(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    101048,       3627]
NotebookOptionsPosition[     84613,       3060]
NotebookOutlinePosition[     87648,       3135]
CellTagsIndexPosition[     87555,       3129]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Textual Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TextualInputAndOutputOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Textual Input and Output\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Automatic" :> Documentation`HelpLookup["paclet:ref/Automatic"],
           "Column" :> Documentation`HelpLookup["paclet:ref/Column"], "Grid" :> 
          Documentation`HelpLookup["paclet:ref/Grid"], "None" :> 
          Documentation`HelpLookup["paclet:ref/None"], "PaddedForm" :> 
          Documentation`HelpLookup["paclet:ref/PaddedForm"], "SpanFromAbove" :> 
          Documentation`HelpLookup["paclet:ref/SpanFromAbove"], 
          "SpanFromBoth" :> 
          Documentation`HelpLookup["paclet:ref/SpanFromBoth"], "SpanFromLeft" :> 
          Documentation`HelpLookup["paclet:ref/SpanFromLeft"], "TableForm" :> 
          Documentation`HelpLookup["paclet:ref/TableForm"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Automatic\"\>", 2->"\<\"Column\"\>",
        3->"\<\"Grid\"\>", 4->"\<\"None\"\>", 5->"\<\"PaddedForm\"\>", 
       6->"\<\"SpanFromAbove\"\>", 7->"\<\"SpanFromBoth\"\>", 
       8->"\<\"SpanFromLeft\"\>", 
       9->"\<\"TableForm\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Tables and Matrices", "Title",
 CellTags->{"S2.9.8", "8.1"},
 CellID->28366],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Column",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Column"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[
    "typeset as a column of elements", "TableText"]},
   {
    RowBox[{
     ButtonBox["Grid",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Grid"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[
    "typeset as a grid of elements", "TableText"]},
   {
    RowBox[{
     ButtonBox["TableForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TableForm"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[
    "print in tabular form", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->2885],

Cell["Formatting lists as tables and matrices. ", "Caption",
 CellID->14439],

Cell["Here is a list. ", "MathCaption",
 CellID->2718],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"i", "+", "45"}], ")"}], "^", "j"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->9107],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"46", ",", "2116", ",", "97336"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"47", ",", "2209", ",", "103823"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"48", ",", "2304", ",", "110592"}], "}"}]}], "}"}]], "Output",
 ImageSize->{401, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->184249940]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " gives the list typeset in a tabular format. "
}], "MathCaption",
 CellID->3554],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", "%", "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->32050],

Cell[BoxData[
 TagBox[GridBox[{
    {"46", "2116", "97336"},
    {"47", "2209", "103823"},
    {"48", "2304", "110592"}
   }],
  "Grid"]], "Output",
 ImageSize->{107, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->509429388]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TableForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TableForm"]], "InlineFormula"],
 " displays the list in a tabular format."
}], "MathCaption",
 CellID->31098],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", "%%", "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->2792],

Cell[BoxData[
 TagBox[GridBox[{
    {"46", "2116", "97336"},
    {"47", "2209", "103823"},
    {"48", "2304", "110592"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{107, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]//TableForm=",
 CellID->797565633]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Column",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Column"]], "InlineFormula"],
 " are wrappers which do not evaluate, but typeset their contents into \
appropriate forms. They are typesetting constructs and require a front end to \
render correctly."
}], "Text",
 CellID->228220372],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Column",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Column"]], "InlineFormula"],
 " is a shorthand for a ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " with one column."
}], "MathCaption",
 CellID->217834760],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{"Range", "[", "5", "]"}], "]"}]], "Input",
 CellLabel->"In[30]:=",
 CellID->505551153],

Cell[BoxData[
 TagBox[GridBox[{
    {"1"},
    {"2"},
    {"3"},
    {"4"},
    {"5"}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}}],
  "Column"]], "Output",
 ImageSize->{11, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[30]=",
 CellID->72072887]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " of a ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Column",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Column"]], "InlineFormula"],
 " demonstrates that the head is inert."
}], "MathCaption",
 CellID->3280929],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[31]:=",
 CellID->103080586],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Column", "[", 
    RowBox[{"List", "[", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "]"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{182, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[31]//FullForm=",
 CellID->159409632]
}, Open  ]],

Cell["\<\
All of these wrappers can be used to present any kind of data, including \
graphical data.\
\>", "MathCaption",
 CellID->203323640],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<disk\>\"", ",", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"Disk", "[", "]"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", "25"}]}], "]"}]}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<square\>\"", ",", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"Rectangle", "[", "]"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", "25"}]}], "]"}]}], "}"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[61]:=",
 CellID->496895237],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"disk\"\>", 
     GraphicsBox[DiskBox[{0, 0}],
      ImageSize->25]},
    {"\<\"square\"\>", 
     GraphicsBox[RectangleBox[{0, 0}],
      ImageSize->25]}
   }],
  "Grid"]], "Output",
 ImageSize->{79, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[61]=",
 CellID->426802518]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["PaddedForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PaddedForm"], "[", 
     RowBox[{
      RowBox[{
       ButtonBox["Column",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Column"], "[", 
       StyleBox["list", "TI"], "]"}], ",", 
      StyleBox["tot", "TI"]}], "]"}], Cell[TextData[{
     "print a column with all numbers padded to have room for ",
     Cell[BoxData[
      StyleBox["tot", "TI"]], "InlineFormula"],
     " digits"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PaddedForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PaddedForm"], "[", 
     RowBox[{
      RowBox[{
       ButtonBox["Grid",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Grid"], "[", 
       StyleBox["list", "TI"], "]"}], ",", 
      StyleBox["tot", "TI"]}], "]"}], Cell[TextData[{
     "print a table with all numbers padded to have room for ",
     Cell[BoxData[
      StyleBox["tot", "TI"]], "InlineFormula"],
     " digits"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PaddedForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PaddedForm"], "[", 
     RowBox[{
      RowBox[{
       ButtonBox["Grid",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Grid"], "[", 
       StyleBox["list", "TI"], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["tot", "TI"], ",", 
        StyleBox["frac", "TI"]}], "}"}]}], "]"}], Cell[TextData[{
     "put ",
     Cell[BoxData[
      StyleBox["frac", "TI"]], "InlineFormula"],
     " digits to the right of the decimal point in all approximate real \
numbers"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->125804708],

Cell["Printing tables of numbers. ", "Caption",
 CellID->19029],

Cell["Here is a list of numbers. ", "MathCaption",
 CellID->25316],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fac", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"10", "!"}], ",", 
    RowBox[{"15", "!"}], ",", 
    RowBox[{"20", "!"}]}], "}"}]}]], "Input",
 CellLabel->"In[32]:=",
 CellID->3059],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3628800", ",", "1307674368000", ",", "2432902008176640000"}], 
  "}"}]], "Output",
 ImageSize->{339, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[32]=",
 CellID->234418035]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Column",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Column"]], "InlineFormula"],
 " displays the list in a column. "
}], "MathCaption",
 CellID->4583],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", "fac", "]"}]], "Input",
 CellLabel->"In[33]:=",
 CellID->22399],

Cell[BoxData[
 TagBox[GridBox[{
    {"3628800"},
    {"1307674368000"},
    {"2432902008176640000"}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}}],
  "Column"]], "Output",
 ImageSize->{150, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[33]=",
 CellID->319767780]
}, Open  ]],

Cell["\<\
This aligns the numbers by padding each one to leave room for up to 20 \
digits. \
\>", "MathCaption",
 CellID->8357],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PaddedForm", "[", 
  RowBox[{
   RowBox[{"Column", "[", "fac", "]"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[36]:=",
 CellID->20070],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      InterpretationBox["\<\"              3628800\"\>",
       3628800,
       Editable->False]},
     {
      InterpretationBox["\<\"        1307674368000\"\>",
       1307674368000,
       Editable->False]},
     {
      InterpretationBox["\<\"  2432902008176640000\"\>",
       2432902008176640000,
       Editable->False]}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}}],
   "Column"],
  PaddedForm[#, 20]& ]], "Output",
 ImageSize->{151, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[36]//PaddedForm=",
 CellID->140385989]
}, Open  ]],

Cell[TextData[{
 "In this particular case, you could also align the numbers using the ",
 Cell[BoxData[
  ButtonBox["Alignment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Alignment"]], "InlineFormula"],
 " option. "
}], "MathCaption",
 CellID->22342],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{"fac", ",", 
   RowBox[{"Alignment", "->", 
    RowBox[{"{", "Right", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[37]:=",
 CellID->17780],

Cell[BoxData[
 TagBox[GridBox[{
    {"3628800"},
    {"1307674368000"},
    {"2432902008176640000"}
   },
   GridBoxAlignment->{"Columns" -> {{Right}}}],
  "Column"]], "Output",
 ImageSize->{150, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[37]=",
 CellID->156521280]
}, Open  ]],

Cell["\<\
This lines up the numbers, padding each one to have room for 8 digits, with 5 \
digits to the right of the decimal point. \
\>", "MathCaption",
 CellID->30406],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PaddedForm", "[", 
  RowBox[{
   RowBox[{"Column", "[", 
    RowBox[{"{", 
     RowBox[{"6.7", ",", "6.888", ",", "6.99999"}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[38]:=",
 CellID->28295],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVcsOgjAQLLRoRIk34cjd/8CTH9EQEzgYDfL/dbdWITxqMTbVKEk7fdDZ
2dIpe14XhyOvy5ynu4qfizK/pNmpgiHqEUIyKNuEQFtAS5ZMCMB+HUNN4QUG
6CukBkjl6g3WAfLfH6LmkGuOffqYlWun9jEdD1ETL3pjnLEYISBTuemw4WBq
VZ/LtzTa0t/KbulAQ9zR4GIfEnE7qaEwO9GSa8Ahps4JJsXRO4c52K9hRYuf
V4I+Rg+N3oJ/d36BO2ednKlRPL1Lu5wuXLEaVUhYo8x85Nl/0G48nI7sZtT6
XuuXOXVRPsldeGcGSqGpu4h3BUcyP6o=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{70, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[38]//PaddedForm=",
 CellID->596132647]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    ButtonBox["SpanFromLeft",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SpanFromLeft"], Cell[
    "span from the element on the left", "TableText"]},
   {
    ButtonBox["SpanFromAbove",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SpanFromAbove"], Cell[
    "span from the element above", "TableText"]},
   {
    ButtonBox["SpanFromBoth",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SpanFromBoth"], Cell[
    "span from the element above and to the left", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->545876737],

Cell[TextData[{
 "Symbols used to represent spanning in ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 "."
}], "Caption",
 CellID->279306913],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " takes a rectangular matrix as its first argument. Individual elements of \
the ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " can span across multiple rows, columns, or a rectangular subgrid by \
specifying the areas to be spanned. The spanning element is always specified \
in the upper left-hand corner of the spanning area, and the remaining area is \
filled in with the appropriate spanning symbols."
}], "Text",
 CellID->741662970],

Cell[TextData[{
 "This shows a spanning row, where the spanning portion is filled in using ",
 Cell[BoxData[
  ButtonBox["SpanFromLeft",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SpanFromLeft"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->85911210],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "\"\<t\>\"", ",", " ", "SpanFromLeft", ",", " ", "SpanFromLeft", ",", 
      " ", "SpanFromLeft"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{
     "\"\<a\>\"", ",", " ", "\"\<b\>\"", ",", " ", "\"\<c\>\"", ",", " ", 
      "\"\<d\>\""}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->121345788],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"t\"\>", "\[SpanFromLeft]", "\[SpanFromLeft]", "\[SpanFromLeft]"},
    {"\<\"a\"\>", "\<\"b\"\>", "\<\"c\"\>", "\<\"d\"\>"}
   }],
  "Grid"]], "Output",
 ImageSize->{56, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->179432470]
}, Open  ]],

Cell[TextData[{
 "Similarly, a column can be spanned using ",
 Cell[BoxData[
  ButtonBox["SpanFromAbove",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SpanFromAbove"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->187755307],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<t\>\"", ",", " ", "\"\<a\>\""}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"SpanFromAbove", ",", " ", "\"\<b\>\""}], "}"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->301605620],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"t\"\>", "\<\"a\"\>"},
    {"\[SpanFromAbove]", "\<\"b\"\>"}
   }],
  "Grid"]], "Output",
 ImageSize->{26, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->280831317]
}, Open  ]],

Cell[TextData[{
 "When specifying a rectangular spanning area, ",
 Cell[BoxData[
  ButtonBox["SpanFromBoth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SpanFromBoth"]], "InlineFormula"],
 " is used in every element which is both below and to the right of the \
spanning element."
}], "MathCaption",
 CellID->868935801],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<t\>\"", ",", " ", "SpanFromLeft", ",", "\"\<a\>\""}], "}"}],
     ",", " ", 
    RowBox[{"{", 
     RowBox[{"SpanFromAbove", ",", " ", "SpanFromBoth", ",", "\"\<b\>\""}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<c\>\"", ",", "\"\<d\>\"", ",", "\"\<e\>\""}], "}"}]}], 
   "}"}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->913084753],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"t\"\>", "\[SpanFromLeft]", "\<\"a\"\>"},
    {"\[SpanFromAbove]", "\[SpanFromBoth]", "\<\"b\"\>"},
    {"\<\"c\"\>", "\<\"d\"\>", "\<\"e\"\>"}
   }],
  "Grid"]], "Output",
 ImageSize->{41, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->478239492]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell["option", "TableHeader"], Cell["default value", "TableHeader"], ""},
   {
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "what background colors to use", "TableText"]},
   {
    ButtonBox["BaselinePosition",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaselinePosition"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "what to align with a surrounding text baseline", "TableText"]},
   {
    ButtonBox["BaseStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaseStyle"], 
    RowBox[{"{", "}"}], Cell[
    "base style specifications for the grid", "TableText"]},
   {
    ButtonBox["Frame",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Frame"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "where to draw frames in the grid", "TableText"]},
   {
    ButtonBox["FrameStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FrameStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "style to use for frames", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->256236415],

Cell[TextData[{
 "Some options which affect the behavior of a ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " as a whole. "
}], "Caption",
 CellID->129906006],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Frame",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Frame"]], "InlineFormula"],
 " option can specify a frame around the entire ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->236709683],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<a\>\"", ",", " ", "\"\<b\>\""}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"\"\<c\>\"", ",", " ", "\"\<d\>\""}], "}"}]}], "}"}], ",", " ", 
   
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->781350725],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"a\"\>", "\<\"b\"\>"},
    {"\<\"c\"\>", "\<\"d\"\>"}
   },
   GridBoxFrame->{"ColumnsIndexed" -> {{{1, -1}, {1, -1}} -> True}}],
  "Grid"]], "Output",
 ImageSize->{36, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->34215740]
}, Open  ]],

Cell[TextData[{
 "This uses ",
 Cell[BoxData[
  ButtonBox["FrameStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrameStyle"]], "InlineFormula"],
 " to change the appearance of a frame."
}], "MathCaption",
 CellID->485154499],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<a\>\"", ",", " ", "\"\<b\>\""}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"\"\<c\>\"", ",", " ", "\"\<d\>\""}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Brown", ",", 
      RowBox[{"AbsoluteThickness", "[", "5", "]"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->7912992],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"a\"\>", "\<\"b\"\>"},
    {"\<\"c\"\>", "\<\"d\"\>"}
   },
   FrameStyle->{
     RGBColor[0.6, 0.4, 0.2], 
     AbsoluteThickness[5]},
   GridBoxFrame->{"ColumnsIndexed" -> {{{1, -1}, {1, -1}} -> True}}],
  "Grid"]], "Output",
 ImageSize->{44, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->420231421]
}, Open  ]],

Cell[TextData[{
 "This uses ",
 Cell[BoxData[
  ButtonBox["Background",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Background"]], "InlineFormula"],
 " to specify a background color for the entire ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->323227392],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<a\>\"", ",", " ", "\"\<b\>\""}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"\"\<c\>\"", ",", " ", "\"\<d\>\""}], "}"}]}], "}"}], ",", 
   RowBox[{"Background", "\[Rule]", "Pink"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[20]:=",
 CellID->5098240],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"a\"\>", "\<\"b\"\>"},
    {"\<\"c\"\>", "\<\"d\"\>"}
   },
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 0.5, 0.5]}}},
   GridBoxFrame->{"ColumnsIndexed" -> {{{1, -1}, {1, -1}} -> True}}],
  "Grid"]], "Output",
 ImageSize->{36, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->98008820]
}, Open  ]],

Cell[TextData[{
 "The position of a ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " relative to its surroundings can be controlled using the ",
 Cell[BoxData[
  ButtonBox["BaselinePosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaselinePosition"]], "InlineFormula"],
 " option."
}], "MathCaption",
 CellID->322180610],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<A matrix:\>\"", ",", " ", 
    RowBox[{"Grid", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", " ", "2"}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"3", ",", " ", "4"}], "}"}]}], "}"}], ",", " ", 
      RowBox[{"BaselinePosition", "\[Rule]", "Top"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->464823507],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"A matrix:\"\>", "\[InvisibleSpace]", 
   TagBox[GridBox[{
      {"1", "2"},
      {"3", "4"}
     },
     BaselinePosition->Top],
    "Grid"]}],
  Row[{"A matrix:", 
    Grid[{{1, 2}, {3, 4}}, BaselinePosition -> Top]}]]], "Output",
 ImageSize->{92, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->867716063]
}, Open  ]],

Cell["This aligns the bottom of the grid with the baseline.", "MathCaption",
 CellID->2395317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<A matrix:\>\"", ",", " ", 
    RowBox[{"Grid", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", " ", "2"}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"3", ",", " ", "4"}], "}"}]}], "}"}], ",", " ", 
      RowBox[{"BaselinePosition", "\[Rule]", "Bottom"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->44239637],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"A matrix:\"\>", "\[InvisibleSpace]", 
   TagBox[GridBox[{
      {"1", "2"},
      {"3", "4"}
     },
     BaselinePosition->Bottom],
    "Grid"]}],
  Row[{"A matrix:", 
    Grid[{{1, 2}, {3, 4}}, BaselinePosition -> Bottom]}]]], "Output",
 ImageSize->{92, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]=",
 CellID->47412694]
}, Open  ]],

Cell[TextData[{
 "This sets the base style of the entire ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " to be the Subsection style."
}], "MathCaption",
 CellID->387061055],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<a\>\"", ",", " ", "\"\<bit\>\""}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"\"\<of\>\"", ",", " ", "\"\<text\>\""}], "}"}]}], "}"}], ",", 
   RowBox[{"BaseStyle", "\[Rule]", 
    RowBox[{"{", "\"\<Subsection\>\"", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->155596842],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"a\"\>", "\<\"bit\"\>"},
    {"\<\"of\"\>", "\<\"text\"\>"}
   },
   BaseStyle->{"Subsection"}],
  "Grid"]], "Output",
 ImageSize->{65, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->580143813]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Column",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Column"]], "InlineFormula"],
 " is a shorthand for specifying a ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " with one column. Since the two functions are similar, the same options can \
be used for each one."
}], "Text",
 CellID->205592237],

Cell[TextData[{
 "This sets some ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " options for ",
 Cell[BoxData[
  ButtonBox["Column",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Column"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->172853630],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"Background", "\[Rule]", "Pink"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->210097611],

Cell[BoxData[
 TagBox[GridBox[{
    {"1"},
    {"2"},
    {"3"},
    {"4"}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 0.5, 0.5]}}},
   GridBoxFrame->{"ColumnsIndexed" -> {{{1, -1}, {1, -1}} -> True}}],
  "Column"]], "Output",
 ImageSize->{21, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]=",
 CellID->2285991]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell["option", "TableHeader"], Cell["default value", "TableHeader"], ""},
   {
    ButtonBox["Alignment",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Alignment"], 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["Center",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Center"], ",", 
      ButtonBox["Baseline",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Baseline"]}], "}"}], Cell[
    "horizontal and vertical alignment of items", "TableText"]},
   {
    ButtonBox["Dividers",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Dividers"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "where to draw divider lines in the grid", "TableText"]},
   {
    ButtonBox["ItemSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ItemSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "width and height of each item", "TableText"]},
   {
    ButtonBox["ItemStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ItemStyle"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "styles for columns and rows", "TableText"]},
   {
    ButtonBox["Spacings",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Spacings"], 
    RowBox[{"{", 
     RowBox[{"0.8", ",", "0.1"}], "}"}], Cell[
    "horizontal and vertical spacings", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->15665],

Cell[TextData[{
 "Some options which affect the columns and rows of a ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 ". "
}], "Caption",
 CellID->584403075],

Cell[TextData[{
 "The options for ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " which affect individual rows and columns all share a similar syntax. The \
options can be specified as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " applies to all of the columns and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " applies to all of the rows; ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " can be single values, or they can be a list of values which represent each \
column or row in turn."
}], "Text",
 CellID->724402532],

Cell[TextData[{
 "With no ",
 Cell[BoxData[
  ButtonBox["Alignment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Alignment"]], "InlineFormula"],
 " setting, elements align to the center horizontally and on the baseline \
vertically."
}], "MathCaption",
 CellID->43065643],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<ten\>\"", ",", " ", 
      RowBox[{"10", "!"}]}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<twenty\>\"", ",", " ", 
      RowBox[{"20", "!"}]}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[31]:=",
 CellID->245582468],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"ten\"\>", "3628800"},
    {"\<\"twenty\"\>", "2432902008176640000"}
   }],
  "Grid"]], "Output",
 ImageSize->{200, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[31]=",
 CellID->248952712]
}, Open  ]],

Cell["\<\
This changes the horizontal alignment of columns to be on the right.\
\>", "MathCaption",
 CellID->171094530],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<ten\>\"", ",", " ", 
       RowBox[{"10", "!"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"\"\<twenty\>\"", ",", " ", 
       RowBox[{"20", "!"}]}], "}"}]}], "}"}], ",", " ", 
   RowBox[{"Alignment", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Right", ",", " ", "Baseline"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[32]:=",
 CellID->96152757],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"ten\"\>", "3628800"},
    {"\<\"twenty\"\>", "2432902008176640000"}
   },
   GridBoxAlignment->{"Columns" -> {{Right}}, "Rows" -> {{Baseline}}}],
  "Grid"]], "Output",
 ImageSize->{200, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[32]=",
 CellID->489598494]
}, Open  ]],

Cell["\<\
This sets the horizontal alignment of each column separately.\
\>", "MathCaption",
 CellID->28400559],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<ten\>\"", ",", " ", 
       RowBox[{"10", "!"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"\"\<twenty\>\"", ",", " ", 
       RowBox[{"20", "!"}]}], "}"}]}], "}"}], ",", " ", 
   RowBox[{"Alignment", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Left", ",", "Right"}], "}"}], ",", " ", "Baseline"}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[33]:=",
 CellID->187582339],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"ten\"\>", "3628800"},
    {"\<\"twenty\"\>", "2432902008176640000"}
   },
   GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Baseline}}}],
  "Grid"]], "Output",
 ImageSize->{200, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[33]=",
 CellID->158436785]
}, Open  ]],

Cell[TextData[{
 "When a ",
 Cell[BoxData[
  ButtonBox["Background",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Background"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["ItemStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ItemStyle"]], "InlineFormula"],
 " options specify distinct settings for rows and columns, the front end will \
attempt to combine the settings where the rows and columns overlap."
}], "Text",
 CellID->488926149],

Cell["\<\
This shows how the green row combines with columns of various colors.\
\>", "MathCaption",
 CellID->270676401],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", " ", "2", ",", " ", "3"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"4", ",", " ", "5", ",", " ", "6"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"7", ",", " ", "8", ",", " ", "9"}], "}"}]}], "}"}], ",", " ", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Orange", ",", "None", ",", "Cyan"}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"None", ",", "Green", ",", "None"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[40]:=",
 CellID->201796843],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2", "3"},
    {"4", "5", "6"},
    {"7", "8", "9"}
   },
   GridBoxBackground->{"Columns" -> {
       RGBColor[1, 0.5, 0], None, 
       RGBColor[0, 1, 1]}, "Rows" -> {None, 
       RGBColor[0, 1, 0], None}}],
  "Grid"]], "Output",
 ImageSize->{41, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[40]=",
 CellID->126220331]
}, Open  ]],

Cell[TextData[{
 "This example shows how ",
 Cell[BoxData[
  ButtonBox["ItemStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ItemStyle"]], "InlineFormula"],
 " can combine styles specified in both rows and columns"
}], "MathCaption",
 CellID->364255547],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", " ", "2"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"3", ",", " ", "4"}], "}"}]}], "}"}], ",", " ", 
   RowBox[{"ItemStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Red", ",", "Automatic"}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"Bold", ",", "Italic"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[88]:=",
 CellID->43947393],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2"},
    {"3", "4"}
   },
   GridBoxItemStyle->{"Columns" -> {
       RGBColor[1, 0, 0], Automatic}, "Rows" -> {Bold, Italic}}],
  "Grid"]], "Output",
 ImageSize->{26, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[88]=",
 CellID->290092680]
}, Open  ]],

Cell["\<\
To repeat an individual row or column specification over multiple rows or \
columns, wrap it in a list. The repeated element will be used as often as \
necessary. If you wrap multiple elements in a list, the entire list will be \
repeated in sequence.\
\>", "Text",
 CellID->65396211],

Cell["The red divider is repeated.", "MathCaption",
 CellID->270154680],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9", ",", "10", ",", "11", ",", "12"}], 
      "}"}]}], "}"}], ",", " ", 
   RowBox[{"Dividers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"None", ",", 
        RowBox[{"{", "Red", "}"}], ",", "None"}], "}"}], ",", "None"}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[60]:=",
 CellID->424020910],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2", "3", "4", "5", "6"},
    {"7", "8", "9", "10", "11", "12"}
   },
   GridBoxDividers->{"Columns" -> {None, {
        RGBColor[1, 0, 0]}, None}, "Rows" -> {{None}}}],
  "Grid"]], "Output",
 ImageSize->{112, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[60]=",
 CellID->169972642]
}, Open  ]],

Cell["Here, red and black dividers are repeated in sequence.", "MathCaption",
 CellID->75156515],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9", ",", "10", ",", "11", ",", "12"}], 
      "}"}]}], "}"}], ",", " ", 
   RowBox[{"Dividers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"None", ",", 
        RowBox[{"{", 
         RowBox[{"Red", ",", "Black"}], "}"}], ",", "None"}], "}"}], ",", 
      "None"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[64]:=",
 CellID->4041861],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2", "3", "4", "5", "6"},
    {"7", "8", "9", "10", "11", "12"}
   },
   GridBoxDividers->{"Columns" -> {None, {
        RGBColor[1, 0, 0], 
        GrayLevel[0]}, None}, "Rows" -> {{None}}}],
  "Grid"]], "Output",
 ImageSize->{112, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[64]=",
 CellID->182042282]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["ItemSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ItemSize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Spacings",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Spacings"]], "InlineFormula"],
 " options take their horizontal measurements in ems and their vertical \
measurements in line heights based upon the current font. Both options also \
can take a ",
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 " coordinate, where the coordinate specifies the fraction of the total cell \
width or window height. The ",
 Cell[BoxData[
  ButtonBox["ItemSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ItemSize"]], "InlineFormula"],
 " option also allows you to request however much space is required to fit \
all of the elements in the given row or column by using the keyword ",
 Cell[BoxData[
  ButtonBox["Full",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Full"]], "InlineFormula"],
 "."
}], "Text",
 CellID->181450172],

Cell["\<\
This makes all of the items 3 ems wide and 1 line height tall\
\>", "MathCaption",
 CellID->86606327],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", " ", "2"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"3", ",", " ", "4"}], "}"}]}], "}"}], ",", " ", 
   RowBox[{"Dividers", "\[Rule]", "All"}], ",", " ", 
   RowBox[{"ItemSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"3", ",", " ", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[70]:=",
 CellID->10184270],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2"},
    {"3", "4"}
   },
   ColumnsEqual->False,
   GridBoxDividers->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxItemSize->{"Columns" -> {{3}}, "Rows" -> {{1}}},
   RowsEqual->False],
  "Grid"]], "Output",
 ImageSize->{99, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[70]=",
 CellID->104444470]
}, Open  ]],

Cell["\<\
The same example in a new font size will show at a different size.\
\>", "MathCaption",
 CellID->98129791],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"Grid", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "2"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"3", ",", " ", "4"}], "}"}]}], "}"}], ",", " ", 
     RowBox[{"Dividers", "\[Rule]", "All"}], ",", " ", 
     RowBox[{"ItemSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"3", ",", " ", "1"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"FontSize", "\[Rule]", "18"}]}], "]"}]], "Input",
 CellLabel->"In[72]:=",
 CellID->30155792],

Cell[BoxData[
 StyleBox[
  StyleBox[
   TagBox[GridBox[{
      {"1", "2"},
      {"3", "4"}
     },
     ColumnsEqual->False,
     GridBoxDividers->{"Columns" -> {{True}}, "Rows" -> {{True}}},
     GridBoxItemSize->{"Columns" -> {{3}}, "Rows" -> {{1}}},
     RowsEqual->False],
    "Grid"],
   StripOnInput->False,
   FontSize->18],
  StripOnInput->False,
  FontSize->18]], "Output",
 ImageSize->{152, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[72]=",
 CellID->9994831]
}, Open  ]],

Cell["\<\
The buttons in this example will always be sized to be a quarter of the width \
of the cell.\
\>", "MathCaption",
 CellID->435792412],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Button", "[", "\"\<Left button\>\"", "]"}], ",", " ", 
      RowBox[{"Button", "[", "\"\<Right button\>\"", "]"}]}], "}"}], "}"}], 
   ",", 
   RowBox[{"ItemSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"Scaled", "[", "0.25", "]"}], "}"}], "}"}], ",", " ", 
      "Full"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[81]:=",
 CellID->284090847],

Cell[BoxData[
 TagBox[GridBox[{
    {
     ButtonBox["\<\"Left button\"\>",
      Appearance->Automatic,
      ButtonData->"paclet:ref/Left button",
      ButtonFrame->"DialogBox",
      ButtonFunction:>{},
      Evaluator->None,
      Method->"Preemptive"], 
     ButtonBox["\<\"Right button\"\>",
      Appearance->Automatic,
      ButtonData->"paclet:ref/Right button",
      ButtonFrame->"DialogBox",
      ButtonFunction:>{},
      Evaluator->None,
      Method->"Preemptive"]}
   },
   ColumnsEqual->False,
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.25]}}, "Rows" -> {{All}}},
   RowsEqual->False],
  "Grid"]], "Output",
 ImageSize->{302, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[81]=",
 CellID->358375395]
}, Open  ]],

Cell[TextData[{
 "The first and last setting for ",
 Cell[BoxData[
  ButtonBox["Spacings",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Spacings"]], "InlineFormula"],
 " specifies one-half of the top and bottom space."
}], "MathCaption",
 CellID->616814426],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", " ", "2"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"3", ",", " ", "4"}], "}"}]}], "}"}], ",", " ", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", " ", 
   RowBox[{"Spacings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", " ", "0", ",", " ", "1"}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"1", ",", " ", "1", ",", " ", "1"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[96]:=",
 CellID->437103811],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2"},
    {"3", "4"}
   },
   GridBoxFrame->{"ColumnsIndexed" -> {{{1, -1}, {1, -1}} -> True}},
   GridBoxSpacings->{"Columns" -> {1, 0, 1}, "Rows" -> {1, 1, 1}}],
  "Grid"]], "Output",
 ImageSize->{32, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[96]=",
 CellID->170044309]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell["option", "TableHeader"], Cell["default value", "TableHeader"], ""},
   {
    ButtonBox["Alignment",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Alignment"], 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["Center",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Center"], ",", 
      ButtonBox["Baseline",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Baseline"]}], "}"}], Cell[
    "horizontal and vertical alignment of items", "TableText"]},
   {
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "what background colors to use", "TableText"]},
   {
    ButtonBox["BaseStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaseStyle"], 
    RowBox[{"{", "}"}], Cell[
    "base style specifications for the item", "TableText"]},
   {
    ButtonBox["Frame",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Frame"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "where to draw frames around the item", "TableText"]},
   {
    ButtonBox["FrameStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FrameStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "style to use for frames", "TableText"]},
   {
    ButtonBox["ItemSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ItemSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "width and height of each item", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->52237618],

Cell[TextData[{
 "Some options for ",
 Cell[BoxData[
  ButtonBox["Item",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Item"]], "InlineFormula"],
 ". "
}], "Caption",
 CellID->68152995],

Cell[TextData[{
 "Many of the settings which can be applied to entire rows and columns can \
also be applied individually to the elements of a ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Column",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Column"]], "InlineFormula"],
 " by using the ",
 Cell[BoxData[
  ButtonBox["Item",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Item"]], "InlineFormula"],
 " wrapper. ",
 Cell[BoxData[
  ButtonBox["Item",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Item"]], "InlineFormula"],
 " allows you to change these settings at the granularity of a single item. \
Settings which are specified at the ",
 Cell[BoxData[
  ButtonBox["Item",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Item"]], "InlineFormula"],
 " level always override settings from the ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Column",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Column"]], "InlineFormula"],
 " as a whole."
}], "Text",
 CellID->20146783],

Cell["\<\
This sets item-specific options for the lower left-hand element.\
\>", "MathCaption",
 CellID->464373915],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Item", "[", 
       RowBox[{"3", ",", " ", 
        RowBox[{"Background", "\[Rule]", "LightGreen"}], ",", " ", 
        RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", "4"}], "}"}]}], 
   "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->381167273],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2"},
    {
     ItemBox["3",
      Background->RGBColor[0.88, 1, 0.88],
      Frame->True,
      StripOnInput->False], "4"}
   }],
  "Grid"]], "Output",
 ImageSize->{32, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->145228375]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Background",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Background"]], "InlineFormula"],
 " setting for ",
 Cell[BoxData[
  ButtonBox["Item",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Item"]], "InlineFormula"],
 " overrides the one for the ",
 Cell[BoxData[
  ButtonBox["Column",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Column"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->768328217],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", 
     RowBox[{"Item", "[", 
      RowBox[{"3", ",", " ", 
       RowBox[{"Background", "\[Rule]", "Pink"}]}], "]"}]}], "}"}], ",", " ", 
   
   RowBox[{"Background", "\[Rule]", "Yellow"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->422042048],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9UjEOwyAMNNCIL3TM3n+0Ux+BokrJUCVK84D8nJ7tgEBqkq0Dd+ZszrbE
Myz96x2WoQvtYw5TP3Sf9j7OkJwhIo9zuxLiiEiOjxGccF0TWqAjZZBTYmSF
zYxIzcGNH9nsUef2HevOvkIeeQ/hKCShuJUqowWYnOGbFIJTdisvVK29FC9V
aSqv4y4udTvZ4Hyb39P9V+VNbB5Qfw6ZL6M5yRM=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{7, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->295557560]
}, Open  ]],

Cell[TextData[{
 "Most of the options to ",
 Cell[BoxData[
  ButtonBox["Item",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Item"]], "InlineFormula"],
 " take the same settings as their ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " counterparts. However, the ",
 Cell[BoxData[
  ButtonBox["Alignment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Alignment"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ItemSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ItemSize"]], "InlineFormula"],
 " options, which allow complex row and column settings in ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 ", take only the ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["horizontal", "TI"], ",", " ", 
    StyleBox["vertical", "TI"]}], "}"}]], "InlineFormula"],
 " setting in ",
 Cell[BoxData[
  ButtonBox["Item",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Item"]], "InlineFormula"],
 "."
}], "Text",
 CellID->50963998],

Cell["\<\
This specifies a larger item area and how the text should be aligned within \
it.\
\>", "MathCaption",
 CellID->469554169],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Item", "[", 
     RowBox[{"\"\<Some aligned text\>\"", ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"ItemSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"15", ",", "3"}], "}"}]}], ",", 
      RowBox[{"Alignment", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Center", ",", "Bottom"}], "}"}]}]}], "]"}], ",", " ", 
    "\"\<caption\>\""}], "}"}], "]"}]], "Input",
 CellLabel->"In[29]:=",
 CellID->676987699],

Cell[BoxData[
 TagBox[GridBox[{
    {
     ItemBox["\<\"Some aligned text\"\>",
      Alignment->{Center, Bottom},
      Frame->True,
      ItemSize->{15, 3},
      StripOnInput->False]},
    {"\<\"caption\"\>"}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}}],
  "Column"]], "Output",
 ImageSize->{203, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[29]=",
 CellID->120183264]
}, Open  ]],

Cell[TextData[{
 "The width value of the ",
 Cell[BoxData[
  ButtonBox["ItemSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ItemSize"]], "InlineFormula"],
 " option is used to determine line-breaking."
}], "MathCaption",
 CellID->55781667],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Item", "[", 
     RowBox[{
      RowBox[{"N", "[", 
       RowBox[{"Pi", ",", "20"}], "]"}], ",", 
      RowBox[{"ItemSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"10", ",", "2"}], "}"}]}]}], "]"}], ",", 
    "\"\<digits of pi\>\""}], "}"}], "]"}]], "Input",
 CellLabel->"In[43]:=",
 CellID->673117326],

Cell[BoxData[
 TagBox[GridBox[{
    {
     ItemBox["3.1415926535897932384626433832795028842`20.",
      ItemSize->{10, 2},
      StripOnInput->False]},
    {"\<\"digits of pi\"\>"}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}}],
  "Column"]], "Output",
 ImageSize->{130, 53},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[43]=",
 CellID->249375876]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["ItemSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ItemSize"]], "InlineFormula"],
 " here specifies a minimum height of 2 line heights, but the item is",
 " ",
 "larger."
}], "MathCaption",
 CellID->71945764],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Item", "[", 
     RowBox[{
      RowBox[{"N", "[", 
       RowBox[{"Pi", ",", "50"}], "]"}], ",", 
      RowBox[{"ItemSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"10", ",", "2"}], "}"}]}]}], "]"}], ",", 
    "\"\<digits of pi\>\""}], "}"}], "]"}]], "Input",
 CellLabel->"In[44]:=",
 CellID->264262523],

Cell[BoxData[
 TagBox[GridBox[{
    {
     ItemBox[
      "3.1415926535897932384626433832795028841971693993751058209849474090732`\
50.",
      ItemSize->{10, 2},
      StripOnInput->False]},
    {"\<\"digits of pi\"\>"}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}}],
  "Column"]], "Output",
 ImageSize->{130, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[44]=",
 CellID->221254619]
}, Open  ]],

Cell[CellGroupData[{

Cell["Formatting Higher-Dimensional Data", "Section",
 CellID->274598773],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Column",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Column"]], "InlineFormula"],
 " supports one-dimensional data, and Grid supports two-dimensional data. To \
print arrays with an arbitrary number of dimensions, you can use ",
 Cell[BoxData[
  ButtonBox["TableForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TableForm"]], "InlineFormula"],
 "."
}], "Text",
 CellID->2403],

Cell[TextData[{
 "Here is the format for a 2\[Times]2 array of elements ",
 Cell[BoxData[
  RowBox[{"a", "[", 
   RowBox[{
    StyleBox["i", "TI"], ",", 
    StyleBox["j", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->8252],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"Array", "[", 
   RowBox[{"a", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[39]:=",
 CellID->15718],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVcsKwjAQjI1VtD5BRPDi1+jJjyhi0YMo6v/XPNoaxo1NSvQgCk27s8lk
d9qM2/R+2J/S+3GXrjbX9HI47m6r9fkqIN5ijGXiWi6YeM7Fk7qyPBf3vhgj
ESYy4hJXPzYu8HlNvl2xmNmSdQr4zHFepFjlGAuQE9m43NvAOxZ8EIhHV6Vp
FKgRnIFxXMV6oeKVXfdgNu6XWFe779F15/DqDLWcBOkFWccQx2TdcmwTbBgj
G/WdhODxVxP7GgVRE1mxbuo8aDUliKs7EA8d1HThwapIrV4chv7q694M+g/N
MnRS91lX6YO8qCAqujb908xz43xq/8zejn+P/qRHU6c9nDvb2D/ly75e1awL
9Kdf9eXvqIn/nX6+3ERNFx7yvNf6sm816DaYb+rF8j7J7V5c5m1ezFoPNj3y
Bg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{102, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[39]//TableForm=",
 CellID->168644140]
}, Open  ]],

Cell["Here is a 2\[Times]2\[Times]2 array. ", "MathCaption",
 CellID->7285],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Array", "[", 
     RowBox[{"a", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "2"}], "}"}]}], "]"}], ",", 
    RowBox[{"Array", "[", 
     RowBox[{"b", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "2"}], "}"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[40]:=",
 CellID->28428],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVltOwzAQdOOkhTYlIKGKz16DC8AXh4gqqvYDgUrvb7x54S52d+1YUKJY
ih2vV+Pxpp7OS3ncvb6Vx/2mXD8fyo/dfvO5fno/6JCcCCG2+nl8EPpd6bfq
2Sqlx7nuEz1dwExCvGqiaOIrYj3tUMzVFvUOxe+ZeUmFmulAZlnJ2n2N+NQR
nzfxvjg1IyHroYvgDGOOEdLmrDOYZF28BvyRvWBlJc4s/k79T3aD5rjWvLNI
NC8I1P688Q5h38AX9ZQ3NF/et0TlgHfCwMUVxcwxrqXilpuF2VrvNq5y2gBW
DSNOCZ7Wc57wnBEcl4p9J8/wst9GHnbNGep5pb6VFUb42tKY581o5sF6gfJq
Zd6e7Uf15+HEU/9rIi+G7lN7XIpyYn3BunapvH9f8Tm8QxQf/3MzKm65TUFV
9lL8pTdPSvFZHL21nvdLcKl8W1tK5c28/67yrRLbvIaPQueRcEaf7z7ZX/p8
6NMIWpxHwulfTY6Lp6sZ5uGhlwwlp7x77sAJc+xYYcJcOtaf/q68VTCXI1+p
YTvx4Wr06MbdSsFz48PT5TjVDHPaXF3mVJOjyzxfTekyxYanyLwva9Ni0w/b
tNjll8XkC8WDLks=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{102, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[40]//TableForm=",
 CellID->180080913]
}, Open  ]],

Cell["And here is a 2\[Times]2\[Times]2\[Times]2 array. ", "MathCaption",
 CellID->25960],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Array", "[", 
       RowBox[{"a", ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "2"}], "}"}]}], "]"}], ",", 
      RowBox[{"Array", "[", 
       RowBox[{"b", ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "2"}], "}"}]}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Array", "[", 
       RowBox[{"c", ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "2"}], "}"}]}], "]"}], ",", 
      RowBox[{"Array", "[", 
       RowBox[{"d", ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "2"}], "}"}]}], "]"}]}], "}"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[41]:=",
 CellID->101],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmVtuwjAQRQNOSsujUKmq+sk2uoH2q4uIUCX4qFpRlsp+UjsPkk4dz3hw
EgeCRMBjc3P9SHwyvMeH7cdnfNht4vXbPv7e7jY/69evvQyJURAER/l+eQ7k
90R+S9/HJJGfU3kcy+JMlYSKp69gmcefGq4PTy6qtYWrBxB/7KjdOHWpjioY
aWqjoi+V+E1NfO5QR8WFJzrZKGUyaTCLwBawHJ3K2Q9TXTULd6A1PN+s9tf0
c0xIGi7O5E9v/s/TBLSAK2FF8Q5WiElvCcrwSqCNBcultSrmFR9NeAaoaDua
LD20336o2t9D4HzcO/ENVaFvuErgnI0JmiSnlpqYz3InC2vu7NXyAnE4J+pA
V3AOlY7qXXXeoXOON1tNzGc2epBW9PdkbKVD9tCrLLRR7Kqi7bOYQ54qzXE5
ksWqFrkjVY6Sv/RYrRdBud+tKvUmHVM7AeISlo3HgZgHYu6OmHX7qzu6rFN3
Sck+96B7loNMwCPjdlgO89r9aF43GbfjGz51ccj43HVA0cR8msnY1mEdGcOy
dt+0pFiON1tNzKeejG2dQbqA9W5o2NaVrR6XgKukqiPgol5o2oeIjqndQMBN
tCvvJz4R5zSPn0vSrnSGnHE/emM/T35kZ/uXSW6bQK6bkf3JHqtrsQm3HF16
Fllo9gBOppaig3FYOjdhPvHp61xn9op9zSBjT9Y8hzzVNjPIxbPQLaJjajfw
cxPtBn5uhp99zr9eYgbZjyzd5eWVB07mq/q6Sim5ZArPctxydOk5ZR3fclYq
RQfL1eJUy5ptK8U+5ZMb+dfJQq/NfLKOc3U6pnZ1PByMfgF1zKB4\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{212, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[41]//TableForm=",
 CellID->205496186]
}, Open  ]],

Cell[TextData[{
 "In general, when you print an ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 "\[Hyphen]dimensional table, successive dimensions are alternately given as \
columns and rows. By setting the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TableDirections",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TableDirections"], "->", "{"}]], 
  "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["dir", "TI"], "1"], TraditionalForm]], "InlineMath"],
 Cell[BoxData[","], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["dir", "TI"], "2"], TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  RowBox[{
   RowBox[{",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 ", where the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["dir", "TI"], "i"], TraditionalForm]], "InlineMath"],
 " are ",
 Cell[BoxData[
  ButtonBox["Column",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Column"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Row",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Row"]], "InlineFormula"],
 ", you can specify explicitly which way each dimension should be given. By \
default, the option is effectively set to ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    ButtonBox["Column",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Column"], ",", 
    ButtonBox["Row",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Row"], ",", 
    ButtonBox["Column",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Column"], ",", 
    ButtonBox["Row",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Row"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->2364],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["TableDirections",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TableDirections"]], "InlineFormula"],
 " allows you to specify explicitly how each dimension in a multidimensional \
table should be given. "
}], "MathCaption",
 CellID->26385],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Array", "[", 
      RowBox[{"a", ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}]}], "]"}], ",", 
     RowBox[{"Array", "[", 
      RowBox[{"b", ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"TableDirections", "->", 
    RowBox[{"{", 
     RowBox[{"Row", ",", "Row", ",", "Column"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[42]:=",
 CellID->27626],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztV1tOwzAQdPMo0AcBCVVI/PQ08MUhogqp/UCg0qPmPsGvNNbgxGvHVYOU
SImz69Vk1rtxJu/laf/xWZ4Ou3L7diy/94fdz/b168hd6YwxVvHz5Znx+5rf
ybOqaz4u+DXh5lJYqfDLgxXav7nwfHZmYc42rB7B/3SluESyFNecO1PLbN7k
YvjnHf5VJJyF9ucjwVGrpNKSTuXBCMNGhEyv/40w8rNfAf6JXpKiks6o2E/6
L9kMr9M92Ng5tFyw/4soqOPg2u4YGYEjotl2jBg4YSt4HdThXfoANtaQxhsr
i7xtqOJdvARbCq4v37ZTU8s3AFlav4zQqTacuYMV4sjaZLrw8hjKzI3oy1Gt
HGoX5LWuKV2GSsS+z9OwUGthXmEMXahDGLcr2WhCMYo3IjXsjTEv/AXMr/R4
68CxxdnwlDateq+Tfp708/j0850jLobWjPOMMWcwvB5xlBP2OSqFMak8X66T
Tr6+To7DG3c//O+yoYboZArbEJ3s4uunkymdStHJa0ptvHQyqdpeOtnFkaaT
XbxoCpmUXU8uQavVgxfGslsPJ7oeXXrYnO/Tw644G56ph9nsF8Gp1Iw=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{212, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[42]//TableForm=",
 CellID->339596263]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TableForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TableForm"]], "InlineFormula"],
 " can handle arbitrary \[OpenCurlyDoubleQuote]ragged\[CloseCurlyDoubleQuote] \
arrays. It leaves blanks wherever there are no elements supplied. "
}], "Text",
 CellID->31033],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TableForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TableForm"]], "InlineFormula"],
 " can handle \[OpenCurlyDoubleQuote]ragged\[CloseCurlyDoubleQuote] arrays. "
}], "MathCaption",
 CellID->4493],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "a", ",", "a"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"b", ",", "b"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[43]:=",
 CellID->29768],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwuAOxtAQDkP0fyAJj
9///gTQyyQpSBGSBaCWwCAMzhAKRTCCCGcIBMSVBBCucD1HIoDig+kAAmz4m
LOLymDYCaRkQgwUqAAaYISGHZpIyWAqkWw5qlypG2OInmaChLo1GkxMi0lhF
GckMX3ymgUxggYYZMk0ru0AGyKLRTDhClIERAEsUe90=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{71, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[43]//TableForm=",
 CellID->271301759]
}, Open  ]],

Cell["\<\
You can include objects that behave as \[OpenCurlyDoubleQuote]subtables\
\[CloseCurlyDoubleQuote]. \
\>", "MathCaption",
 CellID->29935],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"p", ",", "q"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"r", ",", "s"}], "}"}]}], "}"}], ",", "a", ",", "a"}], "}"}],
     ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", "b", ",", "b"}], "}"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[44]:=",
 CellID->19109],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9U19LwzAQvyYryFZwj2onthNBpj74CXQ+qAh+iDKE7UG31dGvH3PJLU3T
28p8WCH36/1y/3KXfBab+dd3sVnMiuytLFbzxew3e12WmpIRAFR6PZ6B/lf6
z6xKKURpAT+h19qohpRoZT5YdbC1p/BsoMn2ak8g3212lCKI/mOjY5BeXSPA
0iiZlrHWJoRjw+YoYxeD3CYsmx/VAzsUnvB2B39le0Y7iKnXP9uFuxZjOwCx
6yjtjILo94F+7SYkyBrxgfCmsVvuyLFuVWznW/1L5jTTvkY84othx0HdA7bj
U9b2NNCfWKtEC9nIhydJ9uTZTtZ/RQOqeuo6h84fhCnh/rv/zuZMWTZSXS/p
8GiCznBBHRkSpsSPCLtznwf6kNs/uDbp1ZB4NSF/SSjchNqR+h0zPYYH9/JP
Al04j0y1b1rCcM+Kf1MQ/QHNjvrZ\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{118, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[44]//TableForm=",
 CellID->283272455]
}, Open  ]],

Cell[TextData[{
 "You can control the number of levels in a nested list to which ",
 Cell[BoxData[
  ButtonBox["TableForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TableForm"]], "InlineFormula"],
 " goes by setting the option ",
 Cell[BoxData[
  ButtonBox["TableDepth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TableDepth"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->20381],

Cell[TextData[{
 "This tells ",
 Cell[BoxData[
  ButtonBox["TableForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TableForm"]], "InlineFormula"],
 " only to go down to depth 2. As a result ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}]], "InlineFormula"],
 " is treated as a single table entry. "
}], "MathCaption",
 CellID->21561],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", 
   RowBox[{"TableDepth", "->", "2"}]}], "]"}]], "Input",
 CellLabel->"In[45]:=",
 CellID->25739],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1UtsKwjAMzdrV6yaiPghDmP7E/kCf/IgxBH0QRff/M1nj6LI6EHTQXM5O
0jTJMS/Pp2teXoo8PTzy+/lSPNP97YGQDgAgw5OsAe0KrfpkVYXalQqlxl8R
aoN6W6OgrSJJDNDWIXNEwjS+JcKuExf/mOetw/FVE0XMEL0pakLdLPZ9KxGb
1uiS+btOl7pyKTKMhT/kGkKB21IWAp3wzROBy2jVvM/w+yB0O0c5FGsZK/vl
z93XcVmdat+PhuG7x6zN13fIPoacae7gNNKB4AWtyUeerjdZWhX/owuzyrfR
n2dJYNw7y4hZNsn7096Mcrc2Xpbc38TTsfeuQ/ACRzE2bw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{55, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[45]//TableForm=",
 CellID->385993893]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    ""},
   {
    ButtonBox["TableDepth",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TableDepth"], 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], Cell[
    "maximum number of levels to include in the table", "TableText"]},
   {
    ButtonBox["TableDirections",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TableDirections"], 
    RowBox[{"{", 
     ButtonBox["Column",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Column"], ",", 
     ButtonBox["Row",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Row"], ",", 
     ButtonBox["Column",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Column"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}"}], Cell[
    "whether to arrange dimensions as rows or columns", "TableText"]},
   {
    ButtonBox["TableAlignments",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TableAlignments"], 
    RowBox[{"{", 
     ButtonBox["Left",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Left"], ",", 
     ButtonBox["Bottom",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Bottom"], ",", 
     ButtonBox["Left",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Left"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}"}], Cell[
    "how to align the entries in each dimension", "TableText"]},
   {
    ButtonBox["TableSpacing",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TableSpacing"], 
    RowBox[{"{", "1", ",", "3", ",", "0", ",", "1", ",", "0", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}"}], Cell[
    "how many spaces to put between entries in each dimension", 
     "TableText"]},
   {
    ButtonBox["TableHeadings",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TableHeadings"], 
    RowBox[{"{", 
     ButtonBox["None",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/None"], ",", 
     ButtonBox["None",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/None"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}"}], Cell[
    "how to label the entries in each dimension", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->25923],

Cell[TextData[{
 "Options for ",
 StyleBox["TableForm", "MR"],
 ". "
}], "Caption",
 CellID->28499],

Cell[TextData[{
 "With the option ",
 Cell[BoxData[
  ButtonBox["TableAlignments",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TableAlignments"]], "InlineFormula"],
 ", you can specify how each entry in the table should be aligned with its \
row or column. For columns, you can specify ",
 Cell[BoxData[
  ButtonBox["Left",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Left"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Center",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Center"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Right",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Right"]], "InlineFormula"],
 ". For rows, you can specify ",
 Cell[BoxData[
  ButtonBox["Bottom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Bottom"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Center",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Center"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Top",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Top"]], "InlineFormula"],
 ". If you set ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TableAlignments",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TableAlignments"], "->", 
   ButtonBox["Center",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Center"]}]], "InlineFormula"],
 ", all entries will be centered both horizontally and vertically. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TableAlignments",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TableAlignments"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " uses the default choice of alignments. "
}], "Text",
 CellID->16731],

Cell["Entries in columns are by default aligned on the left. ", "MathCaption",
 CellID->11849],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "bbbb", ",", "cccccccc"}], "}"}], "]"}]], "Input",
 CellLabel->"In[46]:=",
 CellID->25442],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwWACxtgQDkP0fyAJj
i///gTQmyQQkmYEKWMikmcCmMDBDKBAJFmGBcJAk6SgCCgJGDHexgghmhFoW
GvOZB6ELBlPcgNzCAhUlh4aYgitd4ydZoSkXGy1HzVBDig3pIW0uAyyvI6lg
okAMi6vRXAWxkxgRzBgjNafJg7WCXADSiY1WREo9xJCw1GSIPXaQ7DYgUgUs
vxiRoB4kaIzDhQyMAIbyBV4=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{56, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[46]//TableForm=",
 CellID->10185372]
}, Open  ]],

Cell["This centers all entries. ", "MathCaption",
 CellID->6850],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "bbbb", ",", "cccccccc"}], "}"}], ",", 
   RowBox[{"TableAlignments", "->", "Center"}]}], "]"}]], "Input",
 CellLabel->"In[47]:=",
 CellID->28287],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwWACxtgQDkP0fyAJj
i///gTQmyQQkmYEKWMikmcCmMDBDKBAJFmGBcJAk6SgCCgJGDHexgghmhFoW
GvOZB6ELBlPcgNzCAhUlh4aYgitd4ydZoSkXGy1HzVBDig3pIW0uAyyvI6lg
okAMi6vRXAWxkxgRzBgjNafJg7WCXADSiY1WREo9xJCw1GSIPXaQ7DYgUgUs
vxiRoB4kaIzDhQyMAIbyBV4=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{56, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[47]//TableForm=",
 CellID->150417541]
}, Open  ]],

Cell[TextData[{
 "You can use the option ",
 Cell[BoxData[
  ButtonBox["TableSpacing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TableSpacing"]], "InlineFormula"],
 " to specify how much horizontal space there should be between successive \
columns, or how much vertical space there should be between successive rows. \
A setting of 0 specifies that successive objects should abut. "
}], "Text",
 CellID->22769],

Cell["\<\
This leaves 6 spaces between the entries in each row, and no space between \
successive rows. \
\>", "MathCaption",
 CellID->9223],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ccc", ",", "d"}], "}"}]}], "}"}], ",", 
   RowBox[{"TableSpacing", "->", 
    RowBox[{"{", 
     RowBox[{"0", ",", "6"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[48]:=",
 CellID->1588],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9UssOgjAQ3L6+QY98g4mciSZiovIPDTGBg9EA/1+3bMGlcPCRSNKdzmZ2
6BQutquuN9vVpU3yxj6qumyTw73BlhIAUOBarQH3Dnf9KpxDnFeJVaFAR5gi
Gugf1QvBV68GTYS6armjXp2NL2bkJALBxORtojkd8fTPPl9nZVyOzt5NhwmO
W8RBJUb1ecJOTDP/ej5KFlAup2Anyj5J/+bckG33g7cMpxcTVy/as1unH5JS
HiMXekEevAy7JRBP4sGKVg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{78, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[48]//TableForm=",
 CellID->387437944]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "no labels in any dimension", "TableText"]},
   {
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "successive integer labels in each dimension", "TableText"]},
   {
    RowBox[{"{", "{", 
     SubscriptBox[
      StyleBox["lab", "TI"], 
      StyleBox["11", "TR"]], ",", 
     SubscriptBox[
      StyleBox["lab", "TI"], 
      StyleBox["12", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}"}], Cell[
    "explicit labels", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->12083],

Cell[TextData[{
 "Settings for the option ",
 Cell[BoxData[
  ButtonBox["TableHeadings",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TableHeadings"]], "InlineFormula"],
 ". "
}], "Caption",
 CellID->3400],

Cell["\<\
This puts integer labels in a 2\[Times]2\[Times]2 array. \
\>", "MathCaption",
 CellID->11158],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Array", "[", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2"}], "}"}]}], "]"}], ",", 
   RowBox[{"TableHeadings", "->", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[49]:=",
 CellID->15606],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWk1PwkAQLbSAiiAejB75LR5UNJ7w40yICRyMBvlT/gP+Xe1CS+pj2plu
d7dNKAmUme7sPGan28dLn2frxcfnbL2cz8b3q9n3Yjn/Gd99rSKX3/I8bxO9
Jzde9D2Mvm3fmzCMjufq01f29nVg96OPdmT2wX9B2Grcdcn4QIwqbZ/F0aP4
eAnnr0rGt0lUytuJzA74/djvZ4wPwN8t6O9XlDe7Cl5nb2/HHGKjR5EZyFFq
VU5hdOLviebuO8OZjUeOlq41rmxXCz3OMgJ7CDbWCFGZQUHtCHko6AphFuoa
CQg0aHNocPygorx0FTC7vH/zZsG+wL7BFcXxZlBwFaJ2v8MKYc9ilLJ9Yn/A
OFx38s5RAK00L1cFzFtm78a7JR2FCAbkKL1dWYaAzijDkb3fKhOrn7CaID6f
sJdRbCd7/bBAfPoYhGk2tGuS3YuaDVG/gn37b5b9r825MmUz4iw9rVm4e5ps
Fm7XkM3C7Zv1YMdlVrIa5qw+lRM7pGHQ1Jq55M6Uvwivsc+XOYQ2a8ox5bKs
0AxTRlRmKnQcTNlMn3BM2U2fcExZxMe1+sQn9lKOKZvoE0lekpcar4IeRy5b
gzK8WO96UVXf79kEk6EYcTtepYQRS+PT83TCNANCVL9OvfVggY1GmuevF8Mz
qZFSdr3U0SyEdddFOYbhRhdFm+MSjS5Kjbepi3LY3OiiaHP/TezqolxNbOmi
mBfzuNRFuRrYVETJ6865FprmBzpaaDrOphZqRnNsZqmG+eqgLMJkzWme6uwJ
cbZhxGZ0l6Jc2I3aqcd/q9Q5bbM8M8y30TkleY+vT7jnV+zqnC76RJIX70Ju
dE7bv16P59rTNpHhFtU2keGW0zbVY51Vq6EJT5jGx0dyFK7AlFw3WewL2E+i
KGS8slxvYE9EUe9gPxivSdKrCp9y72qwe6bXa/0BsqyorQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{184, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[49]//TableForm=",
 CellID->288011488]
}, Open  ]],

Cell["\<\
This gives a table in which the rows are labeled by integers, and the columns \
by a list of strings. \
\>", "MathCaption",
 CellID->19463],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ap", ",", "bp", ",", "cp"}], "}"}]}], "}"}], ",", 
   RowBox[{"TableHeadings", "->", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", 
      RowBox[{"{", 
       RowBox[{"\"\<first\>\"", ",", "\"\<middle\>\"", ",", "\"\<last\>\""}], 
       "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[50]:=",
 CellID->20920],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNV19PwjAQ79aVPyoiahQfCDwQJUHCt9DE6IdYiAk8GA3y5DfgU9dd15Ny
XEPHFFmy3e56vV5/92fdS7qYvr6li9kk7T3O04/pbPLZe3ifZyIZCSGW2T1s
i+xdZ2/mXmqd0RN4SuDNJWrZA9iBpWNLz1ntOuEHhB8TvmWsCJkTuGCwQrRg
WIl1vTi7u1YO4sTxEfmzNevwjInlhPBmXP3wdjle2i2ge1tAt2ko9bS6T08p
Qh4fJdHl4pbs3SsaUxWMXCw2ce945JysX8hyw4xT76j3gKF0rLg10DMTbGoL
4dEa2Cjkps1ltYrXx4jwTxpzFYQ0R+/tOs+a6xVfByMN7T99S7EHXuuQKijS
EUas9Opv1nHmtoNWwHr+TZt+r7maGZbAByvpTtOqGdt9hdnx1wB4XCOju9fA
0vj2v/UBu1I2DpQCYspiCt/9Kuk7+CV253HjYOdIr77k3Jce14lYL2nEaE+l
44bfyCJeWnekq5wpc25g5zr8aQnbZg+JK43YLCqKWJVdrXGg2FT8tksjAVYk
4+nxXrBQnlgmNvacZ/HO+47RGp9nu+1+yxkqDkaN61WF6mQrRm63Q2Tp6co9
4yrbL6Sjg3ZApsh8HKMyrl9JrDdGnhAfwrrkDeE7hN8WvQvCt4Iw9dUP/VNE
rJBiPl5amp8u8n9WEX0Dq2KSAw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{137, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[50]//TableForm=",
 CellID->209459251]
}, Open  ]],

Cell[TextData[{
 "This labels the rows but not the columns. ",
 Cell[BoxData[
  ButtonBox["TableForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TableForm"]], "InlineFormula"],
 " automatically drops the third label since there is no corresponding row. "
}], "MathCaption",
 CellID->15758],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "6", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"TableHeadings", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<row a\>\"", ",", "\"\<row b\>\"", ",", "\"\<row c\>\""}], 
       "}"}], ",", "None"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[51]:=",
 CellID->19685],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdVcFuwjAMDWkKK2XligSTOE37ku20Qz+hQpPggEDA/3d26qzZw5QNpGpa
pOL6Ybu26+e+V6f1x7Y6bVbV8u1Q7deb1XH5ujsQlAyMMSVd85mh+5ru/FXW
NckX/k1Y98c8d6AmaQSfRFSWLrLm/zKSKckRRAn2E5G52A28n1WsTfqlS2wb
od+feG47hIhWtRqr6AR8+8oR9Yd/lZ0N09KZVYtm4oOVufq80jBRjuSjmkHj
5o/EDX5WZGRBx1fn2h7pEx3rOeiFmseT1sWOqNhPvbqF1DRWojlgXaj9d/zv
F/3ptglbJIUoVvBc/Irwjv/YpuG8eEX3xWGcrinoPI3Du/vEtTrl6chcZIi+
Ue7bINd7grMTOOKZ51rc3LhJMkFxf2AeyPSYy20fkC+3ftcuR8QvdSFVNtal
tOITtGsvbQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{81, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[51]//TableForm=",
 CellID->2108622]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->311867240],

Cell[TextData[ButtonBox["Textual Input and Output",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TextualInputAndOutputOverview"]], "RelatedTutorials",
 CellID->364580606]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Tables and Matrices - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Textual Input and Output", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/TextualInputAndOutputOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/OutputFormatsForNumbers"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/StylesAndFontsInOutput"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 22.6549308}", "context" -> "", 
    "keywords" -> {
     "alignment", "arrays", "captions", "center alignment", "centering", 
      "column", "column-major output order", "columns", "decimal points", 
      "format", "headings", "horizontal alignment", "labels", 
      "left alignment", "lists", "matrices", "MatrixForm", "names", "output", 
      "PaddedForm", "ragged arrays", "right alignment", "row", 
      "row-major output order", "spaces", "spreadsheets", "subtables", 
      "table subregion", "TableAlignments", "TableDepth", "TableDirections", 
      "TableForm", "TableHeadings", "tables", "TableSpacing", "tabulation", 
      "tensors", "text", "titles", "vertical alignment"}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Formatting lists as tables and matrices. Here is a list. Grid gives the \
list typeset in a tabular format. ", "synonyms" -> {"2.9.8"}, "title" -> 
    "Tables and Matrices", "type" -> "Tutorial", "uri" -> 
    "tutorial/TablesAndMatrices"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.9.8"->{
  Cell[2647, 70, 82, 2, 70, "Title",
   CellTags->{"S2.9.8", "8.1"},
   CellID->28366]},
 "8.1"->{
  Cell[2647, 70, 82, 2, 70, "Title",
   CellTags->{"S2.9.8", "8.1"},
   CellID->28366]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.9.8", 87344, 3118},
 {"8.1", 87443, 3122}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2022, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2647, 70, 82, 2, 70, "Title",
 CellTags->{"S2.9.8", "8.1"},
 CellID->28366],
Cell[2732, 74, 954, 30, 70, "DefinitionBox",
 CellID->2885],
Cell[3689, 106, 76, 1, 70, "Caption",
 CellID->14439],
Cell[3768, 109, 54, 1, 70, "MathCaption",
 CellID->2718],
Cell[CellGroupData[{
Cell[3847, 114, 304, 11, 28, "Input",
 CellID->9107],
Cell[4154, 127, 418, 13, 36, "Output",
 CellID->184249940]
}, Open  ]],
Cell[4587, 143, 209, 7, 70, "MathCaption",
 CellID->3554],
Cell[CellGroupData[{
Cell[4821, 154, 97, 3, 28, "Input",
 CellID->32050],
Cell[4921, 159, 280, 11, 64, "Output",
 CellID->509429388]
}, Open  ]],
Cell[5216, 173, 214, 7, 70, "MathCaption",
 CellID->31098],
Cell[CellGroupData[{
Cell[5455, 184, 102, 3, 28, "Input",
 CellID->2792],
Cell[5560, 189, 719, 22, 78, "Output",
 CellID->797565633]
}, Open  ]],
Cell[6294, 214, 455, 14, 70, "Text",
 CellID->228220372],
Cell[6752, 230, 328, 12, 70, "MathCaption",
 CellID->217834760],
Cell[CellGroupData[{
Cell[7105, 246, 135, 4, 70, "Input",
 CellID->505551153],
Cell[7243, 252, 292, 14, 94, "Output",
 CellID->72072887]
}, Open  ]],
Cell[7550, 269, 467, 18, 70, "MathCaption",
 CellID->3280929],
Cell[CellGroupData[{
Cell[8042, 291, 105, 3, 70, "Input",
 CellID->103080586],
Cell[8150, 296, 414, 14, 50, "Output",
 CellID->159409632]
}, Open  ]],
Cell[8579, 313, 141, 4, 70, "MathCaption",
 CellID->203323640],
Cell[CellGroupData[{
Cell[8745, 321, 573, 18, 70, "Input",
 CellID->496895237],
Cell[9321, 341, 355, 14, 78, "Output",
 CellID->426802518]
}, Open  ]],
Cell[9691, 358, 1995, 64, 70, "DefinitionBox",
 CellID->125804708],
Cell[11689, 424, 63, 1, 70, "Caption",
 CellID->19029],
Cell[11755, 427, 66, 1, 70, "MathCaption",
 CellID->25316],
Cell[CellGroupData[{
Cell[11846, 432, 210, 8, 70, "Input",
 CellID->3059],
Cell[12059, 442, 254, 8, 36, "Output",
 CellID->234418035]
}, Open  ]],
Cell[12328, 453, 200, 7, 70, "MathCaption",
 CellID->4583],
Cell[CellGroupData[{
Cell[12553, 464, 101, 3, 70, "Input",
 CellID->22399],
Cell[12657, 469, 308, 12, 64, "Output",
 CellID->319767780]
}, Open  ]],
Cell[12980, 484, 127, 4, 70, "MathCaption",
 CellID->8357],
Cell[CellGroupData[{
Cell[13132, 492, 163, 5, 70, "Input",
 CellID->20070],
Cell[13298, 499, 624, 23, 78, "Output",
 CellID->140385989]
}, Open  ]],
Cell[13937, 525, 257, 8, 70, "MathCaption",
 CellID->22342],
Cell[CellGroupData[{
Cell[14219, 537, 186, 6, 70, "Input",
 CellID->17780],
Cell[14408, 545, 309, 12, 64, "Output",
 CellID->156521280]
}, Open  ]],
Cell[14732, 560, 169, 4, 70, "MathCaption",
 CellID->30406],
Cell[CellGroupData[{
Cell[14926, 568, 282, 9, 28, "Input",
 CellID->28295],
Cell[15211, 579, 561, 13, 78, "Output",
 Evaluatable->False,
 CellID->596132647]
}, Open  ]],
Cell[15787, 595, 843, 24, 70, "DefinitionBox",
 CellID->545876737],
Cell[16633, 621, 209, 8, 70, "Caption",
 CellID->279306913],
Cell[16845, 631, 636, 16, 70, "Text",
 CellID->741662970],
Cell[17484, 649, 263, 8, 70, "MathCaption",
 CellID->85911210],
Cell[CellGroupData[{
Cell[17772, 661, 423, 13, 70, "Input",
 CellID->121345788],
Cell[18198, 676, 323, 10, 46, "Output",
 CellID->179432470]
}, Open  ]],
Cell[18536, 689, 234, 8, 70, "MathCaption",
 CellID->187755307],
Cell[CellGroupData[{
Cell[18795, 701, 303, 10, 70, "Input",
 CellID->301605620],
Cell[19101, 713, 260, 10, 48, "Output",
 CellID->280831317]
}, Open  ]],
Cell[19376, 726, 324, 9, 70, "MathCaption",
 CellID->868935801],
Cell[CellGroupData[{
Cell[19725, 739, 452, 14, 70, "Input",
 CellID->913084753],
Cell[20180, 755, 343, 11, 64, "Output",
 CellID->478239492]
}, Open  ]],
Cell[20538, 769, 1660, 49, 70, "DefinitionBox3Col",
 CellID->256236415],
Cell[22201, 820, 227, 8, 70, "Caption",
 CellID->129906006],
Cell[22431, 830, 343, 13, 70, "MathCaption",
 CellID->236709683],
Cell[CellGroupData[{
Cell[22799, 847, 372, 12, 70, "Input",
 CellID->781350725],
Cell[23174, 861, 322, 11, 54, "Output",
 CellID->34215740]
}, Open  ]],
Cell[23511, 875, 233, 8, 70, "MathCaption",
 CellID->485154499],
Cell[CellGroupData[{
Cell[23769, 887, 516, 16, 70, "Input",
 CellID->7912992],
Cell[24288, 905, 399, 14, 62, "Output",
 CellID->420231421]
}, Open  ]],
Cell[24702, 922, 359, 13, 70, "MathCaption",
 CellID->323227392],
Cell[CellGroupData[{
Cell[25086, 939, 413, 12, 70, "Input",
 CellID->5098240],
Cell[25502, 953, 395, 13, 54, "Output",
 CellID->98008820]
}, Open  ]],
Cell[25912, 969, 398, 13, 70, "MathCaption",
 CellID->322180610],
Cell[CellGroupData[{
Cell[26335, 986, 473, 15, 70, "Input",
 CellID->464823507],
Cell[26811, 1003, 412, 15, 59, "Output",
 CellID->867716063]
}, Open  ]],
Cell[27238, 1021, 94, 1, 70, "MathCaption",
 CellID->2395317],
Cell[CellGroupData[{
Cell[27357, 1026, 475, 15, 70, "Input",
 CellID->44239637],
Cell[27835, 1043, 417, 15, 50, "Output",
 CellID->47412694]
}, Open  ]],
Cell[28267, 1061, 241, 8, 70, "MathCaption",
 CellID->387061055],
Cell[CellGroupData[{
Cell[28533, 1073, 411, 12, 70, "Input",
 CellID->155596842],
Cell[28947, 1087, 289, 11, 62, "Output",
 CellID->580143813]
}, Open  ]],
Cell[29251, 1101, 414, 13, 70, "Text",
 CellID->205592237],
Cell[29668, 1116, 323, 13, 70, "MathCaption",
 CellID->172853630],
Cell[CellGroupData[{
Cell[30016, 1133, 284, 8, 70, "Input",
 CellID->210097611],
Cell[30303, 1143, 422, 16, 84, "Output",
 CellID->2285991]
}, Open  ]],
Cell[30740, 1162, 1820, 55, 70, "DefinitionBox3Col",
 CellID->15665],
Cell[32563, 1219, 224, 8, 70, "Caption",
 CellID->584403075],
Cell[32790, 1229, 858, 27, 70, "Text",
 CellID->724402532],
Cell[33651, 1258, 276, 9, 70, "MathCaption",
 CellID->43065643],
Cell[CellGroupData[{
Cell[33952, 1271, 334, 11, 70, "Input",
 CellID->245582468],
Cell[34289, 1284, 270, 10, 48, "Output",
 CellID->248952712]
}, Open  ]],
Cell[34574, 1297, 119, 3, 70, "MathCaption",
 CellID->171094530],
Cell[CellGroupData[{
Cell[34718, 1304, 474, 15, 70, "Input",
 CellID->96152757],
Cell[35195, 1321, 341, 11, 48, "Output",
 CellID->489598494]
}, Open  ]],
Cell[35551, 1335, 111, 3, 70, "MathCaption",
 CellID->28400559],
Cell[CellGroupData[{
Cell[35687, 1342, 539, 18, 70, "Input",
 CellID->187582339],
Cell[36229, 1362, 345, 11, 48, "Output",
 CellID->158436785]
}, Open  ]],
Cell[36589, 1376, 461, 14, 70, "Text",
 CellID->488926149],
Cell[37053, 1392, 120, 3, 70, "MathCaption",
 CellID->270676401],
Cell[CellGroupData[{
Cell[37198, 1399, 666, 20, 70, "Input",
 CellID->201796843],
Cell[37867, 1421, 405, 15, 64, "Output",
 CellID->126220331]
}, Open  ]],
Cell[38287, 1439, 261, 8, 70, "MathCaption",
 CellID->364255547],
Cell[CellGroupData[{
Cell[38573, 1451, 520, 17, 70, "Input",
 CellID->43947393],
Cell[39096, 1470, 324, 12, 48, "Output",
 CellID->290092680]
}, Open  ]],
Cell[39435, 1485, 294, 6, 70, "Text",
 CellID->65396211],
Cell[39732, 1493, 71, 1, 70, "MathCaption",
 CellID->270154680],
Cell[CellGroupData[{
Cell[39828, 1498, 579, 19, 70, "Input",
 CellID->424020910],
Cell[40410, 1519, 365, 12, 48, "Output",
 CellID->169972642]
}, Open  ]],
Cell[40790, 1534, 96, 1, 70, "MathCaption",
 CellID->75156515],
Cell[CellGroupData[{
Cell[40911, 1539, 612, 20, 70, "Input",
 CellID->4041861],
Cell[41526, 1561, 388, 13, 48, "Output",
 CellID->182042282]
}, Open  ]],
Cell[41929, 1577, 1078, 32, 70, "Text",
 CellID->181450172],
Cell[43010, 1611, 111, 3, 70, "MathCaption",
 CellID->86606327],
Cell[CellGroupData[{
Cell[43146, 1618, 445, 14, 70, "Input",
 CellID->10184270],
Cell[43594, 1634, 391, 14, 56, "Output",
 CellID->104444470]
}, Open  ]],
Cell[44000, 1651, 116, 3, 70, "MathCaption",
 CellID->98129791],
Cell[CellGroupData[{
Cell[44141, 1658, 561, 17, 70, "Input",
 CellID->30155792],
Cell[44705, 1677, 513, 20, 70, "Output",
 CellID->9994831]
}, Open  ]],
Cell[45233, 1700, 143, 4, 70, "MathCaption",
 CellID->435792412],
Cell[CellGroupData[{
Cell[45401, 1708, 519, 17, 70, "Input",
 CellID->284090847],
Cell[45923, 1727, 769, 27, 70, "Output",
 CellID->358375395]
}, Open  ]],
Cell[46707, 1757, 261, 8, 70, "MathCaption",
 CellID->616814426],
Cell[CellGroupData[{
Cell[46993, 1769, 597, 19, 70, "Input",
 CellID->437103811],
Cell[47593, 1790, 358, 12, 70, "Output",
 CellID->170044309]
}, Open  ]],
Cell[47966, 1805, 2037, 62, 70, "DefinitionBox3Col",
 CellID->52237618],
Cell[50006, 1869, 188, 8, 70, "Caption",
 CellID->68152995],
Cell[50197, 1879, 1192, 40, 70, "Text",
 CellID->20146783],
Cell[51392, 1921, 115, 3, 70, "MathCaption",
 CellID->464373915],
Cell[CellGroupData[{
Cell[51532, 1928, 431, 14, 70, "Input",
 CellID->381167273],
Cell[51966, 1944, 325, 14, 52, "Output",
 CellID->145228375]
}, Open  ]],
Cell[52306, 1961, 467, 18, 70, "MathCaption",
 CellID->768328217],
Cell[CellGroupData[{
Cell[52798, 1983, 349, 11, 28, "Input",
 CellID->422042048],
Cell[53150, 1996, 433, 11, 64, "Output",
 Evaluatable->False,
 CellID->295557560]
}, Open  ]],
Cell[53598, 2010, 1092, 39, 70, "Text",
 CellID->50963998],
Cell[54693, 2051, 132, 4, 70, "MathCaption",
 CellID->469554169],
Cell[CellGroupData[{
Cell[54850, 2059, 523, 15, 70, "Input",
 CellID->676987699],
Cell[55376, 2076, 420, 16, 72, "Output",
 CellID->120183264]
}, Open  ]],
Cell[55811, 2095, 247, 8, 70, "MathCaption",
 CellID->55781667],
Cell[CellGroupData[{
Cell[56083, 2107, 393, 13, 70, "Input",
 CellID->673117326],
Cell[56479, 2122, 389, 14, 74, "Output",
 CellID->249375876]
}, Open  ]],
Cell[56883, 2139, 270, 10, 70, "MathCaption",
 CellID->71945764],
Cell[CellGroupData[{
Cell[57178, 2153, 393, 13, 70, "Input",
 CellID->264262523],
Cell[57574, 2168, 428, 16, 108, "Output",
 CellID->221254619]
}, Open  ]],
Cell[CellGroupData[{
Cell[58039, 2189, 73, 1, 70, "Section",
 CellID->274598773],
Cell[58115, 2192, 430, 13, 70, "Text",
 CellID->2403],
Cell[58548, 2207, 246, 9, 70, "MathCaption",
 CellID->8252],
Cell[CellGroupData[{
Cell[58819, 2220, 209, 7, 28, "Input",
 CellID->15718],
Cell[59031, 2229, 655, 15, 62, "Output",
 Evaluatable->False,
 CellID->168644140]
}, Open  ]],
Cell[59701, 2247, 75, 1, 70, "MathCaption",
 CellID->7285],
Cell[CellGroupData[{
Cell[59801, 2252, 379, 13, 28, "Input",
 CellID->28428],
Cell[60183, 2267, 850, 18, 92, "Output",
 Evaluatable->False,
 CellID->180080913]
}, Open  ]],
Cell[61048, 2288, 89, 1, 70, "MathCaption",
 CellID->25960],
Cell[CellGroupData[{
Cell[61162, 2293, 744, 26, 28, "Input",
 CellID->101],
Cell[61909, 2321, 1069, 21, 92, "Output",
 Evaluatable->False,
 CellID->205496186]
}, Open  ]],
Cell[62993, 2345, 1761, 61, 70, "Text",
 CellID->2364],
Cell[64757, 2408, 303, 9, 70, "MathCaption",
 CellID->26385],
Cell[CellGroupData[{
Cell[65085, 2421, 521, 17, 28, "Input",
 CellID->27626],
Cell[65609, 2440, 829, 17, 62, "Output",
 Evaluatable->False,
 CellID->339596263]
}, Open  ]],
Cell[66453, 2460, 312, 8, 70, "Text",
 CellID->31033],
Cell[66768, 2470, 248, 7, 70, "MathCaption",
 CellID->4493],
Cell[CellGroupData[{
Cell[67041, 2481, 261, 9, 28, "Input",
 CellID->29768],
Cell[67305, 2492, 450, 11, 62, "Output",
 Evaluatable->False,
 CellID->271301759]
}, Open  ]],
Cell[67770, 2506, 146, 4, 70, "MathCaption",
 CellID->29935],
Cell[CellGroupData[{
Cell[67941, 2514, 517, 19, 28, "Input",
 CellID->19109],
Cell[68461, 2535, 679, 15, 84, "Output",
 Evaluatable->False,
 CellID->283272455]
}, Open  ]],
Cell[69155, 2553, 394, 13, 70, "Text",
 CellID->20381],
Cell[69552, 2568, 359, 12, 70, "MathCaption",
 CellID->21561],
Cell[CellGroupData[{
Cell[69936, 2584, 371, 13, 28, "Input",
 CellID->25739],
Cell[70310, 2599, 576, 13, 62, "Output",
 Evaluatable->False,
 CellID->385993893]
}, Open  ]],
Cell[70901, 2615, 2525, 73, 70, "DefinitionBox3Col",
 CellID->25923],
Cell[73429, 2690, 99, 5, 70, "Caption",
 CellID->28499],
Cell[73531, 2697, 1682, 57, 70, "Text",
 CellID->16731],
Cell[75216, 2756, 94, 1, 70, "MathCaption",
 CellID->11849],
Cell[CellGroupData[{
Cell[75335, 2761, 169, 5, 28, "Input",
 CellID->25442],
Cell[75507, 2768, 490, 12, 78, "Output",
 Evaluatable->False,
 CellID->10185372]
}, Open  ]],
Cell[76012, 2783, 64, 1, 70, "MathCaption",
 CellID->6850],
Cell[CellGroupData[{
Cell[76101, 2788, 238, 7, 28, "Input",
 CellID->28287],
Cell[76342, 2797, 491, 12, 78, "Output",
 Evaluatable->False,
 CellID->150417541]
}, Open  ]],
Cell[76848, 2812, 418, 10, 70, "Text",
 CellID->22769],
Cell[77269, 2824, 140, 4, 70, "MathCaption",
 CellID->9223],
Cell[CellGroupData[{
Cell[77434, 2832, 368, 13, 28, "Input",
 CellID->1588],
Cell[77805, 2847, 491, 12, 58, "Output",
 Evaluatable->False,
 CellID->387437944]
}, Open  ]],
Cell[78311, 2862, 999, 30, 70, "DefinitionBox",
 CellID->12083],
Cell[79313, 2894, 209, 8, 70, "Caption",
 CellID->3400],
Cell[79525, 2904, 104, 3, 70, "MathCaption",
 CellID->11158],
Cell[CellGroupData[{
Cell[79654, 2911, 291, 9, 28, "Input",
 CellID->15606],
Cell[79948, 2922, 1187, 23, 108, "Output",
 Evaluatable->False,
 CellID->288011488]
}, Open  ]],
Cell[81150, 2948, 149, 4, 70, "MathCaption",
 CellID->19463],
Cell[CellGroupData[{
Cell[81324, 2956, 508, 16, 47, "Input",
 CellID->20920],
Cell[81835, 2974, 923, 19, 78, "Output",
 Evaluatable->False,
 CellID->209459251]
}, Open  ]],
Cell[82773, 2996, 296, 8, 70, "MathCaption",
 CellID->15758],
Cell[CellGroupData[{
Cell[83094, 3008, 500, 16, 47, "Input",
 CellID->19685],
Cell[83597, 3026, 660, 15, 62, "Output",
 Evaluatable->False,
 CellID->2108622]
}, Open  ]],
Cell[CellGroupData[{
Cell[84294, 3046, 72, 1, 70, "RelatedTutorialsSection",
 CellID->311867240],
Cell[84369, 3049, 178, 4, 70, "RelatedTutorials",
 CellID->364580606]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[84586, 3058, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

