(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     74110,       2588]
NotebookOptionsPosition[     63028,       2203]
NotebookOutlinePosition[     65485,       2265]
CellTagsIndexPosition[     65390,       2259]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Array" :> Documentation`HelpLookup["paclet:ref/Array"], 
         "ArrayDepth" :> Documentation`HelpLookup["paclet:ref/ArrayDepth"], 
         "ArrayFlatten" :> 
         Documentation`HelpLookup["paclet:ref/ArrayFlatten"], "ArrayQ" :> 
         Documentation`HelpLookup["paclet:ref/ArrayQ"], "Dimensions" :> 
         Documentation`HelpLookup["paclet:ref/Dimensions"], "Inner" :> 
         Documentation`HelpLookup["paclet:ref/Inner"], "MatrixForm" :> 
         Documentation`HelpLookup["paclet:ref/MatrixForm"], "Outer" :> 
         Documentation`HelpLookup["paclet:ref/Outer"], "Table" :> 
         Documentation`HelpLookup["paclet:ref/Table"], "Tr" :> 
         Documentation`HelpLookup["paclet:ref/Tr"], "Transpose" :> 
         Documentation`HelpLookup["paclet:ref/Transpose"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"Array\"\>", 2->"\<\"ArrayDepth\"\>", 
      3->"\<\"ArrayFlatten\"\>", 4->"\<\"ArrayQ\"\>", 5->"\<\"Dimensions\"\>",
       6->"\<\"Inner\"\>", 7->"\<\"MatrixForm\"\>", 8->"\<\"Outer\"\>", 
      9->"\<\"Table\"\>", 10->"\<\"Tr\"\>", 
      11->"\<\"Transpose\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Tensors", "Title",
 CellTags->{"S3.7.11", "11.1"},
 CellID->20229],

Cell[TextData[{
 StyleBox["Tensors",
  FontSlant->"Italic"],
 " are mathematical objects that give generalizations of vectors and \
matrices. In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", a tensor is represented as a set of lists, nested to a certain number of \
levels. The nesting level is the ",
 StyleBox["rank",
  FontSlant->"Italic"],
 " of the tensor. "
}], "Text",
 CellID->19298],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     "rank ",
     Cell[BoxData[
      FormBox["0", TraditionalForm]], "InlineMath"]
    }], "TableText"], Cell["scalar", "TableText"]},
   {Cell[TextData[{
     "rank ",
     Cell[BoxData[
      FormBox["1", TraditionalForm]], "InlineMath"]
    }], "TableText"], Cell["vector", "TableText"]},
   {Cell[TextData[{
     "rank ",
     Cell[BoxData[
      FormBox["2", TraditionalForm]], "InlineMath"]
    }], "TableText"], Cell["matrix", "TableText"]},
   {Cell[TextData[{
     "rank ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"]
    }], "TableText"], Cell[TextData[{
     "rank ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     " tensor"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->29356],

Cell["Interpretations of nested lists. ", "Caption",
 CellID->5470],

Cell[TextData[{
 "A tensor of rank ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " is essentially a ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 "\[Hyphen]dimensional table of values. To be a true rank ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " tensor, it must be possible to arrange the elements in the table in a ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 "\[Hyphen]dimensional cuboidal array. There can be no holes or protrusions \
in the cuboid. "
}], "Text",
 CellID->23175],

Cell[TextData[{
 "The ",
 StyleBox["indices",
  FontSlant->"Italic"],
 " that specify a particular element in the tensor correspond to the \
coordinates in the cuboid. The ",
 StyleBox["dimensions",
  FontSlant->"Italic"],
 " of the tensor correspond to the side lengths of the cuboid. "
}], "Text",
 CellID->24196],

Cell[TextData[{
 "One simple way that a rank ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " tensor can arise is in giving a table of values for a function of ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " variables. In physics, the tensors that occur typically have indices which \
run over the possible directions in space or spacetime. Notice, however, that \
there is no built\[Hyphen]in notion of covariant and contravariant tensor \
indices in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ": you have to set these up explicitly using metric tensors."
}], "Text",
 CellID->1683],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Table",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Table"], "[", 
     RowBox[{
      StyleBox["f", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["1", "TR"]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["2", "TR"]]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["k", "TI"]], ",", 
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["k", "TI"]]}], "}"}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "create an ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["n", "1"], "\[Cross]", 
        SubscriptBox["n", "2"], "\[Cross]", "\[Ellipsis]", "\[Cross]", 
        SubscriptBox["n", "k"]}], TraditionalForm]], "InlineMath"],
     " tensor whose elements are the values of ",
     Cell[BoxData[
      FormBox["f", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Array",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Array"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["k", "TI"]]}], "}"}]}], "]"}], Cell[TextData[{
     "create an ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["n", "1"], "\[Cross]", 
        SubscriptBox["n", "2"], "\[Cross]", "\[Ellipsis]", "\[Cross]", 
        SubscriptBox["n", "k"]}], TraditionalForm]], "InlineMath"],
     " tensor with elements given by applying ",
     Cell[BoxData[
      FormBox["a", TraditionalForm]], "InlineMath"],
     " to each set of indices"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ArrayQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArrayQ"], "[", 
     StyleBox["t", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "test whether ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " is a tensor of rank ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Dimensions",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Dimensions"], "[", 
     StyleBox["t", "TI"], "]"}], Cell[
    "give a list of the dimensions of a tensor", "TableText"]},
   {
    RowBox[{
     ButtonBox["ArrayDepth",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArrayDepth"], "[", 
     StyleBox["t", "TI"], "]"}], Cell[
    "find the rank of a tensor", "TableText"]},
   {
    RowBox[{
     ButtonBox["MatrixForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MatrixForm"], "[", 
     StyleBox["t", "TI"], "]"}], Cell[TextData[{
     "print with the elements of ",
     Cell[BoxData[
      FormBox["t", TraditionalForm]], "InlineMath"],
     " arranged in a two\[Hyphen]dimensional array"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->9988],

Cell["\<\
Functions for creating and testing the structure of tensors. \
\>", "Caption",
 CellID->7619],

Cell["Here is a 2x3x2 tensor. ", "MathCaption",
 CellID->2946],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"i1", "+", 
     RowBox[{"i2", " ", "i3"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i3", ",", "2"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32190],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "7"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "8"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{338, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1115807728]
}, Open  ]],

Cell["This is another way to produce the same tensor. ", "MathCaption",
 CellID->2469],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"#1", "+", 
      RowBox[{"#2", "#3"}]}], ")"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25519],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "7"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "8"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{338, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1284210391]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MatrixForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixForm"]], "InlineFormula"],
 " displays the elements of the tensor in a two\[Hyphen]dimensional array. \
You can think of the array as being a 2x3 matrix of column vectors. "
}], "MathCaption",
 CellID->26197],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "t", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->8545],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmjtPAkEQgJd7ABo12ln6P+y18kcQY6IxRqOQ0FFSUl7JT6C8kpKSkpKS
kpIS93Gwxzjnze7tnSSeCbCzN7v7zdzs24dO9/nprdN9eezc3H92Pp5fHr9u
7t4/eZbfYIz1+Of2mvH0lqfkp7fd8l/1fSG+fZEr/9g5kC8LPpf1s1Dmjsfj
JDcEWi3+JUSYD+nCRK9lqafkwWCQyL6kC2RysVjEcSySTVCqDeQgp3X5PNzL
sg32o1a7Uq2dJ+fzObQgiqJEC5YSz5sE/5ZPvtls+v2+Jvd3uQr+R6kQrRu+
17MKSyl5OBxyaJH09nZ4s9kMakt7Ai3TKEQBGHVQT9TsI3qqfh7KPKAP+WSE
rFYrzM9pKrKvUvKJQ9/qnphm1722KHte/y7CzoNCDXNEdtG2R2DejZAU27Co
ULIeIRokuquc1kyft0F7NUVNUVO4oMjq97C1dqIHy5uNI6Z0dvMxnFPgnGM3
TttZYMPSJPg5r97qaN2/Hzt20apHXP+YrayKxTQeR1rO2xWk7WRIZGB7mKxV
jva+KbXdCv842Km7v10EUSgDRI9GB9+/653zKYni9R9oHYenbaORqofN6H/V
34uPEu4sMB1nTfWx92pOXXQGNtWHVuJ72jLnXupq0z2lqa9M9/vlrGvs1ljl
nFWUu8cQegHBNsEaOqM7jn1YTVFT/DeK0WhkRJHV74vMMj6yPlHl9K1Tmi6K
ovV6nUVX1Y1D3kyjyi+Xy8lkIpLpM+U4jpM7oLx1V9H5jnq2oWin0yly88Cd
ndjw2+k9JldzKqRkHskHtzrwXg1fCWR7HjvFd3O2AW8yNa/Ho6LqNXTe+YC0
m79/WU/ixWyv/tWeJYs8zeqnLFBXaZgFrveGWScaLcCh6Kq501f/P8Aa36AJ
gvI=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{117, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->894008711]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dimensions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dimensions"]], "InlineFormula"],
 " gives the dimensions of the tensor. "
}], "MathCaption",
 CellID->7158],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", "t", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->14058],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "3", ",", "2"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->318244720]
}, Open  ]],

Cell[TextData[{
 "Here is the ",
 Cell[BoxData[
  FormBox["111", TraditionalForm]], "InlineMath"],
 " element of the tensor. "
}], "MathCaption",
 CellID->23791],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "[", 
  RowBox[{"[", 
   RowBox[{"1", ",", "1", ",", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->13341],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1505361643]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArrayDepth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayDepth"]], "InlineFormula"],
 " gives the rank of the tensor. "
}], "MathCaption",
 CellID->28900],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayDepth", "[", "t", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->13232],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->1498662102]
}, Open  ]],

Cell["\<\
The rank of a tensor is equal to the number of indices needed to specify each \
element. You can pick out subtensors by using a smaller number of indices. \
\>", "Text",
 CellID->19736],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Transpose",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Transpose"], "[", 
     StyleBox["t", "TI"], "]"}], Cell[
    "transpose the first two indices in a tensor", "TableText"]},
   {
    RowBox[{
     ButtonBox["Transpose",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Transpose"], "[", 
     StyleBox["t", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["p", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["p", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "transpose the indices in a tensor so that the ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " becomes the ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["p", "k"], TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Tr",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Tr"], "[", 
     StyleBox["t", "TI"], ",", 
     StyleBox["f", "TI"], "]"}], Cell[TextData[{
     "form the generalized trace of the tensor ",
     Cell[BoxData[
      FormBox["t", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Outer",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Outer"], "[", 
     StyleBox["f", "TI"], ",", 
     SubscriptBox[
      StyleBox["t", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["t", "TI"], "2"], "]"}], Cell[TextData[{
     "form the generalized outer product of the tensors ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["t", "1"], TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["t", "2"], TraditionalForm]], "InlineMath"],
     " with \[OpenCurlyDoubleQuote]multiplication operator\
\[CloseCurlyDoubleQuote] ",
     Cell[BoxData[
      FormBox["f", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["t", "TI"], "1"], ".", 
     SubscriptBox[
      StyleBox["t", "TI"], "2"]}], Cell[TextData[{
     "form the dot product of ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["t", "1"], TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["t", "2"], TraditionalForm]], "InlineMath"],
     " (last index of ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["t", "1"], TraditionalForm]], "InlineMath"],
     " contracted with first index of ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["t", "2"], TraditionalForm]], "InlineMath"],
     ")"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Inner",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Inner"], "[", 
     StyleBox["f", "TI"], ",", 
     SubscriptBox[
      StyleBox["t", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["t", "TI"], "2"], ",", 
     StyleBox["g", "TI"], "]"}], Cell[TextData[{
     "form the generalized inner product, with \
\[OpenCurlyDoubleQuote]multiplication operator\[CloseCurlyDoubleQuote] ",
     Cell[BoxData[
      FormBox["f", TraditionalForm]], "InlineMath"],
     " and \[OpenCurlyDoubleQuote]addition operator\[CloseCurlyDoubleQuote] ",
     
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->17438],

Cell["Tensor manipulation operations. ", "Caption",
 CellID->9958],

Cell[TextData[{
 "You can think of a rank ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " tensor as having ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " \[OpenCurlyDoubleQuote]slots\[CloseCurlyDoubleQuote] into which you insert \
indices. Applying ",
 Cell[BoxData[
  ButtonBox["Transpose",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Transpose"]], "InlineFormula"],
 " is effectively a way of reordering these slots. If you think of the \
elements of a tensor as forming a ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 "\[Hyphen]dimensional cuboid, you can view ",
 Cell[BoxData[
  ButtonBox["Transpose",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Transpose"]], "InlineFormula"],
 " as effectively rotating (and possibly reflecting) the cuboid. "
}], "Text",
 CellID->30580],

Cell[TextData[{
 "In the most general case, ",
 Cell[BoxData[
  ButtonBox["Transpose",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Transpose"]], "InlineFormula"],
 " allows you to specify an arbitrary reordering to apply to the indices of a \
tensor. The function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Transpose",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Transpose"], "[", 
   RowBox[{"T", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["k", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
 ", gives you a new tensor ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["T", "\[Prime]"], TraditionalForm]], "InlineMath"],
 " such that the value of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    SuperscriptBox["T", "\[Prime]"], 
    RowBox[{
     SubscriptBox["i", "1"], 
     SubscriptBox["i", "2"], "...", 
     SubscriptBox["i", "k"]}]], TraditionalForm]], "InlineMath"],
 " is given by ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["T", 
    RowBox[{
     SubscriptBox["i", 
      SubscriptBox["p", "1"]], 
     SubscriptBox["i", 
      SubscriptBox["p", "2"]], "...", 
     SubscriptBox["i", 
      SubscriptBox["p", "k"]]}]], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->27085],

Cell[TextData[{
 "If you originally had an ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["n", 
     SubscriptBox["p", "1"]], "\[Cross]", 
    SubscriptBox["n", 
     SubscriptBox["p", "2"]], "\[Cross]", "...", "\[Cross]", 
    SubscriptBox["n", 
     SubscriptBox["p", "k"]]}], TraditionalForm]], "InlineMath"],
 " tensor, then by applying ",
 Cell[BoxData[
  ButtonBox["Transpose",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Transpose"]], "InlineFormula"],
 ", you will get an ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["n", "1"], "\[Cross]", 
    SubscriptBox["n", "2"], "\[Cross]", "...", "\[Cross]", 
    SubscriptBox["n", "k"]}], TraditionalForm]], "InlineMath"],
 " tensor. "
}], "Text",
 CellID->15013],

Cell["\<\
Here is a matrix that you can also think of as a 2x3 tensor. \
\>", "MathCaption",
 CellID->5284],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"ap", ",", "bp", ",", "cp"}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[7]:=",
 CellID->5253],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"ap", ",", "bp", ",", "cp"}], "}"}]}], "}"}]], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->848895940]
}, Open  ]],

Cell[TextData[{
 "Applying ",
 Cell[BoxData[
  ButtonBox["Transpose",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Transpose"]], "InlineFormula"],
 " gives you a 3x2 tensor. ",
 Cell[BoxData[
  ButtonBox["Transpose",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Transpose"]], "InlineFormula"],
 " effectively interchanges the two \[OpenCurlyDoubleQuote]slots\
\[CloseCurlyDoubleQuote] for tensor indices. "
}], "MathCaption",
 CellID->30285],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mt", "=", 
  RowBox[{"Transpose", "[", "m", "]"}]}]], "Input",
 CellLabel->"In[8]:=",
 CellID->2426],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "ap"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "bp"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "cp"}], "}"}]}], "}"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->1809716148]
}, Open  ]],

Cell[TextData[{
 "The element ",
 Cell[BoxData[
  RowBox[{"m", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "3"}], "]"}], "]"}]], "InlineFormula"],
 " in the original tensor becomes the element ",
 Cell[BoxData[
  RowBox[{"m", "[", 
   RowBox[{"[", 
    RowBox[{"3", ",", "2"}], "]"}], "]"}]], "InlineFormula"],
 " in the transposed tensor. "
}], "MathCaption",
 CellID->14536],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"m", "[", 
    RowBox[{"[", 
     RowBox[{"2", ",", "3"}], "]"}], "]"}], ",", 
   RowBox[{"mt", "[", 
    RowBox[{"[", 
     RowBox[{"3", ",", "2"}], "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->3281],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"cp", ",", "cp"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->1051263691]
}, Open  ]],

Cell["This produces a 2x3x1x2 tensor. ", "MathCaption",
 CellID->6549],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"Array", "[", 
   RowBox[{"a", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "1", ",", "2"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[10]:=",
 CellID->1348],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztm11S2zAQx5U4aUo7hIQHyCNn4BDtUw+RYToDD0w7lDvCrVLLjlvPdqX9
lGNTmIFYiuJd/bVaS7+Ib/vn+++P++eHu/3N16f9z/uHu183X3481VXVLITZ
Swjhdhfq60N91fzGn9f6t71sry7j36p79xAWoPyp/jOvi59B/QWjHD+3BPUb
5v02zPtBfzH/S/Sv64e2f1y9qP6h/Q1bohX0rlNhA17hfapEPfz8NtGO8r67
PzVqXP9hdHP9T/VfOhqwfMYanejlsi5WoH5+rIftPzjVw/LKyY+VsL20/NFZ
z+hvhcxFaf+sekr98NJTF7WxF2H5p9x85l9f0q3ifFtl3z1DPEjVY+3Sd/fy
EMtbfMucMqe/pxsJKm8PNxIpD/1Ggp4xcA2D5SXaF5gtOCulnNVzF6swG6xB
GeYsal1zXkQr+PyHVqgR0mlFWbVqxXoeslYZC0bsc1auuc+vlXakcS29v1YP
qKs0prh6UHasegz51IcRDX2HM8Inh1FWqYiD89oaYTqtojbdnsQ/d2mtSbXx
2xnFIrYizo2EdO6slXZgHMP+zIWqcHKWhx6cnOVhx6qHTxRBeoDPS3z+SJ9+
VwZbcFR4M9oaU57qUHFlUQeNtYFW9lxqGuuro6/da58vLY+vu0T7Po+qwt/d
DbVCpGYA5d+W6d+F0j+q3FLMeAl5tfzqrRNuVDth+ykT8GYlMlnijfWGS1I0
/RuaiHf3X7BGqTSpLUW+U36UJt/ozl84OiW/aShFxkt940GVm/WJ054YK4+F
get8K0+/tT2Xj06ePUtGYWguLvXN97uJ9mnsQ76pVa10V6/bIVCk25vmUiRc
pyXMrBRdLUPGKatWLX3JtzXetKRXSkO9CYBWLylf1epl/UaCt8cv85Tv75jL
567+fj43ElaaK1VcT8LL5yyrVamWNvJdImdp7HiTb4+chfUDEmtKHy8yTtmx
6qUj37wZYmXePCtlaLc1jng03Prk43FwyoqPYnLC3SfAHMLdb68l3FQ+otpj
BBzjeTkCDvmYxH9Pwm2dE1Mn4G/9jHcT2+Y12lgJ+NTPfFd9u+ZRej/7LSt7
n/3+3wl3k5PNUWwj4FKCOQz7lrDdsZ75liszHNX29c1X/fYJbN3D6qi3lXbp
yVFurTaO897YbjzntQ8hklq1atXsDl1WFu/nvf31mArVvj54RJGeeo8vh43j
vDe6AhNkFx+tpFalWvlEH5eCe+QwjR2o0qnOf8N2Hv+z4mHHqodPFFEU3Bo9
FP+mouY057x5ecRKtnVWfBRpo8e6Q8bIN/aaI999XlbybDdG5nNkO0XyJf7t
GpXjJYddh9lvNy4WiA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{455, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->536289419]
}, Open  ]],

Cell[TextData[{
 "This transposes the first two levels of\[NonBreakingSpace]",
 Cell[BoxData["t"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->26199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tt1", "=", 
  RowBox[{"Transpose", "[", "t", "]"}]}]], "Input",
 CellLabel->"In[11]:=",
 CellID->16835],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztml1OGzEQx51sQkor0qQPiEfOwCHapx4iQpXgoQIBBywno2sHt9Fg73za
OMJISXY2a8/479lZ+xd+7p5ufv3ePd1e7y5/POzub26vHy+/3z2Mp4aZc7M/
zrmrCzcev4xH4eX/nsfX/nB/9MW/D/HbF7dA7M/j29y9bfeVYPt2S3B+Q+xv
Q+yPEn+J8cVxSMdH1QsbH7QH/4aOGtow2qjKBnxuE95S52H7beY6ymh8O2w8
1Pi/CePPjZ87O9Cei2bLR70czSHRmz8Pr1+Nb0Mit04y1+fOp/q1iGOVuZ4a
B2Z/emc9c+Mrpad2XutkcWi1/GeHPmix+TtxlW3tvz3NtEqd5/Wujy2lk86n
ZKQ09fNXyeeAkid0PUpEaDcT+F1Dycg3z3d2bPC5dQZsuBqB7c9MvK4RG9Yx
bC0ERyHTClZbuEaAXuDKVKYV16tWK8yehTglK5FFhfxbC/1A1TA/mI21t9ID
yzGpHlzdj2llEHdQqZ2jfW2L3qDC0Du8z7UZRtMGVoN1RhubWib1xtWm3G7K
m1gFtahhEj+whsHv58zxUmpYKs4TpB9JDbPwo9WjTFZhnC19Z2GUCPZyLvIC
Z0ZWAbl5BRVJVzKaLlhuQV00vmzUoWWZlM7GnYvXZXgdwyG3Wr5+XmSu3wB7
cdCOU6um4otxHca3nYgvdT03PtJuKhiQk/OPOlm3GV8n69FbJ+v88SxEs8Ql
wFzCWoqoc4lzq0Sdq1spol5qXlveN8dnaSfq0zF0ot4iUZ/Hu7sSSYe78Tq0
CWMAbZJ0bOVZhqRjXq1JengWFiPnlNUtljkSP9y81tIBKz2syLlWd64dqlel
Jz52R5SpYVhGtUnOYa9Y/ZdppfWqJemy7OvknKbHRyHnsizqpBxT5GOT8n1W
dTJeloyHuzYYehKunfFOxvPxtUvGtWuQTspl45fM1n9Srp21Ts55difntnom
d3nqrNaRdA4rr8fQOfT4OOk5V/ea3JwbWw1irt3vyQi6lqzJ/19zaq3XJkHn
MjOZVlyvZQi6xUqkE3V7PY6bqL/PSqDNGtcmYcd+fSj3P+ocrzaE3aLGeROr
sBY1TuIHqtYKccd+cbAi7pifMsTdmrxYZxPG3rHZaIm6a5+WNN6OeSlJ2rW9
pMh76nOKvB/yuhrkPeV3irzD8XDiS8WzNyhs3c3+AnKKyG8=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{448, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->668478255]
}, Open  ]],

Cell["The result is a 3x2x1x2 tensor. ", "MathCaption",
 CellID->28137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", "tt1", "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->8351],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "2", ",", "1", ",", "2"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->1826036879]
}, Open  ]],

Cell[TextData[{
 "If you have a tensor that contains lists of the same length at different \
levels, then you can use ",
 Cell[BoxData[
  ButtonBox["Transpose",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Transpose"]], "InlineFormula"],
 " to effectively collapse different levels."
}], "Text",
 CellID->27617],

Cell["\<\
This collapses all three levels, giving a list of the elements on the \
\[OpenCurlyDoubleQuote]main diagonal\[CloseCurlyDoubleQuote]. \
\>", "MathCaption",
 CellID->5233],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Transpose", "[", 
  RowBox[{
   RowBox[{"Array", "[", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3", ",", "3"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->30571],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "[", 
    RowBox[{"1", ",", "1", ",", "1"}], "]"}], ",", 
   RowBox[{"a", "[", 
    RowBox[{"2", ",", "2", ",", "2"}], "]"}], ",", 
   RowBox[{"a", "[", 
    RowBox[{"3", ",", "3", ",", "3"}], "]"}]}], "}"}]], "Output",
 ImageSize->{234, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->2016095630]
}, Open  ]],

Cell["This collapses only the first two levels. ", "MathCaption",
 CellID->25529],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Transpose", "[", 
  RowBox[{
   RowBox[{"Array", "[", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->17731],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"1", ",", "1", ",", "1"}], "]"}], ",", 
     RowBox[{"a", "[", 
      RowBox[{"1", ",", "1", ",", "2"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"2", ",", "2", ",", "1"}], "]"}], ",", 
     RowBox[{"a", "[", 
      RowBox[{"2", ",", "2", ",", "2"}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{338, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->568085610]
}, Open  ]],

Cell[TextData[{
 "You can also use ",
 Cell[BoxData[
  ButtonBox["Tr",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tr"]], "InlineFormula"],
 " to extract diagonal elements of a tensor. "
}], "Text",
 CellID->20342],

Cell["This forms the ordinary trace of a rank 3 tensor. ", "MathCaption",
 CellID->16467],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tr", "[", 
  RowBox[{"Array", "[", 
   RowBox[{"a", ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3", ",", "3"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->30000],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "[", 
   RowBox[{"1", ",", "1", ",", "1"}], "]"}], "+", 
  RowBox[{"a", "[", 
   RowBox[{"2", ",", "2", ",", "2"}], "]"}], "+", 
  RowBox[{"a", "[", 
   RowBox[{"3", ",", "3", ",", "3"}], "]"}]}]], "Output",
 ImageSize->{223, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->1304443250]
}, Open  ]],

Cell["\<\
Here is a generalized trace, with elements combined into a list. \
\>", "MathCaption",
 CellID->30916],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tr", "[", 
  RowBox[{
   RowBox[{"Array", "[", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3", ",", "3"}], "}"}]}], "]"}], ",", "List"}], 
  "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->12634],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "[", 
    RowBox[{"1", ",", "1", ",", "1"}], "]"}], ",", 
   RowBox[{"a", "[", 
    RowBox[{"2", ",", "2", ",", "2"}], "]"}], ",", 
   RowBox[{"a", "[", 
    RowBox[{"3", ",", "3", ",", "3"}], "]"}]}], "}"}]], "Output",
 ImageSize->{234, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->1085989644]
}, Open  ]],

Cell["This combines diagonal elements only down to level 2. ", "MathCaption",
 CellID->17757],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tr", "[", 
  RowBox[{
   RowBox[{"Array", "[", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3", ",", "3"}], "}"}]}], "]"}], ",", "List", ",", 
   "2"}], "]"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->29240],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"1", ",", "1", ",", "1"}], "]"}], ",", 
     RowBox[{"a", "[", 
      RowBox[{"1", ",", "1", ",", "2"}], "]"}], ",", 
     RowBox[{"a", "[", 
      RowBox[{"1", ",", "1", ",", "3"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"2", ",", "2", ",", "1"}], "]"}], ",", 
     RowBox[{"a", "[", 
      RowBox[{"2", ",", "2", ",", "2"}], "]"}], ",", 
     RowBox[{"a", "[", 
      RowBox[{"2", ",", "2", ",", "3"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"3", ",", "3", ",", "1"}], "]"}], ",", 
     RowBox[{"a", "[", 
      RowBox[{"3", ",", "3", ",", "2"}], "]"}], ",", 
     RowBox[{"a", "[", 
      RowBox[{"3", ",", "3", ",", "3"}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{489, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->1050542205]
}, Open  ]],

Cell["\<\
Outer products, and their generalizations, are a way of building higher\
\[Hyphen]rank tensors from lower\[Hyphen]rank ones. Outer products are also \
sometimes known as direct, tensor or Kronecker products.\
\>", "Text",
 CellID->13623],

Cell[TextData[{
 "From a structural point of view, the tensor you get from ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Outer",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Outer"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["t", "TI"], ",", 
    StyleBox["u", "TI"]}], "]"}]], "InlineFormula"],
 " has a copy of the structure of ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " inserted at the \[OpenCurlyDoubleQuote]position\[CloseCurlyDoubleQuote] of \
each element in ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 ". The elements in the resulting structure are obtained by combining \
elements of ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath"],
 " using the function ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->15941],

Cell[TextData[{
 "This gives the \[OpenCurlyDoubleQuote]outer ",
 Cell[BoxData["f"], "InlineFormula"],
 "\[CloseCurlyDoubleQuote] of two vectors. The result is a matrix. "
}], "MathCaption",
 CellID->7131],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Outer", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"ap", ",", "bp"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->15749],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"a", ",", "ap"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"a", ",", "bp"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"b", ",", "ap"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"b", ",", "bp"}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{293, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->658081649]
}, Open  ]],

Cell[TextData[{
 "If you take the \[OpenCurlyDoubleQuote]outer ",
 Cell[BoxData["f"], "InlineFormula"],
 "\[CloseCurlyDoubleQuote] of a length 3 vector with a length 2 vector, you \
get a 3x2 matrix. "
}], "MathCaption",
 CellID->9299],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Outer", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"ap", ",", "bp"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[19]:=",
 CellID->25575],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"a", ",", "ap"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"a", ",", "bp"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"b", ",", "ap"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"b", ",", "bp"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"c", ",", "ap"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"c", ",", "bp"}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{436, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->1728835756]
}, Open  ]],

Cell[TextData[{
 "The result of taking the \[OpenCurlyDoubleQuote]outer ",
 Cell[BoxData["f"], "InlineFormula"],
 "\[CloseCurlyDoubleQuote] of a 2x2 matrix and a length 3 vector is a 2x2x3 \
tensor. "
}], "MathCaption",
 CellID->14363],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Outer", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"m11", ",", "m12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"m21", ",", "m22"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[20]:=",
 CellID->13245],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWsFu2zAMVaJkyZolTXdoulv2M9tpHxEEA9rDsKHN164f40mynbgEY5Iy
JSedDcSwVJqPehRlW68/dofHn792h6f9bvv9effn8Wn/sv32+9l12ZExo7/G
mK8Pxl0X7ir8/PHqfuVlebXwZ1v/tTAT0L5xp7FrfgH9t1X/FPSvE9vD+GD8
fcW7PmMP44VtG7JwIxzlQ4V2h3jD+rXssei9HYyvr3g/C9mH7TErG95q6pqh
f3Lsd8fMNaqUhsPf9Ma64WVW9VsC7YMK2rTqp+anDpofm42oho8D00K0eSTT
cTMfMghRg5dp2T6e3/RWhshIfNvX8ExkPR8iarXG7oZZ1szq+XH0y+R1xjVn
xyWvdbjWUnfxRknNpSVrRKv3iQ1W/zZ7GIVONtCxZmLkkrBvhdmgamMUcNM8
PSlsz9BEjTkKLWUNsbBbsgbt1wP/6iOV8N/nOye0gl5S8sjB9k/3MeYtC7r8
nUKnlqh19VPGrGDY+bISV9e59zO8Uf0lWiAVj3FjkdEu1RCWDQ/GYMzqYZ1b
2anaiOcTm5O6fKI7i4n4xOY4h888z43w/UNW3D1oU9XP80q9yeigwNi7ruk4
Kv4Fq8Mb7jsNezjWhuCQN1cplcUzb83pu38B2pvitO/dZrcqTvsZHPvaL2QI
7qO3xWerbFN4tsocNz7bEh/Ferko+Uuod8mvpBkfFDOefTfFjPrCp0Y9KGi4
vVRBq/1NorIy6DucsWFvgBSzg5ImRdNV0qSVkGZvqn6u5tA33ncs2N06Oho6
f3pVqq49Ij3VbHxcPuDegNTb9e/+9o4NVvw2FB31jFqjUypYl4zdVT0L9Xkh
T8j/R70Z1LPrVs/CG/2FVE3f8zidTqMz8jy1BO9KqZ5xsPNlJe4/e9JUGF/t
4awQvhmvwLBmr5LaE7uyU7URzydcUburZxSCpnpGYcWqZ2meG5SiIdV/KH9d
NR9pvF1XcIino5LxvGpzpaOMlfNQOnsx5alWDShlrGnHUcYwvzHKWH2fNe3K
WNOOo4w17bnKWNijCg2O1mVG/wBpOFbr\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{474, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->34837119]
}, Open  ]],

Cell["Here are the dimensions of the tensor. ", "MathCaption",
 CellID->201],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", "%", "]"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->6424],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "2", ",", "3"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->757871917]
}, Open  ]],

Cell[TextData[{
 "If you take the generalized outer product of an ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["m", "1"], "\[Cross]", 
    SubscriptBox["m", "2"], "\[Cross]", "...", "\[Cross]", 
    SubscriptBox["m", "r"]}], TraditionalForm]], "InlineMath"],
 " tensor and an ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["n", "1"], "\[Cross]", 
    SubscriptBox["n", "2"], "\[Cross]", "...", "\[Cross]", 
    SubscriptBox["n", "s"]}], TraditionalForm]], "InlineMath"],
 " tensor, you get an ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["m", "1"], "\[Cross]", "...", "\[Cross]", 
    SubscriptBox["m", "r"], "\[Cross]", 
    SubscriptBox["n", "1"], "\[Cross]", "...", "\[Cross]", 
    SubscriptBox["n", "s"]}], TraditionalForm]], "InlineMath"],
 " tensor. If the original tensors have ranks ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["s", TraditionalForm]], "InlineMath"],
 ", your result will be a rank ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", "+", "s"}], TraditionalForm]], "InlineMath"],
 " tensor. "
}], "Text",
 CellID->7389],

Cell[TextData[{
 "In terms of indices, the result of applying ",
 Cell[BoxData[
  ButtonBox["Outer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Outer"]], "InlineFormula"],
 " to two tensors ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["T", 
    RowBox[{
     SubscriptBox["i", "1"], 
     SubscriptBox["i", "2"], "...", 
     SubscriptBox["i", "r"]}]], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["U", 
    RowBox[{
     SubscriptBox["j", "1"], 
     SubscriptBox["j", "2"], "...", 
     SubscriptBox["j", "s"]}]], TraditionalForm]], "InlineMath"],
 " is the tensor ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["V", 
    RowBox[{
     SubscriptBox["i", "1"], 
     SubscriptBox["i", "2"], "...", 
     SubscriptBox["i", "r"], 
     SubscriptBox["j", "1"], 
     SubscriptBox["j", "2"], "...", 
     SubscriptBox["j", "s"]}]], TraditionalForm]], "InlineMath"],
 " with elements ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "[", 
    RowBox[{
     SubscriptBox["T", 
      RowBox[{
       RowBox[{
        RowBox[{
         SubscriptBox["i", "1"], 
         SubscriptBox["i", "2"]}], "..."}], 
       SubscriptBox["i", "r"]}]], ",", 
     SubscriptBox["U", 
      RowBox[{
       SubscriptBox["j", "1"], 
       SubscriptBox["j", "2"], "...", 
       SubscriptBox["j", "s"]}]]}], "]"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->20735],

Cell[TextData[{
 "In doing standard tensor calculations, the most common function ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " to use in ",
 Cell[BoxData[
  ButtonBox["Outer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Outer"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 ", corresponding to the standard outer product. "
}], "Text",
 CellID->22024],

Cell[TextData[{
 "Particularly in doing combinatorial calculations, however, it is often \
convenient to take ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " to be ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ". Using ",
 Cell[BoxData[
  ButtonBox["Outer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Outer"]], "InlineFormula"],
 ", you can then get combinations of all possible elements in one tensor, \
with all possible elements in the other."
}], "Text",
 CellID->18895],

Cell[TextData[{
 "In constructing ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Outer",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Outer"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["t", "TI"], ",", 
    StyleBox["u", "TI"]}], "]"}]], "InlineFormula"],
 " you effectively insert a copy of ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath"],
 " at every point in ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 ". To form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Inner",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inner"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["t", "TI"], ",", 
    StyleBox["u", "TI"]}], "]"}]], "InlineFormula"],
 ", you effectively combine and collapse the last dimension of ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 " and the first dimension of ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath"],
 ". The idea is to take an ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["m", "1"], "\[Cross]", 
    SubscriptBox["m", "2"], "\[Cross]", "...", "\[Cross]", 
    SubscriptBox["m", "r"]}], TraditionalForm]], "InlineMath"],
 " tensor and an ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["n", "1"], "\[Cross]", 
    SubscriptBox["n", "2"], "\[Cross]", "...", "\[Cross]", 
    SubscriptBox["n", "s"]}], TraditionalForm]], "InlineMath"],
 " tensor, with ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["m", "r"], "=", 
    SubscriptBox["n", "1"]}], TraditionalForm]], "InlineMath"],
 ", and get an ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["m", "1"], "\[Cross]", 
    SubscriptBox["m", "2"], "\[Cross]", "...", "\[Cross]", 
    SubscriptBox["m", 
     RowBox[{"r", "-", "1"}]], "\[Cross]", 
    SubscriptBox["n", "2"], "\[Cross]", "...", "\[Cross]", 
    SubscriptBox["n", "s"]}], TraditionalForm]], "InlineMath"],
 " tensor as the result. "
}], "Text",
 CellID->28745],

Cell[TextData[{
 "The simplest examples are with vectors. If you apply ",
 Cell[BoxData[
  ButtonBox["Inner",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Inner"]], "InlineFormula"],
 " to two vectors of equal length, you get a scalar. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Inner",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inner"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    SubscriptBox[
     StyleBox["v", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["v", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["g", "TI"]}], "]"}]], "InlineFormula"],
 " gives a generalization of the usual scalar product, with ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " playing the role of multiplication, and ",
 Cell[BoxData[
  FormBox["g", TraditionalForm]], "InlineMath"],
 " playing the role of addition."
}], "Text",
 CellID->6170],

Cell["\<\
This gives a generalization of the standard scalar product of two vectors.\
\>", "MathCaption",
 CellID->11483],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inner", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"ap", ",", "bp", ",", "cp"}], "}"}], ",", "g"}], "]"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->28717],

Cell[BoxData[
 RowBox[{"g", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "ap"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", "bp"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"c", ",", "cp"}], "]"}]}], "]"}]], "Output",
 ImageSize->{207, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]=",
 CellID->133051129]
}, Open  ]],

Cell["This gives a generalization of a matrix product. ", "MathCaption",
 CellID->28752],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inner", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", "g"}], "]"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->11324],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"g", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"1", ",", "a"}], "]"}], ",", 
       RowBox[{"f", "[", 
        RowBox[{"2", ",", "c"}], "]"}]}], "]"}], ",", 
     RowBox[{"g", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"1", ",", "b"}], "]"}], ",", 
       RowBox[{"f", "[", 
        RowBox[{"2", ",", "d"}], "]"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"g", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"3", ",", "a"}], "]"}], ",", 
       RowBox[{"f", "[", 
        RowBox[{"4", ",", "c"}], "]"}]}], "]"}], ",", 
     RowBox[{"g", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"3", ",", "b"}], "]"}], ",", 
       RowBox[{"f", "[", 
        RowBox[{"4", ",", "d"}], "]"}]}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{578, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]=",
 CellID->46685011]
}, Open  ]],

Cell["Here is a 3x2x2 tensor. ", "MathCaption",
 CellID->27740],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "=", 
  RowBox[{"Array", "[", 
   RowBox[{
    RowBox[{"1", "&"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2", ",", "2"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[24]:=",
 CellID->18255],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWM0OgjAMLiD+xt+TR55GT76BHogxgYPRqO+Pq+jlE1LGcGAyko119Odr
V0bZLn4kp3P8SI9xtL3F1yQ93qPN5aamAo/I2xPRfE1qnKnRq/F1UI2ox33w
mctEegT0XOAfG8pL+kzxTTqOT4rfQhNfwF3ea3rlK3JZoI3nEWUZfxGaInld
+7iKtu2X+b/SjLNfa3VYKqTvd7lfMo/0sGF9kv6m8eM78W/4q8Z/UBN/vawq
ojmnMdo2+GzLVdkTuo6/ST/l7PI1pUKg8TuIz6eG8mgf9Znim3UcnxQ/rCMk
fEh73BnvMVI1ZPr81/xSNdY2PlP8dr40LgtcFrgscFnQhBdtR9llQVbjlIml
uDZdvO9YjeB/uMSP+qVzAUkf/tfbtl/m/7KifaTzUyEeHiqMyHsCt8AzsA==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{348, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]=",
 CellID->105083754]
}, Open  ]],

Cell["Here is a 2x3x1 tensor. ", "MathCaption",
 CellID->22070],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"b", "=", 
  RowBox[{"Array", "[", 
   RowBox[{
    RowBox[{"2", "&"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "1"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[25]:=",
 CellID->16843],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "2", "}"}], ",", 
     RowBox[{"{", "2", "}"}], ",", 
     RowBox[{"{", "2", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "2", "}"}], ",", 
     RowBox[{"{", "2", "}"}], ",", 
     RowBox[{"{", "2", "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{228, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]=",
 CellID->131020728]
}, Open  ]],

Cell["This gives a 3x2x3x1 tensor. ", "MathCaption",
 CellID->15756],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", ".", "b"}]], "Input",
 CellLabel->"In[26]:=",
 CellID->10765],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWc1OwzAMTtdtGiB+TxzHy8CJh6gmpO2AQGNPy94BOADXkKQaIDcjTeK0
TvGkVnFre/b31VFr31ab5d19tVktqvnNunpcrhZP8+uHtbpUFkIUz0KIq0uh
1lKtzKF/W3XUy3p1pM/l7q4UY4d84Lh/mFjfZU89Xigz/n76EK9Y/Et9cmbh
ikJ7GYmmn1A9W5Q2u77j2henr91Q8YTXfXGB8kiGPK0TddJi6dCbdWzn8pNr
Hr57YK559s0XxBWLr7Aqm9q8AH29J8CoU9q18ZNjHja/zFeaPCCuGHw1q813
j9Q1PlUivH6MrOeyoxIXlE8YTysOoXhCudAn7z3HPOuTb9n4aMZy2qGVy0t+
GUD5zFOffoZ9cgTRxOEI5w3MvPeNf2R3ziksfNmiGXVsFdHMqg8uIHLxXOBU
y2+5zf6Are/LDbV4YyuEWj5d4/8XXiH4c1VQiJerIoeqCOlD614A7KydI+vB
/7XZUYgLyheM514cQvC0vpcZAc6v/VexFfTfJ7DYE/BXw0rsEzLUCSLWRPYN
BWWeTPU7SXyRGCzy5KO7PGx+6x0vdm4y1I491gTkXWLUCneD02cA5Q+JwRx3
IPGiTsMQ9rdzbt/62L0WZoVCvHZWYr86d+8OQ+sYYHVgPg3KetmmByCKLydW
m3w=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{474, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]=",
 CellID->440383872]
}, Open  ]],

Cell["Here are the dimensions of the result. ", "MathCaption",
 CellID->2980],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", "%", "]"}]], "Input",
 CellLabel->"In[27]:=",
 CellID->1458],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "2", ",", "3", ",", "1"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]=",
 CellID->1442423181]
}, Open  ]],

Cell[TextData[{
 "You can think of ",
 Cell[BoxData[
  ButtonBox["Inner",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Inner"]], "InlineFormula"],
 " as performing a \[OpenCurlyDoubleQuote]contraction\[CloseCurlyDoubleQuote] \
of the last index of one tensor with the first index of another. If you want \
to perform contractions across other pairs of indices, you can do so by first \
transposing the appropriate indices into the first or last position, then \
applying ",
 Cell[BoxData[
  ButtonBox["Inner",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Inner"]], "InlineFormula"],
 ", and then transposing the result back. "
}], "Text",
 CellID->8124],

Cell[TextData[{
 "In many applications of tensors, you need to insert signs to implement \
antisymmetry. The function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Signature",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Signature"], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 ",",
 " ",
 "which gives the signature of a permutation, is often useful for this \
purpose. "
}], "Text",
 CellID->6008],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Outer",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Outer"], "[", 
     StyleBox["f", "TI"], ",", 
     SubscriptBox[
      StyleBox["t", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["t", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[TextData[{
     "form a generalized outer product by combining the lowest\[Hyphen]level \
elements of ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["t", "1"], ",", 
        SubscriptBox["t", "2"], ",", "\[Ellipsis]"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Outer",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Outer"], "[", 
     StyleBox["f", "TI"], ",", 
     SubscriptBox[
      StyleBox["t", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["t", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "treat only sublists at level ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " as separate elements"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Outer",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Outer"], "[", 
     RowBox[{
      StyleBox["f", "TI"], ",", 
      SubscriptBox[
       StyleBox["t", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["t", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[TextData[{
     "treat only sublists at level ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["n", "i"], TraditionalForm]], "InlineMath"],
     " in ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["t", "i"], TraditionalForm]], "InlineMath"],
     " as separate elements"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Inner",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Inner"], "[", 
     StyleBox["f", "TI"], ",", 
     SubscriptBox[
      StyleBox["t", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["t", "TI"], "2"], ",", 
     StyleBox["g", "TI"], "]"}], Cell[TextData[{
     "form a generalized inner product using the lowest\[Hyphen]level \
elements of ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["t", "1"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Inner",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Inner"], "[", 
     StyleBox["f", "TI"], ",", 
     SubscriptBox[
      StyleBox["t", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["t", "TI"], "2"], ",", 
     StyleBox["g", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "contracts index ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " of the first tensor with the first index of the second tensor"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->25311],

Cell["\<\
Treating only certain sublists in tensors as separate elements. \
\>", "Caption",
 CellID->6667],

Cell["", "Text",
 CellID->186700374],

Cell["Here every single symbol is treated as a separate element. ", \
"MathCaption",
 CellID->21717],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Outer", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i", ",", "j"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "l"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[28]:=",
 CellID->15928],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"i", ",", "x"}], "]"}], ",", 
       RowBox[{"f", "[", 
        RowBox[{"i", ",", "y"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"j", ",", "x"}], "]"}], ",", 
       RowBox[{"f", "[", 
        RowBox[{"j", ",", "y"}], "]"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"k", ",", "x"}], "]"}], ",", 
       RowBox[{"f", "[", 
        RowBox[{"k", ",", "y"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"l", ",", "x"}], "]"}], ",", 
       RowBox[{"f", "[", 
        RowBox[{"l", ",", "y"}], "]"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{550, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]=",
 CellID->292112533]
}, Open  ]],

Cell["\<\
But here only sublists at level 1 are treated as separate elements. \
\>", "MathCaption",
 CellID->31099],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Outer", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i", ",", "j"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "l"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "1"}], "]"}]], "Input",
 CellLabel->"In[29]:=",
 CellID->4580],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i", ",", "j"}], "}"}], ",", "x"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i", ",", "j"}], "}"}], ",", "y"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"k", ",", "l"}], "}"}], ",", "x"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"k", ",", "l"}], "}"}], ",", "y"}], "]"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{394, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[29]=",
 CellID->673285511]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ArrayFlatten",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArrayFlatten"], "[", 
     RowBox[{
      StyleBox["t", "TI"], ",", 
      StyleBox["r", "TI"]}], "]"}], Cell[TextData[{
     "create a flat rank ",
     Cell[BoxData[
      FormBox["r", TraditionalForm]], "InlineMath"],
     " tensor from a rank ",
     Cell[BoxData[
      FormBox["r", TraditionalForm]], "InlineMath"],
     " tensor of rank ",
     Cell[BoxData[
      FormBox["r", TraditionalForm]], "InlineMath"],
     " tensors"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ArrayFlatten",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArrayFlatten"], "[", 
     StyleBox["t", "TI"], "]"}], Cell[TextData[{
     "flatten a matrix of matrices (equivalent to ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["ArrayFlatten",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ArrayFlatten"], "[", 
       RowBox[{
        StyleBox["t", "TI"], ",", "2"}], "]"}]], "InlineFormula"],
     ")"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->354449619],

Cell["Flattening block tensors. ", "Caption",
 CellID->94639404],

Cell["\<\
Here is a block matrix (a matrix of matrices that can viewed as blocks that \
fit edge to edge within a larger matrix). \
\>", "MathCaption",
 CellID->125579525],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", " ", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"4", ",", "5"}], "}"}]}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "3", "}"}], ",", 
        RowBox[{"{", "6", "}"}]}], "}"}]}], " ", "}"}], ",", 
    RowBox[{"{", " ", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"7", ",", "8"}], "}"}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"{", "9", "}"}], "}"}]}], " ", "}"}]}], "}"}], "]"}]], "Input",\

 CellLabel->"In[30]:=",
 CellID->55097366],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytU80OgjAMLmMkiuJZIwg334BH0JMPsRATPBgN8v5znRNn2YgYlqxdx/d1
9O8k2vp8Fe2lEsWxEff6Uj2Kw61RV2EAAKXa+zWos1QnvUsple7LEGWICL1g
oQSaqdGhExWjiDpbYwB2SuPzAWp9xwlv7uTlFu9XDv4f93JiK4o+98WJCGfm
xG4HPJjk4Cdgk3nDhY7elciMZp4K+iQ3vNjpZ7rocWElEuJx82fmliP8aC7/
YOGrf3kXrd2/YFD2Gymx+13vYmXEZl3emUFzK++Bp0607livyJrAfgTSO4FD
9XJNum0X0p5CiqZVyQfRtBdSkxN3LCtHXv2+x0fOzOuJ9E8UBE/DkaF+\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{54, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[30]//TableForm=",
 CellID->9028693]
}, Open  ]],

Cell["Here is the matrix formed by piecing the blocks together.", \
"MathCaption",
 CellID->827898695],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"ArrayFlatten", "[", "%", "]"}], "]"}]], "Input",
 CellLabel->"In[31]:=",
 CellID->116341345],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytVM0OgjAMLmMkyp9Xj1w4+R568iEIMYGD0SjvP9cxsI4OJGHJ2nX06/a1
Hdeqa273qmvrqri8qmfT1u/i/HjprTAAgFLP0xH0WumVmaVSWk9liDJEDzMg
0QLNQYesV4wiGm3jA5BpjccHqM2edHB7FpcT3L8YvJ/0YmLCYortMZGD2bG+
PNM+gk0OfgKxWTQctAKp1cJTQZ+UFhezcbZjj0Pa6i9HXM5cuiKOwcqvL/z0
rxzZ0v4dusftempPu55DuTcVY94FucGQ92Bl/dx+wFpEhOGUmfK+zLk6cn8A
ah8UfZ2ut5uDfNbb7ZHE5ornkjNn+WOvZy7s6ZnyvzQIPtFtq2I=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{37, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[31]//TableForm=",
 CellID->527995899]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Tensors - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 23.7018326}", "context" -> "", 
    "keywords" -> {
     "array", "ArrayDepth", "array depth", "array rank", "ArrayQ", "arrays", 
      "collapse", "contraction", "contravariant indices", "covariant indices",
       "diagonal", "direct products of tensors", "dyadic products", "indices",
       "inner", "inner products", "Kronecker products of tensors", "levels", 
      "lists", "metric tensors", "outer", "outer products", "shape", 
      "signature", "Spacetime", "table", "telescope", "tensors", "Tr", 
      "transpose"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Tensors are mathematical objects that give generalizations of vectors \
and matrices. In Mathematica, a tensor is represented as a set of lists, \
nested to a certain number of levels. The nesting level is the rank of the \
tensor. Interpretations of nested lists. A tensor of rank k is essentially a \
k-dimensional table of values. To be a true rank k tensor, it must be \
possible to arrange the elements in the table in a k-dimensional cuboidal \
array. There can be no holes or protrusions in the cuboid. ", 
    "synonyms" -> {"3.7.11"}, "title" -> "Tensors", "type" -> "Tutorial", 
    "uri" -> "tutorial/Tensors"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.7.11"->{
  Cell[2141, 55, 72, 2, 70, "Title",
   CellTags->{"S3.7.11", "11.1"},
   CellID->20229]},
 "11.1"->{
  Cell[2141, 55, 72, 2, 70, "Title",
   CellTags->{"S3.7.11", "11.1"},
   CellID->20229]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.7.11", 65174, 2248},
 {"11.1", 65276, 2252}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1516, 28, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2141, 55, 72, 2, 70, "Title",
 CellTags->{"S3.7.11", "11.1"},
 CellID->20229],
Cell[2216, 59, 401, 13, 70, "Text",
 CellID->19298],
Cell[2620, 74, 1101, 34, 70, "DefinitionBox",
 CellID->29356],
Cell[3724, 110, 67, 1, 70, "Caption",
 CellID->5470],
Cell[3794, 113, 576, 16, 70, "Text",
 CellID->23175],
Cell[4373, 131, 315, 10, 70, "Text",
 CellID->24196],
Cell[4691, 143, 636, 15, 70, "Text",
 CellID->1683],
Cell[5330, 160, 3998, 127, 70, "DefinitionBox",
 CellID->9988],
Cell[9331, 289, 103, 3, 70, "Caption",
 CellID->7619],
Cell[9437, 294, 62, 1, 70, "MathCaption",
 CellID->2946],
Cell[CellGroupData[{
Cell[9524, 299, 374, 13, 70, "Input",
 CellID->32190],
Cell[9901, 314, 641, 23, 36, "Output",
 CellID->1115807728]
}, Open  ]],
Cell[10557, 340, 86, 1, 70, "MathCaption",
 CellID->2469],
Cell[CellGroupData[{
Cell[10668, 345, 274, 10, 70, "Input",
 CellID->25519],
Cell[10945, 357, 641, 23, 36, "Output",
 CellID->1284210391]
}, Open  ]],
Cell[11601, 383, 320, 8, 70, "MathCaption",
 CellID->26197],
Cell[CellGroupData[{
Cell[11946, 395, 101, 3, 28, "Input",
 CellID->8545],
Cell[12050, 400, 1143, 23, 94, "Output",
 Evaluatable->False,
 CellID->894008711]
}, Open  ]],
Cell[13208, 426, 213, 7, 70, "MathCaption",
 CellID->7158],
Cell[CellGroupData[{
Cell[13446, 437, 102, 3, 70, "Input",
 CellID->14058],
Cell[13551, 442, 213, 7, 36, "Output",
 CellID->318244720]
}, Open  ]],
Cell[13779, 452, 161, 6, 70, "MathCaption",
 CellID->23791],
Cell[CellGroupData[{
Cell[13965, 462, 150, 5, 70, "Input",
 CellID->13341],
Cell[14118, 469, 159, 5, 36, "Output",
 CellID->1505361643]
}, Open  ]],
Cell[14292, 477, 208, 7, 70, "MathCaption",
 CellID->28900],
Cell[CellGroupData[{
Cell[14525, 488, 102, 3, 70, "Input",
 CellID->13232],
Cell[14630, 493, 159, 5, 36, "Output",
 CellID->1498662102]
}, Open  ]],
Cell[14804, 501, 195, 4, 70, "Text",
 CellID->19736],
Cell[15002, 507, 3832, 120, 70, "DefinitionBox",
 CellID->17438],
Cell[18837, 629, 66, 1, 70, "Caption",
 CellID->9958],
Cell[18906, 632, 854, 24, 70, "Text",
 CellID->30580],
Cell[19763, 658, 1479, 52, 70, "Text",
 CellID->27085],
Cell[21245, 712, 742, 25, 70, "Text",
 CellID->15013],
Cell[21990, 739, 107, 3, 70, "MathCaption",
 CellID->5284],
Cell[CellGroupData[{
Cell[22122, 746, 259, 9, 70, "Input",
 CellID->5253],
Cell[22384, 757, 325, 11, 36, "Output",
 CellID->848895940]
}, Open  ]],
Cell[22724, 771, 449, 14, 70, "MathCaption",
 CellID->30285],
Cell[CellGroupData[{
Cell[23198, 789, 124, 4, 70, "Input",
 CellID->2426],
Cell[23325, 795, 365, 13, 36, "Output",
 CellID->1809716148]
}, Open  ]],
Cell[23705, 811, 377, 13, 70, "MathCaption",
 CellID->14536],
Cell[CellGroupData[{
Cell[24107, 828, 271, 10, 70, "Input",
 CellID->3281],
Cell[24381, 840, 206, 7, 36, "Output",
 CellID->1051263691]
}, Open  ]],
Cell[24602, 850, 70, 1, 70, "MathCaption",
 CellID->6549],
Cell[CellGroupData[{
Cell[24697, 855, 215, 7, 28, "Input",
 CellID->1348],
Cell[24915, 864, 1575, 30, 71, "Output",
 Evaluatable->False,
 CellID->536289419]
}, Open  ]],
Cell[26505, 897, 157, 5, 70, "MathCaption",
 CellID->26199],
Cell[CellGroupData[{
Cell[26687, 906, 127, 4, 28, "Input",
 CellID->16835],
Cell[26817, 912, 1420, 27, 71, "Output",
 Evaluatable->False,
 CellID->668478255]
}, Open  ]],
Cell[28252, 942, 71, 1, 70, "MathCaption",
 CellID->28137],
Cell[CellGroupData[{
Cell[28348, 947, 104, 3, 70, "Input",
 CellID->8351],
Cell[28455, 952, 225, 7, 36, "Output",
 CellID->1826036879]
}, Open  ]],
Cell[28695, 962, 315, 9, 70, "Text",
 CellID->27617],
Cell[29013, 973, 180, 4, 70, "MathCaption",
 CellID->5233],
Cell[CellGroupData[{
Cell[29218, 981, 305, 10, 70, "Input",
 CellID->30571],
Cell[29526, 993, 408, 13, 36, "Output",
 CellID->2016095630]
}, Open  ]],
Cell[29949, 1009, 81, 1, 70, "MathCaption",
 CellID->25529],
Cell[CellGroupData[{
Cell[30055, 1014, 295, 10, 70, "Input",
 CellID->17731],
Cell[30353, 1026, 575, 19, 36, "Output",
 CellID->568085610]
}, Open  ]],
Cell[30943, 1048, 219, 8, 70, "Text",
 CellID->20342],
Cell[31165, 1058, 89, 1, 70, "MathCaption",
 CellID->16467],
Cell[CellGroupData[{
Cell[31279, 1063, 212, 7, 70, "Input",
 CellID->30000],
Cell[31494, 1072, 379, 12, 36, "Output",
 CellID->1304443250]
}, Open  ]],
Cell[31888, 1087, 112, 3, 70, "MathCaption",
 CellID->30916],
Cell[CellGroupData[{
Cell[32025, 1094, 245, 9, 70, "Input",
 CellID->12634],
Cell[32273, 1105, 408, 13, 36, "Output",
 CellID->1085989644]
}, Open  ]],
Cell[32696, 1121, 93, 1, 70, "MathCaption",
 CellID->17757],
Cell[CellGroupData[{
Cell[32814, 1126, 256, 9, 70, "Input",
 CellID->29240],
Cell[33073, 1137, 1005, 31, 54, "Output",
 CellID->1050542205]
}, Open  ]],
Cell[34093, 1171, 247, 5, 70, "Text",
 CellID->13623],
Cell[34343, 1178, 923, 30, 70, "Text",
 CellID->15941],
Cell[35269, 1210, 205, 5, 70, "MathCaption",
 CellID->7131],
Cell[CellGroupData[{
Cell[35499, 1219, 231, 8, 70, "Input",
 CellID->15749],
Cell[35733, 1229, 539, 19, 36, "Output",
 CellID->658081649]
}, Open  ]],
Cell[36287, 1251, 235, 6, 70, "MathCaption",
 CellID->9299],
Cell[CellGroupData[{
Cell[36547, 1261, 241, 8, 70, "Input",
 CellID->25575],
Cell[36791, 1271, 717, 25, 36, "Output",
 CellID->1728835756]
}, Open  ]],
Cell[37523, 1299, 235, 6, 70, "MathCaption",
 CellID->14363],
Cell[CellGroupData[{
Cell[37783, 1309, 353, 12, 28, "Input",
 CellID->13245],
Cell[38139, 1323, 1281, 25, 54, "Output",
 Evaluatable->False,
 CellID->34837119]
}, Open  ]],
Cell[39435, 1351, 76, 1, 70, "MathCaption",
 CellID->201],
Cell[CellGroupData[{
Cell[39536, 1356, 102, 3, 70, "Input",
 CellID->6424],
Cell[39641, 1361, 214, 7, 36, "Output",
 CellID->757871917]
}, Open  ]],
Cell[39870, 1371, 1131, 35, 70, "Text",
 CellID->7389],
Cell[41004, 1408, 1400, 52, 70, "Text",
 CellID->20735],
Cell[42407, 1462, 478, 16, 70, "Text",
 CellID->22024],
Cell[42888, 1480, 571, 18, 70, "Text",
 CellID->18895],
Cell[43462, 1500, 1965, 65, 70, "Text",
 CellID->28745],
Cell[45430, 1567, 906, 29, 70, "Text",
 CellID->6170],
Cell[46339, 1598, 121, 3, 70, "MathCaption",
 CellID->11483],
Cell[CellGroupData[{
Cell[46485, 1605, 262, 8, 70, "Input",
 CellID->28717],
Cell[46750, 1615, 385, 13, 36, "Output",
 CellID->133051129]
}, Open  ]],
Cell[47150, 1631, 88, 1, 70, "MathCaption",
 CellID->28752],
Cell[CellGroupData[{
Cell[47263, 1636, 451, 16, 70, "Input",
 CellID->11324],
Cell[47717, 1654, 1030, 35, 36, "Output",
 CellID->46685011]
}, Open  ]],
Cell[48762, 1692, 63, 1, 70, "MathCaption",
 CellID->27740],
Cell[CellGroupData[{
Cell[48850, 1697, 226, 8, 28, "Input",
 CellID->18255],
Cell[49079, 1707, 640, 15, 36, "Output",
 Evaluatable->False,
 CellID->105083754]
}, Open  ]],
Cell[49734, 1725, 63, 1, 70, "MathCaption",
 CellID->22070],
Cell[CellGroupData[{
Cell[49822, 1730, 226, 8, 70, "Input",
 CellID->16843],
Cell[50051, 1740, 479, 17, 36, "Output",
 CellID->131020728]
}, Open  ]],
Cell[50545, 1760, 68, 1, 70, "MathCaption",
 CellID->15756],
Cell[CellGroupData[{
Cell[50638, 1765, 89, 3, 28, "Input",
 CellID->10765],
Cell[50730, 1770, 888, 19, 54, "Output",
 Evaluatable->False,
 CellID->440383872]
}, Open  ]],
Cell[51633, 1792, 77, 1, 70, "MathCaption",
 CellID->2980],
Cell[CellGroupData[{
Cell[51735, 1797, 102, 3, 70, "Input",
 CellID->1458],
Cell[51840, 1802, 225, 7, 36, "Output",
 CellID->1442423181]
}, Open  ]],
Cell[52080, 1812, 661, 17, 70, "Text",
 CellID->8124],
Cell[52744, 1831, 628, 22, 70, "Text",
 CellID->6008],
Cell[53375, 1855, 3141, 104, 70, "DefinitionBox",
 CellID->25311],
Cell[56519, 1961, 106, 3, 70, "Caption",
 CellID->6667],
Cell[56628, 1966, 36, 1, 70, "Text",
 CellID->186700374],
Cell[56667, 1969, 100, 2, 70, "MathCaption",
 CellID->21717],
Cell[CellGroupData[{
Cell[56792, 1975, 335, 12, 70, "Input",
 CellID->15928],
Cell[57130, 1989, 1011, 35, 36, "Output",
 CellID->292112533]
}, Open  ]],
Cell[58156, 2027, 115, 3, 70, "MathCaption",
 CellID->31099],
Cell[CellGroupData[{
Cell[58296, 2034, 344, 12, 70, "Input",
 CellID->4580],
Cell[58643, 2048, 766, 28, 36, "Output",
 CellID->673285511]
}, Open  ]],
Cell[59424, 2079, 1118, 37, 70, "DefinitionBox",
 CellID->354449619],
Cell[60545, 2118, 64, 1, 70, "Caption",
 CellID->94639404],
Cell[60612, 2121, 171, 4, 70, "MathCaption",
 CellID->125579525],
Cell[CellGroupData[{
Cell[60808, 2129, 711, 25, 28, "Input",
 CellID->55097366],
Cell[61522, 2156, 582, 13, 74, "Output",
 Evaluatable->False,
 CellID->9028693]
}, Open  ]],
Cell[62119, 2172, 102, 2, 70, "MathCaption",
 CellID->827898695],
Cell[CellGroupData[{
Cell[62246, 2178, 145, 4, 28, "Input",
 CellID->116341345],
Cell[62394, 2184, 580, 13, 78, "Output",
 Evaluatable->False,
 CellID->527995899]
}, Open  ]]
}, Open  ]],
Cell[63001, 2201, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

