(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15327,        557]
NotebookOptionsPosition[     10535,        410]
NotebookOutlinePosition[     13390,        482]
CellTagsIndexPosition[     13299,        476]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/ListsOverview"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Lists\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Count" :> Documentation`HelpLookup["paclet:ref/Count"], 
          "FreeQ" :> Documentation`HelpLookup["paclet:ref/FreeQ"], "MemberQ" :> 
          Documentation`HelpLookup["paclet:ref/MemberQ"], "Position" :> 
          Documentation`HelpLookup["paclet:ref/Position"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Count\"\>", 2->"\<\"FreeQ\"\>", 
       3->"\<\"MemberQ\"\>", 4->"\<\"Position\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Testing and Searching List Elements", "Title",
 CellTags->{"S1.8.5", "5.1"},
 CellID->20084],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Position",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Position"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["form", "TI"], "]"}], Cell[TextData[{
     "the positions at which ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"],
     " occurs in ",
     StyleBox["list", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Count",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Count"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["form", "TI"], "]"}], Cell[TextData[{
     "the number of times ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"],
     " appears as an element of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MemberQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MemberQ"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["form", "TI"], "]"}], Cell[TextData[{
     "test whether ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"],
     " is an element of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FreeQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FreeQ"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["form", "TI"], "]"}], Cell[TextData[{
     "test whether ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"],
     " occurs nowhere in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->19682],

Cell["Testing and searching for elements of lists. ", "Caption",
 CellID->17911],

Cell[TextData[{
 "\"",
 ButtonBox["Getting Pieces of Lists",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GettingPiecesOfLists"],
 "\" discusses how to extract pieces of lists based on their positions or \
indices. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " also has functions that search and test for elements of lists, based on \
the values of those elements. "
}], "Text",
 CellID->20106],

Cell[TextData[{
 "This gives a list of the positions at which ",
 Cell[BoxData["a"], "InlineFormula"],
 " appears in the list. "
}], "MathCaption",
 CellID->9868],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Position", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "a", ",", "b"}], "}"}], ",", "a"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->8644],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", "4", "}"}]}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->23826]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Count",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Count"]], "InlineFormula"],
 " counts the number of occurrences of ",
 Cell[BoxData["a"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->16436],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Count", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "a", ",", "b"}], "}"}], ",", "a"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->17366],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->11592]
}, Open  ]],

Cell[TextData[{
 "This shows that ",
 Cell[BoxData["a"], "InlineFormula"],
 " is an element of ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->24988],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MemberQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "a"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->18838],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->15865]
}, Open  ]],

Cell[TextData[{
 "On the other hand, ",
 Cell[BoxData["d"], "InlineFormula"],
 " is not. "
}], "MathCaption",
 CellID->27212],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MemberQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "d"}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->23947],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->7446]
}, Open  ]],

Cell[TextData[{
 "This assigns ",
 Cell[BoxData["m"], "InlineFormula"],
 " to be the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"3", "\[Cross]", "3"}], TraditionalForm]], "InlineMath"],
 " identity matrix. "
}], "MathCaption",
 CellID->19659],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"IdentityMatrix", "[", "3", "]"}]}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->1052],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->5771]
}, Open  ]],

Cell[TextData[{
 "This shows that ",
 Cell[BoxData["0"], "InlineFormula"],
 " does occur ",
 StyleBox["somewhere",
  FontSlant->"Italic"],
 " in ",
 Cell[BoxData["m"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->21256],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FreeQ", "[", 
  RowBox[{"m", ",", "0"}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->11110],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->32057]
}, Open  ]],

Cell[TextData[{
 "This gives a list of the positions at which ",
 Cell[BoxData["0"], "InlineFormula"],
 " occurs in ",
 Cell[BoxData["m"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->10666],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Position", "[", 
  RowBox[{"m", ",", "0"}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->26250],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{310, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->12670]
}, Open  ]],

Cell[TextData[{
 "As discussed in \"",
 ButtonBox["Finding Expressions That Match a Pattern",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/FindingExpressionsThatMatchAPattern"],
 "\", the functions ",
 Cell[BoxData[
  ButtonBox["Count",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Count"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Position",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Position"]], "InlineFormula"],
 ", as well as ",
 Cell[BoxData[
  ButtonBox["MemberQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MemberQ"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FreeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FreeQ"]], "InlineFormula"],
 ", can be used not only to search for ",
 StyleBox["particular",
  FontSlant->"Italic"],
 " list elements, but also to search for classes of elements which match \
specific \[OpenCurlyDoubleQuote]patterns\[CloseCurlyDoubleQuote]. "
}], "Text",
 CellID->13145],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->385586568],

Cell[TextData[ButtonBox["Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ListsOverview"]], "RelatedTutorials",
 CellID->27407539]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Testing and Searching List Elements - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Lists", "OverviewNavText"], BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/ListsOverview"]], "Text", FontFamily -> "Verdana"], 
    "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/GettingPiecesOfLists"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/AddingRemovingAndModifyingListElements"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 24.5612296}", "context" -> "", 
    "keywords" -> {
     "absent from list", "count", "FreeQ", "independence", "indices", "lists",
       "MemberQ", "membership test", "multiplicity", "number of occurrences", 
      "parts", "position", "present", "search"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Testing and searching for elements of lists. \"Getting Pieces of Lists\" \
discusses how to extract pieces of lists based on their positions or indices. \
Mathematica also has functions that search and test for elements of lists, \
based on the values of those elements. This gives a list of the positions at \
which a appears in the list. ", "synonyms" -> {"1.8.5"}, "title" -> 
    "Testing and Searching List Elements", "type" -> "Tutorial", "uri" -> 
    "tutorial/TestingAndSearchingListElements"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.8.5"->{
  Cell[2019, 60, 98, 2, 70, "Title",
   CellTags->{"S1.8.5", "5.1"},
   CellID->20084]},
 "5.1"->{
  Cell[2019, 60, 98, 2, 70, "Title",
   CellTags->{"S1.8.5", "5.1"},
   CellID->20084]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.8.5", 13088, 465},
 {"5.1", 13187, 469}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1394, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2019, 60, 98, 2, 70, "Title",
 CellTags->{"S1.8.5", "5.1"},
 CellID->20084],
Cell[2120, 64, 1977, 64, 70, "DefinitionBox",
 CellID->19682],
Cell[4100, 130, 80, 1, 70, "Caption",
 CellID->17911],
Cell[4183, 133, 410, 12, 70, "Text",
 CellID->20106],
Cell[4596, 147, 162, 5, 70, "MathCaption",
 CellID->9868],
Cell[CellGroupData[{
Cell[4783, 156, 205, 7, 28, "Input",
 CellID->8644],
Cell[4991, 165, 248, 9, 36, "Output",
 CellID->23826]
}, Open  ]],
Cell[5254, 177, 249, 9, 70, "MathCaption",
 CellID->16436],
Cell[CellGroupData[{
Cell[5528, 190, 203, 7, 28, "Input",
 CellID->17366],
Cell[5734, 199, 155, 5, 36, "Output",
 CellID->11592]
}, Open  ]],
Cell[5904, 207, 233, 9, 70, "MathCaption",
 CellID->24988],
Cell[CellGroupData[{
Cell[6162, 220, 182, 6, 70, "Input",
 CellID->18838],
Cell[6347, 228, 158, 5, 36, "Output",
 CellID->15865]
}, Open  ]],
Cell[6520, 236, 125, 5, 70, "MathCaption",
 CellID->27212],
Cell[CellGroupData[{
Cell[6670, 245, 182, 6, 70, "Input",
 CellID->23947],
Cell[6855, 253, 158, 5, 36, "Output",
 CellID->7446]
}, Open  ]],
Cell[7028, 261, 239, 9, 70, "MathCaption",
 CellID->19659],
Cell[CellGroupData[{
Cell[7292, 274, 129, 4, 70, "Input",
 CellID->1052],
Cell[7424, 280, 387, 13, 36, "Output",
 CellID->5771]
}, Open  ]],
Cell[7826, 296, 226, 10, 70, "MathCaption",
 CellID->21256],
Cell[CellGroupData[{
Cell[8077, 310, 121, 4, 70, "Input",
 CellID->11110],
Cell[8201, 316, 159, 5, 36, "Output",
 CellID->32057]
}, Open  ]],
Cell[8375, 324, 197, 7, 70, "MathCaption",
 CellID->10666],
Cell[CellGroupData[{
Cell[8597, 335, 124, 4, 70, "Input",
 CellID->26250],
Cell[8724, 341, 535, 19, 36, "Output",
 CellID->12670]
}, Open  ]],
Cell[9274, 363, 968, 31, 70, "Text",
 CellID->13145],
Cell[CellGroupData[{
Cell[10267, 398, 72, 1, 70, "RelatedTutorialsSection",
 CellID->385586568],
Cell[10342, 401, 139, 3, 70, "RelatedTutorials",
 CellID->27407539]
}, Open  ]]
}, Open  ]],
Cell[10508, 408, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

