(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13376,        434]
NotebookOptionsPosition[      8986,        306]
NotebookOutlinePosition[     11786,        377]
CellTagsIndexPosition[     11694,        371]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"The Internals of Mathematica" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/TheInternalsOfMathematicaOverview"], 
         "Basic Internal Architecture" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/BasicInternalArchitecture"], 
         "The Algorithms of Mathematica" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/TheAlgorithmsOfMathematica"], 
         "The Software Engineering of Mathematica" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/TheSoftwareEngineeringOfMathematica"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"The Internals of Mathematica\"\>", 
      2->"\<\"Basic Internal Architecture\"\>", 
      3->"\<\"The Algorithms of Mathematica\"\>", 
      4->"\<\"The Software Engineering of Mathematica\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Testing and Verification", "Title",
 CellTags->{"S1.12.5", "5.1"},
 CellID->3925],

Cell[TextData[{
 "Every version of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is subjected to a large amount of testing before it is released. The vast \
majority of this testing is done by an automated system that is written in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->31148],

Cell[TextData[{
 "The automated system feeds millions of pieces of input to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", and checks that the output obtained from them is correct. Often there is \
some subtlety in doing such checking: one must account for different behavior \
of randomized algorithms and for such issues as differences in machine\
\[Hyphen]precision arithmetic on different computers. "
}], "Text",
 CellID->5874],

Cell["\<\
The test inputs used by the automated system are obtained in several ways: \
\>", "Text",
 CellID->25774],

Cell[TextData[{
 "For every ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function, inputs are devised that exercise both common and extreme cases."
}], "Notes",
 CellID->7043],

Cell["\<\
Inputs are devised to exercise each feature of the internal code.\
\>", "Notes",
 CellID->219619824],

Cell[TextData[{
 "All the examples in ",
 StyleBox["Mathematica'",
  FontSlant->"Italic"],
 "s documentation system are used, as well as those from many books about ",
 StyleBox["Mathematica.",
  FontSlant->"Italic"]
}], "Notes",
 CellID->256496333],

Cell["\<\
Tests are constructed from mathematical benchmarks and test sets from \
numerous websites.\
\>", "Notes",
 CellID->149593255],

Cell["\<\
Standard numerical tables are optically scanned for test inputs.\
\>", "Notes",
 CellID->121997404],

Cell["Formulas from standard mathematical tables are entered.", "Notes",
 CellID->21928586],

Cell["Exercises from textbooks are entered.", "Notes",
 CellID->70209438],

Cell[TextData[{
 "For pairs of functions such as ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/D"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 ", random expressions are generated and tested."
}], "Notes",
 CellID->820663401],

Cell["\<\
When tests are run, the automated testing system checks not only the results, \
but also side effects such as messages, as well as memory usage and speed. \
\>", "Text",
 CellID->9429],

Cell[TextData[{
 "There is also a special instrumented version of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " which is set up to perform internal consistency tests. This version of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " runs at a small fraction of the speed of the real ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", but at every step it checks internal memory consistency, \
interruptibility, and so on. "
}], "Text",
 CellID->5536],

Cell[TextData[{
 "The instrumented version of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " also records which pieces of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " source code have been accessed, allowing one to confirm that all of the \
various internal functions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " have been exercised by the tests given. "
}], "Text",
 CellID->6763],

Cell[TextData[{
 "All standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " tests are routinely run on current versions of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", on each different computer system. Depending on the speed of the computer \
system, these tests take from a few hours to a few days of computer time. "
}], "Text",
 CellID->20016],

Cell[TextData[{
 "Even with all this testing, however, it is inevitable in a system as \
complex as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " that errors will remain. "
}], "Text",
 CellID->23934],

Cell[TextData[{
 "The standards of correctness for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are certainly much higher than for typical mathematical proofs. But just \
as long proofs will inevitably contain errors that go undetected for many \
years, so also a complex software system such as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will contain errors that go undetected even after millions of people have \
used it. "
}], "Text",
 CellID->7301],

Cell[TextData[{
 "Nevertheless, particularly after all the testing that has been done on it, \
the probability that you will actually discover an error in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in the course of your work is extremely low. "
}], "Text",
 CellID->2061],

Cell[TextData[{
 "Doubtless there will be times when ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does things you do not expect. But you should realize that the \
probabilities are such that it is vastly more likely that there is something \
wrong with your input to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " or your understanding of what is happening than with the internal code of \
the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system itself. "
}], "Text",
 CellID->32655],

Cell[TextData[{
 "If you do believe that you have found a genuine error in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", then you should contact Wolfram Research Technical Support, so that the \
error can be corrected in future versions. "
}], "Text",
 CellID->3815],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->197496534],

Cell[TextData[{
 ButtonBox["The Internals of ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheInternalsOfMathematicaOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheInternalsOfMathematicaOverview"],
  FontSlant->"Italic"]
}], "RelatedTutorials",
 CellID->666254040],

Cell[TextData[ButtonBox["Basic Internal Architecture",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BasicInternalArchitecture"]], "RelatedTutorials",\

 CellID->255800466],

Cell[TextData[{
 ButtonBox["The Algorithms of ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheAlgorithmsOfMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheAlgorithmsOfMathematica"],
  FontSlant->"Italic"]
}], "RelatedTutorials",
 CellID->820035495],

Cell[TextData[{
 ButtonBox["The Software Engineering of ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheSoftwareEngineeringOfMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheSoftwareEngineeringOfMathematica"],
  FontSlant->"Italic"]
}], "RelatedTutorials",
 CellID->889871574]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Testing and Verification - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["The Internals of Mathematica", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/TheInternalsOfMathematicaOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/TheSoftwareEngineeringOfMathematica"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 25.0612424}", "context" -> "", 
    "keywords" -> {
     "bugs", "defects", "errors", "proofs", "quality assurance", "testing", 
      "textbooks", "verification"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Every version of Mathematica is subjected to a large amount of testing \
before it is released. The vast majority of this testing is done by an \
automated system that is written in Mathematica. The automated system feeds \
millions of pieces of input to Mathematica, and checks that the output \
obtained from them is correct. Often there is some subtlety in doing such \
checking: one must account for different behavior of randomized algorithms \
and for such issues as differences in machine-precision arithmetic on \
different computers. The test inputs used by the automated system are \
obtained in several ways: ", "synonyms" -> {"1.12.5"}, "title" -> 
    "Testing and Verification", "type" -> "Tutorial", "uri" -> 
    "tutorial/TestingAndVerification"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.12.5"->{
  Cell[1868, 55, 87, 2, 70, "Title",
   CellTags->{"S1.12.5", "5.1"},
   CellID->3925]},
 "5.1"->{
  Cell[1868, 55, 87, 2, 70, "Title",
   CellTags->{"S1.12.5", "5.1"},
   CellID->3925]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.12.5", 11483, 360},
 {"5.1", 11582, 364}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1243, 28, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1868, 55, 87, 2, 70, "Title",
 CellTags->{"S1.12.5", "5.1"},
 CellID->3925],
Cell[1958, 59, 326, 10, 70, "Text",
 CellID->31148],
Cell[2287, 71, 441, 9, 70, "Text",
 CellID->5874],
Cell[2731, 82, 115, 3, 70, "Text",
 CellID->25774],
Cell[2849, 87, 185, 6, 70, "Notes",
 CellID->7043],
Cell[3037, 95, 110, 3, 70, "Notes",
 CellID->219619824],
Cell[3150, 100, 249, 8, 70, "Notes",
 CellID->256496333],
Cell[3402, 110, 135, 4, 70, "Notes",
 CellID->149593255],
Cell[3540, 116, 109, 3, 70, "Notes",
 CellID->121997404],
Cell[3652, 121, 91, 1, 70, "Notes",
 CellID->21928586],
Cell[3746, 124, 73, 1, 70, "Notes",
 CellID->70209438],
Cell[3822, 127, 619, 23, 70, "Notes",
 CellID->820663401],
Cell[4444, 152, 194, 4, 70, "Text",
 CellID->9429],
Cell[4641, 158, 469, 13, 70, "Text",
 CellID->5536],
Cell[5113, 173, 412, 13, 70, "Text",
 CellID->6763],
Cell[5528, 188, 368, 10, 70, "Text",
 CellID->20016],
Cell[5899, 200, 209, 7, 70, "Text",
 CellID->23934],
Cell[6111, 209, 474, 12, 70, "Text",
 CellID->7301],
Cell[6588, 223, 283, 7, 70, "Text",
 CellID->2061],
Cell[6874, 232, 511, 15, 70, "Text",
 CellID->32655],
Cell[7388, 249, 276, 7, 70, "Text",
 CellID->3815],
Cell[CellGroupData[{
Cell[7689, 260, 72, 1, 70, "RelatedTutorialsSection",
 CellID->197496534],
Cell[7764, 263, 327, 9, 70, "RelatedTutorials",
 CellID->666254040],
Cell[8094, 274, 176, 4, 70, "RelatedTutorials",
 CellID->255800466],
Cell[8273, 280, 314, 9, 70, "RelatedTutorials",
 CellID->820035495],
Cell[8590, 291, 342, 9, 70, "RelatedTutorials",
 CellID->889871574]
}, Open  ]]
}, Open  ]],
Cell[8959, 304, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

