(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16604,        578]
NotebookOptionsPosition[      9081,        334]
NotebookOutlinePosition[     14192,        491]
CellTagsIndexPosition[     13885,        476]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"System Administration for Network Licenses" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"], 
         "System Administration for Single-User Licenses" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]\
}, #, 2]& , Evaluator -> Automatic], {
      1->"\<\"System Administration for Network Licenses\"\>", 
      2->"\<\"System Administration for Single-User Licenses\"\>"}, \
"\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Testing the Installation on Unix and Linux", "Title",
 CellTags->{"b:6.1.2", "net: 1", "i:2"},
 CellID->182858847],

Cell[TextData[{
 "The following simple commands allow you to test the installation of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Running these commands does not guarantee that the installation was \
successful, but a failed command can indicate that a serious problem \
occurred",
 " ",
 "during installation. "
}], "Text",
 CellTags->"b:6.1.2",
 CellID->90234623],

Cell["\<\
You should run these tests from a regular user account and not from an \
account with administrator privileges.\
\>", "Text",
 CellTags->"b:5.1.2",
 CellID->84716422],

Cell[TextData[{
 "To run ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " using a network license, both the client machine and the license server \
must be on the network and ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " must be running."
}], "Text",
 CellTags->"b:3.2",
 CellID->20351388],

Cell[TextData[{
 "If you run into problems when doing these tests, see the troubleshooting \
tips in \"",
 ButtonBox["Troubleshooting on Unix and Linux",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TroubleshootingOnUnixAndLinux"],
 "\". If you do not find the answer there, check the Technical Support \
website at ",
 ButtonBox["support.wolfram.com/mathematica",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://support.wolfram.com/mathematica"], None}],
 "."
}], "Text",
 CellTags->"b:6.1.2",
 CellID->69228029],

Cell[CellGroupData[{

Cell["To test the kernel:", "Section",
 CellTags->{"b:6.1.0", "net: 1", "i:3"},
 CellID->683200403],

Cell[CellGroupData[{

Cell[TextData[{
 "To start the kernel, type ",
 StyleBox["math", "InlineCode"],
 " in a shell and press ",
 StyleBox["Enter", "KeyEvent"],
 "."
}], "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:6.1.0",
 CellID->342157],

Cell["In[1]:=", "Program",
 CellTags->"b:6.1.0",
 CellID->486411838]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Type ",
 StyleBox["N[Pi, 20]", "InlineCode"],
 " and press ",
 StyleBox["Enter", "KeyEvent"],
 ". The number in the output should match the output shown here."
}], "ItemizedText",
 CellTags->"b:6.1.0",
 CellID->101546744],

Cell["\<\
In[1]:= N[Pi, 20]

Out[1]= 3.1415926535897932385

In[2]:=\
\>", "Program",
 CellTags->"b:6.1.0",
 CellID->483558517]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "To exit the kernel, type ",
 StyleBox["Exit", "InlineCode"],
 " and press ",
 StyleBox["Enter", "KeyEvent"],
 "."
}], "ItemizedText",
 CellTags->"b:6.1.0",
 CellID->23863421],

Cell[TextData[{
 "On Unix and Linux, you can test the kernel on a remote machine by using the \
command ",
 StyleBox["ssh ", "InlineCode"],
 StyleBox["hostname", "TI"],
 StyleBox[" /usr/local/bin/math", "InlineCode"],
 ". (The exact pathname could be different depending on how ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " was installed.) This command will launch the kernel on the remote \
machine",
 " ",
 StyleBox["hostname", "TI"],
 ". When you see the ",
 StyleBox["In[1]", "InlineCode"],
 " label, follow step 2 and step 3 in the previous instructions."
}], "Text",
 CellTags->{"b:6.1.0", "i:5"},
 CellID->971239363]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["To test the front end:", "Section",
 CellTags->{"b:6.1.1", "net: 1", "i:1"},
 CellID->156996419],

Cell[TextData[{
 "Make sure that you are running X. Launch ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by typing ",
 StyleBox["mathematica", "InlineCode"],
 " in a shell and pressing ",
 StyleBox["Enter", "KeyEvent"],
 "."
}], "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:6.1.1",
 CellID->173202688],

Cell["\<\
A splash screen with initialization information appears briefly, after which \
three windows appear. \
\>", "ItemizedTextParagraph",
 CellTags->"b:6.1.1",
 CellID->354502722],

Cell[TextData[{
 "Click anywhere inside the leftmost empty window. This window is a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook."
}], "ItemizedText",
 CellTags->"b:6.1.1",
 CellID->106878410],

Cell[TextData[{
 "Type ",
 StyleBox["N[Pi, 20]", "InlineCode"],
 ". Then hold down the ",
 StyleBox["Shift", "KeyEvent"],
 " key and press ",
 StyleBox["Enter", "KeyEvent"],
 " to evaluate. This should send the command to the kernel and return the \
same result as before. The ",
 StyleBox["In[1]", "InlineCode"],
 " and ",
 StyleBox["Out[1]", "InlineCode"],
 " labels are prepended once the evaluation is completed."
}], "ItemizedTextParagraph",
 CellTags->"b:6.1.1",
 CellID->14268243],

Cell["\<\
In the notebook window, there should be a horizontal line across the \
notebook; this is the horizontal insertion bar. If you do not see one, move \
the pointer until it becomes a horizontal I\[Hyphen]beam and click once to \
see the insertion bar.\
\>", "ItemizedTextParagraph",
 CellTags->"b:6.1.1",
 CellID->537465361],

Cell[TextData[{
 "Press the ",
 StyleBox["Esc", "KeyEvent"],
 " key. You should see three small horizontal lines in a column (\
\[AliasIndicator]). Type ",
 StyleBox["int", "InlineCode"],
 " and press ",
 StyleBox["Esc", "KeyEvent"],
 " again. You should see an integral sign (\[Integral]\[ThinSpace]). As an \
additional font check, typing ",
 StyleBox["\[Backslash][CheckmarkedBox]", "InlineCode"],
 " and ",
 StyleBox["\[Backslash][CirclePlus]", "InlineCode"],
 " should print the symbols ",
 StyleBox["\[CheckmarkedBox]", "InlineCode"],
 " and ",
 StyleBox["\[CirclePlus]", "InlineCode"],
 ", respectively. If the symbols show up correctly, the fonts have been \
properly installed."
}], "ItemizedText",
 CellTags->"b:6.1.1",
 CellID->489135226],

Cell[CellGroupData[{

Cell[TextData[{
 "From the ",
 StyleBox["Help", "MenuName"],
 " menu, choose ",
 StyleBox["Documentation Center", "MenuName"],
 ". The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ",
 "Documentation Center",
 " should appear."
}], "ItemizedText",
 CellTags->"b:6.1.1",
 CellID->168415509],

Cell[TextData[{
 "On Unix and Linux, you can test the X front end remotely, provided the ssh \
server on the remote machine allows X forwarding. You must be running X on \
the local machine to do this. In a shell, type ",
 StyleBox["ssh -X ", "InlineCode"],
 StyleBox["hostname", "TI"],
 StyleBox[" /usr/local/bin/math", "InlineCode"],
 ". (The exact pathname could be different depending on how ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " was installed.) This command will launch ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " on the remote machine ",
 StyleBox["hostname", "TI"],
 ". When the splash screen appears on your screen, follow step 2 and step 3",
 " ",
 "in the previous instructions."
}], "Text",
 CellTags->{"b:6.1.1", "i:4"},
 CellID->300808379]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->136784964],

Cell[TextData[ButtonBox["System Administration for Network Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]], \
"RelatedTutorials",
 CellID->13855348],

Cell[TextData[ButtonBox["System Administration for Single-User Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]], \
"RelatedTutorials",
 CellID->37939478]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Testing the Installation on Unix and Linux - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 25.6237568}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "The following simple commands allow you to test the installation of \
Mathematica. Running these commands does not guarantee that the installation \
was successful, but a failed command can indicate that a serious problem \
occurred during installation. You should run these tests from a regular user \
account and not from an account with administrator privileges. To run \
Mathematica using a network license, both the client machine and the license \
server must be on the network and MathLM must be running.", "synonyms" -> {}, 
    "title" -> "Testing the Installation on Unix and Linux", "type" -> 
    "Tutorial", "uri" -> "tutorial/TestingTheInstallationOnUnixAndLinux"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "b:6.1.2"->{
  Cell[1565, 48, 120, 2, 70, "Title",
   CellTags->{"b:6.1.2", "net: 1", "i:2"},
   CellID->182858847],
  Cell[1688, 52, 377, 11, 70, "Text",
   CellTags->"b:6.1.2",
   CellID->90234623],
  Cell[2624, 87, 530, 15, 70, "Text",
   CellTags->"b:6.1.2",
   CellID->69228029]},
 "net: 1"->{
  Cell[1565, 48, 120, 2, 70, "Title",
   CellTags->{"b:6.1.2", "net: 1", "i:2"},
   CellID->182858847],
  Cell[3179, 106, 99, 2, 70, "Section",
   CellTags->{"b:6.1.0", "net: 1", "i:3"},
   CellID->683200403],
  Cell[4938, 187, 102, 2, 70, "Section",
   CellTags->{"b:6.1.1", "net: 1", "i:1"},
   CellID->156996419]},
 "i:2"->{
  Cell[1565, 48, 120, 2, 70, "Title",
   CellTags->{"b:6.1.2", "net: 1", "i:2"},
   CellID->182858847]},
 "b:5.1.2"->{
  Cell[2068, 65, 176, 5, 70, "Text",
   CellTags->"b:5.1.2",
   CellID->84716422]},
 "b:3.2"->{
  Cell[2247, 72, 374, 13, 70, "Text",
   CellTags->"b:3.2",
   CellID->20351388]},
 "b:6.1.0"->{
  Cell[3179, 106, 99, 2, 70, "Section",
   CellTags->{"b:6.1.0", "net: 1", "i:3"},
   CellID->683200403],
  Cell[3303, 112, 246, 9, 70, "ItemizedText",
   CounterAssignments->{{"ItemizedList", 0}},
   CellTags->"b:6.1.0",
   CellID->342157],
  Cell[3552, 123, 68, 2, 70, "Program",
   CellTags->"b:6.1.0",
   CellID->486411838],
  Cell[3657, 130, 239, 8, 70, "ItemizedText",
   CellTags->"b:6.1.0",
   CellID->101546744],
  Cell[3899, 140, 126, 8, 70, "Program",
   CellTags->"b:6.1.0",
   CellID->483558517],
  Cell[4062, 153, 192, 8, 70, "ItemizedText",
   CellTags->"b:6.1.0",
   CellID->23863421],
  Cell[4257, 163, 632, 18, 70, "Text",
   CellTags->{"b:6.1.0", "i:5"},
   CellID->971239363]},
 "i:3"->{
  Cell[3179, 106, 99, 2, 70, "Section",
   CellTags->{"b:6.1.0", "net: 1", "i:3"},
   CellID->683200403]},
 "i:5"->{
  Cell[4257, 163, 632, 18, 70, "Text",
   CellTags->{"b:6.1.0", "i:5"},
   CellID->971239363]},
 "b:6.1.1"->{
  Cell[4938, 187, 102, 2, 70, "Section",
   CellTags->{"b:6.1.1", "net: 1", "i:1"},
   CellID->156996419],
  Cell[5043, 191, 339, 12, 70, "ItemizedText",
   CounterAssignments->{{"ItemizedList", 0}},
   CellTags->"b:6.1.1",
   CellID->173202688],
  Cell[5385, 205, 184, 5, 70, "ItemizedTextParagraph",
   CellTags->"b:6.1.1",
   CellID->354502722],
  Cell[5572, 212, 211, 7, 70, "ItemizedText",
   CellTags->"b:6.1.1",
   CellID->106878410],
  Cell[5786, 221, 487, 15, 70, "ItemizedTextParagraph",
   CellTags->"b:6.1.1",
   CellID->14268243],
  Cell[6276, 238, 331, 7, 70, "ItemizedTextParagraph",
   CellTags->"b:6.1.1",
   CellID->537465361],
  Cell[6610, 247, 749, 21, 70, "ItemizedText",
   CellTags->"b:6.1.1",
   CellID->489135226],
  Cell[7384, 272, 298, 13, 70, "ItemizedText",
   CellTags->"b:6.1.1",
   CellID->168415509],
  Cell[7685, 287, 780, 20, 70, "Text",
   CellTags->{"b:6.1.1", "i:4"},
   CellID->300808379]},
 "i:1"->{
  Cell[4938, 187, 102, 2, 70, "Section",
   CellTags->{"b:6.1.1", "net: 1", "i:1"},
   CellID->156996419]},
 "i:4"->{
  Cell[7685, 287, 780, 20, 70, "Text",
   CellTags->{"b:6.1.1", "i:4"},
   CellID->300808379]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"b:6.1.2", 10847, 373},
 {"net: 1", 11133, 383},
 {"i:2", 11461, 393},
 {"b:5.1.2", 11580, 397},
 {"b:3.2", 11676, 401},
 {"b:6.1.0", 11773, 405},
 {"i:3", 12481, 428},
 {"i:5", 12598, 432},
 {"b:6.1.1", 12708, 436},
 {"i:1", 13648, 465},
 {"i:4", 13766, 469}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 940, 21, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1565, 48, 120, 2, 70, "Title",
 CellTags->{"b:6.1.2", "net: 1", "i:2"},
 CellID->182858847],
Cell[1688, 52, 377, 11, 70, "Text",
 CellTags->"b:6.1.2",
 CellID->90234623],
Cell[2068, 65, 176, 5, 70, "Text",
 CellTags->"b:5.1.2",
 CellID->84716422],
Cell[2247, 72, 374, 13, 70, "Text",
 CellTags->"b:3.2",
 CellID->20351388],
Cell[2624, 87, 530, 15, 70, "Text",
 CellTags->"b:6.1.2",
 CellID->69228029],
Cell[CellGroupData[{
Cell[3179, 106, 99, 2, 70, "Section",
 CellTags->{"b:6.1.0", "net: 1", "i:3"},
 CellID->683200403],
Cell[CellGroupData[{
Cell[3303, 112, 246, 9, 70, "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:6.1.0",
 CellID->342157],
Cell[3552, 123, 68, 2, 70, "Program",
 CellTags->"b:6.1.0",
 CellID->486411838]
}, Open  ]],
Cell[CellGroupData[{
Cell[3657, 130, 239, 8, 70, "ItemizedText",
 CellTags->"b:6.1.0",
 CellID->101546744],
Cell[3899, 140, 126, 8, 70, "Program",
 CellTags->"b:6.1.0",
 CellID->483558517]
}, Open  ]],
Cell[CellGroupData[{
Cell[4062, 153, 192, 8, 70, "ItemizedText",
 CellTags->"b:6.1.0",
 CellID->23863421],
Cell[4257, 163, 632, 18, 70, "Text",
 CellTags->{"b:6.1.0", "i:5"},
 CellID->971239363]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4938, 187, 102, 2, 70, "Section",
 CellTags->{"b:6.1.1", "net: 1", "i:1"},
 CellID->156996419],
Cell[5043, 191, 339, 12, 70, "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:6.1.1",
 CellID->173202688],
Cell[5385, 205, 184, 5, 70, "ItemizedTextParagraph",
 CellTags->"b:6.1.1",
 CellID->354502722],
Cell[5572, 212, 211, 7, 70, "ItemizedText",
 CellTags->"b:6.1.1",
 CellID->106878410],
Cell[5786, 221, 487, 15, 70, "ItemizedTextParagraph",
 CellTags->"b:6.1.1",
 CellID->14268243],
Cell[6276, 238, 331, 7, 70, "ItemizedTextParagraph",
 CellTags->"b:6.1.1",
 CellID->537465361],
Cell[6610, 247, 749, 21, 70, "ItemizedText",
 CellTags->"b:6.1.1",
 CellID->489135226],
Cell[CellGroupData[{
Cell[7384, 272, 298, 13, 70, "ItemizedText",
 CellTags->"b:6.1.1",
 CellID->168415509],
Cell[7685, 287, 780, 20, 70, "Text",
 CellTags->{"b:6.1.1", "i:4"},
 CellID->300808379]
}, Open  ]],
Cell[CellGroupData[{
Cell[8502, 312, 72, 1, 70, "RelatedTutorialsSection",
 CellID->136784964],
Cell[8577, 315, 214, 5, 70, "RelatedTutorials",
 CellID->13855348],
Cell[8794, 322, 221, 5, 70, "RelatedTutorials",
 CellID->37939478]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[9054, 332, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

