(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     66760,       1532]
NotebookOptionsPosition[     60058,       1356]
NotebookOutlinePosition[     64194,       1447]
CellTagsIndexPosition[     64098,       1441]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Notebooks" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingNotebooksOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Notebooks\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Center" :> Documentation`HelpLookup["paclet:ref/Center"], 
          "FontSlant" :> Documentation`HelpLookup["paclet:ref/FontSlant"], 
          "FontWeight" :> Documentation`HelpLookup["paclet:ref/FontWeight"], 
          "Infinity" :> Documentation`HelpLookup["paclet:ref/Infinity"], 
          "Left" :> Documentation`HelpLookup["paclet:ref/Left"], 
          "LineSpacing" :> Documentation`HelpLookup["paclet:ref/LineSpacing"],
           "ParagraphSpacing" :> 
          Documentation`HelpLookup["paclet:ref/ParagraphSpacing"], "Right" :> 
          Documentation`HelpLookup["paclet:ref/Right"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Center\"\>", 2->"\<\"FontSlant\"\>", 
       3->"\<\"FontWeight\"\>", 4->"\<\"Infinity\"\>", 5->"\<\"Left\"\>", 
       6->"\<\"LineSpacing\"\>", 7->"\<\"ParagraphSpacing\"\>", 
       8->"\<\"Right\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[TextData[{
 "Additional functionality related to this tutorial has been introduced in \
subsequent versions of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". For the latest information, see ",
 ButtonBox["Text Styling",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/TextStyling"],
 "."
}], "TutorialObsolescenceNote",
 CellID->275068910],

Cell[CellGroupData[{

Cell["Text and Font Options", "Title",
 CellTags->{"S2.11.10", "10.1"},
 CellID->21174],

Cell[BoxData[GridBox[{
   {Cell["option", "TableHeader"], Cell[
    "typical default value", "TableHeader"], ""},
   {
    ButtonBox["PageWidth",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PageWidth"], "WindowWidth", Cell[
    "how wide to assume the page to be", "TableText"]},
   {
    ButtonBox["TextAlignment",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TextAlignment"], 
    ButtonBox["Left",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Left"], Cell[
    "how to align successive lines of text", "TableText"]},
   {
    ButtonBox["TextJustification",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TextJustification"], "0", Cell["\<\
how much to allow lines of text to be stretched to make them fit\
\>", "TableText"]},
   {
    ButtonBox["Hyphenation",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Hyphenation"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to allow hyphenation", "TableText"]},
   {
    ButtonBox["ParagraphIndent",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ParagraphIndent"], "0", Cell["\<\
how many printer\[CloseCurlyQuote]s points to indent the first line in each \
paragraph\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->30582],

Cell["General options for text formatting. ", "Caption",
 CellID->10139],

Cell[TextData[{
 "If you have a large block of text containing no explicit Return characters, \
then ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will automatically break your text into a sequence of lines. The option ",
 Cell[BoxData[
  ButtonBox["PageWidth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PageWidth"]], "InlineFormula"],
 " specifies how long each line should be allowed to be. "
}], "Text",
 CellID->12082],

Cell[BoxData[GridBox[{
   {"WindowWidth", Cell[
    "the width of the window on the screen", "TableText"]},
   {"PaperWidth", Cell[
    "the width of the page as it would be printed", "TableText"]},
   {
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], Cell[
    "an infinite width (no linebreaking)", "TableText"]},
   {
    StyleBox["n", "TI"], Cell["\<\
explicit width given in printer\[CloseCurlyQuote]s points\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->14024],

Cell[TextData[{
 "Settings for the ",
 StyleBox["PageWidth", "MR"],
 " option in cells and notebooks. "
}], "Caption",
 CellID->20900],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["TextAlignment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TextAlignment"]], "InlineFormula"],
 " allows you to specify how you want successive lines of text to be aligned. \
Since ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " normally breaks text only at space or punctuation characters, it is common \
to end up with lines of different lengths. Normally the variation in lengths \
will give your text a ragged boundary. But ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows you to adjust the spaces in successive lines of text so as to make \
the lines more nearly equal in length. The setting for ",
 Cell[BoxData[
  ButtonBox["TextJustification",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TextJustification"]], "InlineFormula"],
 " gives the fraction of extra space which ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is allowed to add. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TextJustification",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TextJustification"], "->", "1"}]], 
  "InlineFormula"],
 " leads to \[OpenCurlyDoubleQuote]full justification\[CloseCurlyDoubleQuote] \
in which all complete lines of text are adjusted to be exactly the same \
length."
}], "Text",
 CellID->1575],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Left",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Left"], Cell[
    "aligned on the left", "TableText"]},
   {
    ButtonBox["Right",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Right"], Cell[
    "aligned on the right", "TableText"]},
   {
    ButtonBox["Center",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Center"], Cell["centered", "TableText"]},
   {
    StyleBox["x", "TI"], Cell[TextData[{
     "aligned at a position ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " running from ",
     Cell[BoxData[
      RowBox[{"-", "1"}]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      RowBox[{"+", "1"}]], "InlineFormula"],
     " across the page"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->19337],

Cell[TextData[{
 "Settings for the ",
 StyleBox["TextAlignment", "MR"],
 " option. "
}], "Caption",
 CellID->15376],

Cell[TextData[{
 "Here is text with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TextAlignment",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TextAlignment"], "->", 
   ButtonBox["Left",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Left"]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TextJustification",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TextJustification"], "->", "0"}]], 
  "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->11300],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 121},
 ImageMargins->0,
 CellID->518236943],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TextAlignment",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TextAlignment"], "->", 
   ButtonBox["Center",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Center"]}]], "InlineFormula"],
 " the text is centered. "
}], "MathCaption",
 CellID->15864],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 121},
 ImageMargins->0,
 CellID->155063458],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["TextJustification",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TextJustification"], "->", "1"}]], 
  "InlineFormula"],
 " adjusts word spacing so that both the left and right edges line up. "
}], "MathCaption",
 CellID->2695],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 121},
 ImageMargins->0,
 CellID->1460004160],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["TextJustification",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TextJustification"], "->", "0.5"}]], 
  "InlineFormula"],
 " reduces the degree of raggedness, but does not force the left and right \
edges to be precisely lined up. "
}], "MathCaption",
 CellID->18629],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 121},
 ImageMargins->0,
 CellID->1470818760],

Cell[TextData[{
 "When you enter a block of text in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will treat any explicit Return characters that you type as paragraph \
breaks. The option ",
 Cell[BoxData[
  ButtonBox["ParagraphIndent",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParagraphIndent"]], "InlineFormula"],
 " allows you to specify how much you want to indent the first line in each \
paragraph. By giving a negative setting for ",
 Cell[BoxData[
  ButtonBox["ParagraphIndent",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParagraphIndent"]], "InlineFormula"],
 ", you can make the first line stick out to the left relative to subsequent \
lines."
}], "Text",
 CellID->29788],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["LineSpacing",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LineSpacing"], "->", "{", 
     StyleBox["c", "TI"], ",", "0", "}"}], Cell[TextData[{
     "leave space so that the total height of each line is ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"],
     " times the height of its contents"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["LineSpacing",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LineSpacing"], "->", "{", "0", ",", 
     StyleBox["n", "TI"], "}"}], Cell[TextData[{
     "make the total height of each line exactly ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " printer\[CloseCurlyQuote]s points"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["LineSpacing",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LineSpacing"], "->", "{", 
     StyleBox["c", "TI"], ",", 
     StyleBox["n", "TI"], "}"}], Cell[TextData[{
     "make the total height ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"],
     " times the height of the contents plus ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " printer\[CloseCurlyQuote]s points"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ParagraphSpacing",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ParagraphSpacing"], "->", "{", 
     StyleBox["c", "TI"], ",", "0", "}"}], Cell[TextData[{
     "leave an extra space of ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"],
     " times the height of the font before the beginning of each paragraph"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ParagraphSpacing",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ParagraphSpacing"], "->", "{", "0", ",", 
     StyleBox["n", "TI"], "}"}], Cell[TextData[{
     "leave an extra space of exactly ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " printer\[CloseCurlyQuote]s points before the beginning of each \
paragraph"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ParagraphSpacing",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ParagraphSpacing"], "->", "{", 
     StyleBox["c", "TI"], ",", 
     StyleBox["n", "TI"], "}"}], Cell[TextData[{
     "leave an extra space of ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"],
     " times the height of the font plus ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " printer\[CloseCurlyQuote]s points"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, True, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->30794],

Cell["Options for spacing between lines of text. ", "Caption",
 CellID->31744],

Cell[TextData[{
 "Here is some text with the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LineSpacing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LineSpacing"], "->", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}]], "InlineFormula"],
 ", which inserts just 1 printer\[CloseCurlyQuote]s point of extra space \
between successive lines. "
}], "MathCaption",
 CellID->21706],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 121},
 ImageMargins->0,
 CellID->151372154],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LineSpacing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LineSpacing"], "->", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}]}]], "InlineFormula"],
 " the text is \[OpenCurlyDoubleQuote]looser\[CloseCurlyDoubleQuote]. "
}], "MathCaption",
 CellID->16071],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 121},
 ImageMargins->0,
 CellID->1581959681],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["LineSpacing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LineSpacing"], "->", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0"}], "}"}]}]], "InlineFormula"],
 " makes the text double\[Hyphen]spaced."
}], "MathCaption",
 CellID->31884],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 147},
 ImageMargins->0,
 CellID->1766272641],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LineSpacing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LineSpacing"], "->", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "2"}]}], "}"}]}]], "InlineFormula"],
 " the text is tight. "
}], "MathCaption",
 CellID->19979],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 93},
 ImageMargins->0,
 CellID->1417753890],

Cell[BoxData[GridBox[{
   {Cell["option", "TableHeader"], Cell[
    "typical default value", "TableHeader"], ""},
   {
    ButtonBox["FontFamily",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FontFamily"], "\"\<Courier\>\"", Cell[
    "the family of font to use", "TableText"]},
   {
    ButtonBox["FontSubstitutions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FontSubstitutions"], 
    RowBox[{"{", "}"}], Cell[
    "a list of substitutions to try for font family names", "TableText"]},
   {
    ButtonBox["FontSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FontSize"], "12", Cell["\<\
the maximum height of characters in printer\[CloseCurlyQuote]s points\
\>", "TableText"]},
   {
    ButtonBox["FontWeight",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FontWeight"], "\"\<Bold\>\"", Cell[
    "the weight of characters to use", "TableText"]},
   {
    ButtonBox["FontSlant",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FontSlant"], "\"\<Plain\>\"", Cell[
    "the slant of characters to use", "TableText"]},
   {
    ButtonBox["FontTracking",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FontTracking"], "\"\<Plain\>\"", Cell[
    "the horizontal compression or expansion of characters", "TableText"]},
   {
    ButtonBox["FontColor",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FontColor"], 
    RowBox[{
     ButtonBox["GrayLevel",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GrayLevel"], "[", "0", "]"}], Cell[
    "the color of characters", "TableText"]},
   {
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], 
    RowBox[{
     ButtonBox["GrayLevel",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GrayLevel"], "[", "1", "]"}], Cell[
    "the color of the background for each character", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, True, False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->5158],

Cell["Options for fonts. ", "Caption",
 CellID->16807],

Cell[BoxData[GridBox[{
   {"\"\<Courier\>\"", Cell["textlikethis", "TableText"]},
   {"\"\<Times\>\"", Cell["text like this", "TableText"]},
   {"\"\<Helvetica\>\"", Cell[TextData[StyleBox[
    "text like this", "SR"]], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->845],

Cell["Some typical font family names. ", "Caption",
 CellID->15374],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["FontWeight",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FontWeight"], "->", "\"\<Plain\>\""}], Cell[
    "text like this", "TableText"]},
   {
    RowBox[{
     ButtonBox["FontWeight",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FontWeight"], "->", "\"\<Bold\>\""}], Cell[
    TextData[StyleBox["text like this", "TB"]], "TableText"]},
   {
    RowBox[{
     ButtonBox["FontWeight",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FontWeight"], "->", "\"\<ExtraBold\>\""}], Cell[
    TextData[StyleBox["text like this", "TB"]], "TableText"]},
   {
    RowBox[{
     ButtonBox["FontSlant",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FontSlant"], "->", "\"\<Oblique\>\""}], Cell[
    TextData[{
     StyleBox["text", "TI"],
     " ",
     StyleBox["like", "TI"],
     " ",
     StyleBox["this", "TI"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->17438],

Cell["Some settings of font options. ", "Caption",
 CellID->21156],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows you to specify the font that you want to use in considerable \
detail. Sometimes, however, the particular combination of font families and \
variations that you request may not be available on your computer system. In \
such cases, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will try to find the closest approximation it can. There are various \
additional options, such as ",
 Cell[BoxData["FontPostScriptName"], "InlineFormula"],
 ", that you can set to help ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " find an appropriate font. In addition, you can set ",
 Cell[BoxData[
  ButtonBox["FontSubstitutions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FontSubstitutions"]], "InlineFormula"],
 " to be a list of rules that give replacements to try for font family \
names."
}], "Text",
 CellID->14820],

Cell[TextData[{
 "There are a great many fonts available for ordinary text. But for special \
technical characters, and even for Greek letters, far fewer fonts are \
available. The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system includes fonts that were built to support all of the various \
special characters that are used by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". There are three versions of these fonts: ordinary (like Times), \
monospaced (like Courier), and sans serif (like Helvetica). "
}], "Text",
 CellID->30432],

Cell[TextData[{
 "For a given text font, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " tries to choose the special character font that matches it best. You can \
help ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to make this choice by giving rules for ",
 Cell[BoxData["\"\<FontSerifed\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<FontMonospaced\>\""], "InlineFormula"],
 " in the setting for the ",
 Cell[BoxData[
  ButtonBox["FontProperties",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FontProperties"]], "InlineFormula"],
 " option. You can also give rules for ",
 Cell[BoxData["\"\<FontEncoding\>\""], "InlineFormula"],
 " to specify explicitly from what font each character is to be taken. "
}], "Text",
 CellID->9766],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->221083629],

Cell[TextData[ButtonBox["Manipulating Notebooks",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingNotebooksOverview"]], "RelatedTutorials",
 CellID->81824477]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Text and Font Options - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Manipulating Notebooks", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/ManipulatingNotebooksOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/OptionsForCells"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/OptionsForExpressionInputAndOutput"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 30.0769958}", "context" -> "", 
    "keywords" -> {
     "background", "background color", "\\baselineskip (TeX)", "\\bf (TeX)", 
      "boldface", "bold fonts", "\\boldmath (TeX)", "breaking of words", 
      "centering", "color", "courier fonts", "double-spaced text", 
      "double spacing", "emphasis", "\\em (TeX)", "face", "family", 
      "fixed spacing", "flush left", "flush right", "FontColor", "FontFamily",
       "font options", "FontPostScriptName", "FontProperties", "fonts", 
      "FontSize", "FontSlant", "FontSubstitutions", "FontTracking", 
      "FontWeight", "full justification", "Greek", "hard returns", 
      "Helvetica fonts", "hyphenation", "indentation", "interline spacing", 
      "inter-paragraph spacing", "interparagraph spacing", "italic fonts", 
      "italics", "\\it (TeX)", "justification", "leading", "left aligned", 
      "left justification", "LineSpacing", "looseness", "matching", "naming", 
      "oblique", "oblique fonts", "PageWidth", "PaperWidth", 
      "ParagraphIndent", "paragraph skip", "ParagraphSpacing", 
      "\\parskip (TeX)", "ragged right", "returns", "right aligned", 
      "right justification", "\\rm (TeX)", "Roman fonts", "\\sf (TeX)", 
      "size", "skip", "slant", "\\sl (TeX)", "soft returns", "spacing", 
      "special character fonts", "TextAlignment", "TextJustification", 
      "text options", "tightness", "times fonts", "\\tt (TeX)", "typeface", 
      "typewriter font", "courier", "weight", "width", "window", 
      "WindowWidth", "words", "wrapping"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "General options for text formatting. If you have a large block of text \
containing no explicit Return characters, then Mathematica will automatically \
break your text into a sequence of lines. The option PageWidth specifies how \
long each line should be allowed to be. Settings for the PageWidth option in \
cells and notebooks. ", "synonyms" -> {"2.11.10"}, "title" -> 
    "Text and Font Options", "type" -> "Tutorial", "uri" -> 
    "tutorial/TextAndFontOptions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.11.10"->{
  Cell[2889, 81, 87, 2, 70, "Title",
   CellTags->{"S2.11.10", "10.1"},
   CellID->21174]},
 "10.1"->{
  Cell[2889, 81, 87, 2, 70, "Title",
   CellTags->{"S2.11.10", "10.1"},
   CellID->21174]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.11.10", 63880, 1430},
 {"10.1", 63983, 1434}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1907, 41, 70, "AnchorBarGrid"],
Cell[2510, 66, 354, 11, 70, "TutorialObsolescenceNote",
 CellID->275068910],
Cell[CellGroupData[{
Cell[2889, 81, 87, 2, 70, "Title",
 CellTags->{"S2.11.10", "10.1"},
 CellID->21174],
Cell[2979, 85, 1598, 46, 70, "DefinitionBox3Col",
 CellID->30582],
Cell[4580, 133, 72, 1, 70, "Caption",
 CellID->10139],
Cell[4655, 136, 438, 12, 70, "Text",
 CellID->12082],
Cell[5096, 150, 818, 22, 70, "DefinitionBox",
 CellID->14024],
Cell[5917, 174, 134, 5, 70, "Caption",
 CellID->20900],
Cell[6054, 181, 1303, 35, 70, "Text",
 CellID->1575],
Cell[7360, 218, 1115, 36, 70, "DefinitionBox",
 CellID->19337],
Cell[8478, 256, 115, 5, 70, "Caption",
 CellID->15376],
Cell[8596, 263, 488, 19, 70, "MathCaption",
 CellID->11300],
Cell[9087, 284, 4742, 80, 70, "Picture",
 CellID->518236943],
Cell[13832, 366, 323, 12, 70, "MathCaption",
 CellID->15864],
Cell[14158, 380, 4767, 81, 70, "Picture",
 CellID->155063458],
Cell[18928, 463, 289, 9, 70, "MathCaption",
 CellID->2695],
Cell[19220, 474, 4808, 81, 70, "Picture",
 CellID->1460004160],
Cell[24031, 557, 330, 10, 70, "MathCaption",
 CellID->18629],
Cell[24364, 569, 4755, 80, 70, "Picture",
 CellID->1470818760],
Cell[29122, 651, 772, 22, 70, "Text",
 CellID->29788],
Cell[29897, 675, 2916, 85, 70, "DefinitionBox",
 CellID->30794],
Cell[32816, 762, 78, 1, 70, "Caption",
 CellID->31744],
Cell[32897, 765, 402, 12, 70, "MathCaption",
 CellID->21706],
Cell[33302, 779, 4759, 81, 70, "Picture",
 CellID->151372154],
Cell[38064, 862, 333, 11, 70, "MathCaption",
 CellID->16071],
Cell[38400, 875, 4796, 81, 70, "Picture",
 CellID->1581959681],
Cell[43199, 958, 293, 10, 70, "MathCaption",
 CellID->31884],
Cell[43495, 970, 4829, 82, 70, "Picture",
 CellID->1766272641],
Cell[48327, 1054, 306, 12, 70, "MathCaption",
 CellID->19979],
Cell[48636, 1068, 4612, 78, 70, "Picture",
 CellID->1417753890],
Cell[53251, 1148, 2228, 63, 70, "DefinitionBox3Col",
 CellID->5158],
Cell[55482, 1213, 54, 1, 70, "Caption",
 CellID->16807],
Cell[55539, 1216, 566, 13, 70, "DefinitionBox",
 CellID->845],
Cell[56108, 1231, 67, 1, 70, "Caption",
 CellID->15374],
Cell[56178, 1234, 1261, 39, 70, "DefinitionBox",
 CellID->17438],
Cell[57442, 1275, 66, 1, 70, "Caption",
 CellID->21156],
Cell[57511, 1278, 902, 23, 70, "Text",
 CellID->14820],
Cell[58416, 1303, 553, 13, 70, "Text",
 CellID->30432],
Cell[58972, 1318, 757, 21, 70, "Text",
 CellID->9766],
Cell[CellGroupData[{
Cell[59754, 1343, 72, 1, 70, "RelatedTutorialsSection",
 CellID->221083629],
Cell[59829, 1346, 175, 4, 70, "RelatedTutorials",
 CellID->81824477]
}, Open  ]]
}, Open  ]],
Cell[60031, 1354, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

