(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11177,        375]
NotebookOptionsPosition[      7283,        265]
NotebookOutlinePosition[     10147,        336]
CellTagsIndexPosition[     10058,        330]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Running Mathematica" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RunningMathematicaOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Running Mathematica\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Quit" :> Documentation`HelpLookup["paclet:ref/Quit"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Quit\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Text\[Hyphen]Based Interfaces", "Title",
 CellTags->{"S1.0.2", "2.1"},
 CellID->27222],

Cell[BoxData[GridBox[{
   {"math", Cell[TextData[{
     "the operating system command to start ",
     StyleBox["Mathematica",
      FontSlant->"Italic"]
    }], "TableText"]},
   {Cell["text ending with Enter", "TableText"], Cell[TextData[{
     "input for ",
     StyleBox["Mathematica",
      FontSlant->"Italic"]
    }], "TableText"]},
   {Cell[TextData[{
     "Control\[Hyphen]D \[ThinSpace]or \[ThinSpace]",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Quit",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Quit"], "[", "]"}]], "InlineFormula"]
    }], "TableText"], Cell[TextData[{
     "exiting ",
     StyleBox["Mathematica",
      FontSlant->"Italic"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->22957],

Cell[TextData[{
 "Running ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with a text\[Hyphen]based interface. "
}], "Caption",
 CellID->553],

Cell["\<\
With a text\[Hyphen]based interface, you interact with your computer \
primarily by typing text on the keyboard. \
\>", "Text",
 CellID->26271],

Cell[TextData[{
 "To start ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with a text\[Hyphen]based interface, you typically type the command ",
 Cell[BoxData[
  ButtonBox["math",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/program/math"]], "InlineFormula"],
 " at an operating system prompt. On some systems, you may also be able to \
start ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with a text\[Hyphen]based interface by double\[Hyphen]clicking on a ",
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/MathKernel"],
  FontSlant->"Italic"],
 ButtonBox[" Kernel",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/MathKernel"],
 " icon. "
}], "Text",
 CellID->6955],

Cell[TextData[{
 "When ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has started, it will print the prompt ",
 StyleBox["In[1]:=", "MB"],
 ", signifying that it is ready for your input. You can then type your input, \
ending with Enter or Return."
}], "Text",
 CellID->9389],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will then process the input, and generate a result. If it prints the \
result out, it will label it with ",
 StyleBox["Out[1]=", "MB"],
 ". "
}], "Text",
 CellID->27625],

Cell[TextData[{
 "In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " reference documents, dialogs with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are shown in the following way: "
}], "Text",
 CellID->8029],

Cell[TextData[{
 "The computer prints ",
 StyleBox["In[1]:=", "MB"],
 ". You just type in ",
 Cell[BoxData[
  RowBox[{"2", "+", "2"}]], "InlineFormula"],
 ". The line that starts with ",
 StyleBox["Out[1]=", "MB"],
 " is the result from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "MathCaption",
 CellID->3128],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", "+", "2"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->2039],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->1527]
}, Open  ]],

Cell[TextData[{
 "Note that you do not explicitly type the ",
 StyleBox["In[", "MB"],
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 StyleBox["]:=", "MB"],
 " prompt; only type the text that follows this prompt. "
}], "Text",
 CellID->20394],

Cell[TextData[{
 "Note also that most of the actual dialogs given in the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " tutorials show output in the form you get with a notebook interface to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "; output with a text\[Hyphen]based interface looks similar, but lacks such \
features as special characters and font size changes. "
}], "Text",
 CellID->8490],

Cell[TextData[{
 "\"",
 ButtonBox["Using the ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/UsingTheMathematicaSystemOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/UsingTheMathematicaSystemOverview"],
  FontSlant->"Italic"],
 ButtonBox[" System",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/UsingTheMathematicaSystemOverview"],
 "\" gives more details on running ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with a text\[Hyphen]based interface. To exit ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", either type Control\[Hyphen]D, Control\[Hyphen]Z or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Quit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quit"], "[", "]"}]], "InlineFormula"],
 " at an input prompt. "
}], "Text",
 CellID->29648],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->7129865],

Cell[TextData[{
 ButtonBox["Running ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/RunningMathematicaOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/RunningMathematicaOverview"],
  FontSlant->"Italic"]
}], "RelatedTutorials",
 CellID->108503]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Text-Based Interfaces - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Running Mathematica", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> "paclet:tutorial/RunningMathematicaOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/NotebookInterfaces"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 31.1551484}", "context" -> "", 
    "keywords" -> {
     "closing Mathematica", "command line", "command-line arguments", 
      "DOS prompt", "shell prompt", "command interpreter", 
      "text-based interface", "ending Mathematica", "entering input", 
      "exiting Mathematica", "finishing Mathematica", "input", "interface", 
      "logging off from Mathematica", "operating system", "prompts", "quit", 
      "signing off from Mathematica", "terminating Mathematica", 
      "user interface"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Running Mathematica with a text-based interface. With a text-based \
interface, you interact with your computer primarily by typing text on the \
keyboard. To start Mathematica with a text-based interface, you typically \
type the command math at an operating system prompt. On some systems, you may \
also be able to start Mathematica with a text-based interface by \
double-clicking on a Mathematica Kernel icon. ", "synonyms" -> {"1.0.2"}, 
    "title" -> "Text-Based Interfaces", "type" -> "Tutorial", "uri" -> 
    "tutorial/TextBasedInterfaces"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.0.2"->{
  Cell[1782, 57, 92, 2, 70, "Title",
   CellTags->{"S1.0.2", "2.1"},
   CellID->27222]},
 "2.1"->{
  Cell[1782, 57, 92, 2, 70, "Title",
   CellTags->{"S1.0.2", "2.1"},
   CellID->27222]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.0.2", 9847, 319},
 {"2.1", 9946, 323}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1157, 30, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1782, 57, 92, 2, 70, "Title",
 CellTags->{"S1.0.2", "2.1"},
 CellID->27222],
Cell[1877, 61, 1036, 31, 70, "DefinitionBox",
 CellID->22957],
Cell[2916, 94, 148, 6, 70, "Caption",
 CellID->553],
Cell[3067, 102, 153, 4, 70, "Text",
 CellID->26271],
Cell[3223, 108, 737, 23, 70, "Text",
 CellID->6955],
Cell[3963, 133, 283, 9, 70, "Text",
 CellID->9389],
Cell[4249, 144, 237, 8, 70, "Text",
 CellID->27625],
Cell[4489, 154, 225, 9, 70, "Text",
 CellID->8029],
Cell[4717, 165, 327, 13, 70, "MathCaption",
 CellID->3128],
Cell[CellGroupData[{
Cell[5069, 182, 88, 3, 70, "Input",
 CellID->2039],
Cell[5160, 187, 154, 5, 36, "Output",
 CellID->1527]
}, Open  ]],
Cell[5329, 195, 252, 8, 70, "Text",
 CellID->20394],
Cell[5584, 205, 412, 10, 70, "Text",
 CellID->8490],
Cell[5999, 217, 831, 26, 70, "Text",
 CellID->29648],
Cell[CellGroupData[{
Cell[6855, 247, 70, 1, 70, "RelatedTutorialsSection",
 CellID->7129865],
Cell[6928, 250, 301, 9, 70, "RelatedTutorials",
 CellID->108503]
}, Open  ]]
}, Open  ]],
Cell[7256, 263, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

