(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12535,        358]
NotebookOptionsPosition[      8023,        239]
NotebookOutlinePosition[     11396,        317]
CellTagsIndexPosition[     11304,        311]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"The Internals of Mathematica" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/TheInternalsOfMathematicaOverview"], 
         "Basic Internal Architecture" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/BasicInternalArchitecture"], 
         "The Software Engineering of Mathematica" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/TheSoftwareEngineeringOfMathematica"], 
         "Testing and Verification" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/TestingAndVerification"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"The Internals of Mathematica\"\>", 
      2->"\<\"Basic Internal Architecture\"\>", 
      3->"\<\"The Software Engineering of Mathematica\"\>", 
      4->"\<\"Testing and Verification\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "The Algorithms of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "Title",
 CellTags->{"S1.12.3", "3.1"},
 CellID->28054],

Cell[TextData[{
 "The built\[Hyphen]in functions of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " implement a very large number of algorithms from computer science and \
mathematics. Some of these algorithms are fairly old, but the vast majority \
had to be created or at least modified specifically for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Most of the more mathematical algorithms in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ultimately carry out operations which at least at some time in the past \
were performed by hand. In almost all cases, however, the algorithms use \
methods very different from those common in hand calculation. "
}], "Text",
 CellID->5517],

Cell["\<\
Symbolic integration provides an example. In hand calculation, symbolic \
integration is typically done by a large number of tricks involving changes \
of variables and the like. \
\>", "Text",
 CellID->24192],

Cell[TextData[{
 "But in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " symbolic integration is performed by a fairly small number of very \
systematic procedures. For indefinite integration, the idea of these \
procedures is to find the most general form of the integral, then to \
differentiate this and try to match up undetermined coefficients. "
}], "Text",
 CellID->32530],

Cell["\<\
Often this procedure produces at an intermediate stage immensely complicated \
algebraic expressions, and sometimes very sophisticated kinds of mathematical \
functions. But the great advantage of the procedure is that it is completely \
systematic, and its operation requires no special cleverness of the kind that \
only a human could be expected to provide. \
\>", "Text",
 CellID->12618],

Cell[TextData[{
 "In having ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " do integrals, therefore, one can be confident that it will systematically \
get results, but one cannot expect that the way these results are derived \
will have much at all to do with the way they would be derived by hand. "
}], "Text",
 CellID->3148],

Cell[TextData[{
 "The same is true with most of the mathematical algorithms in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". One striking feature is that even for operations that are simple to \
describe, the systematic algorithms to perform these operations in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " involve fairly advanced mathematical or computational ideas. "
}], "Text",
 CellID->24056],

Cell[TextData[{
 "Thus, for example, factoring a polynomial in ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " is first done modulo a prime such as 17 by finding the null space of a \
matrix obtained by reducing high powers of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " modulo the prime and the original polynomial. Then factorization over the \
integers is achieved by \
\[OpenCurlyDoubleQuote]lifting\[CloseCurlyDoubleQuote] modulo successive \
powers of the prime using a collection of intricate theorems in algebra and \
analysis."
}], "Text",
 CellID->22990],

Cell[TextData[{
 "The use of powerful systematic algorithms is important in making the built\
\[Hyphen]in functions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " able to handle difficult and general cases. But for easy cases that may be \
fairly common in practice it is often possible to use simpler and more \
efficient algorithms. "
}], "Text",
 CellID->2282],

Cell[TextData[{
 "As a result, built\[Hyphen]in functions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " often have large numbers of extra pieces that handle various kinds of \
special cases. These extra pieces can contribute greatly to the complexity of \
the internal code, often taking what would otherwise be a five\[Hyphen]page \
algorithm and making it hundreds of pages long. "
}], "Text",
 CellID->29743],

Cell[TextData[{
 "Most of the algorithms in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", including all their special cases, were explicitly constructed by hand. \
But some algorithms were instead effectively created automatically by \
computer. "
}], "Text",
 CellID->26439],

Cell["\<\
Many of the algorithms used for machine\[Hyphen]precision numerical \
evaluation of mathematical functions are examples. The main parts of such \
algorithms are formulas which are as short as possible but which yield the \
best numerical approximations. \
\>", "Text",
 CellID->21301],

Cell[TextData[{
 "Most such formulas used in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " were actually derived by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " itself. Often many months of computation were required, but the result was \
a short formula that can be used to evaluate functions in an optimal way. "
}], "Text",
 CellID->21493],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->169436504],

Cell[TextData[{
 ButtonBox["The Internals of ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheInternalsOfMathematicaOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheInternalsOfMathematicaOverview"],
  FontSlant->"Italic"]
}], "RelatedTutorials",
 CellID->666254040],

Cell[TextData[ButtonBox["Basic Internal Architecture",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BasicInternalArchitecture"]], "RelatedTutorials",\

 CellID->255800466],

Cell[TextData[{
 ButtonBox["The Software Engineering of ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheSoftwareEngineeringOfMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheSoftwareEngineeringOfMathematica"],
  FontSlant->"Italic"]
}], "RelatedTutorials",
 CellID->889871574],

Cell[TextData[ButtonBox["Testing and Verification",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TestingAndVerification"]], "RelatedTutorials",
 CellID->449263826]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"The Algorithms of Mathematica - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["The Internals of Mathematica", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/TheInternalsOfMathematicaOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/BasicInternalArchitecture"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/TheSoftwareEngineeringOfMathematica"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 33.0301964}", "context" -> "", 
    "keywords" -> {"algorithms"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "The built-in functions of Mathematica implement a very large number of \
algorithms from computer science and mathematics. Some of these algorithms \
are fairly old, but the vast majority had to be created or at least modified \
specifically for Mathematica. Most of the more mathematical algorithms in \
Mathematica ultimately carry out operations which at least at some time in \
the past were performed by hand. In almost all cases, however, the algorithms \
use methods very different from those common in hand calculation. Symbolic \
integration provides an example. In hand calculation, symbolic integration is \
typically done by a large number of tricks involving changes of variables and \
the like. But in Mathematica symbolic integration is performed by a fairly \
small number of very systematic procedures. For indefinite integration, the \
idea of these procedures is to find the most general form of the integral, \
then to differentiate this and try to match up undetermined coefficients. ", 
    "synonyms" -> {"1.12.3"}, "title" -> "The Algorithms of Mathematica", 
    "type" -> "Tutorial", "uri" -> "tutorial/TheAlgorithmsOfMathematica"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.12.3"->{
  Cell[1852, 54, 146, 6, 70, "Title",
   CellTags->{"S1.12.3", "3.1"},
   CellID->28054]},
 "3.1"->{
  Cell[1852, 54, 146, 6, 70, "Title",
   CellTags->{"S1.12.3", "3.1"},
   CellID->28054]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.12.3", 11089, 300},
 {"3.1", 11190, 304}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1227, 27, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1852, 54, 146, 6, 70, "Title",
 CellTags->{"S1.12.3", "3.1"},
 CellID->28054],
Cell[2001, 62, 707, 16, 70, "Text",
 CellID->5517],
Cell[2711, 80, 219, 5, 70, "Text",
 CellID->24192],
Cell[2933, 87, 386, 9, 70, "Text",
 CellID->32530],
Cell[3322, 98, 401, 7, 70, "Text",
 CellID->12618],
Cell[3726, 107, 335, 8, 70, "Text",
 CellID->3148],
Cell[4064, 117, 417, 10, 70, "Text",
 CellID->24056],
Cell[4484, 129, 612, 14, 70, "Text",
 CellID->22990],
Cell[5099, 145, 374, 9, 70, "Text",
 CellID->2282],
Cell[5476, 156, 423, 9, 70, "Text",
 CellID->29743],
Cell[5902, 167, 285, 8, 70, "Text",
 CellID->26439],
Cell[6190, 177, 294, 6, 70, "Text",
 CellID->21301],
Cell[6487, 185, 360, 10, 70, "Text",
 CellID->21493],
Cell[CellGroupData[{
Cell[6872, 199, 72, 1, 70, "RelatedTutorialsSection",
 CellID->169436504],
Cell[6947, 202, 327, 9, 70, "RelatedTutorials",
 CellID->666254040],
Cell[7277, 213, 176, 4, 70, "RelatedTutorials",
 CellID->255800466],
Cell[7456, 219, 342, 9, 70, "RelatedTutorials",
 CellID->889871574],
Cell[7801, 230, 168, 3, 70, "RelatedTutorials",
 CellID->449263826]
}, Open  ]]
}, Open  ]],
Cell[7996, 237, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

