(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26004,        904]
NotebookOptionsPosition[     20155,        721]
NotebookOutlinePosition[     23143,        795]
CellTagsIndexPosition[     23052,        789]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Textual Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TextualInputAndOutputOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Textual Input and Output\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FullForm" :> Documentation`HelpLookup["paclet:ref/FullForm"], 
          "InputForm" :> Documentation`HelpLookup["paclet:ref/InputForm"], 
          "StandardForm" :> 
          Documentation`HelpLookup["paclet:ref/StandardForm"], "ToExpression" :> 
          Documentation`HelpLookup["paclet:ref/ToExpression"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FullForm\"\>", 
       2->"\<\"InputForm\"\>", 3->"\<\"StandardForm\"\>", 
       4->"\<\"ToExpression\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["The Interpretation of Textual Forms", "Title",
 CellTags->{"S2.9.4", "4.1"},
 CellID->5202],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ToExpression",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ToExpression"], "[", 
     StyleBox["input", "TI"], "]"}], Cell[
    "create an expression by interpreting strings or boxes", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->8658],

Cell["Converting from strings or boxes to expressions. ", "Caption",
 CellID->4202],

Cell["This takes a string and interprets it as an expression. ", "MathCaption",
 CellID->23753],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", "\"\<2 + 3 + x/y\>\"", "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->22249],

Cell[BoxData[
 RowBox[{"5", "+", 
  FractionBox["x", "y"]}]], "Output",
 ImageSize->{35, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->5058]
}, Open  ]],

Cell[TextData[{
 "Here is the box structure corresponding to the textual form of an \
expression in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->16575],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToBoxes", "[", 
  RowBox[{
   RowBox[{"2", "+", 
    RowBox[{"x", "^", "2"}]}], ",", "StandardForm"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->8090],

Cell[BoxData[
 RowBox[{"RowBox", "[", 
  RowBox[{"{", 
   RowBox[{"\<\"2\"\>", ",", "\<\"+\"\>", ",", 
    RowBox[{"SuperscriptBox", "[", 
     RowBox[{"\<\"x\"\>", ",", "\<\"2\"\>"}], "]"}]}], "}"}], "]"}]], "Output",\

 ImageSize->{248, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->24638]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToExpression"]], "InlineFormula"],
 " interprets this box structure and yields the original expression again. "
}], "MathCaption",
 CellID->6823],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->31395],

Cell[BoxData[
 RowBox[{"2", "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{37, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->24701]
}, Open  ]],

Cell[TextData[{
 "In any ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is always effectively using ",
 Cell[BoxData[
  ButtonBox["ToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToExpression"]], "InlineFormula"],
 " to interpret the textual form of your input as an actual expression to \
evaluate. "
}], "Text",
 CellID->17205],

Cell[TextData[{
 "If you use the notebook front end for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", then the interpretation only takes place when the contents of a cell are \
sent to the kernel, say for evaluation. This means that within a notebook \
there is no need for the textual forms you set up to correspond to meaningful \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions; this is only necessary if you want to send these forms to the \
kernel. "
}], "Text",
 CellID->11558],

Cell[BoxData[GridBox[{
   {
    ButtonBox["FullForm",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FullForm"], Cell[
    "explicit functional notation", "TableText"]},
   {
    ButtonBox["InputForm",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/InputForm"], Cell[
    "one\[Hyphen]dimensional notation", "TableText"]},
   {
    ButtonBox["StandardForm",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/StandardForm"], Cell[
    "two\[Hyphen]dimensional notation", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->3123],

Cell[TextData[{
 "The hierarchy of forms for standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input. "
}], "Caption",
 CellID->24287],

Cell[TextData[{
 "Here is an expression entered in ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->1041],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plus", "[", 
  RowBox[{"1", ",", 
   RowBox[{"Power", "[", 
    RowBox[{"x", ",", "2"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->14026],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{37, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->2530]
}, Open  ]],

Cell[TextData[{
 "Here is the same expression entered in ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->6209],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"x", "^", "2"}]}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->14820],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{37, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->935]
}, Open  ]],

Cell[TextData[{
 "And here is the expression entered in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->7043],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox["x", "2"]}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->12531],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{37, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->25674]
}, Open  ]],

Cell[TextData[{
 "Built into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is a collection of standard rules for use by ",
 Cell[BoxData[
  ButtonBox["ToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToExpression"]], "InlineFormula"],
 " in converting textual forms to expressions. "
}], "Text",
 CellID->3902],

Cell[TextData[{
 "These rules define the ",
 StyleBox["grammar",
  FontSlant->"Italic"],
 " of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". They state, for example, that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "+", "y"}], TraditionalForm]], "InlineMath"],
 " should be interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Plus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Plus"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ", and that ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "y"], TraditionalForm]], "InlineMath"],
 " should be interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Power",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Power"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". If the input you give is in ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 ", then the rules for interpretation are very straightforward: every \
expression consists just of a head followed by a sequence of elements \
enclosed in brackets. The rules for ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " are slightly more sophisticated: they allow operators such as ",
 Cell[BoxData["+"], "InlineFormula"],
 ", ",
 Cell[BoxData["="], "InlineFormula"],
 ", and ",
 Cell[BoxData["->"], "InlineFormula"],
 ", and understand the meaning of expressions where these operators appear \
between operands. ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " involves still more sophisticated rules, which allow operators and \
operands to be arranged not just in a one\[Hyphen]dimensional sequence, but \
in a full two\[Hyphen]dimensional structure."
}], "Text",
 CellID->8100],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is set up so that ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " form a strict hierarchy: anything you can enter in ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " will also work in ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ", and anything you can enter in ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " will also work in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->23071],

Cell[TextData[{
 "If you use a notebook front end for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", then you will typically want to use all the features of ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ". If you use a text\[Hyphen]based interface, however, then you will \
typically be able to use only features of ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->18775],

Cell[TextData[{
 "When you use ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook, you can enter directly two\[Hyphen]dimensional forms such as ",
 Cell[BoxData[
  SuperscriptBox["x", "2"]], "InlineFormula"],
 " or annotated graphics. But ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " allows only one\[Hyphen]dimensional forms."
}], "Text",
 CellID->22794],

Cell[TextData[{
 "If you copy a ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " expression whose interpretation can be determined without evaluation, then \
the expression will be pasted into external applications as ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ". Otherwise, the text is copied in a linear form that precisely represents \
the two-dimensional structure using \[Backslash]",
 Cell[BoxData[
  RowBox[{"!", 
   RowBox[{"\[Backslash]", 
    RowBox[{"(", 
     RowBox[{
      StyleBox["\[Ellipsis]", "TR"], "\[Backslash]"}], ")"}]}]}]], 
  "InlineFormula"],
 ". When you paste this linear form back into a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook, it will automatically \"snap\" into two\[Hyphen]dimensional \
form."
}], "Text",
 CellID->17855],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ToExpression",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ToExpression"], "[", 
     StyleBox["input", "TI"], ",", 
     StyleBox["form", "TI"], "]"}], Cell[TextData[{
     "attempt to create an expression assuming that ",
     Cell[BoxData[
      StyleBox["input", "TI"]], "InlineFormula"],
     " is given in the specified textual form"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->11960],

Cell["Importing from other textual forms. ", "Caption",
 CellID->17945],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and its subsets ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " provide precise ways to represent any ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression in textual form. And given such a textual form, it is always \
possible to convert it unambiguously to the expression it represents. "
}], "Text",
 CellID->9923],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " is an example of a textual form intended primarily for output. It is \
possible to take any ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression and display it in ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ". But ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " does not have the precision of ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ", and as a result there is in general no unambiguous way to go back from a \
",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " representation and get the expression it represents."
}], "Text",
 CellID->30542],

Cell[TextData[{
 "Nevertheless, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ToExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToExpression"], "[", 
   RowBox[{
    StyleBox["input", "TI"], ",", 
    ButtonBox["TraditionalForm",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TraditionalForm"]}], "]"}]], "InlineFormula"],
 " takes text in ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " and attempts to interpret it as an expression. "
}], "Text",
 CellID->14659],

Cell[TextData[{
 "This takes a string and interprets it as ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " input. "
}], "MathCaption",
 CellID->30487],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", 
  RowBox[{"\"\<f(6)\>\"", ",", "TraditionalForm"}], "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->5943],

Cell[BoxData[
 RowBox[{"f", "[", "6", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->15347]
}, Open  ]],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " the same string would mean a product of terms. "
}], "MathCaption",
 CellID->18584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", 
  RowBox[{"\"\<f(6)\>\"", ",", "StandardForm"}], "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->21389],

Cell[BoxData[
 RowBox[{"6", " ", "f"}]], "Output",
 ImageSize->{21, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->31668]
}, Open  ]],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " output is generated as the result of a computation, the actual collection \
of boxes that represent the output typically contains special ",
 Cell[BoxData[
  ButtonBox["Interpretation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Interpretation"]], "InlineFormula"],
 " objects or other specially tagged forms which specify how an expression \
can be reconstructed from the ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " output. "
}], "Text",
 CellID->21788],

Cell[TextData[{
 "The same is true of ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " that is obtained by explicit conversion from ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ". But if you edit ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " extensively, or enter it from scratch, then ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will have to try to interpret it without the benefit of any additional \
embedded information."
}], "Text",
 CellID->3198],

Cell[TextData[ButtonBox["Textual Input and Output",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TextualInputAndOutputOverview"]], "RelatedTutorials",
 CellID->364580606]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"The Interpretation of Textual Forms - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Textual Input and Output", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/TextualInputAndOutputOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/TheRepresentationOfTextualForms"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/ShortAndShallowOutput"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 34.3739808}", "context" -> "", 
    "keywords" -> {
     "activating 2D forms", "conversion", "embedded information", "exporting",
       "expression", "expressions", "formulas", "grammar of Mathematica", 
      "hierarchy", "importing", "input forms", "interpretation of input", 
      "jumping into 2D form", "make 2D menu item", "operators", "parsing", 
      "snapping into 2D form", "strings", "ToExpression", "TraditionalForm", 
      "two-dimensional string", "typeset expressions"}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Converting from strings or boxes to expressions. This takes a string and \
interprets it as an expression. Here is the box structure corresponding to \
the textual form of an expression in StandardForm. ", "synonyms" -> {"2.9.4"},
     "title" -> "The Interpretation of Textual Forms", "type" -> "Tutorial", 
    "uri" -> "tutorial/TheInterpretationOfTextualForms"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.9.4"->{
  Cell[2152, 63, 97, 2, 70, "Title",
   CellTags->{"S2.9.4", "4.1"},
   CellID->5202]},
 "4.1"->{
  Cell[2152, 63, 97, 2, 70, "Title",
   CellTags->{"S2.9.4", "4.1"},
   CellID->5202]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.9.4", 22843, 778},
 {"4.1", 22941, 782}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1527, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2152, 63, 97, 2, 70, "Title",
 CellTags->{"S2.9.4", "4.1"},
 CellID->5202],
Cell[2252, 67, 584, 16, 70, "DefinitionBox",
 CellID->8658],
Cell[2839, 85, 83, 1, 70, "Caption",
 CellID->4202],
Cell[2925, 88, 95, 1, 70, "MathCaption",
 CellID->23753],
Cell[CellGroupData[{
Cell[3045, 93, 123, 3, 28, "Input",
 CellID->22249],
Cell[3171, 98, 197, 7, 51, "Output",
 CellID->5058]
}, Open  ]],
Cell[3383, 108, 270, 9, 70, "MathCaption",
 CellID->16575],
Cell[CellGroupData[{
Cell[3678, 121, 182, 6, 28, "Input",
 CellID->8090],
Cell[3863, 129, 348, 11, 36, "Output",
 CellID->24638]
}, Open  ]],
Cell[4226, 143, 253, 7, 70, "MathCaption",
 CellID->6823],
Cell[CellGroupData[{
Cell[4504, 154, 105, 3, 28, "Input",
 CellID->31395],
Cell[4612, 159, 201, 7, 36, "Output",
 CellID->24701]
}, Open  ]],
Cell[4828, 169, 417, 15, 70, "Text",
 CellID->17205],
Cell[5248, 186, 512, 13, 70, "Text",
 CellID->11558],
Cell[5763, 201, 832, 24, 70, "DefinitionBox",
 CellID->3123],
Cell[6598, 227, 148, 6, 70, "Caption",
 CellID->24287],
Cell[6749, 235, 212, 8, 70, "MathCaption",
 CellID->1041],
Cell[CellGroupData[{
Cell[6986, 247, 178, 6, 70, "Input",
 CellID->14026],
Cell[7167, 255, 200, 7, 36, "Output",
 CellID->2530]
}, Open  ]],
Cell[7382, 265, 220, 8, 70, "MathCaption",
 CellID->6209],
Cell[CellGroupData[{
Cell[7627, 277, 112, 4, 70, "Input",
 CellID->14820],
Cell[7742, 283, 199, 7, 36, "Output",
 CellID->935]
}, Open  ]],
Cell[7956, 293, 225, 8, 70, "MathCaption",
 CellID->7043],
Cell[CellGroupData[{
Cell[8206, 305, 113, 4, 70, "Input",
 CellID->12531],
Cell[8322, 311, 201, 7, 36, "Output",
 CellID->25674]
}, Open  ]],
Cell[8538, 321, 334, 11, 70, "Text",
 CellID->3902],
Cell[8875, 334, 1963, 61, 70, "Text",
 CellID->8100],
Cell[10841, 397, 1136, 40, 70, "Text",
 CellID->23071],
Cell[11980, 439, 567, 17, 70, "Text",
 CellID->18775],
Cell[12550, 458, 588, 19, 70, "Text",
 CellID->22794],
Cell[13141, 479, 944, 27, 70, "Text",
 CellID->17855],
Cell[14088, 508, 748, 21, 70, "DefinitionBox",
 CellID->11960],
Cell[14839, 531, 71, 1, 70, "Caption",
 CellID->17945],
Cell[14913, 534, 683, 21, 70, "Text",
 CellID->9923],
Cell[15599, 557, 1071, 32, 70, "Text",
 CellID->30542],
Cell[16673, 591, 575, 19, 70, "Text",
 CellID->14659],
Cell[17251, 612, 241, 8, 70, "MathCaption",
 CellID->30487],
Cell[CellGroupData[{
Cell[17517, 624, 153, 4, 70, "Input",
 CellID->5943],
Cell[17673, 630, 183, 6, 36, "Output",
 CellID->15347]
}, Open  ]],
Cell[17871, 639, 237, 8, 70, "MathCaption",
 CellID->18584],
Cell[CellGroupData[{
Cell[18133, 651, 151, 4, 70, "Input",
 CellID->21389],
Cell[18287, 657, 178, 6, 36, "Output",
 CellID->31668]
}, Open  ]],
Cell[18480, 666, 717, 20, 70, "Text",
 CellID->21788],
Cell[19200, 688, 732, 22, 70, "Text",
 CellID->3198],
Cell[19935, 712, 178, 4, 70, "RelatedTutorials",
 CellID->364580606]
}, Open  ]],
Cell[20128, 719, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

