(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15515,        437]
NotebookOptionsPosition[     10772,        319]
NotebookOutlinePosition[     14673,        406]
CellTagsIndexPosition[     14582,        400]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Algebraic Calculations" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/AlgebraicCalculationsOverview"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Algebraic Calculations\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "The Limits of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "Title",
 CellTags->{"S1.4.9", "9.1"},
 CellID->12280],

Cell[TextData[{
 "In just one ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " command, you can easily specify a calculation that is far too complicated \
for any computer to do. For example, you could ask for ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Expand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Expand"], "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], "^", 
    RowBox[{"(", 
     RowBox[{"10", "^", "100"}], ")"}]}], "]"}]], "InlineFormula"],
 ". The result of this calculation would have ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["10", "100"], "+", "1"}], TraditionalForm]], 
  "InlineMath"],
 " terms\[LongDash]more than the total number of particles in the universe. "
}], "Text",
 CellID->27479],

Cell[TextData[{
 "You should have no trouble working out ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Expand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Expand"], "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], "^", "100"}], "]"}]], "InlineFormula"],
 " on any computer that can run ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". But as you increase the exponent of ",
 Cell[BoxData[
  RowBox[{"(", 
   RowBox[{"1", "+", "x"}], ")"}]], "InlineFormula"],
 ", the results you get will eventually become too big for your computer\
\[CloseCurlyQuote]s memory to hold. Exactly at what point this happens \
depends not only on the total amount of memory your computer has, but often \
also on such details as what other jobs happen to be running on your computer \
when you try to do your calculation. "
}], "Text",
 CellID->32707],

Cell[TextData[{
 "If your computer does run out of memory in the middle of a calculation, \
most versions of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " have no choice but to stop immediately. As a result, it is important to \
plan your calculations so that they never need more memory than your computer \
has. "
}], "Text",
 CellID->1813],

Cell[TextData[{
 "Even if the result of an algebraic calculation is quite simple, the \
intermediate expressions that you generate in the course of the calculation \
can be very complicated. This means that even if the final result is small, \
the intermediate parts of a calculation can be too big for your computer to \
handle. If this happens, you can usually break your calculation into pieces, \
and succeed in doing each piece on its own. You should know that the internal \
scheme which ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses for memory management is such that once part of a calculation is \
finished, the memory used to store intermediate expressions that arose is \
immediately made available for new expressions."
}], "Text",
 CellID->6860],

Cell[TextData[{
 "Memory space is the most common limiting factor in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " calculations. Time can also, however, be a limiting factor. You will \
usually be prepared to wait a second, or even a minute, for the result of a \
calculation. But you will less often be prepared to wait an hour or a day, \
and you will almost never be able to wait a year. "
}], "Text",
 CellID->15447],

Cell[TextData[{
 "The internal code of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses highly efficient and optimized algorithms. But there are some tasks \
for which the best known algorithms always eventually take a large amount of \
time. A typical issue is that the time required by the algorithm may increase \
almost exponentially with the size of the input. A classic case is integer \
factorization\[LongDash]where the best known algorithms require times that \
grow almost exponentially with the number of digits. In practice, you will \
find that ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FactorInteger",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FactorInteger"], "[", 
   StyleBox["k", "TI"], "]"}]], "InlineFormula"],
 " will give a result almost immediately when ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " has fewer than about 40 digits. But if ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " has more than 70 digits, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FactorInteger",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FactorInteger"], "[", 
   StyleBox["k", "TI"], "]"}]], "InlineFormula"],
 " can start taking an unmanageably long time."
}], "Text",
 CellID->29846],

Cell[TextData[{
 "In some cases, there is progressive improvement in the algorithms that are \
known, so that successive versions of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can perform particular computations progressively faster. But ideas from \
the theory of computation strongly suggest that many computations will always \
in effect require an irreducible amount of computational work\[LongDash]so \
that no fast algorithm for them will ever be found."
}], "Text",
 CellID->7271],

Cell[TextData[{
 "Whether or not the only algorithms involve exponentially increasing amounts \
of time, there will always come a point where a computation is too large or \
time\[Hyphen]consuming to do on your particular computer system. As you work \
with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you should develop some feeling for the limits on the kinds of \
calculations you can do in your particular application area. "
}], "Text",
 CellID->32182],

Cell[BoxData[GridBox[{
   {Cell["\<\
\[FilledSmallSquare] Doing arithmetic with numbers containing a few hundred \
million digits.\
\>", "TableText"]},
   {Cell[TextData[{
     "\[FilledSmallSquare] Generating a few million digits of numbers like ",
     Cell[BoxData[
      FormBox["\[Pi]", TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox["e", TraditionalForm]], "InlineMath"],
     "."
    }], "TableText"]},
   {Cell["\<\
\[FilledSmallSquare] Expanding out a polynomial that gives a million terms.\
\>", "TableText"]},
   {Cell["\<\
\[FilledSmallSquare] Factoring a polynomial in four variables with a hundred \
thousand terms.\
\>", "TableText"]},
   {Cell["\<\
\[FilledSmallSquare] Reducing a system of quadratic inequalities to a few \
thousand independent components.\
\>", "TableText"]},
   {Cell["\<\
\[FilledSmallSquare] Finding integer roots of a sparse polynomial with degree \
a million.\
\>", "TableText"]},
   {Cell["\<\
\[FilledSmallSquare] Applying a recursive rule a million times.\
\>", "TableText"]},
   {Cell["\<\
\[FilledSmallSquare] Calculating all the primes up to ten million.\
\>", "TableText"]},
   {Cell["\<\
\[FilledSmallSquare] Finding the numerical inverse of a 1000x1000 dense \
matrix.\
\>", "TableText"]},
   {Cell["\<\
\[FilledSmallSquare] Solving a million\[Hyphen]variable sparse linear system \
with several million non\[Hyphen]zero coefficients.\
\>", "TableText"]},
   {Cell["\<\
\[FilledSmallSquare] Finding the determinant of a 250x250 integer matrix.\
\>", "TableText"]},
   {Cell["\<\
\[FilledSmallSquare] Finding the determinant of a 10x10 symbolic matrix.\
\>", "TableText"]},
   {Cell["\<\
\[FilledSmallSquare] Finding numerical roots of a polynomial of degree 200.\
\>", "TableText"]},
   {Cell["\<\
\[FilledSmallSquare] Solving a sparse linear programming problem with a few \
hundred thousand variables.\
\>", "TableText"]},
   {Cell[TextData[{
     "\[FilledSmallSquare] Drawing a network with tens of thousands of \
vertices and hundreds of thousands of edges \[LineSeparator]",
     StyleBox["\[FilledSmallSquare]",
      FontColor->GrayLevel[1]],
     " automatically."
    }], "TableText"]},
   {Cell["\<\
\[FilledSmallSquare] Finding the Fourier transform of a list with a hundred \
million elements.\
\>", "TableText"]},
   {Cell["\<\
\[FilledSmallSquare] Rendering a million graphics primitives.\
\>", "TableText"]},
   {Cell["\<\
\[FilledSmallSquare] Sorting a list of ten million elements.\
\>", "TableText"]},
   {Cell["\<\
\[FilledSmallSquare] Searching a string that is ten million characters long.\
\>", "TableText"]},
   {Cell["\<\
\[FilledSmallSquare] Importing a few tens of megabytes of numerical data.\
\>", "TableText"]},
   {Cell[TextData[{
     "\[FilledSmallSquare] Formatting a few hundred pages of ",
     Cell[BoxData[
      ButtonBox["TraditionalForm",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
     " output."
    }], "TableText"]}
  }]], "FramedBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, False, False, 
     False, False, False, False, False, False, False, False, False, {False}, 
     False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->12344],

Cell["\<\
Some operations that typically take no more than a few seconds on a 2006 \
vintage PC. \
\>", "Caption",
 CellID->13142],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->464247759],

Cell[TextData[ButtonBox["Algebraic Calculations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AlgebraicCalculationsOverview"]], "RelatedTutorials",
 CellID->20816390]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"The Limits of Mathematica - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Algebraic Calculations", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/AlgebraicCalculationsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ControllingTheDisplayOfLargeExpressions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/UsingSymbolsToTagObjects"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 34.8583682}", "context" -> "", 
    "keywords" -> {
     "algorithms", "arithmetic", "calculations", 
      "computational complexity theory", "complexity in computations", 
      "computer systems", "crashing", "expanding polynomials", 
      "exponential time", "factoring", "FactorInteger", "formatting", 
      "intermediate expression swell", "internal code of Mathematica", 
      "limiting factors", "linear algebra", "matrix inversion", "memory", 
      "polynomial time", "RAM", "size of computation", "speed", "storage", 
      "time complexity", "transformation rules", "universe"}, "index" -> True,
     "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "In just one Mathematica command, you can easily specify a calculation \
that is far too complicated for any computer to do. For example, you could \
ask for Expand[(1+x)^(10^100)]. The result of this calculation would have \
10^100+1 terms--more than the total number of particles in the universe. You \
should have no trouble working out Expand[(1+x)^100] on any computer that can \
run Mathematica. But as you increase the exponent of (1+x), the results you \
get will eventually become too big for your computer's memory to hold. \
Exactly at what point this happens depends not only on the total amount of \
memory your computer has, but often also on such details as what other jobs \
happen to be running on your computer when you try to do your calculation. If \
your computer does run out of memory in the middle of a calculation, most \
versions of Mathematica have no choice but to stop immediately. As a result, \
it is important to plan your calculations so that they never need more memory \
than your computer has. ", "synonyms" -> {"1.4.9"}, "title" -> 
    "The Limits of Mathematica", "type" -> "Tutorial", "uri" -> 
    "tutorial/TheLimitsOfMathematica"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.4.9"->{
  Cell[1266, 43, 141, 6, 70, "Title",
   CellTags->{"S1.4.9", "9.1"},
   CellID->12280]},
 "9.1"->{
  Cell[1266, 43, 141, 6, 70, "Title",
   CellTags->{"S1.4.9", "9.1"},
   CellID->12280]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.4.9", 14369, 389},
 {"9.1", 14469, 393}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 641, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1266, 43, 141, 6, 70, "Title",
 CellTags->{"S1.4.9", "9.1"},
 CellID->12280],
Cell[1410, 51, 768, 24, 70, "Text",
 CellID->27479],
Cell[2181, 77, 866, 23, 70, "Text",
 CellID->32707],
Cell[3050, 102, 351, 9, 70, "Text",
 CellID->1813],
Cell[3404, 113, 772, 14, 70, "Text",
 CellID->6860],
Cell[4179, 129, 429, 9, 70, "Text",
 CellID->15447],
Cell[4611, 140, 1260, 32, 70, "Text",
 CellID->29846],
Cell[5874, 174, 499, 10, 70, "Text",
 CellID->7271],
Cell[6376, 186, 469, 10, 70, "Text",
 CellID->32182],
Cell[6848, 198, 3462, 98, 70, "FramedBox",
 CellID->12344],
Cell[10313, 298, 130, 4, 70, "Caption",
 CellID->13142],
Cell[CellGroupData[{
Cell[10468, 306, 72, 1, 70, "RelatedTutorialsSection",
 CellID->464247759],
Cell[10543, 309, 175, 4, 70, "RelatedTutorials",
 CellID->20816390]
}, Open  ]]
}, Open  ]],
Cell[10745, 317, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

