(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11539,        348]
NotebookOptionsPosition[      7788,        246]
NotebookOutlinePosition[     10749,        319]
CellTagsIndexPosition[     10658,        313]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Expressions" :> 
         Documentation`HelpLookup["paclet:tutorial/ExpressionsOverview"]}, #, 
        2]& , Evaluator -> Automatic], {
      1->"\<\"Expressions\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["The Meaning of Expressions", "Title",
 CellTags->{"S2.1.2", "2.1"},
 CellID->20284],

Cell[TextData[{
 "The notion of expressions is a crucial unifying principle in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". It is the fact that every object in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has the same underlying structure that makes it possible for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to cover so many areas with a comparatively small number of basic \
operations. "
}], "Text",
 CellID->29905],

Cell["\<\
Although all expressions have the same basic structure, there are many \
different ways that expressions can be used. Here are a few of the \
interpretations you can give to the parts of an expression.\
\>", "Text",
 CellID->25812],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     "meaning of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableHeader"], Cell[TextData[{
     "meaning of ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], ",", 
       StyleBox["y", "TI"], ",", 
       StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"]
    }], "TableHeader"], Cell["examples", "TableHeader"]},
   {Cell[TextData[ButtonBox["Function",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Function"]], "TableText"], Cell[
    "arguments or parameters", "TableText"], 
    RowBox[{
     ButtonBox["Sin",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sin"], "[", "x", "]", Cell[", ", "TableText"], 
     "f", "[", "x", ",", "y", "]"}]},
   {Cell["Command", "TableText"], Cell[
    "arguments or parameters", "TableText"], 
    RowBox[{
     ButtonBox["Expand",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Expand"], "[", "(", "x", "+", "1", ")", "^", 
     "2", "]"}]},
   {Cell["Operator", "TableText"], Cell["operands", "TableText"], Cell[
    "x+y, a=b", "TableText"]},
   {Cell[TextData[ButtonBox["Head",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Head"]], "TableText"], Cell[
    "elements", "TableText"], Cell["{a,b,c}", "TableText"]},
   {Cell["Object type", "TableText"], Cell["contents", "TableText"], 
    RowBox[{
     ButtonBox["RGBColor",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RGBColor"], "[", "r", ",", "g", ",", "b", 
     "]"}]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->28021],

Cell["Some interpretations of parts of expressions. ", "Caption",
 CellID->6341],

Cell[TextData[{
 "Expressions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are often used to specify operations. So, for example, typing in ",
 Cell[BoxData[
  RowBox[{"2", "+", "3"}]], "InlineFormula"],
 " causes ",
 Cell[BoxData["2"], "InlineFormula"],
 " and ",
 Cell[BoxData["3"], "InlineFormula"],
 " to be added together, while ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Factor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Factor"], "[", 
   RowBox[{
    RowBox[{"x", "^", "6"}], "-", "1"}], "]"}]], "InlineFormula"],
 " performs factorization. "
}], "Text",
 CellID->6575],

Cell[TextData[{
 "Perhaps an even more important use of expressions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", however, is to maintain a structure, which can then be acted on by other \
functions. An expression like ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}]], "InlineFormula"],
 " does not specify an operation. It merely maintains a list structure, which \
contains a collection of three elements. Other functions, such as ",
 Cell[BoxData[
  ButtonBox["Reverse",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reverse"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Dot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dot"]], "InlineFormula"],
 ", can act on this structure. "
}], "Text",
 CellID->22290],

Cell[TextData[{
 "The full form of the expression ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["List",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/List"], "[", 
   RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "InlineFormula"],
 ". The head ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 " performs no operations. Instead, its purpose is to serve as a \
\[OpenCurlyDoubleQuote]tag\[CloseCurlyDoubleQuote] to specify the \
\[OpenCurlyDoubleQuote]type\[CloseCurlyDoubleQuote] of the structure. "
}], "Text",
 CellID->17525],

Cell[TextData[{
 "You can use expressions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to create your own structures. For example, you might want to represent \
points in three\[Hyphen]dimensional space, specified by three coordinates. \
You could give each point as ",
 Cell[BoxData[
  RowBox[{"point", "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 ". The \[OpenCurlyDoubleQuote]function\[CloseCurlyDoubleQuote] ",
 Cell[BoxData["point"], "InlineFormula"],
 " again performs no operation. It serves merely to collect the three \
coordinates together, and to label the resulting object as a ",
 Cell[BoxData["point"], "InlineFormula"],
 ". "
}], "Text",
 CellID->6611],

Cell[TextData[{
 "You can think of expressions like ",
 Cell[BoxData[
  RowBox[{"point", "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " as being \[OpenCurlyDoubleQuote]packets of data\[CloseCurlyDoubleQuote], \
tagged with a particular head. Even though all expressions have the same \
basic structure, you can distinguish different \[OpenCurlyDoubleQuote]types\
\[CloseCurlyDoubleQuote] of expressions by giving them different heads. You \
can then set up transformation rules and programs which treat different types \
of expressions in different ways. "
}], "Text",
 CellID->22167],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->215182215],

Cell[TextData[ButtonBox["Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ExpressionsOverview"]], "RelatedTutorials",
 CellID->323659647]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"The Meaning of Expressions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Expressions", "OverviewNavText"], BaseStyle -> "Link", 
        ButtonData -> "paclet:tutorial/ExpressionsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/EverythingIsAnExpression"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/SpecialWaysToInputExpressions"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 38.2490800}", "context" -> "", 
    "keywords" -> {
     "commands", "data types", "expressions", "functions", "list", 
      "object type", "operands", "parameters", "symbols", "tags", "types"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "The notion of expressions is a crucial unifying principle in \
Mathematica. It is the fact that every object in Mathematica has the same \
underlying structure that makes it possible for Mathematica to cover so many \
areas with a comparatively small number of basic operations. Although all \
expressions have the same basic structure, there are many different ways that \
expressions can be used. Here are a few of the interpretations you can give \
to the parts of an expression. Some interpretations of parts of expressions. \
", "synonyms" -> {"2.1.2"}, "title" -> "The Meaning of Expressions", "type" -> 
    "Tutorial", "uri" -> "tutorial/TheMeaningOfExpressions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.1.2"->{
  Cell[1224, 42, 89, 2, 70, "Title",
   CellTags->{"S2.1.2", "2.1"},
   CellID->20284]},
 "2.1"->{
  Cell[1224, 42, 89, 2, 70, "Title",
   CellTags->{"S2.1.2", "2.1"},
   CellID->20284]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.1.2", 10447, 302},
 {"2.1", 10546, 306}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 599, 15, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1224, 42, 89, 2, 70, "Title",
 CellTags->{"S2.1.2", "2.1"},
 CellID->20284],
Cell[1316, 46, 451, 13, 70, "Text",
 CellID->29905],
Cell[1770, 61, 241, 5, 70, "Text",
 CellID->25812],
Cell[2014, 68, 1860, 50, 70, "DefinitionBox3Col",
 CellID->28021],
Cell[3877, 120, 80, 1, 70, "Caption",
 CellID->6341],
Cell[3960, 123, 600, 21, 70, "Text",
 CellID->6575],
Cell[4563, 146, 774, 22, 70, "Text",
 CellID->22290],
Cell[5340, 170, 694, 21, 70, "Text",
 CellID->17525],
Cell[6037, 193, 769, 20, 70, "Text",
 CellID->6611],
Cell[6809, 215, 673, 15, 70, "Text",
 CellID->22167],
Cell[CellGroupData[{
Cell[7507, 234, 72, 1, 70, "RelatedTutorialsSection",
 CellID->215182215],
Cell[7582, 237, 152, 3, 70, "RelatedTutorials",
 CellID->323659647]
}, Open  ]]
}, Open  ]],
Cell[7761, 244, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

