(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19027,        643]
NotebookOptionsPosition[     12421,        451]
NotebookOutlinePosition[     16689,        556]
CellTagsIndexPosition[     16475,        547]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Transformation Rules and Definitions" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/TransformationRulesAndDefinitionsOverview"]}, #, 
        2]& , Evaluator -> Automatic], {
      1->"\<\"Transformation Rules and Definitions\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["The Ordering of Definitions", "Title",
 CellTags->{"S2.5.7", "7.1"},
 CellID->26982],

Cell[TextData[{
 "When you make a sequence of definitions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", some may be more general than others. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " follows the principle of trying to put more general definitions after more \
specific ones. This means that special cases of rules are typically tried \
before more general cases. "
}], "Text",
 CellID->5783],

Cell[TextData[{
 "This behavior is crucial to the factorial function example given in \"",
 ButtonBox["Making Definitions for Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MakingDefinitionsForFunctions"],
 "\". Regardless of the order in which you entered them, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will always put the rule for the special case ",
 Cell[BoxData[
  RowBox[{"f", "[", "1", "]"}]], "InlineFormula"],
 " ahead of the rule for the general case ",
 Cell[BoxData[
  RowBox[{"f", "[", "n_", "]"}]], "InlineFormula"],
 ". This means that when ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " looks for the value of an expression of the form ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 ", it tries the special case ",
 Cell[BoxData[
  RowBox[{"f", "[", "1", "]"}]], "InlineFormula"],
 " first, and only if this does not apply, it tries the general case ",
 Cell[BoxData[
  RowBox[{"f", "[", "n_", "]"}]], "InlineFormula"],
 ". As a result, when you ask for ",
 Cell[BoxData[
  RowBox[{"f", "[", "5", "]"}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will keep on using the general rule until the \[OpenCurlyDoubleQuote]end \
condition\[CloseCurlyDoubleQuote] rule for ",
 Cell[BoxData[
  RowBox[{"f", "[", "1", "]"}]], "InlineFormula"],
 " applies. "
}], "Text",
 CellID->23387],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     "\[FilledSmallSquare] ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " tries to put specific definitions before more general definitions."
    }], "TableText"]}
  }]], "FramedBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->28793],

Cell[TextData[{
 "Treatment of definitions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->28050],

Cell[TextData[{
 "If ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " did not follow the principle of putting special rules before more general \
ones, then the special rules would always be \[OpenCurlyDoubleQuote]shadowed\
\[CloseCurlyDoubleQuote] by more general ones. In the factorial example, if \
the rule for ",
 Cell[BoxData[
  RowBox[{"f", "[", "n_", "]"}]], "InlineFormula"],
 " was ahead of the rule for ",
 Cell[BoxData[
  RowBox[{"f", "[", "1", "]"}]], "InlineFormula"],
 ", then even when ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " tried to evaluate ",
 Cell[BoxData[
  RowBox[{"f", "[", "1", "]"}]], "InlineFormula"],
 ", it would use the general ",
 Cell[BoxData[
  RowBox[{"f", "[", "n_", "]"}]], "InlineFormula"],
 " rule, and it would never find the special ",
 Cell[BoxData[
  RowBox[{"f", "[", "1", "]"}]], "InlineFormula"],
 " rule. "
}], "Text",
 CellID->19679],

Cell[TextData[{
 "Here is a general definition for ",
 Cell[BoxData[
  RowBox[{"f", "[", "n_", "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->18268],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "n_", "]"}], ":=", 
  RowBox[{"n", " ", 
   RowBox[{"f", "[", 
    RowBox[{"n", "-", "1"}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31274],

Cell[TextData[{
 "Here is a definition for the special case ",
 Cell[BoxData[
  RowBox[{"f", "[", "1", "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->30884],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "1", "]"}], "=", "1"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32629],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->414184669]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " puts the special case before the general one. "
}], "MathCaption",
 CellID->12460],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "f"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->24105],

Cell[CellGroupData[{

Cell["Global`f", "Print", "PrintUsage",
 CellTags->"Info3370859237-5257431",
 CellID->2049311724],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"f", "[", "1", "]"}], "=", "1"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"f", "[", "n_", "]"}], ":=", 
         RowBox[{"n", " ", 
          RowBox[{"f", "[", 
           RowBox[{"n", "-", "1"}], "]"}]}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["f"],
  Editable->False]], "Print",
 CellTags->"Info3370859237-5257431",
 CellID->1659202143]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "In the factorial function example used above, it is clear which rule is \
more general. Often, however, there is no definite ordering in generality of \
the rules you give. In such cases, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " simply tries the rules in the order you give them. "
}], "Text",
 CellID->27824],

Cell["These rules have no definite ordering in generality. ", "MathCaption",
 CellID->27550],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"log", "[", 
    RowBox[{"x_", " ", "y_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"log", "[", "x", "]"}], "+", 
    RowBox[{"log", "[", "y", "]"}]}]}], ";", 
  RowBox[{
   RowBox[{"log", "[", 
    RowBox[{"x_", "^", "n_"}], "]"}], ":=", 
   RowBox[{"n", " ", 
    RowBox[{"log", "[", "x", "]"}]}]}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->7016],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " stores the rules in the order you gave them. "
}], "MathCaption",
 CellID->8060],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "log"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->19801],

Cell[CellGroupData[{

Cell["Global`log", "Print", "PrintUsage",
 CellTags->"Info3370859239-3830030",
 CellID->833156910],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"log", "[", 
          RowBox[{"x_", " ", "y_"}], "]"}], ":=", 
         RowBox[{
          RowBox[{"log", "[", "x", "]"}], "+", 
          RowBox[{"log", "[", "y", "]"}]}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"log", "[", 
          SuperscriptBox["x_", "n_"], "]"}], ":=", 
         RowBox[{"n", " ", 
          RowBox[{"log", "[", "x", "]"}]}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["log"],
  Editable->False]], "Print",
 CellTags->"Info3370859239-3830030",
 CellID->2100954431]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "This rule is a special case of the rule for ",
 Cell[BoxData[
  RowBox[{"log", "[", 
   RowBox[{"x_", "y_"}], "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->2923],

Cell[BoxData[
 RowBox[{
  RowBox[{"log", "[", 
   RowBox[{"2", " ", "x_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"log", "[", "x", "]"}], "+", "log2"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->67],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " puts the special rule before the more general one. "
}], "MathCaption",
 CellID->7300],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "log"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->27225],

Cell[CellGroupData[{

Cell["Global`log", "Print", "PrintUsage",
 CellTags->"Info3370859241-2391574",
 CellID->1082917578],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"log", "[", 
          RowBox[{"2", " ", "x_"}], "]"}], ":=", 
         RowBox[{
          RowBox[{"log", "[", "x", "]"}], "+", "log2"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"log", "[", 
          RowBox[{"x_", " ", "y_"}], "]"}], ":=", 
         RowBox[{
          RowBox[{"log", "[", "x", "]"}], "+", 
          RowBox[{"log", "[", "y", "]"}]}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"log", "[", 
          SuperscriptBox["x_", "n_"], "]"}], ":=", 
         RowBox[{"n", " ", 
          RowBox[{"log", "[", "x", "]"}]}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["log"],
  Editable->False]], "Print",
 CellTags->"Info3370859241-2391574",
 CellID->1042861669]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "Although in many practical cases, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can recognize when one rule is more general than another, you should \
realize that this is not always possible. For example, if two rules both \
contain complicated ",
 Cell[BoxData["/;"], "InlineFormula"],
 " conditions, it may not be possible to work out which is more general, and, \
in fact, there may not be a definite ordering. Whenever the appropriate \
ordering is not clear, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " stores rules in the order you give them. "
}], "Text",
 CellID->10048],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->223636951],

Cell[TextData[ButtonBox["Transformation Rules and Definitions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TransformationRulesAndDefinitionsOverview"]], \
"RelatedTutorials",
 CellID->97729659]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"The Ordering of Definitions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Transformation Rules and Definitions", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/TransformationRulesAndDefinitionsOverview"]], "Text",
       FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/MakingDefinitionsForFunctions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ImmediateAndDelayedDefinitions"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 38.7490928}", "context" -> "", 
    "keywords" -> {
     "assignments", "boundary conditions", "definitions", "end conditions", 
      "ordering", "reordering", "rules", "special cases"}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "When you make a sequence of definitions in Mathematica, some may be more \
general than others. Mathematica follows the principle of trying to put more \
general definitions after more specific ones. This means that special cases \
of rules are typically tried before more general cases. This behavior is \
crucial to the factorial function example given in \"Making Definitions for \
Functions\". Regardless of the order in which you entered them, Mathematica \
will always put the rule for the special case f[1] ahead of the rule for the \
general case f[n_]. This means that when Mathematica looks for the value of \
an expression of the form f[n], it tries the special case f[1] first, and \
only if this does not apply, it tries the general case f[n_]. As a result, \
when you ask for f[5], Mathematica will keep on using the general rule until \
the 'end condition' rule for f[1] applies. Treatment of definitions in \
Mathematica. ", "synonyms" -> {"2.5.7"}, "title" -> 
    "The Ordering of Definitions", "type" -> "Tutorial", "uri" -> 
    "tutorial/TheOrderingOfDefinitions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.5.7"->{
  Cell[1309, 44, 90, 2, 70, "Title",
   CellTags->{"S2.5.7", "7.1"},
   CellID->26982]},
 "7.1"->{
  Cell[1309, 44, 90, 2, 70, "Title",
   CellTags->{"S2.5.7", "7.1"},
   CellID->26982]},
 "Info3370859237-5257431"->{
  Cell[5950, 213, 97, 2, 70, "Print",
   CellTags->"Info3370859237-5257431",
   CellID->2049311724],
  Cell[6050, 217, 937, 29, 70, "Print",
   CellTags->"Info3370859237-5257431",
   CellID->1659202143]},
 "Info3370859239-3830030"->{
  Cell[8134, 295, 98, 2, 70, "Print",
   CellTags->"Info3370859239-3830030",
   CellID->833156910],
  Cell[8235, 299, 1086, 33, 70, "Print",
   CellTags->"Info3370859239-3830030",
   CellID->2100954431]},
 "Info3370859241-2391574"->{
  Cell[10034, 370, 99, 2, 70, "Print",
   CellTags->"Info3370859241-2391574",
   CellID->1082917578],
  Cell[10136, 374, 1284, 40, 70, "Print",
   CellTags->"Info3370859241-2391574",
   CellID->1042861669]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.5.7", 15559, 515},
 {"7.1", 15658, 519},
 {"Info3370859237-5257431", 15776, 523},
 {"Info3370859239-3830030", 16010, 530},
 {"Info3370859241-2391574", 16244, 537}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 684, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1309, 44, 90, 2, 70, "Title",
 CellTags->{"S2.5.7", "7.1"},
 CellID->26982],
Cell[1402, 48, 418, 11, 70, "Text",
 CellID->5783],
Cell[1823, 61, 1408, 39, 70, "Text",
 CellID->23387],
Cell[3234, 102, 541, 15, 70, "FramedBox",
 CellID->28793],
Cell[3778, 119, 134, 6, 70, "Caption",
 CellID->28050],
Cell[3915, 127, 901, 27, 70, "Text",
 CellID->19679],
Cell[4819, 156, 161, 6, 70, "MathCaption",
 CellID->18268],
Cell[4983, 164, 195, 7, 70, "Input",
 CellID->31274],
Cell[5181, 173, 169, 6, 70, "MathCaption",
 CellID->30884],
Cell[CellGroupData[{
Cell[5375, 183, 116, 4, 70, "Input",
 CellID->32629],
Cell[5494, 189, 158, 5, 36, "Output",
 CellID->414184669]
}, Open  ]],
Cell[5667, 197, 150, 5, 70, "MathCaption",
 CellID->12460],
Cell[CellGroupData[{
Cell[5842, 206, 83, 3, 70, "Input",
 CellID->24105],
Cell[CellGroupData[{
Cell[5950, 213, 97, 2, 70, "Print",
 CellTags->"Info3370859237-5257431",
 CellID->2049311724],
Cell[6050, 217, 937, 29, 70, "Print",
 CellTags->"Info3370859237-5257431",
 CellID->1659202143]
}, Open  ]]
}, Open  ]],
Cell[7014, 250, 341, 8, 70, "Text",
 CellID->27824],
Cell[7358, 260, 92, 1, 70, "MathCaption",
 CellID->27550],
Cell[7453, 263, 395, 14, 70, "Input",
 CellID->7016],
Cell[7851, 279, 148, 5, 70, "MathCaption",
 CellID->8060],
Cell[CellGroupData[{
Cell[8024, 288, 85, 3, 70, "Input",
 CellID->19801],
Cell[CellGroupData[{
Cell[8134, 295, 98, 2, 70, "Print",
 CellTags->"Info3370859239-3830030",
 CellID->833156910],
Cell[8235, 299, 1086, 33, 70, "Print",
 CellTags->"Info3370859239-3830030",
 CellID->2100954431]
}, Open  ]]
}, Open  ]],
Cell[9348, 336, 193, 7, 70, "MathCaption",
 CellID->2923],
Cell[9544, 345, 198, 7, 70, "Input",
 CellID->67],
Cell[9745, 354, 154, 5, 70, "MathCaption",
 CellID->7300],
Cell[CellGroupData[{
Cell[9924, 363, 85, 3, 70, "Input",
 CellID->27225],
Cell[CellGroupData[{
Cell[10034, 370, 99, 2, 70, "Print",
 CellTags->"Info3370859241-2391574",
 CellID->1082917578],
Cell[10136, 374, 1284, 40, 70, "Print",
 CellTags->"Info3370859241-2391574",
 CellID->1042861669]
}, Open  ]]
}, Open  ]],
Cell[11447, 418, 617, 15, 70, "Text",
 CellID->10048],
Cell[CellGroupData[{
Cell[12089, 437, 72, 1, 70, "RelatedTutorialsSection",
 CellID->223636951],
Cell[12164, 440, 203, 5, 70, "RelatedTutorials",
 CellID->97729659]
}, Open  ]]
}, Open  ]],
Cell[12394, 449, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

