(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     33325,       1268]
NotebookOptionsPosition[     24964,       1005]
NotebookOutlinePosition[     28698,       1089]
CellTagsIndexPosition[     28605,       1083]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Calculus" :> 
         Documentation`HelpLookup["paclet:tutorial/CalculusOverview"]}, #, 
        2]& , Evaluator -> Automatic], {
      1->"\<\"Calculus\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["The Representation of Derivatives", "Title",
 CellTags->{"S3.5.4", "4.1"},
 CellID->31655],

Cell[TextData[{
 "Derivatives in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " work essentially the same as in standard mathematics. The usual \
mathematical notation, however, often hides many details. To understand how \
derivatives are represented in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", we must look at these details. "
}], "Text",
 CellID->1807],

Cell[TextData[{
 "The standard mathematical notation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["f", "\[Prime]"], 
    RowBox[{"(", "0", ")"}]}], TraditionalForm]], "InlineMath"],
 " is really a shorthand for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["d", 
     StyleBox[
      RowBox[{"d", "t"}], "TI"]], "f", 
    RowBox[{"(", "t", ")"}], 
    SubscriptBox["\[VerticalSeparator]", 
     RowBox[{"t", "=", "0"}]]}], TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 " is a \[OpenCurlyDoubleQuote]dummy variable\[CloseCurlyDoubleQuote]. \
Similarly, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["f", "\[Prime]"], 
    RowBox[{"(", 
     SuperscriptBox["x", "2"], ")"}]}], TraditionalForm]], "InlineMath"],
 " is a shorthand for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["d", 
     StyleBox[
      RowBox[{"d", "t"}], "TI"]], "f", 
    RowBox[{"(", "t", ")"}], 
    SubscriptBox["\[VerticalSeparator]", 
     RowBox[{"t", "=", 
      SuperscriptBox["x", "2"]}]]}], TraditionalForm]], "InlineMath"],
 ". As suggested by the notation ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["f", "\[Prime]"], TraditionalForm]], "InlineMath"],
 ", the object ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["d", 
     StyleBox[
      RowBox[{"d", "t"}], "TI"]], "f", 
    RowBox[{"(", "t", ")"}]}], TraditionalForm]], "InlineMath"],
 " can in fact be viewed as a \[OpenCurlyDoubleQuote]pure function\
\[CloseCurlyDoubleQuote], to be evaluated with a particular choice of its \
parameter ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 ". You can think of the operation of differentiation as acting on a ",
 StyleBox["function",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 ", to give a new ",
 StyleBox["function",
  FontSlant->"Italic"],
 ", usually called ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["f", "\[Prime]"], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->14449],

Cell[TextData[{
 "With functions of more than one argument, the simple notation based on \
primes breaks down. You cannot tell for example whether ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["g", "\[Prime]"], 
    RowBox[{"(", 
     RowBox[{"0", ",", "1"}], ")"}]}], TraditionalForm]], "InlineMath"],
 " stands for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["d", 
     StyleBox[
      RowBox[{"d", "t"}], "TI"]], "g", 
    RowBox[{"(", 
     RowBox[{"t", ",", "1"}], ")"}], 
    SubscriptBox["\[VerticalSeparator]", 
     RowBox[{"t", "=", "0"}]]}], TraditionalForm]], "InlineMath"],
 " or ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["d", 
     StyleBox[
      RowBox[{"d", "t"}], "TI"]], "g", 
    RowBox[{"(", 
     RowBox[{"0", ",", "t"}], ")"}], 
    SubscriptBox["\[VerticalSeparator]", 
     RowBox[{"t", "=", "1"}]]}], TraditionalForm]], "InlineMath"],
 ", and for almost any ",
 Cell[BoxData[
  FormBox["g", TraditionalForm]], "InlineMath"],
 ", these will have totally different values. Once again, however, ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 " is just a dummy variable, whose sole",
 " ",
 "purpose is to show with respect to which \[OpenCurlyDoubleQuote]slot\
\[CloseCurlyDoubleQuote] ",
 Cell[BoxData[
  FormBox["g", TraditionalForm]], "InlineMath"],
 " is to be differentiated. "
}], "Text",
 CellID->8491],

Cell[TextData[{
 "In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", as in some branches of mathematics, it is convenient to think about a \
kind of differentiation that acts on ",
 StyleBox["functions",
  FontSlant->"Italic"],
 ", rather than expressions. We need an operation that takes the function ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 ", and gives us the ",
 StyleBox["derivative function",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["f", "\[Prime]"], TraditionalForm]], "InlineMath"],
 ". Operations such as this that act on ",
 StyleBox["functions",
  FontSlant->"Italic"],
 ", rather than variables, are known in mathematics as ",
 StyleBox["operators",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->18760],

Cell[TextData[{
 "The object ",
 Cell[BoxData[
  RowBox[{"f", "'"}]], "InlineFormula"],
 " in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is the result of applying the differentiation operator to the function ",
 Cell[BoxData["f"], "InlineFormula"],
 ". The full form of ",
 Cell[BoxData[
  RowBox[{"f", "'"}]], "InlineFormula"],
 " is in fact ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Derivative",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Derivative"], "[", "1", "]"}], "[", "f", "]"}]], 
  "InlineFormula"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Derivative",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Derivative"], "[", "1", "]"}]], "InlineFormula"],
 " is the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " differentiation operator. "
}], "Text",
 CellID->24382],

Cell[TextData[{
 "The arguments in the operator ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Derivative",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Derivative"], "["}]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["n", "1"], TraditionalForm]], "InlineMath"],
 Cell[BoxData[","], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["n", "2"], TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  RowBox[{
   RowBox[{",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " specify how many times to differentiate with respect to each \
\[OpenCurlyDoubleQuote]slot\[CloseCurlyDoubleQuote] of the function on which \
it acts. By using operators to represent differentiation, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " avoids any need to introduce explicit \[OpenCurlyDoubleQuote]dummy \
variables\[CloseCurlyDoubleQuote]. "
}], "Text",
 CellID->4836],

Cell[TextData[{
 "This is the full form of the derivative of the function ",
 Cell[BoxData["f"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->30219],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "'"}], "//", "FullForm"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->30270],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{
    RowBox[{"Derivative", "[", "1", "]"}], "[", "f", "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm= ",
 CellID->19679]
}, Open  ]],

Cell[TextData[{
 "Here an argument ",
 Cell[BoxData["x"], "InlineFormula"],
 " is supplied. "
}], "MathCaption",
 CellID->1725],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "'"}], "[", "x", "]"}], "//", "FullForm"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->5519],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{
    RowBox[{
     RowBox[{"Derivative", "[", "1", "]"}], "[", "f", "]"}], "[", "x", "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm= ",
 CellID->4809]
}, Open  ]],

Cell["This is the second derivative. ", "MathCaption",
 CellID->16701],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "''"}], "[", "x", "]"}], "//", "FullForm"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->6631],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{
    RowBox[{
     RowBox[{"Derivative", "[", "2", "]"}], "[", "f", "]"}], "[", "x", "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//FullForm= ",
 CellID->8324]
}, Open  ]],

Cell[TextData[{
 "This gives a derivative of the function ",
 Cell[BoxData["g"], "InlineFormula"],
 " with respect to its second \[OpenCurlyDoubleQuote]slot\
\[CloseCurlyDoubleQuote]. "
}], "MathCaption",
 CellID->25807],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", "y"}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->12725],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["g", 
   TagBox[
    RowBox[{"(", 
     RowBox[{"0", ",", "1"}], ")"}],
    Derivative],
   MultilineFunction->None], "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->22301]
}, Open  ]],

Cell["Here is the full form. ", "MathCaption",
 CellID->30283],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "FullForm"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->3969],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{
    RowBox[{
     RowBox[{"Derivative", "[", 
      RowBox[{"0", ",", "1"}], "]"}], "[", "g", "]"}], "[", 
    RowBox[{"x", ",", "y"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//FullForm= ",
 CellID->12488]
}, Open  ]],

Cell[TextData[{
 "Here is the second derivative with respect to the variable ",
 Cell[BoxData["y"], "InlineFormula"],
 ", which appears in the second slot of ",
 Cell[BoxData["g"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->21164],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"g", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "2"}], "}"}]}], "]"}], "//", "FullForm"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->13963],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{
    RowBox[{
     RowBox[{"Derivative", "[", 
      RowBox[{"0", ",", "2"}], "]"}], "[", "g", "]"}], "[", 
    RowBox[{"x", ",", "y"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]//FullForm= ",
 CellID->24124]
}, Open  ]],

Cell["This is a mixed derivative. ", "MathCaption",
 CellID->7534],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"g", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", "x", ",", "y", ",", "y"}], "]"}], "//",
   "FullForm"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->27770],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{
    RowBox[{
     RowBox[{"Derivative", "[", 
      RowBox[{"1", ",", "2"}], "]"}], "[", "g", "]"}], "[", 
    RowBox[{"x", ",", "y"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]//FullForm= ",
 CellID->2851]
}, Open  ]],

Cell[TextData[{
 "Since ",
 Cell[BoxData[
  ButtonBox["Derivative",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Derivative"]], "InlineFormula"],
 " only specifies how many times to differentiate with respect to each slot, \
the order of the derivatives is irrelevant. "
}], "MathCaption",
 CellID->13997],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"g", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", "y", ",", "y", ",", "x"}], "]"}], "//",
   "FullForm"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->23724],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{
    RowBox[{
     RowBox[{"Derivative", "[", 
      RowBox[{"1", ",", "2"}], "]"}], "[", "g", "]"}], "[", 
    RowBox[{"x", ",", "y"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]//FullForm= ",
 CellID->29511]
}, Open  ]],

Cell[TextData[{
 "Here is a more complicated case, in which both arguments of ",
 Cell[BoxData["g"], "InlineFormula"],
 " depend on the differentiation variable. "
}], "MathCaption",
 CellID->20067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{"x", ",", "x"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->30265],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["g", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"0", ",", "1"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"x", ",", "x"}], "]"}], "+", 
  RowBox[{
   SuperscriptBox["g", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"1", ",", "0"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"x", ",", "x"}], "]"}]}]], "Output",
 ImageSize->{160, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->20840]
}, Open  ]],

Cell["This is the full form of the result. ", "MathCaption",
 CellID->3379],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "FullForm"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->24955],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Plus", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Derivative", "[", 
        RowBox[{"0", ",", "1"}], "]"}], "[", "g", "]"}], "[", 
      RowBox[{"x", ",", "x"}], "]"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Derivative", "[", 
        RowBox[{"1", ",", "0"}], "]"}], "[", "g", "]"}], "[", 
      RowBox[{"x", ",", "x"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{396, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]//FullForm= ",
 CellID->16028]
}, Open  ]],

Cell[TextData[{
 "The object ",
 Cell[BoxData[
  RowBox[{"f", "'"}]], "InlineFormula"],
 " behaves essentially like any other function in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". You can evaluate the function with any argument, and you can use standard \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData["/."], "InlineFormula"],
 " operations to change the argument. (This would not be possible if explicit \
dummy variables had been introduced in the course of the differentiation.) "
}], "Text",
 CellID->1661],

Cell[TextData[{
 "This is the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " representation of the derivative of a function ",
 Cell[BoxData["f"], "InlineFormula"],
 ", evaluated at the origin. "
}], "MathCaption",
 CellID->2432],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "'"}], "[", "0", "]"}], "//", "FullForm"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->18227],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{
    RowBox[{
     RowBox[{"Derivative", "[", "1", "]"}], "[", "f", "]"}], "[", "0", "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]//FullForm= ",
 CellID->30160]
}, Open  ]],

Cell[TextData[{
 "The result of this derivative involves ",
 Cell[BoxData[
  RowBox[{"f", "'"}]], "InlineFormula"],
 " evaluated with the argument ",
 Cell[BoxData[
  RowBox[{"x", "^", "2"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->16139],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->32666],

Cell[BoxData[
 RowBox[{"2", " ", "x", " ", 
  RowBox[{
   SuperscriptBox["f", "\[Prime]",
    MultilineFunction->None], "[", 
   SuperscriptBox["x", "2"], "]"}]}]], "Output",
 ImageSize->{61, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->22237]
}, Open  ]],

Cell[TextData[{
 "You can evaluate the result at the point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "2"}], TraditionalForm]], "InlineMath"],
 " by using the standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " replacement operation. "
}], "MathCaption",
 CellID->32048],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"x", "->", "2"}]}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->24848],

Cell[BoxData[
 RowBox[{"4", " ", 
  RowBox[{
   SuperscriptBox["f", "\[Prime]",
    MultilineFunction->None], "[", "4", "]"}]}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->24404]
}, Open  ]],

Cell[TextData[{
 "There is some slight subtlety when you need to deduce the value of ",
 Cell[BoxData[
  RowBox[{"f", "'"}]], "InlineFormula"],
 " based on definitions for objects like ",
 Cell[BoxData[
  RowBox[{"f", "[", "x_", "]"}]], "InlineFormula"],
 "."
}], "Text",
 CellID->7048],

Cell[TextData[{
 "Here is a definition for a function ",
 Cell[BoxData["h"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->25565],

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "4"}]}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->28221],

Cell[TextData[{
 "When you take the derivative of ",
 Cell[BoxData[
  RowBox[{"h", "[", "x", "]"}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " first evaluates ",
 Cell[BoxData[
  RowBox[{"h", "[", "x", "]"}]], "InlineFormula"],
 ", then differentiates the result. "
}], "MathCaption",
 CellID->22133],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"h", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[15]:= ",
 CellID->13175],

Cell[BoxData[
 RowBox[{"4", " ", 
  SuperscriptBox["x", "3"]}]], "Output",
 ImageSize->{27, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]= ",
 CellID->6241]
}, Open  ]],

Cell[TextData[{
 "You can get the same result by applying the function ",
 Cell[BoxData[
  RowBox[{"h", "'"}]], "InlineFormula"],
 " to the argument ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->32514],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "'"}], "[", "x", "]"}]], "Input",
 CellLabel->"In[16]:= ",
 CellID->12147],

Cell[BoxData[
 RowBox[{"4", " ", 
  SuperscriptBox["x", "3"]}]], "Output",
 ImageSize->{27, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]= ",
 CellID->17362]
}, Open  ]],

Cell[TextData[{
 "Here is the function ",
 Cell[BoxData[
  RowBox[{"h", "'"}]], "InlineFormula"],
 " on its own. "
}], "MathCaption",
 CellID->23954],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"h", "'"}]], "Input",
 CellLabel->"In[17]:= ",
 CellID->29676],

Cell[BoxData[
 RowBox[{
  RowBox[{"4", " ", 
   SuperscriptBox["#1", "3"]}], "&"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]= ",
 CellID->3454]
}, Open  ]],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  RowBox[{"f", "'"}]], "InlineFormula"],
 " is completely determined by the form of the function ",
 Cell[BoxData["f"], "InlineFormula"],
 ". Definitions for objects like ",
 Cell[BoxData[
  RowBox[{"f", "[", "x_", "]"}]], "InlineFormula"],
 " do not immediately apply however to expressions like ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"f", "'"}], "[", "x", "]"}]], "InlineFormula"],
 ". The problem is that ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"f", "'"}], "[", "x", "]"}]], "InlineFormula"],
 " has the full form ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     ButtonBox["Derivative",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Derivative"], "[", "1", "]"}], "[", "f", "]"}], 
   "[", "x", "]"}]], "InlineFormula"],
 ", which nowhere contains anything that explicitly matches the pattern ",
 Cell[BoxData[
  RowBox[{"f", "[", "x_", "]"}]], "InlineFormula"],
 ". In addition, for many purposes it is convenient to have a representation \
of the function ",
 Cell[BoxData[
  RowBox[{"f", "'"}]], "InlineFormula"],
 " itself, without necessarily applying it to any arguments. "
}], "Text",
 CellID->21658],

Cell[TextData[{
 "What ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does is to try and find the explicit form of a ",
 StyleBox["pure function",
  FontSlant->"Italic"],
 " which represents the object ",
 Cell[BoxData[
  RowBox[{"f", "'"}]], "InlineFormula"],
 ". When ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " gets an expression like ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Derivative",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Derivative"], "[", "1", "]"}], "[", "f", "]"}]], 
  "InlineFormula"],
 ", it effectively converts it to the explicit form ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["D",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/D"], "[", 
    RowBox[{
     RowBox[{"f", "[", "#", "]"}], ",", "#"}], "]"}], "&"}]], 
  "InlineFormula"],
 " and then tries to evaluate the derivative. In the explicit form, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can immediately use values that have been defined for objects like ",
 Cell[BoxData[
  RowBox[{"f", "[", "x_", "]"}]], "InlineFormula"],
 ". If ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " succeeds in doing the derivative, it returns the explicit \
pure\[Hyphen]function result. If it does not succeed, it leaves the \
derivative in the original ",
 Cell[BoxData[
  RowBox[{"f", "'"}]], "InlineFormula"],
 " form. "
}], "Text",
 CellID->1721],

Cell[TextData[{
 "This gives the derivative of ",
 Cell[BoxData[
  ButtonBox["Tan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tan"]], "InlineFormula"],
 " in pure\[Hyphen]function form. "
}], "MathCaption",
 CellID->20784],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tan", "'"}]], "Input",
 CellLabel->"In[18]:= ",
 CellID->10688],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"Sec", "[", "#1", "]"}], "2"], "&"}]], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]= ",
 CellID->10466]
}, Open  ]],

Cell[TextData[{
 "Here is the result of applying the pure function to the specific argument \
",
 Cell[BoxData["y"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->16116],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "[", "y", "]"}]], "Input",
 CellLabel->"In[19]:= ",
 CellID->30856],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"Sec", "[", "y", "]"}], "2"]], "Output",
 ImageSize->{52, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]= ",
 CellID->30180]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->665306698],

Cell[TextData[ButtonBox["Calculus",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CalculusOverview"]], "RelatedTutorials",
 CellID->808424779]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"The Representation of Derivatives - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Calculus", "OverviewNavText"], BaseStyle -> "Link", 
        ButtonData -> "paclet:tutorial/CalculusOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DerivativesOfUnknownFunctions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DefiningDerivatives"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 39.1553532}", "context" -> "", 
    "keywords" -> {
     "derivative", "derivatives", "differentiation", "dummy variables", 
      "mathematical notation", "pure functions"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Derivatives in Mathematica work essentially the same as in standard \
mathematics. The usual mathematical notation, however, often hides many \
details. To understand how derivatives are represented in Mathematica, we \
must look at these details. The standard mathematical notation f^,(0) is \
really a shorthand for FractionBox[d, StyleBox[RowBox[{d, t}], TI]]f(t)|_t=0, \
where t is a 'dummy variable'. Similarly, f^,(x^2) is a shorthand for \
FractionBox[d, StyleBox[RowBox[{d, t}], TI]]f(t)|_t=x^2. As suggested by the \
notation f^,, the object FractionBox[d, StyleBox[RowBox[{d, t}], TI]]f(t) can \
in fact be viewed as a 'pure function', to be evaluated with a particular \
choice of its parameter t. You can think of the operation of differentiation \
as acting on a function f, to give a new function, usually called f^,. With \
functions of more than one argument, the simple notation based on primes \
breaks down. You cannot tell for example whether g^,(0,1) stands for \
FractionBox[d, StyleBox[RowBox[{d, t}], TI]]g(t,1)|_t=0 or FractionBox[d, \
StyleBox[RowBox[{d, t}], TI]]g(0,t)|_t=1, and for almost any g, these will \
have totally different values. Once again, however, t is just a dummy \
variable, whose sole purpose is to show with respect to which 'slot' g is to \
be differentiated. ", "synonyms" -> {"3.5.4"}, "title" -> 
    "The Representation of Derivatives", "type" -> "Tutorial", "uri" -> 
    "tutorial/TheRepresentationOfDerivatives"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.5.4"->{
  Cell[1215, 42, 96, 2, 70, "Title",
   CellTags->{"S3.5.4", "4.1"},
   CellID->31655]},
 "4.1"->{
  Cell[1215, 42, 96, 2, 70, "Title",
   CellTags->{"S3.5.4", "4.1"},
   CellID->31655]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.5.4", 28394, 1072},
 {"4.1", 28493, 1076}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 590, 15, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1215, 42, 96, 2, 70, "Title",
 CellTags->{"S3.5.4", "4.1"},
 CellID->31655],
Cell[1314, 46, 378, 11, 70, "Text",
 CellID->1807],
Cell[1695, 59, 2078, 71, 70, "Text",
 CellID->14449],
Cell[3776, 132, 1395, 45, 70, "Text",
 CellID->8491],
Cell[5174, 179, 788, 26, 70, "Text",
 CellID->18760],
Cell[5965, 207, 828, 31, 70, "Text",
 CellID->24382],
Cell[6796, 240, 909, 27, 70, "Text",
 CellID->4836],
Cell[7708, 269, 155, 5, 70, "MathCaption",
 CellID->30219],
Cell[CellGroupData[{
Cell[7888, 278, 115, 4, 28, "Input",
 CellID->30270],
Cell[8006, 284, 355, 13, 50, "Output",
 CellID->19679]
}, Open  ]],
Cell[8376, 300, 127, 5, 70, "MathCaption",
 CellID->1725],
Cell[CellGroupData[{
Cell[8528, 309, 143, 5, 70, "Input",
 CellID->5519],
Cell[8674, 316, 385, 14, 50, "Output",
 CellID->4809]
}, Open  ]],
Cell[9074, 333, 70, 1, 70, "MathCaption",
 CellID->16701],
Cell[CellGroupData[{
Cell[9169, 338, 144, 5, 70, "Input",
 CellID->6631],
Cell[9316, 345, 385, 14, 50, "Output",
 CellID->8324]
}, Open  ]],
Cell[9716, 362, 220, 6, 70, "MathCaption",
 CellID->25807],
Cell[CellGroupData[{
Cell[9961, 372, 171, 6, 70, "Input",
 CellID->12725],
Cell[10135, 380, 336, 13, 36, "Output",
 CellID->22301]
}, Open  ]],
Cell[10486, 396, 62, 1, 70, "MathCaption",
 CellID->30283],
Cell[CellGroupData[{
Cell[10573, 401, 96, 3, 70, "Input",
 CellID->3969],
Cell[10672, 406, 438, 16, 50, "Output",
 CellID->12488]
}, Open  ]],
Cell[11125, 425, 239, 7, 70, "MathCaption",
 CellID->21164],
Cell[CellGroupData[{
Cell[11389, 436, 256, 9, 70, "Input",
 CellID->13963],
Cell[11648, 447, 438, 16, 50, "Output",
 CellID->24124]
}, Open  ]],
Cell[12101, 466, 66, 1, 70, "MathCaption",
 CellID->7534],
Cell[CellGroupData[{
Cell[12192, 471, 228, 8, 70, "Input",
 CellID->27770],
Cell[12423, 481, 437, 16, 50, "Output",
 CellID->2851]
}, Open  ]],
Cell[12875, 500, 309, 9, 70, "MathCaption",
 CellID->13997],
Cell[CellGroupData[{
Cell[13209, 513, 228, 8, 70, "Input",
 CellID->23724],
Cell[13440, 523, 438, 16, 50, "Output",
 CellID->29511]
}, Open  ]],
Cell[13893, 542, 198, 5, 70, "MathCaption",
 CellID->20067],
Cell[CellGroupData[{
Cell[14116, 551, 171, 6, 70, "Input",
 CellID->30265],
Cell[14290, 559, 556, 22, 36, "Output",
 CellID->20840]
}, Open  ]],
Cell[14861, 584, 75, 1, 70, "MathCaption",
 CellID->3379],
Cell[CellGroupData[{
Cell[14961, 589, 98, 3, 70, "Input",
 CellID->24955],
Cell[15062, 594, 667, 23, 50, "Output",
 CellID->16028]
}, Open  ]],
Cell[15744, 620, 550, 16, 70, "Text",
 CellID->1661],
Cell[16297, 638, 237, 8, 70, "MathCaption",
 CellID->2432],
Cell[CellGroupData[{
Cell[16559, 650, 145, 5, 70, "Input",
 CellID->18227],
Cell[16707, 657, 387, 14, 50, "Output",
 CellID->30160]
}, Open  ]],
Cell[17109, 674, 251, 9, 70, "MathCaption",
 CellID->16139],
Cell[CellGroupData[{
Cell[17385, 687, 172, 6, 70, "Input",
 CellID->32666],
Cell[17560, 695, 302, 10, 39, "Output",
 CellID->22237]
}, Open  ]],
Cell[17877, 708, 289, 10, 70, "MathCaption",
 CellID->32048],
Cell[CellGroupData[{
Cell[18191, 722, 115, 4, 70, "Input",
 CellID->24848],
Cell[18309, 728, 267, 9, 36, "Output",
 CellID->24404]
}, Open  ]],
Cell[18591, 740, 286, 9, 70, "Text",
 CellID->7048],
Cell[18880, 751, 135, 5, 70, "MathCaption",
 CellID->25565],
Cell[19018, 758, 143, 5, 70, "Input",
 CellID->28221],
Cell[19164, 765, 335, 12, 70, "MathCaption",
 CellID->22133],
Cell[CellGroupData[{
Cell[19524, 781, 147, 5, 70, "Input",
 CellID->13175],
Cell[19674, 788, 201, 7, 36, "Output",
 CellID->6241]
}, Open  ]],
Cell[19890, 798, 230, 8, 70, "MathCaption",
 CellID->32514],
Cell[CellGroupData[{
Cell[20145, 810, 113, 4, 70, "Input",
 CellID->12147],
Cell[20261, 816, 202, 7, 36, "Output",
 CellID->17362]
}, Open  ]],
Cell[20478, 826, 149, 6, 70, "MathCaption",
 CellID->23954],
Cell[CellGroupData[{
Cell[20652, 836, 85, 3, 70, "Input",
 CellID->29676],
Cell[20740, 841, 221, 8, 36, "Output",
 CellID->3454]
}, Open  ]],
Cell[20976, 852, 1179, 35, 70, "Text",
 CellID->21658],
Cell[22158, 889, 1396, 47, 70, "Text",
 CellID->1721],
Cell[23557, 938, 229, 8, 70, "MathCaption",
 CellID->20784],
Cell[CellGroupData[{
Cell[23811, 950, 87, 3, 70, "Input",
 CellID->10688],
Cell[23901, 955, 229, 8, 36, "Output",
 CellID->10466]
}, Open  ]],
Cell[24145, 966, 175, 6, 70, "MathCaption",
 CellID->16116],
Cell[CellGroupData[{
Cell[24345, 976, 95, 3, 70, "Input",
 CellID->30856],
Cell[24443, 981, 209, 7, 36, "Output",
 CellID->30180]
}, Open  ]],
Cell[CellGroupData[{
Cell[24689, 993, 72, 1, 70, "RelatedTutorialsSection",
 CellID->665306698],
Cell[24764, 996, 146, 3, 70, "RelatedTutorials",
 CellID->808424779]
}, Open  ]]
}, Open  ]],
Cell[24937, 1003, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

