(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18311,        659]
NotebookOptionsPosition[     13546,        515]
NotebookOutlinePosition[     16478,        588]
CellTagsIndexPosition[     16387,        582]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Manipulating Equations and Inequalities" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/ManipulatingEquationsAndInequalitiesOverview"]}, #,
         2]& , Evaluator -> Automatic], {
      1->"\<\"Manipulating Equations and Inequalities\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["The Representation of Equations and Solutions", "Title",
 CellTags->{"S3.4.1", "1.1"},
 CellID->26429],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " treats equations as logical statements. If you type in an equation like ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"3", "x"}]}], "==", "2"}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " interprets this as a logical statement which asserts that ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"x", "^", "2"}], "+", 
   RowBox[{"3", "x"}]}]], "InlineFormula"],
 " is equal to ",
 Cell[BoxData["2"], "InlineFormula"],
 ". If you have assigned an explicit value to ",
 Cell[BoxData["x"], "InlineFormula"],
 ", say ",
 Cell[BoxData[
  RowBox[{"x", "=", "4"}]], "InlineFormula"],
 ", then ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can explicitly determine that the logical statement ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"3", "x"}]}], "==", "2"}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->24537],

Cell[TextData[{
 "If you have not assigned any explicit value to ",
 Cell[BoxData["x"], "InlineFormula"],
 ", however, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " cannot work out whether ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"3", "x"}]}], "==", "2"}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". As a result, it leaves the equation in the symbolic form ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"3", "x"}]}], "==", "2"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->13629],

Cell[TextData[{
 "You can manipulate symbolic equations in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in many ways. One common goal is to rearrange the equations so as to \
\[OpenCurlyDoubleQuote]solve\[CloseCurlyDoubleQuote] for a particular set of \
variables. "
}], "Text",
 CellID->18389],

Cell["Here is a symbolic equation. ", "MathCaption",
 CellID->9843],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"x", "^", "2"}], "+", 
   RowBox[{"3", "x"}]}], "==", "2"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->7004],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"3", " ", "x"}], "+", 
   SuperscriptBox["x", "2"]}], "\[Equal]", "2"}]], "Output",
 ImageSize->{71, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->20101]
}, Open  ]],

Cell[TextData[{
 "You can use the function ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " to reduce the equation so as to give \[OpenCurlyDoubleQuote]solutions\
\[CloseCurlyDoubleQuote] for ",
 Cell[BoxData["x"], "InlineFormula"],
 ". The result, like the original equation, can be viewed as a logical \
statement. "
}], "MathCaption",
 CellID->29384],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{"%", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->12920],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "-", 
      SqrtBox["17"]}], ")"}]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "+", 
      SqrtBox["17"]}], ")"}]}]}]}]], "Output",
 ImageSize->{245, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->31987]
}, Open  ]],

Cell[TextData[{
 "The quadratic equation ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"3", "x"}]}], "==", "2"}]], "InlineFormula"],
 " can be thought of as an implicit statement about the value of ",
 Cell[BoxData["x"], "InlineFormula"],
 ". As shown in the example above, you can use the function ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " to get a more explicit statement about the value of ",
 Cell[BoxData["x"], "InlineFormula"],
 ". The expression produced by ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " has the form ",
 Cell[BoxData[
  RowBox[{"x", "=="}]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["r", "1"], TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  RowBox[{"||", 
   RowBox[{"x", "=="}]}]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["r", "2"], TraditionalForm]], "InlineMath"],
 ". This expression is again a logical statement, which asserts that either \
",
 Cell[BoxData["x"], "InlineFormula"],
 " is equal to ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["r", "1"], TraditionalForm]], "InlineMath"],
 ", or ",
 Cell[BoxData["x"], "InlineFormula"],
 " is equal to ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["r", "2"], TraditionalForm]], "InlineMath"],
 ". The values of ",
 Cell[BoxData["x"], "InlineFormula"],
 " that are consistent with this statement are exactly the same as the ones \
that are consistent with the original quadratic equation. For many purposes, \
however, the form that ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " gives is much more useful than the original equation. "
}], "Text",
 CellID->5136],

Cell[TextData[{
 "You can combine and manipulate equations just like other logical \
statements. You can use logical connectives such as ",
 Cell[BoxData["||"], "InlineFormula"],
 " and ",
 Cell[BoxData["&&"], "InlineFormula"],
 " to specify alternative or simultaneous conditions. You can use functions \
like ",
 Cell[BoxData[
  ButtonBox["LogicalExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogicalExpand"]], "InlineFormula"],
 ", as well as ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 ", to simplify collections of equations. "
}], "Text",
 CellID->29052],

Cell[TextData[{
 "For many purposes, you will find it convenient to manipulate equations \
simply as logical statements. Sometimes, however, you will actually want to \
use explicit solutions to equations in other calculations. In such cases, it \
is convenient to convert equations that are stated in the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["lhs", "TI"], "==", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 " into transformation rules of the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["lhs", "TI"], "->", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 ". Once you have the solutions to an equation in the form of explicit \
transformation rules, you can substitute the solutions into expressions by \
using the ",
 Cell[BoxData["/."], "InlineFormula"],
 " operator."
}], "Text",
 CellID->7582],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " produces a logical statement about the values of ",
 Cell[BoxData["x"], "InlineFormula"],
 " corresponding to the roots of the quadratic equation. "
}], "MathCaption",
 CellID->1528],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"3", "x"}]}], "==", "2"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->6366],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "-", 
      SqrtBox["17"]}], ")"}]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "+", 
      SqrtBox["17"]}], ")"}]}]}]}]], "Output",
 ImageSize->{245, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->1472]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToRules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToRules"]], "InlineFormula"],
 " converts the logical statement into an explicit list of transformation \
rules. "
}], "MathCaption",
 CellID->29193],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"ToRules", "[", "%", "]"}], "}"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->26958],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "3"}], "-", 
        SqrtBox["17"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "3"}], "+", 
        SqrtBox["17"]}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{276, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->4179]
}, Open  ]],

Cell[TextData[{
 "You can now use the transformation rules to substitute the solutions for ",
 Cell[BoxData["x"], "InlineFormula"],
 " into expressions involving ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->28983],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"x", "^", "2"}], "+", 
   RowBox[{"a", " ", "x"}]}], "/.", "%"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->5987],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     FractionBox["1", "4"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "3"}], "-", 
        SqrtBox["17"]}], ")"}], "2"]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "3"}], "-", 
       SqrtBox["17"]}], ")"}], " ", "a"}]}], ",", 
   RowBox[{
    RowBox[{
     FractionBox["1", "4"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "3"}], "+", 
        SqrtBox["17"]}], ")"}], "2"]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "3"}], "+", 
       SqrtBox["17"]}], ")"}], " ", "a"}]}]}], "}"}]], "Output",
 ImageSize->{431, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->10823]
}, Open  ]],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " produces transformation rules for solutions directly. "
}], "MathCaption",
 CellID->397],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"3", "x"}]}], "==", "2"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->11096],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "3"}], "-", 
        SqrtBox["17"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "3"}], "+", 
        SqrtBox["17"]}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{276, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->16594]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->37627051],

Cell[TextData[ButtonBox["Manipulating Equations and Inequalities",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingEquationsAndInequalitiesOverview"]], \
"RelatedTutorials",
 CellID->6804882]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"The Representation of Equations and Solutions - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Manipulating Equations and Inequalities", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/ManipulatingEquationsAndInequalitiesOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/EquationsInOneVariable"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 39.4834866}", "context" -> "", 
    "keywords" -> {
     "==", "equal", "equations", "LogicalExpand", "roots", "solutions", 
      "ToRules"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Mathematica treats equations as logical statements. If you type in an \
equation like x^2+3x==2, Mathematica interprets this as a logical statement \
which asserts that x^2+3x is equal to 2. If you have assigned an explicit \
value to x, say x=4, then Mathematica can explicitly determine that the \
logical statement x^2+3x==2 is False. If you have not assigned any explicit \
value to x, however, Mathematica cannot work out whether x^2+3x==2 is True or \
False. As a result, it leaves the equation in the symbolic form x^2+3x==2. \
You can manipulate symbolic equations in Mathematica in many ways. One common \
goal is to rearrange the equations so as to 'solve' for a particular set of \
variables. ", "synonyms" -> {"3.4.1"}, "title" -> 
    "The Representation of Equations and Solutions", "type" -> "Tutorial", 
    "uri" -> "tutorial/TheRepresentationOfEquationsAndSolutions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.4.1"->{
  Cell[1318, 44, 108, 2, 70, "Title",
   CellTags->{"S3.4.1", "1.1"},
   CellID->26429]},
 "1.1"->{
  Cell[1318, 44, 108, 2, 70, "Title",
   CellTags->{"S3.4.1", "1.1"},
   CellID->26429]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.4.1", 16174, 571},
 {"1.1", 16274, 575}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 693, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1318, 44, 108, 2, 70, "Title",
 CellTags->{"S3.4.1", "1.1"},
 CellID->26429],
Cell[1429, 48, 1118, 40, 70, "Text",
 CellID->24537],
Cell[2550, 90, 802, 30, 70, "Text",
 CellID->13629],
Cell[3355, 122, 304, 8, 70, "Text",
 CellID->18389],
Cell[3662, 132, 67, 1, 70, "MathCaption",
 CellID->9843],
Cell[CellGroupData[{
Cell[3754, 137, 155, 6, 28, "Input",
 CellID->7004],
Cell[3912, 145, 256, 9, 36, "Output",
 CellID->20101]
}, Open  ]],
Cell[4183, 157, 425, 12, 70, "MathCaption",
 CellID->29384],
Cell[CellGroupData[{
Cell[4633, 173, 122, 4, 28, "Input",
 CellID->12920],
Cell[4758, 179, 513, 20, 51, "Output",
 CellID->31987]
}, Open  ]],
Cell[5286, 202, 1850, 57, 70, "Text",
 CellID->5136],
Cell[7139, 261, 659, 19, 70, "Text",
 CellID->29052],
Cell[7801, 282, 812, 20, 70, "Text",
 CellID->7582],
Cell[8616, 304, 316, 9, 70, "MathCaption",
 CellID->1528],
Cell[CellGroupData[{
Cell[8957, 317, 218, 8, 70, "Input",
 CellID->6366],
Cell[9178, 327, 512, 20, 51, "Output",
 CellID->1472]
}, Open  ]],
Cell[9705, 350, 252, 8, 70, "MathCaption",
 CellID->29193],
Cell[CellGroupData[{
Cell[9982, 362, 123, 4, 70, "Input",
 CellID->26958],
Cell[10108, 368, 608, 23, 51, "Output",
 CellID->4179]
}, Open  ]],
Cell[10731, 394, 243, 7, 70, "MathCaption",
 CellID->28983],
Cell[CellGroupData[{
Cell[10999, 405, 160, 6, 70, "Input",
 CellID->5987],
Cell[11162, 413, 903, 35, 51, "Output",
 CellID->10823]
}, Open  ]],
Cell[12080, 451, 238, 8, 70, "MathCaption",
 CellID->397],
Cell[CellGroupData[{
Cell[12343, 463, 218, 8, 70, "Input",
 CellID->11096],
Cell[12564, 473, 609, 23, 51, "Output",
 CellID->16594]
}, Open  ]],
Cell[CellGroupData[{
Cell[13210, 501, 71, 1, 70, "RelatedTutorialsSection",
 CellID->37627051],
Cell[13284, 504, 208, 5, 70, "RelatedTutorials",
 CellID->6804882]
}, Open  ]]
}, Open  ]],
Cell[13519, 513, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

