(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     36828,       1231]
NotebookOptionsPosition[     30401,       1031]
NotebookOutlinePosition[     33579,       1109]
CellTagsIndexPosition[     33484,       1103]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Equations and Inequalities" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingEquationsAndInequalitiesOverview"], 
          "Complex Polynomial Systems" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ComplexPolynomialSystems"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Manipulating Equations and Inequalities\"\>", 
       2->"\<\"Complex Polynomial Systems\"\>"}, "\<\"related tutorials\"\>", 
       
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CylindricalDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/CylindricalDecomposition"], 
          "GenericCylindricalDecomposition" :> 
          Documentation`HelpLookup[
           "paclet:ref/GenericCylindricalDecomposition"], 
          "SemialgebraicComponentInstances" :> 
          Documentation`HelpLookup[
           "paclet:ref/SemialgebraicComponentInstances"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"CylindricalDecomposition\"\>", 
       2->"\<\"GenericCylindricalDecomposition\"\>", 
       3->"\<\"SemialgebraicComponentInstances\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["The Representation of Solution Sets", "Title",
 CellTags->{"S3.4.10", "10.1"},
 CellID->25167],

Cell[TextData[{
 "One can think of any combination of equations or inequalities as implicitly \
defining a region in some kind of space. The fundamental function of ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " is to turn this type of implicit description into an explicit one. "
}], "Text",
 CellID->16966],

Cell[TextData[{
 "An implicit description in terms of equations or inequalities is sufficient \
if one just wants to test whether a point specified by values of variables is \
in the region. But to understand the structure of the region, or to generate \
points in it, one typically needs a more explicit description, of the kind \
obtained from ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->25690],

Cell["\<\
Here are inequalities that implicitly define a semicircular region. \
\>", "MathCaption",
 CellID->868],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"semi", "=", 
  RowBox[{
   RowBox[{"x", ">", "0"}], "&&", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "<", "1"}]}]}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->29926],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", ">", "0"}], "&&", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["y", "2"]}], "<", "1"}]}]], "Output",
 ImageSize->{111, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->22828]
}, Open  ]],

Cell[TextData[{
 "This shows that the point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"1", "/", "2", ",", "1", "/", "2"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " lies in the region. "
}], "MathCaption",
 CellID->21479],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"semi", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "->", 
     RowBox[{"1", "/", "2"}]}], ",", 
    RowBox[{"y", "->", 
     RowBox[{"1", "/", "2"}]}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->14144],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->29703]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " gives a more explicit representation of the region. "
}], "MathCaption",
 CellID->9449],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{"semi", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->18833],

Cell[BoxData[
 RowBox[{
  RowBox[{"0", "<", "x", "<", "1"}], "&&", 
  RowBox[{
   RowBox[{"-", 
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox["x", "2"]}]]}], "<", "y", "<", 
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox["x", "2"]}]]}]}]], "Output",
 ImageSize->{218, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->12003]
}, Open  ]],

Cell[TextData[{
 "If we pick a value for ",
 Cell[BoxData["x"], "InlineFormula"],
 " consistent with the first inequality, we then immediately get an explicit \
inequality for ",
 Cell[BoxData["y"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->22910],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"x", "->", 
   RowBox[{"1", "/", "2"}]}]}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->3240],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    SqrtBox["3"], "2"]}], "<", "y", "<", 
  FractionBox[
   SqrtBox["3"], "2"]}]], "Output",
 ImageSize->{103, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->21027]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Reduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reduce"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " is set up to describe regions by first giving fixed conditions for ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "1"], TraditionalForm]], "InlineMath"],
 ", then giving conditions for ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "2"], TraditionalForm]], "InlineMath"],
 " that depend on ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "1"], TraditionalForm]], "InlineMath"],
 ", then conditions for ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "3"], TraditionalForm]], "InlineMath"],
 " that depend on ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "1"], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "2"], TraditionalForm]], "InlineMath"],
 ", and so on. This structure has the feature that it allows one to pick \
points by successively choosing values for each of the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "i"], TraditionalForm]], "InlineMath"],
 " in turn\[LongDash]in much the same way as when one uses iterators in \
functions like ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->15610],

Cell[TextData[{
 "This gives a representation for the region in which one first picks a value \
for ",
 Cell[BoxData["y"], "InlineFormula"],
 ", then ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->527],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{"semi", ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "x"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->15282],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "1"}], "<", "y", "<", "1"}], "&&", 
  RowBox[{"0", "<", "x", "<", 
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox["y", "2"]}]]}]}]], "Output",
 ImageSize->{174, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->26393]
}, Open  ]],

Cell[TextData[{
 "In some simple cases the region defined by a system of equations or \
inequalities will end up having only one component. In such cases, the output \
from ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " will be of the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["e", "1"], "&&", 
    RowBox[{
     SubscriptBox["e", "2"], "\[Ellipsis]"}]}], TraditionalForm]], 
  "InlineMath"],
 " where each of the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["e", "i"], TraditionalForm]], "InlineMath"],
 " is an equation or inequality involving variables up to ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "i"], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->17187],

Cell[TextData[{
 "In most cases, however, there will be several components, represented by \
output containing forms such as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["u", "1"], "||", 
    SubscriptBox["u", "2"], "||", "\[Ellipsis]"}], TraditionalForm]], 
  "InlineMath"],
 ". ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " typically tries to minimize the number of components used in describing a \
region. But in some cases multiple parametrizations may be needed to cover a \
single connected component, and each one of these will appear as a separate \
component in the output from ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->7863],

Cell[TextData[{
 "In representing solution sets, it is common to find that several components \
can be described together by using forms such as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Ellipsis]", "&&", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["u", "1"], "||", 
      SubscriptBox["u", "2"]}], ")"}], "&&", "\[Ellipsis]"}], 
   TraditionalForm]], "InlineMath"],
 ". ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " by default does this so as to return its results as compactly as possible. \
You can use ",
 Cell[BoxData[
  ButtonBox["LogicalExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogicalExpand"]], "InlineFormula"],
 " to generate an expanded form in which each component appears separately. "
}], "Text",
 CellID->23961],

Cell[TextData[{
 "In generating the most compact results, ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " sometimes ends up making conditions on later variables ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "i"], TraditionalForm]], "InlineMath"],
 " depend on more of the earlier ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "i"], TraditionalForm]], "InlineMath"],
 " than is strictly necessary. You can force ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " to generate results in which a particular ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "i"], TraditionalForm]], "InlineMath"],
 " only has minimal dependence on earlier ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "i"], TraditionalForm]], "InlineMath"],
 " by giving the option ",
 Cell[BoxData[
  RowBox[{"Backsubstitution", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ". Usually this will lead to much larger output, although sometimes it may \
be easier to interpret."
}], "Text",
 CellID->2565],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " expresses the condition on ",
 Cell[BoxData["y"], "InlineFormula"],
 " in terms of ",
 Cell[BoxData["x"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->28599],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", "y"}], "==", "4"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "3"}], "-", 
      RowBox[{"4", "y"}]}], "==", "8"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->19251],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "2"}], "||", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{
      RowBox[{"-", "3"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["3"]}]}]}], "||", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{
      RowBox[{"-", "3"}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["3"]}]}]}]}], ")"}], "&&", 
  RowBox[{"y", "\[Equal]", 
   RowBox[{"4", "-", 
    SuperscriptBox["x", "2"]}]}]}]], "Output",
 ImageSize->{337, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->27318]
}, Open  ]],

Cell[TextData[{
 "Backsubstituting allows conditions for ",
 Cell[BoxData["y"], "InlineFormula"],
 " to be given without involving ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->12081],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", "y"}], "==", "4"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "3"}], "-", 
      RowBox[{"4", "y"}]}], "==", "8"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"Backsubstitution", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->3558],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "2"}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], " ", "\[ImaginaryI]"}], "+", 
        SqrtBox["3"]}], ")"}]}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], "+", 
        RowBox[{"3", " ", 
         SqrtBox["3"]}]}], ")"}]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", "\[ImaginaryI]"}], "+", 
        SqrtBox["3"]}], ")"}]}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"2", " ", "\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{"\[ImaginaryI]", "+", 
        RowBox[{"3", " ", 
         SqrtBox["3"]}]}], ")"}]}]}]}], ")"}]}]], "Output",
 ImageSize->{418, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->28103]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["CylindricalDecomposition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CylindricalDecomposition"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], "1"], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], "2"], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "generate the cylindrical algebraic decomposition of the region defined \
by ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["GenericCylindricalDecomposition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GenericCylindricalDecomposition"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], "1"], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], "2"], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "finds the full-dimensional part of the decomposition of the region \
defined by ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", together with any hypersurfaces containing the rest of the region"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SemialgebraicComponentInstances",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SemialgebraicComponentInstances"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], "1"], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], "2"], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "gives at least one point in each connected component of the region \
defined by ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->6358],

Cell["Cylindrical algebraic decomposition. ", "Caption",
 CellID->15238],

Cell[TextData[{
 "For polynomial equations or inequalities over the reals, the structure of \
the result returned by ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " is typically a ",
 StyleBox["cylindrical algebraic decomposition",
  FontSlant->"Italic"],
 " or ",
 StyleBox["CAD",
  FontSlant->"Italic"],
 ". Sometimes ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " can yield a simpler form. But in all cases you can get the complete CAD by \
using ",
 Cell[BoxData[
  ButtonBox["CylindricalDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CylindricalDecomposition"]], "InlineFormula"],
 ". For systems containing inequalities only, ",
 Cell[BoxData[
  ButtonBox["GenericCylindricalDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GenericCylindricalDecomposition"]], 
  "InlineFormula"],
 " gives you \"most\" of the solution set and is often faster."
}], "Text",
 CellID->7178],

Cell["\<\
Here is the cylindrical algebraic decomposition of a region bounded by a \
hyperbola.\
\>", "MathCaption",
 CellID->192996300],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CylindricalDecomposition", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", 
     RowBox[{"y", "^", "2"}]}], ">=", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->195799226],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "<", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["x", "2"]}]]}], "\[LessEqual]", "y", "\[LessEqual]", 
     SqrtBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["x", "2"]}]]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", ">", "1"}], "&&", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["x", "2"]}]]}], "\[LessEqual]", "y", "\[LessEqual]", 
     SqrtBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["x", "2"]}]]}]}], ")"}]}]], "Output",
 ImageSize->{374, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->331136125]
}, Open  ]],

Cell["\<\
This gives the two-dimensional part of the solution set along with a curve \
containing the boundary.\
\>", "MathCaption",
 CellID->707349036],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GenericCylindricalDecomposition", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", 
     RowBox[{"y", "^", "2"}]}], ">=", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->579428321],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "<", 
       RowBox[{"-", "1"}]}], "&&", 
      RowBox[{
       RowBox[{"-", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["x", "2"]}]]}], "<", "y", "<", 
       SqrtBox[
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["x", "2"]}]]}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", ">", "1"}], "&&", 
      RowBox[{
       RowBox[{"-", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["x", "2"]}]]}], "<", "y", "<", 
       SqrtBox[
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["x", "2"]}]]}]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"1", "-", 
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}], "\[Equal]", "0"}]}], "}"}]], "Output",
 ImageSize->{582, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->144732670]
}, Open  ]],

Cell["This finds solutions from both parts of the solution set.", \
"MathCaption",
 CellID->430565863],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SemialgebraicComponentInstances", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", 
     RowBox[{"y", "^", "2"}]}], ">=", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->130456097],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "2"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "2"}]}], ",", 
     RowBox[{"y", "\[Rule]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{"y", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1"}], ",", 
     RowBox[{"y", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "2"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "2"}], ",", 
     RowBox[{"y", "\[Rule]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox["2"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox["2"]}]}], ",", 
     RowBox[{"y", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox["2"]}]}], ",", 
     RowBox[{"y", "\[Rule]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      SqrtBox["2"]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      SqrtBox["2"]}], ",", 
     RowBox[{"y", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      SqrtBox["2"]}], ",", 
     RowBox[{"y", "\[Rule]", "1"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{476, 66},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->562742212]
}, Open  ]],

Cell["\<\
The results include a few points from each piece of the solution set.\
\>", "MathCaption",
 CellID->26482183],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"RegionPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "-", 
        RowBox[{"y", "^", "2"}]}], ">=", "1"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}], ",", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], "]"}], "/.", "%"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->954484801],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->298864175]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->142002855],

Cell[TextData[ButtonBox["Manipulating Equations and Inequalities",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingEquationsAndInequalitiesOverview"]], \
"RelatedTutorials",
 CellID->6804882],

Cell[TextData[ButtonBox["Complex Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ComplexPolynomialSystems"]], "RelatedTutorials",\

 CellID->65437048]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"The Representation of Solution Sets - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Manipulating Equations and Inequalities", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/ManipulatingEquationsAndInequalitiesOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/EquationsAndInequalitiesOverDomains"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/Quantifiers"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 40.3116328}", "context" -> "", 
    "keywords" -> {
     "algebraic geometry", "back substitution", "CAD", "cells", 
      "connected components", "CylindricalDecomposition", 
      "Semialgebraic sets"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "One can think of any combination of equations or inequalities as \
implicitly defining a region in some kind of space. The fundamental function \
of Reduce is to turn this type of implicit description into an explicit one. \
An implicit description in terms of equations or inequalities is sufficient \
if one just wants to test whether a point specified by values of variables is \
in the region. But to understand the structure of the region, or to generate \
points in it, one typically needs a more explicit description, of the kind \
obtained from Reduce. Here are inequalities that implicitly define a \
semicircular region. ", "synonyms" -> {"3.4.10"}, "title" -> 
    "The Representation of Solution Sets", "type" -> "Tutorial", "uri" -> 
    "tutorial/TheRepresentationOfSolutionSets"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.4.10"->{
  Cell[2490, 70, 100, 2, 70, "Title",
   CellTags->{"S3.4.10", "10.1"},
   CellID->25167]},
 "10.1"->{
  Cell[2490, 70, 100, 2, 70, "Title",
   CellTags->{"S3.4.10", "10.1"},
   CellID->25167]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.4.10", 33266, 1092},
 {"10.1", 33369, 1096}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1865, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2490, 70, 100, 2, 70, "Title",
 CellTags->{"S3.4.10", "10.1"},
 CellID->25167],
Cell[2593, 74, 382, 9, 70, "Text",
 CellID->16966],
Cell[2978, 85, 497, 12, 70, "Text",
 CellID->25690],
Cell[3478, 99, 113, 3, 70, "MathCaption",
 CellID->868],
Cell[CellGroupData[{
Cell[3616, 106, 241, 9, 28, "Input",
 CellID->29926],
Cell[3860, 117, 301, 11, 36, "Output",
 CellID->22828]
}, Open  ]],
Cell[4176, 131, 242, 9, 70, "MathCaption",
 CellID->21479],
Cell[CellGroupData[{
Cell[4443, 144, 244, 9, 28, "Input",
 CellID->14144],
Cell[4690, 155, 158, 5, 36, "Output",
 CellID->29703]
}, Open  ]],
Cell[4863, 163, 221, 7, 70, "MathCaption",
 CellID->9449],
Cell[CellGroupData[{
Cell[5109, 174, 174, 6, 28, "Input",
 CellID->18833],
Cell[5286, 182, 397, 15, 45, "Output",
 CellID->12003]
}, Open  ]],
Cell[5698, 200, 257, 8, 70, "MathCaption",
 CellID->22910],
Cell[CellGroupData[{
Cell[5980, 212, 137, 5, 70, "Input",
 CellID->3240],
Cell[6120, 219, 276, 11, 56, "Output",
 CellID->21027]
}, Open  ]],
Cell[6411, 233, 1618, 54, 70, "Text",
 CellID->15610],
Cell[8032, 289, 229, 8, 70, "MathCaption",
 CellID->527],
Cell[CellGroupData[{
Cell[8286, 301, 174, 6, 70, "Input",
 CellID->15282],
Cell[8463, 309, 329, 12, 45, "Output",
 CellID->26393]
}, Open  ]],
Cell[8807, 324, 780, 26, 70, "Text",
 CellID->17187],
Cell[9590, 352, 826, 24, 70, "Text",
 CellID->7863],
Cell[10419, 378, 827, 24, 70, "Text",
 CellID->23961],
Cell[11249, 404, 1186, 36, 70, "Text",
 CellID->2565],
Cell[12438, 442, 314, 12, 70, "MathCaption",
 CellID->28599],
Cell[CellGroupData[{
Cell[12777, 458, 376, 14, 70, "Input",
 CellID->19251],
Cell[13156, 474, 622, 22, 43, "Output",
 CellID->27318]
}, Open  ]],
Cell[13793, 499, 212, 7, 70, "MathCaption",
 CellID->12081],
Cell[CellGroupData[{
Cell[14030, 510, 428, 15, 70, "Input",
 CellID->3558],
Cell[14461, 527, 1249, 42, 65, "Output",
 CellID->28103]
}, Open  ]],
Cell[15725, 572, 2413, 72, 70, "DefinitionBox",
 CellID->6358],
Cell[18141, 646, 72, 1, 70, "Caption",
 CellID->15238],
Cell[18216, 649, 1058, 32, 70, "Text",
 CellID->7178],
Cell[19277, 683, 136, 4, 70, "MathCaption",
 CellID->192996300],
Cell[CellGroupData[{
Cell[19438, 691, 294, 10, 70, "Input",
 CellID->195799226],
Cell[19735, 703, 1156, 42, 84, "Output",
 CellID->331136125]
}, Open  ]],
Cell[20906, 748, 152, 4, 70, "MathCaption",
 CellID->707349036],
Cell[CellGroupData[{
Cell[21083, 756, 301, 10, 70, "Input",
 CellID->579428321],
Cell[21387, 768, 1066, 39, 52, "Output",
 CellID->144732670]
}, Open  ]],
Cell[22468, 810, 102, 2, 70, "MathCaption",
 CellID->430565863],
Cell[CellGroupData[{
Cell[22595, 816, 302, 10, 70, "Input",
 CellID->130456097],
Cell[22900, 828, 1980, 71, 87, "Output",
 CellID->562742212]
}, Open  ]],
Cell[24895, 902, 119, 3, 70, "MathCaption",
 CellID->26482183],
Cell[CellGroupData[{
Cell[25039, 909, 675, 23, 28, "Input",
 CellID->954484801],
Cell[25717, 934, 4134, 72, 204, "Output",
 Evaluatable->False,
 CellID->298864175]
}, Open  ]],
Cell[CellGroupData[{
Cell[29888, 1011, 72, 1, 70, "RelatedTutorialsSection",
 CellID->142002855],
Cell[29963, 1014, 208, 5, 70, "RelatedTutorials",
 CellID->6804882],
Cell[30174, 1021, 173, 4, 70, "RelatedTutorials",
 CellID->65437048]
}, Open  ]]
}, Open  ]],
Cell[30374, 1029, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

