(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     30622,        761]
NotebookOptionsPosition[     25631,        613]
NotebookOutlinePosition[     28728,        690]
CellTagsIndexPosition[     28637,        684]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Textual Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TextualInputAndOutputOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Textual Input and Output\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FullForm" :> Documentation`HelpLookup["paclet:ref/FullForm"], 
          "InputForm" :> Documentation`HelpLookup["paclet:ref/InputForm"], 
          "StandardForm" :> 
          Documentation`HelpLookup["paclet:ref/StandardForm"], "ToBoxes" :> 
          Documentation`HelpLookup["paclet:ref/ToBoxes"], "ToString" :> 
          Documentation`HelpLookup["paclet:ref/ToString"], "TraditionalForm" :> 
          Documentation`HelpLookup["paclet:ref/TraditionalForm"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FullForm\"\>", 
       2->"\<\"InputForm\"\>", 3->"\<\"StandardForm\"\>", 
       4->"\<\"ToBoxes\"\>", 5->"\<\"ToString\"\>", 
       6->"\<\"TraditionalForm\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["The Representation of Textual Forms", "Title",
 CellTags->{"S2.9.3", "3.1"},
 CellID->5084],

Cell[TextData[{
 "Like everything else in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " the textual forms of expressions can themselves be represented as \
expressions. Textual forms that consist of one\[Hyphen]dimensional sequences \
of characters can be represented directly as ordinary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " strings. Textual forms that involve subscripts, superscripts and other two\
\[Hyphen]dimensional constructs, however, can be represented by nested \
collections of two\[Hyphen]dimensional boxes."
}], "Text",
 CellID->21535],

Cell[BoxData[GridBox[{
   {Cell["One\[Hyphen]dimensional strings", "TableText"], 
    RowBox[{
     ButtonBox["InputForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InputForm"], Cell[", ", "TableText"], 
     ButtonBox["FullForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FullForm"], Cell[", etc.", "TableText"]}]},
   {Cell["Two\[Hyphen]dimensional boxes", "TableText"], 
    RowBox[{
     ButtonBox["StandardForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StandardForm"], Cell[", ", "TableText"], 
     ButtonBox["TraditionalForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TraditionalForm"], Cell[
     ", etc.", "TableText"]}]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->16500],

Cell["Typical representations of textual forms. ", "Caption",
 CellID->10955],

Cell[TextData[{
 "This generates the string corresponding to the textual representation of \
the expression in ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->31155],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToString", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "3"}]}], ",", "InputForm"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->20323],

Cell[BoxData["\<\"x^2 + y^3\"\>"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->650]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " shows the string explicitly. "
}], "MathCaption",
 CellID->6688],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->5939],

Cell[BoxData[
 TagBox[
  StyleBox["\"\<x^2 + y^3\>\"",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm= ",
 CellID->4010]
}, Open  ]],

Cell["Here are the individual characters in the string. ", "MathCaption",
 CellID->26017],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Characters", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->14932],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"x\"\>", ",", "\<\"^\"\>", ",", "\<\"2\"\>", ",", "\<\" \"\>", 
   ",", "\<\"+\"\>", ",", "\<\" \"\>", ",", "\<\"y\"\>", ",", "\<\"^\"\>", 
   ",", "\<\"3\"\>"}], "}"}]], "Output",
 ImageSize->{171, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->14948]
}, Open  ]],

Cell[TextData[{
 "Here is the box structure corresponding to the expression in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->31210],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToBoxes", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "3"}]}], ",", "StandardForm"}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->3495],

Cell[BoxData[
 RowBox[{"RowBox", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"SuperscriptBox", "[", 
     RowBox[{"\<\"x\"\>", ",", "\<\"2\"\>"}], "]"}], ",", "\<\"+\"\>", ",", 
    RowBox[{"SuperscriptBox", "[", 
     RowBox[{"\<\"y\"\>", ",", "\<\"3\"\>"}], "]"}]}], "}"}], "]"}]], "Output",\

 ImageSize->{378, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->26419]
}, Open  ]],

Cell[TextData[{
 "Here is the ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " of the box structure. In this form the structure is effectively \
represented by an ordinary string. "
}], "MathCaption",
 CellID->14648],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToBoxes", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "3"}]}], ",", "StandardForm"}], "]"}], "//", 
  "InputForm"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->4189],

Cell["\\(x\\^2 + y\\^3\\)", "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//InputForm= ",
 CellID->10171]
}, Open  ]],

Cell[TextData[{
 "If you use the notebook front end for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", then you can see the expression that corresponds to the textual form of \
each cell by using the ",
 StyleBox["Show Expression", "SR"],
 " menu item."
}], "Text",
 CellID->15851],

Cell[TextData[{
 "Here is a cell containing an expression in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->3695],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 80},
 ImageMargins->0,
 CellID->2008688096],

Cell[TextData[{
 "Here is the underlying representation of that expression in terms of boxes, \
displayed using the ",
 StyleBox["Show Expression", "SR"],
 " menu item. "
}], "MathCaption",
 CellID->3637],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 192},
 ImageMargins->0,
 CellID->954584117],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ToString",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ToString"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["form", "TI"], "]"}], Cell[TextData[{
     "create a string representing the specified textual form of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ToBoxes",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ToBoxes"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["form", "TI"], "]"}], Cell[TextData[{
     "create a box structure representing the specified textual form of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->15800],

Cell["Creating strings and boxes from expressions. ", "Caption",
 CellID->24407],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->561049842],

Cell[TextData[ButtonBox["Textual Input and Output",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TextualInputAndOutputOverview"]], "RelatedTutorials",
 CellID->364580606]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"The Representation of Textual Forms - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Textual Input and Output", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/TextualInputAndOutputOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/HowInputAndOutputWork"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/TheInterpretationOfTextualForms"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 41.4835378}", "context" -> "", 
    "keywords" -> {
     "boxes", "conversion", "expressions", "raw form", 
      "show Expression menu item", "strings", "ToBoxes", "ToString", 
      "Twodimensional notation", "Unformatting"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Like everything else in Mathematica the textual forms of expressions can \
themselves be represented as expressions. Textual forms that consist of \
one-dimensional sequences of characters can be represented directly as \
ordinary Mathematica strings. Textual forms that involve subscripts, \
superscripts and other two-dimensional constructs, however, can be \
represented by nested collections of two-dimensional boxes. Typical \
representations of textual forms. This generates the string corresponding to \
the textual representation of the expression in InputForm. ", 
    "synonyms" -> {"2.9.3"}, "title" -> "The Representation of Textual Forms",
     "type" -> "Tutorial", "uri" -> 
    "tutorial/TheRepresentationOfTextualForms"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.9.3"->{
  Cell[2360, 66, 97, 2, 70, "Title",
   CellTags->{"S2.9.3", "3.1"},
   CellID->5084]},
 "3.1"->{
  Cell[2360, 66, 97, 2, 70, "Title",
   CellTags->{"S2.9.3", "3.1"},
   CellID->5084]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.9.3", 28428, 673},
 {"3.1", 28526, 677}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1735, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2360, 66, 97, 2, 70, "Title",
 CellTags->{"S2.9.3", "3.1"},
 CellID->5084],
Cell[2460, 70, 576, 13, 70, "Text",
 CellID->21535],
Cell[3039, 85, 999, 26, 70, "DefinitionBox",
 CellID->16500],
Cell[4041, 113, 77, 1, 70, "Caption",
 CellID->10955],
Cell[4121, 116, 275, 9, 70, "MathCaption",
 CellID->31155],
Cell[CellGroupData[{
Cell[4421, 129, 206, 7, 28, "Input",
 CellID->20323],
Cell[4630, 138, 169, 5, 36, "Output",
 CellID->650]
}, Open  ]],
Cell[4814, 146, 202, 7, 70, "MathCaption",
 CellID->6688],
Cell[CellGroupData[{
Cell[5041, 157, 100, 3, 28, "Input",
 CellID->5939],
Cell[5144, 162, 301, 11, 50, "Output",
 CellID->4010]
}, Open  ]],
Cell[5460, 176, 89, 1, 70, "MathCaption",
 CellID->26017],
Cell[CellGroupData[{
Cell[5574, 181, 103, 3, 70, "Input",
 CellID->14932],
Cell[5680, 186, 351, 9, 36, "Output",
 CellID->14948]
}, Open  ]],
Cell[6046, 198, 249, 8, 70, "MathCaption",
 CellID->31210],
Cell[CellGroupData[{
Cell[6320, 210, 207, 7, 70, "Input",
 CellID->3495],
Cell[6530, 219, 425, 13, 36, "Output",
 CellID->26419]
}, Open  ]],
Cell[6970, 235, 294, 9, 70, "MathCaption",
 CellID->14648],
Cell[CellGroupData[{
Cell[7289, 248, 246, 9, 70, "Input",
 CellID->4189],
Cell[7538, 259, 176, 5, 50, "Output",
 CellID->10171]
}, Open  ]],
Cell[7729, 267, 290, 9, 70, "Text",
 CellID->15851],
Cell[8022, 278, 230, 8, 70, "MathCaption",
 CellID->3695],
Cell[8255, 288, 3380, 58, 70, "Picture",
 CellID->2008688096],
Cell[11638, 348, 204, 6, 70, "MathCaption",
 CellID->3637],
Cell[11845, 356, 12302, 204, 70, "Picture",
 CellID->954584117],
Cell[24150, 562, 1066, 31, 70, "DefinitionBox",
 CellID->15800],
Cell[25219, 595, 80, 1, 70, "Caption",
 CellID->24407],
Cell[CellGroupData[{
Cell[25324, 600, 72, 1, 70, "RelatedTutorialsSection",
 CellID->561049842],
Cell[25399, 603, 178, 4, 70, "RelatedTutorials",
 CellID->364580606]
}, Open  ]]
}, Open  ]],
Cell[25604, 611, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

