(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12826,        389]
NotebookOptionsPosition[      8554,        271]
NotebookOutlinePosition[     11625,        346]
CellTagsIndexPosition[     11533,        340]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"The Internals of Mathematica" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/TheInternalsOfMathematicaOverview"], 
         "Basic Internal Architecture" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/BasicInternalArchitecture"], 
         "The Algorithms of Mathematica" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/TheAlgorithmsOfMathematica"], 
         "Testing and Verification" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/TestingAndVerification"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"The Internals of Mathematica\"\>", 
      2->"\<\"Basic Internal Architecture\"\>", 
      3->"\<\"The Algorithms of Mathematica\"\>", 
      4->"\<\"Testing and Verification\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "The Software Engineering of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "Title",
 CellTags->{"S1.12.4", "4.1"},
 CellID->28134],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is one of the more complex software systems ever constructed. It is built \
from several million lines of source code, written in C/C++, Java and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->30884],

Cell[TextData[{
 "The C code in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is actually written in a custom extension of C which supports certain \
memory management and object\[Hyphen]oriented features. The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code is optimized using ",
 Cell[BoxData[
  ButtonBox["Share",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Share"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["DumpSave",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DumpSave"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->17177],

Cell[TextData[{
 "In the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel the breakdown of different parts of the code is roughly as follows: \
language and system: 30%; numerical computation: 20%; algebraic computation: \
20%; graphics and kernel output: 30%. "
}], "Text",
 CellID->14812],

Cell[TextData[{
 "Most of this code is fairly dense and algorithmic: those parts that are in \
effect simple procedures or tables use minimal code since they tend to be \
written at a higher level\[LongDash]often directly in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->20641],

Cell[TextData[{
 "The source code for the kernel, save a fraction of a percent, is identical \
for all computer systems on which ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " runs. "
}], "Text",
 CellID->25304],

Cell["\<\
For the front end, however, a significant amount of specialized code is \
needed to support each different type of user interface environment. The \
front end contains about 700,000 lines of system\[Hyphen]independent C++ \
source code, of which roughly 200,000 lines are concerned with expression \
formatting. Then there are between 50,000 and 100,000 lines of specific code \
customized for each user interface environment. \
\>", "Text",
 CellID->4496],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses a client\[Hyphen]server model of computing. The front end and kernel \
are connected via ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 "\[LongDash]the same system as is used to communicate with other programs. \
",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " supports multiple transport layers, including one based upon TCP/IP and \
one using shared memory."
}], "Text",
 CellID->23162],

Cell[TextData[{
 "The front end and kernel are connected via three independent ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " connections. One is used for user-initiated evaluations. A second is used \
by the front end to resolve the values of ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " expressions. The third is used by the kernel to notify the front end of ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " objects which should be invalidated."
}], "Text",
 CellID->852132862],

Cell[TextData[{
 "Within the C code portion of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel, modularity and consistency are achieved by having different parts \
communicate primarily by exchanging complete ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions. "
}], "Text",
 CellID->12537],

Cell[TextData[{
 "But it should be noted that even though different parts of the system are \
quite independent at the level of source code, they have many algorithmic \
interdependencies. Thus, for example, it is common for numerical functions to \
make extensive use of algebraic algorithms, or for graphics code to use \
fairly advanced mathematical algorithms embodied in quite different ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions. "
}], "Text",
 CellID->18551],

Cell[TextData[{
 "Since the beginning of its development in 1986, the effort spent directly \
on creating the source code for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is about a thousand developer\[Hyphen]years. In addition, a comparable or \
somewhat larger effort has been spent on testing and verification. "
}], "Text",
 CellID->25851],

Cell[TextData[{
 "The source code of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has changed greatly since Version 1 was released. The total number of \
lines of code in the kernel grew from 150,000 in Version 1 to 350,000 in \
Version 2, 600,000 in Version 3, 800,000 in Version 4, 1.5 million in Version \
5 and 2.5 million in Version 6. In addition, at every stage existing code has \
been revised\[LongDash]so that Version 6 has only a few percent of its code \
in common with Version 1. "
}], "Text",
 CellID->2732],

Cell[TextData[{
 "Despite these changes in internal code, however, the user\[Hyphen]level \
design of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has remained compatible from Version 1 on. Much functionality has been \
added, but programs created for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Version 1 will almost always run absolutely unchanged under Version 6."
}], "Text",
 CellID->31565],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->428638919],

Cell[TextData[{
 ButtonBox["The Internals of ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheInternalsOfMathematicaOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheInternalsOfMathematicaOverview"],
  FontSlant->"Italic"]
}], "RelatedTutorials",
 CellID->666254040],

Cell[TextData[ButtonBox["Basic Internal Architecture",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BasicInternalArchitecture"]], "RelatedTutorials",\

 CellID->255800466],

Cell[TextData[{
 ButtonBox["The Algorithms of ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheAlgorithmsOfMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheAlgorithmsOfMathematica"],
  FontSlant->"Italic"]
}], "RelatedTutorials",
 CellID->820035495],

Cell[TextData[ButtonBox["Testing and Verification",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TestingAndVerification"]], "RelatedTutorials",
 CellID->449263826]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"The Software Engineering of Mathematica - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["The Internals of Mathematica", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/TheInternalsOfMathematicaOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TheAlgorithmsOfMathematica"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TestingAndVerification"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 46.1555324}", "context" -> "", 
    "keywords" -> {
     "C language", "client-server computing", "code", "size", 
      "software engineering", "source code"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica is one of the more complex software systems ever \
constructed. It is built from several million lines of source code, written \
in C/C++, Java and Mathematica. The C code in Mathematica is actually written \
in a custom extension of C which supports certain memory management and \
object-oriented features. The Mathematica code is optimized using Share and \
DumpSave. In the Mathematica kernel the breakdown of different parts of the \
code is roughly as follows: language and system: 30%; numerical computation: \
20%; algebraic computation: 20%; graphics and kernel output: 30%. ", 
    "synonyms" -> {"1.12.4"}, "title" -> 
    "The Software Engineering of Mathematica", "type" -> "Tutorial", "uri" -> 
    "tutorial/TheSoftwareEngineeringOfMathematica"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.12.4"->{
  Cell[1823, 54, 156, 6, 70, "Title",
   CellTags->{"S1.12.4", "4.1"},
   CellID->28134]},
 "4.1"->{
  Cell[1823, 54, 156, 6, 70, "Title",
   CellTags->{"S1.12.4", "4.1"},
   CellID->28134]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.12.4", 11318, 329},
 {"4.1", 11419, 333}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1198, 27, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1823, 54, 156, 6, 70, "Title",
 CellTags->{"S1.12.4", "4.1"},
 CellID->28134],
Cell[1982, 62, 299, 9, 70, "Text",
 CellID->30884],
Cell[2284, 73, 576, 20, 70, "Text",
 CellID->17177],
Cell[2863, 95, 303, 8, 70, "Text",
 CellID->14812],
Cell[3169, 105, 310, 8, 70, "Text",
 CellID->20641],
Cell[3482, 115, 219, 7, 70, "Text",
 CellID->25304],
Cell[3704, 124, 466, 8, 70, "Text",
 CellID->4496],
Cell[4173, 134, 468, 14, 70, "Text",
 CellID->23162],
Cell[4644, 150, 636, 17, 70, "Text",
 CellID->852132862],
Cell[5283, 169, 324, 10, 70, "Text",
 CellID->12537],
Cell[5610, 181, 487, 10, 70, "Text",
 CellID->18551],
Cell[6100, 193, 353, 8, 70, "Text",
 CellID->25851],
Cell[6456, 203, 531, 11, 70, "Text",
 CellID->2732],
Cell[6990, 216, 416, 11, 70, "Text",
 CellID->31565],
Cell[CellGroupData[{
Cell[7431, 231, 72, 1, 70, "RelatedTutorialsSection",
 CellID->428638919],
Cell[7506, 234, 327, 9, 70, "RelatedTutorials",
 CellID->666254040],
Cell[7836, 245, 176, 4, 70, "RelatedTutorials",
 CellID->255800466],
Cell[8015, 251, 314, 9, 70, "RelatedTutorials",
 CellID->820035495],
Cell[8332, 262, 168, 3, 70, "RelatedTutorials",
 CellID->449263826]
}, Open  ]]
}, Open  ]],
Cell[8527, 269, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

