(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35324,        770]
NotebookOptionsPosition[     31297,        659]
NotebookOutlinePosition[     34219,        731]
CellTagsIndexPosition[     34128,        725]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Using the Mathematica System" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/UsingTheMathematicaSystemOverview"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Using the Mathematica System\"\>"}, "\<\"related tutorials\"\>",
       
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "The Structure of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "Title",
 CellTags->{"S1.3.1", "1.1"},
 CellID->15760],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["Mathematica",
      FontSlant->"Italic"], Cell[" kernel", "TableText"]}], Cell[
    "the part that actually performs computations", "TableText"]},
   {
    RowBox[{
     StyleBox["Mathematica",
      FontSlant->"Italic"], Cell[" front end", "TableText"]}], Cell[
    "the part that handles interaction with the user", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->3586],

Cell[TextData[{
 "The basic parts of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system. "
}], "Caption",
 CellID->25419],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is a modular software system in which the ",
 StyleBox["kernel",
  FontSlant->"Italic"],
 " which actually performs computations is separate from the ",
 StyleBox["front end",
  FontSlant->"Italic"],
 " which handles interaction with the user. "
}], "Text",
 CellID->28735],

Cell[TextData[{
 "The most common type of front end for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is based on interactive documents known as ",
 StyleBox["notebooks",
  FontSlant->"Italic"],
 ". Notebooks mix ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input and output with text, graphics, palettes and other material. You can \
use notebooks either for doing ongoing computations, or as means of \
presenting or publishing your results."
}], "Text",
 CellID->16616],

Cell[BoxData[GridBox[{
   {Cell["Notebook interface", "TableText"], Cell[
    "interactive documents", "TableText"]},
   {Cell["Text\[Hyphen]based interface", "TableText"], Cell[
    "text from the keyboard", "TableText"]},
   {
    RowBox[{
     StyleBox["MathLink",
      FontSlant->"Italic"], Cell[" interface", "TableText"]}], Cell[
    "communication with other programs", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->20113],

Cell[TextData[{
 "Common kinds of interfaces to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->13335],

Cell[TextData[{
 "The notebook front end includes many menus and graphical tools for creating \
and reading notebook documents and for sending and receiving material from \
the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel. "
}], "Text",
 CellID->28592],

Cell[TextData[{
 "A notebook mixing text, graphics and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input and output."
}], "MathCaption",
 CellID->29018],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnQe8XEX1+JdX0wuEGkoQkKpIUxSlBBCVXiwQxIRIiUgnAtIVIgiIJKC0
HwnSTYBQpAYIxFAEqQbpkJACaAhJACGU+c937jnzZndnd+/bct/Dv/P57L63
c++de+bMOWdOm5mdRxxz8AGHjjhm1MgRQ3Y4asQRB48aefSQbx9+lK1qXiqX
a1o2l1tq7pAc/5tczn81m9NPP92ccMIJyW+jX4Pc76Bi+aTCPkDNc889Z66+
+mp76bLLLnNfffnKtVLr6vgr/+ea8p6l2Odz7tt99XW/W80TTzzh6vQvb6j0
7EC+luI1S3HHUnJ7S3i7a9CXvnw1uWaa3RXAzAXPtuY9y4dOdKCij0neUHCH
QtpW9Li8oAOEXnxF3hN2uLgZ0JqqmRDnbUWISAWN3NhYaP5rcZO6U+Vxk7pT
cWgCNsoMmvK4SY3ihuOmjiNFp+qAmwCaH7qHm8MWk3/GSqsXj3/Y7HvA1e6z
z8irzBlnT7GtVnetJkapCOm7C/9j5r650H1mznrH7DFsgoems9dqkgwlIb1Q
Lrz51iKLk6vdr5aUdT07jbs0o1xviFLL8hhEPaTu5skzzMyZCzqg/G2meKtA
cwrluLEPmYl/fqaxUNYFl+eeM62rcFmBBhXKRx+ZZUYfc3vjoKwLXc6f/77Z
fdcruwqXFeiyp9Tt+N3xZvHijzqgPKsBUKafWxyQCtvhh91qnnxiTmNhSzWZ
l8NgEWfXG8rS1FigR5WDsoizuyUuZ/zjTTPq4MmNhTKVFlgOSvgFvumeuOwl
dcgeZJCH8sw6Q1mT1qhQIseR5w2DMrWKXA7KIh5vBJQ14/LeKS+b006d0pW4
TAElutqPh13fOChrmr17S932215mPvrokw4of5MpLqPzosI2cv9J5qUX/+1+
re+vNhX0hkbdr68V3NIadtjfWnhXPloclJtXvsW10lL2lu81AJE1D/dvxkw1
d9z+vPu1QeS+loK6nKKj4L7WSN1XI3XN0mo4EiWaLHHr1yIQtcRv/W4DMF61
GFCMhwpJDOMxTBb22aOnJYaR+uC5E7fWG891EWQICgRGKTy3RepKU2xlDugE
Gh0eXOe+EbnalA2Sa7JI+0hdOFusXwOSOzBSErWu6uvpER+7NUPUVk2/itrQ
CIyhtip6K3m1oK4TBP7VePXnQSQrqkMtdz2Pq7Z8rLn/2iOtbJZ/tUMdKNlK
R129dYKaTBNFx7QHXzMn/PIu98tdGZPpoKXkj3nzFpkffv+axkJZtfuhr9QB
IZB6KM/oTrhUKBltRr1hUNZElwolLAqrdiGUgsvdBLJcbm++vp3pmFYQan2D
OnXW9Ktwn9Z11X3dCZZ637ej1HULj0kIoFjT3R6B3QmWzwNxVD0bKNChOvTl
yH1bReq2THlfrK7eSKgpbqBICJWgGBLcd8xW75ZDWuS5P70BUFYdX+gvdaF/
z135dXfCpUJZ5BOvN5Q1KUsKZZESny0uK8QXFMoiumwElFXjcoDUFcVjf5U5
Lot84g62JjP+8scbgreaXHCKN3AG7roIbylHF/8VNGj/Ng7KqnE5UOqK4oWn
ZYrLChJcobz6qifNxRc92jgoa6JLhbLIdZAtLivQ5dJSR6wwL7/r1AZAWTUu
FUpGm1FvKJRV06VCWSSJ6g1lTXP2MlJXlJN0Sqa4rDDiCmUYMmwYlFXr7wpl
kf7Ttbh0QCpsRTNOvWFLnfMdw+AgqSuacU7uUgyWgLIo96MRUFbN2Qpl0Yhn
i8sK2viyUgcewafH5Ul1hrImKalQFo14vaGsacZRKItGvBFQVj17Lyd1RbL8
xExxWWHEFcqi2bveUNakVS4vdUWhnhMyxWUFulQoi/S1RkCZHpcOSIUtTNno
AgxWoMYVpK7IS/XLOkNZEzUqlEXBsnpDWRM1KpRou+TreinZCCirnnFWlLoi
KXl8prisMOIKZRH31BvKmvzqK0ldEfcc151wqVAy2ox6Q6GsWkNXKNExmHXm
z3+/i3G5A3UOyJLpr7FUsMFSV+Q2OrbOHUmteH4nAmWJxKdY8Ec7xPoDRsbL
tXp3KLW+vw11DvbCRMZOdm1lqSsKf/yiAV1ryFi51yjvFPkAG9GNVPNjyW40
l2KbVaSuKG1ndJ37kFoTifUhllcYIyztTdH8Ve/epNb+nDQryOiLQb6q1LFy
ixVcHvJjGgB51RqhQlnkEWsElFVrhKtJXZF+cHSdoaxJu1Yoi3BZbyhrslSG
lMLlUQ2AsmpcKpRFq5obAWXVdLm61BXJ2iPrDGVNvjGFskiG1hvKKrzeXyiF
wSMaAFvV9olCWaS5NQLKqu2TNaSuSAk7vM5Q1hRBUCiL7JN6Q1kTLteUuiJP
yWENgLJqzlYowSWcPXPmgsZBWXUEYS2pK5Llh9YZypqk5BelrijO8fPMcZkC
SiQROQCLF3/UOCirnr3Xlrqi/RUOyRSXFUZ8HakryuD6WZ2hrEmrVCjJ9oDH
/dxTbyg7R5cOyHWl6SIXzagGwFY1BteTuiJL7OBMMRhQo+Jt/jvvmzunPG9m
zV7gbcg3Zi9wdfaanytjvSmih3r3JjXVqo3+0ZJPzJy5C80nn3yaU3/SZ599
Zj788GP3qym477nn3zJXXvd3v2bO/m9eeOlt90u1rbDXusixiNIOynQMAy5I
XF5Lm2smPmF2+eHl5tQxd5mfHXWDuf3uf7rbZ89914w+8VZz7Mm3mUNH32Tu
e+AlM3feQnPgYRPd/1dd/3d33+8ueMAcfMSkJnP0CbdYKCdOftpVc9kiJEYB
umC5SG4d2ABcpJpPE89mu/nXv99zOGA7OMoSO9L8XvDuB7aRW++YkSzANmPO
vdfh4ImnZ5tLJzxinn/xLY+PJ56abU4/+x7z8ccdVCTI4GOBv+Kax2wd71KM
qGc1hiWiSPDJvHmLGoelVHqmQmnxYK6blERZE57oben/cXP3fS+YG295xv2l
/PnGp2JY8nw07aFXzRHH3Wyee+EtX6eYWrT4Q9uBmbPecdrhx2Ux9SWpQzZC
U16iHFBnTKWOESmUf7hsupky9cU8TD0w/RVz4SXT8zB1w83PRDHVLHSJnD3i
2MnmxZf/5e5XLFl+tMA/8NdX7J0LF/2nLJZ0nUeRRfDTrqanRx+fydaQAZYG
OakCfTCTTHv4Vfc4/z/06Ovm5DPuNMNHXWfuuf8Fz3VcA3uU+x58yVx2xaMh
pmJiaEOpKzLdRzYAIanMTRVDEDxi5/Ir/2aenTHPTLj6MSd2P/hgiUyzffNI
5czf3eum3Vdfn48odsw4+qRbYSxXj7hC9JTDQpEJ1ggspCKLleXh997/yDHJ
2IummUk3Pw2B+4AB0/Knn34mv5LvdxZ8YJ5+dg7Ts1fgw55+ReqKFI/969zT
zplxDsiNpOmi0OyITEehgiG8sdQVpQwMbwCUVRvCCiUUjbluVYzGQVm1IbyJ
1DG9o9h7vvtJnaGsyXjbVOoIKAKld3btlykuK4z4ZlKHgxgoPWf/uAFQVo1L
3RqmyI20b6a4rECXut9SketjWJ2hrIkuZbsRXSBWb9hSU2NhakhrCGUCai4e
5tYdfIpk6d4N6EvVYe7WSF0s9K1bPRX15keZjkxA2ylSQ9zVWA+3KNUbJcXM
NYXS2SAddZ7S3DtKjsgPMh2RCvTlXlIyg+pbpfrw/Qb0IZVh1/k+6N4BRX3Y
q6vGoSABJAV3b1WqD3vWuQ81Bea2ljrsOWYvD+UeXYXpGJTbSB1za54jcPcG
QFm1Dj1U6nBXElDyGtVumeKygj2yrdQR7kKj8sGkXesMZU2Bue2kDlcn2ql3
5O2SOS7LQLm91GEdAyWb57grOzcAyqr1Pt2MivAhUNqRTy7ulCkuozb8DvIC
7E54BiebbB9pst8KrwwSdZtCPIH4S71R1632L1SU4dXFXWP/Jhe/kxKiTAhS
N8SBIMGlnXiSizt0KUEWQLmTvApyZOKBPGUtttk+JVCZkKaKRCQ66QF+0LdL
CVEmpKnTi0oha4YmF7dNCVEmc7gqFBjJefPONikhykQfUuVM2dzql8nFrVNC
VPfgTQzKPeVVMA1aMNqGHMNgtkwJVCboVMsIJxMM5NH5rZQQ1T2oEYPyB2XQ
uUVKoBqY1KlOiyIkfqPOsNWkV+5dgESmH9lSxWyeEqhM1PRh8ioUYNCJ2aOz
z1dTApWJxFR3MVZP3rhvlhKiTGaf/eRVMAzjLtq6u7hJSqAymcyHy6tUtKN5
KJdvlBKoTNSj/eVVeA1I6WXGVALdMCVQmWibI+VV6HEACZFKprT5ckqgMqHR
A+RVDDd2EFiVGLvZICVQmdDoQfIqAlw4jqBTBXS9lEBlQqOj5FVweiGg66QE
qjE06uA8pAx4X2wAeFVT5qFlAF2zzoDWNL0fXgAoLCTOV/OFlEBlonIeKQ3C
QsxHbHmAUPI+w9UaAG3VmvzR0qBKJqBFlHonyCopIcsEt6OlQWYjoARacOzt
4sEpIcvEA3+cvAoyRSsRD527uGJKoDJB6y+lQTQTfCGgFa3Um8jLpYQsE7X0
RGkQkkU1RRJgMXnn56CUkNVd2y+9MwKPuV+tkQ6dIu/EvoqiX/eyzFwQp1nq
nSvRq2SfzbbYMHk/sG5ZnflUWD4cHutOLBB4emTg0Op98pKeX5K5JhIbuFg4
1vXeveN0uQfRiuKPLs2H/9VK6ZnpcFWgw5LdKag7S+7GF8DgMEjQIVJZrRpt
K3MdvMYtSM6RvkGAzINsQqcL3pTHFCeZ81hHYL0t/7+CTpwnndC9/mKd6C4W
5/nuu93BVQLe3CeZIrzCZHlBGYCFA3If1RngmizQPxYArGQNy4osyn3QVSQd
A/hSIV94UOULVhRznjVWFmdOvmVgvVyQixGFhgGcOmlh9UG+CzIn3zLUcIUA
zAzE6GP5cQ4h1IBRxUz778zIN4U9dbUADDVgTzGFqpUCOcNvb3Yphh281wV4
RQyoWMBEgTAs+Lk5mVJuBS6bJABjosBZEMBW37rYefn5jQU4sztR7mQBGC8/
GAWzSrkK8CuZUW4K2ZBsudrDCV6otxBo7G3bmRcyRXKFUMod0qzCDIxQBJQR
kLLjun9kSs4VkD1FkB2SM/yncQF40sq2pzJHdhmYp0qzTB7IYkQa4k1nZyEQ
N4k8ljlll6GSv0qzaPshlUDZdICO0CFY8uFMMV6BSh6VZjFdoAgoA7JWwccE
Qz3JaQ9mTt5lMP6ENAs5ME2DYUg7Bvi93YnGn00JOKRyZ3ei8SQLuVce4Eoq
/OU3gkYY9JYuJXMH+isCMSIQlCKrlSvxFfE/nIrWZO+5oTvRd3JQQm/n4wej
wIkKpRiHZFBVqUevRk29tjvR+ZvSAWQ5AAIoACMOlWToEPWITBj1iszpvUwH
3pEOQD1QCIAyCSmzhiPAdVY9Xpo50ZchIbfbQa5P3giAcVVfMBpU4ujMau+9
IDM2SGHsLHHffZ0VoYJHJ1cdCGVl3Yue+2CHc7vTYLjvJumNMrXuTQL0yhf8
jfWm3udR1xR3ct9Jq/2c7pCmN8rpMkF0q/Nf3HdyhFv/vA4p1+u8oaKrRKdy
XbZ9ccleJZvjJ4ZAmV418cMt8Gzitmz31qtghLnvIXw52ARKB6+F3JrAiAL6
gvpK35jtlXHqvXtLFZsNuKtJzkgyIQIb9gCwaiahsgzGDr/t+ORcT3PJBrE8
Q7yuEUusq57l3bfu84D1A5S4dhLIW90MSW8Q0vTOUlvODV2u2U88pPC7gd1D
AL94/MNm3wOuNnvvf5XZc98rWmvsXdVKmPtO1g23OQ8AvQunIUtvAR22+qlI
pQP5jDsKVGxxNPfNhWb6I6+a3YeNN+8seL/r7D73va20qtORSgfbu5wu72F/
j933GW/22u9PuVrGoSbTw32Pk/cB0R77TjD3P/gyb6yVOGoj/bHSqgLFX3lr
TeiqnWzPF7INIaPImxuHtjSU93u5MGv2AjPu4r+ac8beb1uzLG/r2BoN5i8F
Ud0pztX9W1pQLtVPxw5ADSYxV5c27FSTplCXN6XStGp+U+pASd6b3v7XYnPa
mXfnvSms69o+pQ5S/FeMU7a0F+iRDR6noE+69VWlvTk1X/z+++839913n3n+
+ef9yVUfffSR+fe/EyGku+stXrzYLFq0SEBLQJ8zZ457lg/XKZvJHao18dln
5FXs8JaN6FIEsDMa23Ia05E7E27TqR1rbm42W2yxhTnnnHNyvaRu6623dk3y
S+t+97vfmeWXX96MHz8+et+ASJ3me/3tb38zK664ohk+fLhH3s0332y22mor
07NnT/Pkk0/mIS+U+zNnvWP2GDYhG31niDT71tuL3Y6DlEOOvrFJsDjqyBvy
NrvM2/yzrXDzT/e/HXtNqX3//ffNkiVL8iDn98KFCwOySkYkn9QSktQ6TTb8
9re/bXbZZZe8UVp22WXNSy+9lFcX3jcgUtc/eAcj/Prrr3uKWWuttXR0EoTp
BkmZe5LLDk170dCU24c0RCK/r7jmMbcraVNkb9JmgXn69OmmtTWBvW/fvgym
b+O9995zdcCf9KOnaWtrM4899lgCiyW/vffe2/Tu3dssvfTS5oADDjCvvPKK
3zRp3Lhxvu011ljDXHDBBR5/ITG0yPdTTz1lVlppJTfYkyZNUjDOOuss14R9
nYx97/BxV56f85bZ+tRxZqtTxpqnX59jtv3VheabJ51vLrv34VysnR5C+fvt
t5+r00+vXr3Mm2++GXtESWfGjBkOCx1YaTbt7e3m008/zRuBkMRaI3UNI7uq
JcLPjrpBgQ/ILpdmY9ew44sWf+ikG9u8NkU2e9XEQOTGdtttZ4YMGWLuuOOO
pIt9+deMHTvWAX700Uebm266yfznP/9xbLzKKquYwYMHmxtuuMFcfvnlpk+f
PubrX/+6p7g111zTfOlLX4J6zFFHHWUOOuigKMWp4IP6KbyHsb7zzjsBSXsC
gQPG7rvvntOkUZiiR48egJRTJv1wycfm8vsesdQ3zjw7c6757piLzLFX3WLm
LViYi7Wl1GeZxdx6662uG8OGDXMT7meffRZ7pE1ehWD91re+ZVpaWsyvf/1r
88c//tHxqK338mCjjTYyDz74YPaUl2oiHyJNhJT3oxFXut/WEHJbnebvlNur
5E65lJdfTRZJzp23MLZprgqX/fff31Haddddx0yi3WIIAPTGG2/0Q4Ucou6U
U07xlLLvvvu6OpnUzHLLLQfVJHstFcuj+fPnO2KFCK+88kqz7rrrOq3guOOO
88PEfPbaa6/JwBo/V6266qq8zmsUF98z3Wx58ljzs8smQmktkceVOJHCUEU4
cOF9bTJw7777rtl4443N6quv7jBgZZe/H4VomWWWMU8//XR21NNJTWZQHvWc
MuYuc+64qeao4292QiqcLyvsIOz+P/bk2/oKeqCScD744he/aN5++22ljBi1
vPjii67u0EMP9dSy4447OpL48MMP3RuY0Y4//ngd5ZgoWrBggfnRj37kdNbf
//73bvK0ErKvPMLsMnr0aLPpppsKUlvddrknXHub2c5OdodY4ljy8SdeEQop
oZ8Mxb/+9S9HiIz6O++8o2Oz8847u2ncznuVB/yFl95ynp7MHItDpMFgwOUl
vTu1S3L/YIQ32GAD88YbbzjhyWutjVB6hPs5PG+++eZOz2EMDjzwQDeEDNe8
efOcbtPU1OSur7DCCubLX/4y45VA2atINnzyySfmT3/6k/ntb3/rIGBI/vrX
vw6QTtFSePvbCxebk677i1Nn/v7KLPO9MRebo6+YbF57e75XccPR7h/0hIll
xIgRflRS6SS6eL9eXtlO6iTWoPjgI7dvOr96SF24DfQywVAy11EeffRR1+xp
p50WG8pE5vZxw/XDH/7QIYyhOvjggx2yYVTGA/3vm9/8pjn11FPNhRde2Cpj
UjiEl156qdlwww3Nd7/7XUcNM2fOdKoMemL/Es/8Y9Y8M+z8P5m9f3+FefK1
2WbkH691/0/75yvRcewrqHzmmWdUtzTf+c53zMorr9y58dxMRqsrfNpbC97t
ZOJssH79+jlh+I1vfMOccMIJdsJ33hPz0EMPmT333FPHq7fAwYR9+um6psd4
dmIYmSop6IHrrbee2WabbcyoUW5BNRyrgpBLkydPtgbTx7llpZOoj6iJKFG/
+tWv+kkPGVF4mZbQ6O3IigxocTLghRdecMDbyV21Ctuq02N5rNDar7e7vpPL
3awy9MAD5gc/+IHZa6+9AE6RauW8TkzeqEF0odUecsghfmKDpW677TanHCwt
dbfffrtTP+0MldPVlHhBzjjjDGRYTlGJ2+jiiy9G3zH33HMPMs+3i2sKEUkb
quPAULyfD7RC2VQg7JLgQujge1taLQ4ktIaBBFcuHv9w6iBDTYksrq5cQKGp
zLUY7mrH06d1IeRC53TaVhsDa+cCHvWBtdDBXB+8loK1tqBFLaOVPnBWPxqo
BtbOBfnqRwP/w6vAmiyVb3EzAxrbueeeiwGzt7SJBXbmmWc6pW3atGlusnHN
LCs3pA1a1DRMJ0mDX/3qV50Pi18JhG1OxScwgN6CqmMNDqdRUAbJS9MGB2qS
Urr9JsoTSiVuI13djVNAnZiqF+BukhCQV8UBnHuNVzpb1P/vikW/znao0kz3
drC8i4PH8UdYFcS7QvDvSfHgWLPbWaz8UgsW8DCf5DUJKtpDKF3hFdz23nvv
+VdwD3UQhyzktcpbL+kt9hhogpT+/ve/m5NOOsnMmjWrR+ThXgKL6p9SXHM6
XmEfewZtaB/nRca17rqLbmuH/wmT36qvohQMICzo6tZff33nKvzCF75gDjvs
MDN37lyz2WabOdOWQbE2kPOB4MciAoaxYzGdNLOs04jxFaHKv/XWW/hiza67
7urU+sMPP9x5/3fffXdz1VVXeQcHxjdQUu666y5no2666abmmGOOcfhtFmIj
yoBnE67G6wZY1jRAYYePmmXk7r33XmfJnXjiiQ5KSG7OnDl6mZ8AjaGNHgxF
2aebMNdyztdvXn31Vafy33333eaXv/ylewkFUYIxZQ0MPbELVRcb7ec//7mL
pP7f//2fw741KAS1/Z0jFx8afcavTMGxy32oz6CeoCGeBF5PyGqPPfaApbwz
CPUctIMv1GjunzJlSnJ5vbSodCNPhAMWBI0UTFWCLCNHjnS9RZt//fXXnQaP
9Qv18/qvfOUrDsRnn33W7LDDDs57aTkCd4KznaCUX/ziF64tnv/LX/7iwATh
mMVWRidYW98ZSUg8MIA3H+6IgcFAlGoeQYvRiCTFQkYSlAITKRsbVDiwVPuM
kMV47q0aODN1IkmyGeYyhCcccrQQW2AMiQlQdtppJzNx4kT3/6GHHup8grAC
40QHKDhBLBnmNHzC9MMUQ4EFmSshVRzWeEQoWHYMAIKCEImaCrgwqKPgurjz
zjul3XZnHEMbWLvQGgXythLCBxN/85vfmJ/9zJ0A6waWa8nzA/1UQLniiivc
hE2BneFdCnQL61AYLHXujBkzxhx77LEy27Q6YtG2wIdlSc9+9A0xpAU+gTgo
xORVbG+77bZYrO7/k08+2Zx99tm+H+AJfEGohISs5JN+rKg48+1HcOasZuAH
V+uss46byvDpImEpiA1YnoI4WHttl93gXPVWKktf+jjXBxY0hRnq+993G8E6
iQ0OKEQacIHYKTaZtJd3UgU/hZZSry7VJM5ghgJUIS+JkuWDNjAPtFLDVqp9
eNeK6Jp4LfUsuIXQBfRy/vnnO6cIH+gOEatqWIzX4MONN97Yey5wL02YMEF+
GccXX/va18zDD7v1luaII45wiLj++uvhA+lMWx7NMKuuvPLKvLddmkCGqfMI
kvnJT36i7OpJknEAl/zlNX/4wx+8GxzWmjp1qichQgiUkLUIRlkwvT8LOfqP
f/xD71HOQnyCHUohZzG7HnnkkZ6s4JpTTjnF/R9yFmK4kLPUXwbozNiQlBXP
FRDUIm8GUOY65hUKc9Xxxx/v/r/mmms8kYW8xP8IdHXih8+EhMksr4QJn4LM
8ePHu/utppOAsLS7xJhoKQVCrGnoHcen11p6KnTR5vKHqt0PVaTp1JtG1JQj
+E15mBjoLbfc4j5E2hHvCmSMfWbPnu3UrJB9QK2pwD5oWVaLtM8lGSPoDlCF
UInOVltuuSU3uA+PEbBUggpZCnpESluFPDRX0ES+973vwUnhHKWMxByKhkwJ
GQk6pGMUFBA8liTMcY9Vg3NpOIl7VWBSUExJeaCEnIQCo5yERWLncm8SPvLI
IwQ7uMcHBAvnJoshQeLSiiEH+4ABA5zKriZJJ/ipM+xkMeuCLRQrBNBk68FO
FGwRy1bN0lw5dio1YJGma+WmVBOSchMTCUoY+UTYFBirepowNgFUT9ltt908
IdFttX8hazvxC4CDHCdhc+gzoJHJDe2XgvKG5ktBUUNJgjBRdjAONFaNKfjP
f/5T9T7iJ8gChJgKs8cffxxzz09O0CKKNQX9j4ib8hT2CEwPKJhNJIlRQp7i
f3GZOEVcR5l6C77Q/HJ5PPXyyy878xKLHf0OEkAXpsA/TCHoyOjXxHkYAYQI
PI1co2CqWTTp5AR2wC6qgtWBVONLgSxn/Ujgzhl5hUTIG0txlbUx/SxF2/oM
MRFMHkDi+UMOcdvxunfpPWDTEkoC6vJl2SoEoVTTKNoMLgW6YVDyQRyYB2Kp
gSvVPii0FlmDrKwCX9c3pVlGHWbCc2itCFWu8V1AUEgmomRMGaoMggOICfcH
LhLLZwl4yzg2gyJQorkkCdXO0MSgZCLEPsJDhraE4o3ewl9cJNQxkVo0Spd7
uNcxm5F4pOj785//7NJIrF6vbAYpI7ZRSwEBj0FybYCLEiMdGDX+0jMIs5DV
cB1YJDhVGGoAm1byNDkbZ7DTXMPClE5sE84ligono14ymxCcBWE0hYmBmwWE
UbCAsESJtNKzffbZx5kA9BysIT2U7S666CKnUjAQjz32mMr0FAh0r4LZyd1D
40D44AhkQsVCsfTWhCVqWaOQ83gE1xWIZDqghzwCtaicAlFoY5rwCjljt8JW
yDXsa0twwho9nNsLKYDb6rzzznPPFYGyetlXYEJiV11yySXOcwYWSoFaajzL
tc8gbL755g20vYLolZ5OArX079+fnBvv3kUZxBg1XhlsdrylqQvLSp2ypHEz
QFKH3iME7T3V8A4k0NGRFueDYGqn2HlrY+kLfKFkALVYvdPrqOHr+kszTHko
4dLMQGlGHvW8Yh/N/UceSbG4tCY/vmIWxebHP05W64bxfdjfqlses3SZGdFi
12NxtdVWUy+Sxzaus6FDh4Jd73SHa6B41HqrpeoZDyiPUKHFpFdKxTJ1vwbI
4/xGYiFfZ82aNShy6/tyq4ZAnpkxF8zVPUSzZQC6DrJijYHXnDzFGqJFMyUU
QyrvQ3pELjD1GtOxNoRncSzyS8/vUJ9d+A6oSPT93MDgHVbuu1+DIve9J0gI
41qSbJA6ZNS5oOZiaaGxyQSfl4BntcHZrggkZ4vXrkkmqC7xobsllMQSfLoW
1v/KRJ0jpEE0JynJfcdLq7FsgaYy1+o3TUm/dVsUpinx1Xs1B91OvBnJs3pO
Ryx9IJYC1tnUgtS8pVBjIqAYd6STtzqNdtCgQW7NAWYBaohr4+gIFJmsQjlM
mtW8ekKbEyZMUIDxT6uWgKNo2LBhjQM4lZhVgLEL8bdQrK2hGQq4QzDU+KUJ
3CGtjJA6PE6a5NGIrURTTUSHycMaHqfgeiBHVwkdnw7270knnSQdipPRfnKN
2CnuB+wyHDlTp06tewdTz996bhL2Ku4gzGEfv08yYHWBltoq6J+YtcRZrR6q
XY4RonaZjCLC+xRcDqwTy3ZMA4b6uTSIMx+jk1/aXzrA+JpAkGETEjjkl55r
GBLxjwUYRIl6FdCfSX/Pfg9cGdejpEEMUCleyOIHwzeBy0RCE75jITHr6GGi
EYTGwseOIhDfZRypHaOfKjK0Y1AmwRIiEHhfsXO/Fqda7RvuHvoHs+IAee21
17qOGbVvrPjBs8avrSNUqHte4ThnoQW/Vpc6Vg3ip7IDmfNr36ydTd24cePk
jKQuYDudjzQQyy+NMMQo8icCBsFcvJ5IJ2tqrhbgQ5v5eqSuy3aeW1carLT/
xVZSh8NCNyVQfMQIeTkBF8cHXgqiJNac16Zxq+LYthZ5bi2pwwqnzopm7wEg
aohQuOSSSyo12RUoTqVu634OHy35xMyZu9DC3LHFAKj78EOXqeSlOvc997zb
jcMnd4Y7cSTelh5uRmBtFfjhA9kxBPx/8MEHN7kQZrOrUmfLztIP2O6nP/2p
cwxCwRb1vt/ITFxTxM10aPCQU4f7asMUbWQ9FqkzxFZ2D/c310x8wnl2Th1z
F8vzze13Jy792XPfNaNPvJWlq+bQ0Te55XJz5y00Bx420f3fsXi6zW0XoYuk
KbL0dZzALKm8cnNSR66lBMI9CYR4WbtMXTXtdSs+SA7fa3fbZYBzrCfKEkvv
/F7w7ge2kVvvmJFQvVthCs5ZZnzphEcKFq+3xvBvn7cj0BLZl0PVqCAQ4xdf
ESDBadunTx/bwLrrrmuZi3CmhlQJtpAyQLASNdhiUxNK4V+mA3gP0Y/aaNXH
GB/0ErAJMxKqISGRUM8uu+zi2TyETgPFZFiS5ULAGMmLBGYt66hRo6JjruIm
m16pMlPPXrVV+VzPCHzZTqyBAqFHTVp6NtdNejJAVm+3lvru+14wN97yjPtL
+fONT5Wh9vZS0oZdQSzwxbuBKMGHyEgW+A5ysRvSybXohjOIeFYsaoAT3zuZ
2joQaHBhujjbtUyePDlGFxqOImwrabOeHsL7WoXkmMw1GYAZCE3XJ6LkP7Jq
dr3Quhp70db5R7Ki5U5I7mbzh8ummylTX3S/lJYfmP6KufCS6Xm0fMPNz1RF
y3amzcX2GlEVD3OfHGf7se+339pTgpuEyln6uof7bvbJ3iFGtAFLJkkDrZEG
WqQBzeruaKBHEc2hx5Ltgr1i63VqgqxUzmKfWtrx6h3baBHyNyXmbL2vqLMK
a0iMhZjxHWsTsEmbJlOLh6wWFyPykthVsu1GyIkxZGdx0Nn7e0XgyE6BLbDX
lBUffXwmTvKAYga47eXYpwWbbdrDr7rH+f+hR183J59xpxk+6jpzz/0v+D1c
3nv/I3Pbnc855cuyY2zvKRXj2Fy4OO3Hvs5+Dy+4gAfGXVimBDFgQrB0C4xv
scUWbnCbSD5JxtmlorDNg0JBgmMaNimCrBybFEGrJA52SV2wmo6/OcYjRW8b
lFF3yxF+ql61debm3hEIsp19grCN2g1oN5Dq5Vf+zTw7Y56ZcPVjzi7riJX3
zZtxdAcb7ItHHptp9jvoWj/rhDvYHBPp7DJSFwyrDEs/53wmsRS3MT6LKVOm
uORAXR0EIsmL5jfpRiTGWmW7HloSFMIqEGJskhhdXktqeA86qyGV6EE5DanE
I12v7Rf5FVqdSEUTGnvRNDPp5qfRYjznYVV9+ulneQDgD2JzNn79QOp075Zw
FCWq4X7FaFMz1XWVFg5iTKSJEyf6pQSIJJxB+JSx7Ejqw2Rjx70YBZUjzhAe
Nc2oI1mcKBHLbchcZjnDaaedFm0/RqGN6Ec5Eu1sP9pKPten3HMumxrTmH7i
wL/pppti3JS9jBX61QNqWBUhWdz+JWFm1pfkJWQEbrLJJi73jbRYO14+o6rY
6dHixpN4BhOMHYMVI7eu0smmm+JNry/VyDaSNeE6v+Spq5U4mdEU2+TpAWdH
d1qdHYgWjIYMtSxatCj3bbmfOC3PsOOuTtEo2XRq7ty5STZuLtk5mPtIi9VQ
Wdjx5sizG0gdo6+Rm64n0UDEaigI8Shbi3nyAvME76+99tpQwycPlrXa/NKA
PtKDxxcvXpzTLNmwf5pTiGtb1rdGpUr2U40Qj+IBYsCVQbBe8SCJn07Bmzp1
qr6bgDa7gM2aNcs7ybiFx9mMazmBJ+bE26/MtdUiePmK3I9zjjXCLDoj6geN
dT09BSLvuAgwSiSs9iTz+9577/UaOpq83hcaH1i4dC6mM2sYK5x6hkfqFJEs
6yQENnv27JzmA7OOiTbZcV4JESHBfWRY1ztEmlqKxRCoDerGelomTJiQ0/2J
WVXNPANVzJkzpx54I4GBMWPlhoaRydKRPVozDiNHhFbYuWQDwnY3gKRHaSFL
A6J76qmnvO5VDVK6LIujdGeT4K4qFgMi93Vl56oWF5qTLotv3a/+kfu6qnOp
vUrDpEFWwWsyvPKlJOC7XzGy7CevJ/JPOJoFtyzSYcEOrM5qG5SZ22+/PRqh
GSRdKtDjfhKvnpHp+AfEnezw1NeFu1lzg25JYQ5lfxbsZ5IgsFaIKLA/BYtb
OqaQPk4cEWpj4RDWC2Mvaxmczkb+HQuSaG/bbbfVxYskxDD10iQRPJb4sOkn
uWloPTzCq5B4LJVjWaY1kGJay5BIna7ACLXB4ZG6RqA+VdBeN9eCOgncGNOx
vTOURSaCFgwwq3roenUyF7EVdXEvk7jVChU1rOqTTUZ8i9CvKMBuExC21Bwz
Zozq5yy5ZFWdlnDb2JiOzXoT6a0ldb6b3RLJwvvCZ9337g1AdypK31EQwWJn
4mmsg+LDmlwrHFT3EUwHuEsMD4iftB41sWM4hqxgAFbP8QzrXmvAMboszGA/
Fsd8N7vZNXMcp07s13MFkRhIN9iYlXejR4/20IJgoZS8jE8QbCWJryMUI731
dSHSNe5CuhqRfFgIcXHWWWflQozr6m3eMXjw4CjGY/KjIZjsJLUm9gayFXsf
D8uLL74ovRvkruGJYR8Kdklh1w9IkEK8FXubOjQwAj+syMPbiDpOCbDJNUUa
OX7IZixSdg2YNm2aRyjbRbCgl6RPTHz23ehyhKbSBfTwSNYFM48PHTo0p/vS
oRuAIGYiJi5UeDa9YKsQCjlK7LIzcOBAt3kcOaosEcdOAvmFyFxjjTXyNmVC
xOD3AXtqQuBWY/BIfsbwxDc0ffr00pHMFreWGLHNIg9raegyYt1eixJxyGle
FysBAJ7ZmuwXZnzb8dgLu4D0g8DIjtIsExxOR/QAKzYT9brdCVbOvKB75D+g
QvC/xYxPfQo7k/g2ezthDDdQ4Bw0MLLM+asbfoh3zcLofWstTogxclCAfXks
jua+1dVbx5NiU2u6MTW+Tegj7DjUR2fZ35C/ixYtUtla7CFrcRo83g6WvFiM
VOh61ufJVjBj1Kkd9N9PJLpNjgmm0dA1pvIOscqERdIN10sFUt33bnIh85MQ
Yr3XF6PIy0SQ0/NcYk6svpE2grHN8DyACmStL0Zthl/DzWJDp1K/yLPuexdp
JvsN98sMV8kJM8lt7oJt7StwV0mAdaJt5Dm6neYMdk9iZ1Qry32ADrWIOjac
c8/uJm/K9rzdgNxdXWPPPK3nSaTd+Qzh7n3ebnVnCDfU4GjwOP3/cIawHq+R
/aG30t9tpFm0PI0dfvzxx7rveblTLxN3ZckTLt3bThLY6n0ubWoO31qAxDGC
U5E0CjyGrAewlk8P6We58xW1nyXOUnRvPTVlX+ouK7eWDuCbZoUeQV2AwvuJ
a4MVaD3l1QXH/KlbG/OWbSrtx77PfqtqFJ4V5d59Wp17mXru2U4apHfYduzw
1kMajJ1Rpzo7VK3b5qhurwej2Y+9z35n1t3Uk/r20iA+R4UoAb9PucPaXBM4
HHAesBnSggULdMOfTDqXaiy1cyzNl61EfefKnGDmxl62LHKrmq0elmnnUrGj
dk5XIfJL42DwGZ4Haxj6jb8KzglzTf6qzsCn5jIFHkAKgWdtHTITt71GLcNj
uRoCeWqGSXt2vSYMhj3UU/CwcNnfjl3/EPEsxHbvurABvUo1HmkPpFcXVtgr
NWVZsYDvkqUF7h1/yHSMik7lLXEMef550HpAR6nVMRSrJSn7h/3+stThtCZd
j/mvyXtQNcE587BypztfclGtup4qHb+uCTwhcjaQLuC8ZudC5gp2uO3fv39O
j1/XrUDKaX4J+JkSUsAWMVyWOFg8JS4rnSdeGpftbokMEpxtM9khkpgUdYlP
OLmnnHbZMFymMhaHSBOdOSq7HFdWOCo7hkiV0+w9SuzIfnKruu9mlzWhz+qS
OWL+Go6isAuwIlyd0AWarrtPl4F2Eb32S32gdHQxUkvhedIx4aeoxAdPAqj9
WFTy3ezPvAxRSZyV3W+0EA9VVGqsNKZeNwSfqSPG6kasdF5zpdUuMWVAuRpn
P7kp7LnMoj2OhC3k6nLHJruXdbGEzD/mWBOOwnUWmo0VwwBTJlu7oFuDCYKd
YKDjEPL2sgcONwwDqebbmCq7obwKBQ+JzaoEzV2qt2KQ2v9SDlCWZZODgzFB
ekQjAE2twcQAdfddmznqykCUxid1buZEWWas0ziXGgFwp/wQZBHgITKBzCiy
uX8nF1546S0Xdao1kNtps5WMNlImykKpuKxnwLVT1EoSB7fMnz+/NJTnCAx1
DqB2Cp1QH8kSVi/z/jSmQjm9IVfS+XK2vL3ewdLUZJssEmpzy+nwFuJ0IW+G
FJDp06frtuEx38vZ8mgDQqep6XkHaZYUImZcKOaDDz5QK7/I6/JbuZDV4eHp
Y3hZHB7+edmVuXPxu+6803G2uzJXisB2xc7c1R6f3hX0+r+d5BsDa4DX37iH
iw4P1/WT/GSu4ZeuSyUIhQdu8uTJuRXkcWxNUjtZuvjSSy9tKiDFzh5/UK7V
sll46gE+UxoMjx3XvjERkelnVVffN0KtbEyG6zWpa3NKAxEpkuXwlKHqXn/9
9ZvI5RKnlz8gYNd6cHkqitMYYx0PKe8daTI88NtR46ef+gVGscPMw1crOOHB
5T3jr9Zbg8N/vRYXgqOvYSD1PlUG6CGbXrNpth7Vwghx8isuZHutPdKkjkzY
Q12FQh3BV/bdAPfs3GnpJwZZc1CnkLVFmg7rxGJKoHXnpSct9wpbdqXEcewx
2LVOQ+v8uk3qGqqJJ8erL+8EA7nlZNGzpRuFHE0eI7EbhsrkLPQ+0bPQebTE
6e7JY0OKoIN6OJ5HvRos/9JztWmWlHU8H/h2EYkpTzcvfxZ7m7s9goQWGarY
ueoF57H7iEKJQ+GVBlhlJRun5zTpvsIQKb2DF2RzB0mt5vLIYRtGhM37wJOe
RY64pWlkKItoWerPPpDMFSztoLPYbTzD9jWsUGDjGD1hjx6ySSCJ7YBdAKbA
sH50XAqf5UQ74GC3CpbZ6+YghV2nQNXs/cRvNi5hiohRbey9IbXyXnIyOWcd
OrrttttklNZxLMvcSVAGWNlABzqCnkjiX2qppZz4D895RzTF4I0cP58a3kI8
EcOwlPOXGqVIKu1kC2kQWETK51QqslSTNYMVjm+vz+ntvWOnt3v2LzjaV55Z
tyRooJGNH1h8Q1KXrh8nyYs5lKGHcXXRboWT2d3/aU6Qj+FAz1wudzK8nCgv
+IqfZJ/MNH3cfnyDBw92+8lTKgyPSg5WXyGTzjvvPGmqr5MYFPL64EpKeLI6
ryLXn0J2jaVwv58MnAx6Zc7XfS4ZLYUE/wlCpgSEOZ03So2KPk+BKVH+LAXp
et9SHSfTDQRS4F1AouTRa7+Sb1VaZZkwE6uukIQm7Cs19IVuIIdFuFthM22a
HEKmEzm1vuwwsXaWSKY/aLN/0TnKafCDsGGvllqkRmprWaUGM4ywgacLSBN2
lUPoVbcL+1TVGfS9Y2fQu/tLC4hmhSIPDXSTlXlW3grUKzlXGlmRqHD0QBTo
SgfLu//DY7sZcTQxigqGoLttgvtyZ9nLKcNeFkS6LQzc5qYgYrlMcZQ8pDeH
SPfjgwZAc8xAfglWH0eC2GVyJmbe0b2hGED9s2KgrBRod1MZW6GGVCqwiVEx
oCTKQ6pGDQCdKFSK7rw+9sjjdgoKJgySx+29Sr5NCY8J3ErhdkE644hXWMm1
g7vbnRSFu8NTv7VzChUQQBdseQEqxUjLh6pHJRzcKePY0HhwGmZGRdl1112T
w9xbnAUOVgo0ADnkw33kvHdv24UMDiMxU7722mutMjyYVOj7BJLK8LVmmQg8
/m0KEAXBiiprVf7k9hWc4YFNhPDUbdoqHHTv/g85m8lHZXk45dtOJ2hp9mfc
d2Cwp7s1WNLkDA9Yj6KcHjoIAiSo8qSnajOXka1HEQTkSoyI7iHEfpDsWokl
bdXtUC4wtGjDSoqlGB6SDBgewYnmUcDwCCYIOSDeAhibw0HK6VQXG5lQAKCV
TJo0yf2PIED/zm+3l283lAQwFOIMHs3DSc/oK5U6WcI1YsSIXLVioBRokDRb
11KQYyqv80BrL4eNXK2yIFV4IZQFm2++uTsuIDk0YKAzUWBHUMvidAp6EgBS
UpxT7+0Bdn/h1Thd0H35i4nHudw63aOUkoVBYQpXZRWTHrxS2HsDDlK5UAo2
2mdiAO/+AIdVnEUHrVOYoTEbULII+oEVhg6e1y0f8AEwPhRcBEh3XqmnXVNC
2RBDgZIhZINFTEEO8X49oLdQBYigQq4NdKjQd6MkIv7SDhGnu6211lrJ8vRc
sz/V23gBtpoZPny49yvhYdF+qaxgGwAUVPqAV4G0UdgCLQ46pp4dnpG3yBLs
CDYpuueee0L6jsEsfdwgOk7hsxTghIUZat6LyVcKD0gKPBDci9Na5Xohfkq9
V8mXQjsU6IYJ0I53MsRru9XDKj1oEocCyhKmGOFmmgO1BNIppcBFN1F0M9RK
/WnBDdFEFiq7ojTOu5BKtRjgVQsKah6zBzM+7gG8dajHOA3xpvAXyU8d28BY
+lNFC6kB2ukXhRPWIEl2zPcmVW83Ovi1CC2ANt7ApjFAhkAm44ZJAD5okeEr
hApqwc+G1Qd1wZHEJShM+2xKh3RQ4c5QEBYhvAOIbKGCz4sekHVAjxgW5jiG
nb/AowdyhJKkoPeiMvR070TRxq+pDhOwCoxIJUJIarFGcCDXlnMcChmi/VDg
ZCYs+lxpdJBI3IsxAnfj+OD3nDlzkuZXc8oTO4ziOgNFCALAQ+AgIOgqhgq/
0TBYXs2cyRykwg1hy2/SSQAVlVAVuEKbIQDXp/0WDFFCh2vlPQpFoPsxUiio
mklciAGVIVip2FLqKYvRbYwyCokWZofB6T5nhyVoW91hn43FcUlR8DZCpRhr
zD96DuRZZ53lclkYVVASgxdhAA+i5/EsQ8FcUQFen4oR4olnWCHXOGdDxEWJ
Mp7vomx2jhbZ1swvdNHEOH7pUbQgSljJr67CrwaZUyyi14k8rmuZ8OCqYt8v
UqchOmhCxsTvfxG21zNSpwEkLES0aGM6EtTCd/xFwE6xG0xNMvsb0gQ0xCQC
7en8z4iwqR+uS/ZeVZSz9kt0l9xmUoeBMHToUEfPmlRFOwwhrGuNIEV54Mzx
S8owx3gVNmS/SJ2iHL8XZM6u4/0i4PQIngUcfq0aae92AVGjyc/MmAuK655s
9H1pMNwtXKkUFtUFqUp6sLPsfZhTfEEquv2k3ofokR3xPR7Cuj7Bs/perQth
CQPYuCaN6dg+NmzvNkFCmGQgOWN1ir4X5tEslhZqyQnrqnygz0veSrUY6Ip8
oFJ4TbMrx//w2hX02n1yGFMrH90A1tTOGz28hsgUljAbZI+SBrkNSxfdH6cW
2R2ujU3khlqSxVL3WyFEjeeWtra23EFSR5gNfYcGmuW7vb3d6eAk2rj2NpK3
15LzlXrsY9Ae6Ora3a14NKjnQ74BgUMLsTTcrKs43BPue+MIhLXb3K+++qr7
YGaWhbqHsyWI2PBB/1cHAf6aNddcUwGHQPIA36hGwOPoLgB8E2kW2xDnEIqv
1UJWiPRH1X8sZWynJUuWiDKTWLm8E8scLuD8C92nDp0UpQ8LGb8+Bz3ocyhU
vBJvM3ZRx7nOLc4PiMWPImbbV+86ehPNEMWxxm4PqQ4zyaxFplhV/6XxWlZy
fj1AYqRZTTZR3JJEOFID8CDQD4hSjzvSlRUNJaKVpEGVV9zcw333dC4EUqiU
9Fn/p8ChIS677LLyghYfSMHw7dWrl6KClAxJcvXcIgeQgFD/OHaCFjuOSXWr
S1YJy9prry2PtHvTKiAXJ/gseftXsd4LPxF91LgGNK892nfffTV+DKXgquNB
fRyphM8o2T0guQ//DF6DpqYm21hyHy4o/CrGdGRSAh5IQU6olMMtSE+hVCUt
XQjE57jjjushhEFkSKvVsLdEq4ghvzgsF110kUDd5odCC+ZvE6lgyaOaiYIo
wJVqgfIA4sRiUunAV4Jn/JCIbJKh2G4Wz8z48eP98JFYpmX77bdXSMSs8AWG
t8Ol6AUmnBGWsX1L+IQ063LYsGEKNOEaLYTB7Uh57OOTEY9YQuJqWdbfWZGK
cZod41BIN9TO4kmnHH300VLX38W5kCGQJJEI2oFGGAY4h9+QMH9BvUrxmjin
zYst5RzGoU+fPq3SovquKBYyfREOSS1XXXVVs/QYHlFC5SOeDfeSbbbZRrtP
TAkKWmaZZTxKcHDphukquEmJC5vroM5W5zINHCqwjm9LE5k62qqBh1ryeMgy
RLNUM0hsCEuoZ/3111eEMmaIH30ZuZazZ89WkYHzUElEW4LO9fYLLrhAhZNl
Hl9tuUfDhUELLu0atx4vtcThQVYXIcVzTovnHILDXgo0O1EHDM3NzR6HeNMV
h+5bPVsN1QZWkmYDRkLBcjs85Pp6v7suJ+Ay+hj9gSf0tx4hYGcXjxJd1g3f
nHfeeVoNLWqxrFQ1JzWHnORfivsUrYZ0bCsntZq8VJ08PVf181yFhkFAje7Q
TZxyKDg4kFHicjLDoZw888wzChyaaJAZjybqgUO30eHUIAp6jxCBc6mii8OC
+KftaxTY8AAJy2UZMNnkyZO1Gt+0SjprE2g1edT4+uRccIUJgUFhHaTeCpsC
K1P/Zpttpjynm7JT/CzVu2iWIqJCb2hFF4uz43XHwLf4FCWKZ7Zmz2x77LGH
v5UIh5YZM2borUx8ikv3XSuzdULdy2c2OyP1ilRb5tIuhGktdoxVA0N7CIuy
pxV/XttCa9YW/UkBLU6AarVlME2nJ1ys1UoCXmFo9ZFYLVYEe2rXhN3kIIik
TpmL5FxtQ5f4aiE21uTOxOrpXKboccyAfJSDsAqIiIeqZfFp6okEUfCtDqAq
HhSg1UOHDlUc1FvzK8FQ7XnDp3O+JEX5kCEGD13XXOMDDjjAoyxIFnDF8o5/
ZZSnehTxFMFrIapE+iUoAGDtq9Ux9eQDsi+0WlkKa40xwbLV1UyEwo855hgd
EjRTHRL3XS1LqbulFpbqLcMJn2s1H9H5NFsRaYYgzokexrkyGEhMdyQfCD9V
w04989hJcaYEgF6Z5IIkcDJX6r2635KfpzpY6fzzz/csAP9jGdhPkpgmZ8Vq
wVQiZE3SXWgGMc/pujXNiCMIq6+3nVTWgRy1OshNy4h12vJYR6dnC0e7623i
gqB3+lI2C1TQiXNpfWUNj8CuVjNsWFiINJbeKIyaDULxk057nm1EQTMixD5k
yBBvI2m0v2bWqOz/TcsayXExIWt0JDsl+/FjBmFma//hD1X5quSJHmV5on//
/prFSvql3qaphhF2IBjZU8DTHALgsVNhq9xKOphEn0VpanGWj7ZuSVyJgClP
7T2UPTV2ajR0whUGqei+Y8ZHwbV6UE9piZ+onPqyjqVwLW6lTAV6twjU8SUN
RkxcD0toSvrZoKVwNlCrirTVXJ5VlXgUSFJhZnPw1+IKqGkGWH311d242Kc0
0V6LnBmkMCPlJXXQKxJYAzikUFbshKEIwq7UEhgumjdDsepMaBuEJcn/S14a
UL6f5lXX1bLXXnsV+exi2lWHiGp1OTKgQT977rmnv19JbaeddvL3s6EaugE5
LNgi+P/VZUoCtaLTihulM5Qyrba4q21K4AyTsIwdO7Yz2hQ5fznRpqxiYh+F
YNqckqLUTMCAYulV30qSdlhIRC6rUDW7JYtSvM4GN5KHjPOLuc2+qfxc0WGg
WLPSuyJYzUieB65e/OaUWnzPpV1oKXzP7YIiMhzDQnKJ9o2sDx1TSzhKAaCD
zDpyVPfff3+tRnlnDLjbTuHq1gxnDRRHtc2T4ykTUBhCXYKFla1D2hGZaPFz
B59jjz1WmweRJKfqJTUlYgxE+E5Jg7O1wmLnQO+3UxeHhqPwBLllzQkkCAuy
Azm6zuJC5xooQaHYZ599lI2YrbTa0l9tbERKGtqelg7roUX9765EZhjKbrvt
ptWys4QrVj9QVLEFOsXqMR5VsrDaFdCdrFksw0WtTtbiv9OJNRFdlmBErmg5
44wztCUy5LREGCk5MzC5laQwbdkyQZM7SrzZJfVK6WK32gorrNCGQ8SaWLoy
hUJgTd3PcAo+JlWTENAPPfSQnlMJyVKN85ExwSIbOXKkYoAMfy1Oi0+QhYGD
hLHKm5+qcT5iL1slwCMwnLG82d/iXkZOIPbG4MGDtRrOU3SX8FPvvPPOOmC4
8ciK3GqrreR9ffJce/xPz+BxxDdaNPDx8lyiQiahnX5uMwyEpqKVFFgIDleU
OtdQ33QBKDP5kUceqZCwrAGRbdm5kganIhoPINSFbuOduC3e2CIi4kehl1sr
gd2FFsESee0Ca1xxruGitxyrreBqVB6yoiVEGEPcYbn1LmQrTyH6BpRXGMZy
hx9U3GmkAiKH7P9azUK/MnzF0Q56qya3Ikms4qS3Ktx146vSmQ2VbRo9QQRn
Ksv+9ZKuHWdnHJVCrCHS6QZVgH23W+UafKjbYQgX+fmCBQgyBfk6fNkkC9OG
hmQYjdCDq1MUNLvDDju0yKuYPkKPWsfU1JrHRHQe3bFVpiEc3HrsIYU2LN2o
vQOEspTOB0MZKjGfc/p6OARG07LpppvmtA3dbKFjBCtMQc0uJ12mea/ZkHmt
LnrbvAa49EhDJkzLTGojgzZZdeejvbrpbwfKE8BRuRUYluwXWjtMiMcff7wC
p9qYlRQJZdlmkJW6klGYwFN8aNLbZ9qkGeLM4hZNaFPzPzNQ00pQfKsTQsSn
+GBpEtxWdJDqrtcsDahyhHMLUYa2BjNA2KCI9FxdL0jGhz6KUgCjII9Z6Mhq
Kl2tyeTFaDB3sNyUU9XV/4XIJFbPc6xSYmEBwgTHAv4uK/G8+RpNC0jODMV5
gpcHvZNXoDrhNtY1buCKuQnGIJGa7jC/cpZgr6DLHANJ5I5MZGKhSNdEEU/u
QWaHRg9gsncG8fFyE4Wdr5vAk20C0UEshy1tEEOok4C/cOFCH9DnNSyp1WYY
BV4DNnSe5+x6ZmwmHroFxi1mdTU6/Az0TOIwGZDY1zaBbdtlXfFFwXnCGEAa
0C5UhE/UL8xod+5G+s2LAJj5iWXWFvd+eKJOgB6Ou2mR0DCoB730haihMpcm
TmfuA7Bqdbsjgma/fIWbNP2pgOLWk+pQA7cahVrDBQOvG3HpVjZ8rEr9pTi6
3IvV3KrWG161TadpEfj0UiGhzYUitBr5CytYNVRtmq5DRhW6QtXIWF/eDadp
NR9rUOQqYALpSRYKn+nTp2ePiRJkwboQJn2cJS5LMZcs7CjEBGERuQ83+AZS
jSmFW4Z5xSJLkUBant79xhtvbCXV+M+1mgZr7W3qGdPVNeZExEa8KRUtu7r3
pO0qlyZ1DoH6sioW6gTNpXyZrjmJrXJpKnOtV6Sbqd+8olB9LjeDr1Zpq7P7
JBfCUL73sXF1pXPNxJBYshneidSqsZk6QdP9cFOnTtUBxaWh6Qrc1KGZTjHk
541u/sdT/+OpLhjwyjwlxPl56lRmPCXkUI9O1QHFqaH5vPBUTSMVf4lJanPE
DLirpfB5fbylqPFky3f71c+11BzlnebwsVzyMF8D+VqKW517falab6f/Hfhw
Md6lGAy5nctBX5cLanNL/T8c9UNM\
\>"], "Picture",
 ImageSize->{533, 486},
 ImageMargins->0,
 CellID->128586948],

Cell[TextData[{
 "A dialog with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " using a text\[Hyphen]based interface."
}], "MathCaption",
 CellID->26525],

Cell["\<\
In[1]:= 2^100

Out[1]= 1267650600228229401496703205376

In[2]:= Integrate[1/(x^3 - 1), x]

                 1 + 2 x
          ArcTan[-------]                               2
                 Sqrt[3]     Log[-1 + x]   Log[1 + x + x ]
Out[2]= -(---------------) + ----------- - ---------------
              Sqrt[3]             3               6\
\>", "Program",
 CellID->12746],

Cell[TextData[{
 "A fragment of C code that communicates via ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " with the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel."
}], "MathCaption",
 CellID->29482],

Cell["\<\
MLPutFunction(stdlink,  \"EvaluatePacket\", 1);

  MLPutFunction(stdlink, \"Gamma\", 2);
    MLPutReal(stdlink, 2);
    MLPutInteger(stdlink, n);

MLEndPacket(stdlink);
MLCheckFunction(stdlink, \"ReturnPacket\", &n);

MLGetReal(stdlink, &result);\
\>", "Program",
 CellID->2815],

Cell[TextData[{
 "Among the many ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 "\[Hyphen]compatible programs that are now available, some are set up to \
serve as complete front ends to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Often such front ends provide their own special user interfaces, and \
treat the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel purely as an embedded computational engine. If you are using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in this way, then only some parts of \"",
 ButtonBox["Using the ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/UsingTheMathematicaSystemOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/UsingTheMathematicaSystemOverview"],
  FontSlant->"Italic"],
 ButtonBox[" System",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/UsingTheMathematicaSystemOverview"],
 "\" will probably be relevant. "
}], "Text",
 CellID->5105],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->4302],

Cell[TextData[{
 ButtonBox["Using the ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/UsingTheMathematicaSystemOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/UsingTheMathematicaSystemOverview"],
  FontSlant->"Italic"],
 ButtonBox[" System",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/UsingTheMathematicaSystemOverview"]
}], "RelatedTutorials",
 CellID->344194261]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"The Structure of Mathematica - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Using the Mathematica System", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/UsingTheMathematicaSystemOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DifferencesBetweenComputerSystems"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 48.9056028}", "context" -> "", 
    "keywords" -> {
     "architecture", "C code", "core", "documents", "electronic documents", 
      "embedded Mathematica kernels", "computation engine", 
      "computing engine", "front end", "interface", "back end", "backend", 
      "kernel", "MathLink", "notebooks", "publishing", "typesetting", 
      "user interface"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "The basic parts of the Mathematica system. Mathematica is a modular \
software system in which the kernel which actually performs computations is \
separate from the front end which handles interaction with the user. The most \
common type of front end for Mathematica is based on interactive documents \
known as notebooks. Notebooks mix Mathematica input and output with text, \
graphics, palettes and other material. You can use notebooks either for doing \
ongoing computations, or as means of presenting or publishing your results.", 
    "synonyms" -> {"1.3.1"}, "title" -> "The Structure of Mathematica", 
    "type" -> "Tutorial", "uri" -> "tutorial/TheStructureOfMathematica"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.3.1"->{
  Cell[1289, 44, 144, 6, 70, "Title",
   CellTags->{"S1.3.1", "1.1"},
   CellID->15760]},
 "1.1"->{
  Cell[1289, 44, 144, 6, 70, "Title",
   CellTags->{"S1.3.1", "1.1"},
   CellID->15760]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.3.1", 33915, 714},
 {"1.1", 34015, 718}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 664, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1289, 44, 144, 6, 70, "Title",
 CellTags->{"S1.3.1", "1.1"},
 CellID->15760],
Cell[1436, 52, 700, 19, 70, "DefinitionBox",
 CellID->3586],
Cell[2139, 73, 136, 6, 70, "Caption",
 CellID->25419],
Cell[2278, 81, 341, 11, 70, "Text",
 CellID->28735],
Cell[2622, 94, 491, 14, 70, "Text",
 CellID->16616],
Cell[3116, 110, 726, 18, 70, "DefinitionBox",
 CellID->20113],
Cell[3845, 130, 136, 6, 70, "Caption",
 CellID->13335],
Cell[3984, 138, 269, 8, 70, "Text",
 CellID->28592],
Cell[4256, 148, 163, 6, 70, "MathCaption",
 CellID->29018],
Cell[4422, 156, 24246, 400, 70, "Picture",
 CellID->128586948],
Cell[28671, 558, 160, 6, 70, "MathCaption",
 CellID->26525],
Cell[28834, 566, 386, 13, 70, "Program",
 CellID->12746],
Cell[29223, 581, 220, 9, 70, "MathCaption",
 CellID->29482],
Cell[29446, 592, 288, 12, 70, "Program",
 CellID->2815],
Cell[29737, 606, 980, 28, 70, "Text",
 CellID->5105],
Cell[CellGroupData[{
Cell[30742, 638, 67, 1, 70, "RelatedTutorialsSection",
 CellID->4302],
Cell[30812, 641, 431, 12, 70, "RelatedTutorials",
 CellID->344194261]
}, Open  ]]
}, Open  ]],
Cell[31270, 657, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

