(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17589,        512]
NotebookOptionsPosition[     12466,        370]
NotebookOutlinePosition[     15998,        452]
CellTagsIndexPosition[     15907,        446]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Numerical Operations on Functions" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/NumericalOperationsOnFunctionsOverview"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Numerical Operations on Functions\"\>"}, "\<\"related tutorials\
\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["The Uncertainties of Numerical Mathematics", "Title",
 CellTags->{"S3.9.2", "2.1"},
 CellID->14523],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does operations like numerical integration very differently from the way \
it does their symbolic counterparts."
}], "Text",
 CellID->8243],

Cell[TextData[{
 "When you do a symbolic integral, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " takes the functional form of the integrand you have given, and applies a \
sequence of exact symbolic transformation rules to it, to try and evaluate \
the integral."
}], "Text",
 CellID->12365],

Cell[TextData[{
 "However, when ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does a numerical integral, after some initial symbolic preprocessing, the \
only information it has about your integrand is a sequence of numerical \
values for it. To get a definite result for the integral, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " then effectively has to make certain assumptions about the smoothness and \
other properties of your integrand. If you give a sufficiently pathological \
integrand, these assumptions may not be valid, and as a result, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " may simply give you the wrong answer for the integral. "
}], "Text",
 CellID->176866141],

Cell[TextData[{
 "This problem may occur, for example, if you try to integrate numerically a \
function which has a very thin spike at a particular position. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " samples your function at a number of points, and then assumes that the \
function varies smoothly between these points. As a result, if none of the \
sample points come close to the spike, then the spike will go undetected, and \
its contribution to the numerical integral will not be correctly included. "
}], "Text",
 CellID->16937],

Cell[TextData[{
 "Here is a plot of the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"exp", "(", 
    RowBox[{"-", 
     SuperscriptBox["x", "2"]}], ")"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->4599],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{"x", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
   RowBox[{"PlotRange", "->", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->31499],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9WT1MHEcUHu6Hw3ES0URGSnNKsENJSUllE/sOzgY7RGlAVqRzEQU5LlAa
SkpKSkqqiMYSJSUlJSUlJSXl5c18u/u9ffv2fKegnMTtzuz7vvdm5ntv5pb+
7qfh73/sfvrwfrf74uPu3vDD+7+6z//8KF3NmRDCZ/n7eyHI/Uju0t/n0Uiu
1e+OfDfFoCHXhlwXs3Y/uz41z5sJNRe/W5E3fbLnocmeRdPum/aPLkMMfiZe
0QVn6VP4Huv1e/mKBu0H8P7/jPHLXn7IZn49uz57MNZxsT+dwEtnRE3kkelI
F81zLCd095vx927q3rjG/+Qjw4iVzaxpW0XY9rT2qd0p2vK5uro6Pz8/ODgI
jdXV1am5bCyz0u52u8Ph8PDw8OLi4ubmxq7hg4xhCrzKfdX7k2l/l9oSscyC
BB2+Nc+/SW2ZqsFgcHt7G56Y589cr6/S7eXlpbDe399nLLT6Ove6trYWn79I
qF7q3dvbOzo6ohVRj1Nb7FdWVmT9wppCSWwy/5EroqJ+gT45OdnZ2Ym3sO4b
H49dH+JAgrco8bm8vOyhvkrt6+vrpaWlePtzQq2nXglLJpZWZVRDJPhSWe/v
74uC6qxDUxyIG+sD61dwCgjW4ljcx1vtQ2Zpfn4+zpX18cjMGVAbqVcciBta
WZRABFhGxdH5PjgO7UN0JorwfEDHd3d3Enm8faVQsvYLCws5Ko7+kZkVWA9S
r5gKgJzWhwhD5GFRIv+zs7N61Pb29unpKVG9LJJGvqoApCLdchlEWiIwMqRv
1izciA/xVNofgsPYydd5bi6R9+oZIWrkrcnj2AQTlT+GCe4qsdg6CEYMxDA6
eyB1Ynl8XubPeF6RmYgtOHutz8v175XWF/PGetJwzjMdMxIwvDZqy/dnqEFm
UubTWjM/OsYHdgPme1+hWJd8FPMEqDeulW2zSmgUq52HivVgXVmzpsxmo0eE
rCWam71+RGQjKnr0R81ItQ+OyvdhzmAZiuvi78qsUHr0XJd89EDL1iMbkLVm
Nvs+mFFAbaZeKZdSNGllUZIskjJElXTdhjUqU3CUjTbVD45qzqEmMOd8HtbQ
cTx5BW0WPNytx/uXm3jgq/VPRYznEY0EfL50RhvPI2Kt4WkZ1WyU1qat1FOP
poo2lB64g7ZLbFLcpMTReiv1sgrZqo728fGxHHktivPooWJGDpQ1s9b3wazX
PqgVHwWtWRSV2iqNnnuvtmZu+D54ktAoVhAfxbZGsQZbK+wwrOx67lhBfBQ1
oFHUVT4LLaMBWL91OW2b49UoasBDRQ2kvcnso2oXjsJuIq1T2/Ut4hMJ0ndN
pmU9MjjnrAQm7u+TMIlfVYXAwCo0CQMKkR8L524cUzPNEKa+fobYruMqqgeW
v+b8Rs2U1y0/tfgonhtfK21Qy6V3DSoHYP3O5bRt6k+jmJs+irmtUawDPor1
Q6NYa3wUa5VGsa6V3tapekjrmC+VDDFa0dysy35ErOsaxfxPVrMFSj7YNzaV
NWtL1Rp1SVtzzfPRNsyap1NO+CV+tzVXKGaGK/2mpEG/dsgdRODEh9VHfDV5
Oqt7oIsqD+rP5DyoMlUe9Nfx5Dt1GhNcpjE1877sgDZ5HBh/NQ6cFifnwZmz
UV6z7HfgVmmN8hNuiheLHgwuO9BsKR0Uqsl0YDWzSdtWcT7WniCZjDMdjlus
DNl7cskt/Zx1PPfHTN1UduzN7Zi5tIvsOLDnw4R/5VHpGnHzpK+sOhy1/t3+
VlnwbJcssnoOi1/T2mUJkR5DA/ppcT4vFKmf4pc1zqsQnHrazpyFgCCyt769
Ef8fYTMUvzCwr3D3Ac6+367+LwE9OACjKk+HFEBIr2wlgOmQ8b1Z/pkUaXfH
/4azOWXP/7Cq/vcozPwLItAqYQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->117954122]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " gives the correct answer for the numerical integral of this function from \
",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "10"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"+", "10"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->30554],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{"x", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->19124],

Cell[BoxData["1.7724538509055054`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->31]
}, Open  ]],

Cell[TextData[{
 "If, however, you ask for the integral from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "10000"}], TraditionalForm]], "InlineMath"],
 " to 10000, with its default settings ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " will miss the peak near ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "0"}], TraditionalForm]], "InlineMath"],
 ", and give the wrong answer. "
}], "MathCaption",
 CellID->28066],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{"x", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10000"}], ",", "10000"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[35]:=",
 CellID->26429],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"ncvb\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"NIntegrate failed to converge to \
prescribed accuracy after \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\(10\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" recursive bisections \
in \\\\\\\"\\\", \\\"MSG\\\"]\\)\\!\\(x\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" near \
\\\\\\\"\\\", \\\"MSG\\\"]\\)\\!\\({x}\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" = \
\\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\({6669.999583202662`}\\)\\!\\(\\*StyleBox[\\\"\\\\\\\". \
NIntegrate obtained \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\(0.`\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" and \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\(0.`\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" for the integral \
and error estimates.\\\\\\\"\\\", \\\"MSG\\\"]\\) \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:Messages/NIntegrate/ncvb\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellLabel->"During evaluation of In[35]:=",
 CellID->523210],

Cell[BoxData["0.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[35]=",
 CellID->77430330]
}, Open  ]],

Cell[TextData[{
 " ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " tries to make the best possible use of the information that it can get \
about the numerical values of the integrand. Thus, for example, by default, \
if ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " notices that the estimated error in the integral in a particular region is \
large, it will take more samples in that region. In this way, ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " tries to \[OpenCurlyDoubleQuote]adapt\[CloseCurlyDoubleQuote] its \
operation to the particular integrand you have given."
}], "Text",
 CellID->297567043],

Cell[TextData[{
 "The kind of adaptive procedure that ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " uses is similar, at least in spirit, to what ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " does in trying to draw smooth curves for functions. In both cases, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " tries to go on taking more samples in a particular region until it has \
effectively found a smooth approximation to the function in that region. "
}], "Text",
 CellID->21875],

Cell["\<\
The kinds of problems that can appear in numerical integration can also arise \
in doing other numerical operations on functions. \
\>", "Text",
 CellID->1692],

Cell[TextData[{
 "For example, if you ask for a numerical approximation to the sum of an \
infinite series, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " samples a certain number of terms in the series, and then does an \
extrapolation to estimate the contributions of other terms. If you insert \
large terms far out in the series, they may not be detected when the \
extrapolation is done, and the result you get for the sum may be incorrect. "
}], "Text",
 CellID->13910],

Cell[TextData[{
 "A similar problem arises when you try to find a numerical approximation to \
the minimum of a function. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " samples only a finite number of values, then effectively assumes that the \
actual function interpolates smoothly between these values. If in fact the \
function has a sharp dip in a particular region, then ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " may miss this dip, and you may get the wrong answer for the minimum. "
}], "Text",
 CellID->18361],

Cell["\<\
If you work only with numerical values of functions, there is simply no way \
to avoid the kinds of problems we have been discussing. Exact symbolic \
computation, of course, allows you to get around these problems. \
\>", "Text",
 CellID->13132],

Cell["\<\
In many calculations, it is therefore worthwhile to go as far as you can \
symbolically, and then resort to numerical methods only at the very end. This \
gives you the best chance of avoiding the problems that can arise in purely \
numerical computations. \
\>", "Text",
 CellID->19728],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->60546747],

Cell[TextData[ButtonBox["Numerical Operations on Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NumericalOperationsOnFunctionsOverview"]], \
"RelatedTutorials",
 CellID->163046772]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"The Uncertainties of Numerical Mathematics - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Numerical Operations on Functions", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/NumericalOperationsOnFunctionsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/NumericalMathematicsInMathematica"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/NumericalIntegration"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 50.7181492}", "context" -> "", 
    "keywords" -> {
     "accuracy", "adaptive integration procedure", "errors", "integration", 
      "minimization", "NIntegrate", "numerical mathematics", 
      "numerical minimization", "numerical summation", 
      "smoothness assumption", "numerical procedures", "uncertainty"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica does operations like numerical integration very differently \
from the way it does their symbolic counterparts. When you do a symbolic \
integral, Mathematica takes the functional form of the integrand you have \
given, and applies a sequence of exact symbolic transformation rules to it, \
to try and evaluate the integral. However, when Mathematica does a numerical \
integral, after some initial symbolic preprocessing, the only information it \
has about your integrand is a sequence of numerical values for it. To get a \
definite result for the integral, Mathematica then effectively has to make \
certain assumptions about the smoothness and other properties of your \
integrand. If you give a sufficiently pathological integrand, these \
assumptions may not be valid, and as a result, Mathematica may simply give \
you the wrong answer for the integral. ", "synonyms" -> {"3.9.2"}, "title" -> 
    "The Uncertainties of Numerical Mathematics", "type" -> "Tutorial", "uri" -> 
    "tutorial/TheUncertaintiesOfNumericalMathematics"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.9.2"->{
  Cell[1299, 44, 105, 2, 70, "Title",
   CellTags->{"S3.9.2", "2.1"},
   CellID->14523]},
 "2.1"->{
  Cell[1299, 44, 105, 2, 70, "Title",
   CellTags->{"S3.9.2", "2.1"},
   CellID->14523]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.9.2", 15694, 435},
 {"2.1", 15794, 439}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 674, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1299, 44, 105, 2, 70, "Title",
 CellTags->{"S3.9.2", "2.1"},
 CellID->14523],
Cell[1407, 48, 207, 6, 70, "Text",
 CellID->8243],
Cell[1617, 56, 300, 8, 70, "Text",
 CellID->12365],
Cell[1920, 66, 711, 16, 70, "Text",
 CellID->176866141],
Cell[2634, 84, 547, 10, 70, "Text",
 CellID->16937],
Cell[3184, 96, 233, 9, 70, "MathCaption",
 CellID->4599],
Cell[CellGroupData[{
Cell[3442, 109, 324, 11, 28, "Input",
 CellID->31499],
Cell[3769, 122, 2133, 39, 143, "Output",
 Evaluatable->False,
 CellID->117954122]
}, Open  ]],
Cell[5917, 164, 438, 16, 70, "MathCaption",
 CellID->30554],
Cell[CellGroupData[{
Cell[6380, 184, 285, 10, 70, "Input",
 CellID->19124],
Cell[6668, 196, 170, 5, 36, "Output",
 CellID->31]
}, Open  ]],
Cell[6853, 204, 501, 16, 70, "MathCaption",
 CellID->28066],
Cell[CellGroupData[{
Cell[7379, 224, 291, 10, 70, "Input",
 CellID->26429],
Cell[7673, 236, 1009, 18, 70, "Message",
 CellID->523210],
Cell[8685, 256, 160, 5, 36, "Output",
 CellID->77430330]
}, Open  ]],
Cell[8860, 264, 853, 22, 70, "Text",
 CellID->297567043],
Cell[9716, 288, 642, 17, 70, "Text",
 CellID->21875],
Cell[10361, 307, 169, 4, 70, "Text",
 CellID->1692],
Cell[10533, 313, 483, 10, 70, "Text",
 CellID->13910],
Cell[11019, 325, 537, 12, 70, "Text",
 CellID->18361],
Cell[11559, 339, 256, 5, 70, "Text",
 CellID->13132],
Cell[11818, 346, 297, 6, 70, "Text",
 CellID->19728],
Cell[CellGroupData[{
Cell[12140, 356, 71, 1, 70, "RelatedTutorialsSection",
 CellID->60546747],
Cell[12214, 359, 198, 5, 70, "RelatedTutorials",
 CellID->163046772]
}, Open  ]]
}, Open  ]],
Cell[12439, 368, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

