(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    305439,       5648]
NotebookOptionsPosition[    298017,       5424]
NotebookOutlinePosition[    301461,       5503]
CellTagsIndexPosition[    301366,       5497]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GraphicsAndSoundOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Graphics and Sound\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Left" :> Documentation`HelpLookup["paclet:ref/Left"], "Plot3D" :> 
          Documentation`HelpLookup["paclet:ref/Plot3D"], "Right" :> 
          Documentation`HelpLookup["paclet:ref/Right"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Left\"\>", 2->"\<\"Plot3D\"\>", 
       3->"\<\"Right\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\<\
Three\[Hyphen]Dimensional Surface Plots\
\>", "Title",
 CellTags->{"S1.9.6", "6.1"},
 CellID->1271],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Plot3D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Plot3D"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["max", "TI"]], "}", ",", "{", 
     StyleBox["y", "TI"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], 
      StyleBox["max", "TI"]], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "make a three\[Hyphen]dimensional plot of ",
     Cell[BoxData[
      FormBox["f", TraditionalForm]], "InlineMath"],
     " as a function of the variables ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox["y", TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->30943],

Cell["Basic 3D plotting function. ", "Caption",
 CellID->9466],

Cell[TextData[{
 "This makes a three\[Hyphen]dimensional plot of the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", "(", 
    RowBox[{"x", "\[InvisibleSpace]", "y"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "MathCaption",
 CellID->21474],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->3445],

Cell[GraphicsData["CompressedBitmap", "\<\
eJylvQeYFdeVLnp8ugnKyUqW7at59871nQBKluXx2OM49ozHBUIIJBTJOTbQ
QNNN0zn3yblzoMlJCAmERM5CiJxjEzrn3Of/3ltr7aqmOTR69h2+TZ06dap2
rf2vvPauam3MvMkTZoyZN2XcmBf/FDFm9uQp4+a++MdZEXQo7Hsmk2kT/bc+
Z6L9/5f25P8mAPRDr+1C2obRT/8i3xbzlr9C/pl+9h1HF9HW3HNlVMg5b3zH
lcY9B+o9vCRH43kbfudck2nw/9Xx2HuOm0Oo+Gc5HK1TYQqfMGGC+vG+50bp
lPKv3LUpTJ1t6qF+gd5beK+7q35fld/n6z08IP3TL3oHr8jncL3fFwya9P55
O1B6VFeooy/Lx9u9KOVLntOvffQ+548IGdnTOkVP8Jd+PefrvalRjQy55gn9
Hk/xl/6979GbA6FXPabf6ZleY+fdvrEefg//HtXv+lzI9WEh1/9TDy58t0f0
zxdCrgoPueof5arR+j1+9Fed/ZF+9v/4DooYRUXR+/rZ/0/I2f1C+v4HOXuU
Tvffh5zdP+Ts/9ODdajE/K+QKweEXPmTHpx7JLbXr//zr7r6Vf3qH+rUDurj
Kj6uqHwtpA9DVl8KueqBkPP+vs+rn9H7fi3k6oF/1dUsuyxeP/3/uXc4eknE
Pb08odPw097462r9UB899f7+wz57NKT8NaPHfs4xV5xjLjtGX6YvbEse0u8Z
Kgk/7OGIWdcWc4hEvGIcG+gad8057qpz7FXq3DH6Sk/nj4T0Gapb6h6/7kWj
2MEHXOOvO7nLa9SlQ7q099D7aEgfofqu+vxl6LgfcE+64Z54wzXxBn1xcv98
C8fYa44xV01m++gr0oeOdSjdfd/jF724pXDwTLnlnixt0k0XtYk3nRP4fmbH
uOum/nQz+5ir9tFXbaOv2D6+QvcyUDXrnz+Wft8Ipf1Jz9QK+nBPuc1t8m3X
5FuuSdRuOifepOOO8eXUv30stWu2MdQ738BA/y6b93fy8XofvHzZuNdA7/Qq
D7VpldT4plMr3FMqXFNum12Tb5udk26ZHpBb3rCPK7ePu24be902hu9qHX2V
ufN4CFJiy0Q7zLrU92Ud/sngfJh3Zo13RrVnRrXJTFSYwt3TqtxCh2tqpdk1
pcLsnHzb9KBz0m06ZJ9w0z7+hm1cuSLCSm30NSLiiZDeFapP3oPGD3BH4wWP
B3xz6nyzudEX78xaz8wazwxq1e7pRA+RYnpCUULNOYVahXNyhYOaImf8TaGl
3Dr2unUMtWvKVZtC6fnRfeh5VkfHsIKmx/xzG3wRDb459dS8QpVnFlHFhLln
1BBVLmrTqpkoIs7snFplGkiEOagJYfSDbcIt2/ib1nHlYdax5WKZdI4b/vN/
3Icaw5P3UNM/ML+ZPvzzmnxzG4ksb0SD2Tun3tTfM7teKKtzz6x1z6h1zagx
u6bXmB5iRZtWzW1qlYPaFGqV9snMTdvE20SYKdw67kZvmkKR+uF9aHuyF1KK
czkLWwMLWgORLf7IFvruYyKbvHMbvRGNJElzGkwDFJXuWfXumXUuajNqnTNq
CTOiNEworXEQkmbH1GqzfUqVKcwmhFon3CYqx98SKi30qd+9N5Uv3IfKx0L5
GZYT1R5Y1B5Y2GYy+xe0mgYQsb75TK93XrN3bpMnotEzh+h1E70PMrGz612z
6olYJzWid3qtY3ota9/0GrNjWo3ZPrXaFG6fUm0jeonUiRVmItdsIZKF2gm3
70+toZGGf3jFoLFfbkxXTnQn7QWiOohYopTIHehb0OqLpKYT65nb7Ilockc0
Eq2NpiddsxtYBmc1OGfVO2fWO2fUOajptNbaqU2jVmOfWmOjNoUF1jqpMtwy
sUJROrHCoJRpUlx/MZSyp/KWBnNjg7lLunNiunOiuwKLmUr/og7fonbfwjbf
gjYvtchWlsV5LZ55ze65ze6IJtecJpPZRVT2Zy7PJhKZSsfMeiLRbJ9RZ+rH
umtQaZtGMkFECmLWyVWWSSQKstHdD/37fgiizwu9P+6lLyKTz+QnIC+eBSF3
aTAnNpizJEiEB6K7/Yu7WESjiPAO78J27wJqbZ7INs98pt09r8U9t8UV0eyK
aDI7iXhFd6OD2qwGx8wG+8x6orteZM02vU41MxMeZp1WayXa2cLKxjK5muGd
zIA/1SfVL4Si/Fh+EvITkZeAXKE9Z2kwEBsMLAkGYoL+mG5/tKK908u0d5Bu
LWg3hRPx7sg2Ib7V7JrbYnrcGdHsnNPM5JMIzG4S4hvt1GY22GZQY12krW06
tTrr9Dqmt59lSo2Shyk1feEskbrQbdYpllE+mJ+C/GTkJSEvEbkG3QGh278k
aPbHBE2P+aK7fQK7Z1GnZ2GHewG1dndkuyLbNb/NOa/VObfFGdHiiGgmKzCn
WcnF7CZusxpts0gvbTMb+gmu1un1lml11OiL2TK1TpK9MMv0+hDbGho3qBEY
dv5lQ1L6FWaiIAMF6Ux4XgrFG3nJFOzmJiInATnxCMTxD/7YoG9J0GT20XgG
eKOD3sXdMp4u98JO98IO1wLihiuyXdldHlCbY26rYy4NqMU+h1qzjKfZNpv0
wTaribEzW2c0EOzTG4h0btN4azLzaAZYZjRaZuqNDlgJAJPKf5QtW3PNiB14
DEqaBuq/ho6bzwg3RtsrT/1no7eBhRYUZqMgE/kZyBccclOQmwxzThIlKYEE
BOLhFxh8sUEvcdXLKHiig57FQZa7qC73oi7Xwk5BwRnZQX5wfjvLHqEwr80+
t9UeQa3FNqdFONjfOqvJOrORGn3hkc5oMNOHuCIGxjq7WTWzlXDjw9YIxs/0
cA/P1l0HQVB6CjkHZCyhY5a89J74P+weLxGGXtGYDs0/GLg8XOTgcwqtKLCg
IBv5mcjLQF46ctNEOZMRSII5kEhpnz8BPgHIGwsvy4mHEOrvjg66F1NjUXEt
6nIu7DI7F3RSLBrZ4ZjfwRIxr93OALUJLgOts1t44LOaLbOaLDObaMsAzWoW
ZPpZZjdbZjdZRJSsEa1kcOa2mq3zWnv78Ad5M5C+aIPG03bVJcYocAD2LX1V
QsJ0LX5MwDAqIaF5Qt+oiYbC+McU/G8Dt8eLPSh2ociJQjsKbHxFvgX52cjL
RG4GctORIwAGkuFPgj8RZl8C3cEXD+9SPu4hCXMTfg8Sfq7F3FipFnUTfo4F
1DrtkdQ6xP70t81tIzC4zWkV2WkJs8xuIQ2a3TzB+GeZ02qJaLMQZmZLRAtZ
kLly6vx2amYraW24LbLdtqDdtrCDzn6gJ67RQbyMkpPw74PtM6QsR2ygT4kL
rRM89jdKoLr+Tu76dwYV3y+RGxZ7UeRBoQuFThTYkS+w5mUjNwu5mcjJQE46
Amnwp4iaJsGXCG8CzF6yx2EeEU33ErIFLtZcV3TQuZgb6+iioGNht31Bl0lZ
FpsIpm0exR7Wue1h1og2+UHwa1OiFm4hzOeyglvndZAEtpv6Wee1Wee3MaKR
7YKObWGn2baok5CN6rQt7rJHd9GVRgXBzMByr8UnENivREmlJca/0DrKo38j
muEhaP7IkM1nS/JQkoNiP59d5EWhGwUu5DuRb0eeDbkW0ews5GQikIFAOvxp
8Amm3iR4E+FJgIcgNbvjFNmuWDhjqAWd0aT1jsVBkcp+tgVdtkhqndb5nYIH
IRVOSDFJZgsh1t8yr40+rYK2NbLLGtlJkthBSC7osC6kxpfZoroISTIf/WzR
3faYbvuSoD02yCzo3wtJpQdJZVjswbwMzIjFpPl9aXto3vfI34Dpvf3cwfZ5
A9sXSotQWoCSfBTnoigHhX4U+riHAjfyXchzINeOXBtyBORAFvyZ8GfAnw5f
GrwCsicJ7kS4E+COhyuO5XWpurdziQiHyoXsUSy5toVB28Ju6wJqXYRdl/Id
DHmHZX6HLqmRjCNtqYVZCN8w64JO68JuxZOFXaZHrYs6rYu6rFFdNjHTtuig
LSZoY6Bhj4MjHo5EvjP1ZvjQMJZezhA8u/mXxGWIcmN+VnBmXHDifIyZFryf
Db0He6NabnAzlEP9QpA2qmSmHy9bhtJSlBaLZShAUT6KclEYQIEf+V6xDG7k
uZDrQI4dOVYEBHJfJnwZ8KXDS3inwpMCTzIfdyXClQBXPJxxeiXAHgM7IUEW
wmwjsCUeXxS0LqRdRo82XYQ6QyzxyqMsslEdhKVlIcd5tLUsoEZf+QgDvIjR
tUYFzVbC+VErdc5IwyZ8VUg7k+FMgTMVrjS4MnTUWYr7G4hnbULScv4hIi04
I6570oLu0dOC74/tCsGuL/usEH865OiAEISN3Nb0wrIVKC1DyTIUl6BYcC4q
QGEeCnKRH0CeH3le5HrEWjiR40DADr8Vfgt8WWItMuBJhycN7lS4U+BO1q1c
P8dSkGjxmGnwMSThtmj6ybYYVmpRUECTbEZ1k59a1K0cGI+HkR1oieq0Rktb
3G0RLbAs6rYs6jJb6PzH6KBVjDrBaxVsbbGwLRVBTuKuHclwpDC2bgv0LAXi
vAlgaj22+WHayfwECaWIEmmaEoMJkV2jZ3SOGtP17gdtI0Y2me7UzYxPqT71
VIlD/aEh38YsUW/UjTzY9MOytVi2ms8vWYHiMhSXoqgEhUUoKJQoIg/5OcgL
INeHHC8CbonMnfDb4bPBZ4XXAq/A76YhposcpeqZtSOBRcwez2DYlzLusQoC
Qomwoma2EifCiA2MKgu9FGgti4OMLR8ixLss0V3WmC5rbJd1Sbc1Jigjo1PM
FjL//bgf6k3Ya+N72DmusSfCngRnOpwZol1mj4uOen3w5Rgyzpg/aZKoTTXa
jyvBAhdmpWJyNJ/24ZTuUWM7RrzX9vaIpuFv1vUAGyrnUsVR9eS7rLhI+l0x
G9P+UAgnHuyR/7KNWLYBpetQugYlwpLi5SgqQ2EpCoqRX4j8ArEzucjNQU4A
OT4EPPALS3wOeO3w2uCxwpMNdxbcmbq8DWARTIJdjCrBQwyxsT+1kbEfYJPw
j/DjJmyxxCjyTE8RwJYlQeuSoCUmyPsi55bobgvxIbbbFtdlXUo7ctDggnUp
uFsz34BvTlxwpMKRBtHEh9x2ECe8fvgC8OXCX4BACRQT9FpDmK4TpocWeTEr
DZOiMU5c6ztjOoaPahs+smXYm/VD/1wlAhbCh8d7OU/1z9xzWi+2KL7c4ZSu
PaF8MbTK9IPln/FlyzahdCNK1qN4LYpXo2gVilaKp12G/FLkFSO3ELn5yMkT
TxtAwA8/CZwHXje8TvG0dritCokwgoSAsXPuaydDFWYTY2FLYOxo058AtEpj
7sQxrsKTZwnp7BhRF2JLbNCyVLZLgtmiGOqgNa7blkAtyD1IHEo7tkTQPehe
fE+h4RFnNpwWuIgnIkIeH7w58OXDX4hAKXJWIHcN8jaobFaQ0RWFC+Km/kOH
N735ZsOwoXVD/7NS+/0N072+9PHv0ot78H84BP8wQy+eK9uCZZ+jdDNKPxWl
2ICidShci4LVKFiJ/BWiFMuQW4KcIuQQ8TSEXFEKkjIalBdeD8udihNpyM4s
ODLhyFBW0k6ZUX97KmwpsCVzswovwqyUJVkTFO5hljhYliKb7Iw5e4kaZbbA
T7YoLmh6mPaylSrEgg5YCfykoC05SJhbRfGoX2X9e+7stMLsonT3ebcLHi88
fniFan8xAsuQsxK565D3CfI/Q8EXd5REWSq1nZWJKfH4eC5GkaUa3z7iww6l
8WFD/lSh/bbccDY989N98KIf+o6DenNDuuTN08u2oXQrSrag5DMUb0bxJknW
N6BgHfJJVlYhl4RmOXLLRAdKEChiHffl8chItpTc9adBO+3iGy1wZMOeBbM9
kz2ywGJLhy0NtlRC2kqiGm6VeMmSBGq6fxBALQmwxCObWhyylyJLXADvxzNP
EijnssQH+Xucfjax1WrIfrg9A3RPujvRYCZOqJkOJ9xuuIkXAXjz4CuEv1TC
jdXMi9xNyNuC/C9RuBOF+1B4SNeMR3u4MlMG8NFcvDslOHx057D3Woe9zQUX
7T+rtH+/rf3hFqMYOu/46HdwJnRO7q6ZyWfLdmHZDpRuR8mXohdbUfQ5Cjej
YBMKSG42il6sRe5q5KxCYAUCZfAvE70o5rF5C+DJU7cwPerywumB0wWHEw4H
7MIfuxV2C2zZsGXBlgmrDM9sTWeupMGaCgu1FOi1EuJQsrQkpVfZxKaw7ARm
URb7BN4MYB4R4xLprKAlMcg/J6qBm4nxpn9g1stt7MIah41FxemEywWXhH6e
HCacRkBDoTHlrEGuDDSfWPMVCnahcD+KDqPoWxSdRNHZu7zLpHjW0Hem4J1x
HcPfbx3yVpP2F67ZE2e035RTHParq+SA/u2KAv0+GbHhF3oy65Czevz590v3
oGQ3SnaieAeKv0LRNhSKIpNG532K3E+Y8tz1yFkn2rIa/pXwLYd3Gbylyks8
6cyB0w+HZHQOD+wu2J2wOWCzwybVCJsFVmrZsGbBkgmL4pAlXbda2ZLhZXMk
zBs23NlJoJaViKwEZMXzVh3UY2WLXMHcTWeWE1couHuWRIBZYoNDmOF0g+TF
nSPyQ4E3MWM5AquQsxY5G5C7GXkyzoLdwoyvUXQMRad0bXk87zz8Z3UHTUSO
XhR8dzqz5e0PWt8a0ThUq9X+VEnawmz51TXt5xfN2hvniStvnLsPV1SW8X2d
GwPvoH8AJftQvFdM1E4U7EAByceXyP8C+Vv5INGZswmBjfBvgH8dfGtlLKvg
XaHXLVxFYqYL4MiDIxf2AOx+2IUZNg9sblidsDpgtcMizLBYYbHAkg1LFrIz
ka37F9GO7HRkp3HLSpWj/bLYtin+ZCWDGk97mF6kI9mperOkwSKlYWsm85f1
kLTRysrpkIDC6YXLz3xw54OY4BVj5SddX8cjYz5sRf52MB+kZkt8UJaj4CyI
DTnn4T7JacVsOyYlcZHj3ZnBN8cyM4aNaBo2tHYIceL3pBo3hBlXtZ9f0F4/
q712WnvlpEm3UGG6Rbp79sLwPGoeq+Qwig+h6ABLQ8FeJid/lzBgO3K/RM4X
yNmKwBYEJMzybYJ3Izzr4Vmrx68POpfBWQpHMRxFsEtWYs+DLQe2AKx+8tFe
VX+1uGFxwuJAth3ZNmRbRReyKe3qn52NnsokHcxMhzmL/5PnD8sUhmRyJEYb
FZ3RTmYyN7JaKbq3F+5Rf8SR50nPSNuYM6R5VtZFuwMON5w+uKR0SAxxk3kt
Yp74VsC/hnnCQ/6MdYN5sod5UnREt7/hheeRfwG5F4Kek01Cw+Oj5jBHtPc5
0x4ytGEo+ZDf3dJ+Xa798pqw44r28/PaT09rr57UXj6u26N7PHhPnSO0GtJ7
hqKnIv9k0TdMUuFhsVIHkLcfeXuRuwc5uxDYicB2YdA2+LbCuwXez+DZDM8m
Fdc851wNx0o4JBqzL4OtBLYi2Aphk6TFmgdLDiwBZPuQ7UW22PJsN7JdyHIg
y44sGzKFY6qKlJmFzExkiAqFZaQzn9KRmaYkS1iUqsSDjtEuMczMR17IklOI
uaR9pIOkiaSSxCKrMpdOtqFkSZ0BuPLgFgVng1smXFqNwHrRHJFExSW9/kX2
q/AMCs+h4KIo2dkuxbf5AUwWHf1gXrdg+JieyBCLfn9b+7dy7V9Jby5pP7vA
R35+TnvtlPbKce2lb7VB35j64JpkIcrG3RUNhN9zpC+Omh4vOIr8b5B3BHmH
kXtIn6sJ7IV/D3y74N0J73Z4vhIR/QLuLXpeZl8H+1rYVsO2CrYVsErBx1oK
SzEsRcguYLnPh8y0ZecgK4AsHzK9yPQgU1KHTBcynci065ljWIYFGdncTOYM
8h9h6ZlGRqZi4AzhUnoa0lMhX/gwfWZKMxOrTc9lZSBLLiPlJSUmE0u21uZi
u8sS5oPDD/KPrgK4i+EhHko2Rlbcvx6BTcghTduG/J3KBg3oiQeKzqPwIvIv
InC2TWH2kGMnEtdhYT6mZmG05MPvTOsa9nGnNqJNe7NJBiR2SPuXK9rrF7RX
zjIrXz+jvUaa9602+BvFytB1cw/+1Zw0484soqIo8DX8h+E/CN8BePfBI07M
vQuuHXBth/NL3TI+bt8M2ybYPoF1A6zrxQetgWUVslciewWyy5At8V5WMTIL
kVlAyOYpW5mZgww/MnzI8CLdjXRXj+aFpduQZkUam02xhWmig2kc9PEmLM3g
HZ1KmxfS05EhGkDKSipLipuVjSyLbn8tdrbIVmIbeUwf+1CHlGCc+SD36i6F
hyKeVbrzZbZ9rmvcC4UHUXiEQwf6UnRG+HYhmH8hmHeBHdTmmyg7zdjQflQx
ZtgxJh7vLwi+PUMivpHtxDntv2rZgv5a3Ne/XNarAdrLp/n7yye010gPj3L1
7UhoBbgnH/2r+XdPtZ4jXfdBuPbDuQ/OvXDshmOXzrcXrFth2QKLmJnsTcj+
BNkbkbUeWeuQtUYUaiUyViCjDBnLkCFuPaMI6YVIz0daHtJykSYopvmR5kOa
R+ndAOFXajZSs7jRbqaiKzUDqcw/3oQpZjJXzem0eZZ0M0P0jDQ1M5uNMJli
dqHkSCXKsHpg9cFGoU8uHPlwigd2lcBdBs9KeNfAt0Ef14v55N3JzX+th9/F
Z1B8XuKvS8w52tlbhy8qsPYiW6jsbfzTHC/Gp+DDqO5RszqHj+epGW1Ys/Zf
ddq/V2q/uamMqfazi2RAtdfPqbqiNuio9tIRbdDX1PhA6HzKA38T5+5aC2rd
eyfb/WG22MmsbcjaiswtyPwMGZuRITlv+gakr0f6OqSvRbqU6tJWIG05Upch
tRSpJUiV+nVqAVLzkZKLlBykBAwdU1W5ZDuSbdKsSLYgOVtFi8mUDSdn0v8M
RWtKBlQLIy4q7mUhPYu5R1c8kU6WViYaMm3iRZ3sUcmvWsTBWgMcJ1G05Cjg
4ImiKFeZHuk/nLsNeTuQv0f4Qxw7iuITOsdI14ouovCSskbPHWrAzhp8Ws4T
287dSFyPyHxxeTHBURFdIye1D3u/TRvGK6W0P1Zrv7ml/eKa9sZlVr3Xzmmv
ntF+ekZ79ZQ26JjEHNqgw715FZoNG1WfsL+Zh+JJf8ByvAsZO5C+HelfIm0b
0iQXSf0cqZ8h9VOkbELKRqRs4IPJa5G8BsmrkbIKKeI+ksuQVIqkYiQVIalQ
zc2zDPJMSKIHiW4kupDoRKIDiZIiJ9qQaIU5kXgQligsTGKvl5SFsOQsNTL6
TOFd2aRKrTzdytaTNo+Stc2Q0IT8ZxbFQm6Ojiw+jpTooC0PdsW5ZSrKetr/
KQKfc8xMwTPxLp8iaonWmHenUXwOxRdRfAlFlyT5P8MLdI428T6p3erzyiyZ
nnzr47Yhb7doGq9i0353W/vldWIYaRnz7OUz2ksnKcJn9/bSt3yCaJk26JA5
hHehsQtzix+Z+R5/3hV93i8KlR64Cp/8FZK/RNIXSNqKxC1IFMuY+CkSPkHC
RiRsQIKEzwlrkLAKCSuRsAIykofjRRJVZB/vR7wP8V7Ei/DHuxDvRLwD5ni7
kpkEGxKs3MwJwi9RnCTepY2ZNVD4lS3KGJbCm1TxYukO5hdtBmY4kSHOMsvD
QVC2n8NaCm6FO0+5V3PaQsmL9xP4ZQw5XyFvF/L3oeAQCim6Po7iU3y85IJw
6rJo34UuvcZ6vLHz60bsqtajuQH2nVi6BhEBjEvDqEVsQIePbVe29iHtVze0
Nygguai9fl577TyzbvBxbfC3HJO8fFRsCfNM+qUdBXqf6/Pv5lnoujmJa7hy
ELcVS7dg6edYuhlLP0WsGMLYDSqgMPWPXYZY8VSxRYgtRGyBXq3jI37E+hDr
xVIPlkr4ttSFpU4sdWApscYcZ1d3jLeBmskcT6CHJwh3SLlIxcKTrOo2bCuV
ubQixYpU0cEwimDMGW7OEbx3xZlP2iX8ca6Ea41wZRN8m+Hfihyx7JTbFBhB
RvFJlJwBcaVUt3r9iy91m4x/pxrbjjWp4w+vuSD25DMsLMYkK95bgpERnKMN
e69VG9qk/Wed9odKFcVpP72o/ZR4c0Z75bQSUvZcg46I8zqsM+agjJw/Tfd6
MnNvvbmHM3y2YP9Q1FpErUbUKkStxGLJwBYvw+JSLC7B4mIsLtLj8oHRuYjO
QbTYlhg/YryI8SCG0FviVvjGOhHrkGYX1hDX7TDHEVP6xVkRL00pksnMBjA8
yY4kGzemkpwZqY0dqRI3qPjx6WzRUGsRrMWwlcJexmmiS6Icz0Z4N8NHqf82
5OxAHtkzVaf41uDHeaUJ5tIrMD1TcoHXYZ2uuETbs41tp5pZIXaTZ7qO4mOw
7eRLZ3jxcTLeWdD99rSOYR/zWkftv+q1f6/Sfs1uSY/jXzlF4Z+gfkyYQoHE
YcUB2hJPDvA9H+yDF72/f6/HQ91v7tVY6yU9PUY78zdi/gbMX4/56xC5BpES
OESuROQKRC7HgjIsEHldUKzz67GFgt2iXCzKwaIAoqjJKprFXl55stiNxS5E
izmKIcjNMWShwmPsWGLDEmGemXnYf6kNxME44RzpV4IdYYls0JIchrYwp8Iy
SCyezsxFVj6yJTG2URZfBvsKOFbDuQ7ujZzs03H/F1wKyN3N9QHyPsqs0fHS
c8Zc0bKrWHaFm/79zC3OmS401KvvTx1uwI4qDgNzDrNbpkOTbHg3Bm/PDr41
rn3oOxJL/KlG++1t7V+va6/zozDaq2cpltDtIjHOUChmHHFMdJ4/iX37e9k6
o85xt427N4oYcM8RqWqx9Zq9FnPWYM5qzFmFOSsxR/Qrogxzl2FuqeKUeR6l
yAPm5yNSCqKROYgMINKPBT5CYKFP9bzIjUUuLHLCHOVU2hbtRLQD0XZE2xAj
KkRsM5PqcbhhTqKzfpDkQrIbKV6kSt0xPRcZ1PI4mcsqgqUEVplrsa+CYw2c
6+H+BJ7PuEBDB3N2IXcv8ntM3Ck9Fy67grJrKLuKsstsuI5ePXLm5kkVFYbt
r8MWSa30OcK3pgSHftBByRSz4HeV2i9vaD+7or1qZMEU171ygpyOyfAzR4Qp
B9j3HNAt237miJk3oZ4/vEdf7or67sOdkFqHrPZjwZ2+AtzKMGNZTxb7xKwi
zJZEZXY+ZudhTi4icjFXkqa5fsz1YZ4X8zyYL5HCAjfP+5seYdRjWWNihRmk
PHEOjiESXBThkYV8ng7SZ5IbyV6k+JAa0POwjAJOsCnNzi6FpQxWiSUd6+Da
CPdmrpX5tiGwgytpdJxV5qiuGeGl51F2CcSR5VdVRNPvUs11+rjY3H62Bd80
6tlwv/StiCzBeNHht+boKwcf0v7AK921n1/TXr2ovXLOSG2PS4npKAduypeR
jii+KE0hXpCu7AuNA9SqbvSsyu33V+uK8RwfY/99oXe+A/Pt3CLtyh4uJMle
RLCGR8kYFttY6M1krMxsql5guB2IcyKOojY3EiRKoIg7yYtkP+dOqbmc+Zok
Ec4q5dqGZSVXrOzr4JBg3v05vF/A/xUCJPb7dNweKDkFMkvLLmD5Zay4hhXX
sfI6n73qcqOKEZ64XMX+5EpT08WWzjMt/NtXFeKc9iNuA2bm4KOU4LsLOBYY
QmnOkCbtT7UK1Qe11y5pL5/jgPnlU4wqIS6xlxilQ3q1YdB+XSMEdtaDffR/
793z34xb6Mqz8Pug39vjGHogMv/86AKMKcDYfIwTtzE+FxNyMDEHkwKYLC5/
ig9TvJjqwTQPpgvCM12Y6cQsauIL5jgQYcdcjsnmsi+fJ3oQyd5+AXFroVXB
GmXDYj5Glsv0fIwweAmFDBTQuRDn5vA7QQKxpACSKffNA+XB6YXIkJw4ezlX
qGxrYd8A5ydwbeaD3i/h36HzbGChpKKlZ/iH5Zew4irzbNV1FX89v/ayPCwh
/y7cPH658uzV2vLrDVVXmpsvtfIlh+qx9QaWSZgdtQIT7PgwrnvkbDZ12lut
2p/rtd+LHXv9iuLjY9pLFA+cpOiZzxgs4dngnniAnYlwcH9fHOyZVQhdX/Vd
3PuuqOIhnZtiCf8XHX8/Bx8EuH0onv9jH0Z7McaLsR6ME+M1wYWJLkxyYrJE
XVMcmGrHNDum2zFD2DfThllWzLZijhURonxzrZhnxXwrIq1YIEdIM81RxMhn
FjvYJcVIV7FuDtjjvJxVJfiRJKYupQCphUgrRnoJF6eyxBta18G+EY5P4fpc
f6I17yAKxOuQAi47i7ILWHGFz1xdrlu+B9dda9lwpVrx8WT58fM3ONe8Vs3K
WN5Yq1benGgO7qnCJ5eR942IZyE+ysD7Ud0jpnYOHSW1oj/WaP92S3vjmvaK
FNhfEgM4+Jj20jFh12Ft8CHtpUNK/5hz4tZ68XOfSXhJnmuPqdd6/ns4aWhd
z6qgu9ZO8zVmfbW11CBGevGOF+96MEp49L4bH7rxkQsfS7A2xoGxDox3YIKD
xdMk4c9kG6baMI2acGSGFTMtmEV5KbFN+ryLa3IVxRIUSqgYMEb0mXMsL+Io
C/YjIYAksZipxUgrRfoyZCxH5kpkr9ar/r7tCOxG7n7JQUnnjqP0NMrOg3Ru
5VWsvq5XCx46cf1bNczrlWdoe7OBJ2evtXafbw1SVrSrSj/vAW24xNu/r9J+
Ua5so7DkFPHDZFTuDqlwjYE3ScS2z3iWwuCFmVkRmn/ew4/QJycH6HrDnBBq
fjLKgfcd+ECA+siGj60YY8M4agLvBAsmWjDZiinydZoF0y2YYWHMZ8uRCBvI
BJIBnG/TfRjFb1FujrujPZw5LRETt9SPuADic5CQxwUjhcSjNomTXVvh+RK+
nQjsQe4B5H+Nwm/5OOnD8gtYeRmrr+lPwqy/iY03ujaVt+tR2OWbOuL6DOj5
Nl3WVpzhPGfhCkwSuRo2Fdp7aibqYe1nV0kJVPlGcD/Gtkyv3eiYi6wPUGCr
djf2ogf8aTLdRw8MT99Px7vn6fShFrxJGbt5mO4j3pb0XZa1mh6YLF+mWsA4
ZzPOsxTI4mk4+59HkYJKRzjkNj2VKrFcxipkrkbWWlg2wPYpHFvglqKxbxcC
e5F7EPk9NuaceHUj4+jHiN7Cppvst7dcr1I4Drx046jC8Vbt5Yp6nhcob2m5
2talLNIXN7lunb4NEcUYLbMe2rigNrJN+0u99tsK3ee/xFGW9pL4ipe+FYgP
9fiKMMFQ9vfqmO4zDbgzI8hH9+iyf398Q+JiOkWeXtXSYR5CZD1Kx9/MwFsZ
eDsTI6R0/24G3svEB5n4SMqLo7MwJhPjMvGIYBEpRifKx4l/DAUC5iVkyZ9m
4c1DXD4Sirjmmboc6av4vKx1yN4A6ybYP4drGzw7+GBgH88mFkimR0Zi+Xlj
XlTH+RY23+ZsfNuNajn+4tnyb9SYb1YwVBV1V2l7u6n2VivndqebcahOSjDf
IGkzZufivUQMmSWQD23izO9X/KC/9ur5OxZE+ebBXyth1p8KUF5YcN2rbIfC
W8mwHNyv11ZC8Va5hlFv/q4n+Niy8zOMpje4zxSopvaHpOLNVLwlc2Ij0vBO
Gkal432ZDyNX9XE6xmQwI+jrpCxMzsaULEzNZltDR2bZwQGXA3MpWBaPu9DL
CX50DmJysSQPsRLHxRcisQTJZUhdyXMNmVIJtWyC7XM4v4B7O3y75ZEeZcRP
6Jzh5xXXlWPjTd0mPXas/MSZcl38b95mPCtr2GdWN96qauFC8LU2nGnGgRqs
v6jP/T2maXXabyrYvb52kcer4lxyr4OOyA65V92Us9HW17L30oC9ph6LI0zZ
Iz8cUOXI+3AkdCXi/Z6OuftpGLGbg7UkDEnGUFkx+GYy3krG2ykYKbx6LxUf
pOHDNOGJ8GdCJpgnWZiSzXZJMWQ2McSJuU7MF3+60M9Fl2jiRj5XNJkbJUhc
huQVSF3Fkz+ZknvYtsC5De4d8O1hVuQd1t8gsOICVl3G2mtYfwOf3MKnFfqz
lF9WtO+4Va94cezGKX0e+trt4zcUY6o4jKmtu1LTyA+KV7R1XG8H5yZqzUHU
GvZmQxd1a+ODen73S6kFvybqMpgS8qOGvz0gHNqroDf1+Fbdxof3imP5rMH7
wv4bfOnrKSWln0ugLYUWp7j090MT8WYShidjhDDq3RS8l4IPUvFRGkYLZ8Zl
QDFnisyoTKdQSDgzhzgjtmyBT8phuYjOx5JCLJXEImkFUlYjbS0yNiBrE6yf
S1a4w1gFT5qxTFKK1Vew7jorxqbburfov60S2ys5Qdh36/ahm5eP3TijngO8
eovZcfv2t1UVx2qqOfipq2dDVt3SUNkevNLKl1CAuuY87LKi6f2M4IgFHUPH
tmpDm6WHR7SfX9ZeO6u7ZF4qcNhwyfsMb7DbpGzZHrNi2V5RPhWjcvg6+PB/
gyf99Mj0BxIk8Y0XQVsMLQY9fFH24YV3kjEqWdggPBgrdovYQEZrqjjrmQ5O
FOe4MNeN+RL8LMpBVB6iC7CkCHGlSJBlI2nrkLGRGaDn1/79yD2MAjFNZWew
8gLWSCbwyU3yGbzzRRW+rAruqGL/sb+i6vCta/p6CwN9Nlo1lVywra9li1Xf
VFHXqvB96Hg9dtwChUWZX2KmFHyGze4a9mELpXk8wF9cNWb9VULAHJByoVkX
f8ZfsYC/SAmox5v0xEIqTpJU4mvqgi994P+SH6FPPz2n+xiKLBZAWyhcEfZo
sp6ZtkPjMCxB9+Sz3JjjwVwv5vkQSU6c64Smh61b4fgKnl3wixcIgXr9dRDU
CoVt1dheHdxVzVAfrKzV7cnFijMEdfnt4wS1rO0Pv96G4w3YVYnSY3rNcAhF
miPbtf+oJX9gUtXYV872oHhErMx+jjCVLO/Wrcwe8Qt3rM6d7yoKpUsOMLSU
cr909L+Da2iW8JxxhRahnhjizZMEsBbF8s8/xGBoLN6U1eHDEzEiEe8k4b0e
8c/E+CxMJIdtU/nE81GFiC7GklLELUfiaqSIG87czAs5CH33LvgkRjLJXOwy
A/0NUm36rAJbq/BVNc+j76kJ6tnQ8QpeyXexgtOk8ooTevWjrpIltbGWjzY1
lDc2c7mjur1TrezvhYyS619wtVB75QxX/V4+ZtT7ehl9bdAuk1j+e3ii++s9
poGGmB/oxY5v78sNo/JkzOqG2iax+2HajG5tDrQI3cb+hOV7EYMxZDGGxGCI
yPdbCXg7QQeevo7OxNgsjM/GRCumSjow28fTn/NyEJkLNRtCTIgtQ/wqJK1F
6kZkyDMhtm1w7oR3LwIHef2bmo9Yed5Yob/pJj6vABma7dXYVcu/Hajt/rqG
Q9ETVTfOVF6+WHlBMUHVVesqWBibarjG3VJ3sbmRU4WmtpbaDijTrOTtIdEE
iYx4Sco3ZCFMumnfo2BnfHfpMeputQ27I/17DGuzT5/B4BlbeesgpxYyRRXK
AYlT73mH3x1PK0uptdmqCvMim5JoaPLA57A4DI/HyCSMknjoY4I6m6GeZMNU
CT5n+zE3F/PzsaAAi2QCKHYF4lcjeT3SNiFT3KljO9x74D/A63co8VKrmT4V
dLcRujXYLegerOs+UstPpZ+srjhTde1i1eUrlWdZxCm2EXNeV/mtAHy6uZpD
ytY6Lvu0Nlc2tclbJ4x3tJEUcRmb7O5Bk25ZdulSvIt3dQlWmD7cg6mSZZPK
GAaRyZZZie/A8/leXlJFz9oMsPTO0yPhZ8hODE9g9N7tjZ4Vk0VKZ/owJwfz
8rCgEIskGIldiYS1SN6AtE+RtQW2r1Ts8+jyc1h9CeuvgUCj7wTajhre2V8X
PFQfPFLP+erJmpqz1TeFjkduVZyorDheU8FwNQhoCrG2Gg4R2xuutTXLu4Rk
FTzfQpaWHlAyaOBjSOAu1QzURPeN/GnwPj2rYutBee1RRv6lYyp37Ru10HdC
Gu8jNA3QyFvMFN2nzuez3pMYKiQf/TADlJ+Os2CiHVMkmpsVQEQe5pPUlSBG
YojE9Uj5RCE2MN9wZ6svYv1VbLqBz2+zsCn7d7gh+E0Dy/ypuoaztZUmHbVK
Rqe64pigdlRQ4wisvep4hwDX0XCVTzTeW8MzinsMDd3Zs2V526mETimwWNH+
huLuYzM7+KBe6zdzATmMpExP9/vG7If39VPj1FscePOgplLheRwRKG81RAKB
t5M4vXxUVCRzK6xfwbkLXgqwvpa60mmQyVt3GZvK8fktY+51Tx0O1INwUrWl
x6/UsNe5VcX+pbryuCB0rEmcTmsVbztk21l3vquBn4SRp/geUAAYSOzUBu24
g5K5F0o6aruF2TpEL3/NcdOgr/VIbPApyiPJY+k4hXpuhdOP+sJJZPVDthDa
xG7h9I+1uWDHYmD0ZjwnFaPEhY+2YpwdE5084UFf5+RhXiEWliJ6BZauRaI8
NZT1BWw74Ca/cQgkaCUn+eCaS9ioV+bCSTsFwCABqGYLTje2n2/gp7qu1LJX
uFXD9r+66lRdFUtYk0hbq2hqB+0zyT1vShP126kQ22E25OvJHuQE4T1GQn2Q
3fDL7FfEkkkG8fJZ7dVz2s8u9THjoHD7sW7Jet4QEaaN79KmoEe2fqBFcgzE
cC3lwHIEZV9S6xprxwQnJnswXSYa5hVh4TJEr0LcOiR9wkeyv+QVrErayPaX
ncaqC/r7UrbexvYqtv0kaV83sjqeaAqebuo+38hvfblaX1FeV36r9nJlLc/k
G0B9K0AdVXFNUPSTh9CzyuWOdG1noAyBE8xUnK6Eca8xuybh+SvHZPJT6nOv
nDHmpf/1mj6nGRp/K9ReDDkq1R7x0e9KGjGmQ5ssjnWmHnd9n92q4DdSAhfK
x8c7McmNqT7MzJXKgQJvPZI/Rbq8Csi5B76DPJOhnorZdB1bbvHxXTXYTwra
CIGNazDnm/gVGlcbasrr+QV8lVI8q6tmw9VEyqmeY+2q4DwyWHk0WM2Oref9
hZxCbtcGfSXbHTqCOzhK32mI4B41NyrTI4IYP5Qg8vXKOV609PMrd5751REJ
nZ1UuP1dX1o6UBuuT+uQlvKWXOlctmRi/x/42IbxLkz2YUYuIiTMWLwKS9cj
6VPj+dBlp7DqPDZcweYb2FaBndX6qvhvmnC8GacJH1n5c7WxsbyR71RZz4+6
1tWc0zP9dkGG8OmuZNUJVkkx/Vn0vL/lKxai7bq1EnT66egMNoIxtdZLG/QN
BdW8yuE1Tv4ZmzeuaL++of2+QvszPzlozPn0wkCtMAl9SzEjI6MboE0XOBbp
6d2QeAxP0TO5BzO+4PK+54CeRSw/y2tkNl1jQdleqUdE3zTqcwH6NS2V37ZW
ftNe+U2HDFsfc8XXkGELRx4Uxn8p7SvZ3y7bHUZuMHi/6XFJjKWsN+gYJxM0
6J9KPelnl7VflvMq0b/Ua8OalJYaM5R3cjDjiLz52LBAQvEL2kftujxM55hA
H/pSDKWsSwqnH5FIkOoEeMlGpKxnWbqB68IZ27iu4j2gT/+tPIf1l7HZmEEM
319HxgbfNuFUi/780tWWzvJmjuorGyuqG9g8N9Se4yiz6oTu28Q8E0bdlUcE
Jt5KbURZlG2Ekex8ZWAkNmbwfu0lmUo0VlQ8zEXp185qP72gr04igfjPGq5d
j+p4a1y3koz7IRT6TmpDMkkqP2jV5NUqyso8wQUaSv+TMVIlpS6eyJ9RwOuO
FkmxPvkzLnw4drNlIf/Fk95y5Q9IXPbU4FADLyE50cynXmzFldbu8hbmRUVT
TXUjz+LV111ukkyzVYxIZ9XxLoEkqKTo9kHIV4n0+t+NEAnPTsPe7GN4eNr8
CK/M0uejXr+k/Ys8qvbHapIb7d32N8cGP5gX7BEgQx/71J//fT+MwrX3ZHXY
JJBdUdGeFo+3UjBKaoUT/Ziej4hSLFyFJfJEDONDKcsh3bo8v7MKJDhHGnFM
YDlPsLTheitb3IqWxuomtij1DdcbVUpSc7pd4u0u0SYyJUpkcFsq2D/s8ROD
vuiFyy6pfCttH3yYF4VwOicu6bULXErX14f+iVN7nmAaHRw5Mzg6Jjjbfgce
kYI+sflJH9goL6pQIfMik0SmAYXHsPwM1l/C5uv4UoptB+t17Xn6XCsuteFa
GwtrRWtbVUtjbTOPvbHhenPdxdbac+01bPO6qk90i9IokcCtA/rYf3THT7NN
UXnGwxK/yGwYV8s4idVeFs/yKmsK16n/WCX3f0D7uPvt6Rgbi1l2XqRqMqa8
jEVI9477/+iWRWwaz4hrWqX2brMuDTMlW6N9UphUjLJgtFTwZxRh3nJEr+c1
5ZnyAKP/MAiXFYLL5+XYXoG9NUq2nj7dggutuNrOp91u665qbatt4QCgsel2
cwPLcrsoS1fN6W4xJ+x9xeriFi8n0N9kb+odu+xhTA7q9o9SKl57elqf2PrF
de237Ei0Ec1Sd+vXM2JdBJS9+McQNHreSfV9bVSL3vNMiehiMCQRb2fos95T
CxBRhqi1iN/Mz0LYZfVZ0XGsPIuNl/Xo8EiDbh6UVDxysz1Y2dZeI7N0Dc01
zU0cgLTXXeyo4wJJt0Rp7FBZl16841H3mZ6VrPOITg4F+BSnqkmjX99i00gW
4P2OoZP4VpMzeEly+maeDv/sJg7V3HEqMuLv0c6dtZr/dL/RhylL0EP7Q8T5
oSl4J1tfZTGbjMAaxH3KD4HYdvMDdfqc5dYbXNo8WIejjew6LrSpVdRh7ZLv
CCOU8t06iJvCV/Hmz5iMimXPULXBsoz4lfO6F/hTtaY1aKPatHHBd0UY5+dy
Ipt/hJ+eOVjfrdYD9YxlgnrXlnovaOgYlb39szwIP6ZbmxoktVZV4E+u4Iub
2F3Fc6jfNhrPClxvx80OVEqFqqGtpam1oaW5Sl8F1113LljDZoyCAmXRWY9v
yjz0/7xjww5JUzHASe2ls0Y2+rtKsVOt2ujukXMwPgmzpfwfOICNl+68PaSP
cYX+PQMZ1z/dGdfYbm1aUJP3+7yZhBHEOQ8mS5Vv8Xp+DiR7J7wHWVtXyhsD
tsmoD8vM8dkWXG5DeQduy4jr2jsb21paWvktTR2N5Z2S3wdrz6rgGLrtMvgp
Hli9s/MIx3iD1HT+ee2Nq9q/qcpL+Nsz8eESzHAifo2uK6eryvVx9J7pYqlV
ox3c2z49oYbI/c4IUs5FO2+l4T07r8mbKc9JkFaSQXIfQMG3bI1IJfXcgpKA
cy1shW6IIapu72xob2+Wylh7c0VnI0e7wboLQalk9OIoW5mf3In3jmqDRDrJ
7P6inBdKaZy1Dpsk9eyBOq2K8pdD+MS5hFrTMzILH3kwpQDzZE1r6jY49iLv
KLsVFW1//2TzHZtZ0d5V29HZ2M7OlKulzRVdTTq1qD2jqDWJ91TUyt+1eEyw
l5llgv93lfwIxYj2oWPYFU7J5IJkxhaUnuAI+HhDp1Sb77YQr/RBvZ77Tgxq
c6T+L/b12Q2XsLUceypxpJ7JvSDrBW91BKs7uus7OO5qaWtqb63rbGaBDzZc
DdZzEIDqExBzj9vy1MY/Gv0/qP2hWhvaPOSDrlGz+S4zvVxWyDuELVL1f+ge
Sl+9H6WPUX6p3NfbmfiQlKAQ81cjTq2NPIiSE1h3kUnfXSniL9c8XtGJms5g
Qwffuq2tpaOVXVWw6WawkecECHCopJpyASH8n3tk48/12sj2EVO6RiwMTpOQ
w7MPn1w15lHCeyLV13QpeaaHT3+p1IV6gRBrwZgAZpVh8UakfslHSFdXn8Nn
V43q08kmlo5r7TrND7d0dHa0t3bppN6GCDOTqoRZJHmwEc+Ezys0ch01kxlu
5FvyNx16I9nz9glNq9I+7tRnR96jnFyQjP8c1t06DQN23MahWjBlLbgucst1
fbVuMdhSHWzht4uBRfacoWAy5/eqcQ/9nmadIvXM/s/6oEj3U2O6tNlBntAT
nXqQjOa2cuyvwvFGKBGs6EBdJxo7QfAoXwQpj3A/r+l3UW+3feN+d3lYG0+W
NKglMDsnkL6uQcIW2PawdaEjW69jX5U68xEaM92wlm/IwV9ne2uwrSkoLEHj
NdSzK0ONWpXwsn53qcqYfq7Lw9MGhwYMSeH7TStF9Cf81GXga6w4bbyL4Egt
zjZT0oFb7Tw8ltKOrq729mA7+200V0AJat15SIzNfA8z1trIXxvpPdKn7uA5
1ZAKwfPxwzU41YhLLboraOpEe2d3VwcbIbTW3blPrX6ff9THJHmf6V/vd58H
KJQeuhQj1OK/DTy8nCNYdRZbrukjfOSirBevakdTZ7CVxiY2JCj35BvWX1Yi
JFaZ76j+MscvQ+4o9cGHe1aJDY3A8CS8J0XLuM/h2M8rMz+5hF23dU6Xt6G6
A/Ud3a0dwr+2pq7W2qDYLNRfoWGalFfnO0rkYvqVzrcne91ZFIQ3/VO/uqNl
BypxulEff73A2d7R3t7W1N3KS4RAGitxsMR+3L/kafIXbXqP6LGQ7ypaHRLF
Ybm6j3UPG7VPL2NPBb6txflG3BZNbOnsbuvo6GrnlaRoqUNTJRrYRPxIlw31
l6N+E9K/rEJ8tHf0zJZgYufQJSATMFPWKPsOYfVZfFmOQ7oeDKxsuzPuYHsr
WhvQzKr/A31sEr2Yfhtyr0dCx2bY8PAxfn6wi/YorlW56ol6XGxCZTsaOoy/
b9TaqOv1M/pd1N8u+53OodDee54r02bJ44gqnis7iS+ugfTrfBNuiAVp7Qy2
d3QGOzoE66f0vsVKmv4Q0mefKw/Fus/tpuh5aikSZZXlxovYfQsnG3QZb+gg
1nQHRa9kVoDvoP5u3b+H9Bg692GsnjaFjbZj3ipk7jLmr2kAxHiStHYxEIIu
9/sr6fePIf2E1rx5Blqqiv2Ir0eqcLUFaoq2Zx29cM/0p5DrQmt28l3mOOKD
k3IQ/ylypeJ0sArnVLnN8IuCpek/0Gu9dwh9apxTSpDyJYu4yVgty1f/h1z9
577w7+ONoGH6VX+Rq/6rT8m48/1h/ew35ey/9CGloRzir/L370waekWDIXzj
Pt+Rs4b2+tXI1fjX9+VXvi8nsB/LN9P3/j9G1rWd\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->174886291]
}, Open  ]],

Cell[TextData[{
 "Three-dimensional graphics can be rotated in place by dragging the mouse \
inside of the graphic. Dragging inside of the graphic causes the graphic to \
tumble in a direction that follows the mouse, and dragging around the borders \
of the graphic causes the graphic to spin in the plane of the screen. \
Dragging the graphic while holding down the ",
 StyleBox["Shift", "KeyEvent"],
 " key causes the graphic to pan. Use the ",
 StyleBox["Control", "KeyEvent"],
 " key (",
 StyleBox["Command", "KeyEvent"],
 " key on Macintosh) to zoom."
}], "Text",
 CellID->120249745],

Cell[TextData[{
 "There are many options for three\[Hyphen]dimensional plots in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Some will be discussed here; others will be described in \"",
 ButtonBox["The Structure of Graphics and Sound",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"],
 "\". "
}], "Text",
 CellID->17349],

Cell["\<\
The first set of options for three\[Hyphen]dimensional plots is largely \
analogous to those provided in the two\[Hyphen]dimensional case. \
\>", "Text",
 CellID->15827],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    ""},
   {
    ButtonBox["Axes",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Axes"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to include axes", "TableText"]},
   {
    ButtonBox["AxesLabel",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AxesLabel"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[TextData[{
     "labels to be put on the axes: ",
     Cell[BoxData[
      StyleBox["zlabel", "TI"]], "InlineFormula"],
     " specifies a label for the ",
     Cell[BoxData[
      FormBox["z", TraditionalForm]], "InlineMath"],
     " axis, ",
     Cell[BoxData[
      RowBox[{"{", 
       StyleBox["xlabel", "TI"], ",", 
       StyleBox["ylabel", "TI"], ",", 
       StyleBox["zlabel", "TI"], "}"}]], "InlineFormula"],
     " for all axes"
    }], "TableText"]},
   {
    ButtonBox["BaseStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaseStyle"], 
    RowBox[{"{", "}"}], Cell[
    "the default style to use for the plot", "TableText"]},
   {
    ButtonBox["Boxed",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Boxed"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to draw a three-dimensional box around the surface", 
     "TableText"]},
   {
    ButtonBox["FaceGrids",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FaceGrids"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[TextData[{
     "how to draw grids on faces of the bounding box; ",
     Cell[BoxData[
      ButtonBox["All",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/All"]], "InlineFormula"],
     " draws a grid on every face"
    }], "TableText"]},
   {
    ButtonBox["LabelStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/LabelStyle"], 
    RowBox[{"{", "}"}], Cell["style specification for labels", "TableText"]},
   {
    ButtonBox["Lighting",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Lighting"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "simulated light sources to use", "TableText"]},
   {
    ButtonBox["Mesh",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Mesh"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "whether an ",
     Cell[BoxData[
      FormBox[
       RowBox[{"x", "\[InvisibleSpace]", "y"}], TraditionalForm]], 
      "InlineMath"],
     " mesh should be drawn on the surface"
    }], "TableText"]},
   {
    ButtonBox["PlotRange",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotRange"], 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["Full",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Full"], ",", 
      ButtonBox["Full",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Full"], ",", 
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"]}], "}"}], Cell[TextData[{
     "the range of ",
     Cell[BoxData[
      FormBox["z", TraditionalForm]], "InlineMath"],
     " or other values to include"
    }], "TableText"]},
   {
    ButtonBox["SphericalRegion",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SphericalRegion"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to make the circumscribing sphere fit in final display area\
\>", "TableText"]},
   {
    ButtonBox["ViewAngle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ViewAngle"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[
    "angle of the field of view", "TableText"]},
   {
    ButtonBox["ViewCenter",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ViewCenter"], 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}], "/", "2"}], Cell[
    "point to display at the center", "TableText"]},
   {
    ButtonBox["ViewPoint",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ViewPoint"], 
    RowBox[{"{", "1.3", ",", "-", "2.4", ",", "2", "}"}], Cell[
    "the point in space from which to look at the surface", "TableText"]},
   {
    ButtonBox["ViewVector",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ViewVector"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "position and direction of a simulated camera", "TableText"]},
   {
    ButtonBox["ViewVertical",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ViewVertical"], 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}], Cell[
    "direction to make vertical", "TableText"]},
   {
    ButtonBox["BoundaryStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BoundaryStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to draw boundary lines for surfaces", "TableText"]},
   {
    ButtonBox["ClippingStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ClippingStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to draw clipped parts of surfaces", "TableText"]},
   {
    ButtonBox["ColorFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ColorFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to determine the color of the surfaces", "TableText"]},
   {
    ButtonBox["Filling",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Filling"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "filling under each surface", "TableText"]},
   {
    ButtonBox["FillingStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FillingStyle"], 
    RowBox[{
     ButtonBox["Opacity",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Opacity"], "[", ".5", "]"}], Cell[
    "style to use for filling", "TableText"]},
   {
    ButtonBox["PlotPoints",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotPoints"], "25", Cell[TextData[{
     "the number of points in each direction at which to sample the function; \
",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["n", "x"], ",", 
         SubscriptBox["n", "y"]}], "}"}], TraditionalForm]], "InlineMath"],
     " specifies different numbers in the ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox["y", TraditionalForm]], "InlineMath"],
     " directions"
    }], "TableText"]},
   {
    ButtonBox["PlotStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "graphics directives for the style of each surface", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, True, False, False, False, False, False, False, False, False, 
     False, False, False, False, False, False, True, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->30954],

Cell[TextData[{
 "Some options for ",
 Cell[BoxData[
  ButtonBox["Plot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot3D"]], "InlineFormula"],
 ". The first set can also be used in ",
 Cell[BoxData[
  ButtonBox["Show",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Show"]], "InlineFormula"],
 ". "
}], "Caption",
 CellID->31504],

Cell[TextData[{
 "This redraws the previous plot with options changed. With this setting for \
",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 ", only the part of the surface in the range ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "0.5"}], "\[LessEqual]", "z", "\[LessEqual]", "0.5"}], 
   TraditionalForm]], "InlineMath"],
 " is shown."
}], "MathCaption",
 CellID->3281],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"%", ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "0.5"}], ",", "0.5"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->14246],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->218709797]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["ClippingStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ClippingStyle"]], "InlineFormula"],
 " option of ",
 Cell[BoxData[
  ButtonBox["Plot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot3D"]], "InlineFormula"],
 " can be used to fill in the clipped regions."
}], "MathCaption",
 CellID->261104373],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "0.5"}], ",", "0.5"}], "}"}]}], ",", 
   RowBox[{"ClippingStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Opacity", "[", 
      RowBox[{".9", ",", "Gray"}], "]"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[24]:=",
 CellID->207531048],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]=",
 CellID->302626911]
}, Open  ]],

Cell[TextData[{
 "When you make the original plot, you can choose to sample more points. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " adaptively samples the plot, adding points for large variations, but \
occasionally you may still need to specify a greater number of points."
}], "MathCaption",
 CellID->27285],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"10", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"x", "+", 
      RowBox[{"Sin", "[", "y", "]"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
   RowBox[{"PlotPoints", "->", "50"}]}], "]"}]], "Input",
 CellLabel->"In[26]:=",
 CellID->16114],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]=",
 CellID->287982764]
}, Open  ]],

Cell["\<\
Here is the same plot, with labels for the axes, and grids added to each \
face. \
\>", "MathCaption",
 CellID->22832],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"%", ",", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<Time\>\"", ",", "\"\<Depth\>\"", ",", "\"\<Value\>\""}], 
     "}"}]}], ",", 
   RowBox[{"FaceGrids", "->", "All"}]}], "]"}]], "Input",
 CellLabel->"In[27]:=",
 CellID->23673],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 131},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]=",
 CellID->218694158]
}, Open  ]],

Cell[TextData[{
 "Probably the single most important issue in plotting a \
three\[Hyphen]dimensional surface is specifying where you want to look at the \
surface from. The ",
 Cell[BoxData[
  ButtonBox["ViewPoint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewPoint"]], "InlineFormula"],
 " option for ",
 Cell[BoxData[
  ButtonBox["Plot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot3D"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Show",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Show"]], "InlineFormula"],
 " allows you to specify the point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], TraditionalForm]], 
  "InlineMath"],
 " in space from which you view a surface. The details of how the coordinates \
for this point are defined are discussed in \"",
 ButtonBox["Coordinate Systems for Three-Dimensional Graphics",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/CoordinateSystemsForThreeDimensionalGraphics"],
 "\". When rotating a graphic using the mouse, you are adjusting the ",
 Cell[BoxData[
  ButtonBox["ViewPoint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewPoint"]], "InlineFormula"],
 " value."
}], "Text",
 CellID->12312],

Cell[TextData[{
 "Here is a surface, viewed from the default view point ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1.3", ",", 
    RowBox[{"-", "2.4"}], ",", "2"}], "}"}]], "InlineFormula"],
 ". This view point is chosen to be \[OpenCurlyDoubleQuote]generic\
\[CloseCurlyDoubleQuote], so that visually confusing coincidental alignments \
between different parts of your object are unlikely. "
}], "MathCaption",
 CellID->3232],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[32]:=",
 CellID->14883],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[32]=",
 CellID->125635056]
}, Open  ]],

Cell["\<\
This redraws the picture, with the view point directly in front. Notice the \
perspective effect that makes the back of the box look much smaller than the \
front. \
\>", "MathCaption",
 CellID->7768],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"%", ",", 
   RowBox[{"ViewPoint", "->", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"-", "2"}], ",", "0"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[33]:=",
 CellID->32589],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 81},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[33]=",
 CellID->266327942]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["ViewPoint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewPoint"]], "InlineFormula"],
 " option also accepts various symbolic values which represent common \
viewpoints."
}], "MathCaption",
 CellID->173239004],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"%", ",", 
   RowBox[{"ViewPoint", "\[Rule]", "Above"}]}], "]"}]], "Input",
 CellLabel->"In[34]:=",
 CellID->294519928],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[34]=",
 CellID->360091387]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{"{", "1.3", ",", "-", "2.4", ",", "2", "}"}], Cell[
    "default view point", "TableText"]},
   {"Front", Cell[TextData[{
     "in front, along the negative ",
     Cell[BoxData[
      FormBox["y", TraditionalForm]], "InlineMath"],
     " direction"
    }], "TableText"]},
   {"Back", Cell[TextData[{
     "in back, along the positive ",
     Cell[BoxData[
      FormBox["y", TraditionalForm]], "InlineMath"],
     " direction"
    }], "TableText"]},
   {"Above", Cell[TextData[{
     "above, along the positive ",
     Cell[BoxData[
      FormBox["z", TraditionalForm]], "InlineMath"],
     " direction"
    }], "TableText"]},
   {"Below", Cell[TextData[{
     "below, along the negative ",
     Cell[BoxData[
      FormBox["z", TraditionalForm]], "InlineMath"],
     " direction"
    }], "TableText"]},
   {
    ButtonBox["Left",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Left"], Cell[TextData[{
     "left, along the negative ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " direction"
    }], "TableText"]},
   {
    ButtonBox["Right",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Right"], Cell[TextData[{
     "right, along the positive ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " direction"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->6209],

Cell[TextData[{
 "Typical choices for the ",
 Cell[BoxData[
  ButtonBox["ViewPoint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewPoint"]], "InlineFormula"],
 " option. "
}], "Caption",
 CellID->21987],

Cell["\<\
The human visual system is not particularly good at understanding complicated \
mathematical surfaces. As a result, you need to generate pictures that \
contain as many clues as possible about the form of the surface.\
\>", "Text",
 CellID->18795],

Cell["\<\
View points slightly above the surface usually work best. It is generally a \
good idea to keep the view point close enough to the surface that there is \
some perspective effect. Having a box explicitly drawn around the surface is \
helpful in recognizing the orientation of the surface. \
\>", "Text",
 CellID->13245],

Cell["\<\
Here is a plot with the default settings for surface rendering options. \
\>", "MathCaption",
 CellID->1912],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], ")"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[37]:=",
 CellID->28639],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[37]=",
 CellID->53625811]
}, Open  ]],

Cell["\<\
This shows the surface without the mesh drawn. It is usually much harder to \
see the form of the surface if the mesh is not there. \
\>", "MathCaption",
 CellID->4248],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], ")"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[49]:=",
 CellID->1479],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx1mH1MVWUYwK/B0qxpH7ZmmQohKM1Imltm7pyJc9osGOZarNbCPtTQlim2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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxNmAmYl1UVh78PZGRHZoAZHBwGBoaRgZncSNxywSBTYzPESoHBLEkGGSIV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        "]]]}, {}, {}, {}}, 
    Line3DBox[{297, 1, 291, 227, 16, 31, 46, 61, 76, 91, 106, 121, 136, 151, 
     166, 181, 196, 261, 301, 211, 295, 282, 212, 213, 214, 215, 216, 217, 
     218, 219, 220, 221, 222, 223, 224, 263, 302, 225, 296, 283, 210, 195, 
     180, 165, 150, 135, 120, 105, 90, 75, 60, 45, 30, 229, 298, 15, 293, 265,
      14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 264, 297}]},
   VertexNormals->CompressedData["
1:eJx1WH1Yzucef4pcVjjjjHGwUXZt5yVGqdH4IiGaJTqsFxI7lyNF2xkWNYo6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    "]],
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{-2, 2}, {-2, 2}, {0., 1.}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[49]=",
 CellID->259026124,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[TextData[{
 "To add an extra element of realism to three\[Hyphen]dimensional graphics, \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by default colors three\[Hyphen]dimensional surfaces using a simulated \
lighting model. In the default case, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " assumes that there are four point light sources plus ambient lighting \
shining on the object. \"",
 ButtonBox["Lighting and Surface Properties",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LightingAndSurfaceProperties"],
 "\" describes how you can set up other light sources, and how you can \
specify the reflection properties of an object. "
}], "Text",
 CellID->2043],

Cell[TextData[{
 "Lighting can also be specified using a string which represents a collection \
of lighting properties. For example, the option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Lighting",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighting"], "->", "\"\<Neutral\>\""}]], 
  "InlineFormula"],
 " uses a set of white lights, and so can be faithfully reproduced on a black \
and white output device such as a printer."
}], "Text",
 CellID->54687613],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Sin", "[", 
     RowBox[{"x", " ", "y"}], "]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]], "Input",
 CellLabel->"In[52]:=",
 CellID->220434071],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[52]=",
 CellID->99624649]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " option by default uses ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Lighting",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighting"], "->", "\"\<Neutral\>\""}]], 
  "InlineFormula"],
 " so that the surface colors are not distorted by colored lights."
}], "MathCaption",
 CellID->14702],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Sin", "[", 
     RowBox[{"x", " ", "y"}], "]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "Hue"}]}], "]"}]], "Input",
 CellLabel->"In[53]:=",
 CellID->14439],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[53]=",
 CellID->213785204]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->121216876],

Cell[TextData[ButtonBox["Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphicsAndSoundOverview"]], "RelatedTutorials",\

 CellID->151800574]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Three-Dimensional Surface Plots - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Graphics and Sound", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> "paclet:tutorial/GraphicsAndSoundOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/ManipulatingOptions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/PlottingListsOfData"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 44, 1.1090402}", "context" -> "", 
    "keywords" -> {
     "angle of view", "AspectRatio", "aspect ratio", "axes", "AxesLabel", 
      "boxed", "camera position", "color", "ColorFunction", "DisplayFunction",
       "FaceGrids", "graphics", "HiddenSurface", "hue", "lighting", "mesh", 
      "orientation", "perspective effects", "Plot3D", "PlotPoints", 
      "plot points", "PlotRange", "plot range", "plots", "point of view", 
      "position", "rulings", "shading", "show", "SurfaceGraphics", 
      "surface plots", "surfaces", "Threedimensional plots", "vantage point", 
      "vector graphics devices", "viewing angle", "ViewPoint", 
      "visual system", "wire frame"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Basic 3D plotting function. This makes a three-dimensional plot of the \
function sin(xy). Three-dimensional graphics can be rotated in place by \
dragging the mouse inside of the graphic. Dragging inside of the graphic \
causes the graphic to tumble in a direction that follows the mouse, and \
dragging around the borders of the graphic causes the graphic to spin in the \
plane of the screen. Dragging the graphic while holding down the Shift key \
causes the graphic to pan. Use the Control key (Command key on Macintosh) to \
zoom.", "synonyms" -> {}, "title" -> "Three-Dimensional Surface Plots", 
    "type" -> "Tutorial", "uri" -> "tutorial/ThreeDimensionalSurfacePlots"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.9.6"->{
  Cell[1965, 60, 109, 4, 70, "Title",
   CellTags->{"S1.9.6", "6.1"},
   CellID->1271]},
 "6.1"->{
  Cell[1965, 60, 109, 4, 70, "Title",
   CellTags->{"S1.9.6", "6.1"},
   CellID->1271]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.9.6", 301155, 5486},
 {"6.1", 301254, 5490}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1340, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1965, 60, 109, 4, 70, "Title",
 CellTags->{"S1.9.6", "6.1"},
 CellID->1271],
Cell[2077, 66, 1413, 43, 70, "DefinitionBox",
 CellID->30943],
Cell[3493, 111, 62, 1, 70, "Caption",
 CellID->9466],
Cell[3558, 114, 260, 9, 70, "MathCaption",
 CellID->21474],
Cell[CellGroupData[{
Cell[3843, 127, 305, 10, 28, "Input",
 CellID->3445],
Cell[4151, 139, 21421, 355, 165, "Output",
 Evaluatable->False,
 CellID->174886291]
}, Open  ]],
Cell[25587, 497, 588, 13, 70, "Text",
 CellID->120249745],
Cell[26178, 512, 377, 10, 70, "Text",
 CellID->17349],
Cell[26558, 524, 179, 4, 70, "Text",
 CellID->15827],
Cell[26740, 530, 7506, 234, 70, "DefinitionBox3Col",
 CellID->30954],
Cell[34249, 766, 341, 13, 70, "Caption",
 CellID->31504],
Cell[34593, 781, 463, 15, 70, "MathCaption",
 CellID->3281],
Cell[CellGroupData[{
Cell[35081, 800, 230, 8, 28, "Input",
 CellID->14246],
Cell[35314, 810, 14557, 243, 166, "Output",
 Evaluatable->False,
 CellID->218709797]
}, Open  ]],
Cell[49886, 1056, 371, 13, 70, "MathCaption",
 CellID->261104373],
Cell[CellGroupData[{
Cell[50282, 1073, 575, 18, 47, "Input",
 CellID->207531048],
Cell[50860, 1093, 14447, 241, 166, "Output",
 Evaluatable->False,
 CellID->302626911]
}, Open  ]],
Cell[65322, 1337, 321, 7, 70, "MathCaption",
 CellID->27285],
Cell[CellGroupData[{
Cell[65668, 1348, 458, 15, 28, "Input",
 CellID->16114],
Cell[66129, 1365, 26639, 441, 165, "Output",
 Evaluatable->False,
 CellID->287982764]
}, Open  ]],
Cell[92783, 1809, 128, 4, 70, "MathCaption",
 CellID->22832],
Cell[CellGroupData[{
Cell[92936, 1817, 300, 9, 28, "Input",
 CellID->23673],
Cell[93239, 1828, 22531, 373, 152, "Output",
 Evaluatable->False,
 CellID->218694158]
}, Open  ]],
Cell[115785, 2204, 1242, 37, 70, "Text",
 CellID->12312],
Cell[117030, 2243, 429, 10, 70, "MathCaption",
 CellID->3232],
Cell[CellGroupData[{
Cell[117484, 2257, 306, 10, 28, "Input",
 CellID->14883],
Cell[117793, 2269, 21421, 355, 165, "Output",
 Evaluatable->False,
 CellID->125635056]
}, Open  ]],
Cell[139229, 2627, 210, 5, 70, "MathCaption",
 CellID->7768],
Cell[CellGroupData[{
Cell[139464, 2636, 236, 8, 28, "Input",
 CellID->32589],
Cell[139703, 2646, 9875, 166, 102, "Output",
 Evaluatable->False,
 CellID->266327942]
}, Open  ]],
Cell[149593, 2815, 269, 9, 70, "MathCaption",
 CellID->173239004],
Cell[CellGroupData[{
Cell[149887, 2828, 166, 5, 28, "Input",
 CellID->294519928],
Cell[150056, 2835, 52966, 872, 203, "Output",
 Evaluatable->False,
 CellID->360091387]
}, Open  ]],
Cell[203037, 3710, 1714, 55, 70, "DefinitionBox",
 CellID->6209],
Cell[204754, 3767, 209, 8, 70, "Caption",
 CellID->21987],
Cell[204966, 3777, 257, 5, 70, "Text",
 CellID->18795],
Cell[205226, 3784, 329, 6, 70, "Text",
 CellID->13245],
Cell[205558, 3792, 118, 3, 70, "MathCaption",
 CellID->1912],
Cell[CellGroupData[{
Cell[205701, 3799, 452, 16, 28, "Input",
 CellID->28639],
Cell[206156, 3817, 20904, 347, 167, "Output",
 Evaluatable->False,
 CellID->53625811]
}, Open  ]],
Cell[227075, 4167, 178, 4, 70, "MathCaption",
 CellID->4248],
Cell[CellGroupData[{
Cell[227278, 4175, 497, 17, 70, "Input",
 CellID->1479],
Cell[227778, 4194, 33804, 565, 167, 10327, 176, "CachedBoxData", "BoxData", \
"Output",
 CellID->259026124]
}, Open  ]],
Cell[261597, 4762, 693, 17, 70, "Text",
 CellID->2043],
Cell[262293, 4781, 472, 12, 70, "Text",
 CellID->54687613],
Cell[CellGroupData[{
Cell[262790, 4797, 397, 12, 28, "Input",
 CellID->220434071],
Cell[263190, 4811, 11335, 190, 165, "Output",
 Evaluatable->False,
 CellID->99624649]
}, Open  ]],
Cell[274540, 5004, 448, 15, 70, "MathCaption",
 CellID->14702],
Cell[CellGroupData[{
Cell[275013, 5023, 386, 12, 28, "Input",
 CellID->14439],
Cell[275402, 5037, 22283, 369, 165, "Output",
 Evaluatable->False,
 CellID->213785204]
}, Open  ]],
Cell[CellGroupData[{
Cell[297722, 5411, 72, 1, 70, "RelatedTutorialsSection",
 CellID->121216876],
Cell[297797, 5414, 166, 4, 70, "RelatedTutorials",
 CellID->151800574]
}, Open  ]]
}, Open  ]],
Cell[297990, 5422, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

