(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23960,        896]
NotebookOptionsPosition[     17833,        708]
NotebookOutlinePosition[     21093,        787]
CellTagsIndexPosition[     21002,        781]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calculus" :> 
          Documentation`HelpLookup["paclet:tutorial/CalculusOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Calculus\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constant" :> Documentation`HelpLookup["paclet:ref/Constant"], 
          "Constants" :> Documentation`HelpLookup["paclet:ref/Constants"], 
          "Dt" :> Documentation`HelpLookup["paclet:ref/Dt"], "SetAttributes" :> 
          Documentation`HelpLookup["paclet:ref/SetAttributes"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Constant\"\>", 
       2->"\<\"Constants\"\>", 3->"\<\"Dt\"\>", 
       4->"\<\"SetAttributes\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Total Derivatives", "Title",
 CellTags->{"S3.5.2", "2.1"},
 CellID->25924],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Dt",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Dt"], "[", 
     StyleBox["f", "TI"], "]"}], Cell[TextData[{
     "total differential ",
     Cell[BoxData[
      StyleBox[
       RowBox[{"d", "f"}], "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Dt",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Dt"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "total derivative ",
     Cell[BoxData[
      FractionBox[
       StyleBox[
        RowBox[{"d", "f"}], "TI"], 
       StyleBox[
        RowBox[{"d", "x"}], "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Dt",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Dt"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[TextData[{
     "multiple total derivative ",
     Cell[BoxData[
      RowBox[{
       FractionBox[
        StyleBox["d", "TI"], 
        StyleBox["d", "x", "TI"]], 
       FractionBox[
        StyleBox["d", "TI"], 
        StyleBox["d", "y", "TI"]], " ", "...", " ", 
       StyleBox["f", "TI"]}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Dt",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Dt"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["x", "TI"], ",", 
     ButtonBox["Constants",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Constants"], "->", "{", 
     SubscriptBox[
      StyleBox["c", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["c", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "total derivative with ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " constant (i.e., ",
     Cell[BoxData[
      RowBox[{
       StyleBox["d", "TI"], 
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["i", "TI"]], "=", "0"}]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["y", "TI"], "/:", 
     ButtonBox["Dt",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Dt"], "[", 
     StyleBox["y", "TI"], ",", 
     StyleBox["x", "TI"], "]", "=", "0"}], Cell[TextData[{
     "set ",
     Cell[BoxData[
      RowBox[{
       FractionBox[
        StyleBox["d", "y", "TI"], 
        StyleBox["d", "x", "TI"]], "=", "0"}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SetAttributes",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SetAttributes"], "[", 
     StyleBox["c", "TI"], ",", 
     ButtonBox["Constant",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Constant"], "]"}], Cell[TextData[{
     "define ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"],
     " to be a constant in all cases"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->10652],

Cell["Total differentiation operations. ", "Caption",
 CellID->13037],

Cell[TextData[{
 "When you find the derivative of some expression ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " with respect to ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", you are effectively finding out how fast ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " changes as you vary ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ". Often ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " will depend not only on ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", but also on other variables, say ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 ". The results that you get then depend on how you assume that ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " vary as you change ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->19035],

Cell[TextData[{
 "There are two common cases. Either ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " are assumed to stay fixed when ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " changes, or they are allowed to vary with ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ". In a standard ",
 StyleBox["partial derivative",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{"\[PartialD]", "f"}], 
    RowBox[{"\[PartialD]", "x"}]], TraditionalForm]], "InlineMath"],
 ", all variables other than ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " are assumed fixed. On the other hand, in the ",
 StyleBox["total derivative",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    StyleBox[
     RowBox[{"d", "f"}], "TI"], 
    StyleBox[
     RowBox[{"d", "x"}], "TI"]], TraditionalForm]], "InlineMath"],
 ", all variables are allowed to change with ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->1699],

Cell[TextData[{
 "In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/D"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " gives a partial derivative, with all other variables assumed independent \
of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dt"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " gives a total derivative, in which all variables are assumed to depend on \
",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". In both cases, you can add an argument to give more information on \
dependencies."
}], "Text",
 CellID->13316],

Cell[TextData[{
 "This gives the ",
 StyleBox["partial derivative",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["\[PartialD]", 
     RowBox[{"\[PartialD]", "x"}]], 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}], ")"}]}], TraditionalForm]], "InlineMath"],
 ". ",
 Cell[BoxData["y"], "InlineFormula"],
 " is assumed to be independent of ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->1890],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->13367],

Cell[BoxData[
 RowBox[{"2", " ", "x"}]], "Output",
 ImageSize->{21, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->19606]
}, Open  ]],

Cell[TextData[{
 "This gives the ",
 StyleBox["total derivative",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["d", 
     StyleBox[
      RowBox[{"d", "x"}], "TI"]], 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}], ")"}]}], TraditionalForm]], "InlineMath"],
 ". Now ",
 Cell[BoxData["y"], "InlineFormula"],
 " is assumed to depend on ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->11221],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dt", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->17975],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "x"}], "+", 
  RowBox[{"2", " ", "y", " ", 
   RowBox[{"Dt", "[", 
    RowBox[{"y", ",", "x"}], "]"}]}]}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->31520]
}, Open  ]],

Cell[TextData[{
 "You can make a replacement for ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    StyleBox[
     RowBox[{"d", "y"}], "TI"], 
    StyleBox[
     RowBox[{"d", "x"}], "TI"]], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->2792],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{
   RowBox[{"Dt", "[", 
    RowBox[{"y", ",", "x"}], "]"}], "->", "yp"}]}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->24565],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "x"}], "+", 
  RowBox[{"2", " ", "y", " ", "yp"}]}]], "Output",
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->25547]
}, Open  ]],

Cell[TextData[{
 "You can also make an explicit definition for ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    StyleBox[
     RowBox[{"d", "y"}], "TI"], 
    StyleBox[
     RowBox[{"d", "x"}], "TI"]], TraditionalForm]], "InlineMath"],
 ". You need to use ",
 Cell[BoxData[
  RowBox[{"y", "/:"}]], "InlineFormula"],
 " to make sure that the definition is associated with ",
 Cell[BoxData["y"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->24258],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"y", "/:", 
  RowBox[{"Dt", "[", 
   RowBox[{"y", ",", "x"}], "]"}], "=", "0"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->27684],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->21531]
}, Open  ]],

Cell[TextData[{
 "With this definition made, ",
 Cell[BoxData[
  ButtonBox["Dt",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dt"]], "InlineFormula"],
 " treats ",
 Cell[BoxData["y"], "InlineFormula"],
 " as independent of ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->2829],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dt", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}], "+", 
    RowBox[{"z", "^", "2"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->31782],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "x"}], "+", 
  RowBox[{"2", " ", "z", " ", 
   RowBox[{"Dt", "[", 
    RowBox[{"z", ",", "x"}], "]"}]}]}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->32705]
}, Open  ]],

Cell[TextData[{
 "This removes your definition for the derivative of ",
 Cell[BoxData["y"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->26162],

Cell[BoxData[
 RowBox[{"Clear", "[", "y", "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->15689],

Cell[TextData[{
 "This takes the total derivative, with ",
 Cell[BoxData["z"], "InlineFormula"],
 " held fixed. "
}], "MathCaption",
 CellID->15923],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dt", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}], "+", 
    RowBox[{"z", "^", "2"}]}], ",", "x", ",", 
   RowBox[{"Constants", "->", 
    RowBox[{"{", "z", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->30870],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "x"}], "+", 
  RowBox[{"2", " ", "y", " ", 
   RowBox[{"Dt", "[", 
    RowBox[{"y", ",", "x", ",", 
     RowBox[{"Constants", "\[Rule]", 
      RowBox[{"{", "z", "}"}]}]}], "]"}]}]}]], "Output",
 ImageSize->{218, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->25342]
}, Open  ]],

Cell[TextData[{
 "This specifies that ",
 Cell[BoxData["c"], "InlineFormula"],
 " is a constant under differentiation. "
}], "MathCaption",
 CellID->9282],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"c", ",", "Constant"}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->14196],

Cell[TextData[{
 "The variable ",
 Cell[BoxData["c"], "InlineFormula"],
 " is taken as a constant. "
}], "MathCaption",
 CellID->12180],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dt", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "^", "2"}], "+", 
    RowBox[{"c", " ", 
     RowBox[{"x", "^", "2"}]}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->19969],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "c", " ", "x"}], "+", 
  RowBox[{"2", " ", "a", " ", 
   RowBox[{"Dt", "[", 
    RowBox[{"a", ",", "x"}], "]"}]}]}]], "Output",
 ImageSize->{117, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->19072]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["function",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData["c"], "InlineFormula"],
 " is also assumed to be a constant."
}], "MathCaption",
 CellID->18715],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dt", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "^", "2"}], "+", 
    RowBox[{
     RowBox[{"c", "[", "x", "]"}], " ", 
     RowBox[{"x", "^", "2"}]}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->16051],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "x", " ", 
   RowBox[{"c", "[", "x", "]"}]}], "+", 
  RowBox[{"2", " ", "a", " ", 
   RowBox[{"Dt", "[", 
    RowBox[{"a", ",", "x"}], "]"}]}]}]], "Output",
 ImageSize->{138, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->24736]
}, Open  ]],

Cell[TextData[{
 "This gives the total differential ",
 Cell[BoxData[
  FormBox[
   RowBox[{"d", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", "c", 
      SuperscriptBox["y", "2"]}], ")"}]}], TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->11755],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dt", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], "+", 
   RowBox[{"c", " ", 
    RowBox[{"y", "^", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->15174],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "x", " ", 
   RowBox[{"Dt", "[", "x", "]"}]}], "+", 
  RowBox[{"2", " ", "c", " ", "y", " ", 
   RowBox[{"Dt", "[", "y", "]"}]}]}]], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->18477]
}, Open  ]],

Cell["\<\
You can make replacements and assignments for total differentials. \
\>", "MathCaption",
 CellID->1154],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{
   RowBox[{"Dt", "[", "y", "]"}], "->", "dy"}]}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->24729],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "c", " ", "dy", " ", "y"}], "+", 
  RowBox[{"2", " ", "x", " ", 
   RowBox[{"Dt", "[", "x", "]"}]}]}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->10882]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->621395050],

Cell[TextData[ButtonBox["Calculus",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CalculusOverview"]], "RelatedTutorials",
 CellID->808424779]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Total Derivatives - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Calculus", "OverviewNavText"], BaseStyle -> "Link", 
        ButtonData -> "paclet:tutorial/CalculusOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/Differentiation"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DerivativesOfUnknownFunctions"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 44, 7.0466922}", "context" -> "", 
    "keywords" -> {
     "constant", "constant functions in differentiation", "constants", 
      "derivatives", "differential", "differentiation", "Dt", 
      "exact differential", "total derivatives", "total differential", 
      "variation"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Total differentiation operations. When you find the derivative of some \
expression f with respect to x, you are effectively finding out how fast f \
changes as you vary x. Often f will depend not only on x, but also on other \
variables, say y and z. The results that you get then depend on how you \
assume that y and z vary as you change x. There are two common cases. Either \
y and z are assumed to stay fixed when x changes, or they are allowed to vary \
with x. In a standard partial derivative FractionBox[RowBox[{\\[PartialD], \
f}], RowBox[{\\[PartialD], x}]], all variables other than x are assumed \
fixed. On the other hand, in the total derivative \
FractionBox[StyleBox[RowBox[{d, f}], TI], StyleBox[RowBox[{d, x}], TI]], all \
variables are allowed to change with x. ", "synonyms" -> {"3.5.2"}, "title" -> 
    "Total Derivatives", "type" -> "Tutorial", "uri" -> 
    "tutorial/TotalDerivatives"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.5.2"->{
  Cell[2058, 61, 80, 2, 70, "Title",
   CellTags->{"S3.5.2", "2.1"},
   CellID->25924]},
 "2.1"->{
  Cell[2058, 61, 80, 2, 70, "Title",
   CellTags->{"S3.5.2", "2.1"},
   CellID->25924]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.5.2", 20791, 770},
 {"2.1", 20890, 774}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1433, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2058, 61, 80, 2, 70, "Title",
 CellTags->{"S3.5.2", "2.1"},
 CellID->25924],
Cell[2141, 65, 3502, 118, 70, "DefinitionBox",
 CellID->10652],
Cell[5646, 185, 69, 1, 70, "Caption",
 CellID->13037],
Cell[5718, 188, 1097, 36, 70, "Text",
 CellID->19035],
Cell[6818, 226, 1157, 41, 70, "Text",
 CellID->1699],
Cell[7978, 269, 888, 33, 70, "Text",
 CellID->13316],
Cell[8869, 304, 512, 20, 70, "MathCaption",
 CellID->1890],
Cell[CellGroupData[{
Cell[9406, 328, 191, 7, 28, "Input",
 CellID->13367],
Cell[9600, 337, 177, 6, 36, "Output",
 CellID->19606]
}, Open  ]],
Cell[9792, 346, 510, 21, 70, "MathCaption",
 CellID->11221],
Cell[CellGroupData[{
Cell[10327, 371, 192, 7, 70, "Input",
 CellID->17975],
Cell[10522, 380, 289, 10, 36, "Output",
 CellID->31520]
}, Open  ]],
Cell[10826, 393, 261, 11, 70, "MathCaption",
 CellID->2792],
Cell[CellGroupData[{
Cell[11112, 408, 170, 6, 70, "Input",
 CellID->24565],
Cell[11285, 416, 234, 8, 36, "Output",
 CellID->25547]
}, Open  ]],
Cell[11534, 427, 452, 16, 70, "MathCaption",
 CellID->24258],
Cell[CellGroupData[{
Cell[12011, 447, 153, 5, 70, "Input",
 CellID->27684],
Cell[12167, 454, 155, 5, 36, "Output",
 CellID->21531]
}, Open  ]],
Cell[12337, 462, 307, 12, 70, "MathCaption",
 CellID->2829],
Cell[CellGroupData[{
Cell[12669, 478, 227, 8, 70, "Input",
 CellID->31782],
Cell[12899, 488, 289, 10, 36, "Output",
 CellID->32705]
}, Open  ]],
Cell[13203, 501, 150, 5, 70, "MathCaption",
 CellID->26162],
Cell[13356, 508, 98, 3, 70, "Input",
 CellID->15689],
Cell[13457, 513, 148, 5, 70, "MathCaption",
 CellID->15923],
Cell[CellGroupData[{
Cell[13630, 522, 295, 10, 70, "Input",
 CellID->30870],
Cell[13928, 534, 366, 12, 36, "Output",
 CellID->25342]
}, Open  ]],
Cell[14309, 549, 154, 5, 70, "MathCaption",
 CellID->9282],
Cell[14466, 556, 136, 4, 70, "Input",
 CellID->14196],
Cell[14605, 562, 135, 5, 70, "MathCaption",
 CellID->12180],
Cell[CellGroupData[{
Cell[14765, 571, 218, 8, 70, "Input",
 CellID->19969],
Cell[14986, 581, 299, 10, 36, "Output",
 CellID->19072]
}, Open  ]],
Cell[15300, 594, 187, 8, 70, "MathCaption",
 CellID->18715],
Cell[CellGroupData[{
Cell[15512, 606, 250, 9, 70, "Input",
 CellID->16051],
Cell[15765, 617, 329, 11, 36, "Output",
 CellID->24736]
}, Open  ]],
Cell[16109, 631, 289, 11, 70, "MathCaption",
 CellID->11755],
Cell[CellGroupData[{
Cell[16423, 646, 192, 7, 70, "Input",
 CellID->15174],
Cell[16618, 655, 315, 10, 36, "Output",
 CellID->18477]
}, Open  ]],
Cell[16948, 668, 113, 3, 70, "MathCaption",
 CellID->1154],
Cell[CellGroupData[{
Cell[17086, 675, 146, 5, 70, "Input",
 CellID->24729],
Cell[17235, 682, 286, 9, 36, "Output",
 CellID->10882]
}, Open  ]],
Cell[CellGroupData[{
Cell[17558, 696, 72, 1, 70, "RelatedTutorialsSection",
 CellID->621395050],
Cell[17633, 699, 146, 3, 70, "RelatedTutorials",
 CellID->808424779]
}, Open  ]]
}, Open  ]],
Cell[17806, 706, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

