(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    127677,       4657]
NotebookOptionsPosition[    108661,       3998]
NotebookOutlinePosition[    112373,       4083]
CellTagsIndexPosition[    112276,       4077]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluation of Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EvaluationOfExpressionsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Evaluation of Expressions\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"All" :> Documentation`HelpLookup["paclet:ref/All"], "False" :> 
          Documentation`HelpLookup["paclet:ref/False"], "HoldForm" :> 
          Documentation`HelpLookup["paclet:ref/HoldForm"], "MatchLocalNames" :> 
          Documentation`HelpLookup["paclet:ref/MatchLocalNames"], "Message" :> 
          Documentation`HelpLookup["paclet:ref/Message"], "Trace" :> 
          Documentation`HelpLookup["paclet:ref/Trace"], "TraceAbove" :> 
          Documentation`HelpLookup["paclet:ref/TraceAbove"], "TraceBackward" :> 
          Documentation`HelpLookup["paclet:ref/TraceBackward"], "TraceDepth" :> 
          Documentation`HelpLookup["paclet:ref/TraceDepth"], "TraceDialog" :> 
          Documentation`HelpLookup["paclet:ref/TraceDialog"], "TraceForward" :> 
          Documentation`HelpLookup["paclet:ref/TraceForward"], "TraceOff" :> 
          Documentation`HelpLookup["paclet:ref/TraceOff"], "TraceOn" :> 
          Documentation`HelpLookup["paclet:ref/TraceOn"], "TracePrint" :> 
          Documentation`HelpLookup["paclet:ref/TracePrint"], "TraceScan" :> 
          Documentation`HelpLookup["paclet:ref/TraceScan"], "True" :> 
          Documentation`HelpLookup["paclet:ref/True"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"All\"\>", 2->"\<\"False\"\>", 
       3->"\<\"HoldForm\"\>", 4->"\<\"MatchLocalNames\"\>", 
       5->"\<\"Message\"\>", 6->"\<\"Trace\"\>", 7->"\<\"TraceAbove\"\>", 
       8->"\<\"TraceBackward\"\>", 9->"\<\"TraceDepth\"\>", 
       10->"\<\"TraceDialog\"\>", 11->"\<\"TraceForward\"\>", 
       12->"\<\"TraceOff\"\>", 13->"\<\"TraceOn\"\>", 
       14->"\<\"TracePrint\"\>", 15->"\<\"TraceScan\"\>", 
       16->"\<\"True\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Tracing Evaluation", "Title",
 CellTags->{"S2.6.12", "12.1"},
 CellID->15851],

Cell[TextData[{
 "The standard way in which ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " works is to take any expression you give as input, evaluate the expression \
completely, and then return the result. When you are trying to understand \
what ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is doing, however, it is often worthwhile to look not just at the final \
result of evaluation, but also at intermediate steps in the evaluation \
process. "
}], "Text",
 CellID->19769],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Trace",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Trace"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "generate a list of all expressions used in the evaluation of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Trace",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Trace"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["form", "TI"], "]"}], Cell[TextData[{
     "include only expressions which match the pattern ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->11237],

Cell["Tracing the evaluation of expressions. ", "Caption",
 CellID->28301],

Cell[TextData[{
 "The expression ",
 Cell[BoxData[
  RowBox[{"1", "+", "1"}]], "InlineFormula"],
 " is evaluated immediately to ",
 Cell[BoxData["2"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->15676],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{"1", "+", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->13604],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"1", "+", "1"}],
    HoldForm], ",", 
   TagBox["2",
    HoldForm]}], "}"}]], "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->27073]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  RowBox[{"2", "^", "3"}]], "InlineFormula"],
 " is evaluated before the addition is done. "
}], "MathCaption",
 CellID->24161],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"2", "^", "3"}], "+", "4"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->21197],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     TagBox[
      SuperscriptBox["2", "3"],
      HoldForm], ",", 
     TagBox["8",
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"8", "+", "4"}],
    HoldForm], ",", 
   TagBox["12",
    HoldForm]}], "}"}]], "Output",
 ImageSize->{126, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->8595]
}, Open  ]],

Cell["\<\
The evaluation of each subexpression is shown in a separate sublist. \
\>", "MathCaption",
 CellID->2125],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"2", "^", "3"}], "+", 
   RowBox[{"4", "^", "2"}], "+", "1"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->5485],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     TagBox[
      SuperscriptBox["2", "3"],
      HoldForm], ",", 
     TagBox["8",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      SuperscriptBox["4", "2"],
      HoldForm], ",", 
     TagBox["16",
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"8", "+", "16", "+", "1"}],
    HoldForm], ",", 
   TagBox["25",
    HoldForm]}], "}"}]], "Output",
 ImageSize->{216, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->15062]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Trace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Trace"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " gives a list which includes ",
 StyleBox["all",
  FontSlant->"Italic"],
 " the intermediate expressions involved in the evaluation of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". Except in rather simple cases, however, the number of intermediate \
expressions generated in this way is typically very large, and the list \
returned by ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 " is difficult to understand. "
}], "Text",
 CellID->29229],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Trace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Trace"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["form", "TI"]}], "]"}]], "InlineFormula"],
 " allows you to \[OpenCurlyDoubleQuote]filter\[CloseCurlyDoubleQuote] the \
expressions that ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 " records, keeping only those which match the pattern ",
 Cell[BoxData[
  StyleBox["form", "TI"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->27560],

Cell["Here is a recursive definition of a factorial function. ", "MathCaption",
 CellID->7718],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"fac", "[", "n_", "]"}], ":=", 
   RowBox[{"n", " ", 
    RowBox[{"fac", "[", 
     RowBox[{"n", "-", "1"}], "]"}]}]}], ";", 
  RowBox[{
   RowBox[{"fac", "[", "1", "]"}], "=", "1"}]}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->29073],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->8079]
}, Open  ]],

Cell[TextData[{
 "This gives ",
 StyleBox["all",
  FontSlant->"Italic"],
 " the intermediate expressions generated in the evaluation of ",
 Cell[BoxData[
  RowBox[{"fac", "[", "3", "]"}]], "InlineFormula"],
 ". The result is quite complicated. "
}], "MathCaption",
 CellID->8709],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{"fac", "[", "3", "]"}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->9662],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWc1y0zAQViI7CX9tWi5lBkpaLvAicOIdMB2G5sDAlN7zuvAUxitZiedj
5V1ZdsmBzNjWSqv90+5K2nys7m+/fKvutzfV5sNd9eN2e/Nz8/77XdNlZ8bM
fhljri5M066blnvo97t5fNO3ntDbhtHaFAC/BPhUwH/dvObG06VvCeNv2/7L
yPhDyyPNv0rEvxbwrbP6Y4HKq1baM2Y29W8EqwW8d9B/GcGTrD6WPLH518L4
m8j4XGVNokIgrUXZfHF8EelHeNni2fY7b+miT82V9ALfMpHuiZL+I2Fcovev
7ZKEV+52uzr8mrbrzdFq1dVCTX3Zo7vsqQ6r3MNujjFrZhZFw5LF5vQibPQG
y87mJdDJGePMy7mYXB7Obpx8466KFHVTrIcGTpGNXzHv0z4SKAaWSbNjvFYq
XmWUpp6jj0HJBqhVyFrYfwIw+jOO96xvDxULMOYV5IJSjsM15EzEQ9tJpyOE
w86HUiMdSethWkrSSVI8Y22/3ylEj8BxPN0UQI+1QiRyDlgz1y/lOElWaWW5
8WKCNeDmD+Ej7Q2avaMP/1jspfPpeE6X6J0DbAV6LmaUmVry2ZD9MW5wLTCb
sXeygTsvRhvyQllY/JF4S2sl+bREL9W3pjzRpOrqZcFTPEaX5Dk0vq8i/EUN
ff1p7WN62F1AysjsXRjww63MthYuGEsjH6TD3cmH0EX5U70zd4fS2iPX89Be
eEqQ1g0zKvLD2gq7fiPdaXTZGiV8ruKFVHheqJ2Odu7urqOamg9R9lxP4y2G
s3RryJ8l+bkYeXx+k2qKoUoUcuq6PsQlxguB5y1e0cHrzltF8Lo5m77SKnBy
cZVjTq4un9i80/pQjezTe93Bsx083JN8RZmaWNtPb6EMF3VeNZ9elaOMUr8A
OLeCTcBnllO4v0vVSRvpj1X4Fol0Y9VnhOn1idWEhf9X8FrQ+xnuptx/AemV
gtQz0jRcg6dJd0J6fa01HqS9debqP5SPdGbUa5p7F4ll8n10jMxLsmhc826+
6zvnHsu5P64Jwsd/rjzowmWAMU8xRHTrOFFLs7eb2R9mpGgC\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{488, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->13823333]
}, Open  ]],

Cell[TextData[{
 "This shows only intermediate expressions of the form ",
 Cell[BoxData[
  RowBox[{"fac", "[", "n_", "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->11574],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"fac", "[", "3", "]"}], ",", 
   RowBox[{"fac", "[", "n_", "]"}]}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->7682],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"fac", "[", "3", "]"}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"fac", "[", "2", "]"}],
      HoldForm], ",", 
     RowBox[{"{", 
      TagBox[
       RowBox[{"fac", "[", "1", "]"}],
       HoldForm], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->7475]
}, Open  ]],

Cell[TextData[{
 "You can specify any pattern in ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->28815],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"fac", "[", "10", "]"}], ",", 
   RowBox[{"fac", "[", 
    RowBox[{"n_", "/;", 
     RowBox[{"n", ">", "5"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->29343],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWN2ugjAMLhSMP8kx0Ru982n0Rh6CGBO9ODlGfX9ckampw42MTsmRBFi7
dv3adWUsy8+77W9+3m/yxeqYH3b7zWmx/DsqFkYA0RoAxjNQ7UK1ypuuTN0A
CT1R8wqYqUesyEn1Tln/sEZ+1BF57m9TGsuoIePOGT0xaBEajpbrjTqq5xtV
TsfGKBM3hSuf3kSjYY4f5Uz93Frfww6RPaHxpfE3nRVpP2SyxkinN7rUuWJ/
5jpZdNKiVTUQRGaKeWgMnxMNF/pzotH+GogtUi/8epCy1TU3D39EsHCay8tY
fafHthX+To/bruxRacdWyUkrEcvbcUvWsZKTGj+sN7YsDOvVf9lB2KIq/52S
RFC3P5S06ZvHvhFPDP6G/4vCCp2pPrWTJ67Wujy6bS/ihbrBdy1M9Zu6jOJd
T7iV76i8P0z1qKvV+nxQ/0mlxT2X9fmhTU9SXp9JoKO8xo+F5LkhNTOHFkQX
zNuzLw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{332, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->258344760]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Trace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Trace"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["form", "TI"]}], "]"}]], "InlineFormula"],
 " effectively works by intercepting every expression that is about to be \
evaluated during the evaluation of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ", and picking out those that match the pattern ",
 Cell[BoxData[
  StyleBox["form", "TI"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->27532],

Cell[TextData[{
 "If you want to trace \[OpenCurlyDoubleQuote]calls\[CloseCurlyDoubleQuote] \
to a function like ",
 Cell[BoxData["fac"], "InlineFormula"],
 ", you can do so simply by telling ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 " to pick out expressions of the form ",
 Cell[BoxData[
  RowBox[{"fac", "[", "n_", "]"}]], "InlineFormula"],
 ". You can also use patterns like ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   RowBox[{"n_", ",", "2"}], "]"}]], "InlineFormula"],
 " to pick out calls with particular argument structure. "
}], "Text",
 CellID->14568],

Cell[TextData[{
 "A typical ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " program, however, consists not only of \[OpenCurlyDoubleQuote]function \
calls\[CloseCurlyDoubleQuote] like ",
 Cell[BoxData[
  RowBox[{"fac", "[", "n", "]"}]], "InlineFormula"],
 ", but also of other elements, such as assignments to variables, control \
structures, and so on. All of these elements are represented as expressions. \
As a result, you can use patterns in ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 " to pick out any kind of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " program element. Thus, for example, you can use a pattern like ",
 Cell[BoxData[
  RowBox[{"k", "=", "_"}]], "InlineFormula"],
 " to pick out all assignments to the symbol ",
 Cell[BoxData["k"], "InlineFormula"],
 ". "
}], "Text",
 CellID->32684],

Cell[TextData[{
 "This shows the sequence of assignments made for ",
 Cell[BoxData["k"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->4361],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"k", "=", "2"}], ";", 
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"i", "=", "1"}], ",", 
       RowBox[{"i", "<", "4"}], ",", 
       RowBox[{"i", "++"}], ",", 
       RowBox[{"k", "=", 
        RowBox[{"i", "/", "k"}]}]}], "]"}], ";", "k"}], ")"}], ",", 
   RowBox[{"k", "=", "_"}]}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->5472],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    TagBox[
     RowBox[{"k", "=", "2"}],
     HoldForm], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      TagBox[
       RowBox[{"k", "=", 
        FractionBox["1", "2"]}],
       HoldForm], "}"}], ",", 
     RowBox[{"{", 
      TagBox[
       RowBox[{"k", "=", "4"}],
       HoldForm], "}"}], ",", 
     RowBox[{"{", 
      TagBox[
       RowBox[{"k", "=", 
        FractionBox["3", "4"]}],
       HoldForm], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{242, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->25286]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Trace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Trace"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["form", "TI"]}], "]"}]], "InlineFormula"],
 " can pick out expressions that occur at any time in the evaluation of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". The expressions need not, for example, appear directly in the form of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " that you give. They may instead occur, say, during the evaluation of \
functions that are called as part of the evaluation of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->8266],

Cell["Here is a function definition. ", "MathCaption",
 CellID->6089],

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "[", "n_", "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"k", "=", 
     RowBox[{"n", "/", "2"}]}], ";", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"k", "=", 
       RowBox[{"i", "/", "k"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "n"}], "}"}]}], "]"}], ";", "k"}], ")"}]}]], "Input",\

 CellLabel->"In[9]:= ",
 CellID->32151],

Cell[TextData[{
 "You can look for expressions generated during the evaluation of ",
 Cell[BoxData["h"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->4604],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"h", "[", "3", "]"}], ",", 
   RowBox[{"k", "=", "_"}]}], "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->17233],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    TagBox[
     RowBox[{"k", "=", 
      FractionBox["3", "2"]}],
     HoldForm], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      TagBox[
       RowBox[{"k", "=", 
        FractionBox["2", "3"]}],
       HoldForm], "}"}], ",", 
     RowBox[{"{", 
      TagBox[
       RowBox[{"k", "=", "3"}],
       HoldForm], "}"}], ",", 
     RowBox[{"{", 
      TagBox[
       RowBox[{"k", "=", "1"}],
       HoldForm], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{242, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->25594]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 " allows you to monitor intermediate steps in the evaluation not only of \
functions that you define, but also of some functions that are built into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". You should realize, however, that the specific sequence of intermediate \
steps followed by built\[Hyphen]in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions depends in detail on their implementation and optimization in a \
particular version of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->9076],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Trace",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Trace"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["f", "TI"], "[", "___", "]", "]"}], Cell[TextData[{
     "show all calls to the function ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Trace",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Trace"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["i", "TI"], "=", "_", "]"}], Cell[TextData[{
     "show assignments to ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Trace",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Trace"], "[", 
     StyleBox["expr", "TI"], ",", "_", "=", "_", "]"}], Cell[
    "show all assignments", "TableText"]},
   {
    RowBox[{
     ButtonBox["Trace",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Trace"], "[", 
     StyleBox["expr", "TI"], ",", 
     ButtonBox["Message",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Message"], "[", "___", "]", "]"}], Cell[
    "show messages generated", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->598],

Cell[TextData[{
 "Some ways to use ",
 StyleBox["Trace", "MR"],
 ". "
}], "Caption",
 CellID->18604],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 " returns a list that represents the \[OpenCurlyDoubleQuote]history\
\[CloseCurlyDoubleQuote] of a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " computation. The expressions in the list are given in the order that they \
were generated during the computation. In most cases, the list returned by ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 " has a nested structure, which represents the \
\[OpenCurlyDoubleQuote]structure\[CloseCurlyDoubleQuote] of the computation. \
"
}], "Text",
 CellID->23533],

Cell[TextData[{
 "The basic idea is that each sublist in the list returned by ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 " represents the \[OpenCurlyDoubleQuote]evaluation chain\
\[CloseCurlyDoubleQuote] for a particular ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression. The elements of this chain correspond to different forms of \
the same expression. Usually, however, the evaluation of one expression \
requires the evaluation of a number of other expressions, often \
subexpressions. Each subsidiary evaluation is represented by a sublist in the \
structure returned by ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->468],

Cell["Here is a sequence of assignments. ", "MathCaption",
 CellID->31184],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "1", "]"}], "=", 
   RowBox[{"a", "[", "2", "]"}]}], ";", 
  RowBox[{
   RowBox[{"a", "[", "2", "]"}], "=", 
   RowBox[{"a", "[", "3", "]"}]}], ";", 
  RowBox[{
   RowBox[{"a", "[", "3", "]"}], "=", 
   RowBox[{"a", "[", "4", "]"}]}]}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->31417],

Cell[BoxData[
 RowBox[{"a", "[", "4", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->2964]
}, Open  ]],

Cell[TextData[{
 "This yields an evaluation chain reflecting the sequence of transformations \
for ",
 Cell[BoxData[
  RowBox[{"a", "[", 
   StyleBox["i", "TI"], "]"}]], "InlineFormula"],
 " used. "
}], "MathCaption",
 CellID->29616],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{"a", "[", "1", "]"}], "]"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->11014],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"a", "[", "1", "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"a", "[", "2", "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"a", "[", "3", "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"a", "[", "4", "]"}],
    HoldForm]}], "}"}]], "Output",
 ImageSize->{164, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->14066]
}, Open  ]],

Cell[TextData[{
 "The successive forms generated in the simplification of ",
 Cell[BoxData[
  RowBox[{"y", "+", "x", "+", "y"}]], "InlineFormula"],
 " show up as successive elements in its evaluation chain. "
}], "MathCaption",
 CellID->14996],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{"y", "+", "x", "+", "y"}], "]"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->16873],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"y", "+", "x", "+", "y"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"x", "+", "y", "+", "y"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"x", "+", 
     RowBox[{"2", " ", "y"}]}],
    HoldForm]}], "}"}]], "Output",
 ImageSize->{170, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->7148]
}, Open  ]],

Cell[TextData[{
 "Each argument of the function ",
 Cell[BoxData["f"], "InlineFormula"],
 " has a separate evaluation chain, given in a sublist. "
}], "MathCaption",
 CellID->2510],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"1", "+", "1"}], ",", 
    RowBox[{"2", "+", "3"}], ",", 
    RowBox[{"4", "+", "5"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->10396],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"1", "+", "1"}],
      HoldForm], ",", 
     TagBox["2",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"2", "+", "3"}],
      HoldForm], ",", 
     TagBox["5",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"4", "+", "5"}],
      HoldForm], ",", 
     TagBox["9",
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"f", "[", 
     RowBox[{"2", ",", "5", ",", "9"}], "]"}],
    HoldForm]}], "}"}]], "Output",
 ImageSize->{293, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]= ",
 CellID->15941]
}, Open  ]],

Cell["\<\
The evaluation chain for each subexpression is given in a separate sublist. \
\>", "MathCaption",
 CellID->25791],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"x", " ", "x"}], "+", 
   RowBox[{"y", " ", "y"}]}], "]"}]], "Input",
 CellLabel->"In[15]:= ",
 CellID->16866],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"x", " ", "x"}],
      HoldForm], ",", 
     TagBox[
      SuperscriptBox["x", "2"],
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"y", " ", "y"}],
      HoldForm], ",", 
     TagBox[
      SuperscriptBox["y", "2"],
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}],
    HoldForm]}], "}"}]], "Output",
 ImageSize->{188, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]= ",
 CellID->25589]
}, Open  ]],

Cell["\<\
Tracing the evaluation of a nested expression yields a nested list. \
\>", "MathCaption",
 CellID->4020],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{"f", "[", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", 
     RowBox[{"1", "+", "1"}], "]"}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[16]:= ",
 CellID->23355],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWFFPwyAQpiBTM+faPRmnyX6NPvkjmsVkezCabf9/coSa5hN2pUB1SYE7
ju+Ou6Nc99aedu8f7Wm/bTevh/Zrt98eNy+fB8NSlRDVoxBi+SDM+GxG9qHf
2jxCXFGrOt45mn4CesnIN6aRhpy7XjPytZO786wbs/4Sjg9PWS+pRC89O/TG
g078FfDnDJ4K4OE6DicXbqwepGUWLxOKNuQM+NrxUX4W4CN9HZCTA9cP1RvC
G6unlN5c9uSJum+XGD2Upxy3fP3Dt7b490TSt8DH94QcjOZDv2HQ0Uf5tJew
Zjprf2eTTETx3Se6y5Ye/x5ozDqcj/UR0ovCMeH8UFp/rH2cvRU1k79buOoH
52N3iXRqlqX6I1V/afv+x41TM7vmsoLzWu6oxOqbOitS7ZsmKzDqWFPjTUVe
C1Wpl9ah/CKAE6raYvFT9ZWy42+iau9FtpbhTvi4iij1nOWpw0qf9pLVYg6U
7nuZesoO5bGu6fGl6/s07rn2zHPrx+DE4Ib/HaHhesBIVN+IyhOe\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{282, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]= ",
 CellID->194705074]
}, Open  ]],

Cell[TextData[{
 "There are two basic ways that subsidiary evaluations can be required during \
the evaluation of a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression. The first way is that the expression may contain \
subexpressions, each of which has to be evaluated. The second way is that \
there may be rules for the evaluation of the expression that involve other \
expressions which themselves must be evaluated. Both kinds of subsidiary \
evaluations are represented by sublists in the structure returned by ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->28251],

Cell[TextData[{
 "The subsidiary evaluations here come from evaluation of the arguments of ",
 Cell[BoxData["f"], "InlineFormula"],
 " and ",
 Cell[BoxData["g"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->5081],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"g", "[", 
     RowBox[{"1", "+", "1"}], "]"}], ",", 
    RowBox[{"2", "+", "3"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[17]:= ",
 CellID->32271],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"1", "+", "1"}],
        HoldForm], ",", 
       TagBox["2",
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{"g", "[", "2", "]"}],
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"2", "+", "3"}],
      HoldForm], ",", 
     TagBox["5",
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"f", "[", 
     RowBox[{
      RowBox[{"g", "[", "2", "]"}], ",", "5"}], "]"}],
    HoldForm]}], "}"}]], "Output",
 ImageSize->{279, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]= ",
 CellID->31825]
}, Open  ]],

Cell["Here is a function with a condition attached. ", "MathCaption",
 CellID->9228],

Cell[BoxData[
 RowBox[{
  RowBox[{"fe", "[", "n_", "]"}], ":=", 
  RowBox[{
   RowBox[{"n", "+", "1"}], "/;", 
   RowBox[{"EvenQ", "[", "n", "]"}]}]}]], "Input",
 CellLabel->"In[18]:= ",
 CellID->31173],

Cell[TextData[{
 "The evaluation of ",
 Cell[BoxData[
  RowBox[{"fe", "[", "6", "]"}]], "InlineFormula"],
 " involves a subsidiary evaluation associated with the condition. "
}], "MathCaption",
 CellID->13454],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{"fe", "[", "6", "]"}], "]"}]], "Input",
 CellLabel->"In[19]:= ",
 CellID->10309],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"fe", "[", "6", "]"}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"EvenQ", "[", "6", "]"}],
        HoldForm], ",", 
       TagBox["True",
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{"RuleCondition", "[", 
       RowBox[{
        RowBox[{"$ConditionHold", "[", 
         RowBox[{"$ConditionHold", "[", 
          RowBox[{"6", "+", "1"}], "]"}], "]"}], ",", "True"}], "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"$ConditionHold", "[", 
       RowBox[{"$ConditionHold", "[", 
        RowBox[{"6", "+", "1"}], "]"}], "]"}],
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"6", "+", "1"}],
    HoldForm], ",", 
   TagBox["7",
    HoldForm]}], "}"}]], "Output",
 ImageSize->{587, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]= ",
 CellID->6430]
}, Open  ]],

Cell["\<\
You often get nested lists when you trace the evaluation of functions that \
are defined \[OpenCurlyDoubleQuote]recursively\[CloseCurlyDoubleQuote] in \
terms of other instances of themselves. The reason is typically that each new \
instance of the function appears as a subexpression in the expressions \
obtained by evaluating previous instances of the function. \
\>", "Text",
 CellID->31238],

Cell[TextData[{
 "Thus, for example, with the definition ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"fac", "[", "n_", "]"}], ":=", 
   RowBox[{"n", " ", 
    RowBox[{"fac", "[", 
     RowBox[{"n", "-", "1"}], "]"}]}]}]], "InlineFormula"],
 ", the evaluation of ",
 Cell[BoxData[
  RowBox[{"fac", "[", "6", "]"}]], "InlineFormula"],
 " yields the expression ",
 Cell[BoxData[
  RowBox[{"6", " ", 
   RowBox[{"fac", "[", "5", "]"}]}]], "InlineFormula"],
 ", which contains ",
 Cell[BoxData[
  RowBox[{"fac", "[", "5", "]"}]], "InlineFormula"],
 " as a subexpression. "
}], "Text",
 CellID->13991],

Cell[TextData[{
 "The successive instances of ",
 Cell[BoxData["fac"], "InlineFormula"],
 " generated appear in successively nested sublists. "
}], "MathCaption",
 CellID->13739],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"fac", "[", "6", "]"}], ",", 
   RowBox[{"fac", "[", "_", "]"}]}], "]"}]], "Input",
 CellLabel->"In[20]:= ",
 CellID->24853],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWM1ugzAMNgRQt0qttF26W59mO+0hUFWpPUybuj7E+tQ0hmSt3FAnIwkM
kIB8juO/2EngvTzuth/lcb8p12+H8mu333yvXz8PkiQSgOQHAJYrkO1Ktuob
r5O8ATJ8Ck2rYCUfqYRz9c5J/+PE+Gl8umJRR10Q6gvBc8MotI5aP/VxvmeH
4tQ4W0jNoaHjG7Ew5I5ooVMts4HKzxWd+v9f7Nd83CyHlh8nK404/8X1mMaX
W6pRA8uFGKv2YRKWFCbLJhuN4VjSN26q0ZQNlh5yOcZGYBFEN5fvYbRifwG3
q9uYfKS+0X0ljFYuj0OffJPaTm7XwlGZt8pYetLG5YkvPeP0isuMWHrGcS7D
SNBa5SLYRWfbKT20Tsgu2L0Gup4oTP8CQuo0fRvF9Hd4dXP9FSaU1VlLTdxb
FWjkbOVyu/Rf5V5jm9XdVq7rat633L6x3Wr9zPS7rhGh5blmFyfPz4kkjtRh
ZFTb/vlUXXYVoeojVfR7/Lp+bPkL9XaRr+s0FL/2O94fdmyeLFqQnAHO1YM/
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{392, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]= ",
 CellID->288643470]
}, Open  ]],

Cell[TextData[{
 "With this definition, ",
 Cell[BoxData[
  RowBox[{"fp", "[", 
   RowBox[{
    StyleBox["n", "TI"], "-", "1"}], "]"}]], "InlineFormula"],
 " is obtained directly as the value of ",
 Cell[BoxData[
  RowBox[{"fp", "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->12567],

Cell[BoxData[
 RowBox[{
  RowBox[{"fp", "[", "n_", "]"}], ":=", 
  RowBox[{
   RowBox[{"fp", "[", 
    RowBox[{"n", "-", "1"}], "]"}], "/;", 
   RowBox[{"n", ">", "1"}]}]}]], "Input",
 CellLabel->"In[21]:= ",
 CellID->17054],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"fp", "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " never appears in a subexpression, so no sublists are generated. "
}], "MathCaption",
 CellID->29877],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"fp", "[", "6", "]"}], ",", 
   RowBox[{"fp", "[", "_", "]"}]}], "]"}]], "Input",
 CellLabel->"In[22]:= ",
 CellID->22490],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"fp", "[", "6", "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"fp", "[", 
     RowBox[{"6", "-", "1"}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"fp", "[", "5", "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"fp", "[", 
     RowBox[{"5", "-", "1"}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"fp", "[", "4", "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"fp", "[", 
     RowBox[{"4", "-", "1"}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"fp", "[", "3", "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"fp", "[", 
     RowBox[{"3", "-", "1"}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"fp", "[", "2", "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"fp", "[", 
     RowBox[{"2", "-", "1"}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"fp", "[", "1", "]"}],
    HoldForm]}], "}"}]], "Output",
 ImageSize->{343, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]= ",
 CellID->31197]
}, Open  ]],

Cell["Here is the recursive definition of the Fibonacci numbers. ", \
"MathCaption",
 CellID->19056],

Cell[BoxData[
 RowBox[{
  RowBox[{"fib", "[", "n_", "]"}], ":=", 
  RowBox[{
   RowBox[{"fib", "[", 
    RowBox[{"n", "-", "1"}], "]"}], "+", 
   RowBox[{"fib", "[", 
    RowBox[{"n", "-", "2"}], "]"}]}]}]], "Input",
 CellLabel->"In[23]:= ",
 CellID->10773],

Cell["Here are the end conditions for the recursion. ", "MathCaption",
 CellID->30589],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"fib", "[", "0", "]"}], "=", 
  RowBox[{
   RowBox[{"fib", "[", "1", "]"}], "=", "1"}]}]], "Input",
 CellLabel->"In[24]:= ",
 CellID->26862],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]= ",
 CellID->27536]
}, Open  ]],

Cell[TextData[{
 "This shows all the steps in the recursive evaluation of ",
 Cell[BoxData[
  RowBox[{"fib", "[", "5", "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->29429],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"fib", "[", "5", "]"}], ",", 
   RowBox[{"fib", "[", "_", "]"}]}], "]"}]], "Input",
 CellLabel->"In[25]:= ",
 CellID->12888],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWttOwzAMzdZtGiCuT/AGz4jfgCc+YkJIGxIXAf9fml7GZDyci+260yqt
nds0PrETJ43P4+J7+fy6+F49La4fPhcfy9XT1/X9+2d1qxg5N751zt1cuup/
Wf2rf91xV/1+xUa68OdiXcpdVqdxJR611yl4fhhZfsL8PiXH1i9dHuI7Ym4/
tz0Lf3Ln4O4V0Yqi1QbRUO9h2jnqCWllih7t97bhhuVy7aNl93GJ9S5/d1qJ
3bXthPVRIH24K0dpmyvp4dbrH2P3Y3H0hUvL7n3598CIf/tqf9ioLoCMaXfT
tdxCResmS3nZxy/oGR4MKbIcmt3GvNsYUr0C52VrPcmWxehYdUaUSsNKtfhE
RCslw1qPRVCElYqd8WSwzrC3xP00jN4hg4Knd8j0hlgLUeVHtR6Z1RAln/ai
VQfFkLBSEaYfP9noHXDutdQ7bFhI7nvLr9NgX4Qy9rWaa6MQvRq+CsFhJ86E
Wg3b55XSN5TekRJl9HqHFSulRZrNfaaia/2kee7qA+KPnQ/jNeR6IF6jTpyw
aGt73oSjvS9v6recZ60A95dQD5PWoaIapYU7ivK0yiaqYWjhnrV1PKrd6rAx
DJkaXRZpM6Y0h18pzNvrZKOUl9Nr6VaZ2GoTiy/x2GJjIY9Wy3blwUbZNd2O
/2GnvNckJ7uaMW4SjwT19s0I0mYccTOEuBlMq9pLMMZaY+JYYf5wM3SkGUUv
JeZdq8yTaasH4uXWs2fS6NqRknMZPVxMmmWJjZbd4T9QOwey2i1YwAKGFNmC
RUIwyjBluCzYrHWoXdshsRp8qZn7G7NktO2ZG9trtczrsWEh+Pytrldmtu2H
AcCzqzekFufu5e0ZMTJ8jFz5vUwdmyF50m3fDVJ52bqe3500pjG55wfojkg9
foAUe0FmVMZnOan28OZRMQ8MIQtuL89uhTWRn+/XmZ+oTGHsOMjJRIaMAptZ
ZJu5ahvsg9yMOc84wL6Y4ThsDphB9A+7XEFatnPWXvNqmZTDyQrrZNtlsEMt
H/60rio2t+tGP4dF1po=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{555, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]= ",
 CellID->287827068]
}, Open  ]],

Cell[TextData[{
 "Each step in the evaluation of any ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression can be thought of as the result of applying a particular \
transformation rule. As discussed in \"",
 ButtonBox["Associating Definitions with Different Symbols",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/AssociatingDefinitionsWithDifferentSymbols"],
 "\", all the rules that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " knows are associated with specific symbols or \[OpenCurlyDoubleQuote]tags\
\[CloseCurlyDoubleQuote]. You can use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Trace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Trace"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["f", "TI"]}], "]"}]], "InlineFormula"],
 " to see all the steps in the evaluation of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " that are performed using transformation rules associated with the symbol \
",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ". In this case, ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 " gives not only the expressions to which each rule is applied, but also the \
results of applying the rules. "
}], "Text",
 CellID->17585],

Cell[TextData[{
 "In general, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Trace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Trace"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["form", "TI"]}], "]"}]], "InlineFormula"],
 " picks out all the steps in the evaluation of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " where ",
 Cell[BoxData[
  StyleBox["form", "TI"]], "InlineFormula"],
 " matches ",
 StyleBox["either",
  FontSlant->"Italic"],
 " the expression about to be evaluated, ",
 StyleBox["or",
  FontSlant->"Italic"],
 " the tag associated with the rule used. "
}], "Text",
 CellID->21841],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Trace",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Trace"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["f", "TI"], "]"}], Cell[TextData[{
     "show all evaluations which use transformation rules associated with the \
symbol ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Trace",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Trace"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["f", "TI"], "|", 
     StyleBox["g", "TI"], "]"}], Cell[TextData[{
     "show all evaluations associated with either ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->4167],

Cell["Tracing evaluations associated with particular tags. ", "Caption",
 CellID->5520],

Cell[TextData[{
 "This shows only intermediate expressions that match ",
 Cell[BoxData[
  RowBox[{"fac", "[", "_", "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->11560],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"fac", "[", "3", "]"}], ",", 
   RowBox[{"fac", "[", "_", "]"}]}], "]"}]], "Input",
 CellLabel->"In[26]:= ",
 CellID->21047],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"fac", "[", "3", "]"}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"fac", "[", "2", "]"}],
      HoldForm], ",", 
     RowBox[{"{", 
      TagBox[
       RowBox[{"fac", "[", "1", "]"}],
       HoldForm], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]= ",
 CellID->14581]
}, Open  ]],

Cell[TextData[{
 "This shows all evaluations that use transformation rules associated with \
the symbol ",
 Cell[BoxData["fac"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->30382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"fac", "[", "3", "]"}], ",", "fac"}], "]"}]], "Input",
 CellLabel->"In[27]:= ",
 CellID->19606],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"fac", "[", "3", "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"3", " ", 
     RowBox[{"fac", "[", 
      RowBox[{"3", "-", "1"}], "]"}]}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"fac", "[", "2", "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"2", " ", 
       RowBox[{"fac", "[", 
        RowBox[{"2", "-", "1"}], "]"}]}],
      HoldForm], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"fac", "[", "1", "]"}],
        HoldForm], ",", 
       TagBox["1",
        HoldForm]}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{379, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]= ",
 CellID->11989]
}, Open  ]],

Cell[TextData[{
 "Here is a rule for the ",
 Cell[BoxData["log"], "InlineFormula"],
 " function. "
}], "MathCaption",
 CellID->26784],

Cell[BoxData[
 RowBox[{
  RowBox[{"log", "[", 
   RowBox[{"x_", " ", "y_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"log", "[", "x", "]"}], "+", 
   RowBox[{"log", "[", "y", "]"}]}]}]], "Input",
 CellLabel->"In[28]:= ",
 CellID->13403],

Cell[TextData[{
 "This traces the evaluation of ",
 Cell[BoxData[
  RowBox[{"log", "[", 
   RowBox[{"a", "b", "c", "d"}], "]"}]], "InlineFormula"],
 ", showing all transformations associated with ",
 Cell[BoxData["log"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->21960],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"log", "[", 
    RowBox[{"a", " ", "b", " ", "c", " ", "d"}], "]"}], ",", "log"}], 
  "]"}]], "Input",
 CellLabel->"In[29]:= ",
 CellID->21462],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"log", "[", 
     RowBox[{"a", " ", "b", " ", "c", " ", "d"}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{
     RowBox[{"log", "[", "a", "]"}], "+", 
     RowBox[{"log", "[", 
      RowBox[{"b", " ", "c", " ", "d"}], "]"}]}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"log", "[", 
       RowBox[{"b", " ", "c", " ", "d"}], "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{
       RowBox[{"log", "[", "b", "]"}], "+", 
       RowBox[{"log", "[", 
        RowBox[{"c", " ", "d"}], "]"}]}],
      HoldForm], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"log", "[", 
         RowBox[{"c", " ", "d"}], "]"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{
         RowBox[{"log", "[", "c", "]"}], "+", 
         RowBox[{"log", "[", "d", "]"}]}],
        HoldForm]}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{397, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[29]= ",
 CellID->8732]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Trace",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Trace"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["form", "TI"], ",", 
     ButtonBox["TraceOn",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TraceOn"], "->", 
     StyleBox["oform", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "switch on tracing only within forms matching ",
     Cell[BoxData[
      StyleBox["oform", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Trace",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Trace"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["form", "TI"], ",", 
     ButtonBox["TraceOff",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TraceOff"], "->", 
     StyleBox["oform", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "switch off tracing within any form matching ",
     Cell[BoxData[
      StyleBox["oform", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->20392],

Cell["Switching off tracing inside certain forms. ", "Caption",
 CellID->26843],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Trace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Trace"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["form", "TI"]}], "]"}]], "InlineFormula"],
 " allows you to trace expressions matching ",
 Cell[BoxData[
  StyleBox["form", "TI"]], "InlineFormula"],
 " generated at any point in the evaluation of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". Sometimes, you may want to trace only expressions generated during \
certain parts of the evaluation of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->14063],

Cell[TextData[{
 "By setting the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TraceOn",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraceOn"], "->", 
   StyleBox["oform", "TI"]}]], "InlineFormula"],
 ", you can specify that tracing should be done only during the evaluation of \
forms which match ",
 Cell[BoxData[
  StyleBox["oform", "TI"]], "InlineFormula"],
 ". Similarly, by setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TraceOff",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraceOff"], "->", 
   StyleBox["oform", "TI"]}]], "InlineFormula"],
 ", you can specify that tracing should be switched off during the evaluation \
of forms which match ",
 Cell[BoxData[
  StyleBox["oform", "TI"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->16923],

Cell["This shows all steps in the evaluation. ", "MathCaption",
 CellID->14611],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{"log", "[", 
   RowBox[{
    RowBox[{"fac", "[", "2", "]"}], " ", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[30]:= ",
 CellID->24740],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWdtOGzEQdbzZQItIUgqIVi1NeWr/ouIBnvoREUKCh4qK8p5PTz27dlid
jD2+7CaslMvYczkznpn1en8vXx7u/yxfHu+Wi9vn5d+Hx7t/i5unZzNUjZTS
v5RSswtl/q/Nv+bjrmvzUWpM39VmXKQvzJc25JH9rWH+hx2/9MwfCfq/AD0T
+L8JeCT574n8n4X5c/NVWRyE58yDC/kc/oVnHOV1s3pV4up9ElajstZ+wvil
h09aza+W74NHfhGJxyd/JcxjNrlxXEUN9FmmHOLH7JL4MX6jdc4qk5VatXL0
S7TLKY5P0jexfHWi3mmk/neR/vj0TSLtHAwUlyS+erVard1l/jejfXhF49p6
pRNQVTYKND9m5PQO9aNfXboO6Rtv+BJR5lUY8jd03cWgLIbtUc5/mctF/4Dl
ngyOZx4RIcL3XuCL107apM7g4yvxP4ZOwcavWNtz2l5AXQCzPSzts3Xot/Va
IUzH8/nER6wkj94SFqnjIF2MQPR7uzPhjiE1WwOVAL061N8Q61SIVD9W3R0E
+dBHac+OtLuTIGrUI3md56WETkJxzMZ+s6vYsoeopXnSp5noIF9JNeBKO5uI
DWPRp02Mqy8rSm1yfpEt83je1Hg/OxC3G+o7+zj5HDvS/iFmfxHil3oANz9E
vOKq2X/fl/Sh34R36Mrhdva7trnLe7Wvat/eswP2MNSN2cLy92Q7NXNT9aVW
2pDPAKm+tljwyR/zi5Xq0HjKBU++Sj79DFRFlytitfdpm9s9ZPYCwXLurr3k
xK5S/rMSzBj0gTsHzdGLe73UWpb0SfXjTvok3KV1ivHCvTXOY7xPmPnQ6RPX
o5x/xN8mTntxT0P7tCXlWVD3ns/nPnL+iHeBY5YLYxOnu3T/G6c19R6J2Evr
iY8YSvFcXA/Y5pI6CVeRQ2mRuglqiXvbk3PCQyRZcxXVrcW5pQ89fPP16xtG
+pVyQoNcVx6jgfa6dnxyMys3A/xcxVSetSS5U/BzCnZx3uE7gfnwG1iXD9eJ
lBr9B/tn5gQ=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{576, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[30]= ",
 CellID->229099618]
}, Open  ]],

Cell[TextData[{
 "This shows only those steps that occur during the evaluation of ",
 Cell[BoxData["fac"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->22443],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"log", "[", 
    RowBox[{
     RowBox[{"fac", "[", "2", "]"}], " ", "x"}], "]"}], ",", 
   RowBox[{"TraceOn", "->", "fac"}]}], "]"}]], "Input",
 CellLabel->"In[31]:= ",
 CellID->22270],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"fac", "[", "2", "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"2", " ", 
       RowBox[{"fac", "[", 
        RowBox[{"2", "-", "1"}], "]"}]}],
      HoldForm], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{"2", "-", "1"}],
          HoldForm], ",", 
         TagBox["1",
          HoldForm]}], "}"}], ",", 
       TagBox[
        RowBox[{"fac", "[", "1", "]"}],
        HoldForm], ",", 
       TagBox["1",
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{"2", " ", "1"}],
      HoldForm], ",", 
     TagBox["2",
      HoldForm]}], "}"}], "}"}], "}"}]], "Output",
 ImageSize->{381, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[31]= ",
 CellID->3919]
}, Open  ]],

Cell[TextData[{
 "This shows only those steps that do not occur during the evaluation of ",
 Cell[BoxData["fac"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->28849],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"log", "[", 
    RowBox[{
     RowBox[{"fac", "[", "2", "]"}], " ", "x"}], "]"}], ",", 
   RowBox[{"TraceOff", "->", "fac"}]}], "]"}]], "Input",
 CellLabel->"In[32]:= ",
 CellID->26112],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"fac", "[", "2", "]"}],
        HoldForm], ",", 
       TagBox["2",
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{"2", " ", "x"}],
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"log", "[", 
     RowBox[{"2", " ", "x"}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{
     RowBox[{"log", "[", "2", "]"}], "+", 
     RowBox[{"log", "[", "x", "]"}]}],
    HoldForm]}], "}"}]], "Output",
 ImageSize->{306, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[32]= ",
 CellID->20576]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Trace",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Trace"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["lhs", "TI"], "->", 
     StyleBox["rhs", "TI"], "]"}], Cell[TextData[{
     "find all expressions matching ",
     Cell[BoxData[
      StyleBox["lhs", "TI"]], "InlineFormula"],
     " that arise during the evaluation of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", and replace them with ",
     Cell[BoxData[
      StyleBox["rhs", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->11845],

Cell["\<\
Applying rules to expressions encountered during evaluation. \
\>", "Caption",
 CellID->2486],

Cell[TextData[{
 "This tells ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 " to return only the arguments of ",
 Cell[BoxData["fib"], "InlineFormula"],
 " used in the evaluation of ",
 Cell[BoxData[
  RowBox[{"fib", "[", "5", "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->29556],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"fib", "[", "5", "]"}], ",", 
   RowBox[{
    RowBox[{"fib", "[", "n_", "]"}], "->", "n"}]}], "]"}]], "Input",
 CellLabel->"In[33]:= ",
 CellID->28603],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWUtOw0AMdX7lTykrlj0NrDhEVCG1CwQqPWx7mjBOKEivE2zPQDKplGg8
tZ/9HNuTqs/1bv3yWu82q3r5tK3f15vVx/Lxbeu2iowo2xPR/IHcunGr9uLP
wV1EJd+L415DFyBfjvw9xmfVR/kq0j41PlY8if/Q8cfaF3zr7oCaOxHR/2of
s1go9XzRsx3qae2GjtcaB+INlc9YXnnjqyqWWaxg/xzk6ksP7VFPi8fRVHQ6
q7V6kl1fHBIO9qrWfyiPsfmG4mrzNDa/UP+67ml3q2+51emwuWMxRzOPtU/P
hmrT1vC2edGg4eyyZn+q3OM5YOZSZxwahdx7OeyegXwNMvfqzIk3Rjv0PgcZ
JxDK6K/w5lKaY7dGr2iPUaTBSooSn02aLBDF+mxQzlq/eLbgaYFe/T2KGZFQ
pIxKsaN+2OS4M3q1Rj0OKwkVnw32fBosrF7jfodgJbR65Y98WuHHUwctsQul
7E6jstNgpakRfiaLJKMfrqK1lRAyua2TfRr1nQar2MmdBotp1LnuPUanNc2a
T4lbGCpmJCVG/9MFvt3Sk4m+txPWZxFPyN/2GQdP0D57icW9Eh/txopXG4eP
1xDxafElnO6/H14eFCvKPgF88PLw\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{472, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[33]= ",
 CellID->778586709]
}, Open  ]],

Cell[TextData[{
 "A powerful aspect of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 " function is that the object it returns is basically a standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression which you can manipulate using other ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions. One important point to realize, however, is that ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 " wraps all expressions that appear in the list it produces with ",
 Cell[BoxData[
  ButtonBox["HoldForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldForm"]], "InlineFormula"],
 " to prevent them from being evaluated. The ",
 Cell[BoxData[
  ButtonBox["HoldForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldForm"]], "InlineFormula"],
 " is not displayed in standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " output format, but it is still present in the internal structure of the \
expression. "
}], "Text",
 CellID->16498],

Cell["\<\
This shows the expressions generated at intermediate stages in the evaluation \
process. \
\>", "MathCaption",
 CellID->2508],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{"1", "+", 
   RowBox[{"3", "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[34]:= ",
 CellID->12878],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     TagBox[
      SuperscriptBox["3", "2"],
      HoldForm], ",", 
     TagBox["9",
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"1", "+", "9"}],
    HoldForm], ",", 
   TagBox["10",
    HoldForm]}], "}"}]], "Output",
 ImageSize->{126, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[34]= ",
 CellID->3338]
}, Open  ]],

Cell[TextData[{
 "The expressions are wrapped with ",
 Cell[BoxData[
  ButtonBox["HoldForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldForm"]], "InlineFormula"],
 " to prevent them from evaluating. "
}], "MathCaption",
 CellID->6723],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Trace", "[", 
   RowBox[{"1", "+", 
    RowBox[{"3", "^", "2"}]}], "]"}], "//", "InputForm"}]], "Input",
 CellLabel->"In[35]:= ",
 CellID->3005],

Cell["\<\
{{HoldForm[3^2], HoldForm[9]}, HoldForm[1 + 9],   HoldForm[10]}\
\>", "Output",
 ImageSize->{441, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[35]//InputForm= ",
 CellID->22411]
}, Open  ]],

Cell[TextData[{
 "In standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " output format, it is sometimes difficult to tell which lists are \
associated with the structure returned by ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 ", and which are expressions being evaluated. "
}], "MathCaption",
 CellID->4193],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "+", "1"}], ",", 
    RowBox[{"2", "+", "3"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[36]:= ",
 CellID->23117],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"1", "+", "1"}],
      HoldForm], ",", 
     TagBox["2",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"2", "+", "3"}],
      HoldForm], ",", 
     TagBox["5",
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"{", 
     RowBox[{"2", ",", "5"}], "}"}],
    HoldForm]}], "}"}]], "Output",
 ImageSize->{198, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[36]= ",
 CellID->943]
}, Open  ]],

Cell["Looking at the input form resolves any ambiguities. ", "MathCaption",
 CellID->1227],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[37]:= ",
 CellID->4514],

Cell["\<\
{{HoldForm[1 + 1], HoldForm[2]},   {HoldForm[2 + 3], HoldForm[5]}, \
HoldForm[{2, 5}]}\
\>", "Output",
 ImageSize->{588, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[37]//InputForm= ",
 CellID->25290]
}, Open  ]],

Cell[TextData[{
 "When you use a transformation rule in ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 ", the result is evaluated before being wrapped with ",
 Cell[BoxData[
  ButtonBox["HoldForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldForm"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->20416],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"fac", "[", "4", "]"}], ",", 
   RowBox[{
    RowBox[{"fac", "[", "n_", "]"}], "->", 
    RowBox[{"n", "+", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[38]:= ",
 CellID->20801],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["5",
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox["4",
      HoldForm], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox["3",
        HoldForm], ",", 
       RowBox[{"{", 
        TagBox["2",
         HoldForm], "}"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[38]= ",
 CellID->30339]
}, Open  ]],

Cell[TextData[{
 "For sophisticated computations, the list structures returned by ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 " can be quite complicated. When you use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Trace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Trace"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["form", "TI"]}], "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 " will include as elements in the lists only those expressions which match \
the pattern ",
 Cell[BoxData[
  StyleBox["form", "TI"]], "InlineFormula"],
 ". But whatever pattern you give, the nesting structure of the lists remains \
the same. "
}], "Text",
 CellID->16544],

Cell[TextData[{
 "This shows all occurrences of ",
 Cell[BoxData[
  RowBox[{"fib", "[", "_", "]"}]], "InlineFormula"],
 " in the evaluation of ",
 Cell[BoxData[
  RowBox[{"fib", "[", "3", "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->20236],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"fib", "[", "3", "]"}], ",", 
   RowBox[{"fib", "[", "_", "]"}]}], "]"}]], "Input",
 CellLabel->"In[39]:= ",
 CellID->20012],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"fib", "[", "3", "]"}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"fib", "[", "2", "]"}],
      HoldForm], ",", 
     RowBox[{"{", 
      TagBox[
       RowBox[{"fib", "[", "1", "]"}],
       HoldForm], "}"}], ",", 
     RowBox[{"{", 
      TagBox[
       RowBox[{"fib", "[", "0", "]"}],
       HoldForm], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    TagBox[
     RowBox[{"fib", "[", "1", "]"}],
     HoldForm], "}"}]}], "}"}]], "Output",
 ImageSize->{329, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[39]= ",
 CellID->16274]
}, Open  ]],

Cell[TextData[{
 "This shows only occurrences of ",
 Cell[BoxData[
  RowBox[{"fib", "[", "1", "]"}]], "InlineFormula"],
 ", but the nesting of the lists is the same as for ",
 Cell[BoxData[
  RowBox[{"fib", "[", "_", "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->5433],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"fib", "[", "3", "]"}], ",", 
   RowBox[{"fib", "[", "1", "]"}]}], "]"}]], "Input",
 CellLabel->"In[40]:= ",
 CellID->29740],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     TagBox[
      RowBox[{"fib", "[", "1", "]"}],
      HoldForm], "}"}], "}"}], ",", 
   RowBox[{"{", 
    TagBox[
     RowBox[{"fib", "[", "1", "]"}],
     HoldForm], "}"}]}], "}"}]], "Output",
 ImageSize->{156, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[40]= ",
 CellID->24401]
}, Open  ]],

Cell[TextData[{
 "You can set the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TraceDepth",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraceDepth"], "->", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " to tell ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 " to include only lists nested at most ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " levels deep. In this way, you can often pick out the \
\[OpenCurlyDoubleQuote]big steps\[CloseCurlyDoubleQuote] in a computation, \
without seeing the details. Note that by setting ",
 Cell[BoxData[
  ButtonBox["TraceDepth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraceDepth"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["TraceOff",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraceOff"]], "InlineFormula"],
 " you can avoid looking at many of the steps in a computation, and thereby \
significantly speed up the operation of ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 " for that computation. "
}], "Text",
 CellID->20183],

Cell["\<\
This shows only steps that appear in lists nested at most two levels deep. \
\>", "MathCaption",
 CellID->21135],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"fib", "[", "3", "]"}], ",", 
   RowBox[{"fib", "[", "_", "]"}], ",", 
   RowBox[{"TraceDepth", "->", "2"}]}], "]"}]], "Input",
 CellLabel->"In[41]:= ",
 CellID->24828],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"fib", "[", "3", "]"}],
    HoldForm], ",", 
   RowBox[{"{", 
    TagBox[
     RowBox[{"fib", "[", "1", "]"}],
     HoldForm], "}"}]}], "}"}]], "Output",
 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[41]= ",
 CellID->30633]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Trace",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Trace"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["form", "TI"], ",", 
     ButtonBox["TraceDepth",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TraceDepth"], "->", 
     StyleBox["n", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "trace the evaluation of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", ignoring steps that lead to lists nested more than ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " levels deep"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->437],

Cell["Restricting the depth of tracing. ", "Caption",
 CellID->32134],

Cell[TextData[{
 "When you use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Trace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Trace"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["form", "TI"]}], "]"}]], "InlineFormula"],
 ", you get a list of all the expressions which match ",
 Cell[BoxData[
  StyleBox["form", "TI"]], "InlineFormula"],
 " produced during the evaluation of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". Sometimes it is useful to see not only these expressions, but also the \
results that were obtained by evaluating them. You can do this by setting the \
option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TraceForward",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraceForward"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->28577],

Cell[TextData[{
 "This shows not only expressions which match ",
 Cell[BoxData[
  RowBox[{"fac", "[", "_", "]"}]], "InlineFormula"],
 ", but also the results of evaluating those expressions. "
}], "MathCaption",
 CellID->3671],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"fac", "[", "4", "]"}], ",", 
   RowBox[{"fac", "[", "_", "]"}], ",", 
   RowBox[{"TraceForward", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[42]:= ",
 CellID->8722],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"fac", "[", "4", "]"}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"fac", "[", "3", "]"}],
      HoldForm], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"fac", "[", "2", "]"}],
        HoldForm], ",", 
       RowBox[{"{", 
        RowBox[{
         TagBox[
          RowBox[{"fac", "[", "1", "]"}],
          HoldForm], ",", 
         TagBox["1",
          HoldForm]}], "}"}], ",", 
       TagBox["2",
        HoldForm]}], "}"}], ",", 
     TagBox["6",
      HoldForm]}], "}"}], ",", 
   TagBox["24",
    HoldForm]}], "}"}]], "Output",
 ImageSize->{342, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[42]= ",
 CellID->27263]
}, Open  ]],

Cell[TextData[{
 "Expressions picked out using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Trace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Trace"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["form", "TI"]}], "]"}]], "InlineFormula"],
 " typically lie in the middle of an evaluation chain. By setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TraceForward",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraceForward"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", you tell ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 " to include also the expression obtained at the end of the evaluation \
chain. If you set ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TraceForward",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraceForward"], "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 " will include ",
 StyleBox["all",
  FontSlant->"Italic"],
 " the expressions that occur after the expression matching ",
 Cell[BoxData[
  StyleBox["form", "TI"]], "InlineFormula"],
 " on the evaluation chain. "
}], "Text",
 CellID->19659],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TraceForward",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraceForward"], "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 ", all elements on the evaluation chain after the one that matches ",
 Cell[BoxData[
  RowBox[{"fac", "[", "_", "]"}]], "InlineFormula"],
 " are included. "
}], "MathCaption",
 CellID->24540],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"fac", "[", "4", "]"}], ",", 
   RowBox[{"fac", "[", "_", "]"}], ",", 
   RowBox[{"TraceForward", "->", "All"}]}], "]"}]], "Input",
 CellLabel->"In[43]:= ",
 CellID->29368],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWV9v0zAQT+Ok6YCuDJAYL9M2XuAN8SHgiQ9RTUjbAwKNvffrAC+ITxhy
iZ16v5xztuPSCqjUtOfcf9/5zvaH9d31x0/ru5ur9fn72/WX65urr+fvPt82
Q2qWZfmbLMsuTrPmf938a7/m87b5bsEOekhP1WNlp80jz7px+i3h/Ss9fuZ4
v29+K4ALgC8C8S8n8n8OsGq9/gBGXwhWK23taxg/c+Ah/aHwP3GMXwrvX3rS
ox45620aLRtQ6V+CFRNLyjGOc15pvHkg35XGQ34IH0Xqn3vyN3qXgXyPD0z/
ILxys9nU5tP8b0c5Lr7cF7YV3tyr2i/GjjSeYrmXDi6VNbM9tZgfiNXJtCtJ
pmdtOIp6+2ERTPlbsdjznevzWPC+0e+/pw7BUz4w6YDrTpgvu1zqMo1yrAqi
dslaeMkqnTzDJXK12F8Wry/GWc7Bov9HYgDW3zEY8bFH2I1UU7twHKVJ/WKc
NphNuO4fA4yxm0aqqYz78YG0CqBU9NGS9VFfWQfy0Kf4no+7LT92jhwrwRbr
UfOYwwrRcx9Qo81KU6NvZi2+tEYTVfEHMjJWDs4I8sVaFWtfaKRx9DFypFq7
L/v8Ms1dOSV+T1i73PzaTBbrIY/lV3nR0wEd1M47IdcpSN8pJJYlZbMUlVN0
4HbSY7JZ/ESypSjepR+mZiyr22BXieuEZBG976NxwA1jkSpbwcRuu6oXW3hs
v05ouFrkPL2Yl/aphNJUBUMdWu1UJN/Q6vav6D819tE+7APxPfoH4w3l4X4L
/WLjU26j/Gcj8rm1wK/KPOWoImsmWuTHe2o38/dZMDWSeduQyq874ncjPC1m
9lhl5PBXokbuOOdOMwikrMw1lVk9cj1nBC8ceHbNol+co33wt/Hv1VTwodKz
bevBxaTBUxYexuaJ5rMC/LkeZ7uXfgK5m8U0ENoz9T6RHt9bzmhR6jsyAn6w
knzvP1yn9q67gSKQ77L2u9mgxzfWkpQ9rdSXuM4zA06TgnWQehijEwFdVHFa
e2on+GLORMKytk+HUkkxcSSdE9DjZ+0TF74nESlr+jSZUq33t31KPLa0o3uZ
4W4p5R3QUH68X2L6e04n7C7KSL7pZnisr/OxQOpG4zXn5tPuNuzqnlvjlQPP
dBumOyGmv1pJtf6E1vds9hsFXb7T\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{560, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[43]= ",
 CellID->89579191]
}, Open  ]],

Cell[TextData[{
 "By setting the option ",
 Cell[BoxData[
  ButtonBox["TraceForward",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraceForward"]], "InlineFormula"],
 ", you can effectively see what happens to a particular form of expression \
during an evaluation. Sometimes, however, you want to find out not what \
happens to a particular expression, but instead how that expression was \
generated. You can do this by setting the option ",
 Cell[BoxData[
  ButtonBox["TraceBackward",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraceBackward"]], "InlineFormula"],
 ". What ",
 Cell[BoxData[
  ButtonBox["TraceBackward",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraceBackward"]], "InlineFormula"],
 " does is to show you what ",
 StyleBox["preceded",
  FontSlant->"Italic"],
 " a particular form of expression on an evaluation chain. "
}], "Text",
 CellID->1848],

Cell[TextData[{
 "This shows that the number ",
 Cell[BoxData["120"], "InlineFormula"],
 " came from the evaluation of ",
 Cell[BoxData[
  RowBox[{"fac", "[", "5", "]"}]], "InlineFormula"],
 " during the evaluation of ",
 Cell[BoxData[
  RowBox[{"fac", "[", "10", "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->20366],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"fac", "[", "10", "]"}], ",", "120", ",", 
   RowBox[{"TraceBackward", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[44]:= ",
 CellID->23290],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        TagBox[
         RowBox[{"fac", "[", "5", "]"}],
         HoldForm], ",", 
        TagBox["120",
         HoldForm]}], "}"}], "}"}], "}"}], "}"}], "}"}], "}"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[44]= ",
 CellID->3227]
}, Open  ]],

Cell[TextData[{
 "Here is the whole evaluation chain associated with the generation of the \
number ",
 Cell[BoxData["120"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->14458],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"fac", "[", "10", "]"}], ",", "120", ",", 
   RowBox[{"TraceBackward", "->", "All"}]}], "]"}]], "Input",
 CellLabel->"In[45]:= ",
 CellID->32071],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        TagBox[
         RowBox[{"fac", "[", "5", "]"}],
         HoldForm], ",", 
        TagBox[
         RowBox[{"5", " ", 
          RowBox[{"fac", "[", 
           RowBox[{"5", "-", "1"}], "]"}]}],
         HoldForm], ",", 
        TagBox[
         RowBox[{"5", " ", "24"}],
         HoldForm], ",", 
        TagBox["120",
         HoldForm]}], "}"}], "}"}], "}"}], "}"}], "}"}], "}"}]], "Output",
 ImageSize->{289, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[45]= ",
 CellID->30106]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraceForward",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraceForward"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["TraceBackward",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraceBackward"]], "InlineFormula"],
 " allow you to look forward and backward in a particular evaluation chain. \
Sometimes, you may also want to look at the evaluation chains within which \
the particular evaluation chain occurs. You can do this using ",
 Cell[BoxData[
  ButtonBox["TraceAbove",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraceAbove"]], "InlineFormula"],
 ". If you set the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TraceAbove",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraceAbove"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", then ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 " will include the initial and final expressions in all the relevant \
evaluation chains. With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TraceAbove",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraceAbove"], "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 " includes all the expressions in all these evaluation chains."
}], "Text",
 CellID->6305],

Cell[TextData[{
 "This includes the initial and final expressions in all evaluation chains \
which contain the chain that contains ",
 Cell[BoxData["120"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->11001],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"fac", "[", "7", "]"}], ",", "120", ",", 
   RowBox[{"TraceAbove", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[46]:= ",
 CellID->25434],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"fac", "[", "7", "]"}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"fac", "[", "6", "]"}],
      HoldForm], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"fac", "[", "5", "]"}],
        HoldForm], ",", 
       TagBox["120",
        HoldForm]}], "}"}], ",", 
     TagBox["720",
      HoldForm]}], "}"}], ",", 
   TagBox["5040",
    HoldForm]}], "}"}]], "Output",
 ImageSize->{298, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[46]= ",
 CellID->1770]
}, Open  ]],

Cell[TextData[{
 "This shows all the ways that ",
 Cell[BoxData[
  RowBox[{"fib", "[", "2", "]"}]], "InlineFormula"],
 " is generated during the evaluation of ",
 Cell[BoxData[
  RowBox[{"fib", "[", "5", "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->9555],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"fib", "[", "5", "]"}], ",", 
   RowBox[{"fib", "[", "2", "]"}], ",", 
   RowBox[{"TraceAbove", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[47]:= ",
 CellID->8507],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWdtSwjAQDb2BIhR8wje+Rh8cPqLDOAMPjg7y/5i0CXbWrZulSRqwM7Rs
kuac7C2Xbqrj7u29Ou631frlUH3u9tuv9fPHQRalIyGSVyFEuRLy/0n+q3/m
2sifEJm6p+dysZK3RIpT/cxB/X1k7Usgw/FQ9dPAeL71sejJD9an6tbcW6VP
hBZTzQ6yj/W9JbMc9uMLJ7QeHnvyTk6Yt6jSXIrmqZ2qvlLEh1U1Vg59ddIT
J9c4kK9rnFDjMe1gv1AuLNuNLXnfXSnvW7Pr2LF+utrhUQ5l9K38LOshQ0y7
VkpW+Qd6nhsOBfZWMPQYNMDjMPbYGs5ktza+GOwXA4fJ4BZpshoW6/4zytwL
qmpViN+Z2g/aMGOkfBWiQpZwvxRGV75Zz7ywjtPCcMfK1dUDygKijOpyP2se
Sq/onjxQfvaDPcyIKZk6G0F3uwxPi5P1f7IwdTpG6WpmxeLy/ZFarUBMKHft
Oi/RqC2eyH5kNznCBtms30KNFNvfc+K77OB7SV4IwVfN1yE9KTZ7YqeaNvbs
0ht9+pma6NHxJOqL4knpi4/QjmAsg/VH4OZ/9whULufO5uEZwvW0ez8Y3krw
iwNXRy5nZHjWBLlz45LbPzcquf27WfG7QbGzm10rap4LyZgbs9dsw7lDvXHi
GDshgNmouczJYqJrVeVf3zrpXgr97NdL1mrlrpdF+y3gDVi5f1Sjb2rVNZTG
lkyNdZU3H/AM4oYpidE3osb5Sw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{587, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[47]= ",
 CellID->56018610]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Trace",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Trace"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["form", "TI"], ",", 
     StyleBox["opts", "TI"], "]"}], Cell[TextData[{
     "trace the evaluation of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " using the specified options"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["TraceForward",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TraceForward"], "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"]}], Cell[TextData[{
     "include the final expression in the evaluation chain containing ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["TraceForward",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TraceForward"], "->", 
     ButtonBox["All",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/All"]}], Cell[TextData[{
     "include all expressions following ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"],
     " in the evaluation chain"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["TraceBackward",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TraceBackward"], "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"]}], Cell[TextData[{
     "include the first expression in the evaluation chain containing ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["TraceBackward",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TraceBackward"], "->", 
     ButtonBox["All",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/All"]}], Cell[TextData[{
     "include all expressions preceding ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"],
     " in the evaluation chain"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["TraceAbove",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TraceAbove"], "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"]}], Cell[TextData[{
     "include the first and last expressions in all evaluation chains which \
contain the chain containing ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["TraceAbove",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TraceAbove"], "->", 
     ButtonBox["All",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/All"]}], Cell[TextData[{
     "include all expressions in all evaluation chains which contain the \
chain containing ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->7730],

Cell["Option settings for including extra steps in trace lists. ", "Caption",
 CellID->4075],

Cell[TextData[{
 "The basic way that ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Trace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Trace"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " works is to intercept each expression encountered during the evaluation of \
",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ", and then to use various criteria to determine whether this expression \
should be recorded. Normally, however, ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 " intercepts expressions only ",
 StyleBox["after",
  FontSlant->"Italic"],
 " function arguments have been evaluated. By setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TraceOriginal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraceOriginal"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", you can get ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 " also to look at expressions ",
 StyleBox["before",
  FontSlant->"Italic"],
 " function arguments have been evaluated. "
}], "Text",
 CellID->8803],

Cell[TextData[{
 "This includes expressions which match ",
 Cell[BoxData[
  RowBox[{"fac", "[", "_", "]"}]], "InlineFormula"],
 " both before and after argument evaluation. "
}], "MathCaption",
 CellID->21439],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"fac", "[", "3", "]"}], ",", 
   RowBox[{"fac", "[", "_", "]"}], ",", 
   RowBox[{"TraceOriginal", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[48]:= ",
 CellID->26194],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"fac", "[", "3", "]"}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"fac", "[", 
       RowBox[{"3", "-", "1"}], "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"fac", "[", "2", "]"}],
      HoldForm], ",", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"fac", "[", 
         RowBox[{"2", "-", "1"}], "]"}],
        HoldForm], ",", 
       TagBox[
        RowBox[{"fac", "[", "1", "]"}],
        HoldForm]}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{340, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[48]= ",
 CellID->22488]
}, Open  ]],

Cell[TextData[{
 "The list structure produced by ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 " normally includes only expressions that constitute steps in \
non\[Hyphen]trivial evaluation chains. Thus, for example, individual symbols \
that evaluate to themselves are not normally included. Nevertheless, if you \
set ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TraceOriginal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraceOriginal"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", then ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 " looks at absolutely every expression involved in the evaluation process, \
including those that have trivial evaluation chains. "
}], "Text",
 CellID->28664],

Cell[TextData[{
 "In this case, ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 " includes absolutely all expressions, even those with trivial evaluation \
chains. "
}], "MathCaption",
 CellID->26673],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"fac", "[", "1", "]"}], ",", 
   RowBox[{"TraceOriginal", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[49]:= ",
 CellID->27048],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"fac", "[", "1", "]"}],
    HoldForm], ",", 
   RowBox[{"{", 
    TagBox["fac",
     HoldForm], "}"}], ",", 
   RowBox[{"{", 
    TagBox["1",
     HoldForm], "}"}], ",", 
   TagBox[
    RowBox[{"fac", "[", "1", "]"}],
    HoldForm], ",", 
   TagBox["1",
    HoldForm]}], "}"}]], "Output",
 ImageSize->{210, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[49]= ",
 CellID->25358]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    ""},
   {
    ButtonBox["TraceForward",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TraceForward"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[TextData[{
     "whether to show expressions following ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"],
     " in the evaluation chain"
    }], "TableText"]},
   {
    ButtonBox["TraceBackward",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TraceBackward"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[TextData[{
     "whether to show expressions preceding ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"],
     " in the evaluation chain"
    }], "TableText"]},
   {
    ButtonBox["TraceAbove",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TraceAbove"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[TextData[{
     "whether to show evaluation chains leading to the evaluation chain \
containing ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    ButtonBox["TraceOriginal",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TraceOriginal"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to look at expressions before their heads and arguments are evaluated\
\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->2280],

Cell[TextData[{
 "Additional options for ",
 StyleBox["Trace", "MR"],
 ". "
}], "Caption",
 CellID->32487],

Cell[TextData[{
 "When you use ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 " to study the execution of a program, there is an issue about how local \
variables in the program should be treated. As discussed in \"",
 ButtonBox["How Modules Work",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/HowModulesWork"],
 "\", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " scoping constructs such as ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " create symbols with new names to represent local variables. Thus, even if \
you called a variable ",
 Cell[BoxData["x"], "InlineFormula"],
 " in the original code for your program, the variable may effectively be \
renamed ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"x$", 
    StyleBox["nnn", "TI"]}]]], "InlineFormula"],
 " when the program is executed. "
}], "Text",
 CellID->19764],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Trace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Trace"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["form", "TI"]}], "]"}]], "InlineFormula"],
 " is set up so that by default a symbol ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " that appears in ",
 Cell[BoxData[
  StyleBox["form", "TI"]], "InlineFormula"],
 " will match all symbols with names of the form ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["x", "TI"], "$", 
    StyleBox["nnn", "TI"]}]]], "InlineFormula"],
 " that arise in the execution of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". As a result, you can for example use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Trace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Trace"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     StyleBox["x", "TI"], "=", "_"}]}], "]"}]], "InlineFormula"],
 " to trace assignment to all variables, local and global, that were named ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " in your original program. "
}], "Text",
 CellID->23713],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Trace",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Trace"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["form", "TI"], ",", 
     ButtonBox["MatchLocalNames",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MatchLocalNames"], "->", 
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "include all steps in the execution of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " that match ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"],
     ", with no replacements for local variable names allowed"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->24013],

Cell["Preventing the matching of local variables. ", "Caption",
 CellID->12452],

Cell[TextData[{
 "In some cases, you may want to trace only the global variable ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", and not any local variables that were originally named ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". You can do this by setting the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MatchLocalNames",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MatchLocalNames"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->18170],

Cell[TextData[{
 "This traces assignments to all variables with names of the form ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"x$", 
    StyleBox["nnn", "TI"]}]]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->24978],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "x", "}"}], ",", 
     RowBox[{"x", "=", "5"}]}], "]"}], ",", 
   RowBox[{"x", "=", "_"}]}], "]"}]], "Input",
 CellLabel->"In[50]:= ",
 CellID->6766],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   TagBox[
    RowBox[{"x$1", "=", "5"}],
    HoldForm], "}"}], "}"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[50]= ",
 CellID->12704]
}, Open  ]],

Cell[TextData[{
 "This traces assignments only to the specific global variable ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->21416],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "x", "}"}], ",", 
     RowBox[{"x", "=", "5"}]}], "]"}], ",", 
   RowBox[{"x", "=", "_"}], ",", 
   RowBox[{"MatchLocalNames", "->", "False"}]}], "]"}]], "Input",
 CellLabel->"In[51]:= ",
 CellID->28649],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[51]= ",
 CellID->10377]
}, Open  ]],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 " performs a complete computation, then returns a structure which represents \
the history of the computation. Particularly in very long computations, it is \
however sometimes useful to see traces of the computation as it proceeds. The \
function ",
 Cell[BoxData[
  ButtonBox["TracePrint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TracePrint"]], "InlineFormula"],
 " works essentially like ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 ", except that it prints expressions when it encounters them, rather than \
saving up all of the expressions to create a list structure. "
}], "Text",
 CellID->22837],

Cell[TextData[{
 "This prints expressions encountered in the evaluation of ",
 Cell[BoxData[
  RowBox[{"fib", "[", "3", "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->28537],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TracePrint", "[", 
  RowBox[{
   RowBox[{"fib", "[", "3", "]"}], ",", 
   RowBox[{"fib", "[", "_", "]"}]}], "]"}]], "Input",
 CellLabel->"In[52]:= ",
 CellID->19459],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{" ", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"fib", "[", "3", "]"}],
    HoldForm]}],
  SequenceForm[
   Indent[1], 
   HoldForm[
    $CellContext`fib[3]]],
  Editable->False]], "Print",
 CellID->20432],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"  ", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"fib", "[", 
     RowBox[{"3", "-", "1"}], "]"}],
    HoldForm]}],
  SequenceForm[
   Indent[2], 
   HoldForm[
    $CellContext`fib[3 - 1]]],
  Editable->False]], "Print",
 CellID->20955],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"  ", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"fib", "[", "2", "]"}],
    HoldForm]}],
  SequenceForm[
   Indent[2], 
   HoldForm[
    $CellContext`fib[2]]],
  Editable->False]], "Print",
 CellID->22105],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"   ", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"fib", "[", 
     RowBox[{"2", "-", "1"}], "]"}],
    HoldForm]}],
  SequenceForm[
   Indent[3], 
   HoldForm[
    $CellContext`fib[2 - 1]]],
  Editable->False]], "Print",
 CellID->20526],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"   ", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"fib", "[", "1", "]"}],
    HoldForm]}],
  SequenceForm[
   Indent[3], 
   HoldForm[
    $CellContext`fib[1]]],
  Editable->False]], "Print",
 CellID->5937],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"   ", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"fib", "[", 
     RowBox[{"2", "-", "2"}], "]"}],
    HoldForm]}],
  SequenceForm[
   Indent[3], 
   HoldForm[
    $CellContext`fib[2 - 2]]],
  Editable->False]], "Print",
 CellID->1366],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"   ", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"fib", "[", "0", "]"}],
    HoldForm]}],
  SequenceForm[
   Indent[3], 
   HoldForm[
    $CellContext`fib[0]]],
  Editable->False]], "Print",
 CellID->3914],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"  ", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"fib", "[", 
     RowBox[{"3", "-", "2"}], "]"}],
    HoldForm]}],
  SequenceForm[
   Indent[2], 
   HoldForm[
    $CellContext`fib[3 - 2]]],
  Editable->False]], "Print",
 CellID->23155],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"  ", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"fib", "[", "1", "]"}],
    HoldForm]}],
  SequenceForm[
   Indent[2], 
   HoldForm[
    $CellContext`fib[1]]],
  Editable->False]], "Print",
 CellID->19290]
}, Open  ]],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[52]= ",
 CellID->6446]
}, Open  ]],

Cell[TextData[{
 "The sequence of expressions printed by ",
 Cell[BoxData[
  ButtonBox["TracePrint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TracePrint"]], "InlineFormula"],
 " corresponds to the sequence of expressions given in the list structure \
returned by ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 ". Indentation in the output from ",
 Cell[BoxData[
  ButtonBox["TracePrint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TracePrint"]], "InlineFormula"],
 " corresponds to nesting in the list structure from ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 ". You can use the ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 " options ",
 Cell[BoxData[
  ButtonBox["TraceOn",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraceOn"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["TraceOff",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraceOff"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["TraceForward",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraceForward"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["TracePrint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TracePrint"]], "InlineFormula"],
 ". However, since ",
 Cell[BoxData[
  ButtonBox["TracePrint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TracePrint"]], "InlineFormula"],
 " produces output as it goes, it cannot support the option ",
 Cell[BoxData[
  ButtonBox["TraceBackward",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraceBackward"]], "InlineFormula"],
 ". In addition, ",
 Cell[BoxData[
  ButtonBox["TracePrint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TracePrint"]], "InlineFormula"],
 " is set up so that ",
 Cell[BoxData[
  ButtonBox["TraceOriginal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraceOriginal"]], "InlineFormula"],
 " is effectively always set to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->18182],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Trace",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Trace"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[TextData[{
     "trace the evaluation of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", returning a list structure containing the expressions encountered"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["TracePrint",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TracePrint"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[TextData[{
     "trace the evaluation of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", printing the expressions encountered"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["TraceDialog",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TraceDialog"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[TextData[{
     "trace the evaluation of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", initiating a dialog when each specified expression is encountered"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["TraceScan",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TraceScan"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[TextData[{
     "trace the evaluation of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", applying ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      ButtonBox["HoldForm",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/HoldForm"]], "InlineFormula"],
     " of each expression encountered"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->19635],

Cell["Functions for tracing evaluation. ", "Caption",
 CellID->20093],

Cell[TextData[{
 "This enters a dialog when ",
 Cell[BoxData[
  RowBox[{"fac", "[", "5", "]"}]], "InlineFormula"],
 " is encountered during the evaluation of ",
 Cell[BoxData[
  RowBox[{"fac", "[", "10", "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->3936],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TraceDialog", "[", 
  RowBox[{
   RowBox[{"fac", "[", "10", "]"}], ",", 
   RowBox[{"fac", "[", "5", "]"}]}], "]"}]], "Input",
 CellLabel->"In[53]:= ",
 CellID->15846],

Cell[BoxData[
 RowBox[{
  RowBox[{"TraceDialog", "::", "\<\"dgbgn\"\>"}], ":", 
  " ", "\<\"Entering Dialog; use Return[] to exit.\"\>"}]], "Message", "MSG",
 CellID->21238],

Cell[BoxData[
 TagBox[
  RowBox[{"fac", "[", "5", "]"}],
  HoldForm]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[54]= ",
 CellID->5456]
}, Open  ]],

Cell["\<\
Inside the dialog you can for example find out where you are by looking at \
the \[OpenCurlyDoubleQuote]stack\[CloseCurlyDoubleQuote]. \
\>", "MathCaption",
 CellID->24403],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Stack", "[", "]"}]], "Input",
 CellLabel->"In[54]:= ",
 CellID->19714],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "TraceDialog", ",", "Times", ",", "Times", ",", "Times", ",", "Times", ",", 
   "Times", ",", "fac"}], "}"}]], "Output",
 ImageSize->{359, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[55]=",
 CellID->25599]
}, Open  ]],

Cell[TextData[{
 "This returns from the dialog, and gives the final result from the \
evaluation of ",
 Cell[BoxData[
  RowBox[{"fac", "[", "10", "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->30041],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Return", "[", "]"}]], "Input",
 CellLabel->"In[55]:= ",
 CellID->6925],

Cell[BoxData[
 RowBox[{
  RowBox[{"TraceDialog", "::", "\<\"dgend\"\>"}], ":", 
  " ", "\<\"Exiting Dialog.\"\>"}]], "Message", "MSG",
 CellID->18074],

Cell[BoxData["3628800"], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[53]= ",
 CellID->12324]
}, Open  ]],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  ButtonBox["TraceDialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraceDialog"]], "InlineFormula"],
 " effectively allows you to stop in the middle of a computation, and \
interact with the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " environment that exists at that time. You can for example find values of \
intermediate variables in the computation, and even reset those values. There \
are however a number of subtleties, mostly associated with pattern and module \
variables. "
}], "Text",
 CellID->10344],

Cell[TextData[{
 "What ",
 Cell[BoxData[
  ButtonBox["TraceDialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraceDialog"]], "InlineFormula"],
 " does is to call the function ",
 Cell[BoxData[
  ButtonBox["Dialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dialog"]], "InlineFormula"],
 " on a sequence of expressions. The ",
 Cell[BoxData[
  ButtonBox["Dialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dialog"]], "InlineFormula"],
 " function is discussed in detail in \"",
 ButtonBox["Dialogs",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/Dialogs"],
 "\". When you call ",
 Cell[BoxData[
  ButtonBox["Dialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dialog"]], "InlineFormula"],
 ", you are effectively starting a subsidiary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session with its own sequence of input and output lines. "
}], "Text",
 CellID->29863],

Cell[TextData[{
 "In general, you may need to apply arbitrary functions to the expressions \
you get while tracing an evaluation. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TraceScan",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraceScan"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " applies ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " to each expression that arises. The expression is wrapped with ",
 Cell[BoxData[
  ButtonBox["HoldForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldForm"]], "InlineFormula"],
 " to prevent it from evaluating. "
}], "Text",
 CellID->13749],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TraceScan",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraceScan"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 ", the function ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " is applied to expressions before they are evaluated. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TraceScan",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraceScan"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["patt", "TI"], ",", 
    StyleBox["fp", "TI"]}], "]"}]], "InlineFormula"],
 " applies ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " before evaluation, and ",
 Cell[BoxData[
  StyleBox["fp", "TI"]], "InlineFormula"],
 " after evaluation. "
}], "Text",
 CellID->29276],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->95192619],

Cell[TextData[ButtonBox["Evaluation of Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EvaluationOfExpressionsOverview"]], "RelatedTutorials",
 CellID->14411223]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Tracing Evaluation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Evaluation of Expressions", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/EvaluationOfExpressionsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/CollectingExpressionsDuringEvaluation"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TheEvaluationStack"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 44, 9.3905022}", "context" -> "", 
    "keywords" -> {
     "assignments", "builtin functions", "built-in functions", 
      "calls to functions", "conditions", "debugging", "development aids", 
      "diagnostics", "dialogs", "efficiency", "evaluation", 
      "evaluation chain", "execution", "function calls", "function arguments",
       "global variables", "history of computation", "HoldForm", "inspector", 
      "intermediate expressions", "local variables", "MatchLocalNames", 
      "messages", "monitoring", "monitoring evaluation", 
      "print trace of evaluation", "programs", "recursion", "results", 
      "return", "rules", "scoping constructs", "stack trace", 
      "steps in evaluation", "system functions", "tags", "trace", 
      "TraceAbove", "TraceBackward", "TraceDepth", "TraceDialog", 
      "TraceForward", "TraceOff", "TraceOn", "TraceOriginal", "TracePrint", 
      "TraceScan", "tracing evaluation", "transformation rules", "variables", 
      "watch evaluation"}, "index" -> True, "label" -> "Mathematica Tutorial",
     "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "The standard way in which Mathematica works is to take any expression \
you give as input, evaluate the expression completely, and then return the \
result. When you are trying to understand what Mathematica is doing, however, \
it is often worthwhile to look not just at the final result of evaluation, \
but also at intermediate steps in the evaluation process. Tracing the \
evaluation of expressions. The expression 1+1 is evaluated immediately to 2. \
", "synonyms" -> {"2.6.11"}, "title" -> "Tracing Evaluation", "type" -> 
    "Tutorial", "uri" -> "tutorial/TracingEvaluation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.6.12"->{
  Cell[3356, 79, 83, 2, 70, "Title",
   CellTags->{"S2.6.12", "12.1"},
   CellID->15851]},
 "12.1"->{
  Cell[3356, 79, 83, 2, 70, "Title",
   CellTags->{"S2.6.12", "12.1"},
   CellID->15851]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.6.12", 112060, 4066},
 {"12.1", 112162, 4070}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2731, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3356, 79, 83, 2, 70, "Title",
 CellTags->{"S2.6.12", "12.1"},
 CellID->15851],
Cell[3442, 83, 497, 13, 70, "Text",
 CellID->19769],
Cell[3942, 98, 1006, 30, 70, "DefinitionBox",
 CellID->11237],
Cell[4951, 130, 74, 1, 70, "Caption",
 CellID->28301],
Cell[5028, 133, 209, 8, 70, "MathCaption",
 CellID->15676],
Cell[CellGroupData[{
Cell[5262, 145, 121, 4, 28, "Input",
 CellID->13604],
Cell[5386, 151, 277, 12, 36, "Output",
 CellID->27073]
}, Open  ]],
Cell[5678, 166, 167, 6, 70, "MathCaption",
 CellID->24161],
Cell[CellGroupData[{
Cell[5870, 176, 145, 5, 28, "Input",
 CellID->21197],
Cell[6018, 183, 425, 19, 39, "Output",
 CellID->8595]
}, Open  ]],
Cell[6458, 205, 115, 3, 70, "MathCaption",
 CellID->2125],
Cell[CellGroupData[{
Cell[6598, 212, 178, 6, 70, "Input",
 CellID->5485],
Cell[6779, 220, 585, 26, 39, "Output",
 CellID->15062]
}, Open  ]],
Cell[7379, 249, 718, 22, 70, "Text",
 CellID->29229],
Cell[8100, 273, 593, 20, 70, "Text",
 CellID->27560],
Cell[8696, 295, 94, 1, 70, "MathCaption",
 CellID->7718],
Cell[CellGroupData[{
Cell[8815, 300, 281, 10, 70, "Input",
 CellID->29073],
Cell[9099, 312, 154, 5, 36, "Output",
 CellID->8079]
}, Open  ]],
Cell[9268, 320, 279, 9, 70, "MathCaption",
 CellID->8709],
Cell[CellGroupData[{
Cell[9572, 333, 127, 4, 28, "Input",
 CellID->9662],
Cell[9702, 339, 1297, 25, 54, "Output",
 Evaluatable->False,
 CellID->13823333]
}, Open  ]],
Cell[11014, 367, 183, 6, 70, "MathCaption",
 CellID->11574],
Cell[CellGroupData[{
Cell[11222, 377, 183, 6, 70, "Input",
 CellID->7682],
Cell[11408, 385, 464, 19, 36, "Output",
 CellID->7475]
}, Open  ]],
Cell[11887, 407, 205, 8, 70, "MathCaption",
 CellID->28815],
Cell[CellGroupData[{
Cell[12117, 419, 237, 8, 28, "Input",
 CellID->29343],
Cell[12357, 429, 709, 16, 36, "Output",
 Evaluatable->False,
 CellID->258344760]
}, Open  ]],
Cell[13081, 448, 551, 18, 70, "Text",
 CellID->27532],
Cell[13635, 468, 634, 18, 70, "Text",
 CellID->14568],
Cell[14272, 488, 898, 25, 70, "Text",
 CellID->32684],
Cell[15173, 515, 146, 5, 70, "MathCaption",
 CellID->4361],
Cell[CellGroupData[{
Cell[15344, 524, 446, 15, 70, "Input",
 CellID->5472],
Cell[15793, 541, 650, 27, 51, "Output",
 CellID->25286]
}, Open  ]],
Cell[16458, 571, 728, 21, 70, "Text",
 CellID->8266],
Cell[17189, 594, 69, 1, 70, "MathCaption",
 CellID->6089],
Cell[17261, 597, 396, 15, 70, "Input",
 CellID->32151],
Cell[17660, 614, 162, 5, 70, "MathCaption",
 CellID->4604],
Cell[CellGroupData[{
Cell[17847, 623, 175, 6, 70, "Input",
 CellID->17233],
Cell[18025, 631, 649, 27, 51, "Output",
 CellID->25594]
}, Open  ]],
Cell[18689, 661, 681, 19, 70, "Text",
 CellID->9076],
Cell[19373, 682, 1555, 48, 70, "DefinitionBox",
 CellID->598],
Cell[20931, 732, 100, 5, 70, "Caption",
 CellID->18604],
Cell[21034, 739, 727, 20, 70, "Text",
 CellID->23533],
Cell[21764, 761, 813, 21, 70, "Text",
 CellID->468],
Cell[22580, 784, 74, 1, 70, "MathCaption",
 CellID->31184],
Cell[CellGroupData[{
Cell[22679, 789, 343, 12, 70, "Input",
 CellID->31417],
Cell[23025, 803, 182, 6, 36, "Output",
 CellID->2964]
}, Open  ]],
Cell[23222, 812, 233, 8, 70, "MathCaption",
 CellID->29616],
Cell[CellGroupData[{
Cell[23480, 824, 127, 4, 70, "Input",
 CellID->11014],
Cell[23610, 830, 446, 19, 36, "Output",
 CellID->14066]
}, Open  ]],
Cell[24071, 852, 243, 6, 70, "MathCaption",
 CellID->14996],
Cell[CellGroupData[{
Cell[24339, 862, 132, 4, 70, "Input",
 CellID->16873],
Cell[24474, 868, 410, 17, 36, "Output",
 CellID->7148]
}, Open  ]],
Cell[24899, 888, 180, 5, 70, "MathCaption",
 CellID->2510],
Cell[CellGroupData[{
Cell[25104, 897, 236, 8, 70, "Input",
 CellID->10396],
Cell[25343, 907, 722, 32, 36, "Output",
 CellID->15941]
}, Open  ]],
Cell[26080, 942, 123, 3, 70, "MathCaption",
 CellID->25791],
Cell[CellGroupData[{
Cell[26228, 949, 170, 6, 70, "Input",
 CellID->16866],
Cell[26401, 957, 645, 28, 39, "Output",
 CellID->25589]
}, Open  ]],
Cell[27061, 988, 114, 3, 70, "MathCaption",
 CellID->4020],
Cell[CellGroupData[{
Cell[27200, 995, 212, 7, 28, "Input",
 CellID->23355],
Cell[27415, 1004, 754, 16, 36, "Output",
 Evaluatable->False,
 CellID->194705074]
}, Open  ]],
Cell[28184, 1023, 680, 16, 70, "Text",
 CellID->28251],
Cell[28867, 1041, 219, 7, 70, "MathCaption",
 CellID->5081],
Cell[CellGroupData[{
Cell[29111, 1052, 232, 8, 70, "Input",
 CellID->32271],
Cell[29346, 1062, 723, 31, 36, "Output",
 CellID->31825]
}, Open  ]],
Cell[30084, 1096, 84, 1, 70, "MathCaption",
 CellID->9228],
Cell[30171, 1099, 202, 7, 70, "Input",
 CellID->31173],
Cell[30376, 1108, 209, 6, 70, "MathCaption",
 CellID->13454],
Cell[CellGroupData[{
Cell[30610, 1118, 128, 4, 70, "Input",
 CellID->10309],
Cell[30741, 1124, 957, 36, 54, "Output",
 CellID->6430]
}, Open  ]],
Cell[31713, 1163, 405, 7, 70, "Text",
 CellID->31238],
Cell[32121, 1172, 591, 20, 70, "Text",
 CellID->13991],
Cell[32715, 1194, 178, 5, 70, "MathCaption",
 CellID->13739],
Cell[CellGroupData[{
Cell[32918, 1203, 184, 6, 28, "Input",
 CellID->24853],
Cell[33105, 1211, 763, 17, 36, "Output",
 Evaluatable->False,
 CellID->288643470]
}, Open  ]],
Cell[33883, 1231, 325, 12, 70, "MathCaption",
 CellID->12567],
Cell[34211, 1245, 224, 8, 70, "Input",
 CellID->17054],
Cell[34438, 1255, 206, 6, 70, "MathCaption",
 CellID->29877],
Cell[CellGroupData[{
Cell[34669, 1265, 182, 6, 70, "Input",
 CellID->22490],
Cell[34854, 1273, 1049, 45, 54, "Output",
 CellID->31197]
}, Open  ]],
Cell[35918, 1321, 100, 2, 70, "MathCaption",
 CellID->19056],
Cell[36021, 1325, 257, 9, 70, "Input",
 CellID->10773],
Cell[36281, 1336, 86, 1, 70, "MathCaption",
 CellID->30589],
Cell[CellGroupData[{
Cell[36392, 1341, 174, 6, 70, "Input",
 CellID->26862],
Cell[36569, 1349, 156, 5, 36, "Output",
 CellID->27536]
}, Open  ]],
Cell[36740, 1357, 185, 6, 70, "MathCaption",
 CellID->29429],
Cell[CellGroupData[{
Cell[36950, 1367, 184, 6, 28, "Input",
 CellID->12888],
Cell[37137, 1375, 1271, 25, 54, "Output",
 Evaluatable->False,
 CellID->287827068]
}, Open  ]],
Cell[38423, 1403, 1308, 37, 70, "Text",
 CellID->17585],
Cell[39734, 1442, 645, 24, 70, "Text",
 CellID->21841],
Cell[40382, 1468, 1153, 36, 70, "DefinitionBox",
 CellID->4167],
Cell[41538, 1506, 87, 1, 70, "Caption",
 CellID->5520],
Cell[41628, 1509, 181, 6, 70, "MathCaption",
 CellID->11560],
Cell[CellGroupData[{
Cell[41834, 1519, 184, 6, 70, "Input",
 CellID->21047],
Cell[42021, 1527, 466, 19, 36, "Output",
 CellID->14581]
}, Open  ]],
Cell[42502, 1549, 187, 6, 70, "MathCaption",
 CellID->30382],
Cell[CellGroupData[{
Cell[42714, 1559, 155, 5, 70, "Input",
 CellID->19606],
Cell[42872, 1566, 782, 32, 36, "Output",
 CellID->11989]
}, Open  ]],
Cell[43669, 1601, 133, 5, 70, "MathCaption",
 CellID->26784],
Cell[43805, 1608, 232, 8, 70, "Input",
 CellID->13403],
Cell[44040, 1618, 279, 9, 70, "MathCaption",
 CellID->21960],
Cell[CellGroupData[{
Cell[44344, 1631, 203, 7, 70, "Input",
 CellID->21462],
Cell[44550, 1640, 1076, 40, 54, "Output",
 CellID->8732]
}, Open  ]],
Cell[45641, 1683, 1506, 44, 70, "DefinitionBox",
 CellID->20392],
Cell[47150, 1729, 79, 1, 70, "Caption",
 CellID->26843],
Cell[47232, 1732, 653, 21, 70, "Text",
 CellID->14063],
Cell[47888, 1755, 770, 25, 70, "Text",
 CellID->16923],
Cell[48661, 1782, 79, 1, 70, "MathCaption",
 CellID->14611],
Cell[CellGroupData[{
Cell[48765, 1787, 185, 6, 28, "Input",
 CellID->24740],
Cell[48953, 1795, 1263, 25, 36, "Output",
 Evaluatable->False,
 CellID->229099618]
}, Open  ]],
Cell[50231, 1823, 165, 5, 70, "MathCaption",
 CellID->22443],
Cell[CellGroupData[{
Cell[50421, 1832, 244, 8, 70, "Input",
 CellID->22270],
Cell[50668, 1842, 883, 36, 36, "Output",
 CellID->3919]
}, Open  ]],
Cell[51566, 1881, 172, 5, 70, "MathCaption",
 CellID->28849],
Cell[CellGroupData[{
Cell[51763, 1890, 245, 8, 70, "Input",
 CellID->26112],
Cell[52011, 1900, 676, 28, 36, "Output",
 CellID->20576]
}, Open  ]],
Cell[52702, 1931, 915, 27, 70, "DefinitionBox",
 CellID->11845],
Cell[53620, 1960, 103, 3, 70, "Caption",
 CellID->2486],
Cell[53726, 1965, 363, 13, 70, "MathCaption",
 CellID->29556],
Cell[CellGroupData[{
Cell[54114, 1982, 211, 7, 28, "Input",
 CellID->28603],
Cell[54328, 1991, 852, 18, 36, "Output",
 Evaluatable->False,
 CellID->778586709]
}, Open  ]],
Cell[55195, 2012, 1171, 36, 70, "Text",
 CellID->16498],
Cell[56369, 2050, 135, 4, 70, "MathCaption",
 CellID->2508],
Cell[CellGroupData[{
Cell[56529, 2058, 146, 5, 70, "Input",
 CellID->12878],
Cell[56678, 2065, 426, 19, 39, "Output",
 CellID->3338]
}, Open  ]],
Cell[57119, 2087, 244, 8, 70, "MathCaption",
 CellID->6723],
Cell[CellGroupData[{
Cell[57388, 2099, 179, 6, 70, "Input",
 CellID->3005],
Cell[57570, 2107, 229, 7, 50, "Output",
 CellID->22411]
}, Open  ]],
Cell[57814, 2117, 392, 12, 70, "MathCaption",
 CellID->4193],
Cell[CellGroupData[{
Cell[58231, 2133, 196, 7, 70, "Input",
 CellID->23117],
Cell[58430, 2142, 559, 25, 36, "Output",
 CellID->943]
}, Open  ]],
Cell[59004, 2170, 90, 1, 70, "MathCaption",
 CellID->1227],
Cell[CellGroupData[{
Cell[59119, 2175, 102, 3, 70, "Input",
 CellID->4514],
Cell[59224, 2180, 252, 8, 50, "Output",
 CellID->25290]
}, Open  ]],
Cell[59491, 2191, 388, 13, 70, "MathCaption",
 CellID->20416],
Cell[CellGroupData[{
Cell[59904, 2208, 236, 8, 70, "Input",
 CellID->20801],
Cell[60143, 2218, 458, 20, 36, "Output",
 CellID->30339]
}, Open  ]],
Cell[60616, 2241, 851, 27, 70, "Text",
 CellID->16544],
Cell[61470, 2270, 254, 9, 70, "MathCaption",
 CellID->20236],
Cell[CellGroupData[{
Cell[61749, 2283, 184, 6, 70, "Input",
 CellID->20012],
Cell[61936, 2291, 664, 27, 36, "Output",
 CellID->16274]
}, Open  ]],
Cell[62615, 2321, 282, 9, 70, "MathCaption",
 CellID->5433],
Cell[CellGroupData[{
Cell[62922, 2334, 184, 6, 70, "Input",
 CellID->29740],
Cell[63109, 2342, 400, 16, 36, "Output",
 CellID->24401]
}, Open  ]],
Cell[63524, 2361, 1167, 36, 70, "Text",
 CellID->20183],
Cell[64694, 2399, 122, 3, 70, "MathCaption",
 CellID->21135],
Cell[CellGroupData[{
Cell[64841, 2406, 228, 7, 70, "Input",
 CellID->24828],
Cell[65072, 2415, 345, 14, 36, "Output",
 CellID->30633]
}, Open  ]],
Cell[65432, 2432, 1096, 32, 70, "DefinitionBox",
 CellID->437],
Cell[66531, 2466, 69, 1, 70, "Caption",
 CellID->32134],
Cell[66603, 2469, 1019, 34, 70, "Text",
 CellID->28577],
Cell[67625, 2505, 226, 6, 70, "MathCaption",
 CellID->3671],
Cell[CellGroupData[{
Cell[67876, 2515, 232, 7, 70, "Input",
 CellID->8722],
Cell[68111, 2524, 788, 33, 36, "Output",
 CellID->27263]
}, Open  ]],
Cell[68914, 2560, 1377, 47, 70, "Text",
 CellID->19659],
Cell[70294, 2609, 446, 15, 70, "MathCaption",
 CellID->24540],
Cell[CellGroupData[{
Cell[70765, 2628, 232, 7, 28, "Input",
 CellID->29368],
Cell[71000, 2637, 1400, 27, 54, "Output",
 Evaluatable->False,
 CellID->89579191]
}, Open  ]],
Cell[72415, 2667, 882, 24, 70, "Text",
 CellID->1848],
Cell[73300, 2693, 330, 11, 70, "MathCaption",
 CellID->20366],
Cell[CellGroupData[{
Cell[73655, 2708, 206, 6, 70, "Input",
 CellID->23290],
Cell[73864, 2716, 442, 17, 36, "Output",
 CellID->3227]
}, Open  ]],
Cell[74321, 2736, 183, 6, 70, "MathCaption",
 CellID->14458],
Cell[CellGroupData[{
Cell[74529, 2746, 205, 6, 70, "Input",
 CellID->32071],
Cell[74737, 2754, 666, 25, 36, "Output",
 CellID->30106]
}, Open  ]],
Cell[75418, 2782, 1539, 48, 70, "Text",
 CellID->6305],
Cell[76960, 2832, 214, 6, 70, "MathCaption",
 CellID->11001],
Cell[CellGroupData[{
Cell[77199, 2842, 202, 6, 70, "Input",
 CellID->25434],
Cell[77404, 2850, 612, 26, 36, "Output",
 CellID->1770]
}, Open  ]],
Cell[78031, 2879, 269, 9, 70, "MathCaption",
 CellID->9555],
Cell[CellGroupData[{
Cell[78325, 2892, 230, 7, 28, "Input",
 CellID->8507],
Cell[78558, 2901, 973, 20, 36, "Output",
 Evaluatable->False,
 CellID->56018610]
}, Open  ]],
Cell[79546, 2924, 3199, 99, 70, "DefinitionBox",
 CellID->7730],
Cell[82748, 3025, 92, 1, 70, "Caption",
 CellID->4075],
Cell[82843, 3028, 1284, 42, 70, "Text",
 CellID->8803],
Cell[84130, 3072, 209, 6, 70, "MathCaption",
 CellID->21439],
Cell[CellGroupData[{
Cell[84364, 3082, 234, 7, 70, "Input",
 CellID->26194],
Cell[84601, 3091, 698, 28, 36, "Output",
 CellID->22488]
}, Open  ]],
Cell[85314, 3122, 911, 26, 70, "Text",
 CellID->28664],
Cell[86228, 3150, 269, 9, 70, "MathCaption",
 CellID->26673],
Cell[CellGroupData[{
Cell[86522, 3163, 193, 6, 70, "Input",
 CellID->27048],
Cell[86718, 3171, 480, 21, 36, "Output",
 CellID->25358]
}, Open  ]],
Cell[87213, 3195, 1901, 58, 70, "DefinitionBox3Col",
 CellID->2280],
Cell[89117, 3255, 106, 5, 70, "Caption",
 CellID->32487],
Cell[89226, 3262, 980, 30, 70, "Text",
 CellID->19764],
Cell[90209, 3294, 1159, 39, 70, "Text",
 CellID->23713],
Cell[91371, 3335, 1189, 34, 70, "DefinitionBox",
 CellID->24013],
Cell[92563, 3371, 79, 1, 70, "Caption",
 CellID->12452],
Cell[92645, 3374, 575, 18, 70, "Text",
 CellID->18170],
Cell[93223, 3394, 219, 8, 70, "MathCaption",
 CellID->24978],
Cell[CellGroupData[{
Cell[93467, 3406, 256, 9, 70, "Input",
 CellID->6766],
Cell[93726, 3417, 254, 10, 36, "Output",
 CellID->12704]
}, Open  ]],
Cell[93995, 3430, 179, 6, 70, "MathCaption",
 CellID->21416],
Cell[CellGroupData[{
Cell[94199, 3440, 310, 10, 70, "Input",
 CellID->28649],
Cell[94512, 3452, 173, 6, 36, "Output",
 CellID->10377]
}, Open  ]],
Cell[94700, 3461, 831, 22, 70, "Text",
 CellID->22837],
Cell[95534, 3485, 186, 6, 70, "MathCaption",
 CellID->28537],
Cell[CellGroupData[{
Cell[95745, 3495, 189, 6, 70, "Input",
 CellID->19459],
Cell[CellGroupData[{
Cell[95959, 3505, 251, 11, 70, "Print",
 CellID->20432],
Cell[96213, 3518, 282, 12, 70, "Print",
 CellID->20955],
Cell[96498, 3532, 252, 11, 70, "Print",
 CellID->22105],
Cell[96753, 3545, 283, 12, 70, "Print",
 CellID->20526],
Cell[97039, 3559, 252, 11, 70, "Print",
 CellID->5937],
Cell[97294, 3572, 282, 12, 70, "Print",
 CellID->1366],
Cell[97579, 3586, 252, 11, 70, "Print",
 CellID->3914],
Cell[97834, 3599, 282, 12, 70, "Print",
 CellID->23155],
Cell[98119, 3613, 252, 11, 70, "Print",
 CellID->19290]
}, Open  ]],
Cell[98386, 3627, 155, 5, 36, "Output",
 CellID->6446]
}, Open  ]],
Cell[98556, 3635, 2191, 74, 70, "Text",
 CellID->18182],
Cell[100750, 3711, 2213, 66, 70, "DefinitionBox",
 CellID->19635],
Cell[102966, 3779, 69, 1, 70, "Caption",
 CellID->20093],
Cell[103038, 3782, 269, 9, 70, "MathCaption",
 CellID->3936],
Cell[CellGroupData[{
Cell[103332, 3795, 191, 6, 70, "Input",
 CellID->15846],
Cell[103526, 3803, 173, 4, 70, "Message",
 CellID->21238],
Cell[103702, 3809, 207, 8, 36, "Output",
 CellID->5456]
}, Open  ]],
Cell[103924, 3820, 182, 4, 70, "MathCaption",
 CellID->24403],
Cell[CellGroupData[{
Cell[104131, 3828, 94, 3, 70, "Input",
 CellID->19714],
Cell[104228, 3833, 290, 9, 36, "Output",
 CellID->25599]
}, Open  ]],
Cell[104533, 3845, 212, 7, 70, "MathCaption",
 CellID->30041],
Cell[CellGroupData[{
Cell[104770, 3856, 94, 3, 70, "Input",
 CellID->6925],
Cell[104867, 3861, 150, 4, 70, "Message",
 CellID->18074],
Cell[105020, 3867, 162, 5, 36, "Output",
 CellID->12324]
}, Open  ]],
Cell[105197, 3875, 579, 15, 70, "Text",
 CellID->10344],
Cell[105779, 3892, 909, 30, 70, "Text",
 CellID->29863],
Cell[106691, 3924, 717, 22, 70, "Text",
 CellID->13749],
Cell[107411, 3948, 917, 33, 70, "Text",
 CellID->29276],
Cell[CellGroupData[{
Cell[108353, 3985, 71, 1, 70, "RelatedTutorialsSection",
 CellID->95192619],
Cell[108427, 3988, 180, 4, 70, "RelatedTutorials",
 CellID->14411223]
}, Open  ]]
}, Open  ]],
Cell[108634, 3996, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

