(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    241308,       5960]
NotebookOptionsPosition[    222260,       5289]
NotebookOutlinePosition[    229478,       5518]
CellTagsIndexPosition[    229312,       5510]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"TreePlot" :> 
         Documentation`HelpLookup["paclet:ref/TreePlot"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"TreePlot\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Tree Drawing", "Title",
 CellTags->{"graphplot", "i:3", "b:0.1"},
 CellID->672278587],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TreePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TreePlot"]], "InlineFormula"],
 " lays out the vertices of a graph in a tree of successive layers, or a \
collection of trees. If the graph ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " is not a tree, ",
 Cell[BoxData[
  ButtonBox["TreePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TreePlot"]], "InlineFormula"],
 " lays out its vertices on the basis of a spanning tree of each component of \
the graph. "
}], "Text",
 CellID->621106430],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["TreePlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TreePlot"], "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox[
         StyleBox["v", "TI"], 
         StyleBox["i1", "TI"]], "->", 
        SubscriptBox[
         StyleBox["v", "TI"], 
         StyleBox["j1", "TI"]]}], ",", 
       RowBox[{
        SubscriptBox[
         StyleBox["v", "TI"], 
         StyleBox["i2", "TI"]], "->", 
        SubscriptBox[
         StyleBox["v", "TI"], 
         StyleBox["j2", "TI"]]}], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], Cell[TextData[{
     "generate a tree plot of the graph in which vertex ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["ik", "TI"]]], "InlineFormula"],
     " is connected to vertex ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["jk", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["TreePlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TreePlot"], "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SubscriptBox[
           StyleBox["v", "TI"], 
           StyleBox["i1", "TI"]], "->", 
          SubscriptBox[
           StyleBox["v", "TI"], 
           StyleBox["j1", "TI"]]}], ",", 
         SubscriptBox[
          StyleBox["lbl", "TI"], 
          StyleBox["1", "TR"]]}], "}"}], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], Cell[TextData[{
     "associate labels ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["lbl", "TI"], 
       StyleBox["k", "TI"]]], "InlineFormula"],
     " with edges in the graph"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["TreePlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TreePlot"], "[", 
     RowBox[{
      StyleBox["g", "TI"], ",", 
      StyleBox["pos", "TI"]}], "]"}], Cell[TextData[{
     "place roots of trees in the plot at position ",
     Cell[BoxData[
      StyleBox["pos", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["TreePlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TreePlot"], "[", 
     RowBox[{
      StyleBox["g", "TI"], ",", 
      StyleBox["pos", "TI"], ",", 
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["k", "TI"]]}], "]"}], Cell[TextData[{
     "use vertex ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["k", "TI"]]], "InlineFormula"],
     " as the root node in the tree plot"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["TreePlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TreePlot"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[TextData[{
     "generate a layered plot of the graph represented by the adjacency \
matrix ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"b:0.1",
 CellID->25485965],

Cell["Tree drawing.", "Caption",
 CellTags->"b:0.1",
 CellID->164814425],

Cell["This a simple graph and its tree plot:", "MathCaption",
 CellID->185285925],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "6"}], ",", 
     RowBox[{"4", "\[Rule]", "8"}], ",", 
     RowBox[{"5", "\[Rule]", "10"}], ",", 
     RowBox[{"6", "\[Rule]", "12"}], ",", 
     RowBox[{"1", "\[Rule]", "3"}], ",", 
     RowBox[{"2", "\[Rule]", "5"}], ",", 
     RowBox[{"3", "\[Rule]", "7"}], ",", 
     RowBox[{"4", "\[Rule]", "9"}], ",", 
     RowBox[{"5", "\[Rule]", "11"}], ",", 
     RowBox[{"6", "\[Rule]", "13"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->686939073],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexLabeling", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->188451088],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{2.393494006535641, 2.209379082955976}, {
    1.104689541477988, 1.4729193886373175`}, {0.3682298471593293, 
    0.7364596943186588}, {3.6822984715932936`, 1.4729193886373175`}, {
    3.3140686244339643`, 0.7364596943186588}, {0., 0.}, {1.8411492357966468`, 
    0.7364596943186588}, {1.4729193886373173`, 0.}, {2.9458387772746346`, 
    0.}, {4.050528318752622, 0.7364596943186588}, {0.7364596943186587, 0.}, {
    2.209379082955976, 0.}, {3.6822984715932936`, 0.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 4}, {2, 3}, {2, 7}, {3, 6}, {3, 11}, {4, 5}, {4, 
       10}, {5, 9}, {5, 13}, {7, 8}, {7, 12}}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["8",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7], InsetBox[
       FrameBox["10",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 8], InsetBox[
       FrameBox["12",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 9], InsetBox[
       FrameBox["7",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 10], InsetBox[
       FrameBox["9",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 11], InsetBox[
       FrameBox["11",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 12], InsetBox[
       FrameBox["13",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 13]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{2.393494006535641, 2.209379082955976}, {
     1.104689541477988, 1.4729193886373175`}, {0.3682298471593293, 
     0.7364596943186588}, {3.6822984715932936`, 1.4729193886373175`}, {
     3.3140686244339643`, 0.7364596943186588}, {0., 0.}, {1.8411492357966468`,
      0.7364596943186588}, {1.4729193886373173`, 0.}, {2.9458387772746346`, 
     0.}, {4.050528318752622, 0.7364596943186588}, {0.7364596943186587, 0.}, {
     2.209379082955976, 0.}, {3.6822984715932936`, 0.}}]& ],
  AspectRatio->0.7385489458759964,
  FrameTicks->None,
  ImageSize->{237., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{241, 175},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->169173888]
}, Open  ]],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["TreePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TreePlot"]], "InlineFormula"],
 " places each tree root at the top. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TreePlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TreePlot"], "[", 
   RowBox[{
    StyleBox["g", "TI"], ",", 
    StyleBox["pos", "TI"]}], "]"}]], "InlineFormula"],
 " places the roots at position ",
 Cell[BoxData[
  StyleBox["pos", "TI"]], "InlineFormula"],
 ". Possible positions are: ",
 Cell[BoxData[
  ButtonBox["Top",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Top"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Bottom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Bottom"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Left",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Left"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Right",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Right"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["Center",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Center"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1944209325],

Cell["This plots the tree by placing the root left:", "MathCaption",
 CellID->3914516],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{"g", ",", "Left", ",", 
   RowBox[{"VertexLabeling", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->940161979],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 2.3934940065356387`}, {0.7364596943186601, 
    1.1046895414779865`}, {1.4729193886373197`, 0.3682298471593285}, {
    0.7364596943186573, 3.682298471593292}, {1.4729193886373164`, 
    3.3140686244339634`}, {2.2093790829559787`, 0.}, {1.4729193886373182`, 
    1.841149235796646}, {2.209379082955977, 1.4729193886373173`}, {
    2.2093790829559756`, 2.945838777274635}, {1.4729193886373158`, 
    4.0505283187526215`}, {2.2093790829559783`, 0.7364596943186587}, {
    2.2093790829559765`, 2.209379082955976}, {2.2093790829559747`, 
    3.682298471593294}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 4}, {2, 3}, {2, 7}, {3, 6}, {3, 11}, {4, 5}, {4, 
       10}, {5, 9}, {5, 13}, {7, 8}, {7, 12}}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["8",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7], InsetBox[
       FrameBox["10",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 8], InsetBox[
       FrameBox["12",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 9], InsetBox[
       FrameBox["7",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 10], InsetBox[
       FrameBox["9",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 11], InsetBox[
       FrameBox["11",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 12], InsetBox[
       FrameBox["13",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 13]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 2.3934940065356387`}, {0.7364596943186601, 
     1.1046895414779865`}, {1.4729193886373197`, 0.3682298471593285}, {
     0.7364596943186573, 3.682298471593292}, {1.4729193886373164`, 
     3.3140686244339634`}, {2.2093790829559787`, 0.}, {1.4729193886373182`, 
     1.841149235796646}, {2.209379082955977, 1.4729193886373173`}, {
     2.2093790829559756`, 2.945838777274635}, {1.4729193886373158`, 
     4.0505283187526215`}, {2.2093790829559783`, 0.7364596943186587}, {
     2.2093790829559765`, 2.209379082955976}, {2.2093790829559747`, 
     3.682298471593294}}]& ],
  AspectRatio->1.354006400772659,
  FrameTicks->None,
  ImageSize->{168.314595672555, Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{172, 228},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->69668883]
}, Open  ]],

Cell["This places the root at the center:", "MathCaption",
 CellID->1379814034],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{"g", ",", "Center", ",", 
   RowBox[{"VertexLabeling", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->642050927],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{2.0662202405139434`, 2.1193569439705566`}, {
    1.377480160314398, 1.9621565151837754`}, {0.961566919653819, 
    3.000288571424581}, {2.7549603207276046`, 2.276557372695493}, {
    3.443700400828341, 1.8049560860259288`}, {1.1466657252494599`, 
    4.02883157051392}, {1.4531838967756767`, 0.8463738597184076}, {
    0.40924025898645167`, 0.7979595030870916}, {3.7232002216854774`, 
    0.7979595026407351}, {2.679256584366514, 3.39234002816766}, {0., 
    2.5909582307019647`}, {2.066220240228486, 0.}, {4.1324404811549265`, 
    2.5909582301453664`}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 4}, {2, 3}, {2, 7}, {3, 6}, {3, 11}, {4, 5}, {4, 
       10}, {5, 9}, {5, 13}, {7, 8}, {7, 12}}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["8",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7], InsetBox[
       FrameBox["10",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 8], InsetBox[
       FrameBox["12",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 9], InsetBox[
       FrameBox["7",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 10], InsetBox[
       FrameBox["9",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 11], InsetBox[
       FrameBox["11",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 12], InsetBox[
       FrameBox["13",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 13]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{2.0662202405139434`, 2.1193569439705566`}, {
     1.377480160314398, 1.9621565151837754`}, {0.961566919653819, 
     3.000288571424581}, {2.7549603207276046`, 2.276557372695493}, {
     3.443700400828341, 1.8049560860259288`}, {1.1466657252494599`, 
     4.02883157051392}, {1.4531838967756767`, 0.8463738597184076}, {
     0.40924025898645167`, 0.7979595030870916}, {3.7232002216854774`, 
     0.7979595026407351}, {2.679256584366514, 3.39234002816766}, {0., 
     2.5909582307019647`}, {2.066220240228486, 0.}, {4.1324404811549265`, 
     2.5909582301453664`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{236., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{240, 230},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->367136693]
}, Open  ]],

Cell[CellGroupData[{

Cell["Options for TreePlot", "Section",
 CellTags->{"Options_for_GraphPlot", "b:0.1"},
 CellID->267311437],

Cell[TextData[{
 "In addition to options for ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 ", the following options are accepted for ",
 Cell[BoxData[
  ButtonBox["LayeredGraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LayeredGraphPlot"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.1",
 CellID->66806916],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    ButtonBox["DataRange",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DataRange"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the range of vertex coordinates to generate", "TableText"]},
   {
    ButtonBox["DirectedEdges",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DirectedEdges"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to show edges as directed arrows", "TableText"]},
   {
    ButtonBox["EdgeLabeling",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/EdgeLabeling"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to include labels given for edges", "TableText"]},
   {
    ButtonBox["EdgeRenderingFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/EdgeRenderingFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "function to give explicit graphics for edges", "TableText"]},
   {
    ButtonBox["LayerSizeFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/LayerSizeFunction"], 
    RowBox[{"1", "&"}], Cell[
    "the height to allow for each layer", "TableText"]},
   {
    ButtonBox["MultiedgeStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MultiedgeStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to draw multiple edges between vertices", "TableText"]},
   {
    ButtonBox["PackingMethod",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PackingMethod"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "method to use for packing components", "TableText"]},
   {
    ButtonBox["PlotRangePadding",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotRangePadding"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how much padding to put around the plot", "TableText"]},
   {
    ButtonBox["PlotStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "style in which objects are drawn", "TableText"]},
   {
    ButtonBox["SelfLoopStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SelfLoopStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to draw edges linking a vertex to itself", "TableText"]},
   {
    ButtonBox["VertexCoordinateRules",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/VertexCoordinateRules"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "rules for explicit vertex coordinates", "TableText"]},
   {
    ButtonBox["VertexLabeling",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/VertexLabeling"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether to show vertex names as labels", "TableText"]},
   {
    ButtonBox["VertexRenderingFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/VertexRenderingFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "function to give explicit graphics for vertices", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellTags->"b:0.1",
 CellID->183266322],

Cell[TextData[{
 "Options for ",
 Cell[BoxData[
  ButtonBox["TreePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TreePlot"]], "InlineFormula"],
 "."
}], "Caption",
 CellTags->"b:0.1",
 CellID->428527873],

Cell[CellGroupData[{

Cell["DirectedEdges", "Subsection",
 CellTags->"b:0.1",
 CellID->94783224],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["DirectedEdges",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DirectedEdges"]], "InlineFormula"],
 " specifies whether to draw edges as directed arrows. Possible values for \
this option are ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". The default value for this option is ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 "."
}], "Text",
 CellID->547537329],

Cell["\<\
This shows a graph with edges represented by arrows instead of lines:\
\>", "MathCaption",
 CellID->133602391],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "8"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "7"}], ",", 
     RowBox[{"4", "\[Rule]", "10"}], ",", 
     RowBox[{"5", "\[Rule]", "7"}], ",", 
     RowBox[{"5", "\[Rule]", "8"}], ",", 
     RowBox[{"6", "\[Rule]", "10"}], ",", 
     RowBox[{"7", "\[Rule]", "10"}], ",", 
     RowBox[{"8", "\[Rule]", "9"}]}], "}"}], ",", 
   RowBox[{"DirectedEdges", "\[Rule]", " ", "True"}], ",", 
   RowBox[{"VertexLabeling", " ", "\[Rule]", " ", "True"}]}], "]"}]], "Input",\

 CellLabel->"In[5]:=",
 CellID->531828830],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.6522281379716341`, 0.}, {2.0652851724645425`, 
    0.8261140689858171}, {0.41305703449290854`, 0.}, {0.41305703449290854`, 
    0.8261140689858171}, {0., 1.6522281379716341`}, {1.0326425862322712`, 
    2.478342206957451}, {0.8261140689858171, 1.6522281379716341`}, {
    2.0652851724645425`, 1.6522281379716341`}, {1.2391711034787256`, 
    0.8261140689858171}, {2.478342206957451, 0.}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.03125054593663268, 0.7}}], 
      ArrowBox[{1, 2}], ArrowBox[{2, 10}], ArrowBox[{3, 4}], ArrowBox[{4, 7}],
       ArrowBox[{5, 6}], ArrowBox[{6, 7}], ArrowBox[{8, 6}], ArrowBox[{8, 2}],
       ArrowBox[{9, 7}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["8",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["7",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["10",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 8], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 9], InsetBox[
       FrameBox["9",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 10]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.6522281379716341`, 0.}, {2.0652851724645425`,
      0.8261140689858171}, {0.41305703449290854`, 0.}, {0.41305703449290854`, 
     0.8261140689858171}, {0., 1.6522281379716341`}, {1.0326425862322712`, 
     2.478342206957451}, {0.8261140689858171, 1.6522281379716341`}, {
     2.0652851724645425`, 1.6522281379716341`}, {1.2391711034787256`, 
     0.8261140689858171}, {2.478342206957451, 0.}}]& ],
  AspectRatio->1.,
  FrameTicks->None,
  ImageSize->{178., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{182, 178},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->983120807]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["EdgeLabeling", "Subsection",
 CellTags->"b:0.1",
 CellID->78244718],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["EdgeLabeling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeLabeling"]], "InlineFormula"],
 " specifies whether and how to display labels given for the edges. Possible \
values for this option are ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", or ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ". The default value for this option is",
 " ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", which displays the supplied edge labels on the graph. With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EdgeLabeling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EdgeLabeling"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", the labels are shown as tooltips."
}], "Text",
 CellID->1357462998],

Cell["This displays the specified edge label:", "MathCaption",
 CellID->51376678],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "7"}], ",", 
     RowBox[{"2", "\[Rule]", "5"}], ",", 
     RowBox[{"2", "\[Rule]", "6"}], ",", 
     RowBox[{"3", "\[Rule]", "8"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"4", "\[Rule]", "7"}], ",", "\"\<edge {4,7}\>\""}], "}"}], ",",
      
     RowBox[{"7", "\[Rule]", "8"}], ",", 
     RowBox[{"7", "\[Rule]", "10"}], ",", 
     RowBox[{"9", "\[Rule]", "10"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", " ", "True"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->474488003],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{181, 181},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->432476563]
}, Open  ]],

Cell["\<\
This displays the edge label as a tooltip. Place the cursor over the edge \
between vertices 4 and 7 to see the tooltip:\
\>", "MathCaption",
 CellID->18324741],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "7"}], ",", 
     RowBox[{"2", "\[Rule]", "5"}], ",", 
     RowBox[{"2", "\[Rule]", "6"}], ",", 
     RowBox[{"3", "\[Rule]", "8"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"4", "\[Rule]", "7"}], ",", "\"\<edge {4,7}\>\""}], "}"}], ",",
      
     RowBox[{"7", "\[Rule]", "8"}], ",", 
     RowBox[{"7", "\[Rule]", "10"}], ",", 
     RowBox[{"9", "\[Rule]", "10"}]}], "}"}], ",", 
   RowBox[{"EdgeLabeling", "\[Rule]", " ", "Automatic"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", " ", "True"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->1364181943],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 0.8320502943378434}, {0.8320502943378437, 
    1.6641005886756872`}, {2.496150883013531, 0.8320502943378434}, {
    2.496150883013531, 1.6641005886756872`}, {2.496150883013531, 0.}, {
    0.8320502943378437, 0.}, {0.8320502943378437, 0.8320502943378434}, {
    1.6641005886756874`, 2.496150883013531}, {1.6641005886756874`, 
    0.8320502943378434}, {1.6641005886756874`, 0.}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{2, 7}], 
      LineBox[{2, 9}], LineBox[{3, 4}], LineBox[{3, 5}], LineBox[{6, 7}], 
      LineBox[{8, 4}], 
      TagBox[
       TooltipBox[LineBox[{8, 2}],
        "\"edge {4,7}\""],
       Annotation[#, "edge {4,7}", "Tooltip"]& ], LineBox[{10, 9}]}, {
      InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["7",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["8",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 8], InsetBox[
       FrameBox["10",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 9], InsetBox[
       FrameBox["9",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 10]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 0.8320502943378434}, {0.8320502943378437, 
     1.6641005886756872`}, {2.496150883013531, 0.8320502943378434}, {
     2.496150883013531, 1.6641005886756872`}, {2.496150883013531, 0.}, {
     0.8320502943378437, 0.}, {0.8320502943378437, 0.8320502943378434}, {
     1.6641005886756874`, 2.496150883013531}, {1.6641005886756874`, 
     0.8320502943378434}, {1.6641005886756874`, 0.}}]& ],
  AspectRatio->1.,
  FrameTicks->None,
  ImageSize->{188., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{192, 188},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->1320228845]
}, Open  ]],

Cell["\<\
This displays the labels as tooltips. Place the cursor over the edge between \
vertices 4 and 7 to see the tooltip:\
\>", "MathCaption",
 CellID->862272319],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "7"}], ",", 
     RowBox[{"2", "\[Rule]", "5"}], ",", 
     RowBox[{"2", "\[Rule]", "6"}], ",", 
     RowBox[{"3", "\[Rule]", "8"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"Tooltip", "[", 
      RowBox[{
       RowBox[{"4", "\[Rule]", "7"}], ",", "\"\<edge {4,7}\>\""}], "]"}], ",",
      
     RowBox[{"7", "\[Rule]", "8"}], ",", 
     RowBox[{"7", "\[Rule]", "10"}], ",", 
     RowBox[{"9", "\[Rule]", "10"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", " ", "True"}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->115157923],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 0.8320502943378434}, {0.8320502943378437, 
    1.6641005886756872`}, {2.496150883013531, 0.8320502943378434}, {
    2.496150883013531, 1.6641005886756872`}, {2.496150883013531, 0.}, {
    0.8320502943378437, 0.}, {0.8320502943378437, 0.8320502943378434}, {
    1.6641005886756874`, 2.496150883013531}, {1.6641005886756874`, 
    0.8320502943378434}, {1.6641005886756874`, 0.}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{2, 7}], 
      LineBox[{2, 9}], LineBox[{3, 4}], LineBox[{3, 5}], LineBox[{6, 7}], 
      LineBox[{8, 4}], 
      TagBox[
       TooltipBox[LineBox[{8, 2}],
        "\"edge {4,7}\""],
       Annotation[#, "edge {4,7}", "Tooltip"]& ], LineBox[{10, 9}]}, {
      InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["7",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["8",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 8], InsetBox[
       FrameBox["10",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 9], InsetBox[
       FrameBox["9",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 10]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 0.8320502943378434}, {0.8320502943378437, 
     1.6641005886756872`}, {2.496150883013531, 0.8320502943378434}, {
     2.496150883013531, 1.6641005886756872`}, {2.496150883013531, 0.}, {
     0.8320502943378437, 0.}, {0.8320502943378437, 0.8320502943378434}, {
     1.6641005886756874`, 2.496150883013531}, {1.6641005886756874`, 
     0.8320502943378434}, {1.6641005886756874`, 0.}}]& ],
  AspectRatio->1.,
  FrameTicks->None,
  ImageSize->{210., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{214, 210},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->1111678718]
}, Open  ]],

Cell["", "Text",
 CellID->350635805]
}, Open  ]],

Cell[CellGroupData[{

Cell["EdgeRenderingFunction", "Subsection",
 CellTags->"b:0.1",
 CellID->229062904],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["EdgeRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeRenderingFunction"]], "InlineFormula"],
 " specifies graphical representation of the graph edges. Possible values for \
this option are ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ", or a function that gives a proper combination of graphics primitives and \
directives. With the default setting of ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", a dark red line is drawn for each edge. With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EdgeRenderingFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EdgeRenderingFunction"], "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 ", edges are not drawn."
}], "Text",
 CellTags->"b:0.1",
 CellID->1564098284],

Cell["This draws vertices only:", "MathCaption",
 CellTags->"b:0.1",
 CellID->683565354],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", "10", "}"}], ",", 
     RowBox[{"{", "10", "}"}]}], "]"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", "None"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[9]:=",
 CellID->115400586],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWM1PE0EUX7rdmlguvXnkr9ET/4EaG0RAMGrhYKKGxEQ9GEg0eACjIXgh
QY3xoBciiQc92H9AAkRisfZD+rm73TbN+mam7czb7uyWWAqENu20M7/33rz3
++1X33B0Znz0RnRmYiQ6dCEWvTU+MTI9dP5mDJbUAUVR4vAZPqfAbxt+0U/c
tuF7kIyqXdeN5JKZfauEyaCa2TUz84ZAQYrDhCy1cDAGF+ZKhmrxm5F6LeCp
lzVjk+P1WlZPLgrxM6uV/U88vpFagXWO68kXNn01/MEYXER8EUJ2Hh/iifE1
2I/FZ45KxOF1VuCmXv1c2LpqZheI7wLJda6wPcVjF7bHYInjYFyvZnhu+u8H
5cQsx0u7sUpuneO18rviziTH9eSj0u59Hj//4yKscxzmiBt9b9YRf9rKbXDc
yi3DEsfBWN+bF7gj9Y228BCpb2uSbcFyizjycrADFrYdV8JkYPPbPHsAYYnj
dC6wY/x5bOVXOE7nXwR29PflX3c4TucPETs2OZSbuJMdv/gAwhLH6XwJsSPW
F2rVR9ihuUUcefXZ6bPTZ6d37ARgCMINTfNhidipYBfyYStIcXKHZNUHfdjD
ceUsgl880LKTs6k69td82MVx5SwHGnZnJGwHG3UEUDw/9sVslQ5U0BzVqV1W
wz2+XJUADcrtmxV0Tx/ZDnKlXGt2UUxrixzwqd5dQ3eOu6chPkOPUrvOjqb/
0U5tnEXaIWvmzpVcM3yV8NZKPJ9DJ06zg1wPXTI5Rpq5Vy7XDlcu1wzbeWvF
72xHeVb1XitZjt27Kh5Erfb7jfdzRru9XD1ZpSdbP8xu758Kg439/dTCdt5P
HWoH2nR69UN2kqdBgsuuFf1/KiJb/f9xfXYOhR1rva33SHtzzd7j1rW23qOV
5Lu39wZjlb8fOV4trxV3ruPe48+7iB3P3mM5cc+zt1nJvYIl1HssJ54gdsT6
WO9xgm3Bcos48hLZAeKM9DwxGKRWVn4DZWfll1H2YIzwmvHBzDxF7KKusl3/
aqYFds3ss2rpO2ensr+E4pvZ5yh+tbQKLgKenkNdc3l8tVkfhGzVp7HmNHlR
RyXi8GLcxE/ZeJmdCZtX4OCEtxImA5k3tLgkWMnP9uNihe/zftbuTyWn1UvW
YTsu2npZFbfH0PELc2TFjnVl4B9pD9uE\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{204, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[9]=",
 CellID->138982770]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EdgeRenderingFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EdgeRenderingFunction"], "->", 
   StyleBox["g", "TI"]}]], "InlineFormula"],
 ", each edge is rendered with the graphics primitives and directives given \
by given by the function ",
 Cell[BoxData[
  FormBox["g", TraditionalForm]], "InlineMath"],
 " that can take three or more arguments, in the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["g", "TI"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["i", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["j", "TI"]]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["i", "TI"]], ",", 
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["j", "TI"]]}], "}"}], ",", 
    SubscriptBox[
     StyleBox["lbl", "TI"], 
     StyleBox["ij", "TI"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["r", "TI"], 
    StyleBox["i", "TI"]], ",", 
   SubscriptBox[
    StyleBox["r", "TI"], 
    StyleBox["j", "TI"]]}]], "InlineFormula"],
 " are the coordinates of the beginning and ending points of the edge, ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["v", "TI"], 
    StyleBox["i", "TI"]], ",", 
   SubscriptBox[
    StyleBox["v", "TI"], 
    StyleBox["j", "TI"]]}]], "InlineFormula"],
 " are the beginning and ending vertices, and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["lbl", "TI"], 
   StyleBox["ij", "TI"]]], "InlineFormula"],
 " is any label specified for the edge or ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ". Explicit settings for ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EdgeRenderingFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EdgeRenderingFunction"], "->", 
   StyleBox["g", "TI"]}]], "InlineFormula"],
 " override settings for ",
 Cell[BoxData[
  ButtonBox["EdgeLabeling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeLabeling"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["DirectedEdges",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DirectedEdges"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.1",
 CellID->270347621],

Cell["\<\
This plots edges as gray arrows with ends set back from vertices by a \
distance 0.3 (in the graphs's coordinate system):\
\>", "MathCaption",
 CellTags->"b:0.1",
 CellID->22126029],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "5"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "6"}], ",", 
     RowBox[{"3", "\[Rule]", "9"}], ",", 
     RowBox[{"4", "\[Rule]", "8"}], ",", 
     RowBox[{"4", "\[Rule]", "10"}], ",", 
     RowBox[{"6", "\[Rule]", "7"}], ",", 
     RowBox[{"8", "\[Rule]", "9"}]}], "}"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0.5", "]"}], ",", " ", 
        RowBox[{"Arrow", "[", 
         RowBox[{"#1", ",", "0.3"}], "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[10]:=",
 CellID->445960829],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{{
      {GrayLevel[0.5], 
       ArrowBox[{{0., 1.6641005886756874`}, {0.8320502943378437, 
        2.4961508830135313`}}, 0.3]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{0., 1.6641005886756874`}, {0., 0.832050294337844}}, 0.3]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{0.8320502943378437, 2.4961508830135313`}, {
        1.6641005886756874`, 3.328201177351375}}, 0.3]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{0.8320502943378437, 2.4961508830135313`}, {
        1.6641005886756874`, 1.6641005886756874`}}, 0.3]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{0.8320502943378437, 1.6641005886756874`}, {
        0.8320502943378437, 2.4961508830135313`}}, 0.3]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{2.496150883013531, 1.6641005886756874`}, {2.496150883013531,
         0.832050294337844}}, 0.3]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{2.496150883013531, 1.6641005886756874`}, {2.496150883013531,
         2.4961508830135313`}}, 0.3]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{2.496150883013531, 0.832050294337844}, {2.496150883013531, 
        0.}}, 0.3]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{1.6641005886756874`, 3.328201177351375}, {2.496150883013531,
         2.4961508830135313`}}, 0.3]}}, 
     GraphicsComplexBox[{{0., 1.6641005886756874`}, {0.8320502943378437, 
      2.4961508830135313`}, {0., 0.832050294337844}, {0.8320502943378437, 
      1.6641005886756874`}, {2.496150883013531, 1.6641005886756874`}, {
      2.496150883013531, 0.832050294337844}, {2.496150883013531, 
      2.4961508830135313`}, {1.6641005886756874`, 3.328201177351375}, {
      1.6641005886756874`, 1.6641005886756874`}, {2.496150883013531, 0.}}, 
      {RGBColor[0, 0, 0.7], 
       TagBox[
        TooltipBox[PointBox[1],
         "1"],
        Annotation[#, 1, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[2],
         "4"],
        Annotation[#, 4, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[3],
         "5"],
        Annotation[#, 5, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[4],
         "2"],
        Annotation[#, 2, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[5],
         "3"],
        Annotation[#, 3, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[6],
         "6"],
        Annotation[#, 6, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[7],
         "9"],
        Annotation[#, 9, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[8],
         "8"],
        Annotation[#, 8, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[9],
         "10"],
        Annotation[#, 10, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[10],
         "7"],
        Annotation[#, 7, "Tooltip"]& ]}]},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 1.6641005886756874`}, {0.8320502943378437, 
     2.4961508830135313`}, {0., 0.832050294337844}, {0.8320502943378437, 
     1.6641005886756874`}, {2.496150883013531, 1.6641005886756874`}, {
     2.496150883013531, 0.832050294337844}, {2.496150883013531, 
     2.4961508830135313`}, {1.6641005886756874`, 3.328201177351375}, {
     1.6641005886756874`, 1.6641005886756874`}, {2.496150883013531, 0.}}]& ],
  AspectRatio->1.1547005383792517`,
  FrameTicks->None,
  ImageMargins->{{0., 0.}, {0., 0.}},
  ImageSize->{170., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{174, 196},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[10]=",
 CellID->16421984]
}, Open  ]],

Cell[TextData[{
 "This displays edges and self-loops with black and red arrows, respectively. \
The function ",
 Cell[BoxData[
  ButtonBox["LineScaledCoordinate",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/LineScaledCoordinate"]], 
  "InlineFormula"],
 " from the ",
 ButtonBox["Graph Utilities Package",
  BaseStyle->"Link",
  ButtonData->"paclet:GraphUtilities/guide/GraphUtilitiesPackage"],
 " adds text at 50% along arrows:"
}], "MathCaption",
 CellID->425797646],

Cell[BoxData[
 RowBox[{"<<", "GraphUtilities`"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->493887946],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "1"}], ",", 
     RowBox[{"1", "\[Rule]", "5"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "6"}], ",", 
     RowBox[{"3", "\[Rule]", "9"}], ",", 
     RowBox[{"4", "\[Rule]", "8"}], ",", 
     RowBox[{"4", "\[Rule]", "10"}], ",", 
     RowBox[{"6", "\[Rule]", "7"}], ",", 
     RowBox[{"8", "\[Rule]", "9"}]}], "}"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"First", "[", "#2", "]"}], "===", 
           RowBox[{"Last", "[", "#2", "]"}]}], ",", "Red", ",", "Black"}], 
         "]"}], ",", 
        RowBox[{"Arrow", "[", 
         RowBox[{"#1", ",", ".1"}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{"#2", ",", 
          RowBox[{"LineScaledCoordinate", "[", 
           RowBox[{"#1", ",", ".5"}], "]"}], ",", 
          RowBox[{"Background", "\[Rule]", "White"}]}], "]"}]}], "}"}], "&"}],
      ")"}]}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->300897750],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{274, 290},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->136575750]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["LayerSizeFunction", "Subsection",
 CellTags->"b:0.1",
 CellID->1356851380],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["LayerSizeFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LayerSizeFunction"]], "InlineFormula"],
 " option specifies the relative height to allow for each layer. By default \
the height is 1. Possible values include a function that gives real machine \
numbers."
}], "Text",
 CellID->1589570377],

Cell["This defines and plots a tree:", "MathCaption",
 CellID->868771299],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "6"}], ",", 
     RowBox[{"2", "\[Rule]", "7"}], ",", 
     RowBox[{"2", "\[Rule]", "8"}], ",", 
     RowBox[{"3", "\[Rule]", "8"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->1981454907],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", "g", "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->953185233],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.8017704658458034`, 0.}, {1.8017704658458034`, 
    0.9008852329229013}, {0.45044261646145084`, 1.8017704658458031`}, {
    1.126106541153627, 2.7026556987687047`}, {0., 0.9008852329229013}, {
    0.9008852329229017, 0.9008852329229013}, {0.9008852329229017, 0.}, {
    1.8017704658458034`, 1.8017704658458031`}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {2, 8}, {3, 4}, {3, 5}, {3, 6}, {7, 6}, {8, 4}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "5"],
       Annotation[#, 5, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.8017704658458034`, 0.}, {1.8017704658458034`,
      0.9008852329229013}, {0.45044261646145084`, 1.8017704658458031`}, {
     1.126106541153627, 2.7026556987687047`}, {0., 0.9008852329229013}, {
     0.9008852329229017, 0.9008852329229013}, {0.9008852329229017, 0.}, {
     1.8017704658458034`, 1.8017704658458031`}}]& ],
  AspectRatio->1.224744871391589,
  FrameTicks->None,
  ImageSize->{152.91002637985, Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{157, 187},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->857613928]
}, Open  ]],

Cell["\<\
This plots the same tree, with the first layer a relative height of 1, the \
second 2, and the third 3:\
\>", "MathCaption",
 CellID->548018285],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"LayerSizeFunction", "\[Rule]", " ", 
    RowBox[{"(", 
     RowBox[{"#", "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->911519381],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.9125315088515246, 0.}, {0.9125315088515246, 
    1.368797263277287}, {0.22813287721288114`, 2.2813287721288114`}, {
    0.5703321930322028, 2.737594526554574}, {0., 1.368797263277287}, {
    0.4562657544257623, 1.368797263277287}, {0.4562657544257623, 0.}, {
    0.9125315088515246, 2.2813287721288114`}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {2, 8}, {3, 4}, {3, 5}, {3, 6}, {7, 6}, {8, 4}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "5"],
       Annotation[#, 5, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.9125315088515246, 0.}, {0.9125315088515246, 
     1.368797263277287}, {0.22813287721288114`, 2.2813287721288114`}, {
     0.5703321930322028, 2.737594526554574}, {0., 1.368797263277287}, {
     0.4562657544257623, 1.368797263277287}, {0.4562657544257623, 0.}, {
     0.9125315088515246, 2.2813287721288114`}}]& ],
  AspectRatio->1.7320508075688772`,
  FrameTicks->None,
  ImageSize->{131.837966020729, Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{136, 228},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->360583481]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MultiedgeStyle", "Subsection",
 CellTags->"b:0.1",
 CellID->82725606],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["MultiedgeStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MultiedgeStyle"]], "InlineFormula"],
 " specifies whether to draw multiple edges between two vertices. Possible \
values for ",
 Cell[BoxData[
  ButtonBox["MultiedgeStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MultiedgeStyle"]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " (the default), ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", or a positive real number. With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MultiedgeStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MultiedgeStyle"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", multiple edges are shown for a graph specified by a list of rules, but \
not shown if specified by an adjacency matrix. With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MultiedgeStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MultiedgeStyle"], "->", 
   StyleBox["\[Delta]", "TR"]}]], "InlineFormula"],
 ", the multiedges are spread out to a scaled distance of ",
 Cell[BoxData[
  FormBox[Cell[TextData[Cell[BoxData[
    StyleBox["\[Delta]", "TR"]], "InlineFormula"]], "InlineFormula"], 
   TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellTags->"b:0.1",
 CellID->904561043],

Cell["\<\
By default, multiple edges are shown if a graph is given as a list of rules:\
\>", "MathCaption",
 CellTags->"b:0.1",
 CellID->239623524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "1"}], ",", 
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "5"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", " ", "6"}], ",", 
     RowBox[{"5", "\[Rule]", "1"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->228833091],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmltsVEUYxw/d7ba72wu9sb1tu9vtFSUgBCwRaCUqjcaExBdI1FIJpEQJ
taJpIpEHNTU8iCYYDDHBGJP6ICmJGpCINWLSB0wK0VgooQVraIMPvSxQy61+
M9/hnLP/M7t7lBY02tDpzJn5/vP7z9mdW3i6ZWfrlu0tO7dtbgmta29pa922
+ZXQEzva6ZFrnqZpe8RvoUb5GcrJ3z0zM/Q3ceoRqSt6cdf42Wfpn+YXiWvi
3OZb0yOiqlrWT55/Ceq3zsgfrUrW3745PnHuBVGVIeujFzr0+lRLL1eGO25c
PTwz86PmFwmXfzF7oVB6btbLsqWXW9e/nRx80ayX5ZdFlef/Xv5FvaRQ4tLk
84S9uWW9+CRby/F7d1GSYugmo0gFddcs06TIRmZ7Te9xtrlEP25DffZ5Ykc1
Mccdbs1oP/s86vcQnyuWPzGPa84+PU4pXKDrbExs36jv3mieGhu768+wW6d2
RiG//W4q9x96d19t7bkjR6rmbpby8FhHR0Y+bWo6vGkT2Y3MXW9pxpuln76D
B9meVjGLPUaHtsessZMDzbf+uCiqUkTitjoNyQhapWNX5YFNMf3evt4zMdBs
WZUH2/R6c1XOJiLu33RVrj+v0f+my9aZstVQT8/HjY0im2GjqpMtRvr6Plyy
RGQXyjIV6JHI5ih1sqB3Vvls/fr+7m6RrZVlKtAjkc1VqmTbaGqAphZo1Do5
QFMDNNVAk6dUybXRVAFNNdCodfKBpgpoKoEmX6lSYKOJAE0l0Kh1AkATAZoK
oClQqhTaaMJAUwE0ap1ioAkDTQhoFihVSmw05UATAhq1TlDxHbLSlAFNQKlS
ZqMJAk0Z0Kh1QkATBJpSoClUqoRtNCVAUwo0ap0I0JQATTHQFClVKm00RUBT
DDRqnWqgKQKaQqApVqrU2GgCQFMINGqdOqAJAM0CoClRqiy00RQAzQKgUes8
CDQFQJMPNKVKlUU2mjygyQcatc5ioMkDmlygCSpVlthocoAmF2jUOkuBJgdo
5gNNmVJlmY0mG2jmA41aZznQZANNFtCUK1VW2GgygSYLaNQ69UCTCTQZQBNS
qqy00fiBJgNo1DqPAI0faHxAE1aqrLLReIHGBzRqnTVA4wWadKCpUKo02GjS
gCYdaNQ6jwJNGtB4gCaiVFlro0kFGg/QsA4/nYSd7sTA8zeunRFVq0WSatBR
6crw61rmnVbTY8fMcU52dyHHPdVgvDbaOT3+ifgEUStZ+N65VuOdUbsrFR57
ljDr741K7C1BfLXYk2QyVetpVXOgrj41J+sl2Yl/dnpJdqK/P73E3hs4ecuq
O5XE+vb7BifvXXUnhOqx9wf3+PtyrP2ZG1NTd6Mi7jLOf32AJhCa4Rr/vk4q
lU9+8BrPn+JepuEvaEWHO6yzpWd8oPnojo0/dXXRzMpyvMJcvfT2+BnrrHr2
uesTvaaa3K/4aD58LxQaPXWKpmYKJYHh3l5S+qi+ngZrNczzcgfG+yPv0ba2
3r17T3R2ftPRMTY0RAGkRZM0jQ6vlS4qkyqlvOcyT8HUI4mTZgpJa26KoCKJ
kSSv1VRFNSLLkXKn5zP6YtaT+/d/2dpKNZRSXuwWUnp2715qRvhJltr+3t9P
UzXN+fSMUsrTc+pUdP4wOORouR/1sxnKfr5hA42vIWb6Wg4+5W6Od8k+DiJO
qiNmiqMMaXBfy8GnJdJr6NGroBYUY+BrwuEy3anU4J2831iheRgNp5ThTrSH
wClHy/OFn98lZXnhVzhdDE5XWKL5XRJsPLN6tOmWo+WJyGu8zzhuF+lu5Z6S
T2cO3D4Abjm62KHbOnC70hKd3G0duOXoEkdua3S38nvA5yAHbqvALUcHHbqN
gNtVlujkbiPglqPLHLkN627ljMVnCQduy8EtR4ccug2C2wZLdHK3QXDL0WFH
bkt0t3IF4v24A7dF4JajIw7dBsDtWkt0crcBcMvRlY7cFuhuH5MxVQ7d5oFb
jq5O6JZI6Hwg1vYccPu4JTqBW6bRo023HC1vdvwJ3PKhRp64hd91MkreLvsM
H8Zaxeh8LsoCrxwpZw+fMUC8uBmWuJgBPptkpLz18XELwy0PubHo+sEjR8rZ
0ssrlqHKr4YHXZ5thbsnzfY+kiNpWiV5TKKjo/QaRk+f5p7SwR1HyhslL9NR
5NnuA8c7Ng58sY/SE29t+bnrHS2Ndnt0Jhz+4auta4S3p2Qc3yHxuk27p+iF
HRn0h9oNbpseO27q80oTfyf1T2nl0s9VuBNWt1afeP6rUfHOQPf53V56c+ry
+7TNp6mGEteV33YpWk1d3hv99VXx0fXLz2/0QvvNqUGzVeL/naPN+xPHDBnl
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{138, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->613057183]
}, Open  ]],

Cell["\<\
But multiple edges are not shown for graphs specified by an adjacency matrix:\
\
\>", "MathCaption",
 CellTags->"b:0.1",
 CellID->1229163597],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0", "3", "0", "0", "0", "0"},
      {"1", "0", "1", "0", "0", "0"},
      {"0", "0", "0", "0", "1", "0"},
      {"0", "0", "0", "0", "1", "0"},
      {"1", "0", "0", "0", "0", "1"},
      {"0", "0", "0", "0", "0", "0"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.28], {
          Offset[0.7]}, 
         Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], ")"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->122898338],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.5846128222154678, 1.558967525907914}, {0., 
    0.779483762953957}, {0., 0.}, {0.779483762953957, 0.}, {
    1.1692256444309357`, 0.779483762953957}, {1.558967525907914, 0.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {2, 1}, {2, 3}, {3, 5}, {4, 5}, {5, 1}, {5, 6}}]}, {
      InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.5846128222154678, 1.558967525907914}, {0., 
     0.779483762953957}, {0., 0.}, {0.779483762953957, 0.}, {
     1.1692256444309357`, 0.779483762953957}, {1.558967525907914, 0.}}]& ],
  AspectRatio->1.,
  FrameTicks->None,
  ImageSize->{152., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{156, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->2122066940]
}, Open  ]],

Cell["This spreads multiple edges by the specified amount:", "MathCaption",
 CellTags->"b:0.1",
 CellID->585581490],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "1"}], ",", 
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "5"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", " ", "6"}], ",", 
     RowBox[{"5", "\[Rule]", "1"}]}], "}"}], ",", 
   RowBox[{"MultiedgeStyle", "\[Rule]", "0.25"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->196326928],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmntsFEUcx5fu3bXQQqmlL2hpaWlpLeWhIAgiKIj4QPEVXyGhEpJWJbxU
+ocETZRqNOFhE0VFjBrFqEB8pCjGJmhsjJpq+INEoC20UMpVCtfeXR+U8zcz
ezt73x161+PwH21g2d2Z+c5nvjM7jx9dWv5MxarV5c9UrizPu319+dqKypUb
8havWU+v9GGapu1kfzM1ug/QHf+7MxCgfyO5xrOrPtDf4T1d4+/4QktkF93v
3uN3f8qSJvP0ft9f3radMt3X/mHPuVqZ3uep97XvsqbvolcsKd5SS793v6fp
aX9HDctVo+neti1dJzZJld7O97tObJDp3a2bvad3yHS/e1tXS5VMZw/uPYpa
uluqAoHftER2Ec8vW2o5/4HvTLVM589vB9PjSDmJv6cbasv/6kNXj6OLTsPQ
FaYWB09n4zXwm3y218rex5l64Wp3gqoeIwqu45D5NKOmWPMw9xymeuw49BAX
B68/yKuZ+WPHofb78jyh3GoO/aqNjnC1Y2si88D2hTQfXO7v7Ix6bDoNyshq
51+3g57P/Lq6prj4aG1taexnF5fwtKut7aMlS/avWEHNK4l9LfFmz9FPw+7d
ojlacQxq6uv+zNP4ZOhq1VzFkuLYxWFtWREv0fP3zq4T60PWr+7W1+So8rW/
iuuXr/09rJeQ/O43WIYknquv+w/RPJZEF9nKQvFy4Oce9w6p6u/YcdHXKGsd
6K/zu7db0t3babmXtSbzXO8vWNBUV8duE22tm8ZzvDVtWltDA7udyp8px7a8
vH6/X0tV6owEWlHqyL59e5YtkyoH1q6t37qV3apVRtlopgBNGdCMUeqMBpoy
oCkDGrVKio1mMtCUAk2aUicVaEqBphRo1CpjbDTXAk0J0KQrddKBpgRoSoBG
rZJhoykGmklAk6HUyQKaSUAzCWjUKmMv841KmkKgyVTqZCu/OUlTCDRqlRwb
zUSgKQCaLKVOLtAUAE0B0KhV8mw0+UAzAWjGKnXygWYC0EwAGrVKgY0mD2hy
gWacUqcQaHKBJhdo1CpFNprxQJMDNNlKnWKgyQGaHKBRq5TYaLKBZhzQ5Ch1
SoFmHNCMAxq1ymQbzVigyQKa8UqdKUCTBTRZQKNWmWqjyQSaDKDJVepMB5oM
oMkAGrXKdTaadKBJA5o8pc4MoEkDmjSgUavMtNGMAZpUoJmg1JkFNKlAkwo0
apXZNpprgCYFaPKVOnOAJgVoUoBGrTLXRjMaaJKBpkCpMw9okoEmGWjUKjfb
aEYBzUigmajUWQA0I4FmJNCoVW6x0SQBTSLQFCp1FgJNItAkAo1aZZGNZgTQ
DAeaIqXOYqAZDjTDgUatcruNJgFo4oFmklLnDqCJB5p4oFGr3GmjcQGNE2j4
ihSM9/W2dTVtpIOT5mQX/dhXD3UcfpbfisvJF72na1Te8bMPFarubnmJsp5t
WNdY+6jm4lIn68pP11eyQ1/TxsClPsNH89xGZyO6aonsovece4cqMX11WVvi
OV7Zd+HjJJ7Pc7xioM8tx0i4SBZ31yF4PY1PDfT9IM54/H4IOncG3RMiWnQq
d/F0ISHT/x2V0DjS5dVCYxHhVHWIDoVTV8dbwtUSLkYUm1rCxYKuci3NB5ez
LwprCY04RdLLiiicS0R36JOir//H6moayEsU9dgjV5H0v0mXYHrV2dT0fVUV
1UVfMNW1GOoKRnAjq8Mc/+2/r2FJYs6hOYw+a6qCKmLz2aIr+7aavn2cJlhG
RvMF6ZFJNGW01NcvjF7XIfygubtu82Yx/5Ix786ezWq6dSi63Xs9x1aRtJbI
LnpX83o2pzIvSNkVXCG+rqhgt2LtZwVOPifLXDj6xKX+86hMlfZ797KpVcyv
tBIE+I9F+dc336RuZLfz+fPFngOUV87d/b4vjTJCme+fXObKQz/innurkxT1
m1yR6MFQnxd0iLKz6OcMixothrQkCjX6Smggi9Lme0ONuo3GA7udK5zz+2mR
pG4Ue2Aj7kNGUaPMsWRR0aGUcODzRx45/Mkn7HZO0GtjNbaqypYIVfeRI9QS
NjYdwdWD+p7aZ7BSCqVTLu1G/izX/BssqmQc5ZJs1DxqJB+mwXRSZbU4odZZ
4Cd/NnbFr2dmEo5kpfw03CWbbAs+zwSHZltUZd/q0CIn+O6E/DPAV6uq6G/Z
YlnKASzo6/VAwX3WrgEHBCs5RKWkA9I39HU6pM+xqBI+NUKy0faM2GSL0RHp
61Roy1yLKr2liY5weamQb97wC/2cAulCLRXqFKXkLjKcnxglvYmrirMkDUIq
IlWIlkoFmQfzsxTS51lUZS7nEP0sgbbwk5VxXpa9FKmfxZAu1NKVc1DkfmIs
c75FFcdj5H4WQjq3y4hbEAWxRONnAbSFnw1FfDMKP/MhXahlXaGfGHG81aIa
vZ+5kM53BCJ6eQV+5kBb+P7FiLwN3c9sSBdq2VfoJ8YFb7OoRu9nFqTz3aHh
R/R+ZkBb+DlSxAqj8DMd0oVabrR+GmsrRu+WWFSH6qd0JhXS+ZlXRAKH7Kdc
oVOgLfwEbHxh4f001wAj2oCxOKGWH6mftLjQPsdIlyoYY7vLohrOT8XuzGAd
BX7ezVULIvKTzDN24bhXSQI/l3LViYP6Sdse2vzwW6gtCZwQaoVKP6UKtlQ8
vzJ6NDWT3Y4AP++xqKKf+CzboAPFcPDzXq5apPQTe0X2vQ61JICfHNhYUUP9
tO8g5XMc+JoAvgrVYvg2lH0dckYhj2mDmQB+3mdRI3J6y078LqPPzf28sd8X
bC+wE3lA1ip9vJ+rmfsc0c3GiUWy6jY26nwSMecmw78HuNq1wb4VBQw1OYo5
k8scQfQk9n34ZQo1vrNziJZSGt2Y82zroee6mp/X4kIjhce/edj95wbNwaOO
ZxvWnfrpsb4L9dqDXK0s2LfUfuoxww/fmS3+s9vladR7alPv+UOSge+EHTSu
qJ2EQS3XjXLVvec/kCdv/mwpx7sgnjygltL5T5xlRSEj+ocl+P/5OOmgSHz0
Z9C8M4J9PWiumUAa/N0mZ0S51VGz/2qp0DhauNzqMRH7XN7WTZ7mNTJK42ms
7O38DnMFLv0SEnG56PvKmBNErkh+s1cb9g/558o+\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{153, 153},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->288826290]
}, Open  ]],

Cell[CellGroupData[{

Cell["PackingMethod", "Subsubsection",
 CellTags->"b:0.1",
 CellID->1079530539],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["PackingMethod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PackingMethod"]], "InlineFormula"],
 " specifies method used for packing disconnected components. Possible values \
for the option are ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " (the default), \"ClosestPacking\", \"ClosestPackingCenter\", \"Layered\", \
\"LayeredLeft\", \"LayeredTop\", and \"NestedGrid\". With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PackingMethod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PackingMethod"], "->", 
   "\"\<ClosestPacking\>\""}]], "InlineFormula"],
 ", components are packed as close together as possible using a polyomino \
method [6], starting from the top left. With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PackingMethod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PackingMethod"], "->", 
   "\"\<ClosestPackingCenter\>\""}]], "InlineFormula"],
 ", components are packed starting from the center. With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PackingMethod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PackingMethod"], "->", "\"\<Layered\>\""}]], 
  "InlineFormula"],
 ", components are packed in layers starting from top left. With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PackingMethod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PackingMethod"], "->", "\"\<LayeredLeft\>\""}]], 
  "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PackingMethod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PackingMethod"], "->", "\"\<LayeredTop\>\""}]], 
  "InlineFormula"],
 ", components are packed in layers starting from the top/left respectively. \
With",
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PackingMethod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PackingMethod"], "->", "\"\<NestedGrid\>\""}]], 
  "InlineFormula"],
 ", components are arranged in a nested grid. The typical effective default \
setting is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PackingMethod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PackingMethod"], "->", "\"\<Layered\>\""}]], 
  "InlineFormula"],
 ", and the packing starts with components of the largest bounding box area."
}], "Text",
 CellID->1733232121],

Cell["\<\
This shows the packing of disconnected components by the default method:\
\>", "MathCaption",
 CellTags->"b:0.1",
 CellID->792188815],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"i", "\[Rule]", 
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{"i", "^", "3"}], ",", "221"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "221"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[19]:=",
 CellID->1585754271],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{173, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->721335210]
}, Open  ]],

Cell[TextData[{
 "This shows the packing of disconnected components using the ",
 Cell[BoxData["\"\<ClosestPackingCenter\>\""], "InlineFormula"],
 " method:"
}], "MathCaption",
 CellTags->"b:0.1",
 CellID->134849000],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"i", "\[Rule]", 
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{"i", "^", "3"}], ",", "221"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "221"}], "}"}]}], "]"}], ",", 
   RowBox[{"PackingMethod", "\[Rule]", "\"\<ClosestPackingCenter\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[20]:=",
 CellID->439127616],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{165, 169},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->40990409]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["PlotRangePadding", "Subsection",
 CellTags->"b:0.1",
 CellID->9543384],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotRangePadding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRangePadding"]], "InlineFormula"],
 " is a common option for graphics functions inherited by ",
 Cell[BoxData[
  ButtonBox["TreePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TreePlot"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1145219532]
}, Open  ]],

Cell[CellGroupData[{

Cell["PlotStyle", "Subsection",
 CellTags->"b:0.1",
 CellID->43937672],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " is a common option for graphics functions inherited by ",
 Cell[BoxData[
  ButtonBox["TreePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TreePlot"]], "InlineFormula"],
 ". The option ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " specifies the style in which objects are drawn."
}], "Text",
 CellTags->"b:0.1",
 CellID->680585317],

Cell["\<\
Draw edges with thicker lines, and both edges and vertices labels in red:\
\>", "MathCaption",
 CellTags->"b:0.1",
 CellID->52453719],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "1"}], ",", 
     RowBox[{"6", "\[Rule]", "5"}], ",", 
     RowBox[{"7", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "4"}], ",", 
     RowBox[{"9", "\[Rule]", "8"}], ",", 
     RowBox[{"10", "\[Rule]", "8"}], ",", 
     RowBox[{"8", "\[Rule]", "3"}], ",", 
     RowBox[{"12", "\[Rule]", "11"}], ",", 
     RowBox[{"13", "\[Rule]", "11"}], ",", 
     RowBox[{"11", "\[Rule]", "1"}], ",", 
     RowBox[{"15", "\[Rule]", "14"}], ",", 
     RowBox[{"16", "\[Rule]", "14"}], ",", 
     RowBox[{"14", "\[Rule]", "2"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"Thickness", "[", "0.02", "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[21]:=",
 CellID->793185],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{2.113587927127463, 2.504993098817734}, {
    0.7828103433805419, 1.8787448241133005`}, {0.3131241373522167, 
    1.252496549408867}, {2.504993098817734, 1.8787448241133005`}, {
    2.1918689614655174`, 0.6262482747044333}, {2.504993098817734, 
    1.252496549408867}, {2.8181172361699507`, 0.6262482747044333}, {0., 0.}, {
    0.3131241373522167, 0.6262482747044333}, {0.6262482747044334, 0.}, {
    3.1312413735221676`, 1.252496549408867}, {3.444365510874384, 
    1.8787448241133005`}, {3.757489648226601, 1.252496549408867}, {
    0.9393724120566502, 0.6262482747044333}, {1.252496549408867, 
    1.252496549408867}, {1.5656206867610838`, 0.6262482747044333}}, {
     {RGBColor[1, 0, 0], Thickness[0.02], 
      LineBox[{{1, 2}, {2, 3}, {3, 4}, {4, 1}, {5, 6}, {6, 4}, {7, 6}, {8, 
       9}, {9, 3}, {10, 9}, {11, 12}, {12, 1}, {13, 12}, {14, 15}, {15, 2}, {
       16, 15}}]}, 
     {RGBColor[1, 0, 0], Thickness[0.02], InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["7",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7], InsetBox[
       FrameBox["9",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 8], InsetBox[
       FrameBox["8",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 9], InsetBox[
       FrameBox["10",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 10], InsetBox[
       FrameBox["12",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 11], InsetBox[
       FrameBox["11",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 12], InsetBox[
       FrameBox["13",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 13], InsetBox[
       FrameBox["15",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 14], InsetBox[
       FrameBox["14",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 15], InsetBox[
       FrameBox["16",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 16]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{2.113587927127463, 2.504993098817734}, {
     0.7828103433805419, 1.8787448241133005`}, {0.3131241373522167, 
     1.252496549408867}, {2.504993098817734, 1.8787448241133005`}, {
     2.1918689614655174`, 0.6262482747044333}, {2.504993098817734, 
     1.252496549408867}, {2.8181172361699507`, 0.6262482747044333}, {0., 
     0.}, {0.3131241373522167, 0.6262482747044333}, {0.6262482747044334, 
     0.}, {3.1312413735221676`, 1.252496549408867}, {3.444365510874384, 
     1.8787448241133005`}, {3.757489648226601, 1.252496549408867}, {
     0.9393724120566502, 0.6262482747044333}, {1.252496549408867, 
     1.252496549408867}, {1.5656206867610838`, 0.6262482747044333}}]& ],
  AspectRatio->0.816496580927726,
  FrameTicks->None,
  ImageMargins->{{0., 0.}, {0., 0.}},
  ImageSize->{214., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{218, 175},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[21]=",
 CellID->418253517]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SelfLoopStyle", "Subsection",
 CellTags->"b:0.1",
 CellID->84930587],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["SelfLoopStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SelfLoopStyle"]], "InlineFormula"],
 " specifies whether and how to draw loops for vertices that are linked to \
themselves. Possible values of the option are ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " (the default), ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", or a positive real number. With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SelfLoopStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SelfLoopStyle"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", self-loops are shown if the graph is specified by a list of rules, but \
not by an adjacency matrix. With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SelfLoopStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SelfLoopStyle"], "->", 
   StyleBox["\[Delta]", "TR"]}]], "InlineFormula"],
 ", the self-loops are drawn with a diameter of ",
 Cell[BoxData[
  StyleBox["\[Delta]", "TR"]], "InlineFormula"],
 " (relative to the average edge length). "
}], "Text",
 CellID->988897229],

Cell["\<\
By default, self-loops are displayed for a graph specified by a list of \
rules:\
\>", "MathCaption",
 CellTags->"b:0.1",
 CellID->1974872317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "5"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"2", "\[Rule]", "5"}], ",", 
     RowBox[{"2", "\[Rule]", "6"}], ",", 
     RowBox[{"2", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "2"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->3675425],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{179, 176},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]=",
 CellID->59536649]
}, Open  ]],

Cell["\<\
Self-loops are not shown if the graph is specified by an adjacency matrix:\
\>", "MathCaption",
 CellTags->"b:0.1",
 CellID->1548899949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   TagBox[
    TagBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"0", "1", "1", "0", "0", "0"},
        {"0", "0", "0", "0", "0", "0"},
        {"0", "0", "0", "0", "0", "0"},
        {"0", "0", "1", "2", "1", "1"},
        {"0", "0", "0", "0", "0", "0"},
        {"0", "0", "0", "0", "0", "0"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.28], {
            Offset[0.7]}, 
           Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->404337916],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 0.8687444855261387}, {0., 0.}, {
    0.651558364144604, 1.7374889710522774`}, {1.303116728289208, 
    0.8687444855261387}, {0.8687444855261387, 0.}, {1.7374889710522774`, 
    0.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {4, 3}, {4, 5}, {4, 6}}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 0.8687444855261387}, {0., 0.}, {
     0.651558364144604, 1.7374889710522774`}, {1.303116728289208, 
     0.8687444855261387}, {0.8687444855261387, 0.}, {1.7374889710522774`, 
     0.}}]& ],
  AspectRatio->1.,
  FrameTicks->None,
  ImageSize->{165., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{169, 165},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]=",
 CellID->1525597759]
}, Open  ]],

Cell["\<\
This shows self-loops with the diameter equals 0.3 times the average length \
of edges:\
\>", "MathCaption",
 CellTags->"b:0.1",
 CellID->735821658],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "5"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"2", "\[Rule]", "5"}], ",", 
     RowBox[{"2", "\[Rule]", "6"}], ",", 
     RowBox[{"2", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "2"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"SelfLoopStyle", "\[Rule]", "0.3"}]}], "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[24]:=",
 CellID->51804372],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{172, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[24]=",
 CellID->124145471]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["VertexCoordinateRules", "Subsection",
 CellTags->"b:0.1",
 CellID->405721262],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["VertexCoordinateRules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexCoordinateRules"]], "InlineFormula"],
 " specifies the coordinates of the vertices. Possible values are",
 " ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ", or a list of coordinates. Coordinates specified by a list of rules are \
not supported by ",
 Cell[BoxData[
  ButtonBox["TreePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TreePlot"]], "InlineFormula"],
 " currently."
}], "Text",
 CellTags->"b:0.1",
 CellID->293738385],

Cell["This draws the Petersen graph using known coordinates:", "MathCaption",
 CellTags->"b:0.1",
 CellID->369012665],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   TagBox[
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "3"}], ",", 
      RowBox[{"1", "\[Rule]", "4"}], ",", 
      RowBox[{"2", "\[Rule]", "4"}], ",", 
      RowBox[{"2", "\[Rule]", "5"}], ",", 
      RowBox[{"3", "\[Rule]", "5"}], ",", 
      RowBox[{"6", "\[Rule]", "7"}], ",", 
      RowBox[{"7", "\[Rule]", "8"}], ",", 
      RowBox[{"8", "\[Rule]", "9"}], ",", 
      RowBox[{"9", "\[Rule]", "10"}], ",", 
      RowBox[{"6", "\[Rule]", "10"}], ",", 
      RowBox[{"1", "\[Rule]", "6"}], ",", 
      RowBox[{"2", "\[Rule]", "7"}], ",", 
      RowBox[{"3", "\[Rule]", "8"}], ",", 
      RowBox[{"4", "\[Rule]", "9"}], ",", 
      RowBox[{"5", "\[Rule]", "10"}]}], "}"}],
    Short[#, 1000]& ], ",", 
   RowBox[{"VertexCoordinateRules", "\[Rule]", 
    TagBox[
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.30901699437494745`", ",", "0.9510565162951535`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.8090169943749476`"}], ",", 
         RowBox[{"-", "0.587785252292473`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.30901699437494723`", ",", 
         RowBox[{"-", "0.9510565162951536`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.8090169943749473`"}], ",", "0.5877852522924732`"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.`", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.6180339887498949`", ",", "1.902113032590307`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.6180339887498947`"}], ",", "1.1755705045849465`"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.6180339887498951`"}], ",", 
         RowBox[{"-", "1.175570504584946`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.6180339887498945`", ",", 
         RowBox[{"-", "1.9021130325903073`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.`", ",", "0"}], "}"}]}], "}"}],
     Short[#, 1000]& ]}]}], "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[25]:=",
 CellID->533487069],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.30901699437494745`, 
    0.9510565162951535}, {-0.8090169943749476, -0.587785252292473}, {
    0.30901699437494723`, -0.9510565162951536}, {-0.8090169943749473, 
    0.5877852522924732}, {1., 0.}, {0.6180339887498949, 
    1.902113032590307}, {-1.6180339887498947`, 
    1.1755705045849465`}, {-1.6180339887498951`, -1.175570504584946}, {
    0.6180339887498945, -1.9021130325903073`}, {2., 0.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {1, 6}, {2, 5}, {2, 8}, {3, 9}, {4, 3}, {4, 
       5}, {4, 7}, {5, 10}, {6, 7}, {6, 10}, {7, 8}, {8, 9}, {9, 10}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.30901699437494745`, 
     0.9510565162951535}, {-0.8090169943749476, -0.587785252292473}, {
     0.30901699437494723`, -0.9510565162951536}, {-0.8090169943749473, 
     0.5877852522924732}, {1., 0.}, {0.6180339887498949, 
     1.902113032590307}, {-1.6180339887498947`, 
     1.1755705045849465`}, {-1.6180339887498951`, -1.175570504584946}, {
     0.6180339887498945, -1.9021130325903073`}, {2., 0.}}]& ],
  AspectRatio->1.0254083207377767`,
  FrameTicks->None,
  ImageMargins->0.,
  ImageSize->{160., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{164, 164},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[25]=",
 CellID->176098474]
}, Open  ]],

Cell["This draws with the default method:", "MathCaption",
 CellID->447953798],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "\[Rule]", "3"}], ",", 
    RowBox[{"1", "\[Rule]", "4"}], ",", 
    RowBox[{"2", "\[Rule]", "4"}], ",", 
    RowBox[{"2", "\[Rule]", "5"}], ",", 
    RowBox[{"3", "\[Rule]", "5"}], ",", 
    RowBox[{"6", "\[Rule]", "7"}], ",", 
    RowBox[{"7", "\[Rule]", "8"}], ",", 
    RowBox[{"8", "\[Rule]", "9"}], ",", 
    RowBox[{"9", "\[Rule]", "10"}], ",", 
    RowBox[{"6", "\[Rule]", "10"}], ",", 
    RowBox[{"1", "\[Rule]", "6"}], ",", 
    RowBox[{"2", "\[Rule]", "7"}], ",", 
    RowBox[{"3", "\[Rule]", "8"}], ",", 
    RowBox[{"4", "\[Rule]", "9"}], ",", 
    RowBox[{"5", "\[Rule]", "10"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[26]:=",
 CellID->2118172987],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.169877403271869, 0.9359019226174953}, {
    0.23397548065437382`, 0.46795096130874764`}, {1.169877403271869, 
    0.46795096130874764`}, {0.9359019226174953, 0.}, {0., 0.}, {
    2.1057793258893645`, 0.46795096130874764`}, {1.8718038452349905`, 0.}, {
    0.46795096130874764`, 0.}, {1.403852883926243, 0.}, {2.339754806543738, 
    0.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {1, 6}, {2, 5}, {2, 8}, {3, 9}, {4, 3}, {4, 
       5}, {4, 7}, {5, 10}, {6, 7}, {6, 10}, {7, 8}, {8, 9}, {9, 10}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.169877403271869, 0.9359019226174953}, {
     0.23397548065437382`, 0.46795096130874764`}, {1.169877403271869, 
     0.46795096130874764`}, {0.9359019226174953, 0.}, {0., 0.}, {
     2.1057793258893645`, 0.46795096130874764`}, {1.8718038452349905`, 0.}, {
     0.46795096130874764`, 0.}, {1.403852883926243, 0.}, {2.339754806543738, 
     0.}}]& ],
  AspectRatio->0.6324555320336759,
  FrameTicks->None,
  ImageSize->{134.066085859655, Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{138, 85},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]=",
 CellID->1315290581]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["VertexLabeling", "Subsection",
 CellTags->"b:0.1",
 CellID->344428094],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["VertexLabeling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexLabeling"]], "InlineFormula"],
 " specifies whether to show vertex names as labels. Possible values for this \
option are ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " (the default) and ",
 Cell[BoxData[
  ButtonBox["Tooltip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tooltip"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["VertexLabeling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VertexLabeling"], "->", "True"}]], 
  "InlineFormula"],
 " shows the labels. For graphs specified by an adjacency matrix, vertex \
labels are taken to be successive integers ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", ",", "2", ",", "\[Ellipsis]", ",", "n"}], TraditionalForm]], 
  "InlineMath"],
 ", where n is the size of the matrix. For graphs specified by a list of \
rules, labels are the expressions used in the rules. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["VertexLabeling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VertexLabeling"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " displays each vertex as a point. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["VertexLabeling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VertexLabeling"], "->", 
   ButtonBox["Tooltip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tooltip"]}]], "InlineFormula"],
 " displays each vertex as a point, but gives its name in a tooltip. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["VertexLabeling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VertexLabeling"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " displays each vertex as a point, giving its name in a tooltip if the \
number of vertices is not too large. You can also use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tooltip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tooltip"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["v", "TI"], 
     StyleBox["k", "TI"]], ",", 
    SubscriptBox[
     StyleBox["v", "TI"], 
     StyleBox["lbl", "TI"]]}], "]"}]], "InlineFormula"],
 " anywhere in the list of rules to specify an alternative tooltip for a \
vertex ",
 Cell[BoxData[
  FormBox[Cell[TextData[Cell[BoxData[
    SubscriptBox[
     StyleBox["v", "TI"], 
     StyleBox["k", "TI"]]], "InlineFormula"]], "InlineFormula"], 
   TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellTags->"b:0.1",
 CellID->659301986],

Cell["\<\
This draws the graph with labels given as indices of the adjacency matrix:\
\>", "MathCaption",
 CellID->1601243868],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0", "1", "0", "0", "0"},
      {"0", "0", "0", "0", "0"},
      {"1", "1", "0", "0", "0"},
      {"0", "1", "0", "0", "0"},
      {"0", "1", "0", "0", "0"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.28], {
          Offset[0.7]}, 
         Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[27]:=",
 CellID->997850596],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.9128709291752769, 1.8257418583505538`}, {
    0.45643546458763845`, 0.9128709291752769}, {1.3693063937629153`, 
    0.9128709291752769}, {0., 0.}, {0.9128709291752769, 0.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {3, 1}, {3, 2}, {4, 2}, {5, 2}}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.9128709291752769, 1.8257418583505538`}, {
     0.45643546458763845`, 0.9128709291752769}, {1.3693063937629153`, 
     0.9128709291752769}, {0., 0.}, {0.9128709291752769, 0.}}]& ],
  AspectRatio->1.1547005383792515`,
  FrameTicks->None,
  ImageSize->{162., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{166, 187},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]=",
 CellID->1931010161]
}, Open  ]],

Cell["This uses the labels specified in the list of rules:", "MathCaption",
 CellID->97622059],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<A\>\"", "\[Rule]", "\"\<B\>\""}], ",", 
     RowBox[{"\"\<A\>\"", "\[Rule]", "\"\<a\>\""}], ",", 
     RowBox[{"\"\<C\>\"", "\[Rule]", "\"\<A\>\""}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[28]:=",
 CellID->1544203859],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.7745966692414834, 0.7745966692414834}, {0., 
    0.}, {0.7745966692414834, 0.}, {1.5491933384829668`, 0.}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{{1, 2}, {1, 3}, {4, 1}}]}, {InsetBox[
       FrameBox["\<\"A\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["\<\"B\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["\<\"a\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["\<\"C\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.7745966692414834, 0.7745966692414834}, {0., 
     0.}, {0.7745966692414834, 0.}, {1.5491933384829668`, 0.}}]& ],
  AspectRatio->0.7071067811865476,
  FrameTicks->None,
  ImageSize->{218., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{222, 154},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]=",
 CellID->201780030]
}, Open  ]],

Cell["\<\
This plots vertices as points, and display vertex names in tooltips. Place \
the cursor above the vertices to see the labels:\
\>", "MathCaption",
 CellID->992105691],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<A\>\"", "\[Rule]", "\"\<B\>\""}], ",", 
     RowBox[{"\"\<A\>\"", "\[Rule]", "\"\<a\>\""}], ",", 
     RowBox[{"\"\<C\>\"", "\[Rule]", "\"\<A\>\""}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "Tooltip"}]}], "]"}]], "Input",
 CellLabel->"In[29]:=",
 CellID->1314056000],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.7745966692414834, 0.7745966692414834}, {0., 
    0.}, {0.7745966692414834, 0.}, {1.5491933384829668`, 0.}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{{1, 2}, {1, 3}, {4, 1}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "\"A\""],
       Annotation[#, "A", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "\"B\""],
       Annotation[#, "B", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "\"a\""],
       Annotation[#, "a", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "\"C\""],
       Annotation[#, "C", "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.7745966692414834, 0.7745966692414834}, {0., 
     0.}, {0.7745966692414834, 0.}, {1.5491933384829668`, 0.}}]& ],
  AspectRatio->0.7071067811865476,
  FrameTicks->None,
  ImageSize->{213., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{217, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[29]=",
 CellID->46778589]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["VertexRenderingFunction", "Subsection",
 CellTags->"b:0.1",
 CellID->283881111],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["VertexRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexRenderingFunction"]], "InlineFormula"],
 " specifies graphical representation of the graph edges. Possible values for \
this option are ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ", or a function that gives a proper combination of graphics primitives and \
directives. With the default setting of ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", vertices are displayed as points, with their names given in tooltips. "
}], "Text",
 CellID->1022272051],

Cell["\<\
By default, vertices are displayed as points and, for small graphs, labeled \
in tool tips. Point the cursor at a vertex to see the tooltip:\
\>", "MathCaption",
 CellTags->"b:0.1",
 CellID->844347480],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "3"}], ",", 
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"2", "\[Rule]", "5"}], ",", 
     RowBox[{"2", "\[Rule]", "6"}], ",", 
     RowBox[{"5", "\[Rule]", "7"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[30]:=",
 CellID->1378684656],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", "g", "]"}]], "Input",
 CellLabel->"In[31]:=",
 CellID->101221751],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 1.774131050290975}, {0.6652991438591156, 
    2.6611965754364624`}, {0., 0.8870655251454875}, {1.3305982877182312`, 
    1.774131050290975}, {0.8870655251454874, 0.8870655251454875}, {
    1.7741310502909748`, 0.8870655251454875}, {0.8870655251454874, 0.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {4, 2}, {4, 5}, {4, 6}, {5, 7}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 1.774131050290975}, {0.6652991438591156, 
     2.6611965754364624`}, {0., 0.8870655251454875}, {1.3305982877182312`, 
     1.774131050290975}, {0.8870655251454874, 0.8870655251454875}, {
     1.7741310502909748`, 0.8870655251454875}, {0.8870655251454874, 0.}}]& ],
  AspectRatio->1.224744871391589,
  FrameTicks->None,
  ImageSize->{168., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{172, 206},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[31]=",
 CellID->190162907]
}, Open  ]],

Cell["This draws the same graph, but without the vertices:", "MathCaption",
 CellTags->"b:0.1",
 CellID->360328832],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[32]:=",
 CellID->271336278],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 1.774131050290975}, {0.6652991438591156, 
    2.6611965754364624`}, {0., 0.8870655251454875}, {1.3305982877182312`, 
    1.774131050290975}, {0.8870655251454874, 0.8870655251454875}, {
    1.7741310502909748`, 0.8870655251454875}, {0.8870655251454874, 0.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {4, 2}, {4, 5}, {4, 6}, {5, 7}}]}, 
     {RGBColor[0, 0, 0.7]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 1.774131050290975}, {0.6652991438591156, 
     2.6611965754364624`}, {0., 0.8870655251454875}, {1.3305982877182312`, 
     1.774131050290975}, {0.8870655251454874, 0.8870655251454875}, {
     1.7741310502909748`, 0.8870655251454875}, {0.8870655251454874, 0.}}]& ],
  AspectRatio->1.224744871391589,
  FrameTicks->None,
  ImageSize->{173., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{177, 212},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[32]=",
 CellID->1662016062]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["VertexRenderingFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VertexRenderingFunction"], "->", 
   StyleBox["g", "TI"]}]], "InlineFormula"],
 ", each vertex is rendered with the graphics primitives given by ",
 Cell[BoxData[
  RowBox[{
   StyleBox["g", "TI"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["r", "TI"], 
     StyleBox["i", "TI"]], ",", 
    SubscriptBox[
     StyleBox["v", "TI"], 
     StyleBox["i", "TI"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["r", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " is the coordinate of the vertex and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " is the label of the vertex. Explicit settings for ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["VertexRenderingFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VertexRenderingFunction"], "->", 
   StyleBox["g", "TI"]}]], "InlineFormula"],
 " override settings for ",
 Cell[BoxData[
  ButtonBox["VertexLabeling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexLabeling"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.1",
 CellID->639309593],

Cell["This shows vertices as yellow disks:", "MathCaption",
 CellTags->"b:0.1",
 CellID->703653719],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "5"}], ",", 
     RowBox[{"2", "\[Rule]", "8"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "8"}], ",", 
     RowBox[{"6", "\[Rule]", "8"}], ",", 
     RowBox[{"7", "\[Rule]", "8"}], ",", 
     RowBox[{"7", "\[Rule]", "9"}]}], "}"}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EdgeForm", "[", "Black", "]"}], ",", "Yellow", ",", 
        RowBox[{"Disk", "[", 
         RowBox[{"#1", ",", "0.2"}], "]"}], ",", "Black", ",", 
        RowBox[{"Text", "[", 
         RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[33]:=",
 CellID->1950334],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{
     GraphicsComplexBox[{{0., 1.4729193886373175`}, {1.104689541477988, 
      2.209379082955976}, {0., 0.7364596943186588}, {0.7364596943186587, 
      0.7364596943186588}, {1.4729193886373173`, 1.4729193886373175`}, {
      2.209379082955976, 1.4729193886373175`}, {1.4729193886373173`, 
      0.7364596943186588}, {2.209379082955976, 0.7364596943186588}, {
      2.209379082955976, 0.}}, 
      {RGBColor[0.5, 0., 0.], 
       LineBox[{{1, 2}, {1, 3}, {2, 5}, {4, 5}, {6, 2}, {7, 5}, {8, 5}, {8, 
        9}}]}], {
      {RGBColor[1, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0., 1.4729193886373175`}, 0.2], 
       {GrayLevel[0], InsetBox["1", {0., 1.4729193886373175`}]}}, 
      {RGBColor[1, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{1.104689541477988, 2.209379082955976}, 0.2], 
       {GrayLevel[0], 
        InsetBox["4", {1.104689541477988, 2.209379082955976}]}}, 
      {RGBColor[1, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0., 0.7364596943186588}, 0.2], 
       {GrayLevel[0], InsetBox["5", {0., 0.7364596943186588}]}}, 
      {RGBColor[1, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.7364596943186587, 0.7364596943186588}, 0.2], 
       {GrayLevel[0], 
        InsetBox["2", {0.7364596943186587, 0.7364596943186588}]}}, 
      {RGBColor[1, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{1.4729193886373173`, 1.4729193886373175`}, 0.2], 
       {GrayLevel[0], 
        InsetBox["8", {1.4729193886373173`, 1.4729193886373175`}]}}, 
      {RGBColor[1, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{2.209379082955976, 1.4729193886373175`}, 0.2], 
       {GrayLevel[0], 
        InsetBox["3", {2.209379082955976, 1.4729193886373175`}]}}, 
      {RGBColor[1, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{1.4729193886373173`, 0.7364596943186588}, 0.2], 
       {GrayLevel[0], 
        InsetBox["6", {1.4729193886373173`, 0.7364596943186588}]}}, 
      {RGBColor[1, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{2.209379082955976, 0.7364596943186588}, 0.2], 
       {GrayLevel[0], 
        InsetBox["7", {2.209379082955976, 0.7364596943186588}]}}, 
      {RGBColor[1, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{2.209379082955976, 0.}, 0.2], 
       {GrayLevel[0], InsetBox["9", {2.209379082955976, 0.}]}}}},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 1.4729193886373175`}, {1.104689541477988, 
     2.209379082955976}, {0., 0.7364596943186588}, {0.7364596943186587, 
     0.7364596943186588}, {1.4729193886373173`, 1.4729193886373175`}, {
     2.209379082955976, 1.4729193886373175`}, {1.4729193886373173`, 
     0.7364596943186588}, {2.209379082955976, 0.7364596943186588}, {
     2.209379082955976, 0.}}]& ],
  AspectRatio->1.,
  FrameTicks->None,
  ImageSize->{204., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{208, 204},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[33]=",
 CellID->1018654162]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example Gallery", "Section",
 CellTags->"b:0.1",
 CellID->806578725],

Cell[CellGroupData[{

Cell["K-ary tree", "Subsection",
 CellTags->"b:0.1",
 CellID->2079063106],

Cell[TextData[{
 "This defines a ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 "-ary tree:"
}], "MathCaption",
 CellID->775463343],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"KaryTree", "[", 
    RowBox[{"level_", ",", 
     RowBox[{"k_:", " ", "2"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"Flatten", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"i", "\[Rule]", 
          RowBox[{
           RowBox[{"k", "*", "i"}], "+", "j"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", 
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{"k", "-", "2"}], ")"}]}], ",", "1", ",", "1"}], "}"}]}], 
        "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"k", "^", "level"}], "-", "1"}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"k", "-", "1"}], ")"}]}]}], "}"}]}], "]"}], "]"}], "/;", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"level", "\[GreaterEqual]", "1"}], "&&", 
      RowBox[{"k", ">", "1"}]}], ")"}]}]}], ";"}]], "Input",
 CellLabel->"In[34]:=",
 CellID->1796566309],

Cell["This plots a 4-ary tree of 4 levels:", "MathCaption",
 CellID->372621804],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"KaryTree", "[", 
    RowBox[{"4", ",", "5"}], "]"}], ",", "Center"}], "]"}]], "Input",
 CellLabel->"In[35]:=",
 CellID->1264672853],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJxNenk8Vd8X9jXP4rq47mjI2EBCmuxVyZQiSUVfQykqmVNSooSEKJWhpFGU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    "], {
     {RGBColor[0.5, 0., 0.], LineBox[CompressedData["
1:eJxF2FN0ZUsUheGqitNJ207btm2m7e60lbRt27Zt27Zt2/bNmP8Y9+l7yUhO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       "]]}, 
     {RGBColor[0, 0, 0.7], PointBox[CompressedData["
1:eJwl10O0GIYSANAXu3HS2HZj27Zt27Zt27Zt204b207+zfmLe2Y2sxwlaNC2
QptAAQEB4YIEBPyJgZEGBCUYwQlBSEIRmjCE/VPDX4QnAhGJRGSiEJVoROdv
YhCTWMQmDnGJR3wSkJBEJCYJSUlGclKQklSkJg1pSUd6MvAPGclEZrKQlWxk
Jwc5yUVu8pCXfOSnAAUpRGGKUJRiFKcEJSlFacpQlnKUpwIVqURlqlCValSn
BjWpRW3qUJd61KcBDWlEY5rQlGY0pwUtaUVr2tCWdrSnAx3pRGe60JVudKcH
PelFb/rQl370ZwADGcRghjCUYQxnBCMZxWjGMJZxjGcCE5nEZKYwlWlMZwYz
mcVs5jCXecxnAQtZxGKWsJRlLGcFK1nFatawlnWsZwMb2cRmtrCVbWxnBzvZ
xW72sJd97OcABznEYY5wlGMc5wQnOcVpznCWc5znAhe5xGWucJVrXOcGN7nF
be5wl3vc5wH/8h8PecRjnvCUZzznBS95xWve8JZ3vOcDH/nEZ77wlW985wc/
+cVv/jR/IAIThKAEIzghCEkoQhOGsITjL8ITgYhEIjJRiEo0ovM3MYhJLGIT
h7jEIz4JSEgiEpOEpCQjOSlISSpSk4a0pCM9GfiHjGQiM1nISjayk4Oc5CI3
echLPvJTgIIUojBFKEoxilOCkpSiNGUoSznKU4GKVKIyVahKNapTg5rUojZ1
qEs96tOAhjSiMU1oSjOa04KWtKI1f4Z3W9rRng50pBOd6UJXutGdHvSkF73p
Q1/60Z8BDGQQgxnCUIYxnBGMZBSjGcNYxjGeCUxkEpOZwlSmMZ0ZzGQWs5nD
XOYxnwUsZBGLWcJSlrGcFaxkFatZw1rWsZ4NbGQTm9nCVraxnR3sZBe72cNe
9rGfAxzkEIc5wlGOcZwTnOQUpznDWc5xngtc5BKXucJVrnGdG9zkFre5w13u
cZ8H/Mt/POQRj3nCU57xnBe85BWvecNb3vGeD3zkE5/5wle+8Z0f/OQXv/mz
+AMRmCAEJRjBCUFIQhGaMIQlHH8RnghEJBKRiUJUohGdv4lBTGIRmzjEJR7x
SUBCEpGYJCQlGclJQUpSkZo0pCUd6cnAP2QkE5nJQlaykZ0c5CQXuclDXvKR
nwIUpBCFKUJRilGcEpSkFKUpQ1nKUZ4KVKQSlalCVapRnRrUpBa1qUNd6lGf
BjSkEY1pQlOa0ZwWtKQVrWlDW9rRng50pBOd6UJXutGdHvSkF73pQ1/60Z8B
DGQQgxnCUIYxnBGMZBSjGcNYxjGeCUxkEpOZwlSmMZ0ZzGQWs5nDXOYxnwUs
ZBGLWcJSlrGcFaxkFatZw1rWsZ4NbGQTm9nCVraxnR3sZBe72cNe9rGfAxzk
EIc5wlGOcZwTnOQUpznDWc5xngtc5BKXucJVrnGdG9zkFre5w13ucZ8H/Mt/
POQRj3nCU57xnBe85BWvecNb3vGeD3zkE5/5wle+8Z0f/OQXv/lz9AciMEEI
SjCCE4KQhCI0YQgb5P8/w/8AfY6D2A==
       "]]}}],
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxNenk8Vd8X9jXP4rq47mjI2EBCmuxVyZQiSUVfQykqmVNSooSEKJWhpFGU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     "]]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{220., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{224, 220},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[35]=",
 CellID->3408298]
}, Open  ]],

Cell[TextData[{
 "This plots the same graph, but with the height of each level ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " proportional to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", 
    SuperscriptBox["i", "2"]}], TraditionalForm]], "InlineMath"],
 ":"
}], "MathCaption",
 CellID->1547849300],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"KaryTree", "[", 
    RowBox[{"4", ",", "5"}], "]"}], ",", "Center", ",", 
   RowBox[{"LayerSizeFunction", "\[Rule]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"#", "^", "2"}]}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[36]:=",
 CellID->2073168878],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{207, 207},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[36]=",
 CellID->19105470]
}, Open  ]],

Cell[TextData[{
 "This sets the height of each level ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " proportional to ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "0.5"}], ")"}], "i"], TraditionalForm]], "InlineMath"],
 ":"
}], "MathCaption",
 CellID->333463715],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"KaryTree", "[", 
    RowBox[{"4", ",", "5"}], "]"}], ",", "Center", ",", 
   RowBox[{"LayerSizeFunction", "\[Rule]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"-", "0.5"}], ")"}], "^", "#"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[37]:=",
 CellID->491651889],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{235, 224},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[37]=",
 CellID->274393964]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Tree Drawing - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 44, 20.7970442}", "context" -> "", 
    "keywords" -> {
     "graph drawing", "graph embedding", "graph layout", 
      "graph visualization", "network layout", "network visualization", 
      "tree drawing", "tree layout"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "TreePlot lays out the vertices of a graph in a tree of successive \
layers, or a collection of trees. If the graph g is not a tree, TreePlot lays \
out its vertices on the basis of a spanning tree of each component of the \
graph. Tree drawing. This a simple graph and its tree plot:", 
    "synonyms" -> {}, "title" -> "Tree Drawing", "type" -> "Tutorial", "uri" -> 
    "tutorial/TreeDrawing"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "graphplot"->{
  Cell[1178, 41, 91, 2, 70, "Title",
   CellTags->{"graphplot", "i:3", "b:0.1"},
   CellID->672278587]},
 "i:3"->{
  Cell[1178, 41, 91, 2, 70, "Title",
   CellTags->{"graphplot", "i:3", "b:0.1"},
   CellID->672278587]},
 "b:0.1"->{
  Cell[1178, 41, 91, 2, 70, "Title",
   CellTags->{"graphplot", "i:3", "b:0.1"},
   CellID->672278587],
  Cell[1843, 64, 3038, 104, 70, "DefinitionBox",
   CellTags->"b:0.1",
   CellID->25485965],
  Cell[4884, 170, 72, 2, 70, "Caption",
   CellTags->"b:0.1",
   CellID->164814425],
  Cell[18593, 539, 106, 2, 70, "Section",
   CellTags->{"Options_for_GraphPlot", "b:0.1"},
   CellID->267311437],
  Cell[18702, 543, 403, 14, 70, "Text",
   CellTags->"b:0.1",
   CellID->66806916],
  Cell[19108, 559, 3793, 111, 70, "DefinitionBox3Col",
   CellTags->"b:0.1",
   CellID->183266322],
  Cell[22904, 672, 211, 9, 70, "Caption",
   CellTags->"b:0.1",
   CellID->428527873],
  Cell[23140, 685, 74, 2, 70, "Subsection",
   CellTags->"b:0.1",
   CellID->94783224],
  Cell[27722, 816, 73, 2, 70, "Subsection",
   CellTags->"b:0.1",
   CellID->78244718],
  Cell[39910, 1146, 83, 2, 70, "Subsection",
   CellTags->"b:0.1",
   CellID->229062904],
  Cell[39996, 1150, 1136, 35, 70, "Text",
   CellTags->"b:0.1",
   CellID->1564098284],
  Cell[41135, 1187, 88, 2, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->683565354],
  Cell[41248, 1193, 378, 11, 28, "Input",
   CellTags->"b:0.1",
   CellID->115400586],
  Cell[41629, 1206, 1423, 28, 98, "Output",
   Evaluatable->False,
   CellTags->"b:0.1",
   CellID->138982770],
  Cell[43067, 1237, 2466, 86, 70, "Text",
   CellTags->"b:0.1",
   CellID->270347621],
  Cell[45536, 1325, 191, 5, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->22126029],
  Cell[45752, 1334, 830, 25, 70, "Input",
   CellTags->"b:0.1",
   CellID->445960829],
  Cell[46585, 1361, 3600, 95, 70, "Output",
   CellTags->"b:0.1",
   CellID->16421984],
  Cell[57394, 1616, 80, 2, 70, "Subsection",
   CellTags->"b:0.1",
   CellID->1356851380],
  Cell[62876, 1797, 75, 2, 70, "Subsection",
   CellTags->"b:0.1",
   CellID->82725606],
  Cell[62954, 1801, 1667, 52, 70, "Text",
   CellTags->"b:0.1",
   CellID->904561043],
  Cell[64624, 1855, 147, 4, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->239623524],
  Cell[67993, 1931, 151, 5, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->1229163597],
  Cell[70791, 2013, 115, 2, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->585581490],
  Cell[74978, 2102, 79, 2, 70, "Subsubsection",
   CellTags->"b:0.1",
   CellID->1079530539],
  Cell[77385, 2176, 143, 4, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->792188815],
  Cell[87895, 2368, 216, 6, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->134849000],
  Cell[98568, 2568, 76, 2, 70, "Subsection",
   CellTags->"b:0.1",
   CellID->9543384],
  Cell[99052, 2589, 70, 2, 70, "Subsection",
   CellTags->"b:0.1",
   CellID->43937672],
  Cell[99125, 2593, 559, 18, 70, "Text",
   CellTags->"b:0.1",
   CellID->680585317],
  Cell[99687, 2613, 143, 4, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->52453719],
  Cell[99855, 2621, 1047, 28, 70, "Input",
   CellTags->"b:0.1",
   CellID->793185],
  Cell[100905, 2651, 4529, 103, 196, "Output",
   CellTags->"b:0.1",
   CellID->418253517],
  Cell[105483, 2760, 74, 2, 70, "Subsection",
   CellTags->"b:0.1",
   CellID->84930587],
  Cell[106990, 2810, 152, 5, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->1974872317],
  Cell[111268, 2901, 146, 4, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->1548899949],
  Cell[114246, 2989, 158, 5, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->735821658],
  Cell[114429, 2998, 570, 16, 47, "Input",
   CellTags->"b:0.1",
   CellID->51804372],
  Cell[115002, 3016, 2913, 52, 193, "Output",
   Evaluatable->False,
   CellTags->"b:0.1",
   CellID->124145471],
  Cell[117964, 3074, 83, 2, 70, "Subsection",
   CellTags->"b:0.1",
   CellID->405721262],
  Cell[118050, 3078, 644, 21, 70, "Text",
   CellTags->"b:0.1",
   CellID->293738385],
  Cell[118697, 3101, 117, 2, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->369012665],
  Cell[118839, 3107, 2175, 61, 70, "Input",
   CellTags->"b:0.1",
   CellID->533487069],
  Cell[121017, 3170, 2443, 72, 70, "Output",
   CellTags->"b:0.1",
   CellID->176098474],
  Cell[126678, 3346, 76, 2, 70, "Subsection",
   CellTags->"b:0.1",
   CellID->344428094],
  Cell[126757, 3350, 2916, 93, 70, "Text",
   CellTags->"b:0.1",
   CellID->659301986],
  Cell[135849, 3632, 85, 2, 70, "Subsection",
   CellTags->"b:0.1",
   CellID->283881111],
  Cell[136810, 3663, 211, 5, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->844347480],
  Cell[139306, 3745, 115, 2, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->360328832],
  Cell[140696, 3784, 1300, 45, 70, "Text",
   CellTags->"b:0.1",
   CellID->639309593],
  Cell[141999, 3831, 99, 2, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->703653719],
  Cell[142123, 3837, 890, 26, 70, "Input",
   CellTags->"b:0.1",
   CellID->1950334],
  Cell[143016, 3865, 3036, 63, 225, "Output",
   CellTags->"b:0.1",
   CellID->1018654162],
  Cell[146113, 3935, 74, 2, 70, "Section",
   CellTags->"b:0.1",
   CellID->806578725],
  Cell[146212, 3941, 73, 2, 70, "Subsection",
   CellTags->"b:0.1",
   CellID->2079063106]},
 "Options_for_GraphPlot"->{
  Cell[18593, 539, 106, 2, 70, "Section",
   CellTags->{"Options_for_GraphPlot", "b:0.1"},
   CellID->267311437]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"graphplot", 223880, 5327},
 {"i:3", 223995, 5331},
 {"b:0.1", 224112, 5335},
 {"Options_for_GraphPlot", 229174, 5503}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 553, 14, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1178, 41, 91, 2, 70, "Title",
 CellTags->{"graphplot", "i:3", "b:0.1"},
 CellID->672278587],
Cell[1272, 45, 568, 17, 70, "Text",
 CellID->621106430],
Cell[1843, 64, 3038, 104, 70, "DefinitionBox",
 CellTags->"b:0.1",
 CellID->25485965],
Cell[4884, 170, 72, 2, 70, "Caption",
 CellTags->"b:0.1",
 CellID->164814425],
Cell[4959, 174, 81, 1, 70, "MathCaption",
 CellID->185285925],
Cell[5043, 177, 647, 18, 70, "Input",
 CellID->686939073],
Cell[CellGroupData[{
Cell[5715, 199, 168, 5, 28, "Input",
 CellID->188451088],
Cell[5886, 206, 3504, 81, 196, "Output",
 CellID->169173888]
}, Open  ]],
Cell[9405, 290, 1167, 45, 70, "Text",
 CellID->1944209325],
Cell[10575, 337, 86, 1, 70, "MathCaption",
 CellID->3914516],
Cell[CellGroupData[{
Cell[10686, 342, 181, 5, 70, "Input",
 CellID->940161979],
Cell[10870, 349, 3706, 85, 249, "Output",
 CellID->69668883]
}, Open  ]],
Cell[14591, 437, 79, 1, 70, "MathCaption",
 CellID->1379814034],
Cell[CellGroupData[{
Cell[14695, 442, 183, 5, 70, "Input",
 CellID->642050927],
Cell[14881, 449, 3675, 85, 251, "Output",
 CellID->367136693]
}, Open  ]],
Cell[CellGroupData[{
Cell[18593, 539, 106, 2, 70, "Section",
 CellTags->{"Options_for_GraphPlot", "b:0.1"},
 CellID->267311437],
Cell[18702, 543, 403, 14, 70, "Text",
 CellTags->"b:0.1",
 CellID->66806916],
Cell[19108, 559, 3793, 111, 70, "DefinitionBox3Col",
 CellTags->"b:0.1",
 CellID->183266322],
Cell[22904, 672, 211, 9, 70, "Caption",
 CellTags->"b:0.1",
 CellID->428527873],
Cell[CellGroupData[{
Cell[23140, 685, 74, 2, 70, "Subsection",
 CellTags->"b:0.1",
 CellID->94783224],
Cell[23217, 689, 683, 24, 70, "Text",
 CellID->547537329],
Cell[23903, 715, 120, 3, 70, "MathCaption",
 CellID->133602391],
Cell[CellGroupData[{
Cell[24048, 722, 655, 18, 70, "Input",
 CellID->531828830],
Cell[24706, 742, 2967, 68, 199, "Output",
 CellID->983120807]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27722, 816, 73, 2, 70, "Subsection",
 CellTags->"b:0.1",
 CellID->78244718],
Cell[27798, 820, 1167, 39, 70, "Text",
 CellID->1357462998],
Cell[28968, 861, 81, 1, 70, "MathCaption",
 CellID->51376678],
Cell[CellGroupData[{
Cell[29074, 866, 665, 19, 47, "Input",
 CellID->474488003],
Cell[29742, 887, 2234, 41, 202, "Output",
 Evaluatable->False,
 CellID->432476563]
}, Open  ]],
Cell[31991, 931, 170, 4, 70, "MathCaption",
 CellID->18324741],
Cell[CellGroupData[{
Cell[32186, 939, 730, 20, 70, "Input",
 CellID->1364181943],
Cell[32919, 961, 3009, 72, 70, "Output",
 CellID->1320228845]
}, Open  ]],
Cell[35943, 1036, 166, 4, 70, "MathCaption",
 CellID->862272319],
Cell[CellGroupData[{
Cell[36134, 1044, 676, 19, 70, "Input",
 CellID->115157923],
Cell[36813, 1065, 3009, 72, 70, "Output",
 CellID->1111678718]
}, Open  ]],
Cell[39837, 1140, 36, 1, 70, "Text",
 CellID->350635805]
}, Open  ]],
Cell[CellGroupData[{
Cell[39910, 1146, 83, 2, 70, "Subsection",
 CellTags->"b:0.1",
 CellID->229062904],
Cell[39996, 1150, 1136, 35, 70, "Text",
 CellTags->"b:0.1",
 CellID->1564098284],
Cell[41135, 1187, 88, 2, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->683565354],
Cell[CellGroupData[{
Cell[41248, 1193, 378, 11, 28, "Input",
 CellTags->"b:0.1",
 CellID->115400586],
Cell[41629, 1206, 1423, 28, 98, "Output",
 Evaluatable->False,
 CellTags->"b:0.1",
 CellID->138982770]
}, Open  ]],
Cell[43067, 1237, 2466, 86, 70, "Text",
 CellTags->"b:0.1",
 CellID->270347621],
Cell[45536, 1325, 191, 5, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->22126029],
Cell[CellGroupData[{
Cell[45752, 1334, 830, 25, 70, "Input",
 CellTags->"b:0.1",
 CellID->445960829],
Cell[46585, 1361, 3600, 95, 70, "Output",
 CellTags->"b:0.1",
 CellID->16421984]
}, Open  ]],
Cell[50200, 1459, 488, 14, 70, "MathCaption",
 CellID->425797646],
Cell[50691, 1475, 103, 3, 70, "Input",
 CellID->493887946],
Cell[CellGroupData[{
Cell[50819, 1482, 1295, 36, 83, "Input",
 CellID->300897750],
Cell[52117, 1520, 5228, 90, 311, "Output",
 Evaluatable->False,
 CellID->136575750]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[57394, 1616, 80, 2, 70, "Subsection",
 CellTags->"b:0.1",
 CellID->1356851380],
Cell[57477, 1620, 360, 10, 70, "Text",
 CellID->1589570377],
Cell[57840, 1632, 73, 1, 70, "MathCaption",
 CellID->868771299],
Cell[57916, 1635, 435, 13, 70, "Input",
 CellID->1981454907],
Cell[CellGroupData[{
Cell[58376, 1652, 105, 3, 70, "Input",
 CellID->953185233],
Cell[58484, 1657, 1966, 57, 70, "Output",
 CellID->857613928]
}, Open  ]],
Cell[60465, 1717, 154, 4, 70, "MathCaption",
 CellID->548018285],
Cell[CellGroupData[{
Cell[60644, 1725, 225, 7, 70, "Input",
 CellID->911519381],
Cell[60872, 1734, 1955, 57, 70, "Output",
 CellID->360583481]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[62876, 1797, 75, 2, 70, "Subsection",
 CellTags->"b:0.1",
 CellID->82725606],
Cell[62954, 1801, 1667, 52, 70, "Text",
 CellTags->"b:0.1",
 CellID->904561043],
Cell[64624, 1855, 147, 4, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->239623524],
Cell[CellGroupData[{
Cell[64796, 1863, 586, 16, 47, "Input",
 CellID->228833091],
Cell[65385, 1881, 2593, 47, 159, "Output",
 Evaluatable->False,
 CellID->613057183]
}, Open  ]],
Cell[67993, 1931, 151, 5, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->1229163597],
Cell[CellGroupData[{
Cell[68169, 1940, 827, 23, 70, "Input",
 CellID->122898338],
Cell[68999, 1965, 1777, 45, 173, "Output",
 CellID->2122066940]
}, Open  ]],
Cell[70791, 2013, 115, 2, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->585581490],
Cell[CellGroupData[{
Cell[70931, 2019, 642, 17, 47, "Input",
 CellID->196326928],
Cell[71576, 2038, 3365, 59, 174, "Output",
 Evaluatable->False,
 CellID->288826290]
}, Open  ]],
Cell[CellGroupData[{
Cell[74978, 2102, 79, 2, 70, "Subsubsection",
 CellTags->"b:0.1",
 CellID->1079530539],
Cell[75060, 2106, 2322, 68, 70, "Text",
 CellID->1733232121],
Cell[77385, 2176, 143, 4, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->792188815],
Cell[CellGroupData[{
Cell[77553, 2184, 346, 11, 28, "Input",
 CellID->1585754271],
Cell[77902, 2197, 9978, 168, 204, "Output",
 Evaluatable->False,
 CellID->721335210]
}, Open  ]],
Cell[87895, 2368, 216, 6, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->134849000],
Cell[CellGroupData[{
Cell[88136, 2378, 448, 14, 47, "Input",
 CellID->439127616],
Cell[88587, 2394, 9920, 167, 190, "Output",
 Evaluatable->False,
 CellID->40990409]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[98568, 2568, 76, 2, 70, "Subsection",
 CellTags->"b:0.1",
 CellID->9543384],
Cell[98647, 2572, 368, 12, 70, "Text",
 CellID->1145219532]
}, Open  ]],
Cell[CellGroupData[{
Cell[99052, 2589, 70, 2, 70, "Subsection",
 CellTags->"b:0.1",
 CellID->43937672],
Cell[99125, 2593, 559, 18, 70, "Text",
 CellTags->"b:0.1",
 CellID->680585317],
Cell[99687, 2613, 143, 4, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->52453719],
Cell[CellGroupData[{
Cell[99855, 2621, 1047, 28, 70, "Input",
 CellTags->"b:0.1",
 CellID->793185],
Cell[100905, 2651, 4529, 103, 196, "Output",
 CellTags->"b:0.1",
 CellID->418253517]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[105483, 2760, 74, 2, 70, "Subsection",
 CellTags->"b:0.1",
 CellID->84930587],
Cell[105560, 2764, 1427, 44, 70, "Text",
 CellID->988897229],
Cell[106990, 2810, 152, 5, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->1974872317],
Cell[CellGroupData[{
Cell[107167, 2819, 495, 14, 28, "Input",
 CellID->3675425],
Cell[107665, 2835, 3588, 63, 197, "Output",
 Evaluatable->False,
 CellID->59536649]
}, Open  ]],
Cell[111268, 2901, 146, 4, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->1548899949],
Cell[CellGroupData[{
Cell[111439, 2909, 1016, 29, 70, "Input",
 CellID->404337916],
Cell[112458, 2940, 1773, 46, 186, "Output",
 CellID->1525597759]
}, Open  ]],
Cell[114246, 2989, 158, 5, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->735821658],
Cell[CellGroupData[{
Cell[114429, 2998, 570, 16, 47, "Input",
 CellTags->"b:0.1",
 CellID->51804372],
Cell[115002, 3016, 2913, 52, 193, "Output",
 Evaluatable->False,
 CellTags->"b:0.1",
 CellID->124145471]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[117964, 3074, 83, 2, 70, "Subsection",
 CellTags->"b:0.1",
 CellID->405721262],
Cell[118050, 3078, 644, 21, 70, "Text",
 CellTags->"b:0.1",
 CellID->293738385],
Cell[118697, 3101, 117, 2, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->369012665],
Cell[CellGroupData[{
Cell[118839, 3107, 2175, 61, 70, "Input",
 CellTags->"b:0.1",
 CellID->533487069],
Cell[121017, 3170, 2443, 72, 70, "Output",
 CellTags->"b:0.1",
 CellID->176098474]
}, Open  ]],
Cell[123475, 3245, 78, 1, 70, "MathCaption",
 CellID->447953798],
Cell[CellGroupData[{
Cell[123578, 3250, 751, 20, 70, "Input",
 CellID->2118172987],
Cell[124332, 3272, 2297, 68, 70, "Output",
 CellID->1315290581]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[126678, 3346, 76, 2, 70, "Subsection",
 CellTags->"b:0.1",
 CellID->344428094],
Cell[126757, 3350, 2916, 93, 70, "Text",
 CellTags->"b:0.1",
 CellID->659301986],
Cell[129676, 3445, 126, 3, 70, "MathCaption",
 CellID->1601243868],
Cell[CellGroupData[{
Cell[129827, 3452, 778, 22, 70, "Input",
 CellID->997850596],
Cell[130608, 3476, 1613, 40, 208, "Output",
 CellID->1931010161]
}, Open  ]],
Cell[132236, 3519, 94, 1, 70, "MathCaption",
 CellID->97622059],
Cell[CellGroupData[{
Cell[132355, 3524, 378, 10, 70, "Input",
 CellID->1544203859],
Cell[132736, 3536, 1333, 33, 175, "Output",
 CellID->201780030]
}, Open  ]],
Cell[134084, 3572, 176, 4, 70, "MathCaption",
 CellID->992105691],
Cell[CellGroupData[{
Cell[134285, 3580, 381, 10, 70, "Input",
 CellID->1314056000],
Cell[134669, 3592, 1131, 34, 70, "Output",
 CellID->46778589]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[135849, 3632, 85, 2, 70, "Subsection",
 CellTags->"b:0.1",
 CellID->283881111],
Cell[135937, 3636, 870, 25, 70, "Text",
 CellID->1022272051],
Cell[136810, 3663, 211, 5, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->844347480],
Cell[137024, 3670, 393, 12, 70, "Input",
 CellID->1378684656],
Cell[CellGroupData[{
Cell[137442, 3686, 105, 3, 70, "Input",
 CellID->101221751],
Cell[137550, 3691, 1741, 51, 70, "Output",
 CellID->190162907]
}, Open  ]],
Cell[139306, 3745, 115, 2, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->360328832],
Cell[CellGroupData[{
Cell[139446, 3751, 183, 5, 70, "Input",
 CellID->271336278],
Cell[139632, 3758, 1049, 23, 233, "Output",
 CellID->1662016062]
}, Open  ]],
Cell[140696, 3784, 1300, 45, 70, "Text",
 CellTags->"b:0.1",
 CellID->639309593],
Cell[141999, 3831, 99, 2, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->703653719],
Cell[CellGroupData[{
Cell[142123, 3837, 890, 26, 70, "Input",
 CellTags->"b:0.1",
 CellID->1950334],
Cell[143016, 3865, 3036, 63, 225, "Output",
 CellTags->"b:0.1",
 CellID->1018654162]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[146113, 3935, 74, 2, 70, "Section",
 CellTags->"b:0.1",
 CellID->806578725],
Cell[CellGroupData[{
Cell[146212, 3941, 73, 2, 70, "Subsection",
 CellTags->"b:0.1",
 CellID->2079063106],
Cell[146288, 3945, 145, 6, 70, "MathCaption",
 CellID->775463343],
Cell[146436, 3953, 1053, 34, 70, "Input",
 CellID->1796566309],
Cell[147492, 3989, 79, 1, 70, "MathCaption",
 CellID->372621804],
Cell[CellGroupData[{
Cell[147596, 3994, 195, 6, 70, "Input",
 CellID->1264672853],
Cell[147794, 4002, 34743, 580, 241, "Output",
 CellID->3408298]
}, Open  ]],
Cell[182552, 4585, 326, 11, 70, "MathCaption",
 CellID->1547849300],
Cell[CellGroupData[{
Cell[182903, 4600, 357, 11, 28, "Input",
 CellID->2073168878],
Cell[183263, 4613, 14491, 242, 228, "Output",
 Evaluatable->False,
 CellID->19105470]
}, Open  ]],
Cell[197769, 4858, 322, 12, 70, "MathCaption",
 CellID->333463715],
Cell[CellGroupData[{
Cell[198116, 4874, 385, 13, 28, "Input",
 CellID->491651889],
Cell[198504, 4889, 23678, 392, 245, "Output",
 Evaluatable->False,
 CellID->274393964]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[222233, 5287, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

