(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20909,        757]
NotebookOptionsPosition[     14852,        566]
NotebookOutlinePosition[     17876,        642]
CellTagsIndexPosition[     17785,        636]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AlgebraicManipulationOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Algebraic Manipulation\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ExpToTrig" :> Documentation`HelpLookup["paclet:ref/ExpToTrig"],
           "TrigExpand" :> Documentation`HelpLookup["paclet:ref/TrigExpand"], 
          "TrigFactor" :> Documentation`HelpLookup["paclet:ref/TrigFactor"], 
          "TrigFactorList" :> 
          Documentation`HelpLookup["paclet:ref/TrigFactorList"], "TrigReduce" :> 
          Documentation`HelpLookup["paclet:ref/TrigReduce"], "TrigToExp" :> 
          Documentation`HelpLookup["paclet:ref/TrigToExp"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ExpToTrig\"\>", 
       2->"\<\"TrigExpand\"\>", 3->"\<\"TrigFactor\"\>", 
       4->"\<\"TrigFactorList\"\>", 5->"\<\"TrigReduce\"\>", 
       6->"\<\"TrigToExp\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Trigonometric Expressions", "Title",
 CellTags->{"S3.3.7", "7.1"},
 CellID->31321],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["TrigExpand",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TrigExpand"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "expand trigonometric expressions out into a sum of terms", 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["TrigFactor",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TrigFactor"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "factor trigonometric expressions into products of terms", "TableText"]},
   {
    RowBox[{
     ButtonBox["TrigFactorList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TrigFactorList"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "give terms and their exponents in a list", "TableText"]},
   {
    RowBox[{
     ButtonBox["TrigReduce",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TrigReduce"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "reduce trigonometric expressions using multiple angles", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->32606],

Cell["Functions for manipulating trigonometric expressions. ", "Caption",
 CellID->13345],

Cell["This expands out a trigonometric expression. ", "MathCaption",
 CellID->31443],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigExpand", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"2", " ", "x"}], "]"}], " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"2", " ", "y"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9850],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   RowBox[{"Cos", "[", "x", "]"}], " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "y", "]"}], "2"], " ", 
   RowBox[{"Sin", "[", "x", "]"}]}], "-", 
  RowBox[{"2", " ", 
   RowBox[{"Cos", "[", "x", "]"}], " ", 
   RowBox[{"Sin", "[", "x", "]"}], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "y", "]"}], "2"]}]}]], "Output",
 ImageSize->{312, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->231226306]
}, Open  ]],

Cell["This factors the expression. ", "MathCaption",
 CellID->18664],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigFactor", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14442],

Cell[BoxData[
 RowBox[{"4", " ", 
  RowBox[{"Cos", "[", "x", "]"}], " ", 
  RowBox[{"Sin", "[", "x", "]"}], " ", 
  RowBox[{"Sin", "[", 
   RowBox[{
    FractionBox["\[Pi]", "4"], "-", "y"}], "]"}], " ", 
  RowBox[{"Sin", "[", 
   RowBox[{
    FractionBox["\[Pi]", "4"], "+", "y"}], "]"}]}]], "Output",
 ImageSize->{241, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->463368835]
}, Open  ]],

Cell["\<\
And this reduces the expression to a form linear in the trigonometric \
functions. \
\>", "MathCaption",
 CellID->15833],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigReduce", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->30736],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"2", " ", "x"}], "-", 
      RowBox[{"2", " ", "y"}]}], "]"}], "+", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"2", " ", "x"}], "+", 
      RowBox[{"2", " ", "y"}]}], "]"}]}], ")"}]}]], "Output",
 ImageSize->{208, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->761329083]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TrigExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigExpand"]], "InlineFormula"],
 " works on hyperbolic as well as circular functions. "
}], "MathCaption",
 CellID->21025],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigExpand", "[", 
  RowBox[{"Tanh", "[", 
   RowBox[{"x", "+", "y"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->27559],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"Cosh", "[", "y", "]"}], " ", 
    RowBox[{"Sinh", "[", "x", "]"}]}], 
   RowBox[{
    RowBox[{
     RowBox[{"Cosh", "[", "x", "]"}], " ", 
     RowBox[{"Cosh", "[", "y", "]"}]}], "+", 
    RowBox[{
     RowBox[{"Sinh", "[", "x", "]"}], " ", 
     RowBox[{"Sinh", "[", "y", "]"}]}]}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"Cosh", "[", "x", "]"}], " ", 
    RowBox[{"Sinh", "[", "y", "]"}]}], 
   RowBox[{
    RowBox[{
     RowBox[{"Cosh", "[", "x", "]"}], " ", 
     RowBox[{"Cosh", "[", "y", "]"}]}], "+", 
    RowBox[{
     RowBox[{"Sinh", "[", "x", "]"}], " ", 
     RowBox[{"Sinh", "[", "y", "]"}]}]}]]}]], "Output",
 ImageSize->{455, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->757090264]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TrigReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigReduce"]], "InlineFormula"],
 " reproduces the original form again. "
}], "MathCaption",
 CellID->11007],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigReduce", "[", "%", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->9006],

Cell[BoxData[
 RowBox[{"Tanh", "[", 
  RowBox[{"x", "+", "y"}], "]"}]], "Output",
 ImageSize->{73, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1288761376]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically uses functions like ",
 Cell[BoxData[
  ButtonBox["Tan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tan"]], "InlineFormula"],
 " whenever it can. "
}], "MathCaption",
 CellID->21129],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], "^", "2"}], "/", 
  RowBox[{"Cos", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->2751],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", "x", "]"}], " ", 
  RowBox[{"Tan", "[", "x", "]"}]}]], "Output",
 ImageSize->{91, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->1699304709]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  ButtonBox["TrigFactorList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigFactorList"]], "InlineFormula"],
 ", however, you can see the parts of functions like ",
 Cell[BoxData[
  ButtonBox["Tan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tan"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->27395],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigFactorList", "[", "%", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->21228],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{236, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->2078406597]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["TrigToExp",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TrigToExp"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "write trigonometric functions in terms of exponentials", "TableText"]},
   {
    RowBox[{
     ButtonBox["ExpToTrig",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ExpToTrig"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "write exponentials in terms of trigonometric functions", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->30059],

Cell["Converting to and from exponentials. ", "Caption",
 CellID->3220],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TrigToExp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigToExp"]], "InlineFormula"],
 " writes trigonometric functions in terms of exponentials. "
}], "MathCaption",
 CellID->22715],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigToExp", "[", 
  RowBox[{"Tan", "[", "x", "]"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->20944],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", "x"}]], "-", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[ImaginaryI]", " ", "x"}]]}], ")"}]}], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], " ", "x"}]], "+", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"\[ImaginaryI]", " ", "x"}]]}]]], "Output",
 ImageSize->{90, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->944929903]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TrigToExp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigToExp"]], "InlineFormula"],
 " also works with hyperbolic functions. "
}], "MathCaption",
 CellID->323517381],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigToExp", "[", 
  RowBox[{"Tanh", "[", "x", "]"}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->759639633],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", "x"}]]}], "+", 
   SuperscriptBox["\[ExponentialE]", "x"]}], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "x"}]], "+", 
   SuperscriptBox["\[ExponentialE]", "x"]}]]], "Output",
 ImageSize->{59, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->880797982]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExpToTrig",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpToTrig"]], "InlineFormula"],
 " does the reverse, getting rid of explicit complex numbers whenever \
possible. "
}], "MathCaption",
 CellID->7658],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpToTrig", "[", "%", "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->5384],

Cell[BoxData[
 RowBox[{"Tanh", "[", "x", "]"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->19791854]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExpToTrig",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpToTrig"]], "InlineFormula"],
 " deals with hyperbolic as well as circular functions. "
}], "MathCaption",
 CellID->30383],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpToTrig", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "x", "]"}], "-", 
   RowBox[{"Exp", "[", 
    RowBox[{"-", "x"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->4638],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"Sinh", "[", "x", "]"}]}]], "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->344379505]
}, Open  ]],

Cell[TextData[{
 "You can also use ",
 Cell[BoxData[
  ButtonBox["ExpToTrig",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpToTrig"]], "InlineFormula"],
 " on purely numerical expressions."
}], "MathCaption",
 CellID->13635],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpToTrig", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"-", "1"}], ")"}], "^", 
   RowBox[{"(", 
    RowBox[{"1", "/", "17"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->5030],

Cell[BoxData[
 RowBox[{
  RowBox[{"Cos", "[", 
   FractionBox["\[Pi]", "17"], "]"}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"Sin", "[", 
    FractionBox["\[Pi]", "17"], "]"}]}]}]], "Output",
 ImageSize->{134, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->450599377]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->160360314],

Cell[TextData[ButtonBox["Algebraic Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AlgebraicManipulationOverview"]], "RelatedTutorials",
 CellID->91103315]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Trigonometric Expressions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Algebraic Manipulation", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/AlgebraicManipulationOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/PolynomialsOverAlgebraicNumberFields"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ExpressionsInvolvingComplexVariables"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 44, 22.3127080}", "context" -> "", 
    "keywords" -> {
     "circular functions", "complex exponentials", "complex powers", 
      "conversion", "Cos", "de Moivres Theorem", "Euler's formula", 
      "expansion", "exponentials", "expressions", "ExpToTrig", "factoring", 
      "hyperbolic functions", "manipulation", "multiple angle formulas", 
      "Poisson series", "polar angles", "powers", "reduction", "sin", "tan", 
      "TrigExpand", "TrigFactor", "TrigFactorList", "trigonometric expansion",
       "trigonometric expressions", "trigonometric functions", "TrigReduce", 
      "TrigToExp"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Functions for manipulating trigonometric expressions. This expands out a \
trigonometric expression. This factors the expression. ", 
    "synonyms" -> {"3.3.7"}, "title" -> "Trigonometric Expressions", "type" -> 
    "Tutorial", "uri" -> "tutorial/TrigonometricExpressions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.3.7"->{
  Cell[2365, 66, 88, 2, 70, "Title",
   CellTags->{"S3.3.7", "7.1"},
   CellID->31321]},
 "7.1"->{
  Cell[2365, 66, 88, 2, 70, "Title",
   CellTags->{"S3.3.7", "7.1"},
   CellID->31321]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.3.7", 17574, 625},
 {"7.1", 17673, 629}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1740, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2365, 66, 88, 2, 70, "Title",
 CellTags->{"S3.3.7", "7.1"},
 CellID->31321],
Cell[2456, 70, 1330, 38, 70, "DefinitionBox",
 CellID->32606],
Cell[3789, 110, 89, 1, 70, "Caption",
 CellID->13345],
Cell[3881, 113, 84, 1, 70, "MathCaption",
 CellID->31443],
Cell[CellGroupData[{
Cell[3990, 118, 236, 8, 28, "Input",
 CellID->9850],
Cell[4229, 128, 505, 16, 36, "Output",
 CellID->231226306]
}, Open  ]],
Cell[4749, 147, 68, 1, 70, "MathCaption",
 CellID->18664],
Cell[CellGroupData[{
Cell[4842, 152, 102, 3, 28, "Input",
 CellID->14442],
Cell[4947, 157, 433, 14, 49, "Output",
 CellID->463368835]
}, Open  ]],
Cell[5395, 174, 130, 4, 70, "MathCaption",
 CellID->15833],
Cell[CellGroupData[{
Cell[5550, 182, 102, 3, 28, "Input",
 CellID->30736],
Cell[5655, 187, 473, 17, 51, "Output",
 CellID->761329083]
}, Open  ]],
Cell[6143, 207, 229, 7, 70, "MathCaption",
 CellID->21025],
Cell[CellGroupData[{
Cell[6397, 218, 157, 5, 70, "Input",
 CellID->27559],
Cell[6557, 225, 823, 28, 53, "Output",
 CellID->757090264]
}, Open  ]],
Cell[7395, 256, 214, 7, 70, "MathCaption",
 CellID->11007],
Cell[CellGroupData[{
Cell[7634, 267, 101, 3, 70, "Input",
 CellID->9006],
Cell[7738, 272, 212, 7, 36, "Output",
 CellID->1288761376]
}, Open  ]],
Cell[7965, 282, 270, 10, 70, "MathCaption",
 CellID->21129],
Cell[CellGroupData[{
Cell[8260, 296, 171, 6, 70, "Input",
 CellID->2751],
Cell[8434, 304, 241, 8, 36, "Output",
 CellID->1699304709]
}, Open  ]],
Cell[8690, 315, 362, 13, 70, "MathCaption",
 CellID->27395],
Cell[CellGroupData[{
Cell[9077, 332, 106, 3, 70, "Input",
 CellID->21228],
Cell[9186, 337, 449, 16, 36, "Output",
 CellID->2078406597]
}, Open  ]],
Cell[9650, 356, 813, 23, 70, "DefinitionBox",
 CellID->30059],
Cell[10466, 381, 71, 1, 70, "Caption",
 CellID->3220],
Cell[10540, 384, 233, 7, 70, "MathCaption",
 CellID->22715],
Cell[CellGroupData[{
Cell[10798, 395, 131, 4, 70, "Input",
 CellID->20944],
Cell[10932, 401, 641, 20, 59, "Output",
 CellID->944929903]
}, Open  ]],
Cell[11588, 424, 218, 7, 70, "MathCaption",
 CellID->323517381],
Cell[CellGroupData[{
Cell[11831, 435, 136, 4, 70, "Input",
 CellID->759639633],
Cell[11970, 441, 441, 15, 52, "Output",
 CellID->880797982]
}, Open  ]],
Cell[12426, 459, 254, 8, 70, "MathCaption",
 CellID->7658],
Cell[CellGroupData[{
Cell[12705, 471, 101, 3, 70, "Input",
 CellID->5384],
Cell[12809, 476, 188, 6, 36, "Output",
 CellID->19791854]
}, Open  ]],
Cell[13012, 485, 229, 7, 70, "MathCaption",
 CellID->30383],
Cell[CellGroupData[{
Cell[13266, 496, 206, 7, 70, "Input",
 CellID->4638],
Cell[13475, 505, 212, 7, 36, "Output",
 CellID->344379505]
}, Open  ]],
Cell[13702, 515, 230, 8, 70, "MathCaption",
 CellID->13635],
Cell[CellGroupData[{
Cell[13957, 527, 218, 8, 70, "Input",
 CellID->5030],
Cell[14178, 537, 333, 11, 49, "Output",
 CellID->450599377]
}, Open  ]],
Cell[CellGroupData[{
Cell[14548, 553, 72, 1, 70, "RelatedTutorialsSection",
 CellID->160360314],
Cell[14623, 556, 175, 4, 70, "RelatedTutorials",
 CellID->91103315]
}, Open  ]]
}, Open  ]],
Cell[14825, 564, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

