(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15223,        459]
NotebookOptionsPosition[      8746,        267]
NotebookOutlinePosition[     13799,        405]
CellTagsIndexPosition[     13518,        391]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"System Administration for Network Licenses" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"], 
         "System Administration for Single-User Licenses" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]\
}, #, 2]& , Evaluator -> Automatic], {
      1->"\<\"System Administration for Network Licenses\"\>", 
      2->"\<\"System Administration for Single-User Licenses\"\>"}, \
"\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Troubleshooting on Windows", "Title",
 CellTags->"i:2",
 CellID->115950173],

Cell[CellGroupData[{

Cell["Passwords", "Section",
 CellTags->{"i:24", "b:5.5", "net: 2"},
 CellID->362746045],

Cell[TextData[{
 "If the front end password dialog box appears when you launch ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", either ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " could not locate the mathpass file or there was no valid password in the \
mathpass file. To resolve this problem, first check that there is a mathpass \
file in one of these directories: ",
 StyleBox[ButtonBox["$BaseDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$BaseDirectory"], "InlineCode"],
 "\\Licensing, ",
 StyleBox[ButtonBox["$InstallationDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$InstallationDirectory"], "InlineCode"],
 "\\Configuration\\Licensing, or ",
 StyleBox[ButtonBox["$UserBaseDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$UserBaseDirectory"], "InlineCode"],
 "\\Licensing",
 ". To find the exact location of these directories on your machine, evaluate \
the command ",
 StyleBox[ButtonBox["$BaseDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$BaseDirectory"], "InlineCode"],
 " (or ",
 StyleBox[ButtonBox["$InstallationDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$InstallationDirectory"], "InlineCode"],
 " or ",
 StyleBox[ButtonBox["$UserBaseDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$UserBaseDirectory"], "InlineCode"],
 ") in a notebook. If you did not find a mathpass file in these locations, \
follow the instructions in \"",
 ButtonBox["Entering a Single-Machine Password",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/EnteringASingleMachinePassword"],
 "\" to re-enter your password. "
}], "Text",
 CellTags->"b:5.5",
 CellID->867215332],

Cell[TextData[{
 "If there is a mathpass file in one of those directories, the password or \
passwords are invalid. Make sure that your MathID number matches the MathID \
number used to issue your password. If your MathID number changes, you will \
need to contact Customer Service to get a new password. Contact information \
is provided in",
 " \"",
 ButtonBox["Registration and Passwords",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/RegistrationAndPasswords"],
 "\"."
}], "Text",
 CellTags->"b:5.5",
 CellID->57565319]
}, Open  ]],

Cell[CellGroupData[{

Cell["Front End Preferences", "Section",
 CellTags->{"i:25", "b:5.5", "net: 3"},
 CellID->308866080],

Cell[TextData[{
 "Front end preferences, such as the locations of recently opened and saved \
files, are stored in a front end initialization file called init.m. This file \
is located in ",
 StyleBox[ButtonBox["$UserBaseDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$UserBaseDirectory"], "InlineCode"],
 "\\FrontEnd",
 ". The default value of ",
 StyleBox[ButtonBox["$UserBaseDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$UserBaseDirectory"], "InlineCode"],
 " for different versions of Windows is listed in \"",
 ButtonBox["Configuration Files on Windows",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ConfigurationFilesOnWindows"],
 "\". To find the exact location of this directory on your machine, evaluate \
the command ",
 StyleBox[ButtonBox["$UserBaseDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$UserBaseDirectory"], "InlineCode"],
 " in a notebook."
}], "Text",
 CellTags->"b:5.5",
 CellID->69939834],

Cell[TextData[{
 "If you need to reset the front end preferences to their default values, \
hold down ",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Ctrl", "KeyEvent"],
 " during startup. This will cause the initialization file to be rebuilt \
automatically. "
}], "Text",
 CellTags->"b:5.5",
 CellID->182638886]
}, Open  ]],

Cell[CellGroupData[{

Cell["Caches", "Section",
 CellTags->{"i:22", "b:5.5", "net: 4"},
 CellID->488554348],

Cell[TextData[{
 "Information about your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system layout, such as the locations of text resource files, is stored in \
caches. These caches are located in C:\\Windows\\Local Settings\\Application \
Data\\Mathematica\\FrontEnd\\6.0 Caches\\ on Windows 98/Me/NT and in \
C:\\Documents and Settings\\",
 Cell[BoxData[
  StyleBox["username", "TI"]], "InlineFormula"],
 "\\Local Settings\\Application Data\\Mathematica\\FrontEnd\\6.0 Caches\\ on \
Windows 2000/XP."
}], "Text",
 CellTags->{"b:5.5", "i:1"},
 CellID->174976620],

Cell[TextData[{
 "A corrupted cache may cause the front end to produce an error or quit \
immediately on startup. The most convenient way to restore the caches to \
their default values is to hold down ",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Ctrl", "KeyEvent"],
 " during startup. This will cause the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " caches and the initialization file to be rebuilt automatically. If you \
want to rebuild your caches but retain your preferences, hold down ",
 StyleBox["Shift", "KeyEvent"],
 " during startup. This will delete and rebuild the cache without rebuilding \
your front end initialization file."
}], "Text",
 CellTags->"b:5.5",
 CellID->47712870]
}, Open  ]],

Cell[CellGroupData[{

Cell["Technical Support", "Section",
 CellTags->{"b:5.5", "net: 5"},
 CellID->129096420],

Cell[TextData[{
 "For further assistance, check the Technical Support FAQs on the web at ",
 ButtonBox["support.wolfram.com",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://support.wolfram.com"], None}],
 ". If you do not find the information you need, please contact Technical \
Support by sending email to ",
 ButtonBox["support@wolfram.com",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["mailto:support@wolfram.com"], None}],
 " or by calling +1-217-398-6500. Include your license ID number in all \
correspondence. Your license ID number is printed on your license \
certificate. It is also available after installation by going to the ",
 StyleBox[ButtonBox["Help",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/HelpMenu"], "MenuName"],
 " menu and clicking ",
 StyleBox[ButtonBox["About Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/AboutMathematica"], "MenuName"],
 ". You must be a registered customer in order to receive installation \
support. You must have a current ",
 StyleBox["Premier Service",
  FontSlant->"Italic"],
 " subscription to receive Technical Support."
}], "Text",
 CellTags->"b:5.5",
 CellID->93880235],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->679274],

Cell[TextData[ButtonBox["System Administration for Network Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]], \
"RelatedTutorials",
 CellID->13855348],

Cell[TextData[ButtonBox["System Administration for Single-User Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]], \
"RelatedTutorials",
 CellID->37939478]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Troubleshooting on Windows - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 44, 25.9846770}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "If the front end password dialog box appears when you launch \
Mathematica, either Mathematica could not locate the mathpass file or there \
was no valid password in the mathpass file. To resolve this problem, first \
check that there is a mathpass file in one of these directories: \
$BaseDirectory\\Licensing, $InstallationDirectory\\Configuration\\Licensing, \
or $UserBaseDirectory\\Licensing. To find the exact location of these \
directories on your machine, evaluate the command $BaseDirectory (or \
$InstallationDirectory or $UserBaseDirectory) in a notebook. If you did not \
find a mathpass file in these locations, follow the instructions in \
\"Entering a Single-Machine Password\" to re-enter your password. If there is \
a mathpass file in one of those directories, the password or passwords are \
invalid. Make sure that your MathID number matches the MathID number used to \
issue your password. If your MathID number changes, you will need to contact \
Customer Service to get a new password. Contact information is provided in \
\"Registration and Passwords\". Front end preferences, such as the locations \
of recently opened and saved files, are stored in a front end initialization \
file called init.m. This file is located in $UserBaseDirectory\\FrontEnd. The \
default value of $UserBaseDirectory for different versions of Windows is \
listed in \"Configuration Files on Windows\". To find the exact location of \
this directory on your machine, evaluate the command $UserBaseDirectory in a \
notebook.", "synonyms" -> {}, "title" -> "Troubleshooting on Windows", "type" -> 
    "Tutorial", "uri" -> "tutorial/TroubleshootingOnWindows"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "i:2"->{
  Cell[1565, 48, 81, 2, 70, "Title",
   CellTags->"i:2",
   CellID->115950173]},
 "i:24"->{
  Cell[1671, 54, 88, 2, 70, "Section",
   CellTags->{"i:24", "b:5.5", "net: 2"},
   CellID->362746045]},
 "b:5.5"->{
  Cell[1671, 54, 88, 2, 70, "Section",
   CellTags->{"i:24", "b:5.5", "net: 2"},
   CellID->362746045],
  Cell[1762, 58, 1657, 43, 70, "Text",
   CellTags->"b:5.5",
   CellID->867215332],
  Cell[3422, 103, 530, 13, 70, "Text",
   CellTags->"b:5.5",
   CellID->57565319],
  Cell[3989, 121, 100, 2, 70, "Section",
   CellTags->{"i:25", "b:5.5", "net: 3"},
   CellID->308866080],
  Cell[4092, 125, 958, 24, 70, "Text",
   CellTags->"b:5.5",
   CellID->69939834],
  Cell[5053, 151, 348, 10, 70, "Text",
   CellTags->"b:5.5",
   CellID->182638886],
  Cell[5438, 166, 85, 2, 70, "Section",
   CellTags->{"i:22", "b:5.5", "net: 4"},
   CellID->488554348],
  Cell[5526, 170, 574, 14, 70, "Text",
   CellTags->{"b:5.5", "i:1"},
   CellID->174976620],
  Cell[6103, 186, 740, 17, 70, "Text",
   CellTags->"b:5.5",
   CellID->47712870],
  Cell[6880, 208, 88, 2, 70, "Section",
   CellTags->{"b:5.5", "net: 5"},
   CellID->129096420],
  Cell[6971, 212, 1174, 29, 70, "Text",
   CellTags->"b:5.5",
   CellID->93880235]},
 "net: 2"->{
  Cell[1671, 54, 88, 2, 70, "Section",
   CellTags->{"i:24", "b:5.5", "net: 2"},
   CellID->362746045]},
 "i:25"->{
  Cell[3989, 121, 100, 2, 70, "Section",
   CellTags->{"i:25", "b:5.5", "net: 3"},
   CellID->308866080]},
 "net: 3"->{
  Cell[3989, 121, 100, 2, 70, "Section",
   CellTags->{"i:25", "b:5.5", "net: 3"},
   CellID->308866080]},
 "i:22"->{
  Cell[5438, 166, 85, 2, 70, "Section",
   CellTags->{"i:22", "b:5.5", "net: 4"},
   CellID->488554348]},
 "net: 4"->{
  Cell[5438, 166, 85, 2, 70, "Section",
   CellTags->{"i:22", "b:5.5", "net: 4"},
   CellID->488554348]},
 "i:1"->{
  Cell[5526, 170, 574, 14, 70, "Text",
   CellTags->{"b:5.5", "i:1"},
   CellID->174976620]},
 "net: 5"->{
  Cell[6880, 208, 88, 2, 70, "Section",
   CellTags->{"b:5.5", "net: 5"},
   CellID->129096420]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"i:2", 11472, 318},
 {"i:24", 11564, 322},
 {"b:5.5", 11681, 326},
 {"net: 2", 12701, 360},
 {"i:25", 12817, 364},
 {"net: 3", 12937, 368},
 {"i:22", 13055, 372},
 {"net: 4", 13174, 376},
 {"i:1", 13290, 380},
 {"net: 5", 13397, 384}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 940, 21, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1565, 48, 81, 2, 70, "Title",
 CellTags->"i:2",
 CellID->115950173],
Cell[CellGroupData[{
Cell[1671, 54, 88, 2, 70, "Section",
 CellTags->{"i:24", "b:5.5", "net: 2"},
 CellID->362746045],
Cell[1762, 58, 1657, 43, 70, "Text",
 CellTags->"b:5.5",
 CellID->867215332],
Cell[3422, 103, 530, 13, 70, "Text",
 CellTags->"b:5.5",
 CellID->57565319]
}, Open  ]],
Cell[CellGroupData[{
Cell[3989, 121, 100, 2, 70, "Section",
 CellTags->{"i:25", "b:5.5", "net: 3"},
 CellID->308866080],
Cell[4092, 125, 958, 24, 70, "Text",
 CellTags->"b:5.5",
 CellID->69939834],
Cell[5053, 151, 348, 10, 70, "Text",
 CellTags->"b:5.5",
 CellID->182638886]
}, Open  ]],
Cell[CellGroupData[{
Cell[5438, 166, 85, 2, 70, "Section",
 CellTags->{"i:22", "b:5.5", "net: 4"},
 CellID->488554348],
Cell[5526, 170, 574, 14, 70, "Text",
 CellTags->{"b:5.5", "i:1"},
 CellID->174976620],
Cell[6103, 186, 740, 17, 70, "Text",
 CellTags->"b:5.5",
 CellID->47712870]
}, Open  ]],
Cell[CellGroupData[{
Cell[6880, 208, 88, 2, 70, "Section",
 CellTags->{"b:5.5", "net: 5"},
 CellID->129096420],
Cell[6971, 212, 1174, 29, 70, "Text",
 CellTags->"b:5.5",
 CellID->93880235],
Cell[CellGroupData[{
Cell[8170, 245, 69, 1, 70, "RelatedTutorialsSection",
 CellID->679274],
Cell[8242, 248, 214, 5, 70, "RelatedTutorials",
 CellID->13855348],
Cell[8459, 255, 221, 5, 70, "RelatedTutorials",
 CellID->37939478]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[8719, 265, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

