(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     58473,       1849]
NotebookOptionsPosition[     50355,       1585]
NotebookOutlinePosition[     53446,       1661]
CellTagsIndexPosition[     53352,       1655]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Structure of Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"The Structure of Graphics and Sound\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Circle" :> Documentation`HelpLookup["paclet:ref/Circle"], 
          "Disk" :> Documentation`HelpLookup["paclet:ref/Disk"], 
          "Graphics Primitives For Text" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GraphicsPrimitivesForText"], "Line" :> 
          Documentation`HelpLookup["paclet:ref/Line"], "Point" :> 
          Documentation`HelpLookup["paclet:ref/Point"], "Polygon" :> 
          Documentation`HelpLookup["paclet:ref/Polygon"], "Raster" :> 
          Documentation`HelpLookup["paclet:ref/Raster"], "Rectangle" :> 
          Documentation`HelpLookup["paclet:ref/Rectangle"], "Text" :> 
          Documentation`HelpLookup["paclet:ref/Text"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Circle\"\>", 2->"\<\"Disk\"\>", 
       3->"\<\"Graphics Primitives For Text\"\>", 4->"\<\"Line\"\>", 
       5->"\<\"Point\"\>", 6->"\<\"Polygon\"\>", 7->"\<\"Raster\"\>", 
       8->"\<\"Rectangle\"\>", 9->"\<\"Text\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\<\
Two\[Hyphen]Dimensional Graphics Elements\
\>", "Title",
 CellTags->{"S2.10.2", "2.1"},
 CellID->32080],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Point",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Point"], "[", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "}", "]"}], Cell[TextData[{
     "point at position ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Line",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Line"], "[", "{", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "1"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "2"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "line through the points ",
     Cell[BoxData["{"], "InlineFormula"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], "1"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["y", "TI"], "1"]], "InlineFormula"],
     "}",
     StyleBox[", ", "TR"],
     Cell[BoxData["{"], "InlineFormula"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], "2"]], "InlineFormula"],
     Cell[BoxData[","], "InlineFormula"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["y", "TI"], "2"]], "InlineFormula"],
     Cell[BoxData["}"], "InlineFormula"],
     ", \[Ellipsis]"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Rectangle",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Rectangle"], "[", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], 
      StyleBox["min", "TI"]], "}", ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["max", "TI"]], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], 
      StyleBox["max", "TI"]], "}", "]"}], Cell[
    "filled rectangle", "TableText"]},
   {
    RowBox[{
     ButtonBox["Polygon",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Polygon"], "[", "{", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "1"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "2"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[
    "filled polygon with the specified list of corners", "TableText"]},
   {
    RowBox[{
     ButtonBox["Circle",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Circle"], "[", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "}", ",", 
     StyleBox["r", "TI"], "]"}], Cell[TextData[{
     "circle with radius ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     " centered at ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Disk",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Disk"], "[", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "}", ",", 
     StyleBox["r", "TI"], "]"}], Cell[TextData[{
     "filled disk with radius ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     " centered at ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Raster",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Raster"], "[", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["a", "TI"], 
         StyleBox["11", "TR"]], ",", 
        SubscriptBox[
         StyleBox["a", "TI"], 
         StyleBox["12", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"], "}", ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["a", "TI"], 
           StyleBox["21", "TR"]], ",", "\[Ellipsis]"}], "}"}], ",", 
        "\[Ellipsis]"}], "}"}]}], "]"}], Cell[TextData[{
     "rectangular array of gray levels between ",
     Cell[BoxData["0"], "InlineFormula"],
     " and ",
     Cell[BoxData["1"], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Text",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Text"], "[", 
     StyleBox["expr", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "}", "]"}], Cell[TextData[{
     "the text of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", centered at ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " (see \"",
     ButtonBox["Graphics Primitives For Text",
      BaseStyle->"Link",
      ButtonData->"paclet:tutorial/GraphicsPrimitivesForText"],
     "\")"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->2021],

Cell["\<\
Basic two\[Hyphen]dimensional graphics elements. \
\>", "Caption",
 CellID->22425],

Cell["Here is a line primitive. ", "MathCaption",
 CellID->17752],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sawline", "=", 
  RowBox[{"Line", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n", ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], "^", "n"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "6"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9204],

Cell[BoxData[
 RowBox[{"Line", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", 
      RowBox[{"-", "1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", 
      RowBox[{"-", "1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"6", ",", "1"}], "}"}]}], "}"}], "]"}]], "Output",
 ImageSize->{375, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->509167989]
}, Open  ]],

Cell["\<\
This shows the line as a two\[Hyphen]dimensional graphics object. \
\>", "MathCaption",
 CellID->19412],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sawgraph", "=", 
  RowBox[{"Graphics", "[", "sawline", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->13004],

Cell[BoxData[
 GraphicsBox[
  LineBox[{{1, -1}, {2, 1}, {3, -1}, {4, 1}, {5, -1}, {6, 1}}]]], "Output",
 ImageSize->{184, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->615398852]
}, Open  ]],

Cell["This redisplays the line, with axes added. ", "MathCaption",
 CellID->28825],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"%", ",", 
   RowBox[{"Axes", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1244],

Cell[BoxData[
 GraphicsBox[LineBox[{{1, -1}, {2, 1}, {3, -1}, {4, 1}, {5, -1}, {6, 1}}],
  Axes->True]], "Output",
 ImageSize->{184, 74},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->86649346]
}, Open  ]],

Cell[TextData[{
 "You can combine graphics objects that you have created explicitly from \
graphics primitives with ones that are produced by functions like ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->26994],

Cell[TextData[{
 "This produces an ordinary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " plot. "
}], "MathCaption",
 CellID->8529],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"Pi", " ", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->20132],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->22943126]
}, Open  ]],

Cell["\<\
This combines the plot with the sawtooth picture made above. \
\>", "MathCaption",
 CellID->22316],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"%", ",", "sawgraph"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->2429],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->536118789]
}, Open  ]],

Cell[TextData[{
 "You can combine different graphical elements simply by giving them in a \
list. In two\[Hyphen]dimensional graphics, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will render the elements in exactly the order you give them. Later \
elements are therefore effectively drawn on top of earlier ones. "
}], "Text",
 CellID->9133],

Cell[TextData[{
 "Here are two blue ",
 Cell[BoxData[
  ButtonBox["Rectangle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rectangle"]], "InlineFormula"],
 " graphics elements. "
}], "MathCaption",
 CellID->12930],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Blue", ",", " ", 
   RowBox[{"Rectangle", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "0.6"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Rectangle", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", ".3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", ".8"}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->10746],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"RGBColor", "[", 
    RowBox[{"0", ",", "0", ",", "1"}], "]"}], ",", 
   RowBox[{"Rectangle", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "0.6`"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Rectangle", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "0.3`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "0.8`"}], "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{545, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->94498335]
}, Open  ]],

Cell["\<\
This draws the rectangles on top of the line that was defined above. \
\>", "MathCaption",
 CellID->25283],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"sawline", ",", "%"}], "}"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->30873],

Cell[BoxData[
 GraphicsBox[{LineBox[{{1, -1}, {2, 1}, {3, -1}, {4, 1}, {5, -1}, {6, 1}}], 
   {RGBColor[0, 0, 1], RectangleBox[{1, -1}, {2, -0.6}], 
    RectangleBox[{4, 0.3}, {5, 0.8}]}}]], "Output",
 ImageSize->{184, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->186736721]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Polygon",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Polygon"]], "InlineFormula"],
 " graphics primitive takes a list of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " coordinates, corresponding to the corners of a polygon. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " joins the last corner with the first one, and then fills the resulting \
area. "
}], "Text",
 CellID->21880],

Cell["\<\
Here are the coordinates of the corners of a regular pentagon. \
\>", "MathCaption",
 CellID->8835],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pentagon", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "Pi", " ", 
        RowBox[{"n", "/", "5"}]}], "]"}], ",", 
      RowBox[{"Cos", "[", 
       RowBox[{"2", " ", "Pi", " ", 
        RowBox[{"n", "/", "5"}]}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "5"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[9]:=",
 CellID->24987],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SqrtBox[
      RowBox[{
       FractionBox["5", "8"], "+", 
       FractionBox[
        SqrtBox["5"], "8"]}]], ",", 
     RowBox[{
      FractionBox["1", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SqrtBox["5"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SqrtBox[
      RowBox[{
       FractionBox["5", "8"], "-", 
       FractionBox[
        SqrtBox["5"], "8"]}]], ",", 
     RowBox[{
      FractionBox["1", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        SqrtBox["5"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        FractionBox["5", "8"], "-", 
        FractionBox[
         SqrtBox["5"], "8"]}]]}], ",", 
     RowBox[{
      FractionBox["1", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        SqrtBox["5"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        FractionBox["5", "8"], "+", 
        FractionBox[
         SqrtBox["5"], "8"]}]]}], ",", 
     RowBox[{
      FractionBox["1", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SqrtBox["5"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{446, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->2050863]
}, Open  ]],

Cell["\<\
This displays the pentagon. With the default choice of aspect ratio, the \
pentagon looks somewhat squashed. \
\>", "MathCaption",
 CellID->25589],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Polygon", "[", "pentagon", "]"}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->7629],

Cell[BoxData[
 GraphicsBox[
  PolygonBox[
   NCache[{{(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2],
       Rational[1, 4] (-1 + 5^Rational[1, 2])}, {(Rational[5, 8] + 
       Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
      Rational[1, 4] (-1 - 5^
       Rational[1, 2])}, {-(Rational[5, 8] + 
        Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
      Rational[1, 4] (-1 - 5^
       Rational[1, 2])}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2])}, {0, 1}}, {{
     0.9510565162951535, 0.30901699437494745`}, {
     0.5877852522924731, -0.8090169943749475}, {-0.5877852522924731, \
-0.8090169943749475}, {-0.9510565162951535, 0.30901699437494745`}, {0, 
     1}}]]]], "Output",
 ImageSize->{184, 171},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->77230955]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Point",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Point"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["pt", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["pt", "TI"], 
        StyleBox["2", "TR"]], ",", "\[Ellipsis]"}], "}"}], "]"}], Cell[
    TextData[{
     "a multipoint consisting of points at ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["pt", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["pt", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", \[Ellipsis]"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Line",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Line"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["line", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["line", "TI"], 
        StyleBox["2", "TR"]], ",", "\[Ellipsis]"}], "}"}], "]"}], Cell[
    TextData[{
     "a multiline consisting of lines ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["line", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["line", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", \[Ellipsis]"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Polygon",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Polygon"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["poly", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["poly", "TI"], 
        StyleBox["2", "TR"]], ",", "\[Ellipsis]"}], "}"}], "]"}], Cell[
    TextData[{
     "a multipolygon consisting of polygons ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["poly", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["poly", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", \[Ellipsis]"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->4706875],

Cell["Primitives which can take multiple elements. ", "Caption",
 CellID->82696337],

Cell[TextData[{
 "A large number of points can be represented by putting a list of \
coordinates inside of a single ",
 Cell[BoxData[
  ButtonBox["Point",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Point"]], "InlineFormula"],
 " primitive. Similarly, a large number of lines or polygons can be \
represented as a list of coordinate lists. This representation is efficient \
and can generally be rendered more quickly by the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end. Graphics directives such as ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 " apply uniformly to the entire set of primitives."
}], "Text",
 CellID->14158757],

Cell["\<\
This creates a multipolygon based upon the set of coordinates defined \
previously.\
\>", "MathCaption",
 CellID->96891115],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Polygon", "[", 
   RowBox[{"{", 
    RowBox[{"pentagon", ",", " ", 
     RowBox[{"1", "+", 
      RowBox[{".5", "pentagon"}]}], ",", " ", 
     RowBox[{"1.5", "+", 
      RowBox[{".2", "pentagon"}]}]}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->512829107],

Cell[GraphicsData["CompressedBitmap", "\<\
eJyFlmtPU0EQhl/kfr+WAiIWRIKKioiAiIiIgChqjDFGjbFyK4qApUEBL9E/
oUaNGj/6lf9X3+1MuhmsLEmf0+fl9NCdmd0wG08lFl7EU8tz8dhUMr6eWJ7b
iE2uJRnl5wHY5etPE/g+zXeZ1246zeu/PEjO8oYbWbtJu57DWshbxm7TZoLW
TN6hXQtaE3mXNh20KHmPNhW0RvI+bTJoEfIB7WrQGshHtImg1ZOPaVeCVkc+
oY0HrZaMG3tKu5zDasg5Y/O0sRxWTS4YW6RdymFV5JKxBG00aJXkM9rFoFWQ
K7SRoJWTq7QLQSsj12nDQSslk7TzQSshU7ShoBWTm7TBoBWRr2kDQSskt4xt
087lsAJyx9gbWn+OO+13sWtwa3+ZrZKtru2K7budHjt1dq7tfnD76GF2x9md
ane4PUPs2WNPt0PkDG02Y23kNKT/XRAHYuQEZIXdkM8A7eQ4ZKU+7SDHIPPr
005yBFKH47y2ZtKj5DCkHj7tIgch+9an3WQ/pD4+PUb2adoDWRtwgjwFqZdP
e9QiJj2pz4voZ1oy6Wldf9SkvWQn5Nz16RmyHVLzXr0CZ8k2vcenbsJa9W/7
1M1rk66pT58vE9eoFfSpm7wG7YxP3QTW0A5rlaKZ1E1iFaR/PnUTWQ7plE/d
ZJZoOgCZLpnQItoRk7qz8wCkfz5dIoe0kvvbova9IWgLOjf1QZsnR3US9pq9
036XhFnDsqnJc9OlFdP1VTOHa2ba183uSZId2gVgg4xBdg+Q0inpyNgm2aI7
ynWzJJO+0ulwaW023dI5qDLpNlmnO8qnO/o8l9ZDzjTgLVmh+8yn78gyrZxP
3+t0uDQCOXeBD2SB9sqnH3U6Iib9TEYhp+v+9olshpzKe3/3xTzzq65WvuM3
shpyKgPfyUo9yYAfZKnWEPhJFusZBfwiC7WSwG/HfGo686Pp//5TRN5f3cPe
0g==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 171},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]=",
 CellID->152467977]
}, Open  ]],

Cell["Here is a multipoint which is colored blue.", "MathCaption",
 CellID->351396055],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Blue", ",", 
     RowBox[{"Point", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "6"}], ",", "6", ",", ".2"}], "}"}]}], "]"}], "]"}]}], 
    "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->328889067],

Cell[GraphicsData["CompressedBitmap", "\<\
eJylWNtuEzEQdbK7ySYoaRty6QVBggoFnioQFIGoWqmiDylvFTxHFVL6gECh
/9DP6DcgVernLfaML7Nnd2kiKtVrr8fnHM+M7XW+zK7m33/Mri4vZuPTxezX
/PLi9/jzz4V+FdWUUrf6/+Wm0vVM1+j/Nsv0U5ZTXUa6q25appLRn6rrakNX
zPMbWZ6BRWSKOLSVSsDiK71+Zcr0+lpXs/k848rBgW32dK8BiVdGf26KFuDK
itqjgVR2/dvx2FTS1FZqNdv0BqOllBi/7JrmWhWyrARNu0HThu++u8uOjrKb
G1tZLGyzZHx/aXUT0+wV1QGZrHgbVtm0SDum1VDmzyB585QiUBwd1EY2uu2V
ozuUeWGzp9PBKbRIGTfPzx2rUttWOaFSHufZth0b46muwJEzkVlpjFsWtyGe
UvUI7Gl8wnCNhkVnttiTaLutgsKYH5EFMitU+QkFM/XQ+klF5KNgGWkma7ZG
qvTsRH8EyjftjLbKIhV5z6j1EiwVaa9b+0HFTIoxGAUvKPbCkLDz2VPlXVMl
rQm3YYUkIQbs49E/dBlI0p14FJ4wzY5VhWitoiqMGlj/qoQdmdcb+dA2Aa0P
7HWLQ6qaIvMVx0DZGNadh1PhHyVXr1NUB4YBKGA/pda6D/mA3hiK3OYMcWvR
ZZixNkQu62hn4dEedmhtmfsR5MVj0LBTksuy/wmM3xKoYd4TsNoE1AH0P4Xx
jEplA/JIi5iAtfMGZhehhp3IAw0DurDerbDGGPYqVD0DPMkS/Ld3T4b0oP8F
jGdUkyl/KCNw18SzPy5dQfiFUjrqf9tmh/BuWmaEP2XQLvXtTO5OS85+1XZg
8w4jp9/LRl4tWHUggi3ox2zuQf8a9OOuhqdME/hol6GzTa64fbDqWf+vw/t9
GLch0IKmN+QOtuKdSu5l7mxzJ30XMF8DGnOQkpJ1RlyJP+ssPnoF99IOcBBn
yWrvBm5h/c5Za0BnbQ4AjDWytivm8BbwJWvw/UEGa5fO9jJO02wD5ntAY44O
+P6D4PDz86sRudqA+RHQHgiOoIQ4mvJ7IYzAnQjXfxMYDgGbGam0XxzTqVRH
p2ScibUcZWGnMc8UEA8rMoPs2DpE1A/7ZKOgEvu54yaZy/ykIh+O6X3xo5+/
Y6hsFTlDHA7Ba/WApxyecrtwu3Q39agnxiaF7/c4tmZRUNQoCjku09H3eZUX
5C+Yyt80i7eSU4osN/v93HejzZXghZOy1diC3M5dKCli+pwKF4ozwGSm0vt6
V2Z0luXugMzl35xXoyxx659mxZtS+C2h+DuEqv0F3f1Fpg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]=",
 CellID->938632423]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Circle",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Circle"], "[", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "}", ",", 
     StyleBox["r", "TI"], "]"}], Cell[TextData[{
     "a circle with radius ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     " centered at the point ",
     Cell[BoxData[
      RowBox[{"{", 
       StyleBox["x", "TI"], ",", 
       StyleBox["y", "TI"], "}"}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Circle",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Circle"], "[", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["r", "TI"], 
      StyleBox["x", "TI"]], ",", 
     SubscriptBox[
      StyleBox["r", "TI"], 
      StyleBox["y", "TI"]], "}", "]"}], Cell[TextData[{
     "an ellipse with semi\[Hyphen]axes ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["x", "TI"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["y", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Circle",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Circle"], "[", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "}", ",", 
     StyleBox["r", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["theta", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["theta", "TI"], "2"], "}", "]"}], Cell[
    "a circular arc", "TableText"]},
   {
    RowBox[{
     ButtonBox["Circle",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Circle"], "[", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["r", "TI"], 
      StyleBox["x", "TI"]], ",", 
     SubscriptBox[
      StyleBox["r", "TI"], 
      StyleBox["y", "TI"]], "}", ",", "{", 
     SubscriptBox[
      StyleBox["theta", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["theta", "TI"], "2"], "}", "]"}], Cell[
    "an elliptical arc", "TableText"]},
   {
    RowBox[{
     ButtonBox["Disk",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Disk"], "[", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "}", ",", 
     StyleBox["r", "TI"], "]", Cell[",  etc.", "TableText"]}], Cell[
    "filled disks", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->24705],

Cell["Circles and disks. ", "Caption",
 CellID->2815],

Cell["This shows two circles with radius 2.", "MathCaption",
 CellID->10713],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", "2"}], "]"}], ",", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", "2"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[25]:=",
 CellID->22334],

Cell[BoxData[
 GraphicsBox[{CircleBox[{0, 0}, 2], CircleBox[{1, 1}, 2]}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]=",
 CellID->661311259]
}, Open  ]],

Cell[TextData[{
 "This shows a sequence of disks with progressively larger semi\[Hyphen]axes \
in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction, and progressively smaller ones in the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " direction. "
}], "MathCaption",
 CellID->13137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Disk", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"3", "n"}], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"n", "/", "4"}], ",", 
        RowBox[{"2", "-", 
         RowBox[{"n", "/", "4"}]}]}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "4"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[26]:=",
 CellID->25615],

Cell[BoxData[
 GraphicsBox[{
   DiskBox[{3, 0}, NCache[{Rational[1, 4], Rational[7, 4]}, {0.25, 1.75}]], 
   DiskBox[{6, 0}, NCache[{Rational[1, 2], Rational[3, 2]}, {0.5, 1.5}]], 
   DiskBox[{9, 0}, NCache[{Rational[3, 4], Rational[5, 4]}, {0.75, 1.25}]], 
   DiskBox[{12, 0}]}]], "Output",
 ImageSize->{184, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]=",
 CellID->21574223]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows you to generate arcs of circles, and segments of ellipses. In both \
cases, the objects are specified by starting and finishing angles. The angles \
are measured counterclockwise in radians with zero corresponding to the \
positive ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction. "
}], "Text",
 CellID->32058],

Cell[TextData[{
 "This draws a ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["140", "\[EmptySmallCircle]"], TraditionalForm]], 
  "InlineMath"],
 " wedge centered at the origin. "
}], "MathCaption",
 CellID->23511],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Disk", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", "1", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"140", " ", "Degree"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->8383],

Cell[BoxData[
 GraphicsBox[DiskBox[{0, 0}, 1, {0, 2.4435}],
  AspectRatio->Automatic]], "Output",
 ImageSize->{184, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]= ",
 CellID->6846]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Raster",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Raster"], "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["a", "TI"], "11"], ",", 
         SubscriptBox[
          StyleBox["a", "TI"], "12"], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["a", "TI"], "21"], Cell[
         ", \[Ellipsis] }, \[Ellipsis] }]", "TableText"], 
         StyleBox[" ", "TR"]}]}]}]}]}], Cell[
    "array of gray levels between 0 and 1", "TableText"]},
   {
    RowBox[{
     ButtonBox["Raster",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Raster"], "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["a", "TI"], 
            StyleBox["11", "TR"]], ",", 
           SubscriptBox[
            StyleBox["o", "TI"], 
            StyleBox["11", "TR"]]}], "}"}], ",", "\[Ellipsis]"}], "}"}], ",", 
       "\[Ellipsis]"}], "}"}], "]"}], Cell[
    "array of gray levels with opacity between 0 and 1", "TableText"]},
   {
    RowBox[{
     ButtonBox["Raster",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Raster"], "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["r", "TI"], 
            StyleBox["11", "TR"]], ",", 
           SubscriptBox[
            StyleBox["g", "TI"], 
            StyleBox["11", "TR"]], ",", 
           SubscriptBox[
            StyleBox["b", "TI"], 
            StyleBox["11", "TR"]]}], "}"}], ",", "\[Ellipsis]"}], "}"}], ",", 
       "\[Ellipsis]"}], "}"}], "]"}], Cell[
    "array of rgb values between 0 and 1", "TableText"]},
   {
    RowBox[{
     ButtonBox["Raster",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Raster"], "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["r", "TI"], 
            StyleBox["11", "TR"]], ",", 
           SubscriptBox[
            StyleBox["g", "TI"], 
            StyleBox["11", "TR"]], ",", 
           SubscriptBox[
            StyleBox["b", "TI"], 
            StyleBox["11", "TR"]], ",", 
           SubscriptBox[
            StyleBox["o", "TI"], 
            StyleBox["11", "TR"]]}], "}"}], ",", "\[Ellipsis]"}], "}"}], ",", 
       "\[Ellipsis]"}], "}"}], "]"}], Cell[
    "array of rgb values with opacity between 0 and 1", "TableText"]},
   {
    RowBox[{
     ButtonBox["Raster",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Raster"], "[", 
     StyleBox["array", "TI"], ",", "{", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], 
      StyleBox["min", "TI"]], "}", ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["max", "TI"]], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], 
      StyleBox["max", "TI"]], "}", "}", ",", "{", 
     SubscriptBox[
      StyleBox["z", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["z", "TI"], 
      StyleBox["max", "TI"]], "}", "]"}], Cell[TextData[{
     "array of gray levels between ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     " drawn in the rectangle defined by ",
     Cell[BoxData["{"], "InlineFormula"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     "}",
     StyleBox[" and ", "TR"],
     Cell[BoxData["{"], "InlineFormula"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     Cell[BoxData[","], "InlineFormula"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     Cell[BoxData["}"], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->20943],

Cell["\<\
Raster\[Hyphen]based graphics elements. \
\>", "Caption",
 CellID->32737],

Cell[TextData[{
 "Here is a ",
 Cell[BoxData[
  FormBox[
   RowBox[{"4", "\[Cross]", "4"}], TraditionalForm]], "InlineMath"],
 " array of values between 0 and 1. "
}], "MathCaption",
 CellID->29831],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"modtab", "=", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{"i", ",", "j"}], "]"}], "/", "3"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "4"}], "}"}]}], "]"}], "//", "N"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28655],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0.`", ",", "0.3333333333333333`", ",", "0.3333333333333333`", ",", 
     "0.3333333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.`", ",", "0.`", ",", "0.6666666666666666`", ",", 
     "0.6666666666666666`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.3333333333333333`", ",", "0.`", ",", "1.`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.`", ",", "0.3333333333333333`", ",", "0.`"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{447, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->73449267]
}, Open  ]],

Cell["This uses the array of values as gray levels in a raster. ", \
"MathCaption",
 CellID->24351],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Raster", "[", "modtab", "]"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->13290],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwbAFhCQYg+z+QBcZb
/v8H0pgkC5DUBipoDA0NZRkVGRUZsSJhQJGwVatWjYqMioxcEVC+0AbmCxCt
Pyo6KjoqOshFw5BEWUZFR0VHRQexKK5+GAMjADFKf6M=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->980484902]
}, Open  ]],

Cell["This shows two overlapping copies of the raster. ", "MathCaption",
 CellID->12295],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Raster", "[", 
     RowBox[{"modtab", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "2"}], "}"}]}], "}"}]}], "]"}], ",", 
    RowBox[{"Raster", "[", 
     RowBox[{"modtab", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1.5", ",", "1.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", "2"}], "}"}]}], "}"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->24420],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwbAHiKgkGIPs/kAXG
W/7/B9KYJAuQlAUqCAsNDbUdFRlRIpZAEatVq1aNiox0EVDakAGmDRAdNSo6
KkojUVDKkwWKigJpRyDNMkxktIG0NjBHDS0ZkH/EoLTUsJAF+VUUSIsxQMSH
piyuthoDIwA65dgD\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->79269685]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " option can be used to change the default way in which a ",
 Cell[BoxData[
  ButtonBox["Raster",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Raster"]], "InlineFormula"],
 " is colored."
}], "MathCaption",
 CellID->20428997],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Raster", "[", 
    RowBox[{"modtab", ",", 
     RowBox[{"ColorFunction", "\[Rule]", "Hue"}]}], "]"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->28665256],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwbAFhCQYg+z+QBcZb
/v8H0pgkC5DUBtKNQGUsoyKjIiNWJAxIhwFzyqjIqMjIFQHlC21gvgiD8kdF
R0VHRQezaBhUVHtUdFR0VHSQi+LqhzEwAgDqsVXb\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->339678368]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->605666],

Cell[TextData[ButtonBox["The Structure of Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]], \
"RelatedTutorials",
 CellID->1229394717]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Two-Dimensional Graphics Elements - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["The Structure of Graphics and Sound", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TheStructureOfGraphics"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/GraphicsDirectivesAndOptions"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 44, 26.2659342}", "context" -> "", 
    "keywords" -> {
     "arcs", "arrays", "AspectRatio", "aspect ratio", "bitmap", "blob", 
      "cell array", "circle", "ColorFunction", "color map", "density map", 
      "disk", "ellipse", "filled region", "folded polygons", 
      "geometrical figures", "graphics", "graphics primitives", "grid", 
      "image array", "line", "opaque ink", "oval", "Pentagon", "pie slices", 
      "pixel array", "point", "polygon", "polygons", "Polyline", "raster", 
      "RasterArray", "rectangle", "region", "rendering", "segments", 
      "self-intersection", "squashing", "text", "two-dimensional graphics", 
      "wedges"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Basic two-dimensional graphics elements. Here is a line primitive. This \
shows the line as a two-dimensional graphics object. ", "synonyms" -> {}, 
    "title" -> "Two-Dimensional Graphics Elements", "type" -> "Tutorial", 
    "uri" -> "tutorial/TwoDimensionalGraphicsElements"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.10.2"->{
  Cell[2669, 71, 113, 4, 70, "Title",
   CellTags->{"S2.10.2", "2.1"},
   CellID->32080]},
 "2.1"->{
  Cell[2669, 71, 113, 4, 70, "Title",
   CellTags->{"S2.10.2", "2.1"},
   CellID->32080]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.10.2", 53137, 1644},
 {"2.1", 53238, 1648}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2044, 44, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2669, 71, 113, 4, 70, "Title",
 CellTags->{"S2.10.2", "2.1"},
 CellID->32080],
Cell[2785, 77, 5402, 179, 70, "DefinitionBox",
 CellID->2021],
Cell[8190, 258, 92, 3, 70, "Caption",
 CellID->22425],
Cell[8285, 263, 65, 1, 70, "MathCaption",
 CellID->17752],
Cell[CellGroupData[{
Cell[8375, 268, 370, 13, 28, "Input",
 CellID->9204],
Cell[8748, 283, 648, 23, 36, "Output",
 CellID->509167989]
}, Open  ]],
Cell[9411, 309, 113, 3, 70, "MathCaption",
 CellID->19412],
Cell[CellGroupData[{
Cell[9549, 316, 136, 4, 28, "Input",
 CellID->13004],
Cell[9688, 322, 234, 7, 98, "Output",
 CellID->615398852]
}, Open  ]],
Cell[9937, 332, 82, 1, 70, "MathCaption",
 CellID->28825],
Cell[CellGroupData[{
Cell[10044, 337, 149, 5, 70, "Input",
 CellID->1244],
Cell[10196, 344, 244, 7, 95, "Output",
 CellID->86649346]
}, Open  ]],
Cell[10455, 354, 304, 9, 70, "Text",
 CellID->26994],
Cell[10762, 365, 140, 6, 70, "MathCaption",
 CellID->8529],
Cell[CellGroupData[{
Cell[10927, 375, 235, 8, 28, "Input",
 CellID->20132],
Cell[11165, 385, 3676, 64, 128, "Output",
 Evaluatable->False,
 CellID->22943126]
}, Open  ]],
Cell[14856, 452, 108, 3, 70, "MathCaption",
 CellID->22316],
Cell[CellGroupData[{
Cell[14989, 459, 125, 4, 28, "Input",
 CellID->2429],
Cell[15117, 465, 6077, 104, 128, "Output",
 Evaluatable->False,
 CellID->536118789]
}, Open  ]],
Cell[21209, 572, 352, 8, 70, "Text",
 CellID->9133],
Cell[21564, 582, 218, 8, 70, "MathCaption",
 CellID->12930],
Cell[CellGroupData[{
Cell[21807, 594, 515, 18, 70, "Input",
 CellID->10746],
Cell[22325, 614, 675, 23, 36, "Output",
 CellID->94498335]
}, Open  ]],
Cell[23015, 640, 116, 3, 70, "MathCaption",
 CellID->25283],
Cell[CellGroupData[{
Cell[23156, 647, 153, 5, 70, "Input",
 CellID->30873],
Cell[23312, 654, 331, 8, 98, "Output",
 CellID->186736721]
}, Open  ]],
Cell[23658, 665, 540, 18, 70, "Text",
 CellID->21880],
Cell[24201, 685, 109, 3, 70, "MathCaption",
 CellID->8835],
Cell[CellGroupData[{
Cell[24335, 692, 457, 15, 70, "Input",
 CellID->24987],
Cell[24795, 709, 1570, 63, 124, "Output",
 CellID->2050863]
}, Open  ]],
Cell[26380, 775, 156, 4, 70, "MathCaption",
 CellID->25589],
Cell[CellGroupData[{
Cell[26561, 783, 141, 4, 70, "Input",
 CellID->7629],
Cell[26705, 789, 915, 20, 192, "Output",
 CellID->77230955]
}, Open  ]],
Cell[27635, 812, 2540, 89, 70, "DefinitionBox",
 CellID->4706875],
Cell[30178, 903, 83, 1, 70, "Caption",
 CellID->82696337],
Cell[30264, 906, 729, 19, 70, "Text",
 CellID->14158757],
Cell[30996, 927, 133, 4, 70, "MathCaption",
 CellID->96891115],
Cell[CellGroupData[{
Cell[31154, 935, 329, 10, 28, "Input",
 CellID->512829107],
Cell[31486, 947, 1194, 24, 192, "Output",
 Evaluatable->False,
 CellID->152467977]
}, Open  ]],
Cell[32695, 974, 86, 1, 70, "MathCaption",
 CellID->351396055],
Cell[CellGroupData[{
Cell[32806, 979, 523, 17, 28, "Input",
 CellID->328889067],
Cell[33332, 998, 1542, 29, 62, "Output",
 Evaluatable->False,
 CellID->938632423]
}, Open  ]],
Cell[34889, 1030, 2802, 91, 70, "DefinitionBox",
 CellID->24705],
Cell[37694, 1123, 53, 1, 70, "Caption",
 CellID->2815],
Cell[37750, 1126, 76, 1, 70, "MathCaption",
 CellID->10713],
Cell[CellGroupData[{
Cell[37851, 1131, 383, 14, 70, "Input",
 CellID->22334],
Cell[38237, 1147, 217, 6, 201, "Output",
 CellID->661311259]
}, Open  ]],
Cell[38469, 1156, 338, 10, 70, "MathCaption",
 CellID->13137],
Cell[CellGroupData[{
Cell[38832, 1170, 489, 17, 70, "Input",
 CellID->25615],
Cell[39324, 1189, 422, 10, 88, "Output",
 CellID->21574223]
}, Open  ]],
Cell[39761, 1202, 417, 11, 70, "Text",
 CellID->32058],
Cell[40181, 1215, 215, 8, 70, "MathCaption",
 CellID->23511],
Cell[CellGroupData[{
Cell[40421, 1227, 302, 10, 70, "Input",
 CellID->8383],
Cell[40726, 1239, 226, 7, 126, "Output",
 CellID->6846]
}, Open  ]],
Cell[40967, 1249, 4781, 155, 70, "DefinitionBox",
 CellID->20943],
Cell[45751, 1406, 83, 3, 70, "Caption",
 CellID->32737],
Cell[45837, 1411, 198, 7, 70, "MathCaption",
 CellID->29831],
Cell[CellGroupData[{
Cell[46060, 1422, 379, 13, 70, "Input",
 CellID->28655],
Cell[46442, 1437, 675, 21, 54, "Output",
 CellID->73449267]
}, Open  ]],
Cell[47132, 1461, 99, 2, 70, "MathCaption",
 CellID->24351],
Cell[CellGroupData[{
Cell[47256, 1467, 138, 4, 28, "Input",
 CellID->13290],
Cell[47397, 1473, 379, 10, 201, "Output",
 Evaluatable->False,
 CellID->980484902]
}, Open  ]],
Cell[47791, 1486, 88, 1, 70, "MathCaption",
 CellID->12295],
Cell[CellGroupData[{
Cell[47904, 1491, 632, 22, 28, "Input",
 CellID->24420],
Cell[48539, 1515, 411, 11, 143, "Output",
 Evaluatable->False,
 CellID->79269685]
}, Open  ]],
Cell[48965, 1529, 384, 13, 70, "MathCaption",
 CellID->20428997],
Cell[CellGroupData[{
Cell[49374, 1546, 239, 8, 28, "Input",
 CellID->28665256],
Cell[49616, 1556, 375, 10, 201, "Output",
 Evaluatable->False,
 CellID->339678368]
}, Open  ]],
Cell[CellGroupData[{
Cell[50028, 1571, 69, 1, 70, "RelatedTutorialsSection",
 CellID->605666],
Cell[50100, 1574, 201, 5, 70, "RelatedTutorials",
 CellID->1229394717]
}, Open  ]]
}, Open  ]],
Cell[50328, 1583, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

