(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22715,        945]
NotebookOptionsPosition[     13594,        645]
NotebookOutlinePosition[     17209,        753]
CellTagsIndexPosition[     17137,        748]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Entering Two-Dimensional Expressions" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/EnteringTwoDimensionalExpressionsOverview"]}, #, 
        2]& , Evaluator -> Automatic], {
      1->"\<\"Entering Two-Dimensional Expressions\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Typing Fractions", "Title",
 CellID->1096810355],

Cell[CellGroupData[{

Cell[TextData[{
 "Typing",
 " ",
 Cell[BoxData[
  FormBox[
   FractionBox["x", "y"], TraditionalForm]]]
}], "Section",
 CellID->1239934002],

Cell["Start with the expression that will be the numerator. ", "Text",
 CellID->389461126],

Cell[TextData[{
 "Type ",
 Cell[BoxData["x"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->142988626],

Cell[BoxData[
 RowBox[{"x", 
  StyleBox["\[VerticalSeparator]",
   FontWeight->"Plain"]}]], "Input",
 CellID->175636189],

Cell[TextData[{
 "Create a built-up fraction by pressing the ",
 StyleBox["Control", "KeyEvent"],
 " and ",
 StyleBox["/", "KeyEvent"],
 " keys at the same time. The placeholder in the denominator is already \
selected. "
}], "Text",
 CellID->1274897545],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["/", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->1758692696],

Cell[BoxData[
 FractionBox["x", 
  StyleBox["\[Placeholder]",
   DrawHighlighted->1]]], "Input",
 CellID->383224364],

Cell["Fill in the denominator. ", "Text",
 CellID->548428395],

Cell[TextData[{
 "Type ",
 Cell[BoxData["y"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->436221841],

Cell[BoxData[
 FractionBox["x", 
  RowBox[{"y", 
   StyleBox["\[VerticalSeparator]",
    FontWeight->"Plain"]}]]], "Input",
 CellID->71310829],

Cell[TextData[{
 "Move the insertion point out of the fraction by pressing the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["Space", "KeyEvent"],
 " bar at the same time. "
}], "Text",
 CellID->225227977],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->1540423425],

Cell[BoxData[
 RowBox[{
  FractionBox["x", "y"], 
  StyleBox["\[VerticalSeparator]",
   FontWeight->"Plain"]}]], "Input",
 CellID->1981139390]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Typing",
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["x", "y"], "+", "z"}], TraditionalForm]]]
}], "Section",
 CellID->275780995],

Cell["Start with the expression that will be the numerator. ", "Text",
 CellID->781472739],

Cell[TextData[{
 "Type ",
 Cell[BoxData["x"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->202339321],

Cell[BoxData[
 RowBox[{"x", 
  StyleBox["\[VerticalSeparator]",
   FontWeight->"Plain"]}]], "Input",
 CellID->1250354846],

Cell[TextData[{
 "Create a built-up fraction by pressing the ",
 StyleBox["Control", "KeyEvent"],
 " and ",
 StyleBox["/", "KeyEvent"],
 " keys at the same time. The placeholder in the denominator is already \
selected. "
}], "Text",
 CellTags->"fractions",
 CellID->1586410827],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["/", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->1797291884],

Cell[BoxData[
 FractionBox["x", 
  StyleBox["\[Placeholder]",
   DrawHighlighted->1]]], "Input",
 CellID->579715686],

Cell["Fill in the denominator. ", "Text",
 CellTags->"fractions",
 CellID->148228163],

Cell[TextData[{
 "Type ",
 Cell[BoxData["y"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->189705021],

Cell[BoxData[
 FractionBox["x", 
  RowBox[{"y", 
   StyleBox["\[VerticalSeparator]",
    FontWeight->"Plain"]}]]], "Input",
 CellID->1506555799],

Cell[TextData[{
 "Move the insertion point out of the fraction by pressing the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["Space", "KeyEvent"],
 " bar at the same time. "
}], "Text",
 CellID->1851115663],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->1105353952],

Cell[BoxData[
 RowBox[{
  FractionBox["x", "y"], 
  StyleBox["\[VerticalSeparator]",
   FontWeight->"Plain"]}]], "Input",
 CellID->1950324714],

Cell["\<\
Once the insertion point is out of the fraction, you can continue typing. \
\>", "Text",
 CellID->2064564037],

Cell[TextData[{
 "Type ",
 Cell[BoxData[
  RowBox[{"+", "z"}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->87001633],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["x", "y"], "+", "z"}], 
  StyleBox["\[VerticalSeparator]",
   FontWeight->"Plain"]}]], "Input",
 CellID->1947565871]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Typing",
 " ",
 Cell[BoxData[
  FormBox[
   FractionBox["x", 
    RowBox[{"y", "+", "z"}]], TraditionalForm]]]
}], "Section",
 CellID->793846323],

Cell["Start with the expression that will be the numerator. ", "Text",
 CellID->2006735497],

Cell[TextData[{
 "Type ",
 Cell[BoxData["x"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->972821944],

Cell[BoxData[
 RowBox[{"x", 
  StyleBox["\[VerticalSeparator]",
   FontWeight->"Plain"]}]], "Input",
 CellID->1425408197],

Cell[TextData[{
 "Create a built-up fraction by pressing the ",
 StyleBox["Control", "KeyEvent"],
 " and ",
 StyleBox["/", "KeyEvent"],
 " keys at the same time. The placeholder in the denominator is already \
selected. "
}], "Text",
 CellID->1655484694],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["/", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->933121526],

Cell[BoxData[
 FractionBox["x", 
  StyleBox["\[Placeholder]",
   DrawHighlighted->1]]], "Input",
 CellID->2047897088],

Cell["Fill in the denominator. ", "Text",
 CellID->1285947547],

Cell[TextData[{
 "Type ",
 Cell[BoxData["y"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->644999021],

Cell[BoxData[
 FractionBox["x", 
  RowBox[{"y", 
   StyleBox["\[VerticalSeparator]",
    FontWeight->"Plain"]}]]], "Input",
 CellID->1095891],

Cell["\<\
Continue typing in the denominator and then move out of the fraction. \
\>", "Text",
 CellTags->"fractions",
 CellID->1238770861],

Cell[TextData[{
 "Type ",
 Cell[BoxData[
  RowBox[{"+", "z"}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->167903162],

Cell[BoxData[
 RowBox[{
  FractionBox["x", 
   RowBox[{"y", "+", "z"}]], 
  StyleBox["\[VerticalSeparator]",
   FontWeight->"Plain"]}]], "Input",
 CellTags->"fractions",
 CellID->154931576],

Cell[TextData[{
 "Move the insertion point out of the fraction by pressing the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["Space", "KeyEvent"],
 " bar at the same time. "
}], "Text",
 CellID->1184817668],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->1762171092],

Cell[BoxData[
 RowBox[{
  FractionBox["x", 
   RowBox[{"y", "+", "z"}]], 
  StyleBox["\[VerticalSeparator]",
   FontWeight->"Plain"]}]], "Input",
 CellTags->"fractions",
 CellID->862567467]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Typing",
 " ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{"x", "+", "y"}], "z"], TraditionalForm]]]
}], "Section",
 CellID->1656800619],

Cell[TextData[{
 "Create a built-up fraction with ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["/", "KeyEvent"],
 ". The numerator and denominator contain placeholders; the one in the \
numerator is selected. "
}], "Text",
 CellID->1575036531],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["/", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->1755543595],

Cell[BoxData[
 FractionBox[
  StyleBox["\[Placeholder]",
   DrawHighlighted->1], "\[Placeholder]"]], "Input",
 CellTags->"fractions",
 CellID->1143375032],

Cell["Type an expression in the numerator. ", "Text",
 CellTags->"fractions",
 CellID->1020489468],

Cell[TextData[{
 "Type ",
 Cell[BoxData[
  RowBox[{"x", "+", "y"}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->1562083734],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"x", "+", "y"}], 
   StyleBox["\[VerticalSeparator]",
    FontWeight->"Plain"]}], "\[Placeholder]"]], "Input",
 CellTags->"fractions",
 CellID->953732763],

Cell[TextData[{
 "Select the placeholder in the denominator by pressing the ",
 StyleBox["Tab", "KeyEvent"],
 " key. (Alternatively, you can select the placeholder by clicking it or \
dragging.) "
}], "Text",
 CellID->568606533],

Cell[TextData[{
 "Press ",
 StyleBox["Tab", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->267770981],

Cell[BoxData[
 FractionBox[
  RowBox[{"x", "+", "y"}], 
  StyleBox["\[Placeholder]",
   DrawHighlighted->1]]], "Input",
 CellTags->"fractions",
 CellID->1448637202],

Cell["Fill in the numerator.", "Text",
 CellID->1223347975],

Cell[TextData[{
 "Type ",
 Cell[BoxData["z"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->800979447],

Cell[BoxData[
 FractionBox[
  RowBox[{"x", "+", "y"}], 
  RowBox[{"z", "|"}]]], "Input",
 CellTags->"fractions",
 CellID->1634066333],

Cell[TextData[{
 "Get out of the fraction by pressing the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["Space", "KeyEvent"],
 " bar at the same time. "
}], "Text",
 CellID->1731980895],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->262067180],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"x", "+", "y"}], "z"], "\[VerticalSeparator]"}]], "Input",
 CellTags->"fractions",
 CellID->74134263]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Another Way of ",
 "Typing",
 " ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{"x", "+", "y"}], "z"], TraditionalForm]]]
}], "Section",
 CellID->434042981],

Cell["Start with the expression that will be the numerator. ", "Text",
 CellTags->"fractions",
 CellID->2105916455],

Cell[TextData[{
 "Type ",
 Cell[BoxData[
  RowBox[{"x", "+", "y"}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->1459872978],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "+", "y"}], 
  StyleBox["\[VerticalSeparator]",
   FontWeight->"Plain"]}]], "Input",
 CellTags->"fractions",
 CellID->1084474271],

Cell[TextData[{
 "Select the expression. (You can select by dragging, by pressing ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox[".", "KeyEvent"],
 " repeatedly, or by clicking the expression repeatedly.) "
}], "Text",
 CellTags->"fractions",
 CellID->1065360608],

Cell["Select it.", "MathCaption",
 CellID->1944573617],

Cell[BoxData[
 StyleBox[
  RowBox[{"x", "+", "y"}],
  DrawHighlighted->1]], "Input",
 CellTags->"fractions",
 CellID->2042640873],

Cell[TextData[{
 "Create a built-up fraction by pressing ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["/", "KeyEvent"],
 ". "
}], "Text",
 CellID->991571569],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["/", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->870259463],

Cell[BoxData[
 FractionBox[
  RowBox[{"x", "+", "y"}], 
  StyleBox["\[Placeholder]",
   DrawHighlighted->1]]], "Input",
 CellTags->"fractions",
 CellID->2087158571],

Cell["Fill in the denominator.", "Text",
 CellID->1876212699],

Cell[TextData[{
 "Type ",
 Cell[BoxData["z"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->2004443192],

Cell[BoxData[
 FractionBox[
  RowBox[{"x", "+", "y"}], 
  RowBox[{"z", "|"}]]], "Input",
 CellTags->"fractions",
 CellID->1100757455],

Cell[TextData[{
 "Get out of the fraction by pressing the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["Space", "KeyEvent"],
 " bar at the same time. "
}], "Text",
 CellID->18168772],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->1960224895],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"x", "+", "y"}], "z"], "\[VerticalSeparator]"}]], "Input",
 CellTags->"fractions",
 CellID->953181638],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->167598681],

Cell[TextData[ButtonBox["Entering Two-Dimensional Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EnteringTwoDimensionalExpressionsOverview"]], \
"RelatedTutorials",
 CellID->161747686]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Typing Fractions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Entering Two-Dimensional Expressions", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/EnteringTwoDimensionalExpressionsOverview"]], "Text",
       FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TypingPowers"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 44, 28.5784934}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Start with the expression that will be the numerator. Type x. Create a \
built-up fraction by pressing the Control and / keys at the same time. The \
placeholder in the denominator is already selected. ", "synonyms" -> {}, 
    "title" -> "Typing Fractions", "type" -> "Tutorial", "uri" -> 
    "tutorial/TypingFractions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "fractions"->{
  Cell[3794, 170, 278, 9, 70, "Text",
   CellTags->"fractions",
   CellID->1586410827],
  Cell[4364, 196, 85, 2, 70, "Text",
   CellTags->"fractions",
   CellID->148228163],
  Cell[7067, 331, 139, 4, 70, "Text",
   CellTags->"fractions",
   CellID->1238770861],
  Cell[7337, 345, 189, 7, 70, "Input",
   CellTags->"fractions",
   CellID->154931576],
  Cell[7931, 372, 189, 7, 70, "Input",
   CellTags->"fractions",
   CellID->862567467],
  Cell[8776, 413, 154, 5, 70, "Input",
   CellTags->"fractions",
   CellID->1143375032],
  Cell[8933, 420, 98, 2, 70, "Text",
   CellTags->"fractions",
   CellID->1020489468],
  Cell[9168, 432, 204, 7, 70, "Input",
   CellTags->"fractions",
   CellID->953732763],
  Cell[9709, 456, 164, 6, 70, "Input",
   CellTags->"fractions",
   CellID->1448637202],
  Cell[10048, 474, 133, 5, 70, "Input",
   CellTags->"fractions",
   CellID->1634066333],
  Cell[10564, 499, 151, 5, 70, "Input",
   CellTags->"fractions",
   CellID->74134263],
  Cell[10938, 520, 115, 2, 70, "Text",
   CellTags->"fractions",
   CellID->2105916455],
  Cell[11190, 532, 168, 6, 70, "Input",
   CellTags->"fractions",
   CellID->1084474271],
  Cell[11361, 540, 297, 8, 70, "Text",
   CellTags->"fractions",
   CellID->1065360608],
  Cell[11718, 553, 129, 5, 70, "Input",
   CellTags->"fractions",
   CellID->2042640873],
  Cell[12215, 578, 164, 6, 70, "Input",
   CellTags->"fractions",
   CellID->2087158571],
  Cell[12557, 596, 133, 5, 70, "Input",
   CellTags->"fractions",
   CellID->1100757455],
  Cell[13072, 621, 152, 5, 70, "Input",
   CellTags->"fractions",
   CellID->953181638]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"fractions", 15517, 690}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 684, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1309, 44, 54, 1, 70, "Title",
 CellID->1096810355],
Cell[CellGroupData[{
Cell[1388, 49, 139, 7, 70, "Section",
 CellID->1239934002],
Cell[1530, 58, 90, 1, 70, "Text",
 CellID->389461126],
Cell[1623, 61, 107, 5, 70, "MathCaption",
 CellID->142988626],
Cell[1733, 68, 120, 4, 70, "Input",
 CellID->175636189],
Cell[1856, 74, 254, 8, 70, "Text",
 CellID->1274897545],
Cell[2113, 84, 167, 7, 70, "MathCaption",
 CellID->1758692696],
Cell[2283, 93, 116, 4, 70, "Input",
 CellID->383224364],
Cell[2402, 99, 61, 1, 70, "Text",
 CellID->548428395],
Cell[2466, 102, 107, 5, 70, "MathCaption",
 CellID->436221841],
Cell[2576, 109, 142, 5, 70, "Input",
 CellID->71310829],
Cell[2721, 116, 224, 7, 70, "Text",
 CellID->225227977],
Cell[2948, 125, 171, 7, 70, "MathCaption",
 CellID->1540423425],
Cell[3122, 134, 142, 5, 70, "Input",
 CellID->1981139390]
}, Open  ]],
Cell[CellGroupData[{
Cell[3301, 144, 163, 8, 70, "Section",
 CellID->275780995],
Cell[3467, 154, 90, 1, 70, "Text",
 CellID->781472739],
Cell[3560, 157, 107, 5, 70, "MathCaption",
 CellID->202339321],
Cell[3670, 164, 121, 4, 70, "Input",
 CellID->1250354846],
Cell[3794, 170, 278, 9, 70, "Text",
 CellTags->"fractions",
 CellID->1586410827],
Cell[4075, 181, 167, 7, 70, "MathCaption",
 CellID->1797291884],
Cell[4245, 190, 116, 4, 70, "Input",
 CellID->579715686],
Cell[4364, 196, 85, 2, 70, "Text",
 CellTags->"fractions",
 CellID->148228163],
Cell[4452, 200, 107, 5, 70, "MathCaption",
 CellID->189705021],
Cell[4562, 207, 144, 5, 70, "Input",
 CellID->1506555799],
Cell[4709, 214, 225, 7, 70, "Text",
 CellID->1851115663],
Cell[4937, 223, 171, 7, 70, "MathCaption",
 CellID->1105353952],
Cell[5111, 232, 142, 5, 70, "Input",
 CellID->1950324714],
Cell[5256, 239, 119, 3, 70, "Text",
 CellID->2064564037],
Cell[5378, 244, 124, 6, 70, "MathCaption",
 CellID->87001633],
Cell[5505, 252, 166, 6, 70, "Input",
 CellID->1947565871]
}, Open  ]],
Cell[CellGroupData[{
Cell[5708, 263, 163, 8, 70, "Section",
 CellID->793846323],
Cell[5874, 273, 91, 1, 70, "Text",
 CellID->2006735497],
Cell[5968, 276, 107, 5, 70, "MathCaption",
 CellID->972821944],
Cell[6078, 283, 121, 4, 70, "Input",
 CellID->1425408197],
Cell[6202, 289, 254, 8, 70, "Text",
 CellID->1655484694],
Cell[6459, 299, 166, 7, 70, "MathCaption",
 CellID->933121526],
Cell[6628, 308, 117, 4, 70, "Input",
 CellID->2047897088],
Cell[6748, 314, 62, 1, 70, "Text",
 CellID->1285947547],
Cell[6813, 317, 107, 5, 70, "MathCaption",
 CellID->644999021],
Cell[6923, 324, 141, 5, 70, "Input",
 CellID->1095891],
Cell[7067, 331, 139, 4, 70, "Text",
 CellTags->"fractions",
 CellID->1238770861],
Cell[7209, 337, 125, 6, 70, "MathCaption",
 CellID->167903162],
Cell[7337, 345, 189, 7, 70, "Input",
 CellTags->"fractions",
 CellID->154931576],
Cell[7529, 354, 225, 7, 70, "Text",
 CellID->1184817668],
Cell[7757, 363, 171, 7, 70, "MathCaption",
 CellID->1762171092],
Cell[7931, 372, 189, 7, 70, "Input",
 CellTags->"fractions",
 CellID->862567467]
}, Open  ]],
Cell[CellGroupData[{
Cell[8157, 384, 164, 8, 70, "Section",
 CellID->1656800619],
Cell[8324, 394, 279, 8, 70, "Text",
 CellID->1575036531],
Cell[8606, 404, 167, 7, 70, "MathCaption",
 CellID->1755543595],
Cell[8776, 413, 154, 5, 70, "Input",
 CellTags->"fractions",
 CellID->1143375032],
Cell[8933, 420, 98, 2, 70, "Text",
 CellTags->"fractions",
 CellID->1020489468],
Cell[9034, 424, 131, 6, 70, "MathCaption",
 CellID->1562083734],
Cell[9168, 432, 204, 7, 70, "Input",
 CellTags->"fractions",
 CellID->953732763],
Cell[9375, 441, 228, 6, 70, "Text",
 CellID->568606533],
Cell[9606, 449, 100, 5, 70, "MathCaption",
 CellID->267770981],
Cell[9709, 456, 164, 6, 70, "Input",
 CellTags->"fractions",
 CellID->1448637202],
Cell[9876, 464, 59, 1, 70, "Text",
 CellID->1223347975],
Cell[9938, 467, 107, 5, 70, "MathCaption",
 CellID->800979447],
Cell[10048, 474, 133, 5, 70, "Input",
 CellTags->"fractions",
 CellID->1634066333],
Cell[10184, 481, 204, 7, 70, "Text",
 CellID->1731980895],
Cell[10391, 490, 170, 7, 70, "MathCaption",
 CellID->262067180],
Cell[10564, 499, 151, 5, 70, "Input",
 CellTags->"fractions",
 CellID->74134263]
}, Open  ]],
Cell[CellGroupData[{
Cell[10752, 509, 183, 9, 70, "Section",
 CellID->434042981],
Cell[10938, 520, 115, 2, 70, "Text",
 CellTags->"fractions",
 CellID->2105916455],
Cell[11056, 524, 131, 6, 70, "MathCaption",
 CellID->1459872978],
Cell[11190, 532, 168, 6, 70, "Input",
 CellTags->"fractions",
 CellID->1084474271],
Cell[11361, 540, 297, 8, 70, "Text",
 CellTags->"fractions",
 CellID->1065360608],
Cell[11661, 550, 54, 1, 70, "MathCaption",
 CellID->1944573617],
Cell[11718, 553, 129, 5, 70, "Input",
 CellTags->"fractions",
 CellID->2042640873],
Cell[11850, 560, 193, 7, 70, "Text",
 CellID->991571569],
Cell[12046, 569, 166, 7, 70, "MathCaption",
 CellID->870259463],
Cell[12215, 578, 164, 6, 70, "Input",
 CellTags->"fractions",
 CellID->2087158571],
Cell[12382, 586, 61, 1, 70, "Text",
 CellID->1876212699],
Cell[12446, 589, 108, 5, 70, "MathCaption",
 CellID->2004443192],
Cell[12557, 596, 133, 5, 70, "Input",
 CellTags->"fractions",
 CellID->1100757455],
Cell[12693, 603, 202, 7, 70, "Text",
 CellID->18168772],
Cell[12898, 612, 171, 7, 70, "MathCaption",
 CellID->1960224895],
Cell[13072, 621, 152, 5, 70, "Input",
 CellTags->"fractions",
 CellID->953181638],
Cell[CellGroupData[{
Cell[13249, 630, 72, 1, 70, "RelatedTutorialsSection",
 CellID->167598681],
Cell[13324, 633, 204, 5, 70, "RelatedTutorials",
 CellID->161747686]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[13567, 643, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

