(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22881,        687]
NotebookOptionsPosition[     17042,        500]
NotebookOutlinePosition[     20136,        588]
CellTagsIndexPosition[     20065,        583]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Entering Two-Dimensional Expressions" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/EnteringTwoDimensionalExpressionsOverview"]}, #, 
        2]& , Evaluator -> Automatic], {
      1->"\<\"Entering Two-Dimensional Expressions\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Typing Matrices", "Title",
 CellID->92010637],

Cell[CellGroupData[{

Cell["Creating a New Matrix", "Section",
 CellID->12345],

Cell[TextData[{
 "Choose ",
 StyleBox[ButtonBox["Insert",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/InsertMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Table/Matrix",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/TableMatrix"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox["New", "MenuName"],
 ". Use the dialog box that pops up to create a matrix."
}], "MathCaption",
 CellID->697249085],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztPQl0VFWWn/pVSRCx6ahgowJqK+M4Zwa1e7RV7OlG0NGmRREcFiWMy8i4
gMsc9wVFEBFZxAZkkS1BEKVBkH2VJZBAQsgK2UlCNshGNrY7796/1K9f7//6
VfWrktDJOf/Ve/fdd+999771vvd/Bo5+44XnXh79xphnRvd68LXR414Y88zr
vQaMfY2BxA6C0CGGPX16CRgHQVAC+huNAUuJ8PzzH8C58xfwl+Xl550YjoEu
o0M7ul/oTyHmdIhdtfYl/8owGCsE8p/wBYUSjOUSxv+2AYodMXRgxqjQ0Gaw
BQsWExKmnrbMpRNidobrHvvoGklGhhGJMRFjN4RPBkaDCQE1NVVQV1cD9fVn
oLGxAZqbm+DcubNw4cJ5uHjxIispcUdchfuNMifszQqsRxglv4ykqaqq9CU9
tQDBpRWeHhyHXETKpVZC8yvlOSnq9MhUwA7PmKjGNAS1zNz4Em0PJIR25KjP
IatPHTRZalKIVEotEiory6yolbgwfEbJuyGIJnp1yvJyVOSFq6cdCpiDI39k
q7BEaWmxZWtcCpa4vFVovbi40LLmA9d6pJnWtUOFqM30aqxW1YspHr1OrULl
hYW5ltWuqpy0K0QYtVgranbZ2IDdZm8rw0t+/nHLmg+koZtNoCIoKuRNoE41
VzOpOvXzZeuYLnNzsyxr0kiLvHYYxcHryYFd1iq0kJ2dYVkTVnuwXgOIbFUD
hDE55FW2Wm2scidOddqeka3WGmvcnyN1KDdT4eEXni2ie/PeKSg6Te2lw176
IcSMDd52D3Fa2mLbW1o7l8BHnGiMRSFG1/BxDsJp869hlDI8DhozX4tuEnUY
7qe8lpZRMlijJ/wjegtCpK/weF/8UZp7m2NdyREczREZ8FqsfBNSRYbHedKJ
l2f0a6rMTq1FceHxf1yCigudF8NrfNK7mS+JHhtqf4SpLp36IqJutpDUp+q3
leowVN6IK0wa1a9aS+VD4YS4nKMMntI6tyYlBOuWiLZYQQjLkshft0MfmUu4
NgHh4RfGDZQNW9e2u3lvydKk80LMCk77VLoAC0sDkE2No+0qtr10+EtfrQ6Q
5NGmBdZPwVMMwvuRagN3P70aTr1Xw320pZtfdbdJDNZaZtt3p0rB4H4Jb/Uv
z9/BKyYY94XZZoWfJ5XzWstb2RJ4k7FwFs8WiDpWZiy/sU2fdngxjN06nc0q
bvQr76NCptBFtinPDk8GT3majhblS1tmyvK7w0qFWDDfNh0F5LTg6shzB63s
qXTSG/hbeVvzfPlipDGZFuqTdvgpzBw4+tuEBh4LDkHR3ay0FHUEeZ4NUc2w
by4IzBfB7yrdOFVeZ5ukATkOyCzXhFwuf/byvdROY78MVnff6cFzJsbB0Wm7
y+bWsWQnfx+Nr7ttaEntS3ZTXz1nRe4eqF2eIohqzOGLsQ5ftCSojjtvqvF3
xaKvpITHgr/aNki1gW2HL41YWXy6YeYrbB59s4VooDT9kznwi+YBLPd4Yjxi
W3trC9syX0qNVAcR61elA5NMf6DE6x7a5uhsqSbE34AMtK3ZtMYNqe9xQ80h
OKYiOMrU0HLpirjFjvLVXvRFpZQRuVYy8njtfB+1rcW0pu154HOZOtwEPMf4
3AP7I0ornbawyCDbWk7r9VJ437XgLW9FteHx3gYR3ROLnq+xm1tHw6n2Ah1d
vxaxusGK9/6KfRNIqF0qV3NgHTmwWzmwZ22rpX3uGKxn66mTP64c3lsgvJr8
PixStzt/Lv3Sbu1Tf6KZOtGGltTu/GkLzh/DPZebhpnzgLCUN6Pa/TlmbYYL
a+3+HJvU5wlTPmXT7o9BWGv3x5g1gY6W+LpHrpG2Wb7dpeJL9cG7VMwsf5kV
y6t2V2zc7hhpW44RzXIjqLs9yoe42t0botp8Qure4L3LEVDVRHuH7dbiyJhu
W41axmlhr/yhcFDYd1Wt3RnRXjocpdvfwrgES5NTpz++2HRn8HQEz9ew/kSh
52tYt7dzkaF0GEoz979cQrXqTpj8CwM+P/TJX6N7L+F0U6nLn1xDPNuub/GW
1Lwv24VX+YL5rtbCJsXqbilCrjFnTarD4e0SWuA2lKUv6IXKWlFG8pqpPQBL
8ZxbVhxqLWYpfjO+XM7jvW7dt42biPchUlfbMJEguYiu4FiHsMHrbf97QmQs
XjWsDNx+W8tABa3aYL6HhMi2a0HPzqOW5X40laMI3RLByrLBblncBvCce5zh
077hCqYzB9aVA/sVB3YTp050ruwI4bAdtpqExzr/xpGmm1pPY1lbqCt/1NqY
Q8gWCZfSpjSMXGxwOrRdt0vbLd3uMLq0uRAmrVN6XEK1ulWeEXSr6xZ0S9lx
sazlPE1m+hRaoafJpntaBp6icK00JK23DY+RndeieE6fsC0mw6v04HxA9t1I
alFPjv6VA+NB2MahJXBPjl23gIz9MS2x4QzOCJ6tWC0boDNGP1kKgrdbxvp1
Hatul1C6KG5VG04wLopbWrZ12CR/C40y93MEcntUWlS0dgdGG+DS7sBoodL/
cBeRJHlcUJBfBCXFpVBZcRqqq2uhtvaM0Avq6s70hKbGJgfGGFZdXT2cOVMP
9fUNcIbFi4tK1X+UFQx/J+Rk50FRYT68O3sV3Dx0Qj8Q7nuDgbsO/ABenBIL
NTWnoLamzh5exzKz4LlPF8PDr34Fa7f90g/27c1g4J379sJDr0yHMZ8vhaqq
Gjt4iZCZlk6V2LH/oNCfGInw87ZtBKsoP2WL9pBLGiqMyvWHQ4l5cqtDWOnJ
8hBwuQZSjhTRkjQKY/K0xWKUulaGKTKcLCkLgQy9IT3jpMyZxSh1rQwLLedr
IOuYwpnFKOXgwOQ1oWeGtH5lQXc5o+VllURCmEsL0+V50ugWJulz8yplzixG
KYcOJi3tvWEip2w3GRZqqU8UV8ucWYxSDh1MEJQtuVNJK78ip3g3GRZqwcsq
6iNk7bEoicB+mfQYupS09lfClMVFGKa6ybBQi1tdc17mzGKUcnBgcj/0zND0
Qykj1LKeqb8gs2cxSjk4MBcHdr0MC7WEDY0KZxajlIMDc3Fg18uw0Ep4MzSd
VzizGKWul2Gh5dwfLlwIP5cS27hkpB415FJcbM8qTqoLW73BjsPZjAvQ1mjH
4eMEKygosmmtiFzemrUChry/BHYm5fQjAk5Iyysl0NuzVkJuTr49vLLSMyHv
eAbx061Ln5+4GPJzsyD7eLY92mNCEz9mK+FGSD96tCekHE4QMcZYogWx5ogR
dPXaxm6s7ZaWXjCLhITkLJi9chs88c58uGnoJ/SLaQaXDkFpruV5Z2/nwN42
bDzh2cBJfrZOrPkVQuz6vdDrifHwyrRVsCk+DWoZ1a0JmTBuxmqCYz7DU/2I
2nrcyYG9ZdIJ7d4cKvVAGUeMXwzr9yRz317fmpgFMZ/GIR73UJXnn3R/n8Tq
iaXxmSCHso6eqLpJHWpDMnRE6z/5Lv/qaGg+Zi4/PGHMzGX3/lp5IxE7Ezat
tbsOmX50AM2GeNjJrCiXZwQ3zPo/7vT5n0J0cvBoBPKGA4++G48vj/FQYqfP
QrEcDnkvTI6z9MkIHEAYvmBwLO7fy/Zmp5a8zmFmPEtXEgK5o61S4RF0qhk8
qd80NaNdTiHFjDh7fb95n6UvQOBcwPCtmtFogPP9OYzAzWgyvFm/jOA1nGps
xW8xvNneuh2DcawpdsSVyLHsY5a+5IDzOsOXaxSpry1nADRq2JaOqK2NnkYj
aiB3SLxp8mXgvVlh3WzBeCW13W/5hl2WvuCASzJ39zM3m+64m2K+P8HD6zb+
fu5M5C84/D+n96ZhfpXNquGuQienvKRTYoKo9Y/68Pu6YzqU6KDcp9qJ9Vnc
h1r4BAau1NWJ1T1KUSySo6Nf80du/X8vxdRlHBjP3rw+xGNtvLr0NM+VXN1j
GKmF+fRnSy3Id7mrbDGaso6NW7/D1HC4LfFYx1owGm9y6cg3pPEA6r9xjQbI
YIwbzXHfOymM1MIUd7+h218yrjct3vFAdFDHA9p95ZB3vjE0MG5gcN+J+8re
HA39RjUxzx68F3LMl/NanXqfLLgwVEY2zUmEwYkFi7k4yFcGdT7B8yzguIbT
Ha5UcNWJGwitZyHDcp29jyeidDCpPt4wJ8EitWW9jj+uCuqow4qnKMtyTb2P
PlwYyrMQi8m35Dxg7piubHRYDkau5Bx4dOfAosNyCHIVHmTIH4nyPuaIDssx
Rx/OMUd0+zFHWI85bibMgWYr4PZfgw3FRB/twJ4jIisjJy2HaPj+DWfWjMaQ
QJ3VmODpf5hsWBX7z6G47vXpP8DmA+lQV98AWxOyvNzrN3KqdaXhosGSG2aC
SZXtPg7TrphGjl8CP+9NUT0PZ882w/nz57AXe3jiDTxKms/Huk0oCPKNccMb
24YfTDD2RumXwt54/jofDa6ZGze+kB0W6vcoP/2SJG8g6wwNo+xRzDw4Vly0
3nk8LfFgwX93WxCsfHTZf968odD/bzHicDZmynJ1Z1h6ugS+SZwDv/3bb2HO
gdlwuu6UahHFf27QpvQOIWOF8Q0TZaIk3q7QqvJ/bUL3M1uUiPPCj9vj1S32
opSF8M/f9YYbl/SCK2d2gTnxs9WmjUMtus9422kfo4OXQ9iljk4+37r0MdyY
6y4cDRHn17yCPCgvLyE9DtzxMPz5lz/C3Zt+DzcsvgFu+dtN6hCBUxZ6jg0a
ot41EPiIYOKv5Y79LdsEv9+8F06ePEEqXJEdB0PSHoN+TIW3fncL9WlllMVZ
37QJimrdnLxaqimzYdnMGW7YzruEddx7ftJStnQvIJ0VluaSzrDZYffFcVCZ
mXClZDLu8T7ly2tSHU20pfe8uBuNpanb//ors/CKTb+oOlC6nta9i8smD0+h
i9fDzKtsNMgZ/+sCS4qwusK0rhztmvHJ9+YbKgeXLrimdK8ZPaXg+TWt4nXh
KIDGmgA2Ei13dwe7Fg5HOKLjzIhLDO3mYpBF24Xqno7lHZ5OxiMmMiqXU3oP
/BQGvr/rARjz8WmGikn5Ykq7kyAcvz6cBNINlMk/FAkDKBSV2yceeME4i5yq
S4rRx6x+dEeC3nElkHxPwr47q0hwisILz/ElXlNWFyu+Nnt5fbm6ROKFh88S
r6mh4jVjzUnMuk4989S/TqI5ThMIS5ZoxpqS0Eg0a10pZl1rIodDlkObx+LX
a8T7mlEJiXhzNpZjVnfDgymXCtP8Cj3kYzD8m7OxzH/Z6PiWPjlRbEHK+Vtk
Kb2PjaSXVJwqTJDcLT1lMP7N31IRGuUt2l4pieV9siOd4jhVmCqWBMa/xax0
YHqzsFqw4jZSVws8AskW6h+765RUf96rLtKpjwLT/LLGg3mSEmJ3nw6NEgRO
vQTOQtCN57VmTLGgghV7q6TuLb0zgxTkgyJ6JI6Y5/TIo+4tgfEPqQSoBT9u
Jprsr3TKND7TdNf8h/hqaahtaLwgD7XSWzlISD6ookcaajFPquyq/dUhqyyv
6aspEi3NQtXWJNRKMxaedUlCr0msDVRoK5fVzExj7eav1T677lCdVDc8lZLq
tv5wXWjqZu0DJmIwQ9CG5DP66mxMrleO8/ysjoWLLdkmMimnfpuP1utl2ny0
QTn8C6dM7nOurakNbAmLoaiccXng+ZaGd3LlizOez7AtjdAfDp8EeXsjn0fZ
9BLWJfBiFDEZ3o7+D4ne2NgMc+YsZ+hvvjlzOAYsgwEog4++ddshhs7CERh0
QFgHzPTGLDqBiz4WRsK+fftYxv79+zFGKQeFTi2MSZsHiP+fGBhRrq6hIVdQ
/m9ybm4uLF++HJYuWQpLlixxwOLF+LmRRYsWwcp334Jvv/2WobLQgSAlFwvI
f9Jnhv6doiJUlpfD/GWbIO4PD7BiLHTA8nsecFFapBzEUPl3QHE8hIwiIfPz
C9iSo5nUgL9z5n4D8+bNg1WrVrGleVmZcDmcSE+HnFHDoIJVurKyEk6dOgWF
R1KgsqQEqquroba2FpYuXaqQweVNMy1ymogqe4RRGMZgRgylnZTr5tvk8ChE
WfQucxODNaqoTQzWSHhyzWHlfUPYsINhJKURLjGVmGP1tK3jOqp0bk4B1DDr
4INWij+QQGYoZxorKSiAzB07KZ66dBmUDrgfGhbOpFqXfR8HR0c+BdVVVVTr
uro6qnlNrUyrtl6iW4txgu1kDOpjkIsDk2yuqiam9QoCxSUC0m+1Klg93fJC
X2INIyxXF3Y/PgL2PTFciIB9Q0ayyrM4wTAPcdTyjBZWVFv9rlT97OP5UF5R
LT2V1fDtoqUwbdo0+PLLL9HksG7IMDg04inIGvU01Dw6AM58Phwq3x8G+353
Mxz8cLxa9bpTlbBs2TJGo8qBxJhdyiuqFNJM7P27j1CGA2NOjDkxJnrGHCoe
waI4JYhyNcYo5fCk7C7rhrnUmODUluUUcguhYyOidhzuqIa/kvE4xkZjtUWO
BnhaccohmgrNhk/CE8Mi4NCwp5nKWFQFI4pCpqoDms2jA3cnY2Zl5bEtfDmc
KGJPcQV8NWsOtcmTrHdiG06eNx/WX9sVikfeB42vD4aadx+E1Nf/CLG9r4XY
vvfD9skTIWHcGChe8yMZU6VVVKHEXXBFly6y0lhMIK0RM/lxIlhUYziAuhEE
h1RcyY3CmBkhuTiLUcqh4+4mLqUU4m48Uc9BJmVKgyc0XZ+t8CzO9OHgSqkQ
H4woMag7RK6QaZA6SaUVEljUWo0u9SIMTc4aAjYDadwWIXn4KGkG6QiHhlJb
IQzE1Nod24H3PJiRmQvZuSWMFobRsHNXPCwY9yKse/IJSBo2ArIefRhKnr2X
7W1ehrPrxkLzpMehZNBdcOCOW+HI4HugdPCDUDxtOjQ0NMCy2FjIzilBSkiu
WKsGlsRHMNS6gu+UuyQW8DJLhEpLk+VZNNJvzj6bgWJCp6ekciGZvh5slYV5
lbh1ELVFpMa5jrJFVL0GGcMoyKG0Avf8zckpFuWiSss6MvxpQfp0YWdIH/UM
aP9SnxqN+Wr70pLCluQ9laSl50BaZj6kZxbQ7/sfToA5774D2+7vC3V/6gMN
wx+C5imj4EL8B3D+6FQonzUGEkcMgBMznoGLa1+Hcx++TG2rqakJYpfFIg0H
CwrwXl5Gvqc60zPyFQWlu/MEZYDWwrQ9GuHsEZwae6R70sa0i1PE5ebp1Gbg
4/SrMfCoawc2lo7SobjrYSizmwLjmJ6p11emBmEwJmNItZ0kCdBi7Jesl1FA
aYSnZchwCSagbAVsdUX5mfmUh20jY9QoOP7sszCgR3emJ2wTl2Ec8v/nOYJj
PuKlqXwKqLVoJrCrqQmlpOZAUko2JNOTAz+t3w6zZ8+GDRs2QM2yBVDz8V+h
ZvxgOLtiHOR8/RJsGTMUVv6lL5zZ/hbAhhegadyj0MCW1s3NzRAbG8s0wShp
zZCsEs+WpwfehOJuTmpxowzDslH6sjJb7uCkk9IHWOHoNGIRZVJIJzpfAUlM
95oZlRY3DBaDZUW0kCASjrtOSUiUKGNuR7Ie5ibJD5ofm0LBmOcg/6Ux1FSk
oSdCaioMhg/mIx5tYpJlRtnUMLxntKSkY7A3PpWxxzAa3nnvE5g7dy7ELY+D
sk0bIe/FvpAX0xeOjfozbHzkXvhh6F9gxZMPwskJg6BmXF+o6HcblN3ZB/LY
rBYXFwd796ciJQdGtOrYsz8NH4HfFEhFLFuUbKLECOb0zO2IMa1JZcpGhfRC
qAxdaq7U5SOUbI9hQaHKo+DmxHI1hdX2uSc+VSW2Jz5VKSTHBmMshhVMZT2e
6Yx0h0WkOOqKQYg0wtIoJSsWjRUhIbNMbBlFr7wMRW+MhZOvjpXGD5eSpF/M
lva2rBCjyeiT7b3noMTDx2D3nhTYtecIe1Jg0dLVsHDhAkhY+xMcuuNO2HRT
D/jlxp6QOOgPULh0LKSPf5JR/if48fYeUPjI7+D0/NlQn5QATQd2U4tgtEQk
RHUW1W5yFTLQGkfid4SNpxh6thBKRbhLOLUljAhF8TI0xmNJkVPMZUTPJdWC
gYZhLAZrJlDVWIx0JTgodFJao0OHiiqBWTahHpEXEuVvvw5l772lLiSwN2v/
qsa/g/mERxsdteIpZC6tEaVtzMHETNi+Mwm2sWf7zsPw8YSpMHXqVJgx8r/g
xJYtcHDm17C6d3do+uq/4eKxaXB+8dNQPvwO2HLzdbDhttvg7NmzcO7cOTh/
/jwZcbtMR/NLc/DVmCJldcZYBMYiVZhTjXVSYw7N2KvAotSYiDEnE1tKDsfY
aCmXxQQnVWgbCUBCODDCpkqpnu76alBIYzUf/R9UT3jPIXt7UME1a+fREKr4
k+q/mIAohEpDJysrkDykTa2OpZn2wMFM+HljPGzamgCb2TNl6lzWURZCWmoq
OXIKEg9B8r13wtlPnoeGd9lW8bm72WbgP6B88gRIuvsu+Ptnk0m/eG05bvly
JsimrYmslW3ekqjSZBCMCw9hjFTSFWMxLDNxNGIwwTdLOIS7GbEYGINEphcZ
JtNKkHElfNTLmc/fh/rpnzpQEyLUblxIMQfC2CIFcxFLkQhri7X2nkb2xWfA
xg1JrA6rf9wvdIEpny+EiRMnwqxZX5F/I5G13NMsXV9fD42FeVB3bx+omD2T
2llTZSUcmT4TmtnC9eLFi5KPjpG5m2i5YMaclSQFfDsVLu5YBmezNzA+Z8t+
dkBz2c8MgQEoAxEQkRWQBRFRKBLOW+Sdu47AfhpRV32/h3W61179mLxWBfkF
UFt1GvI2byRxlfV0yitjoXHLBrVb4CmLAwWW3YqMClECDO+iqAgTvlhCIuHQ
G0VhJMFkZHqYECSMVsRI6vffLd8BJSWnICUlH7ZuTYLFi9ZiL2Yj/8qVKxn1
2Bkz4Kd5cynlwpCK9MeApdf8fQ+VwtJIBaEOD/qTJs1jG5FCqk7RiVJITs6H
gwePoZt3a9LjGDBWDEAZiICIWIAVlCk55AXI17O+V0nV1tTRZb6CwgpA4CAM
GA6mEY75CiVWThr1pMHPQVoQ4bNJC4gkykyVeoyiTgJiJlqQPdI3+aUVMyBg
KAYRci07/D+Qepjn\
\>"], "Graphics",
 Evaluatable->False,
 ImageSize->{352, 304},
 ImageMargins->0,
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->154732338],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "0"},
     {"0", "1", "0"},
     {"0", "0", "1"}
    }], "\[NoBreak]", ")"}], "\[VerticalSeparator]"}]], "Input",
 CellID->71088826]
}, Open  ]],

Cell[CellGroupData[{

Cell["Filling in Placeholders in a Matrix", "Section",
 CellID->2222],

Cell["Suppose the entry in the top-left position is selected.", "Text",
 CellID->202431168],

Cell["", "MathCaption",
 CellID->390995262],

Cell[BoxData[
 RowBox[{"(", GridBox[{
    {
     StyleBox["\[Placeholder]",
      DrawHighlighted->1], "\[Placeholder]"},
    {"\[Placeholder]", "\[Placeholder]"}
   }], ")"}]], "Input",
 CellTags->"matrices",
 CellID->168274073],

Cell[TextData[{
 "Type an entry and select the next placeholder with the ",
 StyleBox["Tab", "KeyEvent"],
 " key; repeat. (Use ",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Tab", "KeyEvent"],
 " to go backwards.)"
}], "Text",
 CellID->143059201],

Cell[TextData[{
 "Type ",
 Cell[BoxData["a"], "InlineFormula"],
 ", press ",
 StyleBox["Tab", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->78051739],

Cell[BoxData[
 RowBox[{"(", GridBox[{
    {"a", 
     StyleBox["\[Placeholder]",
      DrawHighlighted->1]},
    {"\[Placeholder]", "\[Placeholder]"}
   }], ")"}]], "Input",
 CellTags->"matrices",
 CellID->263398684],

Cell[TextData[{
 "Type ",
 Cell[BoxData["b"], "InlineFormula"],
 ", press ",
 StyleBox["Tab", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->353956889],

Cell[BoxData[
 RowBox[{"(", GridBox[{
    {"a", "b"},
    {
     StyleBox["\[Placeholder]",
      DrawHighlighted->1], "\[Placeholder]"}
   }], ")"}]], "Input",
 CellTags->"matrices",
 CellID->528615661],

Cell[TextData[{
 "Type ",
 Cell[BoxData["c"], "InlineFormula"],
 ", press ",
 StyleBox["Tab", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->743008475],

Cell[BoxData[
 RowBox[{"(", GridBox[{
    {"a", "b"},
    {"c", 
     StyleBox["\[Placeholder]",
      DrawHighlighted->1]}
   }], ")"}]], "Input",
 CellTags->"matrices",
 CellID->87630520],

Cell[TextData[{
 "Press the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["Space", "KeyEvent"],
 " bar at the same time to get out of the grid."
}], "Text",
 CellID->61220633],

Cell[TextData[{
 "Type ",
 Cell[BoxData["d"], "InlineFormula"],
 ", press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->7999],

Cell[BoxData[
 RowBox[{"(", 
  RowBox[{GridBox[{
     {"a", "b"},
     {"c", "d"}
    }], "\[VerticalSeparator]"}], ")"}]], "Input",
 CellTags->"matrices",
 CellID->12895388],

Cell["Move the insertion point to get out of the matrix.", "Text",
 CellID->372167099],

Cell[TextData[{
 "Press ",
 StyleBox["RightArrow", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->557903506],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", GridBox[{
     {"a", "b"},
     {"c", "d"}
    }], ")"}], "\[VerticalSeparator]"}]], "Input",
 CellTags->"matrices",
 CellID->191096236]
}, Open  ]],

Cell[CellGroupData[{

Cell["Adding a New Column in a Matrix", "Section",
 CellID->3333],

Cell["\<\
Place the insertion point to the right of any entry; here the insertion point \
is to the right of the entry at the top left. \
\>", "Text",
 CellID->40573178],

Cell["Place the insertion point.", "MathCaption",
 CellID->200574734],

Cell[BoxData[
 RowBox[{"(", GridBox[{
    {
     RowBox[{"a", "\[VerticalSeparator]"}], "b"},
    {"c", "d"}
   }], ")"}]], "Input",
 CellTags->"matrices",
 CellID->10483974],

Cell[TextData[{
 "Press the ",
 StyleBox["Control", "KeyEvent"],
 " and ",
 StyleBox["Comma", "KeyEvent"],
 " keys at the same time. A column of placeholders will appear, with the top \
one selected. "
}], "Text",
 CellID->403191601],

Cell[TextData[{
 StyleBox["Press",
  FontFamily->"Helvetica",
  FontWeight->"Bold"],
 " ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Comma", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->185149012],

Cell[BoxData[
 RowBox[{"(", GridBox[{
    {"a", 
     StyleBox["\[Placeholder]",
      DrawHighlighted->1], "b"},
    {"c", "\[Placeholder]", "d"}
   }], ")"}]], "Input",
 CellTags->"matrices",
 CellID->29733979]
}, Open  ]],

Cell[CellGroupData[{

Cell["Adding a New Row in a Matrix", "Section",
 CellID->4444],

Cell["\<\
Place the insertion point to the right of any entry; here the insertion point \
is to the right of the entry at the top left.\
\>", "Text",
 CellID->199977209],

Cell["Place the insertion point.", "MathCaption",
 CellID->340973465],

Cell[BoxData[
 RowBox[{"(", GridBox[{
    {
     RowBox[{"a", "\[VerticalSeparator]"}], "b"},
    {"c", "d"}
   }], ")"}]], "Input",
 CellTags->"matrices",
 CellID->591731899],

Cell[TextData[{
 "Press the ",
 StyleBox["Control", "KeyEvent"],
 " and ",
 StyleBox["Return", "KeyEvent"],
 " keys at the same time. A row of placeholders will appear, with the first \
one selected. "
}], "Text",
 CellID->204408505],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Return", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->171944951],

Cell[BoxData[
 RowBox[{"(", GridBox[{
    {"a", "b"},
    {
     StyleBox["\[Placeholder]",
      DrawHighlighted->1], "\[Placeholder]"},
    {"c", "d"}
   }], ")"}]], "Input",
 CellTags->"matrices",
 CellID->8615380],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->673518431],

Cell[TextData[ButtonBox["Entering Two-Dimensional Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EnteringTwoDimensionalExpressionsOverview"]], \
"RelatedTutorials",
 CellID->161747686]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Typing Matrices - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Entering Two-Dimensional Expressions", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/EnteringTwoDimensionalExpressionsOverview"]], "Text",
       FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TypingVectors"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TypingSuperscripts"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 44, 30.9535542}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Choose Insert > Table/Matrix > New. Use the dialog box that pops up to \
create a matrix. Suppose the entry in the top-left position is selected. ", 
    "synonyms" -> {}, "title" -> "Typing Matrices", "type" -> "Tutorial", 
    "uri" -> "tutorial/TypingMatrices"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "matrices"->{
  Cell[11752, 247, 229, 8, 70, "Input",
   CellTags->"matrices",
   CellID->168274073],
  Cell[12421, 277, 216, 8, 70, "Input",
   CellTags->"matrices",
   CellID->263398684],
  Cell[12793, 296, 203, 8, 70, "Input",
   CellTags->"matrices",
   CellID->528615661],
  Cell[13152, 315, 189, 8, 70, "Input",
   CellTags->"matrices",
   CellID->87630520],
  Cell[13759, 345, 174, 7, 70, "Input",
   CellTags->"matrices",
   CellID->12895388],
  Cell[14135, 364, 175, 7, 70, "Input",
   CellTags->"matrices",
   CellID->191096236],
  Cell[14659, 388, 174, 7, 70, "Input",
   CellTags->"matrices",
   CellID->10483974],
  Cell[15309, 419, 212, 8, 70, "Input",
   CellTags->"matrices",
   CellID->29733979],
  Cell[15867, 444, 175, 7, 70, "Input",
   CellTags->"matrices",
   CellID->591731899],
  Cell[16455, 472, 217, 9, 70, "Input",
   CellTags->"matrices",
   CellID->8615380]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"matrices", 19167, 549}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 684, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1309, 44, 51, 1, 70, "Title",
 CellID->92010637],
Cell[CellGroupData[{
Cell[1385, 49, 56, 1, 70, "Section",
 CellID->12345],
Cell[1444, 52, 499, 13, 70, "MathCaption",
 CellID->697249085],
Cell[1946, 67, 9343, 157, 70, "Graphics",
 Evaluatable->False,
 CellID->154732338],
Cell[11292, 226, 211, 7, 70, "Input",
 CellID->71088826]
}, Open  ]],
Cell[CellGroupData[{
Cell[11540, 238, 69, 1, 70, "Section",
 CellID->2222],
Cell[11612, 241, 91, 1, 70, "Text",
 CellID->202431168],
Cell[11706, 244, 43, 1, 70, "MathCaption",
 CellID->390995262],
Cell[11752, 247, 229, 8, 70, "Input",
 CellTags->"matrices",
 CellID->168274073],
Cell[11984, 257, 282, 9, 70, "Text",
 CellID->143059201],
Cell[12269, 268, 149, 7, 70, "MathCaption",
 CellID->78051739],
Cell[12421, 277, 216, 8, 70, "Input",
 CellTags->"matrices",
 CellID->263398684],
Cell[12640, 287, 150, 7, 70, "MathCaption",
 CellID->353956889],
Cell[12793, 296, 203, 8, 70, "Input",
 CellTags->"matrices",
 CellID->528615661],
Cell[12999, 306, 150, 7, 70, "MathCaption",
 CellID->743008475],
Cell[13152, 315, 189, 8, 70, "Input",
 CellTags->"matrices",
 CellID->87630520],
Cell[13344, 325, 194, 7, 70, "Text",
 CellID->61220633],
Cell[13541, 334, 215, 9, 70, "MathCaption",
 CellID->7999],
Cell[13759, 345, 174, 7, 70, "Input",
 CellTags->"matrices",
 CellID->12895388],
Cell[13936, 354, 86, 1, 70, "Text",
 CellID->372167099],
Cell[14025, 357, 107, 5, 70, "MathCaption",
 CellID->557903506],
Cell[14135, 364, 175, 7, 70, "Input",
 CellTags->"matrices",
 CellID->191096236]
}, Open  ]],
Cell[CellGroupData[{
Cell[14347, 376, 65, 1, 70, "Section",
 CellID->3333],
Cell[14415, 379, 169, 4, 70, "Text",
 CellID->40573178],
Cell[14587, 385, 69, 1, 70, "MathCaption",
 CellID->200574734],
Cell[14659, 388, 174, 7, 70, "Input",
 CellTags->"matrices",
 CellID->10483974],
Cell[14836, 397, 233, 8, 70, "Text",
 CellID->403191601],
Cell[15072, 407, 234, 10, 70, "MathCaption",
 CellID->185149012],
Cell[15309, 419, 212, 8, 70, "Input",
 CellTags->"matrices",
 CellID->29733979]
}, Open  ]],
Cell[CellGroupData[{
Cell[15558, 432, 62, 1, 70, "Section",
 CellID->4444],
Cell[15623, 435, 169, 4, 70, "Text",
 CellID->199977209],
Cell[15795, 441, 69, 1, 70, "MathCaption",
 CellID->340973465],
Cell[15867, 444, 175, 7, 70, "Input",
 CellTags->"matrices",
 CellID->591731899],
Cell[16045, 453, 233, 8, 70, "Text",
 CellID->204408505],
Cell[16281, 463, 171, 7, 70, "MathCaption",
 CellID->171944951],
Cell[16455, 472, 217, 9, 70, "Input",
 CellTags->"matrices",
 CellID->8615380],
Cell[CellGroupData[{
Cell[16697, 485, 72, 1, 70, "RelatedTutorialsSection",
 CellID->673518431],
Cell[16772, 488, 204, 5, 70, "RelatedTutorials",
 CellID->161747686]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[17015, 498, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

