(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11763,        461]
NotebookOptionsPosition[      6399,        293]
NotebookOutlinePosition[      9432,        378]
CellTagsIndexPosition[      9359,        373]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Entering Two-Dimensional Expressions" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/EnteringTwoDimensionalExpressionsOverview"]}, #, 
        2]& , Evaluator -> Automatic], {
      1->"\<\"Entering Two-Dimensional Expressions\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Typing Overscripts", "Title",
 CellID->234550219],

Cell[CellGroupData[{

Cell[TextData[{
 "Typing",
 " ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["x", "_"], TraditionalForm]]]
}], "Section",
 CellID->12121],

Cell["Type the expression that will have an overscript. ", "Text",
 CellID->81638781],

Cell[TextData[{
 "Type ",
 Cell[BoxData["x"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->299313910],

Cell[BoxData[
 RowBox[{"x", "\[VerticalSeparator]"}]], "Input",
 CellTags->"overscripts",
 CellID->66041],

Cell[TextData[{
 "Create an overscript by pressing the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["7", "KeyEvent"],
 " key at the same time. "
}], "Text",
 CellID->130635841],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["7", "KeyEvent"],
 " or ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["&", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->42351219],

Cell[BoxData[
 OverscriptBox["x", 
  StyleBox["\[Placeholder]",
   DrawHighlighted->1]]], "Input",
 CellTags->"overscripts",
 CellID->737013314],

Cell["\<\
Type an underscore into the placeholder (which is already selected). \
\>", "Text",
 CellID->713178499],

Cell[TextData[{
 "Type ",
 Cell[BoxData["_"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->522155333],

Cell[BoxData[
 OverscriptBox["x", 
  RowBox[{"_", "\[VerticalSeparator]"}]]], "Input",
 CellTags->"overscripts",
 CellID->45070905],

Cell[TextData[{
 "Move the insertion point out of the overscript position down to the \
baseline by pressing the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["Space", "KeyEvent"],
 " bar at the same time. "
}], "Text",
 CellID->189050324],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->49107663],

Cell[BoxData[
 RowBox[{
  OverscriptBox["x", "_"], "\[VerticalSeparator]"}]], "Input",
 CellTags->"overscripts",
 CellID->15153808]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Typing",
 " ",
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    RowBox[{"x", "+", "y"}], "_"], TraditionalForm]]]
}], "Section",
 CellID->23232],

Cell[TextData[{
 "Press the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["7", "KeyEvent"],
 " key at the same time. "
}], "Text",
 CellID->299375773],

Cell["\<\
This creates a pair of placeholders, one on the baseline and another in the \
overscript position. \
\>", "Text",
 CellID->1402591366],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["7", "KeyEvent"],
 " or ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["&", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->81798500],

Cell[BoxData[
 OverscriptBox["\[Placeholder]", 
  StyleBox["\[Placeholder]",
   DrawHighlighted->1]]], "Input",
 CellTags->"overscripts",
 CellID->323226998],

Cell["\<\
Type an underscore into the placeholder in the overscript (which is already \
selected). \
\>", "Text",
 CellID->621251840],

Cell[TextData[{
 "Type ",
 Cell[BoxData["_"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->667739339],

Cell[BoxData[
 OverscriptBox["\[Placeholder]", 
  RowBox[{"_", "\[VerticalSeparator]"}]]], "Input",
 CellTags->"overscripts",
 CellID->282469624],

Cell[TextData[{
 "Press the ",
 StyleBox["Tab", "KeyEvent"],
 " key to select the placeholder that is on the baseline. "
}], "Text",
 CellID->416486806],

Cell[TextData[{
 "Press ",
 StyleBox["Tab", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->336594864],

Cell[BoxData[
 OverscriptBox[
  StyleBox["\[Placeholder]",
   DrawHighlighted->1], "_"]], "Input",
 CellTags->"overscripts",
 CellID->58783325],

Cell["Type the expression under the overscript. ", "Text",
 CellID->136485637],

Cell[TextData[{
 "Type ",
 Cell[BoxData[
  RowBox[{"x", "+", "y"}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->303730816],

Cell[BoxData[
 OverscriptBox[
  RowBox[{
   RowBox[{"x", "+", "y"}], "\[VerticalSeparator]"}], "_"]], "Input",
 CellTags->"overscripts",
 CellID->409623675],

Cell[TextData[{
 "Press the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["Space", "KeyEvent"],
 " bar to get out of the overscripted expression. "
}], "Text",
 CellID->8130759],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->768499266],

Cell[BoxData[
 RowBox[{
  OverscriptBox[
   RowBox[{"x", "+", "y"}], "_"], "\[VerticalSeparator]"}]], "Input",
 CellTags->"overscripts",
 CellID->113640872],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->209764290],

Cell[TextData[ButtonBox["Entering Two-Dimensional Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EnteringTwoDimensionalExpressionsOverview"]], \
"RelatedTutorials",
 CellID->161747686]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Typing Overscripts - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Entering Two-Dimensional Expressions", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/EnteringTwoDimensionalExpressionsOverview"]], "Text",
       FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TypingSubscripts"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TypingUnderscripts"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 44, 31.8129512}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Type the expression that will have an overscript. Type x. Create an \
overscript by pressing the Control key and the 7 key at the same time. ", 
    "synonyms" -> {}, "title" -> "Typing Overscripts", "type" -> "Tutorial", 
    "uri" -> "tutorial/TypingOverscripts"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "overscripts"->{
  Cell[1726, 68, 105, 3, 70, "Input",
   CellTags->"overscripts",
   CellID->66041],
  Cell[2306, 95, 144, 5, 70, "Input",
   CellTags->"overscripts",
   CellID->737013314],
  Cell[2679, 114, 131, 4, 70, "Input",
   CellTags->"overscripts",
   CellID->45070905],
  Cell[3246, 139, 131, 4, 70, "Input",
   CellTags->"overscripts",
   CellID->15153808],
  Cell[4170, 186, 157, 5, 70, "Input",
   CellTags->"overscripts",
   CellID->323226998],
  Cell[4576, 206, 145, 4, 70, "Input",
   CellTags->"overscripts",
   CellID->282469624],
  Cell[4982, 226, 143, 5, 70, "Input",
   CellTags->"overscripts",
   CellID->58783325],
  Cell[5342, 244, 156, 5, 70, "Input",
   CellTags->"overscripts",
   CellID->409623675],
  Cell[5873, 269, 156, 5, 70, "Input",
   CellTags->"overscripts",
   CellID->113640872]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"overscripts", 8534, 342}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 684, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1309, 44, 55, 1, 70, "Title",
 CellID->234550219],
Cell[CellGroupData[{
Cell[1389, 49, 136, 7, 70, "Section",
 CellID->12121],
Cell[1528, 58, 85, 1, 70, "Text",
 CellID->81638781],
Cell[1616, 61, 107, 5, 70, "MathCaption",
 CellID->299313910],
Cell[1726, 68, 105, 3, 70, "Input",
 CellTags->"overscripts",
 CellID->66041],
Cell[1834, 73, 196, 7, 70, "Text",
 CellID->130635841],
Cell[2033, 82, 270, 11, 70, "MathCaption",
 CellID->42351219],
Cell[2306, 95, 144, 5, 70, "Input",
 CellTags->"overscripts",
 CellID->737013314],
Cell[2453, 102, 113, 3, 70, "Text",
 CellID->713178499],
Cell[2569, 107, 107, 5, 70, "MathCaption",
 CellID->522155333],
Cell[2679, 114, 131, 4, 70, "Input",
 CellTags->"overscripts",
 CellID->45070905],
Cell[2813, 120, 258, 8, 70, "Text",
 CellID->189050324],
Cell[3074, 130, 169, 7, 70, "MathCaption",
 CellID->49107663],
Cell[3246, 139, 131, 4, 70, "Input",
 CellTags->"overscripts",
 CellID->15153808]
}, Open  ]],
Cell[CellGroupData[{
Cell[3414, 148, 161, 8, 70, "Section",
 CellID->23232],
Cell[3578, 158, 169, 7, 70, "Text",
 CellID->299375773],
Cell[3750, 167, 144, 4, 70, "Text",
 CellID->1402591366],
Cell[3897, 173, 270, 11, 70, "MathCaption",
 CellID->81798500],
Cell[4170, 186, 157, 5, 70, "Input",
 CellTags->"overscripts",
 CellID->323226998],
Cell[4330, 193, 133, 4, 70, "Text",
 CellID->621251840],
Cell[4466, 199, 107, 5, 70, "MathCaption",
 CellID->667739339],
Cell[4576, 206, 145, 4, 70, "Input",
 CellTags->"overscripts",
 CellID->282469624],
Cell[4724, 212, 152, 5, 70, "Text",
 CellID->416486806],
Cell[4879, 219, 100, 5, 70, "MathCaption",
 CellID->336594864],
Cell[4982, 226, 143, 5, 70, "Input",
 CellTags->"overscripts",
 CellID->58783325],
Cell[5128, 233, 78, 1, 70, "Text",
 CellID->136485637],
Cell[5209, 236, 130, 6, 70, "MathCaption",
 CellID->303730816],
Cell[5342, 244, 156, 5, 70, "Input",
 CellTags->"overscripts",
 CellID->409623675],
Cell[5501, 251, 196, 7, 70, "Text",
 CellID->8130759],
Cell[5700, 260, 170, 7, 70, "MathCaption",
 CellID->768499266],
Cell[5873, 269, 156, 5, 70, "Input",
 CellTags->"overscripts",
 CellID->113640872],
Cell[CellGroupData[{
Cell[6054, 278, 72, 1, 70, "RelatedTutorialsSection",
 CellID->209764290],
Cell[6129, 281, 204, 5, 70, "RelatedTutorials",
 CellID->161747686]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[6372, 291, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

