(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19571,        806]
NotebookOptionsPosition[     11350,        534]
NotebookOutlinePosition[     15175,        649]
CellTagsIndexPosition[     15106,        644]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Entering Two-Dimensional Expressions" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/EnteringTwoDimensionalExpressionsOverview"]}, #, 
        2]& , Evaluator -> Automatic], {
      1->"\<\"Entering Two-Dimensional Expressions\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Typing Powers", "Title",
 CellID->1453038488],

Cell[CellGroupData[{

Cell[TextData[{
 "Typing",
 " ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "m"], TraditionalForm]]]
}], "Section",
 CellID->14222],

Cell["Start with the expression that will be the base. ", "Text",
 CellID->13070490],

Cell[TextData[{
 "Type ",
 Cell[BoxData["x"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->197692404],

Cell[BoxData[
 RowBox[{"x", "\[VerticalSeparator]"}]], "Input",
 CellTags->"powers",
 CellID->55665845],

Cell[TextData[{
 "Create a built-up power by pressing the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["6", "KeyEvent"],
 " key at the same time. "
}], "Text",
 CellID->318462715],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["6", "KeyEvent"],
 " or ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["^", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->287147653],

Cell[BoxData[
 SuperscriptBox["x", 
  StyleBox["\[Placeholder]",
   DrawHighlighted->1]]], "Input",
 CellTags->"powers",
 CellID->413718415],

Cell["\<\
Type the exponent into the placeholder (which is already selected). \
\>", "Text",
 CellID->1780451],

Cell[TextData[{
 "Type ",
 Cell[BoxData["m"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->79286418],

Cell[BoxData[
 SuperscriptBox["x", 
  RowBox[{"m", "\[VerticalSeparator]"}]]], "Input",
 CellTags->"powers",
 CellID->235932712],

Cell[TextData[{
 "Move the insertion point out of the exponent down to the baseline by \
pressing the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["Space", "KeyEvent"],
 " bar at the same time. "
}], "Text",
 CellID->322951253],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->472336432],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "m"], "\[VerticalSeparator]"}]], "Input",
 CellTags->"powers",
 CellID->10171308]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Typing",
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", "m"], "+", 
    SuperscriptBox["y", "n"]}], TraditionalForm]]]
}], "Section",
 CellID->1498891720],

Cell["Start with the expression that will be the base. ", "Text",
 CellID->1889958730],

Cell[TextData[{
 "Type ",
 Cell[BoxData["x"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->1105752333],

Cell[BoxData[
 RowBox[{"x", "\[VerticalSeparator]"}]], "Input",
 CellTags->"powers",
 CellID->55979593],

Cell[TextData[{
 "Create a built-up power by pressing the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["6", "KeyEvent"],
 " key at the same time. "
}], "Text",
 CellID->251182165],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["6", "KeyEvent"],
 " or ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["^", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->1813280800],

Cell[BoxData[
 SuperscriptBox["x", 
  StyleBox["\[Placeholder]",
   DrawHighlighted->1]]], "Input",
 CellTags->"powers",
 CellID->869971023],

Cell["\<\
Type the exponent into the placeholder (which is already selected). \
\>", "Text",
 CellID->1534314785],

Cell[TextData[{
 "Type ",
 Cell[BoxData["m"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->244958319],

Cell[BoxData[
 SuperscriptBox["x", 
  RowBox[{"m", "\[VerticalSeparator]"}]]], "Input",
 CellTags->"powers",
 CellID->288316134],

Cell[TextData[{
 "Move the insertion point out of the exponent down to the baseline by \
pressing the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["Space", "KeyEvent"],
 " bar at the same time. "
}], "Text",
 CellID->1006156506],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->1186159864],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "m"], "\[VerticalSeparator]"}]], "Input",
 CellTags->"powers",
 CellID->698139147],

Cell[TextData[{
 "Type ",
 Cell[BoxData["+"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->1921480068],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   StyleBox["+",
    FontColor->GrayLevel[0]]}], 
  StyleBox[" ",
   FontColor->GrayLevel[0]], 
  StyleBox["|",
   FontColor->GrayLevel[0]]}]], "Input",
 CellTags->"powers",
 CellID->456419290],

Cell["Add the second power in a similar way. ", "Text",
 CellID->227419946],

Cell[TextData[{
 "Type ",
 Cell[BoxData["y"], "InlineFormula"],
 ", press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["^", "KeyEvent"],
 ", type ",
 Cell[BoxData["n"], "InlineFormula"],
 ", and press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->1873624409],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["x", "m"], "+", 
   SuperscriptBox["y", "n"]}], "\[VerticalSeparator]"}]], "Input",
 CellTags->"powers",
 CellID->1452726102]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Typing",
 " ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", 
    RowBox[{"m", "+", "n"}]], TraditionalForm]]]
}], "Section",
 CellID->1226013571],

Cell["Start with the expression that will be the base. ", "Text",
 CellID->504494832],

Cell[TextData[{
 "Type ",
 Cell[BoxData["x"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->779203068],

Cell[BoxData[
 RowBox[{"x", "\[VerticalSeparator]"}]], "Input",
 CellTags->"powers",
 CellID->710684470],

Cell[TextData[{
 "Create a built-up power by pressing the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["6", "KeyEvent"],
 " key at the same time. "
}], "Text",
 CellID->169842676],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["6", "KeyEvent"],
 " or ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["^", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->540088669],

Cell[BoxData[
 SuperscriptBox["x", 
  StyleBox["\[Placeholder]",
   DrawHighlighted->1]]], "Input",
 CellTags->"powers",
 CellID->2004367661],

Cell["\<\
Type the exponent into the placeholder (which is already selected). \
\>", "Text",
 CellID->1978791585],

Cell[TextData[{
 "Type ",
 Cell[BoxData[
  RowBox[{"m", "+", "n"}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->1618411653],

Cell[BoxData[
 SuperscriptBox["x", 
  RowBox[{
   RowBox[{"m", "+", "n"}], "|"}]]], "Input",
 CellTags->"powers",
 CellID->616779069],

Cell[TextData[{
 "Move the insertion point out of the exponent down to the baseline by \
pressing the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["Space", "KeyEvent"],
 " bar at the same time."
}], "Text",
 CellID->302248614],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->1093630343],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", 
   RowBox[{"m", "+", "n"}]], "|"}]], "Input",
 CellTags->"powers",
 CellID->332640128]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Typing ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", 
    FractionBox["m", "n"]], TraditionalForm]]]
}], "Section",
 CellID->782698155],

Cell["Start with the expression that will be the base. ", "Text",
 CellID->1470553210],

Cell[TextData[{
 "Type ",
 Cell[BoxData["x"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->198507147],

Cell[BoxData[
 RowBox[{"x", "\[VerticalSeparator]"}]], "Input",
 CellTags->"powers",
 CellID->1267515838],

Cell[TextData[{
 "Create a built-up power by pressing the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["6", "KeyEvent"],
 " key at the same time. "
}], "Text",
 CellID->100911026],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["6", "KeyEvent"],
 " or ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["^", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->1647016499],

Cell[BoxData[
 SuperscriptBox["x", 
  StyleBox["\[Placeholder]",
   DrawHighlighted->1]]], "Input",
 CellTags->"powers",
 CellID->342088863],

Cell["\<\
Type the exponent into the placeholder (which is already selected). \
\>", "Text",
 CellID->673797422],

Cell[TextData[{
 "Type ",
 Cell[BoxData["m"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->832000923],

Cell[BoxData[
 SuperscriptBox["x", 
  RowBox[{"m", "\[VerticalSeparator]"}]]], "Input",
 CellTags->"powers",
 CellID->1173487244],

Cell["Construct a built-up fraction in the exponent. ", "Text",
 CellID->310295860],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["/", "KeyEvent"],
 ", type ",
 Cell[BoxData["n"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->1052224104],

Cell[BoxData[
 SuperscriptBox["x", 
  FractionBox["m", 
   RowBox[{"n", "\[VerticalSeparator]"}]]]], "Input",
 CellTags->"powers",
 CellID->202682883],

Cell[TextData[{
 "Press the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["Space", "KeyEvent"],
 " bar twice to get down to the baseline. "
}], "Text",
 CellID->582150439],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 " twice."
}], "MathCaption",
 CellID->266932541],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", 
   FractionBox["m", "n"]], "\[VerticalSeparator]"}]], "Input",
 CellTags->"powers",
 CellID->241878004],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->325356779],

Cell[TextData[ButtonBox["Entering Two-Dimensional Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EnteringTwoDimensionalExpressionsOverview"]], \
"RelatedTutorials",
 CellID->161747686]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Typing Powers - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Entering Two-Dimensional Expressions", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/EnteringTwoDimensionalExpressionsOverview"]], "Text",
       FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TypingFractions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TypingSquareRoots"]}], "Text",
       FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 44, 32.3754656}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Start with the expression that will be the base. Type x. Create a \
built-up power by pressing the Control key and the 6 key at the same time. ", 
    "synonyms" -> {}, "title" -> "Typing Powers", "type" -> "Tutorial", "uri" -> 
    "tutorial/TypingPowers"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "powers"->{
  Cell[1722, 68, 103, 3, 70, "Input",
   CellTags->"powers",
   CellID->55665845],
  Cell[2304, 95, 140, 5, 70, "Input",
   CellTags->"powers",
   CellID->413718415],
  Cell[2669, 114, 128, 4, 70, "Input",
   CellTags->"powers",
   CellID->235932712],
  Cell[3223, 139, 127, 4, 70, "Input",
   CellTags->"powers",
   CellID->10171308],
  Cell[3783, 169, 103, 3, 70, "Input",
   CellTags->"powers",
   CellID->55979593],
  Cell[4366, 196, 140, 5, 70, "Input",
   CellTags->"powers",
   CellID->869971023],
  Cell[4735, 215, 128, 4, 70, "Input",
   CellTags->"powers",
   CellID->288316134],
  Cell[5291, 240, 128, 4, 70, "Input",
   CellTags->"powers",
   CellID->698139147],
  Cell[5533, 253, 263, 11, 70, "Input",
   CellTags->"powers",
   CellID->456419290],
  Cell[6264, 286, 178, 6, 70, "Input",
   CellTags->"powers",
   CellID->1452726102],
  Cell[6847, 317, 104, 3, 70, "Input",
   CellTags->"powers",
   CellID->710684470],
  Cell[7430, 344, 141, 5, 70, "Input",
   CellTags->"powers",
   CellID->2004367661],
  Cell[7824, 364, 133, 5, 70, "Input",
   CellTags->"powers",
   CellID->616779069],
  Cell[8383, 390, 133, 5, 70, "Input",
   CellTags->"powers",
   CellID->332640128],
  Cell[8914, 419, 105, 3, 70, "Input",
   CellTags->"powers",
   CellID->1267515838],
  Cell[9499, 446, 140, 5, 70, "Input",
   CellTags->"powers",
   CellID->342088863],
  Cell[9867, 465, 129, 4, 70, "Input",
   CellTags->"powers",
   CellID->1173487244],
  Cell[10305, 485, 150, 5, 70, "Input",
   CellTags->"powers",
   CellID->202682883],
  Cell[10830, 510, 150, 5, 70, "Input",
   CellTags->"powers",
   CellID->241878004]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"powers", 13465, 583}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 684, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1309, 44, 51, 1, 70, "Title",
 CellID->1453038488],
Cell[CellGroupData[{
Cell[1385, 49, 137, 7, 70, "Section",
 CellID->14222],
Cell[1525, 58, 84, 1, 70, "Text",
 CellID->13070490],
Cell[1612, 61, 107, 5, 70, "MathCaption",
 CellID->197692404],
Cell[1722, 68, 103, 3, 70, "Input",
 CellTags->"powers",
 CellID->55665845],
Cell[1828, 73, 199, 7, 70, "Text",
 CellID->318462715],
Cell[2030, 82, 271, 11, 70, "MathCaption",
 CellID->287147653],
Cell[2304, 95, 140, 5, 70, "Input",
 CellTags->"powers",
 CellID->413718415],
Cell[2447, 102, 110, 3, 70, "Text",
 CellID->1780451],
Cell[2560, 107, 106, 5, 70, "MathCaption",
 CellID->79286418],
Cell[2669, 114, 128, 4, 70, "Input",
 CellTags->"powers",
 CellID->235932712],
Cell[2800, 120, 247, 8, 70, "Text",
 CellID->322951253],
Cell[3050, 130, 170, 7, 70, "MathCaption",
 CellID->472336432],
Cell[3223, 139, 127, 4, 70, "Input",
 CellTags->"powers",
 CellID->10171308]
}, Open  ]],
Cell[CellGroupData[{
Cell[3387, 148, 193, 9, 70, "Section",
 CellID->1498891720],
Cell[3583, 159, 86, 1, 70, "Text",
 CellID->1889958730],
Cell[3672, 162, 108, 5, 70, "MathCaption",
 CellID->1105752333],
Cell[3783, 169, 103, 3, 70, "Input",
 CellTags->"powers",
 CellID->55979593],
Cell[3889, 174, 199, 7, 70, "Text",
 CellID->251182165],
Cell[4091, 183, 272, 11, 70, "MathCaption",
 CellID->1813280800],
Cell[4366, 196, 140, 5, 70, "Input",
 CellTags->"powers",
 CellID->869971023],
Cell[4509, 203, 113, 3, 70, "Text",
 CellID->1534314785],
Cell[4625, 208, 107, 5, 70, "MathCaption",
 CellID->244958319],
Cell[4735, 215, 128, 4, 70, "Input",
 CellTags->"powers",
 CellID->288316134],
Cell[4866, 221, 248, 8, 70, "Text",
 CellID->1006156506],
Cell[5117, 231, 171, 7, 70, "MathCaption",
 CellID->1186159864],
Cell[5291, 240, 128, 4, 70, "Input",
 CellTags->"powers",
 CellID->698139147],
Cell[5422, 246, 108, 5, 70, "MathCaption",
 CellID->1921480068],
Cell[5533, 253, 263, 11, 70, "Input",
 CellTags->"powers",
 CellID->456419290],
Cell[5799, 266, 75, 1, 70, "Text",
 CellID->227419946],
Cell[5877, 269, 384, 15, 70, "MathCaption",
 CellID->1873624409],
Cell[6264, 286, 178, 6, 70, "Input",
 CellTags->"powers",
 CellID->1452726102]
}, Open  ]],
Cell[CellGroupData[{
Cell[6479, 297, 167, 8, 70, "Section",
 CellID->1226013571],
Cell[6649, 307, 85, 1, 70, "Text",
 CellID->504494832],
Cell[6737, 310, 107, 5, 70, "MathCaption",
 CellID->779203068],
Cell[6847, 317, 104, 3, 70, "Input",
 CellTags->"powers",
 CellID->710684470],
Cell[6954, 322, 199, 7, 70, "Text",
 CellID->169842676],
Cell[7156, 331, 271, 11, 70, "MathCaption",
 CellID->540088669],
Cell[7430, 344, 141, 5, 70, "Input",
 CellTags->"powers",
 CellID->2004367661],
Cell[7574, 351, 113, 3, 70, "Text",
 CellID->1978791585],
Cell[7690, 356, 131, 6, 70, "MathCaption",
 CellID->1618411653],
Cell[7824, 364, 133, 5, 70, "Input",
 CellTags->"powers",
 CellID->616779069],
Cell[7960, 371, 246, 8, 70, "Text",
 CellID->302248614],
Cell[8209, 381, 171, 7, 70, "MathCaption",
 CellID->1093630343],
Cell[8383, 390, 133, 5, 70, "Input",
 CellTags->"powers",
 CellID->332640128]
}, Open  ]],
Cell[CellGroupData[{
Cell[8553, 400, 159, 7, 70, "Section",
 CellID->782698155],
Cell[8715, 409, 86, 1, 70, "Text",
 CellID->1470553210],
Cell[8804, 412, 107, 5, 70, "MathCaption",
 CellID->198507147],
Cell[8914, 419, 105, 3, 70, "Input",
 CellTags->"powers",
 CellID->1267515838],
Cell[9022, 424, 199, 7, 70, "Text",
 CellID->100911026],
Cell[9224, 433, 272, 11, 70, "MathCaption",
 CellID->1647016499],
Cell[9499, 446, 140, 5, 70, "Input",
 CellTags->"powers",
 CellID->342088863],
Cell[9642, 453, 112, 3, 70, "Text",
 CellID->673797422],
Cell[9757, 458, 107, 5, 70, "MathCaption",
 CellID->832000923],
Cell[9867, 465, 129, 4, 70, "Input",
 CellTags->"powers",
 CellID->1173487244],
Cell[9999, 471, 83, 1, 70, "Text",
 CellID->310295860],
Cell[10085, 474, 217, 9, 70, "MathCaption",
 CellID->1052224104],
Cell[10305, 485, 150, 5, 70, "Input",
 CellTags->"powers",
 CellID->202682883],
Cell[10458, 492, 190, 7, 70, "Text",
 CellID->582150439],
Cell[10651, 501, 176, 7, 70, "MathCaption",
 CellID->266932541],
Cell[10830, 510, 150, 5, 70, "Input",
 CellTags->"powers",
 CellID->241878004],
Cell[CellGroupData[{
Cell[11005, 519, 72, 1, 70, "RelatedTutorialsSection",
 CellID->325356779],
Cell[11080, 522, 204, 5, 70, "RelatedTutorials",
 CellID->161747686]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[11323, 532, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

