(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16354,        668]
NotebookOptionsPosition[      9377,        444]
NotebookOutlinePosition[     12878,        544]
CellTagsIndexPosition[     12804,        539]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Entering Two-Dimensional Expressions" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/EnteringTwoDimensionalExpressionsOverview"]}, #, 
        2]& , Evaluator -> Automatic], {
      1->"\<\"Entering Two-Dimensional Expressions\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Typing Square Roots", "Title",
 CellID->1714573716],

Cell[CellGroupData[{

Cell[TextData[{
 "Typing",
 " ",
 Cell[BoxData[
  FormBox[
   SqrtBox["x"], TraditionalForm]]]
}], "Section",
 CellID->17111],

Cell[TextData[{
 "To get a square root sign, press the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["2", "KeyEvent"],
 " key at the same time. "
}], "Text",
 CellID->684487304],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["2", "KeyEvent"],
 " or ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["@", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->90938115],

Cell[BoxData[
 SqrtBox[
  StyleBox["\[Placeholder]",
   DrawHighlighted->1]]], "Input",
 CellTags->"squareroots",
 CellID->420669506],

Cell["Type inside the placeholder (which is already selected).", "Text",
 CellID->256907757],

Cell[TextData[{
 "Type ",
 Cell[BoxData["x"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->431169093],

Cell[BoxData[
 SqrtBox[
  RowBox[{"x", "\[VerticalSeparator]"}]]], "Input",
 CellTags->"squareroots",
 CellID->259129087],

Cell[TextData[{
 "Press the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["Space", "KeyEvent"],
 " bar at the same time to get out of the square root. "
}], "Text",
 CellID->23701555],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->61818788],

Cell[BoxData[
 RowBox[{
  SqrtBox["x"], "\[VerticalSeparator]"}]], "Input",
 CellTags->"squareroots",
 CellID->796999424]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Typing",
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SqrtBox["x"], 
    SqrtBox["y"]}], TraditionalForm]]]
}], "Section",
 CellID->17222],

Cell[TextData[{
 "To get a square root sign, press the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["2", "KeyEvent"],
 " key at the same time. "
}], "Text",
 CellID->262938196],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["2", "KeyEvent"],
 " or ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["@", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->22307115],

Cell[BoxData[
 SqrtBox[
  StyleBox["\[Placeholder]",
   DrawHighlighted->1]]], "Input",
 CellTags->"squareroots",
 CellID->283193422],

Cell["Type inside the placeholder (which is already selected).", "Text",
 CellID->295795307],

Cell[TextData[{
 "Type ",
 Cell[BoxData["x"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->376650508],

Cell[BoxData[
 SqrtBox[
  RowBox[{"x", "\[VerticalSeparator]"}]]], "Input",
 CellTags->"squareroots",
 CellID->533785659],

Cell[TextData[{
 "Press the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["Space", "KeyEvent"],
 " bar at the same time to get out of the square root. "
}], "Text",
 CellID->371113326],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->36928049],

Cell[BoxData[
 RowBox[{
  SqrtBox["x"], "\[VerticalSeparator]"}]], "Input",
 CellTags->"squareroots",
 CellID->489135662],

Cell["Type the second square root in the same way as the first. ", "Text",
 CellID->353631914],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["@", "KeyEvent"],
 ", type ",
 Cell[BoxData["y"], "InlineFormula"],
 ", and press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->454071162],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox["x"], 
   SqrtBox["y"]}], "\[VerticalSeparator]"}]], "Input",
 CellTags->"squareroots",
 CellID->342012554]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Typing",
 " ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    RowBox[{"x", " ", "y"}]], TraditionalForm]]]
}], "Section",
 CellID->17333],

Cell[TextData[{
 "To get a square root sign, press the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["2", "KeyEvent"],
 " key at the same time. "
}], "Text",
 CellID->239298737],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["2", "KeyEvent"],
 " or ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["@", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->11953563],

Cell[BoxData[
 SqrtBox[
  StyleBox["\[Placeholder]",
   DrawHighlighted->1]]], "Input",
 CellTags->"squareroots",
 CellID->878859866],

Cell["Type inside the placeholder (which is already selected).", "Text",
 CellID->147269270],

Cell[TextData[{
 "Type ",
 Cell[BoxData[
  RowBox[{"x", " ", "y"}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->414969453],

Cell[BoxData[
 SqrtBox[
  RowBox[{
   RowBox[{"x", " ", "y"}], "\[VerticalSeparator]"}]]], "Input",
 CellTags->"squareroots",
 CellID->117853364],

Cell[TextData[{
 "Press the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["Space", "KeyEvent"],
 " bar at the same time to get out of the square root. "
}], "Text",
 CellID->795445671],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->311695124],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   RowBox[{"x", " ", "y"}]], "\[VerticalSeparator]"}]], "Input",
 CellTags->"squareroots",
 CellID->73292304]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Another Way of ",
 "Typing",
 " ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    RowBox[{"x", " ", "y"}]], TraditionalForm]]]
}], "Section",
 CellID->17444],

Cell["\<\
Start by typing the expression that will be inside the square root. \
\>", "Text",
 CellID->153092346],

Cell[TextData[{
 "Type ",
 Cell[BoxData[
  RowBox[{"x", " ", "y"}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->1534451],

Cell[BoxData[
 RowBox[{"x", " ", "y"}]], "Input",
 CellTags->"squareroots",
 CellID->357164017],

Cell[TextData[{
 "Select the expression. (You can select by dragging, by pressing ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox[".", "KeyEvent"],
 " repeatedly, or by clicking the expression repeatedly.) "
}], "Text",
 CellID->277481605],

Cell[TextData[{
 "Select ",
 Cell[BoxData[
  RowBox[{"x", " ", "y"}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->41117918],

Cell[BoxData[
 StyleBox[
  RowBox[{"x", " ", "y"}],
  DrawHighlighted->1]], "Input",
 CellTags->"squareroots",
 CellID->128771970],

Cell[TextData[{
 "Press the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["@", "KeyEvent"],
 " key at the same time to put a square root around the selection. "
}], "Text",
 CellID->753531428],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["@", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->257878982],

Cell[BoxData[
 SqrtBox[
  RowBox[{
   RowBox[{"x", " ", "y"}], "|"}]]], "Input",
 CellTags->"squareroots",
 CellID->84390327],

Cell[TextData[{
 "Get out of the square root by pressing the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["Space", "KeyEvent"],
 " bar at the same time. "
}], "Text",
 CellID->83474669],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->31155432],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   RowBox[{"x", " ", "y"}]], "\[VerticalSeparator]"}]], "Input",
 CellTags->"squareroots",
 CellID->787879702],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->102415935],

Cell[TextData[ButtonBox["Entering Two-Dimensional Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EnteringTwoDimensionalExpressionsOverview"]], \
"RelatedTutorials",
 CellID->161747686]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Typing Square Roots - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Entering Two-Dimensional Expressions", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/EnteringTwoDimensionalExpressionsOverview"]], "Text",
       FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TypingPowers"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TypingRadicals"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 44, 34.5473962}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "To get a square root sign, press the Control key and the 2 key at the \
same time. Press Ctrl+2 or Ctrl+@. Type inside the placeholder (which is \
already selected).", "synonyms" -> {}, "title" -> "Typing Square Roots", 
    "type" -> "Tutorial", "uri" -> "tutorial/TypingSquareRoots"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "squareroots"->{
  Cell[1991, 80, 133, 5, 70, "Input",
   CellTags->"squareroots",
   CellID->420669506],
  Cell[2332, 97, 121, 4, 70, "Input",
   CellTags->"squareroots",
   CellID->259129087],
  Cell[2833, 121, 121, 4, 70, "Input",
   CellTags->"squareroots",
   CellID->796999424],
  Cell[3625, 163, 133, 5, 70, "Input",
   CellTags->"squareroots",
   CellID->283193422],
  Cell[3966, 180, 121, 4, 70, "Input",
   CellTags->"squareroots",
   CellID->533785659],
  Cell[4468, 204, 121, 4, 70, "Input",
   CellTags->"squareroots",
   CellID->489135662],
  Cell[5025, 228, 153, 6, 70, "Input",
   CellTags->"squareroots",
   CellID->342012554],
  Cell[5840, 271, 133, 5, 70, "Input",
   CellTags->"squareroots",
   CellID->878859866],
  Cell[6204, 289, 145, 5, 70, "Input",
   CellTags->"squareroots",
   CellID->117853364],
  Cell[6731, 314, 144, 5, 70, "Input",
   CellTags->"squareroots",
   CellID->73292304],
  Cell[7331, 348, 95, 3, 70, "Input",
   CellTags->"squareroots",
   CellID->357164017],
  Cell[7838, 370, 130, 5, 70, "Input",
   CellTags->"squareroots",
   CellID->128771970],
  Cell[8354, 395, 125, 5, 70, "Input",
   CellTags->"squareroots",
   CellID->84390327],
  Cell[8862, 420, 145, 5, 70, "Input",
   CellTags->"squareroots",
   CellID->787879702]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"squareroots", 11525, 493}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 684, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1309, 44, 57, 1, 70, "Title",
 CellID->1714573716],
Cell[CellGroupData[{
Cell[1391, 49, 125, 7, 70, "Section",
 CellID->17111],
Cell[1519, 58, 196, 7, 70, "Text",
 CellID->684487304],
Cell[1718, 67, 270, 11, 70, "MathCaption",
 CellID->90938115],
Cell[1991, 80, 133, 5, 70, "Input",
 CellTags->"squareroots",
 CellID->420669506],
Cell[2127, 87, 92, 1, 70, "Text",
 CellID->256907757],
Cell[2222, 90, 107, 5, 70, "MathCaption",
 CellID->431169093],
Cell[2332, 97, 121, 4, 70, "Input",
 CellTags->"squareroots",
 CellID->259129087],
Cell[2456, 103, 202, 7, 70, "Text",
 CellID->23701555],
Cell[2661, 112, 169, 7, 70, "MathCaption",
 CellID->61818788],
Cell[2833, 121, 121, 4, 70, "Input",
 CellTags->"squareroots",
 CellID->796999424]
}, Open  ]],
Cell[CellGroupData[{
Cell[2991, 130, 159, 9, 70, "Section",
 CellID->17222],
Cell[3153, 141, 196, 7, 70, "Text",
 CellID->262938196],
Cell[3352, 150, 270, 11, 70, "MathCaption",
 CellID->22307115],
Cell[3625, 163, 133, 5, 70, "Input",
 CellTags->"squareroots",
 CellID->283193422],
Cell[3761, 170, 92, 1, 70, "Text",
 CellID->295795307],
Cell[3856, 173, 107, 5, 70, "MathCaption",
 CellID->376650508],
Cell[3966, 180, 121, 4, 70, "Input",
 CellTags->"squareroots",
 CellID->533785659],
Cell[4090, 186, 203, 7, 70, "Text",
 CellID->371113326],
Cell[4296, 195, 169, 7, 70, "MathCaption",
 CellID->36928049],
Cell[4468, 204, 121, 4, 70, "Input",
 CellTags->"squareroots",
 CellID->489135662],
Cell[4592, 210, 94, 1, 70, "Text",
 CellID->353631914],
Cell[4689, 213, 333, 13, 70, "MathCaption",
 CellID->454071162],
Cell[5025, 228, 153, 6, 70, "Input",
 CellTags->"squareroots",
 CellID->342012554]
}, Open  ]],
Cell[CellGroupData[{
Cell[5215, 239, 150, 8, 70, "Section",
 CellID->17333],
Cell[5368, 249, 196, 7, 70, "Text",
 CellID->239298737],
Cell[5567, 258, 270, 11, 70, "MathCaption",
 CellID->11953563],
Cell[5840, 271, 133, 5, 70, "Input",
 CellTags->"squareroots",
 CellID->878859866],
Cell[5976, 278, 92, 1, 70, "Text",
 CellID->147269270],
Cell[6071, 281, 130, 6, 70, "MathCaption",
 CellID->414969453],
Cell[6204, 289, 145, 5, 70, "Input",
 CellTags->"squareroots",
 CellID->117853364],
Cell[6352, 296, 203, 7, 70, "Text",
 CellID->795445671],
Cell[6558, 305, 170, 7, 70, "MathCaption",
 CellID->311695124],
Cell[6731, 314, 144, 5, 70, "Input",
 CellTags->"squareroots",
 CellID->73292304]
}, Open  ]],
Cell[CellGroupData[{
Cell[6912, 324, 170, 9, 70, "Section",
 CellID->17444],
Cell[7085, 335, 112, 3, 70, "Text",
 CellID->153092346],
Cell[7200, 340, 128, 6, 70, "MathCaption",
 CellID->1534451],
Cell[7331, 348, 95, 3, 70, "Input",
 CellTags->"squareroots",
 CellID->357164017],
Cell[7429, 353, 272, 7, 70, "Text",
 CellID->277481605],
Cell[7704, 362, 131, 6, 70, "MathCaption",
 CellID->41117918],
Cell[7838, 370, 130, 5, 70, "Input",
 CellTags->"squareroots",
 CellID->128771970],
Cell[7971, 377, 211, 7, 70, "Text",
 CellID->753531428],
Cell[8185, 386, 166, 7, 70, "MathCaption",
 CellID->257878982],
Cell[8354, 395, 125, 5, 70, "Input",
 CellTags->"squareroots",
 CellID->84390327],
Cell[8482, 402, 205, 7, 70, "Text",
 CellID->83474669],
Cell[8690, 411, 169, 7, 70, "MathCaption",
 CellID->31155432],
Cell[8862, 420, 145, 5, 70, "Input",
 CellTags->"squareroots",
 CellID->787879702],
Cell[CellGroupData[{
Cell[9032, 429, 72, 1, 70, "RelatedTutorialsSection",
 CellID->102415935],
Cell[9107, 432, 204, 5, 70, "RelatedTutorials",
 CellID->161747686]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[9350, 442, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

