(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14368,        582]
NotebookOptionsPosition[      8304,        387]
NotebookOutlinePosition[     11277,        473]
CellTagsIndexPosition[     11202,        468]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Entering Two-Dimensional Expressions" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/EnteringTwoDimensionalExpressionsOverview"]}, #, 
        2]& , Evaluator -> Automatic], {
      1->"\<\"Entering Two-Dimensional Expressions\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Typing Underscripts", "Title",
 CellID->226163093],

Cell[CellGroupData[{

Cell[TextData[{
 "Typing",
 " ",
 Cell[BoxData[
  FormBox[
   UnderscriptBox["x", "_"], TraditionalForm]]]
}], "Section",
 CellID->22111],

Cell["Type the expression that will have an underscript. ", "Text",
 CellID->128348434],

Cell[TextData[{
 "Type ",
 Cell[BoxData["x"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->110308255],

Cell[BoxData[
 RowBox[{"x", "\[VerticalSeparator]"}]], "Input",
 CellTags->"underscripts",
 CellID->156044399],

Cell[TextData[{
 "Create an underscript by pressing the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["=", "KeyEvent"],
 " key at the same time. "
}], "Text",
 CellID->388526734],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["=", "KeyEvent"],
 " or ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["+", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->623982220],

Cell[BoxData[
 UnderscriptBox["x", 
  StyleBox["\[Placeholder]",
   DrawHighlighted->1]]], "Input",
 CellTags->"underscripts",
 CellID->57563636],

Cell["\<\
Type an underscore into the placeholder (which is already selected). \
\>", "Text",
 CellID->218071578],

Cell[TextData[{
 "Type ",
 Cell[BoxData["_"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->5510642],

Cell[BoxData[
 UnderscriptBox["x", 
  RowBox[{"_", "\[VerticalSeparator]"}]]], "Input",
 CellTags->"underscripts",
 CellID->9318875],

Cell[TextData[{
 "Move the insertion point out of the underscript position up to the baseline \
by pressing the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["Space", "KeyEvent"],
 " bar at the same time. "
}], "Text",
 CellID->32923665],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->7508940],

Cell[BoxData[
 RowBox[{
  UnderscriptBox["x", "_"], "\[VerticalSeparator]"}]], "Input",
 CellTags->"underscripts",
 CellID->506799743]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Typing",
 " ",
 Cell[BoxData[
  FormBox[
   UnderscriptBox[
    RowBox[{"x", "+", "y"}], "_"], TraditionalForm]]]
}], "Section",
 CellID->22222],

Cell[TextData[{
 "Press the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["=", "KeyEvent"],
 " key at the same time. "
}], "Text",
 CellID->446137853],

Cell["\<\
This creates a pair of placeholders, one on the baseline and another in the \
underscript position. \
\>", "Text",
 CellID->425095243],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["=", "KeyEvent"],
 " or ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["+", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->54444391],

Cell[BoxData[
 UnderscriptBox["\[SelectionPlaceholder]", "\[Placeholder]"]], "Input",
 CellID->424853398],

Cell["\<\
Type the expression into the placeholder (which is already selected). \
\>", "Text",
 CellID->292163985],

Cell[TextData[{
 "Type ",
 Cell[BoxData[
  RowBox[{"x", "+", "y"}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->903697041],

Cell[BoxData[
 UnderscriptBox[
  RowBox[{"x", "+", "y"}], "\[Placeholder]"]], "Input",
 CellID->383812972],

Cell[TextData[{
 "Press the ",
 StyleBox["Tab", "KeyEvent"],
 " key to select the placeholder that is under the baseline. "
}], "Text",
 CellID->158285272],

Cell[TextData[{
 "Press ",
 StyleBox["Tab", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->216540821],

Cell[BoxData[
 UnderscriptBox[
  RowBox[{"x", "+", "y"}], "\[SelectionPlaceholder]"]], "Input",
 CellID->638519805],

Cell["Type an underscore. ", "Text",
 CellID->448280177],

Cell[TextData[{
 "Type ",
 Cell[BoxData["_"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->585149526],

Cell[BoxData[
 UnderscriptBox[
  RowBox[{"x", "+", "y"}], 
  RowBox[{"_", "\[VerticalSeparator]"}]]], "Input",
 CellTags->"underscripts",
 CellID->32643294],

Cell[TextData[{
 "Press the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["Space", "KeyEvent"],
 " bar at the same time to get out of the underscripted expression. "
}], "Text",
 CellID->45729143],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->113381973],

Cell[BoxData[
 RowBox[{
  UnderscriptBox[
   RowBox[{"x", "+", "y"}], "_"], "\[VerticalSeparator]"}]], "Input",
 CellTags->"underscripts",
 CellID->122253749]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Typing",
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox[
     UnderscriptBox["lim", 
      RowBox[{"x", "->", "a"}]],
     ScriptLevel->0], 
    RowBox[{"f", "[", "x", "]"}]}], TraditionalForm]]]
}], "Section",
 CellID->22333],

Cell[TextData[{
 "Type ",
 Cell[BoxData["lim"], "InlineFormula"],
 ", and press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["+", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->327443005],

Cell[BoxData[
 UnderscriptBox["lim", 
  StyleBox["\[Placeholder]",
   DrawHighlighted->1]]], "Input",
 CellTags->"underscripts",
 CellID->87765578],

Cell[TextData[{
 "Type ",
 Cell[BoxData["x"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->78963650],

Cell[BoxData[
 UnderscriptBox["lim", 
  RowBox[{"x", "\[VerticalSeparator]"}]]], "Input",
 CellTags->"underscripts",
 CellID->551544125],

Cell[TextData[{
 "Press ",
 StyleBox["Esc", "KeyEvent"],
 ", type ",
 Cell[BoxData["->"], "InlineFormula"],
 ", and press ",
 StyleBox["Esc", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->170789784],

Cell[BoxData[
 UnderscriptBox["lim", 
  RowBox[{
   RowBox[{"x", "\[Rule]"}], "\[VerticalSeparator]"}]]], "Input",
 CellTags->"underscripts",
 CellID->221403578],

Cell[TextData[{
 "Type ",
 Cell[BoxData["a"], "InlineFormula"],
 ", and press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->375683803],

Cell[BoxData[
 RowBox[{
  UnderscriptBox["lim", 
   RowBox[{"x", "\[Rule]", "a"}]], "\[VerticalSeparator]"}]], "Input",
 CellTags->"underscripts",
 CellID->927958370],

Cell[TextData[{
 "Type ",
 Cell[BoxData[
  RowBox[{"f", "[", "x", "]"}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->44005078],

Cell[BoxData[
 RowBox[{
  RowBox[{
   UnderscriptBox["lim", 
    RowBox[{"x", "\[Rule]", "a"}]], 
   RowBox[{"f", "[", "x", "]"}]}], "\[VerticalSeparator]"}]], "Input",
 CellTags->"underscripts",
 CellID->793031135],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->64793136],

Cell[TextData[ButtonBox["Entering Two-Dimensional Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EnteringTwoDimensionalExpressionsOverview"]], \
"RelatedTutorials",
 CellID->161747686]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Typing Underscripts - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Entering Two-Dimensional Expressions", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/EnteringTwoDimensionalExpressionsOverview"]], "Text",
       FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TypingOverscripts"]}], "Text",
       FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 44, 36.0161838}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Type the expression that will have an underscript. Type x. Create an \
underscript by pressing the Control key and the = key at the same time. ", 
    "synonyms" -> {}, "title" -> "Typing Underscripts", "type" -> "Tutorial", 
    "uri" -> "tutorial/TypingUnderscripts"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "underscripts"->{
  Cell[1730, 68, 110, 3, 70, "Input",
   CellTags->"underscripts",
   CellID->156044399],
  Cell[2317, 95, 145, 5, 70, "Input",
   CellTags->"underscripts",
   CellID->57563636],
  Cell[2689, 114, 132, 4, 70, "Input",
   CellTags->"underscripts",
   CellID->9318875],
  Cell[3254, 139, 134, 4, 70, "Input",
   CellTags->"underscripts",
   CellID->506799743],
  Cell[5197, 237, 156, 5, 70, "Input",
   CellTags->"underscripts",
   CellID->32643294],
  Cell[5747, 262, 158, 5, 70, "Input",
   CellTags->"underscripts",
   CellID->122253749],
  Cell[6424, 297, 147, 5, 70, "Input",
   CellTags->"underscripts",
   CellID->87765578],
  Cell[6683, 311, 136, 4, 70, "Input",
   CellTags->"underscripts",
   CellID->551544125],
  Cell[7023, 328, 161, 5, 70, "Input",
   CellTags->"underscripts",
   CellID->221403578],
  Cell[7414, 346, 166, 5, 70, "Input",
   CellTags->"underscripts",
   CellID->927958370],
  Cell[7720, 361, 215, 7, 70, "Input",
   CellTags->"underscripts",
   CellID->793031135]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"underscripts", 10184, 431}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 684, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1309, 44, 56, 1, 70, "Title",
 CellID->226163093],
Cell[CellGroupData[{
Cell[1390, 49, 137, 7, 70, "Section",
 CellID->22111],
Cell[1530, 58, 87, 1, 70, "Text",
 CellID->128348434],
Cell[1620, 61, 107, 5, 70, "MathCaption",
 CellID->110308255],
Cell[1730, 68, 110, 3, 70, "Input",
 CellTags->"underscripts",
 CellID->156044399],
Cell[1843, 73, 197, 7, 70, "Text",
 CellID->388526734],
Cell[2043, 82, 271, 11, 70, "MathCaption",
 CellID->623982220],
Cell[2317, 95, 145, 5, 70, "Input",
 CellTags->"underscripts",
 CellID->57563636],
Cell[2465, 102, 113, 3, 70, "Text",
 CellID->218071578],
Cell[2581, 107, 105, 5, 70, "MathCaption",
 CellID->5510642],
Cell[2689, 114, 132, 4, 70, "Input",
 CellTags->"underscripts",
 CellID->9318875],
Cell[2824, 120, 256, 8, 70, "Text",
 CellID->32923665],
Cell[3083, 130, 168, 7, 70, "MathCaption",
 CellID->7508940],
Cell[3254, 139, 134, 4, 70, "Input",
 CellTags->"underscripts",
 CellID->506799743]
}, Open  ]],
Cell[CellGroupData[{
Cell[3425, 148, 162, 8, 70, "Section",
 CellID->22222],
Cell[3590, 158, 169, 7, 70, "Text",
 CellID->446137853],
Cell[3762, 167, 144, 4, 70, "Text",
 CellID->425095243],
Cell[3909, 173, 270, 11, 70, "MathCaption",
 CellID->54444391],
Cell[4182, 186, 105, 2, 70, "Input",
 CellID->424853398],
Cell[4290, 190, 114, 3, 70, "Text",
 CellID->292163985],
Cell[4407, 195, 130, 6, 70, "MathCaption",
 CellID->903697041],
Cell[4540, 203, 106, 3, 70, "Input",
 CellID->383812972],
Cell[4649, 208, 155, 5, 70, "Text",
 CellID->158285272],
Cell[4807, 215, 100, 5, 70, "MathCaption",
 CellID->216540821],
Cell[4910, 222, 115, 3, 70, "Input",
 CellID->638519805],
Cell[5028, 227, 56, 1, 70, "Text",
 CellID->448280177],
Cell[5087, 230, 107, 5, 70, "MathCaption",
 CellID->585149526],
Cell[5197, 237, 156, 5, 70, "Input",
 CellTags->"underscripts",
 CellID->32643294],
Cell[5356, 244, 215, 7, 70, "Text",
 CellID->45729143],
Cell[5574, 253, 170, 7, 70, "MathCaption",
 CellID->113381973],
Cell[5747, 262, 158, 5, 70, "Input",
 CellTags->"underscripts",
 CellID->122253749]
}, Open  ]],
Cell[CellGroupData[{
Cell[5942, 272, 254, 12, 70, "Section",
 CellID->22333],
Cell[6199, 286, 222, 9, 70, "MathCaption",
 CellID->327443005],
Cell[6424, 297, 147, 5, 70, "Input",
 CellTags->"underscripts",
 CellID->87765578],
Cell[6574, 304, 106, 5, 70, "MathCaption",
 CellID->78963650],
Cell[6683, 311, 136, 4, 70, "Input",
 CellTags->"underscripts",
 CellID->551544125],
Cell[6822, 317, 198, 9, 70, "MathCaption",
 CellID->170789784],
Cell[7023, 328, 161, 5, 70, "Input",
 CellTags->"underscripts",
 CellID->221403578],
Cell[7187, 335, 224, 9, 70, "MathCaption",
 CellID->375683803],
Cell[7414, 346, 166, 5, 70, "Input",
 CellTags->"underscripts",
 CellID->927958370],
Cell[7583, 353, 134, 6, 70, "MathCaption",
 CellID->44005078],
Cell[7720, 361, 215, 7, 70, "Input",
 CellTags->"underscripts",
 CellID->793031135],
Cell[CellGroupData[{
Cell[7960, 372, 71, 1, 70, "RelatedTutorialsSection",
 CellID->64793136],
Cell[8034, 375, 204, 5, 70, "RelatedTutorials",
 CellID->161747686]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[8277, 385, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

