(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15483,        634]
NotebookOptionsPosition[      9075,        429]
NotebookOutlinePosition[     12491,        527]
CellTagsIndexPosition[     12421,        522]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Entering Two-Dimensional Expressions" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/EnteringTwoDimensionalExpressionsOverview"]}, #, 
        2]& , Evaluator -> Automatic], {
      1->"\<\"Entering Two-Dimensional Expressions\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Typing Vectors", "Title",
 CellID->77048861],

Cell[CellGroupData[{

Cell[TextData[{
 "Typing the Row Vector ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", GridBox[{
      {"a", "b", "c", "d"}
     }], ")"}], TraditionalForm]]]
}], "Section",
 CellID->77222],

Cell["\<\
Type a left parenthesis and a right parenthesis, then move the insertion \
point to be between them. \
\>", "Text",
 CellID->860042623],

Cell[TextData[{
 "Type ",
 Cell[BoxData[
  RowBox[{"(", ")"}]], "InlineFormula"],
 ", and press ",
 StyleBox["\[LeftArrow]", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->123675319],

Cell[BoxData[
 RowBox[{"(", "\[VerticalSeparator]", ")"}]], "Input",
 CellTags->"vectors",
 CellID->326751991],

Cell[TextData[{
 "Type the first entry of the vector. Create the next entry by pressing the \
",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox[",", "KeyEvent"],
 " key at the same time."
}], "Text",
 CellID->672993950],

Cell[TextData[{
 "Type ",
 Cell[BoxData["a"], "InlineFormula"],
 ", and press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox[",", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->89966511],

Cell[BoxData[
 RowBox[{"(", GridBox[{
    {"a", 
     StyleBox["\[Placeholder]",
      DrawHighlighted->1]}
   }], ")"}]], "Input",
 CellTags->"vectors",
 CellID->215626485],

Cell[TextData[{
 "Type the next entry into the placeholder (which is already selected). \
Create another entry by pressing the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox[",", "KeyEvent"],
 " key at the same time and repeat. "
}], "Text",
 CellID->106224282],

Cell[TextData[{
 "Type ",
 Cell[BoxData["b"], "InlineFormula"],
 ", and press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox[",", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->478257978],

Cell[BoxData[
 RowBox[{"(", GridBox[{
    {"a", "b", 
     StyleBox["\[Placeholder]",
      DrawHighlighted->1]}
   }], ")"}]], "Input",
 CellTags->"vectors",
 CellID->319797800],

Cell[TextData[{
 "Type ",
 Cell[BoxData["c"], "InlineFormula"],
 ", and press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox[",", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->22515963],

Cell[BoxData[
 RowBox[{"(", GridBox[{
    {"a", "b", "c", 
     StyleBox["\[Placeholder]",
      DrawHighlighted->1]}
   }], ")"}]], "Input",
 GeneratedCell->True,
 CellID->100427797],

Cell[TextData[{
 "Type ",
 Cell[BoxData["d"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->129719057],

Cell[BoxData[
 RowBox[{"(", GridBox[{
    {"a", "b", "c", 
     RowBox[{"d", "\[VerticalSeparator]"}]}
   }], ")"}]], "Input",
 CellTags->"vectors",
 CellID->267973403],

Cell[TextData[{
 "Press the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["Space", "KeyEvent"],
 " bar at the same time to get out of the grid. "
}], "Text",
 CellID->96686234],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->174190199],

Cell[BoxData[
 RowBox[{"(", 
  RowBox[{GridBox[{
     {"a", "b", "c", "d"}
    }], "\[VerticalSeparator]"}], ")"}]], "Input",
 CellTags->"vectors",
 CellID->615121980],

Cell["Move the insertion point to get out of the vector. ", "Text",
 CellID->478287196],

Cell[TextData[{
 "Press ",
 StyleBox["\[RightArrow]", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->480642104],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", GridBox[{
     {"a", "b", "c", "d"}
    }], ")"}], "\[VerticalSeparator]"}]], "Input",
 CellTags->"vectors",
 CellID->1703617]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Typing the Column Vector ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", GridBox[{
      {"a"},
      {"b"},
      {"c"},
      {"d"}
     }], ")"}], TraditionalForm]]]
}], "Section",
 CellID->1664027161],

Cell["\<\
Type a left parenthesis and a right parenthesis, then move the insertion \
point to be between them. \
\>", "Text",
 CellID->280393048],

Cell[TextData[{
 "Type ",
 Cell[BoxData[
  RowBox[{"(", ")"}]], "InlineFormula"],
 ", and press ",
 StyleBox["\[LeftArrow]", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->836933292],

Cell[BoxData[
 RowBox[{"(", "\[VerticalSeparator]", ")"}]], "Input",
 CellTags->"vectors",
 CellID->203942382],

Cell[TextData[{
 "Type the first entry of the vector. Create the next entry by pressing the \
",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["Return", "KeyEvent"],
 " key at the same time. "
}], "Text",
 CellID->8771663],

Cell[TextData[{
 "Type ",
 Cell[BoxData["a"], "InlineFormula"],
 ", and press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Return", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->86796939],

Cell[BoxData[
 RowBox[{"(", GridBox[{
    {"a"},
    {
     StyleBox["\[Placeholder]",
      DrawHighlighted->1]}
   }], ")"}]], "Input",
 CellTags->"vectors",
 CellID->3466848],

Cell[TextData[{
 "Type the next entry into the placeholder (which is already selected). \
Create another entry by pressing the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["Return", "KeyEvent"],
 " key at the same time and repeat. "
}], "Text",
 CellID->13351727],

Cell[TextData[{
 "Type ",
 Cell[BoxData["b"], "InlineFormula"],
 ", and press",
 StyleBox[" ",
  FontSize->16],
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Return", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->64873096],

Cell[BoxData[
 RowBox[{"(", GridBox[{
    {"a"},
    {"b"},
    {
     StyleBox["\[Placeholder]",
      DrawHighlighted->1]}
   }], ")"}]], "Input",
 CellTags->"vectors",
 CellID->532442959],

Cell[TextData[{
 "Type ",
 Cell[BoxData["c"], "InlineFormula"],
 ", and press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Return", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->547708683],

Cell[BoxData[
 RowBox[{"(", GridBox[{
    {"a"},
    {"b"},
    {"c"},
    {
     StyleBox["\[Placeholder]",
      DrawHighlighted->1]}
   }], ")"}]], "Input",
 CellTags->"vectors",
 CellID->49898838],

Cell[TextData[{
 "Type ",
 Cell[BoxData["d"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->167679073],

Cell[BoxData[
 RowBox[{"(", GridBox[{
    {"a"},
    {"b"},
    {"c"},
    {
     RowBox[{"d", "\[VerticalSeparator]"}]}
   }], ")"}]], "Input",
 CellTags->"vectors",
 CellID->15260246],

Cell[TextData[{
 "Press the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["Space", "KeyEvent"],
 " bar at the same time to get out of the grid. "
}], "Text",
 CellID->39987355],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->183668510],

Cell[BoxData[
 RowBox[{"(", 
  RowBox[{GridBox[{
     {"a"},
     {"b"},
     {"c"},
     {"d"}
    }], "\[VerticalSeparator]"}], ")"}]], "Input",
 CellTags->"vectors",
 CellID->4328774],

Cell["Move the insertion point to get out of the vector. ", "Text",
 CellID->238734272],

Cell[TextData[{
 "Press ",
 StyleBox["\[RightArrow]", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->1009034],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", GridBox[{
     {"a"},
     {"b"},
     {"c"},
     {"d"}
    }], ")"}], "\[VerticalSeparator]"}]], "Input",
 CellTags->"vectors",
 CellID->189810127],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->106667889],

Cell[TextData[ButtonBox["Entering Two-Dimensional Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EnteringTwoDimensionalExpressionsOverview"]], \
"RelatedTutorials",
 CellID->161747686]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Typing Vectors - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Entering Two-Dimensional Expressions", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/EnteringTwoDimensionalExpressionsOverview"]], "Text",
       FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TypingRadicals"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TypingMatrices"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 44, 36.5318220}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Type a left parenthesis and a right parenthesis, then move the insertion \
point to be between them. Type (), and press <-. Type the first entry of the \
vector. Create the next entry by pressing the Control key and the , key at \
the same time.", "synonyms" -> {}, "title" -> "Typing Vectors", "type" -> 
    "Tutorial", "uri" -> "tutorial/TypingVectors"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "vectors"->{
  Cell[1906, 75, 110, 3, 70, "Input",
   CellTags->"vectors",
   CellID->326751991],
  Cell[2478, 101, 173, 7, 70, "Input",
   CellTags->"vectors",
   CellID->215626485],
  Cell[3159, 131, 178, 7, 70, "Input",
   CellTags->"vectors",
   CellID->319797800],
  Cell[3858, 167, 168, 6, 70, "Input",
   CellTags->"vectors",
   CellID->267973403],
  Cell[4400, 193, 167, 6, 70, "Input",
   CellTags->"vectors",
   CellID->615121980],
  Cell[4773, 211, 165, 6, 70, "Input",
   CellTags->"vectors",
   CellID->1703617],
  Cell[5529, 251, 110, 3, 70, "Input",
   CellTags->"vectors",
   CellID->203942382],
  Cell[6110, 277, 177, 8, 70, "Input",
   CellTags->"vectors",
   CellID->3466848],
  Cell[6834, 310, 190, 9, 70, "Input",
   CellTags->"vectors",
   CellID->532442959],
  Cell[7255, 332, 200, 10, 70, "Input",
   CellTags->"vectors",
   CellID->49898838],
  Cell[7568, 351, 185, 9, 70, "Input",
   CellTags->"vectors",
   CellID->15260246],
  Cell[8127, 380, 186, 9, 70, "Input",
   CellTags->"vectors",
   CellID->4328774],
  Cell[8517, 401, 188, 9, 70, "Input",
   CellTags->"vectors",
   CellID->189810127]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"vectors", 11287, 479}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 684, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1309, 44, 50, 1, 70, "Title",
 CellID->77048861],
Cell[CellGroupData[{
Cell[1384, 49, 187, 8, 70, "Section",
 CellID->77222],
Cell[1574, 59, 145, 4, 70, "Text",
 CellID->860042623],
Cell[1722, 65, 181, 8, 70, "MathCaption",
 CellID->123675319],
Cell[1906, 75, 110, 3, 70, "Input",
 CellTags->"vectors",
 CellID->326751991],
Cell[2019, 80, 234, 8, 70, "Text",
 CellID->672993950],
Cell[2256, 90, 219, 9, 70, "MathCaption",
 CellID->89966511],
Cell[2478, 101, 173, 7, 70, "Input",
 CellTags->"vectors",
 CellID->215626485],
Cell[2654, 110, 279, 8, 70, "Text",
 CellID->106224282],
Cell[2936, 120, 220, 9, 70, "MathCaption",
 CellID->478257978],
Cell[3159, 131, 178, 7, 70, "Input",
 CellTags->"vectors",
 CellID->319797800],
Cell[3340, 140, 219, 9, 70, "MathCaption",
 CellID->22515963],
Cell[3562, 151, 183, 7, 70, "Input",
 CellID->100427797],
Cell[3748, 160, 107, 5, 70, "MathCaption",
 CellID->129719057],
Cell[3858, 167, 168, 6, 70, "Input",
 CellTags->"vectors",
 CellID->267973403],
Cell[4029, 175, 195, 7, 70, "Text",
 CellID->96686234],
Cell[4227, 184, 170, 7, 70, "MathCaption",
 CellID->174190199],
Cell[4400, 193, 167, 6, 70, "Input",
 CellTags->"vectors",
 CellID->615121980],
Cell[4570, 201, 87, 1, 70, "Text",
 CellID->478287196],
Cell[4660, 204, 110, 5, 70, "MathCaption",
 CellID->480642104],
Cell[4773, 211, 165, 6, 70, "Input",
 CellTags->"vectors",
 CellID->1703617]
}, Open  ]],
Cell[CellGroupData[{
Cell[4975, 222, 219, 11, 70, "Section",
 CellID->1664027161],
Cell[5197, 235, 145, 4, 70, "Text",
 CellID->280393048],
Cell[5345, 241, 181, 8, 70, "MathCaption",
 CellID->836933292],
Cell[5529, 251, 110, 3, 70, "Input",
 CellTags->"vectors",
 CellID->203942382],
Cell[5642, 256, 238, 8, 70, "Text",
 CellID->8771663],
Cell[5883, 266, 224, 9, 70, "MathCaption",
 CellID->86796939],
Cell[6110, 277, 177, 8, 70, "Input",
 CellTags->"vectors",
 CellID->3466848],
Cell[6290, 287, 283, 8, 70, "Text",
 CellID->13351727],
Cell[6576, 297, 255, 11, 70, "MathCaption",
 CellID->64873096],
Cell[6834, 310, 190, 9, 70, "Input",
 CellTags->"vectors",
 CellID->532442959],
Cell[7027, 321, 225, 9, 70, "MathCaption",
 CellID->547708683],
Cell[7255, 332, 200, 10, 70, "Input",
 CellTags->"vectors",
 CellID->49898838],
Cell[7458, 344, 107, 5, 70, "MathCaption",
 CellID->167679073],
Cell[7568, 351, 185, 9, 70, "Input",
 CellTags->"vectors",
 CellID->15260246],
Cell[7756, 362, 195, 7, 70, "Text",
 CellID->39987355],
Cell[7954, 371, 170, 7, 70, "MathCaption",
 CellID->183668510],
Cell[8127, 380, 186, 9, 70, "Input",
 CellTags->"vectors",
 CellID->4328774],
Cell[8316, 391, 87, 1, 70, "Text",
 CellID->238734272],
Cell[8406, 394, 108, 5, 70, "MathCaption",
 CellID->1009034],
Cell[8517, 401, 188, 9, 70, "Input",
 CellTags->"vectors",
 CellID->189810127],
Cell[CellGroupData[{
Cell[8730, 414, 72, 1, 70, "RelatedTutorialsSection",
 CellID->106667889],
Cell[8805, 417, 204, 5, 70, "RelatedTutorials",
 CellID->161747686]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[9048, 427, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

