(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21841,        559]
NotebookOptionsPosition[     16182,        391]
NotebookOutlinePosition[     20076,        495]
CellTagsIndexPosition[     19960,        488]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Unconstrained Optimization" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/UnconstrainedOptimizationOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Unconstrained Optimization\"\>"}, "\<\"related tutorials\"\>", 
       
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Optimization" :> 
          Documentation`HelpLookup["paclet:guide/Optimization"], 
          "Matrix-Based Minimization" :> 
          Documentation`HelpLookup["paclet:guide/MatrixBasedMinimization"], 
          "Curve Fitting & Approximate Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/CurveFittingAndApproximateFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Optimization\"\>", 
       2->"\<\"Matrix-Based Minimization\"\>", 
       3->"\<\"Curve Fitting & Approximate Functions\"\>"}, "\<\"more about\"\
\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Brent\[CloseCurlyQuote]s Method", "Title",
 CellTags->{"t:13", "c:13", "b:0.3.3"},
 CellID->1562437747],

Cell[TextData[{
 "When searching for a real simple root of a real valued function, it is \
possible to take advantage of the special geometry of the problem, where the \
function crosses the axis from negative to positive or vice versa. Brent\
\[CloseCurlyQuote]s method [",
 ButtonBox["Br02",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/UnconstrainedOptimizationReferences#637113374"],
 "] is effectively a safeguarded secant method that always keeps a point \
where the function is positive and one where it is negative so that the root \
is always bracketed. At any given step, a choice is made between an \
interpolated (secant) step and a bisection in such a way that eventual \
convergence is guaranteed. "
}], "Text",
 CellTags->"b:0.3.3",
 CellID->461178313],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " is given two real starting conditions that bracket a root of a real \
function, then Brent\[CloseCurlyQuote]s method will be used. Thus, if you are \
working in one dimension and can determine initial conditions that will \
bracket a root, it is often a good idea to do so since \
Brent\[CloseCurlyQuote]s method is the most robust algorithm available for ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.3.3",
 CellID->755424568],

Cell["\<\
Even though essentially all the theory for solving nonlinear equations and \
local minimization is based on smooth functions, Brent\[CloseCurlyQuote]s \
method is sufficiently robust that you can even get a good estimate for a \
zero crossing for discontinuous functions.\
\>", "Text",
 CellTags->"b:0.3.3",
 CellID->497393312],

Cell[TextData[StyleBox["This loads a package that contains some utility \
functions.",
 FontSize->11,
 FontWeight->"Plain"]], "MathCaption",
 CellID->18098],

Cell[BoxData[
 RowBox[{"<<", "Optimization`UnconstrainedProblems`"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23546],

Cell["\<\
This shows the steps and function evaluations used in an attempt to find the \
root of a discontinuous function.\
\>", "MathCaption",
 CellTags->"b:0.3.3",
 CellID->1683040660],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRootPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", 
     RowBox[{"UnitStep", "[", 
      RowBox[{"Sin", "[", "x", "]"}], "]"}]}], "-", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "3", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellTags->"b:0.3.3",
 CellLabel->"In[27]:=",
 CellID->209774336],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindRoot", "::", "\<\"cvmit\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Failed to converge to the requested \
accuracy or precision within \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\(100\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" iterations.\\\\\\\"\
\\\", \\\"MSG\\\"]\\) \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:Symbols/System/FindRoot\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellTags->"b:0.3.3",
 CellLabel->"During evaluation of In[27]:=",
 CellID->1529738672],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{493, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.3.3",
 CellLabel->"Out[27]=",
 CellID->276799177]
}, Open  ]],

Cell["\<\
The method gives up and issues a message when the root is bracketed very \
closely, but it is not able to find a value of the function, which is zero. \
This robustness carries over very well to continuous functions that are very \
steep.\
\>", "Text",
 CellTags->"b:0.3.3",
 CellID->1890975266],

Cell["\<\
This shows the steps and function evaluations used to find the root of a \
function that varies rapidly near its root.\
\>", "MathCaption",
 CellTags->"b:0.3.3",
 CellID->1010803709],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRootPlot", "[", 
  RowBox[{
   RowBox[{"ArcTan", "[", 
    RowBox[{"10000", " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], " ", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "3", ",", "4"}], "}"}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellTags->"b:0.3.3",
 CellLabel->"In[26]:=",
 CellID->1982289393],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{479, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.3.3",
 CellLabel->"Out[26]=",
 CellID->151095949]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "TutorialMoreAboutSection",
 CellID->607005354],

Cell[TextData[ButtonBox["Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Optimization"]], "TutorialMoreAbout",
 CellID->48539711],

Cell[TextData[ButtonBox["Matrix-Based Minimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixBasedMinimization"]], "TutorialMoreAbout",
 CellID->21321],

Cell[TextData[ButtonBox["Curve Fitting & Approximate Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/CurveFittingAndApproximateFunctions"]], "TutorialMoreAbout",
 CellID->776025961]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->218931966],

Cell[TextData[ButtonBox["Unconstrained Optimization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/UnconstrainedOptimizationOverview"]], "RelatedTutorials",
 CellID->20683583]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Brent's Method - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 44, 36.8130792}", "context" -> 
    "Optimization`UnconstrainedProblems`", "keywords" -> {}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "When searching for a real simple root of a real valued function, it is \
possible to take advantage of the special geometry of the problem, where the \
function crosses the axis from negative to positive or vice versa. Brent's \
method [Br02] is effectively a safeguarded secant method that always keeps a \
point where the function is positive and one where it is negative so that the \
root is always bracketed. At any given step, a choice is made between an \
interpolated (secant) step and a bisection in such a way that eventual \
convergence is guaranteed. If FindRoot is given two real starting conditions \
that bracket a root of a real function, then Brent's method will be used. \
Thus, if you are working in one dimension and can determine initial \
conditions that will bracket a root, it is often a good idea to do so since \
Brent's method is the most robust algorithm available for FindRoot. Even \
though essentially all the theory for solving nonlinear equations and local \
minimization is based on smooth functions, Brent's method is sufficiently \
robust that you can even get a good estimate for a zero crossing for \
discontinuous functions.", "synonyms" -> {}, "title" -> "Brent's Method", 
    "type" -> "Tutorial", "uri" -> 
    "tutorial/UnconstrainedOptimizationBrentsMethod"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "t:13"->{
  Cell[2234, 67, 109, 2, 70, "Title",
   CellTags->{"t:13", "c:13", "b:0.3.3"},
   CellID->1562437747]},
 "c:13"->{
  Cell[2234, 67, 109, 2, 70, "Title",
   CellTags->{"t:13", "c:13", "b:0.3.3"},
   CellID->1562437747]},
 "b:0.3.3"->{
  Cell[2234, 67, 109, 2, 70, "Title",
   CellTags->{"t:13", "c:13", "b:0.3.3"},
   CellID->1562437747],
  Cell[2346, 71, 778, 16, 70, "Text",
   CellTags->"b:0.3.3",
   CellID->461178313],
  Cell[3127, 89, 682, 18, 70, "Text",
   CellTags->"b:0.3.3",
   CellID->755424568],
  Cell[3812, 109, 337, 7, 70, "Text",
   CellTags->"b:0.3.3",
   CellID->497393312],
  Cell[4432, 129, 186, 5, 70, "MathCaption",
   CellTags->"b:0.3.3",
   CellID->1683040660],
  Cell[4643, 138, 334, 11, 70, "Input",
   CellTags->"b:0.3.3",
   CellID->209774336],
  Cell[4980, 151, 569, 12, 19, "Message",
   CellTags->"b:0.3.3",
   CellID->1529738672],
  Cell[5552, 165, 4440, 77, 126, "Output",
   Evaluatable->False,
   CellTags->"b:0.3.3",
   CellID->276799177],
  Cell[10007, 245, 305, 7, 70, "Text",
   CellTags->"b:0.3.3",
   CellID->1890975266],
  Cell[10315, 254, 192, 5, 70, "MathCaption",
   CellTags->"b:0.3.3",
   CellID->1010803709],
  Cell[10532, 263, 370, 11, 28, "Input",
   CellTags->"b:0.3.3",
   CellID->1982289393],
  Cell[10905, 276, 4314, 75, 122, "Output",
   Evaluatable->False,
   CellTags->"b:0.3.3",
   CellID->151095949]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"t:13", 18575, 438},
 {"c:13", 18691, 442},
 {"b:0.3.3", 18810, 446}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1609, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2234, 67, 109, 2, 70, "Title",
 CellTags->{"t:13", "c:13", "b:0.3.3"},
 CellID->1562437747],
Cell[2346, 71, 778, 16, 70, "Text",
 CellTags->"b:0.3.3",
 CellID->461178313],
Cell[3127, 89, 682, 18, 70, "Text",
 CellTags->"b:0.3.3",
 CellID->755424568],
Cell[3812, 109, 337, 7, 70, "Text",
 CellTags->"b:0.3.3",
 CellID->497393312],
Cell[4152, 118, 156, 4, 70, "MathCaption",
 CellID->18098],
Cell[4311, 124, 118, 3, 70, "Input",
 CellID->23546],
Cell[4432, 129, 186, 5, 70, "MathCaption",
 CellTags->"b:0.3.3",
 CellID->1683040660],
Cell[CellGroupData[{
Cell[4643, 138, 334, 11, 70, "Input",
 CellTags->"b:0.3.3",
 CellID->209774336],
Cell[4980, 151, 569, 12, 19, "Message",
 CellTags->"b:0.3.3",
 CellID->1529738672],
Cell[5552, 165, 4440, 77, 126, "Output",
 Evaluatable->False,
 CellTags->"b:0.3.3",
 CellID->276799177]
}, Open  ]],
Cell[10007, 245, 305, 7, 70, "Text",
 CellTags->"b:0.3.3",
 CellID->1890975266],
Cell[10315, 254, 192, 5, 70, "MathCaption",
 CellTags->"b:0.3.3",
 CellID->1010803709],
Cell[CellGroupData[{
Cell[10532, 263, 370, 11, 28, "Input",
 CellTags->"b:0.3.3",
 CellID->1982289393],
Cell[10905, 276, 4314, 75, 122, "Output",
 Evaluatable->False,
 CellTags->"b:0.3.3",
 CellID->151095949]
}, Open  ]],
Cell[CellGroupData[{
Cell[15256, 356, 66, 1, 70, "TutorialMoreAboutSection",
 CellID->607005354],
Cell[15325, 359, 143, 3, 70, "TutorialMoreAbout",
 CellID->48539711],
Cell[15471, 364, 164, 3, 70, "TutorialMoreAbout",
 CellID->21321],
Cell[15638, 369, 195, 4, 70, "TutorialMoreAbout",
 CellID->776025961]
}, Open  ]],
Cell[CellGroupData[{
Cell[15870, 378, 72, 1, 70, "RelatedTutorialsSection",
 CellID->218931966],
Cell[15945, 381, 183, 4, 70, "RelatedTutorials",
 CellID->20683583]
}, Open  ]]
}, Open  ]],
Cell[16155, 389, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

