(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10933,        349]
NotebookOptionsPosition[      7321,        240]
NotebookOutlinePosition[      9831,        311]
CellTagsIndexPosition[      9707,        304]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Unconstrained Optimization" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/UnconstrainedOptimizationOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Unconstrained Optimization\"\>"}, "\<\"related tutorials\"\>", 
       
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Optimization" :> 
          Documentation`HelpLookup["paclet:guide/Optimization"], 
          "Matrix-Based Minimization" :> 
          Documentation`HelpLookup["paclet:guide/MatrixBasedMinimization"], 
          "Curve Fitting & Approximate Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/CurveFittingAndApproximateFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Optimization\"\>", 
       2->"\<\"Matrix-Based Minimization\"\>", 
       3->"\<\"Curve Fitting & Approximate Functions\"\>"}, "\<\"more about\"\
\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Introduction to Local Minimization", "Title",
 CellID->509267359],

Cell["The essence of most methods is in the local quadratic model ", "Text",
 ShowCellBracket->True,
 CellTags->"b:0.2.0",
 CellID->1219547462],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["q", "k"], "(", "p", ")"}], "=", 
   RowBox[{
    RowBox[{"f", "(", 
     SubscriptBox["x", "k"], ")"}], " ", "+", " ", 
    RowBox[{
     RowBox[{"\[Del]", 
      SuperscriptBox[
       RowBox[{"f", "(", 
        SubscriptBox["x", "k"], ")"}], "T"]}], " ", "p"}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     SuperscriptBox["p", "T"], 
     SubscriptBox["B", "k"], " ", "p"}]}]}], TraditionalForm]], "DisplayMath",\

 ShowCellBracket->True,
 CellTags->{"QuadraticModel", "b:0.1"},
 CellID->617710400],

Cell[TextData[{
 "that is used to determine the next step. The ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 " function in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has five essentially different ways of choosing this model, controlled by \
the method option. These methods are similarly used by ",
 Cell[BoxData[
  ButtonBox["FindMaximum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMaximum"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FindFit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindFit"]], "InlineFormula"],
 "."
}], "Text",
 ShowCellBracket->True,
 CellTags->"b:0.2.0",
 CellID->702628418],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["\"Newton\"", "MR"]]], Cell["\<\
us the exact Hessian or a finite difference approximation if the symbolic \
derivative cannot be computed\
\>", "Text"]},
    {Cell[TextData[StyleBox["\"QuasiNewton\"", "MR"]]], Cell["\<\
use the quasi-Newton BFGS approximation to the Hessian built up by updates \
based on past steps\
\>", "Text"]},
    {Cell[TextData[StyleBox["\"LevenbergMarquardt\"", "MR"]]], Cell[
     TextData[{
      "a Gauss-Newton method for least-squares problems; the Hessian is \
approximated by ",
      Cell[BoxData[
       FormBox[
        RowBox[{
         RowBox[{
          SuperscriptBox["J", "T"], "J"}], ","}], TraditionalForm]]],
      " where ",
      Cell[BoxData[
       FormBox["J", TraditionalForm]]],
      " is the Jacobian of the residual function"
     }], "Text"]},
    {Cell[TextData[StyleBox["\"ConjugateGradient\"", "MR"]]], Cell["\<\
a nonlinear version of the conjugate gradient method for solving linear \
systems; a model Hessian is never formed explicitly.\
\>", "Text"]},
    {Cell[TextData[StyleBox["\"PrincipalAxis\"", "MR"]]], Cell["\<\
works without using any derivatives, not even the gradient, by keeping values \
from past steps; it requires two starting conditions in each variable\
\>"]}
   }], TextForm]], "DefinitionBox",
 ShowCellBracket->True,
 CellTags->"b:0.2.0",
 CellID->1350266866],

Cell[TextData[{
 "Basic method choices for ",
 StyleBox["FindMinimum", "MR"],
 "."
}], "Caption",
 ShowCellBracket->True,
 CellTags->"b:0.2.0",
 CellID->1475519013],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Method",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Method"], "\[Rule]", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses the ",
 ButtonBox["quasi-Newton",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/UnconstrainedOptimizationQuasiNewtonMethods"],
 " method unless the problem is structurally a sum of squares, in which case \
the Levenberg\[Dash]Marquardt variant of the ",
 ButtonBox["Gauss\[Dash]Newton",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/UnconstrainedOptimizationGaussNewtonMethods"],
 " method is used. When given two starting conditions in each variable, the \
\"",
 ButtonBox["principal axis",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/UnconstrainedOptimizationPrincipalAxisMethod"],
 "\" method is used."
}], "Text",
 ShowCellBracket->True,
 CellTags->"b:0.2.0",
 CellID->2054379582],

Cell[CellGroupData[{

Cell["MORE ABOUT", "TutorialMoreAboutSection",
 CellID->152355522],

Cell[TextData[ButtonBox["Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Optimization"]], "TutorialMoreAbout",
 CellID->48539711],

Cell[TextData[ButtonBox["Matrix-Based Minimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixBasedMinimization"]], "TutorialMoreAbout",
 CellID->21321],

Cell[TextData[ButtonBox["Curve Fitting & Approximate Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/CurveFittingAndApproximateFunctions"]], "TutorialMoreAbout",
 CellID->776025961]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->810746312],

Cell[TextData[ButtonBox["Unconstrained Optimization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/UnconstrainedOptimizationOverview"]], "RelatedTutorials",
 CellID->20683583]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Introduction to Local Minimization - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 44, 41.1569404}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "The essence of most methods is in the local quadratic model that is used \
to determine the next step. The FindMinimum function in Mathematica has five \
essentially different ways of choosing this model, controlled by the method \
option. These methods are similarly used by FindMaximum and FindFit. us the \
exact Hessian or a finite difference approximation if the symbolic derivative \
cannot be computed", "synonyms" -> {}, "title" -> 
    "Introduction to Local Minimization", "type" -> "Tutorial", "uri" -> 
    "tutorial/UnconstrainedOptimizationIntroductionLocalMinimization"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "b:0.2.0"->{
  Cell[2308, 70, 143, 3, 70, "Text",
   CellTags->"b:0.2.0",
   CellID->1219547462],
  Cell[3035, 97, 729, 24, 70, "Text",
   CellTags->"b:0.2.0",
   CellID->702628418],
  Cell[3767, 123, 1402, 35, 70, "DefinitionBox",
   CellTags->"b:0.2.0",
   CellID->1350266866],
  Cell[5172, 160, 164, 7, 70, "Caption",
   CellTags->"b:0.2.0",
   CellID->1475519013],
  Cell[5339, 169, 1031, 32, 70, "Text",
   CellTags->"b:0.2.0",
   CellID->2054379582]},
 "QuadraticModel"->{
  Cell[2454, 75, 578, 20, 70, "DisplayMath",
   CellTags->{"QuadraticModel", "b:0.1"},
   CellID->617710400]},
 "b:0.1"->{
  Cell[2454, 75, 578, 20, 70, "DisplayMath",
   CellTags->{"QuadraticModel", "b:0.1"},
   CellID->617710400]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"b:0.2.0", 8984, 277},
 {"QuadraticModel", 9450, 293},
 {"b:0.1", 9573, 297}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1609, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2234, 67, 71, 1, 70, "Title",
 CellID->509267359],
Cell[2308, 70, 143, 3, 70, "Text",
 CellTags->"b:0.2.0",
 CellID->1219547462],
Cell[2454, 75, 578, 20, 70, "DisplayMath",
 CellTags->{"QuadraticModel", "b:0.1"},
 CellID->617710400],
Cell[3035, 97, 729, 24, 70, "Text",
 CellTags->"b:0.2.0",
 CellID->702628418],
Cell[3767, 123, 1402, 35, 70, "DefinitionBox",
 CellTags->"b:0.2.0",
 CellID->1350266866],
Cell[5172, 160, 164, 7, 70, "Caption",
 CellTags->"b:0.2.0",
 CellID->1475519013],
Cell[5339, 169, 1031, 32, 70, "Text",
 CellTags->"b:0.2.0",
 CellID->2054379582],
Cell[CellGroupData[{
Cell[6395, 205, 66, 1, 70, "TutorialMoreAboutSection",
 CellID->152355522],
Cell[6464, 208, 143, 3, 70, "TutorialMoreAbout",
 CellID->48539711],
Cell[6610, 213, 164, 3, 70, "TutorialMoreAbout",
 CellID->21321],
Cell[6777, 218, 195, 4, 70, "TutorialMoreAbout",
 CellID->776025961]
}, Open  ]],
Cell[CellGroupData[{
Cell[7009, 227, 72, 1, 70, "RelatedTutorialsSection",
 CellID->810746312],
Cell[7084, 230, 183, 4, 70, "RelatedTutorials",
 CellID->20683583]
}, Open  ]]
}, Open  ]],
Cell[7294, 238, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

