(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19827,        531]
NotebookOptionsPosition[     15203,        388]
NotebookOutlinePosition[     18185,        471]
CellTagsIndexPosition[     18115,        466]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Unconstrained Optimization" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/UnconstrainedOptimizationOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Unconstrained Optimization\"\>"}, "\<\"related tutorials\"\>", 
       
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Optimization" :> 
          Documentation`HelpLookup["paclet:guide/Optimization"], 
          "Matrix-Based Minimization" :> 
          Documentation`HelpLookup["paclet:guide/MatrixBasedMinimization"], 
          "Curve Fitting & Approximate Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/CurveFittingAndApproximateFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Optimization\"\>", 
       2->"\<\"Matrix-Based Minimization\"\>", 
       3->"\<\"Curve Fitting & Approximate Functions\"\>"}, "\<\"more about\"\
\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Introduction to Step Control", "Title",
 CellTags->"b:0.4.0",
 CellID->1034146184],

Cell[TextData[{
 "Even with ",
 ButtonBox["Newton methods",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/UnconstrainedOptimizationNewtonsMethodRoot"],
 " where the local model is based on the actual Hessian, unless you are close \
to a root or minimum, the model step may not bring you any closer to the \
solution. A simple example is given by the following problem."
}], "Text",
 CellTags->"b:0.4.0",
 CellID->1309759317],

Cell[TextData[StyleBox["This loads a package that contains some utility \
functions.",
 FontSize->11,
 FontWeight->"Plain"]], "MathCaption",
 CellID->18098],

Cell[BoxData[
 RowBox[{"<<", "Optimization`UnconstrainedProblems`"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23546],

Cell["\<\
This shows a simple example for root finding with step control disabled where \
the iteration alternates between two points and does not converge. Note: on \
some platforms, you may see convergence. This is due to slight variations in \
machine-number arithmetic which may be sufficient to break the oscillation.\
\>", "MathCaption",
 CellTags->"b:0.4.0",
 CellID->1417459069],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRootPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1.1655611852072114"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Newton", ",", "  ", 
      RowBox[{"StepControl", "\[Rule]", "None"}]}], "}"}]}]}], "]"}]], "Input",\

 CellTags->"b:0.4.0",
 CellLabel->"In[43]:=",
 CellID->1198476512],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindRoot", "::", "\<\"cvmit\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Failed to converge to the requested \
accuracy or precision within \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\(100\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" iterations.\\\\\\\"\
\\\", \\\"MSG\\\"]\\) \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:Symbols/System/FindRoot\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellTags->"b:0.4.0",
 CellLabel->"During evaluation of In[43]:=",
 CellID->667169126],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{406, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.0",
 CellLabel->"Out[43]=",
 CellID->299609884]
}, Open  ]],

Cell["\<\
This shows the same example problem with step control enabled. Since the \
first evaluation point has not reduced the size of the function, the line \
search restricts the step and so the iteration converges to the solution.\
\>", "MathCaption",
 CellTags->"b:0.4.0",
 CellID->721458626],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRootPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1.1655611852072114"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", "\"\<Newton\>\""}]}], "]"}]], "Input",
 CellTags->"b:0.4.0",
 CellLabel->"In[44]:=",
 CellID->862456220],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\<\"Steps\"\>", "\[Rule]", "2"}], ",", 
     RowBox[{"\<\"Residual\"\>", "\[Rule]", "3"}], ",", 
     RowBox[{"\<\"Jacobian\"\>", "\[Rule]", "2"}]}], "}"}], ",", 
   GraphicsBox[{{}, {}, {
      {Hue[0.67, 0.6, 0.6]}, LineBox[CompressedData["
1:eJwt0/dTkwccx3GgYEBmEQGFqmilpQNZEpHil5FS9LRQPaxSjqUNSzYtOK4o
GsbJbJllRsBTKRBAEcL4smLhoBhWSiorjADxeYQ8CAKWtumdP3zufa8/4GPk
F3b2ewU5OTmQ7f8Sm1fDDt2nsNjYRSUxgERDw/qOo2UUhq8PRtCZJJ45Qexy
KaVQoGE3Kb5EYnW8V+OVXymcStrR5ehNYriqk3xDGoW2iVltr9xJXDVU+8Ul
hsLS+I/S9ZxI3ILihhAXCi3XbD6sMiRRJaFz+6lEilVmuo+IfgIvN2c/S9ov
xdS4bmJAm0Czf21YfN8VjLHhc9XdX6LqTtY623UZzc4R/MgUCVoGVH5r0ELi
1Cu/JwplS2g7G1Ue70Rg9FNh0zPuIrZzvmH6VUqw03nnogJnAT0UNnLq9y4h
f6R9NaZAjKPh9vVU+QLSj3f8rZg6j/3mxYxHmmJUNhZd6PeYw3LN4g7X7DlM
p7MjmeazmBnBrGIenEUhTdm26r0ZfHuYobGeLsIUdf4n92qn0flNl0eU/jS6
m+dX9wonca913bEhhQl8nKzrr0MbxyFWSH7prBCHmGVWF82EeFozZPDUlgBf
8NSKmm8IEO1yV+cHh/Fq17zakVvD+LpCifSc4uOixxdZN6v4yGDasZO/60Mp
Z/PmeeM+XM3IPLRfl4dWibi7dbsbT3uNPxiLbUNGaI91OLMN80zt6617a7Ez
5ccjqbxafJg7HKTVnYvcgMN5d7py8Qflk/tSqnNAZMnJ1JYVBKa3Ehh18Ibl
055mXwcet7lFW0pt4DCwbOH9uhW+GvgjadSXBwYbP/sGuvAg7VQhbfFeHzyJ
jF7VutIHD02kwUYtfMg6f8P02l0+aCcvLU3MD4Ny44jIImsYmqqLMtqEAhAG
eXLBSwD0/vaLLW1CSPjLQT5YQwjNjKZjvTPjIL5eYsSQvICfbofYb/GnwEKn
8v1C1iSUp701/SBOBDX0JB/7sml4cGLf2edbMzC3Nl4jnhFBblDsDq2wOdi+
XNDdqj0LKozWL8cUxNCsNOEodpuDAjmf/LrrC9DbbCCKDp0HThAZo6OzBFsx
2bzfc8TAcatbUKyQAE1jQ8itXIDne0aDaQYE7N7up+TZixCZMXMtk0PCwaMm
jnsKl8BKcqb480+Xgfu1ShgtVgIr3rEmn7muQDy7JzDX4SUkGcFJlr4Uwnz0
W7XUCKgZsYryH5HC9GbjmmcTAXmTJX7qpRTosv8JbbxEgiOhFqhfRoGbmyPj
AJMEvSgnoqicghKPgZ5z/iTEN0xW+VRQIHqcGkHKTL/wm0anzN4Zd+F4AAna
JruQknlMkSr3kTku01lP9T4FHx+AP6NkfvdvePdv+A+2EiV/
       "]]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
    Axes->True,
    Epilog->{{
       RGBColor[0, 0, 0], 
       PointSize[0.055], 
       PointBox[{0., 0.}]}, {
       RGBColor[0.5, 0, 0.5], 
       PointSize[0.04], {
        PointBox[{1.16556118520721, 0.919009721560432}], 
        PointBox[{0., 0.}]}}, {
       RGBColor[1, 1, 0], 
       PointSize[0.025], {
        PointBox[{1.16556118520721, 0.919009721560432}], 
        PointBox[{-1.16556118520721, -0.919009721560432}], 
        PointBox[{0., 0.}]}}, {
       RGBColor[0, 0, 1], 
       PointSize[0.015], 
       LineBox[{{1.16556118520721, 0.919009721560432}, {0., 0.}}], {
        PointBox[{1.16556118520721, 0.919009721560432}], 
        PointBox[{0., 0.}]}}},
    Method->{},
    PlotRange->{{-1.16556118520721, 1.16556118520721}, {-0.91900970280513, 
     0.91900970280513}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{524, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.0",
 CellLabel->"Out[44]=",
 CellID->325235077]
}, Open  ]],

Cell[TextData[{
 "A good step-size control algorithm will prevent repetition or escape from \
areas near roots or minima from happening. At the same time, however, when \
steps based on the model function are appropriate, the step-size control \
algorithm should not restrict them, otherwise the convergence rate of the \
algorithm would be compromised. Two commonly used step-size control \
algorithms are \"",
 ButtonBox["line search",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/UnconstrainedOptimizationLineSearchMethods"],
 "\" and \"",
 ButtonBox["trust region",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/UnconstrainedOptimizationTrustRegionMethods"],
 "\" methods. In a line search method, the model function gives a step \
direction, and a search is done along that direction to find an adequate \
point that will lead to convergence. In a trust region method, a distance in \
which the model function will be trusted is updated at each step. If the \
model step lies within that distance, it is used, otherwise; an approximate \
minimum for the model function on the boundary of the trust region is used. \
Generally the trust region methods are more robust, but they require more \
numerical linear algebra."
}], "Text",
 CellTags->"b:0.4.0",
 CellID->2130755737],

Cell[TextData[{
 "Both step control methods were developed originally with minimization in \
mind. However, they apply well to finding roots for nonlinear equations when \
used with a merit function",
 ". ",
 "In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", the 2-norm merit function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"r", "(", "x", ")"}], ".", 
    RowBox[{"r", "(", "x", ")"}]}], TraditionalForm]], "InlineMath"],
 " is used."
}], "Text",
 CellTags->"b:0.4.0",
 CellID->174374387],

Cell[CellGroupData[{

Cell["MORE ABOUT", "TutorialMoreAboutSection",
 CellID->491678873],

Cell[TextData[ButtonBox["Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Optimization"]], "TutorialMoreAbout",
 CellID->48539711],

Cell[TextData[ButtonBox["Matrix-Based Minimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixBasedMinimization"]], "TutorialMoreAbout",
 CellID->21321],

Cell[TextData[ButtonBox["Curve Fitting & Approximate Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/CurveFittingAndApproximateFunctions"]], "TutorialMoreAbout",
 CellID->776025961]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->602677740],

Cell[TextData[ButtonBox["Unconstrained Optimization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/UnconstrainedOptimizationOverview"]], "RelatedTutorials",
 CellID->20683583]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Introduction to Step Control - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 44, 45.1726682}", "context" -> 
    "Optimization`UnconstrainedProblems`", "keywords" -> {}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Even with Newton methods where the local model is based on the actual \
Hessian, unless you are close to a root or minimum, the model step may not \
bring you any closer to the solution. A simple example is given by the \
following problem. This loads a package that contains some utility functions. \
This shows a simple example for root finding with step control disabled where \
the iteration alternates between two points and does not converge. Note: on \
some platforms, you may see convergence. This is due to slight variations in \
machine-number arithmetic which may be sufficient to break the oscillation.", 
    "synonyms" -> {}, "title" -> "Introduction to Step Control", "type" -> 
    "Tutorial", "uri" -> 
    "tutorial/UnconstrainedOptimizationIntroductionStepControl"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "b:0.4.0"->{
  Cell[2234, 67, 88, 2, 70, "Title",
   CellTags->"b:0.4.0",
   CellID->1034146184],
  Cell[2325, 71, 430, 10, 70, "Text",
   CellTags->"b:0.4.0",
   CellID->1309759317],
  Cell[3038, 94, 386, 7, 70, "MathCaption",
   CellTags->"b:0.4.0",
   CellID->1417459069],
  Cell[3449, 105, 412, 13, 70, "Input",
   CellTags->"b:0.4.0",
   CellID->1198476512],
  Cell[3864, 120, 568, 12, 19, "Message",
   CellTags->"b:0.4.0",
   CellID->667169126],
  Cell[4435, 134, 4416, 77, 161, "Output",
   Evaluatable->False,
   CellTags->"b:0.4.0",
   CellID->299609884],
  Cell[8866, 214, 297, 6, 70, "MathCaption",
   CellTags->"b:0.4.0",
   CellID->721458626],
  Cell[9188, 224, 314, 9, 70, "Input",
   CellTags->"b:0.4.0",
   CellID->862456220],
  Cell[9505, 235, 2926, 68, 135, "Output",
   CellTags->"b:0.4.0",
   CellID->325235077],
  Cell[12446, 306, 1291, 24, 70, "Text",
   CellTags->"b:0.4.0",
   CellID->2130755737],
  Cell[13740, 332, 512, 17, 70, "Text",
   CellTags->"b:0.4.0",
   CellID->174374387]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"b:0.4.0", 17094, 428}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1609, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2234, 67, 88, 2, 70, "Title",
 CellTags->"b:0.4.0",
 CellID->1034146184],
Cell[2325, 71, 430, 10, 70, "Text",
 CellTags->"b:0.4.0",
 CellID->1309759317],
Cell[2758, 83, 156, 4, 70, "MathCaption",
 CellID->18098],
Cell[2917, 89, 118, 3, 70, "Input",
 CellID->23546],
Cell[3038, 94, 386, 7, 70, "MathCaption",
 CellTags->"b:0.4.0",
 CellID->1417459069],
Cell[CellGroupData[{
Cell[3449, 105, 412, 13, 70, "Input",
 CellTags->"b:0.4.0",
 CellID->1198476512],
Cell[3864, 120, 568, 12, 19, "Message",
 CellTags->"b:0.4.0",
 CellID->667169126],
Cell[4435, 134, 4416, 77, 161, "Output",
 Evaluatable->False,
 CellTags->"b:0.4.0",
 CellID->299609884]
}, Open  ]],
Cell[8866, 214, 297, 6, 70, "MathCaption",
 CellTags->"b:0.4.0",
 CellID->721458626],
Cell[CellGroupData[{
Cell[9188, 224, 314, 9, 70, "Input",
 CellTags->"b:0.4.0",
 CellID->862456220],
Cell[9505, 235, 2926, 68, 135, "Output",
 CellTags->"b:0.4.0",
 CellID->325235077]
}, Open  ]],
Cell[12446, 306, 1291, 24, 70, "Text",
 CellTags->"b:0.4.0",
 CellID->2130755737],
Cell[13740, 332, 512, 17, 70, "Text",
 CellTags->"b:0.4.0",
 CellID->174374387],
Cell[CellGroupData[{
Cell[14277, 353, 66, 1, 70, "TutorialMoreAboutSection",
 CellID->491678873],
Cell[14346, 356, 143, 3, 70, "TutorialMoreAbout",
 CellID->48539711],
Cell[14492, 361, 164, 3, 70, "TutorialMoreAbout",
 CellID->21321],
Cell[14659, 366, 195, 4, 70, "TutorialMoreAbout",
 CellID->776025961]
}, Open  ]],
Cell[CellGroupData[{
Cell[14891, 375, 72, 1, 70, "RelatedTutorialsSection",
 CellID->602677740],
Cell[14966, 378, 183, 4, 70, "RelatedTutorials",
 CellID->20683583]
}, Open  ]]
}, Open  ]],
Cell[15176, 386, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

