(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10021,        343]
NotebookOptionsPosition[      6620,        240]
NotebookOutlinePosition[      7973,        278]
CellTagsIndexPosition[      7930,        275]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA OVERVIEW", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Unconstrained Optimization", "TOCDocumentTitle"],

Cell[TextData[ButtonBox["Introduction",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/UnconstrainedOptimizationIntroduction#509267359"]], \
"TOCChapter",
 CellID->1368660155],

Cell[CellGroupData[{

Cell["Methods for Local Minimization", "TOCChapter",
 "Filename" -> "UnconstrainedOptimizationNewtonsMethodMinimum",
 CellID->1373882068],

Cell[TextData[ButtonBox["Introduction",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/UnconstrainedOptimizationIntroductionLocalMinimization#\
509267359"]], "TOCSubsection",
 CellID->328978420],

Cell[TextData[ButtonBox["Newton's Method",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/UnconstrainedOptimizationNewtonsMethodMinimum#509267359"]],\
 "TOCSubsection",
 CellID->1091744332],

Cell[TextData[ButtonBox["Quasi-Newton Methods",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/UnconstrainedOptimizationQuasiNewtonMethods#509267359"]], \
"TOCSubsection",
 CellID->1546261443],

Cell[TextData[ButtonBox["Gauss-Newton Methods",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/UnconstrainedOptimizationGaussNewtonMethods#509267359"]], \
"TOCSubsection",
 CellID->1579391167],

Cell[TextData[ButtonBox["Nonlinear Conjugate Gradient Methods",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/UnconstrainedOptimizationConjugateGradientMethods#\
509267359"]], "TOCSubsection",
 CellID->221793237],

Cell[TextData[ButtonBox["Principal Axis Method",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/UnconstrainedOptimizationPrincipalAxisMethod#509267359"]], \
"TOCSubsection",
 CellID->879993387]
}, Open  ]],

Cell[CellGroupData[{

Cell["Methods for Solving Nonlinear Equations", "TOCChapter",
 "Filename" -> "UnconstrainedOptimizationIntroductionNonlinearEquations",
 CellID->1517397562],

Cell[TextData[ButtonBox["Introduction",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/UnconstrainedOptimizationIntroductionNonlinearEquations#\
771134545"]], "TOCSubsection",
 CellID->1532516409],

Cell[TextData[ButtonBox["Newton\[CloseCurlyQuote]s Method",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/UnconstrainedOptimizationNewtonsMethodRoot#456855863"]], \
"TOCSubsection",
 CellID->1574036595],

Cell[TextData[ButtonBox["The Secant Method",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/UnconstrainedOptimizationSecantMethod#798406094"]], \
"TOCSubsection",
 CellID->349397231],

Cell[TextData[ButtonBox["Brent\[CloseCurlyQuote]s Method",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/UnconstrainedOptimizationBrentsMethod#1562437747"]], \
"TOCSubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Step Control", "TOCChapter",
 "Filename" -> "UnconstrainedOptimizationIntroductionStepControl"],

Cell[TextData[ButtonBox["Introduction",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/UnconstrainedOptimizationIntroductionStepControl#\
1034146184"]], "TOCSubsection"],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Line Search Methods",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/UnconstrainedOptimizationLineSearchMethods#1542627801"]], \
"TOCSubsection"],

Cell[TextData[ButtonBox["MoreThuente",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/UnconstrainedOptimizationLineSearchMethods#1668234584"]], \
"TOCSubsubsection"],

Cell[TextData[ButtonBox["Backtracking",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/UnconstrainedOptimizationLineSearchMethods#1052649512"]], \
"TOCSubsubsection"],

Cell[TextData[ButtonBox["Brent",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/UnconstrainedOptimizationLineSearchMethods#1250142150"]], \
"TOCSubsubsection"]
}, Open  ]],

Cell[TextData[ButtonBox["Trust Region Methods",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/UnconstrainedOptimizationTrustRegionMethods#2058254571"]], \
"TOCSubsection",
 CellID->2038148633]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Setting up Optimization Problems in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "TOCChapter",
 "Filename" -> "UnconstrainedOptimizationSpecifyingDerivatives",
 CellID->652421534],

Cell[TextData[ButtonBox["Specifying Derivatives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/UnconstrainedOptimizationSpecifyingDerivatives#562305099"]]\
, "TOCSubsection",
 CellID->197220356],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Variables and Starting Conditions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/UnconstrainedOptimizationVariablesAndStartingConditions#\
1302289373"]], "TOCSubsection",
 CellID->869833581],

Cell[TextData[ButtonBox["Vector and Matrix Valued Variables",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/UnconstrainedOptimizationVariablesAndStartingConditions#\
1035657512"]], "TOCSubsubsection",
 CellID->1371810738]
}, Open  ]],

Cell[TextData[ButtonBox["Termination Conditions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/UnconstrainedOptimizationTerminationConditions#1953968666"]\
], "TOCSubsection",
 CellID->488691112],

Cell[TextData[ButtonBox["Symbolic Evaluation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/UnconstrainedOptimizationSymbolicEvaluation#147397427"]], \
"TOCSubsection",
 CellID->2056654379]
}, Open  ]],

Cell[CellGroupData[{

Cell["UnconstrainedProblems Package", "TOCChapter",
 "Filename" -> "UnconstrainedOptimizationPlottingSearchData"],

Cell[TextData[ButtonBox["Plotting Search Data",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/UnconstrainedOptimizationPlottingSearchData#982979262"]], \
"TOCSubsection"],

Cell[TextData[ButtonBox["Test Problems",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/UnconstrainedOptimizationTestProblems#1407764050"]], \
"TOCSubsection"]
}, Open  ]],

Cell[TextData[ButtonBox["References",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/UnconstrainedOptimizationReferences"]], "TOCChapter",
 CellID->1566298248],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Unconstrained Optimization - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 45, 0.8136936}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Overview", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Introduction Methods for Local Minimization Methods for Solving \
Nonlinear Equations", "synonyms" -> {}, "title" -> 
    "Unconstrained Optimization", "type" -> "Overview", "uri" -> 
    "tutorial/UnconstrainedOptimizationOverview"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 103, 2, 70, "AnchorBarGrid"],
Cell[704, 27, 54, 0, 70, "TOCDocumentTitle"],
Cell[761, 29, 181, 5, 70, "TOCChapter",
 CellID->1368660155],
Cell[CellGroupData[{
Cell[967, 38, 137, 2, 70, "TOCChapter",
 CellID->1373882068],
Cell[1107, 42, 200, 5, 70, "TOCSubsection",
 CellID->328978420],
Cell[1310, 49, 195, 5, 70, "TOCSubsection",
 CellID->1091744332],
Cell[1508, 56, 198, 5, 70, "TOCSubsection",
 CellID->1546261443],
Cell[1709, 63, 198, 5, 70, "TOCSubsection",
 CellID->1579391167],
Cell[1910, 70, 219, 5, 70, "TOCSubsection",
 CellID->221793237],
Cell[2132, 77, 199, 5, 70, "TOCSubsection",
 CellID->879993387]
}, Open  ]],
Cell[CellGroupData[{
Cell[2368, 87, 156, 2, 70, "TOCChapter",
 CellID->1517397562],
Cell[2527, 91, 202, 5, 70, "TOCSubsection",
 CellID->1532516409],
Cell[2732, 98, 209, 5, 70, "TOCSubsection",
 CellID->1574036595],
Cell[2944, 105, 188, 5, 70, "TOCSubsection",
 CellID->349397231],
Cell[3135, 112, 183, 4, 70, "TOCSubsection"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3355, 121, 101, 1, 70, "TOCChapter"],
Cell[3459, 124, 175, 4, 70, "TOCSubsection"],
Cell[CellGroupData[{
Cell[3659, 132, 176, 4, 70, "TOCSubsection"],
Cell[3838, 138, 171, 4, 70, "TOCSubsubsection"],
Cell[4012, 144, 172, 4, 70, "TOCSubsubsection"],
Cell[4187, 150, 165, 4, 70, "TOCSubsubsection"]
}, Open  ]],
Cell[4367, 157, 199, 5, 70, "TOCSubsection",
 CellID->2038148633]
}, Open  ]],
Cell[CellGroupData[{
Cell[4603, 167, 207, 6, 70, "TOCChapter",
 CellID->652421534],
Cell[4813, 175, 202, 5, 70, "TOCSubsection",
 CellID->197220356],
Cell[CellGroupData[{
Cell[5040, 184, 223, 5, 70, "TOCSubsection",
 CellID->869833581],
Cell[5266, 191, 228, 5, 70, "TOCSubsubsection",
 CellID->1371810738]
}, Open  ]],
Cell[5509, 199, 203, 5, 70, "TOCSubsection",
 CellID->488691112],
Cell[5715, 206, 197, 5, 70, "TOCSubsection",
 CellID->2056654379]
}, Open  ]],
Cell[CellGroupData[{
Cell[5949, 216, 113, 1, 70, "TOCChapter"],
Cell[6065, 219, 177, 4, 70, "TOCSubsection"],
Cell[6245, 225, 165, 4, 70, "TOCSubsection"]
}, Open  ]],
Cell[6425, 232, 165, 4, 70, "TOCChapter",
 CellID->1566298248],
Cell[6593, 238, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

