(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    549544,      12044]
NotebookOptionsPosition[    541598,      11786]
NotebookOutlinePosition[    546187,      11926]
CellTagsIndexPosition[    546022,      11918]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Unconstrained Optimization" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/UnconstrainedOptimizationOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Unconstrained Optimization\"\>"}, "\<\"related tutorials\"\>", 
       
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Optimization" :> 
          Documentation`HelpLookup["paclet:guide/Optimization"], 
          "Matrix-Based Minimization" :> 
          Documentation`HelpLookup["paclet:guide/MatrixBasedMinimization"], 
          "Curve Fitting & Approximate Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/CurveFittingAndApproximateFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Optimization\"\>", 
       2->"\<\"Matrix-Based Minimization\"\>", 
       3->"\<\"Curve Fitting & Approximate Functions\"\>"}, "\<\"more about\"\
\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Quasi-Newton Methods", "Title",
 CellID->509267359],

Cell[TextData[{
 "There are many variants of quasi-Newton methods. In all of them, the idea \
is to base the matrix ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["B", "k"], TraditionalForm]]],
 " in the quadratic model"
}], "Text",
 ShowCellBracket->True,
 CellTags->"b:0.2.2",
 CellID->1891212404],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["q", "k"], "(", "p", ")"}], "=", 
   RowBox[{
    RowBox[{"f", "(", 
     SubscriptBox["x", "k"], ")"}], " ", "+", " ", 
    RowBox[{
     RowBox[{"\[Del]", 
      SuperscriptBox[
       RowBox[{"f", "(", 
        SubscriptBox["x", "k"], ")"}], "T"]}], " ", "p"}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     SuperscriptBox["p", "T"], 
     SubscriptBox["B", "k"], " ", "p"}]}]}], TraditionalForm]], "DisplayMath",\

 ShowCellBracket->True,
 CellTags->{"QuadraticModel", "b:0.1"},
 CellID->617710400],

Cell["\<\
on an approximation of the Hessian matrix built up from the function and \
gradient values from some or all steps previously taken.\
\>", "Text",
 ShowCellBracket->True,
 CellTags->"b:0.2.2",
 CellID->432023036],

Cell[TextData[StyleBox["This loads a package that contains some utility \
functions",
 FontSize->11,
 FontWeight->"Plain"]], "MathCaption",
 CellID->18098],

Cell[BoxData[
 RowBox[{"<<", "Optimization`UnconstrainedProblems`"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23546],

Cell[TextData[{
 "This shows a plot of the steps taken by the quasi-Newton method. The path \
is much less direct than for Newton\[CloseCurlyQuote]s method. The \
quasi-Newton method is used by default by ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 " for problems that are not sums of squares."
}], "MathCaption",
 ShowCellBracket->True,
 CellTags->"b:0.2.2",
 CellID->701414781],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimumPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{
      RowBox[{"x", "^", "2"}], " ", "-", " ", 
      RowBox[{"3", " ", "y"}]}], "]"}], " ", "+", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"x", "^", "2"}], " ", "+", " ", 
      RowBox[{"y", "^", "2"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input",
 ShowCellBracket->True,
 CellTags->"b:0.2.2",
 CellLabel->"In[43]:=",
 CellID->1140485884],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2.`"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", "1.376384972443001`"}], ",", 
       RowBox[{"y", "\[Rule]", "1.6786760817546214`"}]}], "}"}]}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\<\"Steps\"\>", "\[Rule]", "9"}], ",", 
     RowBox[{"\<\"Function\"\>", "\[Rule]", "13"}], ",", 
     RowBox[{"\<\"Gradient\"\>", "\[Rule]", "13"}]}], "}"}], ",", 
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxE1XsU4GOdx/HJGsctueZynBoqTZkZo+iyLJNb2JJLroMkWTbkVpTKXUih
pTOJdSvkkgnVNOlQLlklY1eaIiuKMWzIbQjt2T2f1+f5/fM777+ec57z/T6v
tfb99I6fXGzChAnPbjdhwv/9PzDvyDuPef7xTSf8//f0pq8ctsX1B/zTwvaP
Vlr5/J1PHn34Dx45abO7Rk/d9fqD11vlifaCRSfssuZeoy89b8dNl/rO6L03
XnvyC0+OXv3BZ5Z/ZIMn2/ce+7OX7v7C6DPXOvvhG28dve0t+/zyu8v+T3vi
J6ff8I2Pjr55iQkXnHj+6GOuuPvkQ/80+j3bXnjIXlP+0n7miUN23fbI0Vd/
dZMZ771x9L+st9w73rr4U+217/nDCit8aPQfDr/m5Vf/bfSslb/4yML7R79z
5jqPPrHC0+0lp3xtj4c3HP3oK8//ev7uo2+9a6/N7/7i6Ev+/bYf3Xbx6OM+
PXXKjbeN3nvGuRdd9/jojVd4deXvvv6Z9hoP73faheuPXnTdr149d+fR9524
weFnfG70DR89/9ETLhj99bctPvNzPxt96AufuvvTfx693S/+a/P9l/pre8qs
jebsOXX00gdeOmWnHUYveP8yF2/zmdG3L33EKjO+Ofrb9//+tPf8dPQJV2/2
2pQ/jt7ni1ce/paJz7Y32W7Fx1Z/x+g13/z5mct/ePTLT/3x7iUOGz3/5m22
ePWc0T88+/tznp0z+px9V5+68IHRh7/7+IsfmvBce/vFH1/lt28dPe03259+
19ajl71szmu3HDR64WcnHTH3rNF3fPDUx2bfMPqy1Z6eefn80Sc9vuu8C14Z
ve/cm7Y4Z9Lz7RlfefuPT99i9Jv2PHPq8QeMfmXKixcfdcbo37+69xsPmT16
zq9vP32/e0d/48Jpf99j0egjD/3GETus+UJ7xw+89tgHZ4yevuL+e26y3+jl
Hrlr3ganjn7y+g23XPfq0XeedMGP15o3+oqdJ05b7bnRp6xz8CXLrfZie78X
733jxI1Hb3bHxl/528dGT/rmt//+zImjXztw2SMXXD76gX88csGDvxw9d5kH
9vzNU6NnPbD5Pb9caVH7s9dcteXP3zv6o19aae6cmaPf9ZFjpl177OjlJz1y
yXcuHf2Xp7dd9fxfjP7Vz677ytefGH3l19eYcNobXmqf+okTjjz23aP332Dh
gs/sOnqLiTvuddAxo9e+78f37Hvh6AmXr7XV7reMfvCo0+Z+5LHRN279zLSt
lnm5fd7qu1+68Xqjj15486rv3mn0Lj+ZfMY7jhq9wRlnTZj0rdEr7rXoyDfe
NPrBqfs8vuwjo/lxx+IPn37LO4cfmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5of
mh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH73P+KH5ofmh+aH5ofmh+aH5
ofmh+aH50fmIH5ofmh+aH5ofmh+aH5ofmh+aH5ofnff4ofmh+aH5ofmh+aH5
ofmh+aH5ofnR/Y0fmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+a
H93P+KH5ofmh+aH5ofmh+aH5ofmh+aH50fcmfmh+aH5ofmh+aH5ofmh+aH70
vPih+XHWUreu8uWdhx+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+a
H5ofmh+aH5ofmh+aH5ofmh+aH5ofvc/4ofmh+aH5ofmh+aH5ofmh+aH5ofnR
+Ygfmh+aH5ofmh+aH5ofmh+aH5ofmh+d9/ih+aH5ofmh+aH5ofmh+aH5ofmh
+dH9jR+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5of3c/4ofmh
+aH5ofmh+aH5ofmh+aH5ofnR9yZ+aH5ofmh+aH5ofmh+aH5ofvS8+KH5sdty
l1207XHDD80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80P
zQ/ND80PzQ/ND80PzY/eZ/zQ/ND80PzQ/ND80PzQ/ND80PzQ/Oh8xA/ND80P
zQ/ND80PzQ/ND80PzQ/Nj857/ND80PzQ/ND80PzQ/ND80PzQ/ND86P7GD80P
zQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzY/uZ/zQ/ND80PzQ/ND8
0PzQ/ND80PzQ/Oh7Ez80PzQ/ND80PzQ/ND80PzQ/el780PyYtNKp6y531fBD
80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80Pz
Q/ND80Pzo/cZPzQ/ND80PzQ/ND80PzQ/ND80PzQ/Oh/xQ/ND80PzQ/ND80Pz
Q/ND80PzQ/Oj8x4/ND80PzQ/ND80PzQ/ND80PzQ/ND+6v/FD80PzQ/ND80Pz
Q/ND80PzQ/ND80PzQ/ND80PzQ/ND80Pzo/sZPzQ/ND80PzQ/ND80PzQ/ND80
PzQ/+t7ED80PzQ/ND80PzQ/ND80PzY+eFz80Pxas+q8/vOc3ww/ND80PzQ/N
D80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND82P
3mf80PzQ/ND80PzQ/ND80PzQ/ND80PzofMQPzQ/ND80PzQ/ND80PzQ/ND80P
zY/Oe/zQ/ND80PzQ/ND80PzQ/ND80PzQ/Oj+xg/ND80PzQ/ND80PzQ/ND80P
zQ/ND80PzQ/ND80PzQ/ND82P7mf80PzQ/ND80PzQ/ND80PzQ/ND80PzoexM/
ND80PzQ/ND80PzQ/ND80P3pe/ND8mL3mhz5w7oRn6ofmh+aH5ofmh+aH5ofm
h+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+ZH7zN+aH5o
fmh+aH5ofmh+aH5ofmh+aH50PuKH5ofmh+aH5ofmh+aH5ofmh+aH5kfnPX5o
fmh+aH5ofmh+aH5ofmh+aH5ofnR/44fmh+aH5ofmh+aH5ofmh+aH5ofmh+aH
5ofmh+aH5ofmh+ZH9zN+aH5ofmh+aH5ofmh+aH5ofmh+aH70vYkfmh+aH5of
mh+aH5ofmh+aHz0vfmh+HL3WtF/ttu7wQ/ND80PzQ/ND80PzQ/ND80PzQ/ND
80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND86P3GT80PzQ/ND80PzQ/
ND80PzQ/ND80Pzof8UPzQ/ND80PzQ/ND80PzQ/ND80Pzo/MePzQ/ND80PzQ/
ND80PzQ/ND80PzQ/ur/xQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80Pz
Q/ND86P7GT80PzQ/ND80PzQ/ND80PzQ/ND80P/rexA/ND80PzQ/ND80PzQ/N
D82Pnhc/ND9mrLP8rmvuMvzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND8
0PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND86H3GD80PzQ/ND80PzQ/ND80PzQ/N
D82Pzkf80PzQ/ND80PzQ/ND80PzQ/ND80PzovMcPzQ/ND80PzQ/ND80PzQ/N
D80PzY/ub/zQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND86H7G
D80PzQ/ND80PzQ/ND80PzQ/ND82PvjfxQ/ND80PzQ/ND80PzQ/ND86PnxQ/N
jyXX/esf//u44Yfmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH
5ofmh+aH5ofmh+aH5ofmh+ZH7zN+aH5ofmh+aH5ofmh+aH5ofmh+aH50PuKH
5ofmh+aH5ofmh+aH5ofmh+aH5kfnPX5ofmh+aH5ofmh+aH5ofmh+aH5ofnR/
44fmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+ZH9zN+aH5ofmh+
aH5ofmh+aH5ofmh+aH70vYkfmh+aH5ofmh+aH5ofmh+aHz0vfmh+zFvv3oMu
vWr4ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5
ofmh+aH5ofmh+dH7jB+aH5ofmh+aH5ofmh+aH5ofmh+aH52P+KH5ofmh+aH5
ofmh+aH5ofmh+aH50XmPH5ofmh+aH5ofmh+aH5ofmh+aH5of3d/4ofmh+aH5
ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+dH9jB+aH5ofmh+aH5ofmh+a
H5ofmh+aH31v4ofmh+aH5ofmh+aH5ofmh+ZHz4sfmh+zNvjhi/vfN/zQ/ND8
0PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ
/ND86H3GD80PzQ/ND80PzQ/ND80PzQ/ND82Pzkf80PzQ/ND80PzQ/ND80PzQ
/ND80PzovMcPzQ/ND80PzQ/ND80PzQ/ND80PzY/ub/zQ/ND80PzQ/ND80PzQ
/ND80PzQ/ND80PzQ/ND80PzQ/ND86H7GD80PzQ/ND80PzQ/ND80PzQ/ND82P
vjfxQ/ND80PzQ/ND80PzQ/ND86PnxQ/Nj33eP+uEd77ur/VD80PzQ/ND80Pz
Q/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80Pzo/cZ
PzQ/ND80PzQ/ND80PzQ/ND80PzQ/Oh/xQ/ND80PzQ/ND80PzQ/ND80PzQ/Oj
8x4/ND80PzQ/ND80PzQ/ND80PzQ/ND+6v/FD80PzQ/ND80PzQ/ND80PzQ/ND
80PzQ/ND80PzQ/ND80Pzo/sZPzQ/ND80PzQ/ND80PzQ/ND80PzQ/+t7ED80P
zQ/ND80PzQ/ND80PzY+eFz80PyZv8vnX/2Xd4Yfmh+aH5ofmh+aH5ofmh+aH
5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+ZH7zN+aH5ofmh+
aH5ofmh+aH5ofmh+aH50PuKH5ofmh+aH5ofmh+aH5ofmh+aH5kfnPX5ofmh+
aH5ofmh+aH5ofmh+aH5ofnR/44fmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofm
h+aH5ofmh+ZH9zN+aH5ofmh+aH5ofmh+aH5ofmh+aH70vYkfmh+aH5ofmh+a
H5ofmh+aHz0vfmh+PL3ZnrO+v8vwQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80Pz
Q/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND86P3GT80PzQ/ND80PzQ/ND80
PzQ/ND80Pzof8UPzQ/ND80PzQ/ND80PzQ/ND80Pzo/MePzQ/ND80PzQ/ND80
PzQ/ND80PzQ/ur/xQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND
86P7GT80PzQ/ND80PzQ/ND80PzQ/ND80P/rexA/ND80PzQ/ND80PzQ/ND82P
nhc/ND/mfHCTt3zm+OGH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH
5ofmh+aH5ofmh+aH5ofmh+aH5ofmR+8zfmh+aH5ofmh+aH5ofmh+aH5ofmh+
dD7ih+aH5ofmh+aH5ofmh+aH5ofmh+ZH5z1+aH5ofmh+aH5ofmh+aH5ofmh+
aH50f+OH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmR/czfmh+
aH5ofmh+aH5ofmh+aH5ofmh+9L2JH5ofmh+aH5ofmh+aH5ofmh89L35ofhz3
oUnfe9/Vww/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/N
D80PzQ/ND80PzQ/ND82P3mf80PzQ/ND80PzQ/ND80PzQ/ND80PzofMQPzQ/N
D80PzQ/ND80PzQ/ND80PzY/Oe/zQ/ND80PzQ/ND80PzQ/ND80PzQ/Oj+xg/N
D80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND82P7mf80PzQ/ND80PzQ
/ND80PzQ/ND80PzoexM/ND80PzQ/ND80PzQ/ND80P3pe/ND82HqHxd7/yn3D
D80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80P
zQ/ND80PzY/eZ/zQ/ND80PzQ/ND80PzQ/ND80PzQ/Oh8xA/ND80PzQ/ND80P
zQ/ND80PzQ/Nj857/ND80PzQ/ND80PzQ/ND80PzQ/ND86P7GD80PzQ/ND80P
zQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzY/uZ/zQ/ND80PzQ/ND80PzQ/ND8
0PzQ/Oh7Ez80PzQ/ND80PzQ/ND80PzQ/el780PxYfpc/3XLT656tH5ofmh+a
H5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5of
mh+9z/ih+aH5ofmh+aH5ofmh+aH5ofmh+dH5iB+aH5ofmh+aH5ofmh+aH5of
mh+aH533+KH5ofmh+aH5ofmh+aH5ofmh+aH50f2NH5ofmh+aH5ofmh+aH5of
mh+aH5ofmh+aH5ofmh+aH5ofmh/dz/ih+aH5ofmh+aH5ofmh+aH5ofmh+dH3
Jn5ofmh+aH5ofmh+aH5ofmh+9Lz4ofkxf4/btztxyvBD80PzQ/ND80PzQ/ND
80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80Pzo/cZPzQ/
ND80PzQ/ND80PzQ/ND80PzQ/Oh/xQ/ND80PzQ/ND80PzQ/ND80PzQ/Oj8x4/
ND80PzQ/ND80PzQ/ND80PzQ/ND+6v/FD80PzQ/ND80PzQ/ND80PzQ/ND80Pz
Q/ND80PzQ/ND80Pzo/sZPzQ/ND80PzQ/ND80PzQ/ND80PzQ/+t7ED80PzQ/N
D80PzQ/ND80PzY+eFz80Py762BW/22rX4Yfmh+aH5ofmh+aH5ofmh+aH5ofm
h+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+ZH7zN+aH5ofmh+aH5o
fmh+aH5ofmh+aH50PuKH5ofmh+aH5ofmh+aH5ofmh+aH5kfnPX5ofmh+aH5o
fmh+aH5ofmh+aH5ofnR/44fmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH
5ofmh+ZH9zN+aH5ofmh+aH5ofmh+aH5ofmh+aH70vYkfmh+aH5ofmh+aH5of
mh+aHz0vfmh+HLDf6fstfcLwQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND
80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND86P3GT80PzQ/ND80PzQ/ND80PzQ/
ND80Pzof8UPzQ/ND80PzQ/ND80PzQ/ND80Pzo/MePzQ/ND80PzQ/ND80PzQ/
ND80PzQ/ur/xQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND86P7
GT80PzQ/ND80PzQ/ND80PzQ/ND80P/rexA/ND80PzQ/ND80PzQ/ND82Pnhc/
ND+mH3jQU3ddPfzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND8
0PzQ/ND80PzQ/ND80PzQ/ND86H3GD80PzQ/ND80PzQ/ND80PzQ/ND82Pzkf8
0PzQ/ND80PzQ/ND80PzQ/ND80PzovMcPzQ/ND80PzQ/ND80PzQ/ND80PzY/u
b/zQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND86H7GD80PzQ/N
D80PzQ/ND80PzQ/ND82PvjfxQ/ND80PzQ/ND80PzQ/ND86PnxQ/Nj0UHb/f5
s387/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ
/ND80PzQ/ND80PzofcYPzQ/ND80PzQ/ND80PzQ/ND80PzY/OR/zQ/ND80PzQ
/ND80PzQ/ND80PzQ/Oi8xw/ND80PzQ/ND80PzQ/ND80PzQ/Nj+5v/ND80PzQ
/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzofsYPzQ/ND80PzQ/ND80P
zQ/ND80PzY++N/FD80PzQ/ND80PzQ/ND80Pzo+fFD82Pmw+fPnHnxZ6rH5of
mh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+a
H5ofmh+9z/ih+aH5ofmh+aH5ofmh+aH5ofmh+dH5iB+aH5ofmh+aH5ofmh+a
H5ofmh+aH533+KH5ofmh+aH5ofmh+aH5ofmh+aH50f2NH5ofmh+aH5ofmh+a
H5ofmh+aH5ofmh+aH5ofmh+aH5ofmh/dz/ih+aH5ofmh+aH5ofmh+aH5ofmh
+dH3Jn5ofmh+aH5ofmh+aH5ofmh+9Lz4oflx6lErnrXa1OGH5ofmh+aH5ofm
h+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmR+8z
fmh+aH5ofmh+aH5ofmh+aH5ofmh+dD7ih+aH5ofmh+aH5ofmh+aH5ofmh+ZH
5z1+aH5ofmh+aH5ofmh+aH5ofmh+aH50f+OH5ofmh+aH5ofmh+aH5ofmh+aH
5ofmh+aH5ofmh+aH5ofmR/czfmh+aH5ofmh+aH5ofmh+aH5ofmh+9L2JH5of
mh+aH5ofmh+aH5ofmh89L35ofmz/hefWeGDX4Yfmh+aH5ofmh+aH5ofmh+aH
5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+ZH7zN+aH5ofmh+
aH5ofmh+aH5ofmh+aH50PuKH5ofmh+aH5ofmh+aH5ofmh+aH5kfnPX5ofmh+
aH5ofmh+aH5ofmh+aH5ofnR/44fmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofm
h+aH5ofmh+ZH9zN+aH5ofmh+aH5ofmh+aH5ofmh+aH70vYkfmh+aH5ofmh+a
H5ofmh+aHz0vfmh+rHb8fd+58IThh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofm
h+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5kfvM35ofmh+aH5ofmh+aH5o
fmh+aH5ofnQ+4ofmh+aH5ofmh+aH5ofmh+aH5ofmR+c9fmh+aH5ofmh+aH5o
fmh+aH5ofmh+dH/jh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH
5kf3M35ofmh+aH5ofmh+aH5ofmh+aH5ofvS9iR+aH5ofmh+aH5ofmh+aH5of
PS9+aH48dPKc6Z+4Zvih+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh
+aH5ofmh+aH5ofmh+aH5ofmh+aH50fuMH5ofmh+aH5ofmh+aH5ofmh+aH5of
nY/4ofmh+aH5ofmh+aH5ofmh+aH5ofnReY8fmh+aH5ofmh+aH5ofmh+aH5of
mh/d3/ih+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH50f2MH5of
mh+aH5ofmh+aH5ofmh+aH5offW/ih+aH5ofmh+aH5ofmh+aH5kfPix+aH1ec
ft5P1pk//ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND8
0PzQ/ND80PzQ/ND80PzofcYPzQ/ND80PzQ/ND80PzQ/ND80PzY/OR/zQ/ND8
0PzQ/ND80PzQ/ND80PzQ/Oi8xw/ND80PzQ/ND80PzQ/ND80PzQ/Nj+5v/ND8
0PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzofsYPzQ/ND80PzQ/N
D80PzQ/ND80PzY++N/FD80PzQ/ND80PzQ/ND80Pzo+fFD82PQ8/8wlYLF3u+
fmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+
aH5ofmh+aH70PuOH5ofmh+aH5ofmh+aH5ofmh+aH5kfnI35ofmh+aH5ofmh+
aH5ofmh+aH5ofnTe44fmh+aH5ofmh+aH5ofmh+aH5ofmR/c3fmh+aH5ofmh+
aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH50P+OH5ofmh+aH5ofmh+aH5ofm
h+aH5kffm/ih+aH5ofmh+aH5ofmh+aH50fPih+bH+87Z+55rpg4/ND80PzQ/
ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80
P3qf8UPzQ/ND80PzQ/ND80PzQ/ND80Pzo/MRPzQ/ND80PzQ/ND80PzQ/ND80
PzQ/Ou/xQ/ND80PzQ/ND80PzQ/ND80PzQ/Oj+xs/ND80PzQ/ND80PzQ/ND80
PzQ/ND80PzQ/ND80PzQ/ND80P7qf8UPzQ/ND80PzQ/ND80PzQ/ND80Pzo+9N
/ND80PzQ/ND80PzQ/ND80PzoefFD82PCN2fsedhuww/ND80PzQ/ND80PzQ/N
D80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND82P3mf80PzQ
/ND80PzQ/ND80PzQ/ND80PzofMQPzQ/ND80PzQ/ND80PzQ/ND80PzY/Oe/zQ
/ND80PzQ/ND80PzQ/ND80PzQ/Oj+xg/ND80PzQ/ND80PzQ/ND80PzQ/ND80P
zQ/ND80PzQ/ND82P7mf80PzQ/ND80PzQ/ND80PzQ/ND80PzoexM/ND80PzQ/
ND80PzQ/ND80P3pe/ND8uOOCtR/b4MThh+aH5ofmh+aH5ofmh+aH5ofmh+aH
5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5kfvM35ofmh+aH5ofmh+
aH5ofmh+aH5ofnQ+4ofmh+aH5ofmh+aH5ofmh+aH5ofmR+c9fmh+aH5ofmh+
aH5ofmh+aH5ofmh+dH/jh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofm
h+aH5kf3M35ofmh+aH5ofmh+aH5ofmh+aH5ofvS9iR+aH5ofmh+aH5ofmh+a
H5ofPS9+aH6cdcnihy+6Zvih+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5
ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH50fuMH5ofmh+aH5ofmh+aH5ofmh+a
H5ofnY/4ofmh+aH5ofmh+aH5ofmh+aH5ofnReY8fmh+aH5ofmh+aH5ofmh+a
H5ofmh/d3/ih+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH50f2M
H5ofmh+aH5ofmh+aH5ofmh+aH5offW/ih+aH5ofmh+aH5ofmh+aH5kfPix+a
H7td/ugrP5k//ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ
/ND80PzQ/ND80PzQ/ND80PzofcYPzQ/ND80PzQ/ND80PzQ/ND80PzY/OR/zQ
/ND80PzQ/ND80PzQ/ND80PzQ/Oi8xw/ND80PzQ/ND80PzQ/ND80PzQ/Nj+5v
/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzofsYPzQ/ND80P
zQ/ND80PzQ/ND80PzY++N/FD80PzQ/ND80PzQ/ND80Pzo+fFD82PSVff8eVj
/+GF+qH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh
+aH5ofmh+aH5ofnR+4wfmh+aH5ofmh+aH5ofmh+aH5ofmh+dj/ih+aH5ofmh
+aH5ofmh+aH5ofmh+dF5jx+aH5ofmh+aH5ofmh+aH5ofmh+aH93f+KH5ofmh
+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofnR/Ywfmh+aH5ofmh+aH5of
mh+aH5ofmh99b+KH5ofmh+aH5ofmh+aH5ofmR8+LH5ofC2ZfueLm04Yfmh+a
H5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5of
mh+aH73P+KH5ofmh+aH5ofmh+aH5ofmh+aH50fmIH5ofmh+aH5ofmh+aH5of
mh+aH5ofnff4ofmh+aH5ofmh+aH5ofmh+aH5ofnR/Y0fmh+aH5ofmh+aH5of
mh+aH5ofmh+aH5ofmh+aH5ofmh+aH93P+KH5ofmh+aH5ofmh+aH5ofmh+aH5
0fcmfmh+aH5ofmh+aH5ofmh+aH70vPih+TH7B2dcsMTuww/ND80PzQ/ND80P
zQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND82P3mf8
0PzQ/ND80PzQ/ND80PzQ/ND80PzofMQPzQ/ND80PzQ/ND80PzQ/ND80PzY/O
e/zQ/ND80PzQ/ND80PzQ/ND80PzQ/Oj+xg/ND80PzQ/ND80PzQ/ND80PzQ/N
D80PzQ/ND80PzQ/ND82P7mf80PzQ/ND80PzQ/ND80PzQ/ND80PzoexM/ND80
PzQ/ND80PzQ/ND80P3pe/ND8OHruIZPvPHH4ofmh+aH5ofmh+aH5ofmh+aH5
ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+dH7jB+aH5ofmh+a
H5ofmh+aH5ofmh+aH52P+KH5ofmh+aH5ofmh+aH5ofmh+aH50XmPH5ofmh+a
H5ofmh+aH5ofmh+aH5of3d/4ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh
+aH5ofmh+dH9jB+aH5ofmh+aH5ofmh+aH5ofmh+aH31v4ofmh+aH5ofmh+aH
5ofmh+ZHz4sfmh8zbtr++q9+b/ih+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh
+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH50fuMH5ofmh+aH5ofmh+aH5of
mh+aH5ofnY/4ofmh+aH5ofmh+aH5ofmh+aH5ofnReY8fmh+aH5ofmh+aH5of
mh+aH5ofmh/d3/ih+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5
0f2MH5ofmh+aH5ofmh+aH5ofmh+aH5offW/ih+aH5ofmh+aH5ofmh+aH5kfP
ix+aH0ve+q5Ndvjd8EPzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80Pz
Q/ND80PzQ/ND80PzQ/ND80PzQ/Oj9xk/ND80PzQ/ND80PzQ/ND80PzQ/ND86
H/FD80PzQ/ND80PzQ/ND80PzQ/ND86PzHj80PzQ/ND80PzQ/ND80PzQ/ND80
P7q/8UPzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/Oj+xk/ND80
PzQ/ND80PzQ/ND80PzQ/ND/63sQPzQ/ND80PzQ/ND80PzQ/Nj54XPzQ/5t2x
8n+svPiL9UPzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80Pz
Q/ND80PzQ/ND80PzQ/Oj9xk/ND80PzQ/ND80PzQ/ND80PzQ/ND86H/FD80Pz
Q/ND80PzQ/ND80PzQ/ND86PzHj80PzQ/ND80PzQ/ND80PzQ/ND80P7q/8UPz
Q/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/Oj+xk/ND80PzQ/ND80
PzQ/ND80PzQ/ND/63sQPzQ/ND80PzQ/ND80PzQ/Nj54XPzQ/Zt31wk7zpw0/
ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80
PzQ/ND80P3qf8UPzQ/ND80PzQ/ND80PzQ/ND80Pzo/MRPzQ/ND80PzQ/ND80
PzQ/ND80PzQ/Ou/xQ/ND80PzQ/ND80PzQ/ND80PzQ/Oj+xs/ND80PzQ/ND80
PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80P7qf8UPzQ/ND80PzQ/ND80PzQ/ND
80Pzo+9N/ND80PzQ/ND80PzQ/ND80PzoefFD82Of/5z/4Ld2H35ofmh+aH5o
fmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+
9D7jh+aH5ofmh+aH5ofmh+aH5ofmh+ZH5yN+aH5ofmh+aH5ofmh+aH5ofmh+
aH503uOH5ofmh+aH5ofmh+aH5ofmh+aH5kf3N35ofmh+aH5ofmh+aH5ofmh+
aH5ofmh+aH5ofmh+aH5ofmh+dD/jh+aH5ofmh+aH5ofmh+aH5ofmh+ZH35v4
ofmh+aH5ofmh+aH5ofmh+dHz4ofmx+Tfzj3wYycNPzQ/ND80PzQ/ND80PzQ/
ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND96n/FD80Pz
Q/ND80PzQ/ND80PzQ/ND86PzET80PzQ/ND80PzQ/ND80PzQ/ND80Pzrv8UPz
Q/ND80PzQ/ND80PzQ/ND80Pzo/sbPzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80
PzQ/ND80PzQ/ND+6n/FD80PzQ/ND80PzQ/ND80PzQ/ND86PvTfzQ/ND80PzQ
/ND80PzQ/ND86HnxQ/Pj6fvPf27ta4cfmh+aH5ofmh+aH5ofmh+aH5ofmh+a
H5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH73P+KH5ofmh+aH5ofmh
+aH5ofmh+aH50fmIH5ofmh+aH5ofmh+aH5ofmh+aH5ofnff4ofmh+aH5ofmh
+aH5ofmh+aH5ofnR/Y0fmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5of
mh+aH93P+KH5ofmh+aH5ofmh+aH5ofmh+aH50fcmfmh+aH5ofmh+aH5ofmh+
aH70vPih+THnoS8d++jvhh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5of
mh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofvc/4ofmh+aH5ofmh+aH5ofmh+aH5
ofnR+Ygfmh+aH5ofmh+aH5ofmh+aH5ofmh+d9/ih+aH5ofmh+aH5ofmh+aH5
ofmh+dH9jR+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5of3c/4
ofmh+aH5ofmh+aH5ofmh+aH5ofnR9yZ+aH5ofmh+aH5ofmh+aH5ofvS8+KH5
cdyf91n6ysUX1Q/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80P
zQ/ND80PzQ/ND80PzQ/ND82P3mf80PzQ/ND80PzQ/ND80PzQ/ND80PzofMQP
zQ/ND80PzQ/ND80PzQ/ND80PzY/Oe/zQ/ND80PzQ/ND80PzQ/ND80PzQ/Oj+
xg/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND82P7mf80PzQ/ND8
0PzQ/ND80PzQ/ND80PzoexM/ND80PzQ/ND80PzQ/ND80P3pe/ND82HrhZuce
vN7wQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80Pz
Q/ND80PzQ/ND86P3GT80PzQ/ND80PzQ/ND80PzQ/ND80Pzof8UPzQ/ND80Pz
Q/ND80PzQ/ND80Pzo/MePzQ/ND80PzQ/ND80PzQ/ND80PzQ/ur/xQ/ND80Pz
Q/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND86P7GT80PzQ/ND80PzQ/ND80
PzQ/ND80P/rexA/ND80PzQ/ND80PzQ/ND82Pnhc/ND+Wf+qtk9bfY/ih+aH5
ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh
+aH50fuMH5ofmh+aH5ofmh+aH5ofmh+aH5ofnY/4ofmh+aH5ofmh+aH5ofmh
+aH5ofnReY8fmh+aH5ofmh+aH5ofmh+aH5ofmh/d3/ih+aH5ofmh+aH5ofmh
+aH5ofmh+aH5ofmh+aH5ofmh+aH50f2MH5ofmh+aH5ofmh+aH5ofmh+aH5of
fW/ih+aH5ofmh+aH5ofmh+aH5kfPix+aH/OfXeKq504afmh+aH5ofmh+aH5o
fmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH70PuOH
5ofmh+aH5ofmh+aH5ofmh+aH5kfnI35ofmh+aH5ofmh+aH5ofmh+aH5ofnTe
44fmh+aH5ofmh+aH5ofmh+aH5ofmR/c3fmh+aH5ofmh+aH5ofmh+aH5ofmh+
aH5ofmh+aH5ofmh+aH50P+OH5ofmh+aH5ofmh+aH5ofmh+aH5kffm/ih+aH5
ofmh+aH5ofmh+aH50fPih+bHRYsWbDjn2uGH5ofmh+aH5ofmh+aH5ofmh+aH
5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmR+8zfmh+aH5ofmh+
aH5ofmh+aH5ofmh+dD7ih+aH5ofmh+aH5ofmh+aH5ofmh+ZH5z1+aH5ofmh+
aH5ofmh+aH5ofmh+aH50f+OH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofm
h+aH5ofmR/czfmh+aH5ofmh+aH5ofmh+aH5ofmh+9L2JH5ofmh+aH5ofmh+a
H5ofmh89L35ofhzw6p03H/P74Yfmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofm
h+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+ZH7zN+aH5ofmh+aH5ofmh+aH5o
fmh+aH50PuKH5ofmh+aH5ofmh+aH5ofmh+aH5kfnPX5ofmh+aH5ofmh+aH5o
fmh+aH5ofnR/44fmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+ZH
9zN+aH5ofmh+aH5ofmh+aH5ofmh+aH70vYkfmh+aH5ofmh+aH5ofmh+aHz0v
fmh+TF/smn/edOJL9UPzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80Pz
Q/ND80PzQ/ND80PzQ/ND80PzQ/Oj9xk/ND80PzQ/ND80PzQ/ND80PzQ/ND86
H/FD80PzQ/ND80PzQ/ND80PzQ/ND86PzHj80PzQ/ND80PzQ/ND80PzQ/ND80
P7q/8UPzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/Oj+xk/ND80
PzQ/ND80PzQ/ND80PzQ/ND/63sQPzQ/ND80PzQ/ND80PzQ/Nj54XPzQ/Fi1x
5n2LTR9+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5o
fmh+aH5ofmh+aH5ofvQ+44fmh+aH5ofmh+aH5ofmh+aH5ofmR+cjfmh+aH5o
fmh+aH5ofmh+aH5ofmh+dN7jh+aH5ofmh+aH5ofmh+aH5ofmh+ZH9zd+aH5o
fmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofnQ/44fmh+aH5ofmh+aH
5ofmh+aH5ofmR9+b+KH5ofmh+aH5ofmh+aH5ofnR8+KH5sfNyxz28dv3GH5o
fmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+
aH5ofmh+9D7jh+aH5ofmh+aH5ofmh+aH5ofmh+ZH5yN+aH5ofmh+aH5ofmh+
aH5ofmh+aH503uOH5ofmh+aH5ofmh+aH5ofmh+aH5kf3N35ofmh+aH5ofmh+
aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+dD/jh+aH5ofmh+aH5ofmh+aH5ofm
h+ZH35v4ofmh+aH5ofmh+aH5ofmh+dHz4ofmx6nL7/TkaScPPzQ/ND80PzQ/
ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND96
n/FD80PzQ/ND80PzQ/ND80PzQ/ND86PzET80PzQ/ND80PzQ/ND80PzQ/ND80
Pzrv8UPzQ/ND80PzQ/ND80PzQ/ND80Pzo/sbPzQ/ND80PzQ/ND80PzQ/ND80
PzQ/ND80PzQ/ND80PzQ/ND+6n/FD80PzQ/ND80PzQ/ND80PzQ/ND86PvTfzQ
/ND80PzQ/ND80PzQ/ND86HnxQ/Nj+1U2POrDs4cfmh+aH5ofmh+aH5ofmh+a
H5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH73P+KH5ofmh
+aH5ofmh+aH5ofmh+aH50fmIH5ofmh+aH5ofmh+aH5ofmh+aH5ofnff4ofmh
+aH5ofmh+aH5ofmh+aH5ofnR/Y0fmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5of
mh+aH5ofmh+aH93P+KH5ofmh+aH5ofmh+aH5ofmh+aH50fcmfmh+aH5ofmh+
aH5ofmh+aH70vPih+bHaGqsutsL9ww/ND80PzQ/ND80PzQ/ND80PzQ/ND80P
zQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND82P3mf80PzQ/ND80PzQ/ND8
0PzQ/ND80PzofMQPzQ/ND80PzQ/ND80PzQ/ND80PzY/Oe/zQ/ND80PzQ/ND8
0PzQ/ND80PzQ/Oj+xg/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/N
D82P7mf80PzQ/ND80PzQ/ND80PzQ/ND80PzoexM/ND80PzQ/ND80PzQ/ND80
P3pe/ND8eOhNL51x78SX64fmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH
5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+ZH7zN+aH5ofmh+aH5ofmh+aH5ofmh+
aH50PuKH5ofmh+aH5ofmh+aH5ofmh+aH5kfnPX5ofmh+aH5ofmh+aH5ofmh+
aH5ofnR/44fmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+ZH9zN+
aH5ofmh+aH5ofmh+aH5ofmh+aH70vYkfmh+aH5ofmh+aH5ofmh+aHz0vfmh+
XPGW+1edNX34ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5
ofmh+aH5ofmh+aH5ofmh+dH7jB+aH5ofmh+aH5ofmh+aH5ofmh+aH52P+KH5
ofmh+aH5ofmh+aH5ofmh+aH50XmPH5ofmh+aH5ofmh+aH5ofmh+aH5of3d/4
ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+dH9jB+aH5ofmh+a
H5ofmh+aH5ofmh+aH31v4ofmh+aH5ofmh+aH5ofmh+ZHz4sfmh+HTv7pJTNn
Dj80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80
PzQ/ND80PzQ/ep/xQ/ND80PzQ/ND80PzQ/ND80PzQ/Oj8xE/ND80PzQ/ND80
PzQ/ND80PzQ/ND867/FD80PzQ/ND80PzQ/ND80PzQ/ND86P7Gz80PzQ/ND80
PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/up/xQ/ND80PzQ/ND80PzQ/ND
80PzQ/Oj70380PzQ/ND80PzQ/ND80PzQ/Oh58UPz431TL5z65lOGH5ofmh+a
H5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5of
mh+9z/ih+aH5ofmh+aH5ofmh+aH5ofmh+dH5iB+aH5ofmh+aH5ofmh+aH5of
mh+aH533+KH5ofmh+aH5ofmh+aH5ofmh+aH50f2NH5ofmh+aH5ofmh+aH5of
mh+aH5ofmh+aH5ofmh+aH5ofmh/dz/ih+aH5ofmh+aH5ofmh+aH5ofmh+dH3
Jn5ofmh+aH5ofmh+aH5ofmh+9Lz4ofkx4V3Hz3l49vBD80PzQ/ND80PzQ/ND
80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80Pzo/cZPzQ/
ND80PzQ/ND80PzQ/ND80PzQ/Oh/xQ/ND80PzQ/ND80PzQ/ND80PzQ/Oj8x4/
ND80PzQ/ND80PzQ/ND80PzQ/ND+6v/FD80PzQ/ND80PzQ/ND80PzQ/ND80Pz
Q/ND80PzQ/ND80Pzo/sZPzQ/ND80PzQ/ND80PzQ/ND80PzQ/+t7ED80PzQ/N
D80PzQ/ND80PzY+eFz80P+54zyc2v+z+4Yfmh+aH5ofmh+aH5ofmh+aH5ofm
h+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+ZH7zN+aH5ofmh+aH5o
fmh+aH5ofmh+aH50PuKH5ofmh+aH5ofmh+aH5ofmh+aH5kfnPX5ofmh+aH5o
fmh+aH5ofmh+aH5ofnR/44fmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH
5ofmh+ZH9zN+aH5ofmh+aH5ofmh+aH5ofmh+aH70vYkfmh+aH5ofmh+aH5of
mh+aHz0vfmh+nLXRlr8+cIm/1Q/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/N
D80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND82P3mf80PzQ/ND80PzQ/ND80PzQ
/ND80PzofMQPzQ/ND80PzQ/ND80PzQ/ND80PzY/Oe/zQ/ND80PzQ/ND80PzQ
/ND80PzQ/Oj+xg/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND82P
7mf80PzQ/ND80PzQ/ND80PzQ/ND80PzoexM/ND80PzQ/ND80PzQ/ND80P3pe
/ND82G3G23efuv7wQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND
80PzQ/ND80PzQ/ND80PzQ/ND86P3GT80PzQ/ND80PzQ/ND80PzQ/ND80Pzof
8UPzQ/ND80PzQ/ND80PzQ/ND80Pzo/MePzQ/ND80PzQ/ND80PzQ/ND80PzQ/
ur/xQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND86P7GT80PzQ/
ND80PzQ/ND80PzQ/ND80P/rexA/ND80PzQ/ND80PzQ/ND82Pnhc/ND8mbbnU
n56eOfzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND8
0PzQ/ND80PzQ/ND86H3GD80PzQ/ND80PzQ/ND80PzQ/ND82Pzkf80PzQ/ND8
0PzQ/ND80PzQ/ND80PzovMcPzQ/ND80PzQ/ND80PzQ/ND80PzY/ub/zQ/ND8
0PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND86H7GD80PzQ/ND80PzQ/N
D80PzQ/ND82PvjfxQ/ND80PzQ/ND80PzQ/ND86PnxQ/NjwXbPHHIDacMPzQ/
ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80
PzQ/ND96n/FD80PzQ/ND80PzQ/ND80PzQ/ND86PzET80PzQ/ND80PzQ/ND80
PzQ/ND80Pzrv8UPzQ/ND80PzQ/ND80PzQ/ND80Pzo/sbPzQ/ND80PzQ/ND80
PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND+6n/FD80PzQ/ND80PzQ/ND80PzQ/ND
86PvTfzQ/ND80PzQ/ND80PzQ/ND86HnxQ/Nj9nZ3vXTU94cfmh+aH5ofmh+a
H5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH73P
+KH5ofmh+aH5ofmh+aH5ofmh+aH50fmIH5ofmh+aH5ofmh+aH5ofmh+aH5of
nff4ofmh+aH5ofmh+aH5ofmh+aH5ofnR/Y0fmh+aH5ofmh+aH5ofmh+aH5of
mh+aH5ofmh+aH5ofmh+aH93P+KH5ofmh+aH5ofmh+aH5ofmh+aH50fcmfmh+
aH5ofmh+aH5ofmh+aH70vPih+XH0TteetNEDww/ND80PzQ/ND80PzQ/ND80P
zQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND82P3mf80PzQ/ND8
0PzQ/ND80PzQ/ND80PzofMQPzQ/ND80PzQ/ND80PzQ/ND80PzY/Oe/zQ/ND8
0PzQ/ND80PzQ/ND80PzQ/Oj+xg/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/N
D80PzQ/ND82P7mf80PzQ/ND80PzQ/ND80PzQ/ND80PzoexM/ND80PzQ/ND80
PzQ/ND80P3pe/ND8mLHb2W/4+xKv1A/ND80PzQ/ND80PzQ/ND80PzQ/ND80P
zQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND82P3mf80PzQ/ND80PzQ/ND8
0PzQ/ND80PzofMQPzQ/ND80PzQ/ND80PzQ/ND80PzY/Oe/zQ/ND80PzQ/ND8
0PzQ/ND80PzQ/Oj+xg/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/N
D82P7mf80PzQ/ND80PzQ/ND80PzQ/ND80PzoexM/ND80PzQ/ND80PzQ/ND80
P3pe/ND8WHKvI877+frDD80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/N
D80PzQ/ND80PzQ/ND80PzQ/ND80PzY/eZ/zQ/ND80PzQ/ND80PzQ/ND80PzQ
/Oh8xA/ND80PzQ/ND80PzQ/ND80PzQ/Nj857/ND80PzQ/ND80PzQ/ND80PzQ
/ND86P7GD80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzY/uZ/zQ
/ND80PzQ/ND80PzQ/ND80PzQ/Oh7Ez80PzQ/ND80PzQ/ND80PzQ/el780PyY
9/Gd33bKnsMPzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80P
zQ/ND80PzQ/ND80PzQ/Nj95n/ND80PzQ/ND80PzQ/ND80PzQ/ND86HzED80P
zQ/ND80PzQ/ND80PzQ/ND82Pznv80PzQ/ND80PzQ/ND80PzQ/ND80Pzo/sYP
zQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/Nj+5n/ND80PzQ/ND8
0PzQ/ND80PzQ/ND86HsTPzQ/ND80PzQ/ND80PzQ/ND96XvzQ/Ji1/3tnb/Pl
4Yfmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofm
h+aH5ofmh+ZH7zN+aH5ofmh+aH5ofmh+aH5ofmh+aH50PuKH5ofmh+aH5ofm
h+aH5ofmh+aH5kfnPX5ofmh+aH5ofmh+aH5ofmh+aH5ofnR/44fmh+aH5ofm
h+aH5ofmh+aH5ofmh+aH5ofmh+aH5ofmh+ZH9zN+aH5ofmh+aH5ofmh+aH5o
fmh+aH70vYkfmh+aH5ofmh+aH5ofmh+aHz0vfmh+7POp1Td6/XXDD80PzQ/N
D80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80P
zY/eZ/zQ/ND80PzQ/ND80PzQ/ND80PzQ/Oh8xA/ND80PzQ/ND80PzQ/ND80P
zQ/Nj857/ND80PzQ/ND80PzQ/ND80PzQ/ND86P7GD80PzQ/ND80PzQ/ND80P
zQ/ND80PzQ/ND80PzQ/ND80PzY/uZ/zQ/ND80PzQ/ND80PzQ/ND80PzQ/Oh7
Ez80PzQ/ND80PzQ/ND80PzQ/el780PyYfOjfbpv3wPBD80PzQ/ND80PzQ/ND
80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/ND80PzQ/8vV3ce7+XQP368
O4lEkpIlyV6WJFkSXVmSJQk3EUJItmzZkixZkkiE7IQkJLLELUKSLIWEJISQ
ltPpdLY69et33/N8X4/v5b/XY2auz/Hpc83rPTPvmeEPzB+YP+L7TP7A/IH5
A/MH5g/MH5g/MH9g/sD8gfkjfh/JH5g/MH9g/sD8gfkD8wfmD8wfmD8wf8Tv
PfkD8wfmD8wfmD8wf2D+wPyB+QPzB+aPeH+TPzB/YP7A/IH5A/MH5g/MH5g/
MH9g/sD8gfkD8wfmD8wfmD8wf8T7mfyB+QPzB+YPzB+YPzB/YP7A/IH5A/NH
9DfJH5g/MH9g/sD8gfkD8wfmD8wf8XnJH5g/Svr/1H3kBjXhD8wfmD8wf2D+
wPyB+QPzB+YPzB+YPzB/YP7A/IH5A/MH5g/MH5g/MH9g/sD8gfkD8wfmD8wf
mD/i+0z+wPyB+QPzB+YPzB+YPzB/YP7A/IH5I34fyR+YPzB/YP7A/IH5A/MH
5g/MH5g/MH/E7z35A/MH5g/MH5g/MH9g/sD8gfkD8wfmj3h/kz8wf2D+wPyB
+QPzB+YPzB+YPzB/YP7A/IH5A/MH5g/MH5g/MH/E+5n8gfkD8wfmD8wfmD8w
f2D+wPyB+QPzR/Q3yR+YPzB/YP7A/IH5A/MH5g/MH/F5yR+YPyZd9/6PPdrm
/sD8gfkD8wfmD8wfmD8wf2D+wPyB+QPzB+YPzB+YPzB/YP7A/IH5A/MH5g/M
H5g/MH9g/sD8gfkjvs/kD8wfmD8wf2D+wPyB+QPzB+YPzB+YP+L3kfyB+QPz
B+YPzB+YPzB/YP7A/IH5A/NH/N6TPzB/YP7A/IH5A/MH5g/MH5g/MH9g/oj3
N/kD8wfmD8wfmD8wf2D+wPyB+QPzB+YPzB+YPzB/YP7A/IH5A/NHvJ/JH5g/
MH9g/sD8gfkD8wfmD8wfmD8wf0R/k/yB+QPzB+YPzB+YPzB/YP7A/BGfl/yB
+eOmQU/32eaM3B+YPzB/YP7A/IH5A/MH5g/MH5g/MH9g/sD8gfkD8wfmD8wf
mD8wf2D+wPyB+QPzB+YPzB+YPzB/xPeZ/IH5A/MH5g/MH5g/MH9g/sD8gfkD
80f8PpI/MH9g/sD8gfkD8wfmD8wfmD8wf2D+iN978gfmD8wfmD8wf2D+wPyB
+QPzB+YPzB/x/iZ/YP7A/IH5A/MH5g/MH5g/MH9g/sD8gfkD8wfmD8wfmD8w
f2D+iPcz+QPzB+YPzB+YPzB/YP7A/IH5A/MH5o/ob5I/MH9g/sD8gfkD8wfm
D8wfmD/i85I/MH8cOXjw8vl35P7A/IH5A/MH5g/MH5g/MH9g/sD8gfkD8wfm
D8wfmD8wf2D+wPyB+QPzB+YPzB+YPzB/YP7A/IH5I77P5A/MH5g/MH9g/sD8
gfkD8wfmD8wfmD/i95H8gfkD8wfmD8wfmD8wf2D+wPyB+QPzR/zekz8wf2D+
wPyB+QPzB+YPzB+YPzB/YP6I9zf5A/MH5g/MH5g/MH9g/sD8gfkD8wfmD8wf
mD8wf2D+wPyB+QPzR7yfyR+YPzB/YP7A/IH5A/MH5g/MH5g/MH9Ef5P8gfkD
8wfmD8wfmD8wf2D+wPwRn5f8gfmj4ZDzBo5+LfcH5g/MH5g/MH9g/sD8gfkD
8wfmD8wfmD8wf2D+wPyB+QPzB+YPzB+YPzB/YP7A/IH5A/MH5g/MH/F9Jn9g
/sD8gfkD8wfmD8wfmD8wf2D+wPwRv4/kD8wfmD8wf2D+wPyB+QPzB+YPzB+Y
P+L3nvyB+QPzB+YPzB+YPzB/YP7A/IH5A/NHvL/JH5g/MH9g/sD8gfkD8wfm
D8wfmD8wf2D+wPyB+QPzB+YPzB+YP+L9TP7A/IH5A/MH5g/MH5g/MH9g/sD8
gfkj+pvkD8wfmD8wf2D+wPyB+QPzB+aP+LzkD8wf3w/rskGfn3J/YP7A/IH5
A/MH5g/MH5g/MH9g/sD8gfkD8wfmD8wfmD8wf2D+wPyB+QPzB+YPzB+YPzB/
YP7A/BHfZ/IH5g/MH5g/MH9g/sD8gfkD8wfmD8wf8ftI/sD8gfkD8wfmD8wf
mD8wf2D+wPyB+SN+78kfmD8wf2D+wPyB+QPzB+YPzB+YPzB/xPub/IH5A/MH
5g/MH5g/MH9g/sD8gfkD8wfmD8wfmD8wf2D+wPyB+SPez+QPzB+YPzB/YP7A
/IH5A/MH5g/MH5g/or9J/sD8gfkD8wfmD8wfmD8wf2D+iM9L/sD88dSIVve1
2nBN+APzB+YPzB+YPzB/YP7A/IH5A/MH5g/MH5g/MH9g/sD8gfkD8wfmD8wf
mD8wf2D+wPyB+QPzB+aP+D6TPzB/YP7A/IH5A/MH5g/MH5g/MH9g/ojfR/IH
5g/MH5g/MH9g/sD8gfkD8wfmD8wf8XtP/sD8gfkD8wfmD8wfmD8wf2D+wPyB
+SPe3+QPzB+YPzB/YP7A/IH5A/MH5g/MH5g/MH9g/sD8gfkD8wfmD8wf8X4m
f2D+wPyB+QPzB+YPzB+YPzB/YP7A/BH9TfIH5g/MH5g/MH9g/sD8gfkD80d8
XvIH5o++D9bfdknb3B+YPzB/YP7A/IH5A/MH5g/MH5g/MH9g/sD8gfkD8wfm
D8wfmD8wf2D+wPyB+QPzB+YPzB+YPzB/xPeZ/IH5A/MH5g/MH5g/MH9g/sD8
gfkD80f8PpI/MH9g/sD8gfkD8wfmD8wfmD8wf2D+iN978gfmD8wfmD8wf2D+
wPyB+QPzB+YPzB/x/iZ/YP7A/IH5A/MH5g/MH5g/MH9g/sD8gfkD8wfmD8wf
mD8wf2D+iPcz+QPzB+YPzB+YPzB/YP7A/IH5A/MH5o/ob5I/MH9g/sD8gfkD
8wfmD8wfmD/i85I/MH+0eXTJ8xPOyP2B+QPzB+YPzB+YPzB/YP7A/IH5A/MH
5g/MH5g/MH9g/sD8gfkD8wfmD8wfmD8wf2D+wPyB+QPzR3yfyR+YPzB/YP7A
/IH5A/MH5g/MH5g/MH/E7yP5A/MH5g/MH5g/MH9g/sD8gfkD8wfmj/i9J39g
/sD8gfkD8wfmD8wfmD8wf2D+wPwR72/yB+YPzB+YPzB/YP7A/IH5A/MH5g/M
H5g/MH9g/sD8gfkD8wfmj3g/kz8wf2D+wPyB+QPzB+YPzB+YPzB/YP6I/ib5
A/MH5g/MH5g/MH9g/sD8gfkjPi/5A/NH5ZMz2/YfkvsD8wfmD8wfmD8wf2D+
wPyB+QPzB+YPzB+YPzB/YP7A/IH5A/MH5g/MH5g/MH9g/sD8gfkD8wfmj/g+
kz8wf2D+wPyB+QPzB+YPzB+YPzB/YP6I30fyB+YPzB+YPzB/YP7A/IH5A/MH
5g/MH/F7T/7A/IH5A/MH5g/MH5g/MH9g/sD8gfkj3t/kD8wfmD8wf2D+wPyB
+QPzB+YPzB+YPzB/YP7A/IH5A/MH5g/MH/F+Jn9g/sD8gfkD8wfmD8wfmD8w
f2D+wPwR/U3yB+YPzB+YPzB/YP7A/IH5A/NHfF7yB+aPKc++Onn/ibk/MH9g
/sD8gfkD8wfmD8wfmD8wf2D+wPyB+QPzB+YPzB+YPzB/YP7A/IH5A/MH5g/M
H5g/MH9g/ojvM/kD8wfmD8wfmD8wf2D+wPyB+QPzB+aP+H0kf2D+wPyB+QPz
B+YPzB+YPzB/YP7A/BG/9+QPzB+YPzB/YP7A/IH5A/MH5g/MH5g/4v1N/sD8
gfkD8wfmD8wfmD8wf2D+wPyB+QPzB+YPzB+YPzB/YP7A/BHvZ/IH5g/MH5g/
MH9g/sD8gfkD8wfmD8wf0d8kf2D+wPyB+QPzB+YPzB+YPzB/xOclf2D+GPLC
/Ueu+in3B+YPzB+YPzB/YP7A/IH5A/MH5g/MH5g/MH9g/sD8gfkD8wfmD8wf
mD8wf2D+wPyB+QPzB+YPzB/xfSZ/YP7A/IH5A/MH5g/MH5g/MH9g/sD8Eb+P
5A/MH5g/MH9g/sD8gfkD8wfmD8wfmD/i9578gfkD8wfmD8wfmD8wf2D+wPyB
+QPzR7y/yR+YPzB/YP7A/IH5A/MH5g/MH5g/MH9g/sD8gfkD8wfmD8wfmD/i
/Uz+wPyB+QPzB+YPzB+YPzB/YP7A/IH5I/qb5A/MH5g/MH9g/sD8gfkD8wfm
j/i85A/MH93HX/XNexuuDX9g/sD8gfkD8wfmD8wfmD8wf2D+wPyB+QPzB+YP
zB+YPzB/YP7A/IH5A/MH5g/MH5g/MH9g/sD8Ed9n8gfmD8wfmD8wf2D+wPyB
+QPzB+YPzB/x+0j+wPyB+QPzB+YPzB+YPzB/YP7A/IH5I37vyR+YPzB/YP7A
/IH5A/MH5g/MH5g/MH/E+5v8gfkD8wfmD8wfmD8wf2D+wPyB+QPzB+YPzB+Y
PzB/YP7A/IH5I97P5A/MH5g/MH9g/sD8gfkD8wfmD8wfmD+iv0n+wPyB+QPz
B+YPzB+YPzB/YP6Iz0v+wPyx5cQevW7ZJ/cH5g/MH5g/MH9g/sD8gfkD8wfm
D8wfmD8wf2D+wPyB+QPzB+YPzB+YPzB/YP7A/IH5A/MH5g/MH/F9Jn9g/sD8
gfkD8wfmD8wfmD8wf2D+wPwRv4/kD8wfmD8wf2D+wPyB+QPzB+YPzB+YP+L3
nvyB+QPzB+YPzB+YPzB/YP7A/IH5A/NHvL/JH5g/MH9g/sD8gfkD8wfmD8wf
mD8wf2D+wPyB+QPzB+YPzB+YP+L9TP7A/IH5A/MH5g/MH5g/MH9g/sD8gfkj
+pvkD8wfmD8wf2D+wPyB+QPzB+aP+LzkD8wfv7zV/u/OvXJ/YP7A/IH5A/MH
5g/MH5g/MH9g/sD8gfkD8wfmD8wfmD8wf2D+wPyB+QPzB+YPzB+YPzB/YP7A
/BHfZ/IH5g/MH5g/MH9g/sD8gfkD8wfmD8wf8ftI/sD8gfkD8wfmD8wfmD8w
f2D+wPyB+SN+78kfmD8wf2D+wPyB+QPzB+YPzB+YPzB/xPub/IH5A/MH5g/M
H5g/MH9g/sD8gfkD8wfmD8wfmD8wf2D+wPyB+SPez+QPzB+YPzB/YP7A/IH5
A/MH5g/MH5g/or9J/sD8gfkD8wfmD8wfmD8wf2D+iM9L/sD8MfbdbfrXuzP3
B+YPzB+YPzB/YP7A/IH5A/MH5g/MH5g/MH9g/sD8gfkD8wfmD8wfmD8wf2D+
wPyB+QPzB+YPzB/xfSZ/YP7A/IH5A/MH5g/MH5g/MH9g/sD8Eb+P5A/MH5g/
MH9g/sD8gfkD8wfmD8wfmD/i9578gfkD8wfmD8wfmD8wf2D+wPyB+QPzR7y/
yR+YPzB/YP7A/IH5A/MH5g/MH5g/MH9g/sD8gfkD8wfmD8wfmD/i/Uz+wPyB
+QPzB+YPzB+YPzB/YP7A/IH5I/qb5A/MH5g/MH9g/sD8gfkD8wfmj/i85A/M
H5d9ULPm84m5PzB/YP7A/IH5A/MH5g/MH5g/MH9g/sD8gfkD8wfmD8wfmD8w
f2D+wPyB+QPzB+YPzB+YPzB/YP6I7zP5A/MH5g/MH5g/MH9g/sD8gfkD8wfm
j/h9JH9g/sD8gfkD8wfmD8wfmD8wf2D+wPwRv/fkD8wfmD8wf2D+wPyB+QPz
B+YPzB+YP+L9Tf7A/IH5A/MH5g/MH5g/MH9g/sD8gfkD8wfmD8wfmD8wf2D+
wPwR72fyB+YPzB+YPzB/YP7A/IH5A/MH5g/MH9HfJH9g/sD8gfkD8wfmD8wf
mD8wf8TnJX9g/jhg2s933js/9wfmD8wfmD8wf2D+wPyB+QPzB+YPzB+YPzB/
YP7A/IH5A/MH5g/MH5g/MH9g/sD8gfkD8wfmD8wf8X0mf2D+wPyB+QPzB+YP
zB+YPzB/YP7A/BG/j+QPzB+YPzB/YP7A/IH5A/MH5g/MH5g/4vee/IH5A/MH
5g/MH5g/MH9g/sD8gfkD80e8v8kfmD8wf2D+wPyB+QPzB+YPzB+YPzB/YP7A
/IH5A/MH5g/MH5g/4v1M/sD8gfkD8wfmD8wfmD8wf2D+wPyB+SP6m+QPzB+Y
PzB/YP7A/IH5A/MH5o/4vOQPHPd//HHWRuPq1OoU938kjvs/Esf9H4nj/o/E
cf9H4rj/I3Hc/5E47v9IHPd/JI77PxLH/R+J4/6PxHH/R+K4/yNx3P+ROO7/
SBz3fySO+z8Sx/0fieP+j8Rx/0fiuP8jcdz/kTju/0gc938kjvs/Esf9H75P
938kjvs/Esf9H4nj/o/Ecf9H4rj/I3Hc/5E47v9IHPd/JI77PxLH/R9+H+7/
SBz3fySO+z8Sx/0fieP+j8Rx/0fiuP8jcdz/kTju/0gc938kjvs//N7d/5E4
7v9IHPd/JI77PxLH/R+J4/6PxHH/R+K4/yNx3P+ROO7/SBz3f3h/3f+ROO7/
SBz3fySO+z8Sx/0fieP+j8Rx/0fiuP8jcdz/kTju/0gc938kjvs/Esf9H4nj
/o/Ecf9H4rj/I3Hc/5E47v/wfrr/I3Hc/5E47v9IHPd/JI77PxLH/R+J4/6P
xHH/R+K4/yNx3P+ROO7/0N+4/yNx3P+ROO7/SBz3fySO+z8Sx/0fieP+j8Rx
/0fiuP/D57n/IzF//P7nVzPrb537A/MH5g/MH5g/MH9g/sD8gfkD8wfmD8wf
mD8wf2D+wPyB+QPzB+YPzB+YPzB/YP7A/IH5A/MH5o/4PpM/MH9g/sD8gfkD
8wfmD8wfmD8wf2D+iN9H8gfmD8wfmD8wf2D+wPyB+QPzB+YPzB/xe0/+wPyB
+QPzB+YPzB+YPzB/YP7A/IH5I97f5A/MH5g/MH9g/sD8gfkD8wfmD8wfmD8w
f2D+wPyB+QPzB+YPzB/xfiZ/YP7A/IH5A/MH5g/MH5g/MH9g/sD8Ef1N8gfm
D8wfmD8wf2D+wPyB+QPzR3xe8geO+6MWHfrAJXvl/sBxf1TiuD8qcdwflTju
j0oc90cljvujEsf9UYnj/qjEcX9U4rg/KnHcH5U47o9KHPdHJY77oxLH/VGJ
4/6oxHF/VOK4Pypx3B+VOO6PShz3RyWO+6MSx/1RieP+qMRxf1TiuD/K9+n+
qMRxf1TiuD8qcdwflTjuj0oc90cljvujEsf9UYnj/qjEcX9U4rg/yu/D/VGJ
4/6oxHF/VOK4Pypx3B+VOO6PShz3RyWO+6MSx/1RieP+qMRxf5Tfu/ujEsf9
UYnj/qjEcX9U4rg/KnHcH5U47o9KHPdHJY77oxLH/VGJ4/4o76/7oxLH/VGJ
4/6oxHF/VOK4Pypx3B+VOO6PShz3RyWO+6MSx/1RieP+qMRxf1TiuD8qcdwf
lTjuj0oc90cljvujEsf9Ud5P90cljvujEsf9UYnj/qjEcX9U4rg/KnHcH5U4
7o9KHPdHJY77oxLH/VH6G/dHJY77oxLH/VGJ4/6oxHF/VOK4Pypx3B+VOO6P
Shz3R/k890cl5o9xiyf2nHl47g/MH5g/MH9g/sD8gfkD8wfmD8wfmD8wf2D+
wPyB+QPzB+YPzB+YPzB/YP7A/IH5A/MH5g/MH5g/4vtM/sD8gfkD8wfmD8wf
mD8wf2D+wPyB+SN+H8kfmD8wf2D+wPyB+QPzB+YPzB+YPzB/xO89+QPzB+YP
zB+YPzB/YP7A/IH5A/MH5o94f5M/MH9g/sD8gfkD8wfmD8wfmD8wf2D+wPyB
+QPzB+YPzB+YPzB/xPuZ/IH5A/MH5g/MH5g/MH9g/sD8gfkD80f0N8kfmD8w
f2D+wPyB+QPzB+YPzB/xeckf8ft7el7HK7ZalJ1b+/KPz25SEush+NrOe7yy
2VfVwdpj7a+7aNU1zQ/MfYS1L3Lx82v997/887Dy4t/veRMmja1zzQaLsrY3
T1owYaOS7MX2R3TddG51sPJGL/X4++qsVifl2N9bbO/ztS9+vvbK1VfueZ5f
/HzPu6bxhyN/6lIS3+dJf7SqN/uinPd5c8QNM4bnvNkdVcunTMx5q+u7HXjr
9lXBFce8OX5A55y/bdZ8x8svyHniktseOv/unL9o+encl1eVZHtscGL3nTut
+/+vanPcs9stD75zxqiPHjks5/MfrXXAiPNz7nxx35fuuCvnGzds+tNTb1QG
n/HDoOMf+iHnDuMWfnx3Tc7+fvyvBgc80P+b5VlZ/X1//OvCkuzn+U/Wu6gi
58mvbDDo7G1Kgx+96dLSHlnO1x3/XZ9u5+TcY4fsx8PvyHnfFWOO6/Bizsfs
OHaHuT9VBLcq2/ShWf+qDN7g42vqf7Jzzn888PONk4/K+aM+XcomXpLz0/u/
0nfciJx9H3j5yKsPaLmiNHu3YdM+Lz1Qks08b/5LzZuuCH55vyO2b9Ih57s2
GP9A/TNzvuD7JhvVHpxzlxduGFQ5JuedB/xRunRGzusdc+z5fyzN+ddt3vjx
x0Zlwe8vbtb96/1yfnzyrVOn98z5+nsWH/D+oJxPPfPfL78xOuf927y7/UvT
cm7yr50eHL0o5xVf3bXRww1WBn81esWg4W1zfuXK01bcdnLOdx/+0fkDB+R8
UZPd513xRM5HLbyv+wUf5rzrW9VTz1yY8/pDerc/eaPy4N9OmfFy19Y5f9Cq
7Q6HnZDzk9UPP9j+6pxv+Oxf9ds8kvNpj11w4y7v5dz+kq9WNFuQc9OO7ftu
XrcieGWDp+fV2y3nb37e8Pha3XJ+dcJlH5dfnvPwm79vv+SBnC85odP4397O
2e8T6w+Hdfrn6+MOKc3mHvrSrmeenfPI369v2PWFnLvffkzVActz3qjlNgt2
bv9P8LRPF81odHPON130zsS103M+aJOhjy1uuDi4fPypt/1wSs6vdW/Vb9pT
OV9cWnnyxL9ybjlyevZUmyXBC/Yd1fLua3N+4rvzNxswJedTrtu/us+GS4Mb
b7PBbyd2z/nLd+d81mlUzkN7jXl9z19yPrzW1Y9v3XJZcK3RnW/f4LKc3zms
yaVlb+V89R+/9/h1bc4PH9azxZ87lgTrn7H+Geufsf4ZL+txdp+3vstZf4v1
t1h/i/W3WH+Ldzx4VotBr+Ss/8T6T6z/xPpPrP/E+k+s/8SbT20wde+ZOevf
sP4N69+w/g3r37D+DevfsP4N69+w/g3r37D+DevfsP4N69+w/g3r37D+Devf
sP4N69+w/g3r37D+DevfsP4N69+w/g3r37D+DevfsP4N69+w/g3r37D+DfMv
5l/Mv5h/Mf9i/sXiESweweIRLJ7C4iksnsIj3ltSv9erOV86/KSb/v1tzsee
Nbns6Kqcd9975wsO2bY6uF7tu3/a/5Cc//y67PjW5+X88TOnT9vpzpyf6T/1
wG1ezln8XHyfRl700+t7fbgi3ifsfcLeJ+x9wt4n7H3C3ifsfcLeJ+x9wt4n
7H3C3ifsfcLeJ+x9wt4n7H3C3ifsfcLeJ+x9wt4n7H3C3ifsfcLeJ+x9wt4n
7H3C3iesfz/9svezFYtXRP+O9e9Y/47171j/jvXvWP+O9e/Y7xF7v7H3G3u/
sfcbe7+x9xvz505XPT3jzaZl4U/Mn5g/MX9i/sS+X6z/wPoPrP/A+g8sXlh8
3eCTBhxaFvECFi9g8QL2/4v1P1j/g8U3rw8675eDLymL+AaLb7D4Bvt7sf4L
67+w+Gvg4C4X/WtUWcRfWPyF/X1Yf4fFf4cPaVU+9cOyiP+w+A/7fCy+3Pju
+jcPWVIW8SX2fCxenT1iSf2uW66MeBV7Hhb/PvbgzAc3PWxlxL/Y87D+EOsP
sf4Q6w+x/hDrD7H+EOsPsf4Q6w+x/hDrD7H+EOsPsf4Q6w+x8cO5j766/TeX
5N8f5ivMV5ivMF9hvsJ8hfkK8xX274P111h/jfXXWH+N9dfY+GqPp+5/6cFR
K2N8hX0/WP+L9b9Y/4v1v1g8gH2/WP+M9c9Y/4yNF8uevWr/nh/l/z845l8S
8wvmF+z/D8d8SmL9PTZ+ffeFHh9uuzT/e7D+GvMh5kPs78X6d6x/x8bTt45v
f+yvW5bH34P5BfML5hfs78XG710nbvP9s4eVx+dhfsP8hn0+Fq9i8wWNJ9X0
7tsv/zzMN5hvsM/Hnjfv3Z+X7P5wefgM8xn2fCw+xuY3nv3gg2uXfZQ/H/MR
9nnYfMnF055Zb+LS/HmY7zDfYc/Hntfus9vuuXqrivAn9jysP8f6c6w/x/pz
rD/H+nOsP8f6c6w/x/pzrD/H+nOsP8f6c6w/x8Yr2PzV6pnnb3Xg4RXx/WG+
x75PrP/G+m+s/8b6b6z/xv49sP4c68+x/hz7/5k6+6hna/pVRPyC/f9gvsJ8
hfkK+//FfIGNl3HMZ/2w+14fPJz/PTjmVxLH/ErimF9JHPMriWP8nVg89e/5
m7xz69T88zEfYT7C/h4sXmv227LDj1yWPx/zAfZ8zA9YPPi/fLvKeD7mH8w/
2Odhz3vpv+s3leEH7HlY/Nh/+QN/3Hdp3h7zD+Yf7PlYfHpQ+TWXnfxI/nzM
F9jzsfZ1Vp26aquPK8M3WHtsvILFt5+v7XD7T8vy52E+w56PtR9Zp/lmT29d
FT7C2mPx9en1aj127jrPao+1x3yGtd+pwYJdWl5WlY/3Esd4L7H2WPvFjaa+
+s8jeXssfn+96ZiDXvk4r4/5EGuPjc+w5w1sNuSTK0ry9lh9rP7h2194wn7b
VIePsfZYe2w8svEuXX+q6lwdz8Oeh7XH2s/erXXfyZfl9bH6OMY/ezVccdOj
eX2sPlb/3HalNxw+rTriA6w91h5rv0f72RtuuDxvj9XH6pcd/Ob9n22zKupj
9bH67x46qvnwI/L6WH2s/q1dBrxwwuV5faw+Vr9r19PbbfHYqjxeS6w+Vr/x
8R3f/2Haqjw+S6w9Vn/eSS2Ofnx5Xh+rj9V/tmftb89qtjrmL7D6WP2Lz/z9
zJ26rI7fI9Ye62/anTtt0Z+X5+XY73N137FXvfjY6oi/sfZY/amXDK116Ser
433H4nnsecXyYVdcfFfb0tXxfv/7mm5blDerifEHNp+Mtcf612YD2zz9dpea
3FeJPQ+bz8X6v99varTHDVfUxHwY9jysPQ5f3Vb2ZqfHa8Ln2HgOez42/4I9
H/Nn/6FzDqkzvSb8icUr2PgS+3uw+BH7fCyeOGj4pM8/Ka2J+Awbb2PxE/b3
YPNV2Odj8VKdkY/0uGvbNREvYfESNr+LxZdYfIn9/dh8Gvb3YfHi56MGLuh2
5JqIF7H4GIuPsfgYi4+x+Bgbr2DjC2x8gY0vsPEFNr7AxhfY+AIbX2DfLzZe
xL4/LD4d+XivSxpduSZfP0gc6weJY/0gcawfJI71g8TmV7G/B+uvTx/dqfLb
x/P62Hhnp+d3GPzw9DX5/HDiiE8Sex42Xl38Yp0GZ6xYk88nJ9a/Yf0l9nnY
+Pz1CQtHtWi+Nvo3rH/Dno/5ZOAb03f8/ci1eTyTWDyE9V9Yf4h9PjZ+PPyd
ceOfv3JtxI9Y/In1v1j/g/U/WH+I9YfY34vF7xu/P6z9RU+sjf4WGx9g/SXW
X2L9A9Y/YP0b1r9h/Rv2/4vN78z+qN/U1p+ujf4UG59h/R/W/2H9Hza+xfor
rL/C+iusv8LeN6y/wfobrL/B+husv8H6G6y/wfobrD/H/r2w+b/Hpnc/rnTF
2nx+P3HM7yeO+f3EMb+fOOb3E8f8fuKY308c8/uJY34/MX9j87Wv9dlqSc9N
a3Uy/4z5EPMx9jxs/n6LC4a+9u5OtTqJB7H+EeuvMd9hn4/FY/JBxUfY+BTr
L7H+F/t7sPkT+ZLy/7H8fyz/H8v/x/rjIst/lF9czO+cXmfB0I92K4nzVpTL
Ny7md8pHtb/A8+0vwPYXYPsLsP0FWH9dZPmN8qmL+aD31pva5I6TSuJ8GeXy
q7H9Cp5nvwK2XwHbr4DtV8D2K2D7FXCsPxRYvp3882K+6CkNxjx19E0lcR6P
cvnoWD46lo+O5aNj+yV8vv0S2H4JbL8Etl8C2y+B7ZfA9ktg+yWw/RLYfgls
vwS2XwLbL4Htl8D2S2D7JbD9EpH/mPZLYPslsP0S2H4JbL8Etl8C2y+B7ZfA
9ktg+yWw/RLYfglsvwS2XwLbL4Htl8D2S2D7JeL7SPu/5P/IP8f2g2H7wbD9
YNh+sMg3SvvBsP1gkT+V9oNh+8EiHyztB8P2g0V+W9oPhu0Hi3y9tB8M2w8W
+YdpPxi2HyzyKdN+MGw/GLYfDNsPhu0Hw3yA+QDzAeaDyLdN+8Hi+0z9deTf
pv4a66+x/hrrr7H9YFj/ivWvWP+K9a9Y/xq/j9S/Yv0rth8M69+w/g3r37D+
DevfsP4N69+w/i1+76l/w/o3rH/D+jesf8P6N6x/w/o3rH/D+jesf8P6N6x/
w/o3rH/D+jesf8P6N6x/w/o3rH/D+jesf8P6N6x/w/o3rH/D+jfMx/F+Jv9i
/sX8i/kX8y8Wv2DxChavYPEaFp9h8Vn0N2k/GLYfDNsPhu0Hw/aDRb5n2g+G
7QfD9oNh+8Hi89J+peL7JH/Q+K/ykm4DRny3It4v5d4v7P3C3i/s/cLeL+z9
wt4v7P3C3i/s/cLeL+z9wt4v7P3C3i/s/cLeL+z9wt4v7P3C3i/s/cLeL+z9
wt4v7P3C3i/s/cLeL2y+oMjyKfX/2HzKlCvarH9S7bLwgXI+wHyA+QDzAeYD
zAeYD7D+AOsPsP4A6w+w/gDrD7D5pyLL3+RfbP5ryDWN7t1yz7LwsXI+xnyM
+RjzMdYfYf0R1h9h/RGO+cQCyw8Vj2Dj1e4Dy7ae16Ms4hPl4hMsPsH6O6y/
w8bfRZY/Kr7C8iu2vHnOc0/eUhbxlnLxFhZvYf0p1p9i8w1Fln8qPsTyFX65
bVKbc14ui3hRuXgR65+x+ZMiy1cVv2Lr/2OHPvKfXdb1i+JZ5eJZrL/H4mX5
reZPLhs+8IhFtVdG/Kxc/C2/1fraASN7ffXynisjHlcunpffaT6o1sOdTr/8
lJUR3yvXnxfzYdXXvyvXv2P9O9a/Y/071r9j/TvWv2P9O9a/Y/071r9j/TvW
v2Pzi0WWH2q8hOWDTn98hz/bDV4ZPi7myyrnZ+X8jPkZ8zPmZ8zPmJ8xP2F+
wvyE+QnzE+ajIss/Nd7E5jPvHV3nisqXV8b4Uzm/FPNp1ecb5XyDxUtYfIT5
CPMR5iNsfaHI8luNr7H81lOeX7j6P9+vDL8W822V861yvsUxH5WY/zDfFVn+
q/kAbP67xUvT77hxvfKIH4r5uMrFD5FPm+IHzHeY77D1rCLLnzV/geXP/jVh
XKPDWpeHf4v5usr5WDkfY/OvRZZfaz4FW3+Z8Mawx+ueWh7xQTGfV7l4Qbnx
BI58kALLxzW/U8zPvfadfi1nDC4PXxfzfZWLb5SbPy+yfF3P7/R+94l3jy+P
eKGYD6xc/KDc+AdbHyiy/F7zWVh+74ZT23Y8/ofyiGeK+cLKrTcox/J9zZ8V
839nTW/8aeM6FRFvFPOJlYs/lIsniqy+54/6ovzE71tXRHxTzDdWzo/FfGPl
fBn5uMmXmC8xX2K+xHyJ+RLzJeZLzJeYLzFfYr7E/Fhk+bm+T2x+tJi/e9bX
389/9NSKiC+L+cjK+bCYj6ycH5XzI+ZHLN7BfIn5EvMltv5bZPnA1ueUY+Xm
h7H4tJjP3PK7dy4489aKiB+K+czKxRPKxROYz7H5HGx9usjyjcXDymO/ayqP
+dnE8j1KfnysbIdXKvL5wkI+tPKYP0zlMX/oeeaXEsf+4wLLZ475lVRuvKDc
eGHSL4NuXPhDRcQbxfxp5eIP5eKDIst/Fv9j+c//O7+6MuKfYn61cvGA8shP
K7D86P97vnOe7/y/8+oqs/97HnGeL638/55PXBnxRZHlV3t+w2U7tdi7Z2XE
P8X8bOXWU5Vj+dXGV9j46vsVdV8su7Uy4pNi/rZy8Ypy+TBFlo9tfFXMz36q
8q99J71SGfFSMb9bufhGOVbueX1rZky5fm5lxCvF/G/l2svXNj4s5m+3qf3y
Mdn6VREPFfO/lYt/lGP53Z5XWXf4nNptqiL+KuaHKzc/oRwrN/4s5n9PqX/5
2dN65s/D2mP1hzQ8cfGdt1Xl8zOF/HHlMV+S8sG1795k32uOnZDXx7EfN9XH
yo2vi/ngW27dtPZmP1ZFfFjML1fueVj7X5pXDZu9fp4PjtXH6o/d8cemo9pU
R7xXzC9Xrj02ni/mh1/WcvLo007L22PtsfoH7PnkntvdntfH6mP1a/33wK28
PlYfqz99v3MOG/NjdcS7xfxy5dpj7e/t0PnLC+rm+dtYfaz+KZ12PXXPvfP6
WH2sfovO9X4vOS2vj9XH6v911D/9Xr89r1/MD1eu/oRuX1Rd82qe760+Vm6+
rph/rtzzrj3xlVs7zMvbY/Wx+p1OGbHp2rqro34xf1y5+hueceUjH+6d54+r
j5UbDxXz05V7nnxy7Yv55rPOPmnn20/P88eL+eej+uw/4ag7Vsf7rRzLPzff
qlz/qr3nnXXRVh02eS3PT9ceKzefW8x/Vx7nKaV89TgPKLHxcjG/veVlqz6e
NS/Pby/mu5f0/6n7yA1q8vOEUjku5rurr738db5RHyu33lbMr5903fs/9mhb
E+N/5fxRzI+/adDTfbY5oyZ8p5yviyw/3nxHMT/f88Rzxfx85T5fPrx8UM/H
yuM8/EI+/5GDBy+ff0f+fMzn2mP58OIP5bEfrcDqm38q7gdoOOS8gaNfq4n1
EeXWD4v7AdSP/W7p+bE/LeXPi/+Ui/eweLfI2ptPK+4n+H5Ylw36/FQT8bly
8+vF/QTqix89H8uvF48rN14osvrmL4v7EZ4a0eq+VhuuifGPcuMfbP22uB9B
e/G7z8Py241vlBvPYOMZLD+3yJ5nPFrcz9D3wfrbLmm7Jsanyo1PsfWU4n4G
7Y1/fB6WL288qdx4EhuPY+NvbPyNjb+x8Tc2f4Ll3xbZ32e+o7gfos2jS56f
cMaamP9Qbv4Dm//A5j+w+Q9s/gNbD8bWs4r7Ifw9xp/+fuP7ItuPEOvlqTzW
yxPHenniWC9PHOvlic3nFfdLVD45s23/IWtivsXnY/sbrBcqF99MefbVyftP
XBPzN+qbfyuy/Q3iheJ+iyEv3H/kqp/WRPyj3Pye9ubzcJzXU2D7Ifi7uB+j
+/irvnlvw/z+ROXmS7UX3xXZfgh+LO7X2HJij1637JPf36jc/Jf22H4G80PK
xcvY+AAbn2DxR5E9n2+L+z9+eav935175fdRKjd/p7353SLb32A8qdx4FYsP
sHigyJ7HL8X9I+6z51Pl/In5Hpsf93xs/4D5BuX8js13YH7F/Ir5tMg+T/9d
3H9SvO9aOZ9hPsN8ja0/+DzrL0W2H4F/lZv/wnyH+Q7zHTZ/ifkF8wvmF8wv
2P65Ivv7+aG4f6V4P61yfsD8gPkB8wPmB8wPmM8xf2PrY/5+64tFtr+DT5XH
+n3iWK9PHOv1iWO9PnGs1yeO9frEsV6fONbrE4vPi/tbivet+vutF2Pr6UW2
30Q8WdwPU7zvSbn1eu3lQ2DjtSLbf8Lnxf0yxftElIsfsfkkzzM/hs3vYfF6
kYvn1Rf30xTPry/un7EfhS+L+1/sb+GP4v4S+0difbuwX8N+DP1PMX9N/iKf
FPO35K9FPFDIh5K/5f+vmJ8kH8r3X8wXkp/k91HM75Ev5H0t5n/If/H/V8x/
kN/BN8X8AfkM/v+L6/fyA8QnxfVz6/Pik+L6tvXxmC8qrD9bv/b7Ka4XW1/2
ey+u71of9nsvrs9av/X9W0/1fRbXB62H+vfB/FZcT7O+5/0vrqcp57vi+pX1
Mf/+xfUr5ZGvXFhPsj7l37e43mN9KOYvCusz1nP+7/16+XqK9RfxY3F9xPqJ
+LG4nmH9w++nuB5hfcHvp7geYL3A+1ec3zffHvmDaf5c/Gt+U3xanM80nyhe
LZ5PYb7PfCA2n23+Tv9UnO8zn2e9oHj+hPk18S+O/SxpPi32YxTm14rzaebD
xLPF+TTl+nvzVdaTivNfxfkr801x32hh/ko5fxTno8wHxXpcYf5JufWv4nyR
+Rnrk8X5IOXW64rzN+ZLxIvF+Rrl1iuL8ynmJ8SLxfkR5dZXi/MXxtvineL8
gXLr1cXxt/Gw9fjieNh4Vz5IcXxr/Br5u4XxqPGmfJvieNJ40XjQeMzvuzie
Uy4/pjgeMz7y+yuOr5TL3ymOh4w//B6K4xfl8quK4wnxtvmgYryuXP5aMd4V
P8ofLMaHxfuTi/Fc8X5L8VH3S/t+d/NuVdmDg1uNbdSiJHtzdZsBT7xXmfUa
Un+fOUeXZLc0/fD97xZWZLvcvWTyw1eVZE99vtfza+9akU1b/MBDv3y+Ivu6
/53DTzqyNLtn+TU7PFuxInti+Nbf3nPZ8uzk8lNfPn+HsmyXrtev98YvJVnz
VR0O2P3Ysmz8hvP2/rF7SbZw7bYfLb2mLGu1x1EvLPt0WTa+Tq1ur40uyyqP
mLu0ZenS7Op6C76/6ouy7Jb1Omx7XO+lWccGU89pX1mWbTzl0WOu+npJVnfz
MUtX77Aye3Dg6usePXRJ9mXTIddNOXZl1nXlwfs8taIs+Me5e4wYX704e7DZ
hXVuvXZldnq/tcMXf7Mi+LyH7n5/9oWLs17bdx3e5ZmVWd2elUc1a7EieNzK
yXP+3GFxtssurbeu/+XK7OI/pyw+4PXS4GUnLl1SPfefbOluDZ/7ct04wPeB
273WfP0G9/+TvblX6V737bhu3FX7hLZXzFsefF3D45ptf8w/2aB2s985qVt5
NvCsW466beTy4Pf63bhPu/X+yY5o/2bnra4rz6a899pZo7ouD66z7W/XvFhn
edag46hZ854pz9b74pWju/xnUTbn0AGnPfVleXz/+Mjdfzm755WLsie6nL7w
nKry7MJxL249fVRJ8LAfDhvzVf+SrE/XjpfvulNFttu0555/sOnK4LvvbHjd
Jbsvylof32L1om4V8e+JZ7/6xNnTzikLnrV//8m/71GSlZ9U+47x11VkB2bn
1/lt3e8El/bZ+KilG5Zk7/X8fbMrnq2I3xf2+7j9zGmP7TuzIvt9t7Pea3T4
iuB+Q6+bUvuWZVm3c8fuWlVVEf9+eOJfL3zX5MBl6X2ozI6e1PLsvb4vDfbv
Of+Siw++6bjK+P2NuaLb9MMGVGYTOi9fr+vFpcEHP7dR3YPGLc36XdPmxA2e
q4x/b1z2zPbbnLlTabbfwEbzZ8ysjN/vmpvK+t5TXZlt8c3bY/rWKg32e5h2
25wVx+9clX1y9kXtem+9NLtn6KRBTbpXZT33XjT5+knr3qfhj9T7YUBV/P4X
juq13VmzquL3gr1/V4/eYd8/d67Ojm/+ee8hQ5dkHZ+vM2Vc9+r4/Tz4xriz
Vs6qzqa/tsELp71TlQ36onHTT8asyhb9+mS78x6syub8+M5bm+26Ott4swOm
9LuiKuvzx6AvRg1cnbXuNOuYa7tVZa0XnXXK6c+vzvQf5UsP/W27r1dnI78Y
tXTkgsrs9sq6VWN2rYn+pFvNX4MvPKEm7rfC3+/+6fpj18VpW9T+rEHrG2qy
ZkOrmv3nhMpsft2XH17+fE02t+/877Z8szr4rL9atftyo8psTP3hO73xdU22
+qGrz9nhvurgaVeVzln0xLrfRcPLX7m2piZr/kmDZbv3qw7eY73/XLfBPhXZ
fk1OPPCgluv8WD5mwL5HVwcfNHDgnBM3L8/WbLXvx2tPWJP13jmrm+1SHXzr
v78bcWTt6mxa86bdP7phTTZm8KXbnjC/Krtnx6q5t49dE9/fyS1/PO/ob9bE
99V8z8klm6xZ5/Mnap1zV92qbOHeT17/Vcu18f2M3+/mug+cuM4vb48YO7V1
ZXZ1h3NGnDJonU+eHdq7bEBF1rFT52bNXlgbf1/dzrs+//M3a+P7/PKoem2f
WbM2vo9jnr+q18TGtTr5+195YeGOTXar1cnf6z6wgVUXVV9wa1XcF7bg9naP
375lVVZ92yOX9P//9xQ3rsmeeaky+3DowMr9zyrJGu91z23zZldkQ4f3Grxq
aEnW9vdVF9cZsCLbbVndMw5dsCI7d9hJJ/XcrzQrXfHXn+tvUpa1eX7hI/f3
Wp69Uznjik/3L8smndPl07e/XOeVmpdqhvUuyzq1GFvxc8eS7Ojaw4d0v7ss
63rar+2qnluWNdrg8s0bTyrLtrn6igFtv1yaza1/4hPfLSjLnmv7zdhTOi7N
Rjfct9Wjm6zM9lq2z3eDxi/JLmzS9PVeB6zM3n5x5PrPNV+Std26quMO56zM
5m+8UdWzv5YFr6n3cbNJcxZn1c1//PSPu1dmS2/77KTlH6wIHjJt52PmH7E4
+3DHyf9+YdLKbNTlUzfdvsGK4C92Orn38jX/ZENbPvnzxb+te96aYa8dPLo0
uNHg26+r89Y/2Ql73nxhmwbl8X3gHr++eW/TS//Jtm57zsoVB5RnM7ZqXnn1
jOXBj2V/Pr/brv9kC/brfNNb55RnDa7ttunQW5YHnzBn0C6PH7g8G9dh1/rX
31Oe/fp40/cP/nlRdkWneg92fLs8e7DdKwdPKC0J3mV1lzndH1qUHdj5nxa1
fy+P7x+v/uCaXz6/vSSrffQXL37coCK7qOe1S845blE2o9sr+93ZviJrvnzT
i+f0Lgl+96fLL3l0/ZXB7p+778QRH3Q9tyL+PXGfTy/c9bPjy4J7H9dp8N9b
l2Q9T7mya8PhFdnnJ+8z488/VgRvUDNh24VLlmU7nHHSd9+sG/f6fWG/j0Vn
79/7od8rsqsP3ePWpm1XBI94e7OuG/daluKjyvj3w/Nmlu3SblppNuC/8U9l
Nqfpoedst8Wy7NDLfqq94NzK+PfEfn8bXfX+3c8Nr8wOPWPyp917lgb79/36
uqe3vOCdyuys2aNHdL59afbIoMHP7PHHun7wP0t+OadRafDYRbddfMnS5Vnv
wee1Llk3zvV73m1Il7cnHlgVv4fSYa0Ov+a8qmzRvetNuah8SXbLg0tOXbOu
n1585JuDbxqzPNjvo9FTr156W8PqeB/mPnt/9ZEdquP9azux/aP3/6c6O+DR
Dr+d/HlVtvVnzxx/3ohVWc8Z3/Q7a2xVdsUPR5W+stnqTH9Q+7dNNtz//HXj
x5Z1br/yrHV/15/L7qsesW482uOxzW44qCq7b/FX27737uroL3Yof2Cfzo1q
sl3+OPf1h2dVZouqr3lvw4Nrov94be2pR31+fk124WEPfPbSkMpsQJ2DZg+/
rybrfHyjRo2nVwePf/rjBe93Wvc912t+5omTa7KLbxr3+LbPVgeXrl1Z9XVl
RbZRg1qLtvirJrvnlUNb7XpTdfApd7/32LJhFdnXjRb0n9toTTZh/tzX25xe
Hfze1ndkG29fkT3SdOraxw9ek329yZWdDjygOvjL+4987JR/lWe9m40Zenbf
NVnZQfU/P6xxdfAWFz/T49iSqmy37Yc02fn+NfF9lu584VN/TV4T3987u3Xd
/aW/1sT3dcterd+8dPO1WZ03P295b9m6OKRdw0P26bg2vp9G7Us/K++7Nps1
64x+nzarzOYePPvkd+5fmw149+SWVX0rstGHvvnrDe+tjb/vwi6jLj7k77Xx
/W21y+Tra29Uq5Pv44aWrQ85d7tanfz9v+z2ZN1p7Wp1Eo/p7/UH4n/xov7f
7814QDzCB94n4wPxFT/49zJe4G++8H0YP/Ajf/h9Gk+IV/jE/5/xBd/xi+/D
eIMf+cb3Z/wR93Mm//i9GE+IH/jE/5/xhP8/PvF7N54Q7/CJ/3/jCf//fOL9
M54Qj/GJ35vxhPiDT/w+jSf4n0/8no0nxDf84v0wvhAv8Yv3y/hCvMUvvn/j
C9+n8YTvk0/8++D9eu2y2cIJFTGeePaInsf8+mFF+ET/oFy8qNz7ZLwhvuIb
//7K/fsrH3bFnj3eXOcB45HqnmePePXqyvCRf1/jEf++fKQ/NB4RH/ORf3/j
Ef/+/KR/NT4Rb/OT/sX4RLzJT34/xid+P3zk92M84vfDT94/45N4/0bUn3ng
vVXx+2o+cuDIx56rivEFv/CP8YXxCd/wl/GG8Qr/GN9gfjMe0T9h/RNf8anx
ivFTz+UTx9785+oYf2G+fW/FTv1+W706fI2N3/jOeI3v+N74x3hQOd8b/4gn
sPEmXxo/8mOL1jt37DKoNMZL92xx6rWH3lsa5eIP4yXjVf7UXyvXXysX7xhP
GQ/zq3hLufG4cvGU8ZbxN/+K55Qb7ysXvxmPGd/z87hdH+04v15ZlG/ZcOa1
P2xTFuXiQ+M18wf8fe2Nh5w8ZF0/rnzh+VfdO/jMlVEuPjW+40u+F98a75n/
4H/xtPGf+RXxgPjceND8jfhAfG986H0SL4i3jRfNx4gf/N6V+30rNx4wvjRf
JN7we1Tu96jceMN41PyU+MTvQ7nfh3LjH+NX82PimVoHjb51/OSyKO+305z3
XphZFuXGX8a75ufEP8Z3xr/m/8RD+g/jYf2B+Mjv3/jYeoL1ZeuFxfuzrS/7
fYiv/D6w/ZJxv3gaXyk3/4atX6mvP1euP8fef38/v2Prn5jvsf4Cmy/G1gN8
nnw3bH0Ny4ewfsOv+jds/cf6gfV3bH3e+cLKsXLrgcqx8jhPP63fx/6JtL5v
vU45Vm59TjlWHvdBpXKsPO5/SuflYfkDcR9UKsfK436oVI6Vx31RqTz236dy
6/XKsXLrxcqxcvnZyrFy5z3c2qSq5NIpObfYfMjuDV7M7wNXjpVb31KOlTu/
VzlWbj+scqzc+b7KsXLn/SrHyq3XKMfKnReiHCu3H1o5Vu78XeVYufU75Vi5
83mVY+XO61WOlTu/VzlW7jxf5Vi5/DLlWLnzkpVj5c5PVo6VO09ZOVbufGXl
WLnzlpVj5c5fVo6VO49ZOVbufGr5PVj+j/dBOVbufVCOlXsflGPl3gflWLn3
QTlW7n1QjpXLX1GOlTuPWjlWLp9TOVZuv4JyrFw+jHKs3Pm4yrFy/an8Kiz/
Sn+qHCvXnyrHyuUXKMfK5Rcrx8r5QjlWzjfyv7D8sLgfKJXHftFUbr1cOVYe
5/Gncqw8zudP5ZGvnsoj3zzln8V6f8pPEz8px8rFR/LTsPw1+VbKsXL77Z0v
heW3yZdSjpXL33DeFHa+lXjQ+VLYeVXyY+TPYedTxX1CKX8u9o+m/Do+UI6V
84FyrJwPlGPlfKAcK+cD5Vg5HyjHyvlAOVbOB8qxcj5QjpXzgXKsnA+UY+V8
oBwr5wPlWDkfKMfK+UA5Vq4/lx+J5U/qz5Vj5fpz5Vi5/lA5Vq4/VI6VO29f
fiaWvynfRTlW7v4G5Vi5fELlWHmcf57yPyO/NuWH6g+VY+X6c/mhWP6o8YBy
rFy+m/xRLL9Ufyp/FMsvdV+J/FAsf9T7Kn8Ty//0virHyr2vyrFy76tyrNzv
XTlW7veuHCv3e1eOlfu9K8fK9bfyYeWzxvk/af7X/LD4Q74qlu8qPleOlYsf
lGPl3i/5rlg+rPGRcqxcfCcfFsuXNT5SjpV7P+TLYvm0/Oq8DONrbPwv38Tv
1fkT8jmx+SD5JfItnS8hXxOb35R/Evf9pPLYn5bY/LD6/Oe+QPmm2PzL+Mc7
jdtxVVXEA857MF+BrV/IbxH/OO9Bfm3cJ5jmm+W/eL5yz8eer37ct57uD5Rf
h81X131p4dH9rs+fr9zzseerH/evp/sG4zzKxJ7/5YTp3+49Jn++cs/Hnq++
5ztfwvOx58sH8nzlno89X33zI+4vjPs7Epu/7PXOsH8mrcqfr9zzseerH/Mx
6b5Dz8eev8v7/a4euMuqeL5yz8eer77nux/R87HnL/2o+786HZ8/X7nnY89X
3/Pdp+j52PPfnN522HoD8/My3I/o/cLeryO+Ln966Fer4vfvfkS/f+z33+C7
7/fotnpV/B7kn/s9YL8H6zHqux9Rfaz+E788dui3x+fnNTjfwfuOve/yxfi3
eD4Ett5l/cV+AfnjWL65eNx8o/xwbD3F+onzpuRnY/nd5r+UY+X6a/nZWH63
+Es5Vi7+k5+N5XcbPyvHyvlO/jaW321+SjlWbn5KOVZu/KEcKxe/KMfKxe/K
sXLxu3KsXPyuHCsXvyjHyuN8pJR/Hvs5Un66/V/yz+N86ZSfbvyrHCsX38lH
x/LX7V9RjpXH/bgpHz3OR0r57OJL5Vi58xnlo2P57PZjKMfKzT8rx8rFK8qx
cvG5fHYsH979csqxcu+bcqxcvKYcK/c+KcfKza/Jp8fy7b1vyrFy8aByrNz4
SzlWbn5NOVYunlWOlXuflWPl3iflWLn3STlW7n1SjpV7n5Rj5cYHyrFy4wPl
WLnxpf0K2H4G8yP2K2D7GezPU46VW8+yXhf5LYmt18p/mnvfz//+aFzO8iuw
+Sz7R7H1Jeu78qes72L9g/ZY+/7rN31tzBZ5/QVLjl78dMucrQ/Lx5JfgeVT
YPknmC99Pvb58lF8nnwUbL7Q+hq2vmX9WX6Y8QY2PtEeay/fQn35Flj/pT3W
Xv6F+vIvsHxN+WrWu7H8CiwfFMv3wvKLsPxFbH7D3xvzHenvlV/k75NfhOM8
7tQ+9tOm9vKP1I/8ssT6W+uROPYrP3X6o7styvP1Wt5577c7r85Zf6w9jvvn
Un6t+vZf4JgvSu2x9vIF1JcvgGM+KbXH2v9785GVm5yc1/9w1Sdt6/XN2X47
7bH28lHUl4+Cjee1x9o3fOOcX6sfz+sPevyhbcpfyVl++dIRM48846mSyHfG
8lnwkMraE2fvmbP8aXz4I18/+sFVOe9w0YENJz2cs/wJLP8dy9/Gj4z/4dcR
rXKWH4NP7v7CjEGX59xu+82yqx7IuVHptRMvejvnkg9/2bX3TznLV8UvnTuh
4XE75zx03y1v63xUzn3r3lTV4ZKcj/juz0vajsh5p7HHLWj5Rs61r3vr5O1+
yPmXo7b7rElNztan/Pth/37yEf17yUfE4m3tsfaP/bN0Yu3Oef2NZu+wtObk
nK1vaY+1l9+rvv0eWLyjPdZevrP69r9g8ZD2WHv5lerLr8T2X07tUO/IYVuU
BrfsOGCTpbuXRj5Sz/fbljyxrl+Vj4TFo9pj7e03UN/+NGz/pvZYe/lM6stn
wvZvao+1l8+kvnwm7Hx87bH29muobz8ftv9Te6y9fCj15UNh9xdoj7W330R9
+xGx/aPaY+3lU6kvnwq7v0J7rL39MurbT4nFc9pj7Q/ru3Kfz+7J67dof8bY
D17L2f5W7bH28r3Ul++F3feiPdbefiH17SfF4k3tsfb9jz136Yg+eX3zIdj8
ifaxHz+1l4+mfuSnJo75lNQeay9fVX3ztdj8rvZYe/mo6psfweZTtMfayzdT
X7yN7afXHmsv3059+abY+qv2WHv5purLN8X202uPtZdvqr58U2w/vfZYe/mm
6ss3xdaftcfa2++kvv2w2H587eM8/NQ+9lOl+vJVsfxE7bH28hXVl6+Irb9r
j7WXv6i+/EUsf097rL3xl/ryZbH8Pu2x9sZr4Y/rNx/+3rs5m8/RHmtv/4v6
9r9g4zvtsfbGe+ob72HjO+1x9B9pvBf9TRrvYfmJ2mPtjQfVN5+MzT9rj7U3
foz+Ks0XY/NR2mPtjTfVl6+PzVdpj7WXv6++/H1sfKl9nF+S2htvqh/5/ImN
L7XH2htvqm+8iY0vtcfaG2+qb7yJzadpj7U3HlXffvKIJ9L6tfZYe+NX9eVr
Y/lL2mPtjXfVt58Ay2/SHod/0/g4fJ3202Pzgdpj7e1HUN9+BGy8qj3W3vg1
fJ/Gr9h4VXusvfGr+sav2HhVe6y98av6xq/YeFV7rL3xq/rGr9h4VXusvfGr
+sav2HhVe6y98av6xq/YfKn2WHvjW/WdrxHxeJpP1T7ua0ntY/9vqu98CGy+
VftYn0/tjZ/Vtx8Em4/VHkf8msbbEe/+st+SmVnO5mu1x9obn6vv/Asc+Qup
PdbeeD7i5Vvqznn3jpwjvyG1x9ob/6t/74n9jp74Ys7We7TH2psviPgn7bfA
1oO0x9qbX1Df+SvYepH2WHvzEeo7bwRbT9Iea2/+Qv0NH9qk2d0dcpY/oz3W
3nyH+vYDxXg25ddoj7U3P6L+1AN+qjNgcM7yb7TH2ptPUX90vc7XXfZ8zvLr
tMcx/kvzLzFenPvSkj6f5Sz/Tnusvfka9Xu92Lj3Gctylp+nPdbe/E6MN9P5
FNh6hPZYe/NB6m997O9HH71/ztYrtMfamz+K8cO2Xd/vdFrO1jO0x9qbb1J/
ztKJ++x/Y87WO7TH2pufUv/197cZu+czOVsP0R5rbz5L/fvuHdxsp09ytl6i
Pdbe/Jf6l539z71b/5Oz/Cvtsfbmy9Tv1vbE9TfbtCLYfJn2WHvzZ+qbP8Pm
y7THMX+S5s/UN3+GzZdpj7U3f6a++TMc+V+pPdbe/Jn65s9w3GeW2mPtzZ+p
b/4My6/UHmvvPJUYf6fztmI8mfLNtI/8s9TeeoT69p/juM8stY/zIFN76xfq
x/7oxNZ7tcfaW+9Q3/k92HqH9lh76x/qW//A1ju0x9pb/1Df+geWX6891t75
C+o7jwfLL9Uex/xjWl9T3/5ubH1Ne6y99Tb1rbdh+QLax30pqb394erLl8Hy
a7TH2lvfVN/+cSzfQXusvf2I6stHxPIXtcfa23+uvv3nWL6G9lh7+9PVlx+F
5VNpj7W3f119+VtYvpf2WHv7K9W3voydz6s91t75Feo7vwJbz9Yea+98BvWd
z4Dtj9Aex/x9Or9Bfec3YOfTao+1d76D+vJ3cdz3mNpj7Z3foL7zG3Dct5ja
x3m1qb3zG9SP8xsSG984f8R4BRt/YOMJbHyAxftY/I7F55/3WdXq4odybnPB
xcu+eGlFxOu9F+309aC3VkS8jsXn2ke+VmovXldfvI7F59pHPldqL15XX7yO
xefaR75Xai9eV1+8jsXn2kc+WGovXldfvI7jvpPUPs4rTe3F6+rH/v3E4nPt
sfbidfXF61h8rj3WXryuvngdi8+1x9qL19UXr2PxufZYe/G6+uJ1LD7XPu6D
Se3jfKNUX7yOxefaR75eai9eV1+8jsXn2kc+X2ovXldfvI7F59pHvl9qL15X
X7yOxefaRz5gai9eV1+8jsXn2mPtxevqi9ex+Fx7rL14XX3xOhafa4+1F6+r
L17H4nH9kfgai5ex+BeLZ7H4FJtvdF6T+UNsPhCb38Pm75yPj+3PNJ/nfCjz
edj8nfZYe/N56pvPw+bvtMfam89T33weNn+nPdbefJ765vOw+Ft7rL14XH3x
OBZ/a4+1F4+rLx7H4m/tsfbicfXF41j8rT3WXjyuvngci7f9HsTP2HqC876s
D2Dz/Tj2u6T9vth+WfP7zhMzv4/N52uPtTe/r775fSwe1x5rLz5XX3yOxePa
Y+3F5+qLz7H42/chnsZx3kw6H836k/3F2P5d61HOV7Meha0/aY+1tx6lvvUo
HPuHUnusvXhcffE4Fm/7/7H+6Hy3uF8r7U/G9hdbb3Q+nPVGbH1Re6y99Ub1
rTdi8bn2WHvxepx/muJ1LB73/2N92Pl01n/tn8b2P1sPdr6d9WAs3vY86+fO
27Y+bn81tj/aernz8ayXY/kAzuuWn+C8bvkSztMTT2LxIRbvYfEbFo9h8RUW
L2HxDxbPYPEJFm9g8QMWD2B+x3yNjTecF2i8gY03cOSPp/3k2H5i4xHnEVp/
wJFfntpj7Y1f1Lf+gCP/PLXH2hvPqG88g+M+qtQea288o77xDDZfqD3WXnyj
vvlDbL5Qe6y9eEh984fYfKH2WHvxk/rmD7F4yr+neArLf3I+pPgDiyew9T/7
y3Hcv5PWA50/aT0QW//THmtvvKy+9UAsXtEeay9+UV/8gsUr2mPtxS/qi1+w
+MT3EeePpvMzxZP2t2P7y8WXzt8UX2Lzg9pj7eM87FTffCEWz/h7xMvO77T+
bv97nN+U9q+Lp53/aT0eiy+0x9qLN9QXb2DxhL9HfOT8UPGP/fXY/njxkPNH
xUNYvOa8UfN19ttj++nN3zmv1PwdjvvB0378uB887beXv+I8U/krWL6o+5zc
74HlfxbP03beqXgIm7+z/x+7P8p8nueZz8PiCecDYPdHiS+cnyq+wPJvY798
uo8Sy6ctnudtPz2/Yn7F/Ir5FZvPcL8VnjW98aeN61SEf32++Q1sPkN7rD1f
q29+A5vP0B5rz+/qm9/A5jO0x9qLB9Q3v4HNZ2iPtRc/qG9+A5vP0B5rL95Q
3/wGFn/49xB/YPEHFn9g87Oex//Oz+VzzNd+X9h5DvztvF7+xuYftcfam49U
33wk5nvtsfb8rz7/Y77XHmvP/+rzP+Z334d4zXnB8kmcd4GdLyGecx6x/BJs
PVB7rL14QX3rg9j6n7+Hv51XHPk76fyLyN9J51dE/k467zjydxLzseeJR5x3
zI/Ot8DOr+BL5yHzJeZn519g98XxtfOS+RrLJ3ZfnPu4sPFN8bx/5ynzr/rY
fXN87LxlPsbyqZ3HYb85Nh4q3g/gvA7rZcrld7t/znkcWL528f4A5zPLf3Sf
gPU253+43w7zr/rY+SDyyd1HwM9YPrv78Oz3x8Z/zovGzouO88xSfffbYfGE
9lh78cTrTccc9MrH+Xkk2HyC+xKw+3Lk2x/96MzfP/ijKuIL55PE/dKJzU+p
j51f4u9R39+Dfb72WHv7C5x34rwFbL9A8b4H56HE/S6pXDzkPgjl2H6F0S9c
ddvGfapjPsd5Jc6rwOIt9bHzTDxfuedfOL5Hw1n35s93XonnY89THzvPxPOV
e777LZRj+z2cL+L+W2w+ovqtbXbpsTBn54+Yv1Lu+djznS/i+djzPny3ZsLW
m+Xs/BHPV+752POdL+L52POGfvBzh/kdcnb+iOcr93zs+c4j8XzseSdM+2Da
031ydl6J5yuPeD+19/vHfu/qY8/z97g/09+Dfb7z5bHz5bV3Xor2WP0FM2+b
1/LdnJ2n4vepvt8njvFGao+11z8q9/c4j8Xfg33+uNnnn794Yc5xXkt6f5Xr
z7XXn2P9t/rY87wvzt/HB87f/YYrD1od/Z/zXfR/WH+nPnb+i/wQ9Z1Xhc1P
a4+11/+5v1T/h/V3zvfHxfP93U8T+w/S+TPuj8TWE9THzqeJfJp0PwDfue+U
7zC/uR8Auw9Avg+2H0B77Dwb+wPcH2B/ALZfy3na8iucd+O+XyxfQn3sPBz5
/epj961a33PfgHx/bD1Je6y9+Rv1rS9h8Z/7WrH7WsWD7isQD2Lrf+4nMB+F
xa/uHzA/h8Xf7nvFzvsRj7vvQDyOzac5Lwg770d87r4D82tYfK491l68rr54
HZtfdj+C8RE2/vF87PnGQ55nPISNb5xnhJ1HZLzjPgbjHWz+Wnusvfls9c1n
Y/PX2mPtjWfVN5+NjW/d/2D8io1HsfUJbP4Emy/Axv/YeB4bv2P5Bf5/sP8f
43t/v3wDLL9Ae6y9+QD15Rtg+QXaY+3NH6gv3wDbz+h8Kuz8JetX7tewvxFH
vk5qH/k6qX3k66T6ka+TOPJ1UvvI10ntI18n1Y98ncSRr5PaR75Oah/5Oql+
5Oskjnyd1D7ydVL7yNdJ9SNfJ7H9lO5Xxu5Xtr7pfhH7K3Hcj5XuGzGf6D5m
7Lwr84vuIzG/iO2HdD+J9WVsPtT9JOabsfjBeVnYeVfiJfeZiG9wjKfS/SXG
e1j+redjzzf/7nnycbH5UPebyBdwPhd2vpb5cfenyB/A5sM9j6+x+RPMhz4P
+zx+9Hx+xPIttMfay79QX/4FNr/hPDHsPC/zHe57Md+BxQPaY+3FB+qLD7D1
GvfD8Dnmb2z+DfM15md/D/b38LXP52ssn157rL35NfXl12PnQTgfDTt/zPkQ
7r9xPgSWP6Q91l68or58Imz9T3usvfVA9a0HYvGJ9lh78Yr64hUsHnFfj/gD
my/F4gPM95i/MV9jvsV8i/kW8y3mU8yPmP98H9j3wYf+//kQ2x+jPdZefp76
9stg89va4/g9pXhOffPd2PkgzsPDzltzXoj7lJwXgs3Pa4+1Fx+pb74eyxfW
HmsvnlJf/jCWL6w91l78pb78YSxfWHusvfUu9eUPY/GH9lh78Yj64hEs/tAe
ay8eUV88gsUf2uP490vxiPriESz+0B5rLx5RXzyCne/ivD78v/n4Wp2c9+K+
Lee9YPkM7t8yHvU87HnykbSX/4/Nn/xvvj9n5wM6v8X9Xs5vweZT3Pcl/wrb
D+H52PPlY3me/RHYfL3zC7HzB43/3S9mPh1bP9Aea29+X33jfSx/zfmEo5/4
+K2Pn87ZebpY/mCcb+h85nQ+oPkuLD7D5oPw0pKjmz72SX6+YMMWv41+7pn8
vDrrP8qx8+usFykXr2HzHc7T2+iCZ/Y48ficnXeA/2pf/+mjrspZ/IKnbXRl
k04P5/xO/Xmnf7ssP89v3oH9/5r/WX5elvhBOXZ+lnhDufgAj5p32FefbZ6z
fBh89csvdv5w/5zlu2Dje+eZjey91Z6L5uVsvzy+Yp+bn/6lVn7em/3wuHud
v5t8t1POxue49bfdh35xZM7G33jjMZPWfHRxzsbXeNHVLa58596c5YPh6V2G
/Dnh9ZytF+MxW5ac9vz3OfMLvvXvHrMeX50zf+De77x/+MgWOfMD7nTXrm8P
PTxn/T9ufvrwPW/um7P+Ha/eo+Lpa4blrP/Gc2t6bdFvQs76Zzzpy2lDz52d
s/4XP/hk67U9K3OWv4D7X/bglcc3y1l+Aj7hkDV/dumUs/wD3KZRn9M7npuz
/ALc4LcvZrUbkrP9EXjxxH077/5SzuYj8IxbH397+1k5m2/AY09av/WWZTmL
n/Ahs/rPuH7l3/l+zilHHV4zMt+fJf7Eb454ddKKSTl7X7D3BXtfsPcFe1+w
9wV7X7D3BXtfsPcFe1+w+A+fWzF7i/UPyll8F/svph9016ozczY/h1s8/Oza
5YNzlo+I11ywcf+/ns/ZfmWs/4vPT/2t/Hz9LdbfYv0t1t9i40H87I9z79xv
cs7Of8HyBTDfYD6K/Pd0/hC2noydL4StB2Dr59j6PLaegXt1euCp1/7O8+tv
unTPPd79OM8fj/mUVI7lgzuPSrnzo7D7NeWDm//Boxrf8NuiH/P8cPNrWD6E
/G7no2H5CvK1nd+GrW/I3xa/YOtZ8pvjvorE+musf5dPazyhHMuvNf5Qrr/H
+nusv8f6e6y/x/p7rL/H+nusv8f6e6y/x/p7rL/H+nusv8f6e6y/x/p7rL/H
+nusv8f6e6y/x/p7rL/H+nusv8f6e6w/lv+sP8b6Y6w/xvpjrD/G+jOsP8Oz
b/ygaubAPN/aeZO4Y7dGf27VKs+3tv8LN9tuwGkNj83ZfAzWn8n/1f/J143z
pFM5lr9rPk25/hDrj+Xv7jGqw6TT98zzdc0/Ksfyd60vKtefY/cFyQc234n1
p/J79adY/qz7rg7arKbxC5vk+bP2E2H9pXxY/eOcQwec9tSXOcuP1V8qN58r
n09/IN9R/yP/z/yDcqy9+Qrl+hOsP8H6E6w/wfqTyL9M/QnWn2DvH/b+Ye8f
9v5h7x/2/mHxlXxD5/fKb8TyD+UbKxfPYPEMFv9j8T/2fstX1B/ITzR/qBzL
V3R+mHL9AxYvylcUL2Lvr/xF7y8+64ZxV+y4fn4fl/nobueO3bWqKmf5ifaf
KpdfKH/Q+y+/0Psu/xCr7/1XLl+wb82MKdfPrYx8v8q6w+fUblMV6xXYeoV8
QCx/0HqR+uYbptS//OxpPfN8Qvl/WL6g+YzuTfa95tgJ/4+ss46L4v3evomt
GIjdLSoGth4M7ETFTlTsQsXA7kbs7kbxY3dhYnejgkkubBECz4w/3jPPa7/+
d3nNzg479336nFuvxwNTz2OLCxVxzJD3o14v97VEwspXmfX6tcNlPzpudtbP
q5pQ6erevn11nvO4wJzXRT6pfrVd1Uou1nG6fweQ6/Vcfo3cnoy00+trerlW
7F2tpo5LuWX7buir499tI8adWazXJ4HhT3Z6nODzn17/A6afEcznqU8C29Yz
TesWuLDRJ71ex7XX2jypdnp9Tdb+3ltv1dTrZZ4N7lF+cT+9/mXz8Hon2y7R
61cGjS7cKNcp/XylShOS7jz79Ffr/6C+BUw9DO/XMPlzl/VZkuXRzVMr/CP0
ehXm04CZx0E9Sa3OM6sHztHrP8hHUV8Cph6E/BU89SjwxE+o3yBeQ30G+Rl4
MPUa5HPgib+A8Yeo/8B+AOOPUT+xuMLYvbkL6fly4vnwYPLnxP/h8efAyEfq
AYiPgImPgLGfwcRHwOg7MPYyGP0Ixr4EY4+Sz6afAh5Mfpv+C3jsUzD2KRj7
FIx9CsY+BWOfgtGPYOrfyH9r5w+m4eF1wn9P6annr/HnwEf9i6RblkfPX1Pv
BcafJP+M/QMm3kk+lvgmPJj8LPFOePqnyA9jz4GJD4KJD4KxD8mHzg9onuL0
TcfUR4HRb2DiBWDiBWD2B5j9ASbeQv4MfQ7Gvgej/8HobzD2PRj7Hky8BUy8
BYx9AsY+AWOfgFn/YNY/+RPWOzyYfArrH571D2b9g1n/YNY/mPUPZv2DWf9g
7EMw9iEY+xCMfQimPpD8DPL3Sdtstfal6Jh8DfIe3uNypZWVffT8CfOgyP+A
yacwPwp+a+He+xrX0PMx9MODsU84r4n8R76Ann+mSjpX4hdgeM6Dor6FfAf+
hi0mX4G/wXlH+Btg5AH5CeSBLSZ/gH3EeTzUo4KJhxHv1/xHG3zF3nF4wAaD
Vj/B+RzMUwZT30D8Dn2pxUPT8ivEz9DvYOavEd/S5KsNJr6FvcJ8Buq/wcxD
I551pU1s9VY5dEw+jXgW68kWM4+A9cQ8A9YTmPwh8S/Wty3m/HfWN/MLWN9g
4tPEL9D/tph+ZvQ//d/ofzDvh3gE7wdMvQ/xBOwpMO+PeADvD0x+D38e/WeL
6celvov+Xeq3wfz9+I/8vbYYf5K/n/45/n4w+gV/EP1ii/EHqfeh3435m2Dy
bfh/2Iu2mPObtXmXaf1t9K+D0a9av9vs/Jcu9P1fTL8b9Vpl+vd4+1J5Luq5
wNTr42+xv/DP2E9gePw19hP+FPYN/U/0V4Dh6Z+i/g7/gXwu57sSP9fOe03j
OQ+Wenz8C+K7w3/MfrzZV6/PB8PXGXo3/NdEvf4ef4R4EfX6xN/B8NT74w/i
j1Dfz3mwxKfB8Jwfy/wnzf5Pi+/ZYuqhmb9APTfzocDEC/APEmO+PbWbqGPs
Hex77B0w8STsV+JJtpjzTLV5d2n1otSzgDmvAntWy0fYYOolmQc0v0b1c+Pz
p2rnWYCJz2H/FgkdumxXTR3zfrBfeX+2mHo6/FHqDzm/Acx5T9iz5/MX2N5j
0f9i6qE474n6O/r7wdQL8HnipbaY+zGfgc9zvgKY9YO9y3qxxdiLrB/qsVg/
YPw97C/8PTDxaOyjNaXXhl65/b+YehHOP6IehfORwOxH7Cn2K5h6bc6DrNK3
ws+IvPr5lswT+hdOya7Xk2Av4S9hHzHPAx5MvQfyVTuvMC1ex/wr6hOZF4b+
YB4emHl46Bvm3yHvmU+GfrDNZzJ/ivXCPC3sKT4PZr4Z/hbPh//I8xMfsc1P
Yi8hX7GP2A98Hsz8L/KRPB/6mevBXI8+53rm1fL3gpm3xTwtngd7nOdlfoVt
PhJ7jPOCsL/IR2JfcR4S9hTrjflVYOZXkb/kftSLcT2Y66kf43rynTlX5Zi3
NMqknSf1IUe3nW9D9Xznq7VROToUMmv9U3vtXSpvy2XWzrfi+cGHl2+9XOGd
nh/lfugf8pnon1EOjmcG1Ddr/dw8D3jCGt9W4Rn0fCrfTz4Ve5J6NuxH9DHP
D66/fsDz49X0/Cvfjz/OPBv8debpaOcXpz0/mPwr/jffj/3F9WCux17jevYj
fw/70TYfR36MekLm6XBeHJ8HMy8IeanNG0qTx9wP+c39sM+4H5j7Yc9xP62e
Le33o54ee5z6SPJvhUNi7cPq6Jjz9Ji/Q78C9wMzX4j+BZ4X+cLfg3zB3uc8
P+z5AY3LVLJERmiY+l7sefQb9wOTfyQfyPNSP8z8nX1b3SXbAR1zXiHzesgf
wiO/4MlX8PuAyU+Sb+R5sZ+5Hsz1xMO5Hnuavx97mvwl5y8yv+d3/HyPYv11
TH0+84Pw5+Hx/+Gxb/k+sDbfKM1e4u9H/vL7hPgsu9T5l47pzyafSj8B84qq
9Tw9toaDjjmvkvlC2Pvw1HOCqffkep6HeUroA/4+/HX+fvz5Vg3OuRWerud3
yd9SvzLJNdvGphct2nxJPg9mXhL2Js+DPUf+mPM8uR/xGP4eMNdjD3M9543y
fGDyydifzFfi+8kXY3+CuZ75OfRXwVN/C6Y+l+uZR4m/fPtx/xZPZ+mY+h78
ZerHmRcEZl4Q+WPuz7xjrgdzPf0QXE9+l/w357fy/ZwXyN8D5nr0P9cTf8V/
Jz6Lv878QO4H5n7Yx9wPfQ+PvocnXsPvR3wHTDyI+AJ/L/EA7TzbtPwy8zT5
PJh8OPM0+Xs4j4rrwVxPfJvreV544k/w2nmRab+fdl5k2vNp50OmxSuwn4lH
YD8Tf9DO70i7n3Z+R9r9tPM70u7H+Zb8PmDDx+2mMoFWzZ7j/uTTyZdTL8N8
H/qZuB+Y++FPcz/ygVwP5nryh1yPfubvRz+Tz2d+KTyY+UTML+V5+Xv/L14d
L58nHU9MXqdjrmf+EPl/7g/m/tgf3J/vpx6gzPPPefN20DH1ecwrYr4f3489
AMYe+D9/UK8fgNf69//1E8Tr/fo294ennxOe/DHPh/8Hxv+jXoF5TNQzYH8z
L4l+w8YWnwkeynuifhSM/ZF9yvVVB9bo38/9yFdzP76PeUsBq5q61ruiY+x1
5ith78DjD4LxB7meeqlHqY0Wf46J1/JzYPJ3W2cv2Of0Q58HRb0G/gU8/gTx
PfwRMNcz34n5i/Cd7r1sMTybjrGXuB77iO/HPuL7sU+o5wBT/4G9wnwn/FHi
icR3wFzPfCbidcQr8YeYv8S8J3jsKXieh3lJ2F9grmd+EvYLPPYUGHuK+UrY
R9Sf4I8zL4n5L9SPYC8xT4jPUw9C/QfzaKj/YB4L8Vkw8VnbeS7Ue2CvMp+F
+C/zU7BvwVzPPBV+P3h+P23+StrvZzuvhXoS8uMZwnJlref1V3s+4rHUP4O5
nnks2nlBafUk5BvA5CeYt6Kdz5rG4z+A8R+oV9HOb02rZ9HOb02bz8J+If7L
fgGzX4gXs1+Zv8K8NTD+OfUu3J94NP3fzHtBPvB55AOfJ19TzNd5z8XWyVo+
h3kunA/F84L5PuQ934f/SL0N9fFg6uepz8H+4PnAzJvh/ByeB3nN84Lnzt4z
vGj/ZK1fnPtT78b30w9AfQ/yj/oe6tuY/6LN80ub/4I8ByPPQ+yOb4k9lKzV
O8ATn4PHv6deiPwNmHgk82OwN3k+7Efb52MeDeeX83nOJ+f+xKPA6EPyD+Sf
eH4w96deyfb5yFfUWemXrtQ2HTPfk3wF9hbfD6Y+iv5yrsee5H7Yk+Q3yM9R
/0Q+j/kw5GPhyd+CyfdyPfYQ3wdmHg3z5rke+4z7YZ+Bsc/It1BPAo89Dk+/
J/VO08JvONbupmPqEZh3wvdT38X57/DEP/k89jL5Hc4DIL9DvBVMvJX8DvOF
mQ+CPw7GH69SeqlD+XUpmn/G/cDxu57Wmrw0RTvvneuJ53I//LnVZRM+LD6c
ovmzzBPBn6W+SqsHOJYpd39jiqaPmCeC/uL+YOabaPMk0+aZ4M/zfWDml1Cf
wf3RL+S30C/ks9BH3A/M/dBf3I/4BH8PuMuJKS+vZU3V5p9wf+IrfD/2Avky
7HXqw5DfzCPB/ub7wHwf9jXfR/yC+zH/GYz/Tj4Oe4vnAzMvRZtnmfY83J96
Nerrydeh//g+MNejD7me+jXybcgz8mvEs+CJZ5FfI/9CPhHMfA7qYbgf9Wzk
4+iPI/9G/BKe+CX5N+Zt8Txg5i8w74L7UY/J/ajX5H7MY+J+YO5HPRb3I35M
PRbxY+qt0Nd8H5h6NPQ3/fzEy7kfmHou+vXptyefQD0XmPot6pXJL5L/IB+J
vU9+EflGPRbyjf519CU8+hKMvqS+C3uf7wPTL4885P7Uf9nWb9nWX1E/pcmv
tHwY+sq2vsi2Poh8B/LHtn7Gtv7Ftn7Ftv6E+Ab2LfN5qcfHP6P+m3mr1Jcz
f1I73zPNPiYegb7Xzt+zqSdA3uDf2ebrbfPttvly1jP5GdYL863ID4PvZwpd
HlTFoMlneDA8+oP8NPoHzPsjX438ph4PTD4a+xoeDK+dh5BWfwem/595OQsd
Egzjb+i4VP6lVXMfM2j5angwPPFP8rlg8s3Ev8jfgsn38veQH9X0VVp/KfFm
8rVg8qfYI/BgeOwx8pdg8qHIH3gwvDZ/Ny3fBSbfRj0D+TjqGcgPMs+IfBWY
fBn5N/JXzCexPQ+E/BGY68mfkU96XM5jSGxKhFYvhz4mvwPmevJj5HuYr2Ob
byK/0vPbOT/H8RH/k98hH8K8KPIrxBvgtXmzaTz5CfIb1MfQH0d+gvg/8992
tu730zPBotm/xOOx18HUW9rmL4jHc56W1i/ntLpPqIseP8feJP6uneedFo8G
Ew+n/gSe+hPq+Zi3QXxYO087LZ6N/Q3P/EHbefjEa8HElzX/OI0Hw+NvwGP/
28abiafivxCf1eabpsVPwVxPvS/xW+wbPo//PDl2ww//8Xq8E4w/enBSp/st
Zujx1ndGu2Omhfo8e3j82d3xv10uBOqfH+fj3C3LAT1eCk+9FDzxWeKn2ONg
6lFs46nEJ+lPZR4+8tU5w/H2kjlBsydT5ppGrE6M1+KPxC+pL6NfjXhVudyh
FSpN0OsrwdQr286vh8eeAdMP5bFma7b3M/T57MQXqacCo4+JNxJPpF8Nf8G2
f43+NuTj0Dpxs1re1eeVg7G/Np49Osj8LFHTh8wDJ94Ixh5gHjjPQzxSyw+n
YZ6H+CTPQz0ozwPmeYhX8vsQv+P3AfP7EP9Dv1MfynqhHhT/iXgY+Qnid9TT
EG8ifgfGXiI+RbyM+BX1Fp2Sfy8Y5Z6s9ecQjwETDyKeRHyGehHiTcQ/+Dzx
GTD5S65n/xP/ABOfId4D5vPEj5B/xDfAxE94HjDynHgO8o94BZj4BvIZHgyP
/gAzL4v4CvN5iUeA6R9j3i28dt5uGo89AmZ+F/EU4iPENzh/6W4Jxy5Bs1L0
+rc0/x9M/IH9QnyC/UL8g/ww/jMY/5l+afxn1hf+Khj/mPWDPwjGn+X94d+B
8RdZD/g/2rzvNP+M94H/BMY/Ir9EPw3yg+v5PcD8HvhfXE89Bxj7hveBPQKm
PgN/EJ73Sb0G75v6BTD1GsTn4Flv1G/w92Lv4L9h7/B7YR9QLwDWzpNP88fY
/+hjMP3fWrw9jUeekB/m/aPvweh77Enyn+RXwfhvtvlQ9DH+JvoYeUp+kHwN
mHwg+ULiQeRzwNT7kz+Cp5+JfA/yF3lKvgR5ir5HHoO5nvwrPPYF8pr8NfFr
MPJXy/+myT/NnkmTd8QT4OnPJ55MfQX7H4w8wR6Fxx4lfor/SvwOTHyReiL2
M5j9jP1PfAZMPAf/gngM2HYeI/V6+C/EH/BHqD/D/6C+C3+D+itN/6dh/AXs
f+x94hnEQ8DYu9QPEL8EY3+ynrE3sQ95/2DsQ/LX2IOsX/K75IOJ75APxZ7A
3iCfCCYfSHyE9Ut+TdvPaeuR/BP5IPQ/+Rmt3iENo6+Jt6B/WX/kK8DIM/IJ
yEfiM+g31h/xXvQP8XriJ8TriX9hn8MjP+CxB4mHaOfTpMXLqGeHJ38OT34T
nvwmPPudeArxI+Jv1IPAa/WoaTz5RXjtfMw0nnpjeOJr8MSj4YlHw1MvTbyG
emn39a65r5/V5yvC0+8DT74JnnwTPP3L8NRXw1M/B0/9HDz9y/D0N8PTTwJP
PR088Wp44tXwzA+AZ74APPMD4JkvAE//EjzxRXjm48AzPwee+TjwzM+BZ94W
PPWP8MzbgmceFzz93fDM44KnHxyeeVzw9HPD0+8NTz83PP3e8PRzw9PvDU8/
Nzz93vD0c8PT7w3PvB948gvw9GvCE5+GZ54i8Ujm59Dvwv6AZ3/Asz/g2R/w
7A949gc8+wOe/QHP/oBnf8CzP+DZH/DM84Bn/iI88xXhmdcBT34JnvwSPPlx
eOL98Mwjg2eeAjz9wPD0C8MjH4kHIx/p90E+wiMf4YkvwZP/gMeehad+BB75
Do98h9fO70vrH0Ifk0/R6sfoH6d+LI3HXoXX8rNpPPXmxLupN5+fHJC8coje
Xw5PPgieemvi3dRbk9+hHpN4NvWY9Psg/4hXI//I/yD/4JF/8Mg/eOQfPPIP
HvkHj/yDR/7BI//gkX/wyD945B888g8e+QeP/INH/sEj/+CRf/DIP3jkHzzy
Dx75B4/8g0f+wSP/4JF/8Mgn8hHIJ/p9kE/wyCd49i88+xee/QvP/tXOM0+r
lyafQb00/T70E8NTHw3PPAB45gXAUw9FvoN6KPwD9i88+xee9Uv8nvWLfc/6
hWf9wrN+tf6GtPULz/uF5/3C837heb/wvF943i888p/8AfKffCv6jfg9+o18
K/4s88qI/9rWm1I/Sr8M9aP4z8wzo76C8zb5PDyft+WZfwZPfpd4NfPOiKdy
Hiafh+fz8Hye+lY+T30rn4fn87b1r/frerY4+FGPX3MeJp+H5/PwfJ55bHye
8y75PDyfh+fzzG/j85xnyefh+Tw8n2feG5/nPEp+H+Yl8PvgT7I/iSewP/Hf
kA/wyAd45A/xVOQP/h72Bzz2Bzz2PfFS7Hv8Q+x7eOx7eOx7eOx7ePQbPPoN
HvkPj/yHR/7DI//hkf/wyH945AM88gGeeQTUH9E/hv+L/UH8FfuD+gXqc4m/
Up9L/QL1ofDUY2jnB6XJV+I5yFfqHZivBc/8LXjsQ3jsQ3jWDzzrBx77m3gR
9jf1PqwveNYXPPoNHv0Gj/2tnf+RZn/DY3/DY3/DI3+1eqM0+QvP+oVn/cKz
vuBZX/CsL3jWFzzrC571Bc/6gmd9waN/4NE/8OSziI/Tb029EfFpeOpH4YmH
E38nnkN8HXuU+VTYv2DWO/OmqCcEs56ZH4V+Y74+/o7t+QzMR6B/ivkFfB/9
/8STmM/E3wcmnsV8cerRwPSzU99BfTH91OwX6jeIH1KPgb9FPQH2FfUB7Afy
/Xw/mPuTTyf+x/wd+gvAxMfoPyD+DsY/or6d+5Of4/nIt/F85Mf4e8DsF/Jb
rD9tvmOaP0N+CvuNek/sQead8P3UUxKvZZ4I+RHq9ch/8L7AzEOgXpf6Fer5
mOcMJp/D+qAeBUy+ht+P+blav0Ja/oS/j/dFfRf1cDwP/UPEI9HX7E/yFegD
5hWB4fFHiQ9Tz0g8mHgl+Q0w8WH8afK7xIN5/2DsAfo5yVeCie8iD6i3pr6H
9wlGX9EvDU8/O/WozAOgnpR8BPky7ke8n3p38l3Uu/B+qEehXoN+DuLz9I8t
te8WuWyRXq9Bvxj9Stjb5Jewt+mnYj4u+UjqE8g/Yq9R38H7px6EfBb5L943
+Vfiweh/MPqf+DD5eeIf2ANg7AHiIcgT4hn0N4HJRxDfoN+Y/Ub+Ccz6oP6U
fBfzQKgHApOvYL4I/U7M76BeAkz+g/kh2MP40+g/MPsL/5rzfPF/sSfA2BP4
w8wrwp+lHhBM/Sj+LfVM1OMRDwMTDyP/RT0R8xXoBwMj/8mPsV7JbxOvAiMf
yJ9RT0M+G/sUjP5EHnKem9afnhbPARPPse1/J98NZr+SX2K/1nO+Ujrgru7/
Ym+B0ff4w8x7If+NfQjGPiQfTv0l/d74Q2D8Ifqd2X/ks8Hkr9mP5PvY79R3
gelPZf9Tv4W/XaBr0+vv7yZpGHmB/428YD1T7wSm/xJ/j3om4gHkv8HUKxEf
QF+Qz6dfjvolMPYa/XXIT3gw+XHkKfqF/n1tXl1aPgtMPot8I78f+WnqO8Do
T/pfeD/UuxCPBWOPUh+OPYQ/Rv0CGPsN/4zzNLGvieeAiedgb2MfY08TvyV/
iX4kf4k+SPfvn0HTB9SDsz/JT7I/yU9q52mkyX/saeQ/8SPyJ9jX5E+YR4A+
wJ5GH+AfEH/GHiL+HFJt0J+cYXo9NfYr8Wd+X+Qdvy/yjvwE+x37kv1OfJL9
jX3I/ub7iY/x/cTH8G9Zb9i7rDf8U+IX2LvEL/AP8e+xd/HvWZ/IW9Yn8pb4
JfU02IfUF2AfMm+Tz9Nvjn2IvYD+wj5AvrO/sf/ovyV/Qj0K9h75ftYn+4v1
yf6adDZsYfPHej0I9hr+PfOI2A/Yb9p5nWnznagHwZ6jf4f9zvoAU59OvYTt
PCKuB3M98TOupx6a+nAw9eD4C1p9SFo/GeuRfjUw9Qv4b1zP+uR6MNezXunX
QP+AsVeRt9irmnxOux7M9dSXcj3yjfouMPVb1Gex/vj9zjgebBx4R48XY9/y
e2LfYv9STwtmfWIPY89iT6KPwKxX+oXQR9g/1N+C6Z+nnob6F+xD6m3BrH/q
afGHsD+p3wJTL0t9D/Uy9HtRDwumnov6LPYT/gfyBkx9F/4I/hTrB30Fpl6T
fkb0Ec9LPaX2/Gn1kvhrtv1qXA/mep6f6/GHie8Q/wGjb9Fn6Fsw+hb9xnpF
f2nz4dIw6x19xvnR6Cvy32DiQegv7Efyz9iPYOxH8tHYv+Rb0a9g9Cv5V/pR
0H/UK4GJL6EPed/oQ/ovwMSb0I/Un+NvUK8OJv6E/0G/Fv4G/e9g4lP4H8z3
IX+GPgSjD8mncV4R+hT9CEY/ol+5P/qN+4O5P/IGexF7mXkyYOp96Y/Q5lGm
9R/Q7wBG39GPoM2rSzuvRptXl4a1eXVp59to9a5p+5t6AjDxHeQB57OQL8E+
AWOfsL/XzHvXIGqDnh/B3gFj72Bv0G+LvUF8F0x8zbbfnnpx6gnAxN/oV0ff
kG/APgFjn5B/oH+PeA35XDDxO/IN/D7YC/w+YH4f7Af0MfKJ+mYw8T/6MekP
wL6m/wtMfBB5Rj8+8gZMvyT6C/sZTL8k/dvIHzD9kNjvyA9t/nlaPyPPSzwE
/HXRBWfP4yatv5L9DqbfkPpo/H8w9g7XY5+A6U9j3in2CJj+M+Z3sL/B9I8R
b8L+ADMvjHnRrH8w+o7539Qjg6lXZp43/hcY/Ud8g/UGpv+Afi/WF5h6ZZ4H
+xRMvTLxHNYPGP2I/YY/wt/P+qCe1jbeRr/rpd39tlUJ/9/4GvOMsX9s42ms
D+q3beNnzOPFXrGNlzFfF/vHNj7G/Fstn24TD2P9DX8wquLDrv8b/6Kflf5X
23gX/abUT9vGt1i/2HO28Sz6M4i/2sav6M9wfzO7wo6G/xuvwr7PFzft9OiL
enwKe4H9ka7x3oUnrv5vfIn9sTQ+w+lX1f43nsT6r/U9aUymGXr8CHuH+UTY
58RPiIfQH8U8Q9v4B/X4xI9s4x3M2yAeZRvfYP9g79vGM1j/X9uWfOiQrMcv
0L/kK9Cv1Hto/lja/DD678nn4Y+SzyO+rJ2nznkQafk55v9w3gn2Hfk27En6
k+HJp5Fvxh8jnkT+DP1Evyv1S+Q3qAcin0F9HvNQiHeTnyJeS76C+5Gv+PjB
ae2JxEgtP4U9z3rDnme9wbPe4FlvvG/mCfC+be1r9BnrzdaeRl9tj4g+ncHt
f+1n+vfZD7b2MvqM/WZrH9N/T/+FrT1Mfz3+j639i7yhP9PW3kXe2J/1/Ja4
43/tW/rjOe/S1p5Fn3E+p639in/M523tVeIzxDfZH1p/VJr/SP+Frb2IPuS8
P1v7kH7EXquubY9Z+b/2IP2EGaaf9yj5/n/tP/oDiT/a2nv082U696iSn+l/
7Tv0KfNKbe059CnPb2u/0c9HPMXWXkOf0k+CfUa/KfYR8gB9h3+J/YM8QF9Q
f4J9gzxg/xBvxr5BPvD+sWe1/ECavECeU/+IfcN+5/1R34v9gvxA3uK/tCw9
yr1u0UQNU09HPN62nm5h6xlH3Cfq9WHMb9TiW2nyF3sJ+5bzU8DIZ+QB+hV7
l3wRGPlta89g/5I/BCPfkSfoL+xh4qNgLf+dJj+QT9i/+Ptg5D3ygOuxd7ke
zPXI11Utg7x8Z+j2J/WgYOQ/+WvsM+xN8p9g9AH7A3tHm9+Ult8Doy/YL8yz
wx5lfYFZX+hj+tmxT9sFDXp4JKeO0TfsJ9YD+oDzc2zfP/Yr9pXt+0ZfYL/a
vl/0AfaJ7ftEnqNvbN8f+hDe9n3hH3h0ORI8e+L/vh/kFfaz7ftAXmF/2v7+
2D/ME7T9vZFXF4+tz3yghF4v5XVgt9/qYgYtX8P8kPNNrnUKtjOIoXan37dr
6fqa/fhx7vVHL2saNHmRNHJgnbEN9HhYaPLO1j3r6fux+JNGoeF9DNr6m9ti
u/sd5f2RD16R1Kl7/+F6/r9COY9BnUcYNHn28EBopPq+ye/UyZAl59Ce+v6N
OFe/47n5Bi1es6La6MPbFxu08yhc2sSPa6esB9Znz7fLRtxYZdDyp9G18zVL
9dPPwynQNHFplvV6vK5qrRwNwtYZtPrQqKJB7o7K9cQ/XvqHGcNWGLT6wjtf
ffc3X2LQ5Lnfa/saTsrzEU8vXn1x5Kd6cdr8mJqVggNVTH7innPfqSpmPtuW
I3GiYvITbmO75lQx89SqvGv68aOCtfMnLEsCVMw8M+/nKXNUzHkfAa+n91Ax
+f6TnV86qZj9mCPxd2YVE797u3Xb1w8Kpv7A8cSTKyomfuVYdMRWFVPPUMbY
ebqKiYc1rD+ht4qpj7h49ExDFdMf/HZ79uIqpv9j4MNB6VRMvPF+w0Pf3yuY
+TIuhZ4+UDH1GS92BAeqmPVbLnHlRhUzXzG8QfbZKiY/5Fan3nAVE//8PC1b
ZxVzHuUd8amvYk3/9PEpo2LWe4HK6XOpmHir37Kc8e8UTP9m4PO1YSqmX/Pw
rWVPVUx97Ka5UZdVzP4ov/zcYRVr9SknQzaomP0xMt+gBSomP7owr8tEFdPP
ubBLr4EqRl5PP3a7o4rpR7KrPaWxismfTas4rKqK2T91TGuKqJj9079qbDYV
s39Oz1uY8FbB7J9TwW5/VMz+uWlyfq9i9s/uzM0fqJh87buCUy6qmPhrL/e7
R1RMvWzumJpbVUz9w7pqZ5armPqV993bzlQx9a8vT0SNVjH5zPyLdvRTMfHy
HsV7dFQx9diJZ+2bqpj6617zH1VXMfXWkQcXllQx/RddXFzsVYx+tav0IZ2K
6a+I6D8+9o2CqR8ZvcHwTcX0/7T26v1CxfT7WFwP3FKx1t844OkpFVNv+yXo
xV4VU1/r43LUX8XU05Zx7jJfxdTPOny9NlHFxFO/FzQMUjH5/I6unzurmH7D
wz3mNFUx8uzR0ydOKkae5dsUVETFyDPX2O5ZVYw8ixkz3fxawcizrMEVQlVM
PPRJSNcnKqb/9+W06Isqxl6t0iBmv4qR709Hua1RMfK9zYuv01SMfM80JXCw
iolff/bY0VbFxHe3VF3vrGL0zfOEGQVVTH7eeMwl6ZWC6beusWJ/iIqxv3Pu
2ndDxcwnCgrPtkfF2Hc75hyeo2Li7ed7te2nYuLR6WOP11Ux8zRqz1mVW8XU
Fwy84h/2UsHEcwvY9z6rYvyDY9EjFqiY+HCzMrU7qpj8//rN2fOpeNLN1BPF
Vhk1f5b1/celYZ9SN43a+p6XfWLn4deN2vquefh329CrRm19e1Zt0XL9FaO2
vq13p/TxvWzU1neeXNuDt14yaut7dmRGS8xFo7a+IyZPHeKrYNa3f+tbl10V
zPrOsXzV6yYKZn3XaTb1+GQFs77v11429qeCWd/zPxcav175PtZ35K7UJnOV
52F912nTZ/sx5XlZ39ddgxcXumbU1neR0V0bPFD+Xtb3ypuf6txQfo+W/Rzz
XssVr/1e2c1nh57sqMcvkXenTJ3Kh0cYNXlX/+/9BtV+GfXzBa+8z3s61KjJ
u8teDb5ODzFq8q6yR5d0cz/o590VaFPpZad3Rm29V/D+uzNFzTOlrfdtDxIv
FVPux3qv1qne1JPK961Z5la+ZA79/LiqTbfGvZiix1PRB/3Cj7/r62DS9MG5
nCVCZuQ2afog1cX5QEwWk7YfBoZW7dMlo16vMunUiOG3c5i0/XDebainoYCe
L3SpmX3I6iYmTX8ddbJbHVhH93dyf5iyb66LSdsPsxYVyda1uUkupgw6MU/x
17Gf9ximb3Zvr8dP0K8jI28/swwzafq1R6kjl/P01c+7czQNu7l6oEn8po5L
2n4hRosXo98/Xi/y8Pkmk6bfg09OWemx3KTtp6xjn0Wc3miSs+6rc4Uk6efF
YT9Uy/hzQ62zJmnQYMsjYy893ow9srPZLd/Kv03S5u/vDoHB+nlu2DPVLlVd
cC2PWYyVMge36qjHm7GHAp5tTHjT2CzBR6SH6wuj5i+gvx4Ebbr3cYxZ019v
yh3xrOll1vSXd9/BgzIMMWv7279rzkkd+5u1/R3bMOvGvL11fzImXcjvQX3N
mvw+9ePW8aGDzJr8Xu54J4P9cLMmv9s4vZk7Svn+O4P8S7ra6+et9eycs2fT
GXr8G3vwbU6X0hsV/yZD2XX3F1XU41Xo94HFxzXJudas6fddE9p3vbRUP28u
ZdyZnY4Lzdp+KP/pV+aTyv3YDz1Opd9cQ/GHT2Vq/Kj0Dv38tT9fVhXcX0qf
J8n+vPbxdrPWF/Tz4OZ/aN+8myKX0A8N86f4FL9mluSpBaVS5gTt80mtZ68/
/DRCi99jH02OOTGhbbhZs486bFhz6fAn/by3+hkLdN712SyV53ZoUmaxPl9y
17CCla981M8XYz9u67i0oxSyaPuxh39Qn+xZLZq+uV9x5ec7Cj+6x++6zbbr
+a7bQaXCirbQ51OWLpit99kVer4A+7BB49YBpxrp56t1+/3NZbizRU6m/t5f
783/d35YAb/OwZn1eZb18rjcrOKmz6/EHvV2j/RZ7/n/nX/2K92ODF4WmVEh
wq5c1kTt+nav7+ToYqfnJ5AX538NrLbdTz+frOi28o2PL7Zo/kt4tenpbynX
Yz8PChq47kiQPi9ztW++uSUiLFJi97uir0bq9e9rDTOcHm/V52UiL26P8znx
8YtF0h3cVmvMGH3+Jfqpw6Oybw4oegD9VGpikW8jC1o1/bSh9egMBRysmn6a
5lmw36ECVk0/9b5a62pFhUc/VY89eWyL8nn005ffh8ZnKGwVU7DRb8hWvd4K
f85jQ9/fVgXjb0zKtOFw1WZWKRMVOiNqsJ6fYX8vN1fxea/w7O9lqxvG1Gpg
1fT33/P1u06uqceDrMs39s7oYtX2u9OhH/VLN7Vq8q9NtGdmUw2r1Fu6PIPP
Wf18q2bPJgfPNP+RTjcbtk+Yqc8Hndnw+r3bw/V6Y59jX1+eGWfV5FVzS8jK
6MFWzd5z2N0m7PtgfV5Xererpawj9Xmh7yafNviusYpL0e6ffvjr8Wns/YMv
ktp/WaHHL+Vl1j0v1uvzQuuVL/3q8WWr5MjS1u1OKz0fhb6teW+Kfeebenwz
g+nAgKMKPrxiftWju/X8LfI++8wiB9tEKn73kKqVXCfp/RPo9/Uj12/yj9TP
r5q289H8ep+skiddkbCbDfX5ocif+YFdp4Uonw/LMGH7tJT4/5kXWq/M9jbf
G+nnQ+W7Y7jZt3m8pPuweeuSsvr5Sfi7Zb9ne1ytf7zUX7in/5ix+nxQ5FHp
Y09upvTR55FVmRb86cS4eJm4bULX3QH6vNACa+fWnOymzwe1f/aw0IHS+nzP
jplKjYv20c8jwh//UXr/0gOR8dK81vtinQfq/SNxQfmbL0mvz/9EfnVJKmzn
9C1efH6Vy3Hhe6yWPziUMD2rtXi0Vh+OvBrz/NeK8NEJUuBrc79MZ/T+k9SQ
hGqnryRomPhB4RIlWvqfTRBD/8N/Ip9GafV6+MvnN81v3Urhi5TLM/HJKr1f
ZfWSlhVWv9P7wZFvi8r29fEtkCgFGzbvnGui3g/ebOqZkulD9P5v/27Xt97Y
FKX1e1eKP/X15De9//tbjalDji3T+70vNfP8tDdM7+/2uW5/IHSW3s/9Nej1
7g9hev829tS+x00fNz2fKPd2Xg683lXv345eGfy+d6jer52t7hjf9p31/uxq
t/90KPVF78cuMEPyZu2s91/369H+adUPer+1X661HzN11fur6/VI2NKjh35e
Es9zMsNDo8/SJKnZ4GFztxuK/uj0OMHnvySZnTqzz4nTer9P48eXHvsrvx/1
+Y2cXHI+nq/3Z6OP3O8+edLb4a/k+hGR5eo6vR/o9JSgcpvWRmnnG10vEBwa
7h+rYdaXIfDjlWPD/sq3cu7Oc0bq/UKjJ5ad8V9nfT5peOqVz46vorT6yQnt
kocd+aqfR9R09bfwnrUSdD7Nfl7XIvfMqNC/8jvwYu3fGfXzg7Z2LP+tfsFo
Lb+NPm/dZGH3HbmSJfbvpqF2ij6Hz7Tn0qj64fEaZr8Pvrv4pF02/fyhhVMy
Xj2i8P45X5kPXtXnneLf+dQ+13Zoq2QJW3+6V55xer0m9kmfxm/PlZ6QLD/W
h26M3hCn8exfJ0+7I3lWJUu7iQtvnNqnn4ej2TP9fnQuu1x5Pler5+73+ry+
iBO3/OLb6/NTkaeed7NfaL8mWZPvl7qnu3pqlX7+z7oLG2sMu50sH0a55Pv+
NVrL9+NP7fILGPj7nN4Pcbb27A/prifL5t7hztbV+vxU/KkPxY9cLBKZLDX7
btgzcr1eX/N0a01n5z36/FTiCy+nzm766keyDDy/0RI7QZ+nSrzw54pXnQ3F
lM9nPLK061T9fBjs1Yo1Y7oPUK7HXl17de1O/wIpUuPz7B4tFP3H9djP772e
PMmaP0W899vVHdFZn6+Kfvn4bGPuic1SJLDTkMH9nsdo+Uz0aeTA93/ta6do
+nTe0/l96jZK0ez/T65jmixrrtfDHR+ZJzhLyxTNvy3eO9RpUuMUzb91n5w1
a6hyvyovNm05V1mfx4r+zJS7ZgUZoueDvm+9dCtsQIrmzx+OHFbxxcAUzV6a
GZA3LlnB2EvTe+RpOUzB2Euvq/udzax8vqvLwCkOqQla/gL7Ye0Yh9jYrcrv
t/tksL1i75Cvxf6Zt8l5ySUF+6z5HWTYqc9jnJr0YV/3jXo9CP7l+yN97le/
op93k7xw5Oa1X1I0+2++22TnYsYUseSp2eRQd71eBPlRYK1/oYEGPX/Zo/zN
yaULpsru+tXXzHLXz1upWc7xeRk7vZ5E84+fP+39pGiq+Fbv9/VLZf38FeRl
13cjXK7USdX0y5lMhyKXNNfrDTu/qna8iat+Hky9DQt3unvp+bZabqPr5FIw
8qVep4EngyemyqIc16+fq6Tnq9mPPQt+7LB6TKpmn9TMvPap3cBU6T/XoejF
ZH1+JfLCYI1fVGx1qrb/U1fUaDN8Y6pmn/Stt3mHy07l94hdOP3XVH2eLfvr
45u8h65tTtX8t4AvP3/kXKOfDzPj/Jrrpy+nSsERtV+8XqjPx2Q/56p4t/zE
C6mavfaoljX669VUbf9lrNbpefitVG3/lerbaYnfPeV5kmu0Sf/cpN2P9T+6
w3rDj/up2voPXxBc43VQqmYPx12aUajhtVTNHn7d7UzF3Bf082WCivzxOPUr
VWokNGl3sbx+3gr2duHEplvClO/D3v5yrtmR8l9TtXhZ+Ow1A3J8S9XiZTvW
bUhcp2D2V+EqJeZfUzD7K9uYC5eWKZj9teBrQEWTcj/2l9T2tvv7JVXbX25e
29vtUr4ffWB3bFGj+tH6+TOtViyzn2GXzpV8zcFqJ7Pez63Xk+64GfTxdSY9
f1qh4t7dJ4uncyVfs6hZao7J5dK55m7ysdrQV3r+b3i+ElVL1dDrF4hPnglc
9sm1mH6eTMLXUhfPOadzJf6x2/Fe2w5107n+qOo74cJffX4x/l+reiW7n6iX
znXn5+JL3902yIVCYe/PVDZI1Sv7qnRT9teWum+/rq5ikJAVTbd7T4qVyYZ8
hwt2NEjWyhdvP9geKysuxhiOdjfIujOZD7W9FS/r0j37W6uzQX5dzxS7bF2c
7HGYHz9nukEGnHdpu+NynLR/vS7Rc7ZB7B1nmB2irOLWN6yW3SyD+NyUaetz
KvvxwZnwsz4GudSljWHvUJPMaeyzylORK4YK70+lLDNJz7WFxuXcZ5BWJcsN
qRRokoknSgZN32+QgJ7tOpZ6ZZIN+/aHHzug+HEO5Y7+jFf8s2Unyu07aBC/
AIcNM4ubJax5unUDDxmkXeIt+y/NzJIw62r9bwoeVWF35rzDzTJozM+EiocN
kiXDgGZ5l5ulV93DW2sr2GKuMfXLcbNkvDjnWkYF78r0p8HM52bZvbXqr03K
52N/RWb6bjKLQ/VR3jHK92V+GOtcuJBFTiXN3pFNwRUXrrYWbmSRsrlmTv+h
PK/vQr8JP/pbJKhtc+M85e9xD8/vN2OuRWY3b/3os/L3dmhpSe2v7L882ds4
vnpjlMp+F4K2njWKT6PQyRtfGqV38Nr7qer/Pxl3cukzRS9uLXpmZbxRJr8c
N+DoY6MMyvV3abY7Vuk/vJHbxKdGGevcdfYqxW8aeHbj3aPK52OuxV4L6RIn
uXIG+QenN8nB5rlqTZkQJ9EB325u/GsUz+83xh75rsivPzd7FE80ijR/PCd2
WqykL16iyyAnk0xNHHKm9qZYeV2k8e9N5U1SYMypxDXbFLs/74NtKyuZpG/5
MdVefTdIjzOrovO6m2Ss1+uNSz2Uv+t4m0yBs03Sy2FD7vzK+t3cYeSvhfMV
OVJhy5rbL2Kk8NgRy+MOmSQ2282MDa4lSoZPR0P6Bphkd8S4GxfTx0i6RWtz
nX9jEu/PFdcsGx0tq87nS3cu2STdWj1aPfFjlPSp1su/eyXlPf3Mfv1Z1yix
L/pOHnqYpU5soYI1E03SpFv7pmt6mKW0tWqLNUXN0uT1PY/p7mapN6j2wqZN
zJJUcd67oM5mqfKpqN+6+xZ5V+TZqCkKdpp5L8wjxiJ5B8z79EC5fluul04X
Cip+dLOoMh+U++9z8W7Z8aNRvOJy/G47zyx3DlcplFX53aJmZY2xn2mWuMzF
c5z9pfj9wyZVXjHdLNZdW5+cmhkpLx1G/uikrKuhfR5mCq5klNiGLSdvUfC6
/Tu/vnUzyrgzoz2HHDDLtToea/ZUjZTcbV9Ua/TSLKsSp24adj5OtnUoNOW5
sg77TVzv/zUkQn7drf64ZJJZ3tU6lGdbuzgpvDOo+HwFr7peJyxXT8W+PhT/
OmNGiwz2vF956oYICRlfeVG68hb58qvpzbWhsZJ1f6VaH6pYZPFBT3evzhGy
zeTW8WsXiyQWaLb5rvK+i6/Lt6eOu0W62S+acj5nhORpus/p5myLnG+VqfEH
xb9ZVqT4y3hfi4zMmvnK9+yxsqvF7qEtjqnxsDlBOyeHyw+/0UHlEi1iHD1b
nir2xSz7GV9Xp7PK8XMHJfdUg2zs3D98V3mrpGZakG2Rsl9zV9yaUKeqVR6G
JPnnVt5PaiHD41iFL59hXd2wCIscTLVkLajglp88HdyV9zGg77oz95yscnD0
gPttNiVK088zqrSuYpWTdn7dZowySWjmzhPDPKzSduXvwLuKvVq05ZLGXd2t
YghfXTG3su4H1W8wY99sq3jWbjOnrn28fDgeur3YXMWuTVrfsY+yH1+Oa+Q0
+IRV2hQ9PCa6nVGKVMrp3v+tVa708LhWrnmMDC3jUndJ5Xh5dKrx/F/v4qTm
xJQDm8rHS+kpt4cfnxgnp/POOHRkbryUeVa98ZBT0TJ936dTX47ES/3fiwes
aR8nWSvt6vT5cLy0Tfwzp09FxR/I7LfH46Xy+a15F7UdHi2J7i3+RPyNF0v2
Y9/LZY6TcsUz/K6RLkHsOndpkEWxV1r9yTZ9cY0EmZV3+t+6ZaKl8ugak68q
dleHwTtuFb0YK9eqDem6SbG7Zpdsu/GFol98Rv1Jd/95ghjbXD1b31uxv3wT
s+VT7FSHJ1N8N2+Okr4XIutl6Z0ofsE1LLUV/7p7zkNlCnVPlKAlTv02r4yS
pjuq1TnsmyirB7X9uUDxn09Ylq7ZNi9RHpp6BP5WcLaDH+PeBCRKiiVhfjHF
nste3G/twreJ4lIleOxBxX+eZt7YruibRDm9/UXgGmX9zN6156WkJkrby81C
jYr/XN2ryKkjyYkypWqO7eGdFH+2zpV8UjlJ+pyt+mxnl1hp4ZrQOZtHkvQI
exjQTrH3/vxY+6WP4i/X8B0nmW8myP48rRqdPpEki8tOjju8KUF2GAoE+lf6
K1tGH2w9ZbXij47pc6lK97/ivGD/6NzdEqSE268FzwL+yo+Z7d1DFX/U40+v
SAfFH/UfP7pfnOI/tuvhMXhLzWTZteJRox5B8WL9k2NW5l7JsmHRxsU1PyXK
yZ+lcpi6J8u50MoJtTziZdEt7wF5A5Il2HPP9MoVjXIyi/G840fFf1teLShz
7njp8aig99I3yVIgc2rxrusTZcIil2UdXydLwzMZ+jY7aJXvu4dNqWWXImEd
Nxs+eSv+3cjMjZtkSpEIz9yt7OtapbJH1+i3VVPk0LbWbTt0TZTkjNOaHnVO
kTcl1vQNs5hkcccNIV89UuS638rwMGU//Tc/Z6nZfVKkU9OKvYso9tHqYhOy
VFX8kS/TMji/LaL4L/tqfozumyIHs0w4O6OxRdadbDuyau8UmeU8ZY+foq+q
7tqz8XqPFLl/u2XobqdEqbZ++M6Nyv1ODCwSFpI5UT4cmtUhy/wUyRXYJDr9
9gSJPL/vleV9ilQYW7RHoKIPLCbDm/sZUiWyRu5Tiz0SpFvbPgP3ZkkVp0kP
C97JmSA3/o5dX985VXb1mxsz6VqsHHxbLdvxPor9Vn3/RMO1eOl3sflsS7dU
aRKYsedun3BJHlk/OXRuqvx0tJRu3zFOLNYZjZsuVOzrTEtHXqkTL5W6rWo6
cVGq+I/81X1vcpwscPnh9/Voqqxtk3fDL+V9FF0Ydm3QqVTpkTH6dIn5Vjl8
Pqjbnv9S5VqXrcse7rZK7kptz/c8lir5/Iq9bNLMJG8PLb7u/zpVekXV/3La
yyS5p7l1WPEuVe4VvHjn0SqT2GV64eDwMVXyVrKLXn7aJFnPWK21Piv2bb49
36OV37fdf+Oiwj+lituopZcqNbHI+lmtGnz4kCrVL2fbW2CgYg/cu/d+jHK/
3/l7Tzul2APGpLUH9irft/fz/vl1FPtvx4LKN0Yo9l+WvqVqtv+aIOl+znPZ
55rOddDKI/JfJ4M4jp29qUUuxc87/yC73WiDzIys8GJMAYN0G7b1du8xit02
fun1WwoufHjaZKflBpl+oUJQnmKK3P3vpLtlRIIkDih1+anC9zFv6jp3VIIU
C7TvVFLBduN3NqycMVYyJZQ7J/UM8ulhv+2ri8WK2xY3txmNDbLgS/bhz0sr
8n7MxZDVTQwypFLrT3tdY2Vx0uCogBYGmepZ+82OgbGyP9V355a2BqmxY9eK
c0nxkilLtXiTcv2t164XnilybPLkEj4tlfu9HOs1rKchVszFL2+dPcQgjTrM
7v/+b6xsmzVxs/dQgwy716fItsJxUqzf56WPRhgk5eHg1TeLxcmHheXqthpp
EAmOPPq0cZx4HOpyJWKs8nfXn1QxU/84mdJ6327PSQbxXFNox4bi8ZJ80Rp7
cLJBhnbu1ntlm3hxuV3/fDfld7q/Pd/L/CPj5ciE3w9GDFN4/0pJ8ybHy/Ru
A4c8V57HJbF2xda1jNLwckClOisMEnP7R961zY1i+nml5N2VBtn7LiC7R2+j
/Ck9dHLoaoOcvBQxONbTKPX3ffZ9v0b5fSYOnlV1rlE61Rw/qYO/QeqsPFjc
Z5FRei3f3ueGgl8+Tj51/6BRLvge8fPeYJC/voVbljlklIvlKlyaoeAzD8Y1
M943SpYVH4tk3azY03MDGoeHG8VpRI9OI7YaZGuzG+Oz5DLJiA3/5dm23SC/
Pf+r2b6GSdz6eVt3KXo3Z6WkhIXnLHLv76l+1xXsHlzpyX+flPX558jX4sr1
DfqXuFI7o1Uu3n5Sy3GLYl+/dZiXUdGj5SfeeLNf+f5Cppx98yq4bMfPvvsU
7Fh2fuva7a0y9U25Wz2V5z+T49CZvl2tMriCm++JtQZx8DrSu/QYq4S+aLPy
ivJ7XHsY/CP/dKs0OtwmpO4qg+Sv+CBwfrZw6XSmZDu1fsVcpfbJ3oo/H3N4
SnG1nu3NrTIB47uGi9exqz1UvsAbp1utJobLlhp/M6l80qb9h/ptCZfYnh//
1dM8bF78Re2L4VJ214UotR4t5efgvW2/hYuz08LRKp9zXc2vpdJHSK4yfm9V
vmr46O11K0dI1+G3pqj8xKL+kbnaRsjdq6Nuqfynwi82lJ0YISn1d81R+e2Z
PK2JfhFyJq7WCZWX4XtX219UcFSZZSr//eXtdL/fRUj0qNf/6uvmj/izODld
pKTP0ONffdCJL6+yvi4VKYXPui5V+TcrT80ObxMpc1wbb/v3/KeO57k1IlLa
ZRs29d/n62ad+tZP8S/fhOxT+buDvRwCT0ZKj4J1hv2r1wsxjrn9LlKGDmse
oPL9XjkW2R6v3P/N7u4qv855tud/paLkdYExZ1Q+S+aXxZe5Rsllr10tVb5G
icDeO0dEyfCdg66ofJH6x0pNXRol36PLuah8A+uqzitORsmdPuVuq/ytqv+V
8XwWJTV9KlZQeb/ppd2mxUeJQ4fLD/+9v2amsl0KRUu7jzscVT7/t/ENh7lG
i1PFyi9VvuaB+eWaDIoWu8A52VS+t3l2Dfel0XK178QPKv9gxMhyVQ5HS32n
O0lqvd5dh+7l5Fm0LC266V+91uADZ8o6GqLlWmmvaJVv0dJUyKlQjFwatOO3
yhf2H18mU/0YWf59wDeVD6o+NFfhQTGy1rg4RuV/bt1fKnZOjPRrfvCVyl+s
dzi93eEYGT3ew6LyYyb3LxFyL0YMU+rdV/kTs26b42JipEXr3Mkq/27j81U/
sijytViuKyqfZWKIKaaoQa4+OJlRrTdLKCk5P1VV5JBTmZMqv31J8LifYpC7
5Vyzq/zoTjOXv1D85BKRE/f/+7wc/v3J0yAfR1z7V7+2+fOyrA+8FbkWYd2s
8lObTB/ycolB0q+s5qjy0nXc4uubDJKYHLhK5R0d5NODY4qcHbOmuMofSKya
6dxlg1R33jhf5au2Supx46lByr/8UVbluybfmRfwxSCl7h30+Vdv6Rr49JzR
ID+m1Kryr56vm6TuVeT9vvohY1Te2atf2+OOir+fMNX5X33d862+WyrGSv2K
DYaofJPcmYL2NYqVF8YzdVW+SeWPCWvax0pw/zM9Vd5u7qHGWxX5XywqqrHK
+8Rk8Fk8PlZuP+zQUeVP/219zm9BrBQZUrbFv/rAbQVMvutiZe681OYq/+ny
zxpLDin26R2Ptir/dFW+id7nYyUq4MG/es+HUQuPzHqo6J+5yzqrvGPu1KiR
H2PFd+Ph6iq/9UrZspNjYmWy5UoPlX/R9dOoQamKPblzSzmV79bx9vZR+eOk
7YK4vio/1Tfgl0fZOGnUYGsRlbfc8Co4WF2Hs6sOUfn0eycO7dg6Tl5FH7JX
+cUuefx69o2TTE1GjlD5pPvVvrUYHScTPG7YqXzC3cvZOs1R1lGe4+NU3isy
tH/DNXHi5PDtr1qv2chv3IKW+5R92Dp+8r96y2T/D86n4yTgYxajyhcMqJTc
8F6cPKnd4V89ZegP6VnxbZxkHFrrj8pXqRsxtWZEnDyucHSeys9ZGvGyeFKc
7Bs/4IvKf2h/3lAxj1GWeedfqvI5bm/qUqCkUUbcWfZa5V1zrR5VorZRNk1Y
tlrlm09u9Th7C6PsrHHqocqX3Tnhe4GeRomclmuDym/1Tmib3ssoDjNe31R5
Q4VBA3LMNEqmqN3bVD5s+6m71uVGcZ4Qe17lr7/u/y79LqMUruO2V+V/PfJu
EX3CKH8/ZDyh8n2/jHKPv2WUvleTDqt8nu9Nb3x/YZTac7Lv/8fPXfoo+qdR
mqW/G6jy+e87NPloMUrLohm3qnzzlPOtfmQ3Scj8A+dUPnBY4sXnRUzSYljE
GpU/dzjxxsfqJun6fNtVlR9zKrru/aYmeZz15iKVD/rQtdELd5O0WXb0tsrP
PGE6fW2ISd7snzdT5Wv/vXb2/lSTbPR4+VDl9w7PXfPsYpP0fFDlXz1v+gUt
nK9vNYnR7PhS5dtYmpw4dtQkf0wXh6v8L9PXo2evmeRR3RkfVH7nskVV9z4x
SVV/p37/6oH/bC4fEGqSlslJ3/6t/4G/Dm+OM0kO85yuKn8n29jde+3M0qvl
rn/1u+mfDKuwpqBZ3vT8r5XK7y04sOiWKmZxKTU89t/nXTPuX9TQLPnfXW2k
8nN/Tti4ppNZ7t1w/1cPfMn1VmnfAWYp6r3XWeXDRu7Pu3iSWaZP9kqv4tPe
B3ZNmm+WURn6lVfx8uNJK303msXt2MF/9cV79gQWH3nQLBvq/Sr8b/1+npbV
+5Liryfmy6fiNefDtg0MNkvEJtfcKg5tVWLhyBCzdC4R+K9e+fXDlkU8os2y
zWdoBhUn949OHZjBIjUzzC6r4tVl3mzukM8io0ydLOrzjroeMdOjgkXy3Zzv
pPKram1zbFHXIi9ikv79HvtcCsd3aGeRZQE3XFT+4dFNGxv0sciCrF6f/+3n
q9MntxhnETv3RqLyC6c9dXCebZHy61Y8U/mWK+xjG/gr959nafOvHvxxqw0V
9lqkq//QIJWPtP821lmxl9zdLe4qn7lKBofidy2y8Hjk2X/yPFNMeIUPyvPW
kP4qv2uQ3Yb84RbJUbHEv/Xc2avpiOIpFvn08bWXynvt7+WQPbdV9j6L26Ly
Vda8/JG/jFXyzrk+SeUnrk3ZkK6WVXakeK5Q+eI1Tntmb2WV/wLTz1b52Q1S
Clp7WGXE9FG+Kn9iSOi3dKOssnTu3mUq/6LmgM1Rin2VaWzKGJWvemn4IOsq
q8iaw//q0zPvK1/k+w6rtPNw7K/yN9u0+hL1n2LPORTdq/J2fftt/3DTKt5R
xzr8Wy9nlgz4/toqwxPTB6r8o2/ZSz7/YZX5uU41UvmC7WqFfEiwStfIYVdU
vvDahnvvZYuX9JtL/NMnBe07DXiu2NvPp3YJVnljoLn8tWrx0qf7j3/6rHxo
WMi9ZvFSpsyjdyo/1r/10TNd48UuOD6Tyn9amTzw2rB4cdvw/ZfKH7vWuMax
KfGyqkC7f/XcITEHvp1ZFi/trx20qnyeQmFn9myJlyon739S+ZXl/3geOx4v
K9KXzqrK46i87Rptvhovi5sMuafyz/579XPP83hpNtGzsMq7RMy/tfpbvNxs
mOE/lZ9+0WfUZnO8eOWZW1Xly5h3t1uUOUFGBK7dovK5WoZFry6cINaiK5qq
vPy6+HJm5QRZft8yV+XnL68yeVGTBFk2aZu7yke0+Nl/UscEqTW4gJfKv+/h
mThzcII8Twz2Unmn583+jJiYIJcnPWiv8osmHpw3aVGCHHWu968f4lOVyCkD
Nyj+n5ehusrvqGuffeSRBNn+IP2//ok1k7Nl8riYII9aDrBX+WF1b64b+Fjh
53T912+xrnbQug6fE+RQwLcYtf56f84vJTxiE6R+jm7BKp+xX9vyLdInyvvN
zR6rfI1hG451cEiU1X0a/lL5kbteXmhQPlEWPW10+F89eQvHhi0aJEpJx5Z2
qj03xn5fJ+e2ibIlZv7cf/Xke3cHN+ifKC/8z1dU+W8umX5VGJsonRIu91B5
nwXT+jvPS5QFTf60V/l2/3WdX3xtovSrOLOiyn/ZZoyrcCBR3J838Vb530et
pQqcTZSGn8Ws1m+PfuqzoviDRPk6tfpOlX/cdlpQ9veJsslj/DWVr9bhReRo
RT+YAx1L1H9klMOXo++8dTbJ/NhSp9o/MIr359ubcvRU5L1X0o89d41yttTB
k1lnmeSJfTGnBreNks3xwMwde01i//dDTD5FT7VZElzomYITi3ZrZ6/guFPN
WhW6o/ANK0/vfMMo0V+NDoPvK/plnGOJSgq291+24/Ivk4xr3rbhlWtGeW2a
l3AtyiSdI7zO+ir4cbG7UUuym8U9V+rp3lcV3KXYwvB8Zvnzo1rVXApOWFH9
1qxqZom+83pFpStG6bDC1Ot7PbM8j+9z9d1lowQXPnd3RxdFH3i6ra6s4MJh
7ikB/czi+qjZo5BLRln7s1zwb2+z3C5U87/+Cn4zN+Fzy3lmWZmn1IcSCs5w
aOGNgZsU+T7oQcG7F43i9m2AW8AB5f4Z3i/frGCvpxF3Ml5W5PmoEPuhCh45
7/qwsAdmqef9dV97BRd7d7r0G0W+3wz7r1wDBRfyseseHmWW8Ws8ctZXcEHf
yu3eKfK9wc3eeVor2LXGyqw381rk0dwej/srOHzx/d85KlqkQvYHwWsUHFDg
6AAvF4ukNpuU76qCJ2Uu9GVSe4s0dd+0zkF53nzDShf43MsiM25OquKh4CLr
pEOeCRap3GN/zAcFzzS63y/ta5ExyY2Wqr/HBBfvdWHrLdL99KWzoQpemckt
qc4ui+ydkhRUT/k9h8X18oy7aJH/9vUt6Kz83g+feucseMsim/L4bZ+n4Jbt
/a81/WKR0Ks/DtxV3pfRd0SD298tEjegXkKW60b51Wt75kdqHWTNbiOOKu97
2NG825tmsUphl0URDxXcaJnJeWFlqzjesDv8RFkv3y89ybJe8ZczuIzrkPeO
UbbGnP8wZqxVUtxa9dtwT/n+2mOcc62xyoNzVTf3CzZKUrlOp8P2x8mQDgX/
zDIZpercQ8bnj+MkW5k7mzdEG+X0xZprVhoUft9S9/d/jPL5RGBuL0ucfB16
oK2jgv2cxvsm2xul8dy8HY/8MErFTxm7B5Qwyt2+7n+sYcp6z1/v7hdFvq5s
Fp1jv4L7RbXqd8U7XqY89LhzV7l+1NFi2cetUeRxp8N724UbxXN8nd991sXL
0LbDzAYF14hZkOXkqXhpPPnp5EkGo5z8UTj0vCJP3xZ5/LqzYqfl9+npsudg
rDQo/P2RaxnFThriOqDei1jZ3L9Mao3CJtm2KE/z6kbFf/j47VNAPpPUfLns
TvPkWClX8KzzbXuTnGy1cZ8qPy/WOTvfNbdJSqaeCtrfLkFGrbhzwj+vSTq8
yPUhw4gEeTw1stco5X4b6+Q5kkGRl1GNnpQ4VdokI6eldxpdMlYqfXccWre5
SbpcXTvjr4KrxyyelVfBV3uUeZy9Saw0GvX+SEBDk0iR0gO7KvLybLkVHY31
TdKrpFuZgPcJMi/KY3qXJiYZfWPXDHtzgmKveSye19okTQ51K3xutUFmD8tU
zzzaJEdu9Irfv1bx/4p2PppNwed8fi+tpvhnXfJ6tc7haZIbV7oEHFLkZbeh
hoUy1CQde0v6tS0TxSF05L7mI02Speax76UGJErOE3mv7p5ikndbP2dZFh0j
Ja42n9hVkTvL2xQcPKKkQZa3LJTziL/ye0VVfTfPySCfvK+VvrvKJH3qDu7+
6lCiVK5+8WHrnSa5fulIs6wjY8Sl1++4bYodWmBTvkutFf/34bTXgacvmsQ7
T5/qz1ZEi+lx69gok0k+/Y5zz/Q0WsIatB7SPcwk5/NMvh6XLlq2Hlqy5VIx
sxR06xZ6RrEXX94sf7VzB7NEOmUvp9aFb/b+s3l+O7N82FmndoOrZolvVeJL
w7ZmCej558Drb2b52N3Hd0obs4y4WvyenZ1FYgennKuh4M5tb295UtkiU6YO
qOKl4DcbJ32s3tEi0euu3i6sfP5ltY12lZX97V20+G035f6VbjXpfk2x174V
aHjmT3uzTP4ZWGxs+Shxzv/Iu4qX8vk/ncYOVOR98PwFXuE+ZlloGBX3oI5J
3u9o+LvJBOW5vLN8/qPI+6OD7zYdOcoszU2nsy8eoKyD0O4vBo00S+Hc/Tve
8zFJZJn4t8uGmaWE34L1e5eY5JTs8WnmaZanp3fEfFfnLo6+lmXYULM4B7XJ
0XWtVe4VrHqr5wizOL3adqv3FqtUfXbs1Q3lfp3K54kaecEqk92HdFs/Xvl7
jy+olP+tVabv9q0fOsUsz5aOyrq8l1Hi4/u4dNttlmkJrZoGzzVKk9pH5hg3
mOVt5KGIgYuNElGh0qMN683y/nyfESd2GqX6oGEtL682i1/07CfuLeJl3PIB
7mY/s5zKO6Lfvo7xcmZ6aGHTOrMcXjYmd+NR8RLy7p3vue1myTi85ybXbpFi
DbjWzO6GWVb4D/x7X/Ev3Ru7na38yCw/DHFbFsfEyfMZB4KzXjfLjaKzX4xI
iJNijkPDwxU90ONQRPNxiv30c3eDAvkVuz/dQ2Pl1u/iZerwmbF/bit64n6X
7W8yRcrdcw1qRf80S6YVx3eXGBgnx4vkbFDIaJZmv2+Hjpqr2FWtjznE/zDL
Heea2wtUSJCXzW6MOvlb0SNz/d8UkAQp+te/10WzWcZdLlv7xsUIefhn0sRn
eSxy/+HagUkOcVJpa+vHUxQ/YdPpgjkyToqQxFJHBp1sqMj9NZ298x+PFYlw
WLywlUXaxO6f/+RMgiSW/x6ySizSuF3gwH3VImTdk/wL/bwskiGs8PO56vk2
JzKEdlf8hH5+2WNuKTjTY3u3agpuHvby3L7IcHHodbHvpI2KHupSPnp8oVi5
t6Fksat7LDI51flUUcdEybp7/ZZPaxW7f5Fnn+/FEyWkfnLVUZst0nbKGKcN
JoOsyFGx4ZzLFvkV5Pft4mmD5G/aaMfRaItcn+c967eCO/w+mLxAwWviR+Xa
3ytcepbZftitgFWO1HWf5LrcIFUOLfH4ms8qrcYsfF9d8eca1PadMLisVYIq
X3dfPNUsc7akjnIqYZVoU5NXn3aY5czsdJZKRazSYOmlcXeV91z6V/YpCx0V
v6H8zgINlfdUopL3j44KDr0QlE7CzDI2pGmfaw5W+VOn8efTf8yy17tu13kK
vlPl2qwRyn6992PPrmDleQbnehnTM7dFDs9d8fmUgkNCayd2qWKR13lGZ7yk
YOfPTU4411J+x9lxNd8o+FaRai+zdrbI7SLvE3cp91v7q5Vv6x4WqfYka7mv
Ct6Xw73IvskWKdXxXq11yvO8Xrz19X4f5b32G7/jroK3/rpzvOMWi4SUDb20
QPl78nqt3uR2SXlvHtsb51f+3oaTzq/fpPhf953jc4xQ/Kjnu+vVXLA8UZI3
HQ15rXy+9aj4Y9V2m2TUoEKHGre2yuPg9h1+3DSJk3feDCubWmVRtah5IY9N
4v84tcOxRlbx9X3/Z47iX9Up/Gx6ZwXvis3X7u4EqxyuHJf1WXPFb9pZ6e3J
SVZptNfzbb8WVnl7I3W+m6KvO2bqk7FcB6ucvlC6t2+2cDE2vOwxd5hVOlWu
3WufIo86v8tf8fY0q8xc9ebIyFom2ZA+csX1kVbJWaJTib9Nle8f/mNnG+V6
321XJ/R/o8iXYwWnFRyuyIlvW/Z6f7PK2adlvpxV/LwzhWN6HUmyyuLHlx90
mmoV/9YbWw9S7IZLX9K1X7zBKj6WGXE/XhhlaL7y69v4WWXGu/u5r7RS/KOM
98p2V/y+GJcL3XxmGuXv3DuhKy8rcmu44U6b2kYpfWbzgAw/FbmVsZDPj/Px
Ujj48+cNkVZZ+Xrk9j6DYyR5yKei7nnjJditcPmQaMVPebA6X1wBxa/r1y3D
tbIxMtK6y6de83jpMszPf+yiOLnxoZPvkLHxkq/qliVDBih+zJkqnXzXx0t3
Y6XSFTZHy+3zs0tlvxMvxmN5fodtipbecU9cuip4yut3U+s2UPyWYp0Cnypy
pprrhRsOoxOk94iaL8oHxcucsqs7pyj7P98x34VT/sSL4f7bayc6RUtUl0UB
BxU/rF1s7y+32yvY979Ij+IJMuSE3ajnplipEdrQb5ljgvi3uNt629EEmRRo
ODlO8cNSUyN/2RWIlqAN1YObjkyQHSsrZI9R5EWFNe3n/KuHH2NotDghSkJ6
Wpzy+yfImK8H7E8di5WdX8c98tqYIAdnB79a9yRB1qef8/KcYje4jB3vk+Ne
lMz8VslxRWSCnDt+VRYuiZV2nt65jkckyIscn+4Ue50gdT9nW+BsSJBKEzv9
qaHgoP0Z2+1UcK+ubb95nokSQ4UXB+wKJMo41yWfAj8kyMop23e8VfCUHjsy
xIyJlWyh/VtulkQpEPe74eohsTJ1Qsj9e6MS5WjXnyfaD4yVsk7pvNbNSBTP
coVHnFoUJaeHtix+cl2iNM3ZIuHXtChZ/bHFnNx3E+Wa68X+HSZGSb5FHe0v
RCbKYC//mNPjo6TEgiZv21kSJc/a3hUWjI6SxnUiY7IXSJLyFeNSjo6MkqEr
1hj2l0uSXsmhk3KHJMjMN/Mrjs6bJHunecpRrygZ/zDux8LGSRKZuHvh2LcJ
4ryvxwr7lkmy2/h+/JxnCbJoTtmD60YnyYTpr2PHK79bZb+NHmdnJEnH8BrR
X4ZHyVzLwf/WrU2SLDeLPq89Ikq8A7LsfXIgSewXHN1+bFSUdM5Y0rz5WpK0
dVp7ff+YqP9H1pvHQ/m9/+MSiVRoEQlliRBRsqRrJBItlhCSVFJUpCJLSQtZ
SloIWZJspU1SSqRQdqVFtoq8bMM9+8LM/I7373vf88fnz+txztxzz5xzrut5
Xeec5xP+2WmtHW+eBKeg0750H4T3ZB7axyA7K+bD+Qn0+xxsNR0ekyeB/Paj
xY6TZPio4PLmDX0SDpiVCKz8KXBkyKLPb3wSRi6FcBglHBgKPWZ/HfUPE7NZ
pYnyayvLU9IHJieBHjrj2OJIMnwPUkuzUZyC5i3dCwZjyLDryZm7dzdOQf7W
wyfXoPH+fnrYYMpyCmxf0moXxVOg79Rts27bKSjt/PfbMwHNK5W9WWWbp4Ch
w3W2jeFAtdK+4Ls7p2DTRWep8udkSElJUfyVNwU2eVLZq/ZzwDNqx0uxW1MQ
IffaauAjGTZq9s9u/TgFP7esrFiK8PSVyN0LJD9PgV/PJnl7Kw58Prvm9jfU
btkxZ2RCiwNxG37e8R6egjdfegauCMhwRlTu4FN5HjSaFKu4iY+DT/K6FZ+U
eeAmOmR2hcmG/UX8Gzs1eODlc3rBYUsqmJadzba25sGJBNstgT/YkPPfEwNt
ZM/f984p33kcDpR3xF0M4sGpiugNBY/Runcv+bXGnwe2F431f7dwoa6sI+JP
IA/KE8bIck+ocGqD/MInd3gQUelzZhXyE2ERNLPMuzyIjbezbwtkQ3KjvMG7
dB58LkzI285Ceb9gv+LiDzwUH17Z7kP5jA/GWCHZxgMNV4WBg2pseOo5o7mz
gQf3k6/nhO6lgaPMjMpQGg+qnhcHGXWxYJvgdnXOBHrf0jHKSD8LJNhGu5JH
eRBzfvCOxyUuhEDYm0VkHui+HPffjPzphz9/HPUV+PBpWfAh2WYa9O9yTpyx
lA8HuVTb6TxrxMvgS4IaH3wjH9rWWbOgfE5DofNKPtTZBNw0CmTBU9M8v02K
fAgyufCKgvz0i8uXt2TL8yH/UoLKz/1coGlYi31E7Ve/Z9ee9qGDxh6dx3tJ
fDi36NhTz0g6mJ8+XBpqzYdZfeE7zp+nQ86ipX0mNnyYefGK90wUzxJLT7y9
aM+Hpw2JtoIqOtw86vLfRgc+1KSX96rcRvE0Z5v+rh182JszZziuEuGiSxpP
bm3hQ1Hy5sSpd0z4HfbQwwHZhj75HcHdTJi4nHz5hiUfLogYPTceYcJA5UXm
o4188Fi+97Up8jNqquGbMfQ+hetvi3UxJ4CrKd7y4hgf5mvzSipEMIhV3bd+
RTAfFE7I7rmgwAUZp8Uzso7z4fvySNdyCgc6W0bivt7iw8a71vShIAyCSR+S
r9XwoWmY71iJ1ptigtrv4SY+XIv679qJ1xhEFstx7ozxIfbAv6MBXzA4omQR
WsThw7iV4REXlN9ZWFuofhzmw6PysaspKJ9rOLOEbqAsgFPZt9h+GzkgaR9/
snyRADrZlv6jgRRQMk68ydgogJkzPI55JlBA/gOreslWAVjP//JXqYACRll9
C7ucBLCq0K3BqZMNmSVY/g1bAbT8dv2t/4sN1wLnvFmNbAq1W/eJ1wgE6/wc
/3laAEnHdU/7TVDgAblgmaq/AC5VbHEwnqLA2TnSO+nHBKDwROnEKgUqDKSk
sreGCODOsB7vkDEVdATfLm09J4AdfHfJjWj+NxQPhSw9KYCjYpL/Eo+zoTFD
vPxBsACuvJ01b+AKG/qtyqJNjggg2EBHqS6JCud0KtfvuCWAeof8GbIFVHjq
22QVmiaAx3PX+Co+psI+Up/KjAwBxGm8mXraRIWp+a76vvfQ99XIRceNUuEi
3+lXeIEAEmKs042fs+Cz5frxBGRTJP69XtjDgiin8IjzmQJ4sclsrmQfwgkv
HovPRLa+im3fIy6a34w1XeTbAnjo4/t52HAUchdnNobVCmBYozCTazYKKp7K
C5d8EoBy7TC7NJwGCxXP5+yoEkCbzMKSpDga+H3t7D7wXgDrMfG72+/T4MlZ
eecvHwUwx59WPVxEg/irA3OfoOedZzRqXmigQcL2VrWnnwWQzaime47S4Oou
yZMHmgVQNpe89ZQ0HcR/ffVrahPAfbfLDx1fMWF9Ss7wMmTPc1PYu/Y3E7jr
3atPNqLfk36NJSrGApUDEgcr6gQQpbO88/lsFmjMTNktg+wNkYOpkuoscPlu
zZpTIwCHHwlWv9YgXG1VPG8Avf/trv20yvejsOH5j4/3JgTQGFLj/aRxFBb2
kIPdqQIQf5VzcunBMUg12G4gKi1COrNy++GwO2Og/zwz/4usCCnxXqNBTiEX
ntaMUJ6i9jm2km5/lMkw8ClNP0RFhOToeqOyw5QM6ssjtEVWiJDG7vw+SAki
w5VniysEmiIk8vU/6l4+XPD7nF8WitrFo2c9HVIYhxsnz2mOrBUhPTzSc9gS
4Z83c4+evmsiQjL8bC+2B/ln0vC3yvWmIqSjsZed3a6OQ2js3aE9FiKkPwPq
ttkMFJ8dO7S2bxAhNatmXfFZxIXw8afDgeuE+iE3P+c8nqeAAfnF2/ie4xgc
FD1R67NIyP94SGeGrMwajOArWOC+TGChhMGMNfOV7/txiP50rdBfYbeFeiM4
v2Tj8d/HODOFeiNGJ582lZMwiJfysqheTSH43fH7HZIhl26WbsEgarZ8T04Z
G1bFzg8udMKI+x2TzQ5saSsMvuwbHPhKZxOfx+970fO6WKUBGGzSy50ztpJK
8NXh/DwmferSn5GfGsj/R/L4ySL4yuzVClf8QuvDi1yvcSIKI+5P3Vwl9epp
IAYil6Ky/Xeyiefh9yd45qdDf6ZgMGJpwClA8xvnu8Pv21oabBY9mYYR/DrB
P1vqfmRgxP2kSwpiJhJZGHE/6Yraxb0zcjCCf0OvgPrzULZQ777MpGaDRKZQ
3/7mD6mKXelCPft5cw772KViMPmxJvOZNot4H/z+8d62/f/bv8X5Zt2jNrmm
/xTq0S/T0rus1yDUn38h3uWYWi/Um+feuPfApFaoL6+scklJ9gNaxxciKbdR
/LoV0PNCv4YG3FVRfzepsAgbvy/i+3X+G5GPQn35d6+Wp16tE+rJZ7RGr/D/
LNSP980VM0lvokHG+UCqG1Bhe+ot7c9iQn13QaRtjRmTRtyvCVelXxjHaNCi
Vd2W0Ukl+Prx+zuHH38xryHTwDDJ/cZkFptox/kLUh7M5nvSaYQ+bvy/2dzD
BkK9djet0nXpSnRQO+F3JL6TQujbtJ1+PbvSh0PY+H2oA9uKUwaV6WBFvlSf
14YR/Bw4X/iTHZRF7S5CPfcJWOQ8YIOeJ3fZw09ZqI+2Z9CqpfI/oR586MKa
Wz1onWB27WWdF4V67qIzFzw/cYIOF1ed8quIxwh+RJwPp8jFRtsyiA5FZ5dL
jm0T6sM/PBE6VJuE4vuPJ7tUrgv5VScMfmXHlNCBJHrNKkhWqE9w/NYZvlOm
UL/n1F7/E7u/c+En+Xn1ubdCPukeGzFF8T6hnvzqKGueXi0dHDd+IWe6ThD8
nPj9G7eaGK+z0/supbvqzfuE/J2E/kbKcq894gxIGl3yNaFgnNA/wPmnVz3V
WjFpwICD79Skz88X6r/h/HuJdtcOihxgQJq0bLtsPJnQe1s0Qz0ld4QOtpbS
OSvchPr0paVZJv3bhHr00pW76mbaC/Xn560O3X13q1BvvlVEZsZjW6G+fM1d
d00zW6Ge/KRPVswmW6F+vN6j2g2fbYV68dK92bVtW4X68NwVs2btsRfqwW9d
M+h4fDuD4IejYLIVBUEMkKqRs+AsEOrR6d0YkOztGSP4RXB+7bkxG1f9PMcA
jfB/1HG0zqtvvKj8eEmo9148VJUhdZIBy1+efz3Lik48L5h3MHjLExZh43wE
mV1nDS+h/szH7pc7d4/BWlP7Av9KBpxwWeFQWjxG8G3ifLiWv7i0tudCfXc5
n8BHY2no9wXkPNoWQiP6n776QV7ci03Y+H2seqtXumUtDLh2QMLHdptQH2/D
3Pi7YzJjkHMz7Mrb3wzoeaw+xL5PJfhH1tHyd5o/pMLtVcUZqt+F+vAWQxfc
H6HPZy+h87X+Uonn/fP6L/9Mh1BfHufz8xLtPn+NxgDXlbmnNVmjhN7F+YCK
UsGnUfgU6CxhJsEk4s1WmXLncjQPWIN5RfXrhfzluD9bVeVyxUqECbMFKfvi
AoR69fh9yDmaNndTJhiwepJ0rMCAQ7Sf/mwn/yCQA+nn3KSiZZnEfTvPxAsO
rUuZEHdcdrVE8SihZ1T3eaRBLnoUHFqmyN5rhHzoS3L0nYIMmRC+tzJZcrZQ
P7DhutVyw1gO2O1e52mlyiT4DjWTWob5W5jQRZJ/0H1glODPldJa+lfDdBQm
K9v7q72ZhP7cjrust6ruTOhZO//xoecUoj9+n/G2aIvB2zNMkLGWaKpXGyX0
rhxi7DkmlBGIWuE+Ofsmk8AH9cze3ENhTMDWHOza5yfUI8T5pI9UHctpusQE
3TPXwR/hn76dbR1iJ5kEn+2tVOds+5dMeHO+Qa1PnQLdb/vIOmlMsFQwO0ra
zAWpMLl5u6qZ4JceOixbOkLoF6o+UtN+nDYCsz8abnTsZBJ6oV7uc80Um5iQ
cGCOqOswRvTH/XvF19Cmi+1MULONOhp6GD2/WftnA8rDWpWlk+2iRwg9Q5yv
W7F7RF1SmiXUg1lrzBTlM0Gyw3ToSSlG9Dd6mXy2IQkDm0/hq4fmsuC/Dwe+
z48U6iES/Mjlyk7YIhYRH7q4cge8lFnwxmarntxFjNCvcvmnLdmBcNNwe8aO
o/os4Pkcz2mTFPLd09oTpNLmMUDTrzR2XI9F+Me45F35nSjO4/7xmVOwW9NS
FmTFvDJxymcQz5f53BF+8CqTsHF/li6+TumEEovAN84kK4MhVRb4rH58+ZbW
CKEHOXJShuW3UMh3rnyve2Owwgj0H2tdv24XCx4/KylrcsWI/t4rMj+rbsKI
/ni83Ks7SyPDmUXoEYwN3mQPebIIPHN9xNDtvD0L7ocU2V16SCeeh+OTq1+b
zG7askDbKXvRrdMsov3fw9gNe4u50Dh/Z1HEFoQj02+1k0WE+l6zZ7kUu6/G
CDtyj8EW/6UYwc+O6zM0Nd3rKwtnwfGisCTzcRrRjvONV3xJKZBHtrnE6LWF
6kI9S/z+8K/UpcX0IBaIDiv37h4V8hcnTLwJ37maDT7LPe9nJLHg63F2jCiK
18+jC9T+3ES4y5GbZSOJEXzXKulLHOsnJgj+mJB/A25/BBNwVOXnF+0HQr2C
sThD69hyFoGHw5PCI2zvssCQYt6z7R2NeJ5HsP2PsyQ2YcdvsDVqO80G8b4d
HX0VQr29iDN5T7tLEG5cpggzOrlE/+iBWxHHWyYIvu05kiGyQY8nCL4ZHK/c
vKDTF/FVqB/S4zT6Ue0PC8JSN87cEiDUG4pXlTx0IpENFPLOlIoGFigsmByo
SJog+LpFcq1jJIIm4NL473XOs1AcGkxTx9SF+p5h+gOH+n+z4c/ytBN7ZdkE
vplv5rbvw3I2zPFO3kN1mSD00nB9rLfu+yvyN7KJ+FO3bvshKxU2bJyx4obk
EJXo/3ze2I1glN/j/Da4Pkxv4gYS6LHhUvBabuJzKqGHlDw8ZlSgwIEwx3kL
tHew4cX6zKRjE+NwinL7341ANoi6bY/d9HOc4LfB8VmvVtun9LNs4v568oKC
BcrIjt730lj9IpX4PK5/8oa/p/hAEhvuFDz7nbgN5XtvYYiczCb4KfZvTLgu
n8OGUw9utIvUjBN6pzjf/eSfLR7jH9lEfPwY5DUrOZcN6luzy/7uphL98fjY
cTn0Z+VLNtxe0X472Vuol4rr1ejwuovcqtlE/vd5PsdYvIkN2q1nE+YbUUFs
0n1SoZZN6IME/QowifnLhp4Fp/1PnxiHJoF5TM8Em8CXR4alpHLlOQQ/QI/a
i6cHuWyAfR65mrJUoj/OF80JbFVoWMCBreJj7A8xHDAbe5Zcw0LrTKO39exN
DtxffFv7IGrH+Qcym/1eDK7mEHx26+SfWmbbcKA6M9cP9IR6VXdvbDLnNlAI
Ph88Xo9eHLcyRf+7/IPkBdZPhHqwuD7QMeZa6wUoD3G5R/M9NGOc4PfB+eEj
bp9v+BTOge+XnvZrVqH8Zd5fTa0gof7e9pBW5bJrHHicFnfSq4tM6PflP3//
ITiFQth4fOcfVHZc+IcD5lduXLZsF+r7fYzRfdNZQSb4gHB8fvNTl6UsV6hn
y7p3KfQChQNGSdmRB0IpBJ89zufn/ikw6MwOLmjYuaoVZgv1uXqzso/xfSkE
PxCer90QcXYZ28WFGWcezT5yikzw+eB6EFJ5xYLKei4wS0X3fXKmwMG11LOb
67gw5KpcbH2MTPD7xGjcfHPxMJng8+HWVikEfuUQfD74+9et8mc3OUyC29yl
URuOkAn+HpxPo/TC4MfiB5MQr5bGbKkV6oUZrW0523qcTPD71PCydUN8hXq9
+O8Bs88DawaE+t4mT082b+mfhHkFV2xtQoV6vfjvq7XJF1WUngJji+jtuXc5
hJ4iXo/5W3t/hjJpCtYJnv36gPBY4pk9O+rvTEHaw71UpdMcWHuwbuS/E1PE
+nqvH797f+wUzF7zKQJ7TSb4f/DxLCw/mWxROUXUhx6VmawsezAFyVYVl0W8
OIQ+I64fk+jzPO7q+ykC38o1KpLMutD7Dv2Fs3QKWF7XWf6YMQWy+ouca2Q4
BD8QXo/q6jvqzKJOwU4ZCSxfgQre68RcxVR4hF7G/pQWk1lWPPB0XmWuy2fD
rtAdi5lKPOCIK7HVQKgnjK/3Tc6JfnuP8eBOb2fATYS/x3Y5NxQcFuq1nd69
W2v+Lh4cuThZ+B7lA7g+MV6fMoqvOql5kAePh58mBf7lEu2KM/s7YqOp0Nfo
PtMhjEfUH7w2yD46eJIH5zaKBVblsQm9SFGfJ6+mz7vi/EK4fsavDy2XqqJ5
wFec68u+Ng75O+Kya3N5UPXRSyS3jgqH383jHi/gEXyOo8vOVxws5IFFmOTx
DUeFenO4PlC8mF671AseqHBbzQ+/5BLtlzz9TGhFXIKPCNfXTjO7VLCzhAfs
m4F301rHobNEPquvnQe1hXX6bZRxMJdrLbEf4hH8bJo1g7aODTxoKaG9KxKh
EfqwTtHxnkwrGqSKKz00Qf15NoLcLhGhXhGuB9L514E91M0Dwx2fdh7SYhOf
x/n1okN+UZ+h53PsvEW/3uUS7TjeXWlya+bcQR58O1tC/mU6AZ4ZggieHB9y
Ex6SWvcI9XpxfZRnloNVIdJ8Ip+tK3qrHcXkQeMB9SzTDhbRH+fneLvjcvdD
AQ9CtAI09pznEu3/faE7rvblwpMYV6lyeT7Uyrzfkek9AaUen5q3r+QT9cDk
2knnehU+7OnaU+//Taj/geur7bnhflZbn0/Ux7z9k2RIqH/9LTP7Db5CPUC8
nvPkU8sPp9V86BVbqViwj0u0S4pe7Vlvifzkcv7nbCs+LFbwrpvGS0WPQmex
tgv1h1P8fzEltvJB7IWETVQindAPxPkRB+44STzYwQfxK/tNXaWY0N4ClRJe
fKI+kfSzY5LkwCfwPG+G7USmHR94NaW/Al4ziefh/LJ6Gb3Sb9z4ELrTfFTF
gku043oz/XsufHnnz4dSd1bIel0MDpqPqtJuCvUHLyqm59dE8kHPT3ap3CIu
oV+I65kk5fWUd13lg8umwe5ihP9DVJe4i+XxCX7NdxJFS5Zl8SFtqd35HGTj
eh0jL578d6KFQ/An4f790feUxAslfLCY1UAquYKBNu2d7vx2oV7WXFXNvvUD
fLhdnLLsdCmH0EdcN5drtL5OqH+M+79rj81W5skKgNIx61hXiFB/XPpnzKkT
KhRCrxXX1/nQ3O9Qvl4AEsb+M630hfrjrRrbuhfOHQGL4/M0NjoIiPpuzHDv
Z+XNAnAQYafe4g8T+jFUktHahnihngzO5zcvwmnw8k6BsP7Jg2eb0fOizDap
pf1kE/1xf1dmORzb6iaAtpwOi8e7Rwh9x/umP+o4z0dA+8PHhcV3BBB5ef7z
3vlUoh3HZ/u8E2s7IwSEHqB70+iCoTgB4b/+iVnXSoQJYPuN6MncAKF+5OzT
4dG2fSOg0JHzclER+v5/i26sf0cl9FNwPM1avk3vzAMBPHsaVMs8wQKp4sf3
q14IiPXt77D9cP49ARgYrH2yHeUN+OfzPLE+uzoaoa+Cr1cL58NHmhoFRP0+
asPEy/utAqJeJvlI5u/SrwJifVg36L791CMg1kNL2eSHo+0CIr+dVG5vO9ws
gGZfQ94QhUl8X4T4j3W/EE7B9Vpoi7FlWPQYoW+N+z+p67eHNGVFSPP77P7d
yeES7bj/IzkG5P5cLEIa9GgtfuZGJvQu8fVVmWF5L9dIhIT7D9bZX9L2miKk
Oq27+/i7hfqYOL/d+VIzXoq5UA948SIVd9omERK+npY+Ui7aACKkU19fb41q
4BB8RPj6eaLlYPgB9T+QOaQwQ0Sop4nnuyPK6hG8GRjoxWS9SPyMEfomeP3k
/slq42G96f2Q8BNv71H+j76mqdahmwNuGMw+UeLR1Uj9P/qaBzuXlJcgG48v
103dnip/pxHr68Itk+duAhrAcv1/tCIOwfeN4607Sw+LndWnE/6pqSkmp9qN
DoVbjEKtUTzA+bXx/79I877OQeRHaf1R79qrhHqcD5YnFRxUZxF81bi/X+e8
8fBSdwbxfqe+DBTlRTGI+F9j5RL8t4hB7H/duxJ4XKuZQby/wh0PLeNvDCis
LcQGEf7C64s4frO0cVP9MJcJelmm/dM8IXh9D/dfC3WXMXepMwm8av+LuszH
DvVPCjRyrRDqY+HjiXHIfIfdTPjv3JEkSUyoT4/733bPjQdPhDAJf7/uXq/W
YBET5F9bj+Yrc4l6m028MbnUiEvwGePxysKy7t6sSiYR3wT5ys027ejzxfdf
h27hEvW1lKb+23M9uEQ9Do+/YuF+eTWDTCJen7TI7Ejjobi1Zr/etQAuUT8L
mOOzeocqi6hv4eORGvnk1KABCxrPlpyxePl/9U6/Nd/XoXig/tqmC+0KuUT9
B8dLyS9GW4bsWfDp1bnUqiXs/6OHevRJtodsAgtWfl8bwnrPJeozqRveujY1
c4n+uP6ZU96idefjWSCn9iiu78D/1U8NbNI4GVbGAourf0crLwr1yAh9XdKJ
jNQWFuHfs7vn2Cznovcnm1vKvhHqk83Nvubn8lWoF4/j6cItNP8wKTYx/wKG
NP92L2XDVMwd/ephNlGvwOfjqjmvHINXo3kcczLuoSyHqE/g+H3hmgXhZW5s
OLlyXZDOWg5RX9iqqXm5wIpD1CfweGlqNTR5O5ZN5BcrEhIDXuSygdk14+si
Jw5RL7BcILX99wUOkZ+rHClerobmN86fi8/3Mtk5Ld+Q/bOtcH9+CgduiSnL
3lPkCPM1s6ZtDzKR34oWIeXVoPgs9/HZaDoHRPepk4/sphD5G84/KLMpa0+F
8hRowZadL84I9evx/NiD19O8YNsUkc/ey+1vmhk6BdHnxCu2pJOJfAuPx+aP
VK6bBk+B+kudJbuRjbdf3ydi+LaQQvCx4v4vZkz+j9zNKaI+8L1eCnobpgg+
3yklF+w4fQokZh572PaXTOjZT6lmrM2gUAgbr2ekJB0vXMSZIuoF9vyKCucV
PJiltdD8kTyVyKfwesoDvYK771R5RD3jnkWnpK4dwuOyabdZ2uNEPoTXe64a
pUooOvPgl1nwFa3NVKL9nKnbMiMvKpGf4fWmiXi9ReL7ebCMfVjB6wyVyJdw
Pa5T4jOf+5/lgdnhySle7DiRz+D1pl1Srat/F/GI/eFDd+Wr0+7xAP6pPTV9
SSX64/EicJ2j77lHPNhcc3Gz3ftxIr/A498l6+LoMZSfqB0v2zFPl0bkL3i9
cUHP34dWAzyCX9rm09ebT2goP00I+nhfdILIF3ondGc/1pwg+FPx+iCp6FoS
C9n4/liHkZzuIJdH1FslK+z5b2ag/OBxgaLe9gkC7+P1ysT++NgylD/8WVrW
1SWH4tDXtYM3UH5gpO5qsCN3gsDbeL20/aXIBMmJD+b0wqKe7QyCzxTXUz69
uadYfS+f4BcvUTuh2B/Fh+gU1bw+FLdx/L3seafpgBJG8JPi8f1Q6UN+OcLj
7Bq9+H5TjMDbeD1+rVSa7NUCPrE/8VP/K+t8A3r/pAaF4nCMwNP4fofqwxoP
w298+LX8yLP/MIzgH8X3dzhOYRVdcwXEeZN9N1/cZmkIiP2htorCuiA9AbF/
sOSO1WkbVwH0mVmJn/hMIfhG8fVkPD8zNcxHAJx7VxbsShgh+EFbX+9MsNlH
/T960W3i/+35jGycf//TQtbniFwBip87FhjWjBB4E9/fUvvhkHP4iQCuVv24
tduA9n/0pcVXj664VSYg9t9krHVHir+gds9a0pGNowR+xPf3XGbmpp5C+BPX
X5399Va+cq+A2L+U/JbmMndSALVSNNNH7aME3sT3Txs0sx0Wi4qQtKfm5Z7+
b4zQ38T3j/mNQxd0kI3Xf+ZnafM/6YmQNrYWO9S+YsPBh6+iGhwxuGJy6FFJ
Lwte2yQv2hmFwZLIIWN2JwajK16sXe1CBzdwt/s+SoedbYyQmW4MyHoze/gL
Zwy6TDUCZpxhwMVBB+tG/hg8USlTkQthwAv37w7uj6mgY+ElK4HwzrP1rp1X
rajg2V9cf5bPAPFVwyu5j0eg/0vQTId6JvDn54dn9mKQxgxKUGtiwm81E8/Y
sBFYv9B+tJzBBL/LS+9Gz2dAVee/ug96LFDTqlRfrDYC1au9DzO2ssA6vWNr
zQ4MHqiExx/dxoLsIQihamFwUeOCAe8UCz5bfJHeNEGDMr3OjdP7Ql9GEhIe
iGHwsV991D2bBUqpbNOPHyZAU2YyIR7lHd2tL995RU/AH8MI6VQOC06Gjqu0
R0xA2S7mYAGPBdsk+oLmK9FgnfuIiRaDBaTPGsr5HVTo1cjSomix4eZ+qaqt
6Pd7mBfXnLBlwxZXoxu+w+PweYEVZ+5pNry10317+fg4XOF2nrSnIZyhlyKz
7g0Fmmm07xmhHAj4e+b13B9k6FBsKs5r5kCqk9STXzcocHPPqR8HUd4rd1G7
9VsSBdSi+4KoCOflM8pKVoWg+DZzpN1chQsur4qpsc4UkI38LPbyE8JdGepX
ZVFcTPZLiytdMQWcoKxtd4I48EwizedI+BRs2bLSIx3hz+9ZrSVLULzaWF5q
VvCHCw0dt+n7t/Jg1e4NEwfT2JBD8+gtiUD++d2eYst7bKg28Pq96zQPLPO/
OxU850IXV9y78z4PdiZs/pogygbHX877Y5H/1W3//HQlwm0yPeo8CeTf7tfY
bR1D+VdQAMOYv4cP4/9uWEv3cKAq8fuBmci/KF6alxE8iPLnBqXhbpT/d6bW
xTMq2bD27fMhr10CUBLf1ig+hwllD9kfqtD64VDLs/d848Kz0JQFczmoXX/7
p8PJXFAtw2ZaLxQh2d32GL9xiwt+4q1SpAUipIrhPcMnf3FgT+XCBx8sRUgO
3r8vTCE8ovwueTt/Ngaeas9GG2I54KZ1cO+jWRhMlhTsfy/PgaD8iMG4tRiI
SxVbMBQ4cEL7QGi1EQYVWZ/kKXkIRxWVmsqi/KYtV3GDbTMLJnVDtrKjMahK
vvbM9iTKW7bteUD6RYPlcmJRcy/QIHZW1uYXP2nwMMM9+NQaKjxZm9dvKEEH
bfItq7ENVDQP9P+tE6fD8a1al/56UKC6qiXH14gO3Qs31S46SIEeSeW0DWvo
8KEgVO9vPZrvxuKq/h50eHd405zvZhjoTi5dePEKHeokV97Yb4NB9eBrl/2X
6GBmnZiRnjkBgxPr9BRL6bA9jR2TiuLL8Lr3x9JR/hPAEFdXbhqHHNNqlYUD
dPCQzpduNxuHN6nJw9FzGKBwJENnv+04LAieH3RfggHHuY5SPx6RwftSfcX+
9QzYKFGxV/MFGQpq1sqIrmNAn0qt94pOOjyOe3Z/JsqflIJN+jktY3Bz10ML
+zgGmC6W2P7rLQ3UbA/s+hnLgL86ufbOn2mgPjbvsPJlBsRVfzUVk6ZBVCvF
WPMlA1qzN3s8lKXBVLHbg5MvGHC1yHz1hwwqsPz3vXjVhdpf7f2pbkCF+KDE
XS2zmLBCp2STM4oXFy7AorT1TKj+2HdsZzMFnpPWvE1exwTWrFLn8CgK7GZu
urpgHxPCEypFvBAerC6Z52nqzoTor7abrphQIIH83HtGIhNadj3dVmFJgVO5
hyLFY5hwdEd/nx+KH8dvyw3fR/lRhmjXK8cRDKIGltkZovxn/4W8J/uTR0D2
Hy0q4jcTDOtZWfxPGDyvLY9a04PysSQ120iLEYjUPczuR+uk//hHG9P9GGhK
HXBvMUH5yI33WopHMHAuXam/2JAF4fPGiiL5dGhIDXwruwblDzqVXK95I9Dw
iLXGcB8Lah9V+RebY5B5Ze/3CGTfk17XYraDDp/fGvbOR7Z/SqDyst10sNEY
aPm0hwXHwc88YzEGSydUkihxLJhx0WA4+g8NPmlERH1DduDvQ6fUByfAYoE8
aT3KX7Jjx3/KhdBgs0Hz7kvvWCArPldeF+EVrUUmrbv+skDLueL34tU0+Jqy
psl9mAUJpkvGN4rTgFHu+KoB5Suuij6HfD5Q4fqVbbM/GKM8OXmtpdasCUjx
2MA54MmGvYc/7b+XRoWlauYdeR5seBCeMBDaPA7HF2tmGSeh/GZhyxLtxnFI
vn65+iTKmxKXyPHqz43DNffCmFe/2fBkQfinqfXj8ErSo2vUmAOvRNf7UvTG
oZAz6/ipzRzYN3nkjHY9BR7ee9sb58OBwfmnqgoHyfCtibUj+xkHLA6wN5Gz
KDAZ0OAxhWwj7Pt7WiQFXJ7w7/+WRHnf7idf/z4gwxOrO9dXGXNh/jbv5Iwc
MkBYYGO8FcpbHx5OI7kifFLRm1ryjAtrs3LFzT9zoDoGKM+vTqL5JD3RUIds
99mtvNRJmOGmZm14nwNv7LWmYuZMQfkzlTW7znHgmFxyHtd7Cu7mFl7RlOHA
3C9r8nbORvje9e7Sayh/fOwyxzoskQener6nSaD8NF6aqbg6ngcO6mElTzey
YXDs1enfFQiPOwRjllvYcKAwzyKljAcF1o+Dq+9zIfZi7O2Btzx4Jf3rVck9
lM/7TpBMq3kwWT733W86ynO/jOf49vOgdFI3lYfyWg3MghQvw4coyeyZ96+j
cfX+9PfkPD6Mzr0u9XoJC2rmr60qN+JDz4b6rmw2A7Y98o4XRXhUKqP/VW89
B6J1mhbeecWHdElFB41oDhRxHs1PGuODr3V9ju56DkQEc46/VxBA5Vwd8mYU
F4u/mvgUbRBAe/Act7ssNnhsOBh700wAI32eqqrI39qe+3f9B8J/g/7rtvyT
Z4PiTqf9w1cFYLat6kirOhuSvO+M6McLoEac0r7kAHrf2nrp6HIBvL5SHyJ2
ggWVDnmq5BcCcFreMHUIvW+dA78xC+EvAwfV1M1VXAi+YHSmVkyE5B1evrww
DI3rmbLI2KUipMqxhrIOWS6UxZVHmhiLkFy/7XNYtwaD1TPsA5LEMej9rcSf
p4mBSGue+XVRtK4sjH1d6zBIveixUnoVBvfF5WSLBzDIu+3dUGWAQdbz/Rb0
Xxh471u8PHM1BgZ/OIw5aP49im1XHNiFweLo+jnnKilw6E68tpUHBn5bTR62
PKPAeQrpyZbdGLwcsX9w6R0VrHg/XCrPYTDrZVflzj4qbBlNWnHhAgasMo/3
V1G+JBF4buar8xjcdtulfJXKgrV6b9RdO2jgsFBxVagIG7IYMyuY32gQYWA3
ZL4AxbOGqPQNKD61h0jkn8DYkP1GRC5+igYNw7Mzz3HR+Gg9qn7Gp8G2Bc4N
P+ahdfN3z7uVM1E8Gi4k37uHxnvn5NOjq+gwojAzuquSAzXpZfo5KH612gS6
rHrBgVMLnuw8akCHkKe/lorLcOEUY2bAeic6UA2SyMuWcaEx7tLwMzc6zFV+
cy5mFRfa3Y64h3jRwUp3n71hKBcuOmrC7Qt0GKta5SK4w4UlCgHvwm7TYa8K
dbc7Gr/xX875C1A8+7arxXqVAgtMXQYXqiL82vydJNVkinAjK23WYk8GzP/d
V1C0igXim15666P4ZPBuLW8XwnXcDl+5h5EofsXYzZPhs6CL5FH+7hwD7o9K
S+uj/+fMy9VOExcZEPhoWMMvhg17kgrWTj5ggPT8yGVtiWz4KttgbFTIgF19
fFm1XDZI6gqWfXzCgKFYU9NHVDb8DPh9za6NATJgfbiWzYagDqMF0l8Z8Fbz
an+GNAe4xWUfjbsZcMebJp7hxgHHzTRf55kI91TJeW+I4IBky0nzwiVM6Kqh
R5CyOCDVluNwV58JXiVLlbsaOHDtt7iTggMTZO7H+938yoHHfx1TMFcmHIjT
rTv4G+FMwZ5Ikg8Tnpvnx4wgv9Zcqnjd7zITeh6vu+26hgvHQpLE5z1iQsXL
i5wcVy6s7Bt3tfjGhNqONqkPaD1cvOEVyBNhAeMlfb89+n+nZqIVj/C5izT1
5/P1LNgdoFA/acSCY3u7p1bpskBd4X3CPhSvMnUTTMrTkd9U+j62S58Fbbo+
szc9ZMHRSvLSHBeE7xXb8vLrWFBwhfOjzZsFnaWf2uPesCAlq+RHsicLvGMO
GJ95zYW+/JVKdiiexaphOraL2OB0/4VqxgUWZAhOBYoasMHoprxuPPJTRz42
dYshHLw7MeludRgLdBMCkurruQh/rkt0RnbuectFN/ai+e2eUVyF3iNuhbIX
Jwzh9JSnpyoqWfAcS78WjsZPvnqHml0XCyKW3lIobWKDsUrW3btoXnyOm3p+
ks6GN2Xr43uR3xkvHmnay2SDNnzp+KvJhgxS/SFvCQ6cE2nwXGGK/LbVMtGt
Ohzw63ivxzjABolR0pTlBg7obFGSig9nw6Lw96OTJhwYvbOOvSSEDW7Wx85o
7+FA4I3bksuL2fBNsF3ZLowD863Tt4v3sCG8411uUyIHVnT/mx0rhnBq+saN
p7PRfNGVGx/T58D7zwGxh95xoG7Pd7OjCQjnnnf/tr2GA69phiUlaRwoXP+n
kYnikXtO1LDIIw40WYT77HWhQNnja0nMmEnQE/UKoyH8aXG2993ih5PQ8DSA
rOhOgQ7z7MvWOZOwJlvs0KeTFEjseUj6NXcKFgS8vaB6hgJ29IVyTxWn4GT4
j1j/cxSYur6ph60zBeTlqd6FN8mg5vhRs8FnCkT0nd2vppEhOqlqkUbQFOis
qzlZmUIBP9J3/5sHpyDwSeWAQiYFzqkvmxtwYgoOnhEvsc0lw9Y0vbNdF6dg
SlCZ7JBHAa05EXmGUVNgY1ujLVmD3veugtn+Z1MAp5O/vf9Jhj+5FsM1/VMw
ezsjuOgPGWrPaNQmYFNg+5XDnfhLgZWX6Omf+6YgNz7+t+U4GTwOLpusnMGD
url1597OogKdMSRWJcWDP4NU0Wn9rjjptfn/mfHAgLFNlqY5DhHvZnpGb+bB
FdUpaWM9KqxWUPxx2ZAHnKFG/0Um48A46fVWzZUHhrTTVCNXKiScXxq6w40H
Y8ZXXjwOpMLwhTt/vgTwoPB8q0pO0DiE+GR8lEbxvHd82XqJO1S4JM/iOsXx
ILb+Lu/+43HAbFoqXqD4brNlI6/zIxXWPJ1gu+TzwM5xgF/eSwWXka7Aayje
e+faBp5G+aeIR3TcyF8e/Miev3VcG+G79fMijqD8TE7Z/vDOzTQIftIn7T3E
g1/9cH7jognYUP3uIJ+H3revLisWJqCwxE9NfjEf5ug9+nM8jAaBWysvrOLz
IOdSVpZ6BA2eXMrwaUX2A8umn79u0SD815zzTrP54Kxj0BYZMwFbL+9Lo5vx
YcaREb4cynP8Gjorr+nwYenLb+rG8+gQib3wO6THhyMBGW2V6nTQmNOkPQfh
iXlZW5uDfkzAwH1dOY99yN5S7oZtZkBkz5329V58cDJXSLrsx4DyN2u6uxDe
8Kx7azTqyoDX1pvnaSNb9V+AwBzh29+/pLY5X+SD5oqgUyX6CB+/fXj7VAof
fMhtm5PdMRhf4tqaWMoH7iyDOTIob1uzH/sU2sSHzOQ397pyUJzNTLkv28eH
iP6c5LpRDI7aaW21mSWA4bQXR8+LU2Cu9p6IYDkBbGzM7K0WpSC8beyiJSuA
iHWc9llmFHhTsnrjJW0BtL3rn/PFnAJF39oaSasEcOeO+IWWXRTgJfy6GbhW
APUiQR9q16J8Yikt6PABAQRw8xr1PlDAzIE8vnGPAIqvXTZM7KOAw7D5fRtf
AYS9kM1d+oMChmt2NmbuF4Dd4ZlJH2NHwPW96ILUWAEUPldaN+ZMhT0zyPnU
ywJYK607t/wEFdoz5/NtEV4SPaFXueQgFYYeuM7jxgngqOiRnTJ9IzAnPWnJ
jCIBHHC9szZbehTklngcGniF8m1lsWA+mj+9+cHmlc8FYPiGujl9Kw2O6DkU
jiB8ZfjXxaR1Aw22a29+9qtMAF/z+i7b+49CmFNG4+vvAri/uCzN8+woKGX9
J/DoFoBOfs6j+PRR+I/yuLt5QAC3/FMPvSujg17e+QUOKL/30XlabFtHh43p
nlaKCJ9Fvau7eeAnHQo8M9T+IHvK153+mDcK9YOzB/cLBPAmq2KlqOgYPN/3
acBMRIT0LvR9d5TBGEjlS1JZ4iKkpyy7X8nNY7A9LOhRgLwIiTyQ5eQ1kwy0
9z1hrUoipNMyi9Y7DY9BcOknKXNFEZLvZuuRR4VkKPVykWnTESF1FxkdbnlF
hrha7KuGnghpSfTBTTOQP1kRbMwONhAhfbY0E3yrHwe54t2zPC1FSEq1QYs0
f47D/evfNx3dJELC692HlvLSFTaKkPD9uPQb244lmIuQ8HqrR+gPpXNzMOjZ
oaVsbIHB1j+bz7+cjYE9d+tetPrh4e7J3YGSGBR7iSquQThxa3TBlsJ5GHE+
fI4847+chRhc0LN2jfJC+b/RygtSshix31ixMe7IHdTu18W8NSeEA3LttMwp
9PlA+3NyNeHj4PX+/WOpDQjv1mR9qyRzIAW7qkuxECE5+OVZ6Q6i/o/chkNA
hNRa4+cnN8mBu+3Wm/TQ+wcd7ix+XzQO7POZcU6o/WCQ2sPY4nEYio4+ug/Z
+PlTpZvdvjdI6P+Ze36y/eE48TxcD8ukcO3lpTIYcT+r6kt09EVpDBrrFi/z
iOLA/+QCpTAwT7x2Me0bFxzS82+c288D6tELRfCTS+xPPDS12Tb/Fxeqf/f7
73PnEfVpOw27Jt9lGMjGcijVpShfT5hx4YsGRuxn3XlTzULYgqhH+y40SNi4
GSPO+11qudq/wB4j9o9WeoZZ5jhixH7cmiGlJRG2GHE+VubXgjrr4xhRf879
MpxodhIj9kdK09aKU0Mx4v6LkYRq8LFI4X641fV97VfDMGJ/UqtqREQZfR4/
L7blp47z4qMYcV8oS0V+XOcORpxHv/xoycvidIzYb4gSX6pKv4tB1ZiSwxdj
OkjfPbF5djZGnLenbD+j/B/yexHXxkyqzqH1uLIz4XouBu7eu0rKcumwMvaB
vVgeRtSvb+0CnuUDjLifJeswT2VrPkbcR1j7b0paoQCD9lzauSRDBqyRLec/
RTa+f7FS5oG4TCEGVzd/8IsMZ8CCsHSpdcgOWKTTHZzFgH8WaxqVkb118IbD
kRqEu3Pqvjeiz68s5370HmRAQ+K8BDNk4+c7/v7RlzmCvr9/d0PJtmndYKr7
Lhf0fu+1DVdYOTFB+1/1LN59DLK5aSmmIUwoPzaa7IV+39nGGXMM0plwq8Rk
0Sn0+z3vHonSfMeEI2fPe1lkYWB6rJ2m9JcJVxc/7C7LwEB+o+nhBbNYEJm6
OKcT/d9bis6eY+fTYPF2yiM+yq/w8dB5ce9wdjuNGI9bqjYZ4S00YjwejV20
TWqkEeMhZX3hdvcnGjEeV0N3fvKpoxHjcTDx1BbljzRiP3zhTD3NHzU0+No3
21FkBwvcyYllFrU04nyNfD9nNbWeRpynYwQ4mrLRe+H75corTgw4o/fB79fu
vvfmheQXGjFfzSp2aL1F+R4+X+981zYWsGnEfF2f8Vj7Ko1G7M8t6hu9dgD9
Tvw8kueVZBoPoxHr41CIZHQfi0asnyyxGbYGWnRiv9QnKOaVtyqd2N8x/fOH
Or6ETvivDd2g265AJ/aLTy6at3gtwg34/tJk1SGlKns6cd6htdO0e+VWOuEf
Q3KrrhwNpRPnEb6XbTA1CqMT9yfmF/nN7M2iE+cFfrSsMo67Ryf2/9ibv99J
aKYT+5cX0xavTqXQif3YVd92RAYrMojzvrcDmvWUtjKE93Mk3eVynRnEelgY
0Pwz1YFBrIfNKtlxYjsYxHq4FsULGrJnEOuhTdJNa7Mdg1gPYTYf7ixBz8fX
w55YDu+QLYNYD5cn+oYNkI2vh6KAatszyMbXw8dPRocAfR5fDzq8b9Qr6Pn4
engp90tq9zYGsR4QKLV4Os2D9f/Wg8YVo5TbjgxiPaxriHog7cIg5juIU8Ls
zjKI+f5KoSfLNYRBzPf3rz486Q9kEPOxTPTpyz5k4/NRo6Y2bG8oA547aB+v
yxkDxxax2IG7DGL/bbsM2ckX5dsJEo9vz/GmgU0WrSEd/U/4+YvOconPHZkM
Yn66SejYFn1mEPNx5/53GmdqGcR8fzp4cr4fhUHEA6Nh263rOQxi/31D1uGe
SlUmMV9n66iz1loz4SHHYGeeCgXiDnVeqrnLJMZXZJdLwIOVLGJ82Ytcjmxc
wSLG12FB29+KZSxifPv5ob1LFVnE/39KjvU9Ddn4/z8cLXr9ujKL+P/ZmV9s
b6qxiP+/5In11WJtFizurGvJT+AS97kc3nMaHt/gwhXKhsjzqD/uT2bfKiS9
c2AR/j3U4h/7qg2L8BcP3zyg7kZ+BR+/qlBHuel7VXh8EpirpK9D+TTu/1Jq
X6+Z/YBFxKde06B1y7JZxPjwTIMfXm5E+fd2iyD9oxzi/ke7Esvy+QkOBP9e
VTHSgvJuX/UG22CUv2ryZ7Bb2bA+9n15JMK7+P0LxcMN3S3fKPDptmaDgS0H
onLm+XrMHyfuS9w89vnV/rnj8JQ8UqB8kgOnXU692vSSQ7TXpllsW/GaA3Pe
1R85iPLqE5jSi8/ITmJ+uRODcIfJgvHhxbVkiFS6Uh+McSBWg7lz7kcywsU8
yg0qB1RX+Z4638Uh7kMonGyjpHRzYG+cwPSnGhciP0ZqiPdw4O8yJ42TK7nQ
G+G/lhRAIe5HlB5/p+3rTwHMrqvcdSsXVt/KFJP9zSHaO+la0m+RnUf7R2/c
zoUjEb0njl4nQ8eq1YcrgxCuyW+xuHaVDCv3NhrkhnFB97u485+/HKK9PLWr
V7GfA7JDcSOVp7nQ4OPpc/YiGe7qy9DOZ3Dh3sZut8loMuzce85J6R4X5pb+
0vlxjgx7ZBPCNJDfW28e2sdAn8f7395wPZiL7PtesWmh2cgvcqzzu5B/w+9n
2FQU135BtuPxjD/HkP1laNjGEfXH268HPM5XQ7Z0iU+SWSMXguNz7EgOFNA1
7Zg9m8KFY+vf8AZ2UuDGkaKbTSwulCTRN9HR78fb5wmq0h2RXXhDrXQ3hwsG
1ZJtf3dQgG7x8mbj0knkp65L/0b24j9/DtepTYKroDS3B40H3r7s2Q4BBY1X
9+uFbkWovTjpGmcJsttaDuY7rpoE0dQ7OyrR97/ddEc5yWYSbM5cN1mA3u/S
+qCnStvR84/1bpD6wSHa47eqL6r9zgHza5/8rG0n4XOYhPMfJ9R/S3iR04lJ
5F/f7VrtTIEWX3L16lOT4Pb7QN/6Cg4sdNxY1VmHntfRGzxSjj4/LKJ/v2US
mq0aImXLOMAzejnY8WMSOiKXLNNG86XbRdUukzIJBvqm/807RoF+x9et6uxJ
kNBZseH3cQoMheeu3cGfBHVxjft5kWTifNOo4j1ayFkyNNq8KdqmMgWOBTo5
gMY7znDke4ruFDyes29lXRwZjnoPeKtvmYLP9yojJNF82p+yRn63wxRIz1l2
MaKODB+PxYsE1k9BVPBdeakGMrDdU88pN0/BLrGo7MwWMnjpjb093DEFdQ9b
KlRWcIjzSuIqvYu+LedAi336sxvIxs+fGUf7rXqwjAfzsZibLS7jxHmhox6q
S1L3jcP2wXdBWpE8eE2fpcX0GQe7iE/U/Wd5xP10x1tHk3d+5RF4+OvPFZQL
n3mEf+H8E2x4TuMR8aS0tXJQl88j4lH69gHNcXU+gZeO3bQua0c27v/003ml
I/Z8At8i6Nen6Mgn8K3lN5cFl134RDz/ZxlvtsqdL/T3gu8fpPbwiXg7u/0H
7bAHn4i38mUMH5Yrn4i3m6f+pJY48Ql/L3Kk8kDMdj5xvnXfzm3Waxr4xHlb
qaiCE/ZTfAIPja8t7aRN8on48yUp/5OxsoA4z6ceMdYbpSEg8FYm1UhVa6uA
iF9NO75tL3IREPeb6VMRJYdCBcT5sRZb5YD+EAGRz5h+feKbcV5A+PfBuIWD
v88JiPi61Hmr+t97AqDcCjHRolFh//jV4v5CATF+bt7u+qefCIj4EmhcIZ5R
IiDGy8Pfn9H8QEDgZ7camS1vPwuI8Xuo3c2oahYQ8UgtY4v/wXYBgSfcD4Um
FncICPwsods07+YPARHvhi+PHlP+JSDGu2h3JLatW0CMV/PiIyoNXQJivII1
NvR7dwqI8fLMlTCJ+S4gxmtYsSXa9KuAiM+rw0dfnm4VEPFZ6cMlV+NGAYFf
TJ0XKj6TEyHh+HCh8lz5/JUiJPx8bWKzxmz6KhHSSLnqzyfRKG9xfiXDV8Cg
XL+rUAflQc+sed9Xovx0f+5gbepjDOYtnbqYo47Bbr/Lht+NOLCS7um7ZxUG
itcu/yGTOLBptftpD5Tf4vi49cKZsOJ1GFjG+s+nYhgMUxf0+hhh8KVyY/0A
DeWNlnfjxddioMwyudg6iwIphz8vEzHBiPnVN5jloGSBwajKnMpQOQoYcfJG
j5mh52go/TE0pMDO+Scud5BQfqfX4KbmRYHHZSL2qlsxuDPybUP1OQosA4Pj
bjsxOFX6X3NRLAWyr0iJjTtgwPXvC7RuY4PvSRs/M5RfO5K9y5qR/Vr1teRC
ZOP+w0pJfMgNff/3U0tVGiU5MOvN/NOOphiRL3QfJl367YVBggjl19s6Cpyd
uTzgsycGO2NPONk0U6B+Ru7N33sw+DG36t2SHgocye0YO+GNgSyP7JXSRQH+
7V3JhsjG8R7jzrfLaQcwuGX62Yw+RoFvt1Oj2D7o/wpbOygqTgVno+1znvli
xHr5u8GJKnMEA9F/N6I/SVPhlGtM499DGPyX/6ZKeTUVwv753GpFeYh1L+nl
f65UoC9Jv5pwAoMKM3L73rNUUP2Vovw4BANp5x2b/KKo8GZczAxD9mkJpee9
mVSQXLvPqykcg94ZO3ozCqgQKe/dMBmBxsPmsV0YjQUS1NJTTGT72c706Jti
wXmTN0r+qH93uy11rRIbblqt1Bs+hcHQ+e56Y3M2vDz0+r5YIEbg5Y9t4SYe
BzFQC+/64buXDeLYEd0KP5Tfbjq3Tf8MG3zs0gd46Pfj55eNk5lXB9H/y7kR
J28UywapT8e+h+zFwK38vexoPBvqx2/JX0XjsRjzXl54jw0Fu9yo0/cBLL+6
1CqnsEHhauLSrx4Y4S+c3NjpTy9h4Lt13Z6AfirUtn3JZFzAYNBvieWHCSpI
kf6SnVG78glNHZIIDZ5vN0lQjMHgESXIxZRFhQOSH+6pXsYIf/OrXD05/ArK
33Uy/7CkaCBr3rrdNBaDskosuE6GBj979op/R3aW3T0Z1+U0YDsW+MbEYeD6
RtuoQJkG93hYDyAbzzc6aibdpRORvSeSPb6GBtxg8QqdBPT7+o51fbOmIXxw
DltwFSPikfELqyeHkjDI1o1L2OBMgy0xO7xdrmGwxtmot/4oDaTsj//Lvo4R
50cXX9TUj7+Bgf+5fzeenKLBZBI33CkZA9WOyrnRN2kgZjbLduimsN4wV3zn
ntDbGCwreCtqm0KD2SJLl6rdwoD338lhkQoaRGd4RI2loPm+Od/e9jey74gn
laRhcPTr9zCPWXSQHx/10L+L/o/zPRYmunSYGSP7NRgFvWvxWbwyR5QPBBid
DMnB4HiputZfZD89Y3D/DLK5L+bN23qKDuEuE9LLcjEI7/tPwQ3l1YGVtiGA
7MVKq8+KpdKhtyb2wc37GAz0edWn3aXDs29hFxuQ3bGzaO7wazrkQZRLZx6a
n5Y2icXv6dCg17Ne8QEGdiq0+6xuOozTVs8lI3t07vKHcYN0uO0U83d1Plqf
8/7arhFBefON4uRmZH+buXD7+jkMiF924MXsAgwOvivRTVVjwBcjw7AwZOdM
PI4u1WeA2Ht6VQGyd1W4F6/awoAO2RUrJ5D9mnl1Ix/l5Yu9frPnID8rl5Zp
T/ZnwJat2+t1ka1/4Ode+TMMCPJ0MZquTy1S92r+fY0B93eU2Bogu0AuPZef
wYANe7eoqSE7prpOXaKUAQOl9m4s9Pwga0ZJaRUDXsiEeX5DtkWI4eX9P1Ce
/dfGJQrZFxatmm3cz4DMzF3b7JG9TvTPIcbktP5Dk1Mt+n1JnkGKl2ehPJNx
ddMlZJ+Ir75Wg/JQb5NusTr0/7wyzlmdo82ES/vjfaOQPSJ3UL4Z5aU7RbIr
zqL/N70u71jMNibsVblSZo5sjvzBiCUBTLSe5jsOofGyGSvtMQ5kwqH2KMlX
yDZc6X+v8DoT4iPy1Wfcw8BJxnrf02Qm2L15JU1D4//k+XwtSikTYrGS9BE0
X/x/ZhmwvzHBur7wbCaaT9tD3bQ/spgw9ddXQyodI+pVNorYumk9w99PDULu
m6G8sHf2Pwk0X3E8ZnJmS4ckmv9L7ZK9iyxYkDej894rNN+P/Sh99NyTBQ0D
85fcQusFr29dX/iKIYXWU2BqVbi2Lwt86tXKLqL1Vhftyj8XyYK+/uyqNrRe
cbxx6+OfM/fQet5mpre5MZEF4VVa9m3xGMzuNPqmdBV9flVWZS2yQy3eSm27
xwJfyU6Flch/3Ow/1yieyYK/+5UqK5CN45VKl/G4OuSP4kxm7V9dwgLV6tLO
JOSPFn3PJ98tY4GghOS/D/mj9woPNWUbWKAZ21gWiPzZgZKWws2VLBjTEjfY
Oe3P/t9555EwU+meab2ZzQc0D4iPwMJ+/VXTeourTORWh+mNQMZZwc5pfRkc
ry1sft3cPa3non/K1GH7CNjtl5Gd7r/al6d96PQILG3y9Jzuj/Ph3MoruTHd
39TqgJ3F7RFgH1nHmdZvcXqmqOFcOQLRzy0OTffHzz+bmzd4TPf327HPfVXP
CNRcvfB3uv9Lh0gVkvgoXJz5NGi6P84v9LqtSWO6vzfz9iF5jVEoCO5t+p+e
4y1DBb3to/Av+G34//QU/995aOxuGG36fU39VgWLHRuFG4cMX03336ezTU7x
9ijUVwRcmu6P8zd5jqV/mO5vNgSRlBejsHS2f950fxvn71ISPaPg+Kb26nR/
/Lz0zr0iKdP9f7gzLvVOjULGZHDydP/9Uj2idPUxeH67PWW6P86PdRLO+f/v
/7t3KLFx8xhYPtwQNd3fem0A9/fRMdj64Xb2dH8czxVMjpGm+88TK7nxKnEM
fGReHZvuX/wmntL8YgwuaS8p/J++4f87n11wX0thuv/iM32pDzrGwPfSjz3T
/X2ebB6qmBoDaZ29T6f743xoZhdlaP+/nqbc3RtKZFh759q2aXuH573egs1k
KHp59NV0fxxPHqmNaZluf3/EIzvqIBnEKe0bpm2DvYUdtxLJYLDLtnq6P34+
/IZ60MPpdonI+ntHH5GhTTtVb9rOeLuvIboD5Y/6jP/pNeH1zZy80rjp9ikt
//vudDLce9WhPG1nUdqqjiuhfE4ttPV/eqH/7/4+xcXsyHR7oqFjns3/R9SV
x1P1fW0UDSKlVCJjqGgSEVoIUUmGIvNcyJASKlIJIUMkEjKkNMqQDEmSMiaE
Umg0c4dzJ9x7332833t/f/k81nP3OXs4ez9r7bPP0p4Cw97LIji2ZrLK7Nyn
oOnt5x6cz4mnpktNm+D2XtXYAtXIKej0S+PDcd9pQpHxkylwOL54AOdzznus
S6rdgtsvv5EpkG6dgrv8ghQ8X9K18EfZatgUfGFL/sX5nPhtammaMM4/d14u
X2jVNJg975vPr7R1ZkeKrPY01NxaPYHzOec13k15knB7juqd3Bm7aehi0b/h
eOGpuOjlkdNg0kok9cznY/r/8xoSA1K9uJ1ET8wZzp+GFoZHO45zRasvzLVM
g9TmcgbO58Sbr2uUzuezVN4snNU9Pg1+QuL1OF4b8qsCW4LmneWuPHg+Ls55
jSPlovm4valBuG0I+QWpC0Ve4jjArWfHuAoBIqpmBObzPf63n/gU2xWL289u
dDvYi3RzO0v/EY6tVlU//mmO1g2Ty0I4nxMfH/cWDMTtgSIxTW1I53mefJY9
fz2tmxv7ggggU0cTxfmc/bQbpvG2uL1I/vL+BjTPbSWbpuD4ZZBDTjvSGbGL
nMVxPme/7fiVp/twO7PF/H1VEQHmEiVjcLzq4IZ171+jdZFcLY3zOf6uSJKH
Cm430mXqv2gjQOvJdWE4/q3ac7P6JwGO6gsp4nyOf3Mz6fGa+ftNjKp7QET3
368zXx9WetSyEn4ijOceVcH5HH/GWj6Yb749cgk62auJcPVs9Hw+sDdftkc9
3ESEJc/TVHE+Zz9wwYm6Sfz7nIzde6tTNYlgN06yn8//pdnDzjYlQiz9s+Z8
vsn/9gsF/l76ivNDqKc14pA/lCgZNp+P7NiSkNBbp4nwjmeJLs7n+Ocbbj57
P//9T9eE8suXiXBGUM4Y5zdHrCHH3SKCHOgY4XyO//6kzrAE58sO39oZch+V
3/1TB+dXdJWfulJJhIcyAfP55Dj+0et1kDOfD68v9rlfExHOlr1Uxfmbt1n9
C0H+0BHhfAucz/F/Sm+lxuP8ybP+yh6T6Pfs7E3z+cyqyE7+vCTwce+1wfkc
/+d6kO55nF8yYlhkt4IExjLpUji/N/3WV4+NqNwwYSecz4knJGvrnMT5ymYi
ChZqJEi7nbMa51uP7rG0N0H3WWzigfO5+6ePrh3D+S7lHXnGx0lgRyoRxPmE
j39aLXxJUHc41gfnc/arXr1cZTifj3P9dSlA/tWGjk+8OJ9ikWpkkkyCzqLP
p3E+Zz/r5/W/qjg/KkTrrlouCfi/k+fz28nmHaiDchJ0rJAJmc+H+V+8I/o8
WRa3X3s1ulb5PQmetEhMzedj/Lx4jzr+fdPe0HCcz/FvyIv2zOdrHHl765bs
KFoHHIz/zOcvZH4qVWaieeLQj8j5fKv/+S9re8rm80M6B+mtXCdEhsdWZ7/h
mGSQqyKH/JWzjYfm8xVy/JOEIqf5fJQjz6cSliP/RPtCdgfOP94U9mAd8k+C
spqScTvHP3ntpj6f/9LjUI6gwFEyiN5taMT5n4o9ZUS8yKCx7Wg6buf4J5vZ
uz7Pj9eNR2PmQpD/cvXPfP7BIAWHTIEbZPAfJGTjdo5/MhZn/RbHsmIr+cl3
yXBrZnZ+vGbaua5mFpNBaV32/fl8hP/FezYq33mBY2dm7+XROjL0Ni0uwvnt
McGJ5G4yLDvi+AS3c+JBpSKMXBx/e/2QNfiHDA9KFs+Pb+pU1pIxOrLzqpbi
dk686F1QwE0cJ+tGXehZjEG0PyMV51/u67k6JIHB4grJKtzOiSdF58xdwbHv
uUB6K/KPbr3oi8X5WXfkWD26GLzhl56vHyfe9K0n4wyORWz9g94dwcBlQ0EE
zo9JuxbS5o7B72Stj/P5Tv+LR016GLjjuIwYTqpE/tQz0+PncD5lD4v0LgaD
K8sDP+F2TryqJ5VuheOt5vn+xekYrP5A8cH58fyJvlVPMAgweN+D2znxy7WF
JYbz7XV3YKKwBoNr7HMu8/k4IzVHijsw2LV09wBu58Q3+bv85vMJ5y1S9c4a
wuDesW/zz5uzDdv1AYaud6TpL27nxD8XGm+an38bf+QNpyxE/o6o5CGc36X2
60fWWgo4SIZP4nZOfLRAemA+/6TApe0esUoIu2nr4fym4d82qdoUeJtiTZnP
J/vfftklt+uL5/vLY+BXxCEKvLNUU8f5980FumOdKSBCsmbids5+2jemwvz6
ulnpuXNwAAXkOxZuwfllpw+aXY5E/t3ty/w45uy3MWpLRnH+ibD7A76pFOjL
fiCF2/vcypuDHyL/cWGvEI45+60ylkrz+bI1oMHe/RUFftmJr5pvT3cjI79W
ClB/24rhmLMfq7T3ajPO/+An3G/7HdX37PHFuJ3WxVPvTqBA6yKR+etx9muz
vtRW4fwKjejj5jxUaJZ1mcPrN6Q5rGO3igrhgQzF+fyx/8UrHfb0PJrPZ8nY
0bdfngpVnioEnG9vMldprkGF78fFd+B8TjwzwbzhDs63NVhpvdeYCm68Vb9x
/um/+urG9lR4rnxuz/x89F+881/N1VicH/N3S8+uU8g/9OXrxfl8CrUleyPQ
/aaLGOB8Tjx0XafwvL7XmbhydAvyH8/08jbP55N1OL1NrYAKn5MmTefzC/8X
L3VMdvKaz49evP6LTBkV3q8urZl/HjY4P9nykQquR1fY4HxOPPXrHX8bnL/1
64zV2j4q3MkWmc9PXGSQsEl2ggqVFyJccT5nP7RWVmM/zn/ltfGL8BwVzoWt
mp8vqhnswrUiNMBo4Dv/vP3nnwr8eaGG829+uHeUX5oGYvtfzc8XzLpK+eW7
aJCheDRkfnz/5696rPgih/MFPgb2zO6jQZMg5ep8vu+Iujx+Gxo8+fH+Ks7n
+KtHDTJW4PzXNbnWpBM0oO5/N59/eiZunczcBRoEBKTP50/m+KsNXhQWno8z
/squryNxNLjRKT6/HnaXNueQcpC/2dSVOZ+/9T9/dN2TwXGcb3pzp93gcxqQ
P5Lm54sAi28bRt/RYCzo0kOcz9lfX2Br2ofzVVYV/PjSRQORED2D+fHgaJY9
OEyDlNr8cpzP2e+93bSzAef3U5KdW2no/vXmduL8W+E7NvQI0sGoxuQdzufs
z9DVrz7H+UsXCvypX0+HiEtrZHB+r/T17NZtdFgXdOEzzufsJ7zP2n4H5/Ms
FjxZCXRQc4gSxvkWt5yk3lnSQWBu39B8/uj/4pVG8Vsicf730ScTz93oEFWy
ZxZv3ySVN/cqg+mgmPZ8ej5/8n/xSolpV1+cH9tHP10YTQf9TvlhnK/qUipb
nEmHg/9a2Dif8/7KZNe7+XypcSFM2t3HdOC3VO2c93cZxvcL39Bhu/TD+Xzk
nPcJdspo6uD8EfGW8JRPdOhss6jB+aN6CUpZv+nAMjgqi/M58ez3uo/lcL4E
64xALJkOE0m+93H+QpOUJymLGMDv828Xzufs55hVsRfj/NWZyxIj1jAADHzm
/d0eOe8dsVsYYCB6el4vct5f6KpcO4nnYxXifbI2WIsBKhe3n52f74wUKyLM
GMBIFHLA+Zz9pOdh3Z9wftG+U/m+Tgy4o559HOfvHv+pE3yGAZoRvfN6mvP+
zbLCZS9wfj3be5v7VQbw6CTr4HzH5LL3vrcZMOwxdR3nc/azGA63knB+3FxT
je0DBvxw/ymF84PSXh92r2bAK/tzeTif8z2TjVbafjj/MOH5QfMWBpTcd+bB
+Z/JUl9tBxmgMZs+7z9x3veZCPpggvO9Ak2+759mwBHG1wG8vbqUFnqYL5iB
U15RfTif870YLTuyLM5frtjst1d0Buxpy6tx/gmnDNJ+xRm4V3OOivM5+zPN
B08zuhAuUPNboLZ7BlTWVqfi/H3fxa7sPTgDxk8fi+H+Jef9ov7Xf1pxvon0
xTtb7GZgeWS0D87v7HwtquaP7uddoCbO53yfBpMduovzXdbv3yV7aQbcDqwE
nN/4uv/BlpQZaJdWcsL5nPeTVjYOncT5F5fv/Lw2fwZWtP8VxvnO3m17ZStm
IElqTwzO53yvRMHTZDvO57tcenr5hxnokg76htf/GY3v69r+GVggurUc5z8p
cxKuvEWGUJ8C5ZIeMhwc2GBJKyDDGccr+tu+IJ1ITmr6XkMG11eya8c7yXDy
rIaBcSMZbMVMs/H3xwbMUpvqf5OhTuW0j+8nMpQt2230dpgMvLSqbFGES3x3
/XRZgoE8n2b5oVYy7DlknL1pCwY3VFytypqQvddHdJ0pBnGn4rce/ECGCiO+
3dv9MSDfMtHA87dy9JCCjuaTFfVk+BVJ7/5SioFo+Y5dW96SufonZnXiTW2k
I696flyUU45BoZdw/Cpkv2yo+829B4OzSddbLr0hc/WP7TnpG1m16L4VdziK
9WOwdMXZoQPI/uRMarYEAwOKf2bPQjwf7X/654WLfNSu10iXpwmybXkoICvp
e/k1wnrYpSzmegqoOZmNVKF24uifubBPMbwIHxDdftd3IwXEl1zK9EH42tvj
gYuBAjVj9pV51WSu/jljtqx+IcIZCYeaDx9AeqHhR5gVwje9d3/TcaVA3N/M
za+ryFz9o+fhfXkvwgFu9rxsPwqk7/iREYzwt9ytL7OvUcBwR+l+QYQ5+sd5
i/Ge55Wo/2Rpd8NTKPDEP+VKN8LfX04LKRdRwFt/x4EEhDn6R/ib1jVrhJvu
nfveVkGBxLuPJ7wRvpLesHIY6Z+Q7RJZeL5hjv4p/14ng+cjTlDGfk30U+Ci
gtezPbh9JZ/cZ6R/iHeW/MTtHP3ju2Q73RzhCWuJin42BXgcvr/Zh/Bfv9m2
caR/mrM+E9wQ5uif8wpLJQoRlrTr078jR4VnASZaUQgHFcT1aWhS4WUq+V8z
whz9YxSX1a6G6v8mucVCaT8VoOCdAx/Cg2UH9KscqFBT+EEuAGGO/vmxbcUV
PtTel9fk37rmTYUgQXb0K2R/D7EHA69QoU05y+oYsnP0T8q+n9+FUH/mze7K
fHGDCsxvdlCE7JZ+mhfdHlAhT3XiQgSyc/SP3Ln+13j+6bWjPl2Pi6mwbMG2
bV+Qnf9Vz+OkVio0DXyYISI7R//8TXisO4LGn2DwbPyZLiosyTi0WQfhldVZ
S5lEpP/uf8x8hsYrR/9Q2gXfVaPx/yqtj7yISgWB4K/Kv5D9zF8l5SdraBBT
UpxThZ4H+b1XoUCHBol8E86SDaj8yrLpETcaCEas1e5Hz/U5XZPZ8FganGkI
/MJAz2eE58rYM8U0OFjn+OFkGxlWRFhv9X1Bg9L0jfqXEb5/U3tJzmcaLJ9x
IFV1oPY/ezu/to8Gny9efRn+mQyTV1aPT5iToDXLTzWbFwOJx4FCBc4kuGJb
d28TG/Xnt5d7My4g+/StH10zqH8OtvBZRKB5XF+vYQXCDjfuuirfQ/784eRX
WylkWKWoFrSzDq2rdL38SwQy198us76ncXWUDNuYH6mKv0hwp6a14+M4mk+u
PXr4hocM/TTaVBWalzj+9q93yuPDyI/0EVMSSlmKyn1zO+TiPzJE1xlPGyJ/
e0VdyCE8XzPH305tCw5KGCJDS6xyejryt2uuGwY8/onG70T23xc7yVDMDmiK
RVi0f+O1PCMyFLS/SFYfJEP4v4DFFD1UTu7QrlqEOf64sXzbhqDvZKgeFRm3
s0DzzOQdjx8/yHCir6vpsi0ZOtX4mFRk/5iTvOCIHxp3H+2ftHxD/WOye3Ob
Kxm2S4aPLEZ27vf7linaZyA7cWmiQfgqOny8vfSpRx8Z+kZTCy/I0eHvBgnK
QWQvJRLrH6nSwW/7HzF/9PuQ/NuD95XoEFu+02gW2Tn67Jhab+AldL/PRN7E
TGjTof04vbUc3V/P8cLhj/vooHW6yaNwgAzuShFVX5Be2x67zJSE2ufYwj3F
luZ0qPHeSUtDmKPf3vJePdGL2ltJYG/CZ6TfanqNvS1Q+zIcDepSzqP7XcJK
HELtz9FvnyT8yQ/H0PryDSOlXqUDZaao6cgIup73sz+BBXSwLWu2GJ4kw2u5
M31CSH85KV/zakPjI+PjVg3/80T4+1JpeCny4ytXs+IEY4hwlv/qK7ISBiLi
ptlehUR4sefsmUOyGCwr98+iNxAhTW7AbnA9xo2Hhfa5nhpagYEqf9eRtmEi
iD8Lafy3CoMuuYZtz/hIcFZA06dyOcaNh+1tVH+zWRADy3jFtD0rSSAfv7i9
exkqj+g1lIlwF9nW/B3C4cNtvzoUScCe43OcXIxBRbmO+WcZEij4l4TOoXWS
o/8MrQSPnV2EgR3mZp0owoDbmCMjfgEGDs+Srk1IMoDccfDhHQEM0jRXXxlT
ZoDqUalspaUYBIe7/B5WYMBIzav016h8jj6M0dX20RfBYO+xGepnpA9Fd1k4
fhbCgDdzC2+oFQPYnuw9m1D9OkzhpD/SdwwhiVc6Mhi88b/jFEckwBBBIjT6
MAarTWPfu5MJsN8e/vAizImvnldvwxT1Mai3KzqgupUIV5KvOZ/ci/3vfMV1
ttwKTQy2yF0+P6BOBMLYPR8dbQzKzolZpJoSQclzrD9LHYMH9SE5hINE2ECe
pvHuxrj6cGvDNvFGLQzCrBgNn5A+DDids8FbAwPttE8VksMMkDyW9mMvur5J
idlEjxMBzpdZnbx0AYPPwem5F9wJMHaFcO93KMaNZ/+w+cHI9sHLu/R95C4B
FFoXZgSdwLjxa3Up+rJAZ8Sf/qYl9IgA2kUVUR5uGFjzKH+SqyfA5Q8bo2Tt
MQgIOeV/qZIA/cv0i4sdMa5+tNq14XgFKm+kUN4xA+nH6Dv0Q4fQ78eXTrjH
WM/Ah79EqnsgBmcWhnulTk7DrsPrqy4jncOJ/z/QPyHPSsJgwGN5pcJKApzh
CQupvo1BFm8P71oVApDu0MNv3MCg06N54ecl07B6OGuisRuDYr8fbUfWT0Np
0uZ98R0Yd3+DBLqCoq8x0FU3ate9Og1lbqdUPr9C9Tvw8NemyCnQStCJpFMx
SLhg+E6APAn5418M6NIU+Fj77mue0ySMDJK+D5pTYOj+Iq2DJycher35t8bD
FGCohsiEsDEYzW2axN8Hd5Qc29KzlAKPLeI86JYUcOvzrbRXoMC/ozqTSej3
pp6C2fbKFEhIeOG8EuHlH/aMvD9EgT8GOU8eoPKymoX2qaG/P04aiCegvwdI
Tb1uARTw4VmxMADxkj+EF4zdRPqntqu7Cumku9U6e1rLKTCx5WfGaRN0nQYr
i2VfKeCwt6Mu3ZgCgf1uys/nKJD9g3BMDeHxid3ZldJovQ9SkDBFeCTsoMIO
QyqEOI6k/0PYI8uXVwKt//IivBpLUPmxPCoGlxOpMPH1g/vrg0jXSYkGTpdR
4Rd/SiP+/r7kX/OLXuVUMPaRPyiEsPknwtLqHiroJHxOSj9CgXOiOtq/+qmw
UiBaeAmq70Ehw0E5OhW0bc3aclH72N2T4CPz0eDPxODtSisKtDh2vFFF8+77
waK0ixEU0GyK/5aL5sHVnacmZMMpwKusuzECzROrgpylVoVQADte7PgAzWva
ujzL7AMp3PjkygukFTQvdH/2pKxaEwyq/QrPlZ2iwN/M6ZBPaFz2Gwm+nDpB
4cYnb2q4xce6U+DKO7M1imcw2OQh0rHHkwIy+7oCP0cj/a1Z+naPG4Wrx0vE
Q16lOyF+w+juaTQuacPivAtcUL/bqBwgZ2JASOljnnemwCae24bSxRiotS/g
GXSgwIodZ59JPcRAGqOd/+lI4er3E9or/KXt0P2895pwReOSIuhl0mOP+n3M
LmxzAwYTrn9sTiG78SfbjJV9GHh6fNeVPU4By0OstZUfMWgaFsz8aUvhxmsK
5L8caEfX2xYPb1r20uDURx3vWvT7ZJPgszQTGoQYBN/QQfaL8m6GS21poHAo
1uoKqs99UWyzpCUNNkaF11xD98eJ5yw0uUOUR/X3rnFefe8EDZZUlI5Go/ru
74w4vdCbBnMrI73+IDxqaTFie5EGH+sVb7ai9uTEd0Sd3n1TQP1BUD9b/fg6
DV6+Mt21ELV/7i53/8uFNDDsyd+thPqnjXpE4AXSU40OmUJvziIdLnPv3oPI
CeApK/pwGOl0V7XpTRpJE7BGvideuoACigFRB+9uQn5LYJO7w1MKhL6fFDHe
jXTda2H7M4jf3ymTG2pFhi3+W+s8cync+H7wwiAXr1uoffwvxZUmkmFpmQTx
EHquOPF8h9RI/s54Cpz8tNpo8i7SKcEdLgqJFND3F5/eU4p0iOalMr5YCqic
DDtT/RT5ISZK6hBH4eoRG2bohw8x6Pl1Yiq8QXrkzakMvWORFKhzXFJLlqHD
7QO7T76NpoBu9nRu9nY6mMk8UClBvzcdHi7o3kKHHKpnwglUPvd8wQLhJZ3o
/oTl09K2Aipvk/VMPbqfQa+7KQZ2dCjX/5qwDM9PtSjYw+I90oOzCx6wkJ/C
0Ydv2ycN/r5GzwsWfbyGSQKmak5lfBWFG/8RHKlMFEV+zoKPTrZRhXTYIfL8
ovsLNH6VKY96ntMhLqeS9K2MAiaJ7+msOjqMXP3472I1BYSa/paRrFH5jalE
JoXC3Y8iqEkbu/6mwHXxSLkV50kQcB9++I1Q4KZNg2dQKgnWpLU/8BugwBL+
bZVCCSQQcZ21aBuicNf/0cQib2/kV/UnH34RKMaA8IIAOwzZ961L9zmxjgE3
i2NuuPxC45+Zl16lxoAoj2ujDcjP+lJU62E2QYQ67z2vxBSo8NphpP/wNBH6
JkL1suWpXL0S8vhM4VIRKjiNl9sYLCXBvuAbGl/XUOFwwgODQ0if/Ck3TClH
fppoZG6kgBwJ/PS0itKWUWHpOXUfwQIi5D+7UOR1kMqN9+yseH1ltQ4VeE/G
8FTmM2BJdJSajyoV9O3ID24XMcDiTNvQ5d1U7n5p8y9NyYN+VFg7kbT2zBki
xDTn1CueoEKv1bd9y0fHuN+n/XeiKdayfQw2LrF2Gn9KBb5D10bHvo9BjfYb
hQt5yK/rW3tGRYwI5xpz8w/lU7nxnqNPD+a03kb4npgtXXQGJN8/f9udQOWu
72Iymq0FU6i+dRuJR2oJEHCzN3PoL5rHX0iW6VqOcc/TjB/UlajQGYMRLa/y
oq00KHyyYJhyYAzStXp3XpOhweuUYw+K5dG40I4axzbRINhNsVtThQI7ryq7
RyjRwK9lpxO/KZqXRp6Vx8nRwOFMy6CTL1qP1Cf59aRoYPOJT8I4AT13++8M
Zq+ncf1vxx5fAx/kt30NGb68CY3Dvr8HXtxeS4MkDbsTk58psIdhvzxGjMb1
vzVtW3jyVtMgoc/FeWUvBVL55Pn3I/utmq1tNRgFxErmVDchO8f/Xi/hZ1a3
igb2AdMEKbQ+Pv0G0rMIzzmu+rtvLRUczEU+FiDM8b/VbeoeNCE84Jwn6YDW
z8YFGxc/QNja61l/sjYV6u4M9ixD5XP877RvlJ31CO9Z5NzYtY8Ki47/YO1F
+GStw/FXLmgcPnzsdA7dH8f/PheV0PMM1XdNpUVfvCcVFmiuPvEK2U8HO8+0
RCM+PfIPA9V/woduTXhGBa0uuaq3Euh6vPdu7e2lgsKv5e/HUX909/hE6M1Q
4eDErfJIRRo8G8t8OMaD/FHHJe3lqD/6/M7ufhiAwS0fG5i1osHe1yoFDSEY
uG7j/3LJggZhGV8lnt1Cuny38yXJAzTu+hR6/YGMF/Kbq4L3lWlVYPB+t7Dm
Lj0anBC4Z/Qd6awO89qXlD00bnzJZ0KsXF0Ntb/6flnyIAYhcypW13bTwMjk
x2PxPxgU/e7yvatOg9rv3zYzGBicGj9BmNtBA+nnNKNN0xjEUE027tlF465n
B6/I8/po0kBo14/uMH0auLTzucWi368M1z731IgGnktPvLmByqc3/jG3Po7a
SYZw1Eqbxl2/DGYePVbcRwPbo7JCm91p0BxzQF4P0P3Uh937F0ODwAva9zeg
+vqcNmw5j/TF6e0jBhqhNO7+6Pjx7bY7T9Ig/I/Tz20bMRBvJwil+tGgwrur
TV8Xg0zHz3ZfULmc/Yb4m3d/q3vRoGxV37hMNw2G0w/e3+yB1t2XQ00XSTSQ
O96ZsDGQBk1y1rUpaWTY2RGZCU/ROutSS8DukcHG2xXmHtC4+8VhUbl54yk0
OF+zSte1G/mJAdp77yaidZT/WVOYJRlu8k3+1uukgZd9EowcI8P1145bNDto
3Pl9hZ+AfuUYDY4r2PaHFNEhreFsddcQDcqdl0cYPKXDGttT+b2/adz1It9H
fcOXFXRYkHv9R/lCtL6Zt9ko8+PfofpwhHeGBL37Lj1pX0aHe7Whh/Okp7nf
V/YNyBWQWz4NsvHHoh4gv/hk1tTPvlXT0HF5nWTtYTp3fQh6czH4sQ8dbn44
+tAyjQTBW4+teexAB8lc+kRIIgnid88cJyE/uSsjQH1N+hT3/Jz/v+8udnFT
sPHO7EBHJx2ygjXq/5lOcb+fvCEy+YHGvik4clSbsluJgfz1fM07v4hQ9ia9
wEUV+VGlORk2P4gg0m5Q+h75gfUr7hsXPmBwz9sd2MayuJXDgHUk7M/e7Qy4
PmjhL32fAU69P0WS9zIg1nHqRutTBuj/HpWJOcaA1Huu756umYLx+5+T+90Y
aNxoVq7BJrnfa354HFPazZyEowtI97bHo98pCB5YMDoJc95RzrdQOZodSO1M
TwK51MSrMZcBOqlNJTFFRO7vlzY9ntuZRwTqVOypqkcMIOZUntC8T4T9Xycz
1xQwACP8kfjayuDmQ4ooEl/X3sSAIMGIHzMVDDCZsZ7828yAjB8JYuU1DPA7
+iCL+YkBU/7+ORXdDBB5JEEwbZ2E0+n3dNf9YsAW6U15DdeI3POA61ijJ+Mu
E+HSh+2hFnMM0HpcXyp1hQik17E77s8wkA53cFZC/imHP6Mlt5y3kwGTFm9C
+AcZsMvAuUH1xST3/GDfQ/PuN68mIS7Kv+rU0hnwO2F1mPF4EobUphacUJwB
MUpy8eyTSThXKynAuxH//pynvPZXBlRes9EJRXyBIWvpYj8imHz+9Xq55gyQ
Mh5vFkTXOW1yeOrUnhm4u+39mCbCh68czrbXnoFuJebFy2mTYN//T27KcQaK
D2yx9r+J6qvDNn7jPQMKAr7nDrgQuecJh+9t2ejlQYTaqjDJCYcZGHQ2b+B3
IsKDRjNB6oUZ0NqZ4LAWtZPP1K3riS4zECesuCsbYabM9QdKPuj+LddPro+e
BKnqLZTGhBnQWZZpFnKcyD1f6DNbVd5qh9pzhUTVlRszkPNTadMJWyKs3uOT
3HhrBozOtKldPkYERasXC1uez8DJpxtZAzZE2JTszj6Zg64XmV31+jcDhrvy
FznGzsBPORvRaYSpSzobL96eAXkb8qw6fh6ueDryYekMjJUuaWpC9phqL23R
ctT+eWmvQxC2IYzeKX07A/csEsbiAia55w/f8JHrf5+ZBAlWWrvPwAwslUjW
VPGbhGdERslenlmQMJYxszMnwkhfWcnToRnwrVccyz6C9Na+RynS4zOwQTN+
lvWTAVVXNxyn/5yB2xpfd4UgPP3J9fnqsRkIPWkZfdt7knte0XXiYfjhU5Pw
OiQp7oXQLPhs8SFaeU1CjUhop7TSLAgKyleuNiPCzoZDHfLCs0DITZhiHCZC
vED2tWnRWVAzkn0uOcCAUwfNbb6LzMJVp/0kwROT3POLN6tNnrxF+GTiwYJN
WrNg21HqHec5Cewr34b2mc+C3pncKhzzFR4y10bY4UHECg10Pbtgwcg3GrMw
0BM2EYCwG59Roi7MQvlfveYwNB5PDeevk1afhS55Cf1Zj0nuecgSsz+hC1F5
G6wtn5h6zoJyabgPH8IFpzaJ0xA+6Xv38QaE23qLRY0vovp/EAMJhJ8ufJ/y
+sIsKIbuXH8Sta+xavX6UedZOP/BL+W6BRH+nTzysMR3FnLbPJVt0PPLud7H
5sMzI+h5czl4MeWz4yz8/Kr5iI3mgxFFy72tqPzHN3jDLqL6c74X7x1zT64f
Xe928O9mzeRZMHxxa4fzyUmYVUuf+vpgFiSfWjMe+0xyz282LpFWkUP99e28
068lVbNQa/jNp9sXzV+rft7t/zILScavXM45E7n8n0Ukj1WORIjYtDAjuRrV
b6m+vCHCeryDm6JqZmE2pGjvXXcivFgX4FbRNwv1l24eb6pF8xp56P2fl7Nw
4KzM5xQ0TynabAturZ2FYnnTL48DJ7nnQ5MPzrqW+U9C0bnzwuE/Z2HxsYT+
VcGTsMmUaSklMAfqC7zEE58wuPxLZrkLXjxkwIp/v1hP52Yha/pUxrZrk7Dr
0PlHhppzEGl54b7NdSL3fKipeoCpVCQRWqxrM5P3zEG85dkzWrEMrt3q6LQm
MZIB6u5zq89ZzMFOD4ljPs8mufnFXoSeMvxaOAkp1eee+92YA8k/opNGjybh
1knL+xdT58Bio5tW48tJWHNXN9D4yRxUd2Z0MTqI3POnKomr7u9pJEJIVl5V
WcUc/HrJ0mU0ESF3o0mm5es52LGn42LAZgZ8siDy+w7PQYGgg33nginu9/Df
twbvvcNA89ueRQRnESZc+yfgfh6jw9VCW7Ebikzu+4h+g7DVfh8TLLLUTZ9t
JYGso7nxqCoTPhu+s9TaTYKxVD1VphYT+gODqqLaZrjnV98LbPPp/IDmsc8y
0hfDmHD9+AUf/o8zkCE3kieBMOf9wjWZK65IpzEhvolf7WUWCWpnw5er3GCC
4Z6O0xfySWDNeshcnczkxsc7ji09oXWXCbs9Pff4hdAhhP039V4qk6tH3j/+
dLG9jgmOR515+UZI4POjcF99FROiVstcII6RwGZww2/PGiYsEOtecn0xGYRP
iJkKtzIhGT78chenw/ZD7m+/f2KChhapQ/sxDVxf7FmwayELbgUM/nxeivTY
14zwJh4WV79pmd956zKF2kM88brECA2i3XmkM0aZ3PjAdSfp4TRhFuhHsa9q
3yLDlu7ZD2cXs0CPmL3lTR4ZQnRG3LYJsUDhRdSWmmIyMI0ECFMrWDA7/Nj1
5jMy/N4hc04VYY6+8xYkqFuIs+Drz1ueX2vR7xclKcWIsYB3+vkB70EybFe8
cTVSmgXWK0Iv3zCgQdHh8R/FiiyuvmX2C5UcXseCKR0/901hSKc3/DhyfjWL
q1/Dt5gp793Ngt1VRX/n5DEQ+uUuKq7KQvPNOql6VQz+jhdlJquzIMJ4bG5I
H4M7xTYhdE0WvPsbZmyhhYF9SwLBSIPFja+1vBSdYOxlQd5mnQ4bcwwSswmL
xXRY8KD8eIm4BQZqdkNegHAKqC1he2LQ5DqVGajH4sbbtLV68v4YskD9G1Fq
EvkjNyI8LOz3ofa83N3on4xB9eTfCAUTFsi8OtHwugoDkIguijBD7btde+jc
EAYXTfPZnlYsUFmhUCb6GwMbdcn+UoRPZl7feZqXAoQ7ugVka9S/WU8zwpZS
wNd0wrHdhgU+EknMCVkKsO1Ilv9sUX0tKyrW7KAg52/oE9GOBcEZN7PmJKlw
TcquvAzhj6WAVW2hgpNeRFwe4gtKC7+tNaBCeIfzUxdU3gzh7Mo1plSY8ruw
IxZdz1Mp+++JU1Rou3YDm7VkQf7PTYRhXyrIl+rrtSJsLqonr4j88L+b7de7
oPpw9kcznh5TC97Pgr7odBHhNir4iU7uKzRgcfdDIzNS3tvpssBj0e/Pft1U
6GJuTNiB2stytDf11TgVMp+0/D2O+oOzH+qFyVJNUH+pvbF26kP+YGNRgiz+
fTp16x23fJA/qJidUVuI+tf0t9udxcjv5NnCLJHfxYLMkGNVvUuQn6gZ1nYC
jRfO+/txyWsGzp1mwcWNtAaLiWlY/KHe1tyLxd2Pz27P3HbGiQXknBz9eC8K
HPDxgylHFlzTGtmwOJQC9IqzNj7I3iGym1YcS4GOS02H2xCuW0wr5blIgW6K
kFs4wpz9+i2yded5nNF4uyR+0ySBAiKzfeXfkJ3PyELn8l08jufjittzL27c
cv4ZBRavWrlhAcLXEv2+nbhHgepSKY+FCHPiCaaldqbN6Pe8fNQw+xIKxMuF
Js4h7J1cJpJVR4HiO8qkLoQz0yqOjndSIFRgbudphNXGv7ooNVCgddDdsAFh
Trwh8O1gZDuqX5PCqFPrFwqcePjruj2y73R2uOD5lwJ5rqFiX5Ed+6KxQYRO
gZUJgiVLEF7+efl+k2EKaITyWDYizDmP4JXU73/wDQtEG1MCW20JkFL34ezx
MtSfQqbO2zwIEL/rPf+Gaha4DU4rb0L+inx2n1HfZ9b/9mvknCRCRllw9kCE
+YECAlyRaG1iDLFgi8x26rqnBDADMas/f1kQvfzT6PH3BAjxTFAfIbHg4ZKZ
XAdbBliGCZw9wM+G86167iddGdC/pj/ahYcNfzs1v54VQ34D/xX//VvYgDV1
brZdx4CTzWaCbZvY3HiW+O/lWyu12LD0xaVuaWsisL/nD1mrsaHizM8BC1ek
d7vCU2o12TDklj7XeJoIyZfWni4ENpQWdgi6In/my1SWi64Fm/t+GZWw4+YZ
YzZoL7t99/g/Osgtf+f4TJ/N3Z/MdE5MDT/FhnZ1SZveSSIkfDHQL/Jiw74X
m8YsF5Ggo7xp8Y7T6HppD5WN1EnweLg2XTecDVIPgnb/06ZDt1BawcQVZC/s
7OTbh9YHbzJz8WU2dz36/QJrIwayYdkCv6uSF+iwIeXhJw0/Nnd/9u/ez57j
HmyI11IZMoihg5DPBcdAdP2S1r+9eF4g5W+/ddyd2BDSO/wtIY0Oggym+hp3
Ntf/ZeUHTB+5yYZGaxWj3PMkEAhmvnZLZIPgqg8aLyNIcELwQtyXJDa4WdSu
pSeR4GmF/5GbqWzu+jrzclbA4Q4bqp/4qoxkk2ATmdfoxW10PQXJRnYNCdxu
nxHfnM2GwPHcBj20Xu5qXtbVU8iG9O8PpAuWkqFhIGtU7ykbghLu+fWsJEOZ
6E3/8meofx8syrwSRYPTLV/U64rZoDcV++dSMg0qbHqtriM7/f7sJZ5iGlDW
jEkLPmRz18sOXp68w1lsWLE6VnZinAYFnWsKGzLY3PcpnYtik1kpbIjUfNE2
RaHB7LE7YZvR/ZK39WSpCNGhxWC58Aiqb/o52omjS+iQ4RRsPJPM5p63W2kp
oxP2gQ2Wz0ODnsqNw7OUk4SkOjb3fYLl97f8VatmA+wU2p9sToZtK16QFSvZ
YPbiUdel42RYTa/U9ahiw7nJjZ/PepGhO1jzUlsNG4Rss+NVPclAdRL3NkOY
sz/wU49+KRCV7/xkeUtoKP6eiE217BvUf/nL7ZcnkqGd9LJVpp7N1QN5iWfX
HnjPhgz5alZZBhlcGJ75N9+xwV5o0Ni/ggz5SuQBZ3T/PF3V+4+h9fyCdLq8
SCsbNoYzf7YJYNDw/jm2p4MNI2G9tS0qGCgrfTo01sWGrTFBQoMI13zspY4j
vHNYRd3TDIM/yTuuvuphQ79WfWGkFQYTtHFhyV70fARvdNI7jcFO5Z8tml/Z
UCNo+KnlPAb777G+/kD41vhLS8cUDIaJyb2n+tkwuTRJqOIeBqOlIzY7vrPh
pPiq1z1o/Vv5KyH3LcJ0J/4bq5Wp4PbdWmkK8VUWbmY17qMCzyY9lZPf2NC0
Zouv0mEqFBZqST9H5YfsGJDZ6E2FP0tdhePR/cglWFtO+lNBxYzfSRThQM8b
tvQkKjjv3PRSvpsNxY4O/O7JVIj+EZUjjrBR+cXVMSVUOHHpdtYb1B6Ddd2v
7LuoQJjM2STQxuaub5+2+4X6NbJBw8tsowNGBdPxvfXfP7KhrqMsSGQVDa79
CjL2b2Bz33f+Gi5mue4tmi9WXzfdIUmD6/8cQ0VR/8jceq8xpUqDfKnFBkmo
fznxxuJ/xx6po/GU9P7DvZp9NHiat1J+Bo2Pa3zJAeVGNOit+j4ZgvDWdV5r
G+xo4Fs9cqvjFRtub57dHGRJA7W2xwsOoPHGOc+54SpZ5g6RDVXfK2R4S8dB
6L6WTsE4mxsvfakxJ5s0iOYnXp2q6T6k14603P43wIacrAVbP49iQLupGH8d
2feuOZN6ZBaDjd3fmiWG2CB2U806YhwDt7yfe9KRnfu9lsx36wqQ/eHP0LZZ
JgZ2g3oV2xH+bW+79NcyCqyTrki8g3DCj9reaxsoELt77TW+n2zIn11v5ipC
gc3K54yLkZ3zPt/B1lkHO2RXKp1bWob007YRbYU1CIulZplob6eAXO9pMyuE
NY4qlPDrU0B955IbiQh7rf6qTNxFAe3H6ZEeCHPe9/vzdJloOcIbXhz7sW4/
Ba4ODqRkIuzgPXvylyUFnhwp+lKKMNYa1NLpgfTEhHlVHcLllcL6W49TYIbd
EFGJMEd/xE5c3FCM8PVl6WFbfdDvr5w6+wZhTccp7d5gCqg4DzXg10u9tEyR
cJ0C1qolwTcRTpBMei4eRoGoIN/Upwhz9MdMkMzGgwg7duRhJKQ/9LoG+SIR
PhUqPiOJ9Mf9al3TY3h5Ss4qLkh/OB0or+BB+KJesmcF0h8Gt9wG9BHm6I/V
It3Rkag9za7uljiJ9Id9lKL+GMLrz0VCFdIf2YZB0skIS2ymvtzURYGUK/eH
BRA2N0/exI/0R9TXKcPzCHP0R+Tq+062qL9Dql/nJCD9QYpazSIhHPjKXrYY
6Y8OuQI3F4QHy1esO4z0x9CWkKEcNJ74W3hvLET640dAygUrZOecB1bSZR0q
Xsqja5E1wVwGE/Biuvv680U8utd+jx5QOzABIfkuZguX8Oheirn0sSx0ArRZ
WjF+wjy6nPdze8oMtRQFeXRnX1TLONfOQG7s1dNi/Dy6j7GOzoVlM5Cm/WJz
42IeXc55X0xrYEJShkeXJy/f79qGSXBfq3/fV4pHd0P+s45dlpOQuMMz3FKe
R5eU2W18ZNsMdADxn8s2Hl2XJQQtotYMiC2eunFAmUeX8/6xVGedswcqr3Sd
esGk/wzciM0YstnAo5udPLv0pu8MLGmbfLsYlc8535vCyoyLVeXRjXqXIGQz
NglZV39Pbt3Bo2s1qKLmypwEraQwubKdPLoxllGaKuunoM9T1oVPjUeXc963
YmPgxTkNHt2zdb3bk9SnIHCHmY3Ybh7dD31bNmmkE6DN8kvYCSkCaPwavK2Y
gecHm1mfi3Be9vuK97kEOKyQRnggQwArnXixpZkESLu66eFKaQI3H7l6T+dE
2GYCLBPamu95mAF5tXceMtHvl7UeGbuLcMaLZolhhHcfo4pX7CdCyrD348WG
BMguW0gTP0IEt67WJ0VGBIguW6q42Z8Ir98cOhp+iMDNF6jJdN/ifpjAzcdo
QL3zocSUAI9fFlg8KqXDD+9zl3dYEsB4wseo7xGdm+/UeBUT8p/QQbc26o0w
wlYfKM93D9IhztppVQ+6XsTa3DnjETrYv3MQEDYgwERCjWG8PgmEb4aZv/JD
ulZaQujvIRJkFHQFqQQQoGRW3X6HDwl6Uj7nmpwlwOVtLv+UfUkgK8tjlYB/
v0VTMNckiAT3rD4vuhdEgKtSfL3rEFa4Mfk6A+HMnSxaxg0SKDkMTNeHEKBx
6ZnVuhkkCBHXO6NxngBVgt/tv0zToNqgzfrmRQJIptyu00B6hcXvXxl7iQCr
tiVc+95Ngz/Od3O7IghwsLH3qP9iOlzrYjr7oPLSv+/73CJKh2ry+RHfcwSg
kWw9PNbSudcvKyAU1m2hw9OI7JoFgQRYc//EItpOOhyq+Lr9LqpfGvF+U9oB
OtzPKdMeRzq/SLj88JY2MhhF/2VboXFyI/Lq3OhXMqy/k/pDB40Tpd18c9Zk
MgxhpabUOwQI1vdcis2SYUWKgFs0GieBpOs/zNYh//dGcZdNFmofzxMh8hsw
uGB41igfYSVF8nNRwEA/YVtgWA4Bkn49fHRBFwMitUUkGWEl4R3kZqQfppI/
GTvcIwBmMhY544qB3rRWqRkal8sKX7HenUL+fMAbU3ycuku5PMu9hoF58LTn
QB6Bm6/71axDtGU+AYQkW1JOP8Sg3jD9kTbyOzj5ur/eyCM+Rjiy2WuxTwsG
rvK8V73uE6BwLcHuAVrfzi5dJdmO8Ha/GL7EKQyetRxocStE/FHrjqw5DNxP
pIRUImwwtT97YAUFruSk79j8gACuVW8MUqUp8O7wazNfhDXWfZa2U6NAWOE+
1WqEdeMUK2MNKJAkLNg0grAcdXaWH60XL6yvrF39kAAb7BNVLp+kQK3ok9+b
EU6wD+scQv5nV3XANP69kzllWm5wPFrvREWCdiJM13h+cRLN5z65zlHrEf7G
dBTzK6aAX/VaBRYqv/WpoPDW9xTQkjnq8Q7hV+2Nse7dFCg1HvGPR3hfb3B/
wSgF9LWiG/H7T8vZyrZF8/HRTN30flQ///iIK1bCVOAtbb5xGOGzAWlnzCWo
sNje/ekoah/+/SVEUKXCU428vVsQttBjDe/XpYKdlddlNPagr1wn0NuGCkTm
B0IN6o/tKz3t97pTQVV/pEATYd9m+dLeMCropf3WZ6P+5ORLn1tEdj6HcLC4
61xvHhXExAO9aGh85JneuB+fT4XxunirCYQn3h/CZhuoQGPnlrWi8bU5SE8m
uYkKIvUGnecRll9WUfT3HxXY7m9e2aPxaWQdVzs8TYUjn6QLH6DxW9Ssfi5l
MQ12RYRduo/Gu32kaVaaGA2CdKqjfW6j+68zMWCmkiHFM8C3oYcMAmri9RZF
ZGB5/TjyvpsML5NfvCK/IoP3ipIhoy4yaDmMuFp3kMHCMVFD7jOZmx/7vsuS
EwvR/2snfNSlaGQY2LzDtwk9Z5x82TXZiqTZVjL821a/ZhcfBo0Tt24PITz6
dOMHXXH0fHRcz5xpRn6DfQLhoSQG9qTC0EqEswKWukloY+Dpe7U/9CMZ/mos
u0PfhyF//W/y1Acy8A/xPZdyxCA5kX1IqRHhxo/DIt4Y5EbwhHu8J8N4Bjw7
EIFBoUETmb+BDO9susXIiRjwqRIbJN6Rocj4z9tspE+lN7ysH6ong+mM4PDN
PTTwG6/7N4zsHZcD39UcoYH86ojsAFReEsXgZLQ9DXqKFZYdRNc7cks5YFMw
DR4krxNwRPe361fGVoNwGjz0vH6OgHB3zluLsSwaaJ4KS3reQoZken7Rhxwa
vK5dzPcNYcJB5p/Pj2jc9pCw+vpF5C0NRHr3/V78iczNV76P8LRAFrUvJ38q
9oTkWsGL6t0oVd7uiebbfD+1LSwyd74eGvVI6UTz1k5C1ZE9uP96eVnAHdQv
AvYC9EMIy5tdKbyNcH+veMemYuSfL0y50kEiQ3PGg10elSQQNNHxCiOSYcO1
hG1GHSRIvPGWqDVFhvScU75FlXTYZmkm9gbZV0o0LNlbT4cOV1A6iuZNzvo2
apOZpKOMQYxUrE5GEhEe/526s0IR4+a3jSUvU9aUR/OWf6rf+H0iHKMef3pC
FoNjuUj4lxNhodqtPiEpDJjBthUXaohwXDhGqBCNixdvMtWsuonwXTazvG4t
BpZXtu1858OAM7rGO0PROBrQ6KxKPMeAOEp4ezjiO+reulcySoCKX9q6L4+g
efSf+EarHjQv2YU+UjuG5lG3/U2V7QSo/XOMz8cG/f4rQ5ePjwi2qeoqvAcw
ePPd9MCPxURojJCx2GqMAef78dUXHI3iwzB4+Pbr6XC07ry6VsDaHITBETvV
n6No3TqtcvGgyBkM0leF/R7rn4aOEq8PYoUY3NGK21QwMQ3PFvIcLsnD4F7t
tKbeQgIQP/R8l83CuPliTSJv9Mn2oN9vUTdfoTYNy+Rspc43Y1Dx273B13Aa
zso8PFjRiJ6b//KzH46ki+F+iXd526vkS1OwV7jBTZOOgcti2iXi3SkQtLBz
tyBg3HzAsqTTY5Eb0bz48W5Q7MQkCIgWTs0hvyImiJX4cekUDBBI51+uowC/
x/ayNKtJ0PAOT2o/SoG7QdeqSeGTQI5r1PhhROGuF5odg04WyH7LvK0hB/lL
oqdup+tYU8BEWEjHYQDj5jsfWLaUUfATrT89bYTVCIfVtqybWUmBPeB4QBv5
HZz15UNjqr6gBQUcvhhG3NOkQKex2d6lRyjc9cXFjVdHy4wCz4T0zuo5UcAy
rPj7aVPEv7qtuRXhMPFiTy+Ed2RVr797mQLnm2a2xhxE64z/qFrENQok7h4z
tkG4LSvvh1kBBTJdrwQtPkCBL9frBeofUWBJubB+uwkFvEuPqTl/oMD2tj3d
VGPEiy1npH6iwPGvySIfEf5zLlTy8xgFzhz1ErBBOGPwe/gsGbXjSot2fYQN
j2dveIDWF9EdkgE7EC526qihraHC9QO3J7QQvjLp5Ty8E83/NXE7ryNMuxGV
EqdFBbJ64fYXCEuTU17ftqZCkHL/Pk90PwTNt9mvHKnAOj5QfA/h5uu2/bUX
qfB1JX9cB7r/bz8FNSIuU+GeuF3nYrx+FasN3dH60k66x/P5EOqPySMhv9H6
cmR4xf4RhNPPe8RSi5F9TUxoHWqv6PrJ7J/vqVATLYoBat/myKxKmQ4qhJ51
8BZC7R/6ornxwjAVYkRpMcKofx4e5d+6Fvn/fhvtXfD+46wHA/cJdlgEBVhN
FZ+GMDI4x2X+XIPWec56EJX2Lqc6FI0/xWfauxdhkCbhvTAyhAJCYdN9S5G+
8jIxClMJooDkeHhWEZoHHu0XMJw9g+o3ElV7VAODzttiX3L80e8j40Yp1TQ4
5RyUbxJAgZuZJ9a0fKDB45T6408CKdB96S3j08UJ8B/QSf30hAL36HbXpgsm
QEG9aGp5JgX2Hl45vG4TGa6zO65eeUoBCq19Ul0P6b22ivdPCykgIXXeTsSU
DFSf3T0n8tH1BQk60Qg7yhxK3I/wPqFkNxU3MhQnPYmKyKKA6oeKhNv+ZFjE
/O1y8A6Fm2/651ykZAsaN4/V6e5G9Ug/K2wVF2ynwM5IU4W4IhLUyS9cV9WD
2osVX6KTh/CGrT72XylQGe2TbN5Fgk6p9cV6HynANvxu3jZEggXp72Zb3iHd
o8BuEUfrwdRmkfvtuJ8Z9PrkMR0S2FR3DkrwUsE9/uhRW3USyA3wSUguRP1Y
N3fIwYMExwqzTJMIFAig+nzy/0sEpUQJscBNVBjYdfmk1BwRNnfIBoRuoHLn
696DYasWmlHhkOPW7NfZRAjf1V119DAVrAiB99yLifBmbtH0SwMqvFVtXxPZ
Nga6b46U3nhGBe0VzFVFQkS44b111+EiKjh3HO9zWk0E4b3pHd/ROOyPywqN
kyGCpWazpn8mFepm2rvruwjgaRawNasbPSehH0e+tBFgccPOveZfqdz5umft
V567fVSIOnzY06sfYf3zdvfaqaDTe3QmWmcM0tuoln1badz5hNjF6MDzsKku
8gmaFqLALplXT4SRvebHad9MfgpcTV01+WAbDd58E9x1C803v7+o3w9XoHHn
m2WCOgda5Gnw8qv4wUH0XHoe2ntaEeGT6oWeMg5oXkhW/m0uQwNx3pfPLrhS
YKzv+80caRpc7Fv77m0YBV4ruhvaStKA0rTqzZFYNG/E9eXwS9BAPdpjKZaN
5i2575tFxGlQadd8YA9qh4t7vJRKEf710/zdAGq3+pg99jsRP26U5kiop8LG
mzL7lKTw9/HsyFeaqZD3drPvRnQ9+RyFsCtjVPjxPnf/d3R/nOfT5/Kw4BlU
nxWqxOU7xMZA+tH98CfWNCCtr1lycsMYbDWXnhs7TOP6H7cGFj5WPkYD7djs
85uiMSgZz67XQnY3uQupT2MwOF/i8LLVlAYlz2JIhwqQvyC10n2DEY37fP96
Gx7+5CIN/t27STNfjAH1KF/0s1AaaPTktL9COqL3G8NlcyQNWo+pNg//RTrx
TMyRqWiki/RdPvCvQeu8iuRG4hkaV5/Ktzx7JvSMBgmpKzMePiXDBV4B0fJc
GkyVrz/vUU6GrrdCN2eRzuI8r4vfiXqs7qGBla3WZZYrGVzqZrvUm2jguNNM
444IGSgKNUJjczQwzTcL9OUnQ8Rf56WPFtIh/XTDchlhMjBPXQzKZtG45/Vk
FvEtCaXTwEiLMfpvFRkOuz9UZDBowLetcNH1RdMgMi0vvcMW+ekbPaOG80kQ
1KqYcd6cDivce5xl7pC4ds7znZZWsAOzoHP3E6hvrW6sPkiH0e6FTxQKSTDg
e0onwowOTfx1Hc6RU3CS2Vx34RsdnLvzkg2jpiDeoYn3RB8d3oa2p2noTAFd
ILGHbzsD7u/semizdwr2HRsviN/KgDeyw4RvE0RwbImxPSPHgL2SicmvSETu
+3oPx66d8p0iAlHz4cpVMgwooYTOheUwuOU9sPyyflZ5CtZdD7KrN2TAAvaj
eu/hSTiyWi3YtJgB6zp3Rz7OIXJxp+jAggUfGVzM3KpINQknwtAGRnw3/wwc
EctJkns4CQ/l+tekb5+BGdbG7FU5k6A8MhQWsX8GxE87nhJ3IIKGSo6KVNQM
bH/w704K/j7LhbbOI+Ez0K+2x8T2GBF45hP0zMC0iRe/quckSBsu+UOwmwVx
5UqRkwiPmIz7lUXNwllT96lkhA+tXHQ4JnYWDqfLzX5pZnDtGplav4+1MsC7
8kJoz6VZMNuyxH29PRGKD7cxgl/MQk3mL/297xngYSI/eix7FphGV3pGChig
a5O8nC0wB7bNXX7ODxng6DjeFsecBYHfTjtzIoiw2OHMnfodcyAccnh57BUi
XFI7JpiuPgf6pl1rhSIY0OFydGOU/RxcZPjMeEUy4EV+5c8Eyzkg6CyrHcqf
hHTP3cUm0XNAiSR+Da4ngrPPOi2hkjnID4ow3KLFgDo1ObWEjjkoDBKMvabH
4L6/Umd9d0WYNgNy+7e4PW2fA8s/EQNlpEkgnP1xJHURE8aSFtT5UCdhEX9z
v/kyJrS+LYm7OU7Hvwd1mrSdCa9dQ/e6YnSIogswChWZsPbhrtpvTDqo3uPL
Mpdkcs/3nym2Yd/wYUIzDEtQO2eghH3cpPUEE6S6/inGJdDBdBfhulIkE7z3
3Wp5EkOH5XPrKgpjmHDISL0r4jYdxPhahLeGMcGw+QnZqH4GjK9eJQ5EM7nx
nowsRsy5LiaccpB9vGM1HQoFE+XLO5lQtWrdumheOqxVPpgv/IMJJDaF0Yme
S1WP2OunfzLBkXLeMk+BDo/8V/AtaWIiP3bZ2ZEHNBDLMzwax88C7aGJTaw6
GggThrbtmWXC+hLYNtFIA0me4lWP6Exwp3WL8WvTQJGnt2XTZhYI+4e8LNZH
8/Rqyz3aSixYoQBnzyrSgDcpJOfbNhYckZp0bFuP1oE0QcnJnSyoFY+GZWgd
2K3UL560gwXrzZYo/LFA68IKnzE7ORY0MEk2/I40iM8QvTokxYLt1fXv1JBf
sNys2z/kEAsGLdpukp4jfcwX/INkygJ9E82KJZ8w+NBCDdWzYMEVvrBFmzuQ
Hpr5rnkCYU48R2CUUR9syYLxmu2mf7oxYK1Te89G9lVkK9U/SPe7PniuoHuM
xdXrRoIfXUKt/6+oMw+nqgvb+GlCA01CpEJCZUhJRd0SJQ0KmUUDGVKRMjWI
KKWoJPWSIRpFhQapEJWEN0kRScaMZ5465+xvvdf35fvzvtY+++y9nvU8z+9e
+1xnk+OlC+JnE/72s953J9JZMtIvV+yL933qIhnZDwl/Zl/Q4CrBxvtVpbXj
uZBh5CZOdpfA6tHop28khI//Gbz9kOjay1apToQ79ppPbT5PtPHmfdLmi7kw
f6wrv4ic7+/+yV7vnsefnEg89N31DztxEdQ8/44tub6/+ydXpJT6BfYS2Kl0
Rs88zsXrY6vlcrdJwHsopZYRyQVypiXbEp3+sq56+g3CASxP1hCZv+DO/c+6
Sb/M1WxYMWqjBOqNzz/tIvXsyHdLesxXCWgTO+UX5wjgoP3dy/qzBIeWxEcb
PBZAPczs/eUqCbyX9vUedhTg+BGjoKnSFNy25R1cuF+A2uJPq0V8Ce5dUqbF
TRbgbNMz9Xo9Cun5sbs+aQrAUFxKW61B4cJLjZ1N5xjQt1i6yXIDhVknxj00
vMaAlaaf7rgtFBY4vHW78ojU7fOhSUecKVQuXqOamMPHz6crflvuoEb2d3MY
3aXBrhQO0m3mDM9mYtbeEw7tIRRmPlXXLtViwsdCfsAunMKRB/cty435OE79
m3nqFAXBaOvJBqTv+B8orIk6+t/77z5OOLydjz3CVbeUIyiw1u+6XVjPhIy2
u0pKFgUv51fOM1qYePBruU9YNgXFY7Zucn+YiHzZcsDnHgXPY/eCNEh/NFQJ
e7cml8Lca9kUI5oH39hlJRaPKLw4ErbPNJWHrsW5DpvI+N98M6uXjPp0l4J9
6Qxlzfs8rDaznDWL6Pqwt9mqr3morKwxziLfZzA+JjLiPemjvXX3g8j17D0V
J32omoXbWVc+V1dRGO37c21PMws9bt5yl6sppN3+IT+HxcIpJenRRrUUAlSK
1/38Q/j8e88atToK8gpLVHcrs7El9MQJ9XoKK47tmqqkysZo1YW1e4hO9Gl7
Zq9L8sVS63bbZwo/Uj6xElezUZdnwXL5QkHvy9azNcTnvzzysnBxIwXVjNnZ
Gz3ZaH/04Nvob9QIH+VEnV36m+i3cwzi10ex4Rbyy8C9mRrZnw1bypS3+E6N
5E95l9b7ry0UlMPDXhWS/DHfqRrzbysF8cWDmtkCDpa/bYtL/EGN5I8d09rR
mOjYwrHxZQZcmDR9eplNzvc3f74ox+fmkO9rf/+8q8eBiwvS3ZwJTdRI/txX
LpgqRa5P4eHF9BPHuFAv/+3WR+7v7/7jyYrmC5wGCptk1afQiD90sOkbF0bm
J938ycqkbC6KmM8sjIjOPv/YXkR48031h0dDZL4jpk+yWvyR+IK1EQOtNRTK
rBt07nZwIZ4V0TuOxGdRw9tDuz8IoTXX1egRjWambBqbkvBa+H98RTOz3DZt
mvx7Icbt+D7/3Cia2d9+0qP2aLadiELGtLi3Y2uFqN0w3vCmhEKpds6X6zFC
LOuN1GUo0szqbx+tSCMc0NnzqW6iMs3sQr65jlakEOVzGzhXZtLMxu+BnXSi
EBtvH95RIE8zuz7T+aapvhClWdll3vo0s2kBSjFnrYTgu1RtUNShmUkvM4g7
vUWIxt1HY6O1aGbn+IHTNxwcwqlvS8xtTGhmSd6KL8o8hhDm/ydk9kqaWdQY
E1WbXUOYtvJl0maif5t56Zo8pcMvcTw7Yz4dkQd0F5VU0jG2qpbXq0NH6J+O
ivAvdGjkngvZp0tHwjNhu+cFBmwk4XwNW/qIv7q/7UlLtT0daZ5bpEsfMMB9
cD3+miMd004+oC/KYyKs8k7Yh6P0ET8Z/Dtn55XjdEzllt3vqmVCVkM0KyeS
jgMOtA7VXzwUa8H8RD3r/5+/qNwtkG5gQejz+sbsdj5212mY7hSwRvp/nEJq
9GmSR91/Vrt5XBbgzNkDPyhN9kj9vOT0ofO5DlnXvVozq/MFKGid/JSnx4ZH
janRg1FCVNdKwoI2sXHZWdr+6mghXMSyF2uILrFi6K2bKMQYW3Gj9VY2AgNu
JUSOEWL2H5PlCzezsXhR59tiPyGoUU4JUkfZcHihHa8TIoT+v2o5iSSv4P/m
2vloIU6Wt4ZbxrER/YI5t+qsENajE85sPc/Gsgtbg//7nb3r89i3KTlsTHPn
ByuQ9bbdedf73lw2tG0CZfrJemxsVc8qKGSP8EvL3riY9mdszOoOut9RJ8Q0
6cDp8kR/fmXpXiBDfM0rS7v/9rNi5wdkySnxMC76fBXlwIFbibXcGR0eyBp6
MtGZg4LdTfFruonvchyVviyMMzLf3RNX7NkTwcGPR52BZYf4aFAoN6xK5+DG
R6sLHqF8bNFTXGOVSfy/TYRe/gk+9o5LO1F0k4PAgrUyXsf5I/sLV0067V1b
+FBN2jM3+y0HZc33dM50EZ5KujYx7gMHZ9+Yvr0yyB/ZT2guM1+0d6MA1Srb
ESzijPSzoQWlm1aP4eK8TXNU/m4BwjyLvzpOIHVCdq+Slp8Atron/QzkuMi8
mpjSNJ7U9y3Nfq7EL/+9f69EO7k5uoRb0o4dvazNQ5njqJNXDHg4FteT6kh8
V9Kq1pAPW3kj9f+UP133oD0PYtGg9PjnPOTX1f5IdyGcdvhV4jkZPjJYQSk7
iD/8y3s3o574tp7kQc0zd2GrGh9z/dllUnE8MHZ86d6oy4eL06FNUxJ4KFoo
N+Up8U2zOtrMArJ5+Kfm2OESot0rloceJNr++PTiZ65kfmtKPXh3SVxmRyu8
JuOvXDqnBpHxzHTPw2v9+Ni/KZG3ooAHk/DLK9cE86Huvv3rZ3KduqvyFC5e
E0A7PvZ0PPFDf9f/7KqPBq/1iT86v2jLvH8EeBvTyNpG+n5fe/pSr2Qyf6wh
0wnETzUuvaRXVy6ApVpbdwI5rvMhR7Sb+IfZSUeTUgl3GM/Rf8gOZcD5jYH1
DFURluc5ylw8ykDj9+KnU7VEaDfviC25PoglCeOPc4NEmJkZfZN7YxDeXcdr
Uo6KsCr84ZtNxQxYCOftXJIjwiXNsa5hZQy0PJavP/lQBIfj28tvvmBAr8/T
ye22CB7KweenFzFGfh/vsrjvZcQzBvJqwzVXZ4ngXMlcurljENevPHrdxiTj
VsY5qX2DeMWat79DJIIo82etkioLs2w7YqwbxSP7ZWvLQ2njWsRY56G1umsZ
C7dEfhmev/7jabX4u2tZmCBH61PoFaNo9mpfY08WLrNEdovYYgy/nXew258F
5w5795+Et49P3WydEcLC/imB+aFiMR64/hyYzGPhrtJk4zVaElzPm1fvxWdh
wLorP4Pov/sL9IS2+f06hA8tvi/OELJG+Lw5+eKW1iUcHEnZ8FTDTTKyf6O0
RUrKkPDoLGG5kTbJY2fb5jlzdxA+ZHV8m9RGR0z4B1spGjXyvEDO5K7KmnEU
todEjU3h05FVflfGbxKFDQ2/isrmMKB2c0zC2tkUpi0wmFOxiAG7r746PYT/
4heHy7stZ6B7cXrEJ20K82/r/FIh879i7RezFEdqJF40t1vJeYTvZK9s9rT7
xMDay6kraj0Jr6VTX68E9cGmvse/5jiFp9PlU7fH9CF5cp5uUiyFXeNbPUzS
+nDwbct3o0Rq5P/2Fd2jU/qTKISrZTkuu9WH5lUNDsWXKVh4Lp+vZsnEhewm
Ne0oauT50fe+H75WMRT+OcFxeb+LiUvauU134iicrG2O2qDMwh9x4CeZh9RI
vPf8ChVdeUzhRp+mbsUKFvJ3bMh1L6Kg+7q1PSabjZjioHM+hG/+Pn8+tnj0
CXPCN3tcLCrdHw/gy42i3CukH7+JuGFLJ7quTOFEDtEJahd/lVQMoDx9mmmk
As0s5MBXo+CCgZH+vVema+bu3gGwVpvd0yD9/jH2m4fEDiI7Ni2rTZtmZnD4
uF9J/CAmrLIKCSD9vFSKlhadOohA5ycT3i2gmdmovLFwTRpE/t1ujRlE9x6K
45xRp0M/vXB3xig6RCeCva+TPLbIUU5M16fDpqi94Kcz4W/65cSnPnQEmWN/
bTThzXc1Mae+sVBfcnCyD6mH2SF+OyrLWAjPfhA0MJqPKZNm0NHIgmuVXpXG
GiaGFQ7Uh4xl4/TK95v2/GRiXyTv2tgBFh4N5VnnU6TeL/yy/SPFwtVCF7UO
Xwa6xG0fmvXZ6P9XecGLDsID7Q8u5s9gw37rmC0ezgIkUqrfDhI9/dAMa78e
4ke2TSl1MWdDxsHolK2qEH7PX75558hGk8W9lttWdBh29+olRrMxQyfcaO6z
Ybw9cMn42AM2ygK+hNVMpePKgamrW6+yMX9QPb7lHyEWFMYZqxFd1hEoZ9U7
BJdxEll+CxuchIYEJbsh3GzJTU8Yy4GJ3j9bOouGwOM9Zlb+Jj4yBab/+75C
FXqNPgcXPBzKCtWHMEXnctd54iudAg5kxJgMIoiTWtu/gwOZfj3Zj1cGcbn5
hdFUcGCbuu7ZhI8kvzv6HGJPcRC1q3WPAuHvzZuDnQX7OFj18vzA0B0e8gZG
S/1DdP0jl7E2Y/ko6jZ9uSqSg/QWWTePvQPYHhXTd/0JB5wbxrXNzwdg9XmJ
wexLHIRuqDPYQdazTfXDZV8ecZA70aRJTPqDwgZRuEUKB+KFU6Xskvjo2Jeg
WnePgzFzT8aoKQ0gN6Sxc2wrB456er29H/hoVvidGfCag3eZ7d8fk/hd2ZUz
Wb+Rg6k1W7OMPvbD/dxhY59xXKy3ciloDmJikLVTakU/Od7xXWFmdD8maIiD
3+tz0bLlWnzvFwZGbTH+qEt8ceK8+VVjxjOxTlJjuE+Ji4WBRuciIgRYIhts
Vkc0uosWVV0SYKdsKq9Fi3B/qa+r3+p+fPo30k3bjQuVyEUBycRvlgkStJWc
uahWH674VMIApTHcq7Kai2tjZoY+/CLApkKrNdeIz15W1pRwSdSH8ZqNj+PO
kvM9l/4834IB94yCwoOnuNjqQJ/B7xPAV1OBJefHRV6G/awXlAABnsk26ke5
uNE5lvmIomO20fLl9gVcrA5+O4Ui9S88JjP4/mUuPCIeLVN41YdnOm1SfcVc
uEy4E3qB1FNf1q7wijdcVC4fXtAT1YdZLUXDZoNcuLavF8R69yF3TdxxTWke
FCtG2x5NoqPyxLnuu4RDFKoqZyvto+PswQ8bdPR5iHm4JPN9PoljxHDtI5KH
QreQXYnEzyj+vHd//EweJjbeWahv0IfXRteXupvy4PLTghHoRAc/Od89wZwH
N+MY8UY3Nlz9i219XHmwW9HXM76ADZWVP5TXkvHxiicdUrOEsEm87GJnwsPy
kmttokdCeG/T6K6x4yGwZYO3uSEdnUu3G+b58bBw07eld+axkbAss6tyPw/+
Q9Yr/i0VImSZtz19H7nefUPzkmTpyPD/qHs1iYdvx5YUtpxmYapmUUZvIQ8q
njtZV1fy8eJhnsWuZB7W9Vof+N4wjH93GCralvLAbVGlTQaL+Dmj1owfPFwT
BhzWPcCCvP+n5m3lPLB9v3ouPcnHkNfqwSKi9ff/+H3mKh/yy6O/9dfz8H3J
iuT7F4fRpu70o3uQcOm97XfMA4dxJ7lqr9c4PqYbsnbe0GLB6V6T4BQZz5Va
6PHVcBjnC7/9rDPi49KShSKxmI+S217ze/X4eLBL6sO7Z0ykOYeMOgs+ssZO
6706RYCoGwuNz6/lY4/4LhWvLkDpeVhxnfi4c2utTy5vCMHHfi/T8eGj4Mk7
LcFeJraF791x8iwfCaF5rOYlAtglPVWaf4CPZ+9KfmjnDOHLoYu5e57y0SIT
EGpnzkSHb8dciwI+Lvz3rtDZTPQ2zG21/UE4L9B2yb6gIYxf3LmqbIgP5SeH
qzxchiDNiDi4fKIAnClNS/tEDFwa0rjynui087V9qpEC8EdpvrTqI8dXPPkm
V8rArSA9hbD9AnipDsraPWZg/7RqRs8ZATx4f9TSWgfRsHrYJqNMgOZpNjG1
KQzE1nxXUCwVwEeYm6dwnuiKprD+FgEm9+ftm/ZNgM0HBtsvEh80dPh3oCCE
ATrdScVxphDPw3f3S+wYeDI974BnhRC3UvBa4MiA2ZmEstXX/uBO1f2WiQUC
VH31vLHyxx8ozWH4x6YJMNgk57hAWQSexue4lIsCTJeVO/JqmQjndhTbb0pk
4NntsOxmBxHG+Qu/ngsh/uxXw6ONAYQfZ0gnh/mSOfuyoMTutAg1Vzjn1hB/
MDsmo7L/mQgJRu/X7W9m4J2Hl2dMgwhZrLnD6f0MDFABjY19Ihi6zZQ7LWYg
f8LpU1tpYgjbVeaGTB2C+qXtXuxFhAf9pF7MmsJEjeXXTKG8GFqmvC0uGkyo
mLortmqLMfeYR9ta4jdvBbHoISZiLM511ZSXFqAih1PfM00MyVmluCnP+Qjb
X7N/8U4xjp41Ed/+JUR38dj0NevFmCqftC3iCBOv3gjuTw0UY76kK/9JPPHD
rB2nvE6KsTsoxzzzxBDmnW4sj0oW44Ojklv2jSFUMvZPaswTQyE3/UdaPZPw
mO/jRKLtKn/Ix1jzUePTVZdQIIblJDZ6nwth98ilQPGqGPfy9s7lvhqCsNvF
dddbMQ6nj9l4/ucQjiWuNNRtFcNwZmLsc0M+4Z/SKulyMQ68a3vpHS9EO83o
iWW7GD1s/zULthEOsLVz7hkUw7i8KVyJ5Lu3nLPJ5jEShGh7x+en8NC5xis0
cKIET0s6/f39hfjlkVuUNFmCg0VZXVc3DeOsoVDXRFWC1Ke1/N9Bw/jsvHHK
ssUSHDnbveY74YBvE1cku+lLML3Hst7OSoht1y+Y7TSRwKNzQoX99WH0y5pP
PGshwdfvcz7WlQ/jwcb3OqaOEgTqzLZW1xBitHW2Wt4ecv5D4oTvfwT4V1Qj
jDwnwYuFWUG7jOlINnhjKpsqQcfFEPbkLXRM2Frh2nSfnC9SkvaU1OcaTZc7
c75J0BNote5FogAaSQdl6O0SKM+JTlN8KcD4r5vZ2mUSXLOPu9deSYd1RXCo
AYt8/tUbo1hrAZyuqV1/JUd4+eARfl2YAK+Vc+4HMSQ4ezfrSuQ0kn+Nrvk7
lCiEbJ2/yXM9WY9WpaZS+oRv/zG1n04ToOh5wOioZRQQVJa30FCAjrcnL8bP
oiAzZXtK5dw+SK1e3NvnTOHb9+CH144xEB1RXjLNgoK2lZac/IY++Fu/i326
j0LfJ5OuWxOY8Mpw8VsQRIGm2FHnPp8PT8viFyWEhxtWu0TXc/rgOf5Q+5RH
FJqDy2+6vWRiZ4pU/6obhN+dfL1uB/HQnywllV5I4e3DfFWbqH6o39sU0kD4
9x+rVTzdYhaWZGkrPX9HeD2teobMOzaUZowx1PhBoV32ENpZXCgf2Rs0+J5C
uWA2U6QwAH7YvsSW0YSH78TMMfgphHbfEfpZOoVg/9mVS44PQPXeoBZDjmZW
YLZDduv2QfQc7EqJmUczi66+ua+C8Ni360lTtPRoZgoFMkfc1En/YloWHDGk
mZ1et0dk0TWE3t1pfRvX0swynb+yN8gIsVfeR9FpOc0sr3WfxYcEAYK02TqN
o+kot/DM2tQ5AOV3TaOvEt5a2Jl/wwED+BA2SZxYxcH45teDpYx+bDLZr8mj
c+D77zfnyNv9WDb51GknZS6eS9mZXPfsR9Oe1q3PLLlYWX3Fe5pqPyrcd71X
OsTFnC2Rg1muDATw/c2uH+Yi7nLu3ekZJD7ffn/78pmL0Xba6ivu0uHWLaeV
wCO8YmCVvDSK9GcTwU/7STyszFz2XCWSDukTvZv/ez7+ce8n3wWWdLRFD4i9
HHhIv5tcWDyHjnXfyod9TvAQdCR6ejpvGH35ed0r7vHQdCdkQtvjYbT2J776
2cjDhzROV862YaiGb9rursrHyqQqe4VaJpwOtZ2bRfrfQKWXyO77EEwV3u+Z
FsWHfpgf/3gEE31zv9ayj/DB6azjfXo9BOqh7aSIVD7Ed30bftuTz8989fn6
DT6e39lZWbSb8JzEXD7uCR/s7OaHyw2YcLvvvTPyPR8r9D9NPinLxFpNvYmv
2WS83fuWby0De/Orbd7ZCxBNma5ozyf5slRvxTk3AaiNiqbbxwzh/E+aY2yU
AN8Nj22QLxmEwyUfI+MxQrz7ernDwZv0v+Kgli5nkveMwOjm4EHsoMUEHGoS
Qu8JK6biswDVi1ZZznD5g1RjzYksLwa8bTaO0yb9Z5WUdMn+kEEYRq5zvSst
gmoYrTn5xSCK9GrncwpFWFOvGvXIRQCdP+yL0RkibInr/mfqTAHa7ys9OSMW
YceLAt+HlkNYGj363v7dYiwIGcsIruHD4YrgwoMtYkw26r76eifxQ7+y3fyz
xfiZ+PKVxX0hzgSESx16KMa40JjSmalClK9XWaVbJcbanpB7i46Scebpyy/5
YgRsspiq4SJEgH6qXrWmBDMbpstJjEg9XvLAzXGrBIKb7w3KJguh+2GKi3eo
BAmH7t6NqRfg0to9nJ/5Erzh+f4qFPwGw5TuvnMdqR+bPNRKyHiDX5eTBcmP
p0LZ1JaVQlTKrH886wkXvOHQqDQPIU6ZjIsabiP8WiTJ0AsUYl3oyuA6Dhdt
b0/vm1EnREylWvWLWB586VIKbY18aOpIMbqkSXy5NxWOWQiw6FXMcvVYPm7P
m6EYSOLa/sPFdzCNj12mx1NMzgtglvw89dA4AZp8JgUduM9AtXFQzax4ESLr
t0U3LhjCrZJy2SwrMfp7GFc/eTLRHvTm5hRPMVwHE0/u1RrGvO7KyUkyEojH
KxYuUKNjrbr6jCJS37NPJditiqCjVc1L/aASHS8Tj98zWsxA/Od/l940I3p/
5oyKRUxUSAW63vCno1gYPlbqGQvPJu+Xe5dMx/ptHY5yN/mYKvTSuj1IOHYo
arrPNiESo+wKPA6w8dyGeyzzv/8d2Tt51uEKNiJZlbLZpD7vMlO5rT7MwcWV
h3bInuThoalx9b31PHAUhJlZQzyYXVTe6XeQh9+qYxZ+bBHCbHTQbYNMHiaV
vAx+O4aFSz9e4yaJ/6oNIQu8v7Ow5xReOM0h8Z2hZLg4kQ3p6ONKTCsJfGLs
5bpeC3C9c4FV6Xrit/oUD+dpCaGeyenUyuIifW7W75ObhTD46Lyy8AMX7J7k
dx7lhJ9nTpGL4vDw6smip68JF25f6BstpcJHo+3ZdT5pDCw423ZZOkiED8WZ
hi82MrHoTaifJ1m/plLxTh+KmTj6Z7qheoYY47fcHLdzzDAsNFTrTViEN442
ffafSIeu7aklNeESGI3ZF/jyKB1Pm56ptlVJEOxQlCB53wfZcEkwO4OCMHT+
qFO2/VhupeUTUUdB4nDc5HJnP7GBPe+G+BTYphM/rpUnft1KZkO+Ec3sfwDk
EZVr
     "], {{
       {GrayLevel[1.], EdgeForm[None], 
        GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxMnXV8FtT3x2ei9IJtz5492wARcKRMGAsG2wAdDLtbvwpKCSooYVEGotgt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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXeYVFXSxi+IgooSHIJDkAElzTAjTDtDkO2m+86gd7oVQQVd08I+JlaR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           "],
           VertexColors->None]}]}, 
       {GrayLevel[0.840347680599748], EdgeForm[None], 
        GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxMnXd4lsXSxl97TUNqEiAJL5qQQBASICERDE0SQKqgAipgV8SuiFJEOgKC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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtnAm4ldP3x09FA2keNY/u7Y66U/eqzrnnvPfe7hlKSqUIKYpKSUSRmQaS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           "],
           VertexColors->None]}]}, 
       {GrayLevel[0.680682571514866], EdgeForm[None], 
        GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxMnXeYFUXTxVcEde+9G1kyygK7y5JR0pKRBRQUc8IIKqCAZAFFEBAToAIK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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtnAd0VFXXhq/SBARpigIKKiUJSUDJJAiSycydCdxkgoh0VHoRUFFRLCCi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           "],
           VertexColors->None]}]}, 
       {GrayLevel[0.521017462429984], EdgeForm[None], 
        GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnXW8VcXXxq9xT1ywW38GChxAMEC4WId7pM6Fe7HF7u7uLgzsbsXubkVJ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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwlmndgFUUXxVcUJSBFpPee8EIQX4SAYMLj5SW7KRRBqihF7A0VQUQBGzYQ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           "],
           VertexColors->None]}]}, 
       {GrayLevel[0.361352353345102], EdgeForm[None], 
        GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxdnXW4lUXXxs/Zz7NpRRETQUwEFdgHETjU3gjuo2Big6KiAoogYGAHdmJ3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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmnmgTlX3xw95VJKGt2iiNN2uwn2e3JDhnnNznc29VxEyV4qQDIUQQtE8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           "],
           VertexColors->None]}]}, 
       {GrayLevel[0.25], EdgeForm[None], 
        GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxdmgeUleURhv/L0mLvJTEmJhpcg2SNXhcTWa7I7q+5CyqoFMGOJQoEI/Z4
7AUsCDYUBEWagID0YoyaqBGkdwTpIEUQkF7yPjvvPZyTc/bbb75eZr6Zd+a/
Z9zcsVmHakmSpEVJor/kDaV9SnuVXlPao7RbqbdStUySZJRedzttbyrt95hq
5+mf0gPq01PkAbe9pLRNaavS20qJ2g8q66q0RWmz0stK293vrSTaGf+OUlEm
1u6VxPqMP0mpltY6UXnt84J+yHWUHxRdUZYkM9Kgi1RX3Xs70eUTMlFX5P4H
S2L/94uenEuSKRqb8Zkyrp+oPt8VJ0nDOknSpJ7OXTdJlqs8SfXLlOdU/56G
1FLfmkojkliPtfqIrp6J8/QTXTsT/YYn0X680ijRpyg/WWlkEudk/CDRRyo/
Qmmw6KMyUR4g+nDlhym9L/pnmZi3r+gamVjv3ST2QnlgEnMwppvon3zvr5rP
u5ReUdrhtu5KO11+QelH8+xF85NyD4+j3xClYzT30UpDRR+bifJHSZyJ83yY
xFmPUxqWRE6/D5IYx9nO1T1OUrmF0jVKE5UmeNzekhgzqCTqr0WuRH+t+6+n
cQ2S4AHn3qn6XUqd1f8KlUcnccdNnbOvJs6573wSPIMnezz2Po3dVxLrIgPU
7facf0qCr8ipxKXqzNxBaRLyirz/OQl+0K/C7Zz1L16H+7gsibtg/MXeO2Mk
hkn/JHgrca6SG85WP4k3yRoXeX3KDd2XfsOzmlvpQt3J59rvL7Tfcar/RPTP
RY/1fZyaCZmbrvpWmeD7fNHXZYKns0W3zoQM8C5vFX0LsqT6ebrzUs2fanNz
03iDvM92mejHG6bvzUrTSmOtMUnoBepuUmqWxL7Yz5VJtI+2PF6v9rZKV7md
tuZK4z2m0nyDZ1dbRmibor21zIRso6tuFH2D0peqb5EJPYPOYn3aFqu+TSbk
GL1GX9ZGJbzm99FNzBsjhtyi857rt8FbQUW87n7IJTKHPHdX/3Hq3079XxE9
VvStov+YhJ5lzIWWEXTe+UnoU9ouSEKHUpaaqXpjrPcH74Vy1uPod7k67ZIu
+kr8mCc+zEpDDyKrOy3DvZQ/rr6/VHpQ++mv/Vyq/dwrup/oBqI7i35fdJno
X6vf00pPIYsa+4Ty05V+5bonlc5Qesb93lKfL7V+XY39jcrPum0d70X1LVS/
SvRPopuLXsv7En2t6DXsU/Q1ojeK3i/6OtEbRO8T3Vr0atE7RF8teqvoonPE
P9E/iD6o+raifxRdTfU3it4iOiP6Bmi1Ly0JWdqmvLrqb1b9Zhgs+nrRZ4p8
Xuk5pbOUurhc13xGX/7eOfZKQ6p0Inbsd84Z81vPwfm/1/x7tHZLdV6PDhHd
SvQm0QdEt6lTtXzVfNjJs5PQrcxb7LoX/RaQUeSzTG+tSxryPUy8elP0QrUt
UlpgOZ5aEm+g8J6heQvI/1d+A9zHt74T8sWm5ymf4/e/2H3auM8S06yz0H2G
aw9vp9HWUHt7OY11WXOq3yG6ZYb3M1j9u6vPzJLQKbSxR/QcdgwbRt/p1jvo
rn9bf7H3Lz3nxVrrac1zmuhZnr+1x870WoUz897Re/+y7uujPXTS2I9Ufkgy
P0DlxuLFZ+7DWmOUj1XapLHvqv3eNMojS2LcxiT6fuo52SN7ZT8z1febNPDF
QI19LI1+Bf071mM/8VrorM/dzt3O9z3Dh9m+5yGa5zXNM9ftC/5PR3OX9J/r
e5htPrb2WUYr/ZBEPsbnWiIhG+f6ca6HRs5YY6dlmjG8Bd4t7xfd/WMj9ZXB
3K7yIimjhdl4q1OVT8lGP94z7xpbMEt1M7Px5pvViXHoX/QC+uG2TLxz5riT
s6vv7Gy0oSMYh13h/fCO7kAO1T4/G+VvlS/Ohu4YrP1+YHwwVPkwpQ2ih5RE
G9iil+5yY6PQDc+IfiINHv5N8vC27vp8rdNVdc+mIXfTNPc32dBBM5RPz8bZ
0EfUYedYZ6hlY5DXmmh9QD06AewIhtwierXWX9g0+ID+Jef+wTMDs4FpBjAn
d8E9ai/LNWaW6F0y9tN0/0PU1tQ6jvd7BXqwOOzXVaK3FYeN46yLmka/taLn
a+zS4tD15ODwH1S/Lh/jx2vecdnAtbwfcO5W6/kB2dD1X6rvV/koz1Oamz2k
78hvzwQmZg6w4jON9Y4EuPZLqU5Q364ypCuL42yc4wL1/UT5P5VWq65RnWgH
O+431kZ3PaB7uD8NPN5P+Xtp2JaHwPtp4PFHlD+sNLkkbF9v27/eLmPP3lV7
X6WV3LfyAWnYosHKB6Vho+5QfnsaeOc25e3S4Mkw5UPT0PFDlH+Qhq3rr/z9
NOxV5zR4DF/vlFzdofSDbHU/tb1bEja0r2n2017tr0n2fq9z36Kx32nsTO5T
9ALRX4juKPquNGQNe8xZsOl9fMaqc5XEvE/aXvd135Xi1Yp83HF96c8Oacgq
Om2EdcII6zjqR5mmfoL6jk/DZk7i7tOwsc97DDLOXvt53RZ+A+DznjrTzfDJ
Z33P++yk8/bKBd+7qf2FNGwG72aQ3+mnqvtXGnZ7h+7gJ6XaMprj0Mdp2P8x
ykenYVdbY3/SkNM2yq9L4z19ovyfaWCHj5GLNPDCKs23UmkBOkT5YqWpokdh
H9LAI8OVf5iGDR+pfEQa2KSWfceCT4l/eYJ9s3uUOtmf+bvL+BD32ffB38Sf
wKeZJH5MVLqkTvTZ534TdTdfaa39Kh9w/f32R/a7Dz7TvV4DrNc5c8jv6uy2
9Zr7++wh3EPO3rjLkyvjPsGptc6J/ltVf6zqa6i8TOO+ywbGAvtSx1nAWGCt
jpnAYeCxv4lep75rs1HernlOrIx5t4k+XnTNcwIHk7Nn/GF0OboCf/VOl/FX
/+oyfvLdSndlAiOwZodM+LKcg3UPd07bpUn4zAOVLknCTwZfXJ6Ev4Wv1cjt
tEktVfnVjKnpdVi7PAlfjbZq3iN2ivePzsrWCdu4yVgx4/Z2lgN4DH/RQSut
z3AYqH/AWIdztM+Efdhg3FjbdZw5L32xR7pvTnHY4io97Te30baFudGlyA8+
WZdzw+9rXh6+GX7ZHtmLX5ZH237Rp5fHmEbyyy4pjVjGLOmGZuWBYViPdcHw
DdR+cWmU8THwNU5TfX3VlZZGeXYaMRfeA/4xMoX8TVN9eVmcl7nBbcz/pOr/
XBb4B+y1pjj8Q3wSdD8+6RYxaWM+bNhm0etFbxV9ZZ3I8dOwkc+fGzGDUZr/
MTFzp20FZ8JmvZgGbgY3rtc8q/Ox3nOqb1AWNoV8UnnQ3+nOlyidmoRvAEiH
Hysk18uzUV6h9mVKP1dxU70YQ3/sFLGh5fZhwCPI0lKNW5I9hPvJkTP8Ft4W
vF6l9pXZ8FvWYAOz8cbwYahDVnpIJ7SR3lxeL+zBCu+B8ibvARuzWqk1sqF8
lVKrJOpWup69L3f/C3T2MeVhH/8o+iPRp+B31A3fEp7vrRuyiFy0rIh+9ClV
Pr48ZBfcABYBeyxwbAD8s9fySx/OzL1wJ9vMS/AJeBC8AiYk4Z8TJ6ih8+7L
B857Srzt1CTmw2aAg57ym2F+ZPXRNHi8xvJxhfczQ3I6vTSwOusRF2AN3gtv
ZYKxORgcmZzm/sjkXmMa9BJ10zwPbcQqiEtQB66nHtlkXdZHjok10Y94DDgf
vA+mIe5EW2vdZ/dcyND1ot/IBa/AH7OMmdkDd8A+iBkQOyDO1APskQsf6HUw
SS58ODApeLW58TVYGhx9vvi1Tnc4RXX3gH9yYef/KvqdXGDkG0W/mQtMgY5D
1+Hjg0OHGIs+IV50aBIyAib9Jh/86J0GjkQWNsCHfLxvdO5l1sHIVH3rjZ7Y
1lz4r8Q7iIMQ/3gcDJYLn+yzNGwStgd7h04mjoadHWT9jF3ob32OzR1s3X27
fQz0MroAPAoWnW6fqbXt94jkUMyVHN5gR4faXmBfBiSHYqgDbS/Q88TxGM99
PN447oQ1wPrg/Hn5iLOA8T/0HRD/W5CPmEuZMXJD7222fS/8O/xo/GP8WXxZ
fFr0GD5YM7+Xnr4zVBPrMd9myxg24STb077JoXgwObHEsZZdZHiXfbZ2tsXE
LPvaHhFTJLaIvSbeSNsex3W44x2O6+AHIffE0XhjP9nfY78FXw5eFHwnfENs
K/FL5iV+iHwX4v3ktGFHuTvuGmwD/+FNIY5MG/aUPSIHYAbOx76rS4725MM/
IYZJ3Oxt6xdkrvC9oqfbrpQ+u7As8CfYcG4+9Bk+JTk6DZ3Be+Yto2uwW+iD
+9Lwr/CpwKNLrfPXqW6Z5plsv+dj4z0wG2cAy61V+8MVoUPRE8yPrSQ+RJyI
+FPBL0KvYPeZAz7fnYYuRsdi40c69jtTc87ORzwYv2i8fbq9wgDf5sPHY53h
XmukacaCx18yJicWVex9EOtUVVXsE//4+TR85FLjD3Qp2BhMC/Yo8reaB42F
8P3YOz73U2n43Qe0n+X58P04E2ORW+5pkutqi4/VKsOOTnQ98+81zrrfmIs3
Cd5A73OX+MVfaJ0JuYjrH6X8qMrAxEvte/NewCvIFu8eHHy0y//V2Em5wOBT
RX+ci+9drD/ZeyBGSKyQ2DAxu7N9X/CLM8GzYdngDXcEXkEHI2OrHV/gDb2T
BtbBhmS0zvZ8xBrw8bDD4K5aqif4vdgxCNp5S+Dpo7xv4hf4Y/hi+JELmkb5
e833SIXtYhq2/3HLPfoDu4IPPMNz4w9NyYdPVE3r7shHHIdvLWCvlup/ULzb
ko+4Dx8ttubD9uCTT3UsCD/qW8dnitRnVz5sEm8DfoIJ0D/MjQ4i/gGuYw38
6jmOBSG7yCy6srvvmxj565ZH4uvYFXApsegl2n9PnX1acdgEsD64njgTMSvi
SejxS922SPtarDTWMoYcI4dveG7sE3EH2onjEBeAr/AUnMU9tbLe4z7QfcTs
/+A3Ax+W2a/v4b3Thm25JAm/pH9cY1WZmM0mx6mIFa1xPIGzEYP5RRK2qJHP
0CcN3Ay2+pkmqV4Z/hu2DhnlzhhHjIGxxJZf9Zve63ssfAd+w/pxp8f18N2y
NnK4Sff0aEXgts/T8PHw68CzrAnO3eVxrIHyAD+3tQ/K+8N3xCdfZ58RW9fN
e2WPYFzwLXKDvBMjJB6FPkIvgkt+ncS3iMN03pqVsQZ29AW/xT0+H2fDPnZ1
23bPwXpb3Zd5RziugV93hOY8rDKwOL4W8X2+FWB7dOQqTEMMYpl9ZOwi3wX5
7rdD7+LuJiGLxBrWGM/jPx/pt1rwXcEUtLFO1TeLkvAHwP1DHV/B38MHwCfB
H8HWYrewadhX7BllcBjvH2wMVgMrP+0z17FuAi+Dm7EX+B7wCmyOjwfmA0vj
2+Jz4m+2t69CX3RlF98jNvsinxn9hJ5Cn/RyzIk4DzIyOhdyQqxtuzHBbvuT
9MfG1/dc+E+N7JOiqz7Khb5aJPm6qjz0JnZyZC70OzG8zfmY+x+qH5ULvwL7
z/dgvp0Sj5+eRkz+SLUfURlxin+nEacgRkGcjHgZOpN403rHTJAPbC/6nW9r
c9L4vtbPcxe+uzb0uwVbXey14cGvLKOFb0XwYI72+/eKsJm3GwOBrSaUh5+D
j3NcZXx3JO6yW5N3bBJ++AmV8U2ROAr8og6e9bXcsTb261bbBHh1ltcGT5X6
rmljbuQR366BfXzii+3TiDHu07r3NIkYAVgNWQOjwRvqch5PXIlYzDHa28sV
UUa2iRMRk5lcHvFf/GPwX8ZnBmsmLtMP2UfGmesmz1FTl3ogH/oa2cNeI5PY
991+33yrgsbW13KMiTsg3vy018V/a+n7PmD/HJk/aJ8c2T5ca9WuDD8cX/NJ
84LvIegyvsugi9BD+LCMAWuCkZmrpsvEChf42wT+FrI7xfYS2098FPs2xVig
re77hjRiuMQw1jaJOEYhNgc2QbfeYp4u1XxXlIdda+/1wb/Ey7Bpd1g/NDf2
Bi82MlbEbpXZN8E/4xsYPhoxC3QrMRB4dK19gfmyOwsdf16Vj+/Hlxq7X23M
j1/c2BiYmPg8fwsAp1dYV1IGg7ew/r/JMlPDcUnkiDvlbjkHNrqVaeaf4TWK
/I0X2SjEjE6xTCKP6HL2fU3Bv3AMBfnCBrW1/sz42y/yVvhdSOF3IuRXJuEL
8jsDfieC74Hfxu9EiCGgY/B1NuRD71Au/KaEufCt+O0Cv3HAZ7gmiXj4GM9N
G1j5areN8NysR/wbGQEffm0ZQXbAF2AvMAY26ky/7U62IdgV7gfdxh2BfZAV
5ITzH2Z7g+3HvmJbW2jvrSoi5tXBckQ/Yv0rHO/6Tz6+TzAGv7rcfIU3+Ir4
l5wFvwGfCHtzgW0QZ0fP0T62PGIH6H5i6Hw7hM/4sdgH7vVrrdWxIs4Jzqhr
rMKZ6/kesE9Z2zXeynll8V54J+389sf57vnNyNR8fNs737YNvMDvFJAB3vr1
3ndz84N90xdbcFJl/J6jnd9Vkc/8rOcAE/B9hnfyheN9NawL/gdUA4Gy
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwll2dwVlUQhk8QARF7HduMvzJoZD5HY6x8188kZ5wviIJKFaTZhqKgiFgR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           "],
           VertexColors->None]}]}}, {{}, {
        {Opacity[0.4]}, 
        TooltipBox[LineBox[CompressedData["
1:eJwV1Fd7VUUYhuEJvasIeKTX5U+wYEWalAMVBQ+ko6gUhYQUQHpCALGAGGro
TQREhBBCCLGA9N5JQkcgREB66OA9B+9+9vfM7JlvrTVrP989qV1iQghhiY8X
GodQ+l4I6S1CWNUyhBx5kWvfKoQO8pFkNQ2hI/aUzjJR3QknYXHzEI60CaEI
27cOYTLX19imd0LYLFtli3Qw1lESjfWxX3kT8zDXfhn2TvR9JOapV8vLeuhq
fjfpItOs+zE25LtjtvoTnI6n7F2kh5P4KTeD62efnfbdJaf5z/iZfDK/m7tj
/z34Od9DUvgkPdzl++EaPWTqJ9n3UbhWnS+v2r+P+X3lS0mK1ySv8ck4J+6N
czEFX+fTcJ46Fefjef0U6/cc9ucWcGn2P6yfI1LKD+AX8v35Iq5YjkqJDDT2
lQwwdkx9X8/HcRA3WAbyKfp+wKdigb5Hu4Y038dgoXqdvKW3seZ/I1/Ld/Kt
NObH4Xj5XibID9KEz8Il+voRl+JEbMpPxl/Uk3AZTsFm/DT8VT0Vl2M2Nudn
4G/q6bgCL7vmEvfkEs7kVnJDXEep67og//Gz+Bx+KF/G/StX+Nn8Kn4Yf5G7
JFf5OXwuP5y/HNeQa/wVnBufiYwwdlX92L26hvPj85B0/ro6+P0NXMj9JBn8
TXUCfwsXcT/LSL5cXYG/jYvjfZJM/o66In8Xl8b7JKP4e+pK/H1cFu+TjOYf
qCvzD3F5vE8yhn+krsI/xhXxHsXnxod3Q6jKJ2BOvBcylq+grsZXxFxudXzW
fCV1db4y5nFr4nPnq6hr8FUxn1sbzwRfTV2Tr44F3Lp4Lvga6lp8TSzkfpdx
fC11bb42/sH9Gc8SX0ddh38C/+LWx3PFP6l+Sq57Nhtin+ZM4OtyT8sN/m8+
L547vh5XX27yG2P/fBbfgHtGbvHlks9viteBm/Ft524rFqi3xOvAbdiC34GF
6u3xOnAntuR34x7ZJftkr7TiD+BB2S+H5ZC05j/0Xp2KZ9b+J7EMn+MeOl8n
1EPMGxrfX/2eVj/iz+A/MiyeMXsPMnZWfS6ecb8fzi/iB/PnuYtcmXf5Dful
x/NnbAQuxgx8k8+MZyyey3h24rmSRnw7vey3xgHZJ2es9Sx3Tx971T3N6yWp
9jqoPhR7M+dsfP+s39vYbPwCX7HeB37bVkqMX9DTS9xta23zu07mdI7/kdba
rt4R/8PMOyZTrNGFn4pdsZf0ljbWel9OmJPt/+A4/g/l023w
          "]],
         "0.5`"]}, {
        {GrayLevel[0]}, 
        TooltipBox[LineBox[CompressedData["
1:eJwV1VOUHVgURdEXu2PbNjo2KrZdMSu2bdtW245t27bNnu9rjr2+7xk3bWhY
ne7hAoFA3fCBwKaSgcCXkEBgdJlA4BNH8TM36h850n7PEfzADfo7DrffcBjf
cr3+mkPtlxzCV1ynv+Bg+xkH8TnX6k850H7MAXzCNfoj9rcfsB8fcrV+n33t
u+zDe1yl32Fv+xZ78TZX6jfZ077OHrzBFfo1htlX2J1XuVy/zG72RXblJS7T
L7CLfY6deZ5L9bPsZJ9mR57hEv0UO9gn2J4nuVg/znb2UbblMS7Sj7CNfYih
PMyF+kG2tvezFQ9wgb6PLe09bMG9nK/vZnN7J5txF+fpO9jU3sYm3M65+lY2
tjezEbdwjv4fG9r/sAH/5Wz9b9a3/2Q9/sVZ+h+sa//GOvydM/VfWdv+mbX4
C2foP7Gm/QNr8EdO179ndftbVuN3nKZ/w6r2RlbhJk7VN7CyvY4hXM8p+lpW
slezItdwsr6KFewVLM+VnKQvZzl7KctyGSfqS1jGXsTSXMwJ+kKWsuezJBdw
vD6PJew5LM65HKfPZjF7JotyFsfqM1jEnsbCnM4x+lR+bU9mIU4J3qc+iQXt
CSzAicF71cczvz2W+TgueLf6GOa1RzEPRwfvWB/J3PZw5uKI4D3rw5jTHsIc
HBq8b30ws9sDmY2DgneuD2BWux+zsH/w7vW+zGz3Zib2Cd6/3osZ7R7MwJ4c
pIcxvd2N6didA/WuTGt3Zhp24QC9E1PbHZiKHdlfb8+UdlumYDv209swud2a
yRjKvnorJrVbMAlbso/enIntpkzEZuytN2FCuxETsDF76Q0Z367PeGzAnno9
xrXrMA7rsodem7HtmvyKtRim12Asuxpjsjq761UZw67M6KzCbnoIo9kVGZWV
2FWvwCh2OUZmeXbRyzKSXZoRWYad9VKMYJdgeJZkJ704w9lFGWAxdtSL8Etp
b5SfWZgd9EL8ZBfgRxZkez0/P9h5+Z752E7Pw3d2Lr5lbrbVc/KNnZ2vmYNt
9Gx8ZWfhS2ZlqJ6ZL+yMfM5MbK1n4DM7HZ8yPVvpafnETs3HTMOWeio+slPw
IVOyhZ6cD+ykvM9kbK4n4T07Ee8yMZvpCXnHjs/bTMCmejzesuPwJuOyiR6b
N+xYvM6v2FiPyWt2dF5lDDbSo/GKHYWXGZUN9ci8ZEfkRUZiAz0CL9jheJ7h
WV8P8Jz9uZK/jF9YT//EM/YHnuZH1tXf85T9lif5jnX0Nzxhv+JxvmZt/SWP
2c95lC9YS3/GI/YTHuZT1tQf85D9kAf5iDX0Bzxg3+N+3md1/S732be5l3dY
Tb/FPfYN7uZNVtWvc5d9lTt5jVX0K9xhX+J2XmZl/SK32ee5lRcYop/jFvsM
N/Ms35QNBP4H4f/Pvw==
          "]],
         "0"]}, {
        {Opacity[0.4]}, 
        TooltipBox[LineBox[CompressedData["
1:eJwV1We8z2UYBvDHioOIYx372CUzMzt7S/bIapNKJYmGdWRT1rFJFEl7IrPQ
pint3rT30ND3fnF9rv913eNZv+f5Z4+9of/EPCml3LwpNWiX0qKOKdW9JKWp
nVOa6fczvVKahZ/F5/Nm+F2zD8idTG/ll+yRUiaUgOJqb5JTVU6WnNbtU6ot
70ZeFV453i30eHoTPSH60dfhSnQZ8Un0On0L61cEMqCQvmPllJVTTE5LfUfT
G+gxuID4SJxJZ4g3Fx9Or6dH4Lzig3ExOp94U/GB9Dp6EE7ivXFR+mzblBqL
96TX0r3w3x1S6owz6DPiDcU70mvoTvg38TY4P/2TeD3xOdbwYfeUTsHRLinl
0G1jrnJ+lnOldTajc+nmOJuuBk38bgqf61kb/9c7pS/lV9dzmB6b9dsCT+o5
nK4j56ycr+SMVT8OavL+4X3Oq6ZusLwhsEnd+/o+oXYoXUvev/K+kDda3Rio
zjvD+5SXrXaAvIGwUe27ah9XO4iuEfsi7zN5o9S9J1aZ9xfvY15VtZfKW6tu
HTymrj99GVSJbwROqlkv9g7egD9RN1Kvy6G8+O96fcirrFcfdX1hlbw35T+q
Xz+6grw/5J2Slyv2lthq/DZegz/iD9dvBJSKs5L7Lq9inLH6hXIWwSP69aJ7
Q2l5ZeCYHovFjuMl+D11y/Cr9FJ8P9wXe8ofpn83tcXVdcXnxTfPq2CcLvQM
eTNhh3G60z2ghJyScEi/WWKH8exYg345+Ag9B98Lc2NN/CF6DoXC6n60lmO8
csZoo9/1cibCg8ZoS2fx2+H2cAP/Rf22iXWgL4EietzI38Pfzu/IK8r7Sd/j
+k4S2yt2E96Hb46182/Fk+EWmAK3wWv8QeY1GPLp8Z0e+3ilzeEifbvI6Qob
jdOELsNvirvxusMmfjO6OeRX34O325ib+S14LaEAv2d8S/wt/It55/C+N9ZL
xuot9rhYL/wE7oP38/vFfaH74qfwpfgA/zI8APrDIBgIB2OP8VAYDMNhGBzi
D7C2gfCn9+JrY+7gFbeOcuaR5OSJ78G8suL8+eVxXl6++Fb4FeLM+RVjjbwC
sJxfKd5RfuW4G7Em/izzXCFWlc6Gv4xZkD+bv5JfjVcdzvAL8efwV/Fr8GrC
3/wMfk7cB34tXm34h/8vzOUXjm8LF8E7reVcPI8uiufjYnEv+OfhBXRxvBCX
wLv4mXF36JJ4MS6FH+WXwUvo0ngpLhtnyc/Cy+hysU+4fJxl3MXYH7pC7Aeu
FOfIr4JXxLuCV+Kqca7xpuFVdDZejavH+fJr4ly6Bl6Da8V58+vgtfGexluE
z8dP8+vi9fQFeAO+ED/Drx/fKV0vvkvcAD/Lb4Q30w3jDcaN8XP8JvgB+iK8
FTfFz/Obx12km+FtuAV+gX8x3k63xA/hVnE3+W3ww3TreCdw27ib/G98a/85
s528XGdZJ/6P4SyvXZxRvHX8C3h141t0J9rHGfHX8i/k1YM8/A5xRvx1/Pq8
BvGN8hvGmyDWMfZErBGd6ZtsjDvxOsce8W81l1L8yXiPu7AXcjql9C2911z3
0YfjHZd/OYyA0TAq3rP4j8LjYAxcCVfAy/yr40zM66o4A3wNfoV/Xew9fW3s
NS5krqf8ZxbE42OfeQ+YVyvzbA0Z/Amxz/yt/NvMq6z5Tok3wtz2w1zz/YE+
qv8B+nU8Vc0dcDtMh2nwBv8u/JJed8Zbgu/Gb/J/Vn+usQ7wHjJOJ2N3hmK8
e+Id4T/Mv11eeeNPxQeNda+x7/B7Hj5MH4IT+s2PfVAzL9aNF+CT/F/kZup5
lLdTv2n0dLgL7oQj6l+G+fr9Sr+j5hX6A7wi3mV1y/Hrce/0+cjelcUrY328
XXrera6SOd4Te6J2gV4z/F6IZ+Ks+C/kn9bzT7oifULtbrWz6CpqZ8d/hpxF
aub4PRdyoq/canDauNn4f2KR37s=
          "]],
         RowBox[{"-", "0.5`"}]], 
        TooltipBox[
         LineBox[{16361, 20114, 17521, 17738, 19808, 19809, 19805, 19807, 
          19806, 17839, 16364, 19381, 19382, 19380, 17101, 17524, 17523, 
          17740, 17739, 19813, 17525, 19810, 19812, 19811, 17840, 16369, 
          19389, 19390, 19388, 17105, 17529, 17528, 19816, 19815, 18263, 
          19387, 19386, 19814, 16528, 16368, 20118, 17527, 17111, 20211, 
          17841, 16373, 20120, 17535, 18018, 18006, 17110, 18016, 17532, 
          18017, 16529, 17741, 17534, 20169, 17533}],
         RowBox[{"-", "0.5`"}]], 
        TooltipBox[
         LineBox[{16372, 20119, 17531, 18004, 18003, 18021, 18022, 18020, 
          18019, 18005, 17109, 18015, 17530, 19817, 19819, 19818, 17108, 
          19395, 17107, 19396, 16371, 19394, 17106, 19391, 19393, 19392, 
          16370, 18002, 16367, 20117, 17692, 18001, 18000, 19941, 19942, 
          19940, 19939, 18262, 17104, 17526, 20116, 16366, 19385, 17103, 
          19383, 17102, 19384, 16365, 17998, 17999, 17691, 19938, 17690, 
          17997, 19936, 19937, 19935, 19934, 18261, 17100, 17522, 20115, 
          16363, 19379, 17099, 19376, 19378, 19377, 16362, 17996, 16351, 
          20113, 17689, 17995, 17994, 17687, 20210, 17688, 17098, 19334, 
          17097, 19335, 16350, 17990, 16340, 20109, 17685, 17989, 17988, 
          17683, 20209, 17684, 17083, 19290, 17082, 19291, 16339, 17984, 
          16332, 20106, 17680, 17507, 17983, 17678, 20208, 17679, 17501, 
          19924, 19925, 19923, 17675, 17979, 19922, 16513, 19921, 18239, 
          17065, 17500, 20103, 16326, 17975, 16322, 20101, 17672, 17492, 
          17494, 20168, 17493}],
         RowBox[{"-", "0.5`"}]]}, {
        {GrayLevel[0]}, 
        TooltipBox[LineBox[CompressedData["
1:eJwV2Hf8T2UfBvAvQkuiXZ6nJdkje/Sz+dk7REXZycpOlFL23nv8zFCUzJSt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          "]],
         RowBox[{"-", "1"}]]}, {
        {Opacity[0.4]}, 
        TooltipBox[LineBox[CompressedData["
1:eJwl2Hm8T+UWBvBtFpXxmKfjmIfMM5nJXOqmVIg+KCJJk0TRcHHTzVChDN1r
zpCZzGO6KW4lkVmIVESG4n7X5/7xfJ69nvWs9b6/vd/97vec1J4DOw9IlyRJ
+YxJktYxSV5uniSL2yfJvlZJkqdZkhRomyTDaItoC+Fbem56fvpL9I9pC+Ab
ei56Pvp88Txo0iRJ5uKv5VLoeWGWuDG9XMskGap+tvhFPAe/QKvQOEnq8tWD
WlAHakN5ek1cxhjVcWlcA5ejlzPv0Xp8qsdhY5WSqyb3d9pa2ho4RK9KqwKr
xS3Moazasmrf5Btm7JegOq0Fzx16NMOVcXNcjV6JdwLvJvVH9ask11RuvXgd
tNKzkh7jeTaI38Eb8XBaHfXteGuoaYur4w/lP4CtPFvguJ5t5O6CzeK79Kut
ropxp/LVUvOKXg1oNWizadv5TqrroKY9bBO3UVefpzrPLJ7a6kaqaxL3ljaf
Vk28i/dz2AGfwU4YRW/O11mve+GeeBbql8S6gHZ6V+dZ6nqeXp/g18Qt1TQQ
LxPXEH+l1x74Ar6E3fAGvS3fA3o+CF2ggd5r1CxQuxq3178NT2PxWnFD+U14
oXgj7ijfQb6ZeLO4sfz2mJt4G+4k31G+uXiHuKn853iJeBe+R76zfCvxf8Qt
5PeZ23extmOutM489/F0M7/ucMb9/Qn+K/eJur34H37L/Tx3ib+Leyy+T10X
WhvaflobvR9X3w+egIP6j+N7KNYCzwGeuuJ68DCtPe1g3AN1g/gHw9NwSN3b
PN14OvIc5akf4xuvO21oPCc1l8zxMpyUX8F3Ar8i11luRDxP/Co+Fus3nofr
N+F1GB3vCxynj9e7j76d9DitR4OYn7H60sbzTIDMrZMkC3SjP0GfTJsC2WjZ
oQe9P30GbSbkoOWER+kD6HNp8yAPLS/0pA+k3zTWU/huY3/eIknS+T0JnDGv
5fwrYBn08ltW4t/MbzXvBdw79iu9CkIhGKxPerUZ4Au9FnXwzPFinJH2s57n
YVM8I7UbcX+8m+c+PZ9Xn4UvK+yl/UTbg7PFWsB7xV/jK3G/9VwJS2E5LIPs
fBfi3dJ3F+yM56n/N2oeUDtM/9t5huMHYx3F74X90FU8gp5T/lX8cKwXekY4
CI+IR9LzyL+Ov9J7D3wJzxvjCM9ZnsM4heco/lp8DN8C+Wij1fWkHRffDieg
l3gMvYD8W/hb/fbBN/Ed0Pc0zzmeU7gQT158BnrTxvEXpk3EB2K9w/cwQl0x
nmM8RfEPtFdo5T2jNe5Tf89+LS6q9pz8p65/xutwcVyM/p6eT6ovKx6ptqLa
9fIb4AJtI07lKwkXxQN431eTJp6GTxjzZKxvOAU/wnT6GfxG/K54F3BVtcfV
VonnHe8ErbKxNum/GbbCFiitb5l43/gG88+Ib4l4Fv5F3a9wHi7EGoXZ9N/x
JbgIb+l7Gc+hX8HjxH/gt3G9eBZ61sVXaf+kVYn3x7i5oD79Gv2dmC89Ny0P
pEBeuC73Z3yz5PKJB7u/+fFftBvx7aEXED9DL4hv0pJ29m36NvEQ+nZc3u+5
aqwdrq/hiuIKsNCcU/jzQV4oAPlhEb0QLgwFoSgUgcX04rgEFIOSkApL6KVw
aUiDslAGPqF/ZB8oEmsCCkMD47ekPWtuhcTp+NJDTXMuJn6OXhxnoGWEWvQS
4ufpqTgTLTPUppcUp0FDPbPQxruPdeil4rlCI/qdMIGeVX4ivgXPNa/seJI4
G34X34rnxXuMc8BtkAtywnz6THO+Vc/bYj+Aavq2oA0yr1vE2eBs7L963WEO
t4tzQHW+GjCGfk5+LP459lI9p6ufAeXkB1onk2kD9cus7jDPEagU+7M4azxH
vgowSo+jcq/hY7Ffq5umT0aeEvIZ4h3CzWlP6pdOnB4O8b6qpoKemcQlefoZ
d5L6KbxTIT+tD+1tWj+1KfFOivPhl9V+p8dwvD/WM8/7am7YG3PJ/4Vz45tx
ZqQ3hRzinDA07jHuodcb6h7XO5t4gzg7fkE+E+4mHiXfV/6KPlfjzGGs5+RL
m/c1cWa+7nyv8b1njPSxx4gz4FI8afBMnBfUvczTR69E7qLaS/A7DJa/ab/v
om4oT2+ev+LsKb6Bn5K/hu8Xvyh/p3EawVXa32gv0N4V/6LXr3HuM9YANZvx
k7EH8N3L9yzfY3o35L0cZxLaENok8Vl152C9mr5q1uE++GKcb/ie5ssf7z6k
wGr5VTCI3kvP83w/qf8FT9RvApwSn4aP+brpNR8/ghfgs3yr9D2Hc+uXCx6W
+yjmHGtffBvcCl3pU+N7Su8ea5yWFSbRJsLj9EfomWgZYVzshdCb/lCsOVoC
Y2lj4DF6V/qf9p3rMIo2EnrGOTKeNe0PGEZ7CXrEPhvfgPj2wt3m82L8FnoH
v+FInCFpz9A64CH4B9pA3FbcP55H/K7Q3Y8b7s1Ca/4z6+BjvCvWK+1PeCD2
emOcj7MEtI5vu15L41yAe+nRktYj5guPwn49r6udp9d8mAs79VyAd6vZ4XqP
+u2xx/N9QdvmujXtXuNdpXXCp413Cn6EJsbYGn+j8WzBV3i2qPlKvDW+p7TN
+EvxJnxZ/g/Y6LoJrZ1+l8StcSPxBvpyNetxQ3GruKfyLXB98bp4J8QXYG18
/2mfxm9QswbvjrM8/k1+JT4tXoXrmGdH9+Bu6ARN9fs13g9ci2cFzxw9luOa
4oZxf+Wnx9+Hcaaiz44zFj5P/7frWfAv+AhOuBc1jTGNv2p8P9Wf5XtXPFN+
kboZeGF826Ov69bW0DR8TG01ta1jnfIfif0t+tBa0qrgVriGnqfUnob5+nyo
dh7+UfyB65b6TcVH4luppkmsY30O6zcWl6fdSSuHG8c+HfcclxXXxw3jbyKo
SD+u5wmYq/8UPefEGUo82XUz47yPDxjnDv7KcTa2tprSl+Pv4yykZ6U4axl3
GW0p7KenxvkpzmXx9wxtSfz9Qy9BH04rZa5pxq/AU5xWDheL8xouGeccXDT2
VVwEl8Gp8S3HhcUlcSGchkvQU3FBcXFcAJeIvvRiOL+4CM6Hi8Y4cYbEKeKC
OC8uFOM1/v//J/4HVN0n/g==
          "]],
         RowBox[{"-", "1.5`"}]]}, {}, {}}}],
    AspectRatio->1,
    Epilog->{{
       RGBColor[0, 0, 0], 
       PointSize[0.055], 
       PointBox[{1.376384972443, 1.67867608175462}]}, {}, {
       RGBColor[1, 0, 0], 
       PointSize[0.0325], {
        PointBox[{1., 1.}], 
        PointBox[{0.811216254637209, 1.68144016427475}], 
        PointBox[{1.18079066924938, 2.03359862195574}], 
        PointBox[{0.959292016499844, 1.82253795096056}], 
        PointBox[{1.68043223535903, 1.82667101153838}], 
        PointBox[{1.33527538576489, 1.82469281904417}], 
        PointBox[{1.56452248587279, 1.57190333460013}], 
        PointBox[{1.43119920888297, 1.71891816025674}], 
        PointBox[{1.33564569549889, 1.65841113259596}], 
        PointBox[{1.37402443730264, 1.67809345307659}], 
        PointBox[{1.37649986814713, 1.67870359920809}], 
        PointBox[{1.37638466941991, 1.67867606759919}], 
        PointBox[{1.376384972443, 1.67867608175462}]}}, {
       RGBColor[0, 1, 0], 
       PointSize[0.02], {
        PointBox[{1., 1.}], 
        PointBox[{0.811216254637209, 1.68144016427475}], 
        PointBox[{1.18079066924938, 2.03359862195574}], 
        PointBox[{0.959292016499844, 1.82253795096056}], 
        PointBox[{1.68043223535903, 1.82667101153838}], 
        PointBox[{1.33527538576489, 1.82469281904417}], 
        PointBox[{1.56452248587279, 1.57190333460013}], 
        PointBox[{1.43119920888297, 1.71891816025674}], 
        PointBox[{1.33564569549889, 1.65841113259596}], 
        PointBox[{1.37402443730264, 1.67809345307659}], 
        PointBox[{1.37649986814713, 1.67870359920809}], 
        PointBox[{1.37638466941991, 1.67867606759919}], 
        PointBox[{1.376384972443, 1.67867608175462}]}}, {}, {}, {
       RGBColor[0, 0, 1], 
       PointSize[0.015], 
       LineBox[{{1, 1}, {1, 1}, {0.811216254637209, 1.68144016427475}, {
         0.959292016499844, 1.82253795096056}, {1.33527538576489, 
         1.82469281904417}, {1.43119920888297, 1.71891816025674}, {
         1.33564569549889, 1.65841113259596}, {1.37402443730264, 
         1.67809345307659}, {1.37649986814713, 1.67870359920809}, {
         1.37638466941991, 1.67867606759919}, {1.376384972443, 
         1.67867608175462}}], {
        PointBox[{1, 1}], 
        PointBox[{1, 1}], 
        PointBox[{0.811216254637209, 1.68144016427475}], 
        PointBox[{0.959292016499844, 1.82253795096056}], 
        PointBox[{1.33527538576489, 1.82469281904417}], 
        PointBox[{1.43119920888297, 1.71891816025674}], 
        PointBox[{1.33564569549889, 1.65841113259596}], 
        PointBox[{1.37402443730264, 1.67809345307659}], 
        PointBox[{1.37649986814713, 1.67870359920809}], 
        PointBox[{1.37638466941991, 1.67867606759919}], 
        PointBox[{1.376384972443, 1.67867608175462}]}}},
    Frame->True,
    FrameTicks->True,
    Method->{},
    PlotRange->{{0.811216254637209, 1.68043223535903}, {1, 2.03359862195574}},
    
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ShowCellBracket->True,
 ImageSize->{476, 209},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.2.2",
 CellLabel->"Out[43]=",
 CellID->1958341651]
}, Open  ]],

Cell["\<\
The first thing to notice about the path taken in this example is that it \
starts in the wrong direction. This direction is chosen because at the first \
step all the method has to go by is the gradient, and so it takes the \
direction of steepest descent. However, in subsequent steps, it incorporates \
information from the values of the function and gradient at the steps taken \
to build up an approximate model of the Hessian. \
\>", "Text",
 ShowCellBracket->True,
 CellTags->"b:0.2.2",
 CellID->1801110191],

Cell[TextData[{
 "The methods used by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are the Broyden\[Dash]Fletcher\[Dash]Goldfarb\[Dash]Shanno (BFGS) updates \
and, for large systems, the limited memory BFGS (L-BFGS) methods, in which \
the model ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["B", "k"], TraditionalForm]]],
 " is not stored explicitly, but rather ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     FormBox[
      SubscriptBox["B", "k"],
      TraditionalForm], 
     RowBox[{"-", "1"}]], "  ", 
    RowBox[{"\[Del]", 
     RowBox[{"f", "(", 
      SubscriptBox["x", "k"], ")"}]}]}], TraditionalForm]]],
 " is calculated by gradients and step directions stored from past steps."
}], "Text",
 ShowCellBracket->True,
 CellTags->"b:0.2.2",
 CellID->329492025],

Cell[TextData[{
 "The BFGS method is implemented such that instead of forming the model \
Hessian ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["B", "k"], TraditionalForm]]],
 " at each step, Cholesky factors ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["L", "k"], TraditionalForm]]],
 " such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["L", "k"], ".", 
    SuperscriptBox[
     SubscriptBox["L", "k"], "T"]}], TraditionalForm]]],
 "= ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["B", "k"], TraditionalForm]]],
 " are computed so that only ",
 Cell[BoxData[
  FormBox[
   RowBox[{"O", "(", 
    SuperscriptBox["n", "2"], ")"}], TraditionalForm]]],
 " operations are needed to solve the system ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["B", "k"], 
     SubscriptBox["s", "k"]}], "  ", "=", " ", 
    RowBox[{"-", " ", 
     RowBox[{"\[Del]", 
      RowBox[{"f", "(", 
       SubscriptBox["x", "k"], ")"}]}]}]}], TraditionalForm]]],
 " [",
 ButtonBox["DS96",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/UnconstrainedOptimizationReferences#611012876"],
 "] for a problem with ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]]],
 " variables."
}], "Text",
 ShowCellBracket->True,
 CellTags->"b:0.2.2",
 CellID->1559622209],

Cell[TextData[{
 "For large-scale sparse problems, the BFGS method can be problematic \
because, in general, the Cholesky factors (or the Hessian approximation ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["B", "k"], TraditionalForm]]],
 " or its inverse) are dense, so the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"O", "(", 
    SuperscriptBox["n", "2"], ")"}], TraditionalForm]]],
 " memory and operations requirements become prohibitive compared to \
algorithms that take advantage of sparseness. The L-BFGS algorithm [",
 ButtonBox["NW99",
  BaseStyle->"RefGuideLinkText",
  ButtonData:>{
   "Advanced Documentation: Unconstrained Optimization: References", 
    "NW99"}],
 "] forms an approximation to the inverse Hessian based on a the last ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]]],
 " past steps, which are stored. The Hessian approximation may not be as \
complete, but the memory and order of operations are limited to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"O", "(", 
    RowBox[{"n", " ", "m"}], ")"}], TraditionalForm]]],
 " for a problem with ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]]],
 " variables. In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 5, for problems over 250 variables, the algorithm is switched \
automatically to L-BFGS. You can control this with the method option ",
 Cell[BoxData[
  RowBox[{"\"\<StepMemory\>\"", "->", 
   StyleBox["m", "TI"]}]], "InlineFormula"],
 ". With ",
 Cell[BoxData[
  RowBox[{
   StyleBox["m", "TI"], "=", "\[Infinity]"}]], "InlineFormula"],
 ", the full BFGS method will always be used. Choosing an appropriate value \
of ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]]],
 " is a tradeoff between speed of convergence and the work done per step. \
With ",
 Cell[BoxData[
  RowBox[{
   StyleBox["m", "TI"], "<", "3"}]], "InlineFormula"],
 ", you are most likely better off using a \"",
 ButtonBox["conjugate gradient",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/UnconstrainedOptimizationConjugateGradientMethods"],
 "\" algorithm."
}], "Text",
 ShowCellBracket->True,
 CellTags->"b:0.2.2",
 CellID->385071381],

Cell[TextData[{
 "This shows the same example function with the minimum computed using L-BFGS \
with ",
 Cell[BoxData[
  RowBox[{
   StyleBox["m", "TI"], "=", "5"}]], "InlineFormula"],
 "."
}], "MathCaption",
 ShowCellBracket->True,
 CellTags->"b:0.2.2",
 CellID->1526472056],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimumPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{
      RowBox[{"x", "^", "2"}], " ", "-", " ", 
      RowBox[{"3", " ", "y"}]}], "]"}], " ", "+", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"x", "^", "2"}], " ", "+", " ", 
      RowBox[{"y", "^", "2"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "1"}], "}"}]}], "}"}], ",", " ", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<QuasiNewton\>\"", ",", " ", 
      RowBox[{"\"\<StepMemory\>\"", "\[Rule]", "5"}]}], "}"}]}]}], 
  "]"}]], "Input",
 ShowCellBracket->True,
 CellTags->"b:0.2.2",
 CellLabel->"In[22]:=",
 CellID->1576198130],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.907277 1.14212 -1.06807 1.0873 [
[.00642 -0.0125 -9 -9 ]
[.00642 -0.0125 9 0 ]
[.23484 -0.0125 -3 -9 ]
[.23484 -0.0125 3 0 ]
[.46327 -0.0125 -9 -9 ]
[.46327 -0.0125 9 0 ]
[.69169 -0.0125 -9 -9 ]
[.69169 -0.0125 9 0 ]
[.92012 -0.0125 -9 -9 ]
[.92012 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .23669 -18 -4.5 ]
[-0.0125 .23669 0 4.5 ]
[-0.0125 .45415 -18 -4.5 ]
[-0.0125 .45415 0 4.5 ]
[-0.0125 .67161 -18 -4.5 ]
[-0.0125 .67161 0 4.5 ]
[-0.0125 .88907 -18 -4.5 ]
[-0.0125 .88907 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.00642 0 m
.00642 .00625 L
s
[(0.8)] .00642 -0.0125 0 1 Mshowa
.23484 0 m
.23484 .00625 L
s
[(1)] .23484 -0.0125 0 1 Mshowa
.46327 0 m
.46327 .00625 L
s
[(1.2)] .46327 -0.0125 0 1 Mshowa
.69169 0 m
.69169 .00625 L
s
[(1.4)] .69169 -0.0125 0 1 Mshowa
.92012 0 m
.92012 .00625 L
s
[(1.6)] .92012 -0.0125 0 1 Mshowa
.125 Mabswid
.06353 0 m
.06353 .00375 L
s
.12063 0 m
.12063 .00375 L
s
.17774 0 m
.17774 .00375 L
s
.29195 0 m
.29195 .00375 L
s
.34906 0 m
.34906 .00375 L
s
.40616 0 m
.40616 .00375 L
s
.52038 0 m
.52038 .00375 L
s
.57748 0 m
.57748 .00375 L
s
.63459 0 m
.63459 .00375 L
s
.7488 0 m
.7488 .00375 L
s
.80591 0 m
.80591 .00375 L
s
.86301 0 m
.86301 .00375 L
s
.97722 0 m
.97722 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(1)] -0.0125 .01923 1 0 Mshowa
0 .23669 m
.00625 .23669 L
s
[(1.2)] -0.0125 .23669 1 0 Mshowa
0 .45415 m
.00625 .45415 L
s
[(1.4)] -0.0125 .45415 1 0 Mshowa
0 .67161 m
.00625 .67161 L
s
[(1.6)] -0.0125 .67161 1 0 Mshowa
0 .88907 m
.00625 .88907 L
s
[(1.8)] -0.0125 .88907 1 0 Mshowa
.125 Mabswid
0 .0736 m
.00375 .0736 L
s
0 .12796 m
.00375 .12796 L
s
0 .18233 m
.00375 .18233 L
s
0 .29106 m
.00375 .29106 L
s
0 .34542 m
.00375 .34542 L
s
0 .39979 m
.00375 .39979 L
s
0 .50852 m
.00375 .50852 L
s
0 .56288 m
.00375 .56288 L
s
0 .61725 m
.00375 .61725 L
s
0 .72598 m
.00375 .72598 L
s
0 .78034 m
.00375 .78034 L
s
0 .83471 m
.00375 .83471 L
s
0 .94344 m
.00375 .94344 L
s
0 .9978 m
.00375 .9978 L
s
.25 Mabswid
0 0 m
0 1 L
s
.00642 .99375 m
.00642 1 L
s
.23484 .99375 m
.23484 1 L
s
.46327 .99375 m
.46327 1 L
s
.69169 .99375 m
.69169 1 L
s
.92012 .99375 m
.92012 1 L
s
.125 Mabswid
.06353 .99625 m
.06353 1 L
s
.12063 .99625 m
.12063 1 L
s
.17774 .99625 m
.17774 1 L
s
.29195 .99625 m
.29195 1 L
s
.34906 .99625 m
.34906 1 L
s
.40616 .99625 m
.40616 1 L
s
.52038 .99625 m
.52038 1 L
s
.57748 .99625 m
.57748 1 L
s
.63459 .99625 m
.63459 1 L
s
.7488 .99625 m
.7488 1 L
s
.80591 .99625 m
.80591 1 L
s
.86301 .99625 m
.86301 1 L
s
.97722 .99625 m
.97722 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .23669 m
1 .23669 L
s
.99375 .45415 m
1 .45415 L
s
.99375 .67161 m
1 .67161 L
s
.99375 .88907 m
1 .88907 L
s
.125 Mabswid
.99625 .0736 m
1 .0736 L
s
.99625 .12796 m
1 .12796 L
s
.99625 .18233 m
1 .18233 L
s
.99625 .29106 m
1 .29106 L
s
.99625 .34542 m
1 .34542 L
s
.99625 .39979 m
1 .39979 L
s
.99625 .50852 m
1 .50852 L
s
.99625 .56288 m
1 .56288 L
s
.99625 .61725 m
1 .61725 L
s
.99625 .72598 m
1 .72598 L
s
.99625 .78034 m
1 .78034 L
s
.99625 .83471 m
1 .83471 L
s
.99625 .94344 m
1 .94344 L
s
.99625 .9978 m
1 .9978 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.325 g
.01923 .98077 m
.98077 .98077 L
.98077 .01923 L
.01923 .01923 L
F
0 g
.5 Mabswid
.4 g
.01923 .04253 m
.02894 .04602 L
.03576 .04837 L
.03866 .04935 L
.04837 .05254 L
.05808 .05559 L
.06635 .05808 L
.06779 .05851 L
.07751 .0613 L
.08722 .06398 L
.09693 .06654 L
.10184 .06779 L
.10664 .06899 L
.11636 .07135 L
.12607 .0736 L
.13578 .07575 L
.14398 .07751 L
.14549 .07782 L
.15521 .07981 L
.16492 .08171 L
.17463 .08353 L
.18434 .08528 L
.19406 .08695 L
.19564 .08722 L
.20377 .08856 L
.21348 .0901 L
.22319 .09158 L
.23291 .093 L
.24262 .09436 L
.25233 .09567 L
.26204 .09692 L
.2621 .09693 L
.27176 .09813 L
.28147 .09928 L
.29118 .10039 L
.30089 .10145 L
.31061 .10247 L
.32032 .10344 L
.33003 .10438 L
.33974 .10527 L
.34946 .10613 L
.35546 .10664 L
.35917 .10695 L
.36888 .10774 L
.37859 .10849 L
.38831 .1092 L
.39802 .10989 L
.40773 .11054 L
.41744 .11116 L
.42716 .11175 L
.43687 .11231 L
.44658 .11284 L
.45629 .11335 L
.46601 .11382 L
.47572 .11427 L
.48543 .11469 L
.49514 .11508 L
.50486 .11545 L
.51457 .11579 L
.52428 .1161 L
.53265 .11636 L
.53399 .11639 L
.54371 .11666 L
.55342 .1169 L
.56313 .11711 L
.57284 .11729 L
.58256 .11746 L
.59227 .11759 L
.60198 .1177 L
.61169 .11778 L
.62141 .11784 L
.63112 .11787 L
.64083 .11787 L
.65054 .11784 L
.66026 .11778 L
.66997 .1177 L
.67968 .11758 L
.68939 .11744 L
.69911 .11726 L
.70882 .11704 L
.71853 .11679 L
.72824 .11651 L
.73303 .11636 L
.73796 .11619 L
.74767 .11583 L
.75738 .11542 L
.76709 .11497 L
.77681 .11448 L
.78652 .11394 L
.79623 .11334 L
.80594 .11269 L
.81566 .11198 L
.82537 .11121 L
.83508 .11036 L
.84479 .10945 L
.85451 .10845 L
.86422 .10737 L
.87031 .10664 L
.87393 .10619 L
.88364 .10491 L
.89336 .10352 L
.90307 .102 L
.91278 .10034 L
.92249 .09853 L
.93039 .09693 L
.93221 .09654 L
.94192 .09436 L
.95163 .09196 L
.96134 .08931 L
.96834 .08722 L
.97106 .08636 L
.98077 .08308 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .04253 m
.02894 .04602 L
.03576 .04837 L
.03866 .04935 L
.04837 .05254 L
.05808 .05559 L
.06635 .05808 L
.06779 .05851 L
.07751 .0613 L
.08722 .06398 L
.09693 .06654 L
.10184 .06779 L
.10664 .06899 L
.11636 .07135 L
.12607 .0736 L
.13578 .07575 L
.14398 .07751 L
.14549 .07782 L
.15521 .07981 L
.16492 .08171 L
.17463 .08353 L
.18434 .08528 L
.19406 .08695 L
.19564 .08722 L
.20377 .08856 L
.21348 .0901 L
.22319 .09158 L
.23291 .093 L
.24262 .09436 L
.25233 .09567 L
.26204 .09692 L
.2621 .09693 L
.27176 .09813 L
.28147 .09928 L
.29118 .10039 L
.30089 .10145 L
.31061 .10247 L
.32032 .10344 L
.33003 .10438 L
.33974 .10527 L
.34946 .10613 L
.35546 .10664 L
.35917 .10695 L
.36888 .10774 L
.37859 .10849 L
.38831 .1092 L
.39802 .10989 L
.40773 .11054 L
.41744 .11116 L
.42716 .11175 L
Mistroke
.43687 .11231 L
.44658 .11284 L
.45629 .11335 L
.46601 .11382 L
.47572 .11427 L
.48543 .11469 L
.49514 .11508 L
.50486 .11545 L
.51457 .11579 L
.52428 .1161 L
.53265 .11636 L
.53399 .11639 L
.54371 .11666 L
.55342 .1169 L
.56313 .11711 L
.57284 .11729 L
.58256 .11746 L
.59227 .11759 L
.60198 .1177 L
.61169 .11778 L
.62141 .11784 L
.63112 .11787 L
.64083 .11787 L
.65054 .11784 L
.66026 .11778 L
.66997 .1177 L
.67968 .11758 L
.68939 .11744 L
.69911 .11726 L
.70882 .11704 L
.71853 .11679 L
.72824 .11651 L
.73303 .11636 L
.73796 .11619 L
.74767 .11583 L
.75738 .11542 L
.76709 .11497 L
.77681 .11448 L
.78652 .11394 L
.79623 .11334 L
.80594 .11269 L
.81566 .11198 L
.82537 .11121 L
.83508 .11036 L
.84479 .10945 L
.85451 .10845 L
.86422 .10737 L
.87031 .10664 L
.87393 .10619 L
.88364 .10491 L
Mistroke
.89336 .10352 L
.90307 .102 L
.91278 .10034 L
.92249 .09853 L
.93039 .09693 L
.93221 .09654 L
.94192 .09436 L
.95163 .09196 L
.96134 .08931 L
.96834 .08722 L
.97106 .08636 L
.98077 .08308 L
Mfstroke
.475 g
.01923 .17414 m
.02894 .174 L
.03866 .17387 L
.04837 .17375 L
.05808 .17363 L
.06779 .17352 L
.07751 .17342 L
.08722 .17332 L
.09693 .17323 L
.10664 .17314 L
.11636 .17306 L
.12607 .17298 L
.13578 .17291 L
.14549 .17284 L
.15521 .17277 L
.16492 .1727 L
.17463 .17264 L
.18434 .17258 L
.19406 .17253 L
.20377 .17247 L
.21348 .17242 L
.22319 .17237 L
.23291 .17233 L
.24262 .17228 L
.25233 .17224 L
.26204 .1722 L
.27176 .17216 L
.28147 .17212 L
.29118 .17209 L
.30089 .17205 L
.31061 .17202 L
.32032 .17199 L
.33003 .17196 L
.33974 .17193 L
.34946 .1719 L
.35917 .17188 L
.36888 .17185 L
.37859 .17183 L
.38831 .17181 L
.39802 .17178 L
.40773 .17176 L
.41744 .17174 L
.42716 .17173 L
.43687 .17171 L
.44658 .17169 L
.45629 .17167 L
.46601 .17166 L
.47572 .17165 L
.48543 .17163 L
.49514 .17162 L
.50486 .17161 L
.51457 .1716 L
.52428 .17159 L
.53399 .17158 L
.54371 .17157 L
.55342 .17156 L
.56313 .17155 L
.57284 .17155 L
.58256 .17154 L
.59227 .17154 L
.60198 .17153 L
.61169 .17153 L
.62141 .17153 L
.63112 .17153 L
.64083 .17153 L
.65054 .17153 L
.66026 .17153 L
.66997 .17153 L
.67968 .17153 L
.68939 .17154 L
.69911 .17154 L
.70882 .17155 L
.71853 .17155 L
.72824 .17156 L
.73796 .17157 L
.74767 .17158 L
.75738 .17159 L
.76709 .1716 L
.77681 .17161 L
.78652 .17163 L
.79623 .17165 L
.80594 .17166 L
.81566 .17168 L
.82537 .1717 L
.83508 .17173 L
.84479 .17175 L
.85451 .17178 L
.86422 .17181 L
.87393 .17184 L
.88364 .17187 L
.89336 .17191 L
.90307 .17195 L
.91278 .17199 L
.92249 .17204 L
.93221 .17209 L
.94192 .17215 L
.95163 .17221 L
.96134 .17228 L
.97106 .17235 L
.98077 .17243 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .17414 m
.02894 .174 L
.03866 .17387 L
.04837 .17375 L
.05808 .17363 L
.06779 .17352 L
.07751 .17342 L
.08722 .17332 L
.09693 .17323 L
.10664 .17314 L
.11636 .17306 L
.12607 .17298 L
.13578 .17291 L
.14549 .17284 L
.15521 .17277 L
.16492 .1727 L
.17463 .17264 L
.18434 .17258 L
.19406 .17253 L
.20377 .17247 L
.21348 .17242 L
.22319 .17237 L
.23291 .17233 L
.24262 .17228 L
.25233 .17224 L
.26204 .1722 L
.27176 .17216 L
.28147 .17212 L
.29118 .17209 L
.30089 .17205 L
.31061 .17202 L
.32032 .17199 L
.33003 .17196 L
.33974 .17193 L
.34946 .1719 L
.35917 .17188 L
.36888 .17185 L
.37859 .17183 L
.38831 .17181 L
.39802 .17178 L
.40773 .17176 L
.41744 .17174 L
.42716 .17173 L
.43687 .17171 L
.44658 .17169 L
.45629 .17167 L
.46601 .17166 L
.47572 .17165 L
.48543 .17163 L
.49514 .17162 L
Mistroke
.50486 .17161 L
.51457 .1716 L
.52428 .17159 L
.53399 .17158 L
.54371 .17157 L
.55342 .17156 L
.56313 .17155 L
.57284 .17155 L
.58256 .17154 L
.59227 .17154 L
.60198 .17153 L
.61169 .17153 L
.62141 .17153 L
.63112 .17153 L
.64083 .17153 L
.65054 .17153 L
.66026 .17153 L
.66997 .17153 L
.67968 .17153 L
.68939 .17154 L
.69911 .17154 L
.70882 .17155 L
.71853 .17155 L
.72824 .17156 L
.73796 .17157 L
.74767 .17158 L
.75738 .17159 L
.76709 .1716 L
.77681 .17161 L
.78652 .17163 L
.79623 .17165 L
.80594 .17166 L
.81566 .17168 L
.82537 .1717 L
.83508 .17173 L
.84479 .17175 L
.85451 .17178 L
.86422 .17181 L
.87393 .17184 L
.88364 .17187 L
.89336 .17191 L
.90307 .17195 L
.91278 .17199 L
.92249 .17204 L
.93221 .17209 L
.94192 .17215 L
.95163 .17221 L
.96134 .17228 L
.97106 .17235 L
.98077 .17243 L
Mistroke
Mfstroke
.55 g
.01923 .33333 m
.02376 .33003 L
.02894 .32643 L
.03833 .32032 L
.03866 .32011 L
.04837 .31431 L
.055 .31061 L
.05808 .30895 L
.06779 .30399 L
.07426 .30089 L
.07751 .29939 L
.08722 .2951 L
.09674 .29118 L
.09693 .2911 L
.10664 .28736 L
.11636 .28385 L
.12332 .28147 L
.12607 .28056 L
.13578 .27746 L
.14549 .27454 L
.15521 .27178 L
.1553 .27176 L
.16492 .26918 L
.17463 .26672 L
.18434 .26438 L
.19406 .26217 L
.19463 .26204 L
.20377 .26007 L
.21348 .25808 L
.22319 .25618 L
.23291 .25438 L
.24262 .25267 L
.24458 .25233 L
.25233 .25103 L
.26204 .24948 L
.27176 .24799 L
.28147 .24658 L
.29118 .24523 L
.30089 .24394 L
.31061 .24272 L
.31139 .24262 L
.32032 .24154 L
.33003 .24042 L
.33974 .23936 L
.34946 .23834 L
.35917 .23737 L
.36888 .23644 L
.37859 .23555 L
.38831 .23471 L
.39802 .23391 L
.40773 .23315 L
.41088 .23291 L
.41744 .23242 L
.42716 .23173 L
.43687 .23107 L
.44658 .23045 L
.45629 .22986 L
.46601 .2293 L
.47572 .22878 L
.48543 .22829 L
.49514 .22782 L
.50486 .22739 L
.51457 .22698 L
.52428 .2266 L
.53399 .22625 L
.54371 .22593 L
.55342 .22564 L
.56313 .22538 L
.57284 .22514 L
.58256 .22493 L
.59227 .22474 L
.60198 .22459 L
.61169 .22446 L
.62141 .22436 L
.63112 .22428 L
.64083 .22424 L
.65054 .22422 L
.66026 .22423 L
.66997 .22428 L
.67968 .22435 L
.68939 .22445 L
.69911 .22459 L
.70882 .22476 L
.71853 .22496 L
.72824 .2252 L
.73796 .22547 L
.74767 .22578 L
.75738 .22613 L
.76709 .22652 L
.77681 .22696 L
.78652 .22744 L
.79623 .22796 L
.80594 .22854 L
.81566 .22917 L
.82537 .22986 L
.83508 .2306 L
.84479 .23141 L
.85451 .23229 L
.86087 .23291 L
.86422 .23324 L
.87393 .23427 L
.88364 .23539 L
.89336 .2366 L
.90307 .23791 L
.91278 .23932 L
.92249 .24086 L
.93221 .24252 L
.93274 .24262 L
.94192 .24433 L
.95163 .2463 L
.96134 .24844 L
.97106 .25077 L
.97708 .25233 L
.98077 .25333 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .33333 m
.02376 .33003 L
.02894 .32643 L
.03833 .32032 L
.03866 .32011 L
.04837 .31431 L
.055 .31061 L
.05808 .30895 L
.06779 .30399 L
.07426 .30089 L
.07751 .29939 L
.08722 .2951 L
.09674 .29118 L
.09693 .2911 L
.10664 .28736 L
.11636 .28385 L
.12332 .28147 L
.12607 .28056 L
.13578 .27746 L
.14549 .27454 L
.15521 .27178 L
.1553 .27176 L
.16492 .26918 L
.17463 .26672 L
.18434 .26438 L
.19406 .26217 L
.19463 .26204 L
.20377 .26007 L
.21348 .25808 L
.22319 .25618 L
.23291 .25438 L
.24262 .25267 L
.24458 .25233 L
.25233 .25103 L
.26204 .24948 L
.27176 .24799 L
.28147 .24658 L
.29118 .24523 L
.30089 .24394 L
.31061 .24272 L
.31139 .24262 L
.32032 .24154 L
.33003 .24042 L
.33974 .23936 L
.34946 .23834 L
.35917 .23737 L
.36888 .23644 L
.37859 .23555 L
.38831 .23471 L
.39802 .23391 L
Mistroke
.40773 .23315 L
.41088 .23291 L
.41744 .23242 L
.42716 .23173 L
.43687 .23107 L
.44658 .23045 L
.45629 .22986 L
.46601 .2293 L
.47572 .22878 L
.48543 .22829 L
.49514 .22782 L
.50486 .22739 L
.51457 .22698 L
.52428 .2266 L
.53399 .22625 L
.54371 .22593 L
.55342 .22564 L
.56313 .22538 L
.57284 .22514 L
.58256 .22493 L
.59227 .22474 L
.60198 .22459 L
.61169 .22446 L
.62141 .22436 L
.63112 .22428 L
.64083 .22424 L
.65054 .22422 L
.66026 .22423 L
.66997 .22428 L
.67968 .22435 L
.68939 .22445 L
.69911 .22459 L
.70882 .22476 L
.71853 .22496 L
.72824 .2252 L
.73796 .22547 L
.74767 .22578 L
.75738 .22613 L
.76709 .22652 L
.77681 .22696 L
.78652 .22744 L
.79623 .22796 L
.80594 .22854 L
.81566 .22917 L
.82537 .22986 L
.83508 .2306 L
.84479 .23141 L
.85451 .23229 L
.86087 .23291 L
.86422 .23324 L
Mistroke
.87393 .23427 L
.88364 .23539 L
.89336 .2366 L
.90307 .23791 L
.91278 .23932 L
.92249 .24086 L
.93221 .24252 L
.93274 .24262 L
.94192 .24433 L
.95163 .2463 L
.96134 .24844 L
.97106 .25077 L
.97708 .25233 L
.98077 .25333 L
Mfstroke
.625 g
.01923 .55123 m
.02242 .54371 L
.02677 .53399 L
.02894 .52934 L
.03138 .52428 L
.03628 .51457 L
.03866 .51007 L
.0415 .50486 L
.04707 .49514 L
.04837 .49297 L
.05303 .48543 L
.05808 .47768 L
.0594 .47572 L
.06624 .46601 L
.06779 .4639 L
.0736 .45629 L
.07751 .45141 L
.08153 .44658 L
.08722 .44004 L
.09009 .43687 L
.09693 .42964 L
.09938 .42716 L
.10664 .42008 L
.10947 .41744 L
.11636 .41127 L
.12048 .40773 L
.12607 .40311 L
.13252 .39802 L
.13578 .39554 L
.14549 .38849 L
.14576 .38831 L
.15521 .38192 L
.16038 .37859 L
.16492 .37577 L
.17463 .37002 L
.17662 .36888 L
.18434 .36461 L
.19406 .35953 L
.19476 .35917 L
.20377 .35474 L
.21348 .35022 L
.21518 .34946 L
.22319 .34596 L
.23291 .34192 L
.23839 .33974 L
.24262 .33811 L
.25233 .33449 L
.26204 .33106 L
.26507 .33003 L
.27176 .32781 L
.28147 .32472 L
.29118 .32178 L
.29622 .32032 L
.30089 .31899 L
.31061 .31634 L
.32032 .31381 L
.33003 .31141 L
.33339 .31061 L
.33974 .30912 L
.34946 .30694 L
.35917 .30487 L
.36888 .3029 L
.37859 .30102 L
.37927 .30089 L
.38831 .29924 L
.39802 .29754 L
.40773 .29592 L
.41744 .29439 L
.42716 .29293 L
.43687 .29155 L
.43953 .29118 L
.44658 .29024 L
.45629 .289 L
.46601 .28783 L
.47572 .28672 L
.48543 .28568 L
.49514 .2847 L
.50486 .28379 L
.51457 .28293 L
.52428 .28214 L
.53302 .28147 L
.53399 .2814 L
.54371 .28072 L
.55342 .28009 L
.56313 .27952 L
.57284 .27901 L
.58256 .27855 L
.59227 .27815 L
.60198 .27781 L
.61169 .27751 L
.62141 .27728 L
.63112 .2771 L
.64083 .27697 L
.65054 .27691 L
.66026 .2769 L
.66997 .27695 L
.67968 .27705 L
.68939 .27722 L
.69911 .27746 L
.70882 .27775 L
.71853 .27812 L
.72824 .27855 L
.73796 .27905 L
.74767 .27963 L
.75738 .28028 L
.76709 .28101 L
.77265 .28147 L
.77681 .28183 L
.78652 .28273 L
.79623 .28373 L
.80594 .28482 L
.81566 .28601 L
.82537 .28731 L
.83508 .28873 L
.84479 .29027 L
.85018 .29118 L
.85451 .29194 L
.86422 .29375 L
.87393 .29572 L
.88364 .29784 L
.89336 .30015 L
.89635 .30089 L
.90307 .30264 L
.91278 .30534 L
.92249 .30827 L
.92971 .31061 L
.93221 .31145 L
.94192 .3149 L
.95163 .31865 L
.9557 .32032 L
.96134 .32273 L
.97106 .32719 L
.97681 .33003 L
.98077 .33207 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .55123 m
.02242 .54371 L
.02677 .53399 L
.02894 .52934 L
.03138 .52428 L
.03628 .51457 L
.03866 .51007 L
.0415 .50486 L
.04707 .49514 L
.04837 .49297 L
.05303 .48543 L
.05808 .47768 L
.0594 .47572 L
.06624 .46601 L
.06779 .4639 L
.0736 .45629 L
.07751 .45141 L
.08153 .44658 L
.08722 .44004 L
.09009 .43687 L
.09693 .42964 L
.09938 .42716 L
.10664 .42008 L
.10947 .41744 L
.11636 .41127 L
.12048 .40773 L
.12607 .40311 L
.13252 .39802 L
.13578 .39554 L
.14549 .38849 L
.14576 .38831 L
.15521 .38192 L
.16038 .37859 L
.16492 .37577 L
.17463 .37002 L
.17662 .36888 L
.18434 .36461 L
.19406 .35953 L
.19476 .35917 L
.20377 .35474 L
.21348 .35022 L
.21518 .34946 L
.22319 .34596 L
.23291 .34192 L
.23839 .33974 L
.24262 .33811 L
.25233 .33449 L
.26204 .33106 L
.26507 .33003 L
.27176 .32781 L
Mistroke
.28147 .32472 L
.29118 .32178 L
.29622 .32032 L
.30089 .31899 L
.31061 .31634 L
.32032 .31381 L
.33003 .31141 L
.33339 .31061 L
.33974 .30912 L
.34946 .30694 L
.35917 .30487 L
.36888 .3029 L
.37859 .30102 L
.37927 .30089 L
.38831 .29924 L
.39802 .29754 L
.40773 .29592 L
.41744 .29439 L
.42716 .29293 L
.43687 .29155 L
.43953 .29118 L
.44658 .29024 L
.45629 .289 L
.46601 .28783 L
.47572 .28672 L
.48543 .28568 L
.49514 .2847 L
.50486 .28379 L
.51457 .28293 L
.52428 .28214 L
.53302 .28147 L
.53399 .2814 L
.54371 .28072 L
.55342 .28009 L
.56313 .27952 L
.57284 .27901 L
.58256 .27855 L
.59227 .27815 L
.60198 .27781 L
.61169 .27751 L
.62141 .27728 L
.63112 .2771 L
.64083 .27697 L
.65054 .27691 L
.66026 .2769 L
.66997 .27695 L
.67968 .27705 L
.68939 .27722 L
.69911 .27746 L
.70882 .27775 L
Mistroke
.71853 .27812 L
.72824 .27855 L
.73796 .27905 L
.74767 .27963 L
.75738 .28028 L
.76709 .28101 L
.77265 .28147 L
.77681 .28183 L
.78652 .28273 L
.79623 .28373 L
.80594 .28482 L
.81566 .28601 L
.82537 .28731 L
.83508 .28873 L
.84479 .29027 L
.85018 .29118 L
.85451 .29194 L
.86422 .29375 L
.87393 .29572 L
.88364 .29784 L
.89336 .30015 L
.89635 .30089 L
.90307 .30264 L
.91278 .30534 L
.92249 .30827 L
.92971 .31061 L
.93221 .31145 L
.94192 .3149 L
.95163 .31865 L
.9557 .32032 L
.96134 .32273 L
.97106 .32719 L
.97681 .33003 L
.98077 .33207 L
Mfstroke
.7 g
.98077 .41402 m
.97284 .40773 L
.97106 .40638 L
.96134 .39945 L
.95922 .39802 L
.95163 .39313 L
.94357 .38831 L
.94192 .38736 L
.93221 .38208 L
.92531 .37859 L
.92249 .37723 L
.91278 .37278 L
.90356 .36888 L
.90307 .36868 L
.89336 .36491 L
.88364 .36144 L
.87684 .35917 L
.87393 .35824 L
.86422 .35529 L
.85451 .35257 L
.84479 .35007 L
.84228 .34946 L
.83508 .34777 L
.82537 .34566 L
.81566 .34372 L
.80594 .34195 L
.79623 .34033 L
.79245 .33974 L
.78652 .33886 L
.77681 .33754 L
.76709 .33634 L
.75738 .33527 L
.74767 .33432 L
.73796 .33349 L
.72824 .33277 L
.71853 .33215 L
.70882 .33164 L
.69911 .33123 L
.68939 .33092 L
.67968 .33071 L
.66997 .33059 L
.66026 .33056 L
.65054 .33062 L
.64083 .33076 L
.63112 .331 L
.62141 .33132 L
.61169 .33173 L
.60198 .33223 L
.59227 .33281 L
.58256 .33348 L
.57284 .33423 L
.56313 .33507 L
.55342 .336 L
.54371 .33702 L
.53399 .33812 L
.52428 .33932 L
.52101 .33974 L
.51457 .34061 L
.50486 .342 L
.49514 .34348 L
.48543 .34506 L
.47572 .34675 L
.46601 .34854 L
.46122 .34946 L
.45629 .35043 L
.44658 .35244 L
.43687 .35457 L
.42716 .35682 L
.41754 .35917 L
.41744 .35919 L
.40773 .3617 L
.39802 .36434 L
.38831 .36712 L
.38243 .36888 L
.37859 .37006 L
.36888 .37315 L
.35917 .37641 L
.35294 .37859 L
.34946 .37985 L
.33974 .38347 L
.33003 .38729 L
.32753 .38831 L
.32032 .39132 L
.31061 .39557 L
.30524 .39802 L
.30089 .40006 L
.29118 .4048 L
.28545 .40773 L
.28147 .40982 L
.27176 .41514 L
.26771 .41744 L
.26204 .42077 L
.25233 .42675 L
.2517 .42716 L
.24262 .43311 L
.23714 .43687 L
.23291 .43987 L
.22385 .44658 L
.22319 .44708 L
.21348 .45479 L
.21166 .45629 L
.20377 .46305 L
.20044 .46601 L
.19406 .47191 L
.19009 .47572 L
.18434 .48144 L
.18049 .48543 L
.17463 .49175 L
.17159 .49514 L
.16492 .50291 L
.16331 .50486 L
.15559 .51457 L
.15521 .51507 L
.14838 .52428 L
.14549 .52837 L
.14165 .53399 L
.13578 .54301 L
.13534 .54371 L
.12943 .55342 L
.12607 .55923 L
.12389 .56313 L
.11868 .57284 L
.11636 .5774 L
.1138 .58256 L
.10921 .59227 L
.10664 .59797 L
.10489 .60198 L
.10084 .61169 L
.09704 .62141 L
.09693 .62168 L
.09346 .63112 L
.09011 .64083 L
.08722 .64975 L
.08697 .65054 L
.08403 .66026 L
.08129 .66997 L
.07874 .67968 L
.07751 .68465 L
.07637 .68939 L
.07418 .69911 L
.07217 .70882 L
.07033 .71853 L
.06866 .72824 L
.06779 .73371 L
.06716 .73796 L
.06583 .74767 L
.06468 .75738 L
.0637 .76709 L
.0629 .77681 L
.06228 .78652 L
.06185 .79623 L
.06161 .80594 L
.06156 .81566 L
.06173 .82537 L
.06212 .83508 L
.06273 .84479 L
.06359 .85451 L
.0647 .86422 L
.06609 .87393 L
.06777 .88364 L
.06779 .88375 L
.06977 .89336 L
.0721 .90307 L
.0748 .91278 L
.07751 .92137 L
.07789 .92249 L
.08141 .93221 L
.0854 .94192 L
.08722 .94599 L
.0899 .95163 L
.09497 .96134 L
.09693 .96482 L
.10067 .97106 L
.10664 .98018 L
.10705 .98077 L
.98077 .98077 L
F
0 g
.98077 .41402 m
.97284 .40773 L
.97106 .40638 L
.96134 .39945 L
.95922 .39802 L
.95163 .39313 L
.94357 .38831 L
.94192 .38736 L
.93221 .38208 L
.92531 .37859 L
.92249 .37723 L
.91278 .37278 L
.90356 .36888 L
.90307 .36868 L
.89336 .36491 L
.88364 .36144 L
.87684 .35917 L
.87393 .35824 L
.86422 .35529 L
.85451 .35257 L
.84479 .35007 L
.84228 .34946 L
.83508 .34777 L
.82537 .34566 L
.81566 .34372 L
.80594 .34195 L
.79623 .34033 L
.79245 .33974 L
.78652 .33886 L
.77681 .33754 L
.76709 .33634 L
.75738 .33527 L
.74767 .33432 L
.73796 .33349 L
.72824 .33277 L
.71853 .33215 L
.70882 .33164 L
.69911 .33123 L
.68939 .33092 L
.67968 .33071 L
.66997 .33059 L
.66026 .33056 L
.65054 .33062 L
.64083 .33076 L
.63112 .331 L
.62141 .33132 L
.61169 .33173 L
.60198 .33223 L
.59227 .33281 L
.58256 .33348 L
Mistroke
.57284 .33423 L
.56313 .33507 L
.55342 .336 L
.54371 .33702 L
.53399 .33812 L
.52428 .33932 L
.52101 .33974 L
.51457 .34061 L
.50486 .342 L
.49514 .34348 L
.48543 .34506 L
.47572 .34675 L
.46601 .34854 L
.46122 .34946 L
.45629 .35043 L
.44658 .35244 L
.43687 .35457 L
.42716 .35682 L
.41754 .35917 L
.41744 .35919 L
.40773 .3617 L
.39802 .36434 L
.38831 .36712 L
.38243 .36888 L
.37859 .37006 L
.36888 .37315 L
.35917 .37641 L
.35294 .37859 L
.34946 .37985 L
.33974 .38347 L
.33003 .38729 L
.32753 .38831 L
.32032 .39132 L
.31061 .39557 L
.30524 .39802 L
.30089 .40006 L
.29118 .4048 L
.28545 .40773 L
.28147 .40982 L
.27176 .41514 L
.26771 .41744 L
.26204 .42077 L
.25233 .42675 L
.2517 .42716 L
.24262 .43311 L
.23714 .43687 L
.23291 .43987 L
.22385 .44658 L
.22319 .44708 L
.21348 .45479 L
Mistroke
.21166 .45629 L
.20377 .46305 L
.20044 .46601 L
.19406 .47191 L
.19009 .47572 L
.18434 .48144 L
.18049 .48543 L
.17463 .49175 L
.17159 .49514 L
.16492 .50291 L
.16331 .50486 L
.15559 .51457 L
.15521 .51507 L
.14838 .52428 L
.14549 .52837 L
.14165 .53399 L
.13578 .54301 L
.13534 .54371 L
.12943 .55342 L
.12607 .55923 L
.12389 .56313 L
.11868 .57284 L
.11636 .5774 L
.1138 .58256 L
.10921 .59227 L
.10664 .59797 L
.10489 .60198 L
.10084 .61169 L
.09704 .62141 L
.09693 .62168 L
.09346 .63112 L
.09011 .64083 L
.08722 .64975 L
.08697 .65054 L
.08403 .66026 L
.08129 .66997 L
.07874 .67968 L
.07751 .68465 L
.07637 .68939 L
.07418 .69911 L
.07217 .70882 L
.07033 .71853 L
.06866 .72824 L
.06779 .73371 L
.06716 .73796 L
.06583 .74767 L
.06468 .75738 L
.0637 .76709 L
.0629 .77681 L
.06228 .78652 L
Mistroke
.06185 .79623 L
.06161 .80594 L
.06156 .81566 L
.06173 .82537 L
.06212 .83508 L
.06273 .84479 L
.06359 .85451 L
.0647 .86422 L
.06609 .87393 L
.06777 .88364 L
.06779 .88375 L
.06977 .89336 L
.0721 .90307 L
.0748 .91278 L
.07751 .92137 L
.07789 .92249 L
.08141 .93221 L
.0854 .94192 L
.08722 .94599 L
.0899 .95163 L
.09497 .96134 L
.09693 .96482 L
.10067 .97106 L
.10664 .98018 L
.10705 .98077 L
Mfstroke
.775 g
.98077 .50792 m
.97843 .50486 L
.97106 .49576 L
.97053 .49514 L
.96177 .48543 L
.96134 .48498 L
.95203 .47572 L
.95163 .47534 L
.94192 .46667 L
.94113 .46601 L
.93221 .45884 L
.92884 .45629 L
.92249 .45172 L
.91486 .44658 L
.91278 .44525 L
.90307 .43934 L
.89874 .43687 L
.89336 .43394 L
.88364 .42899 L
.87982 .42716 L
.87393 .42446 L
.86422 .4203 L
.85703 .41744 L
.85451 .41649 L
.84479 .41299 L
.83508 .40979 L
.82837 .40773 L
.82537 .40685 L
.81566 .40418 L
.80594 .40174 L
.79623 .39952 L
.7891 .39802 L
.78652 .39751 L
.77681 .39569 L
.76709 .39407 L
.75738 .39262 L
.74767 .39134 L
.73796 .39023 L
.72824 .38927 L
.71853 .38846 L
.71643 .38831 L
.70882 .3878 L
.69911 .38728 L
.68939 .3869 L
.67968 .38665 L
.66997 .38653 L
.66026 .38654 L
.65054 .38668 L
.64083 .38694 L
.63112 .38732 L
.62141 .38783 L
.6139 .38831 L
.61169 .38846 L
.60198 .38921 L
.59227 .39009 L
.58256 .39109 L
.57284 .39221 L
.56313 .39345 L
.55342 .39483 L
.54371 .39633 L
.53399 .39796 L
.53367 .39802 L
.52428 .39973 L
.51457 .40163 L
.50486 .40368 L
.49514 .40587 L
.48735 .40773 L
.48543 .40821 L
.47572 .4107 L
.46601 .41335 L
.45629 .41617 L
.4521 .41744 L
.44658 .41916 L
.43687 .42234 L
.42716 .4257 L
.42313 .42716 L
.41744 .42927 L
.40773 .43304 L
.3984 .43687 L
.39802 .43703 L
.38831 .44126 L
.37859 .44574 L
.37682 .44658 L
.36888 .45048 L
.35917 .4555 L
.35769 .45629 L
.34946 .46083 L
.34054 .46601 L
.33974 .46648 L
.33003 .47249 L
.32504 .47572 L
.32032 .47887 L
.31094 .48543 L
.31061 .48567 L
.30089 .49292 L
.29804 .49514 L
.29118 .50067 L
.2862 .50486 L
.28147 .50897 L
.27528 .51457 L
.27176 .51788 L
.2652 .52428 L
.26204 .52748 L
.25585 .53399 L
.25233 .53785 L
.24717 .54371 L
.24262 .54911 L
.23911 .55342 L
.23291 .56139 L
.2316 .56313 L
.2246 .57284 L
.22319 .57488 L
.21808 .58256 L
.21348 .58983 L
.21199 .59227 L
.20632 .60198 L
.20377 .60657 L
.20102 .61169 L
.19609 .62141 L
.19406 .62562 L
.1915 .63112 L
.18723 .64083 L
.18434 .64783 L
.18326 .65054 L
.1796 .66026 L
.17621 .66997 L
.17463 .6748 L
.1731 .67968 L
.17025 .68939 L
.16767 .69911 L
.16533 .70882 L
.16492 .71066 L
.16325 .71853 L
.16141 .72824 L
.15982 .73796 L
.15848 .74767 L
.15738 .75738 L
.15654 .76709 L
.15595 .77681 L
.15561 .78652 L
.15555 .79623 L
.15575 .80594 L
.15624 .81566 L
.15703 .82537 L
.15813 .83508 L
.15955 .84479 L
.16131 .85451 L
.16344 .86422 L
.16492 .87013 L
.16595 .87393 L
.16888 .88364 L
.17225 .89336 L
.17463 .89951 L
.1761 .90307 L
.18047 .91278 L
.18434 .92051 L
.1854 .92249 L
.19095 .93221 L
.19406 .9372 L
.19717 .94192 L
.20377 .95113 L
.20415 .95163 L
.21196 .96134 L
.21348 .96312 L
.2207 .97106 L
.22319 .97364 L
.23048 .98077 L
.98077 .98077 L
F
0 g
.98077 .50792 m
.97843 .50486 L
.97106 .49576 L
.97053 .49514 L
.96177 .48543 L
.96134 .48498 L
.95203 .47572 L
.95163 .47534 L
.94192 .46667 L
.94113 .46601 L
.93221 .45884 L
.92884 .45629 L
.92249 .45172 L
.91486 .44658 L
.91278 .44525 L
.90307 .43934 L
.89874 .43687 L
.89336 .43394 L
.88364 .42899 L
.87982 .42716 L
.87393 .42446 L
.86422 .4203 L
.85703 .41744 L
.85451 .41649 L
.84479 .41299 L
.83508 .40979 L
.82837 .40773 L
.82537 .40685 L
.81566 .40418 L
.80594 .40174 L
.79623 .39952 L
.7891 .39802 L
.78652 .39751 L
.77681 .39569 L
.76709 .39407 L
.75738 .39262 L
.74767 .39134 L
.73796 .39023 L
.72824 .38927 L
.71853 .38846 L
.71643 .38831 L
.70882 .3878 L
.69911 .38728 L
.68939 .3869 L
.67968 .38665 L
.66997 .38653 L
.66026 .38654 L
.65054 .38668 L
.64083 .38694 L
.63112 .38732 L
Mistroke
.62141 .38783 L
.6139 .38831 L
.61169 .38846 L
.60198 .38921 L
.59227 .39009 L
.58256 .39109 L
.57284 .39221 L
.56313 .39345 L
.55342 .39483 L
.54371 .39633 L
.53399 .39796 L
.53367 .39802 L
.52428 .39973 L
.51457 .40163 L
.50486 .40368 L
.49514 .40587 L
.48735 .40773 L
.48543 .40821 L
.47572 .4107 L
.46601 .41335 L
.45629 .41617 L
.4521 .41744 L
.44658 .41916 L
.43687 .42234 L
.42716 .4257 L
.42313 .42716 L
.41744 .42927 L
.40773 .43304 L
.3984 .43687 L
.39802 .43703 L
.38831 .44126 L
.37859 .44574 L
.37682 .44658 L
.36888 .45048 L
.35917 .4555 L
.35769 .45629 L
.34946 .46083 L
.34054 .46601 L
.33974 .46648 L
.33003 .47249 L
.32504 .47572 L
.32032 .47887 L
.31094 .48543 L
.31061 .48567 L
.30089 .49292 L
.29804 .49514 L
.29118 .50067 L
.2862 .50486 L
.28147 .50897 L
.27528 .51457 L
Mistroke
.27176 .51788 L
.2652 .52428 L
.26204 .52748 L
.25585 .53399 L
.25233 .53785 L
.24717 .54371 L
.24262 .54911 L
.23911 .55342 L
.23291 .56139 L
.2316 .56313 L
.2246 .57284 L
.22319 .57488 L
.21808 .58256 L
.21348 .58983 L
.21199 .59227 L
.20632 .60198 L
.20377 .60657 L
.20102 .61169 L
.19609 .62141 L
.19406 .62562 L
.1915 .63112 L
.18723 .64083 L
.18434 .64783 L
.18326 .65054 L
.1796 .66026 L
.17621 .66997 L
.17463 .6748 L
.1731 .67968 L
.17025 .68939 L
.16767 .69911 L
.16533 .70882 L
.16492 .71066 L
.16325 .71853 L
.16141 .72824 L
.15982 .73796 L
.15848 .74767 L
.15738 .75738 L
.15654 .76709 L
.15595 .77681 L
.15561 .78652 L
.15555 .79623 L
.15575 .80594 L
.15624 .81566 L
.15703 .82537 L
.15813 .83508 L
.15955 .84479 L
.16131 .85451 L
.16344 .86422 L
.16492 .87013 L
.16595 .87393 L
Mistroke
.16888 .88364 L
.17225 .89336 L
.17463 .89951 L
.1761 .90307 L
.18047 .91278 L
.18434 .92051 L
.1854 .92249 L
.19095 .93221 L
.19406 .9372 L
.19717 .94192 L
.20377 .95113 L
.20415 .95163 L
.21196 .96134 L
.21348 .96312 L
.2207 .97106 L
.22319 .97364 L
.23048 .98077 L
Mfstroke
.85 g
.98077 .6525 m
.98026 .65054 L
.97755 .64083 L
.97449 .63112 L
.97106 .62142 L
.97105 .62141 L
.96721 .61169 L
.96293 .60198 L
.96134 .59862 L
.95818 .59227 L
.95292 .58256 L
.95163 .58032 L
.94709 .57284 L
.94192 .565 L
.94063 .56313 L
.93346 .55342 L
.93221 .55183 L
.92548 .54371 L
.92249 .54032 L
.91658 .53399 L
.91278 .53016 L
.9066 .52428 L
.90307 .52111 L
.89533 .51457 L
.89336 .51299 L
.88364 .50567 L
.8825 .50486 L
.87393 .49906 L
.86769 .49514 L
.86422 .49307 L
.85451 .48763 L
.85031 .48543 L
.84479 .48268 L
.83508 .47819 L
.82932 .47572 L
.82537 .4741 L
.81566 .4704 L
.80594 .46704 L
.80276 .46601 L
.79623 .464 L
.78652 .46126 L
.77681 .4588 L
.76709 .45661 L
.76558 .45629 L
.75738 .45467 L
.74767 .45297 L
.73796 .45149 L
.72824 .45023 L
.71853 .44918 L
.70882 .44833 L
.69911 .44767 L
.68939 .4472 L
.67968 .44691 L
.66997 .44681 L
.66026 .44688 L
.65054 .44712 L
.64083 .44754 L
.63112 .44812 L
.62141 .44888 L
.61169 .4498 L
.60198 .45089 L
.59227 .45216 L
.58256 .4536 L
.57284 .45521 L
.56685 .45629 L
.56313 .457 L
.55342 .45897 L
.54371 .46113 L
.53399 .46347 L
.5243 .46601 L
.52428 .46601 L
.51457 .46875 L
.50486 .47171 L
.49514 .47488 L
.49267 .47572 L
.48543 .47827 L
.47572 .48191 L
.46687 .48543 L
.46601 .48579 L
.45629 .48993 L
.44658 .49436 L
.44492 .49514 L
.43687 .49908 L
.42716 .50411 L
.42577 .50486 L
.41744 .50948 L
.40879 .51457 L
.40773 .51521 L
.39802 .52134 L
.39358 .52428 L
.38831 .52789 L
.37982 .53399 L
.37859 .53491 L
.36888 .54244 L
.36732 .54371 L
.35917 .55055 L
.3559 .55342 L
.34946 .55929 L
.34542 .56313 L
.33974 .56876 L
.33579 .57284 L
.33003 .57906 L
.32692 .58256 L
.32032 .59033 L
.31874 .59227 L
.31118 .60198 L
.31061 .60275 L
.3042 .61169 L
.30089 .61658 L
.29776 .62141 L
.29181 .63112 L
.29118 .6322 L
.28633 .64083 L
.28147 .6502 L
.2813 .65054 L
.27668 .66026 L
.27246 .66997 L
.27176 .67169 L
.26863 .67968 L
.26517 .68939 L
.26206 .69911 L
.26204 .69917 L
.25931 .70882 L
.2569 .71853 L
.25483 .72824 L
.25309 .73796 L
.25233 .74291 L
.2517 .74767 L
.25064 .75738 L
.24992 .76709 L
.24954 .77681 L
.24952 .78652 L
.24986 .79623 L
.25057 .80594 L
.25167 .81566 L
.25233 .8203 L
.25318 .82537 L
.25511 .83508 L
.25748 .84479 L
.26033 .85451 L
.26204 .85966 L
.26368 .86422 L
.26758 .87393 L
.27176 .88303 L
.27206 .88364 L
.27717 .89336 L
.28147 .90067 L
.28297 .90307 L
.28953 .91278 L
.29118 .91506 L
.29693 .92249 L
.30089 .92726 L
.30526 .93221 L
.31061 .93788 L
.31465 .94192 L
.32032 .94727 L
.32524 .95163 L
.33003 .95567 L
.33721 .96134 L
.33974 .96326 L
.34946 .97015 L
.3508 .97106 L
.35917 .97646 L
.36632 .98077 L
.98077 .98077 L
F
0 g
.98077 .6525 m
.98026 .65054 L
.97755 .64083 L
.97449 .63112 L
.97106 .62142 L
.97105 .62141 L
.96721 .61169 L
.96293 .60198 L
.96134 .59862 L
.95818 .59227 L
.95292 .58256 L
.95163 .58032 L
.94709 .57284 L
.94192 .565 L
.94063 .56313 L
.93346 .55342 L
.93221 .55183 L
.92548 .54371 L
.92249 .54032 L
.91658 .53399 L
.91278 .53016 L
.9066 .52428 L
.90307 .52111 L
.89533 .51457 L
.89336 .51299 L
.88364 .50567 L
.8825 .50486 L
.87393 .49906 L
.86769 .49514 L
.86422 .49307 L
.85451 .48763 L
.85031 .48543 L
.84479 .48268 L
.83508 .47819 L
.82932 .47572 L
.82537 .4741 L
.81566 .4704 L
.80594 .46704 L
.80276 .46601 L
.79623 .464 L
.78652 .46126 L
.77681 .4588 L
.76709 .45661 L
.76558 .45629 L
.75738 .45467 L
.74767 .45297 L
.73796 .45149 L
.72824 .45023 L
.71853 .44918 L
.70882 .44833 L
Mistroke
.69911 .44767 L
.68939 .4472 L
.67968 .44691 L
.66997 .44681 L
.66026 .44688 L
.65054 .44712 L
.64083 .44754 L
.63112 .44812 L
.62141 .44888 L
.61169 .4498 L
.60198 .45089 L
.59227 .45216 L
.58256 .4536 L
.57284 .45521 L
.56685 .45629 L
.56313 .457 L
.55342 .45897 L
.54371 .46113 L
.53399 .46347 L
.5243 .46601 L
.52428 .46601 L
.51457 .46875 L
.50486 .47171 L
.49514 .47488 L
.49267 .47572 L
.48543 .47827 L
.47572 .48191 L
.46687 .48543 L
.46601 .48579 L
.45629 .48993 L
.44658 .49436 L
.44492 .49514 L
.43687 .49908 L
.42716 .50411 L
.42577 .50486 L
.41744 .50948 L
.40879 .51457 L
.40773 .51521 L
.39802 .52134 L
.39358 .52428 L
.38831 .52789 L
.37982 .53399 L
.37859 .53491 L
.36888 .54244 L
.36732 .54371 L
.35917 .55055 L
.3559 .55342 L
.34946 .55929 L
.34542 .56313 L
.33974 .56876 L
Mistroke
.33579 .57284 L
.33003 .57906 L
.32692 .58256 L
.32032 .59033 L
.31874 .59227 L
.31118 .60198 L
.31061 .60275 L
.3042 .61169 L
.30089 .61658 L
.29776 .62141 L
.29181 .63112 L
.29118 .6322 L
.28633 .64083 L
.28147 .6502 L
.2813 .65054 L
.27668 .66026 L
.27246 .66997 L
.27176 .67169 L
.26863 .67968 L
.26517 .68939 L
.26206 .69911 L
.26204 .69917 L
.25931 .70882 L
.2569 .71853 L
.25483 .72824 L
.25309 .73796 L
.25233 .74291 L
.2517 .74767 L
.25064 .75738 L
.24992 .76709 L
.24954 .77681 L
.24952 .78652 L
.24986 .79623 L
.25057 .80594 L
.25167 .81566 L
.25233 .8203 L
.25318 .82537 L
.25511 .83508 L
.25748 .84479 L
.26033 .85451 L
.26204 .85966 L
.26368 .86422 L
.26758 .87393 L
.27176 .88303 L
.27206 .88364 L
.27717 .89336 L
.28147 .90067 L
.28297 .90307 L
.28953 .91278 L
.29118 .91506 L
Mistroke
.29693 .92249 L
.30089 .92726 L
.30526 .93221 L
.31061 .93788 L
.31465 .94192 L
.32032 .94727 L
.32524 .95163 L
.33003 .95567 L
.33721 .96134 L
.33974 .96326 L
.34946 .97015 L
.3508 .97106 L
.35917 .97646 L
.36632 .98077 L
Mfstroke
.25 g
.91351 .01923 m
.91278 .01956 L
.90307 .02376 L
.89336 .02756 L
.88956 .02894 L
.88364 .031 L
.87393 .03414 L
.86422 .037 L
.85816 .03866 L
.85451 .03961 L
.84479 .042 L
.83508 .04418 L
.82537 .04619 L
.81566 .04802 L
.8137 .04837 L
.80594 .0497 L
.79623 .05123 L
.78652 .05263 L
.77681 .05391 L
.76709 .05507 L
.75738 .05613 L
.74767 .05708 L
.73796 .05794 L
.7363 .05808 L
.72824 .05871 L
.71853 .0594 L
.70882 .06 L
.69911 .06052 L
.68939 .06097 L
.67968 .06135 L
.66997 .06166 L
.66026 .0619 L
.65054 .06208 L
.64083 .06219 L
.63112 .06225 L
.62141 .06225 L
.61169 .06218 L
.60198 .06206 L
.59227 .06189 L
.58256 .06166 L
.57284 .06138 L
.56313 .06104 L
.55342 .06065 L
.54371 .0602 L
.53399 .05971 L
.52428 .05916 L
.51457 .05856 L
.50746 .05808 L
.50486 .0579 L
.49514 .05719 L
.48543 .05643 L
.47572 .05561 L
.46601 .05474 L
.45629 .05381 L
.44658 .05283 L
.43687 .05179 L
.42716 .0507 L
.41744 .04954 L
.40807 .04837 L
.40773 .04832 L
.39802 .04705 L
.38831 .04571 L
.37859 .04431 L
.36888 .04284 L
.35917 .04131 L
.34946 .0397 L
.34333 .03866 L
.33974 .03803 L
.33003 .03628 L
.32032 .03446 L
.31061 .03257 L
.30089 .03059 L
.29306 .02894 L
.29118 .02854 L
.28147 .0264 L
.27176 .02418 L
.26204 .02186 L
.25233 .01946 L
.25144 .01923 L
F
0 g
.91351 .01923 m
.91278 .01956 L
.90307 .02376 L
.89336 .02756 L
.88956 .02894 L
.88364 .031 L
.87393 .03414 L
.86422 .037 L
.85816 .03866 L
.85451 .03961 L
.84479 .042 L
.83508 .04418 L
.82537 .04619 L
.81566 .04802 L
.8137 .04837 L
.80594 .0497 L
.79623 .05123 L
.78652 .05263 L
.77681 .05391 L
.76709 .05507 L
.75738 .05613 L
.74767 .05708 L
.73796 .05794 L
.7363 .05808 L
.72824 .05871 L
.71853 .0594 L
.70882 .06 L
.69911 .06052 L
.68939 .06097 L
.67968 .06135 L
.66997 .06166 L
.66026 .0619 L
.65054 .06208 L
.64083 .06219 L
.63112 .06225 L
.62141 .06225 L
.61169 .06218 L
.60198 .06206 L
.59227 .06189 L
.58256 .06166 L
.57284 .06138 L
.56313 .06104 L
.55342 .06065 L
.54371 .0602 L
.53399 .05971 L
.52428 .05916 L
.51457 .05856 L
.50746 .05808 L
.50486 .0579 L
.49514 .05719 L
Mistroke
.48543 .05643 L
.47572 .05561 L
.46601 .05474 L
.45629 .05381 L
.44658 .05283 L
.43687 .05179 L
.42716 .0507 L
.41744 .04954 L
.40807 .04837 L
.40773 .04832 L
.39802 .04705 L
.38831 .04571 L
.37859 .04431 L
.36888 .04284 L
.35917 .04131 L
.34946 .0397 L
.34333 .03866 L
.33974 .03803 L
.33003 .03628 L
.32032 .03446 L
.31061 .03257 L
.30089 .03059 L
.29306 .02894 L
.29118 .02854 L
.28147 .0264 L
.27176 .02418 L
.26204 .02186 L
.25233 .01946 L
.25144 .01923 L
Mfstroke
.925 g
.68565 .98077 m
.68939 .98035 L
.69911 .97912 L
.70882 .97765 L
.71853 .97592 L
.72824 .97392 L
.73796 .97165 L
.74029 .97106 L
.74767 .96907 L
.75738 .96618 L
.76709 .96296 L
.77158 .96134 L
.77681 .95936 L
.78652 .95537 L
.79479 .95163 L
.79623 .95095 L
.80594 .94605 L
.81341 .94192 L
.81566 .94061 L
.82537 .93459 L
.82894 .93221 L
.83508 .92789 L
.8422 .92249 L
.84479 .92042 L
.85369 .91278 L
.85451 .91204 L
.86375 .90307 L
.86422 .90259 L
.87263 .89336 L
.87393 .89182 L
.88048 .88364 L
.88364 .87938 L
.88746 .87393 L
.89336 .86472 L
.89366 .86422 L
.89916 .85451 L
.90307 .84683 L
.90404 .84479 L
.90835 .83508 L
.91212 .82537 L
.91278 .82353 L
.91541 .81566 L
.91822 .80594 L
.9206 .79623 L
.92249 .78687 L
.92256 .78652 L
.92411 .77681 L
.92526 .76709 L
.92603 .75738 L
.92642 .74767 L
.92642 .73796 L
.92605 .72824 L
.92529 .71853 L
.92414 .70882 L
.92258 .69911 L
.92249 .69862 L
.92061 .68939 L
.91821 .67968 L
.91535 .66997 L
.91278 .66239 L
.912 .66026 L
.90814 .65054 L
.90372 .64083 L
.90307 .63951 L
.89868 .63112 L
.89336 .62202 L
.89297 .62141 L
.88651 .61169 L
.88364 .60774 L
.8792 .60198 L
.87393 .59568 L
.87089 .59227 L
.86422 .58528 L
.86143 .58256 L
.85451 .5762 L
.85058 .57284 L
.84479 .5682 L
.83798 .56313 L
.83508 .5611 L
.82537 .55478 L
.82312 .55342 L
.81566 .54914 L
.80594 .54411 L
.80512 .54371 L
.79623 .53962 L
.78652 .53561 L
.78225 .53399 L
.77681 .53205 L
.76709 .52891 L
.75738 .52614 L
.74999 .52428 L
.74767 .52374 L
.73796 .52167 L
.72824 .51991 L
.71853 .51846 L
.70882 .5173 L
.69911 .51642 L
.68939 .5158 L
.67968 .51545 L
.66997 .51534 L
.66026 .51549 L
.65054 .51589 L
.64083 .51653 L
.63112 .51741 L
.62141 .51853 L
.61169 .5199 L
.60198 .52152 L
.59227 .52338 L
.58799 .52428 L
.58256 .5255 L
.57284 .52788 L
.56313 .53052 L
.55342 .53344 L
.55169 .53399 L
.54371 .53665 L
.53399 .54016 L
.52496 .54371 L
.52428 .54399 L
.51457 .54814 L
.50486 .55265 L
.50327 .55342 L
.49514 .55753 L
.48543 .56282 L
.48487 .56313 L
.47572 .56854 L
.46889 .57284 L
.46601 .57474 L
.45629 .58147 L
.4548 .58256 L
.44658 .58878 L
.44223 .59227 L
.43687 .59675 L
.43094 .60198 L
.42716 .60548 L
.42076 .61169 L
.41744 .61509 L
.41156 .62141 L
.40773 .62574 L
.40321 .63112 L
.39802 .63768 L
.39564 .64083 L
.38879 .65054 L
.38831 .65127 L
.38259 .66026 L
.37859 .66711 L
.37701 .66997 L
.372 .67968 L
.36888 .68635 L
.36754 .68939 L
.36361 .69911 L
.36017 .70882 L
.35917 .71195 L
.35723 .71853 L
.35477 .72824 L
.35277 .73796 L
.35125 .74767 L
.3502 .75738 L
.34962 .76709 L
.34952 .77681 L
.34991 .78652 L
.35081 .79623 L
.35223 .80594 L
.3542 .81566 L
.35675 .82537 L
.35917 .83298 L
.35991 .83508 L
.36372 .84479 L
.36824 .85451 L
.36888 .85577 L
.37353 .86422 L
.37859 .87235 L
.37965 .87393 L
.38671 .88364 L
.38831 .88567 L
.39482 .89336 L
.39802 .89685 L
.40412 .90307 L
.40773 .90651 L
.41481 .91278 L
.41744 .91498 L
.42713 .92249 L
.42716 .92251 L
.43687 .92927 L
.44144 .93221 L
.44658 .93535 L
.45629 .94086 L
.45827 .94192 L
.46601 .94587 L
.47572 .95043 L
.47844 .95163 L
.48543 .95458 L
.49514 .95836 L
.50349 .96134 L
.50486 .96181 L
.51457 .96494 L
.52428 .96778 L
.53399 .97034 L
.53692 .97106 L
.54371 .97264 L
.55342 .97469 L
.56313 .9765 L
.57284 .97808 L
.58256 .97944 L
.59227 .98058 L
.59405 .98077 L
F
0 g
.68565 .98077 m
.68939 .98035 L
.69911 .97912 L
.70882 .97765 L
.71853 .97592 L
.72824 .97392 L
.73796 .97165 L
.74029 .97106 L
.74767 .96907 L
.75738 .96618 L
.76709 .96296 L
.77158 .96134 L
.77681 .95936 L
.78652 .95537 L
.79479 .95163 L
.79623 .95095 L
.80594 .94605 L
.81341 .94192 L
.81566 .94061 L
.82537 .93459 L
.82894 .93221 L
.83508 .92789 L
.8422 .92249 L
.84479 .92042 L
.85369 .91278 L
.85451 .91204 L
.86375 .90307 L
.86422 .90259 L
.87263 .89336 L
.87393 .89182 L
.88048 .88364 L
.88364 .87938 L
.88746 .87393 L
.89336 .86472 L
.89366 .86422 L
.89916 .85451 L
.90307 .84683 L
.90404 .84479 L
.90835 .83508 L
.91212 .82537 L
.91278 .82353 L
.91541 .81566 L
.91822 .80594 L
.9206 .79623 L
.92249 .78687 L
.92256 .78652 L
.92411 .77681 L
.92526 .76709 L
.92603 .75738 L
.92642 .74767 L
Mistroke
.92642 .73796 L
.92605 .72824 L
.92529 .71853 L
.92414 .70882 L
.92258 .69911 L
.92249 .69862 L
.92061 .68939 L
.91821 .67968 L
.91535 .66997 L
.91278 .66239 L
.912 .66026 L
.90814 .65054 L
.90372 .64083 L
.90307 .63951 L
.89868 .63112 L
.89336 .62202 L
.89297 .62141 L
.88651 .61169 L
.88364 .60774 L
.8792 .60198 L
.87393 .59568 L
.87089 .59227 L
.86422 .58528 L
.86143 .58256 L
.85451 .5762 L
.85058 .57284 L
.84479 .5682 L
.83798 .56313 L
.83508 .5611 L
.82537 .55478 L
.82312 .55342 L
.81566 .54914 L
.80594 .54411 L
.80512 .54371 L
.79623 .53962 L
.78652 .53561 L
.78225 .53399 L
.77681 .53205 L
.76709 .52891 L
.75738 .52614 L
.74999 .52428 L
.74767 .52374 L
.73796 .52167 L
.72824 .51991 L
.71853 .51846 L
.70882 .5173 L
.69911 .51642 L
.68939 .5158 L
.67968 .51545 L
.66997 .51534 L
Mistroke
.66026 .51549 L
.65054 .51589 L
.64083 .51653 L
.63112 .51741 L
.62141 .51853 L
.61169 .5199 L
.60198 .52152 L
.59227 .52338 L
.58799 .52428 L
.58256 .5255 L
.57284 .52788 L
.56313 .53052 L
.55342 .53344 L
.55169 .53399 L
.54371 .53665 L
.53399 .54016 L
.52496 .54371 L
.52428 .54399 L
.51457 .54814 L
.50486 .55265 L
.50327 .55342 L
.49514 .55753 L
.48543 .56282 L
.48487 .56313 L
.47572 .56854 L
.46889 .57284 L
.46601 .57474 L
.45629 .58147 L
.4548 .58256 L
.44658 .58878 L
.44223 .59227 L
.43687 .59675 L
.43094 .60198 L
.42716 .60548 L
.42076 .61169 L
.41744 .61509 L
.41156 .62141 L
.40773 .62574 L
.40321 .63112 L
.39802 .63768 L
.39564 .64083 L
.38879 .65054 L
.38831 .65127 L
.38259 .66026 L
.37859 .66711 L
.37701 .66997 L
.372 .67968 L
.36888 .68635 L
.36754 .68939 L
.36361 .69911 L
Mistroke
.36017 .70882 L
.35917 .71195 L
.35723 .71853 L
.35477 .72824 L
.35277 .73796 L
.35125 .74767 L
.3502 .75738 L
.34962 .76709 L
.34952 .77681 L
.34991 .78652 L
.35081 .79623 L
.35223 .80594 L
.3542 .81566 L
.35675 .82537 L
.35917 .83298 L
.35991 .83508 L
.36372 .84479 L
.36824 .85451 L
.36888 .85577 L
.37353 .86422 L
.37859 .87235 L
.37965 .87393 L
.38671 .88364 L
.38831 .88567 L
.39482 .89336 L
.39802 .89685 L
.40412 .90307 L
.40773 .90651 L
.41481 .91278 L
.41744 .91498 L
.42713 .92249 L
.42716 .92251 L
.43687 .92927 L
.44144 .93221 L
.44658 .93535 L
.45629 .94086 L
.45827 .94192 L
.46601 .94587 L
.47572 .95043 L
.47844 .95163 L
.48543 .95458 L
.49514 .95836 L
.50349 .96134 L
.50486 .96181 L
.51457 .96494 L
.52428 .96778 L
.53399 .97034 L
.53692 .97106 L
.54371 .97264 L
.55342 .97469 L
Mistroke
.56313 .9765 L
.57284 .97808 L
.58256 .97944 L
.59227 .98058 L
.59405 .98077 L
Mfstroke
1 g
.61169 .61113 m
.62141 .60878 L
.63112 .60687 L
.64083 .60537 L
.65054 .60429 L
.66026 .60362 L
.66997 .60337 L
.67968 .60353 L
.68939 .60413 L
.69911 .60517 L
.70882 .60667 L
.71853 .60867 L
.72824 .61119 L
.72996 .61169 L
.73796 .61429 L
.74767 .618 L
.7553 .62141 L
.75738 .62242 L
.76709 .62763 L
.77281 .63112 L
.77681 .63377 L
.78629 .64083 L
.78652 .64101 L
.79623 .64965 L
.79714 .65054 L
.80594 .66012 L
.80606 .66026 L
.81346 .66997 L
.81566 .67323 L
.81961 .67968 L
.82469 .68939 L
.82537 .69084 L
.82883 .69911 L
.83212 .70882 L
.83463 .71853 L
.83508 .72053 L
.8364 .72824 L
.83747 .73796 L
.83787 .74767 L
.83759 .75738 L
.83664 .76709 L
.83508 .77649 L
.83501 .77681 L
.83267 .78652 L
.82959 .79623 L
.82571 .80594 L
.82537 .80672 L
.82098 .81566 L
.81566 .82479 L
.81529 .82537 L
.80851 .83508 L
.80594 .83837 L
.80047 .84479 L
.79623 .84932 L
.79091 .85451 L
.78652 .85844 L
.77943 .86422 L
.77681 .8662 L
.76709 .87286 L
.76538 .87393 L
.75738 .87861 L
.74767 .88359 L
.74756 .88364 L
.73796 .8879 L
.72824 .8916 L
.72305 .89336 L
.71853 .89476 L
.70882 .89742 L
.69911 .89961 L
.68939 .90137 L
.67968 .90271 L
.6767 .90307 L
.66997 .90365 L
.66026 .90421 L
.65054 .90439 L
.64083 .90419 L
.63112 .90362 L
.62487 .90307 L
.62141 .90266 L
.61169 .90132 L
.60198 .89957 L
.59227 .89741 L
.58256 .89479 L
.57784 .89336 L
.57284 .89171 L
.56313 .88809 L
.55342 .8839 L
.55286 .88364 L
.54371 .87906 L
.53476 .87393 L
.53399 .87346 L
.52428 .86696 L
.5206 .86422 L
.51457 .85934 L
.50917 .85451 L
.50486 .85027 L
.49981 .84479 L
.49514 .83913 L
.49212 .83508 L
.48583 .82537 L
.48543 .82468 L
.48076 .81566 L
.47676 .80594 L
.47572 .80299 L
.47375 .79623 L
.47164 .78652 L
.47039 .77681 L
.46995 .76709 L
.4703 .75738 L
.47142 .74767 L
.47331 .73796 L
.47572 .72908 L
.47599 .72824 L
.47946 .71853 L
.48377 .70882 L
.48543 .70551 L
.48896 .69911 L
.49509 .68939 L
.49514 .68932 L
.50227 .67968 L
.50486 .67651 L
.51061 .66997 L
.51457 .66583 L
.52032 .66026 L
.52428 .65668 L
.53164 .65054 L
.53399 .64871 L
.54371 .6417 L
.545 .64083 L
.55342 .63551 L
.56112 .63112 L
.56313 .63004 L
.57284 .62519 L
.58138 .62141 L
.58256 .62092 L
.59227 .61717 L
.60198 .61392 L
.60958 .61169 L
F
0 g
.61169 .61113 m
.62141 .60878 L
.63112 .60687 L
.64083 .60537 L
.65054 .60429 L
.66026 .60362 L
.66997 .60337 L
.67968 .60353 L
.68939 .60413 L
.69911 .60517 L
.70882 .60667 L
.71853 .60867 L
.72824 .61119 L
.72996 .61169 L
.73796 .61429 L
.74767 .618 L
.7553 .62141 L
.75738 .62242 L
.76709 .62763 L
.77281 .63112 L
.77681 .63377 L
.78629 .64083 L
.78652 .64101 L
.79623 .64965 L
.79714 .65054 L
.80594 .66012 L
.80606 .66026 L
.81346 .66997 L
.81566 .67323 L
.81961 .67968 L
.82469 .68939 L
.82537 .69084 L
.82883 .69911 L
.83212 .70882 L
.83463 .71853 L
.83508 .72053 L
.8364 .72824 L
.83747 .73796 L
.83787 .74767 L
.83759 .75738 L
.83664 .76709 L
.83508 .77649 L
.83501 .77681 L
.83267 .78652 L
.82959 .79623 L
.82571 .80594 L
.82537 .80672 L
.82098 .81566 L
.81566 .82479 L
.81529 .82537 L
Mistroke
.80851 .83508 L
.80594 .83837 L
.80047 .84479 L
.79623 .84932 L
.79091 .85451 L
.78652 .85844 L
.77943 .86422 L
.77681 .8662 L
.76709 .87286 L
.76538 .87393 L
.75738 .87861 L
.74767 .88359 L
.74756 .88364 L
.73796 .8879 L
.72824 .8916 L
.72305 .89336 L
.71853 .89476 L
.70882 .89742 L
.69911 .89961 L
.68939 .90137 L
.67968 .90271 L
.6767 .90307 L
.66997 .90365 L
.66026 .90421 L
.65054 .90439 L
.64083 .90419 L
.63112 .90362 L
.62487 .90307 L
.62141 .90266 L
.61169 .90132 L
.60198 .89957 L
.59227 .89741 L
.58256 .89479 L
.57784 .89336 L
.57284 .89171 L
.56313 .88809 L
.55342 .8839 L
.55286 .88364 L
.54371 .87906 L
.53476 .87393 L
.53399 .87346 L
.52428 .86696 L
.5206 .86422 L
.51457 .85934 L
.50917 .85451 L
.50486 .85027 L
.49981 .84479 L
.49514 .83913 L
.49212 .83508 L
.48583 .82537 L
Mistroke
.48543 .82468 L
.48076 .81566 L
.47676 .80594 L
.47572 .80299 L
.47375 .79623 L
.47164 .78652 L
.47039 .77681 L
.46995 .76709 L
.4703 .75738 L
.47142 .74767 L
.47331 .73796 L
.47572 .72908 L
.47599 .72824 L
.47946 .71853 L
.48377 .70882 L
.48543 .70551 L
.48896 .69911 L
.49509 .68939 L
.49514 .68932 L
.50227 .67968 L
.50486 .67651 L
.51061 .66997 L
.51457 .66583 L
.52032 .66026 L
.52428 .65668 L
.53164 .65054 L
.53399 .64871 L
.54371 .6417 L
.545 .64083 L
.55342 .63551 L
.56112 .63112 L
.56313 .63004 L
.57284 .62519 L
.58138 .62141 L
.58256 .62092 L
.59227 .61717 L
.60198 .61392 L
.60958 .61169 L
.61169 .61113 L
Mfstroke
.775 g
.98077 .82187 m
.97987 .82537 L
.97716 .83508 L
.97412 .84479 L
.97106 .85358 L
.97072 .85451 L
.96693 .86422 L
.96274 .87393 L
.96134 .87696 L
.95811 .88364 L
.95299 .89336 L
.95163 .89578 L
.94735 .90307 L
.94192 .91159 L
.94112 .91278 L
.93425 .92249 L
.93221 .9252 L
.92664 .93221 L
.92249 .93711 L
.91821 .94192 L
.91278 .94766 L
.90881 .95163 L
.90307 .95707 L
.89829 .96134 L
.89336 .96554 L
.88644 .97106 L
.88364 .97318 L
.87393 .98012 L
.87297 .98077 L
.98077 .98077 L
F
0 g
.98077 .82187 m
.97987 .82537 L
.97716 .83508 L
.97412 .84479 L
.97106 .85358 L
.97072 .85451 L
.96693 .86422 L
.96274 .87393 L
.96134 .87696 L
.95811 .88364 L
.95299 .89336 L
.95163 .89578 L
.94735 .90307 L
.94192 .91159 L
.94112 .91278 L
.93425 .92249 L
.93221 .9252 L
.92664 .93221 L
.92249 .93711 L
.91821 .94192 L
.91278 .94766 L
.90881 .95163 L
.90307 .95707 L
.89829 .96134 L
.89336 .96554 L
.88644 .97106 L
.88364 .97318 L
.87393 .98012 L
.87297 .98077 L
s
.7 g
.98077 .95821 m
.97849 .96134 L
.97106 .97096 L
.97098 .97106 L
.9627 .98077 L
.98077 .98077 L
F
0 g
.98077 .95821 m
.97849 .96134 L
.97106 .97096 L
.97098 .97106 L
.9627 .98077 L
s
0 0 0 r
.055 w
.66472 .75716 Mdot
1 0 0 r
.0325 w
.23484 .01923 Mdot
.01923 .76016 Mdot
.30515 .98077 Mdot
.98077 .78497 Mdot
.56853 .90444 Mdot
.87844 .57303 Mdot
.68696 .77779 Mdot
.64082 .74726 Mdot
.6645 .75669 Mdot
.66471 .75718 Mdot
.66472 .75716 Mdot
.66472 .75716 Mdot
.66472 .75716 Mdot
0 1 0 r
.02 w
.23484 .01923 Mdot
.01923 .76016 Mdot
.30515 .98077 Mdot
.98077 .78497 Mdot
.56853 .90444 Mdot
.87844 .57303 Mdot
.68696 .77779 Mdot
.64082 .74726 Mdot
.6645 .75669 Mdot
.66471 .75718 Mdot
.66472 .75716 Mdot
.66472 .75716 Mdot
.66472 .75716 Mdot
0 0 1 r
.5 Mabswid
.23484 .01923 m
.23484 .01923 L
.01923 .76016 L
.30515 .98077 L
.56853 .90444 L
.68696 .77779 L
.64082 .74726 L
.6645 .75669 L
.66471 .75718 L
.66472 .75716 L
.66472 .75716 L
.66472 .75716 L
s
.015 w
.23484 .01923 Mdot
.23484 .01923 Mdot
.01923 .76016 Mdot
.30515 .98077 Mdot
.56853 .90444 Mdot
.68696 .77779 Mdot
.64082 .74726 Mdot
.6645 .75669 Mdot
.66471 .75718 Mdot
.66472 .75716 Mdot
.66472 .75716 Mdot
.66472 .75716 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ShowCellBracket->True,
 ImageSize->{288, 288},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.2.2",
 CellLabel->"From In[22]:=",
 CellID->1951185165,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"],
 ImageRangeCache->{{{0, 287}, {287, 0}} -> {0.724082, 0.923841, 0.00329714, \
0.00346338}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2.`"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", "1.3763849725073272`"}], ",", 
       RowBox[{"y", "\[Rule]", "1.6786760822011257`"}]}], "}"}]}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\<\"Steps\"\>", "\[Rule]", "10"}], ",", 
     RowBox[{"\<\"Function\"\>", "\[Rule]", "13"}], ",", 
     RowBox[{"\<\"Gradient\"\>", "\[Rule]", "13"}]}], "}"}], ",", 
   TagBox[
    RowBox[{
    "\[SkeletonIndicator]", "ContourGraphics", "\[SkeletonIndicator]"}],
    False,
    Editable->False]}], "}"}]], "Output",
 ShowCellBracket->True,
 ImageSize->{428, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.2.2",
 CellLabel->"Out[22]=",
 CellID->1493778465]
}, Open  ]],

Cell[TextData[{
 "Quasi-Newton methods are chosen as the default in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " because they are typically quite fast and do not require computation of \
the Hessian matrix, which can be quite expensive both in terms of the \
symbolic computation and numerical evaluation. With an adequate \"",
 ButtonBox["line search",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/UnconstrainedOptimizationLineSearchMethods"],
 "\", they can be shown to converge superlinearly [",
 ButtonBox["NW99",
  BaseStyle->"RefGuideLinkText",
  ButtonData:>{
   "Advanced Documentation: Unconstrained Optimization: References", 
    "NW99"}],
 "] to a local minimum where the Hessian is positive definite. This means \
that "
}], "Text",
 ShowCellBracket->True,
 CellTags->"b:0.2.2",
 CellID->1850827825],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    UnderscriptBox["lim", 
     RowBox[{"k", "\[Rule]", "\[Infinity]"}]], 
    FractionBox[
     RowBox[{"\[LeftDoubleBracketingBar]", 
      RowBox[{
       SubscriptBox["x", 
        RowBox[{"k", "+", "1"}]], "-", 
       SuperscriptBox["x", "*"]}], "\[RightDoubleBracketingBar]"}], 
     RowBox[{"\[LeftDoubleBracketingBar]", 
      RowBox[{
       SubscriptBox["x", "k"], "-", 
       SuperscriptBox["x", "*"]}], "\[RightDoubleBracketingBar]"}]]}], "=", 
   " ", "0"}], TraditionalForm]], "DisplayMath",
 ShowCellBracket->True,
 CellTags->"b:0.2.2",
 CellID->562627980],

Cell[TextData[{
 "or, in other words, the steps keep getting smaller. However, for very high \
precision, this does not compare to the ",
 StyleBox["q",
  FontSlant->"Italic"],
 "-quadratic convergence rate of ",
 ButtonBox["Newton\[CloseCurlyQuote]s",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/UnconstrainedOptimizationNewtonsMethodMinimum"],
 " method."
}], "Text",
 ShowCellBracket->True,
 CellTags->"b:0.2.2",
 CellID->717962119],

Cell["\<\
This shows the number of steps and function evaluations required to find the \
minimum to high precision for the problem shown.\
\>", "MathCaption",
 ShowCellBracket->True,
 CellTags->"b:0.2.2",
 CellID->1985213605],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"First", "[", 
  RowBox[{"Timing", "[", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"e", " ", "=", " ", "0"}], ",", " ", 
       RowBox[{"s", " ", "=", " ", "0"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"min", ",", " ", "minpoint"}], "}"}], ",", 
         RowBox[{"{", "points", "}"}]}], "}"}], "  ", "=", " ", 
       RowBox[{"Reap", "[", 
        RowBox[{"FindMinimum", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Cos", "[", 
            RowBox[{
             RowBox[{"x", "^", "2"}], " ", "-", " ", 
             RowBox[{"3", " ", "y"}]}], "]"}], " ", "+", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{
             RowBox[{"x", "^", "2"}], " ", "+", " ", 
             RowBox[{"y", "^", "2"}]}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x", ",", "1."}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"y", ",", "1."}], "}"}]}], "}"}], ",", " ", 
          RowBox[{"Method", "->", "\"\<QuasiNewton\>\""}], ",", " ", 
          RowBox[{"WorkingPrecision", "\[Rule]", "10000"}], ",", 
          RowBox[{"StepMonitor", "\[RuleDelayed]", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"s", "++"}], ";", 
             RowBox[{"Sow", "[", 
              RowBox[{"{", 
               RowBox[{"x", ",", "y"}], "}"}], "]"}]}], ")"}]}], ",", " ", 
          RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
           RowBox[{"e", "++"}]}]}], "]"}], "]"}]}], ";", 
      RowBox[{"Print", "[", 
       RowBox[{
       "s", ",", "\"\< steps and \>\"", ",", "e", ",", 
        "\"\< evaluations\>\""}], "]"}]}]}], "]"}], "]"}], "]"}]], "Input",
 ShowCellBracket->True,
 CellTags->"b:0.2.2",
 CellID->31635796],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "95", "\[InvisibleSpace]", "\<\" steps and \"\>", "\[InvisibleSpace]", 
   "106", "\[InvisibleSpace]", "\<\" evaluations\"\>"}],
  SequenceForm[95, " steps and ", 106, " evaluations"],
  Editable->False]], "Print",
 ShowCellBracket->True,
 CellTags->"b:0.2.2",
 CellID->1274362563],

Cell[BoxData["2.7962319999999963`"], "Output",
 ShowCellBracket->True,
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.2.2",
 CellID->1357184810]
}, Open  ]],

Cell["\<\
Newton's method is able to find ten times as many digits with far fewer steps \
because of its quadratic convergence rate. However, the convergence with the \
quasi-Newton method is still superlinear since the ratio of the errors is \
clearly going to zero.\
\>", "Text",
 ShowCellBracket->True,
 CellTags->"b:0.2.2",
 CellID->1781286883],

Cell["\<\
This makes a plot showing the ratios of the errors in the computation. The \
ratios of the errors are shown on a logarithmic scale so that the trend can \
clearly be seen over a large range of magnitudes.\
\>", "MathCaption",
 ShowCellBracket->True,
 CellTags->"b:0.2.2",
 CellID->838874921],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"exact", " ", "=", " ", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", " ", "y"}], "}"}], " ", "/.", " ", 
    RowBox[{"Last", "[", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", "2"}], " ", "+", " ", 
           RowBox[{"y", "^", "2"}]}], " ", "\[Equal]", 
          RowBox[{"3", "  ", 
           RowBox[{"Pi", "/", "2"}]}]}], ",", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", "2"}], " ", "-", " ", 
           RowBox[{"3", " ", "y"}]}], " ", "\[Equal]", " ", 
          RowBox[{"-", "Pi"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "]"}]}]}], ";", 
  RowBox[{"errs", "=", " ", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Norm", "[", 
       RowBox[{"N", "[", 
        RowBox[{"exact", " ", "-", " ", "#"}], "]"}], "]"}], "&"}], ",", " ", 
     "points"}], "]"}]}], ";"}], "\n", 
 RowBox[{"ListPlot", "[", 
  RowBox[{"Log", "[", 
   RowBox[{"10", ",", " ", 
    RowBox[{
     RowBox[{"Drop", "[", 
      RowBox[{"errs", ",", " ", "1"}], "]"}], "/", 
     RowBox[{"Drop", "[", 
      RowBox[{"errs", ",", " ", 
       RowBox[{"-", "1"}]}], "]"}]}]}], "]"}], "]"}]}], "Input",
 ShowCellBracket->True,
 CellTags->"b:0.2.2",
 CellLabel->"In[47]:=",
 CellID->740654692],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWVtLVFEU3jpnvIzajXJUFI2kSMKKQkkaZ2zUqTAlsqQwc7DUibykkiQ+
BElRGRQVmHYhqCAIekjqBwRRT7323B857cs5Z/Y+Z+01Z5yhl4TZc7as9a3b
t9beR08l58avTCTnUiPJhsRMcno8NTLb0D01Q38VKCCErNPPaBWhzyZ94p9q
0zRJgD3xH7LCFuL+7RO+f/f2VzTy/OHyN1KISA2cfU+luuIvJKlCKvSY7Yoc
jJ8//kxNfv765TeM9YgthsASCgYot8yWEgeV7ihwV/xlNLJCXcB0BHY8tuby
x1C8vq/iC6nenjcixGIQ/x6KD+vcQe2EEB1h51hs1WUnpMSxhOJXcFnmGYMv
tHQC1neRy+5tya6cdmFXYJXw+qV1BKqNQlx7/uja32JLsewxddRi1laBEbCg
GJq9zYNNOTInLMvmxuJi20WUqdvzlLVFlBN5tRJ0kYiEHRbJ7NGx6KYJzJRA
Ot9hhb8L3KKrp0gN2Bc3UK5jOrqehXVmUTt1iv9zEr63Z+pA/GmgAyy6kJ2I
BsxfWOMayspGJYYJNEdCtjxD1VNozvZwjDK2Fsn89LIUYmUK5b7AZv4w6pNi
B1k2kdHGKOp/k5IDjqX0WdAUs2AUZUNTTlkYQVjTnAdkmF3Nvqp/CWabNdYP
KmwbRquZlpXxB9HqHEZ0dHYQHc/8a1X8v2Di860VRD5vQnOuDZQ9h0aL6eiY
16ZE0I8wqd1Xvc8gjGnPiYt9MJMs9zrMfPR6n5Qr77zryNp/tu1Ba9bpYNr3
MO/8kFF7UO52OjUiQUfHZ+wnUD8THKXCTM85qPonUO8SCtcSqL2TIJe7US7D
OnGA0/atshfRgDncq8QQQzl5GkSPojmCdY6iuepHdHRc7lfiiJjQdBtwai5x
UlP5IyY++0AsH6zkuEFXtsSkTXe7661ANI1kxNNFLWg+BXqZpOP0D3i2t6Cs
FGj4DUH27RDAV3sGD20IC2byUBbV3Q/z3GqjpMKlAyi/07Iy/j60HpcRHR2/
YZ29qJ0xJY4mNI4xEH83in8V0dGxB9bZBXDEnmmTShSNCAMmHZ4byEyvR2t/
3WGkfeL4P23r0QwLZLvH8Td9CL0WrQV/OyObJB2dx2xbi3LNP5bHP8/MnXdq
spE7kuCJfgrPO9XC7nAcxXMjXVB4FZYs8RHMFsMKgv/UqBWz9Kpdtt37KpDv
lVL+hUGRDxoWkJVwRq7s8JnfrOQ8Xm9jS6nudgCfKcx3AzzDwv/O53Id0zPi
oeel3wgqTd35pv6FaIuJdbgB+ePbCnwbz6oGntxuZktIN++8SNl5zTsn460/
N3aUoxkPmmovwxOgxlTfIfxNAGFZl7slhRch1Mu7ID5/YbTm2fHEa1LIxkzQ
dRgTWNeQdFNjn4SuEe9Yc07JB2k9ViEhKkuXUpv0OxZhkcWiq9RY2qrQZpV/
xScrxymlD1QkOfzx4uCHZ0+/iwcmTqzXX8lD973wf9yzf4cVsG+whnU57gVr
1zUrKfgLnVBM3A==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.2.2",
 CellLabel->"Out[48]=",
 CellID->7209322]
}, Open  ]],

Cell["\<\
The following table summarizes the options you can use with quasi-Newton \
methods.\
\>", "Text",
 ShowCellBracket->True,
 CellTags->"b:0.2.2",
 CellID->2069182195],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    ""},
   {"\"\<StepMemory\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "the effective number of steps to \"remember\" in the Hessian \
approximation, can be a positive integer or ",
     Cell[BoxData[
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"]], "InlineFormula"]
    }], "TableText"]},
   {"\"\<StepControl\>\"", "\"\<LineSearch\>\"", Cell[TextData[{
     "how to control steps, can be ",
     Cell[BoxData["\"\<LineSearch\>\""], "InlineFormula"],
     " or ",
     Cell[BoxData[
      ButtonBox["None",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/None"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, 
     AbsoluteThickness[0.5], {False}, False}, "RowsIndexed" -> {}}},
 CellTags->"b:0.2.3",
 CellID->204030633],

Cell[TextData[{
 "Method options for ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Method",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Method"], "->", "\"\<QuasiNewton\>\""}]], 
  "InlineFormula"],
 ". "
}], "Caption",
 ShowCellBracket->True,
 CellTags->"b:0.2.2",
 CellID->419879652],

Cell[CellGroupData[{

Cell["MORE ABOUT", "TutorialMoreAboutSection",
 CellID->32273520],

Cell[TextData[ButtonBox["Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Optimization"]], "TutorialMoreAbout",
 CellID->48539711],

Cell[TextData[ButtonBox["Matrix-Based Minimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixBasedMinimization"]], "TutorialMoreAbout",
 CellID->21321],

Cell[TextData[ButtonBox["Curve Fitting & Approximate Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/CurveFittingAndApproximateFunctions"]], "TutorialMoreAbout",
 CellID->776025961]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->304865425],

Cell[TextData[ButtonBox["Unconstrained Optimization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/UnconstrainedOptimizationOverview"]], "RelatedTutorials",
 CellID->20683583]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Quasi-Newton Methods - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 45, 12.3296134}", "context" -> 
    "Optimization`UnconstrainedProblems`", "keywords" -> {}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "There are many variants of quasi-Newton methods. In all of them, the \
idea is to base the matrix B_k in the quadratic model on an approximation of \
the Hessian matrix built up from the function and gradient values from some \
or all steps previously taken. This loads a package that contains some \
utility functions", "synonyms" -> {}, "title" -> "Quasi-Newton Methods", 
    "type" -> "Tutorial", "uri" -> 
    "tutorial/UnconstrainedOptimizationQuasiNewtonMethods"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "b:0.2.2"->{
  Cell[2294, 70, 297, 10, 70, "Text",
   CellTags->"b:0.2.2",
   CellID->1891212404],
  Cell[3175, 104, 221, 6, 70, "Text",
   CellTags->"b:0.2.2",
   CellID->432023036],
  Cell[3678, 123, 464, 12, 70, "MathCaption",
   CellTags->"b:0.2.2",
   CellID->701414781],
  Cell[4167, 139, 615, 21, 28, "Input",
   CellTags->"b:0.2.2",
   CellID->1140485884],
  Cell[4785, 162, 461378, 7621, 230, "Output",
   CellTags->"b:0.2.2",
   CellID->1958341651],
  Cell[466178, 7786, 524, 10, 70, "Text",
   CellTags->"b:0.2.2",
   CellID->1801110191],
  Cell[466705, 7798, 795, 26, 70, "Text",
   CellTags->"b:0.2.2",
   CellID->329492025],
  Cell[467503, 7826, 1279, 49, 70, "Text",
   CellTags->"b:0.2.2",
   CellID->1559622209],
  Cell[468785, 7877, 2112, 60, 70, "Text",
   CellTags->"b:0.2.2",
   CellID->385071381],
  Cell[470900, 7939, 275, 10, 70, "MathCaption",
   CellTags->"b:0.2.2",
   CellID->1526472056],
  Cell[471200, 7953, 792, 26, 70, "Input",
   CellTags->"b:0.2.2",
   CellID->1576198130],
  Cell[471995, 7981, 57793, 3436, 70, 50731, 3314, "GraphicsData", 
  "PostScript", "Graphics",
   CellTags->"b:0.2.2",
   CellID->1951185165],
  Cell[529791, 11419, 821, 27, 54, "Output",
   CellTags->"b:0.2.2",
   CellID->1493778465],
  Cell[530627, 11449, 829, 21, 70, "Text",
   CellTags->"b:0.2.2",
   CellID->1850827825],
  Cell[531459, 11472, 620, 19, 70, "DisplayMath",
   CellTags->"b:0.2.2",
   CellID->562627980],
  Cell[532082, 11493, 447, 14, 70, "Text",
   CellTags->"b:0.2.2",
   CellID->717962119],
  Cell[532532, 11509, 225, 6, 70, "MathCaption",
   CellTags->"b:0.2.2",
   CellID->1985213605],
  Cell[532782, 11519, 1882, 51, 70, "Input",
   CellTags->"b:0.2.2",
   CellID->31635796],
  Cell[534667, 11572, 328, 9, 70, "Print",
   CellTags->"b:0.2.2",
   CellID->1274362563],
  Cell[534998, 11583, 200, 6, 36, "Output",
   CellTags->"b:0.2.2",
   CellID->1357184810],
  Cell[535213, 11592, 348, 8, 70, "Text",
   CellTags->"b:0.2.2",
   CellID->1781286883],
  Cell[535564, 11602, 301, 7, 70, "MathCaption",
   CellTags->"b:0.2.2",
   CellID->838874921],
  Cell[535890, 11613, 1405, 44, 65, "Input",
   CellTags->"b:0.2.2",
   CellID->740654692],
  Cell[537298, 11659, 1775, 34, 123, "Output",
   Evaluatable->False,
   CellTags->"b:0.2.2",
   CellID->7209322],
  Cell[539088, 11696, 174, 6, 70, "Text",
   CellTags->"b:0.2.2",
   CellID->2069182195],
  Cell[540359, 11735, 289, 12, 70, "Caption",
   CellTags->"b:0.2.2",
   CellID->419879652]},
 "QuadraticModel"->{
  Cell[2594, 82, 578, 20, 70, "DisplayMath",
   CellTags->{"QuadraticModel", "b:0.1"},
   CellID->617710400]},
 "b:0.1"->{
  Cell[2594, 82, 578, 20, 70, "DisplayMath",
   CellTags->{"QuadraticModel", "b:0.1"},
   CellID->617710400]},
 "b:0.2.3"->{
  Cell[539265, 11704, 1091, 29, 70, "DefinitionBox3Col",
   CellTags->"b:0.2.3",
   CellID->204030633]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"b:0.2.2", 543167, 11822},
 {"QuadraticModel", 545646, 11903},
 {"b:0.1", 545769, 11907},
 {"b:0.2.3", 545894, 11911}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1609, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2234, 67, 57, 1, 70, "Title",
 CellID->509267359],
Cell[2294, 70, 297, 10, 70, "Text",
 CellTags->"b:0.2.2",
 CellID->1891212404],
Cell[2594, 82, 578, 20, 70, "DisplayMath",
 CellTags->{"QuadraticModel", "b:0.1"},
 CellID->617710400],
Cell[3175, 104, 221, 6, 70, "Text",
 CellTags->"b:0.2.2",
 CellID->432023036],
Cell[3399, 112, 155, 4, 70, "MathCaption",
 CellID->18098],
Cell[3557, 118, 118, 3, 70, "Input",
 CellID->23546],
Cell[3678, 123, 464, 12, 70, "MathCaption",
 CellTags->"b:0.2.2",
 CellID->701414781],
Cell[CellGroupData[{
Cell[4167, 139, 615, 21, 28, "Input",
 CellTags->"b:0.2.2",
 CellID->1140485884],
Cell[4785, 162, 461378, 7621, 230, "Output",
 CellTags->"b:0.2.2",
 CellID->1958341651]
}, Open  ]],
Cell[466178, 7786, 524, 10, 70, "Text",
 CellTags->"b:0.2.2",
 CellID->1801110191],
Cell[466705, 7798, 795, 26, 70, "Text",
 CellTags->"b:0.2.2",
 CellID->329492025],
Cell[467503, 7826, 1279, 49, 70, "Text",
 CellTags->"b:0.2.2",
 CellID->1559622209],
Cell[468785, 7877, 2112, 60, 70, "Text",
 CellTags->"b:0.2.2",
 CellID->385071381],
Cell[470900, 7939, 275, 10, 70, "MathCaption",
 CellTags->"b:0.2.2",
 CellID->1526472056],
Cell[CellGroupData[{
Cell[471200, 7953, 792, 26, 70, "Input",
 CellTags->"b:0.2.2",
 CellID->1576198130],
Cell[471995, 7981, 57793, 3436, 70, 50731, 3314, "GraphicsData", \
"PostScript", "Graphics",
 CellTags->"b:0.2.2",
 CellID->1951185165],
Cell[529791, 11419, 821, 27, 54, "Output",
 CellTags->"b:0.2.2",
 CellID->1493778465]
}, Open  ]],
Cell[530627, 11449, 829, 21, 70, "Text",
 CellTags->"b:0.2.2",
 CellID->1850827825],
Cell[531459, 11472, 620, 19, 70, "DisplayMath",
 CellTags->"b:0.2.2",
 CellID->562627980],
Cell[532082, 11493, 447, 14, 70, "Text",
 CellTags->"b:0.2.2",
 CellID->717962119],
Cell[532532, 11509, 225, 6, 70, "MathCaption",
 CellTags->"b:0.2.2",
 CellID->1985213605],
Cell[CellGroupData[{
Cell[532782, 11519, 1882, 51, 70, "Input",
 CellTags->"b:0.2.2",
 CellID->31635796],
Cell[534667, 11572, 328, 9, 70, "Print",
 CellTags->"b:0.2.2",
 CellID->1274362563],
Cell[534998, 11583, 200, 6, 36, "Output",
 CellTags->"b:0.2.2",
 CellID->1357184810]
}, Open  ]],
Cell[535213, 11592, 348, 8, 70, "Text",
 CellTags->"b:0.2.2",
 CellID->1781286883],
Cell[535564, 11602, 301, 7, 70, "MathCaption",
 CellTags->"b:0.2.2",
 CellID->838874921],
Cell[CellGroupData[{
Cell[535890, 11613, 1405, 44, 65, "Input",
 CellTags->"b:0.2.2",
 CellID->740654692],
Cell[537298, 11659, 1775, 34, 123, "Output",
 Evaluatable->False,
 CellTags->"b:0.2.2",
 CellID->7209322]
}, Open  ]],
Cell[539088, 11696, 174, 6, 70, "Text",
 CellTags->"b:0.2.2",
 CellID->2069182195],
Cell[539265, 11704, 1091, 29, 70, "DefinitionBox3Col",
 CellTags->"b:0.2.3",
 CellID->204030633],
Cell[540359, 11735, 289, 12, 70, "Caption",
 CellTags->"b:0.2.2",
 CellID->419879652],
Cell[CellGroupData[{
Cell[540673, 11751, 65, 1, 70, "TutorialMoreAboutSection",
 CellID->32273520],
Cell[540741, 11754, 143, 3, 70, "TutorialMoreAbout",
 CellID->48539711],
Cell[540887, 11759, 164, 3, 70, "TutorialMoreAbout",
 CellID->21321],
Cell[541054, 11764, 195, 4, 70, "TutorialMoreAbout",
 CellID->776025961]
}, Open  ]],
Cell[CellGroupData[{
Cell[541286, 11773, 72, 1, 70, "RelatedTutorialsSection",
 CellID->304865425],
Cell[541361, 11776, 183, 4, 70, "RelatedTutorials",
 CellID->20683583]
}, Open  ]]
}, Open  ]],
Cell[541571, 11784, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

