(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12368,        414]
NotebookOptionsPosition[      6053,        213]
NotebookOutlinePosition[     10872,        363]
CellTagsIndexPosition[     10530,        346]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Unconstrained Optimization" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/UnconstrainedOptimizationOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Unconstrained Optimization\"\>"}, "\<\"related tutorials\"\>", 
       
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Optimization" :> 
          Documentation`HelpLookup["paclet:guide/Optimization"], 
          "Matrix-Based Minimization" :> 
          Documentation`HelpLookup["paclet:guide/MatrixBasedMinimization"], 
          "Curve Fitting & Approximate Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/CurveFittingAndApproximateFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Optimization\"\>", 
       2->"\<\"Matrix-Based Minimization\"\>", 
       3->"\<\"Curve Fitting & Approximate Functions\"\>"}, "\<\"more about\"\
\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["References", "Title",
 CellTags->{"t:29", "c:29", "b:0.7"},
 CellID->929625783],

Cell[TextData[{
 "[AN96] L. Adams and J. L. Nazereth eds. ",
 StyleBox["Linear and Nonlinear Conjugate Gradient-Related Methods",
  FontSlant->"Italic"],
 ", Philadelphia: SIAM, 1996."
}], "Text",
 CellTags->{"AN96", "b:0.7"},
 CellID->1277002956],

Cell[TextData[{
 "[Br02] R. P. Brent, ",
 StyleBox["Algorithms for Minimization without Derivatives",
  FontSlant->"Italic"],
 ", New York: Dover, 2002 (Original volume 1973)."
}], "Text",
 CellTags->{"Br02", "b:0.7"},
 CellID->637113374],

Cell[TextData[{
 "[DS96] J. E. Dennis and R. B. Schnabel, ",
 StyleBox["Numerical Methods for Unconstrained Optimization",
  FontSlant->"Italic"],
 ", Philadelphia: SIAM, 1996 (Original volume 1983)."
}], "Text",
 CellTags->{"DS96", "b:0.7"},
 CellID->611012876],

Cell[TextData[{
 "[GMW81] P. E. Gill, W. Murray, and M. H. Wright, ",
 StyleBox["Practical Optimization",
  FontSlant->"Italic"],
 ", San Diego: Academic Press, 1981."
}], "Text",
 CellTags->{"GMW81", "b:0.7"},
 CellID->26606978],

Cell[TextData[{
 "[MW93] J. J. More and S. J. Wright, ",
 StyleBox["Optimization Software Guide",
  FontSlant->"Italic"],
 ", Philadelphia: SIAM, 1993."
}], "Text",
 CellTags->{"MW93", "b:0.7"},
 CellID->506880670],

Cell[TextData[{
 "[MT94] J. J. More and D. J. Thuente, \[OpenCurlyDoubleQuote]Line Search \
Algorithms with Guaranteed Sufficient Decrease,\[CloseCurlyDoubleQuote] ",
 StyleBox["ACM",
  FontSlant->"Italic"],
 " ",
 StyleBox["Transactions on Mathematical Software",
  FontSlant->"Italic"],
 ", ",
 StyleBox["20",
  FontWeight->"Bold"],
 ", 1994."
}], "Text",
 CellTags->{"MT94", "b:0.7"},
 CellID->75793041],

Cell[TextData[{
 "[MGH81] J.J. More, B.S. Garbow, K.E. Hillstrom, \
\[OpenCurlyDoubleQuote]Testing Unconstrained Optimization Software,\
\[CloseCurlyDoubleQuote] ",
 StyleBox["ACM ",
  FontSlant->"Italic"],
 StyleBox["Transactions on Mathematical Software",
  FontSlant->"Italic"],
 ", ",
 StyleBox["7",
  FontWeight->"Bold"],
 "(1), 1981 pp. 17-41."
}], "Text",
 CellTags->{"MGH81", "b:0.7"},
 CellID->395837416],

Cell[TextData[{
 "[NW99] J. Nocedal and S. J. Wright, ",
 StyleBox["Numerical Optimization",
  FontSlant->"Italic"],
 ", New York: Springer, 1999"
}], "Text",
 CellTags->{"NW99", "b:0.7"},
 CellID->2082595953],

Cell[TextData[{
 "[PTVF92] W. H. Press, S. A. Teukolsky, W. T. Vetterling, and B. P. \
Flannery, ",
 StyleBox["Numerical Recipes in C",
  FontSlant->"Italic"],
 ", 2nd ed., New York: Cambridge University Press, 1992."
}], "Text",
 CellTags->{"PTVF92", "b:0.7"},
 CellID->354219618],

Cell[TextData[{
 "[Rhein98] W. C. Rheinboldt, ",
 StyleBox["Methods for Solving Systems of Nonlinear Equations",
  FontSlant->"Italic"],
 ", Philadelphia: SIAM, 1998 (Original volume 1974)."
}], "Text",
 CellTags->{"Rhein98", "b:0.7"},
 CellID->544450242],

Cell[CellGroupData[{

Cell["MORE ABOUT", "TutorialMoreAboutSection",
 CellID->561076514],

Cell[TextData[ButtonBox["Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Optimization"]], "TutorialMoreAbout",
 CellID->48539711],

Cell[TextData[ButtonBox["Matrix-Based Minimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixBasedMinimization"]], "TutorialMoreAbout",
 CellID->21321],

Cell[TextData[ButtonBox["Curve Fitting & Approximate Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/CurveFittingAndApproximateFunctions"]], "TutorialMoreAbout",
 CellID->371088505]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->48117461],

Cell[TextData[ButtonBox["Unconstrained Optimization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/UnconstrainedOptimizationOverview"]], "RelatedTutorials",
 CellID->20683583]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"References - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Unconstrained Optimization", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/UnconstrainedOptimizationOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/UnconstrainedOptimizationIntroduction#509267359"]}],
       "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 45, 13.9390296}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "[AN96] L. Adams and J. L. Nazereth eds. Linear and Nonlinear Conjugate \
Gradient-Related Methods, Philadelphia: SIAM, 1996. [Br02] R. P. Brent, \
Algorithms for Minimization without Derivatives, New York: Dover, 2002 \
(Original volume 1973). [DS96] J. E. Dennis and R. B. Schnabel, Numerical \
Methods for Unconstrained Optimization, Philadelphia: SIAM, 1996 (Original \
volume 1983).", "synonyms" -> {}, "title" -> "References", "type" -> 
    "Tutorial", "uri" -> "tutorial/UnconstrainedOptimizationReferences"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "t:29"->{
  Cell[2234, 67, 85, 2, 70, "Title",
   CellTags->{"t:29", "c:29", "b:0.7"},
   CellID->929625783]},
 "c:29"->{
  Cell[2234, 67, 85, 2, 70, "Title",
   CellTags->{"t:29", "c:29", "b:0.7"},
   CellID->929625783]},
 "b:0.7"->{
  Cell[2234, 67, 85, 2, 70, "Title",
   CellTags->{"t:29", "c:29", "b:0.7"},
   CellID->929625783],
  Cell[2322, 71, 247, 7, 70, "Text",
   CellTags->{"AN96", "b:0.7"},
   CellID->1277002956],
  Cell[2572, 80, 238, 7, 70, "Text",
   CellTags->{"Br02", "b:0.7"},
   CellID->637113374],
  Cell[2813, 89, 262, 7, 70, "Text",
   CellTags->{"DS96", "b:0.7"},
   CellID->611012876],
  Cell[3078, 98, 229, 7, 70, "Text",
   CellTags->{"GMW81", "b:0.7"},
   CellID->26606978],
  Cell[3310, 107, 214, 7, 70, "Text",
   CellTags->{"MW93", "b:0.7"},
   CellID->506880670],
  Cell[3527, 116, 406, 14, 70, "Text",
   CellTags->{"MT94", "b:0.7"},
   CellID->75793041],
  Cell[3936, 132, 413, 14, 70, "Text",
   CellTags->{"MGH81", "b:0.7"},
   CellID->395837416],
  Cell[4352, 148, 209, 7, 70, "Text",
   CellTags->{"NW99", "b:0.7"},
   CellID->2082595953],
  Cell[4564, 157, 281, 8, 70, "Text",
   CellTags->{"PTVF92", "b:0.7"},
   CellID->354219618],
  Cell[4848, 167, 255, 7, 70, "Text",
   CellTags->{"Rhein98", "b:0.7"},
   CellID->544450242]},
 "AN96"->{
  Cell[2322, 71, 247, 7, 70, "Text",
   CellTags->{"AN96", "b:0.7"},
   CellID->1277002956]},
 "Br02"->{
  Cell[2572, 80, 238, 7, 70, "Text",
   CellTags->{"Br02", "b:0.7"},
   CellID->637113374]},
 "DS96"->{
  Cell[2813, 89, 262, 7, 70, "Text",
   CellTags->{"DS96", "b:0.7"},
   CellID->611012876]},
 "GMW81"->{
  Cell[3078, 98, 229, 7, 70, "Text",
   CellTags->{"GMW81", "b:0.7"},
   CellID->26606978]},
 "MW93"->{
  Cell[3310, 107, 214, 7, 70, "Text",
   CellTags->{"MW93", "b:0.7"},
   CellID->506880670]},
 "MT94"->{
  Cell[3527, 116, 406, 14, 70, "Text",
   CellTags->{"MT94", "b:0.7"},
   CellID->75793041]},
 "MGH81"->{
  Cell[3936, 132, 413, 14, 70, "Text",
   CellTags->{"MGH81", "b:0.7"},
   CellID->395837416]},
 "NW99"->{
  Cell[4352, 148, 209, 7, 70, "Text",
   CellTags->{"NW99", "b:0.7"},
   CellID->2082595953]},
 "PTVF92"->{
  Cell[4564, 157, 281, 8, 70, "Text",
   CellTags->{"PTVF92", "b:0.7"},
   CellID->354219618]},
 "Rhein98"->{
  Cell[4848, 167, 255, 7, 70, "Text",
   CellTags->{"Rhein98", "b:0.7"},
   CellID->544450242]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"t:29", 8184, 261},
 {"c:29", 8296, 265},
 {"b:0.7", 8409, 269},
 {"AN96", 9456, 303},
 {"Br02", 9561, 307},
 {"DS96", 9665, 311},
 {"GMW81", 9770, 315},
 {"MW93", 9874, 319},
 {"MT94", 9979, 323},
 {"MGH81", 10085, 327},
 {"NW99", 10192, 331},
 {"PTVF92", 10300, 335},
 {"Rhein98", 10410, 339}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1609, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2234, 67, 85, 2, 70, "Title",
 CellTags->{"t:29", "c:29", "b:0.7"},
 CellID->929625783],
Cell[2322, 71, 247, 7, 70, "Text",
 CellTags->{"AN96", "b:0.7"},
 CellID->1277002956],
Cell[2572, 80, 238, 7, 70, "Text",
 CellTags->{"Br02", "b:0.7"},
 CellID->637113374],
Cell[2813, 89, 262, 7, 70, "Text",
 CellTags->{"DS96", "b:0.7"},
 CellID->611012876],
Cell[3078, 98, 229, 7, 70, "Text",
 CellTags->{"GMW81", "b:0.7"},
 CellID->26606978],
Cell[3310, 107, 214, 7, 70, "Text",
 CellTags->{"MW93", "b:0.7"},
 CellID->506880670],
Cell[3527, 116, 406, 14, 70, "Text",
 CellTags->{"MT94", "b:0.7"},
 CellID->75793041],
Cell[3936, 132, 413, 14, 70, "Text",
 CellTags->{"MGH81", "b:0.7"},
 CellID->395837416],
Cell[4352, 148, 209, 7, 70, "Text",
 CellTags->{"NW99", "b:0.7"},
 CellID->2082595953],
Cell[4564, 157, 281, 8, 70, "Text",
 CellTags->{"PTVF92", "b:0.7"},
 CellID->354219618],
Cell[4848, 167, 255, 7, 70, "Text",
 CellTags->{"Rhein98", "b:0.7"},
 CellID->544450242],
Cell[CellGroupData[{
Cell[5128, 178, 66, 1, 70, "TutorialMoreAboutSection",
 CellID->561076514],
Cell[5197, 181, 143, 3, 70, "TutorialMoreAbout",
 CellID->48539711],
Cell[5343, 186, 164, 3, 70, "TutorialMoreAbout",
 CellID->21321],
Cell[5510, 191, 195, 4, 70, "TutorialMoreAbout",
 CellID->371088505]
}, Open  ]],
Cell[CellGroupData[{
Cell[5742, 200, 71, 1, 70, "RelatedTutorialsSection",
 CellID->48117461],
Cell[5816, 203, 183, 4, 70, "RelatedTutorials",
 CellID->20683583]
}, Open  ]]
}, Open  ]],
Cell[6026, 211, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

