(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13189,        388]
NotebookOptionsPosition[      8507,        273]
NotebookOutlinePosition[     12441,        361]
CellTagsIndexPosition[     12350,        355]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Using the Mathematica System" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/UsingTheMathematicaSystemOverview"], 
          "Mathematica Sessions" :> 
          Documentation`HelpLookup["paclet:tutorial/MathematicaSessions"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Using the Mathematica System\"\>", 
       2->"\<\"Mathematica Sessions\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"In" :> Documentation`HelpLookup["paclet:ref/In"], "InString" :> 
          Documentation`HelpLookup["paclet:ref/InString"], "Out" :> 
          Documentation`HelpLookup["paclet:ref/Out"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"In\"\>", 2->"\<\"InString\"\>", 
       3->"\<\"Out\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Using a Text\[Hyphen]Based Interface", "Title",
 CellTags->{"S1.3.3", "3.1"},
 CellID->85],

Cell[TextData[{
 "With a text\[Hyphen]based interface, you interact with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " just by typing successive lines of input, and getting back successive \
lines of output on your screen. "
}], "Text",
 CellID->8764],

Cell[TextData[{
 "At each stage, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " prints a prompt of the form ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["In",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/In"], "[", 
    StyleBox["n", "TI"], "]"}], ":="}]], "InlineFormula"],
 " to tell you that it is ready to receive input. When you have entered your \
input, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " processes it, and then displays the result with a label of the form ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Out",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Out"], "[", 
    StyleBox["n", "TI"], "]"}], "="}]], "InlineFormula"],
 "."
}], "Text",
 CellID->7234],

Cell[TextData[{
 "If your input is short, then you can give it on a single line, ending the \
line by pressing Enter or Return. If your input is longer, you can give it on \
several lines. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will automatically continue reading successive lines until it has received \
a complete expression. Thus, for example, if you type an opening parenthesis \
on one line, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will go on reading successive lines of input until it sees the \
corresponding closing parenthesis. Note that if you enter a completely blank \
line, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will throw away the lines you have typed so far, and issue a new input \
prompt."
}], "Text",
 CellID->17076],

Cell[BoxData[GridBox[{
   {
    RowBox[{"%", 
     StyleBox["n", "TI"], Cell[" \[ThinSpace]or \[ThinSpace]", "TableText"], 
     ButtonBox["Out",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Out"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "the value of the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula"],
     " output"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["InString",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InString"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "the text of the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula"],
     " input"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["In",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/In"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula"],
     " input, for re\[Hyphen]evaluation"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->14015],

Cell["\<\
Retrieving and re\[Hyphen]evaluating previous input and output. \
\>", "Caption",
 CellID->30118],

Cell[TextData[{
 "With a text\[Hyphen]based interface, each line of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input and output appears sequentially. Often your computer system will \
allow you to scroll backwards to review previous work, and to cut\[Hyphen]and\
\[Hyphen]paste previous lines of input. "
}], "Text",
 CellID->13384],

Cell[TextData[{
 "But whatever kind of computer system you have, you can always use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to retrieve or re\[Hyphen]evaluate previous input and output. In general, \
re\[Hyphen]evaluating a particular piece of input or output may give you a \
different result than when you evaluated it in the first place. The reason is \
that in between you may have reset the values of variables that are used in \
that piece of input or output. If you ask for ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Out",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Out"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 ", then ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will give you the final form of your ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineMath"],
 " output. On the other hand, if you ask for ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["In",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/In"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 ", then ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will take the ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineMath"],
 " input you gave, and re\[Hyphen]evaluate it using whatever current \
assignments you have given for variables. "
}], "Text",
 CellID->24847],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->78036867],

Cell[TextData[{
 ButtonBox["Using the ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/UsingTheMathematicaSystemOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/UsingTheMathematicaSystemOverview"],
  FontSlant->"Italic"],
 ButtonBox[" System",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/UsingTheMathematicaSystemOverview"]
}], "RelatedTutorials",
 CellID->344194261],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaSessions"],
  FontSlant->"Italic"],
 ButtonBox[" Sessions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaSessions"]
}], "RelatedTutorials",
 CellID->515861756]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Using a Text-Based Interface - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Using the Mathematica System", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/UsingTheMathematicaSystemOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DifferencesBetweenComputerSystems"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DoingComputationsInNotebooks"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 45, 41.8928702}", "context" -> "", 
    "keywords" -> {
     "backtracking", "calculations", "Commandline interface", "continuation", 
      "DOS", "textbased interface", "ending input", "entering input", 
      "evaluation", "expressions", "history", "in", "input", "InString", 
      "interface", "journaling", "lines", "Long input", "textbased interface",
       "newlines", "out", "prompts", "reading text input", 
      "redoing calculations", "replaying input", "re-running calculations", 
      "return", "reviewing results", "terminating input", 
      "text-based interface", "user interface", "what if investigations"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "With a text-based interface, you interact with Mathematica just by \
typing successive lines of input, and getting back successive lines of output \
on your screen. At each stage, Mathematica prints a prompt of the form \
In[n]:= to tell you that it is ready to receive input. When you have entered \
your input, Mathematica processes it, and then displays the result with a \
label of the form Out[n]=. If your input is short, then you can give it on a \
single line, ending the line by pressing Enter or Return. If your input is \
longer, you can give it on several lines. Mathematica will automatically \
continue reading successive lines until it has received a complete \
expression. Thus, for example, if you type an opening parenthesis on one \
line, Mathematica will go on reading successive lines of input until it sees \
the corresponding closing parenthesis. Note that if you enter a completely \
blank line, Mathematica will throw away the lines you have typed so far, and \
issue a new input prompt.", "synonyms" -> {"1.3.3"}, "title" -> 
    "Using a Text-Based Interface", "type" -> "Tutorial", "uri" -> 
    "tutorial/UsingATextBasedInterface"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.3.3"->{
  Cell[2145, 63, 96, 2, 70, "Title",
   CellTags->{"S1.3.3", "3.1"},
   CellID->85]},
 "3.1"->{
  Cell[2145, 63, 96, 2, 70, "Title",
   CellTags->{"S1.3.3", "3.1"},
   CellID->85]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.3.3", 12145, 344},
 {"3.1", 12241, 348}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1520, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2145, 63, 96, 2, 70, "Title",
 CellTags->{"S1.3.3", "3.1"},
 CellID->85],
Cell[2244, 67, 260, 7, 70, "Text",
 CellID->8764],
Cell[2507, 76, 727, 26, 70, "Text",
 CellID->7234],
Cell[3237, 104, 782, 19, 70, "Text",
 CellID->17076],
Cell[4022, 125, 1649, 52, 70, "DefinitionBox",
 CellID->14015],
Cell[5674, 179, 107, 3, 70, "Caption",
 CellID->30118],
Cell[5784, 184, 344, 8, 70, "Text",
 CellID->13384],
Cell[6131, 194, 1498, 43, 70, "Text",
 CellID->24847],
Cell[CellGroupData[{
Cell[7654, 241, 71, 1, 70, "RelatedTutorialsSection",
 CellID->78036867],
Cell[7728, 244, 431, 12, 70, "RelatedTutorials",
 CellID->344194261],
Cell[8162, 258, 291, 9, 70, "RelatedTutorials",
 CellID->515861756]
}, Open  ]]
}, Open  ]],
Cell[8480, 271, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

