(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     47068,       1773]
NotebookOptionsPosition[     37077,       1430]
NotebookOutlinePosition[     40054,       1504]
CellTagsIndexPosition[     39959,       1498]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AlgebraicManipulationOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Algebraic Manipulation\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraics" :> 
          Documentation`HelpLookup["paclet:ref/Algebraics"], "Assuming" :> 
          Documentation`HelpLookup["paclet:ref/Assuming"], "Booleans" :> 
          Documentation`HelpLookup["paclet:ref/Booleans"], "Complexes" :> 
          Documentation`HelpLookup["paclet:ref/Complexes"], "Element" :> 
          Documentation`HelpLookup["paclet:ref/Element"], "False" :> 
          Documentation`HelpLookup["paclet:ref/False"], "FullSimplify" :> 
          Documentation`HelpLookup["paclet:ref/FullSimplify"], 
          "FunctionExpand" :> 
          Documentation`HelpLookup["paclet:ref/FunctionExpand"], "Integers" :> 
          Documentation`HelpLookup["paclet:ref/Integers"], "Primes" :> 
          Documentation`HelpLookup["paclet:ref/Primes"], "Rationals" :> 
          Documentation`HelpLookup["paclet:ref/Rationals"], "Reals" :> 
          Documentation`HelpLookup["paclet:ref/Reals"], "Refine" :> 
          Documentation`HelpLookup["paclet:ref/Refine"], "Simplify" :> 
          Documentation`HelpLookup["paclet:ref/Simplify"], "True" :> 
          Documentation`HelpLookup["paclet:ref/True"], "$Assumptions" :> 
          Documentation`HelpLookup["paclet:ref/$Assumptions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Algebraics\"\>", 
       2->"\<\"Assuming\"\>", 3->"\<\"Booleans\"\>", 4->"\<\"Complexes\"\>", 
       5->"\<\"Element\"\>", 6->"\<\"False\"\>", 7->"\<\"FullSimplify\"\>", 
       8->"\<\"FunctionExpand\"\>", 9->"\<\"Integers\"\>", 
       10->"\<\"Primes\"\>", 11->"\<\"Rationals\"\>", 12->"\<\"Reals\"\>", 
       13->"\<\"Refine\"\>", 14->"\<\"Simplify\"\>", 15->"\<\"True\"\>", 
       16->"\<\"$Assumptions\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Using Assumptions", "Title",
 CellTags->{"S3.3.11", "11.1"},
 CellID->31833],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " normally makes as few assumptions as possible about the objects you ask it \
to manipulate. This means that the results it gives are as general as \
possible. But sometimes these results are considerably more complicated than \
they would be if more assumptions were made. "
}], "Text",
 CellID->16235],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Refine",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Refine"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["assum", "TI"], "]"}], Cell[TextData[{
     "refine ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " using assumptions"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Simplify",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Simplify"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["assum", "TI"], "]"}], Cell[
    "simplify with assumptions", "TableText"]},
   {
    RowBox[{
     ButtonBox["FullSimplify",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FullSimplify"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["assum", "TI"], "]"}], Cell[
    "full simplify with assumptions", "TableText"]},
   {
    RowBox[{
     ButtonBox["FunctionExpand",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FunctionExpand"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["assum", "TI"], "]"}], Cell[
    "function expand with assumptions", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->10287],

Cell["Doing operations with assumptions. ", "Caption",
 CellID->28393],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " by default does essentially nothing with this expression. "
}], "MathCaption",
 CellID->4827],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"Sqrt", "[", "x", "]"}]}], "-", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"1", "/", "x"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->3348],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SqrtBox[
    FractionBox["1", "x"]]}], "+", 
  FractionBox["1", 
   SqrtBox["x"]]}]], "Output",
 ImageSize->{84, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->16624]
}, Open  ]],

Cell[TextData[{
 "The reason is that its value is quite different for different choices of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->32692],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"x", "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3"}], ",", 
     RowBox[{"-", "2"}], ",", 
     RowBox[{"-", "1"}], ",", "1", ",", "2", ",", "3"}], "}"}]}]}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->11918],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", "\[ImaginaryI]"}], 
     SqrtBox["3"]]}], ",", 
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], " ", 
    SqrtBox["2"]}], ",", 
   RowBox[{
    RowBox[{"-", "2"}], " ", "\[ImaginaryI]"}], ",", "0", ",", "0", ",", 
   "0"}], "}"}]], "Output",
 ImageSize->{199, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->12800]
}, Open  ]],

Cell[TextData[{
 "With the assumption ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", ">", "0"}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " can immediately reduce the expression to 0. "
}], "MathCaption",
 CellID->17244],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", "x", "]"}]}], "-", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"1", "/", "x"}], "]"}]}], ",", 
   RowBox[{"x", ">", "0"}]}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->6431],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->9086]
}, Open  ]],

Cell[TextData[{
 "Without making assumptions about ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 ", nothing can be done. "
}], "MathCaption",
 CellID->9695],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"Log", "[", 
   RowBox[{"x", " ", "y"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->11508],

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"x", " ", "y"}], "]"}]], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->21753]
}, Open  ]],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " are both assumed positive, the log can be expanded. "
}], "MathCaption",
 CellID->11597],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"y", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->23192],

Cell[BoxData[
 RowBox[{
  RowBox[{"Log", "[", "x", "]"}], "+", 
  RowBox[{"Log", "[", "y", "]"}]}]], "Output",
 ImageSize->{101, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->31121]
}, Open  ]],

Cell[TextData[{
 "By applying ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " with appropriate assumptions to equations and inequalities you can in \
effect establish a vast range of theorems."
}], "Text",
 CellID->2819],

Cell[TextData[{
 "Without making assumptions about ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " the truth or falsity of this equation cannot be determined. "
}], "MathCaption",
 CellID->8907],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Abs", "[", "x", "]"}], "==", "x"}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->29071],

Cell[BoxData[
 RowBox[{"x", "\[Equal]", 
  RowBox[{"Abs", "[", "x", "]"}]}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->5022]
}, Open  ]],

Cell[TextData[{
 "Now ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " can prove that the equation is true. "
}], "MathCaption",
 CellID->20561],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", "x", "]"}], "==", "x"}], ",", 
   RowBox[{"x", ">", "0"}]}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->1991],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->22052]
}, Open  ]],

Cell["\<\
This establishes the standard result that the arithmetic mean is larger than \
the geometric one. \
\>", "MathCaption",
 CellID->5251],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "+", "y"}], ")"}], "/", "2"}], ">=", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"x", " ", "y"}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"x", ">=", "0"}], "&&", 
    RowBox[{"y", ">=", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->1523],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->28965]
}, Open  ]],

Cell[TextData[{
 "This proves that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"erf", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 " lies in the range ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"0", ",", "1"}], ")"}], TraditionalForm]], "InlineMath"],
 " for all positive arguments. "
}], "MathCaption",
 CellID->24956],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"0", "<", 
    RowBox[{"Erf", "[", "x", "]"}], "<", "1"}], ",", 
   RowBox[{"x", ">", "0"}]}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->26980],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->15061]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " always try to find the simplest forms of expressions. Sometimes, however, \
you may just want ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to follow its ordinary evaluation process, but with certain assumptions \
made. You can do this using ",
 Cell[BoxData[
  ButtonBox["Refine",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refine"]], "InlineFormula"],
 ". The way it works is that ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Refine",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Refine"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["assum", "TI"]}], "]"}]], "InlineFormula"],
 " performs the same transformations as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " would perform automatically if the variables in ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " were replaced by numerical expressions satisfying the assumptions ",
 Cell[BoxData[
  StyleBox["assum", "TI"]], "InlineFormula"],
 "."
}], "Text",
 CellID->28465],

Cell[TextData[{
 "There is no simpler form that ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " can find. "
}], "MathCaption",
 CellID->27523],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Log", "[", "x", "]"}], ",", 
   RowBox[{"x", "<", "0"}]}], "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->12300],

Cell[BoxData[
 RowBox[{"Log", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->25828]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Refine",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refine"]], "InlineFormula"],
 " just evaluates ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Log",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Log"], "[", "x", "]"}]], "InlineFormula"],
 " as it would for any explicit negative number\[NonBreakingSpace]",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->29235],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"Log", "[", "x", "]"}], ",", 
   RowBox[{"x", "<", "0"}]}], "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->27953],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "+", 
  RowBox[{"Log", "[", 
   RowBox[{"-", "x"}], "]"}]}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->24612]
}, Open  ]],

Cell[TextData[{
 "An important class of assumptions are those which assert that some object \
is an element of a particular domain. You can set up such assumptions using \
",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "\[Element]", 
   StyleBox["dom", "TI"]}]], "InlineFormula"],
 ", where the ",
 Cell[BoxData[
  FormBox["\[Element]", TraditionalForm]], "InlineMath"],
 " character can be entered as ",
 Cell[BoxData["\[AliasIndicator]el\[AliasIndicator]"], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", 
   RowBox[{"[", 
    ButtonBox["Element",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Element"], "]"}]}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->13682],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["x", "TI"], "\[Element]", 
     StyleBox["dom", "TI"], Cell["  or  ", "TableText"], 
     ButtonBox["Element",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Element"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["dom", "TI"], "]"}], Cell[TextData[{
     "assert that ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " is an element of the domain ",
     Cell[BoxData[
      StyleBox["dom", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "\[Element]", 
     StyleBox["dom", "TI"]}], Cell[TextData[{
     "assert that all the ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["x", "i"], TraditionalForm]], "InlineMath"],
     " are elements of the domain ",
     Cell[BoxData[
      StyleBox["dom", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["patt", "TI"], "\[Element]", 
     StyleBox["dom", "TI"]}], Cell[TextData[{
     "assert that any expression which matches ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"],
     " is an element of the domain ",
     Cell[BoxData[
      StyleBox["dom", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->23876],

Cell["Asserting that objects are elements of domains. ", "Caption",
 CellID->6157],

Cell[TextData[{
 "This confirms that ",
 Cell[BoxData[
  FormBox["\[Pi]", TraditionalForm]], "InlineMath"],
 " is an element of the domain of real numbers. "
}], "MathCaption",
 CellID->5289],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Pi", " ", "\[Element]", " ", "Reals"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->3292],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->15199]
}, Open  ]],

Cell["\<\
These numbers are all elements of the domain of algebraic numbers. \
\>", "MathCaption",
 CellID->1776],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"1", ",", 
    RowBox[{"Sqrt", "[", "2", "]"}], ",", 
    RowBox[{"3", "+", 
     RowBox[{"Sqrt", "[", "5", "]"}]}]}], "}"}], " ", "\[Element]", " ", 
  "Algebraics"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->2461],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->20842]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " knows that ",
 Cell[BoxData[
  FormBox["\[Pi]", TraditionalForm]], "InlineMath"],
 " is not an algebraic number. "
}], "MathCaption",
 CellID->19131],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Pi", " ", "\[Element]", " ", "Algebraics"}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->27660],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]= ",
 CellID->8700]
}, Open  ]],

Cell[TextData[{
 "Current mathematics has not established whether ",
 Cell[BoxData[
  FormBox[
   RowBox[{"e", "+", "\[Pi]"}], TraditionalForm]], "InlineMath"],
 " is an algebraic number or not. "
}], "MathCaption",
 CellID->11638],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"E", "+", "Pi"}], " ", "\[Element]", " ", "Algebraics"}]], "Input",
 CellLabel->"In[15]:= ",
 CellID->21080],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[ExponentialE]", "+", "\[Pi]"}], "\[Element]", 
  "Algebraics"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]= ",
 CellID->24620]
}, Open  ]],

Cell[TextData[{
 "This represents the assertion that the symbol ",
 Cell[BoxData["x"], "InlineFormula"],
 " is an element of the domain of real numbers. "
}], "MathCaption",
 CellID->2545],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", " ", "\[Element]", " ", "Reals"}]], "Input",
 CellLabel->"In[16]:= ",
 CellID->30929],

Cell[BoxData[
 RowBox[{"x", "\[Element]", "Reals"}]], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]= ",
 CellID->30168]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Complexes",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Complexes"], Cell[TextData[{
     "the domain of complex numbers ",
     Cell[BoxData[
      FormBox["\[DoubleStruckCapitalC]", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    ButtonBox["Reals",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Reals"], Cell[TextData[{
     "the domain of real numbers ",
     Cell[BoxData[
      FormBox["\[DoubleStruckCapitalR]", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    ButtonBox["Algebraics",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Algebraics"], Cell[TextData[{
     "the domain of algebraic numbers ",
     Cell[BoxData[
      FormBox["\[DoubleStruckCapitalA]", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    ButtonBox["Rationals",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Rationals"], Cell[TextData[{
     "the domain of rational numbers ",
     Cell[BoxData[
      FormBox["\[DoubleStruckCapitalQ]", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    ButtonBox["Integers",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Integers"], Cell[TextData[{
     "the domain of integers ",
     Cell[BoxData[
      FormBox["\[DoubleStruckCapitalZ]", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    ButtonBox["Primes",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Primes"], Cell[TextData[{
     "the domain of primes ",
     Cell[BoxData[
      FormBox["\[DoubleStruckCapitalP]", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    ButtonBox["Booleans",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Booleans"], Cell[TextData[{
     "the domain of Booleans (",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     ") ",
     Cell[BoxData[
      FormBox["\[DoubleStruckCapitalB]", TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->14141],

Cell[TextData[{
 "Domains supported by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->18762],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " is assumed to be an integer, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", "(", 
    RowBox[{"n", "\[InvisibleSpace]", "\[Pi]"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " is zero. "
}], "MathCaption",
 CellID->20834],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"n", " ", "Pi"}], "]"}], ",", 
   RowBox[{"n", " ", "\[Element]", " ", "Integers"}]}], "]"}]], "Input",
 CellLabel->"In[17]:= ",
 CellID->31633],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]= ",
 CellID->32270]
}, Open  ]],

Cell[TextData[{
 "This establishes the theorem ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"cosh", "(", "x", ")"}], "\[GreaterEqual]", "1"}], 
   TraditionalForm]], "InlineMath"],
 " if ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " is assumed to be a real number. "
}], "MathCaption",
 CellID->23082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cosh", "[", "x", "]"}], ">=", "1"}], ",", 
   RowBox[{"x", " ", "\[Element]", " ", "Reals"}]}], "]"}]], "Input",
 CellLabel->"In[18]:= ",
 CellID->10000],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]= ",
 CellID->14560]
}, Open  ]],

Cell[TextData[{
 "If you say that a variable satisfies an inequality, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will automatically assume that it is real. "
}], "MathCaption",
 CellID->1364],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"x", " ", "\[Element]", " ", "Reals"}], ",", 
   RowBox[{"x", ">", "0"}]}], "]"}]], "Input",
 CellLabel->"In[19]:= ",
 CellID->6141],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]= ",
 CellID->16099]
}, Open  ]],

Cell[TextData[{
 "By using ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " with assumptions you can access many of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s vast collection of mathematical facts. "
}], "Text",
 CellID->6336],

Cell["This uses the periodicity of the tangent function. ", "MathCaption",
 CellID->7665],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Tan", "[", 
    RowBox[{"x", "+", 
     RowBox[{"Pi", " ", "k"}]}], "]"}], ",", 
   RowBox[{"k", " ", "\[Element]", " ", "Integers"}]}], "]"}]], "Input",
 CellLabel->"In[20]:= ",
 CellID->6833],

Cell[BoxData[
 RowBox[{"Tan", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]= ",
 CellID->29029]
}, Open  ]],

Cell[TextData[{
 "The assumption ",
 Cell[BoxData[
  RowBox[{"k", "/", "2", " ", "\[Element]", " ", 
   ButtonBox["Integers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integers"]}]], "InlineFormula"],
 " implies that ",
 Cell[BoxData["k"], "InlineFormula"],
 " must be even. "
}], "MathCaption",
 CellID->28827],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Tan", "[", 
    RowBox[{"x", "+", 
     RowBox[{"Pi", " ", 
      RowBox[{"k", "/", "2"}]}]}], "]"}], ",", 
   RowBox[{
    RowBox[{"k", "/", "2"}], " ", "\[Element]", " ", "Integers"}]}], 
  "]"}]], "Input",
 CellLabel->"In[21]:= ",
 CellID->27254],

Cell[BoxData[
 RowBox[{"Tan", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]= ",
 CellID->21028]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " knows that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"log", "(", "x", ")"}], "<", 
    RowBox[{"exp", "(", "x", ")"}]}], TraditionalForm]], "InlineMath"],
 " for positive ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->10319],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Log", "[", "x", "]"}], "<", 
    RowBox[{"Exp", "[", "x", "]"}]}], ",", 
   RowBox[{"x", ">", "0"}]}], "]"}]], "Input",
 CellLabel->"In[22]:= ",
 CellID->5984],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]= ",
 CellID->27110]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " accesses knowledge about special functions. "
}], "MathCaption",
 CellID->24417],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"BesselJ", "[", 
     RowBox[{"0", ",", "x"}], "]"}], "]"}], ",", 
   RowBox[{"x", " ", "\[Element]", " ", "Reals"}]}], "]"}]], "Input",
 CellLabel->"In[23]:= ",
 CellID->29397],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]= ",
 CellID->8125]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " knows about discrete mathematics and number theory as well as continuous \
mathematics. "
}], "Text",
 CellID->7406],

Cell["\<\
This uses Wilson\[CloseCurlyQuote]s Theorem to simplify the result. \
\>", "MathCaption",
 CellID->11410],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{
   RowBox[{"Mod", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"p", "-", "1"}], ")"}], "!"}], ",", "p"}], "]"}], ",", 
   RowBox[{"p", " ", "\[Element]", " ", "Primes"}]}], "]"}]], "Input",
 CellLabel->"In[24]:= ",
 CellID->28463],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", "p"}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]= ",
 CellID->32048]
}, Open  ]],

Cell["\<\
This uses the multiplicative property of the Euler phi function. \
\>", "MathCaption",
 CellID->4690],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{
   RowBox[{"EulerPhi", "[", 
    RowBox[{"m", " ", "n"}], "]"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], " ", "\[Element]", " ", "Integers"}], "&&",
     
    RowBox[{
     RowBox[{"GCD", "[", 
      RowBox[{"m", ",", "n"}], "]"}], "==", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[25]:= ",
 CellID->4969],

Cell[BoxData[
 RowBox[{
  RowBox[{"EulerPhi", "[", "m", "]"}], " ", 
  RowBox[{"EulerPhi", "[", "n", "]"}]}]], "Output",
 ImageSize->{161, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]= ",
 CellID->5344]
}, Open  ]],

Cell[TextData[{
 "In something like ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Simplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Simplify"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["assum", "TI"]}], "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Refine",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Refine"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["assum", "TI"]}], "]"}]], "InlineFormula"],
 " you explicitly give the assumptions you want to use. But sometimes you may \
want to specify one set of assumptions to use in a whole collection of \
operations. You can do this by using ",
 Cell[BoxData[
  ButtonBox["Assuming",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assuming"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->28599],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Assuming",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Assuming"], "[", 
     StyleBox["assum", "TI"], ",", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "use assumptions ",
     Cell[BoxData[
      StyleBox["assum", "TI"]], "InlineFormula"],
     " in the evaluation of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    ButtonBox["$Assumptions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$Assumptions"], Cell[
    "the default assumptions to use", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->14643],

Cell["Specifying assumptions with larger scopes. ", "Caption",
 CellID->10155],

Cell[TextData[{
 "This tells ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " to use the default assumption ",
 Cell[BoxData[
  RowBox[{"x", ">", "0"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->12464],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"x", ">", "0"}], ",", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"x", "^", "2"}], "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[26]:= ",
 CellID->14537],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]= ",
 CellID->5558]
}, Open  ]],

Cell["This combines the two assumptions given. ", "MathCaption",
 CellID->17206],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"x", ">", "0"}], ",", 
   RowBox[{"Assuming", "[", 
    RowBox[{
     RowBox[{"x", " ", "\[Element]", " ", "Integers"}], ",", 
     RowBox[{"Refine", "[", 
      RowBox[{"Floor", "[", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"x", "^", "2"}], "]"}], "]"}], "]"}]}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[27]:= ",
 CellID->16911],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]= ",
 CellID->29414]
}, Open  ]],

Cell[TextData[{
 "Functions like ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Refine",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refine"]], "InlineFormula"],
 " take the option ",
 Cell[BoxData[
  ButtonBox["Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assumptions"]], "InlineFormula"],
 ", which specifies what default assumptions they should use. By default, the \
setting for this option is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Assumptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Assumptions"], ":>", 
   ButtonBox["$Assumptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Assumptions"]}]], "InlineFormula"],
 ". The way ",
 Cell[BoxData[
  ButtonBox["Assuming",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assuming"]], "InlineFormula"],
 " then works is to assign a local value to ",
 Cell[BoxData[
  ButtonBox["$Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Assumptions"]], "InlineFormula"],
 ", much as in ",
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 "."
}], "Text",
 CellID->19947],

Cell[TextData[{
 "In addition to ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Refine",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refine"]], "InlineFormula"],
 ", a number of other functions take ",
 Cell[BoxData[
  ButtonBox["Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assumptions"]], "InlineFormula"],
 " options, and thus can have assumptions specified for them by ",
 Cell[BoxData[
  ButtonBox["Assuming",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assuming"]], "InlineFormula"],
 ". Examples are ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Limit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Limit"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["LaplaceTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LaplaceTransform"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->21293],

Cell[TextData[{
 "The assumption is automatically used in ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->9129],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"n", ">", "0"}], ",", 
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"Integrate", "[", 
      RowBox[{
       RowBox[{"x", "^", "n"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}], "^", "2"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[28]:= ",
 CellID->26587],

Cell[BoxData[
 RowBox[{"1", "+", 
  FractionBox["1", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "n"}], ")"}], "2"]]}]], "Output",
 ImageSize->{74, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]= ",
 CellID->14080]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->74605452],

Cell[TextData[ButtonBox["Algebraic Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AlgebraicManipulationOverview"]], "RelatedTutorials",
 CellID->91103315]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Using Assumptions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Algebraic Manipulation", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/AlgebraicManipulationOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/Simplification"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 45, 40.9553462}", "context" -> "", 
    "keywords" -> {
     "Algebraics", "assertions", "assuming", "assumptions", "Booleans", 
      "complexes", "constraints", "domains", "domains for variables", 
      "evaluation", "facts", "number fields", "FullSimplify", 
      "FunctionExpand", "global assumptions", "integers", 
      "mathematical facts", "multiplicative properties", "number theory", 
      "predicates", "primes", "proofs", "rationals", "Reals", "refine", 
      "rings", "scope", "sets of numbers", "simplify", "theorems", 
      "type assumptions", "types", "variables", "Wilsons Theorem", 
      "assumptions"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Mathematica normally makes as few assumptions as possible about the \
objects you ask it to manipulate. This means that the results it gives are as \
general as possible. But sometimes these results are considerably more \
complicated than they would be if more assumptions were made. Doing \
operations with assumptions. Simplify by default does essentially nothing \
with this expression. ", "synonyms" -> {"3.3.11"}, "title" -> 
    "Using Assumptions", "type" -> "Tutorial", "uri" -> 
    "tutorial/UsingAssumptions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.3.11"->{
  Cell[3344, 80, 82, 2, 70, "Title",
   CellTags->{"S3.3.11", "11.1"},
   CellID->31833]},
 "11.1"->{
  Cell[3344, 80, 82, 2, 70, "Title",
   CellTags->{"S3.3.11", "11.1"},
   CellID->31833]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.3.11", 39743, 1487},
 {"11.1", 39845, 1491}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2719, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3344, 80, 82, 2, 70, "Title",
 CellTags->{"S3.3.11", "11.1"},
 CellID->31833],
Cell[3429, 84, 370, 8, 70, "Text",
 CellID->16235],
Cell[3802, 94, 1462, 45, 70, "DefinitionBox",
 CellID->10287],
Cell[5267, 141, 70, 1, 70, "Caption",
 CellID->28393],
Cell[5340, 144, 231, 7, 70, "MathCaption",
 CellID->4827],
Cell[CellGroupData[{
Cell[5596, 155, 237, 8, 28, "Input",
 CellID->3348],
Cell[5836, 165, 265, 11, 62, "Output",
 CellID->16624]
}, Open  ]],
Cell[6116, 179, 198, 6, 70, "MathCaption",
 CellID->32692],
Cell[CellGroupData[{
Cell[6339, 189, 266, 9, 28, "Input",
 CellID->11918],
Cell[6608, 200, 466, 17, 55, "Output",
 CellID->12800]
}, Open  ]],
Cell[7089, 220, 338, 12, 70, "MathCaption",
 CellID->17244],
Cell[CellGroupData[{
Cell[7452, 236, 289, 10, 70, "Input",
 CellID->6431],
Cell[7744, 248, 154, 5, 36, "Output",
 CellID->9086]
}, Open  ]],
Cell[7913, 256, 252, 9, 70, "MathCaption",
 CellID->9695],
Cell[CellGroupData[{
Cell[8190, 269, 161, 5, 70, "Input",
 CellID->11508],
Cell[8354, 276, 207, 7, 36, "Output",
 CellID->21753]
}, Open  ]],
Cell[8576, 286, 253, 9, 70, "MathCaption",
 CellID->11597],
Cell[CellGroupData[{
Cell[8854, 299, 261, 9, 70, "Input",
 CellID->23192],
Cell[9118, 310, 238, 8, 36, "Output",
 CellID->31121]
}, Open  ]],
Cell[9371, 321, 434, 14, 70, "Text",
 CellID->2819],
Cell[9808, 337, 216, 6, 70, "MathCaption",
 CellID->8907],
Cell[CellGroupData[{
Cell[10049, 347, 156, 5, 70, "Input",
 CellID->29071],
Cell[10208, 354, 213, 7, 36, "Output",
 CellID->5022]
}, Open  ]],
Cell[10436, 364, 220, 8, 70, "MathCaption",
 CellID->20561],
Cell[CellGroupData[{
Cell[10681, 376, 204, 7, 70, "Input",
 CellID->1991],
Cell[10888, 385, 158, 5, 36, "Output",
 CellID->22052]
}, Open  ]],
Cell[11061, 393, 144, 4, 70, "MathCaption",
 CellID->5251],
Cell[CellGroupData[{
Cell[11230, 401, 362, 13, 70, "Input",
 CellID->1523],
Cell[11595, 416, 158, 5, 36, "Output",
 CellID->28965]
}, Open  ]],
Cell[11768, 424, 337, 12, 70, "MathCaption",
 CellID->24956],
Cell[CellGroupData[{
Cell[12130, 440, 218, 7, 70, "Input",
 CellID->26980],
Cell[12351, 449, 158, 5, 36, "Output",
 CellID->15061]
}, Open  ]],
Cell[12524, 457, 1266, 40, 70, "Text",
 CellID->28465],
Cell[13793, 499, 219, 8, 70, "MathCaption",
 CellID->27523],
Cell[CellGroupData[{
Cell[14037, 511, 180, 6, 70, "Input",
 CellID->12300],
Cell[14220, 519, 185, 6, 36, "Output",
 CellID->25828]
}, Open  ]],
Cell[14420, 528, 439, 15, 70, "MathCaption",
 CellID->29235],
Cell[CellGroupData[{
Cell[14884, 547, 178, 6, 70, "Input",
 CellID->27953],
Cell[15065, 555, 266, 9, 36, "Output",
 CellID->24612]
}, Open  ]],
Cell[15346, 567, 702, 22, 70, "Text",
 CellID->13682],
Cell[16051, 591, 1427, 45, 70, "DefinitionBox",
 CellID->23876],
Cell[17481, 638, 82, 1, 70, "Caption",
 CellID->6157],
Cell[17566, 641, 191, 6, 70, "MathCaption",
 CellID->5289],
Cell[CellGroupData[{
Cell[17782, 651, 113, 3, 70, "Input",
 CellID->3292],
Cell[17898, 656, 159, 5, 36, "Output",
 CellID->15199]
}, Open  ]],
Cell[18072, 664, 113, 3, 70, "MathCaption",
 CellID->1776],
Cell[CellGroupData[{
Cell[18210, 671, 269, 9, 70, "Input",
 CellID->2461],
Cell[18482, 682, 159, 5, 36, "Output",
 CellID->20842]
}, Open  ]],
Cell[18656, 690, 217, 8, 70, "MathCaption",
 CellID->19131],
Cell[CellGroupData[{
Cell[18898, 702, 119, 3, 70, "Input",
 CellID->27660],
Cell[19020, 707, 159, 5, 36, "Output",
 CellID->8700]
}, Open  ]],
Cell[19194, 715, 231, 7, 70, "MathCaption",
 CellID->11638],
Cell[CellGroupData[{
Cell[19450, 726, 142, 4, 70, "Input",
 CellID->21080],
Cell[19595, 732, 241, 8, 36, "Output",
 CellID->24620]
}, Open  ]],
Cell[19851, 743, 188, 5, 70, "MathCaption",
 CellID->2545],
Cell[CellGroupData[{
Cell[20064, 752, 113, 3, 70, "Input",
 CellID->30929],
Cell[20180, 757, 191, 6, 36, "Output",
 CellID->30168]
}, Open  ]],
Cell[20386, 766, 2187, 68, 70, "DefinitionBox",
 CellID->14141],
Cell[22576, 836, 127, 6, 70, "Caption",
 CellID->18762],
Cell[22706, 844, 314, 12, 70, "MathCaption",
 CellID->20834],
Cell[CellGroupData[{
Cell[23045, 860, 232, 7, 70, "Input",
 CellID->31633],
Cell[23280, 869, 156, 5, 36, "Output",
 CellID->32270]
}, Open  ]],
Cell[23451, 877, 333, 12, 70, "MathCaption",
 CellID->23082],
Cell[CellGroupData[{
Cell[23809, 893, 230, 7, 70, "Input",
 CellID->10000],
Cell[24042, 902, 159, 5, 36, "Output",
 CellID->14560]
}, Open  ]],
Cell[24216, 910, 203, 6, 70, "MathCaption",
 CellID->1364],
Cell[CellGroupData[{
Cell[24444, 920, 195, 6, 70, "Input",
 CellID->6141],
Cell[24642, 928, 159, 5, 36, "Output",
 CellID->16099]
}, Open  ]],
Cell[24816, 936, 608, 21, 70, "Text",
 CellID->6336],
Cell[25427, 959, 89, 1, 70, "MathCaption",
 CellID->7665],
Cell[CellGroupData[{
Cell[25541, 964, 257, 8, 70, "Input",
 CellID->6833],
Cell[25801, 974, 185, 6, 36, "Output",
 CellID->29029]
}, Open  ]],
Cell[26001, 983, 320, 11, 70, "MathCaption",
 CellID->28827],
Cell[CellGroupData[{
Cell[26346, 998, 313, 11, 70, "Input",
 CellID->27254],
Cell[26662, 1011, 185, 6, 36, "Output",
 CellID->21028]
}, Open  ]],
Cell[26862, 1020, 357, 14, 70, "MathCaption",
 CellID->10319],
Cell[CellGroupData[{
Cell[27244, 1038, 236, 8, 70, "Input",
 CellID->5984],
Cell[27483, 1048, 159, 5, 36, "Output",
 CellID->27110]
}, Open  ]],
Cell[27657, 1056, 226, 7, 70, "MathCaption",
 CellID->24417],
Cell[CellGroupData[{
Cell[27908, 1067, 268, 8, 70, "Input",
 CellID->29397],
Cell[28179, 1077, 155, 5, 36, "Output",
 CellID->8125]
}, Open  ]],
Cell[28349, 1085, 184, 6, 70, "Text",
 CellID->7406],
Cell[28536, 1093, 115, 3, 70, "MathCaption",
 CellID->11410],
Cell[CellGroupData[{
Cell[28676, 1100, 311, 10, 70, "Input",
 CellID->28463],
Cell[28990, 1112, 196, 7, 36, "Output",
 CellID->32048]
}, Open  ]],
Cell[29201, 1122, 111, 3, 70, "MathCaption",
 CellID->4690],
Cell[CellGroupData[{
Cell[29337, 1129, 411, 14, 70, "Input",
 CellID->4969],
Cell[29751, 1145, 248, 8, 36, "Output",
 CellID->5344]
}, Open  ]],
Cell[30014, 1156, 835, 28, 70, "Text",
 CellID->28599],
Cell[30852, 1186, 919, 28, 70, "DefinitionBox",
 CellID->14643],
Cell[31774, 1216, 78, 1, 70, "Caption",
 CellID->10155],
Cell[31855, 1219, 288, 11, 70, "MathCaption",
 CellID->12464],
Cell[CellGroupData[{
Cell[32168, 1234, 244, 8, 70, "Input",
 CellID->14537],
Cell[32415, 1244, 155, 5, 36, "Output",
 CellID->5558]
}, Open  ]],
Cell[32585, 1252, 80, 1, 70, "MathCaption",
 CellID->17206],
Cell[CellGroupData[{
Cell[32690, 1257, 402, 13, 70, "Input",
 CellID->16911],
Cell[33095, 1272, 156, 5, 36, "Output",
 CellID->29414]
}, Open  ]],
Cell[33266, 1280, 1252, 43, 70, "Text",
 CellID->19947],
Cell[34521, 1325, 1327, 48, 70, "Text",
 CellID->21293],
Cell[35851, 1375, 221, 8, 70, "MathCaption",
 CellID->9129],
Cell[CellGroupData[{
Cell[36097, 1387, 362, 13, 70, "Input",
 CellID->26587],
Cell[36462, 1402, 275, 10, 54, "Output",
 CellID->14080]
}, Open  ]],
Cell[CellGroupData[{
Cell[36774, 1417, 71, 1, 70, "RelatedTutorialsSection",
 CellID->74605452],
Cell[36848, 1420, 175, 4, 70, "RelatedTutorials",
 CellID->91103315]
}, Open  ]]
}, Open  ]],
Cell[37050, 1428, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

