(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23348,        875]
NotebookOptionsPosition[     18881,        723]
NotebookOutlinePosition[     20267,        761]
CellTagsIndexPosition[     20224,        758]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Automatic" :> Documentation`HelpLookup["paclet:ref/Automatic"], 
         "Nearest" :> Documentation`HelpLookup["paclet:ref/Nearest"], 
         "NearestFunction" :> 
         Documentation`HelpLookup["paclet:ref/NearestFunction"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"Automatic\"\>", 2->"\<\"Nearest\"\>",
       3->"\<\"NearestFunction\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Using Nearest", "Title",
 CellID->2948],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Nearest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nearest"]], "InlineFormula"],
 " is used to find elements in a list that are closest to a given data \
point."
}], "Text",
 CellID->6916],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Nearest",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Nearest"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["elem", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["elem", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[TextData[{
     "give the list of ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["elem", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " to which ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " is nearest"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Nearest",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Nearest"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SubscriptBox[
          StyleBox["elem", "TI"], 
          StyleBox["1", "TR"]], "->", 
         SubscriptBox[
          StyleBox["v", "TI"], 
          StyleBox["1", "TR"]]}], ",", 
        RowBox[{
         SubscriptBox[
          StyleBox["elem", "TI"], 
          StyleBox["2", "TR"]], "->", 
         SubscriptBox[
          StyleBox["v", "TI"], 
          StyleBox["2", "TR"]]}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      StyleBox["x", "TI"]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     Cell[TextData[{
      "give the ",
      Cell[BoxData[
       SubscriptBox[
        StyleBox["v", "TI"], 
        StyleBox["i", "TI"]]], "InlineFormula"],
      " corresponding to the ",
      Cell[BoxData[
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["i", "TI"]]], "InlineFormula"],
      " to which ",
      Cell[BoxData[
       StyleBox["x", "TI"]], "InlineFormula"],
      " is nearest"
     }]],
     Cell[""]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Nearest",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Nearest"], "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["elem", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["elem", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "->", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["v", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["v", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], ",", 
      StyleBox["x", "TI"]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell["give the same result", "TableText"]},
   {
    RowBox[{
     ButtonBox["Nearest",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Nearest"], "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["elem", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["elem", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "->", 
       ButtonBox["Automatic",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Automatic"]}], ",", 
      StyleBox["x", "TI"]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "take the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " to be the integers 1, 2, 3, ",
     Cell[BoxData[
      StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Nearest",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Nearest"], "[", 
     RowBox[{
      StyleBox["data", "TI"], ",", 
      StyleBox["x", "TI"], ",", 
      StyleBox["n", "TI"]}], "]"}], Cell[TextData[{
     "give the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " nearest elements to ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Nearest",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Nearest"], "[", 
     RowBox[{
      StyleBox["data", "TI"], ",", 
      StyleBox["x", "TI"], ",", 
      RowBox[{"{", 
       StyleBox[
        RowBox[{"n", ",", "r"}], "TI"], "}"}]}], "]"}], Cell[TextData[{
     "give up to the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " nearest elements to ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " within a radius ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Nearest",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Nearest"], "[", 
     StyleBox["data", "TI"], "]"}], Cell[TextData[{
     "generate a ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["NearestFunction",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NearestFunction"], "[", 
       StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
     " which can be applied repeatedly to different ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->1847918958],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Nearest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nearest"]], "InlineFormula"],
 StyleBox[" function.",
  GridBoxOptions->{
  GridBoxAlignment->{
   "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
    "RowsIndexed" -> {}},
  GridBoxItemSize->{"Columns" -> {
      Scaled[0.4], {
       Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}},
  GridBoxSpacings->{
   "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
    "Rows" -> {0.2, {0.6}, 0.2}, "RowsIndexed" -> {}}}]
}], "Caption",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.4], {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.6}, 0.2}, "RowsIndexed" -> {}}},
 CellID->24103],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Nearest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nearest"]], "InlineFormula"],
 " works with numeric lists, tensors, or a list of strings."
}], "Text",
 CellID->613527418],

Cell["This finds the elements nearest to 4.5.", "MathCaption",
 CellID->1725055125],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nearest", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", 
     "8"}], "}"}], ",", "4.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1498106725],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "5"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1888380538]
}, Open  ]],

Cell["This finds 3 elements nearest to 4.5.", "MathCaption",
 CellID->1577387778],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nearest", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", 
     "8"}], "}"}], ",", "4.5", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->790371959],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "5", ",", "3"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->1301566356]
}, Open  ]],

Cell["This finds all elements nearest to 4.5 within a radius of 2.", \
"MathCaption",
 CellID->1148491666],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nearest", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", 
     "8"}], "}"}], ",", "4.5", ",", 
   RowBox[{"{", 
    RowBox[{"Infinity", ",", " ", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1949058588],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "5", ",", "3", ",", "6"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1972494515]
}, Open  ]],

Cell[TextData[{
 "This finds the points nearest to ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", "2"}], "}"}]], "InlineFormula"],
 " in 2D."
}], "MathCaption",
 CellID->295749308],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nearest", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->719580878],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->796311563]
}, Open  ]],

Cell["This finds the nearest string to \"cat\".", "MathCaption",
 CellID->313294566],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nearest", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<bat\>\"", ",", "\"\<sad\>\"", ",", "\"\<cake\>\""}], "}"}], 
   ",", "\"\<cat\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2128671023],

Cell[BoxData[
 RowBox[{"{", "\<\"bat\"\>", "}"}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1544944800]
}, Open  ]],

Cell["\<\
The rule-based data syntax lets you use nearest elements to return their \
labels.\
\>", "Text",
 CellID->22274147],

Cell["Here two-dimensional points are labeled.", "MathCaption",
 CellID->17774],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nearest", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "a"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", "b"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", "c"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1723],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->894637869]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nearest", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "3"}], "}"}]}], "}"}], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->2138553683],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->17407470]
}, Open  ]],

Cell["This labels the elements using successive integers.", "MathCaption",
 CellID->1620301544],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nearest", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"7", ",", "7"}], "}"}]}], "}"}], "\[Rule]", " ", "Automatic"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->1090527130],

Cell[BoxData[
 RowBox[{"{", "4", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->895638943]
}, Open  ]],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  ButtonBox["Nearest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nearest"]], "InlineFormula"],
 " is to be applied repeatedly to the same numerical data, you can get \
significant performance gains by first generating a ",
 Cell[BoxData[
  ButtonBox["NearestFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NearestFunction"]], "InlineFormula"],
 "."
}], "Text",
 CellID->7785],

Cell[TextData[{
 "This generates a set of 10,000 points in 2D and a ",
 Cell[BoxData[
  ButtonBox["NearestFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NearestFunction"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->2750],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"pts", " ", "=", " ", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"10000", ",", "2"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"nf", "=", 
  RowBox[{"Nearest", "[", "pts", "]"}]}]}], "Input",
 CellLabel->"In[22]:=",
 CellID->9395],

Cell[BoxData[
 TagBox[
  RowBox[{"NearestFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"10000", ",", "2"}], "}"}], ",", 
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", ">"],
     Editable->False]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{218, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]=",
 CellID->529688265]
}, Open  ]],

Cell["\<\
This finds points in the set that are closest to the 10 target points.\
\>", "MathCaption",
 CellID->87645364],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"target", " ", "=", " ", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "2"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"res", "=", 
    RowBox[{"Map", "[", 
     RowBox[{"nf", ",", "target"}], "]"}]}], ";"}], "//", 
  "Timing"}]}], "Input",
 CellLabel->"In[24]:=",
 CellID->1958040158],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4.85722573273506`*^-16", ",", "Null"}], "}"}]], "Output",
 ImageSize->{147, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]=",
 CellID->131835262]
}, Open  ]],

Cell[TextData[{
 "It takes much longer if ",
 Cell[BoxData[
  ButtonBox["NearestFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NearestFunction"]], "InlineFormula"],
 " is not used."
}], "MathCaption",
 CellID->1896369044],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"res2", "=", 
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Nearest", "[", 
        RowBox[{"pts", ",", "#"}], "]"}], "&"}], ",", "target"}], "]"}]}], 
   ";"}], "//", "Timing"}]], "Input",
 CellLabel->"In[26]:=",
 CellID->1376604908],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.504032`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]=",
 CellID->1812214919]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"res", "\[Equal]", "res2"}]], "Input",
 CellLabel->"In[27]:=",
 CellID->30505446],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]=",
 CellID->1395264049]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    ButtonBox["DistanceFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DistanceFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the distance metric to use ", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, 
     AbsoluteThickness[0.5], {False}, False}, "RowsIndexed" -> {}}},
 CellID->26498],

Cell[TextData[{
 "Options for ",
 Cell[BoxData[
  ButtonBox["Nearest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nearest"]], "InlineFormula"],
 "."
}], "Caption",
 CellID->27277],

Cell[TextData[{
 "For numerical data, by default ",
 Cell[BoxData[
  ButtonBox["Nearest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nearest"]], "InlineFormula"],
 " uses the ",
 Cell[BoxData[
  ButtonBox["EuclideanDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EuclideanDistance"]], "InlineFormula"],
 ". For strings, ",
 Cell[BoxData[
  ButtonBox["EditDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EditDistance"]], "InlineFormula"],
 " is used."
}], "Text",
 CellID->21088]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Using Nearest - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 45, 44.1429278}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Nearest is used to find elements in a list that are closest to a given \
data point. Nearest function. Nearest works with numeric lists, tensors, or a \
list of strings.", "synonyms" -> {}, "title" -> "Using Nearest", "type" -> 
    "Tutorial", "uri" -> "tutorial/UsingNearest"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 773, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1398, 44, 45, 1, 70, "Title",
 CellID->2948],
Cell[1446, 47, 240, 8, 70, "Text",
 CellID->6916],
Cell[1689, 57, 5296, 182, 70, "DefinitionBox",
 CellID->1847918958],
Cell[6988, 241, 1034, 29, 70, "Caption",
 CellID->24103],
Cell[8025, 272, 225, 7, 70, "Text",
 CellID->613527418],
Cell[8253, 281, 83, 1, 70, "MathCaption",
 CellID->1725055125],
Cell[CellGroupData[{
Cell[8361, 286, 249, 8, 28, "Input",
 CellID->1498106725],
Cell[8613, 296, 204, 7, 36, "Output",
 CellID->1888380538]
}, Open  ]],
Cell[8832, 306, 81, 1, 70, "MathCaption",
 CellID->1577387778],
Cell[CellGroupData[{
Cell[8938, 311, 258, 8, 28, "Input",
 CellID->790371959],
Cell[9199, 321, 214, 7, 36, "Output",
 CellID->1301566356]
}, Open  ]],
Cell[9428, 331, 106, 2, 70, "MathCaption",
 CellID->1148491666],
Cell[CellGroupData[{
Cell[9559, 337, 320, 10, 70, "Input",
 CellID->1949058588],
Cell[9882, 349, 224, 7, 36, "Output",
 CellID->1972494515]
}, Open  ]],
Cell[10121, 359, 188, 7, 70, "MathCaption",
 CellID->295749308],
Cell[CellGroupData[{
Cell[10334, 370, 393, 14, 70, "Input",
 CellID->719580878],
Cell[10730, 386, 302, 11, 36, "Output",
 CellID->796311563]
}, Open  ]],
Cell[11047, 400, 84, 1, 70, "MathCaption",
 CellID->313294566],
Cell[CellGroupData[{
Cell[11156, 405, 231, 7, 70, "Input",
 CellID->2128671023],
Cell[11390, 414, 191, 6, 36, "Output",
 CellID->1544944800]
}, Open  ]],
Cell[11596, 423, 125, 4, 70, "Text",
 CellID->22274147],
Cell[11724, 429, 79, 1, 70, "MathCaption",
 CellID->17774],
Cell[CellGroupData[{
Cell[11828, 434, 490, 17, 70, "Input",
 CellID->1723],
Cell[12321, 453, 203, 7, 36, "Output",
 CellID->894637869]
}, Open  ]],
Cell[CellGroupData[{
Cell[12561, 465, 493, 17, 70, "Input",
 CellID->2138553683],
Cell[13057, 484, 202, 7, 36, "Output",
 CellID->17407470]
}, Open  ]],
Cell[13274, 494, 95, 1, 70, "MathCaption",
 CellID->1620301544],
Cell[CellGroupData[{
Cell[13394, 499, 579, 20, 70, "Input",
 CellID->1090527130],
Cell[13976, 521, 180, 6, 36, "Output",
 CellID->895638943]
}, Open  ]],
Cell[14171, 530, 433, 14, 70, "Text",
 CellID->7785],
Cell[14607, 546, 242, 8, 70, "MathCaption",
 CellID->2750],
Cell[CellGroupData[{
Cell[14874, 558, 310, 10, 70, "Input",
 CellID->9395],
Cell[15187, 570, 452, 16, 36, "Output",
 CellID->529688265]
}, Open  ]],
Cell[15654, 589, 120, 3, 70, "MathCaption",
 CellID->87645364],
Cell[CellGroupData[{
Cell[15799, 596, 396, 14, 70, "Input",
 CellID->1958040158],
Cell[16198, 612, 229, 7, 39, "Output",
 CellID->131835262]
}, Open  ]],
Cell[16442, 622, 234, 8, 70, "MathCaption",
 CellID->1896369044],
Cell[CellGroupData[{
Cell[16701, 634, 304, 11, 70, "Input",
 CellID->1376604908],
Cell[17008, 647, 217, 7, 36, "Output",
 CellID->1812214919]
}, Open  ]],
Cell[CellGroupData[{
Cell[17262, 659, 104, 3, 70, "Input",
 CellID->30505446],
Cell[17369, 664, 163, 5, 36, "Output",
 CellID->1395264049]
}, Open  ]],
Cell[17547, 672, 593, 16, 70, "DefinitionBox3Col",
 CellID->26498],
Cell[18143, 690, 185, 8, 70, "Caption",
 CellID->27277],
Cell[18331, 700, 508, 18, 70, "Text",
 CellID->21088]
}, Open  ]],
Cell[18854, 721, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

