(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26785,       1012]
NotebookOptionsPosition[     19076,        767]
NotebookOutlinePosition[     22496,        847]
CellTagsIndexPosition[     22405,        841]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Algebraic Calculations" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/AlgebraicCalculationsOverview"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Algebraic Calculations\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Values for Symbols", "Title",
 CellTags->{"S1.4.2", "2.1"},
 CellID->30101],

Cell[TextData[{
 "When ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " transforms an expression such as ",
 Cell[BoxData[
  RowBox[{"x", "+", "x"}]], "InlineFormula"],
 " into ",
 Cell[BoxData[
  RowBox[{"2", "x"}]], "InlineFormula"],
 ", it is treating the variable ",
 Cell[BoxData["x"], "InlineFormula"],
 " in a purely symbolic or formal fashion. In such cases, ",
 Cell[BoxData["x"], "InlineFormula"],
 " is a symbol which can stand for any expression. "
}], "Text",
 CellID->9407],

Cell[TextData[{
 "Often, however, you need to replace a symbol like ",
 Cell[BoxData["x"], "InlineFormula"],
 " with a definite \[OpenCurlyDoubleQuote]value\[CloseCurlyDoubleQuote]. \
Sometimes this value will be a number; often it will be another expression. "
}], "Text",
 CellID->30195],

Cell[TextData[{
 "To take an expression such as ",
 Cell[BoxData[
  RowBox[{"1", "+", 
   RowBox[{"2", "x"}]}]], "InlineFormula"],
 " and replace the symbol ",
 Cell[BoxData["x"], "InlineFormula"],
 " that appears in it with a definite value, you can create a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " transformation rule, and then apply this rule to the expression. To \
replace ",
 Cell[BoxData["x"], "InlineFormula"],
 " with the value ",
 Cell[BoxData["3"], "InlineFormula"],
 ", you would create the transformation rule ",
 Cell[BoxData[
  RowBox[{"x", "->", "3"}]], "InlineFormula"],
 ". You must type ",
 Cell[BoxData["->"], "InlineFormula"],
 " as a pair of characters, with no space in between. You can think of ",
 Cell[BoxData[
  RowBox[{"x", "->", "3"}]], "InlineFormula"],
 " as being a rule in which \[OpenCurlyDoubleQuote]",
 Cell[BoxData["x"], "InlineFormula"],
 " goes to ",
 Cell[BoxData["3"], "InlineFormula"],
 "\[CloseCurlyDoubleQuote]. "
}], "Text",
 CellID->31219],

Cell[TextData[{
 "To apply a transformation rule to a particular ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression, you type ",
 Cell[BoxData[
  RowBox[{
   StyleBox["expr", "TI"], "/.", 
   StyleBox["rule", "TI"]}]], "InlineFormula"],
 ". The \[OpenCurlyDoubleQuote]replacement operator\[CloseCurlyDoubleQuote] \
",
 Cell[BoxData["/."], "InlineFormula"],
 " is typed as a pair of characters, with no space in between. "
}], "Text",
 CellID->3084],

Cell[TextData[{
 "This uses the transformation rule ",
 Cell[BoxData[
  RowBox[{"x", "->", "3"}]], "InlineFormula"],
 " in the expression ",
 Cell[BoxData[
  RowBox[{"1", "+", 
   RowBox[{"2", "x"}]}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->11427],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "+", 
   RowBox[{"2", "x"}]}], "/.", 
  RowBox[{"x", "->", "3"}]}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->29355],

Cell[BoxData["7"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->25560]
}, Open  ]],

Cell[TextData[{
 "You can replace ",
 Cell[BoxData["x"], "InlineFormula"],
 " with any expression. Here every occurrence of ",
 Cell[BoxData["x"], "InlineFormula"],
 " is replaced by ",
 Cell[BoxData[
  RowBox[{"2", "-", "y"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->22133],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "+", "x", "+", 
   RowBox[{"x", "^", "2"}]}], "/.", 
  RowBox[{"x", "->", 
   RowBox[{"2", "-", "y"}]}]}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->15452],

Cell[BoxData[
 RowBox[{"3", "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"2", "-", "y"}], ")"}], "2"], "-", "y"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->24800]
}, Open  ]],

Cell[TextData[{
 "Here is a transformation rule. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " treats it like any other symbolic expression. "
}], "MathCaption",
 CellID->603],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "->", 
  RowBox[{"3", "+", "y"}]}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->31688],

Cell[BoxData[
 RowBox[{"x", "\[Rule]", 
  RowBox[{"3", "+", "y"}]}]], "Output",
 ImageSize->{54, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->5398]
}, Open  ]],

Cell[TextData[{
 "This applies the transformation rule on the previous line to the expression \
",
 Cell[BoxData[
  RowBox[{
   RowBox[{"x", "^", "2"}], "-", "9"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->6875],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"x", "^", "2"}], "-", "9"}], "/.", "%"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->11569],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "9"}], "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"3", "+", "y"}], ")"}], "2"]}]], "Output",
 ImageSize->{78, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->304]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["expr", "TI"], "/.", 
     StyleBox["x", "TI"], "->", 
     StyleBox["value", "TI"]}], Cell[TextData[{
     "replace ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " by ",
     Cell[BoxData[
      StyleBox["value", "TI"]], "InlineFormula"],
     " in the expression ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["expr", "TI"], "/.", "{", 
     StyleBox["x", "TI"], "->", 
     StyleBox["xval", "TI"], ",", 
     StyleBox["y", "TI"], "->", 
     StyleBox["yval", "TI"], "}"}], Cell[
    "perform several replacements", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->16990],

Cell["Replacing symbols by values in expressions. ", "Caption",
 CellID->27843],

Cell["\<\
You can apply rules together by putting the rules in a list. \
\>", "MathCaption",
 CellID->29557],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "+", "y"}], ")"}], " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "y"}], ")"}], "^", "2"}]}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "->", "3"}], ",", 
    RowBox[{"y", "->", 
     RowBox[{"1", "-", "a"}]}]}], "}"}]}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->7857],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"4", "-", "a"}], ")"}], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"2", "+", "a"}], ")"}], "2"]}]], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->11319]
}, Open  ]],

Cell[TextData[{
 "The replacement operator ",
 Cell[BoxData["/."], "InlineFormula"],
 " allows you to apply transformation rules to a particular expression. \
Sometimes, however, you will want to define transformation rules that should \
",
 StyleBox["always",
  FontSlant->"Italic"],
 " be applied. For example, you might want to replace ",
 Cell[BoxData["x"], "InlineFormula"],
 " with ",
 Cell[BoxData["3"], "InlineFormula"],
 " whenever ",
 Cell[BoxData["x"], "InlineFormula"],
 " occurs. "
}], "Text",
 CellID->11875],

Cell[TextData[{
 "As discussed in \"",
 ButtonBox["Defining Variables",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/DefiningVariables"],
 "\", you can do this by ",
 StyleBox["assigning",
  FontSlant->"Italic"],
 " the value ",
 Cell[BoxData["3"], "InlineFormula"],
 " to ",
 Cell[BoxData["x"], "InlineFormula"],
 " using ",
 Cell[BoxData[
  RowBox[{"x", "=", "3"}]], "InlineFormula"],
 ". Once you have made the assignment ",
 Cell[BoxData[
  RowBox[{"x", "=", "3"}]], "InlineFormula"],
 ", ",
 Cell[BoxData["x"], "InlineFormula"],
 " will always be replaced by ",
 Cell[BoxData["3"], "InlineFormula"],
 ", whenever it appears. "
}], "Text",
 CellID->24149],

Cell[TextData[{
 "This assigns the value ",
 Cell[BoxData["3"], "InlineFormula"],
 " to ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->18190],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", "3"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->3946],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->10798]
}, Open  ]],

Cell[TextData[{
 "Now ",
 Cell[BoxData["x"], "InlineFormula"],
 " will automatically be replaced by ",
 Cell[BoxData["3"], "InlineFormula"],
 " wherever it appears. "
}], "MathCaption",
 CellID->19467],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "^", "2"}], "-", "1"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->26346],

Cell[BoxData["8"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->20509]
}, Open  ]],

Cell[TextData[{
 "This assigns the expression ",
 Cell[BoxData[
  RowBox[{"1", "+", "a"}]], "InlineFormula"],
 " to be the value of ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->30080],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{"1", "+", "a"}]}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->30479],

Cell[BoxData[
 RowBox[{"1", "+", "a"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->7981]
}, Open  ]],

Cell[TextData[{
 "Now ",
 Cell[BoxData["x"], "InlineFormula"],
 " is replaced by ",
 Cell[BoxData[
  RowBox[{"1", "+", "a"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->23207],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "^", "2"}], "-", "1"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->7719],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", "a"}], ")"}], "2"]}]], "Output",
 ImageSize->{78, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->32138]
}, Open  ]],

Cell[TextData[{
 "You can define the value of a symbol to be any expression, not just a \
number. You should realize that once you have given such a definition, the \
definition will continue to be used whenever the symbol appears, until you \
explicitly change or remove the definition. For most people, forgetting to \
remove values you have assigned to symbols is the single most common source \
of mistakes in using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->32425],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["x", "TI"], "=", 
     StyleBox["value", "TI"]}], Cell[TextData[{
     "define a value for ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " which will always be used"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], "=."}], Cell[TextData[{
     "remove any value defined for ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->1699],

Cell["Assigning values to symbols. ", "Caption",
 CellID->20770],

Cell[TextData[{
 "The symbol ",
 Cell[BoxData["x"], "InlineFormula"],
 " still has the value you assigned to it above. "
}], "MathCaption",
 CellID->32014],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "+", "5", "-", 
  RowBox[{"2", "x"}]}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->32510],

Cell[BoxData[
 RowBox[{"6", "+", "a", "-", 
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "a"}], ")"}]}]}]], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->12355]
}, Open  ]],

Cell[TextData[{
 "This removes the value you assigned to\[NonBreakingSpace]",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->24232],

Cell[BoxData[
 RowBox[{"x", "=."}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->5765],

Cell[TextData[{
 "Now ",
 Cell[BoxData["x"], "InlineFormula"],
 " has no value defined, so it can be used as a purely symbolic variable. "
}], "MathCaption",
 CellID->18618],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "+", "5", "-", 
  RowBox[{"2", "x"}]}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->31720],

Cell[BoxData[
 RowBox[{"5", "-", "x"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->16237]
}, Open  ]],

Cell[TextData[{
 "A symbol such as ",
 Cell[BoxData["x"], "InlineFormula"],
 " can serve many different purposes in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", and in fact, much of the flexibility of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " comes from being able to mix these purposes at will. However, you need to \
keep some of the different uses of ",
 Cell[BoxData["x"], "InlineFormula"],
 " straight in order to avoid making mistakes. The most important distinction \
is between the use of ",
 Cell[BoxData["x"], "InlineFormula"],
 " as a name for another expression, and as a symbolic variable that stands \
only for itself. "
}], "Text",
 CellID->28264],

Cell[TextData[{
 "Traditional programming languages that do not support symbolic computation \
allow variables to be used only as names for objects, typically numbers, that \
have been assigned as values for them. In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", however, ",
 Cell[BoxData["x"], "InlineFormula"],
 " can also be treated as a purely formal variable, to which various \
transformation rules can be applied. Of course, if you explicitly give a \
definition, such as ",
 Cell[BoxData[
  RowBox[{"x", "=", "3"}]], "InlineFormula"],
 ", then ",
 Cell[BoxData["x"], "InlineFormula"],
 " will always be replaced by ",
 Cell[BoxData["3"], "InlineFormula"],
 ", and can no longer serve as a formal variable. "
}], "Text",
 CellID->709],

Cell[TextData[{
 "You should understand that explicit definitions such as ",
 Cell[BoxData[
  RowBox[{"x", "=", "3"}]], "InlineFormula"],
 " have a global effect. On the other hand, a replacement such as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["expr", "TI"], "/.", 
   RowBox[{"x", "->", "3"}]}]], "InlineFormula"],
 " affects only the specific expression ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". It is usually much easier to keep things straight if you avoid using \
explicit definitions except when absolutely necessary."
}], "Text",
 CellID->30703],

Cell["\<\
You can always mix replacements with assignments. With assignments, you can \
give names to expressions in which you want to do replacements, or to rules \
that you want to use to do the replacements. \
\>", "Text",
 CellID->32544],

Cell[TextData[{
 "This assigns a value to the symbol ",
 Cell[BoxData["t"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->32050],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"1", "+", 
   RowBox[{"x", "^", "2"}]}]}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->12541],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{37, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->4301]
}, Open  ]],

Cell[TextData[{
 "This finds the value of ",
 Cell[BoxData["t"], "InlineFormula"],
 ", and then replaces ",
 Cell[BoxData["x"], "InlineFormula"],
 " by ",
 Cell[BoxData["2"], "InlineFormula"],
 " in it. "
}], "MathCaption",
 CellID->12344],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "/.", 
  RowBox[{"x", "->", "2"}]}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->17427],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]= ",
 CellID->26141]
}, Open  ]],

Cell[TextData[{
 "This finds the value of ",
 Cell[BoxData["t"], "InlineFormula"],
 " for a different value of ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->2910],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "/.", 
  RowBox[{"x", "->", 
   RowBox[{"5", "a"}]}]}]], "Input",
 CellLabel->"In[15]:= ",
 CellID->19696],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"25", " ", 
   SuperscriptBox["a", "2"]}]}]], "Output",
 ImageSize->{54, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]= ",
 CellID->14824]
}, Open  ]],

Cell[TextData[{
 "This finds the value of ",
 Cell[BoxData["t"], "InlineFormula"],
 " when ",
 Cell[BoxData["x"], "InlineFormula"],
 " is replaced by ",
 Cell[BoxData[
  ButtonBox["Pi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pi"]], "InlineFormula"],
 ", and then evaluates the result numerically. "
}], "MathCaption",
 CellID->19683],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "/.", 
   RowBox[{"x", "->", "Pi"}]}], "//", "N"}]], "Input",
 CellLabel->"In[16]:= ",
 CellID->31098],

Cell[BoxData["10.869604401089358`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]= ",
 CellID->10640]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->72429047],

Cell[TextData[ButtonBox["Algebraic Calculations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AlgebraicCalculationsOverview"]], "RelatedTutorials",
 CellID->20816390]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Values for Symbols - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Algebraic Calculations", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/AlgebraicCalculationsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/SymbolicComputation"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/TransformingAlgebraicExpressions"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 45, 46.4711124}", "context" -> "", 
    "keywords" -> {
     "/.", "=.", "=", "->", "algebraic variables", "arrow", "assignments", 
      "controlled transformations", "evaluation at a point", 
      "programming languages", "ReplaceAll", "replacements", "rule", "rules", 
      "set", "Slashdot", "substitution", "symbols", "temporary binding", 
      "transformation rules", "unset", "values", "variables"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "When Mathematica transforms an expression such as x+x into 2x, it is \
treating the variable x in a purely symbolic or formal fashion. In such \
cases, x is a symbol which can stand for any expression. Often, however, you \
need to replace a symbol like x with a definite 'value'. Sometimes this value \
will be a number; often it will be another expression. To take an expression \
such as 1+2x and replace the symbol x that appears in it with a definite \
value, you can create a Mathematica transformation rule, and then apply this \
rule to the expression. To replace x with the value 3, you would create the \
transformation rule x->3. You must type -> as a pair of characters, with no \
space in between. You can think of x->3 as being a rule in which 'x goes to \
3'. ", "synonyms" -> {"1.4.2"}, "title" -> "Values for Symbols", "type" -> 
    "Tutorial", "uri" -> "tutorial/ValuesForSymbols"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.4.2"->{
  Cell[1266, 43, 81, 2, 70, "Title",
   CellTags->{"S1.4.2", "2.1"},
   CellID->30101]},
 "2.1"->{
  Cell[1266, 43, 81, 2, 70, "Title",
   CellTags->{"S1.4.2", "2.1"},
   CellID->30101]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.4.2", 22194, 830},
 {"2.1", 22293, 834}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 641, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1266, 43, 81, 2, 70, "Title",
 CellTags->{"S1.4.2", "2.1"},
 CellID->30101],
Cell[1350, 47, 493, 16, 70, "Text",
 CellID->9407],
Cell[1846, 65, 289, 6, 70, "Text",
 CellID->30195],
Cell[2138, 73, 1000, 29, 70, "Text",
 CellID->31219],
Cell[3141, 104, 463, 14, 70, "Text",
 CellID->3084],
Cell[3607, 120, 261, 10, 70, "MathCaption",
 CellID->11427],
Cell[CellGroupData[{
Cell[3893, 134, 156, 6, 28, "Input",
 CellID->29355],
Cell[4052, 142, 155, 5, 36, "Output",
 CellID->25560]
}, Open  ]],
Cell[4222, 150, 287, 10, 70, "MathCaption",
 CellID->22133],
Cell[CellGroupData[{
Cell[4534, 164, 195, 7, 28, "Input",
 CellID->15452],
Cell[4732, 173, 260, 9, 36, "Output",
 CellID->24800]
}, Open  ]],
Cell[5007, 185, 184, 6, 70, "MathCaption",
 CellID->603],
Cell[CellGroupData[{
Cell[5216, 195, 113, 4, 70, "Input",
 CellID->31688],
Cell[5332, 201, 205, 7, 36, "Output",
 CellID->5398]
}, Open  ]],
Cell[5552, 211, 223, 8, 70, "MathCaption",
 CellID->6875],
Cell[CellGroupData[{
Cell[5800, 223, 137, 5, 70, "Input",
 CellID->11569],
Cell[5940, 230, 266, 10, 36, "Output",
 CellID->304]
}, Open  ]],
Cell[6221, 243, 1005, 32, 70, "DefinitionBox",
 CellID->16990],
Cell[7229, 277, 79, 1, 70, "Caption",
 CellID->27843],
Cell[7311, 280, 108, 3, 70, "MathCaption",
 CellID->29557],
Cell[CellGroupData[{
Cell[7444, 287, 361, 14, 70, "Input",
 CellID->7857],
Cell[7808, 303, 297, 11, 36, "Output",
 CellID->11319]
}, Open  ]],
Cell[8120, 317, 522, 16, 70, "Text",
 CellID->11875],
Cell[8645, 335, 666, 24, 70, "Text",
 CellID->24149],
Cell[9314, 361, 169, 7, 70, "MathCaption",
 CellID->18190],
Cell[CellGroupData[{
Cell[9508, 372, 88, 3, 70, "Input",
 CellID->3946],
Cell[9599, 377, 155, 5, 36, "Output",
 CellID->10798]
}, Open  ]],
Cell[9769, 385, 201, 7, 70, "MathCaption",
 CellID->19467],
Cell[CellGroupData[{
Cell[9995, 396, 112, 4, 70, "Input",
 CellID->26346],
Cell[10110, 402, 155, 5, 36, "Output",
 CellID->20509]
}, Open  ]],
Cell[10280, 410, 213, 8, 70, "MathCaption",
 CellID->30080],
Cell[CellGroupData[{
Cell[10518, 422, 112, 4, 70, "Input",
 CellID->30479],
Cell[10633, 428, 176, 6, 36, "Output",
 CellID->7981]
}, Open  ]],
Cell[10824, 437, 185, 8, 70, "MathCaption",
 CellID->23207],
Cell[CellGroupData[{
Cell[11034, 449, 111, 4, 70, "Input",
 CellID->7719],
Cell[11148, 455, 268, 10, 36, "Output",
 CellID->32138]
}, Open  ]],
Cell[11431, 468, 505, 11, 70, "Text",
 CellID->32425],
Cell[11939, 481, 775, 25, 70, "DefinitionBox",
 CellID->1699],
Cell[12717, 508, 64, 1, 70, "Caption",
 CellID->20770],
Cell[12784, 511, 155, 5, 70, "MathCaption",
 CellID->32014],
Cell[CellGroupData[{
Cell[12964, 520, 118, 4, 70, "Input",
 CellID->32510],
Cell[13085, 526, 260, 9, 36, "Output",
 CellID->12355]
}, Open  ]],
Cell[13360, 538, 156, 5, 70, "MathCaption",
 CellID->24232],
Cell[13519, 545, 85, 3, 70, "Input",
 CellID->5765],
Cell[13607, 550, 173, 5, 70, "MathCaption",
 CellID->18618],
Cell[CellGroupData[{
Cell[13805, 559, 118, 4, 70, "Input",
 CellID->31720],
Cell[13926, 565, 178, 6, 36, "Output",
 CellID->16237]
}, Open  ]],
Cell[14119, 574, 686, 18, 70, "Text",
 CellID->28264],
Cell[14808, 594, 751, 19, 70, "Text",
 CellID->709],
Cell[15562, 615, 578, 15, 70, "Text",
 CellID->30703],
Cell[16143, 632, 241, 5, 70, "Text",
 CellID->32544],
Cell[16387, 639, 134, 5, 70, "MathCaption",
 CellID->32050],
Cell[CellGroupData[{
Cell[16546, 648, 137, 5, 70, "Input",
 CellID->12541],
Cell[16686, 655, 201, 7, 36, "Output",
 CellID->4301]
}, Open  ]],
Cell[16902, 665, 239, 9, 70, "MathCaption",
 CellID->12344],
Cell[CellGroupData[{
Cell[17166, 678, 115, 4, 70, "Input",
 CellID->17427],
Cell[17284, 684, 156, 5, 36, "Output",
 CellID->26141]
}, Open  ]],
Cell[17455, 692, 191, 7, 70, "MathCaption",
 CellID->2910],
Cell[CellGroupData[{
Cell[17671, 703, 134, 5, 70, "Input",
 CellID->19696],
Cell[17808, 710, 227, 8, 36, "Output",
 CellID->14824]
}, Open  ]],
Cell[18050, 721, 343, 12, 70, "MathCaption",
 CellID->19683],
Cell[CellGroupData[{
Cell[18418, 737, 141, 5, 70, "Input",
 CellID->31098],
Cell[18562, 744, 174, 5, 36, "Output",
 CellID->10640]
}, Open  ]],
Cell[CellGroupData[{
Cell[18773, 754, 71, 1, 70, "RelatedTutorialsSection",
 CellID->72429047],
Cell[18847, 757, 175, 4, 70, "RelatedTutorials",
 CellID->20816390]
}, Open  ]]
}, Open  ]],
Cell[19049, 765, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

