(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[   3342494,      66303]
NotebookOptionsPosition[   3330718,      65943]
NotebookOutlinePosition[   3332582,      65987]
CellTagsIndexPosition[   3332539,      65984]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Creating Inspectors" :> 
         Documentation`HelpLookup["paclet:guide/CreatingInspectors"]}, #, 
        2]& , Evaluator -> Automatic], {
      1->"\<\"Creating Inspectors\"\>"}, "\<\"more about\"\>", 
      StyleBox["\<\"more about\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Views", "Title"],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " supports a variety of objects that can be used to organize and display \
information in output",
 ". ",
 "Known collectively as Views, these objects range from the simple ",
 Cell[BoxData[
  ButtonBox["OpenerView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenerView"]], "InlineFormula"],
 " to the complex and versatile ",
 Cell[BoxData[
  ButtonBox["TabView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TabView"]], "InlineFormula"],
 "."
}], "Text"],

Cell["\<\
All have in common that they take a first argument containing a list of \
expressions to be displayed as separate panes in the view, and an optional \
second argument to determine which one should be displayed at the moment. All \
provide a user interface allowing you to change which pane is displayed: they \
are intended as interactive data-viewers.\
\>", "Text"],

Cell["\<\
The individual views are described first, then options and techniques common \
to all or most of them.\
\>", "Text"],

Cell[CellGroupData[{

Cell["OpenerView", "Section"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OpenerView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenerView"]], "InlineFormula"],
 " allows you to open and close a pane containing an arbitrary expression. ",
 Cell[BoxData[
  ButtonBox["OpenerView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenerView"]], "InlineFormula"],
 " is always given a list of two elements: the first element becomes the \
title (always visible) and the second becomes the contents that is revealed \
by clicking the disclosure triangle. In this example, click the triangle to \
reveal the word \"Contents\"."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OpenerView", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<Title\>\"", ",", " ", "\"\<Contents\>\""}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = False}, 
   InterpretationBox[
    StyleBox[
     PaneSelectorBox[{False->
      TagBox[GridBox[{
         {
          OpenerBox[Dynamic[Typeset`var$$],
           Appearance->Automatic,
           AutoAction->False,
           ContinuousAction->False,
           Enabled->Automatic], "\<\"Title\"\>"}
        },
        BaselinePosition->{1, 1},
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxBackground->{"Columns" -> {{Automatic}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
        RowsEqual->False],
       "Grid"], True->
      TagBox[GridBox[{
         {
          OpenerBox[Dynamic[Typeset`var$$],
           Appearance->Automatic,
           AutoAction->False,
           ContinuousAction->False,
           Enabled->Automatic], "\<\"Title\"\>"},
         {"", 
          PaneBox["\<\"Contents\"\>",
           ImageMargins->0]}
        },
        BaselinePosition->{1, 1},
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxBackground->{"Columns" -> {{Automatic}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
        RowsEqual->False],
       "Grid"]}, Dynamic[Typeset`var$$],
      Alignment->Automatic,
      BaselinePosition->Baseline,
      DefaultBaseStyle->"OpenerView",
      ImageMargins->0,
      ImageSize->Automatic],
     Deployed->False,
     StripOnInput->False],
    OpenerView[{"Title", "Contents"}, False]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1313338999]
}, Open  ]],

Cell["\<\
This control can be used to create objects that mimic the way disclosure \
triangles are used in other applications, for example, in the Finder \
(Macintosh) or Explorer (Windows). Typically the second element is bigger \
than the first, as in this example.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OpenerView", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<Plot\>\"", ",", " ", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", 
        RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = False}, 
   InterpretationBox[
    StyleBox[
     PaneSelectorBox[{False->
      TagBox[GridBox[{
         {
          OpenerBox[Dynamic[Typeset`var$$],
           Appearance->Automatic,
           AutoAction->False,
           ContinuousAction->False,
           Enabled->Automatic], "\<\"Plot\"\>"}
        },
        BaselinePosition->{1, 1},
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxBackground->{"Columns" -> {{Automatic}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
        RowsEqual->False],
       "Grid"], True->
      TagBox[GridBox[{
         {
          OpenerBox[Dynamic[Typeset`var$$],
           Appearance->Automatic,
           AutoAction->False,
           ContinuousAction->False,
           Enabled->Automatic], "\<\"Plot\"\>"},
         {"", 
          PaneBox[
           GraphicsBox[{{}, {}, 
             {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwl2Xk4VN//AHBrITFzh1Ap2heSUlT0PpWtSClpE0JCskZIKm1IElLJlrKU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               "]]}},
            AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
            Axes->True,
            AxesOrigin->{0, 0},
            
            PlotRange->
             NCache[{{0, 2 Pi}, {-0.9999998592131705, 0.9999998782112116}}, {{
               0, 6.283185307179586}, {-0.9999998592131705, 
               0.9999998782112116}}],
            PlotRangeClipping->True,
            PlotRangePadding->{
              Scaled[0.02], 
              Scaled[0.02]}],
           ImageMargins->0]}
        },
        BaselinePosition->{1, 1},
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxBackground->{"Columns" -> {{Automatic}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
        RowsEqual->False],
       "Grid"]}, Dynamic[Typeset`var$$],
      Alignment->Automatic,
      BaselinePosition->Baseline,
      DefaultBaseStyle->"OpenerView",
      ImageMargins->0,
      ImageSize->Automatic],
     Deployed->False,
     StripOnInput->False],
    OpenerView[{"Plot", 
      Graphics[{{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Line[CompressedData["
1:eJwl2Xk4VN//AHBrITFzh1Ap2heSUlT0PpWtSClpE0JCskZIKm1IElLJlrKU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           "]]}}}, {
       AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
        PlotRange -> {{0, 2 Pi}, {-0.9999998592131705, 0.9999998782112116}}, 
        PlotRangeClipping -> True, PlotRangePadding -> {
          Scaled[0.02], 
          Scaled[0.02]}}]}, False]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1451632327]
}, Open  ]],

Cell[TextData[{
 "A column or grid of ",
 Cell[BoxData[
  ButtonBox["OpenerView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenerView"]], "InlineFormula"],
 "s allows browsing a large amount of data in a compact format."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{"Map", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"OpenerView", "[", 
      RowBox[{"{", 
       RowBox[{"#", ",", 
        RowBox[{"DateListPlot", "[", 
         RowBox[{"CountryData", "[", 
          RowBox[{"#", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", "\"\<GDP\>\"", "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"1970", ",", "2005"}], "}"}]}], "}"}]}], "]"}], "]"}]}],
        "}"}], "]"}], "&"}], ",", 
    RowBox[{"CountryData", "[", "\"\<GroupOf8\>\"", "]"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = False}, 
       InterpretationBox[
        StyleBox[
         PaneSelectorBox[{False->
          TagBox[GridBox[{
             {
              OpenerBox[Dynamic[Typeset`var$$],
               Appearance->Automatic,
               AutoAction->False,
               ContinuousAction->False,
               Enabled->Automatic], "\<\"Canada\"\>"}
            },
            BaselinePosition->{1, 1},
            ColumnsEqual->False,
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxBackground->{"Columns" -> {{Automatic}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
            RowsEqual->False],
           "Grid"], True->
          TagBox[GridBox[{
             {
              OpenerBox[Dynamic[Typeset`var$$],
               Appearance->Automatic,
               AutoAction->False,
               ContinuousAction->False,
               Enabled->Automatic], "\<\"Canada\"\>"},
             {"", 
              PaneBox[
               GraphicsBox[{{}, 
                 {Hue[0.67, 0.6, 0.6], 
                  PointBox[{{2.2089888*^9, 8.51102721952742*^10}, {
                   2.2405248*^9, 9.611388494862978*^10}, {2.2720608*^9, 
                   1.094720184098862*^11}, {2.3036832*^9, 
                   1.2719440059381201`*^11}, {2.3352192*^9, 
                   1.5529838808012518`*^11}, {2.3667552*^9, 
                   1.6827567004560587`*^11}, {2.3982912*^9, 
                   2.00061864743176*^11}, {2.4299136*^9, 
                   2.0490855246558777`*^11}, {2.4614496*^9, 
                   2.1158699904973694`*^11}, {2.4929856*^9, 
                   2.354038885269667*^11}, {2.5245216*^9, 
                   2.6527162075194025`*^11}, {2.556144*^9, 
                   2.9670158287541626`*^11}, {2.58768*^9, 
                   3.0382902858739197`*^11}, {2.619216*^9, 
                   3.2898857285467914`*^11}, {2.650752*^9, 
                   3.42332183759481*^11}, {2.6823744*^9, 
                   3.50666308740087*^11}, {2.7139104*^9, 
                   3.6336595904342676`*^11}, {2.7454464*^9, 
                   4.1532010633550885`*^11}, {2.7769824*^9, 
                   4.9056464772996716`*^11}, {2.8086048*^9, 
                   5.4728594655086096`*^11}, {2.8401408*^9, 
                   5.742041096183926*^11}, {2.8716768*^9, 
                   5.888384271853116*^11}, {2.9032128*^9, 
                   5.70279426668597*^11}, {2.9348352*^9, 
                   5.546898143452979*^11}, {2.9663712*^9, 
                   5.558404311536865*^11}, {2.9979072*^9, 
                   5.816644190490315*^11}, {3.0294432*^9, 
                   6.043712052962986*^11}, {3.0610656*^9, 
                   6.27595363337625*^11}, {3.0926016*^9, 
                   6.069244392498939*^11}, {3.1241376*^9, 
                   6.512017086979576*^11}, {3.1556736*^9, 
                   7.144534748267805*^11}, {3.187296*^9, 
                   7.050688372908894*^11}, {3.218832*^9, 
                   7.243042892296139*^11}, {3.250368*^9, 
                   8.547108065250964*^11}, {3.281904*^9, 
                   9.767419516622521*^11}, {3.3135264*^9, 
                   1.1317597770741843`*^12}}]}, {}},
                AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                AxesOrigin->NCache[{2208988800, 0}, {2.2089888*^9, 0}],
                Frame->True,
                FrameTicks->{{Automatic, Automatic}, {{{
                    NCache[2208988800, 2.2089888*^9], 
                    FormBox["\"1970\"", TraditionalForm]}, {
                    NCache[2524521600, 2.5245216*^9], 
                    FormBox["\"1980\"", TraditionalForm]}, {
                    NCache[2840140800, 2.8401408*^9], 
                    FormBox["\"1990\"", TraditionalForm]}, {
                    NCache[3155673600, 3.1556736*^9], 
                    FormBox["\"2000\"", TraditionalForm]}, {
                    NCache[2272060800, 2.2720608*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2335219200, 2.3352192*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2398291200, 2.3982912*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2461449600, 2.4614496*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2587680000, 2.58768*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2650752000, 2.650752*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2713910400, 2.7139104*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2776982400, 2.7769824*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2903212800, 2.9032128*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2966371200, 2.9663712*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3029443200, 3.0294432*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3092601600, 3.0926016*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3218832000, 3.218832*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3281904000, 3.281904*^9], 
                    FormBox["\" \"", TraditionalForm]}}, {{
                    NCache[2208988800, 2.2089888*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2524521600, 2.5245216*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2840140800, 2.8401408*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3155673600, 3.1556736*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2272060800, 2.2720608*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2335219200, 2.3352192*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2398291200, 2.3982912*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2461449600, 2.4614496*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2587680000, 2.58768*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2650752000, 2.650752*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2713910400, 2.7139104*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2776982400, 2.7769824*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2903212800, 2.9032128*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2966371200, 2.9663712*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3029443200, 3.0294432*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3092601600, 3.0926016*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3218832000, 3.218832*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3281904000, 3.281904*^9], 
                    FormBox["\" \"", TraditionalForm]}}}},
                GridLines->NCache[{{{2208988800, 
                    GrayLevel[0.8]}, {2524521600, 
                    GrayLevel[0.8]}, {2840140800, 
                    GrayLevel[0.8]}, {3155673600, 
                    GrayLevel[0.8]}}, None}, {{{2.2089888*^9, 
                    GrayLevel[0.8]}, {2.5245216*^9, 
                    GrayLevel[0.8]}, {2.8401408*^9, 
                    GrayLevel[0.8]}, {3.1556736*^9, 
                    GrayLevel[0.8]}}, None}],
                
                PlotRange->{{2.2089888*^9, 3.3135264*^9}, {0., 
                 1.1317597770741843`*^12}},
                PlotRangeClipping->True,
                PlotRangePadding->{
                  Scaled[0.02], 
                  Scaled[0.02]},
                Ticks->None],
               ImageMargins->0]}
            },
            BaselinePosition->{1, 1},
            ColumnsEqual->False,
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxBackground->{"Columns" -> {{Automatic}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
            RowsEqual->False],
           "Grid"]}, Dynamic[Typeset`var$$],
          Alignment->Automatic,
          BaselinePosition->Baseline,
          DefaultBaseStyle->"OpenerView",
          ImageMargins->0,
          ImageSize->Automatic],
         Deployed->False,
         StripOnInput->False],
        OpenerView[{"Canada", 
          Graphics[{{{}, {
              Hue[0.67, 0.6, 0.6], 
              
              Point[{{2.2089888*^9, 8.51102721952742*^10}, {2.2405248*^9, 
               9.611388494862978*^10}, {2.2720608*^9, 
               1.094720184098862*^11}, {2.3036832*^9, 
               1.2719440059381201`*^11}, {2.3352192*^9, 
               1.5529838808012518`*^11}, {2.3667552*^9, 
               1.6827567004560587`*^11}, {2.3982912*^9, 
               2.00061864743176*^11}, {2.4299136*^9, 
               2.0490855246558777`*^11}, {2.4614496*^9, 
               2.1158699904973694`*^11}, {2.4929856*^9, 
               2.354038885269667*^11}, {2.5245216*^9, 
               2.6527162075194025`*^11}, {2.556144*^9, 
               2.9670158287541626`*^11}, {2.58768*^9, 
               3.0382902858739197`*^11}, {2.619216*^9, 
               3.2898857285467914`*^11}, {2.650752*^9, 
               3.42332183759481*^11}, {2.6823744*^9, 3.50666308740087*^11}, {
               2.7139104*^9, 3.6336595904342676`*^11}, {2.7454464*^9, 
               4.1532010633550885`*^11}, {2.7769824*^9, 
               4.9056464772996716`*^11}, {2.8086048*^9, 
               5.4728594655086096`*^11}, {2.8401408*^9, 
               5.742041096183926*^11}, {2.8716768*^9, 
               5.888384271853116*^11}, {2.9032128*^9, 5.70279426668597*^11}, {
               2.9348352*^9, 5.546898143452979*^11}, {2.9663712*^9, 
               5.558404311536865*^11}, {2.9979072*^9, 
               5.816644190490315*^11}, {3.0294432*^9, 
               6.043712052962986*^11}, {3.0610656*^9, 6.27595363337625*^11}, {
               3.0926016*^9, 6.069244392498939*^11}, {3.1241376*^9, 
               6.512017086979576*^11}, {3.1556736*^9, 
               7.144534748267805*^11}, {3.187296*^9, 7.050688372908894*^11}, {
               3.218832*^9, 7.243042892296139*^11}, {3.250368*^9, 
               8.547108065250964*^11}, {3.281904*^9, 9.767419516622521*^11}, {
               3.3135264*^9, 1.1317597770741843`*^12}}]}, {}}}, {
           AspectRatio -> GoldenRatio^(-1), AxesOrigin -> {2208988800, 0}, 
            Frame -> True, 
            FrameTicks -> {{
              Automatic, 
               Automatic}, {{{2208988800, "1970"}, {2524521600, "1980"}, {
                2840140800, "1990"}, {3155673600, "2000"}, {
                2272060800, " "}, {2335219200, " "}, {2398291200, " "}, {
                2461449600, " "}, {2587680000, " "}, {2650752000, " "}, {
                2713910400, " "}, {2776982400, " "}, {2903212800, " "}, {
                2966371200, " "}, {3029443200, " "}, {3092601600, " "}, {
                3218832000, " "}, {3281904000, " "}}, {{2208988800, " "}, {
                2524521600, " "}, {2840140800, " "}, {3155673600, " "}, {
                2272060800, " "}, {2335219200, " "}, {2398291200, " "}, {
                2461449600, " "}, {2587680000, " "}, {2650752000, " "}, {
                2713910400, " "}, {2776982400, " "}, {2903212800, " "}, {
                2966371200, " "}, {3029443200, " "}, {3092601600, " "}, {
                3218832000, " "}, {3281904000, " "}}}}, 
            GridLines -> {{{2208988800, 
                GrayLevel[0.8]}, {2524521600, 
                GrayLevel[0.8]}, {2840140800, 
                GrayLevel[0.8]}, {3155673600, 
                GrayLevel[0.8]}}, None}, 
            PlotRange -> {{2.2089888*^9, 3.3135264*^9}, {0., 
             1.1317597770741843`*^12}}, PlotRangeClipping -> True, 
            PlotRangePadding -> {
              Scaled[0.02], 
              Scaled[0.02]}, Ticks -> None}]}, False]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ]},
    {
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = True}, 
       InterpretationBox[
        StyleBox[
         PaneSelectorBox[{False->
          TagBox[GridBox[{
             {
              OpenerBox[Dynamic[Typeset`var$$],
               Appearance->Automatic,
               AutoAction->False,
               ContinuousAction->False,
               Enabled->Automatic], "\<\"France\"\>"}
            },
            BaselinePosition->{1, 1},
            ColumnsEqual->False,
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxBackground->{"Columns" -> {{Automatic}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
            RowsEqual->False],
           "Grid"], True->
          TagBox[GridBox[{
             {
              OpenerBox[Dynamic[Typeset`var$$],
               Appearance->Automatic,
               AutoAction->False,
               ContinuousAction->False,
               Enabled->Automatic], "\<\"France\"\>"},
             {"", 
              PaneBox[
               GraphicsBox[{{}, 
                 {Hue[0.67, 0.6, 0.6], 
                  PointBox[{{2.2089888*^9, 1.4860490316148856`*^11}, {
                   2.2405248*^9, 1.6599051480654675`*^11}, {2.2720608*^9, 
                   2.0370806787064062`*^11}, {2.3036832*^9, 
                   2.6392489611186478`*^11}, {2.3352192*^9, 
                   2.8178832637142487`*^11}, {2.3667552*^9, 
                   3.5608510491218945`*^11}, {2.3982912*^9, 
                   3.682859284585891*^11}, {2.4299136*^9, 
                   4.0667378485213184`*^11}, {2.4614496*^9, 
                   5.030293764523027*^11}, {2.4929856*^9, 
                   6.065025382702382*^11}, {2.5245216*^9, 
                   6.890241190158655*^11}, {2.556144*^9, 
                   6.034738136776915*^11}, {2.58768*^9, 
                   5.73916593597205*^11}, {2.619216*^9, 
                   5.526822076601039*^11}, {2.650752*^9, 
                   5.2512930500900977`*^11}, {2.6823744*^9, 
                   5.489972719697796*^11}, {2.7139104*^9, 
                   7.642085878650359*^11}, {2.7454464*^9, 
                   9.25744668315392*^11}, {2.7769824*^9, 
                   1.0065906584591847`*^12}, {2.8086048*^9, 
                   1.0080845330770159`*^12}, {2.8401408*^9, 
                   1.239216273221249*^12}, {2.8716768*^9, 
                   1.2382601056413403`*^12}, {2.9032128*^9, 
                   1.3716431138354666`*^12}, {2.9348352*^9, 
                   1.291925428637067*^12}, {2.9663712*^9, 
                   1.3651592829157007`*^12}, {2.9979072*^9, 
                   1.5701600445521953`*^12}, {3.0294432*^9, 
                   1.574359362801807*^12}, {3.0610656*^9, 
                   1.4255858862792654`*^12}, {3.0926016*^9, 
                   1.4727634653137236`*^12}, {3.1241376*^9, 
                   1.455813223397778*^12}, {3.1556736*^9, 
                   1.3279619433987944`*^12}, {3.187296*^9, 
                   1.3397410314001665`*^12}, {3.218832*^9, 
                   1.457392660121621*^12}, {3.250368*^9, 
                   1.799946390329191*^12}, {3.281904*^9, 
                   2.0599603906303352`*^12}, {3.3135264*^9, 
                   2.1265776254725664`*^12}}]}, {}},
                AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                AxesOrigin->NCache[{2208988800, 0}, {2.2089888*^9, 0}],
                Frame->True,
                FrameTicks->{{Automatic, Automatic}, {{{
                    NCache[2208988800, 2.2089888*^9], 
                    FormBox["\"1970\"", TraditionalForm]}, {
                    NCache[2524521600, 2.5245216*^9], 
                    FormBox["\"1980\"", TraditionalForm]}, {
                    NCache[2840140800, 2.8401408*^9], 
                    FormBox["\"1990\"", TraditionalForm]}, {
                    NCache[3155673600, 3.1556736*^9], 
                    FormBox["\"2000\"", TraditionalForm]}, {
                    NCache[2272060800, 2.2720608*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2335219200, 2.3352192*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2398291200, 2.3982912*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2461449600, 2.4614496*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2587680000, 2.58768*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2650752000, 2.650752*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2713910400, 2.7139104*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2776982400, 2.7769824*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2903212800, 2.9032128*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2966371200, 2.9663712*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3029443200, 3.0294432*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3092601600, 3.0926016*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3218832000, 3.218832*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3281904000, 3.281904*^9], 
                    FormBox["\" \"", TraditionalForm]}}, {{
                    NCache[2208988800, 2.2089888*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2524521600, 2.5245216*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2840140800, 2.8401408*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3155673600, 3.1556736*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2272060800, 2.2720608*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2335219200, 2.3352192*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2398291200, 2.3982912*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2461449600, 2.4614496*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2587680000, 2.58768*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2650752000, 2.650752*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2713910400, 2.7139104*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2776982400, 2.7769824*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2903212800, 2.9032128*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2966371200, 2.9663712*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3029443200, 3.0294432*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3092601600, 3.0926016*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3218832000, 3.218832*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3281904000, 3.281904*^9], 
                    FormBox["\" \"", TraditionalForm]}}}},
                GridLines->NCache[{{{2208988800, 
                    GrayLevel[0.8]}, {2524521600, 
                    GrayLevel[0.8]}, {2840140800, 
                    GrayLevel[0.8]}, {3155673600, 
                    GrayLevel[0.8]}}, None}, {{{2.2089888*^9, 
                    GrayLevel[0.8]}, {2.5245216*^9, 
                    GrayLevel[0.8]}, {2.8401408*^9, 
                    GrayLevel[0.8]}, {3.1556736*^9, 
                    GrayLevel[0.8]}}, None}],
                
                PlotRange->{{2.2089888*^9, 3.3135264*^9}, {0., 
                 2.1265776254725664`*^12}},
                PlotRangeClipping->True,
                PlotRangePadding->{
                  Scaled[0.02], 
                  Scaled[0.02]},
                Ticks->None],
               ImageMargins->0]}
            },
            BaselinePosition->{1, 1},
            ColumnsEqual->False,
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxBackground->{"Columns" -> {{Automatic}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
            RowsEqual->False],
           "Grid"]}, Dynamic[Typeset`var$$],
          Alignment->Automatic,
          BaselinePosition->Baseline,
          DefaultBaseStyle->"OpenerView",
          ImageMargins->0,
          ImageSize->Automatic],
         Deployed->False,
         StripOnInput->False],
        OpenerView[{"France", 
          Graphics[{{{}, {
              Hue[0.67, 0.6, 0.6], 
              
              Point[{{2.2089888*^9, 1.4860490316148856`*^11}, {2.2405248*^9, 
               1.6599051480654675`*^11}, {2.2720608*^9, 
               2.0370806787064062`*^11}, {2.3036832*^9, 
               2.6392489611186478`*^11}, {2.3352192*^9, 
               2.8178832637142487`*^11}, {2.3667552*^9, 
               3.5608510491218945`*^11}, {2.3982912*^9, 
               3.682859284585891*^11}, {2.4299136*^9, 
               4.0667378485213184`*^11}, {2.4614496*^9, 
               5.030293764523027*^11}, {2.4929856*^9, 
               6.065025382702382*^11}, {2.5245216*^9, 
               6.890241190158655*^11}, {2.556144*^9, 6.034738136776915*^11}, {
               2.58768*^9, 5.73916593597205*^11}, {2.619216*^9, 
               5.526822076601039*^11}, {2.650752*^9, 
               5.2512930500900977`*^11}, {2.6823744*^9, 
               5.489972719697796*^11}, {2.7139104*^9, 
               7.642085878650359*^11}, {2.7454464*^9, 9.25744668315392*^11}, {
               2.7769824*^9, 1.0065906584591847`*^12}, {2.8086048*^9, 
               1.0080845330770159`*^12}, {2.8401408*^9, 
               1.239216273221249*^12}, {2.8716768*^9, 
               1.2382601056413403`*^12}, {2.9032128*^9, 
               1.3716431138354666`*^12}, {2.9348352*^9, 
               1.291925428637067*^12}, {2.9663712*^9, 
               1.3651592829157007`*^12}, {2.9979072*^9, 
               1.5701600445521953`*^12}, {3.0294432*^9, 
               1.574359362801807*^12}, {3.0610656*^9, 
               1.4255858862792654`*^12}, {3.0926016*^9, 
               1.4727634653137236`*^12}, {3.1241376*^9, 
               1.455813223397778*^12}, {3.1556736*^9, 
               1.3279619433987944`*^12}, {3.187296*^9, 
               1.3397410314001665`*^12}, {3.218832*^9, 
               1.457392660121621*^12}, {3.250368*^9, 1.799946390329191*^12}, {
               3.281904*^9, 2.0599603906303352`*^12}, {3.3135264*^9, 
               2.1265776254725664`*^12}}]}, {}}}, {
           AspectRatio -> GoldenRatio^(-1), AxesOrigin -> {2208988800, 0}, 
            Frame -> True, 
            FrameTicks -> {{
              Automatic, 
               Automatic}, {{{2208988800, "1970"}, {2524521600, "1980"}, {
                2840140800, "1990"}, {3155673600, "2000"}, {
                2272060800, " "}, {2335219200, " "}, {2398291200, " "}, {
                2461449600, " "}, {2587680000, " "}, {2650752000, " "}, {
                2713910400, " "}, {2776982400, " "}, {2903212800, " "}, {
                2966371200, " "}, {3029443200, " "}, {3092601600, " "}, {
                3218832000, " "}, {3281904000, " "}}, {{2208988800, " "}, {
                2524521600, " "}, {2840140800, " "}, {3155673600, " "}, {
                2272060800, " "}, {2335219200, " "}, {2398291200, " "}, {
                2461449600, " "}, {2587680000, " "}, {2650752000, " "}, {
                2713910400, " "}, {2776982400, " "}, {2903212800, " "}, {
                2966371200, " "}, {3029443200, " "}, {3092601600, " "}, {
                3218832000, " "}, {3281904000, " "}}}}, 
            GridLines -> {{{2208988800, 
                GrayLevel[0.8]}, {2524521600, 
                GrayLevel[0.8]}, {2840140800, 
                GrayLevel[0.8]}, {3155673600, 
                GrayLevel[0.8]}}, None}, 
            PlotRange -> {{2.2089888*^9, 3.3135264*^9}, {0., 
             2.1265776254725664`*^12}}, PlotRangeClipping -> True, 
            PlotRangePadding -> {
              Scaled[0.02], 
              Scaled[0.02]}, Ticks -> None}]}, False]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ]},
    {
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = False}, 
       InterpretationBox[
        StyleBox[
         PaneSelectorBox[{False->
          TagBox[GridBox[{
             {
              OpenerBox[Dynamic[Typeset`var$$],
               Appearance->Automatic,
               AutoAction->False,
               ContinuousAction->False,
               Enabled->Automatic], "\<\"Germany\"\>"}
            },
            BaselinePosition->{1, 1},
            ColumnsEqual->False,
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxBackground->{"Columns" -> {{Automatic}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
            RowsEqual->False],
           "Grid"], True->
          TagBox[GridBox[{
             {
              OpenerBox[Dynamic[Typeset`var$$],
               Appearance->Automatic,
               AutoAction->False,
               ContinuousAction->False,
               Enabled->Automatic], "\<\"Germany\"\>"},
             {"", 
              PaneBox[
               GraphicsBox[{{}, 
                 {Hue[0.67, 0.6, 0.6], 
                  PointBox[{{2.2089888*^9, 2.0810384443389188`*^11}, {
                   2.2405248*^9, 2.406633633299223*^11}, {2.2720608*^9, 
                   2.901008009718065*^11}, {2.3036832*^9, 
                   3.859488165006181*^11}, {2.3352192*^9, 
                   4.294585203779621*^11}, {2.3667552*^9, 
                   4.7140775174106274`*^11}, {2.3982912*^9, 
                   5.0176605229263135`*^11}, {2.4299136*^9, 
                   5.811627444679083*^11}, {2.4614496*^9, 
                   7.210086697895739*^11}, {2.4929856*^9, 
                   8.529460356368018*^11}, {2.5245216*^9, 
                   9.12584520044493*^11}, {2.556144*^9, 
                   7.661408754107075*^11}, {2.58768*^9, 
                   7.417212813241608*^11}, {2.619216*^9, 
                   7.391623711685114*^11}, {2.650752*^9, 
                   6.956865796672733*^11}, {2.6823744*^9, 
                   7.021427484597816*^11}, {2.7139104*^9, 
                   1.0066288875939098`*^12}, {2.7454464*^9, 
                   1.2559866089578115`*^12}, {2.7769824*^9, 
                   1.3534382051911914`*^12}, {2.8086048*^9, 
                   1.344638146460924*^12}, {2.8401408*^9, 
                   1.7073594468832742`*^12}, {2.8716768*^9, 
                   1.8085817176429229`*^12}, {2.9032128*^9, 
                   2.0622474911792007`*^12}, {2.9348352*^9, 
                   2.004389958855537*^12}, {2.9663712*^9, 
                   2.1462382715819878`*^12}, {2.9979072*^9, 
                   2.5226236677348384`*^12}, {3.0294432*^9, 
                   2.438564676803662*^12}, {3.0610656*^9, 
                   2.1605698959520244`*^12}, {3.0926016*^9, 
                   2.1844745936107478`*^12}, {3.1241376*^9, 
                   2.1435558626971543`*^12}, {3.1556736*^9, 
                   1.9002196577147825`*^12}, {3.187296*^9, 
                   1.8909539959373965`*^12}, {3.218832*^9, 
                   2.0187441865571965`*^12}, {3.250368*^9, 
                   2.4416665647769404`*^12}, {3.281904*^9, 
                   2.7511128494533535`*^12}, {3.3135264*^9, 
                   2.794856489081232*^12}}]}, {}},
                AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                AxesOrigin->NCache[{2208988800, 0}, {2.2089888*^9, 0}],
                Frame->True,
                FrameTicks->{{Automatic, Automatic}, {{{
                    NCache[2208988800, 2.2089888*^9], 
                    FormBox["\"1970\"", TraditionalForm]}, {
                    NCache[2524521600, 2.5245216*^9], 
                    FormBox["\"1980\"", TraditionalForm]}, {
                    NCache[2840140800, 2.8401408*^9], 
                    FormBox["\"1990\"", TraditionalForm]}, {
                    NCache[3155673600, 3.1556736*^9], 
                    FormBox["\"2000\"", TraditionalForm]}, {
                    NCache[2272060800, 2.2720608*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2335219200, 2.3352192*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2398291200, 2.3982912*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2461449600, 2.4614496*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2587680000, 2.58768*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2650752000, 2.650752*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2713910400, 2.7139104*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2776982400, 2.7769824*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2903212800, 2.9032128*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2966371200, 2.9663712*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3029443200, 3.0294432*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3092601600, 3.0926016*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3218832000, 3.218832*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3281904000, 3.281904*^9], 
                    FormBox["\" \"", TraditionalForm]}}, {{
                    NCache[2208988800, 2.2089888*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2524521600, 2.5245216*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2840140800, 2.8401408*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3155673600, 3.1556736*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2272060800, 2.2720608*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2335219200, 2.3352192*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2398291200, 2.3982912*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2461449600, 2.4614496*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2587680000, 2.58768*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2650752000, 2.650752*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2713910400, 2.7139104*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2776982400, 2.7769824*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2903212800, 2.9032128*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2966371200, 2.9663712*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3029443200, 3.0294432*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3092601600, 3.0926016*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3218832000, 3.218832*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3281904000, 3.281904*^9], 
                    FormBox["\" \"", TraditionalForm]}}}},
                GridLines->NCache[{{{2208988800, 
                    GrayLevel[0.8]}, {2524521600, 
                    GrayLevel[0.8]}, {2840140800, 
                    GrayLevel[0.8]}, {3155673600, 
                    GrayLevel[0.8]}}, None}, {{{2.2089888*^9, 
                    GrayLevel[0.8]}, {2.5245216*^9, 
                    GrayLevel[0.8]}, {2.8401408*^9, 
                    GrayLevel[0.8]}, {3.1556736*^9, 
                    GrayLevel[0.8]}}, None}],
                
                PlotRange->{{2.2089888*^9, 3.3135264*^9}, {0., 
                 2.794856489081232*^12}},
                PlotRangeClipping->True,
                PlotRangePadding->{
                  Scaled[0.02], 
                  Scaled[0.02]},
                Ticks->None],
               ImageMargins->0]}
            },
            BaselinePosition->{1, 1},
            ColumnsEqual->False,
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxBackground->{"Columns" -> {{Automatic}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
            RowsEqual->False],
           "Grid"]}, Dynamic[Typeset`var$$],
          Alignment->Automatic,
          BaselinePosition->Baseline,
          DefaultBaseStyle->"OpenerView",
          ImageMargins->0,
          ImageSize->Automatic],
         Deployed->False,
         StripOnInput->False],
        OpenerView[{"Germany", 
          Graphics[{{{}, {
              Hue[0.67, 0.6, 0.6], 
              
              Point[{{2.2089888*^9, 2.0810384443389188`*^11}, {2.2405248*^9, 
               2.406633633299223*^11}, {2.2720608*^9, 
               2.901008009718065*^11}, {2.3036832*^9, 
               3.859488165006181*^11}, {2.3352192*^9, 
               4.294585203779621*^11}, {2.3667552*^9, 
               4.7140775174106274`*^11}, {2.3982912*^9, 
               5.0176605229263135`*^11}, {2.4299136*^9, 
               5.811627444679083*^11}, {2.4614496*^9, 
               7.210086697895739*^11}, {2.4929856*^9, 
               8.529460356368018*^11}, {2.5245216*^9, 9.12584520044493*^11}, {
               2.556144*^9, 7.661408754107075*^11}, {2.58768*^9, 
               7.417212813241608*^11}, {2.619216*^9, 7.391623711685114*^11}, {
               2.650752*^9, 6.956865796672733*^11}, {2.6823744*^9, 
               7.021427484597816*^11}, {2.7139104*^9, 
               1.0066288875939098`*^12}, {2.7454464*^9, 
               1.2559866089578115`*^12}, {2.7769824*^9, 
               1.3534382051911914`*^12}, {2.8086048*^9, 
               1.344638146460924*^12}, {2.8401408*^9, 
               1.7073594468832742`*^12}, {2.8716768*^9, 
               1.8085817176429229`*^12}, {2.9032128*^9, 
               2.0622474911792007`*^12}, {2.9348352*^9, 
               2.004389958855537*^12}, {2.9663712*^9, 
               2.1462382715819878`*^12}, {2.9979072*^9, 
               2.5226236677348384`*^12}, {3.0294432*^9, 
               2.438564676803662*^12}, {3.0610656*^9, 
               2.1605698959520244`*^12}, {3.0926016*^9, 
               2.1844745936107478`*^12}, {3.1241376*^9, 
               2.1435558626971543`*^12}, {3.1556736*^9, 
               1.9002196577147825`*^12}, {3.187296*^9, 
               1.8909539959373965`*^12}, {3.218832*^9, 
               2.0187441865571965`*^12}, {3.250368*^9, 
               2.4416665647769404`*^12}, {3.281904*^9, 
               2.7511128494533535`*^12}, {3.3135264*^9, 
               2.794856489081232*^12}}]}, {}}}, {
           AspectRatio -> GoldenRatio^(-1), AxesOrigin -> {2208988800, 0}, 
            Frame -> True, 
            FrameTicks -> {{
              Automatic, 
               Automatic}, {{{2208988800, "1970"}, {2524521600, "1980"}, {
                2840140800, "1990"}, {3155673600, "2000"}, {
                2272060800, " "}, {2335219200, " "}, {2398291200, " "}, {
                2461449600, " "}, {2587680000, " "}, {2650752000, " "}, {
                2713910400, " "}, {2776982400, " "}, {2903212800, " "}, {
                2966371200, " "}, {3029443200, " "}, {3092601600, " "}, {
                3218832000, " "}, {3281904000, " "}}, {{2208988800, " "}, {
                2524521600, " "}, {2840140800, " "}, {3155673600, " "}, {
                2272060800, " "}, {2335219200, " "}, {2398291200, " "}, {
                2461449600, " "}, {2587680000, " "}, {2650752000, " "}, {
                2713910400, " "}, {2776982400, " "}, {2903212800, " "}, {
                2966371200, " "}, {3029443200, " "}, {3092601600, " "}, {
                3218832000, " "}, {3281904000, " "}}}}, 
            GridLines -> {{{2208988800, 
                GrayLevel[0.8]}, {2524521600, 
                GrayLevel[0.8]}, {2840140800, 
                GrayLevel[0.8]}, {3155673600, 
                GrayLevel[0.8]}}, None}, 
            PlotRange -> {{2.2089888*^9, 3.3135264*^9}, {0., 
             2.794856489081232*^12}}, PlotRangeClipping -> True, 
            PlotRangePadding -> {
              Scaled[0.02], 
              Scaled[0.02]}, Ticks -> None}]}, False]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ]},
    {
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = False}, 
       InterpretationBox[
        StyleBox[
         PaneSelectorBox[{False->
          TagBox[GridBox[{
             {
              OpenerBox[Dynamic[Typeset`var$$],
               Appearance->Automatic,
               AutoAction->False,
               ContinuousAction->False,
               Enabled->Automatic], "\<\"Italy\"\>"}
            },
            BaselinePosition->{1, 1},
            ColumnsEqual->False,
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxBackground->{"Columns" -> {{Automatic}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
            RowsEqual->False],
           "Grid"], True->
          TagBox[GridBox[{
             {
              OpenerBox[Dynamic[Typeset`var$$],
               Appearance->Automatic,
               AutoAction->False,
               ContinuousAction->False,
               Enabled->Automatic], "\<\"Italy\"\>"},
             {"", 
              PaneBox[
               GraphicsBox[{{}, 
                 {Hue[0.67, 0.6, 0.6], 
                  PointBox[{{2.2089888*^9, 1.1001857267906438`*^11}, {
                   2.2405248*^9, 1.208138060400842*^11}, {2.2720608*^9, 
                   1.4051891364948038`*^11}, {2.3036832*^9, 
                   1.6924997901562256`*^11}, {2.3352192*^9, 
                   1.9190272481504858`*^11}, {2.3667552*^9, 
                   2.180850414845017*^11}, {2.3982912*^9, 
                   2.147967296050531*^11}, {2.4299136*^9, 
                   2.4615984711328445`*^11}, {2.4614496*^9, 
                   3.0110685730610004`*^11}, {2.4929856*^9, 
                   3.7633987340165295`*^11}, {2.5245216*^9, 
                   4.5847054570827466`*^11}, {2.556144*^9, 
                   4.143881892309424*^11}, {2.58768*^9, 
                   4.1068947165956665`*^11}, {2.619216*^9, 
                   4.259969852143084*^11}, {2.650752*^9, 
                   4.2190574220929376`*^11}, {2.6823744*^9, 
                   4.353899537941441*^11}, {2.7139104*^9, 
                   6.169717535000852*^11}, {2.7454464*^9, 
                   7.76334491116145*^11}, {2.7769824*^9, 
                   8.590083924665312*^11}, {2.8086048*^9, 
                   8.947177390136152*^11}, {2.8401408*^9, 
                   1.13346545429888*^12}, {2.8716768*^9, 
                   1.1952212090324875`*^12}, {2.9032128*^9, 
                   1.265830956132651*^12}, {2.9348352*^9, 
                   1.0209509577101204`*^12}, {2.9663712*^9, 
                   1.0539769534685912`*^12}, {2.9979072*^9, 
                   1.126076542839802*^12}, {3.0294432*^9, 
                   1.2596573470019568`*^12}, {3.0610656*^9, 
                   1.19235440187141*^12}, {3.0926016*^9, 
                   1.2171187235257039`*^12}, {3.1241376*^9, 
                   1.2007866317323293`*^12}, {3.1556736*^9, 
                   1.0973432886781492`*^12}, {3.187296*^9, 
                   1.1173484826847188`*^12}, {3.218832*^9, 
                   1.2189766944107778`*^12}, {3.250368*^9, 
                   1.507113125025088*^12}, {3.281904*^9, 
                   1.724522852463169*^12}, {3.3135264*^9, 
                   1.7624749651606726`*^12}}]}, {}},
                AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                AxesOrigin->NCache[{2208988800, 0}, {2.2089888*^9, 0}],
                Frame->True,
                FrameTicks->{{Automatic, Automatic}, {{{
                    NCache[2208988800, 2.2089888*^9], 
                    FormBox["\"1970\"", TraditionalForm]}, {
                    NCache[2524521600, 2.5245216*^9], 
                    FormBox["\"1980\"", TraditionalForm]}, {
                    NCache[2840140800, 2.8401408*^9], 
                    FormBox["\"1990\"", TraditionalForm]}, {
                    NCache[3155673600, 3.1556736*^9], 
                    FormBox["\"2000\"", TraditionalForm]}, {
                    NCache[2272060800, 2.2720608*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2335219200, 2.3352192*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2398291200, 2.3982912*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2461449600, 2.4614496*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2587680000, 2.58768*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2650752000, 2.650752*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2713910400, 2.7139104*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2776982400, 2.7769824*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2903212800, 2.9032128*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2966371200, 2.9663712*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3029443200, 3.0294432*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3092601600, 3.0926016*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3218832000, 3.218832*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3281904000, 3.281904*^9], 
                    FormBox["\" \"", TraditionalForm]}}, {{
                    NCache[2208988800, 2.2089888*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2524521600, 2.5245216*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2840140800, 2.8401408*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3155673600, 3.1556736*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2272060800, 2.2720608*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2335219200, 2.3352192*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2398291200, 2.3982912*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2461449600, 2.4614496*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2587680000, 2.58768*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2650752000, 2.650752*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2713910400, 2.7139104*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2776982400, 2.7769824*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2903212800, 2.9032128*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2966371200, 2.9663712*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3029443200, 3.0294432*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3092601600, 3.0926016*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3218832000, 3.218832*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3281904000, 3.281904*^9], 
                    FormBox["\" \"", TraditionalForm]}}}},
                GridLines->NCache[{{{2208988800, 
                    GrayLevel[0.8]}, {2524521600, 
                    GrayLevel[0.8]}, {2840140800, 
                    GrayLevel[0.8]}, {3155673600, 
                    GrayLevel[0.8]}}, None}, {{{2.2089888*^9, 
                    GrayLevel[0.8]}, {2.5245216*^9, 
                    GrayLevel[0.8]}, {2.8401408*^9, 
                    GrayLevel[0.8]}, {3.1556736*^9, 
                    GrayLevel[0.8]}}, None}],
                
                PlotRange->{{2.2089888*^9, 3.3135264*^9}, {0., 
                 1.7624749651606726`*^12}},
                PlotRangeClipping->True,
                PlotRangePadding->{
                  Scaled[0.02], 
                  Scaled[0.02]},
                Ticks->None],
               ImageMargins->0]}
            },
            BaselinePosition->{1, 1},
            ColumnsEqual->False,
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxBackground->{"Columns" -> {{Automatic}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
            RowsEqual->False],
           "Grid"]}, Dynamic[Typeset`var$$],
          Alignment->Automatic,
          BaselinePosition->Baseline,
          DefaultBaseStyle->"OpenerView",
          ImageMargins->0,
          ImageSize->Automatic],
         Deployed->False,
         StripOnInput->False],
        OpenerView[{"Italy", 
          Graphics[{{{}, {
              Hue[0.67, 0.6, 0.6], 
              
              Point[{{2.2089888*^9, 1.1001857267906438`*^11}, {2.2405248*^9, 
               1.208138060400842*^11}, {2.2720608*^9, 
               1.4051891364948038`*^11}, {2.3036832*^9, 
               1.6924997901562256`*^11}, {2.3352192*^9, 
               1.9190272481504858`*^11}, {2.3667552*^9, 
               2.180850414845017*^11}, {2.3982912*^9, 
               2.147967296050531*^11}, {2.4299136*^9, 
               2.4615984711328445`*^11}, {2.4614496*^9, 
               3.0110685730610004`*^11}, {2.4929856*^9, 
               3.7633987340165295`*^11}, {2.5245216*^9, 
               4.5847054570827466`*^11}, {2.556144*^9, 
               4.143881892309424*^11}, {2.58768*^9, 
               4.1068947165956665`*^11}, {2.619216*^9, 
               4.259969852143084*^11}, {2.650752*^9, 
               4.2190574220929376`*^11}, {2.6823744*^9, 
               4.353899537941441*^11}, {2.7139104*^9, 
               6.169717535000852*^11}, {2.7454464*^9, 7.76334491116145*^11}, {
               2.7769824*^9, 8.590083924665312*^11}, {2.8086048*^9, 
               8.947177390136152*^11}, {2.8401408*^9, 1.13346545429888*^12}, {
               2.8716768*^9, 1.1952212090324875`*^12}, {2.9032128*^9, 
               1.265830956132651*^12}, {2.9348352*^9, 
               1.0209509577101204`*^12}, {2.9663712*^9, 
               1.0539769534685912`*^12}, {2.9979072*^9, 
               1.126076542839802*^12}, {3.0294432*^9, 
               1.2596573470019568`*^12}, {3.0610656*^9, 
               1.19235440187141*^12}, {3.0926016*^9, 
               1.2171187235257039`*^12}, {3.1241376*^9, 
               1.2007866317323293`*^12}, {3.1556736*^9, 
               1.0973432886781492`*^12}, {3.187296*^9, 
               1.1173484826847188`*^12}, {3.218832*^9, 
               1.2189766944107778`*^12}, {3.250368*^9, 
               1.507113125025088*^12}, {3.281904*^9, 1.724522852463169*^12}, {
               3.3135264*^9, 1.7624749651606726`*^12}}]}, {}}}, {
           AspectRatio -> GoldenRatio^(-1), AxesOrigin -> {2208988800, 0}, 
            Frame -> True, 
            FrameTicks -> {{
              Automatic, 
               Automatic}, {{{2208988800, "1970"}, {2524521600, "1980"}, {
                2840140800, "1990"}, {3155673600, "2000"}, {
                2272060800, " "}, {2335219200, " "}, {2398291200, " "}, {
                2461449600, " "}, {2587680000, " "}, {2650752000, " "}, {
                2713910400, " "}, {2776982400, " "}, {2903212800, " "}, {
                2966371200, " "}, {3029443200, " "}, {3092601600, " "}, {
                3218832000, " "}, {3281904000, " "}}, {{2208988800, " "}, {
                2524521600, " "}, {2840140800, " "}, {3155673600, " "}, {
                2272060800, " "}, {2335219200, " "}, {2398291200, " "}, {
                2461449600, " "}, {2587680000, " "}, {2650752000, " "}, {
                2713910400, " "}, {2776982400, " "}, {2903212800, " "}, {
                2966371200, " "}, {3029443200, " "}, {3092601600, " "}, {
                3218832000, " "}, {3281904000, " "}}}}, 
            GridLines -> {{{2208988800, 
                GrayLevel[0.8]}, {2524521600, 
                GrayLevel[0.8]}, {2840140800, 
                GrayLevel[0.8]}, {3155673600, 
                GrayLevel[0.8]}}, None}, 
            PlotRange -> {{2.2089888*^9, 3.3135264*^9}, {0., 
             1.7624749651606726`*^12}}, PlotRangeClipping -> True, 
            PlotRangePadding -> {
              Scaled[0.02], 
              Scaled[0.02]}, Ticks -> None}]}, False]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ]},
    {
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = False}, 
       InterpretationBox[
        StyleBox[
         PaneSelectorBox[{False->
          TagBox[GridBox[{
             {
              OpenerBox[Dynamic[Typeset`var$$],
               Appearance->Automatic,
               AutoAction->False,
               ContinuousAction->False,
               Enabled->Automatic], "\<\"Japan\"\>"}
            },
            BaselinePosition->{1, 1},
            ColumnsEqual->False,
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxBackground->{"Columns" -> {{Automatic}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
            RowsEqual->False],
           "Grid"], True->
          TagBox[GridBox[{
             {
              OpenerBox[Dynamic[Typeset`var$$],
               Appearance->Automatic,
               AutoAction->False,
               ContinuousAction->False,
               Enabled->Automatic], "\<\"Japan\"\>"},
             {"", 
              PaneBox[
               GraphicsBox[{{}, 
                 {Hue[0.67, 0.6, 0.6], 
                  PointBox[{{2.2089888*^9, 2.014529580514261*^11}, {
                   2.2405248*^9, 2.2755033969951434`*^11}, {2.2720608*^9, 
                   3.01343259543402*^11}, {2.3036832*^9, 
                   4.094100716072971*^11}, {2.3352192*^9, 
                   4.544586112238592*^11}, {2.3667552*^9, 
                   4.941750673051077*^11}, {2.3982912*^9, 
                   5.554042215464973*^11}, {2.4299136*^9, 
                   6.835571874274996*^11}, {2.4614496*^9, 
                   9.604251124685349*^11}, {2.4929856*^9, 
                   9.996525293671614*^11}, {2.5245216*^9, 
                   1.0473829652743596`*^12}, {2.556144*^9, 
                   1.1575808025550977`*^12}, {2.58768*^9, 
                   1.0757971376079556`*^12}, {2.619216*^9, 
                   1.173473359359394*^12}, {2.650752*^9, 
                   1.2486767468971565`*^12}, {2.6823744*^9, 
                   1.3367483967990293`*^12}, {2.7139104*^9, 
                   1.980635436908171*^12}, {2.7454464*^9, 
                   2.4020878317749478`*^12}, {2.7769824*^9, 
                   2.91659077365674*^12}, {2.8086048*^9, 
                   2.9183378659623613`*^12}, {2.8401408*^9, 
                   2.9957356166212617`*^12}, {2.8716768*^9, 
                   3.4256890248509097`*^12}, {2.9032128*^9, 
                   3.738954620999907*^12}, {2.9348352*^9, 
                   4.291732742888624*^12}, {2.9663712*^9, 
                   4.724875099850551*^12}, {2.9979072*^9, 
                   5.206658298158463*^12}, {3.0294432*^9, 
                   4.620456505153843*^12}, {3.0610656*^9, 
                   4.233781703969587*^12}, {3.0926016*^9, 
                   3.842264579344679*^12}, {3.1241376*^9, 
                   4.3476498177611074`*^12}, {3.1556736*^9, 
                   4.649615208479153*^12}, {3.187296*^9, 
                   4.0877240379293174`*^12}, {3.218832*^9, 
                   3.904826021289916*^12}, {3.250368*^9, 
                   4.231250256567769*^12}, {3.281904*^9, 
                   4.584885115685265*^12}, {3.3135264*^9, 
                   4.558949854127995*^12}}]}, {}},
                AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                AxesOrigin->NCache[{2208988800, 0}, {2.2089888*^9, 0}],
                Frame->True,
                FrameTicks->{{Automatic, Automatic}, {{{
                    NCache[2208988800, 2.2089888*^9], 
                    FormBox["\"1970\"", TraditionalForm]}, {
                    NCache[2524521600, 2.5245216*^9], 
                    FormBox["\"1980\"", TraditionalForm]}, {
                    NCache[2840140800, 2.8401408*^9], 
                    FormBox["\"1990\"", TraditionalForm]}, {
                    NCache[3155673600, 3.1556736*^9], 
                    FormBox["\"2000\"", TraditionalForm]}, {
                    NCache[2272060800, 2.2720608*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2335219200, 2.3352192*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2398291200, 2.3982912*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2461449600, 2.4614496*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2587680000, 2.58768*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2650752000, 2.650752*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2713910400, 2.7139104*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2776982400, 2.7769824*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2903212800, 2.9032128*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2966371200, 2.9663712*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3029443200, 3.0294432*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3092601600, 3.0926016*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3218832000, 3.218832*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3281904000, 3.281904*^9], 
                    FormBox["\" \"", TraditionalForm]}}, {{
                    NCache[2208988800, 2.2089888*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2524521600, 2.5245216*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2840140800, 2.8401408*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3155673600, 3.1556736*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2272060800, 2.2720608*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2335219200, 2.3352192*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2398291200, 2.3982912*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2461449600, 2.4614496*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2587680000, 2.58768*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2650752000, 2.650752*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2713910400, 2.7139104*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2776982400, 2.7769824*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2903212800, 2.9032128*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2966371200, 2.9663712*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3029443200, 3.0294432*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3092601600, 3.0926016*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3218832000, 3.218832*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3281904000, 3.281904*^9], 
                    FormBox["\" \"", TraditionalForm]}}}},
                GridLines->NCache[{{{2208988800, 
                    GrayLevel[0.8]}, {2524521600, 
                    GrayLevel[0.8]}, {2840140800, 
                    GrayLevel[0.8]}, {3155673600, 
                    GrayLevel[0.8]}}, None}, {{{2.2089888*^9, 
                    GrayLevel[0.8]}, {2.5245216*^9, 
                    GrayLevel[0.8]}, {2.8401408*^9, 
                    GrayLevel[0.8]}, {3.1556736*^9, 
                    GrayLevel[0.8]}}, None}],
                
                PlotRange->{{2.2089888*^9, 3.3135264*^9}, {0., 
                 5.206658298158463*^12}},
                PlotRangeClipping->True,
                PlotRangePadding->{
                  Scaled[0.02], 
                  Scaled[0.02]},
                Ticks->None],
               ImageMargins->0]}
            },
            BaselinePosition->{1, 1},
            ColumnsEqual->False,
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxBackground->{"Columns" -> {{Automatic}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
            RowsEqual->False],
           "Grid"]}, Dynamic[Typeset`var$$],
          Alignment->Automatic,
          BaselinePosition->Baseline,
          DefaultBaseStyle->"OpenerView",
          ImageMargins->0,
          ImageSize->Automatic],
         Deployed->False,
         StripOnInput->False],
        OpenerView[{"Japan", 
          Graphics[{{{}, {
              Hue[0.67, 0.6, 0.6], 
              
              Point[{{2.2089888*^9, 2.014529580514261*^11}, {2.2405248*^9, 
               2.2755033969951434`*^11}, {2.2720608*^9, 
               3.01343259543402*^11}, {2.3036832*^9, 4.094100716072971*^11}, {
               2.3352192*^9, 4.544586112238592*^11}, {2.3667552*^9, 
               4.941750673051077*^11}, {2.3982912*^9, 
               5.554042215464973*^11}, {2.4299136*^9, 
               6.835571874274996*^11}, {2.4614496*^9, 
               9.604251124685349*^11}, {2.4929856*^9, 
               9.996525293671614*^11}, {2.5245216*^9, 
               1.0473829652743596`*^12}, {2.556144*^9, 
               1.1575808025550977`*^12}, {2.58768*^9, 
               1.0757971376079556`*^12}, {2.619216*^9, 
               1.173473359359394*^12}, {2.650752*^9, 
               1.2486767468971565`*^12}, {2.6823744*^9, 
               1.3367483967990293`*^12}, {2.7139104*^9, 
               1.980635436908171*^12}, {2.7454464*^9, 
               2.4020878317749478`*^12}, {2.7769824*^9, 
               2.91659077365674*^12}, {2.8086048*^9, 
               2.9183378659623613`*^12}, {2.8401408*^9, 
               2.9957356166212617`*^12}, {2.8716768*^9, 
               3.4256890248509097`*^12}, {2.9032128*^9, 
               3.738954620999907*^12}, {2.9348352*^9, 
               4.291732742888624*^12}, {2.9663712*^9, 
               4.724875099850551*^12}, {2.9979072*^9, 
               5.206658298158463*^12}, {3.0294432*^9, 
               4.620456505153843*^12}, {3.0610656*^9, 
               4.233781703969587*^12}, {3.0926016*^9, 
               3.842264579344679*^12}, {3.1241376*^9, 
               4.3476498177611074`*^12}, {3.1556736*^9, 
               4.649615208479153*^12}, {3.187296*^9, 
               4.0877240379293174`*^12}, {3.218832*^9, 
               3.904826021289916*^12}, {3.250368*^9, 4.231250256567769*^12}, {
               3.281904*^9, 4.584885115685265*^12}, {3.3135264*^9, 
               4.558949854127995*^12}}]}, {}}}, {
           AspectRatio -> GoldenRatio^(-1), AxesOrigin -> {2208988800, 0}, 
            Frame -> True, 
            FrameTicks -> {{
              Automatic, 
               Automatic}, {{{2208988800, "1970"}, {2524521600, "1980"}, {
                2840140800, "1990"}, {3155673600, "2000"}, {
                2272060800, " "}, {2335219200, " "}, {2398291200, " "}, {
                2461449600, " "}, {2587680000, " "}, {2650752000, " "}, {
                2713910400, " "}, {2776982400, " "}, {2903212800, " "}, {
                2966371200, " "}, {3029443200, " "}, {3092601600, " "}, {
                3218832000, " "}, {3281904000, " "}}, {{2208988800, " "}, {
                2524521600, " "}, {2840140800, " "}, {3155673600, " "}, {
                2272060800, " "}, {2335219200, " "}, {2398291200, " "}, {
                2461449600, " "}, {2587680000, " "}, {2650752000, " "}, {
                2713910400, " "}, {2776982400, " "}, {2903212800, " "}, {
                2966371200, " "}, {3029443200, " "}, {3092601600, " "}, {
                3218832000, " "}, {3281904000, " "}}}}, 
            GridLines -> {{{2208988800, 
                GrayLevel[0.8]}, {2524521600, 
                GrayLevel[0.8]}, {2840140800, 
                GrayLevel[0.8]}, {3155673600, 
                GrayLevel[0.8]}}, None}, 
            PlotRange -> {{2.2089888*^9, 3.3135264*^9}, {0., 
             5.206658298158463*^12}}, PlotRangeClipping -> True, 
            PlotRangePadding -> {
              Scaled[0.02], 
              Scaled[0.02]}, Ticks -> None}]}, False]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ]},
    {
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = False}, 
       InterpretationBox[
        StyleBox[
         PaneSelectorBox[{False->
          TagBox[GridBox[{
             {
              OpenerBox[Dynamic[Typeset`var$$],
               Appearance->Automatic,
               AutoAction->False,
               ContinuousAction->False,
               Enabled->Automatic], "\<\"Russia\"\>"}
            },
            BaselinePosition->{1, 1},
            ColumnsEqual->False,
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxBackground->{"Columns" -> {{Automatic}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
            RowsEqual->False],
           "Grid"], True->
          TagBox[GridBox[{
             {
              OpenerBox[Dynamic[Typeset`var$$],
               Appearance->Automatic,
               AutoAction->False,
               ContinuousAction->False,
               Enabled->Automatic], "\<\"Russia\"\>"},
             {"", 
              PaneBox[
               GraphicsBox[{{}, 
                 {Hue[0.67, 0.6, 0.6], 
                  PointBox[{{2.8401408*^9, 5.697118807301721*^11}, {
                   2.8716768*^9, 5.60148358206564*^11}, {2.9032128*^9, 
                   4.899543440560434*^11}, {2.9348352*^9, 
                   4.576050839536752*^11}, {2.9663712*^9, 
                   4.0791335145689514`*^11}, {2.9979072*^9, 
                   3.991662245416091*^11}, {3.0294432*^9, 
                   3.9208952318958527`*^11}, {3.0610656*^9, 
                   4.049406205883203*^11}, {3.0926016*^9, 
                   2.709531602854175*^11}, {3.1241376*^9, 
                   1.95907924077677*^11}, {3.1556736*^9, 
                   2.597178361724186*^11}, {3.187296*^9, 
                   3.066175749373683*^11}, {3.218832*^9, 
                   3.4548832824979877`*^11}, {3.250368*^9, 
                   4.3148797448197046`*^11}, {3.281904*^9, 
                   5.902873738774519*^11}, {3.3135264*^9, 
                   7.659680383768098*^11}}]}, {}},
                AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                
                AxesOrigin->
                 NCache[{2208988800, 2.*^11}, {2.2089888*^9, 2.*^11}],
                Frame->True,
                FrameTicks->{{Automatic, Automatic}, {{{
                    NCache[2208988800, 2.2089888*^9], 
                    FormBox["\"1970\"", TraditionalForm]}, {
                    NCache[2524521600, 2.5245216*^9], 
                    FormBox["\"1980\"", TraditionalForm]}, {
                    NCache[2840140800, 2.8401408*^9], 
                    FormBox["\"1990\"", TraditionalForm]}, {
                    NCache[3155673600, 3.1556736*^9], 
                    FormBox["\"2000\"", TraditionalForm]}, {
                    NCache[2272060800, 2.2720608*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2335219200, 2.3352192*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2398291200, 2.3982912*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2461449600, 2.4614496*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2587680000, 2.58768*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2650752000, 2.650752*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2713910400, 2.7139104*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2776982400, 2.7769824*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2903212800, 2.9032128*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2966371200, 2.9663712*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3029443200, 3.0294432*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3092601600, 3.0926016*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3218832000, 3.218832*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3281904000, 3.281904*^9], 
                    FormBox["\" \"", TraditionalForm]}}, {{
                    NCache[2208988800, 2.2089888*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2524521600, 2.5245216*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2840140800, 2.8401408*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3155673600, 3.1556736*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2272060800, 2.2720608*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2335219200, 2.3352192*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2398291200, 2.3982912*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2461449600, 2.4614496*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2587680000, 2.58768*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2650752000, 2.650752*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2713910400, 2.7139104*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2776982400, 2.7769824*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2903212800, 2.9032128*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2966371200, 2.9663712*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3029443200, 3.0294432*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3092601600, 3.0926016*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3218832000, 3.218832*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3281904000, 3.281904*^9], 
                    FormBox["\" \"", TraditionalForm]}}}},
                GridLines->NCache[{{{2208988800, 
                    GrayLevel[0.8]}, {2524521600, 
                    GrayLevel[0.8]}, {2840140800, 
                    GrayLevel[0.8]}, {3155673600, 
                    GrayLevel[0.8]}}, None}, {{{2.2089888*^9, 
                    GrayLevel[0.8]}, {2.5245216*^9, 
                    GrayLevel[0.8]}, {2.8401408*^9, 
                    GrayLevel[0.8]}, {3.1556736*^9, 
                    GrayLevel[0.8]}}, None}],
                
                PlotRange->
                 NCache[{{2208988800, 3.3135264*^9}, {1.95907924077677*^11, 
                   7.659680383768098*^11}}, {{2.2089888*^9, 3.3135264*^9}, {
                  1.95907924077677*^11, 7.659680383768098*^11}}],
                PlotRangeClipping->True,
                PlotRangePadding->{
                  Scaled[0.02], 
                  Scaled[0.02]},
                Ticks->None],
               ImageMargins->0]}
            },
            BaselinePosition->{1, 1},
            ColumnsEqual->False,
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxBackground->{"Columns" -> {{Automatic}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
            RowsEqual->False],
           "Grid"]}, Dynamic[Typeset`var$$],
          Alignment->Automatic,
          BaselinePosition->Baseline,
          DefaultBaseStyle->"OpenerView",
          ImageMargins->0,
          ImageSize->Automatic],
         Deployed->False,
         StripOnInput->False],
        OpenerView[{"Russia", 
          Graphics[{{{}, {
              Hue[0.67, 0.6, 0.6], 
              
              Point[{{2.8401408*^9, 5.697118807301721*^11}, {2.8716768*^9, 
               5.60148358206564*^11}, {2.9032128*^9, 4.899543440560434*^11}, {
               2.9348352*^9, 4.576050839536752*^11}, {2.9663712*^9, 
               4.0791335145689514`*^11}, {2.9979072*^9, 
               3.991662245416091*^11}, {3.0294432*^9, 
               3.9208952318958527`*^11}, {3.0610656*^9, 
               4.049406205883203*^11}, {3.0926016*^9, 
               2.709531602854175*^11}, {3.1241376*^9, 1.95907924077677*^11}, {
               3.1556736*^9, 2.597178361724186*^11}, {3.187296*^9, 
               3.066175749373683*^11}, {3.218832*^9, 
               3.4548832824979877`*^11}, {3.250368*^9, 
               4.3148797448197046`*^11}, {3.281904*^9, 
               5.902873738774519*^11}, {3.3135264*^9, 
               7.659680383768098*^11}}]}, {}}}, {
           AspectRatio -> GoldenRatio^(-1), 
            AxesOrigin -> {2208988800, 2.*^11}, Frame -> True, 
            FrameTicks -> {{
              Automatic, 
               Automatic}, {{{2208988800, "1970"}, {2524521600, "1980"}, {
                2840140800, "1990"}, {3155673600, "2000"}, {
                2272060800, " "}, {2335219200, " "}, {2398291200, " "}, {
                2461449600, " "}, {2587680000, " "}, {2650752000, " "}, {
                2713910400, " "}, {2776982400, " "}, {2903212800, " "}, {
                2966371200, " "}, {3029443200, " "}, {3092601600, " "}, {
                3218832000, " "}, {3281904000, " "}}, {{2208988800, " "}, {
                2524521600, " "}, {2840140800, " "}, {3155673600, " "}, {
                2272060800, " "}, {2335219200, " "}, {2398291200, " "}, {
                2461449600, " "}, {2587680000, " "}, {2650752000, " "}, {
                2713910400, " "}, {2776982400, " "}, {2903212800, " "}, {
                2966371200, " "}, {3029443200, " "}, {3092601600, " "}, {
                3218832000, " "}, {3281904000, " "}}}}, 
            GridLines -> {{{2208988800, 
                GrayLevel[0.8]}, {2524521600, 
                GrayLevel[0.8]}, {2840140800, 
                GrayLevel[0.8]}, {3155673600, 
                GrayLevel[0.8]}}, None}, 
            PlotRange -> {{2208988800, 3.3135264*^9}, {1.95907924077677*^11, 
              7.659680383768098*^11}}, PlotRangeClipping -> True, 
            PlotRangePadding -> {
              Scaled[0.02], 
              Scaled[0.02]}, Ticks -> None}]}, False]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ]},
    {
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = False}, 
       InterpretationBox[
        StyleBox[
         PaneSelectorBox[{False->
          TagBox[GridBox[{
             {
              OpenerBox[Dynamic[Typeset`var$$],
               Appearance->Automatic,
               AutoAction->False,
               ContinuousAction->False,
               Enabled->Automatic], "\<\"UnitedKingdom\"\>"}
            },
            BaselinePosition->{1, 1},
            ColumnsEqual->False,
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxBackground->{"Columns" -> {{Automatic}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
            RowsEqual->False],
           "Grid"], True->
          TagBox[GridBox[{
             {
              OpenerBox[Dynamic[Typeset`var$$],
               Appearance->Automatic,
               AutoAction->False,
               ContinuousAction->False,
               Enabled->Automatic], "\<\"UnitedKingdom\"\>"},
             {"", 
              PaneBox[
               GraphicsBox[{{}, 
                 {Hue[0.67, 0.6, 0.6], 
                  PointBox[{{2.2089888*^9, 1.2363590126436914`*^11}, {
                   2.2405248*^9, 1.3980572083619217`*^11}, {2.2720608*^9, 
                   1.6063569485203543`*^11}, {2.3036832*^9, 
                   1.8124513969447748`*^11}, {2.3352192*^9, 
                   1.957702847195009*^11}, {2.3667552*^9, 
                   2.3398975145108023`*^11}, {2.3982912*^9, 
                   2.2479207505729996`*^11}, {2.4299136*^9, 
                   2.5385680838041418`*^11}, {2.4614496*^9, 
                   3.21772819807636*^11}, {2.4929856*^9, 
                   4.179666923422399*^11}, {2.5245216*^9, 
                   5.361321896283531*^11}, {2.556144*^9, 
                   5.083982851941528*^11}, {2.58768*^9, 
                   4.840449529095338*^11}, {2.619216*^9, 
                   4.5894000027881354`*^11}, {2.650752*^9, 
                   4.3150455371477625`*^11}, {2.6823744*^9, 
                   4.5550699023655786`*^11}, {2.7139104*^9, 
                   5.58954105166052*^11}, {2.7454464*^9, 
                   6.857539263293876*^11}, {2.7769824*^9, 
                   8.331747712214061*^11}, {2.8086048*^9, 
                   8.412809635246335*^11}, {2.8401408*^9, 
                   9.89564266780465*^11}, {2.8716768*^9, 
                   1.0334817518162361`*^12}, {2.9032128*^9, 
                   1.0715859646146346`*^12}, {2.9348352*^9, 
                   9.624067386994218*^11}, {2.9663712*^9, 
                   1.0413426629112925`*^12}, {2.9979072*^9, 
                   1.1336896670768289`*^12}, {3.0294432*^9, 
                   1.1912803900154153`*^12}, {3.0610656*^9, 
                   1.3270351591864573`*^12}, {3.0926016*^9, 
                   1.4251182105389539`*^12}, {3.1241376*^9, 
                   1.4649752807122458`*^12}, {3.1556736*^9, 
                   1.4427772951531748`*^12}, {3.187296*^9, 
                   1.4348964593935117`*^12}, {3.218832*^9, 
                   1.571371904459777*^12}, {3.250368*^9, 
                   1.805663111405002*^12}, {3.281904*^9, 
                   2.1321560657658647`*^12}, {3.3135264*^9, 
                   2.1987957539265283`*^12}}]}, {}},
                AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                AxesOrigin->NCache[{2208988800, 0}, {2.2089888*^9, 0}],
                Frame->True,
                FrameTicks->{{Automatic, Automatic}, {{{
                    NCache[2208988800, 2.2089888*^9], 
                    FormBox["\"1970\"", TraditionalForm]}, {
                    NCache[2524521600, 2.5245216*^9], 
                    FormBox["\"1980\"", TraditionalForm]}, {
                    NCache[2840140800, 2.8401408*^9], 
                    FormBox["\"1990\"", TraditionalForm]}, {
                    NCache[3155673600, 3.1556736*^9], 
                    FormBox["\"2000\"", TraditionalForm]}, {
                    NCache[2272060800, 2.2720608*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2335219200, 2.3352192*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2398291200, 2.3982912*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2461449600, 2.4614496*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2587680000, 2.58768*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2650752000, 2.650752*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2713910400, 2.7139104*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2776982400, 2.7769824*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2903212800, 2.9032128*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2966371200, 2.9663712*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3029443200, 3.0294432*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3092601600, 3.0926016*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3218832000, 3.218832*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3281904000, 3.281904*^9], 
                    FormBox["\" \"", TraditionalForm]}}, {{
                    NCache[2208988800, 2.2089888*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2524521600, 2.5245216*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2840140800, 2.8401408*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3155673600, 3.1556736*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2272060800, 2.2720608*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2335219200, 2.3352192*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2398291200, 2.3982912*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2461449600, 2.4614496*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2587680000, 2.58768*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2650752000, 2.650752*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2713910400, 2.7139104*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2776982400, 2.7769824*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2903212800, 2.9032128*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2966371200, 2.9663712*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3029443200, 3.0294432*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3092601600, 3.0926016*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3218832000, 3.218832*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3281904000, 3.281904*^9], 
                    FormBox["\" \"", TraditionalForm]}}}},
                GridLines->NCache[{{{2208988800, 
                    GrayLevel[0.8]}, {2524521600, 
                    GrayLevel[0.8]}, {2840140800, 
                    GrayLevel[0.8]}, {3155673600, 
                    GrayLevel[0.8]}}, None}, {{{2.2089888*^9, 
                    GrayLevel[0.8]}, {2.5245216*^9, 
                    GrayLevel[0.8]}, {2.8401408*^9, 
                    GrayLevel[0.8]}, {3.1556736*^9, 
                    GrayLevel[0.8]}}, None}],
                
                PlotRange->{{2.2089888*^9, 3.3135264*^9}, {0., 
                 2.1987957539265283`*^12}},
                PlotRangeClipping->True,
                PlotRangePadding->{
                  Scaled[0.02], 
                  Scaled[0.02]},
                Ticks->None],
               ImageMargins->0]}
            },
            BaselinePosition->{1, 1},
            ColumnsEqual->False,
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxBackground->{"Columns" -> {{Automatic}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
            RowsEqual->False],
           "Grid"]}, Dynamic[Typeset`var$$],
          Alignment->Automatic,
          BaselinePosition->Baseline,
          DefaultBaseStyle->"OpenerView",
          ImageMargins->0,
          ImageSize->Automatic],
         Deployed->False,
         StripOnInput->False],
        OpenerView[{"UnitedKingdom", 
          Graphics[{{{}, {
              Hue[0.67, 0.6, 0.6], 
              
              Point[{{2.2089888*^9, 1.2363590126436914`*^11}, {2.2405248*^9, 
               1.3980572083619217`*^11}, {2.2720608*^9, 
               1.6063569485203543`*^11}, {2.3036832*^9, 
               1.8124513969447748`*^11}, {2.3352192*^9, 
               1.957702847195009*^11}, {2.3667552*^9, 
               2.3398975145108023`*^11}, {2.3982912*^9, 
               2.2479207505729996`*^11}, {2.4299136*^9, 
               2.5385680838041418`*^11}, {2.4614496*^9, 
               3.21772819807636*^11}, {2.4929856*^9, 4.179666923422399*^11}, {
               2.5245216*^9, 5.361321896283531*^11}, {2.556144*^9, 
               5.083982851941528*^11}, {2.58768*^9, 4.840449529095338*^11}, {
               2.619216*^9, 4.5894000027881354`*^11}, {2.650752*^9, 
               4.3150455371477625`*^11}, {2.6823744*^9, 
               4.5550699023655786`*^11}, {2.7139104*^9, 
               5.58954105166052*^11}, {2.7454464*^9, 6.857539263293876*^11}, {
               2.7769824*^9, 8.331747712214061*^11}, {2.8086048*^9, 
               8.412809635246335*^11}, {2.8401408*^9, 9.89564266780465*^11}, {
               2.8716768*^9, 1.0334817518162361`*^12}, {2.9032128*^9, 
               1.0715859646146346`*^12}, {2.9348352*^9, 
               9.624067386994218*^11}, {2.9663712*^9, 
               1.0413426629112925`*^12}, {2.9979072*^9, 
               1.1336896670768289`*^12}, {3.0294432*^9, 
               1.1912803900154153`*^12}, {3.0610656*^9, 
               1.3270351591864573`*^12}, {3.0926016*^9, 
               1.4251182105389539`*^12}, {3.1241376*^9, 
               1.4649752807122458`*^12}, {3.1556736*^9, 
               1.4427772951531748`*^12}, {3.187296*^9, 
               1.4348964593935117`*^12}, {3.218832*^9, 
               1.571371904459777*^12}, {3.250368*^9, 1.805663111405002*^12}, {
               3.281904*^9, 2.1321560657658647`*^12}, {3.3135264*^9, 
               2.1987957539265283`*^12}}]}, {}}}, {
           AspectRatio -> GoldenRatio^(-1), AxesOrigin -> {2208988800, 0}, 
            Frame -> True, 
            FrameTicks -> {{
              Automatic, 
               Automatic}, {{{2208988800, "1970"}, {2524521600, "1980"}, {
                2840140800, "1990"}, {3155673600, "2000"}, {
                2272060800, " "}, {2335219200, " "}, {2398291200, " "}, {
                2461449600, " "}, {2587680000, " "}, {2650752000, " "}, {
                2713910400, " "}, {2776982400, " "}, {2903212800, " "}, {
                2966371200, " "}, {3029443200, " "}, {3092601600, " "}, {
                3218832000, " "}, {3281904000, " "}}, {{2208988800, " "}, {
                2524521600, " "}, {2840140800, " "}, {3155673600, " "}, {
                2272060800, " "}, {2335219200, " "}, {2398291200, " "}, {
                2461449600, " "}, {2587680000, " "}, {2650752000, " "}, {
                2713910400, " "}, {2776982400, " "}, {2903212800, " "}, {
                2966371200, " "}, {3029443200, " "}, {3092601600, " "}, {
                3218832000, " "}, {3281904000, " "}}}}, 
            GridLines -> {{{2208988800, 
                GrayLevel[0.8]}, {2524521600, 
                GrayLevel[0.8]}, {2840140800, 
                GrayLevel[0.8]}, {3155673600, 
                GrayLevel[0.8]}}, None}, 
            PlotRange -> {{2.2089888*^9, 3.3135264*^9}, {0., 
             2.1987957539265283`*^12}}, PlotRangeClipping -> True, 
            PlotRangePadding -> {
              Scaled[0.02], 
              Scaled[0.02]}, Ticks -> None}]}, False]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ]},
    {
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = False}, 
       InterpretationBox[
        StyleBox[
         PaneSelectorBox[{False->
          TagBox[GridBox[{
             {
              OpenerBox[Dynamic[Typeset`var$$],
               Appearance->Automatic,
               AutoAction->False,
               ContinuousAction->False,
               Enabled->Automatic], "\<\"UnitedStates\"\>"}
            },
            BaselinePosition->{1, 1},
            ColumnsEqual->False,
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxBackground->{"Columns" -> {{Automatic}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
            RowsEqual->False],
           "Grid"], True->
          TagBox[GridBox[{
             {
              OpenerBox[Dynamic[Typeset`var$$],
               Appearance->Automatic,
               AutoAction->False,
               ContinuousAction->False,
               Enabled->Automatic], "\<\"UnitedStates\"\>"},
             {"", 
              PaneBox[
               GraphicsBox[{{}, 
                 {Hue[0.67, 0.6, 0.6], 
                  PointBox[{{2.2089888*^9, 1.025*^12}, {2.2405248*^9, 
                   1.1134*^12}, {2.2720608*^9, 1.2254*^12}, {2.3036832*^9, 
                   1.3698*^12}, {2.3352192*^9, 1.4864000007432*^12}, {
                   2.3667552*^9, 1.624000001624*^12}, {2.3982912*^9, 
                   1.8098000018098*^12}, {2.4299136*^9, 
                   2.0143000020143*^12}, {2.4614496*^9, 
                   2.2769000022769*^12}, {2.4929856*^9, 
                   2.5445000025445*^12}, {2.5245216*^9, 
                   2.7689000027689*^12}, {2.556144*^9, 3.1054000031054*^12}, {
                   2.58768*^9, 3.2295000032295*^12}, {2.619216*^9, 
                   3.5088000035088*^12}, {2.650752*^9, 
                   3.902600001626085*^12}, {2.6823744*^9, 4.1875*^12}, {
                   2.7139104*^9, 4.4277*^12}, {2.7454464*^9, 4.7021*^12}, {
                   2.7769824*^9, 5.0639*^12}, {2.8086048*^9, 5.4417*^12}, {
                   2.8401408*^9, 5.7572*^12}, {2.8716768*^9, 5.9469*^12}, {
                   2.9032128*^9, 6.2868*^12}, {2.9348352*^9, 6.6043*^12}, {
                   2.9663712*^9, 7.0175*^12}, {2.9979072*^9, 7.3423*^12}, {
                   3.0294432*^9, 7.7623*^12}, {3.0610656*^9, 8.2509*^12}, {
                   3.0926016*^9, 8.6946*^12}, {3.1241376*^9, 9.2162*^12}, {
                   3.1556736*^9, 9.7648*^12}, {3.187296*^9, 1.00759*^13}, {
                   3.218832*^9, 1.04176*^13}, {3.250368*^9, 1.09185*^13}, {
                   3.281904*^9, 1.16792*^13}, {3.3135264*^9, 
                   1.24558*^13}}]}, {}},
                AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                AxesOrigin->NCache[{2208988800, 0}, {2.2089888*^9, 0}],
                Frame->True,
                FrameTicks->{{Automatic, Automatic}, {{{
                    NCache[2208988800, 2.2089888*^9], 
                    FormBox["\"1970\"", TraditionalForm]}, {
                    NCache[2524521600, 2.5245216*^9], 
                    FormBox["\"1980\"", TraditionalForm]}, {
                    NCache[2840140800, 2.8401408*^9], 
                    FormBox["\"1990\"", TraditionalForm]}, {
                    NCache[3155673600, 3.1556736*^9], 
                    FormBox["\"2000\"", TraditionalForm]}, {
                    NCache[2272060800, 2.2720608*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2335219200, 2.3352192*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2398291200, 2.3982912*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2461449600, 2.4614496*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2587680000, 2.58768*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2650752000, 2.650752*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2713910400, 2.7139104*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2776982400, 2.7769824*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2903212800, 2.9032128*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2966371200, 2.9663712*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3029443200, 3.0294432*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3092601600, 3.0926016*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3218832000, 3.218832*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3281904000, 3.281904*^9], 
                    FormBox["\" \"", TraditionalForm]}}, {{
                    NCache[2208988800, 2.2089888*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2524521600, 2.5245216*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2840140800, 2.8401408*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3155673600, 3.1556736*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2272060800, 2.2720608*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2335219200, 2.3352192*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2398291200, 2.3982912*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2461449600, 2.4614496*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2587680000, 2.58768*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2650752000, 2.650752*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2713910400, 2.7139104*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2776982400, 2.7769824*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2903212800, 2.9032128*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2966371200, 2.9663712*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3029443200, 3.0294432*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3092601600, 3.0926016*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3218832000, 3.218832*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3281904000, 3.281904*^9], 
                    FormBox["\" \"", TraditionalForm]}}}},
                GridLines->NCache[{{{2208988800, 
                    GrayLevel[0.8]}, {2524521600, 
                    GrayLevel[0.8]}, {2840140800, 
                    GrayLevel[0.8]}, {3155673600, 
                    GrayLevel[0.8]}}, None}, {{{2.2089888*^9, 
                    GrayLevel[0.8]}, {2.5245216*^9, 
                    GrayLevel[0.8]}, {2.8401408*^9, 
                    GrayLevel[0.8]}, {3.1556736*^9, 
                    GrayLevel[0.8]}}, None}],
                PlotRange->{{2.2089888*^9, 3.3135264*^9}, {0., 1.24558*^13}},
                PlotRangeClipping->True,
                PlotRangePadding->{
                  Scaled[0.02], 
                  Scaled[0.02]},
                Ticks->None],
               ImageMargins->0]}
            },
            BaselinePosition->{1, 1},
            ColumnsEqual->False,
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxBackground->{"Columns" -> {{Automatic}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
            RowsEqual->False],
           "Grid"]}, Dynamic[Typeset`var$$],
          Alignment->Automatic,
          BaselinePosition->Baseline,
          DefaultBaseStyle->"OpenerView",
          ImageMargins->0,
          ImageSize->Automatic],
         Deployed->False,
         StripOnInput->False],
        OpenerView[{"UnitedStates", 
          Graphics[{{{}, {
              Hue[0.67, 0.6, 0.6], 
              
              Point[{{2.2089888*^9, 1.025*^12}, {2.2405248*^9, 1.1134*^12}, {
               2.2720608*^9, 1.2254*^12}, {2.3036832*^9, 1.3698*^12}, {
               2.3352192*^9, 1.4864000007432*^12}, {2.3667552*^9, 
               1.624000001624*^12}, {2.3982912*^9, 1.8098000018098*^12}, {
               2.4299136*^9, 2.0143000020143*^12}, {2.4614496*^9, 
               2.2769000022769*^12}, {2.4929856*^9, 2.5445000025445*^12}, {
               2.5245216*^9, 2.7689000027689*^12}, {2.556144*^9, 
               3.1054000031054*^12}, {2.58768*^9, 3.2295000032295*^12}, {
               2.619216*^9, 3.5088000035088*^12}, {2.650752*^9, 
               3.902600001626085*^12}, {2.6823744*^9, 4.1875*^12}, {
               2.7139104*^9, 4.4277*^12}, {2.7454464*^9, 4.7021*^12}, {
               2.7769824*^9, 5.0639*^12}, {2.8086048*^9, 5.4417*^12}, {
               2.8401408*^9, 5.7572*^12}, {2.8716768*^9, 5.9469*^12}, {
               2.9032128*^9, 6.2868*^12}, {2.9348352*^9, 6.6043*^12}, {
               2.9663712*^9, 7.0175*^12}, {2.9979072*^9, 7.3423*^12}, {
               3.0294432*^9, 7.7623*^12}, {3.0610656*^9, 8.2509*^12}, {
               3.0926016*^9, 8.6946*^12}, {3.1241376*^9, 9.2162*^12}, {
               3.1556736*^9, 9.7648*^12}, {3.187296*^9, 1.00759*^13}, {
               3.218832*^9, 1.04176*^13}, {3.250368*^9, 1.09185*^13}, {
               3.281904*^9, 1.16792*^13}, {3.3135264*^9, 
               1.24558*^13}}]}, {}}}, {
           AspectRatio -> GoldenRatio^(-1), AxesOrigin -> {2208988800, 0}, 
            Frame -> True, 
            FrameTicks -> {{
              Automatic, 
               Automatic}, {{{2208988800, "1970"}, {2524521600, "1980"}, {
                2840140800, "1990"}, {3155673600, "2000"}, {
                2272060800, " "}, {2335219200, " "}, {2398291200, " "}, {
                2461449600, " "}, {2587680000, " "}, {2650752000, " "}, {
                2713910400, " "}, {2776982400, " "}, {2903212800, " "}, {
                2966371200, " "}, {3029443200, " "}, {3092601600, " "}, {
                3218832000, " "}, {3281904000, " "}}, {{2208988800, " "}, {
                2524521600, " "}, {2840140800, " "}, {3155673600, " "}, {
                2272060800, " "}, {2335219200, " "}, {2398291200, " "}, {
                2461449600, " "}, {2587680000, " "}, {2650752000, " "}, {
                2713910400, " "}, {2776982400, " "}, {2903212800, " "}, {
                2966371200, " "}, {3029443200, " "}, {3092601600, " "}, {
                3218832000, " "}, {3281904000, " "}}}}, 
            GridLines -> {{{2208988800, 
                GrayLevel[0.8]}, {2524521600, 
                GrayLevel[0.8]}, {2840140800, 
                GrayLevel[0.8]}, {3155673600, 
                GrayLevel[0.8]}}, None}, 
            PlotRange -> {{2.2089888*^9, 3.3135264*^9}, {0., 1.24558*^13}}, 
            PlotRangeClipping -> True, PlotRangePadding -> {
              Scaled[0.02], 
              Scaled[0.02]}, Ticks -> None}]}, False]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ]}
   },
   ColumnsEqual->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   RowsEqual->False],
  "Column"]], "Output",
 ImageSize->{198, 275},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->22806322]
}, Open  ]],

Cell["\<\
The title is not limited to being a plain string: any arbitrary typeset \
expression or graphic can be used. Here, for example, is an outline of the \
country with its name as the title line.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{"Map", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"OpenerView", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Row", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Rasterize", "[", 
            RowBox[{
             RowBox[{"Show", "[", 
              RowBox[{
               RowBox[{"CountryData", "[", 
                RowBox[{"#", ",", "\"\<Shape\>\""}], "]"}], ",", 
               RowBox[{"ImageSize", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"40", ",", "40"}], "}"}]}]}], "]"}], ",", 
             RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", "#"}], 
          "}"}], "]"}], ",", 
        RowBox[{"DateListPlot", "[", 
         RowBox[{"CountryData", "[", 
          RowBox[{"#", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", "\"\<GDP\>\"", "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"1970", ",", "2005"}], "}"}]}], "}"}]}], "]"}], "]"}]}],
        "}"}], "]"}], "&"}], ",", 
    RowBox[{"CountryData", "[", "\"\<GroupOf8\>\"", "]"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:="],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = False}, 
       InterpretationBox[
        StyleBox[
         PaneSelectorBox[{False->
          TagBox[GridBox[{
             {
              OpenerBox[Dynamic[Typeset`var$$],
               Appearance->Automatic,
               AutoAction->False,
               ContinuousAction->False,
               Enabled->Automatic], 
              InterpretationBox[
               RowBox[{
                GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJmYGDQgGIWhlEwCoY94ADiaCAWHmiHYAGg7HgPiP+zsbHtAtKM
A+wedAByj5W9ve07IP0fiE8BMdPAOgkF8HNycNybO3va/wvnjv8XEhT8JSYm
lsJA/3AE2acDxIFAPB2IlZiYmPYD6f+OjvZ/nzy69R+E9+7eCgrD/8zMzM1A
mpsK9goAsRY7O7ubno5OkZ6O9nx3d5eFXp5uG7093ff5eHns9/Jy38PKyvqN
ARJ/cFxSnP/z0oUT/2Fug+Erl07/9/f3+QlVpwvE7FC2OwPhcJ0BxK6KinLJ
Tg62C8NCg07X1VY8WDh/1u9dOzf9P7h/x//Ll079v33rEty+h/ev/79x7RyY
fefWZTD9+OFNDHch43t3roD9wMjIuBTNXxw43MWErG7likX/z54+gtcOYvH1
q+dQ+I8e3Pjv5ur8H81dyBgbCIXJe3q6EfQ/sXj92uVwew8d2AkXT0qMI9V9
l2Dy6P4lF4PSAbK9yGkChNHc5EvAfc4weVB6osRd166c/Z+dlfZfSUkRbn9i
QiyKGlD8gNIQkps4sYSjAJL7HGDi5Ljp9KlDYL0a6mr/kO1gZmacB6IT4mOw
6gOFBZ54Rg7L3SD+4kVzyHJfaGgQzLy/QKyJFjdTQHJnTh3GqR+H20KRzACV
O/9VVJT/3797lSS3nT97DFbmdmFJN6Ay+L+hgf4/bHpBeQYkv2jhbGR3uTFg
1oHyhPyIC4PKW6i5QmhmwspdsDpY2QjDu3dtxhZmKVj8CANk5wkk89mQzBMF
ibm6OmHE4YL5M7G5zQmP2/pBasgp90B6kOxIB7ajfKFmmoPEdmzb8N/MzARX
GsNVXyCDBJDayMjQH6B6h1T33bpxAZfdh9H4oDo3E8reygBpGxIDfjGQWO4h
qz1+dB+47MXhRmLrB3zAQlxc7P3Vy2cIumvJ4rlwe2RkpFHKOl9fL2Q3FFHR
fQx8fHwZbS0NL0B1NzZ3gcRJCB8QnoVDPJgc9wEBq5yczIr5c2f8wVZ+NDZU
k+q+dzjEJ5DpPhAQdna033fuzFGUeMSGMzNSSHUvDMtQ4D4QcJUQE/tCpt34
MBsDlQAXF8dkbm7O7Whmgus+NDvXEOEub2q5iwDIIcItMJxKJzehgyNEum+g
AEofBQ8eDADsFmCbarC6DwYGu/vUGQa3+0AA1N4dzO4DAVD/oA6ItQbaIaNg
aAEAlA+BgQ==
                  "], {{0, 0}, {40, 40}}, {0, 255},
                  ColorFunction->RGBColor],
                 Background->None,
                 ImageSize->{40, 40},
                 PlotRange->{{0, 40}, {0, 40}}], 
                "\[InvisibleSpace]", "\<\"Canada\"\>"}],
               Row[{
                 Graphics[
                  Raster[CompressedData["
1:eJxTTMoPSmJmYGDQgGIWhlEwCoY94ADiaCAWHmiHYAGg7HgPiP+zsbHtAtKM
A+wedAByj5W9ve07IP0fiE8BMdPAOgkF8HNycNybO3va/wvnjv8XEhT8JSYm
lsJA/3AE2acDxIFAPB2IlZiYmPYD6f+OjvZ/nzy69R+E9+7eCgrD/8zMzM1A
mpsK9goAsRY7O7ubno5OkZ6O9nx3d5eFXp5uG7093ff5eHns9/Jy38PKyvqN
ARJ/cFxSnP/z0oUT/2Fug+Erl07/9/f3+QlVpwvE7FC2OwPhcJ0BxK6KinLJ
Tg62C8NCg07X1VY8WDh/1u9dOzf9P7h/x//Ll079v33rEty+h/ev/79x7RyY
fefWZTD9+OFNDHch43t3roD9wMjIuBTNXxw43MWErG7likX/z54+gtcOYvH1
q+dQ+I8e3Pjv5ur8H81dyBgbCIXJe3q6EfQ/sXj92uVwew8d2AkXT0qMI9V9
l2Dy6P4lF4PSAbK9yGkChNHc5EvAfc4weVB6osRd166c/Z+dlfZfSUkRbn9i
QiyKGlD8gNIQkps4sYSjAJL7HGDi5Ljp9KlDYL0a6mr/kO1gZmacB6IT4mOw
6gOFBZ54Rg7L3SD+4kVzyHJfaGgQzLy/QKyJFjdTQHJnTh3GqR+H20KRzACV
O/9VVJT/3797lSS3nT97DFbmdmFJN6Ay+L+hgf4/bHpBeQYkv2jhbGR3uTFg
1oHyhPyIC4PKW6i5QmhmwspdsDpY2QjDu3dtxhZmKVj8CANk5wkk89mQzBMF
ibm6OmHE4YL5M7G5zQmP2/pBasgp90B6kOxIB7ajfKFmmoPEdmzb8N/MzARX
GsNVXyCDBJDayMjQH6B6h1T33bpxAZfdh9H4oDo3E8reygBpGxIDfjGQWO4h
qz1+dB+47MXhRmLrB3zAQlxc7P3Vy2cIumvJ4rlwe2RkpFHKOl9fL2Q3FFHR
fQx8fHwZbS0NL0B1NzZ3gcRJCB8QnoVDPJgc9wEBq5yczIr5c2f8wVZ+NDZU
k+q+dzjEJ5DpPhAQdna033fuzFGUeMSGMzNSSHUvDMtQ4D4QcJUQE/tCpt34
MBsDlQAXF8dkbm7O7Whmgus+NDvXEOEub2q5iwDIIcItMJxKJzehgyNEum+g
AEofBQ8eDADsFmCbarC6DwYGu/vUGQa3+0AA1N4dzO4DAVD/oA6ItQbaIaNg
aAEAlA+BgQ==
                   "], {{0, 0}, {40, 40}}, {0, 255}, ColorFunction -> 
                   RGBColor], Background -> None, ImageSize -> {40, 40}, 
                  PlotRange -> {{0, 40}, {0, 40}}], "Canada"}]]}
            },
            BaselinePosition->{1, 1},
            ColumnsEqual->False,
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxBackground->{"Columns" -> {{Automatic}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
            RowsEqual->False],
           "Grid"], True->
          TagBox[GridBox[{
             {
              OpenerBox[Dynamic[Typeset`var$$],
               Appearance->Automatic,
               AutoAction->False,
               ContinuousAction->False,
               Enabled->Automatic], 
              InterpretationBox[
               RowBox[{
                GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJmYGDQgGIWhlEwCoY94ADiaCAWHmiHYAGg7HgPiP+zsbHtAtKM
A+wedAByj5W9ve07IP0fiE8BMdPAOgkF8HNycNybO3va/wvnjv8XEhT8JSYm
lsJA/3AE2acDxIFAPB2IlZiYmPYD6f+OjvZ/nzy69R+E9+7eCgrD/8zMzM1A
mpsK9goAsRY7O7ubno5OkZ6O9nx3d5eFXp5uG7093ff5eHns9/Jy38PKyvqN
ARJ/cFxSnP/z0oUT/2Fug+Erl07/9/f3+QlVpwvE7FC2OwPhcJ0BxK6KinLJ
Tg62C8NCg07X1VY8WDh/1u9dOzf9P7h/x//Ll079v33rEty+h/ev/79x7RyY
fefWZTD9+OFNDHch43t3roD9wMjIuBTNXxw43MWErG7likX/z54+gtcOYvH1
q+dQ+I8e3Pjv5ur8H81dyBgbCIXJe3q6EfQ/sXj92uVwew8d2AkXT0qMI9V9
l2Dy6P4lF4PSAbK9yGkChNHc5EvAfc4weVB6osRd166c/Z+dlfZfSUkRbn9i
QiyKGlD8gNIQkps4sYSjAJL7HGDi5Ljp9KlDYL0a6mr/kO1gZmacB6IT4mOw
6gOFBZ54Rg7L3SD+4kVzyHJfaGgQzLy/QKyJFjdTQHJnTh3GqR+H20KRzACV
O/9VVJT/3797lSS3nT97DFbmdmFJN6Ay+L+hgf4/bHpBeQYkv2jhbGR3uTFg
1oHyhPyIC4PKW6i5QmhmwspdsDpY2QjDu3dtxhZmKVj8CANk5wkk89mQzBMF
ibm6OmHE4YL5M7G5zQmP2/pBasgp90B6kOxIB7ajfKFmmoPEdmzb8N/MzARX
GsNVXyCDBJDayMjQH6B6h1T33bpxAZfdh9H4oDo3E8reygBpGxIDfjGQWO4h
qz1+dB+47MXhRmLrB3zAQlxc7P3Vy2cIumvJ4rlwe2RkpFHKOl9fL2Q3FFHR
fQx8fHwZbS0NL0B1NzZ3gcRJCB8QnoVDPJgc9wEBq5yczIr5c2f8wVZ+NDZU
k+q+dzjEJ5DpPhAQdna033fuzFGUeMSGMzNSSHUvDMtQ4D4QcJUQE/tCpt34
MBsDlQAXF8dkbm7O7Whmgus+NDvXEOEub2q5iwDIIcItMJxKJzehgyNEum+g
AEofBQ8eDADsFmCbarC6DwYGu/vUGQa3+0AA1N4dzO4DAVD/oA6ItQbaIaNg
aAEAlA+BgQ==
                  "], {{0, 0}, {40, 40}}, {0, 255},
                  ColorFunction->RGBColor],
                 Background->None,
                 ImageSize->{40, 40},
                 PlotRange->{{0, 40}, {0, 40}}], 
                "\[InvisibleSpace]", "\<\"Canada\"\>"}],
               Row[{
                 Graphics[
                  Raster[CompressedData["
1:eJxTTMoPSmJmYGDQgGIWhlEwCoY94ADiaCAWHmiHYAGg7HgPiP+zsbHtAtKM
A+wedAByj5W9ve07IP0fiE8BMdPAOgkF8HNycNybO3va/wvnjv8XEhT8JSYm
lsJA/3AE2acDxIFAPB2IlZiYmPYD6f+OjvZ/nzy69R+E9+7eCgrD/8zMzM1A
mpsK9goAsRY7O7ubno5OkZ6O9nx3d5eFXp5uG7093ff5eHns9/Jy38PKyvqN
ARJ/cFxSnP/z0oUT/2Fug+Erl07/9/f3+QlVpwvE7FC2OwPhcJ0BxK6KinLJ
Tg62C8NCg07X1VY8WDh/1u9dOzf9P7h/x//Ll079v33rEty+h/ev/79x7RyY
fefWZTD9+OFNDHch43t3roD9wMjIuBTNXxw43MWErG7likX/z54+gtcOYvH1
q+dQ+I8e3Pjv5ur8H81dyBgbCIXJe3q6EfQ/sXj92uVwew8d2AkXT0qMI9V9
l2Dy6P4lF4PSAbK9yGkChNHc5EvAfc4weVB6osRd166c/Z+dlfZfSUkRbn9i
QiyKGlD8gNIQkps4sYSjAJL7HGDi5Ljp9KlDYL0a6mr/kO1gZmacB6IT4mOw
6gOFBZ54Rg7L3SD+4kVzyHJfaGgQzLy/QKyJFjdTQHJnTh3GqR+H20KRzACV
O/9VVJT/3797lSS3nT97DFbmdmFJN6Ay+L+hgf4/bHpBeQYkv2jhbGR3uTFg
1oHyhPyIC4PKW6i5QmhmwspdsDpY2QjDu3dtxhZmKVj8CANk5wkk89mQzBMF
ibm6OmHE4YL5M7G5zQmP2/pBasgp90B6kOxIB7ajfKFmmoPEdmzb8N/MzARX
GsNVXyCDBJDayMjQH6B6h1T33bpxAZfdh9H4oDo3E8reygBpGxIDfjGQWO4h
qz1+dB+47MXhRmLrB3zAQlxc7P3Vy2cIumvJ4rlwe2RkpFHKOl9fL2Q3FFHR
fQx8fHwZbS0NL0B1NzZ3gcRJCB8QnoVDPJgc9wEBq5yczIr5c2f8wVZ+NDZU
k+q+dzjEJ5DpPhAQdna033fuzFGUeMSGMzNSSHUvDMtQ4D4QcJUQE/tCpt34
MBsDlQAXF8dkbm7O7Whmgus+NDvXEOEub2q5iwDIIcItMJxKJzehgyNEum+g
AEofBQ8eDADsFmCbarC6DwYGu/vUGQa3+0AA1N4dzO4DAVD/oA6ItQbaIaNg
aAEAlA+BgQ==
                   "], {{0, 0}, {40, 40}}, {0, 255}, ColorFunction -> 
                   RGBColor], Background -> None, ImageSize -> {40, 40}, 
                  PlotRange -> {{0, 40}, {0, 40}}], "Canada"}]]},
             {"", 
              PaneBox[
               GraphicsBox[{{}, 
                 {Hue[0.67, 0.6, 0.6], 
                  PointBox[{{2.2089888*^9, 8.51102721952742*^10}, {
                   2.2405248*^9, 9.611388494862978*^10}, {2.2720608*^9, 
                   1.094720184098862*^11}, {2.3036832*^9, 
                   1.2719440059381201`*^11}, {2.3352192*^9, 
                   1.5529838808012518`*^11}, {2.3667552*^9, 
                   1.6827567004560587`*^11}, {2.3982912*^9, 
                   2.00061864743176*^11}, {2.4299136*^9, 
                   2.0490855246558777`*^11}, {2.4614496*^9, 
                   2.1158699904973694`*^11}, {2.4929856*^9, 
                   2.354038885269667*^11}, {2.5245216*^9, 
                   2.6527162075194025`*^11}, {2.556144*^9, 
                   2.9670158287541626`*^11}, {2.58768*^9, 
                   3.0382902858739197`*^11}, {2.619216*^9, 
                   3.2898857285467914`*^11}, {2.650752*^9, 
                   3.42332183759481*^11}, {2.6823744*^9, 
                   3.50666308740087*^11}, {2.7139104*^9, 
                   3.6336595904342676`*^11}, {2.7454464*^9, 
                   4.1532010633550885`*^11}, {2.7769824*^9, 
                   4.9056464772996716`*^11}, {2.8086048*^9, 
                   5.4728594655086096`*^11}, {2.8401408*^9, 
                   5.742041096183926*^11}, {2.8716768*^9, 
                   5.888384271853116*^11}, {2.9032128*^9, 
                   5.70279426668597*^11}, {2.9348352*^9, 
                   5.546898143452979*^11}, {2.9663712*^9, 
                   5.558404311536865*^11}, {2.9979072*^9, 
                   5.816644190490315*^11}, {3.0294432*^9, 
                   6.043712052962986*^11}, {3.0610656*^9, 
                   6.27595363337625*^11}, {3.0926016*^9, 
                   6.069244392498939*^11}, {3.1241376*^9, 
                   6.512017086979576*^11}, {3.1556736*^9, 
                   7.144534748267805*^11}, {3.187296*^9, 
                   7.050688372908894*^11}, {3.218832*^9, 
                   7.243042892296139*^11}, {3.250368*^9, 
                   8.547108065250964*^11}, {3.281904*^9, 
                   9.767419516622521*^11}, {3.3135264*^9, 
                   1.1317597770741843`*^12}}]}, {}},
                AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                AxesOrigin->NCache[{2208988800, 0}, {2.2089888*^9, 0}],
                Frame->True,
                FrameTicks->{{Automatic, Automatic}, {{{
                    NCache[2208988800, 2.2089888*^9], 
                    FormBox["\"1970\"", TraditionalForm]}, {
                    NCache[2524521600, 2.5245216*^9], 
                    FormBox["\"1980\"", TraditionalForm]}, {
                    NCache[2840140800, 2.8401408*^9], 
                    FormBox["\"1990\"", TraditionalForm]}, {
                    NCache[3155673600, 3.1556736*^9], 
                    FormBox["\"2000\"", TraditionalForm]}, {
                    NCache[2272060800, 2.2720608*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2335219200, 2.3352192*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2398291200, 2.3982912*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2461449600, 2.4614496*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2587680000, 2.58768*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2650752000, 2.650752*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2713910400, 2.7139104*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2776982400, 2.7769824*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2903212800, 2.9032128*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2966371200, 2.9663712*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3029443200, 3.0294432*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3092601600, 3.0926016*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3218832000, 3.218832*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3281904000, 3.281904*^9], 
                    FormBox["\" \"", TraditionalForm]}}, {{
                    NCache[2208988800, 2.2089888*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2524521600, 2.5245216*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2840140800, 2.8401408*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3155673600, 3.1556736*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2272060800, 2.2720608*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2335219200, 2.3352192*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2398291200, 2.3982912*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2461449600, 2.4614496*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2587680000, 2.58768*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2650752000, 2.650752*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2713910400, 2.7139104*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2776982400, 2.7769824*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2903212800, 2.9032128*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2966371200, 2.9663712*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3029443200, 3.0294432*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3092601600, 3.0926016*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3218832000, 3.218832*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3281904000, 3.281904*^9], 
                    FormBox["\" \"", TraditionalForm]}}}},
                GridLines->NCache[{{{2208988800, 
                    GrayLevel[0.8]}, {2524521600, 
                    GrayLevel[0.8]}, {2840140800, 
                    GrayLevel[0.8]}, {3155673600, 
                    GrayLevel[0.8]}}, None}, {{{2.2089888*^9, 
                    GrayLevel[0.8]}, {2.5245216*^9, 
                    GrayLevel[0.8]}, {2.8401408*^9, 
                    GrayLevel[0.8]}, {3.1556736*^9, 
                    GrayLevel[0.8]}}, None}],
                
                PlotRange->{{2.2089888*^9, 3.3135264*^9}, {0., 
                 1.1317597770741843`*^12}},
                PlotRangeClipping->True,
                PlotRangePadding->{
                  Scaled[0.02], 
                  Scaled[0.02]},
                Ticks->None],
               ImageMargins->0]}
            },
            BaselinePosition->{1, 1},
            ColumnsEqual->False,
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxBackground->{"Columns" -> {{Automatic}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
            RowsEqual->False],
           "Grid"]}, Dynamic[Typeset`var$$],
          Alignment->Automatic,
          BaselinePosition->Baseline,
          DefaultBaseStyle->"OpenerView",
          ImageMargins->0,
          ImageSize->Automatic],
         Deployed->False,
         StripOnInput->False],
        OpenerView[{
          Row[{
            Graphics[
             Raster[CompressedData["
1:eJxTTMoPSmJmYGDQgGIWhlEwCoY94ADiaCAWHmiHYAGg7HgPiP+zsbHtAtKM
A+wedAByj5W9ve07IP0fiE8BMdPAOgkF8HNycNybO3va/wvnjv8XEhT8JSYm
lsJA/3AE2acDxIFAPB2IlZiYmPYD6f+OjvZ/nzy69R+E9+7eCgrD/8zMzM1A
mpsK9goAsRY7O7ubno5OkZ6O9nx3d5eFXp5uG7093ff5eHns9/Jy38PKyvqN
ARJ/cFxSnP/z0oUT/2Fug+Erl07/9/f3+QlVpwvE7FC2OwPhcJ0BxK6KinLJ
Tg62C8NCg07X1VY8WDh/1u9dOzf9P7h/x//Ll079v33rEty+h/ev/79x7RyY
fefWZTD9+OFNDHch43t3roD9wMjIuBTNXxw43MWErG7likX/z54+gtcOYvH1
q+dQ+I8e3Pjv5ur8H81dyBgbCIXJe3q6EfQ/sXj92uVwew8d2AkXT0qMI9V9
l2Dy6P4lF4PSAbK9yGkChNHc5EvAfc4weVB6osRd166c/Z+dlfZfSUkRbn9i
QiyKGlD8gNIQkps4sYSjAJL7HGDi5Ljp9KlDYL0a6mr/kO1gZmacB6IT4mOw
6gOFBZ54Rg7L3SD+4kVzyHJfaGgQzLy/QKyJFjdTQHJnTh3GqR+H20KRzACV
O/9VVJT/3797lSS3nT97DFbmdmFJN6Ay+L+hgf4/bHpBeQYkv2jhbGR3uTFg
1oHyhPyIC4PKW6i5QmhmwspdsDpY2QjDu3dtxhZmKVj8CANk5wkk89mQzBMF
ibm6OmHE4YL5M7G5zQmP2/pBasgp90B6kOxIB7ajfKFmmoPEdmzb8N/MzARX
GsNVXyCDBJDayMjQH6B6h1T33bpxAZfdh9H4oDo3E8reygBpGxIDfjGQWO4h
qz1+dB+47MXhRmLrB3zAQlxc7P3Vy2cIumvJ4rlwe2RkpFHKOl9fL2Q3FFHR
fQx8fHwZbS0NL0B1NzZ3gcRJCB8QnoVDPJgc9wEBq5yczIr5c2f8wVZ+NDZU
k+q+dzjEJ5DpPhAQdna033fuzFGUeMSGMzNSSHUvDMtQ4D4QcJUQE/tCpt34
MBsDlQAXF8dkbm7O7Whmgus+NDvXEOEub2q5iwDIIcItMJxKJzehgyNEum+g
AEofBQ8eDADsFmCbarC6DwYGu/vUGQa3+0AA1N4dzO4DAVD/oA6ItQbaIaNg
aAEAlA+BgQ==
              "], {{0, 0}, {40, 40}}, {0, 255}, ColorFunction -> RGBColor], 
             Background -> None, ImageSize -> {40, 40}, 
             PlotRange -> {{0, 40}, {0, 40}}], "Canada"}], 
          Graphics[{{{}, {
              Hue[0.67, 0.6, 0.6], 
              
              Point[{{2.2089888*^9, 8.51102721952742*^10}, {2.2405248*^9, 
               9.611388494862978*^10}, {2.2720608*^9, 
               1.094720184098862*^11}, {2.3036832*^9, 
               1.2719440059381201`*^11}, {2.3352192*^9, 
               1.5529838808012518`*^11}, {2.3667552*^9, 
               1.6827567004560587`*^11}, {2.3982912*^9, 
               2.00061864743176*^11}, {2.4299136*^9, 
               2.0490855246558777`*^11}, {2.4614496*^9, 
               2.1158699904973694`*^11}, {2.4929856*^9, 
               2.354038885269667*^11}, {2.5245216*^9, 
               2.6527162075194025`*^11}, {2.556144*^9, 
               2.9670158287541626`*^11}, {2.58768*^9, 
               3.0382902858739197`*^11}, {2.619216*^9, 
               3.2898857285467914`*^11}, {2.650752*^9, 
               3.42332183759481*^11}, {2.6823744*^9, 3.50666308740087*^11}, {
               2.7139104*^9, 3.6336595904342676`*^11}, {2.7454464*^9, 
               4.1532010633550885`*^11}, {2.7769824*^9, 
               4.9056464772996716`*^11}, {2.8086048*^9, 
               5.4728594655086096`*^11}, {2.8401408*^9, 
               5.742041096183926*^11}, {2.8716768*^9, 
               5.888384271853116*^11}, {2.9032128*^9, 5.70279426668597*^11}, {
               2.9348352*^9, 5.546898143452979*^11}, {2.9663712*^9, 
               5.558404311536865*^11}, {2.9979072*^9, 
               5.816644190490315*^11}, {3.0294432*^9, 
               6.043712052962986*^11}, {3.0610656*^9, 6.27595363337625*^11}, {
               3.0926016*^9, 6.069244392498939*^11}, {3.1241376*^9, 
               6.512017086979576*^11}, {3.1556736*^9, 
               7.144534748267805*^11}, {3.187296*^9, 7.050688372908894*^11}, {
               3.218832*^9, 7.243042892296139*^11}, {3.250368*^9, 
               8.547108065250964*^11}, {3.281904*^9, 9.767419516622521*^11}, {
               3.3135264*^9, 1.1317597770741843`*^12}}]}, {}}}, {
           AspectRatio -> GoldenRatio^(-1), AxesOrigin -> {2208988800, 0}, 
            Frame -> True, 
            FrameTicks -> {{
              Automatic, 
               Automatic}, {{{2208988800, "1970"}, {2524521600, "1980"}, {
                2840140800, "1990"}, {3155673600, "2000"}, {
                2272060800, " "}, {2335219200, " "}, {2398291200, " "}, {
                2461449600, " "}, {2587680000, " "}, {2650752000, " "}, {
                2713910400, " "}, {2776982400, " "}, {2903212800, " "}, {
                2966371200, " "}, {3029443200, " "}, {3092601600, " "}, {
                3218832000, " "}, {3281904000, " "}}, {{2208988800, " "}, {
                2524521600, " "}, {2840140800, " "}, {3155673600, " "}, {
                2272060800, " "}, {2335219200, " "}, {2398291200, " "}, {
                2461449600, " "}, {2587680000, " "}, {2650752000, " "}, {
                2713910400, " "}, {2776982400, " "}, {2903212800, " "}, {
                2966371200, " "}, {3029443200, " "}, {3092601600, " "}, {
                3218832000, " "}, {3281904000, " "}}}}, 
            GridLines -> {{{2208988800, 
                GrayLevel[0.8]}, {2524521600, 
                GrayLevel[0.8]}, {2840140800, 
                GrayLevel[0.8]}, {3155673600, 
                GrayLevel[0.8]}}, None}, 
            PlotRange -> {{2.2089888*^9, 3.3135264*^9}, {0., 
             1.1317597770741843`*^12}}, PlotRangeClipping -> True, 
            PlotRangePadding -> {
              Scaled[0.02], 
              Scaled[0.02]}, Ticks -> None}]}, False]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ]},
    {
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = False}, 
       InterpretationBox[
        StyleBox[
         PaneSelectorBox[{False->
          TagBox[GridBox[{
             {
              OpenerBox[Dynamic[Typeset`var$$],
               Appearance->Automatic,
               AutoAction->False,
               ContinuousAction->False,
               Enabled->Automatic], 
              InterpretationBox[
               RowBox[{
                GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJmYGDQgGIWhlEwDMEsZmbma0CadaAdgg6A7moAUv+hOHJgXYMV
/Ofm5vqfnBT3Hsg2pYJ5jJycnNK6ujrLdXW114mJiBzh5GTLp8R9CxfMAuGf
kpISXSTqFWdnZ3cUFhaOkpKSagPy7RigcbF08bz/+/Zs+5+bm/mfkZHxF1CM
iVz3LV405/+yJfP/KygopBOhHmSPPgcH+1VZWZk3TY21r0D6a2rKvwYE+D6f
NWPy/7u3r/x/8ugWGO/etfm/oaH+ajzmsQGxEC5JHh6eNJAbgXZ9BdJ6BNwG
MuswSP3KFYv+3751Ce4OXPjh/ev/U1MT7wHT0FqgPk4gBhW3ukAcw4BI9zAs
isNeG6i8HAH3FYHUHdi3/R8hdyHj+3ev/vf0cP2N7h5NDfUfJ47tB8urqqr8
Z2FheQYUF8BhNz8Bt4GBqKhQwpLFc76T4j5YOE6c0P27p7vt/51bl/8/uHft
/6MHN1DUlJcVfWZjY3sDtIadGLfgAFJFRbmXSXUfMfjenSv/geXdX6Ad7hS4
j8nf3+fg44c3qe6+1SsWfVNUlAOVc/8pcB8DHx/vi9OnDlHVbYcO7gKVw6C4
lQFZQYHzeED+09PT+R0U6Pfr1o0LVHEfqKyEhps6JWEHAqqqynHdXa1g8y5d
OEGx20BpBWQWJyfHBSDNQan7gMCcAVpGgPIlpe67evnM/+Ag/y9ycrIXgWYK
UsF980FuW792+S9qpb9rV87+V1JSeAE014pCt4HqgP96ujp/QGUYpe6ClYF+
vt5/gHV5GuVBBwZuIDfevH6eIrddv3oOnEb27t7639vL47eoqGgLA2VlMwM/
P+80NjbWH12dLT/Ry39ysIK8HKje/29ibPSKgfK8C6qfqZJnYbihrvIzsL04
i4mJKRVoNiMFbhMAmnN12dL5VHMbCIPKT2tri3NA86UpDDt5BmiZQo14RcbA
NuM/YDvvEQMk75EKQO3RGgZIe+h7b0/7X2q6DVa2sLKy/gW2r7YyEF8+g+pB
SQak9trWzWup6i5kfPf25X+ZGal/BQQE1jEQzsMWMDcpKSn+zs/L+kdpWUIM
XrN6CbCPIddCKOCAbbAekNt27thIczch46bGmv9iYmJTCLmPlZkZ3McA9jnh
eQHUDl+2ZN7fLZvX/O/saAa3h6idT0Dllo6O1j4GAuMEwLy0DDndJSXGofdj
QH0+qucTUH1pZmYMysdmhMKQAZIG/YA4DeomUB8bVH4y2lhZLjh14iDc3Ivn
yS+vQe0fUH8E1EcCtWNioiP+MpDefkbuW3PDwlBQQOCbnIz0UxC7rLToDynu
ArkHRIPafgIC/PC+HQcHRwUDpH4nB4DcCSqr/kHNcwBiASB/l5aWxh9i+ySg
/rukpMR3mJuEhAS6GSBlCq6+JbFAEFhP3gDSWUCcjCQuwsHB/tjY2PDVrJlT
fuNy16KFs/9Pm9IPdpOamgoonED9DGYK3UQKkOXi4toHDMsf6O3qI4f2gN0F
LLs+S0iIL6Ojm9CBHS8vzw9QmoflSVD7jgGR90FjLWwD6D4FIyP9pyC3gcZn
pKUk/0DdBWqfUNJ+ohbgkpCQOFlTU/EyJzv9AyMj41SgmPFAOwoNgOLPHFiX
ljOMwCkBAKMoRAQ=
                  "], {{0, 0}, {40, 40}}, {0, 255},
                  ColorFunction->RGBColor],
                 Background->None,
                 ImageSize->{40, 40},
                 PlotRange->{{0, 40}, {0, 40}}], 
                "\[InvisibleSpace]", "\<\"France\"\>"}],
               Row[{
                 Graphics[
                  Raster[CompressedData["
1:eJxTTMoPSmJmYGDQgGIWhlEwDMEsZmbma0CadaAdgg6A7moAUv+hOHJgXYMV
/Ofm5vqfnBT3Hsg2pYJ5jJycnNK6ujrLdXW114mJiBzh5GTLp8R9CxfMAuGf
kpISXSTqFWdnZ3cUFhaOkpKSagPy7RigcbF08bz/+/Zs+5+bm/mfkZHxF1CM
iVz3LV405/+yJfP/KygopBOhHmSPPgcH+1VZWZk3TY21r0D6a2rKvwYE+D6f
NWPy/7u3r/x/8ugWGO/etfm/oaH+ajzmsQGxEC5JHh6eNJAbgXZ9BdJ6BNwG
MuswSP3KFYv+3751Ce4OXPjh/ev/U1MT7wHT0FqgPk4gBhW3ukAcw4BI9zAs
isNeG6i8HAH3FYHUHdi3/R8hdyHj+3ev/vf0cP2N7h5NDfUfJ47tB8urqqr8
Z2FheQYUF8BhNz8Bt4GBqKhQwpLFc76T4j5YOE6c0P27p7vt/51bl/8/uHft
/6MHN1DUlJcVfWZjY3sDtIadGLfgAFJFRbmXSXUfMfjenSv/geXdX6Ad7hS4
j8nf3+fg44c3qe6+1SsWfVNUlAOVc/8pcB8DHx/vi9OnDlHVbYcO7gKVw6C4
lQFZQYHzeED+09PT+R0U6Pfr1o0LVHEfqKyEhps6JWEHAqqqynHdXa1g8y5d
OEGx20BpBWQWJyfHBSDNQan7gMCcAVpGgPIlpe67evnM/+Ag/y9ycrIXgWYK
UsF980FuW792+S9qpb9rV87+V1JSeAE014pCt4HqgP96ujp/QGUYpe6ClYF+
vt5/gHV5GuVBBwZuIDfevH6eIrddv3oOnEb27t7639vL47eoqGgLA2VlMwM/
P+80NjbWH12dLT/Ry39ysIK8HKje/29ibPSKgfK8C6qfqZJnYbihrvIzsL04
i4mJKRVoNiMFbhMAmnN12dL5VHMbCIPKT2tri3NA86UpDDt5BmiZQo14RcbA
NuM/YDvvEQMk75EKQO3RGgZIe+h7b0/7X2q6DVa2sLKy/gW2r7YyEF8+g+pB
SQak9trWzWup6i5kfPf25X+ZGal/BQQE1jEQzsMWMDcpKSn+zs/L+kdpWUIM
XrN6CbCPIddCKOCAbbAekNt27thIczch46bGmv9iYmJTCLmPlZkZ3McA9jnh
eQHUDl+2ZN7fLZvX/O/saAa3h6idT0Dllo6O1j4GAuMEwLy0DDndJSXGofdj
QH0+qucTUH1pZmYMysdmhMKQAZIG/YA4DeomUB8bVH4y2lhZLjh14iDc3Ivn
yS+vQe0fUH8E1EcCtWNioiP+MpDefkbuW3PDwlBQQOCbnIz0UxC7rLToDynu
ArkHRIPafgIC/PC+HQcHRwUDpH4nB4DcCSqr/kHNcwBiASB/l5aWxh9i+ySg
/rukpMR3mJuEhAS6GSBlCq6+JbFAEFhP3gDSWUCcjCQuwsHB/tjY2PDVrJlT
fuNy16KFs/9Pm9IPdpOamgoonED9DGYK3UQKkOXi4toHDMsf6O3qI4f2gN0F
LLs+S0iIL6Ojm9CBHS8vzw9QmoflSVD7jgGR90FjLWwD6D4FIyP9pyC3gcZn
pKUk/0DdBWqfUNJ+ohbgkpCQOFlTU/EyJzv9AyMj41SgmPFAOwoNgOLPHFiX
ljOMwCkBAKMoRAQ=
                   "], {{0, 0}, {40, 40}}, {0, 255}, ColorFunction -> 
                   RGBColor], Background -> None, ImageSize -> {40, 40}, 
                  PlotRange -> {{0, 40}, {0, 40}}], "France"}]]}
            },
            BaselinePosition->{1, 1},
            ColumnsEqual->False,
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxBackground->{"Columns" -> {{Automatic}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
            RowsEqual->False],
           "Grid"], True->
          TagBox[GridBox[{
             {
              OpenerBox[Dynamic[Typeset`var$$],
               Appearance->Automatic,
               AutoAction->False,
               ContinuousAction->False,
               Enabled->Automatic], 
              InterpretationBox[
               RowBox[{
                GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJmYGDQgGIWhlEwDMEsZmbma0CadaAdgg6A7moAUv+hOHJgXYMV
/Ofm5vqfnBT3Hsg2pYJ5jJycnNK6ujrLdXW114mJiBzh5GTLp8R9CxfMAuGf
kpISXSTqFWdnZ3cUFhaOkpKSagPy7RigcbF08bz/+/Zs+5+bm/mfkZHxF1CM
iVz3LV405/+yJfP/KygopBOhHmSPPgcH+1VZWZk3TY21r0D6a2rKvwYE+D6f
NWPy/7u3r/x/8ugWGO/etfm/oaH+ajzmsQGxEC5JHh6eNJAbgXZ9BdJ6BNwG
MuswSP3KFYv+3751Ce4OXPjh/ev/U1MT7wHT0FqgPk4gBhW3ukAcw4BI9zAs
isNeG6i8HAH3FYHUHdi3/R8hdyHj+3ev/vf0cP2N7h5NDfUfJ47tB8urqqr8
Z2FheQYUF8BhNz8Bt4GBqKhQwpLFc76T4j5YOE6c0P27p7vt/51bl/8/uHft
/6MHN1DUlJcVfWZjY3sDtIadGLfgAFJFRbmXSXUfMfjenSv/geXdX6Ad7hS4
j8nf3+fg44c3qe6+1SsWfVNUlAOVc/8pcB8DHx/vi9OnDlHVbYcO7gKVw6C4
lQFZQYHzeED+09PT+R0U6Pfr1o0LVHEfqKyEhps6JWEHAqqqynHdXa1g8y5d
OEGx20BpBWQWJyfHBSDNQan7gMCcAVpGgPIlpe67evnM/+Ag/y9ycrIXgWYK
UsF980FuW792+S9qpb9rV87+V1JSeAE014pCt4HqgP96ujp/QGUYpe6ClYF+
vt5/gHV5GuVBBwZuIDfevH6eIrddv3oOnEb27t7639vL47eoqGgLA2VlMwM/
P+80NjbWH12dLT/Ry39ysIK8HKje/29ibPSKgfK8C6qfqZJnYbihrvIzsL04
i4mJKRVoNiMFbhMAmnN12dL5VHMbCIPKT2tri3NA86UpDDt5BmiZQo14RcbA
NuM/YDvvEQMk75EKQO3RGgZIe+h7b0/7X2q6DVa2sLKy/gW2r7YyEF8+g+pB
SQak9trWzWup6i5kfPf25X+ZGal/BQQE1jEQzsMWMDcpKSn+zs/L+kdpWUIM
XrN6CbCPIddCKOCAbbAekNt27thIczch46bGmv9iYmJTCLmPlZkZ3McA9jnh
eQHUDl+2ZN7fLZvX/O/saAa3h6idT0Dllo6O1j4GAuMEwLy0DDndJSXGofdj
QH0+qucTUH1pZmYMysdmhMKQAZIG/YA4DeomUB8bVH4y2lhZLjh14iDc3Ivn
yS+vQe0fUH8E1EcCtWNioiP+MpDefkbuW3PDwlBQQOCbnIz0UxC7rLToDynu
ArkHRIPafgIC/PC+HQcHRwUDpH4nB4DcCSqr/kHNcwBiASB/l5aWxh9i+ySg
/rukpMR3mJuEhAS6GSBlCq6+JbFAEFhP3gDSWUCcjCQuwsHB/tjY2PDVrJlT
fuNy16KFs/9Pm9IPdpOamgoonED9DGYK3UQKkOXi4toHDMsf6O3qI4f2gN0F
LLs+S0iIL6Ojm9CBHS8vzw9QmoflSVD7jgGR90FjLWwD6D4FIyP9pyC3gcZn
pKUk/0DdBWqfUNJ+ohbgkpCQOFlTU/EyJzv9AyMj41SgmPFAOwoNgOLPHFiX
ljOMwCkBAKMoRAQ=
                  "], {{0, 0}, {40, 40}}, {0, 255},
                  ColorFunction->RGBColor],
                 Background->None,
                 ImageSize->{40, 40},
                 PlotRange->{{0, 40}, {0, 40}}], 
                "\[InvisibleSpace]", "\<\"France\"\>"}],
               Row[{
                 Graphics[
                  Raster[CompressedData["
1:eJxTTMoPSmJmYGDQgGIWhlEwDMEsZmbma0CadaAdgg6A7moAUv+hOHJgXYMV
/Ofm5vqfnBT3Hsg2pYJ5jJycnNK6ujrLdXW114mJiBzh5GTLp8R9CxfMAuGf
kpISXSTqFWdnZ3cUFhaOkpKSagPy7RigcbF08bz/+/Zs+5+bm/mfkZHxF1CM
iVz3LV405/+yJfP/KygopBOhHmSPPgcH+1VZWZk3TY21r0D6a2rKvwYE+D6f
NWPy/7u3r/x/8ugWGO/etfm/oaH+ajzmsQGxEC5JHh6eNJAbgXZ9BdJ6BNwG
MuswSP3KFYv+3751Ce4OXPjh/ev/U1MT7wHT0FqgPk4gBhW3ukAcw4BI9zAs
isNeG6i8HAH3FYHUHdi3/R8hdyHj+3ev/vf0cP2N7h5NDfUfJ47tB8urqqr8
Z2FheQYUF8BhNz8Bt4GBqKhQwpLFc76T4j5YOE6c0P27p7vt/51bl/8/uHft
/6MHN1DUlJcVfWZjY3sDtIadGLfgAFJFRbmXSXUfMfjenSv/geXdX6Ad7hS4
j8nf3+fg44c3qe6+1SsWfVNUlAOVc/8pcB8DHx/vi9OnDlHVbYcO7gKVw6C4
lQFZQYHzeED+09PT+R0U6Pfr1o0LVHEfqKyEhps6JWEHAqqqynHdXa1g8y5d
OEGx20BpBWQWJyfHBSDNQan7gMCcAVpGgPIlpe67evnM/+Ag/y9ycrIXgWYK
UsF980FuW792+S9qpb9rV87+V1JSeAE014pCt4HqgP96ujp/QGUYpe6ClYF+
vt5/gHV5GuVBBwZuIDfevH6eIrddv3oOnEb27t7639vL47eoqGgLA2VlMwM/
P+80NjbWH12dLT/Ry39ysIK8HKje/29ibPSKgfK8C6qfqZJnYbihrvIzsL04
i4mJKRVoNiMFbhMAmnN12dL5VHMbCIPKT2tri3NA86UpDDt5BmiZQo14RcbA
NuM/YDvvEQMk75EKQO3RGgZIe+h7b0/7X2q6DVa2sLKy/gW2r7YyEF8+g+pB
SQak9trWzWup6i5kfPf25X+ZGal/BQQE1jEQzsMWMDcpKSn+zs/L+kdpWUIM
XrN6CbCPIddCKOCAbbAekNt27thIczch46bGmv9iYmJTCLmPlZkZ3McA9jnh
eQHUDl+2ZN7fLZvX/O/saAa3h6idT0Dllo6O1j4GAuMEwLy0DDndJSXGofdj
QH0+qucTUH1pZmYMysdmhMKQAZIG/YA4DeomUB8bVH4y2lhZLjh14iDc3Ivn
yS+vQe0fUH8E1EcCtWNioiP+MpDefkbuW3PDwlBQQOCbnIz0UxC7rLToDynu
ArkHRIPafgIC/PC+HQcHRwUDpH4nB4DcCSqr/kHNcwBiASB/l5aWxh9i+ySg
/rukpMR3mJuEhAS6GSBlCq6+JbFAEFhP3gDSWUCcjCQuwsHB/tjY2PDVrJlT
fuNy16KFs/9Pm9IPdpOamgoonED9DGYK3UQKkOXi4toHDMsf6O3qI4f2gN0F
LLs+S0iIL6Ojm9CBHS8vzw9QmoflSVD7jgGR90FjLWwD6D4FIyP9pyC3gcZn
pKUk/0DdBWqfUNJ+ohbgkpCQOFlTU/EyJzv9AyMj41SgmPFAOwoNgOLPHFiX
ljOMwCkBAKMoRAQ=
                   "], {{0, 0}, {40, 40}}, {0, 255}, ColorFunction -> 
                   RGBColor], Background -> None, ImageSize -> {40, 40}, 
                  PlotRange -> {{0, 40}, {0, 40}}], "France"}]]},
             {"", 
              PaneBox[
               GraphicsBox[{{}, 
                 {Hue[0.67, 0.6, 0.6], 
                  PointBox[{{2.2089888*^9, 1.4860490316148856`*^11}, {
                   2.2405248*^9, 1.6599051480654675`*^11}, {2.2720608*^9, 
                   2.0370806787064062`*^11}, {2.3036832*^9, 
                   2.6392489611186478`*^11}, {2.3352192*^9, 
                   2.8178832637142487`*^11}, {2.3667552*^9, 
                   3.5608510491218945`*^11}, {2.3982912*^9, 
                   3.682859284585891*^11}, {2.4299136*^9, 
                   4.0667378485213184`*^11}, {2.4614496*^9, 
                   5.030293764523027*^11}, {2.4929856*^9, 
                   6.065025382702382*^11}, {2.5245216*^9, 
                   6.890241190158655*^11}, {2.556144*^9, 
                   6.034738136776915*^11}, {2.58768*^9, 
                   5.73916593597205*^11}, {2.619216*^9, 
                   5.526822076601039*^11}, {2.650752*^9, 
                   5.2512930500900977`*^11}, {2.6823744*^9, 
                   5.489972719697796*^11}, {2.7139104*^9, 
                   7.642085878650359*^11}, {2.7454464*^9, 
                   9.25744668315392*^11}, {2.7769824*^9, 
                   1.0065906584591847`*^12}, {2.8086048*^9, 
                   1.0080845330770159`*^12}, {2.8401408*^9, 
                   1.239216273221249*^12}, {2.8716768*^9, 
                   1.2382601056413403`*^12}, {2.9032128*^9, 
                   1.3716431138354666`*^12}, {2.9348352*^9, 
                   1.291925428637067*^12}, {2.9663712*^9, 
                   1.3651592829157007`*^12}, {2.9979072*^9, 
                   1.5701600445521953`*^12}, {3.0294432*^9, 
                   1.574359362801807*^12}, {3.0610656*^9, 
                   1.4255858862792654`*^12}, {3.0926016*^9, 
                   1.4727634653137236`*^12}, {3.1241376*^9, 
                   1.455813223397778*^12}, {3.1556736*^9, 
                   1.3279619433987944`*^12}, {3.187296*^9, 
                   1.3397410314001665`*^12}, {3.218832*^9, 
                   1.457392660121621*^12}, {3.250368*^9, 
                   1.799946390329191*^12}, {3.281904*^9, 
                   2.0599603906303352`*^12}, {3.3135264*^9, 
                   2.1265776254725664`*^12}}]}, {}},
                AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                AxesOrigin->NCache[{2208988800, 0}, {2.2089888*^9, 0}],
                Frame->True,
                FrameTicks->{{Automatic, Automatic}, {{{
                    NCache[2208988800, 2.2089888*^9], 
                    FormBox["\"1970\"", TraditionalForm]}, {
                    NCache[2524521600, 2.5245216*^9], 
                    FormBox["\"1980\"", TraditionalForm]}, {
                    NCache[2840140800, 2.8401408*^9], 
                    FormBox["\"1990\"", TraditionalForm]}, {
                    NCache[3155673600, 3.1556736*^9], 
                    FormBox["\"2000\"", TraditionalForm]}, {
                    NCache[2272060800, 2.2720608*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2335219200, 2.3352192*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2398291200, 2.3982912*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2461449600, 2.4614496*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2587680000, 2.58768*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2650752000, 2.650752*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2713910400, 2.7139104*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2776982400, 2.7769824*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2903212800, 2.9032128*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2966371200, 2.9663712*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3029443200, 3.0294432*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3092601600, 3.0926016*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3218832000, 3.218832*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3281904000, 3.281904*^9], 
                    FormBox["\" \"", TraditionalForm]}}, {{
                    NCache[2208988800, 2.2089888*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2524521600, 2.5245216*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2840140800, 2.8401408*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3155673600, 3.1556736*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2272060800, 2.2720608*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2335219200, 2.3352192*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2398291200, 2.3982912*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2461449600, 2.4614496*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2587680000, 2.58768*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2650752000, 2.650752*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2713910400, 2.7139104*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2776982400, 2.7769824*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2903212800, 2.9032128*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2966371200, 2.9663712*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3029443200, 3.0294432*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3092601600, 3.0926016*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3218832000, 3.218832*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3281904000, 3.281904*^9], 
                    FormBox["\" \"", TraditionalForm]}}}},
                GridLines->NCache[{{{2208988800, 
                    GrayLevel[0.8]}, {2524521600, 
                    GrayLevel[0.8]}, {2840140800, 
                    GrayLevel[0.8]}, {3155673600, 
                    GrayLevel[0.8]}}, None}, {{{2.2089888*^9, 
                    GrayLevel[0.8]}, {2.5245216*^9, 
                    GrayLevel[0.8]}, {2.8401408*^9, 
                    GrayLevel[0.8]}, {3.1556736*^9, 
                    GrayLevel[0.8]}}, None}],
                
                PlotRange->{{2.2089888*^9, 3.3135264*^9}, {0., 
                 2.1265776254725664`*^12}},
                PlotRangeClipping->True,
                PlotRangePadding->{
                  Scaled[0.02], 
                  Scaled[0.02]},
                Ticks->None],
               ImageMargins->0]}
            },
            BaselinePosition->{1, 1},
            ColumnsEqual->False,
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxBackground->{"Columns" -> {{Automatic}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
            RowsEqual->False],
           "Grid"]}, Dynamic[Typeset`var$$],
          Alignment->Automatic,
          BaselinePosition->Baseline,
          DefaultBaseStyle->"OpenerView",
          ImageMargins->0,
          ImageSize->Automatic],
         Deployed->False,
         StripOnInput->False],
        OpenerView[{
          Row[{
            Graphics[
             Raster[CompressedData["
1:eJxTTMoPSmJmYGDQgGIWhlEwDMEsZmbma0CadaAdgg6A7moAUv+hOHJgXYMV
/Ofm5vqfnBT3Hsg2pYJ5jJycnNK6ujrLdXW114mJiBzh5GTLp8R9CxfMAuGf
kpISXSTqFWdnZ3cUFhaOkpKSagPy7RigcbF08bz/+/Zs+5+bm/mfkZHxF1CM
iVz3LV405/+yJfP/KygopBOhHmSPPgcH+1VZWZk3TY21r0D6a2rKvwYE+D6f
NWPy/7u3r/x/8ugWGO/etfm/oaH+ajzmsQGxEC5JHh6eNJAbgXZ9BdJ6BNwG
MuswSP3KFYv+3751Ce4OXPjh/ev/U1MT7wHT0FqgPk4gBhW3ukAcw4BI9zAs
isNeG6i8HAH3FYHUHdi3/R8hdyHj+3ev/vf0cP2N7h5NDfUfJ47tB8urqqr8
Z2FheQYUF8BhNz8Bt4GBqKhQwpLFc76T4j5YOE6c0P27p7vt/51bl/8/uHft
/6MHN1DUlJcVfWZjY3sDtIadGLfgAFJFRbmXSXUfMfjenSv/geXdX6Ad7hS4
j8nf3+fg44c3qe6+1SsWfVNUlAOVc/8pcB8DHx/vi9OnDlHVbYcO7gKVw6C4
lQFZQYHzeED+09PT+R0U6Pfr1o0LVHEfqKyEhps6JWEHAqqqynHdXa1g8y5d
OEGx20BpBWQWJyfHBSDNQan7gMCcAVpGgPIlpe67evnM/+Ag/y9ycrIXgWYK
UsF980FuW792+S9qpb9rV87+V1JSeAE014pCt4HqgP96ujp/QGUYpe6ClYF+
vt5/gHV5GuVBBwZuIDfevH6eIrddv3oOnEb27t7639vL47eoqGgLA2VlMwM/
P+80NjbWH12dLT/Ry39ysIK8HKje/29ibPSKgfK8C6qfqZJnYbihrvIzsL04
i4mJKRVoNiMFbhMAmnN12dL5VHMbCIPKT2tri3NA86UpDDt5BmiZQo14RcbA
NuM/YDvvEQMk75EKQO3RGgZIe+h7b0/7X2q6DVa2sLKy/gW2r7YyEF8+g+pB
SQak9trWzWup6i5kfPf25X+ZGal/BQQE1jEQzsMWMDcpKSn+zs/L+kdpWUIM
XrN6CbCPIddCKOCAbbAekNt27thIczch46bGmv9iYmJTCLmPlZkZ3McA9jnh
eQHUDl+2ZN7fLZvX/O/saAa3h6idT0Dllo6O1j4GAuMEwLy0DDndJSXGofdj
QH0+qucTUH1pZmYMysdmhMKQAZIG/YA4DeomUB8bVH4y2lhZLjh14iDc3Ivn
yS+vQe0fUH8E1EcCtWNioiP+MpDefkbuW3PDwlBQQOCbnIz0UxC7rLToDynu
ArkHRIPafgIC/PC+HQcHRwUDpH4nB4DcCSqr/kHNcwBiASB/l5aWxh9i+ySg
/rukpMR3mJuEhAS6GSBlCq6+JbFAEFhP3gDSWUCcjCQuwsHB/tjY2PDVrJlT
fuNy16KFs/9Pm9IPdpOamgoonED9DGYK3UQKkOXi4toHDMsf6O3qI4f2gN0F
LLs+S0iIL6Ojm9CBHS8vzw9QmoflSVD7jgGR90FjLWwD6D4FIyP9pyC3gcZn
pKUk/0DdBWqfUNJ+ohbgkpCQOFlTU/EyJzv9AyMj41SgmPFAOwoNgOLPHFiX
ljOMwCkBAKMoRAQ=
              "], {{0, 0}, {40, 40}}, {0, 255}, ColorFunction -> RGBColor], 
             Background -> None, ImageSize -> {40, 40}, 
             PlotRange -> {{0, 40}, {0, 40}}], "France"}], 
          Graphics[{{{}, {
              Hue[0.67, 0.6, 0.6], 
              
              Point[{{2.2089888*^9, 1.4860490316148856`*^11}, {2.2405248*^9, 
               1.6599051480654675`*^11}, {2.2720608*^9, 
               2.0370806787064062`*^11}, {2.3036832*^9, 
               2.6392489611186478`*^11}, {2.3352192*^9, 
               2.8178832637142487`*^11}, {2.3667552*^9, 
               3.5608510491218945`*^11}, {2.3982912*^9, 
               3.682859284585891*^11}, {2.4299136*^9, 
               4.0667378485213184`*^11}, {2.4614496*^9, 
               5.030293764523027*^11}, {2.4929856*^9, 
               6.065025382702382*^11}, {2.5245216*^9, 
               6.890241190158655*^11}, {2.556144*^9, 6.034738136776915*^11}, {
               2.58768*^9, 5.73916593597205*^11}, {2.619216*^9, 
               5.526822076601039*^11}, {2.650752*^9, 
               5.2512930500900977`*^11}, {2.6823744*^9, 
               5.489972719697796*^11}, {2.7139104*^9, 
               7.642085878650359*^11}, {2.7454464*^9, 9.25744668315392*^11}, {
               2.7769824*^9, 1.0065906584591847`*^12}, {2.8086048*^9, 
               1.0080845330770159`*^12}, {2.8401408*^9, 
               1.239216273221249*^12}, {2.8716768*^9, 
               1.2382601056413403`*^12}, {2.9032128*^9, 
               1.3716431138354666`*^12}, {2.9348352*^9, 
               1.291925428637067*^12}, {2.9663712*^9, 
               1.3651592829157007`*^12}, {2.9979072*^9, 
               1.5701600445521953`*^12}, {3.0294432*^9, 
               1.574359362801807*^12}, {3.0610656*^9, 
               1.4255858862792654`*^12}, {3.0926016*^9, 
               1.4727634653137236`*^12}, {3.1241376*^9, 
               1.455813223397778*^12}, {3.1556736*^9, 
               1.3279619433987944`*^12}, {3.187296*^9, 
               1.3397410314001665`*^12}, {3.218832*^9, 
               1.457392660121621*^12}, {3.250368*^9, 1.799946390329191*^12}, {
               3.281904*^9, 2.0599603906303352`*^12}, {3.3135264*^9, 
               2.1265776254725664`*^12}}]}, {}}}, {
           AspectRatio -> GoldenRatio^(-1), AxesOrigin -> {2208988800, 0}, 
            Frame -> True, 
            FrameTicks -> {{
              Automatic, 
               Automatic}, {{{2208988800, "1970"}, {2524521600, "1980"}, {
                2840140800, "1990"}, {3155673600, "2000"}, {
                2272060800, " "}, {2335219200, " "}, {2398291200, " "}, {
                2461449600, " "}, {2587680000, " "}, {2650752000, " "}, {
                2713910400, " "}, {2776982400, " "}, {2903212800, " "}, {
                2966371200, " "}, {3029443200, " "}, {3092601600, " "}, {
                3218832000, " "}, {3281904000, " "}}, {{2208988800, " "}, {
                2524521600, " "}, {2840140800, " "}, {3155673600, " "}, {
                2272060800, " "}, {2335219200, " "}, {2398291200, " "}, {
                2461449600, " "}, {2587680000, " "}, {2650752000, " "}, {
                2713910400, " "}, {2776982400, " "}, {2903212800, " "}, {
                2966371200, " "}, {3029443200, " "}, {3092601600, " "}, {
                3218832000, " "}, {3281904000, " "}}}}, 
            GridLines -> {{{2208988800, 
                GrayLevel[0.8]}, {2524521600, 
                GrayLevel[0.8]}, {2840140800, 
                GrayLevel[0.8]}, {3155673600, 
                GrayLevel[0.8]}}, None}, 
            PlotRange -> {{2.2089888*^9, 3.3135264*^9}, {0., 
             2.1265776254725664`*^12}}, PlotRangeClipping -> True, 
            PlotRangePadding -> {
              Scaled[0.02], 
              Scaled[0.02]}, Ticks -> None}]}, False]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ]},
    {
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = False}, 
       InterpretationBox[
        StyleBox[
         PaneSelectorBox[{False->
          TagBox[GridBox[{
             {
              OpenerBox[Dynamic[Typeset`var$$],
               Appearance->Automatic,
               AutoAction->False,
               ContinuousAction->False,
               Enabled->Automatic], 
              InterpretationBox[
               RowBox[{
                GraphicsBox[RasterBox[CompressedData["
1:eJzlmGlMVFcUx98wDMwGQy3MBjPMlGIQSgltQEZmQGhtSGmM1TapjUpKi2nU
RhDEBSSKJNYKxS5glNpiAjXRUluJsVCxslkE2VcBZbPFtB9YnSqLt+cM8wix
tc3Me69fepJ/bt7kzbm/d7dzztXH71wfz6coys8qR+r/Y87Ozp8olYrj1sfl
IKf/sHseaC3oJdAKUIC1f76Tk9MGaHNARK1WTUL7uVAoNOt03v1isTAOniWP
+RKzDQcM6wyGlWM5x478nrxr5yiySCSS3wQCgTk1JWnio6NZ5vbWG+RwZsb4
qZOfTVVX/Ui6O5tIxoF95pCQF7uUSuX7AgE/WyIRNbm5uTZZv5c1A4638vNy
5+8O95KRoVvk2tXLBHmabtYS/O2f1NZSR5b7PjsVHRVp5vF4xNXVtQJcOrDJ
BxZ26GD6+L+xPEnDgz2W1hgehvP/AstsaCaYp3u9PS128aE6228S2EOzMH4Z
4E/BMh/faDQU45zayzc00E3u9HeQnOwjc+CPgLQs8uF63pSUuGMS15+9jKi+
3jYStTpiWKFQ9IBPdxYZHaRSSfP2bVunmfChWpvriMkU/gv49GLI9DQoApQg
l3u0rzKE3s08lD6N82QvW2NDDXknbnO9p1wexpBNpdNpu6AlaftT73d1NM4x
HbfSi+eJ3ls7CD5DGbLJwX46XZA/19/bzoiJ1pnCgofeGk0N+NYxZLOYSqW6
lPvxUVbYfq69SlZHmC6AWzc22MC0Xp7q0drqK6zwfVGQh3GjlGIpbmi12uxL
pSWssOE3UgvnHWtxw8HBYYdM5jqDe40J2+2+DvJcgP+MlW8DW3xgSvR5oeQs
4/FDRow7cVve/jU4OKgA/EqZwsH4TSNfR1sDK3NM60Te8Xn0C/laOcUgdqjV
yoJdSR+wykYLc4yNG9+cfeXl6HYfH30y5Awx0GWsjYik7IfvOeGj1dx4nd43
BPLLcVvgYH6bszIP/MElH8bIM4WnLPs7MDBgwMbx83w3fssA5kRcMqKqKsuJ
j88z9bbAQb0Qk5+fO0XnvVwJYrplfvl8fowtfG5usg6TMbzfaFzVff5c0QRX
fFFREY+ohTVoa02HeZUeVKLVah4M3unihO9s8VePli17CuslgY18tPHgrPp0
394UMxdrsepaGfFwd6+wkw3Nz1OtuvftN1/PcLH2IPZNQB/BDPhkYrF4qLjo
y2mmdcfjwnOaWlh77zHgQ1NsTYhvYZOtvq6S3rfVDNnQBGvWRNczqX2XCuch
N+dDrIXHwLeIBb4UEBm43WnxD2Np+faerqbFPu3ZOwcz9o+AnxCK4V0MxLrN
cL4/wLsWqN0WYyadGwYFBc7ic/2NKpv4sg5n9ML/fJkOHpper0+KjDSdlsvd
RwUCxyv+/itGyi5/R2JfjbHcBVyvqbBpHPFceS02ppJi/45QCOK7uLgUUdZx
xFqb7hfrDPp3yEX/9kzavi1hXiqVPtTpNHEssy01vDshe/ckL45Z361W8vq6
tZb8k8fjYR1JwlaGzi2NPelpe+ZEIqHlHVg3uzlik0H/9ylrfo1zGx5uICKR
iI6lKLyj8gFN+/n5TpaXXSQajRddh+C5cowjNtrwfoxgfUz3CeNRB60BFLnk
PR6cIw30O46OjpiLVnLMRnl4eKzfnZI4lp6WushHPTlHl+Ff6Pdg7W7imk+j
0SQGBz9/TqFQFFr7fYP66z04K/YnpeuAPA==
                  "], {{0, 0}, {40, 40}}, {0, 255},
                  ColorFunction->RGBColor],
                 Background->None,
                 ImageSize->{40, 40},
                 PlotRange->{{0, 40}, {0, 40}}], 
                "\[InvisibleSpace]", "\<\"Germany\"\>"}],
               Row[{
                 Graphics[
                  Raster[CompressedData["
1:eJzlmGlMVFcUx98wDMwGQy3MBjPMlGIQSgltQEZmQGhtSGmM1TapjUpKi2nU
RhDEBSSKJNYKxS5glNpiAjXRUluJsVCxslkE2VcBZbPFtB9YnSqLt+cM8wix
tc3Me69fepJ/bt7kzbm/d7dzztXH71wfz6coys8qR+r/Y87Ozp8olYrj1sfl
IKf/sHseaC3oJdAKUIC1f76Tk9MGaHNARK1WTUL7uVAoNOt03v1isTAOniWP
+RKzDQcM6wyGlWM5x478nrxr5yiySCSS3wQCgTk1JWnio6NZ5vbWG+RwZsb4
qZOfTVVX/Ui6O5tIxoF95pCQF7uUSuX7AgE/WyIRNbm5uTZZv5c1A4638vNy
5+8O95KRoVvk2tXLBHmabtYS/O2f1NZSR5b7PjsVHRVp5vF4xNXVtQJcOrDJ
BxZ26GD6+L+xPEnDgz2W1hgehvP/AstsaCaYp3u9PS128aE6228S2EOzMH4Z
4E/BMh/faDQU45zayzc00E3u9HeQnOwjc+CPgLQs8uF63pSUuGMS15+9jKi+
3jYStTpiWKFQ9IBPdxYZHaRSSfP2bVunmfChWpvriMkU/gv49GLI9DQoApQg
l3u0rzKE3s08lD6N82QvW2NDDXknbnO9p1wexpBNpdNpu6AlaftT73d1NM4x
HbfSi+eJ3ls7CD5DGbLJwX46XZA/19/bzoiJ1pnCgofeGk0N+NYxZLOYSqW6
lPvxUVbYfq69SlZHmC6AWzc22MC0Xp7q0drqK6zwfVGQh3GjlGIpbmi12uxL
pSWssOE3UgvnHWtxw8HBYYdM5jqDe40J2+2+DvJcgP+MlW8DW3xgSvR5oeQs
4/FDRow7cVve/jU4OKgA/EqZwsH4TSNfR1sDK3NM60Te8Xn0C/laOcUgdqjV
yoJdSR+wykYLc4yNG9+cfeXl6HYfH30y5Awx0GWsjYik7IfvOeGj1dx4nd43
BPLLcVvgYH6bszIP/MElH8bIM4WnLPs7MDBgwMbx83w3fssA5kRcMqKqKsuJ
j88z9bbAQb0Qk5+fO0XnvVwJYrplfvl8fowtfG5usg6TMbzfaFzVff5c0QRX
fFFREY+ohTVoa02HeZUeVKLVah4M3unihO9s8VePli17CuslgY18tPHgrPp0
394UMxdrsepaGfFwd6+wkw3Nz1OtuvftN1/PcLH2IPZNQB/BDPhkYrF4qLjo
y2mmdcfjwnOaWlh77zHgQ1NsTYhvYZOtvq6S3rfVDNnQBGvWRNczqX2XCuch
N+dDrIXHwLeIBb4UEBm43WnxD2Np+faerqbFPu3ZOwcz9o+AnxCK4V0MxLrN
cL4/wLsWqN0WYyadGwYFBc7ic/2NKpv4sg5n9ML/fJkOHpper0+KjDSdlsvd
RwUCxyv+/itGyi5/R2JfjbHcBVyvqbBpHPFceS02ppJi/45QCOK7uLgUUdZx
xFqb7hfrDPp3yEX/9kzavi1hXiqVPtTpNHEssy01vDshe/ckL45Z361W8vq6
tZb8k8fjYR1JwlaGzi2NPelpe+ZEIqHlHVg3uzlik0H/9ylrfo1zGx5uICKR
iI6lKLyj8gFN+/n5TpaXXSQajRddh+C5cowjNtrwfoxgfUz3CeNRB60BFLnk
PR6cIw30O46OjpiLVnLMRnl4eKzfnZI4lp6WushHPTlHl+Ff6Pdg7W7imk+j
0SQGBz9/TqFQFFr7fYP66z04K/YnpeuAPA==
                   "], {{0, 0}, {40, 40}}, {0, 255}, ColorFunction -> 
                   RGBColor], Background -> None, ImageSize -> {40, 40}, 
                  PlotRange -> {{0, 40}, {0, 40}}], "Germany"}]]}
            },
            BaselinePosition->{1, 1},
            ColumnsEqual->False,
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxBackground->{"Columns" -> {{Automatic}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
            RowsEqual->False],
           "Grid"], True->
          TagBox[GridBox[{
             {
              OpenerBox[Dynamic[Typeset`var$$],
               Appearance->Automatic,
               AutoAction->False,
               ContinuousAction->False,
               Enabled->Automatic], 
              InterpretationBox[
               RowBox[{
                GraphicsBox[RasterBox[CompressedData["
1:eJzlmGlMVFcUx98wDMwGQy3MBjPMlGIQSgltQEZmQGhtSGmM1TapjUpKi2nU
RhDEBSSKJNYKxS5glNpiAjXRUluJsVCxslkE2VcBZbPFtB9YnSqLt+cM8wix
tc3Me69fepJ/bt7kzbm/d7dzztXH71wfz6coys8qR+r/Y87Ozp8olYrj1sfl
IKf/sHseaC3oJdAKUIC1f76Tk9MGaHNARK1WTUL7uVAoNOt03v1isTAOniWP
+RKzDQcM6wyGlWM5x478nrxr5yiySCSS3wQCgTk1JWnio6NZ5vbWG+RwZsb4
qZOfTVVX/Ui6O5tIxoF95pCQF7uUSuX7AgE/WyIRNbm5uTZZv5c1A4638vNy
5+8O95KRoVvk2tXLBHmabtYS/O2f1NZSR5b7PjsVHRVp5vF4xNXVtQJcOrDJ
BxZ26GD6+L+xPEnDgz2W1hgehvP/AstsaCaYp3u9PS128aE6228S2EOzMH4Z
4E/BMh/faDQU45zayzc00E3u9HeQnOwjc+CPgLQs8uF63pSUuGMS15+9jKi+
3jYStTpiWKFQ9IBPdxYZHaRSSfP2bVunmfChWpvriMkU/gv49GLI9DQoApQg
l3u0rzKE3s08lD6N82QvW2NDDXknbnO9p1wexpBNpdNpu6AlaftT73d1NM4x
HbfSi+eJ3ls7CD5DGbLJwX46XZA/19/bzoiJ1pnCgofeGk0N+NYxZLOYSqW6
lPvxUVbYfq69SlZHmC6AWzc22MC0Xp7q0drqK6zwfVGQh3GjlGIpbmi12uxL
pSWssOE3UgvnHWtxw8HBYYdM5jqDe40J2+2+DvJcgP+MlW8DW3xgSvR5oeQs
4/FDRow7cVve/jU4OKgA/EqZwsH4TSNfR1sDK3NM60Te8Xn0C/laOcUgdqjV
yoJdSR+wykYLc4yNG9+cfeXl6HYfH30y5Awx0GWsjYik7IfvOeGj1dx4nd43
BPLLcVvgYH6bszIP/MElH8bIM4WnLPs7MDBgwMbx83w3fssA5kRcMqKqKsuJ
j88z9bbAQb0Qk5+fO0XnvVwJYrplfvl8fowtfG5usg6TMbzfaFzVff5c0QRX
fFFREY+ohTVoa02HeZUeVKLVah4M3unihO9s8VePli17CuslgY18tPHgrPp0
394UMxdrsepaGfFwd6+wkw3Nz1OtuvftN1/PcLH2IPZNQB/BDPhkYrF4qLjo
y2mmdcfjwnOaWlh77zHgQ1NsTYhvYZOtvq6S3rfVDNnQBGvWRNczqX2XCuch
N+dDrIXHwLeIBb4UEBm43WnxD2Np+faerqbFPu3ZOwcz9o+AnxCK4V0MxLrN
cL4/wLsWqN0WYyadGwYFBc7ic/2NKpv4sg5n9ML/fJkOHpper0+KjDSdlsvd
RwUCxyv+/itGyi5/R2JfjbHcBVyvqbBpHPFceS02ppJi/45QCOK7uLgUUdZx
xFqb7hfrDPp3yEX/9kzavi1hXiqVPtTpNHEssy01vDshe/ckL45Z361W8vq6
tZb8k8fjYR1JwlaGzi2NPelpe+ZEIqHlHVg3uzlik0H/9ylrfo1zGx5uICKR
iI6lKLyj8gFN+/n5TpaXXSQajRddh+C5cowjNtrwfoxgfUz3CeNRB60BFLnk
PR6cIw30O46OjpiLVnLMRnl4eKzfnZI4lp6WushHPTlHl+Ff6Pdg7W7imk+j
0SQGBz9/TqFQFFr7fYP66z04K/YnpeuAPA==
                  "], {{0, 0}, {40, 40}}, {0, 255},
                  ColorFunction->RGBColor],
                 Background->None,
                 ImageSize->{40, 40},
                 PlotRange->{{0, 40}, {0, 40}}], 
                "\[InvisibleSpace]", "\<\"Germany\"\>"}],
               Row[{
                 Graphics[
                  Raster[CompressedData["
1:eJzlmGlMVFcUx98wDMwGQy3MBjPMlGIQSgltQEZmQGhtSGmM1TapjUpKi2nU
RhDEBSSKJNYKxS5glNpiAjXRUluJsVCxslkE2VcBZbPFtB9YnSqLt+cM8wix
tc3Me69fepJ/bt7kzbm/d7dzztXH71wfz6coys8qR+r/Y87Ozp8olYrj1sfl
IKf/sHseaC3oJdAKUIC1f76Tk9MGaHNARK1WTUL7uVAoNOt03v1isTAOniWP
+RKzDQcM6wyGlWM5x478nrxr5yiySCSS3wQCgTk1JWnio6NZ5vbWG+RwZsb4
qZOfTVVX/Ui6O5tIxoF95pCQF7uUSuX7AgE/WyIRNbm5uTZZv5c1A4638vNy
5+8O95KRoVvk2tXLBHmabtYS/O2f1NZSR5b7PjsVHRVp5vF4xNXVtQJcOrDJ
BxZ26GD6+L+xPEnDgz2W1hgehvP/AstsaCaYp3u9PS128aE6228S2EOzMH4Z
4E/BMh/faDQU45zayzc00E3u9HeQnOwjc+CPgLQs8uF63pSUuGMS15+9jKi+
3jYStTpiWKFQ9IBPdxYZHaRSSfP2bVunmfChWpvriMkU/gv49GLI9DQoApQg
l3u0rzKE3s08lD6N82QvW2NDDXknbnO9p1wexpBNpdNpu6AlaftT73d1NM4x
HbfSi+eJ3ls7CD5DGbLJwX46XZA/19/bzoiJ1pnCgofeGk0N+NYxZLOYSqW6
lPvxUVbYfq69SlZHmC6AWzc22MC0Xp7q0drqK6zwfVGQh3GjlGIpbmi12uxL
pSWssOE3UgvnHWtxw8HBYYdM5jqDe40J2+2+DvJcgP+MlW8DW3xgSvR5oeQs
4/FDRow7cVve/jU4OKgA/EqZwsH4TSNfR1sDK3NM60Te8Xn0C/laOcUgdqjV
yoJdSR+wykYLc4yNG9+cfeXl6HYfH30y5Awx0GWsjYik7IfvOeGj1dx4nd43
BPLLcVvgYH6bszIP/MElH8bIM4WnLPs7MDBgwMbx83w3fssA5kRcMqKqKsuJ
j88z9bbAQb0Qk5+fO0XnvVwJYrplfvl8fowtfG5usg6TMbzfaFzVff5c0QRX
fFFREY+ohTVoa02HeZUeVKLVah4M3unihO9s8VePli17CuslgY18tPHgrPp0
394UMxdrsepaGfFwd6+wkw3Nz1OtuvftN1/PcLH2IPZNQB/BDPhkYrF4qLjo
y2mmdcfjwnOaWlh77zHgQ1NsTYhvYZOtvq6S3rfVDNnQBGvWRNczqX2XCuch
N+dDrIXHwLeIBb4UEBm43WnxD2Np+faerqbFPu3ZOwcz9o+AnxCK4V0MxLrN
cL4/wLsWqN0WYyadGwYFBc7ic/2NKpv4sg5n9ML/fJkOHpper0+KjDSdlsvd
RwUCxyv+/itGyi5/R2JfjbHcBVyvqbBpHPFceS02ppJi/45QCOK7uLgUUdZx
xFqb7hfrDPp3yEX/9kzavi1hXiqVPtTpNHEssy01vDshe/ckL45Z361W8vq6
tZb8k8fjYR1JwlaGzi2NPelpe+ZEIqHlHVg3uzlik0H/9ylrfo1zGx5uICKR
iI6lKLyj8gFN+/n5TpaXXSQajRddh+C5cowjNtrwfoxgfUz3CeNRB60BFLnk
PR6cIw30O46OjpiLVnLMRnl4eKzfnZI4lp6WushHPTlHl+Ff6Pdg7W7imk+j
0SQGBz9/TqFQFFr7fYP66z04K/YnpeuAPA==
                   "], {{0, 0}, {40, 40}}, {0, 255}, ColorFunction -> 
                   RGBColor], Background -> None, ImageSize -> {40, 40}, 
                  PlotRange -> {{0, 40}, {0, 40}}], "Germany"}]]},
             {"", 
              PaneBox[
               GraphicsBox[{{}, 
                 {Hue[0.67, 0.6, 0.6], 
                  PointBox[{{2.2089888*^9, 2.0810384443389188`*^11}, {
                   2.2405248*^9, 2.406633633299223*^11}, {2.2720608*^9, 
                   2.901008009718065*^11}, {2.3036832*^9, 
                   3.859488165006181*^11}, {2.3352192*^9, 
                   4.294585203779621*^11}, {2.3667552*^9, 
                   4.7140775174106274`*^11}, {2.3982912*^9, 
                   5.0176605229263135`*^11}, {2.4299136*^9, 
                   5.811627444679083*^11}, {2.4614496*^9, 
                   7.210086697895739*^11}, {2.4929856*^9, 
                   8.529460356368018*^11}, {2.5245216*^9, 
                   9.12584520044493*^11}, {2.556144*^9, 
                   7.661408754107075*^11}, {2.58768*^9, 
                   7.417212813241608*^11}, {2.619216*^9, 
                   7.391623711685114*^11}, {2.650752*^9, 
                   6.956865796672733*^11}, {2.6823744*^9, 
                   7.021427484597816*^11}, {2.7139104*^9, 
                   1.0066288875939098`*^12}, {2.7454464*^9, 
                   1.2559866089578115`*^12}, {2.7769824*^9, 
                   1.3534382051911914`*^12}, {2.8086048*^9, 
                   1.344638146460924*^12}, {2.8401408*^9, 
                   1.7073594468832742`*^12}, {2.8716768*^9, 
                   1.8085817176429229`*^12}, {2.9032128*^9, 
                   2.0622474911792007`*^12}, {2.9348352*^9, 
                   2.004389958855537*^12}, {2.9663712*^9, 
                   2.1462382715819878`*^12}, {2.9979072*^9, 
                   2.5226236677348384`*^12}, {3.0294432*^9, 
                   2.438564676803662*^12}, {3.0610656*^9, 
                   2.1605698959520244`*^12}, {3.0926016*^9, 
                   2.1844745936107478`*^12}, {3.1241376*^9, 
                   2.1435558626971543`*^12}, {3.1556736*^9, 
                   1.9002196577147825`*^12}, {3.187296*^9, 
                   1.8909539959373965`*^12}, {3.218832*^9, 
                   2.0187441865571965`*^12}, {3.250368*^9, 
                   2.4416665647769404`*^12}, {3.281904*^9, 
                   2.7511128494533535`*^12}, {3.3135264*^9, 
                   2.794856489081232*^12}}]}, {}},
                AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                AxesOrigin->NCache[{2208988800, 0}, {2.2089888*^9, 0}],
                Frame->True,
                FrameTicks->{{Automatic, Automatic}, {{{
                    NCache[2208988800, 2.2089888*^9], 
                    FormBox["\"1970\"", TraditionalForm]}, {
                    NCache[2524521600, 2.5245216*^9], 
                    FormBox["\"1980\"", TraditionalForm]}, {
                    NCache[2840140800, 2.8401408*^9], 
                    FormBox["\"1990\"", TraditionalForm]}, {
                    NCache[3155673600, 3.1556736*^9], 
                    FormBox["\"2000\"", TraditionalForm]}, {
                    NCache[2272060800, 2.2720608*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2335219200, 2.3352192*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2398291200, 2.3982912*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2461449600, 2.4614496*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2587680000, 2.58768*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2650752000, 2.650752*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2713910400, 2.7139104*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2776982400, 2.7769824*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2903212800, 2.9032128*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2966371200, 2.9663712*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3029443200, 3.0294432*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3092601600, 3.0926016*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3218832000, 3.218832*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3281904000, 3.281904*^9], 
                    FormBox["\" \"", TraditionalForm]}}, {{
                    NCache[2208988800, 2.2089888*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2524521600, 2.5245216*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2840140800, 2.8401408*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3155673600, 3.1556736*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2272060800, 2.2720608*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2335219200, 2.3352192*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2398291200, 2.3982912*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2461449600, 2.4614496*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2587680000, 2.58768*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2650752000, 2.650752*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2713910400, 2.7139104*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2776982400, 2.7769824*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2903212800, 2.9032128*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2966371200, 2.9663712*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3029443200, 3.0294432*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3092601600, 3.0926016*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3218832000, 3.218832*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3281904000, 3.281904*^9], 
                    FormBox["\" \"", TraditionalForm]}}}},
                GridLines->NCache[{{{2208988800, 
                    GrayLevel[0.8]}, {2524521600, 
                    GrayLevel[0.8]}, {2840140800, 
                    GrayLevel[0.8]}, {3155673600, 
                    GrayLevel[0.8]}}, None}, {{{2.2089888*^9, 
                    GrayLevel[0.8]}, {2.5245216*^9, 
                    GrayLevel[0.8]}, {2.8401408*^9, 
                    GrayLevel[0.8]}, {3.1556736*^9, 
                    GrayLevel[0.8]}}, None}],
                
                PlotRange->{{2.2089888*^9, 3.3135264*^9}, {0., 
                 2.794856489081232*^12}},
                PlotRangeClipping->True,
                PlotRangePadding->{
                  Scaled[0.02], 
                  Scaled[0.02]},
                Ticks->None],
               ImageMargins->0]}
            },
            BaselinePosition->{1, 1},
            ColumnsEqual->False,
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxBackground->{"Columns" -> {{Automatic}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
            RowsEqual->False],
           "Grid"]}, Dynamic[Typeset`var$$],
          Alignment->Automatic,
          BaselinePosition->Baseline,
          DefaultBaseStyle->"OpenerView",
          ImageMargins->0,
          ImageSize->Automatic],
         Deployed->False,
         StripOnInput->False],
        OpenerView[{
          Row[{
            Graphics[
             Raster[CompressedData["
1:eJzlmGlMVFcUx98wDMwGQy3MBjPMlGIQSgltQEZmQGhtSGmM1TapjUpKi2nU
RhDEBSSKJNYKxS5glNpiAjXRUluJsVCxslkE2VcBZbPFtB9YnSqLt+cM8wix
tc3Me69fepJ/bt7kzbm/d7dzztXH71wfz6coys8qR+r/Y87Ozp8olYrj1sfl
IKf/sHseaC3oJdAKUIC1f76Tk9MGaHNARK1WTUL7uVAoNOt03v1isTAOniWP
+RKzDQcM6wyGlWM5x478nrxr5yiySCSS3wQCgTk1JWnio6NZ5vbWG+RwZsb4
qZOfTVVX/Ui6O5tIxoF95pCQF7uUSuX7AgE/WyIRNbm5uTZZv5c1A4638vNy
5+8O95KRoVvk2tXLBHmabtYS/O2f1NZSR5b7PjsVHRVp5vF4xNXVtQJcOrDJ
BxZ26GD6+L+xPEnDgz2W1hgehvP/AstsaCaYp3u9PS128aE6228S2EOzMH4Z
4E/BMh/faDQU45zayzc00E3u9HeQnOwjc+CPgLQs8uF63pSUuGMS15+9jKi+
3jYStTpiWKFQ9IBPdxYZHaRSSfP2bVunmfChWpvriMkU/gv49GLI9DQoApQg
l3u0rzKE3s08lD6N82QvW2NDDXknbnO9p1wexpBNpdNpu6AlaftT73d1NM4x
HbfSi+eJ3ls7CD5DGbLJwX46XZA/19/bzoiJ1pnCgofeGk0N+NYxZLOYSqW6
lPvxUVbYfq69SlZHmC6AWzc22MC0Xp7q0drqK6zwfVGQh3GjlGIpbmi12uxL
pSWssOE3UgvnHWtxw8HBYYdM5jqDe40J2+2+DvJcgP+MlW8DW3xgSvR5oeQs
4/FDRow7cVve/jU4OKgA/EqZwsH4TSNfR1sDK3NM60Te8Xn0C/laOcUgdqjV
yoJdSR+wykYLc4yNG9+cfeXl6HYfH30y5Awx0GWsjYik7IfvOeGj1dx4nd43
BPLLcVvgYH6bszIP/MElH8bIM4WnLPs7MDBgwMbx83w3fssA5kRcMqKqKsuJ
j88z9bbAQb0Qk5+fO0XnvVwJYrplfvl8fowtfG5usg6TMbzfaFzVff5c0QRX
fFFREY+ohTVoa02HeZUeVKLVah4M3unihO9s8VePli17CuslgY18tPHgrPp0
394UMxdrsepaGfFwd6+wkw3Nz1OtuvftN1/PcLH2IPZNQB/BDPhkYrF4qLjo
y2mmdcfjwnOaWlh77zHgQ1NsTYhvYZOtvq6S3rfVDNnQBGvWRNczqX2XCuch
N+dDrIXHwLeIBb4UEBm43WnxD2Np+faerqbFPu3ZOwcz9o+AnxCK4V0MxLrN
cL4/wLsWqN0WYyadGwYFBc7ic/2NKpv4sg5n9ML/fJkOHpper0+KjDSdlsvd
RwUCxyv+/itGyi5/R2JfjbHcBVyvqbBpHPFceS02ppJi/45QCOK7uLgUUdZx
xFqb7hfrDPp3yEX/9kzavi1hXiqVPtTpNHEssy01vDshe/ckL45Z361W8vq6
tZb8k8fjYR1JwlaGzi2NPelpe+ZEIqHlHVg3uzlik0H/9ylrfo1zGx5uICKR
iI6lKLyj8gFN+/n5TpaXXSQajRddh+C5cowjNtrwfoxgfUz3CeNRB60BFLnk
PR6cIw30O46OjpiLVnLMRnl4eKzfnZI4lp6WushHPTlHl+Ff6Pdg7W7imk+j
0SQGBz9/TqFQFFr7fYP66z04K/YnpeuAPA==
              "], {{0, 0}, {40, 40}}, {0, 255}, ColorFunction -> RGBColor], 
             Background -> None, ImageSize -> {40, 40}, 
             PlotRange -> {{0, 40}, {0, 40}}], "Germany"}], 
          Graphics[{{{}, {
              Hue[0.67, 0.6, 0.6], 
              
              Point[{{2.2089888*^9, 2.0810384443389188`*^11}, {2.2405248*^9, 
               2.406633633299223*^11}, {2.2720608*^9, 
               2.901008009718065*^11}, {2.3036832*^9, 
               3.859488165006181*^11}, {2.3352192*^9, 
               4.294585203779621*^11}, {2.3667552*^9, 
               4.7140775174106274`*^11}, {2.3982912*^9, 
               5.0176605229263135`*^11}, {2.4299136*^9, 
               5.811627444679083*^11}, {2.4614496*^9, 
               7.210086697895739*^11}, {2.4929856*^9, 
               8.529460356368018*^11}, {2.5245216*^9, 9.12584520044493*^11}, {
               2.556144*^9, 7.661408754107075*^11}, {2.58768*^9, 
               7.417212813241608*^11}, {2.619216*^9, 7.391623711685114*^11}, {
               2.650752*^9, 6.956865796672733*^11}, {2.6823744*^9, 
               7.021427484597816*^11}, {2.7139104*^9, 
               1.0066288875939098`*^12}, {2.7454464*^9, 
               1.2559866089578115`*^12}, {2.7769824*^9, 
               1.3534382051911914`*^12}, {2.8086048*^9, 
               1.344638146460924*^12}, {2.8401408*^9, 
               1.7073594468832742`*^12}, {2.8716768*^9, 
               1.8085817176429229`*^12}, {2.9032128*^9, 
               2.0622474911792007`*^12}, {2.9348352*^9, 
               2.004389958855537*^12}, {2.9663712*^9, 
               2.1462382715819878`*^12}, {2.9979072*^9, 
               2.5226236677348384`*^12}, {3.0294432*^9, 
               2.438564676803662*^12}, {3.0610656*^9, 
               2.1605698959520244`*^12}, {3.0926016*^9, 
               2.1844745936107478`*^12}, {3.1241376*^9, 
               2.1435558626971543`*^12}, {3.1556736*^9, 
               1.9002196577147825`*^12}, {3.187296*^9, 
               1.8909539959373965`*^12}, {3.218832*^9, 
               2.0187441865571965`*^12}, {3.250368*^9, 
               2.4416665647769404`*^12}, {3.281904*^9, 
               2.7511128494533535`*^12}, {3.3135264*^9, 
               2.794856489081232*^12}}]}, {}}}, {
           AspectRatio -> GoldenRatio^(-1), AxesOrigin -> {2208988800, 0}, 
            Frame -> True, 
            FrameTicks -> {{
              Automatic, 
               Automatic}, {{{2208988800, "1970"}, {2524521600, "1980"}, {
                2840140800, "1990"}, {3155673600, "2000"}, {
                2272060800, " "}, {2335219200, " "}, {2398291200, " "}, {
                2461449600, " "}, {2587680000, " "}, {2650752000, " "}, {
                2713910400, " "}, {2776982400, " "}, {2903212800, " "}, {
                2966371200, " "}, {3029443200, " "}, {3092601600, " "}, {
                3218832000, " "}, {3281904000, " "}}, {{2208988800, " "}, {
                2524521600, " "}, {2840140800, " "}, {3155673600, " "}, {
                2272060800, " "}, {2335219200, " "}, {2398291200, " "}, {
                2461449600, " "}, {2587680000, " "}, {2650752000, " "}, {
                2713910400, " "}, {2776982400, " "}, {2903212800, " "}, {
                2966371200, " "}, {3029443200, " "}, {3092601600, " "}, {
                3218832000, " "}, {3281904000, " "}}}}, 
            GridLines -> {{{2208988800, 
                GrayLevel[0.8]}, {2524521600, 
                GrayLevel[0.8]}, {2840140800, 
                GrayLevel[0.8]}, {3155673600, 
                GrayLevel[0.8]}}, None}, 
            PlotRange -> {{2.2089888*^9, 3.3135264*^9}, {0., 
             2.794856489081232*^12}}, PlotRangeClipping -> True, 
            PlotRangePadding -> {
              Scaled[0.02], 
              Scaled[0.02]}, Ticks -> None}]}, False]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ]},
    {
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = False}, 
       InterpretationBox[
        StyleBox[
         PaneSelectorBox[{False->
          TagBox[GridBox[{
             {
              OpenerBox[Dynamic[Typeset`var$$],
               Appearance->Automatic,
               AutoAction->False,
               ContinuousAction->False,
               Enabled->Automatic], 
              InterpretationBox[
               RowBox[{
                GraphicsBox[RasterBox[CompressedData["
1:eJztmH9Uk1UYx98x2BgD3gmMsbFB/BAyQAlpCO2IUiSnQlOyREWBAk04olCy
VE6hoksFRERRUPLISUtUkgrtl2igaEYQIfJD0UrNJLQUVKbdnmfurR0aCtOx
f3rO+Z67e3ff+37e+977PM993eJTpsSzKYp6XCtz6n9js9mRcnnA8mHDBF9i
1dQ8OiYDhXG5nNsV+3cT4LsF9WdNDQUmpWm6Zu6chIbNhfk36k7WkPbWRgLt
qDdNyGUjEjkWIMeitxbe/eWnVsJob9kHxHu451cmZEMj2WtX9TY1ntQw4bxh
eb6jmbS1NJC42Jhm6CMFRYLEQw3n5ua6PCwstDc4OOhq0rzEq6MD/MtemvRi
dVJSYn1xUcGd9EWpJCjoqSq5PPCyVOq8f6j5wDiwV3OgjLawsHgFShaIB3IQ
ix0XQ9tlc3Nz9RtzX++ZMX1aJ4/HKzIB44OMzeVyr+3auZ14erpfgLrLQ4wl
BBEzM7NeKL1AHo8CUCwSvTbc06MrdvaMdqjGUIaHienIl78+W+MbbG1trkDp
/AgQg3JzVJdaT9eTUSP91Hw+f4GB4wRmLE1vxz14+NABkpw0p416+Dlk+fv5
pJTu2Hqn40wTCR2ruMXhcKKg3cKAsR4DkW+OfKHxE9vfL+qG+viH5BuVkaE8
3dhwnEjE4huwXy5Bm6XO/7xBjDUB+Zqb6jR8xVsK1PCskw3k4goEtklWVlYF
GUuUPZ9UlBEPD7c9uh1cXWW4xy8MYkypi4vsN1wnyJeWOv8a+IQpBrCZCwR0
zYQJ4ddjZkarce6OH6tCX1gN/9Ggl0HJUVGTOhWK4M8HOqilpWUe8HX/fL5F
w/fdt9VEKBTWDoJLwGKxVsA4s2Qy58bao4eIbsxbn7e2i8+3agoJGdMJvvvi
poJ1NyNfiBjwXhE6OGA+RLJWvKMZD3+D/10zCL6FeI2jo1BdkJ/brcuGwucG
JnLgs3ISFjauMzIyIp0axPqDtauEIoHH456j7uUeKN8BXOoOmgd5Ved7quV3
mfnvqyNVB8mG/JwrwcHyjQMct6+xtKUZKJZ6cEx3gGc6yzwLvL//zBmqZGth
T3xczInQUIUK+j+tcx9jmquzs6R6zeosgvtJ35xh2749O8HPW7dAf7shYNIY
TfOfsbGx7oEc+S9984VcJdsK1UsWL2pVrVzWQdva3obL4ocADedgDfiOrh/q
a/WusZbm70lgYMCfQqH9VujrChoBmgjiGpkN1yT6avJx+Ud62U6fqiNeXp6/
cjiafTbUloJsfX0aI4ytiQlxFyCXes4EbJYQR/6AnEHvemMUFzsT44O9Cfjo
qVMnH8UzWX9sVV9XEkXImGUmYMO4F120ZUNvf2wnag+TiIjwLuiqMBaDj8+I
V319fXaD/wzRacY94QS+5MC24k16/UjpjuKbEOMPQr9plPH8Lg05fVvs7JmY
1xNtnLOGWF+C9cx3F+uNC8r0tN8lEkkW9LExEheai4/PE42pC5J7YG/eRn+P
TPBOMTfV5NH62DC3Gf2kf4URuRibMjHy+YvoH5h7Y35aX3es372AKt+7i0gk
TqWU8WMp+niib33dT6uyMpn8xtCzzkCNeLi73Tl39tSA2bCvtTWf4dNde8aY
Sz9Ya29DPntL9x0/SLnZKg0fTdN5UDrB/poFZ5VdRuATjB83thLPCMjH5El7
ykp7wB/fN15gHhwTE62m/s1lUYacG+9nFiEhclVQUGC9SOR4daSfbzfuTbyX
UpmmOYsw56X+hN/StGyhj5iNMfwGi2dSmbWVFb4vAnE+wdvbq0p7X7Isc2m/
fJWf7mP4/I3Ep2s0sDVByafu5Wz2sMYwPpDCjXnkTNuP/3BhLrMyK/NK0rzE
Bvwf8qoPh4APre/3G5adnV0lnLU7ZTLp9XW5q+9u3rSemTP8vuAE4mifyVTG
1jKECwQ28+Hc3wq/E4xxo78BEvI7/Q==
                  "], {{0, 0}, {40, 40}}, {0, 255},
                  ColorFunction->RGBColor],
                 Background->None,
                 ImageSize->{40, 40},
                 PlotRange->{{0, 40}, {0, 40}}], 
                "\[InvisibleSpace]", "\<\"Italy\"\>"}],
               Row[{
                 Graphics[
                  Raster[CompressedData["
1:eJztmH9Uk1UYx98x2BgD3gmMsbFB/BAyQAlpCO2IUiSnQlOyREWBAk04olCy
VE6hoksFRERRUPLISUtUkgrtl2igaEYQIfJD0UrNJLQUVKbdnmfurR0aCtOx
f3rO+Z67e3ff+37e+977PM993eJTpsSzKYp6XCtz6n9js9mRcnnA8mHDBF9i
1dQ8OiYDhXG5nNsV+3cT4LsF9WdNDQUmpWm6Zu6chIbNhfk36k7WkPbWRgLt
qDdNyGUjEjkWIMeitxbe/eWnVsJob9kHxHu451cmZEMj2WtX9TY1ntQw4bxh
eb6jmbS1NJC42Jhm6CMFRYLEQw3n5ua6PCwstDc4OOhq0rzEq6MD/MtemvRi
dVJSYn1xUcGd9EWpJCjoqSq5PPCyVOq8f6j5wDiwV3OgjLawsHgFShaIB3IQ
ix0XQ9tlc3Nz9RtzX++ZMX1aJ4/HKzIB44OMzeVyr+3auZ14erpfgLrLQ4wl
BBEzM7NeKL1AHo8CUCwSvTbc06MrdvaMdqjGUIaHienIl78+W+MbbG1trkDp
/AgQg3JzVJdaT9eTUSP91Hw+f4GB4wRmLE1vxz14+NABkpw0p416+Dlk+fv5
pJTu2Hqn40wTCR2ruMXhcKKg3cKAsR4DkW+OfKHxE9vfL+qG+viH5BuVkaE8
3dhwnEjE4huwXy5Bm6XO/7xBjDUB+Zqb6jR8xVsK1PCskw3k4goEtklWVlYF
GUuUPZ9UlBEPD7c9uh1cXWW4xy8MYkypi4vsN1wnyJeWOv8a+IQpBrCZCwR0
zYQJ4ddjZkarce6OH6tCX1gN/9Ggl0HJUVGTOhWK4M8HOqilpWUe8HX/fL5F
w/fdt9VEKBTWDoJLwGKxVsA4s2Qy58bao4eIbsxbn7e2i8+3agoJGdMJvvvi
poJ1NyNfiBjwXhE6OGA+RLJWvKMZD3+D/10zCL6FeI2jo1BdkJ/brcuGwucG
JnLgs3ISFjauMzIyIp0axPqDtauEIoHH456j7uUeKN8BXOoOmgd5Ved7quV3
mfnvqyNVB8mG/JwrwcHyjQMct6+xtKUZKJZ6cEx3gGc6yzwLvL//zBmqZGth
T3xczInQUIUK+j+tcx9jmquzs6R6zeosgvtJ35xh2749O8HPW7dAf7shYNIY
TfOfsbGx7oEc+S9984VcJdsK1UsWL2pVrVzWQdva3obL4ocADedgDfiOrh/q
a/WusZbm70lgYMCfQqH9VujrChoBmgjiGpkN1yT6avJx+Ud62U6fqiNeXp6/
cjiafTbUloJsfX0aI4ytiQlxFyCXes4EbJYQR/6AnEHvemMUFzsT44O9Cfjo
qVMnH8UzWX9sVV9XEkXImGUmYMO4F120ZUNvf2wnag+TiIjwLuiqMBaDj8+I
V319fXaD/wzRacY94QS+5MC24k16/UjpjuKbEOMPQr9plPH8Lg05fVvs7JmY
1xNtnLOGWF+C9cx3F+uNC8r0tN8lEkkW9LExEheai4/PE42pC5J7YG/eRn+P
TPBOMTfV5NH62DC3Gf2kf4URuRibMjHy+YvoH5h7Y35aX3es372AKt+7i0gk
TqWU8WMp+niib33dT6uyMpn8xtCzzkCNeLi73Tl39tSA2bCvtTWf4dNde8aY
Sz9Ya29DPntL9x0/SLnZKg0fTdN5UDrB/poFZ5VdRuATjB83thLPCMjH5El7
ykp7wB/fN15gHhwTE62m/s1lUYacG+9nFiEhclVQUGC9SOR4daSfbzfuTbyX
UpmmOYsw56X+hN/StGyhj5iNMfwGi2dSmbWVFb4vAnE+wdvbq0p7X7Isc2m/
fJWf7mP4/I3Ep2s0sDVByafu5Wz2sMYwPpDCjXnkTNuP/3BhLrMyK/NK0rzE
Bvwf8qoPh4APre/3G5adnV0lnLU7ZTLp9XW5q+9u3rSemTP8vuAE4mifyVTG
1jKECwQ28+Hc3wq/E4xxo78BEvI7/Q==
                   "], {{0, 0}, {40, 40}}, {0, 255}, ColorFunction -> 
                   RGBColor], Background -> None, ImageSize -> {40, 40}, 
                  PlotRange -> {{0, 40}, {0, 40}}], "Italy"}]]}
            },
            BaselinePosition->{1, 1},
            ColumnsEqual->False,
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxBackground->{"Columns" -> {{Automatic}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
            RowsEqual->False],
           "Grid"], True->
          TagBox[GridBox[{
             {
              OpenerBox[Dynamic[Typeset`var$$],
               Appearance->Automatic,
               AutoAction->False,
               ContinuousAction->False,
               Enabled->Automatic], 
              InterpretationBox[
               RowBox[{
                GraphicsBox[RasterBox[CompressedData["
1:eJztmH9Uk1UYx98x2BgD3gmMsbFB/BAyQAlpCO2IUiSnQlOyREWBAk04olCy
VE6hoksFRERRUPLISUtUkgrtl2igaEYQIfJD0UrNJLQUVKbdnmfurR0aCtOx
f3rO+Z67e3ff+37e+977PM993eJTpsSzKYp6XCtz6n9js9mRcnnA8mHDBF9i
1dQ8OiYDhXG5nNsV+3cT4LsF9WdNDQUmpWm6Zu6chIbNhfk36k7WkPbWRgLt
qDdNyGUjEjkWIMeitxbe/eWnVsJob9kHxHu451cmZEMj2WtX9TY1ntQw4bxh
eb6jmbS1NJC42Jhm6CMFRYLEQw3n5ua6PCwstDc4OOhq0rzEq6MD/MtemvRi
dVJSYn1xUcGd9EWpJCjoqSq5PPCyVOq8f6j5wDiwV3OgjLawsHgFShaIB3IQ
ix0XQ9tlc3Nz9RtzX++ZMX1aJ4/HKzIB44OMzeVyr+3auZ14erpfgLrLQ4wl
BBEzM7NeKL1AHo8CUCwSvTbc06MrdvaMdqjGUIaHienIl78+W+MbbG1trkDp
/AgQg3JzVJdaT9eTUSP91Hw+f4GB4wRmLE1vxz14+NABkpw0p416+Dlk+fv5
pJTu2Hqn40wTCR2ruMXhcKKg3cKAsR4DkW+OfKHxE9vfL+qG+viH5BuVkaE8
3dhwnEjE4huwXy5Bm6XO/7xBjDUB+Zqb6jR8xVsK1PCskw3k4goEtklWVlYF
GUuUPZ9UlBEPD7c9uh1cXWW4xy8MYkypi4vsN1wnyJeWOv8a+IQpBrCZCwR0
zYQJ4ddjZkarce6OH6tCX1gN/9Ggl0HJUVGTOhWK4M8HOqilpWUe8HX/fL5F
w/fdt9VEKBTWDoJLwGKxVsA4s2Qy58bao4eIbsxbn7e2i8+3agoJGdMJvvvi
poJ1NyNfiBjwXhE6OGA+RLJWvKMZD3+D/10zCL6FeI2jo1BdkJ/brcuGwucG
JnLgs3ISFjauMzIyIp0axPqDtauEIoHH456j7uUeKN8BXOoOmgd5Ved7quV3
mfnvqyNVB8mG/JwrwcHyjQMct6+xtKUZKJZ6cEx3gGc6yzwLvL//zBmqZGth
T3xczInQUIUK+j+tcx9jmquzs6R6zeosgvtJ35xh2749O8HPW7dAf7shYNIY
TfOfsbGx7oEc+S9984VcJdsK1UsWL2pVrVzWQdva3obL4ocADedgDfiOrh/q
a/WusZbm70lgYMCfQqH9VujrChoBmgjiGpkN1yT6avJx+Ud62U6fqiNeXp6/
cjiafTbUloJsfX0aI4ytiQlxFyCXes4EbJYQR/6AnEHvemMUFzsT44O9Cfjo
qVMnH8UzWX9sVV9XEkXImGUmYMO4F120ZUNvf2wnag+TiIjwLuiqMBaDj8+I
V319fXaD/wzRacY94QS+5MC24k16/UjpjuKbEOMPQr9plPH8Lg05fVvs7JmY
1xNtnLOGWF+C9cx3F+uNC8r0tN8lEkkW9LExEheai4/PE42pC5J7YG/eRn+P
TPBOMTfV5NH62DC3Gf2kf4URuRibMjHy+YvoH5h7Y35aX3es372AKt+7i0gk
TqWU8WMp+niib33dT6uyMpn8xtCzzkCNeLi73Tl39tSA2bCvtTWf4dNde8aY
Sz9Ya29DPntL9x0/SLnZKg0fTdN5UDrB/poFZ5VdRuATjB83thLPCMjH5El7
ykp7wB/fN15gHhwTE62m/s1lUYacG+9nFiEhclVQUGC9SOR4daSfbzfuTbyX
UpmmOYsw56X+hN/StGyhj5iNMfwGi2dSmbWVFb4vAnE+wdvbq0p7X7Isc2m/
fJWf7mP4/I3Ep2s0sDVByafu5Wz2sMYwPpDCjXnkTNuP/3BhLrMyK/NK0rzE
Bvwf8qoPh4APre/3G5adnV0lnLU7ZTLp9XW5q+9u3rSemTP8vuAE4mifyVTG
1jKECwQ28+Hc3wq/E4xxo78BEvI7/Q==
                  "], {{0, 0}, {40, 40}}, {0, 255},
                  ColorFunction->RGBColor],
                 Background->None,
                 ImageSize->{40, 40},
                 PlotRange->{{0, 40}, {0, 40}}], 
                "\[InvisibleSpace]", "\<\"Italy\"\>"}],
               Row[{
                 Graphics[
                  Raster[CompressedData["
1:eJztmH9Uk1UYx98x2BgD3gmMsbFB/BAyQAlpCO2IUiSnQlOyREWBAk04olCy
VE6hoksFRERRUPLISUtUkgrtl2igaEYQIfJD0UrNJLQUVKbdnmfurR0aCtOx
f3rO+Z67e3ff+37e+977PM993eJTpsSzKYp6XCtz6n9js9mRcnnA8mHDBF9i
1dQ8OiYDhXG5nNsV+3cT4LsF9WdNDQUmpWm6Zu6chIbNhfk36k7WkPbWRgLt
qDdNyGUjEjkWIMeitxbe/eWnVsJob9kHxHu451cmZEMj2WtX9TY1ntQw4bxh
eb6jmbS1NJC42Jhm6CMFRYLEQw3n5ua6PCwstDc4OOhq0rzEq6MD/MtemvRi
dVJSYn1xUcGd9EWpJCjoqSq5PPCyVOq8f6j5wDiwV3OgjLawsHgFShaIB3IQ
ix0XQ9tlc3Nz9RtzX++ZMX1aJ4/HKzIB44OMzeVyr+3auZ14erpfgLrLQ4wl
BBEzM7NeKL1AHo8CUCwSvTbc06MrdvaMdqjGUIaHienIl78+W+MbbG1trkDp
/AgQg3JzVJdaT9eTUSP91Hw+f4GB4wRmLE1vxz14+NABkpw0p416+Dlk+fv5
pJTu2Hqn40wTCR2ruMXhcKKg3cKAsR4DkW+OfKHxE9vfL+qG+viH5BuVkaE8
3dhwnEjE4huwXy5Bm6XO/7xBjDUB+Zqb6jR8xVsK1PCskw3k4goEtklWVlYF
GUuUPZ9UlBEPD7c9uh1cXWW4xy8MYkypi4vsN1wnyJeWOv8a+IQpBrCZCwR0
zYQJ4ddjZkarce6OH6tCX1gN/9Ggl0HJUVGTOhWK4M8HOqilpWUe8HX/fL5F
w/fdt9VEKBTWDoJLwGKxVsA4s2Qy58bao4eIbsxbn7e2i8+3agoJGdMJvvvi
poJ1NyNfiBjwXhE6OGA+RLJWvKMZD3+D/10zCL6FeI2jo1BdkJ/brcuGwucG
JnLgs3ISFjauMzIyIp0axPqDtauEIoHH456j7uUeKN8BXOoOmgd5Ved7quV3
mfnvqyNVB8mG/JwrwcHyjQMct6+xtKUZKJZ6cEx3gGc6yzwLvL//zBmqZGth
T3xczInQUIUK+j+tcx9jmquzs6R6zeosgvtJ35xh2749O8HPW7dAf7shYNIY
TfOfsbGx7oEc+S9984VcJdsK1UsWL2pVrVzWQdva3obL4ocADedgDfiOrh/q
a/WusZbm70lgYMCfQqH9VujrChoBmgjiGpkN1yT6avJx+Ud62U6fqiNeXp6/
cjiafTbUloJsfX0aI4ytiQlxFyCXes4EbJYQR/6AnEHvemMUFzsT44O9Cfjo
qVMnH8UzWX9sVV9XEkXImGUmYMO4F120ZUNvf2wnag+TiIjwLuiqMBaDj8+I
V319fXaD/wzRacY94QS+5MC24k16/UjpjuKbEOMPQr9plPH8Lg05fVvs7JmY
1xNtnLOGWF+C9cx3F+uNC8r0tN8lEkkW9LExEheai4/PE42pC5J7YG/eRn+P
TPBOMTfV5NH62DC3Gf2kf4URuRibMjHy+YvoH5h7Y35aX3es372AKt+7i0gk
TqWU8WMp+niib33dT6uyMpn8xtCzzkCNeLi73Tl39tSA2bCvtTWf4dNde8aY
Sz9Ya29DPntL9x0/SLnZKg0fTdN5UDrB/poFZ5VdRuATjB83thLPCMjH5El7
ykp7wB/fN15gHhwTE62m/s1lUYacG+9nFiEhclVQUGC9SOR4daSfbzfuTbyX
UpmmOYsw56X+hN/StGyhj5iNMfwGi2dSmbWVFb4vAnE+wdvbq0p7X7Isc2m/
fJWf7mP4/I3Ep2s0sDVByafu5Wz2sMYwPpDCjXnkTNuP/3BhLrMyK/NK0rzE
Bvwf8qoPh4APre/3G5adnV0lnLU7ZTLp9XW5q+9u3rSemTP8vuAE4mifyVTG
1jKECwQ28+Hc3wq/E4xxo78BEvI7/Q==
                   "], {{0, 0}, {40, 40}}, {0, 255}, ColorFunction -> 
                   RGBColor], Background -> None, ImageSize -> {40, 40}, 
                  PlotRange -> {{0, 40}, {0, 40}}], "Italy"}]]},
             {"", 
              PaneBox[
               GraphicsBox[{{}, 
                 {Hue[0.67, 0.6, 0.6], 
                  PointBox[{{2.2089888*^9, 1.1001857267906438`*^11}, {
                   2.2405248*^9, 1.208138060400842*^11}, {2.2720608*^9, 
                   1.4051891364948038`*^11}, {2.3036832*^9, 
                   1.6924997901562256`*^11}, {2.3352192*^9, 
                   1.9190272481504858`*^11}, {2.3667552*^9, 
                   2.180850414845017*^11}, {2.3982912*^9, 
                   2.147967296050531*^11}, {2.4299136*^9, 
                   2.4615984711328445`*^11}, {2.4614496*^9, 
                   3.0110685730610004`*^11}, {2.4929856*^9, 
                   3.7633987340165295`*^11}, {2.5245216*^9, 
                   4.5847054570827466`*^11}, {2.556144*^9, 
                   4.143881892309424*^11}, {2.58768*^9, 
                   4.1068947165956665`*^11}, {2.619216*^9, 
                   4.259969852143084*^11}, {2.650752*^9, 
                   4.2190574220929376`*^11}, {2.6823744*^9, 
                   4.353899537941441*^11}, {2.7139104*^9, 
                   6.169717535000852*^11}, {2.7454464*^9, 
                   7.76334491116145*^11}, {2.7769824*^9, 
                   8.590083924665312*^11}, {2.8086048*^9, 
                   8.947177390136152*^11}, {2.8401408*^9, 
                   1.13346545429888*^12}, {2.8716768*^9, 
                   1.1952212090324875`*^12}, {2.9032128*^9, 
                   1.265830956132651*^12}, {2.9348352*^9, 
                   1.0209509577101204`*^12}, {2.9663712*^9, 
                   1.0539769534685912`*^12}, {2.9979072*^9, 
                   1.126076542839802*^12}, {3.0294432*^9, 
                   1.2596573470019568`*^12}, {3.0610656*^9, 
                   1.19235440187141*^12}, {3.0926016*^9, 
                   1.2171187235257039`*^12}, {3.1241376*^9, 
                   1.2007866317323293`*^12}, {3.1556736*^9, 
                   1.0973432886781492`*^12}, {3.187296*^9, 
                   1.1173484826847188`*^12}, {3.218832*^9, 
                   1.2189766944107778`*^12}, {3.250368*^9, 
                   1.507113125025088*^12}, {3.281904*^9, 
                   1.724522852463169*^12}, {3.3135264*^9, 
                   1.7624749651606726`*^12}}]}, {}},
                AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                AxesOrigin->NCache[{2208988800, 0}, {2.2089888*^9, 0}],
                Frame->True,
                FrameTicks->{{Automatic, Automatic}, {{{
                    NCache[2208988800, 2.2089888*^9], 
                    FormBox["\"1970\"", TraditionalForm]}, {
                    NCache[2524521600, 2.5245216*^9], 
                    FormBox["\"1980\"", TraditionalForm]}, {
                    NCache[2840140800, 2.8401408*^9], 
                    FormBox["\"1990\"", TraditionalForm]}, {
                    NCache[3155673600, 3.1556736*^9], 
                    FormBox["\"2000\"", TraditionalForm]}, {
                    NCache[2272060800, 2.2720608*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2335219200, 2.3352192*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2398291200, 2.3982912*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2461449600, 2.4614496*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2587680000, 2.58768*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2650752000, 2.650752*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2713910400, 2.7139104*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2776982400, 2.7769824*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2903212800, 2.9032128*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2966371200, 2.9663712*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3029443200, 3.0294432*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3092601600, 3.0926016*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3218832000, 3.218832*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3281904000, 3.281904*^9], 
                    FormBox["\" \"", TraditionalForm]}}, {{
                    NCache[2208988800, 2.2089888*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2524521600, 2.5245216*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2840140800, 2.8401408*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3155673600, 3.1556736*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2272060800, 2.2720608*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2335219200, 2.3352192*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2398291200, 2.3982912*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2461449600, 2.4614496*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2587680000, 2.58768*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2650752000, 2.650752*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2713910400, 2.7139104*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2776982400, 2.7769824*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2903212800, 2.9032128*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2966371200, 2.9663712*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3029443200, 3.0294432*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3092601600, 3.0926016*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3218832000, 3.218832*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3281904000, 3.281904*^9], 
                    FormBox["\" \"", TraditionalForm]}}}},
                GridLines->NCache[{{{2208988800, 
                    GrayLevel[0.8]}, {2524521600, 
                    GrayLevel[0.8]}, {2840140800, 
                    GrayLevel[0.8]}, {3155673600, 
                    GrayLevel[0.8]}}, None}, {{{2.2089888*^9, 
                    GrayLevel[0.8]}, {2.5245216*^9, 
                    GrayLevel[0.8]}, {2.8401408*^9, 
                    GrayLevel[0.8]}, {3.1556736*^9, 
                    GrayLevel[0.8]}}, None}],
                
                PlotRange->{{2.2089888*^9, 3.3135264*^9}, {0., 
                 1.7624749651606726`*^12}},
                PlotRangeClipping->True,
                PlotRangePadding->{
                  Scaled[0.02], 
                  Scaled[0.02]},
                Ticks->None],
               ImageMargins->0]}
            },
            BaselinePosition->{1, 1},
            ColumnsEqual->False,
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxBackground->{"Columns" -> {{Automatic}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
            RowsEqual->False],
           "Grid"]}, Dynamic[Typeset`var$$],
          Alignment->Automatic,
          BaselinePosition->Baseline,
          DefaultBaseStyle->"OpenerView",
          ImageMargins->0,
          ImageSize->Automatic],
         Deployed->False,
         StripOnInput->False],
        OpenerView[{
          Row[{
            Graphics[
             Raster[CompressedData["
1:eJztmH9Uk1UYx98x2BgD3gmMsbFB/BAyQAlpCO2IUiSnQlOyREWBAk04olCy
VE6hoksFRERRUPLISUtUkgrtl2igaEYQIfJD0UrNJLQUVKbdnmfurR0aCtOx
f3rO+Z67e3ff+37e+977PM993eJTpsSzKYp6XCtz6n9js9mRcnnA8mHDBF9i
1dQ8OiYDhXG5nNsV+3cT4LsF9WdNDQUmpWm6Zu6chIbNhfk36k7WkPbWRgLt
qDdNyGUjEjkWIMeitxbe/eWnVsJob9kHxHu451cmZEMj2WtX9TY1ntQw4bxh
eb6jmbS1NJC42Jhm6CMFRYLEQw3n5ua6PCwstDc4OOhq0rzEq6MD/MtemvRi
dVJSYn1xUcGd9EWpJCjoqSq5PPCyVOq8f6j5wDiwV3OgjLawsHgFShaIB3IQ
ix0XQ9tlc3Nz9RtzX++ZMX1aJ4/HKzIB44OMzeVyr+3auZ14erpfgLrLQ4wl
BBEzM7NeKL1AHo8CUCwSvTbc06MrdvaMdqjGUIaHienIl78+W+MbbG1trkDp
/AgQg3JzVJdaT9eTUSP91Hw+f4GB4wRmLE1vxz14+NABkpw0p416+Dlk+fv5
pJTu2Hqn40wTCR2ruMXhcKKg3cKAsR4DkW+OfKHxE9vfL+qG+viH5BuVkaE8
3dhwnEjE4huwXy5Bm6XO/7xBjDUB+Zqb6jR8xVsK1PCskw3k4goEtklWVlYF
GUuUPZ9UlBEPD7c9uh1cXWW4xy8MYkypi4vsN1wnyJeWOv8a+IQpBrCZCwR0
zYQJ4ddjZkarce6OH6tCX1gN/9Ggl0HJUVGTOhWK4M8HOqilpWUe8HX/fL5F
w/fdt9VEKBTWDoJLwGKxVsA4s2Qy58bao4eIbsxbn7e2i8+3agoJGdMJvvvi
poJ1NyNfiBjwXhE6OGA+RLJWvKMZD3+D/10zCL6FeI2jo1BdkJ/brcuGwucG
JnLgs3ISFjauMzIyIp0axPqDtauEIoHH456j7uUeKN8BXOoOmgd5Ved7quV3
mfnvqyNVB8mG/JwrwcHyjQMct6+xtKUZKJZ6cEx3gGc6yzwLvL//zBmqZGth
T3xczInQUIUK+j+tcx9jmquzs6R6zeosgvtJ35xh2749O8HPW7dAf7shYNIY
TfOfsbGx7oEc+S9984VcJdsK1UsWL2pVrVzWQdva3obL4ocADedgDfiOrh/q
a/WusZbm70lgYMCfQqH9VujrChoBmgjiGpkN1yT6avJx+Ud62U6fqiNeXp6/
cjiafTbUloJsfX0aI4ytiQlxFyCXes4EbJYQR/6AnEHvemMUFzsT44O9Cfjo
qVMnH8UzWX9sVV9XEkXImGUmYMO4F120ZUNvf2wnag+TiIjwLuiqMBaDj8+I
V319fXaD/wzRacY94QS+5MC24k16/UjpjuKbEOMPQr9plPH8Lg05fVvs7JmY
1xNtnLOGWF+C9cx3F+uNC8r0tN8lEkkW9LExEheai4/PE42pC5J7YG/eRn+P
TPBOMTfV5NH62DC3Gf2kf4URuRibMjHy+YvoH5h7Y35aX3es372AKt+7i0gk
TqWU8WMp+niib33dT6uyMpn8xtCzzkCNeLi73Tl39tSA2bCvtTWf4dNde8aY
Sz9Ya29DPntL9x0/SLnZKg0fTdN5UDrB/poFZ5VdRuATjB83thLPCMjH5El7
ykp7wB/fN15gHhwTE62m/s1lUYacG+9nFiEhclVQUGC9SOR4daSfbzfuTbyX
UpmmOYsw56X+hN/StGyhj5iNMfwGi2dSmbWVFb4vAnE+wdvbq0p7X7Isc2m/
fJWf7mP4/I3Ep2s0sDVByafu5Wz2sMYwPpDCjXnkTNuP/3BhLrMyK/NK0rzE
Bvwf8qoPh4APre/3G5adnV0lnLU7ZTLp9XW5q+9u3rSemTP8vuAE4mifyVTG
1jKECwQ28+Hc3wq/E4xxo78BEvI7/Q==
              "], {{0, 0}, {40, 40}}, {0, 255}, ColorFunction -> RGBColor], 
             Background -> None, ImageSize -> {40, 40}, 
             PlotRange -> {{0, 40}, {0, 40}}], "Italy"}], 
          Graphics[{{{}, {
              Hue[0.67, 0.6, 0.6], 
              
              Point[{{2.2089888*^9, 1.1001857267906438`*^11}, {2.2405248*^9, 
               1.208138060400842*^11}, {2.2720608*^9, 
               1.4051891364948038`*^11}, {2.3036832*^9, 
               1.6924997901562256`*^11}, {2.3352192*^9, 
               1.9190272481504858`*^11}, {2.3667552*^9, 
               2.180850414845017*^11}, {2.3982912*^9, 
               2.147967296050531*^11}, {2.4299136*^9, 
               2.4615984711328445`*^11}, {2.4614496*^9, 
               3.0110685730610004`*^11}, {2.4929856*^9, 
               3.7633987340165295`*^11}, {2.5245216*^9, 
               4.5847054570827466`*^11}, {2.556144*^9, 
               4.143881892309424*^11}, {2.58768*^9, 
               4.1068947165956665`*^11}, {2.619216*^9, 
               4.259969852143084*^11}, {2.650752*^9, 
               4.2190574220929376`*^11}, {2.6823744*^9, 
               4.353899537941441*^11}, {2.7139104*^9, 
               6.169717535000852*^11}, {2.7454464*^9, 7.76334491116145*^11}, {
               2.7769824*^9, 8.590083924665312*^11}, {2.8086048*^9, 
               8.947177390136152*^11}, {2.8401408*^9, 1.13346545429888*^12}, {
               2.8716768*^9, 1.1952212090324875`*^12}, {2.9032128*^9, 
               1.265830956132651*^12}, {2.9348352*^9, 
               1.0209509577101204`*^12}, {2.9663712*^9, 
               1.0539769534685912`*^12}, {2.9979072*^9, 
               1.126076542839802*^12}, {3.0294432*^9, 
               1.2596573470019568`*^12}, {3.0610656*^9, 
               1.19235440187141*^12}, {3.0926016*^9, 
               1.2171187235257039`*^12}, {3.1241376*^9, 
               1.2007866317323293`*^12}, {3.1556736*^9, 
               1.0973432886781492`*^12}, {3.187296*^9, 
               1.1173484826847188`*^12}, {3.218832*^9, 
               1.2189766944107778`*^12}, {3.250368*^9, 
               1.507113125025088*^12}, {3.281904*^9, 1.724522852463169*^12}, {
               3.3135264*^9, 1.7624749651606726`*^12}}]}, {}}}, {
           AspectRatio -> GoldenRatio^(-1), AxesOrigin -> {2208988800, 0}, 
            Frame -> True, 
            FrameTicks -> {{
              Automatic, 
               Automatic}, {{{2208988800, "1970"}, {2524521600, "1980"}, {
                2840140800, "1990"}, {3155673600, "2000"}, {
                2272060800, " "}, {2335219200, " "}, {2398291200, " "}, {
                2461449600, " "}, {2587680000, " "}, {2650752000, " "}, {
                2713910400, " "}, {2776982400, " "}, {2903212800, " "}, {
                2966371200, " "}, {3029443200, " "}, {3092601600, " "}, {
                3218832000, " "}, {3281904000, " "}}, {{2208988800, " "}, {
                2524521600, " "}, {2840140800, " "}, {3155673600, " "}, {
                2272060800, " "}, {2335219200, " "}, {2398291200, " "}, {
                2461449600, " "}, {2587680000, " "}, {2650752000, " "}, {
                2713910400, " "}, {2776982400, " "}, {2903212800, " "}, {
                2966371200, " "}, {3029443200, " "}, {3092601600, " "}, {
                3218832000, " "}, {3281904000, " "}}}}, 
            GridLines -> {{{2208988800, 
                GrayLevel[0.8]}, {2524521600, 
                GrayLevel[0.8]}, {2840140800, 
                GrayLevel[0.8]}, {3155673600, 
                GrayLevel[0.8]}}, None}, 
            PlotRange -> {{2.2089888*^9, 3.3135264*^9}, {0., 
             1.7624749651606726`*^12}}, PlotRangeClipping -> True, 
            PlotRangePadding -> {
              Scaled[0.02], 
              Scaled[0.02]}, Ticks -> None}]}, False]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ]},
    {
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = True}, 
       InterpretationBox[
        StyleBox[
         PaneSelectorBox[{False->
          TagBox[GridBox[{
             {
              OpenerBox[Dynamic[Typeset`var$$],
               Appearance->Automatic,
               AutoAction->False,
               ContinuousAction->False,
               Enabled->Automatic], 
              InterpretationBox[
               RowBox[{
                GraphicsBox[RasterBox[CompressedData["
1:eJzVmGtsDFEUx+/O7PspW9XqKm0QlXrUJ0HrGYKE2CJEbFO7Sry1ql6JR8W7
XtUi2giaiPhEJB7RtKWpiqxGqdIqpQgfRDw+aHV3r3NmZ9bsqMSX7q1/cnLu
zszm/ubcO+eeexPd69LdPCEkSTQ1+e9kA7vEcdx78FGsYRTSgHWCUZnFMyUK
lw7idg08HTxoYMdST+YPaBeyhlJo7qiUkV9aXz6lZ0tP/jSZTAdZA8k0QKvV
loCnOdlr/NV3b0tjPFmr1dwR23Gs4GBsK0UGuiFnLX3V0iCfh5IhXzRYbwaI
AkNiwgDfm9ZndPWq5WFs58+d8ev1+m/YttksXvBRZrOxQrzvjgDfMKKIl9ls
fgi+DdvA2zFr1sxAVcUNmpo6NvSdl50vCYjtmAgwoqww1gGe55Vj61P8foT+
UV2t/NpHMBUJ5k49mKE7AIGvFvuLirJ3Xr1ymeZuWBtwLV7oJ3/OR3qq+Bg9
ffJ4V3NVnkO7I4/iUujBPg7s3+1/19ZM0V40P6b79uyiK1dk0dqaCvr2TRN9
3lgnsNhsNnq36hb1Pqj+g9NkMlzoBkZUktRHhmtRZ97G7O9FJ474du3cRhMS
+gtjjnz4TUnvILxHUz0tOVOkjPnobmJM5jmuHvwtsEnR0dH5RqOhSeyzxWq1
+pFHzidZnbeGxsb08Z0oLGgXn49kbuLABmG/f+OTbFNezldYj6ZEkE2uTI8n
4/3Rw/vpyxcNXfIVHi/4Ds9NYMRH7HZ7MxHn2fp1q3zK+Qj5XZqDfVjwxcbG
lIv9r1CpVEJOb2l+EsaYkjLiA1wfzoIPpNZoNC4SzEsqg053MWvpkva2189D
fPPmzsGczmLt7lJ2e6/DO7Zv/YaMFeXXKcQV800Say6Zkp3O2Q3Ih2NNfufB
qYy5QoqPd2wpLSkWxhfXFhLky2fNJdOE7PVr2nAdxDimpY2TGHuKTEOHJrU0
NjxUxrAnCGssgefpE6/AhzVFv7i4etZgMg00Go0d0vq3LMvdDuv1UdZQojAX
ZoLRLZtzOzzuDAqsrSR4DtBThPV0KLfwPOdlzKPUSCJw8UI9ZrFY9rEGUgj3
IvLc3Fe8jnFdyApKksPRF88gBDbY/98Gz4N3Qr0j1bdDWPJBzRDa90s2Y/q0
z3cqb+I5wCfgdLLkA2lh7lVB7RwoOLSX3r9XGapncN8yYnjyZxl7LwZ8KrVa
/Rj7h1h+LbtQGlYTYr0NcZT2+GjpEebDHKgl4ndSXHQkjA/rGlzz+jnihL2e
Xq93RZhPromp48Z8kurqmupyarVa5HvQNIZsKMf41LGvsJZZkun6iUw6nW43
eAPE7SrHcTdIMO+wUu/585yNebnZ0lmOXnGfJRv2nS87d4plyNKV8Px9AQmy
Jf7rn34BC2Nb9A==
                  "], {{0, 0}, {40, 40}}, {0, 255},
                  ColorFunction->RGBColor],
                 Background->None,
                 ImageSize->{40, 40},
                 PlotRange->{{0, 40}, {0, 40}}], 
                "\[InvisibleSpace]", "\<\"Japan\"\>"}],
               Row[{
                 Graphics[
                  Raster[CompressedData["
1:eJzVmGtsDFEUx+/O7PspW9XqKm0QlXrUJ0HrGYKE2CJEbFO7Sry1ql6JR8W7
XtUi2giaiPhEJB7RtKWpiqxGqdIqpQgfRDw+aHV3r3NmZ9bsqMSX7q1/cnLu
zszm/ubcO+eeexPd69LdPCEkSTQ1+e9kA7vEcdx78FGsYRTSgHWCUZnFMyUK
lw7idg08HTxoYMdST+YPaBeyhlJo7qiUkV9aXz6lZ0tP/jSZTAdZA8k0QKvV
loCnOdlr/NV3b0tjPFmr1dwR23Gs4GBsK0UGuiFnLX3V0iCfh5IhXzRYbwaI
AkNiwgDfm9ZndPWq5WFs58+d8ev1+m/YttksXvBRZrOxQrzvjgDfMKKIl9ls
fgi+DdvA2zFr1sxAVcUNmpo6NvSdl50vCYjtmAgwoqww1gGe55Vj61P8foT+
UV2t/NpHMBUJ5k49mKE7AIGvFvuLirJ3Xr1ymeZuWBtwLV7oJ3/OR3qq+Bg9
ffJ4V3NVnkO7I4/iUujBPg7s3+1/19ZM0V40P6b79uyiK1dk0dqaCvr2TRN9
3lgnsNhsNnq36hb1Pqj+g9NkMlzoBkZUktRHhmtRZ97G7O9FJ474du3cRhMS
+gtjjnz4TUnvILxHUz0tOVOkjPnobmJM5jmuHvwtsEnR0dH5RqOhSeyzxWq1
+pFHzidZnbeGxsb08Z0oLGgXn49kbuLABmG/f+OTbFNezldYj6ZEkE2uTI8n
4/3Rw/vpyxcNXfIVHi/4Ds9NYMRH7HZ7MxHn2fp1q3zK+Qj5XZqDfVjwxcbG
lIv9r1CpVEJOb2l+EsaYkjLiA1wfzoIPpNZoNC4SzEsqg053MWvpkva2189D
fPPmzsGczmLt7lJ2e6/DO7Zv/YaMFeXXKcQV800Say6Zkp3O2Q3Ih2NNfufB
qYy5QoqPd2wpLSkWxhfXFhLky2fNJdOE7PVr2nAdxDimpY2TGHuKTEOHJrU0
NjxUxrAnCGssgefpE6/AhzVFv7i4etZgMg00Go0d0vq3LMvdDuv1UdZQojAX
ZoLRLZtzOzzuDAqsrSR4DtBThPV0KLfwPOdlzKPUSCJw8UI9ZrFY9rEGUgj3
IvLc3Fe8jnFdyApKksPRF88gBDbY/98Gz4N3Qr0j1bdDWPJBzRDa90s2Y/q0
z3cqb+I5wCfgdLLkA2lh7lVB7RwoOLSX3r9XGapncN8yYnjyZxl7LwZ8KrVa
/Rj7h1h+LbtQGlYTYr0NcZT2+GjpEebDHKgl4ndSXHQkjA/rGlzz+jnihL2e
Xq93RZhPromp48Z8kurqmupyarVa5HvQNIZsKMf41LGvsJZZkun6iUw6nW43
eAPE7SrHcTdIMO+wUu/585yNebnZ0lmOXnGfJRv2nS87d4plyNKV8Px9AQmy
Jf7rn34BC2Nb9A==
                   "], {{0, 0}, {40, 40}}, {0, 255}, ColorFunction -> 
                   RGBColor], Background -> None, ImageSize -> {40, 40}, 
                  PlotRange -> {{0, 40}, {0, 40}}], "Japan"}]]}
            },
            BaselinePosition->{1, 1},
            ColumnsEqual->False,
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxBackground->{"Columns" -> {{Automatic}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
            RowsEqual->False],
           "Grid"], True->
          TagBox[GridBox[{
             {
              OpenerBox[Dynamic[Typeset`var$$],
               Appearance->Automatic,
               AutoAction->False,
               ContinuousAction->False,
               Enabled->Automatic], 
              InterpretationBox[
               RowBox[{
                GraphicsBox[RasterBox[CompressedData["
1:eJzVmGtsDFEUx+/O7PspW9XqKm0QlXrUJ0HrGYKE2CJEbFO7Sry1ql6JR8W7
XtUi2giaiPhEJB7RtKWpiqxGqdIqpQgfRDw+aHV3r3NmZ9bsqMSX7q1/cnLu
zszm/ubcO+eeexPd69LdPCEkSTQ1+e9kA7vEcdx78FGsYRTSgHWCUZnFMyUK
lw7idg08HTxoYMdST+YPaBeyhlJo7qiUkV9aXz6lZ0tP/jSZTAdZA8k0QKvV
loCnOdlr/NV3b0tjPFmr1dwR23Gs4GBsK0UGuiFnLX3V0iCfh5IhXzRYbwaI
AkNiwgDfm9ZndPWq5WFs58+d8ev1+m/YttksXvBRZrOxQrzvjgDfMKKIl9ls
fgi+DdvA2zFr1sxAVcUNmpo6NvSdl50vCYjtmAgwoqww1gGe55Vj61P8foT+
UV2t/NpHMBUJ5k49mKE7AIGvFvuLirJ3Xr1ymeZuWBtwLV7oJ3/OR3qq+Bg9
ffJ4V3NVnkO7I4/iUujBPg7s3+1/19ZM0V40P6b79uyiK1dk0dqaCvr2TRN9
3lgnsNhsNnq36hb1Pqj+g9NkMlzoBkZUktRHhmtRZ97G7O9FJ474du3cRhMS
+gtjjnz4TUnvILxHUz0tOVOkjPnobmJM5jmuHvwtsEnR0dH5RqOhSeyzxWq1
+pFHzidZnbeGxsb08Z0oLGgXn49kbuLABmG/f+OTbFNezldYj6ZEkE2uTI8n
4/3Rw/vpyxcNXfIVHi/4Ds9NYMRH7HZ7MxHn2fp1q3zK+Qj5XZqDfVjwxcbG
lIv9r1CpVEJOb2l+EsaYkjLiA1wfzoIPpNZoNC4SzEsqg053MWvpkva2189D
fPPmzsGczmLt7lJ2e6/DO7Zv/YaMFeXXKcQV800Say6Zkp3O2Q3Ih2NNfufB
qYy5QoqPd2wpLSkWxhfXFhLky2fNJdOE7PVr2nAdxDimpY2TGHuKTEOHJrU0
NjxUxrAnCGssgefpE6/AhzVFv7i4etZgMg00Go0d0vq3LMvdDuv1UdZQojAX
ZoLRLZtzOzzuDAqsrSR4DtBThPV0KLfwPOdlzKPUSCJw8UI9ZrFY9rEGUgj3
IvLc3Fe8jnFdyApKksPRF88gBDbY/98Gz4N3Qr0j1bdDWPJBzRDa90s2Y/q0
z3cqb+I5wCfgdLLkA2lh7lVB7RwoOLSX3r9XGapncN8yYnjyZxl7LwZ8KrVa
/Rj7h1h+LbtQGlYTYr0NcZT2+GjpEebDHKgl4ndSXHQkjA/rGlzz+jnihL2e
Xq93RZhPromp48Z8kurqmupyarVa5HvQNIZsKMf41LGvsJZZkun6iUw6nW43
eAPE7SrHcTdIMO+wUu/585yNebnZ0lmOXnGfJRv2nS87d4plyNKV8Px9AQmy
Jf7rn34BC2Nb9A==
                  "], {{0, 0}, {40, 40}}, {0, 255},
                  ColorFunction->RGBColor],
                 Background->None,
                 ImageSize->{40, 40},
                 PlotRange->{{0, 40}, {0, 40}}], 
                "\[InvisibleSpace]", "\<\"Japan\"\>"}],
               Row[{
                 Graphics[
                  Raster[CompressedData["
1:eJzVmGtsDFEUx+/O7PspW9XqKm0QlXrUJ0HrGYKE2CJEbFO7Sry1ql6JR8W7
XtUi2giaiPhEJB7RtKWpiqxGqdIqpQgfRDw+aHV3r3NmZ9bsqMSX7q1/cnLu
zszm/ubcO+eeexPd69LdPCEkSTQ1+e9kA7vEcdx78FGsYRTSgHWCUZnFMyUK
lw7idg08HTxoYMdST+YPaBeyhlJo7qiUkV9aXz6lZ0tP/jSZTAdZA8k0QKvV
loCnOdlr/NV3b0tjPFmr1dwR23Gs4GBsK0UGuiFnLX3V0iCfh5IhXzRYbwaI
AkNiwgDfm9ZndPWq5WFs58+d8ev1+m/YttksXvBRZrOxQrzvjgDfMKKIl9ls
fgi+DdvA2zFr1sxAVcUNmpo6NvSdl50vCYjtmAgwoqww1gGe55Vj61P8foT+
UV2t/NpHMBUJ5k49mKE7AIGvFvuLirJ3Xr1ymeZuWBtwLV7oJ3/OR3qq+Bg9
ffJ4V3NVnkO7I4/iUujBPg7s3+1/19ZM0V40P6b79uyiK1dk0dqaCvr2TRN9
3lgnsNhsNnq36hb1Pqj+g9NkMlzoBkZUktRHhmtRZ97G7O9FJ474du3cRhMS
+gtjjnz4TUnvILxHUz0tOVOkjPnobmJM5jmuHvwtsEnR0dH5RqOhSeyzxWq1
+pFHzidZnbeGxsb08Z0oLGgXn49kbuLABmG/f+OTbFNezldYj6ZEkE2uTI8n
4/3Rw/vpyxcNXfIVHi/4Ds9NYMRH7HZ7MxHn2fp1q3zK+Qj5XZqDfVjwxcbG
lIv9r1CpVEJOb2l+EsaYkjLiA1wfzoIPpNZoNC4SzEsqg053MWvpkva2189D
fPPmzsGczmLt7lJ2e6/DO7Zv/YaMFeXXKcQV800Say6Zkp3O2Q3Ih2NNfufB
qYy5QoqPd2wpLSkWxhfXFhLky2fNJdOE7PVr2nAdxDimpY2TGHuKTEOHJrU0
NjxUxrAnCGssgefpE6/AhzVFv7i4etZgMg00Go0d0vq3LMvdDuv1UdZQojAX
ZoLRLZtzOzzuDAqsrSR4DtBThPV0KLfwPOdlzKPUSCJw8UI9ZrFY9rEGUgj3
IvLc3Fe8jnFdyApKksPRF88gBDbY/98Gz4N3Qr0j1bdDWPJBzRDa90s2Y/q0
z3cqb+I5wCfgdLLkA2lh7lVB7RwoOLSX3r9XGapncN8yYnjyZxl7LwZ8KrVa
/Rj7h1h+LbtQGlYTYr0NcZT2+GjpEebDHKgl4ndSXHQkjA/rGlzz+jnihL2e
Xq93RZhPromp48Z8kurqmupyarVa5HvQNIZsKMf41LGvsJZZkun6iUw6nW43
eAPE7SrHcTdIMO+wUu/585yNebnZ0lmOXnGfJRv2nS87d4plyNKV8Px9AQmy
Jf7rn34BC2Nb9A==
                   "], {{0, 0}, {40, 40}}, {0, 255}, ColorFunction -> 
                   RGBColor], Background -> None, ImageSize -> {40, 40}, 
                  PlotRange -> {{0, 40}, {0, 40}}], "Japan"}]]},
             {"", 
              PaneBox[
               GraphicsBox[{{}, 
                 {Hue[0.67, 0.6, 0.6], 
                  PointBox[{{2.2089888*^9, 2.014529580514261*^11}, {
                   2.2405248*^9, 2.2755033969951434`*^11}, {2.2720608*^9, 
                   3.01343259543402*^11}, {2.3036832*^9, 
                   4.094100716072971*^11}, {2.3352192*^9, 
                   4.544586112238592*^11}, {2.3667552*^9, 
                   4.941750673051077*^11}, {2.3982912*^9, 
                   5.554042215464973*^11}, {2.4299136*^9, 
                   6.835571874274996*^11}, {2.4614496*^9, 
                   9.604251124685349*^11}, {2.4929856*^9, 
                   9.996525293671614*^11}, {2.5245216*^9, 
                   1.0473829652743596`*^12}, {2.556144*^9, 
                   1.1575808025550977`*^12}, {2.58768*^9, 
                   1.0757971376079556`*^12}, {2.619216*^9, 
                   1.173473359359394*^12}, {2.650752*^9, 
                   1.2486767468971565`*^12}, {2.6823744*^9, 
                   1.3367483967990293`*^12}, {2.7139104*^9, 
                   1.980635436908171*^12}, {2.7454464*^9, 
                   2.4020878317749478`*^12}, {2.7769824*^9, 
                   2.91659077365674*^12}, {2.8086048*^9, 
                   2.9183378659623613`*^12}, {2.8401408*^9, 
                   2.9957356166212617`*^12}, {2.8716768*^9, 
                   3.4256890248509097`*^12}, {2.9032128*^9, 
                   3.738954620999907*^12}, {2.9348352*^9, 
                   4.291732742888624*^12}, {2.9663712*^9, 
                   4.724875099850551*^12}, {2.9979072*^9, 
                   5.206658298158463*^12}, {3.0294432*^9, 
                   4.620456505153843*^12}, {3.0610656*^9, 
                   4.233781703969587*^12}, {3.0926016*^9, 
                   3.842264579344679*^12}, {3.1241376*^9, 
                   4.3476498177611074`*^12}, {3.1556736*^9, 
                   4.649615208479153*^12}, {3.187296*^9, 
                   4.0877240379293174`*^12}, {3.218832*^9, 
                   3.904826021289916*^12}, {3.250368*^9, 
                   4.231250256567769*^12}, {3.281904*^9, 
                   4.584885115685265*^12}, {3.3135264*^9, 
                   4.558949854127995*^12}}]}, {}},
                AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                AxesOrigin->NCache[{2208988800, 0}, {2.2089888*^9, 0}],
                Frame->True,
                FrameTicks->{{Automatic, Automatic}, {{{
                    NCache[2208988800, 2.2089888*^9], 
                    FormBox["\"1970\"", TraditionalForm]}, {
                    NCache[2524521600, 2.5245216*^9], 
                    FormBox["\"1980\"", TraditionalForm]}, {
                    NCache[2840140800, 2.8401408*^9], 
                    FormBox["\"1990\"", TraditionalForm]}, {
                    NCache[3155673600, 3.1556736*^9], 
                    FormBox["\"2000\"", TraditionalForm]}, {
                    NCache[2272060800, 2.2720608*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2335219200, 2.3352192*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2398291200, 2.3982912*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2461449600, 2.4614496*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2587680000, 2.58768*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2650752000, 2.650752*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2713910400, 2.7139104*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2776982400, 2.7769824*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2903212800, 2.9032128*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2966371200, 2.9663712*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3029443200, 3.0294432*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3092601600, 3.0926016*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3218832000, 3.218832*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3281904000, 3.281904*^9], 
                    FormBox["\" \"", TraditionalForm]}}, {{
                    NCache[2208988800, 2.2089888*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2524521600, 2.5245216*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2840140800, 2.8401408*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3155673600, 3.1556736*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2272060800, 2.2720608*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2335219200, 2.3352192*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2398291200, 2.3982912*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2461449600, 2.4614496*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2587680000, 2.58768*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2650752000, 2.650752*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2713910400, 2.7139104*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2776982400, 2.7769824*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2903212800, 2.9032128*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2966371200, 2.9663712*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3029443200, 3.0294432*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3092601600, 3.0926016*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3218832000, 3.218832*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3281904000, 3.281904*^9], 
                    FormBox["\" \"", TraditionalForm]}}}},
                GridLines->NCache[{{{2208988800, 
                    GrayLevel[0.8]}, {2524521600, 
                    GrayLevel[0.8]}, {2840140800, 
                    GrayLevel[0.8]}, {3155673600, 
                    GrayLevel[0.8]}}, None}, {{{2.2089888*^9, 
                    GrayLevel[0.8]}, {2.5245216*^9, 
                    GrayLevel[0.8]}, {2.8401408*^9, 
                    GrayLevel[0.8]}, {3.1556736*^9, 
                    GrayLevel[0.8]}}, None}],
                
                PlotRange->{{2.2089888*^9, 3.3135264*^9}, {0., 
                 5.206658298158463*^12}},
                PlotRangeClipping->True,
                PlotRangePadding->{
                  Scaled[0.02], 
                  Scaled[0.02]},
                Ticks->None],
               ImageMargins->0]}
            },
            BaselinePosition->{1, 1},
            ColumnsEqual->False,
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxBackground->{"Columns" -> {{Automatic}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
            RowsEqual->False],
           "Grid"]}, Dynamic[Typeset`var$$],
          Alignment->Automatic,
          BaselinePosition->Baseline,
          DefaultBaseStyle->"OpenerView",
          ImageMargins->0,
          ImageSize->Automatic],
         Deployed->False,
         StripOnInput->False],
        OpenerView[{
          Row[{
            Graphics[
             Raster[CompressedData["
1:eJzVmGtsDFEUx+/O7PspW9XqKm0QlXrUJ0HrGYKE2CJEbFO7Sry1ql6JR8W7
XtUi2giaiPhEJB7RtKWpiqxGqdIqpQgfRDw+aHV3r3NmZ9bsqMSX7q1/cnLu
zszm/ubcO+eeexPd69LdPCEkSTQ1+e9kA7vEcdx78FGsYRTSgHWCUZnFMyUK
lw7idg08HTxoYMdST+YPaBeyhlJo7qiUkV9aXz6lZ0tP/jSZTAdZA8k0QKvV
loCnOdlr/NV3b0tjPFmr1dwR23Gs4GBsK0UGuiFnLX3V0iCfh5IhXzRYbwaI
AkNiwgDfm9ZndPWq5WFs58+d8ev1+m/YttksXvBRZrOxQrzvjgDfMKKIl9ls
fgi+DdvA2zFr1sxAVcUNmpo6NvSdl50vCYjtmAgwoqww1gGe55Vj61P8foT+
UV2t/NpHMBUJ5k49mKE7AIGvFvuLirJ3Xr1ymeZuWBtwLV7oJ3/OR3qq+Bg9
ffJ4V3NVnkO7I4/iUujBPg7s3+1/19ZM0V40P6b79uyiK1dk0dqaCvr2TRN9
3lgnsNhsNnq36hb1Pqj+g9NkMlzoBkZUktRHhmtRZ97G7O9FJ474du3cRhMS
+gtjjnz4TUnvILxHUz0tOVOkjPnobmJM5jmuHvwtsEnR0dH5RqOhSeyzxWq1
+pFHzidZnbeGxsb08Z0oLGgXn49kbuLABmG/f+OTbFNezldYj6ZEkE2uTI8n
4/3Rw/vpyxcNXfIVHi/4Ds9NYMRH7HZ7MxHn2fp1q3zK+Qj5XZqDfVjwxcbG
lIv9r1CpVEJOb2l+EsaYkjLiA1wfzoIPpNZoNC4SzEsqg053MWvpkva2189D
fPPmzsGczmLt7lJ2e6/DO7Zv/YaMFeXXKcQV800Say6Zkp3O2Q3Ih2NNfufB
qYy5QoqPd2wpLSkWxhfXFhLky2fNJdOE7PVr2nAdxDimpY2TGHuKTEOHJrU0
NjxUxrAnCGssgefpE6/AhzVFv7i4etZgMg00Go0d0vq3LMvdDuv1UdZQojAX
ZoLRLZtzOzzuDAqsrSR4DtBThPV0KLfwPOdlzKPUSCJw8UI9ZrFY9rEGUgj3
IvLc3Fe8jnFdyApKksPRF88gBDbY/98Gz4N3Qr0j1bdDWPJBzRDa90s2Y/q0
z3cqb+I5wCfgdLLkA2lh7lVB7RwoOLSX3r9XGapncN8yYnjyZxl7LwZ8KrVa
/Rj7h1h+LbtQGlYTYr0NcZT2+GjpEebDHKgl4ndSXHQkjA/rGlzz+jnihL2e
Xq93RZhPromp48Z8kurqmupyarVa5HvQNIZsKMf41LGvsJZZkun6iUw6nW43
eAPE7SrHcTdIMO+wUu/585yNebnZ0lmOXnGfJRv2nS87d4plyNKV8Px9AQmy
Jf7rn34BC2Nb9A==
              "], {{0, 0}, {40, 40}}, {0, 255}, ColorFunction -> RGBColor], 
             Background -> None, ImageSize -> {40, 40}, 
             PlotRange -> {{0, 40}, {0, 40}}], "Japan"}], 
          Graphics[{{{}, {
              Hue[0.67, 0.6, 0.6], 
              
              Point[{{2.2089888*^9, 2.014529580514261*^11}, {2.2405248*^9, 
               2.2755033969951434`*^11}, {2.2720608*^9, 
               3.01343259543402*^11}, {2.3036832*^9, 4.094100716072971*^11}, {
               2.3352192*^9, 4.544586112238592*^11}, {2.3667552*^9, 
               4.941750673051077*^11}, {2.3982912*^9, 
               5.554042215464973*^11}, {2.4299136*^9, 
               6.835571874274996*^11}, {2.4614496*^9, 
               9.604251124685349*^11}, {2.4929856*^9, 
               9.996525293671614*^11}, {2.5245216*^9, 
               1.0473829652743596`*^12}, {2.556144*^9, 
               1.1575808025550977`*^12}, {2.58768*^9, 
               1.0757971376079556`*^12}, {2.619216*^9, 
               1.173473359359394*^12}, {2.650752*^9, 
               1.2486767468971565`*^12}, {2.6823744*^9, 
               1.3367483967990293`*^12}, {2.7139104*^9, 
               1.980635436908171*^12}, {2.7454464*^9, 
               2.4020878317749478`*^12}, {2.7769824*^9, 
               2.91659077365674*^12}, {2.8086048*^9, 
               2.9183378659623613`*^12}, {2.8401408*^9, 
               2.9957356166212617`*^12}, {2.8716768*^9, 
               3.4256890248509097`*^12}, {2.9032128*^9, 
               3.738954620999907*^12}, {2.9348352*^9, 
               4.291732742888624*^12}, {2.9663712*^9, 
               4.724875099850551*^12}, {2.9979072*^9, 
               5.206658298158463*^12}, {3.0294432*^9, 
               4.620456505153843*^12}, {3.0610656*^9, 
               4.233781703969587*^12}, {3.0926016*^9, 
               3.842264579344679*^12}, {3.1241376*^9, 
               4.3476498177611074`*^12}, {3.1556736*^9, 
               4.649615208479153*^12}, {3.187296*^9, 
               4.0877240379293174`*^12}, {3.218832*^9, 
               3.904826021289916*^12}, {3.250368*^9, 4.231250256567769*^12}, {
               3.281904*^9, 4.584885115685265*^12}, {3.3135264*^9, 
               4.558949854127995*^12}}]}, {}}}, {
           AspectRatio -> GoldenRatio^(-1), AxesOrigin -> {2208988800, 0}, 
            Frame -> True, 
            FrameTicks -> {{
              Automatic, 
               Automatic}, {{{2208988800, "1970"}, {2524521600, "1980"}, {
                2840140800, "1990"}, {3155673600, "2000"}, {
                2272060800, " "}, {2335219200, " "}, {2398291200, " "}, {
                2461449600, " "}, {2587680000, " "}, {2650752000, " "}, {
                2713910400, " "}, {2776982400, " "}, {2903212800, " "}, {
                2966371200, " "}, {3029443200, " "}, {3092601600, " "}, {
                3218832000, " "}, {3281904000, " "}}, {{2208988800, " "}, {
                2524521600, " "}, {2840140800, " "}, {3155673600, " "}, {
                2272060800, " "}, {2335219200, " "}, {2398291200, " "}, {
                2461449600, " "}, {2587680000, " "}, {2650752000, " "}, {
                2713910400, " "}, {2776982400, " "}, {2903212800, " "}, {
                2966371200, " "}, {3029443200, " "}, {3092601600, " "}, {
                3218832000, " "}, {3281904000, " "}}}}, 
            GridLines -> {{{2208988800, 
                GrayLevel[0.8]}, {2524521600, 
                GrayLevel[0.8]}, {2840140800, 
                GrayLevel[0.8]}, {3155673600, 
                GrayLevel[0.8]}}, None}, 
            PlotRange -> {{2.2089888*^9, 3.3135264*^9}, {0., 
             5.206658298158463*^12}}, PlotRangeClipping -> True, 
            PlotRangePadding -> {
              Scaled[0.02], 
              Scaled[0.02]}, Ticks -> None}]}, False]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ]},
    {
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = False}, 
       InterpretationBox[
        StyleBox[
         PaneSelectorBox[{False->
          TagBox[GridBox[{
             {
              OpenerBox[Dynamic[Typeset`var$$],
               Appearance->Automatic,
               AutoAction->False,
               ContinuousAction->False,
               Enabled->Automatic], 
              InterpretationBox[
               RowBox[{
                GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJmYGDQgGIWhlEwCkbBKBgFo2BIAkYgNgNiNSibFoAJiDmgbBAt
A2WzQmkjBtxVKchN/6F4Mw3cZo5kPjLuwCI2C4g9gZgZST87mho2ajmMkZFx
D8hMTU31v/fuXPmfEB/zf+OGVf/Z2Fj/gcQ3rFvxf8b0Sf9v37r0//rVc//D
w4J/Q92QBDUiHosfhHFYJ8rMzHSWAREnBJ0nLCj4eMe2Df+fPLqFgh89uPH/
8cObGOIgN0LdMBPot1MwvwkI8P/z9HCDuZ0Pi12g8L4Glc/EIg9KU7C0C6Kd
Yf4FhRu6O/Dh9LSkXzC9p04chIufPX0E5nYnLPbzMGCGMyy9RyGJCQKxA4yP
LeyIwaD4Rg7fC+eOA92dDLMDW/zNA8nduXX5f39fJ0wdPxDfBbG9vTww0v/5
s8fIchsyvnLpNLq5T7G4DQT++/h4gvVcvXwGRU9Odjo4PR3cvwMsR6mbkDEo
bUDtuQfEU3G4jQHZPcuXzgeH/+FDu8FpgpruQcegOEayGz1e1YHYAIkvDFN7
49o5mroL2X1I6Q5efgPz9mIkd8OAJIhfVlqItWzAhU8c20/NMNQCum0WEv8i
kvtA5fZ/KSnJf8SUGQ/uXftvZWUBN9vIyIAkfyFjUPpGTmMtzXUwdiiS++D1
ICgvEGNuR3sTRr5+eP86WWFYW1OOrY5kx5ZXlJWV/uKyB1RWRYSHYDMLjGfP
mgJWd/H8CTBfU0P9v5+v9/8Z0yaC+f29HVjNDQ7yRzcLV1tmIkgeVG+Cwh2k
V0xM9B8O94Dqmkvo4lqaGmB34vJDe2sjhvv27t5KrPtA+WcqLrOh2ANNizSU
BrWzbmBRDyo7QOWFCLL4uTNH/y+YPxPuxu1b1//fv3cbTF4cl/uQgBELC8sy
LPYR0wYqZYDU0+jhAPLDdGTzrl05C3djbGwkTJyXCDtgQB/NfdQCEjAzz5w6
TEzewAdA4YCtbUEJgJcZ/X0db6FsEE1M3NINANM7qN1pB8RcA+2WUTAKRsEo
GAXEAwCwGZ4C
                  "], {{0, 0}, {40, 40}}, {0, 255},
                  ColorFunction->RGBColor],
                 Background->None,
                 ImageSize->{40, 40},
                 PlotRange->{{0, 40}, {0, 40}}], 
                "\[InvisibleSpace]", "\<\"Russia\"\>"}],
               Row[{
                 Graphics[
                  Raster[CompressedData["
1:eJxTTMoPSmJmYGDQgGIWhlEwCkbBKBgFo2BIAkYgNgNiNSibFoAJiDmgbBAt
A2WzQmkjBtxVKchN/6F4Mw3cZo5kPjLuwCI2C4g9gZgZST87mho2ajmMkZFx
D8hMTU31v/fuXPmfEB/zf+OGVf/Z2Fj/gcQ3rFvxf8b0Sf9v37r0//rVc//D
w4J/Q92QBDUiHosfhHFYJ8rMzHSWAREnBJ0nLCj4eMe2Df+fPLqFgh89uPH/
8cObGOIgN0LdMBPot1MwvwkI8P/z9HCDuZ0Pi12g8L4Glc/EIg9KU7C0C6Kd
Yf4FhRu6O/Dh9LSkXzC9p04chIufPX0E5nYnLPbzMGCGMyy9RyGJCQKxA4yP
LeyIwaD4Rg7fC+eOA92dDLMDW/zNA8nduXX5f39fJ0wdPxDfBbG9vTww0v/5
s8fIchsyvnLpNLq5T7G4DQT++/h4gvVcvXwGRU9Odjo4PR3cvwMsR6mbkDEo
bUDtuQfEU3G4jQHZPcuXzgeH/+FDu8FpgpruQcegOEayGz1e1YHYAIkvDFN7
49o5mroL2X1I6Q5efgPz9mIkd8OAJIhfVlqItWzAhU8c20/NMNQCum0WEv8i
kvtA5fZ/KSnJf8SUGQ/uXftvZWUBN9vIyIAkfyFjUPpGTmMtzXUwdiiS++D1
ICgvEGNuR3sTRr5+eP86WWFYW1OOrY5kx5ZXlJWV/uKyB1RWRYSHYDMLjGfP
mgJWd/H8CTBfU0P9v5+v9/8Z0yaC+f29HVjNDQ7yRzcLV1tmIkgeVG+Cwh2k
V0xM9B8O94Dqmkvo4lqaGmB34vJDe2sjhvv27t5KrPtA+WcqLrOh2ANNizSU
BrWzbmBRDyo7QOWFCLL4uTNH/y+YPxPuxu1b1//fv3cbTF4cl/uQgBELC8sy
LPYR0wYqZYDU0+jhAPLDdGTzrl05C3djbGwkTJyXCDtgQB/NfdQCEjAzz5w6
TEzewAdA4YCtbUEJgJcZ/X0db6FsEE1M3NINANM7qN1pB8RcA+2WUTAKRsEo
GAXEAwCwGZ4C
                   "], {{0, 0}, {40, 40}}, {0, 255}, ColorFunction -> 
                   RGBColor], Background -> None, ImageSize -> {40, 40}, 
                  PlotRange -> {{0, 40}, {0, 40}}], "Russia"}]]}
            },
            BaselinePosition->{1, 1},
            ColumnsEqual->False,
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxBackground->{"Columns" -> {{Automatic}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
            RowsEqual->False],
           "Grid"], True->
          TagBox[GridBox[{
             {
              OpenerBox[Dynamic[Typeset`var$$],
               Appearance->Automatic,
               AutoAction->False,
               ContinuousAction->False,
               Enabled->Automatic], 
              InterpretationBox[
               RowBox[{
                GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJmYGDQgGIWhlEwCkbBKBgFo2BIAkYgNgNiNSibFoAJiDmgbBAt
A2WzQmkjBtxVKchN/6F4Mw3cZo5kPjLuwCI2C4g9gZgZST87mho2ajmMkZFx
D8hMTU31v/fuXPmfEB/zf+OGVf/Z2Fj/gcQ3rFvxf8b0Sf9v37r0//rVc//D
w4J/Q92QBDUiHosfhHFYJ8rMzHSWAREnBJ0nLCj4eMe2Df+fPLqFgh89uPH/
8cObGOIgN0LdMBPot1MwvwkI8P/z9HCDuZ0Pi12g8L4Glc/EIg9KU7C0C6Kd
Yf4FhRu6O/Dh9LSkXzC9p04chIufPX0E5nYnLPbzMGCGMyy9RyGJCQKxA4yP
LeyIwaD4Rg7fC+eOA92dDLMDW/zNA8nduXX5f39fJ0wdPxDfBbG9vTww0v/5
s8fIchsyvnLpNLq5T7G4DQT++/h4gvVcvXwGRU9Odjo4PR3cvwMsR6mbkDEo
bUDtuQfEU3G4jQHZPcuXzgeH/+FDu8FpgpruQcegOEayGz1e1YHYAIkvDFN7
49o5mroL2X1I6Q5efgPz9mIkd8OAJIhfVlqItWzAhU8c20/NMNQCum0WEv8i
kvtA5fZ/KSnJf8SUGQ/uXftvZWUBN9vIyIAkfyFjUPpGTmMtzXUwdiiS++D1
ICgvEGNuR3sTRr5+eP86WWFYW1OOrY5kx5ZXlJWV/uKyB1RWRYSHYDMLjGfP
mgJWd/H8CTBfU0P9v5+v9/8Z0yaC+f29HVjNDQ7yRzcLV1tmIkgeVG+Cwh2k
V0xM9B8O94Dqmkvo4lqaGmB34vJDe2sjhvv27t5KrPtA+WcqLrOh2ANNizSU
BrWzbmBRDyo7QOWFCLL4uTNH/y+YPxPuxu1b1//fv3cbTF4cl/uQgBELC8sy
LPYR0wYqZYDU0+jhAPLDdGTzrl05C3djbGwkTJyXCDtgQB/NfdQCEjAzz5w6
TEzewAdA4YCtbUEJgJcZ/X0db6FsEE1M3NINANM7qN1pB8RcA+2WUTAKRsEo
GAXEAwCwGZ4C
                  "], {{0, 0}, {40, 40}}, {0, 255},
                  ColorFunction->RGBColor],
                 Background->None,
                 ImageSize->{40, 40},
                 PlotRange->{{0, 40}, {0, 40}}], 
                "\[InvisibleSpace]", "\<\"Russia\"\>"}],
               Row[{
                 Graphics[
                  Raster[CompressedData["
1:eJxTTMoPSmJmYGDQgGIWhlEwCkbBKBgFo2BIAkYgNgNiNSibFoAJiDmgbBAt
A2WzQmkjBtxVKchN/6F4Mw3cZo5kPjLuwCI2C4g9gZgZST87mho2ajmMkZFx
D8hMTU31v/fuXPmfEB/zf+OGVf/Z2Fj/gcQ3rFvxf8b0Sf9v37r0//rVc//D
w4J/Q92QBDUiHosfhHFYJ8rMzHSWAREnBJ0nLCj4eMe2Df+fPLqFgh89uPH/
8cObGOIgN0LdMBPot1MwvwkI8P/z9HCDuZ0Pi12g8L4Glc/EIg9KU7C0C6Kd
Yf4FhRu6O/Dh9LSkXzC9p04chIufPX0E5nYnLPbzMGCGMyy9RyGJCQKxA4yP
LeyIwaD4Rg7fC+eOA92dDLMDW/zNA8nduXX5f39fJ0wdPxDfBbG9vTww0v/5
s8fIchsyvnLpNLq5T7G4DQT++/h4gvVcvXwGRU9Odjo4PR3cvwMsR6mbkDEo
bUDtuQfEU3G4jQHZPcuXzgeH/+FDu8FpgpruQcegOEayGz1e1YHYAIkvDFN7
49o5mroL2X1I6Q5efgPz9mIkd8OAJIhfVlqItWzAhU8c20/NMNQCum0WEv8i
kvtA5fZ/KSnJf8SUGQ/uXftvZWUBN9vIyIAkfyFjUPpGTmMtzXUwdiiS++D1
ICgvEGNuR3sTRr5+eP86WWFYW1OOrY5kx5ZXlJWV/uKyB1RWRYSHYDMLjGfP
mgJWd/H8CTBfU0P9v5+v9/8Z0yaC+f29HVjNDQ7yRzcLV1tmIkgeVG+Cwh2k
V0xM9B8O94Dqmkvo4lqaGmB34vJDe2sjhvv27t5KrPtA+WcqLrOh2ANNizSU
BrWzbmBRDyo7QOWFCLL4uTNH/y+YPxPuxu1b1//fv3cbTF4cl/uQgBELC8sy
LPYR0wYqZYDU0+jhAPLDdGTzrl05C3djbGwkTJyXCDtgQB/NfdQCEjAzz5w6
TEzewAdA4YCtbUEJgJcZ/X0db6FsEE1M3NINANM7qN1pB8RcA+2WUTAKRsEo
GAXEAwCwGZ4C
                   "], {{0, 0}, {40, 40}}, {0, 255}, ColorFunction -> 
                   RGBColor], Background -> None, ImageSize -> {40, 40}, 
                  PlotRange -> {{0, 40}, {0, 40}}], "Russia"}]]},
             {"", 
              PaneBox[
               GraphicsBox[{{}, 
                 {Hue[0.67, 0.6, 0.6], 
                  PointBox[{{2.8401408*^9, 5.697118807301721*^11}, {
                   2.8716768*^9, 5.60148358206564*^11}, {2.9032128*^9, 
                   4.899543440560434*^11}, {2.9348352*^9, 
                   4.576050839536752*^11}, {2.9663712*^9, 
                   4.0791335145689514`*^11}, {2.9979072*^9, 
                   3.991662245416091*^11}, {3.0294432*^9, 
                   3.9208952318958527`*^11}, {3.0610656*^9, 
                   4.049406205883203*^11}, {3.0926016*^9, 
                   2.709531602854175*^11}, {3.1241376*^9, 
                   1.95907924077677*^11}, {3.1556736*^9, 
                   2.597178361724186*^11}, {3.187296*^9, 
                   3.066175749373683*^11}, {3.218832*^9, 
                   3.4548832824979877`*^11}, {3.250368*^9, 
                   4.3148797448197046`*^11}, {3.281904*^9, 
                   5.902873738774519*^11}, {3.3135264*^9, 
                   7.659680383768098*^11}}]}, {}},
                AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                
                AxesOrigin->
                 NCache[{2208988800, 2.*^11}, {2.2089888*^9, 2.*^11}],
                Frame->True,
                FrameTicks->{{Automatic, Automatic}, {{{
                    NCache[2208988800, 2.2089888*^9], 
                    FormBox["\"1970\"", TraditionalForm]}, {
                    NCache[2524521600, 2.5245216*^9], 
                    FormBox["\"1980\"", TraditionalForm]}, {
                    NCache[2840140800, 2.8401408*^9], 
                    FormBox["\"1990\"", TraditionalForm]}, {
                    NCache[3155673600, 3.1556736*^9], 
                    FormBox["\"2000\"", TraditionalForm]}, {
                    NCache[2272060800, 2.2720608*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2335219200, 2.3352192*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2398291200, 2.3982912*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2461449600, 2.4614496*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2587680000, 2.58768*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2650752000, 2.650752*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2713910400, 2.7139104*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2776982400, 2.7769824*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2903212800, 2.9032128*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2966371200, 2.9663712*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3029443200, 3.0294432*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3092601600, 3.0926016*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3218832000, 3.218832*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3281904000, 3.281904*^9], 
                    FormBox["\" \"", TraditionalForm]}}, {{
                    NCache[2208988800, 2.2089888*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2524521600, 2.5245216*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2840140800, 2.8401408*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3155673600, 3.1556736*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2272060800, 2.2720608*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2335219200, 2.3352192*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2398291200, 2.3982912*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2461449600, 2.4614496*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2587680000, 2.58768*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2650752000, 2.650752*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2713910400, 2.7139104*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2776982400, 2.7769824*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2903212800, 2.9032128*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2966371200, 2.9663712*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3029443200, 3.0294432*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3092601600, 3.0926016*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3218832000, 3.218832*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3281904000, 3.281904*^9], 
                    FormBox["\" \"", TraditionalForm]}}}},
                GridLines->NCache[{{{2208988800, 
                    GrayLevel[0.8]}, {2524521600, 
                    GrayLevel[0.8]}, {2840140800, 
                    GrayLevel[0.8]}, {3155673600, 
                    GrayLevel[0.8]}}, None}, {{{2.2089888*^9, 
                    GrayLevel[0.8]}, {2.5245216*^9, 
                    GrayLevel[0.8]}, {2.8401408*^9, 
                    GrayLevel[0.8]}, {3.1556736*^9, 
                    GrayLevel[0.8]}}, None}],
                
                PlotRange->
                 NCache[{{2208988800, 3.3135264*^9}, {1.95907924077677*^11, 
                   7.659680383768098*^11}}, {{2.2089888*^9, 3.3135264*^9}, {
                  1.95907924077677*^11, 7.659680383768098*^11}}],
                PlotRangeClipping->True,
                PlotRangePadding->{
                  Scaled[0.02], 
                  Scaled[0.02]},
                Ticks->None],
               ImageMargins->0]}
            },
            BaselinePosition->{1, 1},
            ColumnsEqual->False,
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxBackground->{"Columns" -> {{Automatic}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
            RowsEqual->False],
           "Grid"]}, Dynamic[Typeset`var$$],
          Alignment->Automatic,
          BaselinePosition->Baseline,
          DefaultBaseStyle->"OpenerView",
          ImageMargins->0,
          ImageSize->Automatic],
         Deployed->False,
         StripOnInput->False],
        OpenerView[{
          Row[{
            Graphics[
             Raster[CompressedData["
1:eJxTTMoPSmJmYGDQgGIWhlEwCkbBKBgFo2BIAkYgNgNiNSibFoAJiDmgbBAt
A2WzQmkjBtxVKchN/6F4Mw3cZo5kPjLuwCI2C4g9gZgZST87mho2ajmMkZFx
D8hMTU31v/fuXPmfEB/zf+OGVf/Z2Fj/gcQ3rFvxf8b0Sf9v37r0//rVc//D
w4J/Q92QBDUiHosfhHFYJ8rMzHSWAREnBJ0nLCj4eMe2Df+fPLqFgh89uPH/
8cObGOIgN0LdMBPot1MwvwkI8P/z9HCDuZ0Pi12g8L4Glc/EIg9KU7C0C6Kd
Yf4FhRu6O/Dh9LSkXzC9p04chIufPX0E5nYnLPbzMGCGMyy9RyGJCQKxA4yP
LeyIwaD4Rg7fC+eOA92dDLMDW/zNA8nduXX5f39fJ0wdPxDfBbG9vTww0v/5
s8fIchsyvnLpNLq5T7G4DQT++/h4gvVcvXwGRU9Odjo4PR3cvwMsR6mbkDEo
bUDtuQfEU3G4jQHZPcuXzgeH/+FDu8FpgpruQcegOEayGz1e1YHYAIkvDFN7
49o5mroL2X1I6Q5efgPz9mIkd8OAJIhfVlqItWzAhU8c20/NMNQCum0WEv8i
kvtA5fZ/KSnJf8SUGQ/uXftvZWUBN9vIyIAkfyFjUPpGTmMtzXUwdiiS++D1
ICgvEGNuR3sTRr5+eP86WWFYW1OOrY5kx5ZXlJWV/uKyB1RWRYSHYDMLjGfP
mgJWd/H8CTBfU0P9v5+v9/8Z0yaC+f29HVjNDQ7yRzcLV1tmIkgeVG+Cwh2k
V0xM9B8O94Dqmkvo4lqaGmB34vJDe2sjhvv27t5KrPtA+WcqLrOh2ANNizSU
BrWzbmBRDyo7QOWFCLL4uTNH/y+YPxPuxu1b1//fv3cbTF4cl/uQgBELC8sy
LPYR0wYqZYDU0+jhAPLDdGTzrl05C3djbGwkTJyXCDtgQB/NfdQCEjAzz5w6
TEzewAdA4YCtbUEJgJcZ/X0db6FsEE1M3NINANM7qN1pB8RcA+2WUTAKRsEo
GAXEAwCwGZ4C
              "], {{0, 0}, {40, 40}}, {0, 255}, ColorFunction -> RGBColor], 
             Background -> None, ImageSize -> {40, 40}, 
             PlotRange -> {{0, 40}, {0, 40}}], "Russia"}], 
          Graphics[{{{}, {
              Hue[0.67, 0.6, 0.6], 
              
              Point[{{2.8401408*^9, 5.697118807301721*^11}, {2.8716768*^9, 
               5.60148358206564*^11}, {2.9032128*^9, 4.899543440560434*^11}, {
               2.9348352*^9, 4.576050839536752*^11}, {2.9663712*^9, 
               4.0791335145689514`*^11}, {2.9979072*^9, 
               3.991662245416091*^11}, {3.0294432*^9, 
               3.9208952318958527`*^11}, {3.0610656*^9, 
               4.049406205883203*^11}, {3.0926016*^9, 
               2.709531602854175*^11}, {3.1241376*^9, 1.95907924077677*^11}, {
               3.1556736*^9, 2.597178361724186*^11}, {3.187296*^9, 
               3.066175749373683*^11}, {3.218832*^9, 
               3.4548832824979877`*^11}, {3.250368*^9, 
               4.3148797448197046`*^11}, {3.281904*^9, 
               5.902873738774519*^11}, {3.3135264*^9, 
               7.659680383768098*^11}}]}, {}}}, {
           AspectRatio -> GoldenRatio^(-1), 
            AxesOrigin -> {2208988800, 2.*^11}, Frame -> True, 
            FrameTicks -> {{
              Automatic, 
               Automatic}, {{{2208988800, "1970"}, {2524521600, "1980"}, {
                2840140800, "1990"}, {3155673600, "2000"}, {
                2272060800, " "}, {2335219200, " "}, {2398291200, " "}, {
                2461449600, " "}, {2587680000, " "}, {2650752000, " "}, {
                2713910400, " "}, {2776982400, " "}, {2903212800, " "}, {
                2966371200, " "}, {3029443200, " "}, {3092601600, " "}, {
                3218832000, " "}, {3281904000, " "}}, {{2208988800, " "}, {
                2524521600, " "}, {2840140800, " "}, {3155673600, " "}, {
                2272060800, " "}, {2335219200, " "}, {2398291200, " "}, {
                2461449600, " "}, {2587680000, " "}, {2650752000, " "}, {
                2713910400, " "}, {2776982400, " "}, {2903212800, " "}, {
                2966371200, " "}, {3029443200, " "}, {3092601600, " "}, {
                3218832000, " "}, {3281904000, " "}}}}, 
            GridLines -> {{{2208988800, 
                GrayLevel[0.8]}, {2524521600, 
                GrayLevel[0.8]}, {2840140800, 
                GrayLevel[0.8]}, {3155673600, 
                GrayLevel[0.8]}}, None}, 
            PlotRange -> {{2208988800, 3.3135264*^9}, {1.95907924077677*^11, 
              7.659680383768098*^11}}, PlotRangeClipping -> True, 
            PlotRangePadding -> {
              Scaled[0.02], 
              Scaled[0.02]}, Ticks -> None}]}, False]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ]},
    {
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = False}, 
       InterpretationBox[
        StyleBox[
         PaneSelectorBox[{False->
          TagBox[GridBox[{
             {
              OpenerBox[Dynamic[Typeset`var$$],
               Appearance->Automatic,
               AutoAction->False,
               ContinuousAction->False,
               Enabled->Automatic], 
              InterpretationBox[
               RowBox[{
                GraphicsBox[RasterBox[CompressedData["
1:eJzdmHtQVFUYwA/7ELblIRCguwspqQmLoag5PRzGrEinx+Q/9UdOiKnVNFA8
MtDEaggTRHuYGIFOQUKshmCm02QBRoQpSog8fFt/2Eh/OBqQu/v1fXc529ld
RJvx3tv0zXxzz+Fc7vnt9zjnO2diWsaiNC1jbOqw6tj/Q4KCglJ1Ol0DNgE1
WBj6r/xE8NIcof248J6f8miS3IY6n/lyco1E+1Zotdrjer1+KfYfMxqNa/E5
R2HOR4mnqrICfj3fC309x2DF8qWXUlIe7snOSu+/7945ThrHeLjG2U2m8baw
sLC0qKiojdjXKMBYSvNWflYuMZ4+2QlnT3dJbdKuzsMwPXGaMzn5AXt52UcO
W20lvLepCF595eWhyIiIiwaDoYe5/CGXGFF3EmNOdsZFqzXucsvBA4Ocj9uV
nufPdoP491N9nTB7VtIAc9lWKxMf5UAIaoGfn9/J4bnInh6M3mqrrXIyz5i1
3mowzIFMcY78NXl/XjjXA/PmJf9F/cbv9l2X76uGnQ56B3PoBD4n3Wo2lCT6
/pTJkyApafqVrMx0Z8fRVrcP9+7ZBT/+cMDHp6JGWywSI9q9UQY+TUBAQDt9
v6S48LoMN9Lqz7dz+98hAyPF3p30/fz8vN9Hs9VouiR1cT9+4yEZ+LgYMRYv
f1K2Gc6dOfGv+XZUbXOEh4cvloHLH7leQrVhG+p3f3FTPLgOwqq816729XZI
/ZIN64bGjg1eLQMf02g0tH9JMbRvb90N2dpaGz32wpkzZ1yIjZ1Yg22DHHwo
U/hcmCf2ovUFzkVPPTFwqK0JaK0ZiZHGYmIszfg/d6OamLx1xO2M+dYI2yu2
jshGPk1MnDYUHW3OYPLtGaMJ2QPeXfe2j/0wf8Q9Y74KbCRUo8IGXBPF9YZY
f25rhoULHnFMmBBTrCYb6cIFKSPuHWaziWotir0AFfimYj471+avcnpzkf0K
C97kvr1LQaZI1Bmoz6CuRv9dPXPquAcb7cXsn7gzK8gWx24id03jx9l1Wm05
jukVZCNZSTy5r2fD/q/rYM0buVJ+Yg3v4DX0sfZWCAkJvjL8W5SUcaizIiLC
VyLfoLiWiO3dX9bQ+eM3pmw+kJ+otnT7tLf7qE+uEmfqc886AgMD1zNlzkJu
8ff3X4FnR4kxISF+QLQZr2Fqqj/l/LFKsqFkMK+cKC56B/bU2xy8n5ebY8ez
2WBoaOjTCrORSP7FutzN1/ZTE1jj49x8TB27cZHm1+lc8dfZccgdb03f7xf5
otWAQ7v9QfPjXiFxUJyJeVG65X2wmE10rl2iBh/KW0zwI9XN3rUK+Xt43KIC
XwjabpDmb6iv9bjPEHMYa4RL+M6DCrPRfZ/bdltLP5Bs573nktI9C+4lJUrC
Yex1iHwvvvA8tB9ukdq4Jjqam76BLZs3QdnHH0LLwW9h7tz7f8GxyQoiBjHX
3iHdYdTtqpbsR7ai/pgx+n6RH8/wR5g695SpnCErMx26u45wpmXMVacaVOIS
RbqfLC4qvEa1MtUCzMU4W2UuLoGokGCNdy5flmanNWVH1TbOeI/KbFyeZCPf
QafIMdnf1M1Cqg==
                  "], {{0, 0}, {40, 40}}, {0, 255},
                  ColorFunction->RGBColor],
                 Background->None,
                 ImageSize->{40, 40},
                 PlotRange->{{0, 40}, {0, 40}}], 
                "\[InvisibleSpace]", "\<\"UnitedKingdom\"\>"}],
               Row[{
                 Graphics[
                  Raster[CompressedData["
1:eJzdmHtQVFUYwA/7ELblIRCguwspqQmLoag5PRzGrEinx+Q/9UdOiKnVNFA8
MtDEaggTRHuYGIFOQUKshmCm02QBRoQpSog8fFt/2Eh/OBqQu/v1fXc529ld
RJvx3tv0zXxzz+Fc7vnt9zjnO2diWsaiNC1jbOqw6tj/Q4KCglJ1Ol0DNgE1
WBj6r/xE8NIcof248J6f8miS3IY6n/lyco1E+1Zotdrjer1+KfYfMxqNa/E5
R2HOR4mnqrICfj3fC309x2DF8qWXUlIe7snOSu+/7945ThrHeLjG2U2m8baw
sLC0qKiojdjXKMBYSvNWflYuMZ4+2QlnT3dJbdKuzsMwPXGaMzn5AXt52UcO
W20lvLepCF595eWhyIiIiwaDoYe5/CGXGFF3EmNOdsZFqzXucsvBA4Ocj9uV
nufPdoP491N9nTB7VtIAc9lWKxMf5UAIaoGfn9/J4bnInh6M3mqrrXIyz5i1
3mowzIFMcY78NXl/XjjXA/PmJf9F/cbv9l2X76uGnQ56B3PoBD4n3Wo2lCT6
/pTJkyApafqVrMx0Z8fRVrcP9+7ZBT/+cMDHp6JGWywSI9q9UQY+TUBAQDt9
v6S48LoMN9Lqz7dz+98hAyPF3p30/fz8vN9Hs9VouiR1cT9+4yEZ+LgYMRYv
f1K2Gc6dOfGv+XZUbXOEh4cvloHLH7leQrVhG+p3f3FTPLgOwqq816729XZI
/ZIN64bGjg1eLQMf02g0tH9JMbRvb90N2dpaGz32wpkzZ1yIjZ1Yg22DHHwo
U/hcmCf2ovUFzkVPPTFwqK0JaK0ZiZHGYmIszfg/d6OamLx1xO2M+dYI2yu2
jshGPk1MnDYUHW3OYPLtGaMJ2QPeXfe2j/0wf8Q9Y74KbCRUo8IGXBPF9YZY
f25rhoULHnFMmBBTrCYb6cIFKSPuHWaziWotir0AFfimYj471+avcnpzkf0K
C97kvr1LQaZI1Bmoz6CuRv9dPXPquAcb7cXsn7gzK8gWx24id03jx9l1Wm05
jukVZCNZSTy5r2fD/q/rYM0buVJ+Yg3v4DX0sfZWCAkJvjL8W5SUcaizIiLC
VyLfoLiWiO3dX9bQ+eM3pmw+kJ+otnT7tLf7qE+uEmfqc886AgMD1zNlzkJu
8ff3X4FnR4kxISF+QLQZr2Fqqj/l/LFKsqFkMK+cKC56B/bU2xy8n5ebY8ez
2WBoaOjTCrORSP7FutzN1/ZTE1jj49x8TB27cZHm1+lc8dfZccgdb03f7xf5
otWAQ7v9QfPjXiFxUJyJeVG65X2wmE10rl2iBh/KW0zwI9XN3rUK+Xt43KIC
XwjabpDmb6iv9bjPEHMYa4RL+M6DCrPRfZ/bdltLP5Bs573nktI9C+4lJUrC
Yex1iHwvvvA8tB9ukdq4Jjqam76BLZs3QdnHH0LLwW9h7tz7f8GxyQoiBjHX
3iHdYdTtqpbsR7ai/pgx+n6RH8/wR5g695SpnCErMx26u45wpmXMVacaVOIS
RbqfLC4qvEa1MtUCzMU4W2UuLoGokGCNdy5flmanNWVH1TbOeI/KbFyeZCPf
QafIMdnf1M1Cqg==
                   "], {{0, 0}, {40, 40}}, {0, 255}, ColorFunction -> 
                   RGBColor], Background -> None, ImageSize -> {40, 40}, 
                  PlotRange -> {{0, 40}, {0, 40}}], "UnitedKingdom"}]]}
            },
            BaselinePosition->{1, 1},
            ColumnsEqual->False,
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxBackground->{"Columns" -> {{Automatic}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
            RowsEqual->False],
           "Grid"], True->
          TagBox[GridBox[{
             {
              OpenerBox[Dynamic[Typeset`var$$],
               Appearance->Automatic,
               AutoAction->False,
               ContinuousAction->False,
               Enabled->Automatic], 
              InterpretationBox[
               RowBox[{
                GraphicsBox[RasterBox[CompressedData["
1:eJzdmHtQVFUYwA/7ELblIRCguwspqQmLoag5PRzGrEinx+Q/9UdOiKnVNFA8
MtDEaggTRHuYGIFOQUKshmCm02QBRoQpSog8fFt/2Eh/OBqQu/v1fXc529ld
RJvx3tv0zXxzz+Fc7vnt9zjnO2diWsaiNC1jbOqw6tj/Q4KCglJ1Ol0DNgE1
WBj6r/xE8NIcof248J6f8miS3IY6n/lyco1E+1Zotdrjer1+KfYfMxqNa/E5
R2HOR4mnqrICfj3fC309x2DF8qWXUlIe7snOSu+/7945ThrHeLjG2U2m8baw
sLC0qKiojdjXKMBYSvNWflYuMZ4+2QlnT3dJbdKuzsMwPXGaMzn5AXt52UcO
W20lvLepCF595eWhyIiIiwaDoYe5/CGXGFF3EmNOdsZFqzXucsvBA4Ocj9uV
nufPdoP491N9nTB7VtIAc9lWKxMf5UAIaoGfn9/J4bnInh6M3mqrrXIyz5i1
3mowzIFMcY78NXl/XjjXA/PmJf9F/cbv9l2X76uGnQ56B3PoBD4n3Wo2lCT6
/pTJkyApafqVrMx0Z8fRVrcP9+7ZBT/+cMDHp6JGWywSI9q9UQY+TUBAQDt9
v6S48LoMN9Lqz7dz+98hAyPF3p30/fz8vN9Hs9VouiR1cT9+4yEZ+LgYMRYv
f1K2Gc6dOfGv+XZUbXOEh4cvloHLH7leQrVhG+p3f3FTPLgOwqq816729XZI
/ZIN64bGjg1eLQMf02g0tH9JMbRvb90N2dpaGz32wpkzZ1yIjZ1Yg22DHHwo
U/hcmCf2ovUFzkVPPTFwqK0JaK0ZiZHGYmIszfg/d6OamLx1xO2M+dYI2yu2
jshGPk1MnDYUHW3OYPLtGaMJ2QPeXfe2j/0wf8Q9Y74KbCRUo8IGXBPF9YZY
f25rhoULHnFMmBBTrCYb6cIFKSPuHWaziWotir0AFfimYj471+avcnpzkf0K
C97kvr1LQaZI1Bmoz6CuRv9dPXPquAcb7cXsn7gzK8gWx24id03jx9l1Wm05
jukVZCNZSTy5r2fD/q/rYM0buVJ+Yg3v4DX0sfZWCAkJvjL8W5SUcaizIiLC
VyLfoLiWiO3dX9bQ+eM3pmw+kJ+otnT7tLf7qE+uEmfqc886AgMD1zNlzkJu
8ff3X4FnR4kxISF+QLQZr2Fqqj/l/LFKsqFkMK+cKC56B/bU2xy8n5ebY8ez
2WBoaOjTCrORSP7FutzN1/ZTE1jj49x8TB27cZHm1+lc8dfZccgdb03f7xf5
otWAQ7v9QfPjXiFxUJyJeVG65X2wmE10rl2iBh/KW0zwI9XN3rUK+Xt43KIC
XwjabpDmb6iv9bjPEHMYa4RL+M6DCrPRfZ/bdltLP5Bs573nktI9C+4lJUrC
Yex1iHwvvvA8tB9ukdq4Jjqam76BLZs3QdnHH0LLwW9h7tz7f8GxyQoiBjHX
3iHdYdTtqpbsR7ai/pgx+n6RH8/wR5g695SpnCErMx26u45wpmXMVacaVOIS
RbqfLC4qvEa1MtUCzMU4W2UuLoGokGCNdy5flmanNWVH1TbOeI/KbFyeZCPf
QafIMdnf1M1Cqg==
                  "], {{0, 0}, {40, 40}}, {0, 255},
                  ColorFunction->RGBColor],
                 Background->None,
                 ImageSize->{40, 40},
                 PlotRange->{{0, 40}, {0, 40}}], 
                "\[InvisibleSpace]", "\<\"UnitedKingdom\"\>"}],
               Row[{
                 Graphics[
                  Raster[CompressedData["
1:eJzdmHtQVFUYwA/7ELblIRCguwspqQmLoag5PRzGrEinx+Q/9UdOiKnVNFA8
MtDEaggTRHuYGIFOQUKshmCm02QBRoQpSog8fFt/2Eh/OBqQu/v1fXc529ld
RJvx3tv0zXxzz+Fc7vnt9zjnO2diWsaiNC1jbOqw6tj/Q4KCglJ1Ol0DNgE1
WBj6r/xE8NIcof248J6f8miS3IY6n/lyco1E+1Zotdrjer1+KfYfMxqNa/E5
R2HOR4mnqrICfj3fC309x2DF8qWXUlIe7snOSu+/7945ThrHeLjG2U2m8baw
sLC0qKiojdjXKMBYSvNWflYuMZ4+2QlnT3dJbdKuzsMwPXGaMzn5AXt52UcO
W20lvLepCF595eWhyIiIiwaDoYe5/CGXGFF3EmNOdsZFqzXucsvBA4Ocj9uV
nufPdoP491N9nTB7VtIAc9lWKxMf5UAIaoGfn9/J4bnInh6M3mqrrXIyz5i1
3mowzIFMcY78NXl/XjjXA/PmJf9F/cbv9l2X76uGnQ56B3PoBD4n3Wo2lCT6
/pTJkyApafqVrMx0Z8fRVrcP9+7ZBT/+cMDHp6JGWywSI9q9UQY+TUBAQDt9
v6S48LoMN9Lqz7dz+98hAyPF3p30/fz8vN9Hs9VouiR1cT9+4yEZ+LgYMRYv
f1K2Gc6dOfGv+XZUbXOEh4cvloHLH7leQrVhG+p3f3FTPLgOwqq816729XZI
/ZIN64bGjg1eLQMf02g0tH9JMbRvb90N2dpaGz32wpkzZ1yIjZ1Yg22DHHwo
U/hcmCf2ovUFzkVPPTFwqK0JaK0ZiZHGYmIszfg/d6OamLx1xO2M+dYI2yu2
jshGPk1MnDYUHW3OYPLtGaMJ2QPeXfe2j/0wf8Q9Y74KbCRUo8IGXBPF9YZY
f25rhoULHnFMmBBTrCYb6cIFKSPuHWaziWotir0AFfimYj471+avcnpzkf0K
C97kvr1LQaZI1Bmoz6CuRv9dPXPquAcb7cXsn7gzK8gWx24id03jx9l1Wm05
jukVZCNZSTy5r2fD/q/rYM0buVJ+Yg3v4DX0sfZWCAkJvjL8W5SUcaizIiLC
VyLfoLiWiO3dX9bQ+eM3pmw+kJ+otnT7tLf7qE+uEmfqc886AgMD1zNlzkJu
8ff3X4FnR4kxISF+QLQZr2Fqqj/l/LFKsqFkMK+cKC56B/bU2xy8n5ebY8ez
2WBoaOjTCrORSP7FutzN1/ZTE1jj49x8TB27cZHm1+lc8dfZccgdb03f7xf5
otWAQ7v9QfPjXiFxUJyJeVG65X2wmE10rl2iBh/KW0zwI9XN3rUK+Xt43KIC
XwjabpDmb6iv9bjPEHMYa4RL+M6DCrPRfZ/bdltLP5Bs573nktI9C+4lJUrC
Yex1iHwvvvA8tB9ukdq4Jjqam76BLZs3QdnHH0LLwW9h7tz7f8GxyQoiBjHX
3iHdYdTtqpbsR7ai/pgx+n6RH8/wR5g695SpnCErMx26u45wpmXMVacaVOIS
RbqfLC4qvEa1MtUCzMU4W2UuLoGokGCNdy5flmanNWVH1TbOeI/KbFyeZCPf
QafIMdnf1M1Cqg==
                   "], {{0, 0}, {40, 40}}, {0, 255}, ColorFunction -> 
                   RGBColor], Background -> None, ImageSize -> {40, 40}, 
                  PlotRange -> {{0, 40}, {0, 40}}], "UnitedKingdom"}]]},
             {"", 
              PaneBox[
               GraphicsBox[{{}, 
                 {Hue[0.67, 0.6, 0.6], 
                  PointBox[{{2.2089888*^9, 1.2363590126436914`*^11}, {
                   2.2405248*^9, 1.3980572083619217`*^11}, {2.2720608*^9, 
                   1.6063569485203543`*^11}, {2.3036832*^9, 
                   1.8124513969447748`*^11}, {2.3352192*^9, 
                   1.957702847195009*^11}, {2.3667552*^9, 
                   2.3398975145108023`*^11}, {2.3982912*^9, 
                   2.2479207505729996`*^11}, {2.4299136*^9, 
                   2.5385680838041418`*^11}, {2.4614496*^9, 
                   3.21772819807636*^11}, {2.4929856*^9, 
                   4.179666923422399*^11}, {2.5245216*^9, 
                   5.361321896283531*^11}, {2.556144*^9, 
                   5.083982851941528*^11}, {2.58768*^9, 
                   4.840449529095338*^11}, {2.619216*^9, 
                   4.5894000027881354`*^11}, {2.650752*^9, 
                   4.3150455371477625`*^11}, {2.6823744*^9, 
                   4.5550699023655786`*^11}, {2.7139104*^9, 
                   5.58954105166052*^11}, {2.7454464*^9, 
                   6.857539263293876*^11}, {2.7769824*^9, 
                   8.331747712214061*^11}, {2.8086048*^9, 
                   8.412809635246335*^11}, {2.8401408*^9, 
                   9.89564266780465*^11}, {2.8716768*^9, 
                   1.0334817518162361`*^12}, {2.9032128*^9, 
                   1.0715859646146346`*^12}, {2.9348352*^9, 
                   9.624067386994218*^11}, {2.9663712*^9, 
                   1.0413426629112925`*^12}, {2.9979072*^9, 
                   1.1336896670768289`*^12}, {3.0294432*^9, 
                   1.1912803900154153`*^12}, {3.0610656*^9, 
                   1.3270351591864573`*^12}, {3.0926016*^9, 
                   1.4251182105389539`*^12}, {3.1241376*^9, 
                   1.4649752807122458`*^12}, {3.1556736*^9, 
                   1.4427772951531748`*^12}, {3.187296*^9, 
                   1.4348964593935117`*^12}, {3.218832*^9, 
                   1.571371904459777*^12}, {3.250368*^9, 
                   1.805663111405002*^12}, {3.281904*^9, 
                   2.1321560657658647`*^12}, {3.3135264*^9, 
                   2.1987957539265283`*^12}}]}, {}},
                AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                AxesOrigin->NCache[{2208988800, 0}, {2.2089888*^9, 0}],
                Frame->True,
                FrameTicks->{{Automatic, Automatic}, {{{
                    NCache[2208988800, 2.2089888*^9], 
                    FormBox["\"1970\"", TraditionalForm]}, {
                    NCache[2524521600, 2.5245216*^9], 
                    FormBox["\"1980\"", TraditionalForm]}, {
                    NCache[2840140800, 2.8401408*^9], 
                    FormBox["\"1990\"", TraditionalForm]}, {
                    NCache[3155673600, 3.1556736*^9], 
                    FormBox["\"2000\"", TraditionalForm]}, {
                    NCache[2272060800, 2.2720608*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2335219200, 2.3352192*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2398291200, 2.3982912*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2461449600, 2.4614496*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2587680000, 2.58768*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2650752000, 2.650752*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2713910400, 2.7139104*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2776982400, 2.7769824*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2903212800, 2.9032128*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2966371200, 2.9663712*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3029443200, 3.0294432*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3092601600, 3.0926016*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3218832000, 3.218832*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3281904000, 3.281904*^9], 
                    FormBox["\" \"", TraditionalForm]}}, {{
                    NCache[2208988800, 2.2089888*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2524521600, 2.5245216*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2840140800, 2.8401408*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3155673600, 3.1556736*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2272060800, 2.2720608*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2335219200, 2.3352192*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2398291200, 2.3982912*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2461449600, 2.4614496*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2587680000, 2.58768*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2650752000, 2.650752*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2713910400, 2.7139104*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2776982400, 2.7769824*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2903212800, 2.9032128*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2966371200, 2.9663712*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3029443200, 3.0294432*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3092601600, 3.0926016*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3218832000, 3.218832*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3281904000, 3.281904*^9], 
                    FormBox["\" \"", TraditionalForm]}}}},
                GridLines->NCache[{{{2208988800, 
                    GrayLevel[0.8]}, {2524521600, 
                    GrayLevel[0.8]}, {2840140800, 
                    GrayLevel[0.8]}, {3155673600, 
                    GrayLevel[0.8]}}, None}, {{{2.2089888*^9, 
                    GrayLevel[0.8]}, {2.5245216*^9, 
                    GrayLevel[0.8]}, {2.8401408*^9, 
                    GrayLevel[0.8]}, {3.1556736*^9, 
                    GrayLevel[0.8]}}, None}],
                
                PlotRange->{{2.2089888*^9, 3.3135264*^9}, {0., 
                 2.1987957539265283`*^12}},
                PlotRangeClipping->True,
                PlotRangePadding->{
                  Scaled[0.02], 
                  Scaled[0.02]},
                Ticks->None],
               ImageMargins->0]}
            },
            BaselinePosition->{1, 1},
            ColumnsEqual->False,
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxBackground->{"Columns" -> {{Automatic}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
            RowsEqual->False],
           "Grid"]}, Dynamic[Typeset`var$$],
          Alignment->Automatic,
          BaselinePosition->Baseline,
          DefaultBaseStyle->"OpenerView",
          ImageMargins->0,
          ImageSize->Automatic],
         Deployed->False,
         StripOnInput->False],
        OpenerView[{
          Row[{
            Graphics[
             Raster[CompressedData["
1:eJzdmHtQVFUYwA/7ELblIRCguwspqQmLoag5PRzGrEinx+Q/9UdOiKnVNFA8
MtDEaggTRHuYGIFOQUKshmCm02QBRoQpSog8fFt/2Eh/OBqQu/v1fXc529ld
RJvx3tv0zXxzz+Fc7vnt9zjnO2diWsaiNC1jbOqw6tj/Q4KCglJ1Ol0DNgE1
WBj6r/xE8NIcof248J6f8miS3IY6n/lyco1E+1Zotdrjer1+KfYfMxqNa/E5
R2HOR4mnqrICfj3fC309x2DF8qWXUlIe7snOSu+/7945ThrHeLjG2U2m8baw
sLC0qKiojdjXKMBYSvNWflYuMZ4+2QlnT3dJbdKuzsMwPXGaMzn5AXt52UcO
W20lvLepCF595eWhyIiIiwaDoYe5/CGXGFF3EmNOdsZFqzXucsvBA4Ocj9uV
nufPdoP491N9nTB7VtIAc9lWKxMf5UAIaoGfn9/J4bnInh6M3mqrrXIyz5i1
3mowzIFMcY78NXl/XjjXA/PmJf9F/cbv9l2X76uGnQ56B3PoBD4n3Wo2lCT6
/pTJkyApafqVrMx0Z8fRVrcP9+7ZBT/+cMDHp6JGWywSI9q9UQY+TUBAQDt9
v6S48LoMN9Lqz7dz+98hAyPF3p30/fz8vN9Hs9VouiR1cT9+4yEZ+LgYMRYv
f1K2Gc6dOfGv+XZUbXOEh4cvloHLH7leQrVhG+p3f3FTPLgOwqq816729XZI
/ZIN64bGjg1eLQMf02g0tH9JMbRvb90N2dpaGz32wpkzZ1yIjZ1Yg22DHHwo
U/hcmCf2ovUFzkVPPTFwqK0JaK0ZiZHGYmIszfg/d6OamLx1xO2M+dYI2yu2
jshGPk1MnDYUHW3OYPLtGaMJ2QPeXfe2j/0wf8Q9Y74KbCRUo8IGXBPF9YZY
f25rhoULHnFMmBBTrCYb6cIFKSPuHWaziWotir0AFfimYj471+avcnpzkf0K
C97kvr1LQaZI1Bmoz6CuRv9dPXPquAcb7cXsn7gzK8gWx24id03jx9l1Wm05
jukVZCNZSTy5r2fD/q/rYM0buVJ+Yg3v4DX0sfZWCAkJvjL8W5SUcaizIiLC
VyLfoLiWiO3dX9bQ+eM3pmw+kJ+otnT7tLf7qE+uEmfqc886AgMD1zNlzkJu
8ff3X4FnR4kxISF+QLQZr2Fqqj/l/LFKsqFkMK+cKC56B/bU2xy8n5ebY8ez
2WBoaOjTCrORSP7FutzN1/ZTE1jj49x8TB27cZHm1+lc8dfZccgdb03f7xf5
otWAQ7v9QfPjXiFxUJyJeVG65X2wmE10rl2iBh/KW0zwI9XN3rUK+Xt43KIC
XwjabpDmb6iv9bjPEHMYa4RL+M6DCrPRfZ/bdltLP5Bs573nktI9C+4lJUrC
Yex1iHwvvvA8tB9ukdq4Jjqam76BLZs3QdnHH0LLwW9h7tz7f8GxyQoiBjHX
3iHdYdTtqpbsR7ai/pgx+n6RH8/wR5g695SpnCErMx26u45wpmXMVacaVOIS
RbqfLC4qvEa1MtUCzMU4W2UuLoGokGCNdy5flmanNWVH1TbOeI/KbFyeZCPf
QafIMdnf1M1Cqg==
              "], {{0, 0}, {40, 40}}, {0, 255}, ColorFunction -> RGBColor], 
             Background -> None, ImageSize -> {40, 40}, 
             PlotRange -> {{0, 40}, {0, 40}}], "UnitedKingdom"}], 
          Graphics[{{{}, {
              Hue[0.67, 0.6, 0.6], 
              
              Point[{{2.2089888*^9, 1.2363590126436914`*^11}, {2.2405248*^9, 
               1.3980572083619217`*^11}, {2.2720608*^9, 
               1.6063569485203543`*^11}, {2.3036832*^9, 
               1.8124513969447748`*^11}, {2.3352192*^9, 
               1.957702847195009*^11}, {2.3667552*^9, 
               2.3398975145108023`*^11}, {2.3982912*^9, 
               2.2479207505729996`*^11}, {2.4299136*^9, 
               2.5385680838041418`*^11}, {2.4614496*^9, 
               3.21772819807636*^11}, {2.4929856*^9, 4.179666923422399*^11}, {
               2.5245216*^9, 5.361321896283531*^11}, {2.556144*^9, 
               5.083982851941528*^11}, {2.58768*^9, 4.840449529095338*^11}, {
               2.619216*^9, 4.5894000027881354`*^11}, {2.650752*^9, 
               4.3150455371477625`*^11}, {2.6823744*^9, 
               4.5550699023655786`*^11}, {2.7139104*^9, 
               5.58954105166052*^11}, {2.7454464*^9, 6.857539263293876*^11}, {
               2.7769824*^9, 8.331747712214061*^11}, {2.8086048*^9, 
               8.412809635246335*^11}, {2.8401408*^9, 9.89564266780465*^11}, {
               2.8716768*^9, 1.0334817518162361`*^12}, {2.9032128*^9, 
               1.0715859646146346`*^12}, {2.9348352*^9, 
               9.624067386994218*^11}, {2.9663712*^9, 
               1.0413426629112925`*^12}, {2.9979072*^9, 
               1.1336896670768289`*^12}, {3.0294432*^9, 
               1.1912803900154153`*^12}, {3.0610656*^9, 
               1.3270351591864573`*^12}, {3.0926016*^9, 
               1.4251182105389539`*^12}, {3.1241376*^9, 
               1.4649752807122458`*^12}, {3.1556736*^9, 
               1.4427772951531748`*^12}, {3.187296*^9, 
               1.4348964593935117`*^12}, {3.218832*^9, 
               1.571371904459777*^12}, {3.250368*^9, 1.805663111405002*^12}, {
               3.281904*^9, 2.1321560657658647`*^12}, {3.3135264*^9, 
               2.1987957539265283`*^12}}]}, {}}}, {
           AspectRatio -> GoldenRatio^(-1), AxesOrigin -> {2208988800, 0}, 
            Frame -> True, 
            FrameTicks -> {{
              Automatic, 
               Automatic}, {{{2208988800, "1970"}, {2524521600, "1980"}, {
                2840140800, "1990"}, {3155673600, "2000"}, {
                2272060800, " "}, {2335219200, " "}, {2398291200, " "}, {
                2461449600, " "}, {2587680000, " "}, {2650752000, " "}, {
                2713910400, " "}, {2776982400, " "}, {2903212800, " "}, {
                2966371200, " "}, {3029443200, " "}, {3092601600, " "}, {
                3218832000, " "}, {3281904000, " "}}, {{2208988800, " "}, {
                2524521600, " "}, {2840140800, " "}, {3155673600, " "}, {
                2272060800, " "}, {2335219200, " "}, {2398291200, " "}, {
                2461449600, " "}, {2587680000, " "}, {2650752000, " "}, {
                2713910400, " "}, {2776982400, " "}, {2903212800, " "}, {
                2966371200, " "}, {3029443200, " "}, {3092601600, " "}, {
                3218832000, " "}, {3281904000, " "}}}}, 
            GridLines -> {{{2208988800, 
                GrayLevel[0.8]}, {2524521600, 
                GrayLevel[0.8]}, {2840140800, 
                GrayLevel[0.8]}, {3155673600, 
                GrayLevel[0.8]}}, None}, 
            PlotRange -> {{2.2089888*^9, 3.3135264*^9}, {0., 
             2.1987957539265283`*^12}}, PlotRangeClipping -> True, 
            PlotRangePadding -> {
              Scaled[0.02], 
              Scaled[0.02]}, Ticks -> None}]}, False]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ]},
    {
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = False}, 
       InterpretationBox[
        StyleBox[
         PaneSelectorBox[{False->
          TagBox[GridBox[{
             {
              OpenerBox[Dynamic[Typeset`var$$],
               Appearance->Automatic,
               AutoAction->False,
               ContinuousAction->False,
               Enabled->Automatic], 
              InterpretationBox[
               RowBox[{
                GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJmYGDQgGIWhlEwCkbBKBgFVADRQPwfiKUG2iFYwAQGiNtAeC0Z
+iOo6xwUoADE/62tLWHuA2E2IvUyIukBYWYquYkfZB4jI+M3EB0eHvz78cOb
/+tqK5HtAoWJERAnAHEFENtB3QMDzDC1vj6eIHMc0eTJBYIgM6sqS/9bWVn8
dHdz+fPk0a3/MHzrxgVkN6JjTagZVkBsjybnTaZ79IDYEoh9gVgLZh6ym7Dh
B/eu/b9+9dz/06cO/Qf64R8eN8MwqUBYQU6m1MTY4EFRYc6r6qqyPxYWZp9a
Wxq+EXIbNvzw/vX/9+5c+T95Ui/Y7YcO7kJ2GzcJ7rIBpqsuYWGh17NnTvnx
6MENkt1CDL5/9+p/dTVVUvNFIUh9YkLsvwvnjtPEXcg4OSkO5r67DISbo/Eg
tTNnTKa5u5AxMCxgblTG4S5Qnp4HUrN29VK6ug2EQeUSA/7yjw0mD0oT9HYf
CJ86eQhfPlYCic+aSd94RcZ3b19Bdp8FmvsiQeLZWWngMmAg3GdmZoLsPpR8
AixL9oDEQX4YCLft3LERvZxmQnYfMzPz0ZDgALqFHSg/HNy/A0UMzX3o5cz/
zIyUP/Rw2+2bF/8rKyv9BdlpZ2v9B+RWUJ48e/rI/5iYCJj7BNDcFwYSv33r
El3Cb+nief95eXkvs7GxHUtKjHsNijeQO+fMnoochuxI7ksHiZ0/e4wu7ps7
Z9ovaWnpOKCdpgzgdlDJO1C9DJLbvnU9shtZkeMY6Jd/tI5bCQnxf8D8CIpf
WF3BCcT/+no7wGounj+Bq6wOgolfvniSZLtBaQjUJgGxQWGxZvWS/zHREf8D
Anz/Hjm0B1Rn/oSa/wstXEDAAySXl5PxA6QWqm41A2pb1QDmPlBaQLYb1IY7
fnTf/w3rVgDtmfQxIz3lUV5e5vnExNiToSGBR3y8PPZ7errt8PLy2OHi4ngK
OS8Cw+oaiAamtxkMkHoAF5Di4OCoYkDNxyFoauByoDJpzuxpnzPSki+4ujqv
t7GxapOQEAWFMaidqgPEogyQNj47mhmgODFBixuih8lYWVmvdbQ3YavruJHd
Z2Cg1wykHYBYglizqQCYubm518nLyf7j4eHZh0UelC5YGDDTBz0BLysz8xEG
SL4ZBaNgFIwCmgIAaC0IUA==
                  "], {{0, 0}, {40, 40}}, {0, 255},
                  ColorFunction->RGBColor],
                 Background->None,
                 ImageSize->{40, 40},
                 PlotRange->{{0, 40}, {0, 40}}], 
                "\[InvisibleSpace]", "\<\"UnitedStates\"\>"}],
               Row[{
                 Graphics[
                  Raster[CompressedData["
1:eJxTTMoPSmJmYGDQgGIWhlEwCkbBKBgFVADRQPwfiKUG2iFYwAQGiNtAeC0Z
+iOo6xwUoADE/62tLWHuA2E2IvUyIukBYWYquYkfZB4jI+M3EB0eHvz78cOb
/+tqK5HtAoWJERAnAHEFENtB3QMDzDC1vj6eIHMc0eTJBYIgM6sqS/9bWVn8
dHdz+fPk0a3/MHzrxgVkN6JjTagZVkBsjybnTaZ79IDYEoh9gVgLZh6ym7Dh
B/eu/b9+9dz/06cO/Qf64R8eN8MwqUBYQU6m1MTY4EFRYc6r6qqyPxYWZp9a
Wxq+EXIbNvzw/vX/9+5c+T95Ui/Y7YcO7kJ2GzcJ7rIBpqsuYWGh17NnTvnx
6MENkt1CDL5/9+p/dTVVUvNFIUh9YkLsvwvnjtPEXcg4OSkO5r67DISbo/Eg
tTNnTKa5u5AxMCxgblTG4S5Qnp4HUrN29VK6ug2EQeUSA/7yjw0mD0oT9HYf
CJ86eQhfPlYCic+aSd94RcZ3b19Bdp8FmvsiQeLZWWngMmAg3GdmZoLsPpR8
AixL9oDEQX4YCLft3LERvZxmQnYfMzPz0ZDgALqFHSg/HNy/A0UMzX3o5cz/
zIyUP/Rw2+2bF/8rKyv9BdlpZ2v9B+RWUJ48e/rI/5iYCJj7BNDcFwYSv33r
El3Cb+nief95eXkvs7GxHUtKjHsNijeQO+fMnoochuxI7ksHiZ0/e4wu7ps7
Z9ovaWnpOKCdpgzgdlDJO1C9DJLbvnU9shtZkeMY6Jd/tI5bCQnxf8D8CIpf
WF3BCcT/+no7wGounj+Bq6wOgolfvniSZLtBaQjUJgGxQWGxZvWS/zHREf8D
Anz/Hjm0B1Rn/oSa/wstXEDAAySXl5PxA6QWqm41A2pb1QDmPlBaQLYb1IY7
fnTf/w3rVgDtmfQxIz3lUV5e5vnExNiToSGBR3y8PPZ7errt8PLy2OHi4ngK
OS8Cw+oaiAamtxkMkHoAF5Di4OCoYkDNxyFoauByoDJpzuxpnzPSki+4ujqv
t7GxapOQEAWFMaidqgPEogyQNj47mhmgODFBixuih8lYWVmvdbQ3YavruJHd
Z2Cg1wykHYBYglizqQCYubm518nLyf7j4eHZh0UelC5YGDDTBz0BLysz8xEG
SL4ZBaNgFIwCmgIAaC0IUA==
                   "], {{0, 0}, {40, 40}}, {0, 255}, ColorFunction -> 
                   RGBColor], Background -> None, ImageSize -> {40, 40}, 
                  PlotRange -> {{0, 40}, {0, 40}}], "UnitedStates"}]]}
            },
            BaselinePosition->{1, 1},
            ColumnsEqual->False,
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxBackground->{"Columns" -> {{Automatic}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
            RowsEqual->False],
           "Grid"], True->
          TagBox[GridBox[{
             {
              OpenerBox[Dynamic[Typeset`var$$],
               Appearance->Automatic,
               AutoAction->False,
               ContinuousAction->False,
               Enabled->Automatic], 
              InterpretationBox[
               RowBox[{
                GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJmYGDQgGIWhlEwCkbBKBgFVADRQPwfiKUG2iFYwAQGiNtAeC0Z
+iOo6xwUoADE/62tLWHuA2E2IvUyIukBYWYquYkfZB4jI+M3EB0eHvz78cOb
/+tqK5HtAoWJERAnAHEFENtB3QMDzDC1vj6eIHMc0eTJBYIgM6sqS/9bWVn8
dHdz+fPk0a3/MHzrxgVkN6JjTagZVkBsjybnTaZ79IDYEoh9gVgLZh6ym7Dh
B/eu/b9+9dz/06cO/Qf64R8eN8MwqUBYQU6m1MTY4EFRYc6r6qqyPxYWZp9a
Wxq+EXIbNvzw/vX/9+5c+T95Ui/Y7YcO7kJ2GzcJ7rIBpqsuYWGh17NnTvnx
6MENkt1CDL5/9+p/dTVVUvNFIUh9YkLsvwvnjtPEXcg4OSkO5r67DISbo/Eg
tTNnTKa5u5AxMCxgblTG4S5Qnp4HUrN29VK6ug2EQeUSA/7yjw0mD0oT9HYf
CJ86eQhfPlYCic+aSd94RcZ3b19Bdp8FmvsiQeLZWWngMmAg3GdmZoLsPpR8
AixL9oDEQX4YCLft3LERvZxmQnYfMzPz0ZDgALqFHSg/HNy/A0UMzX3o5cz/
zIyUP/Rw2+2bF/8rKyv9BdlpZ2v9B+RWUJ48e/rI/5iYCJj7BNDcFwYSv33r
El3Cb+nief95eXkvs7GxHUtKjHsNijeQO+fMnoochuxI7ksHiZ0/e4wu7ps7
Z9ovaWnpOKCdpgzgdlDJO1C9DJLbvnU9shtZkeMY6Jd/tI5bCQnxf8D8CIpf
WF3BCcT/+no7wGounj+Bq6wOgolfvniSZLtBaQjUJgGxQWGxZvWS/zHREf8D
Anz/Hjm0B1Rn/oSa/wstXEDAAySXl5PxA6QWqm41A2pb1QDmPlBaQLYb1IY7
fnTf/w3rVgDtmfQxIz3lUV5e5vnExNiToSGBR3y8PPZ7errt8PLy2OHi4ngK
OS8Cw+oaiAamtxkMkHoAF5Di4OCoYkDNxyFoauByoDJpzuxpnzPSki+4ujqv
t7GxapOQEAWFMaidqgPEogyQNj47mhmgODFBixuih8lYWVmvdbQ3YavruJHd
Z2Cg1wykHYBYglizqQCYubm518nLyf7j4eHZh0UelC5YGDDTBz0BLysz8xEG
SL4ZBaNgFIwCmgIAaC0IUA==
                  "], {{0, 0}, {40, 40}}, {0, 255},
                  ColorFunction->RGBColor],
                 Background->None,
                 ImageSize->{40, 40},
                 PlotRange->{{0, 40}, {0, 40}}], 
                "\[InvisibleSpace]", "\<\"UnitedStates\"\>"}],
               Row[{
                 Graphics[
                  Raster[CompressedData["
1:eJxTTMoPSmJmYGDQgGIWhlEwCkbBKBgFVADRQPwfiKUG2iFYwAQGiNtAeC0Z
+iOo6xwUoADE/62tLWHuA2E2IvUyIukBYWYquYkfZB4jI+M3EB0eHvz78cOb
/+tqK5HtAoWJERAnAHEFENtB3QMDzDC1vj6eIHMc0eTJBYIgM6sqS/9bWVn8
dHdz+fPk0a3/MHzrxgVkN6JjTagZVkBsjybnTaZ79IDYEoh9gVgLZh6ym7Dh
B/eu/b9+9dz/06cO/Qf64R8eN8MwqUBYQU6m1MTY4EFRYc6r6qqyPxYWZp9a
Wxq+EXIbNvzw/vX/9+5c+T95Ui/Y7YcO7kJ2GzcJ7rIBpqsuYWGh17NnTvnx
6MENkt1CDL5/9+p/dTVVUvNFIUh9YkLsvwvnjtPEXcg4OSkO5r67DISbo/Eg
tTNnTKa5u5AxMCxgblTG4S5Qnp4HUrN29VK6ug2EQeUSA/7yjw0mD0oT9HYf
CJ86eQhfPlYCic+aSd94RcZ3b19Bdp8FmvsiQeLZWWngMmAg3GdmZoLsPpR8
AixL9oDEQX4YCLft3LERvZxmQnYfMzPz0ZDgALqFHSg/HNy/A0UMzX3o5cz/
zIyUP/Rw2+2bF/8rKyv9BdlpZ2v9B+RWUJ48e/rI/5iYCJj7BNDcFwYSv33r
El3Cb+nief95eXkvs7GxHUtKjHsNijeQO+fMnoochuxI7ksHiZ0/e4wu7ps7
Z9ovaWnpOKCdpgzgdlDJO1C9DJLbvnU9shtZkeMY6Jd/tI5bCQnxf8D8CIpf
WF3BCcT/+no7wGounj+Bq6wOgolfvniSZLtBaQjUJgGxQWGxZvWS/zHREf8D
Anz/Hjm0B1Rn/oSa/wstXEDAAySXl5PxA6QWqm41A2pb1QDmPlBaQLYb1IY7
fnTf/w3rVgDtmfQxIz3lUV5e5vnExNiToSGBR3y8PPZ7errt8PLy2OHi4ngK
OS8Cw+oaiAamtxkMkHoAF5Di4OCoYkDNxyFoauByoDJpzuxpnzPSki+4ujqv
t7GxapOQEAWFMaidqgPEogyQNj47mhmgODFBixuih8lYWVmvdbQ3YavruJHd
Z2Cg1wykHYBYglizqQCYubm518nLyf7j4eHZh0UelC5YGDDTBz0BLysz8xEG
SL4ZBaNgFIwCmgIAaC0IUA==
                   "], {{0, 0}, {40, 40}}, {0, 255}, ColorFunction -> 
                   RGBColor], Background -> None, ImageSize -> {40, 40}, 
                  PlotRange -> {{0, 40}, {0, 40}}], "UnitedStates"}]]},
             {"", 
              PaneBox[
               GraphicsBox[{{}, 
                 {Hue[0.67, 0.6, 0.6], 
                  PointBox[{{2.2089888*^9, 1.025*^12}, {2.2405248*^9, 
                   1.1134*^12}, {2.2720608*^9, 1.2254*^12}, {2.3036832*^9, 
                   1.3698*^12}, {2.3352192*^9, 1.4864000007432*^12}, {
                   2.3667552*^9, 1.624000001624*^12}, {2.3982912*^9, 
                   1.8098000018098*^12}, {2.4299136*^9, 
                   2.0143000020143*^12}, {2.4614496*^9, 
                   2.2769000022769*^12}, {2.4929856*^9, 
                   2.5445000025445*^12}, {2.5245216*^9, 
                   2.7689000027689*^12}, {2.556144*^9, 3.1054000031054*^12}, {
                   2.58768*^9, 3.2295000032295*^12}, {2.619216*^9, 
                   3.5088000035088*^12}, {2.650752*^9, 
                   3.902600001626085*^12}, {2.6823744*^9, 4.1875*^12}, {
                   2.7139104*^9, 4.4277*^12}, {2.7454464*^9, 4.7021*^12}, {
                   2.7769824*^9, 5.0639*^12}, {2.8086048*^9, 5.4417*^12}, {
                   2.8401408*^9, 5.7572*^12}, {2.8716768*^9, 5.9469*^12}, {
                   2.9032128*^9, 6.2868*^12}, {2.9348352*^9, 6.6043*^12}, {
                   2.9663712*^9, 7.0175*^12}, {2.9979072*^9, 7.3423*^12}, {
                   3.0294432*^9, 7.7623*^12}, {3.0610656*^9, 8.2509*^12}, {
                   3.0926016*^9, 8.6946*^12}, {3.1241376*^9, 9.2162*^12}, {
                   3.1556736*^9, 9.7648*^12}, {3.187296*^9, 1.00759*^13}, {
                   3.218832*^9, 1.04176*^13}, {3.250368*^9, 1.09185*^13}, {
                   3.281904*^9, 1.16792*^13}, {3.3135264*^9, 
                   1.24558*^13}}]}, {}},
                AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                AxesOrigin->NCache[{2208988800, 0}, {2.2089888*^9, 0}],
                Frame->True,
                FrameTicks->{{Automatic, Automatic}, {{{
                    NCache[2208988800, 2.2089888*^9], 
                    FormBox["\"1970\"", TraditionalForm]}, {
                    NCache[2524521600, 2.5245216*^9], 
                    FormBox["\"1980\"", TraditionalForm]}, {
                    NCache[2840140800, 2.8401408*^9], 
                    FormBox["\"1990\"", TraditionalForm]}, {
                    NCache[3155673600, 3.1556736*^9], 
                    FormBox["\"2000\"", TraditionalForm]}, {
                    NCache[2272060800, 2.2720608*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2335219200, 2.3352192*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2398291200, 2.3982912*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2461449600, 2.4614496*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2587680000, 2.58768*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2650752000, 2.650752*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2713910400, 2.7139104*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2776982400, 2.7769824*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2903212800, 2.9032128*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2966371200, 2.9663712*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3029443200, 3.0294432*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3092601600, 3.0926016*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3218832000, 3.218832*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3281904000, 3.281904*^9], 
                    FormBox["\" \"", TraditionalForm]}}, {{
                    NCache[2208988800, 2.2089888*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2524521600, 2.5245216*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2840140800, 2.8401408*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3155673600, 3.1556736*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2272060800, 2.2720608*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2335219200, 2.3352192*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2398291200, 2.3982912*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2461449600, 2.4614496*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2587680000, 2.58768*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2650752000, 2.650752*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2713910400, 2.7139104*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2776982400, 2.7769824*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2903212800, 2.9032128*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[2966371200, 2.9663712*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3029443200, 3.0294432*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3092601600, 3.0926016*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3218832000, 3.218832*^9], 
                    FormBox["\" \"", TraditionalForm]}, {
                    NCache[3281904000, 3.281904*^9], 
                    FormBox["\" \"", TraditionalForm]}}}},
                GridLines->NCache[{{{2208988800, 
                    GrayLevel[0.8]}, {2524521600, 
                    GrayLevel[0.8]}, {2840140800, 
                    GrayLevel[0.8]}, {3155673600, 
                    GrayLevel[0.8]}}, None}, {{{2.2089888*^9, 
                    GrayLevel[0.8]}, {2.5245216*^9, 
                    GrayLevel[0.8]}, {2.8401408*^9, 
                    GrayLevel[0.8]}, {3.1556736*^9, 
                    GrayLevel[0.8]}}, None}],
                PlotRange->{{2.2089888*^9, 3.3135264*^9}, {0., 1.24558*^13}},
                PlotRangeClipping->True,
                PlotRangePadding->{
                  Scaled[0.02], 
                  Scaled[0.02]},
                Ticks->None],
               ImageMargins->0]}
            },
            BaselinePosition->{1, 1},
            ColumnsEqual->False,
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxBackground->{"Columns" -> {{Automatic}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
            RowsEqual->False],
           "Grid"]}, Dynamic[Typeset`var$$],
          Alignment->Automatic,
          BaselinePosition->Baseline,
          DefaultBaseStyle->"OpenerView",
          ImageMargins->0,
          ImageSize->Automatic],
         Deployed->False,
         StripOnInput->False],
        OpenerView[{
          Row[{
            Graphics[
             Raster[CompressedData["
1:eJxTTMoPSmJmYGDQgGIWhlEwCkbBKBgFVADRQPwfiKUG2iFYwAQGiNtAeC0Z
+iOo6xwUoADE/62tLWHuA2E2IvUyIukBYWYquYkfZB4jI+M3EB0eHvz78cOb
/+tqK5HtAoWJERAnAHEFENtB3QMDzDC1vj6eIHMc0eTJBYIgM6sqS/9bWVn8
dHdz+fPk0a3/MHzrxgVkN6JjTagZVkBsjybnTaZ79IDYEoh9gVgLZh6ym7Dh
B/eu/b9+9dz/06cO/Qf64R8eN8MwqUBYQU6m1MTY4EFRYc6r6qqyPxYWZp9a
Wxq+EXIbNvzw/vX/9+5c+T95Ui/Y7YcO7kJ2GzcJ7rIBpqsuYWGh17NnTvnx
6MENkt1CDL5/9+p/dTVVUvNFIUh9YkLsvwvnjtPEXcg4OSkO5r67DISbo/Eg
tTNnTKa5u5AxMCxgblTG4S5Qnp4HUrN29VK6ug2EQeUSA/7yjw0mD0oT9HYf
CJ86eQhfPlYCic+aSd94RcZ3b19Bdp8FmvsiQeLZWWngMmAg3GdmZoLsPpR8
AixL9oDEQX4YCLft3LERvZxmQnYfMzPz0ZDgALqFHSg/HNy/A0UMzX3o5cz/
zIyUP/Rw2+2bF/8rKyv9BdlpZ2v9B+RWUJ48e/rI/5iYCJj7BNDcFwYSv33r
El3Cb+nief95eXkvs7GxHUtKjHsNijeQO+fMnoochuxI7ksHiZ0/e4wu7ps7
Z9ovaWnpOKCdpgzgdlDJO1C9DJLbvnU9shtZkeMY6Jd/tI5bCQnxf8D8CIpf
WF3BCcT/+no7wGounj+Bq6wOgolfvniSZLtBaQjUJgGxQWGxZvWS/zHREf8D
Anz/Hjm0B1Rn/oSa/wstXEDAAySXl5PxA6QWqm41A2pb1QDmPlBaQLYb1IY7
fnTf/w3rVgDtmfQxIz3lUV5e5vnExNiToSGBR3y8PPZ7errt8PLy2OHi4ngK
OS8Cw+oaiAamtxkMkHoAF5Di4OCoYkDNxyFoauByoDJpzuxpnzPSki+4ujqv
t7GxapOQEAWFMaidqgPEogyQNj47mhmgODFBixuih8lYWVmvdbQ3YavruJHd
Z2Cg1wykHYBYglizqQCYubm518nLyf7j4eHZh0UelC5YGDDTBz0BLysz8xEG
SL4ZBaNgFIwCmgIAaC0IUA==
              "], {{0, 0}, {40, 40}}, {0, 255}, ColorFunction -> RGBColor], 
             Background -> None, ImageSize -> {40, 40}, 
             PlotRange -> {{0, 40}, {0, 40}}], "UnitedStates"}], 
          Graphics[{{{}, {
              Hue[0.67, 0.6, 0.6], 
              
              Point[{{2.2089888*^9, 1.025*^12}, {2.2405248*^9, 1.1134*^12}, {
               2.2720608*^9, 1.2254*^12}, {2.3036832*^9, 1.3698*^12}, {
               2.3352192*^9, 1.4864000007432*^12}, {2.3667552*^9, 
               1.624000001624*^12}, {2.3982912*^9, 1.8098000018098*^12}, {
               2.4299136*^9, 2.0143000020143*^12}, {2.4614496*^9, 
               2.2769000022769*^12}, {2.4929856*^9, 2.5445000025445*^12}, {
               2.5245216*^9, 2.7689000027689*^12}, {2.556144*^9, 
               3.1054000031054*^12}, {2.58768*^9, 3.2295000032295*^12}, {
               2.619216*^9, 3.5088000035088*^12}, {2.650752*^9, 
               3.902600001626085*^12}, {2.6823744*^9, 4.1875*^12}, {
               2.7139104*^9, 4.4277*^12}, {2.7454464*^9, 4.7021*^12}, {
               2.7769824*^9, 5.0639*^12}, {2.8086048*^9, 5.4417*^12}, {
               2.8401408*^9, 5.7572*^12}, {2.8716768*^9, 5.9469*^12}, {
               2.9032128*^9, 6.2868*^12}, {2.9348352*^9, 6.6043*^12}, {
               2.9663712*^9, 7.0175*^12}, {2.9979072*^9, 7.3423*^12}, {
               3.0294432*^9, 7.7623*^12}, {3.0610656*^9, 8.2509*^12}, {
               3.0926016*^9, 8.6946*^12}, {3.1241376*^9, 9.2162*^12}, {
               3.1556736*^9, 9.7648*^12}, {3.187296*^9, 1.00759*^13}, {
               3.218832*^9, 1.04176*^13}, {3.250368*^9, 1.09185*^13}, {
               3.281904*^9, 1.16792*^13}, {3.3135264*^9, 
               1.24558*^13}}]}, {}}}, {
           AspectRatio -> GoldenRatio^(-1), AxesOrigin -> {2208988800, 0}, 
            Frame -> True, 
            FrameTicks -> {{
              Automatic, 
               Automatic}, {{{2208988800, "1970"}, {2524521600, "1980"}, {
                2840140800, "1990"}, {3155673600, "2000"}, {
                2272060800, " "}, {2335219200, " "}, {2398291200, " "}, {
                2461449600, " "}, {2587680000, " "}, {2650752000, " "}, {
                2713910400, " "}, {2776982400, " "}, {2903212800, " "}, {
                2966371200, " "}, {3029443200, " "}, {3092601600, " "}, {
                3218832000, " "}, {3281904000, " "}}, {{2208988800, " "}, {
                2524521600, " "}, {2840140800, " "}, {3155673600, " "}, {
                2272060800, " "}, {2335219200, " "}, {2398291200, " "}, {
                2461449600, " "}, {2587680000, " "}, {2650752000, " "}, {
                2713910400, " "}, {2776982400, " "}, {2903212800, " "}, {
                2966371200, " "}, {3029443200, " "}, {3092601600, " "}, {
                3218832000, " "}, {3281904000, " "}}}}, 
            GridLines -> {{{2208988800, 
                GrayLevel[0.8]}, {2524521600, 
                GrayLevel[0.8]}, {2840140800, 
                GrayLevel[0.8]}, {3155673600, 
                GrayLevel[0.8]}}, None}, 
            PlotRange -> {{2.2089888*^9, 3.3135264*^9}, {0., 1.24558*^13}}, 
            PlotRangeClipping -> True, PlotRangePadding -> {
              Scaled[0.02], 
              Scaled[0.02]}, Ticks -> None}]}, False]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ]}
   },
   ColumnsEqual->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   RowsEqual->False],
  "Column"]], "Output",
 ImageSize->{198, 481},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1053764688]
}, Open  ]],

Cell[TextData[{
 "One advantage of a column like this over a ",
 Cell[BoxData[
  ButtonBox["TabView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TabView"]], "InlineFormula"],
 ", for example, is that you can have two or more panes open at once, while \
other views typically let you see only one pane at a time."
}], "Text"],

Cell[TextData[{
 "Like other Views, ",
 Cell[BoxData[
  ButtonBox["OpenerView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenerView"]], "InlineFormula"],
 " can be nested arbitrarily deeply",
 ". ",
 "This example turns any expression into a nested tree of openers in which \
the closed state is the head of the expression and the open state is a column \
of openers for each argument."
}], "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"OpenerTree", "[", "expr_", "]"}], ":=", 
   RowBox[{"OpenerView", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"OpenerTree", "[", 
       RowBox[{"Head", "[", "expr", "]"}], "]"}], ",", 
      RowBox[{"Column", "[", 
       RowBox[{"Map", "[", 
        RowBox[{"OpenerTree", ",", 
         RowBox[{"Apply", "[", 
          RowBox[{"List", ",", "expr"}], "]"}]}], "]"}], "]"}]}], "}"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"OpenerTree", "[", "expr_", "]"}], ":=", 
  RowBox[{"expr", "/;", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Length", "[", "expr", "]"}], "===", "0"}], ")"}]}]}]}], "Input",\

 CellLabel->"In[5]:="],

Cell["\<\
Here is a simple application shown with all the openers in the open state.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OpenerTree", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "+", "b"}], ")"}], 
   RowBox[{"(", 
    RowBox[{"c", "+", "d"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[7]:="],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = True}, 
   InterpretationBox[
    StyleBox[
     PaneSelectorBox[{False->
      TagBox[GridBox[{
         {
          OpenerBox[Dynamic[Typeset`var$$],
           Appearance->Automatic,
           AutoAction->False,
           ContinuousAction->False,
           Enabled->Automatic], "Times"}
        },
        BaselinePosition->{1, 1},
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxBackground->{"Columns" -> {{Automatic}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
        RowsEqual->False],
       "Grid"], True->
      TagBox[GridBox[{
         {
          OpenerBox[Dynamic[Typeset`var$$],
           Appearance->Automatic,
           AutoAction->False,
           ContinuousAction->False,
           Enabled->Automatic], "Times"},
         {"", 
          PaneBox[
           TagBox[GridBox[{
              {
               TagBox[
                DynamicModuleBox[{Typeset`var$$ = True}, 
                 InterpretationBox[
                  StyleBox[
                   PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Plus"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Plus"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {"a"},
                    {"b"}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                   Deployed->False,
                   StripOnInput->False],
                  OpenerView[{Plus, 
                    Column[{$CellContext`a, $CellContext`b}]}, False]],
                 DynamicModuleValues:>{}],
                Setting[#, {0}]& ]},
              {
               TagBox[
                DynamicModuleBox[{Typeset`var$$ = True}, 
                 InterpretationBox[
                  StyleBox[
                   PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Plus"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Plus"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {"c"},
                    {"d"}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                   Deployed->False,
                   StripOnInput->False],
                  OpenerView[{Plus, 
                    Column[{$CellContext`c, $CellContext`d}]}, False]],
                 DynamicModuleValues:>{}],
                Setting[#, {0}]& ]}
             },
             ColumnsEqual->False,
             GridBoxAlignment->{"Columns" -> {{Left}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
             RowsEqual->False],
            "Column"],
           ImageMargins->0]}
        },
        BaselinePosition->{1, 1},
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxBackground->{"Columns" -> {{Automatic}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
        RowsEqual->False],
       "Grid"]}, Dynamic[Typeset`var$$],
      Alignment->Automatic,
      BaselinePosition->Baseline,
      DefaultBaseStyle->"OpenerView",
      ImageMargins->0,
      ImageSize->Automatic],
     Deployed->False,
     StripOnInput->False],
    OpenerView[{Times, 
      Column[{
        OpenerView[{Plus, 
          Column[{$CellContext`a, $CellContext`b}]}], 
        OpenerView[{Plus, 
          Column[{$CellContext`c, $CellContext`d}]}]}]}, False]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{60, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->325474407]
}, Open  ]],

Cell["\<\
Here is a more deeply nested application with just a few opened.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OpenerTree", "[", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"x", "^", "9"}]}], ")"}]}], ",", "x"}], "]"}], "]"}]], "Input",\

 CellLabel->"In[8]:=",
 CellID->607509540],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = True}, 
   InterpretationBox[
    StyleBox[
     PaneSelectorBox[{False->
      TagBox[GridBox[{
         {
          OpenerBox[Dynamic[Typeset`var$$],
           Appearance->Automatic,
           AutoAction->False,
           ContinuousAction->False,
           Enabled->Automatic], "Times"}
        },
        BaselinePosition->{1, 1},
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxBackground->{"Columns" -> {{Automatic}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
        RowsEqual->False],
       "Grid"], True->
      TagBox[GridBox[{
         {
          OpenerBox[Dynamic[Typeset`var$$],
           Appearance->Automatic,
           AutoAction->False,
           ContinuousAction->False,
           Enabled->Automatic], "Times"},
         {"", 
          PaneBox[
           TagBox[GridBox[{
              {
               FractionBox["1", "18"]},
              {
               TagBox[
                DynamicModuleBox[{Typeset`var$$ = True}, 
                 InterpretationBox[
                  StyleBox[
                   PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Plus"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Plus"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {"2"},
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Power"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Power"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {"3"},
                    {
                    FractionBox["1", "2"]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Power, 
                    Column[{3, 
                    Rational[1, 2]}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]},
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "ArcTan"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "ArcTan"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Power"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Power"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {"3"},
                    {
                    RowBox[{"-", 
                    FractionBox["1", "2"]}]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Power, 
                    Column[{3, 
                    Rational[-1, 2]}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]},
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Plus"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Plus"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {"1"},
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {"2"},
                    {"x"}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Times, 
                    Column[{2, $CellContext`x}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Plus, 
                    Column[{1, 
                    OpenerView[{Times, 
                    Column[{2, $CellContext`x}]}]}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{
                    Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Times, 
                    Column[{
                    OpenerView[{Power, 
                    Column[{3, 
                    Rational[-1, 2]}]}], 
                    OpenerView[{Plus, 
                    Column[{1, 
                    OpenerView[{Times, 
                    Column[{2, $CellContext`x}]}]}]}]}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{ArcTan, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    OpenerView[{Power, 
                    Column[{3, 
                    Rational[-1, 2]}]}], 
                    OpenerView[{Plus, 
                    Column[{1, 
                    OpenerView[{Times, 
                    Column[{2, $CellContext`x}]}]}]}]}]}]}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Times, 
                    Column[{2, 
                    OpenerView[{Power, 
                    Column[{3, 
                    Rational[1, 2]}]}], 
                    OpenerView[{ArcTan, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    OpenerView[{Power, 
                    Column[{3, 
                    Rational[-1, 2]}]}], 
                    OpenerView[{Plus, 
                    Column[{1, 
                    OpenerView[{Times, 
                    Column[{2, $CellContext`x}]}]}]}]}]}]}]}]}]}, False]],
                    DynamicModuleValues:>{}],
                    Setting[#, {0}]& ]},
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {"4"},
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "ArcTan"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "ArcTan"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Plus"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Plus"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {"x"},
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Sec"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Sec"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    FractionBox["1", "18"]},
                    {"\[Pi]"}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 18], Pi}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Sec, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 18], Pi}]}]}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Times, 
                    Column[{$CellContext`x, 
                    OpenerView[{Sec, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 18], Pi}]}]}]}]}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]},
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    RowBox[{"-", "1"}]},
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Tan"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Tan"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    FractionBox["1", "18"]},
                    {"\[Pi]"}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 18], Pi}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Tan, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 18], Pi}]}]}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Times, 
                    Column[{-1, 
                    OpenerView[{Tan, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 18], Pi}]}]}]}]}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{
                    Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Plus, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{$CellContext`x, 
                    OpenerView[{Sec, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 18], Pi}]}]}]}]}]}], 
                    OpenerView[{Times, 
                    Column[{-1, 
                    OpenerView[{Tan, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 18], Pi}]}]}]}]}]}]}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{ArcTan, 
                    Column[{
                    OpenerView[{Plus, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{$CellContext`x, 
                    OpenerView[{Sec, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 18], Pi}]}]}]}]}]}], 
                    OpenerView[{Times, 
                    Column[{-1, 
                    OpenerView[{Tan, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 18], Pi}]}]}]}]}]}]}]}]}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]},
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Cos"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Cos"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    FractionBox["1", "18"]},
                    {"\[Pi]"}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{
                    Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 18], Pi}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Cos, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 18], Pi}]}]}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Times, 
                    Column[{4, 
                    OpenerView[{ArcTan, 
                    Column[{
                    OpenerView[{Plus, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{$CellContext`x, 
                    OpenerView[{Sec, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 18], Pi}]}]}]}]}]}], 
                    OpenerView[{Times, 
                    Column[{-1, 
                    OpenerView[{Tan, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 18], Pi}]}]}]}]}]}]}]}]}]}], 
                    OpenerView[{Cos, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 18], Pi}]}]}]}]}]}, False]],
                    DynamicModuleValues:>{}],
                    Setting[#, {0}]& ]},
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    RowBox[{"-", "2"}]},
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Log"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Log"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Plus"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Plus"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    RowBox[{"-", "1"}]},
                    {"x"}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{
                    Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Plus, 
                    Column[{-1, $CellContext`x}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Log, 
                    Column[{
                    OpenerView[{Plus, 
                    Column[{-1, $CellContext`x}]}]}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Times, 
                    Column[{-2, 
                    OpenerView[{Log, 
                    Column[{
                    OpenerView[{Plus, 
                    Column[{-1, $CellContext`x}]}]}]}]}]}, False]],
                    DynamicModuleValues:>{}],
                    Setting[#, {0}]& ]},
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = True}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Log"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Log"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = True}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Plus"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Plus"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {"1"},
                    {"x"},
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = True}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Power"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Power"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {"x"},
                    {"2"}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{
                    Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Power, 
                    Column[{$CellContext`x, 2}]}, False]],
                    DynamicModuleValues:>{}],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Plus, 
                    Column[{1, $CellContext`x, 
                    OpenerView[{Power, 
                    Column[{$CellContext`x, 2}]}]}]}, False]],
                    DynamicModuleValues:>{}],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Log, 
                    Column[{
                    OpenerView[{Plus, 
                    Column[{1, $CellContext`x, 
                    OpenerView[{Power, 
                    Column[{$CellContext`x, 2}]}]}]}]}]}, False]],
                    DynamicModuleValues:>{}],
                    Setting[#, {0}]& ]},
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {"2"},
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Cos"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Cos"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    FractionBox["1", "9"]},
                    {"\[Pi]"}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{
                    Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 9], Pi}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Cos, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 9], Pi}]}]}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]},
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Log"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Log"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Plus"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Plus"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {"1"},
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Power"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Power"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {"x"},
                    {"2"}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Power, 
                    Column[{$CellContext`x, 2}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]},
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {"2"},
                    {"x"},
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Cos"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Cos"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    FractionBox["1", "9"]},
                    {"\[Pi]"}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 9], Pi}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Cos, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 9], Pi}]}]}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Times, 
                    Column[{2, $CellContext`x, 
                    OpenerView[{Cos, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 9], Pi}]}]}]}]}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{
                    Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Plus, 
                    Column[{1, 
                    OpenerView[{Power, 
                    Column[{$CellContext`x, 2}]}], 
                    OpenerView[{Times, 
                    Column[{2, $CellContext`x, 
                    OpenerView[{Cos, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 9], Pi}]}]}]}]}]}]}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Log, 
                    Column[{
                    OpenerView[{Plus, 
                    Column[{1, 
                    OpenerView[{Power, 
                    Column[{$CellContext`x, 2}]}], 
                    OpenerView[{Times, 
                    Column[{2, $CellContext`x, 
                    OpenerView[{Cos, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 9], Pi}]}]}]}]}]}]}]}]}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Times, 
                    Column[{2, 
                    OpenerView[{Cos, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 9], Pi}]}]}]}], 
                    OpenerView[{Log, 
                    Column[{
                    OpenerView[{Plus, 
                    Column[{1, 
                    OpenerView[{Power, 
                    Column[{$CellContext`x, 2}]}], 
                    OpenerView[{Times, 
                    Column[{2, $CellContext`x, 
                    OpenerView[{Cos, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 9], Pi}]}]}]}]}]}]}]}]}]}]}]}, False]],
                    DynamicModuleValues:>{}],
                    Setting[#, {0}]& ]},
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    RowBox[{"-", "2"}]},
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Cos"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Cos"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    FractionBox["2", "9"]},
                    {"\[Pi]"}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{
                    Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Times, 
                    Column[{
                    Rational[2, 9], Pi}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Cos, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[2, 9], Pi}]}]}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]},
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Log"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Log"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Plus"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Plus"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {"1"},
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Power"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Power"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {"x"},
                    {"2"}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Power, 
                    Column[{$CellContext`x, 2}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]},
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    RowBox[{"-", "2"}]},
                    {"x"},
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Cos"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Cos"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    FractionBox["2", "9"]},
                    {"\[Pi]"}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Times, 
                    Column[{
                    Rational[2, 9], Pi}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Cos, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[2, 9], Pi}]}]}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Times, 
                    Column[{-2, $CellContext`x, 
                    OpenerView[{Cos, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[2, 9], Pi}]}]}]}]}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{
                    Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Plus, 
                    Column[{1, 
                    OpenerView[{Power, 
                    Column[{$CellContext`x, 2}]}], 
                    OpenerView[{Times, 
                    Column[{-2, $CellContext`x, 
                    OpenerView[{Cos, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[2, 9], Pi}]}]}]}]}]}]}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Log, 
                    Column[{
                    OpenerView[{Plus, 
                    Column[{1, 
                    OpenerView[{Power, 
                    Column[{$CellContext`x, 2}]}], 
                    OpenerView[{Times, 
                    Column[{-2, $CellContext`x, 
                    OpenerView[{Cos, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[2, 9], Pi}]}]}]}]}]}]}]}]}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Times, 
                    Column[{-2, 
                    OpenerView[{Cos, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[2, 9], Pi}]}]}]}], 
                    OpenerView[{Log, 
                    Column[{
                    OpenerView[{Plus, 
                    Column[{1, 
                    OpenerView[{Power, 
                    Column[{$CellContext`x, 2}]}], 
                    OpenerView[{Times, 
                    Column[{-2, $CellContext`x, 
                    OpenerView[{Cos, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[2, 9], Pi}]}]}]}]}]}]}]}]}]}]}]}, False]],
                    DynamicModuleValues:>{}],
                    Setting[#, {0}]& ]},
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    RowBox[{"-", "2"}]},
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Log"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Log"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Plus"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Plus"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {"1"},
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Power"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Power"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {"x"},
                    {"2"}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Power, 
                    Column[{$CellContext`x, 2}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]},
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    RowBox[{"-", "2"}]},
                    {"x"},
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Sin"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Sin"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    FractionBox["1", "18"]},
                    {"\[Pi]"}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 18], Pi}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Sin, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 18], Pi}]}]}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Times, 
                    Column[{-2, $CellContext`x, 
                    OpenerView[{Sin, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 18], Pi}]}]}]}]}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{
                    Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Plus, 
                    Column[{1, 
                    OpenerView[{Power, 
                    Column[{$CellContext`x, 2}]}], 
                    OpenerView[{Times, 
                    Column[{-2, $CellContext`x, 
                    OpenerView[{Sin, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 18], Pi}]}]}]}]}]}]}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Log, 
                    Column[{
                    OpenerView[{Plus, 
                    Column[{1, 
                    OpenerView[{Power, 
                    Column[{$CellContext`x, 2}]}], 
                    OpenerView[{Times, 
                    Column[{-2, $CellContext`x, 
                    OpenerView[{Sin, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 18], Pi}]}]}]}]}]}]}]}]}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]},
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Sin"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Sin"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    FractionBox["1", "18"]},
                    {"\[Pi]"}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{
                    Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 18], Pi}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Sin, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 18], Pi}]}]}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Times, 
                    Column[{-2, 
                    OpenerView[{Log, 
                    Column[{
                    OpenerView[{Plus, 
                    Column[{1, 
                    OpenerView[{Power, 
                    Column[{$CellContext`x, 2}]}], 
                    OpenerView[{Times, 
                    Column[{-2, $CellContext`x, 
                    OpenerView[{Sin, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 18], Pi}]}]}]}]}]}]}]}]}]}], 
                    OpenerView[{Sin, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 18], Pi}]}]}]}]}]}, False]],
                    DynamicModuleValues:>{}],
                    Setting[#, {0}]& ]},
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {"4"},
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "ArcTan"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "ArcTan"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Plus"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Plus"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Cot"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Cot"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    FractionBox["1", "9"]},
                    {"\[Pi]"}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 9], Pi}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Cot, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 9], Pi}]}]}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]},
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {"x"},
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Csc"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Csc"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    FractionBox["1", "9"]},
                    {"\[Pi]"}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 9], Pi}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Csc, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 9], Pi}]}]}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Times, 
                    Column[{$CellContext`x, 
                    OpenerView[{Csc, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 9], Pi}]}]}]}]}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{
                    Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Plus, 
                    Column[{
                    OpenerView[{Cot, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 9], Pi}]}]}]}], 
                    OpenerView[{Times, 
                    Column[{$CellContext`x, 
                    OpenerView[{Csc, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 9], Pi}]}]}]}]}]}]}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{ArcTan, 
                    Column[{
                    OpenerView[{Plus, 
                    Column[{
                    OpenerView[{Cot, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 9], Pi}]}]}]}], 
                    OpenerView[{Times, 
                    Column[{$CellContext`x, 
                    OpenerView[{Csc, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 9], Pi}]}]}]}]}]}]}]}]}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]},
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Sin"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Sin"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    FractionBox["1", "9"]},
                    {"\[Pi]"}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{
                    Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 9], Pi}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Sin, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 9], Pi}]}]}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Times, 
                    Column[{4, 
                    OpenerView[{ArcTan, 
                    Column[{
                    OpenerView[{Plus, 
                    Column[{
                    OpenerView[{Cot, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 9], Pi}]}]}]}], 
                    OpenerView[{Times, 
                    Column[{$CellContext`x, 
                    OpenerView[{Csc, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 9], Pi}]}]}]}]}]}]}]}]}]}], 
                    OpenerView[{Sin, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 9], Pi}]}]}]}]}]}, False]],
                    DynamicModuleValues:>{}],
                    Setting[#, {0}]& ]},
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {"4"},
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "ArcTan"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "ArcTan"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Plus"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Plus"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {"x"},
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    RowBox[{"-", "1"}]},
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Cos"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Cos"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    FractionBox["2", "9"]},
                    {"\[Pi]"}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Times, 
                    Column[{
                    Rational[2, 9], Pi}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Cos, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[2, 9], Pi}]}]}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Times, 
                    Column[{-1, 
                    OpenerView[{Cos, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[2, 9], Pi}]}]}]}]}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{
                    Automatic}}},
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Plus, 
                    Column[{$CellContext`x, 
                    OpenerView[{Times, 
                    Column[{-1, 
                    OpenerView[{Cos, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[2, 9], Pi}]}]}]}]}]}]}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]},
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Csc"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{
                    Automatic}}},
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Csc"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    FractionBox["2", "9"]},
                    {"\[Pi]"}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Times, 
                    Column[{
                    Rational[2, 9], Pi}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{
                    Automatic}}},
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Csc, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[2, 9], Pi}]}]}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{
                    Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Times, 
                    Column[{
                    OpenerView[{Plus, 
                    Column[{$CellContext`x, 
                    OpenerView[{Times, 
                    Column[{-1, 
                    OpenerView[{Cos, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[2, 9], Pi}]}]}]}]}]}]}]}], 
                    OpenerView[{Csc, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[2, 9], Pi}]}]}]}]}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{ArcTan, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    OpenerView[{Plus, 
                    Column[{$CellContext`x, 
                    OpenerView[{Times, 
                    Column[{-1, 
                    OpenerView[{Cos, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[2, 9], Pi}]}]}]}]}]}]}]}], 
                    OpenerView[{Csc, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[2, 9], Pi}]}]}]}]}]}]}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]},
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Sin"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Sin"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    TagBox[
                    DynamicModuleBox[{Typeset`var$$ = False}, 
                    InterpretationBox[
                    StyleBox[
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"], True->
                    TagBox[GridBox[{
                    {
                    OpenerBox[Dynamic[Typeset`var$$],
                    Appearance->Automatic,
                    AutoAction->False,
                    ContinuousAction->False,
                    Enabled->Automatic], "Times"},
                    {"", 
                    PaneBox[
                    TagBox[GridBox[{
                    {
                    FractionBox["2", "9"]},
                    {"\[Pi]"}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{
                    Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{
                    0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Times, 
                    Column[{
                    Rational[2, 9], Pi}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{"Columns" -> {{Automatic}}, 
                    "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{"Columns" -> {{0.2}}, 
                    "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Sin, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[2, 9], Pi}]}]}]}, False]],
                    DynamicModuleValues:>Automatic],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                    },
                    BaselinePosition->{1, 1},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxBackground->{"Columns" -> {{Automatic}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    
                    GridBoxSpacings->{
                    "Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                    RowsEqual->False],
                    "Grid"]}, Dynamic[Typeset`var$$],
                    Alignment->Automatic,
                    BaselinePosition->Baseline,
                    DefaultBaseStyle->"OpenerView",
                    ImageMargins->0,
                    ImageSize->Automatic],
                    Deployed->False,
                    StripOnInput->False],
                    OpenerView[{Times, 
                    Column[{4, 
                    OpenerView[{ArcTan, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    OpenerView[{Plus, 
                    Column[{$CellContext`x, 
                    OpenerView[{Times, 
                    Column[{-1, 
                    OpenerView[{Cos, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[2, 9], Pi}]}]}]}]}]}]}]}], 
                    OpenerView[{Csc, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[2, 9], Pi}]}]}]}]}]}]}]}], 
                    OpenerView[{Sin, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[2, 9], Pi}]}]}]}]}]}, False]],
                    DynamicModuleValues:>{}],
                    Setting[#, {0}]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    ImageMargins->0]}
                  },
                  BaselinePosition->{1, 1},
                  ColumnsEqual->False,
                  GridBoxAlignment->{"Columns" -> {{Left}}},
                  GridBoxBackground->{"Columns" -> {{Automatic}}},
                  
                  GridBoxItemSize->{
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                  GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
                  RowsEqual->False],
                 "Grid"]}, Dynamic[Typeset`var$$],
                Alignment->Automatic,
                BaselinePosition->Baseline,
                DefaultBaseStyle->"OpenerView",
                ImageMargins->0,
                ImageSize->Automatic],
               Deployed->False,
               StripOnInput->False],
              OpenerView[{Plus, 
                Column[{
                  OpenerView[{Times, 
                    Column[{2, 
                    OpenerView[{Power, 
                    Column[{3, 
                    Rational[1, 2]}]}], 
                    OpenerView[{ArcTan, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    OpenerView[{Power, 
                    Column[{3, 
                    Rational[-1, 2]}]}], 
                    OpenerView[{Plus, 
                    Column[{1, 
                    OpenerView[{Times, 
                    Column[{2, $CellContext`x}]}]}]}]}]}]}]}]}]}], 
                  OpenerView[{Times, 
                    Column[{4, 
                    OpenerView[{ArcTan, 
                    Column[{
                    OpenerView[{Plus, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{$CellContext`x, 
                    OpenerView[{Sec, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 18], Pi}]}]}]}]}]}], 
                    OpenerView[{Times, 
                    Column[{-1, 
                    OpenerView[{Tan, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 18], Pi}]}]}]}]}]}]}]}]}]}], 
                    OpenerView[{Cos, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 18], Pi}]}]}]}]}]}], 
                  OpenerView[{Times, 
                    Column[{-2, 
                    OpenerView[{Log, 
                    Column[{
                    OpenerView[{Plus, 
                    Column[{-1, $CellContext`x}]}]}]}]}]}], 
                  OpenerView[{Log, 
                    Column[{
                    OpenerView[{Plus, 
                    Column[{1, $CellContext`x, 
                    OpenerView[{Power, 
                    Column[{$CellContext`x, 2}]}]}]}]}]}], 
                  OpenerView[{Times, 
                    Column[{2, 
                    OpenerView[{Cos, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 9], Pi}]}]}]}], 
                    OpenerView[{Log, 
                    Column[{
                    OpenerView[{Plus, 
                    Column[{1, 
                    OpenerView[{Power, 
                    Column[{$CellContext`x, 2}]}], 
                    OpenerView[{Times, 
                    Column[{2, $CellContext`x, 
                    OpenerView[{Cos, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 9], Pi}]}]}]}]}]}]}]}]}]}]}]}], 
                  OpenerView[{Times, 
                    Column[{-2, 
                    OpenerView[{Cos, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[2, 9], Pi}]}]}]}], 
                    OpenerView[{Log, 
                    Column[{
                    OpenerView[{Plus, 
                    Column[{1, 
                    OpenerView[{Power, 
                    Column[{$CellContext`x, 2}]}], 
                    OpenerView[{Times, 
                    Column[{-2, $CellContext`x, 
                    OpenerView[{Cos, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[2, 9], Pi}]}]}]}]}]}]}]}]}]}]}]}], 
                  OpenerView[{Times, 
                    Column[{-2, 
                    OpenerView[{Log, 
                    Column[{
                    OpenerView[{Plus, 
                    Column[{1, 
                    OpenerView[{Power, 
                    Column[{$CellContext`x, 2}]}], 
                    OpenerView[{Times, 
                    Column[{-2, $CellContext`x, 
                    OpenerView[{Sin, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 18], Pi}]}]}]}]}]}]}]}]}]}], 
                    OpenerView[{Sin, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 18], Pi}]}]}]}]}]}], 
                  OpenerView[{Times, 
                    Column[{4, 
                    OpenerView[{ArcTan, 
                    Column[{
                    OpenerView[{Plus, 
                    Column[{
                    OpenerView[{Cot, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 9], Pi}]}]}]}], 
                    OpenerView[{Times, 
                    Column[{$CellContext`x, 
                    OpenerView[{Csc, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 9], Pi}]}]}]}]}]}]}]}]}]}], 
                    OpenerView[{Sin, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 9], Pi}]}]}]}]}]}], 
                  OpenerView[{Times, 
                    Column[{4, 
                    OpenerView[{ArcTan, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    OpenerView[{Plus, 
                    Column[{$CellContext`x, 
                    OpenerView[{Times, 
                    Column[{-1, 
                    OpenerView[{Cos, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[2, 9], Pi}]}]}]}]}]}]}]}], 
                    OpenerView[{Csc, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[2, 9], Pi}]}]}]}]}]}]}]}], 
                    OpenerView[{Sin, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[2, 9], Pi}]}]}]}]}]}]}]}, False]],
             DynamicModuleValues:>{}],
            Setting[#, {0}]& ]}
         },
         ColumnsEqual->False,
         GridBoxAlignment->{"Columns" -> {{Left}}},
         GridBoxItemSize->{
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
         RowsEqual->False],
        "Column"],
       ImageMargins->0]}
    },
    BaselinePosition->{1, 1},
    ColumnsEqual->False,
    GridBoxAlignment->{"Columns" -> {{Left}}},
    GridBoxBackground->{"Columns" -> {{Automatic}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
    GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
    RowsEqual->False],
   "Grid"]}, Dynamic[Typeset`var$$],
  Alignment->Automatic,
  BaselinePosition->Baseline,
  DefaultBaseStyle->"OpenerView",
  ImageMargins->0,
  ImageSize->Automatic],
 Deployed->False,
 StripOnInput->False],
OpenerView[{Times, 
  Column[{
    Rational[1, 18], 
    OpenerView[{Plus, 
      Column[{
        OpenerView[{Times, 
          Column[{2, 
            OpenerView[{Power, 
              Column[{3, 
                Rational[1, 2]}]}], 
            OpenerView[{ArcTan, 
              Column[{
                OpenerView[{Times, 
                  Column[{
                    OpenerView[{Power, 
                    Column[{3, 
                    Rational[-1, 2]}]}], 
                    OpenerView[{Plus, 
                    Column[{1, 
                    OpenerView[{Times, 
                    Column[{2, $CellContext`x}]}]}]}]}]}]}]}]}]}], 
        OpenerView[{Times, 
          Column[{4, 
            OpenerView[{ArcTan, 
              Column[{
                OpenerView[{Plus, 
                  Column[{
                    OpenerView[{Times, 
                    Column[{$CellContext`x, 
                    OpenerView[{Sec, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 18], Pi}]}]}]}]}]}], 
                    OpenerView[{Times, 
                    Column[{-1, 
                    OpenerView[{Tan, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 18], Pi}]}]}]}]}]}]}]}]}]}], 
            OpenerView[{Cos, 
              Column[{
                OpenerView[{Times, 
                  Column[{
                    Rational[1, 18], Pi}]}]}]}]}]}], 
        OpenerView[{Times, 
          Column[{-2, 
            OpenerView[{Log, 
              Column[{
                OpenerView[{Plus, 
                  Column[{-1, $CellContext`x}]}]}]}]}]}], 
        OpenerView[{Log, 
          Column[{
            OpenerView[{Plus, 
              Column[{1, $CellContext`x, 
                OpenerView[{Power, 
                  Column[{$CellContext`x, 2}]}]}]}]}]}], 
        OpenerView[{Times, 
          Column[{2, 
            OpenerView[{Cos, 
              Column[{
                OpenerView[{Times, 
                  Column[{
                    Rational[1, 9], Pi}]}]}]}], 
            OpenerView[{Log, 
              Column[{
                OpenerView[{Plus, 
                  Column[{1, 
                    OpenerView[{Power, 
                    Column[{$CellContext`x, 2}]}], 
                    OpenerView[{Times, 
                    Column[{2, $CellContext`x, 
                    OpenerView[{Cos, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 9], Pi}]}]}]}]}]}]}]}]}]}]}]}], 
        OpenerView[{Times, 
          Column[{-2, 
            OpenerView[{Cos, 
              Column[{
                OpenerView[{Times, 
                  Column[{
                    Rational[2, 9], Pi}]}]}]}], 
            OpenerView[{Log, 
              Column[{
                OpenerView[{Plus, 
                  Column[{1, 
                    OpenerView[{Power, 
                    Column[{$CellContext`x, 2}]}], 
                    OpenerView[{Times, 
                    Column[{-2, $CellContext`x, 
                    OpenerView[{Cos, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[2, 9], Pi}]}]}]}]}]}]}]}]}]}]}]}], 
        OpenerView[{Times, 
          Column[{-2, 
            OpenerView[{Log, 
              Column[{
                OpenerView[{Plus, 
                  Column[{1, 
                    OpenerView[{Power, 
                    Column[{$CellContext`x, 2}]}], 
                    OpenerView[{Times, 
                    Column[{-2, $CellContext`x, 
                    OpenerView[{Sin, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 18], Pi}]}]}]}]}]}]}]}]}]}], 
            OpenerView[{Sin, 
              Column[{
                OpenerView[{Times, 
                  Column[{
                    Rational[1, 18], Pi}]}]}]}]}]}], 
        OpenerView[{Times, 
          Column[{4, 
            OpenerView[{ArcTan, 
              Column[{
                OpenerView[{Plus, 
                  Column[{
                    OpenerView[{Cot, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 9], Pi}]}]}]}], 
                    OpenerView[{Times, 
                    Column[{$CellContext`x, 
                    OpenerView[{Csc, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[1, 9], Pi}]}]}]}]}]}]}]}]}]}], 
            OpenerView[{Sin, 
              Column[{
                OpenerView[{Times, 
                  Column[{
                    Rational[1, 9], Pi}]}]}]}]}]}], 
        OpenerView[{Times, 
          Column[{4, 
            OpenerView[{ArcTan, 
              Column[{
                OpenerView[{Times, 
                  Column[{
                    OpenerView[{Plus, 
                    Column[{$CellContext`x, 
                    OpenerView[{Times, 
                    Column[{-1, 
                    OpenerView[{Cos, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[2, 9], Pi}]}]}]}]}]}]}]}], 
                    OpenerView[{Csc, 
                    Column[{
                    OpenerView[{Times, 
                    Column[{
                    Rational[2, 9], Pi}]}]}]}]}]}]}]}], 
            OpenerView[{Sin, 
              Column[{
                OpenerView[{Times, 
                  Column[{
                    Rational[2, 9], Pi}]}]}]}]}]}]}]}]}]}, False]],
DynamicModuleValues:>{}],
Setting[#, {0}]& ]], "Output",
 ImageSize->{109, 340},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->359644193]
}, Open  ]],

Cell[TextData[{
 "For more information and a detailed listing of options, see ",
 Cell[BoxData[
  ButtonBox["OpenerView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenerView"]], "InlineFormula"],
 "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["TabView", "Section"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TabView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TabView"]], "InlineFormula"],
 " is a rich object capable of creating surprisingly interesting user \
interfaces",
 ". ",
 "Given a list of expressions, it returns a panel with a row of tabs that \
allow you to look at the expressions one at a time."
}], "Text"],

Cell["\<\
By default, the tabs are numbered sequentially. In the output below, click \
the tabs to flip between panes.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TabView", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"40", "!"}], ",", " ", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", 
        RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], ",", " ", 
    RowBox[{"Factor", "[", 
     RowBox[{
      RowBox[{"x", "^", "14"}], "-", "1"}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->419581083],

Cell[BoxData[
 TabViewBox[{{1,"1"->"815915283247897734345611269596115894272000000000"}, {2,
  "2"->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwl2Xk4VN//AHBrITFzh1Ap2heSUlT0PpWtSClpE0JCskZIKm1IElLJlrKU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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->
    NCache[{{0, 2 Pi}, {-0.9999998592131705, 0.9999998782112116}}, {{
      0, 6.283185307179586}, {-0.9999998592131705, 0.9999998782112116}}],
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}]}, {3,"3"->
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", "x", "+", 
     SuperscriptBox["x", "2"], "-", 
     SuperscriptBox["x", "3"], "+", 
     SuperscriptBox["x", "4"], "-", 
     SuperscriptBox["x", "5"], "+", 
     SuperscriptBox["x", "6"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "x", "+", 
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["x", "3"], "+", 
     SuperscriptBox["x", "4"], "+", 
     SuperscriptBox["x", "5"], "+", 
     SuperscriptBox["x", "6"]}], ")"}]}]}}, 3]], "Output",
 ImageSize->{449, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->1298227418]
}, Open  ]],

Cell[TextData[{
 "More descriptive tab labels can be added using the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["label", "TI"], "->", 
   StyleBox["contents", "TI"]}]], "InlineFormula"],
 "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TabView", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\"\<Factorial\>\"", "\[Rule]", 
     RowBox[{"40", "!"}]}], ",", " ", 
    RowBox[{"\"\<Plot\>\"", "\[Rule]", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"Sin", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", 
         RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]}], ",", " ", 
    RowBox[{"\"\<Factor\>\"", "\[Rule]", 
     RowBox[{"Factor", "[", 
      RowBox[{
       RowBox[{"x", "^", "14"}], "-", "1"}], "]"}]}]}], "}"}], "]"}]], "Input",\

 CellLabel->"In[10]:=",
 CellID->874360806],

Cell[BoxData[
 TabViewBox[{{1,"\<\"Factorial\"\>"->
  "815915283247897734345611269596115894272000000000"}, {2,"\<\"Plot\"\>"->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwl2Xk4VN//AHBrITFzh1Ap2heSUlT0PpWtSClpE0JCskZIKm1IElLJlrKU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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->
    NCache[{{0, 2 Pi}, {-0.9999998592131705, 0.9999998782112116}}, {{
      0, 6.283185307179586}, {-0.9999998592131705, 0.9999998782112116}}],
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}]}, {3,"\<\"Factor\"\>"->
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", "x", "+", 
     SuperscriptBox["x", "2"], "-", 
     SuperscriptBox["x", "3"], "+", 
     SuperscriptBox["x", "4"], "-", 
     SuperscriptBox["x", "5"], "+", 
     SuperscriptBox["x", "6"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "x", "+", 
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["x", "3"], "+", 
     SuperscriptBox["x", "4"], "+", 
     SuperscriptBox["x", "5"], "+", 
     SuperscriptBox["x", "6"]}], ")"}]}]}}, 2]], "Output",
 ImageSize->{449, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->988521252]
}, Open  ]],

Cell[TextData[{
 "The contents can of course be programmatically generated. Here a ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " command is used to generate ten different plots."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TabView", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"n", " ", "x"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", 
        RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[11]:="],

Cell[BoxData[
 TabViewBox[{{1,"1"->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwl2Xk4VN//AHBrITFzh1Ap2heSUlT0PpWtSClpE0JCskZIKm1IElLJlrKU
Tyl7wgkpFCmVUCoky8xc65iZLL/zfX5/nef1PHPunXlv595n1B089xwTExER
eSYqIvK/VRzLNHSuu7CZV/7/6+Le8k3zYu3gdkHz8FyyCp9pObXEeIL3rXzD
z2T9o+DCL4w5B+cfVQSlkbXV+FJleswNUL2Q+n4vWb/YxSxNikmB9UYzrfbd
TIE97iqtd2JyYB0WlgVez4GbQzZ58TEY9BQfGaqGYNhUvUNmq28jXC4tM5Ix
agSvIIujeV7foOh0lU5pSzOcLD4WJbbwFyzJnvfBlN0On3u2S2c6dEFXd8vB
aqlOiNDiiRQe7AH16Y9FdzC7wXtlza1X6WwQ+r5dl83vga5jXedTC9ng7V+8
cJ14L1iniriff8uGZ+dnqhbP7IWNihu2ol42fLLXWfJoQS+ITT3iYg0ObOud
tUXXvBdiPl0zwXkccDyepiCa3Au5gbsEZRVcsGhp9tPV7wOh44mnPzwG4L9Z
PQ23HfrBnjkcUOo/AC+nDs9/4dYP1eVB2+6FDECsU2x9k08/RKtEfDsQNQAv
zPw3jYb2w9IPWWKfnwzAeouIJT1p/WC1sdu6jj0AuY6Lr0X+7oenjKNThW6D
oBJvdbLyIBsUyntqb/kMQnqFWO2Mo2wIPOEVdypoEMy+txpbuLDB8M255Wsi
BsG3STyt3J8NbWeS9z55NAg3cn3SzWPZIPW3LfNBzyC8M5Szn/uODQ5l1ruj
nYfgyj7MC1nHgTWFypSK5xD48BZG+OpzQCynten+6SEIXLD6vd02DqSl2u7P
CxsCzfv2VvMtOdBx0dn26+Mh0E27uXmjOwccdvi7z6WH4JVecP2PVOLmW2FZ
p4eBcWIjp0GcC2sa9+/QPj8MR7qacwukuSBWqyJbEjYMYU5F7Fh5LqSVJN14
d3cYeg/fLFw/hwsdSenx3JfDcCD/2inFNVxwcCp4qCMyAr+qvFavt+WC4+Dn
V6/CRsA11PWnIIcL9kHR+4ujR6A9d65jUD4XbMTNuTl3RsBft377cDEXrBWr
5qRkjUBUYvGmBpJH0w3P/c/WjMBPk4Wxy5q4sOrCdY2NUqMgPfFR3WOECytk
tldpM0ZBNcHd6hSfC0tjJQ4tVx6F18XLW3zGuaCWfuaq8rJRuA5KXw5I0MCq
de3gmYzC5ujgMzUsGvgM4zt5V0dhfXbi03XaNIzcFdXKvjEKP9/lRb/SoWFw
QVl12u1RCBUVFmzTo6FPR2f4ZuYoFDfefbMGaPhxYIGF19tREI0w6Mkzp6Ey
dVJcczoPuGzlU1ucaShfXpKwSJ4HtX6fF+12peFlrp/2XCUecCoKZ+x3pyH/
Ndt2xlIe0JKDATt9aMjsaX3Ra8yDOwtzS7+fpSFydZFnxhUeHNbyNLsUS0Pd
muZuvygeDG5PWykdT4PUurEjRvE8MGWLXL5yh4ZLG3TNu9LJ9VmdqW5JNJzZ
WrRsQTUPRs/Ln/yWQUOxYXPK4Hse7Gl3nqb+iAae8disis88mCl1RMEhmwYf
M11J+y4etF4WjazPocHNquh3kvgYvNkR07a9mIYs6+YDJ2eMgWb8xhnWJTR0
Hxj7oM8ag3IRl+xDpTQcPaJb3rZgDD7FHN+08xUNB5yLElS2joGT7khk81sa
TAKK9t46PwY688Xjzn8h3zeouc4pbAxWumyMZzWT+AWPbdGJHoOiWFWxlG80
bL6gu7opZQyeBXkpprTRsD6iSJaJx+DVcnc1w980nIpsvvjrzRikX1BxTuig
ITdqTJjTMAarb+VRvZ00aMbq9lq0jwG73CvFs5uGRYlF1ZETY5C/viZEvZ8G
h+RmfRtJPlxsuTq8kU1DaupY3sqZfJg10PPenEPD3HTdtLq5fMjdGvnfQZqG
Q5n7VRIW8UHN3TLXaoCGO49OR7tq8GFjV9kc00FSX0+LQqT0+dByPUNZeZiG
3c+aR5u38WFgVX72CHFU7ph7phkfhieu3a8doUGmSPew8WE+NAga8214NJi+
2P9J0ZEPM2a3f5w9RsOVl6e3/3Ej32fX6O6PxGKvinQvBfHB8sutU0sFNDye
SWVMhPIhUuL37s/Eew67K5y+xocfWc06AUIahFlvQgdi+XCzxkyN9Y+GBzy1
QddEPmhxmax0YnPDM3adD/lwZZnozFXjpP5vfqm3ecKHApnhmU+JDTUjHu8q
58NEluWi2Aka2EFdyrVv+GChHrKBTxxXs/nq1g98GH+hsc9qkgb9WXdHXzbz
YX/ittOZxH8chx3X/eLDev/slEHiqOc7Pz3t4cNU4K6GNVMkn1OZaNkgH57Y
qoqfIG43F8u5L+BDk53k5gTiKwk2qnPEBJBuIAx5Rbyqp/BanIwAxvQHq38Q
f13HFM5kCWDb0g5qiDjk4gmXq3ME8HjH22MTxEs/Vn8VWSSAkcCk8inixnlq
RkEaArgl66QqIA5wD8ob1hFAdvvc0F5itZLP6icNBDC++z27kbhmulZ0t5EA
eKaBR3KIvfaFT9pZCCBntebnS8TKDzrdW6wF8JM3vNuS+NWAQdseO2K5700K
xK6b72x/f1wAD7x4Nh/I76cih4qMvATw4o41+zxxSYv5EhwggM1hVOhyYoel
mXF6FwTw/fXWebUkvjJ+ouK54QKoPCBWYUecW3nYe2WMAJI/ebhxSH4OMQp/
PkwQwA2jrNk+xGK2DIt5DwSwcPvHjxyS3+xst9Lb2QIwE8hF2xNbCV6vYOYL
YCcvbF8dqY9x4/l3I0oFUObkumAlsXlHk9/ZegGcKqOaPvJJPWit6uJ9Ib//
sn6REnHi2bA9Xu0CQMFRD6xIPXKUDbQcaQGcOxx2K2+U5HdXRo8pU0jOH48/
kkMkv0ki+ytVhJA95sCUIP3R3neoetMCIRzNPWMiIP2kdUU+bdVaIdA6pk01
pN8aSwMOK+wTQoPZHJ/xHpIfmaba60eEoCZFj+X+Jfk5oKk33VkIWgaXIuxJ
P3sN/1YQ+gtB3Mq7OZX0O3OFWcPPO0LYFWc9p/AHmU/TU5g1qULoP+mjhb6T
eP8ZsnqWJYTk2OAzla00ON1PaDtfLITcm59Kc8j8KVbu61H/JoTDR7VojY80
XOcZaMj8EgLD+lB9wAeSn883PYf+CmFpfEx3aT0NM6I38CrHhMANb3+nWUeD
7fRwcSelf8D21vXIraRh7Z/vxubz/4H/Y0r7FZmHUlWrI3SW/oOG5Ng1b8pJ
PkO+MSR1/0HbiP9wCZmnkryl8zKs/8H0wfIgk1wa/ut6o9dz6x8UC48pclJo
uFA5O7gx6R98DHkqco7Md+tUD1yc/g/qZTaslb5Hg4jNLOPwgn9Q6XzWaxo5
H/Y2Hdu74ss/eDcge+ThNTIPKiQ83BXGIZVXGeXhR+ZNytYHAzHj8CZMdtOW
bTRcrWn8EXpvHIrn+C2OI+fbm0FbZcWH5PNGq5XbN9FgZHjm+oaCcZh/oXP2
fnI+bu3NOx3aPA4/Lj3P+7GI9P/axeYKcycgO3xs1WZy3q5+O31UN30CLsR3
5lqVcsFz4JZW3ZMJQM8u90YUceGpyiI3m8IJeL3/0q7iXC5ouqOf599OgLTM
whx+FjnfmYG1tb0TUHjdqEv+FhcWHe5LOrxqEk5kH3W9e4ILSvR743NFk1Ap
2RG8kOLCnZv4aC+ehKgLpkq2slxQ1skN3lszCS8zlztETyMOvJ27tIXs76yV
/y7kwGxxh3mNwknQ1JLgy3dyYJ7S2Kja5ikY7Rj27H/OgSWgnl75egoyAsaY
Z7dzIOFtiai4qwg6rPBrsa89GwZ+PQuk3UWQw7PErFXk+c9EmDHY5iWCnB8n
HOy0ZMOIRuzv/AARtEj16E69bWywiDlR4RwmghTdU59EL2aD2JG5F+oyRVDJ
pysd4z39cGLorEhMtwgKbhYRaSTPp/qqW6bUnERR49Wwg/WH+sDU5rOPg4so
+vazqlvdsg+s7h3vfuAuig4JLot6mvTBCZWo+iV+oqj9X0Lf0No+SFBsu6dx
RRR9KD727b5sH/Bn+unpZYmiM+XGccmlvZA/meW9iy2KrsYYhy1V6oWVvxhd
Z0+JoYO6w12qRX/hSRblUuAjjmR50z94/eyC4PYjTSuvSKAfe44tv+jxG7z1
9cyS4yRRcKNJ3NqQNhCmGDr0R09Drd3m92tWfYZGrwT702nT0TzZwGU+n9/C
BpMFkz/uS6GPX2WdJ0WeQa3RhiyUKI02NNrOy4l8itOf393QkS2DGllq+umn
a7DiQg0320czkNXS3EXGf5rwJ1GpUJVSWSRRl/JIp7UNF0j5ZjTWzkRxgasL
quJ/Yw1FhptDtRxaGf3ggM3LLkxH8RTWfpVHq68zO5fU/sXsgXmVmq3yyDil
qqS26S/u22PiuaxdHlXTe584t//FXbPu1Kp2E4/f+BY1/Be3Jm8IkeLJo40x
5pO3VXuww/7yYa4MA6mtcNh6zasH7zwueuT1CgbaluTU3MnsxQuvXtXydGMg
6Vrr0KYtfdjnq06IgzsDrS8UT3i5ow+/Wtzxfp8HAy1rd/ZO2tuHbV/ru+n7
MNDNtnZri2N9OEF06KF0EAOd6P9Y4RTWh6lgm9kPwxkowCLa2KG+D4t5a0u2
ZDGQ69Hxxpt7+rHlq/a97x8zkGa44p8nh/pxqnxkGv6PgYLj9QOqHPrx5qfd
kPGMgb4/l1Ro8+nHQf33gnyLGSj8L4v9MqYfDx2bNjCzhoEaP5Sc3vqxH3cc
amvd+peBtI22zLXezsayBvsz7XsZKLms7YO+JRuvm9/kG9LPQBw5+fg5B9k4
rLNOtoRmoNnWPpYVLmys5V6yWZvPQG5F00yeXGXj4LN30+ZLM9Fj+1gzydds
rJi63218BRPtkYpUz1zPwZtDm9bP1mSisuOf5CINONjFaZe4nhYTGS+LeO9i
yMGly0wSfdcykX5f6nPpPRzs8Hx9Q98mJqpq1Ob0uHPw00rFNS3mTKSulnZ1
zn0ONv3TJCjwYKKuhebPDcW5+OzKqDM5XkxkUho3/FKKi3O9TSeyfJjo7E21
rpVyXDxnslQk0Z+J3v4srBtV5mLurIzpoSFMNBmtE669iovjTAMULaKY6JOm
1H8m+7n4V/Zc7e4nTFSfIs/+84CLFYe+5v7MYaI1z4zDvLK4eIfeTZ2W50yU
cepL9vB/XJz3WlLvfQETPf1z61JnARdf+cHdnFvGRCsZZraub8mrrHyFeUg9
Ewnyaqtle7k4wOeYyywOE+1Nc7DLXkLjMDPu8Y00E22pXT0tZgWNby86fdx2
kImOs8Veea6iceHXMOeMUSaK6DdxYayn8fDG/5zWTzJRp++oe7chjT3Eh+2t
5SkU6Wpu02VP47Pfz9gHMSm0ZGxW/iYnGkcWSNgnsyhk/PeoXMRxGmcfn2XX
rUQhivf8zQwPGve823DEX41CHLNDGg+CaOwYd/5gvDaFGLIgqR5DY5+T0gdL
1lKo97aiSk8cjUONYw60r6PQvokz6hm3aZzKf7B/yUYKxeZ9lZ2eRON2m7f7
CrdSaGGkq55NJo0563bvazWkUEronrbWRzQel2uxmjSm0KYz79x3/0fjORV9
e43NKOT5NfmA2nMaH1gst+frXgqt8i1Ee0to7DIZbyncR6GISL5heCmNTzfP
t5x3gELLJb3XFJbTOD5ce7ezDYVWPgt/M1JJ4yaOlQXPiUKu0pGVEu9obFF4
b8csfwptnDN8zbOFXG/YYUoxgEJbZe/t5rfS+OLqFfmKQRTSH21TC/xO4+LH
xaqKIRTyMX/c4fCTxgtSvgywrlBocbrv769dNNb/npjOCiPxEm/kz++m8X4V
p0OsCArZbx1XPvqXxDt2qIqKotDLu5d93vXSmHdV/jYznkIszApFXBozqr+a
Me+Q/ZvuNm+nabxSLFmEmUDyUf9wrdkAje2DNdwYyRR6qLJrct0QjYNeDM9j
pFLIz9jXff4wjW/xSprk04jdlv0SGaFxndd2A/kMCiU7OTdnj9K46wljSC6L
QlaJlw758Wg81decIfeYxDfKtmP9GI11jjkz5J5SaK7llan7fBKfNM3qmc/I
/f0C48wENHb9ORI4M5dCJkIfTQ5x8sGLnbKFFDpe1uKm/I/EJ37HHdliCg1v
GZdLI25qYu6ULaGQQsGNwoXjNOYyWkRlSynkUeh7NIlYyiK1cEY5hdZ1hcvL
T5B4Xjt+YsYrCm1uK3gVQGxQs0ptRiWFxHV/nGolPiDJ+yzzmkKZN/+u1Jkk
9be1LFzmDYUmLpb/uUwcee7SZpkaCsWk70wjz9s4s9RsWLqOQv9Fhh5lTtG4
UkBlSb+n0J4G84VmxN/Xt9pIN1Bo92TS32Binu99pnQjhTbkuD7NIGY+d3kj
9YlCJ33IaUSswdU6I/WZQkrfTLd1EBuvHNOS+kqhtZ47mSPE9i7lXdO/USi6
+ulv8v6Bz6Rfvju9lUINx93yyfsHju8wt5j+ndTD73Ph5P0DP5uvID69nfRn
6YB9P3GdTVvRtF/kfqGvNn4h/nM3zX1aB6mHkpFZRcQiza7q07ooVMuOG40m
nq2g/VWym+xPevzVgVjHkh8h2UOh65ZbSjSId0VhkOwj+685p3JJPNzeXRmR
YJP4NCwPzyK+JGXxSIJLoaUJiacOEScbKdpKDFCI6fHJQYL4Reh3SmKIQt41
v/ZmkPhzx92CxXkUihL7u/kTyd/BA2bLBWMUOuEgkmRL/Dpv5VeugELN1aU7
O0n+77qxtVonKCTyKT7zi5DGEm/ef/8wRepn7ejubcQe6k/Cq0VZSF06YOcj
Uk+G3052PpNkoaC355Etqb+ctRbRGdNZyGqxte4TUp+zb6wySJRmIfsO7oUR
Ur8DRnT81ZksNCNTleVO6vtentcOW0Xi3LIVU4M0niZvObZXiYUOBnNfM4i9
3LQfbldhobEfAfmzST8Zqw9N6Kiy0JMzYXFKpP+Gonyfz1jMQv6FwXYFpD+P
9O21FV3KQm+51tnhPTSuMdKZMbaMhZJL4i2sST8njY84dWiQ/ULPxG+k/03d
/JVf6LBQzmU52wtkPuRVW1c/Xc9CnK7rJ5XbaTxPXdfnoR4LRQWMfM0k82S4
eezdDX0WMhhqLc5p+V/8A885G7JQUa9mlWMTjaXvH9SwMWahnnfC7LKPND41
vqHF0pSFzotmDMo30nh7nnCNgTkLmTWsu5X0nsYjasHdLCsWmm3LMz1STWO7
YJtYaWsWyvdzWhRUReqrWR9N7Sfx3K1qf6OCxilRE3f7DrPQzl2mwrQyGu8Y
D9lZ4chCy/58e+NRQOP7zRfyPXxZKH72De27D2jcXb36Z5QfCwlRYZHUfdIP
+T+lc06z0Eww3OWZTM6jaAM7+gwLXWZfKVC/S+P32wXSXpdYaINtk++cKBrz
X3rZed8i17dc5eroT+PNj+dH3LzNQlr1hxwNfcm8vdOQ//wuyW9j65m5XjSW
89OQGUpioYBwlxm5rjReuKon3yeDhc72m5f72JD5lGonc6qIhRTERU3NEI3j
ouTWxb1goVaLT7eT9WncElxml/+Sheqbjyn26tHY6eCcghHMQlNPpyU7atM4
kGq286thoStr1MRpdRo/vGRR4N/CQt1sOwV7URoLXQzsA/+x0Kf6iJi8F+R8
f7kC+U2wUNXzxxcQOc/vzVRW855iIfeTkp3Vz7hYP3fop4u4AmoK+SJSksnF
If8y7Q7MUECcs6tqTG5xsXgUZac7RwE9yTG7IvTgYtm8v0dGNyqgiv/2La6e
y8U2kl8MBvUV0Lb389IclLj4yf5KVc5mBVRP8Yv4TC62GE/80bVVASXErM6X
m87F0UZ7jnzeoYAyk/0UOgY4WOFbqU3eIQXUU7M4a2kVB6tO3DzsHUT8N0FF
z4E8H3XsfHE7WAF1NORpOR3m4FNvpZXKQxRQ4cCnuqtWHFx388InmYsKSK6J
dafAmIP9l3hvf3hNAf24WPwmewUHN+7arducqIAuSFgaSAyycWiaHMsAK6DW
YsV9p06zcbfJtTopCUVkY8dZ++FEP3Yws1dbPE0RndsepK3k2I9/WKzz3yKl
iMYFv6P2k+fVz/t+qgfJKqI/WmK+Fab9uNJxbWC/ArESWrxxcT9OOte2tGGx
IrIc8bCt+N6HrYpWXo41UUSpjYfH9Iz7cNWS9zDvmiJqdnyt7iDei92kMiTU
pWchfyOZHfV23bgodZFB1c1ZaHqZplupeidu2KRfvYephK74lFRX3f6J+W73
9tpHKSGtIquSt7HfcM3ulH0zZymjifZvb9WiGrHDBv3MzDhldM/fJks1sQKn
fTvr/ltVBb13ubwh8bgX1rgibBokdt1d5TK52AsXrj29SWyeCtKGTs2KGk/8
LspLZiEx0/bor+2VHnjE0DHLiZhR4KB5uMAdGz837fpLfJEr4Xn2ngvuC2fZ
cOerILpGvf7VcXt8Sje6apL4Z3XzgHStHZ7skl0pr0bu57jPKKbSllTyNKEW
8Y3Xlj1pBTZYn8e/7U1suWWN8ut7B3CUQ3vTCHGSf9aqaS67sTLj8CZJdRWk
ONnYPLfKAqeVNacpEpc+MdutWWiOi5Q/eq8ndiwt2WSRaIp/NVTJBxC/bTMS
iXZB2C0YnQ4jPiFf8R0V6eOR5WXtd4iLvVhFR5P0sNTlwicviK+tW3j8getq
HLNmrWIdsYLyl6CwlGV47q+c4Fbidw+qF9edUMMZ1zW6+ohPihmmKHkxsPam
R2b/iIe1rv/v/67y/wMoLNIt
      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->
    NCache[{{0, 2 Pi}, {-0.9999998592131705, 0.9999998782112116}}, {{
      0, 6.283185307179586}, {-0.9999998592131705, 0.9999998782112116}}],
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}]}, {2,"2"->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVmnk4VV8Xx7koma7pXmOihFQapPKL9k5IqCRDgynSIJEGKnMJTUJShiKl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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->
    NCache[{{0, 2 Pi}, {-0.9999996658276197, 0.9999993650500513}}, {{
      0, 6.283185307179586}, {-0.9999996658276197, 0.9999993650500513}}],
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}]}, {3,"3"->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVmnk8VO8Xxy1jN5bBjKVkqZQsCVHReVKhiDZLWZKkvlJUloooZUkSQiiR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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->
    NCache[{{0, 2 Pi}, {-0.9999990687548602, 0.9999987329187721}}, {{
      0, 6.283185307179586}, {-0.9999990687548602, 0.9999987329187721}}],
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}]}, {4,"4"->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwUm3k8lN8Xx+27MgyjTagoRNqo5NykEuqrbMkSUooWFApJQqhsRZEt2VJk
18ZFhLTYsmffzcxj35ff8/trXh9n5p7POXd57ttrRsr65tlLbCwsLLs5WFj+
/8qO+X737nugrlT0/9fX6tuGiw5JPLsAy9f/K+R9dh8WMpVsWsJugn/tp2uP
woKhn3plLj/sPlg0FUndDI2D1uM+pUnk3/k/b4r3e/oB/l4Ik40Ji4Ovf8+8
3+KJ4ey1da0vwz7A8bTrTT3oDwioAo44kQljvTddf6yvgbFPjpTu8kwoGXr/
q+95DeQXNuY5l2aB0f0euqF/LRwtj1+J/ZIDzAMb983Y14N5w96Q8fQCsEn+
eP/51iYInTDLiQjDMGjQrF9wugOeikapFQsWw6NYURWeig6oy/LdvO9sMbgu
WqOf6p1gOmLWL9FWDEpWaa/OinXBDVN+xwl6CVxPdc75wNINzw9f8Y8UKoOm
4NFXod97oKVF336NYRns5FjM+7vcAxIucPphZBk0K0oPlO7thZQMMep16XLY
yF0b/fx1L3zeXB6H9n4H9RiTkwsufdDJKl0waFwJ5bOMXYtrB2BrrGCUWXQl
WI+42VocGYArB+c9arsqQfStSZmp0wBMONVofLlaBYfMaE5S9QPA0ef5O8j9
B2z//OxJcfAgyH1v698X9xO2UMYcn00NwU3risq03p/Q3dIiunfzMOSuZL/b
vP0X9KIvJVYnh+GwSqAjb9Yv+FZ3Xskqehj0UlWX20t/g4+wRWWb2ggcKtfm
07hVA1jp3QZp21EQakj+o/KsBs7el8hlPBqFvh628J05NZCXZXpLJ3UUgli+
bF43WQOqiaYXvwyOQs8h+X1jTrWg8FHL6IIVHQq0Hy30h9VCycLEpQxPOjwx
6cVt2bVwX7392+NXdNjn+kq7YqIWnnP5xhH1dPDP5reMdaoD1vqe9P+AAeYl
ttueh9UBy9H2BQ4TBuyu+TYSkF0HGt7DisecGNDOcHd2nqiD1ViRLzZvGKC0
gx6o61QPZvqGdaIsTOBQ1dLTCKuHcO/OTzQxJjQfTxRVza6HY3liEa/lmeBt
Yxa/ZaIeaPrvGnUMmdAY9zNvwbEBKkZe+48nMOFdxnb3sdAG+LhaIC6XxwSv
Qh80kNUAuXOV0kPfmbCjTa26drwBnN9HPZ4cYsLK8MuQCspfqJ/wsUbzTKib
mzIsVP4LV8/iNxReAjzE0rtSHf9C66V4OyRLwJltvMmxoX/hzMkW15h9BMjs
vWT/POsvFPn6r9w7SkDNmU0z98f/QrpHSXSlOQFJlne/OFMa4aqwjc5uOwLc
bv71slduhE3nM19LuBCw5elTfmPHRlB6Rfh7PiFg7tVwjW5oI3QejS4ejyDg
Z9qxCI2sRrCysmUMxBPgUrksqTjeCNl5FwOMcgjQaTIZ2EJpgu/ZnB9qvhAg
OZD3bp1yExQ2pu7/+Y2AH+w39nM6NkFCiC/zeB0BccI/FhdCmuCu6XxfeTMB
t6VkSsYym8A3preqvIMArV3efgM1TaAnaeB7vI+ATdCh0z7WBMmCRqxawwRM
nDpIqRNqBqUTYzt+MAj4bhbRWLGrGbblb2P8HCfglf3Eq0K9ZqA+mz6oN02A
g9tpqxyHZviUZMppMEeA9g21VJ6QZqhbgaafC2T91nKE+YdmoDRUcVQvEbBk
KL4/53czxMYY+J1eIaDxJNc9HmYzdBwTNjJeJSDz8NQ3c8EWyAZ+h35SByr3
8OUotEBmuETdHKltttWc4dFtgVMTrB6hpD68ruiluX0LzMcfufmBHE9M8H1n
dmALKPmjD2eXCRhjiZLhSWsBj42qR9wXyX5NPbpuXtUCDrqqCjvmCUgccs7N
HmqBJ5dk75rNEODZfnGRm6cVtkyU7BadJMC45oyGuWwryIZEXdInCNhVBgHZ
x1thvnidJG2UAL6PO2u4L7eCVPY9J8sBAvrebaCZ+7YCz2rLDaVuAorieC2y
E1vhjT1th08bAS+fzSZyl7XCupeT+RZ/CXB81D9q1tsKF9NZduHfZP/c63dn
s7XBCFtSelIFAVtvltzllm4DWuF6HeFiApqNYrizLdsg/c5DU88PBGRrPz7N
7dUGx6d513gmE/BY/W64WRz5/pZHFzhiCFCXMdzC3dEGZnnPnZL8CRBff9TO
bLkNhAc1vIvvkfMtqJyVtbEd6N+3/bJ2ItfztACYmbaDylh22eHzZD+GF3yz
3NqhwnX6l8spAs79G/rJFdUOcd9fVasgAgTKy85nNbcDrxXF8exWApyee7hw
Gf2Dc48YF8cGmKDrb1do6vwPlvetsN1sZIKMxzmOrOf/wHqQYeFazoSWi3vD
TOv/wY8TLvoy5P5Ge+jpmXodcEDr2FcOIyasl22d4nToAInU+dLmI0yYXF95
yDS4A6xirIpVdzIhmS2xivN3BzRb2/+LYWOCYJ1p/3mdTiiVpuRypjLg+sdL
QWxbuiDiX/XaqH90UDx5RpJ1bxfsrbHOYC2mw1iLWvaqZhf4Gc8HD76mw+1F
kcaly11w6FPF4V02dHBTL900m9YFMVIWGWU9o+BXJpE+ursbjtgHPPWoHAEt
Qz4YOdoNg1K6EwJvRoB3YLpmyKAb6qjKW7bdG4En3L+m+l26IXwh5wWhNALP
tN3Vuj53g4m4MidLyDDE1zRVN2j0QJCw470PB4fA2uqbeb1+Dwzr2Z+jrBki
12EGUWvTAxP3TiVzdQ9CsoifyB+/HhBfW1CV4TsI6UZ7Tat+9IBM2K5u/h8D
8Lk9ZKTwbC/YN/PRc6EfGoZO8qZY98H9GI22hb5uICK3H3vo1AcrdySfQWY3
8OlwP7jg3QeuKjzl6u7dgNLL5mgJfcBqqtdyU6gb3jnCkH93H3RPxP7OUekC
74W9FXaW/fDDqkN8eaodlAQkfRUtBiDuhrW5ScZfCFSaYck3GQKjJvPB2ysf
wc31pPyA3RC8z1mr2dyaD1dxtKGYxxBcSk+WrMvPBa3/jqa5xA7BxcuKPZnX
M4H7Zoi+Su8QJJ90sy2yjAOfDLnkj9eG4c/bqg+aGQnYc+cFnS/3R0D97P1d
jcXl+IZztvNoyAjsv1D4PunPd2xeyBm/IWEEQjhC2/k7KrDaqfdT7mUj4BW8
u9l/vgovXpuPUeMln5vO69UK5X7jO++fjRWGjUIpe03aqGo9dpSvDC9OosPj
ruTCOtU23Hepzys+nw47ekq2fctuw0bxLNe8KuiQdkLmjKpCOz4oekADDdPB
8IKVd+qmf5ht9S0TKzBghut70aWFDhxW9/gEzmHAEEXs4jfdbswhmLo7rowB
Am23n1zy7cYuJ8o23f/LAKsrYiWfCrvx+a9Lk+qzDEhyZ794e2cPlk6+Hl90
kAme3i6uNN5enH33v/nCEiYUmb8RPJLZh7fm2vfF1DHhS+r64NDePhzBfPTn
Xi8TjNOrN/uK9WO3i8VJhzkJGF7O7j/j3o81TimfLdQinyv67+KuogFcLyny
7usfAgpXvhxqKBjEx02VIqK7COgIzV9H9A3ij+E6DzzIcz/s7a+UOMoQPs1Z
Kh/LOwbXr/79XHR1CO92W2C1kB+D7YpdTp3UYbxw0T7j340xmBKQ3cFtNIIt
KZN3vrqMwZjaL+LF3RFcXuR29JXnGNzbqKVaGj2CQ9YFNp8LGoNM1WKl7u4R
LPsnla0hfQzWXfZXOWg7ip947PqVnTcGVN9GL/9Ho3hix8cXoYXkeGJT+6+l
jOIinwqF/36NQfyC3fJ4/yg2ODhg9IM+BlLm083D5nT8efC61Nsp0m/crouN
bnS8OXx69NHSGPgY6L83eEHHIwTHg2MC43D/d8k3jj90/CBpy7ti+XGI2XTP
UvYAA2cIWa3m241DlJDUB4k5BqYWDVWFO43DGoME2VlBJr5r7/D8tts4HK27
ctx0CxNrfr+/Y3fgOMhKae8s12XiNvdY/fS34zDsJcRKi2JitENG4knWOBzL
38qi+Z6JkxvTh+w+jYN871u0UMjETsqF97ZXkfm7nzqzdjExz2BbypuhcUhy
uxZ/S4LAN55fdPIeG4eKbIWQXgUC1x8ZVbOaGwc7oet/Wg8SODZ6oVaCZwLM
81cuWRgSmEPbO3p57QSsl35nNGJFYLtZXtt22gSEPgquWrpO4H1n1y1Fyk6A
zNiAR64PgaNW47/fUZoACLW9ZBJMYJb07aHGKhPg81VN0ieSwD+5VWVET0xA
ruVpR7v3BN6dh8cmT0/AiQOWRdvyCPzC+sSXOqMJCHZx0rlcSGDrQiO9kMsT
kOCYluLyk3x/vrjwupsT0BrpkllfT2C2D631r10nQNRLtTmulcB1KdHhcl4T
cISxstraReCEeAvjHP8JWJN3jd93gMBOkZLr1EInQFDlU1fMKIE1wnpayyIn
QKAh88q2MQILP06MPpUwAXnGeUEbpgjc8/CyRWPaBFwyKkJeswTO9tgueSGH
9Hvf5Kb+AoG9nUe6B79MwJueNMHwJQKfvfH+jUPZBFgrXKccWyGwtO2NS/M/
J6Cxbtzp4iqBJy7skvX+OwHvDkjtHCN16bmJIb4Osr9VbodHSR12Jjft2cAE
6M5TEw1Iba3tcm0jMQETZ2IuKpDj7T6qqpg0OwEiFuceOJH52NQWiJ0skyD+
XIpTlvRTt/drVj7PJLDutp8/SfpN2Ol5CyiT0Caobt82SdYvg/ZVrpsEu/MH
7NoIsv7NbLN60pMgYBnGo032Q1i87GOL3CQ076CaypL96hHyc7PeMwlzMpvv
3iL7mc2rpTZ6aBLUilM9FMl+e7PxrdzSnITp7oPe58j5OLtYjZd0J4HHbTJ1
vJqsf+rpA1/DSdAdeSi88I2sn/7f0TUWkyB3c1ev4xey/n4K54vLk+Dn9ueI
STZZb1O4f6rrJGhViJ5xjSXrrTHWVvaaBCM/dbOMZ2S9VesEPvtPwn550zRD
f7K+zzHB1ZFkPbYRXdM3yfpyLpwxSJiEhOhUFcKarO+9lMi/tEmwXXj2wYRc
zz0xSRHML5PgG9y46K1K1hNhe861bBKapm7pa+wg6wnesZ7l1ySIBdyuu7WO
9P8gPYbSMQklKRNXFOeY2NomL3EvyxRcXPp7m+8DE+82d71cyDMFJc6/nC6+
YmI2owPbj1OmwFVtapPyIyZOOFH4zlh6CpRWOJny5kzcI1ee7aY5Bd7L+RJp
bEycveXRbfZTU+DejCRyRhjYe+PJ/U8MpyDqlCaxp46Bpdf8+hRzeQpU1ip8
j41j4IvjDcXF/lNQs3yRIrOXgS3dQow/hkzBd62db/6tY2Azdl3mh5dk/O9o
idQqHRuJftsQlzoFD1Z19c5U0rHWgSyXe5VTwPZ5z2cTQzpWfPBU4SDPNCSy
19Q4nx/FcnwnvykLTcPMjsFS+QOjWPYZx/kd4tMwlzWd60wbxZJJ7o/Et09D
2IsXWRV1I1ik6mrPzIlpWGmnit3SHMFzQsdf5jyahuu7nypeIs/zqUhWpXfB
00B0i1+OoQ/hcenC8oQX06Ak5vfVqWwIj+zdOxmaMg1+rGOas05D+N856dMO
FdMQbCgberd6EJfGr7Dv5J6BcOv/zGbsBvCTXQU3k/1mwNdJGeVd6cU/djcN
OAfNQJl5bH3P/l7Ms2/W/FjEDNT3r99WwdGLfQ6o6PYlzcCeYJ/V/Lge7K5R
sF26fAZYUvFnrbpubGdQ0B3DPkveY9Qmu+S68Ik7BfrhXrPwK4RNec6iBbMV
F6j4uM3BuaTMBzxNZThNUDh52XsOfHh3cOhUf8NnTa9RXR/PQXJaXsZeXIrf
zEiOX42egyzfeG2h5GKsuTMw7b+iOVDYGrmlpesj9osy27SBbR4ue8Y+7u+I
w3zOrOzZAfPw0enNvH7PJ8guNXWUD5sH6z8zZu+Xv8B5ofzOxKh5mN4oIPFI
vAjevbP7+uLdPKhc+DZ3WqYEdHvqne/9mgfvkMm7iUblEPRf8pAWZQGYmZ9C
lRJ/AUVO53fnywWgpr7hUhxuhAHuOEpl/ALIT4oUS19ogs/9EwaZqQuQkpS0
9WtDE9i8jmrz+rgAY/rWpX+LmuGj+MiQVPMC+PxrtHUKagUL7gB2G9oiSLnt
lKpY1wHv+76rDoUvwrK1Ro+TXQ88KF3vUROzCJnxLLZ8sT1gFH8Df0xaBIcW
HnmT2h5gMRM7HpC3CGbZYnrrVHpBv/6SvtzfRTB6Emi7ZrUXFko4blyjLgHd
U+2mtFc/aMVpvBkLW4KKyV7loSND8Kiy5p/3qyU4SBxlv3pjCL6PW4iLJi7B
kzRKyt2oITim6f70QN4S8Menq58YHwKN4RxX76Yl4C3cIegZOQxqe7bpUjcu
g77X+9mc+hFwN8vxS966DIJlcvFNcyPw2fdIierOZXhjG+5wf9MoHGg232+u
vgyDycoj5y6Nwv57EZLJlstw2eHYJSliFHZVcE+rJC2DQ/mNjQ9G6HBzLFzp
R/oyJD0bMozhZkDGuq12ZvnLsFfvpeberQzYeQ11elUsQ6/JyP4aUwbIUe5W
VQ0vw5nTt95lk/e6qwe5OcwmlmFNLu/niH8MSL0Yrs5cWAaJz6Yp49MMkM3P
yhEWWAH7FhMrvm1M2Go6EmOquAI44WrOFw8mXPS508zYvwIhs2bcOqFMSEjn
EvGCFYjoGWU5ncQEKZYt/ol6K8D7tNk1vZoJljuySvebrED1ds5jvB1MiD8L
y5VWK+CkdsO4iWCCRJKpE8NpBT7L3+euohBg/nv4/X33FejL1eGlSxEQPes6
SPFZgdft8eJeygSs135utj98BUxrz2kunCbA5Jb0i8qYFRBvtG7pNCP5NTqz
9nwyGTc6fn2fHQE04ufx+wUrACYn45QekvFQbDWMV2B9RdnL2CCSN/dme+hX
rgD/4Xb6g0gy3pj4orBmBaa1rOxb3pDxuy+yZVvI/EdDBhLTyfiGwF+h3SuA
NlD29OUTsK7IY2hxeAXUROZkX2DSH7u1RM0CWe9/9reMyXtrVJLBgYPsq2DC
OOpj00jABq0TBon8q/AudGN2XztZ38iBm2uoqxBL7Opq6iFg41OFwDsbVyHg
vcLU4SEyrrQ5qWfrKuAG+UYxBgGb6ijFujtX4eixLw7W5L039jZHW/6+VSjg
a8mUnCZAgjY7Lam+CnfypnzPzJHxT8NCj4+vAj2B6J5aIGCzWbv89OlVmD+0
6RPfMgHxK7+PXzBehZztR9merRAg+brEqurCKijdjcx/ukrGj+Z67LmyCo++
/ahdILXUQPKLGIdV4FSZOtNK6gT/yGzuu6twLzFJRYHU0vJPfjk+WIU/7t2+
Y+T4Cb88h9oCViGyaKOG7BIBWxwc2Y+HrYLgkPrtmv//f0PYRiIzahUWql7L
0GcI2JpndGD9m1VYtKBcdpsk48YnDXzerUJraPURd4KAbQuHbjJzVmHdwv1q
5ggBydGKgee+rkL20/9of/sJkAGppNKyVWDT+nlIkeSE5G6RYoVfqzBSPndm
oYWM+3C1RfxdBammE84H6sm4zPw0S8cqFHFEfxutJkC2alTIfmAVZgVOmFPK
CEi175D/y1yFzQa8l9K+ELB9Te1xmF2FTm0KS0E2Ac93mBbxcrCgy1a/Q+Tj
CGhwa6hW52FBr16z/Hv2nADqz1MttwRYkLe+41WHAALCb6Cpf1QWJG4fz/fI
kYCInG1y2dtY0Dbj9Xa7DhHQyBGnMriDBeFbe98gBQLEjMSPbVRkQdIO+0a+
byTgxRyfpd9+FrSh4GD+/iUmvDw8Fn7+BAsyjrlr8i6XCc1BV98E67Aggar9
HLdfM0G8qyez7D8W9O4YZUveUyZEev+tVjzHghpjZzcm2DAhquIzK/tVFmS7
lnOLsgATxroy7xLXWFBIxduICzMMOLGQPN7mwIJEmPs+ru9iwJTCs+7cOyxo
nVKEuWo2A06H2Zdc9mdB8//NLq8/wwA2840PfqSwoCNdAWG1d+lwzkV4Pv8d
CzKIUqiZMaPDh2AexzcfWFDJF9feDKCDWemUpUcBC3pjcvu/FnY65Mv+QooV
LOjmboXZLY9GwX7iHkvYAAuitt54tXh3BEr5b9/xHGFBSxs2BPkZjYD4Nrsx
OyYL0quol3q/ewS+Gxt1HZ1hQYJ/Bw2rhodBslCxeJqTFR0acbU11R+Ghked
9022saIUkdlSC+oQqG06sippw4oS0kJ+KJ8lnwdmDU7WV1iR6oKT2qHN/WDw
ynbgzTVWtKkXCfSP9oH9uqBfMs6saPUZ79VNPn0QJdr2SsGPFV36tIl+MLMX
5gSdVVVTWZFc/zaO5dluyF1JdfyPzoq27Mg8TotsB/kuob57t9mQv8qIcK1o
FaSnCl/Jc2JHf1QjTY501GGfv/gIuys7mn0pYpJlVY/N2K5vOOPOjqT13MIr
+uoxn1nFb/pDdlT48bT2v+EGfHmtx76t4ewotDA61Z5oxJIu/WzPCtjRxqBd
dnwDrfj50Y8xDkvsKPFeMcdH1W5s73DJtYiFA8W2nqyOcurGGjHCZwQ4OZAh
JfmbwvtuPD5zjSNVkANFXayTPC/Rg0+nSdl3SnAgTqHaksKVHsxDeax6+ggH
mvWSt67I6MMeHeb18n4c6ME9y1bl8kE8deJwzKVADvSl9nokmhjE17I22sYF
caAdx3od+ySGsKlP24LwCw7kIlKhP+QyhA/KmUgvpHCgp5IxftVSw3je2cCx
sooDtd+NNDG1HsEOnXsOsf3mQIVK9Xes/UfwkJYIp1odB6qhPds2mT6CmzfU
vfzQyoHeJjEDM2ZH8MeS/4ojRjlQ8BWOLHffUewiqLP2kiAnuuPkWTIYQMdM
F7mWWAonKu41/Xo4lY4vd/G+aRblRNPzHZUi38n7bE7lfl0JTkT9qcuhzsLA
+0yOW+xR4kSy41Ms924w8PvSbduv7+FER0/HOpf7M/BWBc6JZBVOxCISTglM
IPl79ZvvesSJHl9/Me3bwMBTiUfSWc9woqjqcju13Ux8bY2U6yFDTqTPlcR1
XouJ+1xZjjibcKKxgFCnMfL+Xq+NG4asONHGD7cO+ZH3e+3c2Fjpy5zocmBZ
hw95/y/d5HnFzI4T1Vm0dyxkkPf7MbWlP06ciHuTRrROAxPLnd/4ndeVE4n+
WcjeNkDywbfF4KPunMhx4myL8ywTh0V83lLwkBOlD0hLu4oT2FFNVSf2OScK
sDhbOa1P8vSN5/eDX5Lx+xPFzy0JHBQ3luMVzYn2P9xZ++kagdPY3m68mMiJ
vvaG3At/SGDVvZxnDFI5kcfOkWKdIAJ/v2Tle+w9J1J6csTu0UuShyrXMWVz
OVFwMD4T9I7ADgvO0us+kvnezB8zySXwinydEd9XTqT9w0Tg7VcCPzFXfLyI
OVGpZLjPvTICbwgOxPRvnMjrL4Q0kryXVjww+a+CE/2L/SWcW0fmn9DY/qea
E43sCBsXbSHzb4kzK/7DicS8S0SWOghsYLgYklXPie47Olhf7iP9+BmXJzRx
otWW55UGw6Sfjznzz9o4EZ2La08Fg/QzvFbRt5MT+c56hBSOk342XLN26SXH
S3heqzJN4PWnKiNsBzlRmdKPoX1zBE713Fp9bpQTrVW+96OA5OP9mV6rJwlO
tPCDuFZI8nN5d/ueQ5Okv/bjlcdJvjYQOXBFYZYTbdsc2KhP8nePZnj0pkVy
/g4mPusjtYPLeM2aVU7U+9d6eY7UKymnOFnYuZDvGxeRUFI/aXl7YJyLC9mZ
32p6T463np/rRg8fF4ot+aOru0z6UbNOqF/DhbR9+u/cXCT93ChqLBPmQv0H
x63F5glcFreeP1+MC21AwtQjMyRP17pAynouZBKi/YKYIHAXW/2tlxJciD/O
c16K5Pcbe5VSA6S50IOtziebRwi8dOlxu5sMFwrsa3whTPJ74ItBoWtyXOjT
dcXZGpLfxauOHjNX5EKmtYPuIm0ETlmIu3t6NxeSMNBTa20g/SgspcN+LuRA
i9Db9pv0Y36uZ9dBLhTwpaJu6juZv1hIR0SDC8kcDAiTKiDzT1y7z3GcC3ls
CBe8n0Hm31KVM32SCxkvPXS0SiLzPXqwsfkMFypsDHuYF0rg5I//9KoMudBy
gKSn7CMC7x054PvZhAvBI/sFCQ8C652aYERbcSFxmSfb4mwI3OF5WjroEhcK
TcpQ2n6OwNcy04zuX+VCIpUyTio6BA4QuYitHLnQZn1++2ElMt8xPHnWmXx/
2NPHT6TIfC4btmve5UIFfsEf84UJXNpSHyLzgAvZH3CWfD3JxAtxmtajIVyo
s617qIHkefXZw2HK4Vzo2Jq1O+SjmfjBaZVS10guJDvyOnqa3O88yzukORK4
0GOW5NAh8jwQPb+2Z2MOF7o/WW97hp2Jz2XxCF8sIPOxnRvQH2XgaB42jbdf
yH6fHcK//s/zBVOv95VxoT9Jccd3xDPwLmqr1em/XKhWSdb9Ccnzt+zrQ5+3
cKFbAu8ijcQZOL/0Z0nrPy50MLip8dUiHR92xFK2A1xoZtTia2QxHWv/Tuy+
P8uF0g+cknbSpONL/jetstZxoxcPr16h7h3FqZ1XQmc3caPz5wP469eOYvp+
65LD0tyIkhIsJjY6gp36DaR+yHGj6F/JnArxI9hL42B3zyFuVLM5QD6NYwRH
LXFYUS24kde6+k9PC4ZwjUOUpWsCN+oqrdj/349+LBcitHg7mRs1mrp5WL3q
xw8/+IU7pXGjh4x9Xzdd68f7mU4/rmdzo5Lrvza8EOjHMfY6e21Kyc+HHDua
cLIP211e4j7Tw40OvHuSUJ7bgznMLD7ISfOgZp4Zx/y3HfjACemVf695kJnx
yDhv9h9cdexAKormRT/nVXp3nPgNdyo8Fe/H8yKe1Bu8taf/wPaTZbmFibxI
JIEzclquBvx0/ys5mM6L8tnrOfYo14Km/qXWvUW8SPqSscPCgXootgwV2NHF
izpZc8K+HmyCAvdhB8pWPnSUI3L5xnAHXF5WnP1vOx+y8A0zErXsBLH7t+8F
KfAhTaxko9jYCbe9VwP49/GhoW60/ZxlF+wOEH3DeZwPDf+7P252ohsyIo78
nbflQ7fPWu8K4eqFpKzIAz3v+NChvPsrrRoDYLdoKtf8gQ81GUpa7XMYgF3H
JDb8zuFDth9QmUrMAHxtTlj69IUP6bjoVCvPDED96jscWs2HqH2ob/DNILCe
Ljp2ZJQPlZ/nWFfFIHn4hdd+FYIPFV/eU6svOgxPujVkd07yod7+C3IeasMg
7lzBs26RD727MHb+TcAwKEXXVI/x8aNIQvjkoc0jYD7ScyZejh/J2ruJiKiM
gvTeJI0IRX60XT0B7Tk3CkP3bPc82c2P2ltCdw3dGYXbFDr1zkF+5PvL1GTN
p1F4rDrd9J82P1KkeSip76WDnndB5bHT/EjGWK9y5gwdxH7e/XToLD9yb7TV
QzfpkHBhJUr2PD/qMkqx8Umlwyc/bovVq/yIO9/6bpkoAzxrqk5PX+dHuW7X
zeaUGKC5/gmMOvIjpWHhyk8nGVCTLiTVdJcfGQQOJfe6M2CwYV1fRgA/+nLx
Y39lKwPeS7Q3JD7lR7anDG0sxhngdCW2PCqUH6lHizp7cjNhZVE6xS+SH024
fZo0280E0S0KdhZv+dGnVYZJoDcTQsIeG71N50d2UlcnFiKYwMc2qjGVxY+O
mxXEdaQxgaX77YbAz/woeUPzz+UaJrjr8fL8LeJHLRUCMaq9TJjBV6Y2f+NH
qZzt0v1TTKDHyv7Kq+ZHfmqKAmFiBNiuefSJpYYfFfIGN4TKENBzbyBJp4Ef
BbRpbWTbT0CzWZJndzs/2vG6e+0efQL0f3LYK3TzIwl8fN+kJQG/D9kYu/bz
o8uvRX5J3yCgbP2WXYJMfnR62ffiHz8CINB747kJfiSY4TWmE0bA5/lunjcz
/Gg5OlhAJYaAfVePTDMW+NFXj8u+ISkEZDbHd6uu8qNbw8by57IIkNdi+f2Q
XQDd1TSqffqZ5LGCC59/cwug/odTusrfSP6NkHhmIySA3Ocebi+pI3mey/P+
B6oA6n1ThtJJngtz/me/IC6Artkdi+MieU+wX+3csU0CaCXtu8wvkgf9DaI1
Q6QE0IBK+leWUQLYyxZ3tW0TQPa1bCdfkzzpucd0k4ycAFJ87pKfQfLmfMJn
XkdFAWRpaj6xfZaA28LrZ77sFkBYLJu+luRn4sHdHi4VAWRDFXt5keRZu/Hm
32cOCaDz6rXDW0h+7rdU/RINAmhVp65Fj+Rhy5oXKYNHBdCuwQzrEVK3weyz
3VoCSLX8zYMxUht9MPK6pyuAgnKe779I6lqJ/GuVegJI/6WAjwY5nm6QqImI
oQCKv3z4ZhCZr2L59jELEwH0nIuF5QTpR+N6g/Jbc9K/cgO6RvotbN8jMWUl
gCagS32FrEdV9xkfXBZA/42N8S6T9eZ8mZgJsBNAnevv5l4h+6Eof7a34QZZ
r0Wo/pEBknejsv5sviWAQotmV/zIfm7ho3y1cxVApfvX1h5oJSD2rkNqnrsA
MkSdAyYkP4sP/3nO4iWAWE6JWA6S/PzsnNIDHR8B1LZ3waKHnL81lUHXI/wF
0NWXvjw6JD8HqDBNup8IIKP9J32kSH7mSDl1XCFUACntc1u6lErAgq/A5tJI
AWRrtuHlgWcEOE/b8wvGCqAv30U3VT0iYMymetY4QQA9NQixqnAnYOBoYA0j
jfRj1s1DsSagjpXHe91XATTZ1PmgU5YAZnqkhV6xAFJRP3BHRZwA3vPyhx6V
CSD6uXwLTh4CUPbpqamfAmhGeYsExwATMqzDL9f8E0DGcr6t4a+Y8GON7FHu
HgHkdZ2em/SICf2fP25WHxBAumvNWRVvMWGjSHvzO6YAGpPeZ/FWiwmPv0nr
PFoVQCJame8MGQxIvpkrW8QuiBSv1gTs+cuA0g3HOaa5BdG6yJMTT74yYOHW
1UJrIUFUR7mwPjeAAVe2ZiqpSwmiFemn/3VtIs8j38PUaQ1BdJZiPr9BkQ6W
yn/G5E8IouZZMTwiSAf3f5a/rHUE0dq4lCk1xihk7/Pxq9EXRCXHG6evp42C
5MCPuXc2gujpLe584c2jsHT83D9rP0HkldijOT5OnteTw58iAwVRb59kOvwY
hj1x7hE1QYLI6dR82IaEYbCbjf1P/YUgOi9iluCpNwzNKf0l61IFkVDFUhVn
6hDk8dxKrqkSRIOFRqZFGoMw4PGAUfRLEAkWH4u3pA2C+Hjw3vRaQaRfp5zz
dnQAPFrelwa0CKKvI2WDu58NgGbaQIfGsCDi13Iw3tvRD3U652l5PGtQp0v9
6FObPhgLOuIfeWIN+ta2Z2eWSjcoiArZWZevQckcL+72n2gAImiGuqdxLTJb
Nkh0+/ID08ckSne2rkWrocsfz+ZW45GzJ25u71iLRENzpQvf/8R9Yi+rNg2s
RU61SZEHon/j1tgDnjwza5HYzZ9L2QdrsbVx0SSTTwhd4tFYH8P1F5+yZTUv
kxNCARKdsuZm7Vj3ZXhOiYIQ+l7ZwKrzux1rV+3gw4pCaOjJu4bv8A9ryZ8t
+LRbCB2+3mVlJdWBNYgEyoeDQojv7RW78Y5OrOqq+T1SWwgJ8SnOr8R34y2P
HindtBNCa3SfRm363YedGvd6Wl8TQu6dOnVWy324eFvPT8MbQqhxB0XZSKEf
W5Sp2ak5CSGFj5ejdAP6cRTrRCKvmxC6rtXUYQYDWNjDbH1igBDa5lJl4Pxq
EFtV81598VgIcSrsmLQj+TxzfUFB4FMh1N7Zt4WLGMSnP1EMHUOFkNSmrDK5
I0M4cOZ7sHqkEMpJSuXd2D2E2RyVOVtShdDKZwerDWtH8JniDv2faUJIi+m0
IL1nBMevfZKA3wsh17JPQ9+NRrB6xgAkZwqhZW+U2h09gt1GX7nd+iiEmnV3
HTbYOoonLnGNCVYKoZQfbAJ4Mx0fyctRZ/0hhCYGNb/8d5iOQzisnk5VC6Hf
qVbLt8/TseKbL3Jtf8j+Xjrh5f6Mju26HC6lNgkhg/ik8mskn/ecb2vVGBRC
9zd8/vWonIEFDhunWA4LofT3UvnrOkh+31x/y3NUCPk9fNu4bYaB/Xt/CHwm
hJBgSZTIu61MrHTts7rynBAazb120sKdvF+f3s//3wJZf8RQRn4wE3vvym66
tiSE3hvM7vJ7w8SNU28dUlkoqPysplxAFRN73ItM2MxLQdLUlAbRtSQPXBC9
eZifgt5n8o5v2kzgP0dCD5kKUtCjjPcpUYoEluYKaIigUJBU4LuaMZIvdIc4
XueKUNDa6/G4yoTAzj+8rteJUhDi4dMQsyVwZdAdrjXrKUj1zjVRXi8CTzhM
1clvpKDY7qSZjMckH+s7xJ2UoCBhqabHFREE1txHt7eVpCCeLt03Z1+T/ES7
ouorTUG/A34J6pH8/XK+l+PNVgpakYiKxSR/l7ZdqC2WoSC2lRvyrwsJLBpv
bLckR0GluiHRn34RWN27fv/6nRR0tqhMdYzktys2/7GrKlGQVnEdeknyXdjx
6j+GymQ/ioYjsroJ/HX7iehbeyjIXPfjZrVBAg/wfbsSuo+CnKOvlarQCbyW
ob7vgwoFXZ7IvZI4RvL7n8+svw5Q0APO4pUHUwS2ztr/e+QQBf00OXyrZpbk
3WfZUTzqFPTkqXlBMMnXec6KtjKIghJe1RVhkq87jNP2aGpQUKpwzX1Lkod5
DsqwWGtSUA3in3QkeXn3xoSf949TUIjBF5EpUpuubIqM0SL75RTZOUBqn67I
S1+0KciqsMtIm9QZpaK7W3RJfyanPSTI8ZoTQ1dmTlPQa1MpQ/J5j1kfCVZT
z1BQWu76YXHSj9zVgBe79SnotuA9DSD9Guhw2ugZUpBJpMCNxkkCe+58sOuG
MQUx29e4d5A8nbp2eemxCQW9uKrtbjxK4LrxO1VvTSmI/pTrIfn8xYv1U+EV
5hQ0tMD3Nprk6a35Dtb9Fyio3jyO62orgU+/pCuyW1MQhQgsSK4n8B23K4uS
NhSUPy3SaviTwAlmfRXqlyloFFaDXMoI/FPd8rnZFQraGhI8z/OVwNOS7ZZu
dhS0d9UHBHMIrNVfP593g4L266xhvRZH4HvyQe4fHChoi+VY9YNwAmc7ai2n
OlHQ4adUh43/X28rX1miXShIX0x2qOs2ydOart7hdyiIP71cmP8q2c9AZY5g
Nwq6dZ+z7LMZgZliydzenhSUJ6Pv8U6DwFvMLQPcvSio3255iL6XwOferOd3
9qYghcNeKbkyBC5RCl5zxY+CWtiz5pt4CPxc647o6SByv3wOdb1dwcRVQbtf
nAgh5+t33Qgzj4lXGujiR8Io6LGBWNw4uT9traw27o2gINF63v4QTyY+6Ka9
ZX0sBVHPreUERSa+WcyRJBJPQZkf2cPY1zFxIheWEUygIHHDv9/Oknwt+GyP
HEsyBb2t3WYX1sjAXe82Kg+kU5D3mUjHeFcGFp1ozO78QEExRdxV3ywYWFs1
dG9LFum3OfDV7WMMnFPGqfozj4LCMk+qe1EY2O8fUz27kIIkj3PnaCfSscLa
El3PXxQUGvXnM3/eKLYydP/t+odcj3/pFarhozji1T49x1oKOkLdrrVwexSv
yqbp2/ylIN5iryi1PaO4Dj07r/2PgpRFjNN/po3gO06XrogxyPNhG14J8RvG
/jpM24MEBS0ktc1wmQ/jF1tdbS3GKQif88rn2TOM8xv9LydPk/mubwnJ/jeE
Jw++t9m/QkGtTZSDeTuH8A32SUujtcJI8GL61R2fBvDF514mEcrCSCZIcKjq
YS92us5r8nmPMEppq0nVP9WLvY+HnevYJ4zyDxnP+oj14vi5N8YyB4XRYOVP
+Z6UHtxhVmGYryGMLHgGqhO+d+Nz29acbdQXRrWPFXcfGenEp/NfaYu5CKM9
FxtPDB1sxlcmrVdF75D5Gma/6ZU14Ye75HJF3YTRiaEe7fOnmvDHtI+bRD2F
UTkdDxpbNGLpuL9jIn7CSP7cXI6yRwOeebT2BSVCGL3xaErmeluDY00e9grk
C6NEjk/ahm9LMHPJzoN9RhitRnkZ9rh+BZNzOjvmZ4XRkZKCzwftiqAsR76R
OS+M7ofo7lirWAyRdnSl1mVhFPuJN3bv5lLQbL7em8kpgjS7T6dKrJTDqxwH
bQtREdRB1HruevcLtOxcxD/tFUFOHdKqZw0aIafcqDxjvwia+khkZlY1goSU
ilOiqgiSEMtLLlBvgsmm2epgNREkdLuB46NsM8Qeu3v/sqYI2lzv/+nMdAtM
SXoMiBiIoLUbCvfb3vsHr5se5N64JYISirtUMtf3wED5rs4gZxH0xGQ1M+Zs
DyjkdvJ+cCXH+7jLUjWwB/JDDl8g3EXQqrSes+NcD/w8Oc/r4COCKuN6zJtq
emHui8MFx3AR5CqgbRLr0A/qaZsDQ1+Q46W+rKIn9MPDl79zsyJFUJcOq2tL
Qz+scVbgm4gRQcEKwRyBKgOwRXEo1ylZBCmmr7xXmhuA0/EX+G4XiCD+VOXd
tZeG4HnQmn3PP4mgwNsXXseEDkGLR+GF3C8iqO5DieDi1yGwMdmQN4VF0OEj
pjWXhIfhrnDTBedKEUT/nsA/UDAMiT6n81xaRFCeZ73rGH0ERpyWOyPaRFD1
1+3azpRRULJ6z1fwj/y8Wcrv+/tG4fNhPsvZbhGUIzBss8VjFP7MlPPdGSHz
X1vn9YydDgtXDlveXRRBr/3eej9foIP2FznkvCyClHF1rZYoA14Jiks6roqg
swtDbwOVGKCWPdF5hZ2KmnPumuRZM8BzMeXCOX4quss63fTqGwN+nwoHA0Eq
MvJN9clqZcDmeO/NemupqOKlVdaZcQYUa5p3nhChokWdB9t3bWICe5DwBZUN
VKRq+UDD7CYTDLpW1fdsoqI+2p8XX72ZkLibIaG0mYoupxQ3JYYz4XhTRYfM
FnJ8m2KC/zMTInbkFUlvo6L2RH/VwGomDLonxErIUpEvzf5UcDsT/CXvWYjJ
U9E+f7tahWUmNDvZqQvvpKKGpB3FZQIE7Cg3llijREXLO0+69Wwg4MfV3R2c
e6hoW1moTYYqAQI5g+bTB6nocMBhLu9rBJhx/j08rkZFyi11Khp3CEg3Lt3E
UKeiDTWfnvo9JOD0UvS/Pg0q+neRYzbqJcmHpwMLuzSpaGbAocAugeTleNeY
9uNUJLBVY6bwHQEhx86aN2iTftMVLZhfCeh6AYdrdKnoBZFwtLqMAOURhU0/
T1ORVreipPxPArzV1i9X6JFa92ejIMmbdUHc/76dpaIofyvdWyT/S3dPfcUG
VHRisMTWtJOAW3t6or8YUdFV0QzK9z4Cynz/eBSco6I3rg17c4YJoDZ/Ncs5
T0VUz9pCaSYBNnJpah/MqChlTOkVdYKAPI8XG99ZUNH3PVcL/acJ4Prjs5Rs
SUU3ffvF7s+RvC7l1J5gTUVfdi+9miX5O/nWha+xNlRUUj6pMUHy+Wy5bnTU
ZXJ+5Nk4bpL8riV+0CPiChXpNOi2XCf5/qWdrFmYHem3YqiISeqhr1S1oGtU
ZJvXmj1O6gNr2TYG3iDzrYrlufz/9wVWxKKvAxV55D+ouEeO15rT3vbAiezX
cyaDa5kAea4fX+7dpqI4hqSi8CIBHucKXt11oaL4l9XBcXP///1GorvzHSp6
WBuy8QNZz6blUFNHNyraIsLWhch6tXpOfXrhQUX+vLH7FhkE3K7gpRV5UlGa
VMesFNmvuPflt/u8qOjWEfnDeb3kegl9UMf3kIrKFl9I5P0jYNrl8C5lXypK
3NhVINVEgKTZ/FPjR1TEveOK7OIfAlxkHE8mPqYibC4sNI0JeM2/M+XHU3I9
rB6tFy0g/Y0NcYwHU5GXbD3L/79fseWLZfHh51Tk56+tyxtJrq/4jRI2EVRU
Q1yv6npKgJtvs3vgSyryfHjxpow3ATX/6ak0RVORWaQqZfkKAYt7BcKXY6lo
j+fFB0GmBMisr5zY8pqKjh+aZgs+RfanDzIckqhoYHcudCgRkFK1yP8ihYp+
X9vgs1OSXF8ZBVcL31KRHbspnb6W3C93lbbxZVBRxzEn40IGuV8tRr13ZVJR
wYj23O82JngdTekyyqaiIfbFuTNVTGgU3Bz9Jp+KMkSOOKUnMME7YY3IYUye
Hz8eqpedZkL6ox8OF0uoSEFw63c7VXJ/XvP7HfCNrCejKt5XigmKKisBjRVU
pG1IzK2bYEBbNYPFoYaK6LKBl6qeMIAr661FRB0VXaT5Jko4MWB3xKWvXxuo
SPI8T/WoEQP8Lf+58rZQ0Yj4eAUhwYC90z+ZCd1UdPBOb+v7VDpcaPXXreol
53fT7dg/AXQIxJppRD8VsbhquN+wo0NXwNdLaiNU5NQmXiEtR4enEu/b/06Q
54XGxXUub0Zh4MTjHzwcomi773LTWc8RsNaxlNzGJYpmNl3w3n9uBP6d3udy
hEcUmfz2/ZOoPAINhp1SbgKiSEvNhX1r7zCUXtxzd5Qqij6/PbSxGA1DzP02
2d/bRJFngWLv2sFBMCiQ9312QhQpCrRS7/T3Qc1nlrYPJ0WR8YR0uHR2H+gU
/d31U0cUueTY9Th49oFG+f12Dj1RVLnlq+eSaB/sqq/f43JOFNn96TkzjHpB
gHDvOXdVFP16dWZpxK8bvsn8BInHoijAuONCdW4baAd1aos9FUV8Uz9zVjTa
oGZ6wnBNsCjq4vp1rrKmFTrK1l1bCRNFi+3R3ttGW2DO2vZlR5QoKra/slV1
QzMoxLGNx6aJov2fVvtO2jVABO1AwuYfokhttw+v++sqsONJ5pDiFUNTxVaZ
WpXJuJrN/+lRfjHyvlElvUbgHVZYvip2WVCMvG/2nz733wdMjO/c/o4ihhLi
3weLjeTg2215OvvWi6HUEINUM7uv+F5GedhJeTGUWXUwYUPqdxxi0C/pdEoM
yRWkHfN5VY/HT1e8ff6fGJJh6jnabmrAZ0++3V1wRgytb5IimLENWFT9uuaS
oRhK6r/7tjv+L46Snbb1sxBDEtc9JkTjm3DiAseHqJtiaETxbUZRQBsuiN96
+FuoGEr/9Dbr7L1uvHVV073kmRjqCgjdEpndjUPML33C4WJIWM3sRORgN76y
Pnnf10gxJHL+oek3vR68/rmsYt5rMfSwdWkqZXMv9ngktzklSwxdsJX7wPKh
Dw/1a5sn5YihDeyma7w7+7Chpv2rN3mknws078y1/ViR9T0t/pMYWuroTqPc
7MedbjuFIkvEUP6pfzY1Owawxo1drI9rxdD+h2tWYoMGccZPPQioF0OyNgot
UZ8G8QZ5x3uP/oqhlOa7t1X7BvHUYNb8wxYxZPCPOGGkOoSTrPZMeHSLoR1m
dof42ocwj+H+3hvjYmhAl1OsQmgE384xkro+KYYI7bLesH0juJviesF+mtSZ
ms9mTEbw598FbbbzYii4mG708PUIttc60GDJSkPUITaeN/Kj+PchtfKzFBqS
/z2k5itPx4EfnRePi9AQS7j08JwWHZ/Y90H5kCgNxRyee8FymY6LFaVjt6yj
oe2b8dEfsXScI8XjOiVJQ5WqUesP8TOwQ+yR9CFpGvKMNaId3cbAChvce9u3
0pD4cMKvNnUGTqYy/yvfTkPHv2d0Fzow8Evuhu0Ru2gobNTD8uAfBjb0EbwQ
uJuG5AQFmwr7GViY9US4514aGnc6vf3PIgM/XvjEaqtKQzs/veCPkmFiT0Zc
qwqioSF1Lr5KF5Kn7FqEFDRoqCB71TMrgIlnB4RPSGrSULVJvplMNBM7dPnm
8GjR0LtptYNZmIkv1ts/afmPhtbrZezXZCWwpF5S6a8zNLQUbRf7QIjA7T87
5kr0aSioR+ma1mYCG30/cynNmIbazo+bOB4isPDRx69iTWjI0MtuTb0Wgf/g
stowUxqKlxg6U2hI8usnFXX3CzT08ea9UrkbBObc73j7phUNqa05G5Z+l8Cl
2WlpFy/S0Ipl8v6PPgQ+9H4TTdeW9ENbMLSJJPDcduNT6CoN5cYJeHO+IXBu
UsjDvfY0pGvwvW/newIrxrGPbbxJQ7dPSZeJFBJ4ZMNhGYojDaWWI5Zakq9T
XrqYcd6ioacVq+NUkr9tRDPD5m/TUL1qwr3OOrLesOFKhgsNpXgcDNjVQuB/
a7asdt8h8zWmLXF3Ejjqsdm+RjdyPiqSSi71kfXzRNj/8KCh4QsZ304OE1jE
98/rIk8aKgsTH8thELiGlbc524vs/x3e/Yn//36Cp8aaFG8aOhvm6rd+msAn
F901X/nQ0AZW+QaxOQJz3clzC/ajIa7PhSKRC2Q/ppiZD/1paC7z1aHXSwS+
77h90DWQhi4ss2kqrRBYjWm16doTGvo+yy57dJXsj90rfcsgGvLXe9DVTupg
tzfc90No6POjde7zpJYJfPclJoycnz9yx/1IXRSZc/PrcxpyHPx89CE5nuHb
L1vaIsj1XW94Z4zMR//4rWn+JQ3Zfxcc/UX68amsfiz+iobesronbSD9bmiu
B5UYsv/vvuS0TBE4e7Bt0jCOhpgRt7bykPWenO1Nuf2ahrg5fvKk0AncxUU3
ffaG7Lferdv5gwS+Iza1NjuJ1K+j7+3vIfBamaVvNSk0tMlzVU22ncDJ+zju
EG9pSNGy6Zf/XwKrHxNQWPOehiIO9Z4y/U3gazYbn+tk0lBhu2ScfhGB2W9v
1bLLpqFLi2Yf7+aR8/VQYck/l9x/D7r0KOT6qEpQs/n+kYZOtZq+C39BYMts
TfH+zzSULGVV5f2E7F+J7k/2Qhqa31Ah0eNF9qvbbO+REhr6tVXl6JwtgQvH
bIYufKMhsWEV7w/nCWzAcj3as5yGqhp8mlt0Cfxw8z2Or1U0tO3Vzu/+SmS9
5jEN++vI+aymCxozmdj1epK/YQMN6VyXschoZ+I199LVbjeS6585sej2g4kP
RxcmZrXSkLle91XnRCaOav13W6GXhmyMhKPmzjCx8kj/dp1+GlqM/VHDrsbE
lfOM9quDNPTDWVr20TZyf4uvaKaM0tC696eqZmcY2MBYQlR6ioYE1yb7PXnG
wKOXZarQDA29mUzXtbnLwN4uivcuzNHQkw3L0QUWDJwVrt4fvURDLl7Hiupk
GXhNg0UejVMchaaGZw3l0HGlXpyhoJg4evbo8Qme3FFsV9ZfxC0ujg5/UN+9
5fkoFlRV2M62XhzdwJnKdbdG8dnNnxZmNokjzos6dkzlUdzGqIvr2iaOBj32
rex8O4KZgVwjOfvE0QmKXhPyGcYhK7r6GSri6EekXEeb+TDe4/Tsa+oBcWR+
LfO1iMowvmMiGRxzWBwdoGhj06EhzLb94N5Hx8SRU5CH7oXjQ1i0/LrneUNx
xGO+BorHBvBH1dxBA2NxNJ1kdtOxbACff7+g95+JOCq13e1f9WIAxz57tEXT
XBxpe1UqOR4ewNutX1fuvCSOgm6yVWb59GO11QZhVmdxtDJyZPwFex+2PqCW
kvJcHI3GPf+mUtmFO+FM0M8IccTgEa5OetqFzY5fdh5/KY5W14Z/rDjbhY30
Q44eihFHBWOb2I0/dmLt632dv5PE0Z+4Vkeppn949+sn4jP54mhPs0Ni4GIL
ZuP9F6DZQvpVZvl9gajFCc33rnVvWoc2i33Y6GgbghX8FurHSb1hh8rJv9tC
cP4e10NsEusQb8njKqfKYFwd5MC3hdTL8mINbKVBeErzYqoNqT88uH9VKu8J
Pp6l1TdI6vgnhmtMXvnjkQARM+bmdWiN9GvOfFsvfFsl5NsKqZsP7DeeqbyP
V/oE5NdKrkPV7cUPvEo9SfLnWlAi9erbYZfneR5YbWbuhSOpdf+3Zdv+75pd
sb8v6d7lL0D+09dLa5gzCvZLCERbsypKOtRMXJ8mcThv/6K91xeJAvlzbfZu
1tyWs3+7xMVCMyCfp7j0q/ecjP0Pzh3mrwDyQ6y2BPdnJOzPqnEo7wDy/Qua
v9pvj9n/RXPvvRlA/nXmfNXEuRH7OVq3rd0J5MsHfLNenBmwf5KRsegpIP9q
flJYx3yP/TIP1tfcAvLdtL9Jncp22L+sV+fJKyD/MXPfHPECg/2G1iu9fwP5
Ovq9oPMw9gEAXXfMew==
      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->
    NCache[{{0, 2 Pi}, {-0.9999968914310025, 0.9999975297451876}}, {{
      0, 6.283185307179586}, {-0.9999968914310025, 0.9999975297451876}}],
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}]}, {5,"5"->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwU2nc8ld8fAHDz2lyXK0qFlmQlqXzlcwgNUrRUVqKUXUYhRUuSrJSyklUa
RkbLkVGSJHvved17H6tsfs/vL6/P63nO/JznnPN+ufJ2buYOXBwcHGU8HBz/
/8uNBav7tgfqbnB58NXyZqruhpGi/9ZE2UB8SndP56ebMJelZt8S6QbBpSvq
fD5FwYCk40x+5HXo+1az/dLHF9BqdKskNfIhUGL4j6Xn50KDTeSm+MhEuH2r
+VtqeimYO8u0Pol8BzzqBwv/OdWB8E7AMXuz4Nc/c9WNXPUw9sFDvKc8Cx5S
UofbHtdD/pfGPK+SbDDn+Tr+82sD7ClPWkr4lAsmZUe8T4s1g1W9Zvj4mwKo
jJfZpRzWDhETlrkxkRgi/PxKAwJ74QH9qU6xSDFc2fsuS+h7L9Rm31673bwY
Zl6bWNCE++A0w3JgTVsxvATd9bej+8D1tJDHBPMrFC9YpP5M6Ifo3Y7BsdQy
0LhsoKn3eBBaWo44iR4rg927xGTv1w3CGm8wvRlbBulDcZVbxYYg/a2UpItC
OdwpcWkMuzUEH9eWJyLNb/Be6/TGU+eHoYtToWDoRAU0ljiZtggxYH2CyFPL
uAqQqS6ka+xmgKP2rP+f7gp4sD9G57cLAyYu1eh/uvAD0o7/gj9VDODpD6gO
86uEdt7zDr8DR2H/jYvZ3MWVwD3OYbrxzSiEyR6PvsLzE36cFzlU0DQKK46p
nLJ78BNk1UM6g5SYoPStbWB7YhUobk/Zl/SNCW523yte9VWBistgX/ooE94v
5WSuVfwFiou0nG4xFuzeEeIhkP0LihXY3T3HWHA4Y+die0k1EByxL/iaWfDI
YH23Gd9vMOhvrLj2jwWt3WKl34x/wyAef71akg1nZYaCs+p/Q2m1o2OTCRv+
Kz8gqH+5Bjaez16Qfc8Gan3a7x1RNdDlZG2GKtnQ38v1SCW3BupbDme/6GJD
GMentTKTNRCtZxGkyE/AWbEVA6ISf0DP48+/fasI2Lnm8iuebX/gR5z1tXQV
Anr/27J97NIf6GKcnpc9TEDBgbtzA5F/oLd0etU2WwJCT/bhtpw/MI94nt92
I8DWEW7/qf0D37jnlSQDCNju8+zA94k/IBWwyqbzPgGCd6bFvtBqoWCTy1Df
EwI6o4805GjUwoWYr5fWpxIQnCNkm3CpFmJdCxyOfSLA6uv5DdGRtfCnelnf
sJwAjZpSxr2cWpBAcaJu1QTwda3Nul5bC1W6zg9rGwloZ/l5eU3UQuiNdRFu
nQRkLzRpO9HqQFbbuN9wgIA7QpocZzTqwHLvHutjowScWhlefty8Dvi272mJ
HyNAbTMzxORSHegpn9Zc+5cAnp37DutH1sEw9jzSMkNAs1EKfWdOHRQ+O7K2
ap6AN8c42lRq60COHnN7epGAIHvLpHUTddAdn3fl9DIBJy4XOsjQ6uGYNN/Y
NBkrB0luEdOohwcin4aqyJgzwn2Mx7weOMo7bFuXCGhMrMqb86gHEd0TZ+TI
+jLfKvqNRdTDBqHRyYQ5Am58uYUGs+vhrehOxePTBByt6uZt/1MPGTKFNKNJ
Aja36fz8M14P8064ypVNwNLIk/Dv4g3wWMrfs2aYgNqZqWNftjbAAfir7NRL
QDqf2apcswY4bSS4BtoI8Jd6053h0QBLvzw8TeoIMNsgkJYQ0QChLwrPRFUS
sFHTwSk6uwGehiBZya8EzOt/VQ/50wCTI7pd1fkE1Jit/nd9vAE8Tn1ilGYS
kGp79ZOXeCM0rQi7OZlIgK9bww2nrY3w6Ij1pFUUAesePBA64dEIh6ajYvp9
CJh5NlJjEtEIdvV6XpwXCKh6ZRijn90IiuyrgadOEuBdsSinOk6+b5zwpmQH
AcZNJwfXiTdBz/BMQu0GAuQG8zJltjZBi1WerZwEAZXcrlq8Hk1AXbFP2WeU
DYm0yvm58CZw4DqjEtjIBk/5jV/Hsprgl8hpVmUxG1ZDp3H7WBPc2SRatTaK
De6+pmdy3Zvh1euh6U5VNhxw1cngD2+GnbOm766T3+M6OyXC6l0zFM4LKjrP
sqBxP+UaP7sZrnZnMZS+kt+7TNETK6cWcB2P8jPfxwIpkdddOSEtsD6+ZfCs
IgvGOJ5u5H/VAgVb9Z5+42NByrDX+5zhFsjj1B8NKmOCYKFKDd+5Vlgj8vQR
azsT+jNXrbC63Qobd328lUhlQlGigHVOSitQHjjse8kYBY+7A6OWfa2Qo6bS
9T1uFJqPx/Pl2LaBmRaSN55lQOpfYbA83Q5vLqvuMowegYCRudvZvu0wUxHk
O2Q/AhYdw1WUp+1QYHkiYlxzBITLy05lN7fDOa/HxXp1w3Ap2t+bcrwDfkff
95jgHwa0jfkm63AnmNk+KEg+OQguhQ5hXOu6IVBqdcWx2F5Q3W8mx6nZDXut
+dWJI70w1qKTs2zQDVyZ+634RHvBc16iceFcN+TsHC36dKMHfHVLVk+/6gbN
oOozTrbdcKdszZtRjR54svSWy5TeDkk1TT/r9XsBrbiQb0vuG/XD+wXS7frh
7edjnx4cScNErKLhzUv9oD4l2dJjlIkFjfkCbYL64bPMjV3fZbMwelM2syK5
H6q3iFT+J5qHMz1gOLinH6wuJfLGMYpw0Jzm94u2A9ChcLllefcPrCYsd1vV
ehDqzUvWb9vYiA98WSoWdB0EDvr7+k8fG7G9a8fC4LVBYGqrsgtNm/DTmqee
ifHkOdZTrcLl1Ywpj+j21I5BEE04fMz1YytuXy20Z+L0EJzcwbJO3dCFQ9T+
ceSfHIaYyn5z6dw+7Ouzf8vgxWFImHibE/KvD1/Accek/Ich+tQC3WVXP953
aM8r74RheJAdc8b3Sz/mcws/sqNvGNbFrDh0s2gA33qrlFboPALX5TZWFCUP
Yc9/12qGr42A1bWhWIv2IXxW98+c9MMR2MdpY25EH8b61T6HrmaPwNcrI+Ir
bg9jTnbZzK5/I2AgsVfGznIEB6jYGH+6zoAUYQNbs2EGdvXK8RoNZ4Cxr46i
p9QotvrCm7QqmQGHi2+E1+0ZxToHX0/5lTFgztRdaU/cKJ53no3XERiFDtPi
FaV7mJjx3qTCeeUofN+UcCjDiYlbFxIn4raMQprur5DiSCb+GGq0d/HgKMzE
Ul7e7mTiK6+jxr5EkueuCG21oTMLO04NrmS/GIU8iQtdKQ9Y+ISOtuGavFGw
HL5+Ve0tC2tVdccGkOe0SPia8K9MFt4oqVn2dngUjhac3P9dkI3plnfZnbOj
oClccWRqExtPjarsAVkm+NGfS3+1YeP+bYEubipMMGZGIxtfNq7zq3+cqMsE
29CWaPloNs4R8mMu2zJhuO9Mj1g5G3tsqXhUnMoEIfsWdEOWwP0O/TeS8pmw
hyG3XKtG4ONJHM43vjNBTWAL20SfwNr0XfpohAm5wSl27+0J/PrQMRW5OSY4
1Q7OJHkSeE2IhzSHEAt+8D7pyblJYK7ll2yszILrq5REDBMJ7LnrW0vibhYM
tVuHl2USePByb9l1UxbE+L4bPF9AYIu3S+9sbFjwsmAbVi0hcOXwymfgzoJ9
6hy/pasIrLNux521gSy4aqf4Z0MDgd9aHfFYjmCBwYPiO8c6CCz3xM2yK5kF
Cue68tP7CRxZe38vzmVBekqiquwogXlEMjQSy1hgai//NWeMwN57y1Zfb2DB
Zcv7e53+Eng4sJvfZpAF59lCzw1nCXzq88Kk7jQLngi05ugtELjqn3TXGn42
lA9sd7RZIrDu1u2VS9JsQFEXchKWCZzlZJbXuZkNamd+BC+TsUKaS1KRNhua
Zd4PB5JxdPe9+wnG5L1GMqphA1mesirNO8CSDa/XtlqMzhP4yrGSM9YubAj8
jy+odobAjIedJroBbJjemnyubYrAlpVzO9Y8ZMOO5f8UKGT/q3lWrFtKZIMt
zbXRnEFgBNtEO7PYwDrb8uprH4Fzrh6a/fKVDTvtNvwybyfw+vdO/fG1bKC/
X3Kn1BM4hn3397U+NsT8ode0VxKYf3PKR6spNvBcXq3UWExg37PFqbt5yXO4
oaJsIo/AzPj28NVSBEw1/xjVeEVg6+YZv8WNBIwxq8di4gmsf3Cr+Zd9BJx0
vzH7M5DA7+8e3B1Pnnvnm88WxV8i8MaSC4rXLpL3AO73fdF2BBbckbykE0rA
26SLEn+BwP4eRSOy8QToTN8WtVEhMDuztX7hDQEehz2Mx2QIXCcnkfn5NwHT
0TOvQ8bY2Oi0WkxcNwHCRdbj0a1sXPjIONB/nIDEaPmCilI2NuUt2ZIgMAYX
qYFG76LYWMN3jtN6Cxmb7NlxfzMbOz0Onv61bQw4JJHclDAbp7yXYu3WGQM+
3zVyoQQLSxEazasPjkHpue5nJjksPHfW6W2H6xgkzZnrb1JlYVvxySufvcfA
Y9M7r0ARFi4v8t3zLGAMRG8bMrcwmThcJqTZImwMfpn/+uWZzsSbfmdw1b8Z
g4Alp8ssOhMf1R48Xskcg4Nct2RRHQN/HHKRfzk1BtjJjc2bwcBrH/0dvbsw
BnGTvkFK/gzMIHgCDYXHYXK4RyZagYEDU9dlFm8ZhwVP8WmK4wh+Sz2znH9x
HCrsw3jPNw5hyaLhH48ujUOUtrxL/PMhfNXJPdrTdxzEijf2GTgPYYNv1zdr
hIzDNstEfubyIG7zSzjy5uU4JFimHsNyg5h/qC39xfA4RL9Nvpi6vx/bfTl+
OPzcBCSX8gRe0O/GGvnSNBm3CaAPwjur8S7M9a617rnPBGg1spR4rbpwcpL1
idzgCTCEI9RPWztx781z1o2vJuDJKzPfHX/asN0Bb2dZYgL2nDpepMxsxHZN
j4IzfCbBreKJ38czP/DZ8fri4uApuMmSuJQq/hVsfcNPFIZPAf/KFjWjgyVg
yW3CfvdkCnYtjPp6BZfCcXrpqsSMKSiQmdA8s1gO+3Zle1+rmIK00NIDT7or
QTXwgbI2/1+oN3Jpm9KvhRmq0ZPcu3/hNc+Ry2tC22AqllMt8+Ff+Owhpxq3
qh3GFb6UJz/+C7EdVm+cXrUDQ1NzMiL9L+ziCFCcKO+ADgsFU/fvf0EiSs98
91QXlCQtcavw/QOxfIlOV3ovhKoXuKXd+QfToh9iiKkBqNRoGvQKI+Oo2weu
qwwC//ZpK8OYfzBXuKE7xGEQbu3aYdKf+g/cV/r7U+sHwU+/QFGh/B/EcRt/
zH41BBePFvTEc09Dt3jG8M7dI5BxvMnCRWgaWos6do6T5+agxfRvHYlp+OBa
KU6LG4EzVjuK2hSm4YuB2VLwDHk/OlfwVEZ/GkItKWyVVwzYe6XgyKMb0/CH
R/WWBzEKt3ybKu2Dp2G3fHOeFp0JJf7Teprh0/BOPevZUW0m6AbuUK9LnIZD
rTYSj4OYoBVSICyOp8EtU91vLbnve4Y23ez+Ng0DN+PnI7ewICdseu5d9TRM
G/zLszBmgUrUjhHTzmm4Rzsz1BTMgvVxBeWhi9NweXFLSMQ8C+wSmnQseWfA
/lm94E0pNiQlTeduEZmBC//qD35VZ4Ns6o7kStkZyDbNfSN/lg2n0k/IPF0/
A9KPvRP0/djw5KVP+AXlGUhRPTv7JpINEm8LAvh1ZiDZdrD0DGbD4aymv017
ZoCVprb5ZT3pyZxp53TjGfD/JtK/c4QNggU7ThudngHq9XZPNSoB+z6cqKWf
nYGQfVl2jxRIf33y2T9wcQaGcvob9DQJ4Cou2HHLdwY2LsdnOh8j4JUILW0x
aAbWjRwq1ThHgPlpZ0mf+zOgWh6TJutNwFzGt6CxqBnYKd88sPk2AS/+yY1f
iJsBh5FbK06RnjAx8LPpS5mBgyayza+TyH02ouGX5ZsZ6PBUrZQn90EDlZBX
h4rI8j3nR91LCWD69kv/+DYDpXErAw78IiC6Qveu/u8ZeHv8rIAh6Ukdqdi/
n5pmwHrHAVNb0pMDZyfPbu+egRLdvxJxpCfDsg/Wvh2eAe66l5tmSE9qLacj
xfEZMFpfbelJ7qOdJlzvns/OQIADI5T6jxz/U8vVq7hmQbX15eOqWQJUh/Pv
RwvOwsYPbXYZC6T/tovPiUiQz/svt74gPRhw08nx7qpZSPe8P1ZEenHTn/JG
jvWzsCh7Jn6WjGvWyBn6Ks+ClM3JriNkfMXZN3dScxYePl76+Iv0o9zHenmX
3bPA6OD47zzp1Qo+tfBBw1mI+bDdXY70rPuxe0s2prPQl/nYY5b0o/SLPueW
47PQFGZoOUH6sXhsd5u5zSzMVwQeERoh4ILuk/1V52dB9Hj2DQPSj7TQiQJD
91n4knJKIqGVgI8tJhvxlVk4sn+9nnQtAXab0qN3Bs6C3+06w9wK0v9enNw5
98jyqQfOuhURkFNy2mNL5CwIq9/tMcklPU7N70p5OgsfxxNFTdLJ9WFNNV3z
ghxvfYmuy1PSw5kXPz/OnIWlRxpVWeS5d3S2TEn8/Sxs3W+wYkUAAQtGa2ND
Ps/CuwLLO0mu5HrorfO69msW/C9fCl5zkFwPaqr9/xpm4c53F4rkfwTEXQs2
d++cBSNPhwBVRQJY0rvVzhKzsH/KyrN+mVzfh9KG94nPQZirldtUChu04jlO
lMjMQdc4T4h8KBs6GafK/1OYA/3zUReuXCLvLXfEklW3zcGTu/SDaTpsqPl8
5bTksTnY2jNRuuI7C64I1v14YDUHK2Wa59LTWSBnobKT79wceDlP7nS8ywL3
yR7JOe85OOUkf9LfgAXiSsbVXU/mIEh+Zr9IHhMG+RLFK5Lm4MMkU+JbBBM+
DkwczcqYA+2oeOcaFybYP3/adqNwDiqrYnU61jGhUJoxLN88B8WZ163H7o6C
Nd89bvsV86CEz6vVqjNg20C7kcnaebDQniqQ4GYAf6l6iOameSgd++qcXz8C
OQHNVN4d8zD4eO/Pdd4jwPtv05q04/Ow58NW3aLsYXjd/23n8KN5uN2vw7Mo
PASBJSv9a+LnwUSCR6SzYRCOJ7niwtR5+JLqlr4tgXSTpZTRvbx5qBsT6dcj
9+8jdQ5HlBrm4e4Big/VcADmvvK4OksugMmbXM0syz7Yl6j/YixyAU4t7TKv
cu6EuxU1HUHPFqBDhnX8YUMHfBu3lqanLAD3FRcz/90dYGjg92BX3gK8t67b
NSDYDvojuT5BTQuwb2fcE6e4FtDZtsFEUnYR3jW6qykk1IP6d76/O1IXQc5V
YkelTxmsIKqMrhcsgVzIeCRL7Rt+EoHPjOAlsJtiGK7y+46lNXP8j1Qswe0D
qxPSyiuw9NXHOZtaliDyQX1ojsVPvJLbbk3N3BIMxh07WKddg9esmP4rp7sM
6zVbGlL1GvBGkE8tKVuGJyX9v981d+K0Holi5V/LcOnWybOFTl144y1KW0zD
Mmg4duQNLXbhTT9GqU6Dy5Af7Xeh4WE3jt58ukiAhwOVdKwglF734JjcDUo5
GzjQeo8VA16/+vDT7x85uS9woPJrO67+Sx3CY91ZVwln8vnHN0YPWofw3rm0
8TZ3DlQceTMpWnQYTylH9by/woFWSq+XGfMcxqaRTl/PBXMgzYTZz4XaIzgl
88yuI6EcaFr+u2fOxRE8X3YiG8I50KHKMHOJpyM4Y3rPc+knHKi0YlqMMj2C
uaxkAyvTORCX5NODES8Z2MKbNpufyYHMBDKbUusZ+N1Dfo8X78j+uHPxySwz
sGXJlK1/AQdKMFa3XGE+ivM3/UKq3zkQj77UoMXYKHaauMYROciBdARavdeT
98MSIc8rAQwOVJ28e8t7FRaW3nBx7CKbA51RMTwXfZCFv5043r3nH9mf5Gde
e+6zsNwX1eK/vJyoSOQt374lFvZuXL+zV4ATWX760LtXho1/ESuzqkU40XHL
nE+R29jYV4EvKZ3OiW6kaU1SzrFx/d2u6yc3cKL6nkbtkyVsrPS8YdpwMyfa
/HzoZVITGwd+/OmmocKJ/jWpJagy2ViVVWAjtJ2s//oRZVkJAt+ivG2a3smJ
eLkk2303ELhtbcqhfh1OtDGpTWfNDgIHm4eTdwtOJJSR4LLVgsCdTncKXu7j
RBd4cryTzhN4+21/tRgTThQhwvnC3JvAoQmX0oMOc6Lo70pP994icG+B41q3
o5xIgYb4r0cQeOcf68enLTjRuefl8TOkJx4yjorts+RE4215Yu9fkv5brbcs
Z8+JdHqkLhNFBN5nWX/JzpET1T6pb9z2g8BHn50ffOHMia6OuVo+riWwbevc
yQF3TtR93PerTBuBnWTCfm304kQ53aU/PvaS/rOQ13O8yol8JszBd4TAQY/f
v395jWy/6OLECYLAYY17FUcDOdHKmPsfjpD+ekpve6Z8hxOtpXp6uJA+Szvq
KuYawoncOBUWU0i/5URx3nwXxoliDtQZzi0SuKg2+t9YJCcqvkL5z4X03w9x
xYsajzmRl7Zf7SIZ1x/+1HH5GTmfGRr8r8m4+6GpWV4iJ3K2dev0IX3IrO4p
+/eCnN8reVZnSH/OiHjt3JnBifJ3V0Y7kj7lOcj/+uprThT+J/fJA9Kv1NBn
az9lcSKX8MJbNaQPZX+qRi2850S95ta+W0n/bhIsoeh+4ESyNy48zyJ9rLH/
mO/1L5woZKptkynpZ93gYVbxVzL/nyf1BElfH/jud4brG5n/5M1KAz8JfJwi
1rCnkhN5hqvJd30lsJ1h8r7b1Zwo6AfbZSafwK63tn/+VsuJ1MduW20lfe9b
WqHG38SJ1IaM9oQkEPg2l+WL/W2c6MjN91e4yXyH6xFS97vI+abdsIoPInDc
jaCQqj5OpJR/54TFZdKPSxkeh5icyKHppt42cwIX79YZCB/jRJWhf1cdRaTH
/X9b1E5xIqZxZPdj0ot9c3/h2CK5nvoeohBe0o+77uXGcHKhRmvj6V2kF+eu
yG5q5uVC08e7qkVJL9Km9UVPi3KhKzyjJ5Uy2XiNVmNgHI0Lnb619uSlSPJ7
8brwt0OKC/Uw4qi9V9hYb/Jhu+1aLtS1/DPwvz1s7E60vzqnzoWKVftfjf5i
YX9V9zUZmlxI49q+G3fesnCwC3fkyE4uVDNhc+pQGAsnjm6+6qzHhQaMxXJc
jVm4esh77yVzLrStxWHv0icm3tJN7b/myYVyFmLPGPmMYtMhuRLvK1xIyOXw
FlXTUezOVk9y8+dCT5R0Ml3Wj+L3C4ctz9ziQlVX+JqmqxlYRyai3iCaC/k9
61g+JsvAJubi5ULvuVDLA8/rarHD2PWk/AueQi7UZOjNlDg3jMNttwYufuJC
G+0KZ89oDON6V7PdRCkX0l7FNQk/hrDl/Yi82jouJH123cpNY4PYuUw8LXaS
C9HvVNr+XDeAw37K34qc5kKLu55UDQ7146zarXb357mQgFKSTWBmP57qNltz
jZsbSYRa/961tR/7L0bE2Epwo/UrLIx7tPpwqBbt7qZt3Ejw2fiUjXIPfpNB
c8y7xI1u7GAzUmNa8K0GrMftw43uanCv9p9pxpZcLqvM/LiRokh6XPzJZixo
+b2aeZMb8a1cd6NepgmfE/Pfvv4RNwq+4FgRHlmP5bwHuKIKuFEvv+9wZG01
jt5TGO++wI2ivuGDLzVysZO7g08RBw9a5Vd3+d3NLKwfTzMT5uVBb4+EbPXP
yMTj/5x5MkR4kE77xM7bw0nY9JW8U9caHnQy7YdhvlsQ8Ivf32mqx4P+Y4Sp
O1cWgH+nVd2WOzzIn1NFZuxODUzt3R3vEMKDcmy/RnAq/QHnbNnziWE8qDFt
6vCzqj9w+lbbHO0xD1qR0Mk6Rq0DbaWTCnPpPIgZ4evuHNEAs15HPSp+8CBT
g75fZt6t4N617T+uah60MVPpQLtYGwzvk+DVqeVBBW6Y61VGGzSvqn3yrpUH
ta7NurPU1A6FXw8Vx4zyoBu7vB9Lq3SBt4ixmIMIL7q9YV1lWWMPsL2VWhLE
eVGriLZelmwvnOsWeNFM50UdnpvtVtv1wvHcCi2TNbzI592ShNdoL2w/aWS9
TY0XHdjMsXZwug+mUvTecJrxovNbP2lp/xsAZ1F5n/+O8SK+MhNjh22D0O/D
oed1khdZyaXd+us2CHUHcP3wGV609cCWGt2hQcgZ01n4fYkXNdzekLq3egg8
dHYaJ0TzIv+rT3Kb/EeAwzX6+sMnvKh/RWCg1usRCEscy70Rx4tW2Nd4zbaO
wCuul7JnU3iRCVenQ7oWA3orZNib3vOi2DGNPbcHGeA+56UgU8iLVmmuEhyi
jsLSltrjgp95kUSlRFCK9iisehiCmaW8iP9KZJRq6CgcPTYfnl3Hixp9pAPs
NzGh986J8uQmsnxT3mSwCRPcC3Nno9p4UdQV4wRODyaErnK28+7jRW4bW+SY
BUwo72nf9t8kL0p7tyM9bDcLjkrsclSeJvvPzbq824oFvQaP4lbPk/N7btXS
Ln8WLKUf5OXgpqBjJrnWMoUs0HItaiyjUZAroVBptYkNZYkrhfKlKEhlwafz
nB4bzP94Q/pKCsrlUdtbeIoNrppqGfcUKChZxyJ36302LDjcb/fdSEFdW26H
WySzIeTxENVZiYKEI8K9ygvZkD6XeNVUg4J2r1j3n1sf6QHlhTegRUFRs5nS
mdNke1YWveraFPRlRnZGSYiA7mKqsYQ+BfnnvxuaUiPAdcL5Oo8RBYle9ZfW
1SO9su5H7t/9FPTf69DQH2akv+4GyjabUVDDz13Zqe4EpBV2HP5xjII+FF5P
+0v6RpOx6/bHkxR0LtjG8Q7pn5JVMR8yrSgo+/j1lBOxBBw+OMGKO0NBdSNi
IhdSSX8GmCqEOVDQt5Bqi49ZBDhnvTp+/QIFUUooe4w/EXBP4iw+40FBZYu9
/5SqyfYN8aS5FwVxuE8evEr6N817laLBVQqKFTppTSH9q5nhY7n9GgVdaNeZ
+9NPtt9SF74xkIK0jlrPtDHI9oXUy1fcpqCVhpKa68fI9nVCZ/nvURC1+OCD
V1Nk+67DKnOhFJTSFDnsSvpzLtHAbjScgt4Z8ap5kD7Vnd4dufURBQV7RU81
k34NNN1R4hNLQd2T2NWS9G1ZqvrEl3iy/ayPkfNkzL+4WYEnmYK8+eiW+WRs
fHSd+YE0CnrT+7kqlPRzWKZsUPgrCtLNXGQGkL6u5ZLKaXxLQXmiN36Gkv6m
nxLrlc2loNMx+6/l/yXAIpufdraAgraLf169QPY/jp9L/+UnCoqvia62In3f
ZTPvQWAKulEwWtBGjl+hYOr59jIKQrIa/N4dBJwTZf/xq6AgvWtbp5QbCHjp
MMRZUkVBpvyCBRxVBDA/d2/l/0NBYVPqkeNfCVCXbD1j2kBBAe9cfy3nE3DZ
qS4iuoWCMtvb87dkEpBfUvW1tYOCTin2J3slELDbA8ufH6Qg4nXHpH0QATcq
Cs3eMChI3VJKXugyOT9rcwIn2RR0NdCtp8aOgAPVKT3XpymoPvnv2Gcg52ND
gvi3eQoqV/LU7lcm4I//Yz1hDj50yuidkIoMOf4tIc+f8PMhltahgA0EGxyC
3c5ky/AhqZyzoSXhbMjocoyYXs2HVo451lB82MDUsvu6W4GMV8y88bBkw6WB
o/KVSnzIfOUdjaL1bLihr93T+x8f8uZcE7cvkwWlsdvENyM+pFX3+HNTCAso
48p6bgZ8KLKCXzj6AgseJK59Pm/Ch9aeV558vJ4FTxd4zkha86EKvfX7hsOZ
0HlkKfyUHR8aF3gpu3CBCfKZ08VJ5/iQ4IyniqE+EzJOMuRU3PiQtpe8j9/Y
KOTl/+42vMGHpjaFCMbuGYUa96e2Psl8qM29TOVN+QgohVPnPdP4kIfJN7ZI
zAjcfHfn0aVXfMgp/9Xt3w4joMW+VOmSw4eyjexHrnKPQLyTsaZ9CR9yG5k2
frBjGC6eW+Az6+VDgf9NVVTcHAQeS+t3Sgr8SOXQx/zV+b1g7Ve/X3EjP7qs
8PfDeq9eKHh6oH+DEj867HRytHBbL1xs0ZKR1+BHz/h273j4rgf+HBe7uUKf
H9VGvX4ul9wNCWbFx3ns+FHdM3PriOF22LVXYanjOT+5n4QouWXXgeaLyuDv
qfzopgcXy1S2DlSXL0lkv+RHq+8fcPl8p5Zcn6WKt7L50fbcsWTTU39AaBPp
7a/8yLTmU5L97C/ooGRkeHfzI3nR87MKZ8sg8JvKEbG1Akheyi15bsc18Fdo
7JhREEBb/K3WFVWfxd4BAY69GwUQ9+3U77o3g/FFrd/X8lQF0Gb5v0elaxLx
kTT3jNO6AihNuW5lVGE23nAndzHdSgCta9PZIPWoBP8w3JWB4gRQTfoPfKu2
Fl/5HqB6PUkABT0wzr3lWYcV95e9/5IigNzoN77O0+vxHZNDX7XfCCCvPlOP
3ScasMERh1bNIgFknjzfEFXbhIttI4Q3dwugzxPzTcUZ7di9tzHyfL8Ayv7+
FzahDrzWXlYmbVgAZQ4XNODGDhxwPn3DunEBdHgqi9OHswvruH7RXc0liB79
Z3nZMK0bF/iNuIuvF0Q/Fh6297f24nOLqtOHFAWRG8u0ecfaPix13fNamLIg
2sU3bcRztg97Bi3fE9ouiIpFgoS5Rvqwxj36C14jQaT47NesFbsfv43Ra5g9
L4h0qPscBDsGsbX03dM7nQURs9gtYLX0EBZ5WtXj7S6IvmvIrwgzH8LO8SfY
k1cEkVVwlXVg+RBWSnHhY98TRKvN551uvRjGqdmxu3ozBVGQVgHljS4DX5w/
rdT8ThA9/5o0+NaJgdUN16yqzhVEHWzzbtEnDPy5OXnhwydB9F7AeKCfzcB1
y5k44qcgcv015VoVPYqf7HfNuvtbEF3kfvxf8udRbB2l/vxanSASvaUnXt03
ihkb84IutJH1i6StWq/OxJymRYZ6o4LosdEn16xiJv72+IbWDkIQRTic2Ly6
j4lDe/Q3qUwKomMs3+5mHtLnXt/5ZeYF0VxoqYi2EQurxdX8HBMUQq4LOQ0P
ill4aiDy86CoEHr17USFZQcLf1Q79qadJoQWHol89JxlYaPSlrCKlUIo/ZcP
21+Nja0YvWZJSkJoLprR3k76QkEzVT9GVQjJSSiN9rxk4+Fr57eFapD15WlL
bClmY09xpuQVbSHE/5MWdZfBxtqn3/K66pLvlxsOxS6xMUeq+7+z+kLoneIm
U7Y4ge/v/Nt06IAQkrD/EHBai8CHgwoqDE2F0L0P2y5c3ktgqaqrH/4zF0LB
P6fSf54gcLLN0tNNp4TQz549Mf+RPnd8WXx/tbUQ2lNvet+c9LnqZJC/hJ0Q
8m9MsMkgvfbhDp/18gUhdH+y9qzYKwIH1Pww/esihGxbVJfW5hHYYGUojHoI
IZgtMXHFBBa0N1Xv8RJC7RcdqXMVBK55Q5VvuiqEdtsliZb+IXDMdK34r2tC
SC3mkfiPFgJb6j3iKg0UQkohq4eFegiscP/EZOFtIRT16YPD/SECD9XL9L+9
J4TO5Tyx28si8Os17fUpD4TQzr8xn2CCwJccE8qfRgihq91g7vmPwDtzbPPD
HwmhLWeqhQdILy/NK6TfiRVCBZEqjRGkp8sMBx77xwshRTQb70t6O+RhevCl
50Lo2b4Ai0TS44dbLlx1TBVCjMGPS///fy59nfJF65dCKKXdOiyOjMMj7x9/
+UYIOZofsjpClhfkGtWfyhZCVYoXeteR9d/2OKAG+UKo6cZ5FVGyfY6el6tC
PgqhDekBR2mk1/0OC/A3FAmhlZ6nPdVJr//DjlNrS4WQ5zWFLEcGgT3UKrov
fhdCp2Tctn7qIzAzYdOvvJ9CqEvDXFGxncDnRe9+4KgRQgJjh3++qyNw77XB
VON6IWSx+ewJ80oCW7EMI2OahdBizrgYtZjAzZapAT3tQuixT73uyHsCH6ni
cVLuEULv7Q9rdmYQuPo/+xM+A0KIezN9L/GMnJ+V69RF2EKoeUQXzl8nMIQE
yVpMCKH/tnFNVLsR+ONsD/+Lf2T/NpVbHrUhcFZzUs/OZSF06Y30fx//I/CW
fRzVN7mF0eUk5ttnigROK7D5WM0njN78hLY4SdL7MWui7KnC6IXI2Rcc5Ppe
QQm4/k5SGNkeHfawr2PjSK8OpzlpYfQoytSa8YmNg4/GGYTLC6NzMsPaNiHk
90Fb+e+ThjDKDM3m5VzNxkTg1V7KDmEUerMq9t4yC18cb642+08Y3afkI+0e
FrateZw+tEcYVXu/274imYVNwugnJY4JI2Pzx5ItMiz8fdHT0PqkMOLaX+P8
6S8T67vUb31pJYyk5FaZ/aph4p0mUYJwThhFBPKO3rzFxOsExT9f9BFGbbbM
/lO9ozjhqntGnp8w0r+49W9TwSiWHvkdzXFDGLn6ZwU+CB3FohVhLjHBwijj
iNVk2rZRPHdbeG1JrDCKtf+QmX+FgWs5+YNkPguj40Z51d5dw5j9Jtb6cLEw
yuOpPijzahgLnNry390yYURkWmZRPYcxyjGdmqoSRvuHh5a5KcP4rd2jczUd
wuhWo87wRoUhfL9UwfjusjDyWv3E+ovOADa4vVvyr74I+jYUPszF14Ntt/4e
27JXBGmpd29zwt3Yr8P2l52xCGKG9Jva+HTjnO237tQcEUGnDo6EDvzswnKD
lTOZ9iKoYLbx4IJfB14wsuiwuyOC1JBfb2N+M87jv5xW80MEfShee3LLhV94
0D+QVfRLBIUvq1z5rlWFpccfar75I4LCKLqmH7h/Yv+W1yX3WkSQx/0N0p+e
VWCDV4Od+iMiaN990SKu8lJca3xqRR6/KJL6nF1Lo7zHY2F6wbF7RVHPGZWh
at1cUOA+/PuusSi6zy27uSA7D476WEt5HxJFzVYv/WTXF0KhjV+K+QlRxKmZ
umcd3xe4rp5XLHReFF2WEXHQtysF0VrF2Wt3RJFYjs79Hr5foEynXrQrF0XZ
4/Gbi7qbQOLdp9epP0SR7EiT8bOAZpjbd54Y/kX2xyEuonJVC1T4F3m6NYqi
Qsup1aJHW8G+3/m6/5Ao8nge5571qR3ic39ExwiIoWDRfd8bs7vh1kGvphYR
McR/aOvP43Pd4Dwkt3I1TQz1BHEctNbvAe1VVxJfrBRDsi6ZNfM1PdAYtPFV
1hYx1Nf6t3zXcC+Imt/ElQfF0J0fpR8lF/vh76gql6i5GFq0P/xt/e4BaL/d
amB2XAwlpu4TT/AfgFcftlY2WYsh6IyyKZ8dACP57vp+NzF04vnHF/nMQQgY
02EsRYghJ7vLQVm5w+AQMqysHyOGRl1jGCEjw2CyPtrt9lMxdFB99/X3a0Zg
pcXolNALMXSkIe0gcWcE8nHssvR7MbT1+/SlNlMGEGH/JLc1iqHA1aX61p9G
gTm2pkSlVQydDzzOU9Q7CgzzvW6KnWIo163e2EOACf1ST36sHhRDdWL7c6uP
MqE1YVcA/z8x5PWXAxv3MaGZw24L95wYojGrXFR5WdBgF9K8uCiGLn1clWC1
kQWOUS6xs1xUVHIl3jzhHAvsThRNsgWp6KJyVmZUJwvOBJsfYApTkYJv/XDZ
HAtsPwwmjYhS0fmd1wp1pNhgtUrMtJ9GRXy79jkvHmCDpcmLlB5JKkqRUBA0
tGfDqWs75julqGirx/SbGn82WHTZZLSspCKmfefr7Ew2HKdOLTXKUtHCtoUB
3hI2HNMLPla/hoouz2r2PGsivf4ii+u3AhXFhtwVvs9BgFm9wcmq9VQkvOcS
9EmQ3uRtefdjIxUdHVmr7beRgIPnOa3KlKhoedd57LifAJMnj3K/KlNRxJkZ
jy8nSQ/92CyIVanI7iXSOXyBgH1bzAs+aFBRHNvymeodAowsB0UKNKlI0jf5
2tUoAgwf+Nq/16Kia5F3aJxJBOgTyeLvtKno8N9BhXLSa3pyOxxf61DRyr4o
cU7Sc8jsZ9FLXSoKEjKIvVJJejbIhp6OqOhg5IXrW+pIv+VOOqXoU1HlT60w
mTYCdPrvljw3oKI79xKj9XsJ0KbLyiQaUVH6/lPn0oYJ2GWU5Ra3j4om9/W0
GbAJ2Olj8C32AJkPn8u1qycJ2JHRLPvYhIqGD9KVt04ToNXifDnalIrOhET8
DpgjvS7IWRlxmJyPiqsZFNLT2/57JPfQnIoGuTelV5A+1nDe7BN6lIo+Tn4o
LiP9rB7/5de941TUa76KmCNjtWqz9XctqEiDe0HdiYxVlwd8b52iIk6phnt0
sryyuu+fQEsqKswf4pwj/b7ljKjidWsqypvWSZMmfa0UmRzgb0tFHwJTgz1I
XyuWajVctaOitxs+YJ5xAjZNVW7xsacixuHGc7WkrzdusAnyPEdF42flE1oH
CFh/fLLZw5GKno/eDFndRcC6u3fV3C5SUf3nzGPPmgi41KgZYOdMRd9Putdc
/01A8YbeqmOu5PgtWVrp3wgQ83q4ar87Fc2fLvgi/oUA6zKdizqXyPUdUx6P
cwh4I8EoVPOkIvt4d8nsdAIW7B7zrfMm8zPifnbwGQFPOSdSBHypaPTK5vTV
pLdHDidOLvhRkfjUuu1ynmQ+kkz0x65R0cOYqV/nHQho1E3vagwk13vThaDv
hgRsCDuqWnmTikQ2C57q1iTAs4Pz2pfbVGT0+vJ7WEcAzd9yZco9KjJ5KBBb
t8iGMz8FLjy+T0WWB1I5BRhsyFpZUBDygIp0S/te3mlgg+kH8WMeEVTknquY
avmKDSH/vj3UjaWiau7H6YHGbGgx9Ozc+oyKbpatOMynwQbFR/IqG+LJ/kRO
XmtZwYZv2/wrhZ5T0efvh9odeljA5bGVtyWDivQPnX2j7swCs+LOI1WvqMhM
TcdF+SALksRCk/FrKrqX+YnLV4UFum8HIS2LivZPm6eIMJngO/rM93IhFe1Z
N3BS+QwTJhwoYyIVVGRTW2fAqTwKenm5upyVVITkt1v5cY1COM+ZB1M/qUiR
5s842swA1ReflNp+k/k788hMKYgBF7vdHTKaqGhOfNVz3+oR6D3V1qo/REW2
838iEw8Mg/DuE+m2I1Rk/btGRU1iGLavrbscMEpFnr8FjaXahiC4r1L4I0FF
m1SVto07DoGa80fdrTNU1GajUMF7bRD8r8UmrxUQR2I2Gxulg/uBnnTi4oKS
OLocNC6lqdVNfq91WitVxBHXlaagxZYucLQ/xL1TTRwdPreOlWvUBZ8V98Zd
3iaOvvjOKkSv7gS7bK1qxn/iiHuDgGH01zZ4W0LXaDERR7Ov3Hl3DDbCvoG6
2TxXcSS8Ln1a98YPuLYlzO+duziqncyvOX6gAnI89i1mXBJHQo0zr1slvsOq
pc8ccd7iKEWslcMgtQzYUml8QQHiSKpZOLjlFobofVfopmHiaHef3M9LOenQ
nSm7dfAN+f63chupmE+YPtGY0/VOHE1UBEpMCRThAzsjNFuyxdGCopXdA91i
nFvGu7Mqj2xvv1PhzawSfKeDrZvzRRy5SDGfd4Z9x8piX00CfomjOJFnly4+
rsFXLjk4SrHEkcLZggMu/S042Jh9Xpsg+6P3uCLzRit+vN7nvPW4ONpw0fSO
smwbzm8MPpf2Vxw9Zhid6Tvcjie1X9trLYmjMxeR8tusTuzKPWl7XIyG3OLL
5Hle9OBr7X62vuI0xJTg/KnF6MGheTy2CRI0lBV+Wn1EvRdnnpeyGVxBvn/w
7IHyz714+OcuK285Ggq6F7N3fXUfPht942TMVhpqoSb5NDYM4EsuAic/bqOh
Arf7M2slB3GQUaRF53YaYn9dcPhpNoiTZl6c2KhNQ6HtZev1fg7iTsvvx/L1
aWi3ynruq/lD2GKDqHnjERoKGPqwKst5BDsuxZjNHSPr69oRfCRpBPs0rTVb
Y0FD5ucrfaFuBMfc23r4nCUNrfPhNhzVIn3NOmr6z56GvNefb3D6y8Cm+c8O
SHnT0NOw+STWQSZ2nLRbpl+hoUajnv6eS0x8U13pPd2XhmIDTj1c/5iJC18V
rqYH0NCAwmhkRAcTKyQ2jEncoaHNNzJSJ86wsE57XKpEMA2dSlxjph/Iwidk
7E9JhNBQt7Pez5ZEFg6NmiilhdGQdt9GzY5WFv53V+yxeAwNle5WoynsY2Nq
eaOx+BMaqkm7fDDuDBtv4UrgEH9KQ2oSfzotfNnY1l/5IjWBhrivfk+IIT3t
+2FyDTWJhu43eaVJkZ5+9O9jnVgyDT3XdMtvbGDjSvf9u8XSaKh3uK5ecpmN
+99QJ0QzaGgj+t4TQSPwMqMpTfQVDdl3rJoy2UBgTYdzVNG3NHTiEvOk3z4C
myarlItk0dAOn+9/WBYEvtA1dVUkh4bsdnx/HOdI4ISTN/uE82lo7pnN/Te3
CVwYc+CJcCENuQrc4haLInBdnfhB4Y80tGnriHVmIoHZ1BZO4c80NLKpwTQo
k8D8pkn5QkU0pONlfS8q//8ePu8kVExDfd0uPzpJz+2uUJUTKqEhOYXi6rOk
9yx4/9ULltFQlfuQlQLpwUv6X+4JfiPbmzFBK9sIHHr9lq5gBQ1JqGgYGPcS
OP2z8aRAJQ195MzRyRsmcMksLUOgioZSOEo4LdgEbtdqtRSopqGjhtvct02S
Pr38XFyghoa2WORe2DtNYPFsx2/8tTSUO1pVHzVHYGW2mh9/PQ1F+g3HSS8S
2GjLtBp/Iw2J/TLJaSB9bOtY1M/XTEMGZmsFf5J+9ku9HcvXSq5/R/uEGTKO
6TUx5WunIdt7yy7W//899VpJbr5OGtprkOu/QNZXadlWQOmmIUs1+braeQIP
xCY7U3ppiPH2R0DPDOnrpgvylH4auvxcKFKR9PVKya2NvIM0RGGtW59B+lrT
bCaEd5iGVrOVzWxHCXwoDAMvg4Z2VazWNhsg8MWfd6Z4mDS06skPHr9OAt/i
N33Jw6ahqLudbR2NZD4N6dY8YzQkXdrPvlpN4A9B7TSeCRoSNdt96VA5mb+F
i/7c/2hIazo+Nz2LwCctjDfPTtMQz173gHOppKdztzSyZ2nowyF7h/OxBI69
yFRrXaShZ7201+qkr3m+VbX/Xqah1BfSL2fdCewq/+ZeOacESmirXeC1I7BB
s0tfFq8E+n2MPPn1CPxum2l4Gp8E0oy68rhEnRzvQ9XdcQISqPLD/smuNQQe
MyRi7opIINlrqf2MGTZ+lut+wJougaajbAJMU9iYImY2fWSFBHr7M/PyqQds
7H5xa8p+GQm04eUN+jsvNjaSn1jUXC2BjHQUn2kasPFE2OVsoQ0SyLHU1OBr
MwtbMY5Yc26SQH6O4fR1n1m4wlBTaFpRAvHUfvGtTWDh+IUp+15lCZRc+bxM
1o6F9130lv6gKYHs7I/EXu5m4tzy4+VvtSTQCUEzteNFTLxGfsellJ0S6Era
OpPQZ0w82TT986EOWf7wgTP/jjDJ+b96/ZyBBGLHDla2fB7FU3L+gxJHJZDo
1WHxl24MbONvGSVwXAJRH7NjVPcwcGWTDlo+IYECqxduS0kxcGLYYizjtAQS
WqvRLf5xBB9YCDj49awEivAQ426YG8bPmwLfu16WQGUlTc9DbYfwYLl6V5iX
BGrIM/BV2jiEld93CbzzkUDO8uf6148O4vzw3TaEnwR6Or40tf3yIK7aPyvg
fksCpds7Zk/7DeCZT+42Ho8k0KX6gkF/jz5smmQj6FkggTRmb7wbn+jA0WGi
26M/SKAdP9VZYNmBW/y/2Lz/JIG+/ZfXW1TWju1PrsqbwhKocWlPtk1UG75K
a7LxqpBAX6tbt73Y1IJTbpnmebeQ/dGYO/hXrR7POe62vTovgQaPb2I/+FKK
D3xSQl6LEkjvlVV+zs0S/ExEWs5jWQJltsm9cNj/FevkTHQ5cksiazlXpJj+
BQfMp9tYCEkiPmrWwd/fczF3GM1mxypJdNr3Ed/G8nUgnDtk9VdbEtWmP9ti
/r0ULHkbdo/rSCL5oxIrsjjK4c2JktUsXUm06NPQErrrG5guxHX060ui6m0h
zSkvKyDc0Nyq/oAkohztXHct6BdINn+2zD0liR4W7/2yKbgOVi9GnPbwlURL
Y83Xvr1vh329Bz889if7k62+TDftAM/vAiuKAiTRts15nRGDHVAZEVgreFMS
tfx7dG9Rsgu8N3rsT7kviVyuDv2Jye2GmkOHdzTFSaKZRf6n6exemNcUfrSY
IIninp09ULCtDzaurJhY91wSfWkYNtW50gf+/fDWPZUcb+jK+ITlPth8VW2D
4FtJVJP3Z8tDvgEIShaV2I0lUWqQJ741Nwhv7la6n/0qiTRSiqsEtYag2flO
9b1SSbSR5qA94j4EqjuW7jV+l0RB1VMxGf1D0PaTxeFeI4n6qH08PGXDQMl+
aR1TK4n0zrW8WDs3DBoxDp8/10uidg7L3jtqIxBs2+Ej0ELWN3lDR+PJCGj+
rWIn90iirveH/OtsGWDTGmzyo08S3Sg6JrQuggEh2OAVMSCJ7MajinKKGdB9
77ODDkMSmcwY7XqwehQerHnd3jAhiWTNs/cKVo9CIbej9sKUJJIkFp5qzYxC
//C6JwrT5HyrW44/kWeCdu6zI27zkshSOY5z3oMJg3vvV/Lz0NHyix8X6QKk
t41t5TZQ6EgxnDdURZkFHabbvfX46WjX1cNxvqYsqD/WJe8rTEfJuuH178JZ
UHJ229VRSTqq/i4/4CLEBt3z/L/5VtDRa8PiWElFNny42LF+vQwdCTrMnB3Z
Q/rB426N5Wo6UjrGu3PlVTbEX2/bVL2BjqQN1kvfbmGD9M2sa4xNdPRI2OR+
MMGG6Du36yhKdOR7Iiv9PQ8BIQ/UroMqHdG7QqJvKRNAieBpOK1OR1r3uw9t
AgICo1uUrmjQ0QH5XSFjhwm48uxmY5YWHbkOpEVOeRAwlWCh/GsnHR3NYPiq
BhLglqwSNKJNR7lF0VIPHhLASOVq5t1NRwM9CZzUeALOvWxSUQA68qIsdOS/
JKD39eubunp09JDx9EhgHgFWWYEtp/bQkZmfI9WtmIDm3ONqPoZ0NCFmXnGd
9PbRgi23o/bS0TG/vdtzSW/XfORoe7efbG9SZ4VAOwHGRQ3qVcZ05FGjrBnY
R8C3r6/ukHZGomtkLFYxSN+XX2/nOUxH83wix5oIAooqjmrIm9PRfek13HlT
pMerNgfvPkpHn0xd0PsZAt7/Xuo4eZyOpAQVx+tJ/6rX1W3ztqAjo6rgZSnS
x68bM+5FnqKjVzVNp33///vt1mtdby3pqOiq08ISGSd3mG//aU1HZ6IzOlLI
eE3PpvtDtnQ04s7F5UyWf9q/0M19lo5W1c55HF0ggD78R0vOgY6Y2fI61qSv
w0fTQnXO09GWdkmve6SvhQm/XosLdDRrfX1H4xgBwROHd3o5kc//SKcYkL7m
/rchLMKFjsJcU3rq+wkImJ3re+NGR0KCY7J3OwiYW/i9q9KDjuobaoNPNxDg
zZH6cPAyHblwKlubVxEwzu07wOVNR39VetqcSggYFlwf8Z8vma9mIQbfawLs
RWcHT/jT0fanllL3EwnoEq/W8Qygo+vpnxQ0IkkfS18Zfh1ERzeo+sdYpJ/N
ZA/q/rhFR/zfNuzlIv1ctVYheuAOuX7GQrJ0jhJQurEK1tyno6WR0pJ16gQc
COs6IPWAjrjPijitX0Pm9+/EMdGHdLRue3mMoxABnWUyzkuRdCSzq1n/Sx8b
7JVVfP5F0xHtuH9udTUbRqNQEDuGjvInVgZv+MCGGbvzTzqf0lFv03XX1Pts
CKj0fdEYR0f/aD1Rvy+zgVcj7G11Apl/FWcDvdNsoHHmlRUl05FPzqGExU1s
UE7kGk94RUfyxofuj/6vYjOPpzp743iWRCVD7j1fN6LRFEO0ikHfpxIaKirt
kpBR0TCK+qFkK+QKSdIIYxmlYiKyPEIb2UJZSgldLvfelLG1/c78+X6d1znP
cz7n+ef9xykWsQVy3C+JNzmwp33XWperItbES3cG/xYHfPL90hYHilhLczuN
0wUcuGyWD1fWiFjnrmsbne5zoFZmcNaqkmE2kZika9ZywPCj/pRszBCrfto2
jzzjQDN/q2WW2xCb8d6pWKmBAwFhu1LTzIbYO4XhDd+bOdCzHh1zB4Rs3bbW
qTcdHPhF12GJlomQnRZ7jGoLByrXxKRElg2w4eNn9ycNcWC1nkvUxsgBVtEp
0SNWxIET4fPa/tg5wPIMyk+fGeEA7/J+W6UPAnbVs5k3D0xy4PFZ2a2hPAF7
WD5LdoECF/Yry8qEO/SzddLnLqyfxYVXQ+5WCZx+Vv+rB/eQIhfetQy5zm7r
YyUjS3RuKHPhijjPce3WPta3q9BmFY8L8XKdkSMbetnAWw/jNupxIa/Fq1FZ
tYeN3d6v5bOJCzWmpv5RBe3svesLzasvcmFmiXKArOwdduF3i/89iOdC7uWT
yvw5N9hYR7cSvMSFsU/Nxp6qWexvvKxVZVe40Fmznr/HPInlJSw2KEzjgufC
rvIIcz4GRPysmZ3PhcHrL3t31t/DdV5LpaKauVBtY8dLC2vEW8/s2PMttB/W
aKOuYxPO0/MOjGij5x9P91Efb8JRQf5kSAcX5v5Wt6Ba9zlmOq/4GNDDBRfp
XpXc860o72DU6zVC67mcGcxZ2oENpmYPtyoTqJqtoGoq1YORxcc/W84l0HJ7
LN98fQ9arbq9zJRDoN5rpkNHaA9WGvz4p7YaAe1l0fw2uXf4zwJ5v1EtAi8N
bqTfm96LSTNadRKXErBvrdTsEPWhQ6iiU+RyAmXgtuS+Tj+qSFldClpJ4PG6
IikNl36MmiqRcjcmEPC3duzBF/0YJErtXA0EdjxqHnhc9B5dWo5Ed2whoKLe
/KrTcQC17DKr6u0JWF3XqDWNHcBXz7onHmwj8LpxoeHMqgHc8cjeLXcngYb2
vSjUHkTrktVr/udEYL2D97arbwdxupG37zFn2g+ve631HCFWFeTmurgQuNA3
VLnbVIimNzWIrTuByZyf1mbFC9EgVeaD+jECPipmT5+YDaFwnvkiZW+6Pysn
PdBtCLOTTuyb/geBg/VbFPkXhlArbvCJ6ASBJFWF7uquIZwb1phWEUSAVRn9
Zd/vw9gkpdBecIau/xpg/yp+GKOD1s3JPkvgWKOfKL9oGOX8C0/xwwkcyOCf
2jM1jBOHr247EEMg0wP0ok6KkH8qY8bpWAIjF+xwcbIIF0XeKL0WR+D4aOTx
0RIROvxdqt2VSED61Yxm3rgIh4urX04mEdD6rf+Jj6oYQ5/URTFXCfTMNTw3
vlSMBYKuTw6pBEKmGteGuotx43hvtm8aAZMuXnlksBjfyg3vjc+g75VTLVWa
LEalRV+qm7IJhM+6pJtYK8ajruoJNncIeOydr/STlgRlfBdaHy4g0Fhp8sR9
hQSTQ/S/nLtL4HN3uUfjBgk+TTdzfVRMYMOwsvss6s8HCiyY/vt0/riBz7v9
JDjxwPaZTDmBMfmYDW3hElzUs2/l2gd0nlS9/tJNl2D5B9cBp2oCMhnbm8Jv
SXD7NM+UoIcEVHU4odPvS3BY6bjdtccE1CbHvTJrJBiiGShb9pRAWpOz5SHq
czzDsOLOOgKLO9seWr2UYMGaC0cn6wl8jRu/tfGNBDduvqTFNNH9Z6KfHnkv
wbeO11qNnhOQLwnszRuWoJ9n5jmHVgIpVh1NSh8lOCcwz8z3Bc1vX8uRi2MS
zIou/BDXTiBv1+OE5dSXzVPK/8rvJBB4w3j5py8SbL3xcFfTKwJ1YS1LW6gv
Hy2tny3pJhDj7BnynPqwTF1bpWIPgV37p2uPUE7ufO2r30sg2KdmjiHlZcJ+
HZt+ArO9v9pEU19+Mil65SEg8Guf/nt56ssHFMZizw0S0C2fEP9F/X2c+WaR
PURg60vDoAPU72N05CYfiuj82D/NN6X+v8h4Tl6fhMDm8t48owGarxXXWeYj
gZUaNSn2PTTfnfM5P44SmFnZeiu6Q4JDhxY9hTECn4QZvIEmCZ49YRDoNEEg
d887ddfHNN9wo2VBUwRsrzhPTCuXYP6lNf0pXwhY66qMVeRL0DrT8krpNwIK
YVJuf1Jffnt386bOaQyIPu1MTk2iebbuLyTTGaib2lonHyDBzN5DHkYzGIiw
LOZ7H5Wg2ScvDQcFBoyjpt38uleCR1ROh8UpMtDV71IZbCxB6R8jTPKVGIjf
nJv/33+G5GV8UaMyA19Pa4uSlGledqkOilwGFuTO87MSiPFwTX/FDIaBj+kZ
hU7PxahorK8jzWMgzcfrTGmZGLdqlkyNaTAwejmuieWLsUv0PPXtTwwI7i4Q
R+qJMchZTaFrMa3fsFS68QcxarU5+bTpMtBzSnbd3n9F6Fo2bFG7hIElljiw
mfqzOFJO+M8qBvbWf4eitSKM/Wa77dZqBkwcWqW3LBDhCp/4shwTyidrc1ZN
E6H/bi3+NXMGdK+2N0hKh1Fa55eVERvofUpKbhvoDSPnoWfQHgcGFn7+UHNt
UIjFxncF23cy8P1kQ01AhRD33Jyy27KbnlcRyhbHCfHP+AhtC0cG7s6tfWlt
IkSdg2lPlrgxsLu6ok4cNIhm31tVpI4z0D1LrcdGJMBun3kBn08w0HSx1Na/
WIDB7537//VnICe78vbcEAE+qhffEwYw8OG90ckUrgC3pMg7toYyIMU3z+St
fo8HTcyysxNoPZWlcRP7+/ANax/zLJEBf95qvSj1Ptxneej4SBIDLQH+thc6
enHHttj1ptcYkHaPvSOw78VfPfveNGTSftx/T/7Z7B0uT4tmxooYOBSf7GLx
339khdfnLToY8PL0NrzJvsD09sCjPRpqUDR4cM6S4ATUD59qGaFsd16qRs8w
AYtW+JlKz1eD+9tP7vr5dTzWxfw+U5uycJmS1mKTeBy1cMlxpVzlwTfWHLmI
lvnWfQLKcRWnFFSrYlB4fu4+saYaLA464n01OBR9V8dWf6OcECBIiXsdgt/6
ZuspaamB+c2q7PMmIdTs5aYMKfM2PXPyGwlGs7GJy96UjzVbi9KrgjDmYHfL
KOWM1E07pKlzMj/sNZ2+gNbf8uCSyOQPTC9/mc6h7DZxvbB9xBvvMc3eRpQN
+uavcaz2wrcN1Ur+lJ1UVmYXnHXFwwHgd47yi3ml6REfnXFUt7w7ifIeX75U
Sc1+lA8ryiuhzBrHCWeFbse45Ss4tZRvb8q0O/x4M6q/vR3QSbloXtKVsnAL
zLqg3yek/G9YTrBG9EpcZvq3zWfKzqfuVO0Lyaz4P96zBPs=
      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->
    NCache[{{0, 2 Pi}, {-0.9999999976346008, 0.9999995164942488}}, {{
      0, 6.283185307179586}, {-0.9999999976346008, 0.9999995164942488}}],
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}]}, {6,"6"->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwU2nlYTV0XAPC6zXO3SwhJIYpMzcrakhAyJppLkkoUKlTUSyWkoiil0CSa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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->
    NCache[{{0, 2 Pi}, {-0.9999995986499631, 0.9999998621386874}}, {{
      0, 6.283185307179586}, {-0.9999995986499631, 0.9999998621386874}}],
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}]}, {7,"7"->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwU23c81d8fB/DLtTcJlaxoUCkNKnmfJAmprGQWWpKkjESlIQoh+UZkZGVv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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->
    NCache[{{0, 2 Pi}, {-0.999996559755116, 0.9999954728040336}}, {{
      0, 6.283185307179586}, {-0.999996559755116, 0.9999954728040336}}],
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}]}, {8,"8"->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwU2nc8Ve8fAHDjcrnW1R6SqG9CsjIKn4e0ECWkrCgNqWhQGaWUUkkqRRnZ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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->
    NCache[{{0, 2 Pi}, {-0.9999997416044833, 0.9999999999346731}}, {{
      0, 6.283185307179586}, {-0.9999997416044833, 0.9999999999346731}}],
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}]}, {9,"9"->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwU2nc4lt8bAHB7vNaLEhKiYaSBlMJ9ktDSNxVlVBRlFcrISMpKpShCiTLT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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->
    NCache[{{0, 2 Pi}, {-0.999999838936776, 0.9999999995237755}}, {{
      0, 6.283185307179586}, {-0.999999838936776, 0.9999999995237755}}],
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}]}, {10,"10"->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwU23c81d8bAHD7cu1SKKk0lESJpNRzIkK+EkUhZUQhoVChKSSESlEiI6Ky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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->
    NCache[{{0, 2 Pi}, {-0.9999996519478712, 0.9999999691979907}}, {{
      0, 6.283185307179586}, {-0.9999996519478712, 0.9999999691979907}}],
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}]}}, 4]], "Output",
 ImageSize->{227, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->1143189172]
}, Open  ]],

Cell["\<\
The tab labels are not restricted to simple strings. Here typeset \
mathematical expressions are used as tab labels.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TabView", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"HoldForm", "[", 
      RowBox[{"Integrate", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"x", "^", "n"}]}], ")"}]}], ",", "x"}], "]"}], "]"}], 
     "\[Rule]", 
     RowBox[{"Integrate", "[", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"x", "^", "n"}]}], ")"}]}], ",", "x"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "8"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[12]:="],

Cell[BoxData[
 TabViewBox[{{1,
  TagBox[
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"1", "-", 
       SuperscriptBox["x", "n"]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}],
   HoldForm]->
  RowBox[{"-", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", "x"}], "]"}]}]}, {2,
  TagBox[
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"1", "-", 
       SuperscriptBox["x", "n"]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}],
   HoldForm]->
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "x"}], "]"}]}]}]}, {3,
  TagBox[
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"1", "-", 
       SuperscriptBox["x", "n"]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}],
   HoldForm]->
  RowBox[{
   FractionBox[
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "x"}]}], 
      SqrtBox["3"]], "]"}], 
    SqrtBox["3"]], "-", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "x", "+", 
      SuperscriptBox["x", "2"]}], "]"}]}]}]}, {4,
  TagBox[
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"1", "-", 
       SuperscriptBox["x", "n"]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}],
   HoldForm]->
  RowBox[{
   FractionBox[
    RowBox[{"ArcTan", "[", "x", "]"}], "2"], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "x"}], "]"}]}]}]}, {5,
  TagBox[
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"1", "-", 
       SuperscriptBox["x", "n"]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}],
   HoldForm]->
  RowBox[{
   FractionBox["1", "20"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      SqrtBox[
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", 
          SqrtBox["5"]}], ")"}]}]], " ", 
      RowBox[{"ArcTan", "[", 
       FractionBox[
        RowBox[{"1", "-", 
         SqrtBox["5"], "+", 
         RowBox[{"4", " ", "x"}]}], 
        SqrtBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"5", "+", 
            SqrtBox["5"]}], ")"}]}]]], "]"}]}], "+", 
     RowBox[{"2", " ", 
      SqrtBox[
       RowBox[{"10", "-", 
        RowBox[{"2", " ", 
         SqrtBox["5"]}]}]], " ", 
      RowBox[{"ArcTan", "[", 
       FractionBox[
        RowBox[{"1", "+", 
         SqrtBox["5"], "+", 
         RowBox[{"4", " ", "x"}]}], 
        SqrtBox[
         RowBox[{"10", "-", 
          RowBox[{"2", " ", 
           SqrtBox["5"]}]}]]], "]"}]}], "-", 
     RowBox[{"4", " ", 
      RowBox[{"Log", "[", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "x"}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SqrtBox["5"]}], ")"}], " ", 
      RowBox[{"Log", "[", 
       RowBox[{"1", "-", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SqrtBox["5"]}], ")"}], " ", "x"}], "+", 
        SuperscriptBox["x", "2"]}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SqrtBox["5"]}], ")"}], " ", 
      RowBox[{"Log", "[", 
       RowBox[{"1", "+", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SqrtBox["5"]}], ")"}], " ", "x"}], "+", 
        SuperscriptBox["x", "2"]}], "]"}]}]}], ")"}]}]}, {6,
  TagBox[
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"1", "-", 
       SuperscriptBox["x", "n"]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}],
   HoldForm]->
  RowBox[{
   FractionBox["1", "12"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      SqrtBox["3"], " ", 
      RowBox[{"ArcTan", "[", 
       FractionBox[
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", "x"}]}], 
        SqrtBox["3"]], "]"}]}], "+", 
     RowBox[{"2", " ", 
      SqrtBox["3"], " ", 
      RowBox[{"ArcTan", "[", 
       FractionBox[
        RowBox[{"1", "+", 
         RowBox[{"2", " ", "x"}]}], 
        SqrtBox["3"]], "]"}]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"Log", "[", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "x"}], "]"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"Log", "[", 
       RowBox[{"1", "+", "x"}], "]"}]}], "-", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", "x", "+", 
       SuperscriptBox["x", "2"]}], "]"}], "+", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", "x", "+", 
       SuperscriptBox["x", "2"]}], "]"}]}], ")"}]}]}, {7,
  TagBox[
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"1", "-", 
       SuperscriptBox["x", "n"]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}],
   HoldForm]->
  RowBox[{
   RowBox[{
    FractionBox["2", "7"], " ", 
    RowBox[{"ArcTan", "[", 
     RowBox[{
      RowBox[{"Sec", "[", 
       FractionBox["\[Pi]", "14"], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{"x", "+", 
        RowBox[{"Sin", "[", 
         FractionBox["\[Pi]", "14"], "]"}]}], ")"}]}], "]"}], " ", 
    RowBox[{"Cos", "[", 
     FractionBox["\[Pi]", "14"], "]"}]}], "+", 
   RowBox[{
    FractionBox["2", "7"], " ", 
    RowBox[{"ArcTan", "[", 
     RowBox[{
      RowBox[{"Sec", "[", 
       FractionBox[
        RowBox[{"3", " ", "\[Pi]"}], "14"], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{"x", "-", 
        RowBox[{"Sin", "[", 
         FractionBox[
          RowBox[{"3", " ", "\[Pi]"}], "14"], "]"}]}], ")"}]}], "]"}], " ", 
    RowBox[{"Cos", "[", 
     FractionBox[
      RowBox[{"3", " ", "\[Pi]"}], "14"], "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "7"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "7"], " ", 
    RowBox[{"Cos", "[", 
     FractionBox["\[Pi]", "7"], "]"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"], "+", 
      RowBox[{"2", " ", "x", " ", 
       RowBox[{"Cos", "[", 
        FractionBox["\[Pi]", "7"], "]"}]}]}], "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "7"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"], "+", 
      RowBox[{"2", " ", "x", " ", 
       RowBox[{"Sin", "[", 
        FractionBox["\[Pi]", "14"], "]"}]}]}], "]"}], " ", 
    RowBox[{"Sin", "[", 
     FractionBox["\[Pi]", "14"], "]"}]}], "+", 
   RowBox[{
    FractionBox["2", "7"], " ", 
    RowBox[{"ArcTan", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "+", 
        RowBox[{"Cos", "[", 
         FractionBox["\[Pi]", "7"], "]"}]}], ")"}], " ", 
      RowBox[{"Csc", "[", 
       FractionBox["\[Pi]", "7"], "]"}]}], "]"}], " ", 
    RowBox[{"Sin", "[", 
     FractionBox["\[Pi]", "7"], "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "7"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"], "-", 
      RowBox[{"2", " ", "x", " ", 
       RowBox[{"Sin", "[", 
        FractionBox[
         RowBox[{"3", " ", "\[Pi]"}], "14"], "]"}]}]}], "]"}], " ", 
    RowBox[{"Sin", "[", 
     FractionBox[
      RowBox[{"3", " ", "\[Pi]"}], "14"], "]"}]}]}]}, {8,
  TagBox[
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"1", "-", 
       SuperscriptBox["x", "n"]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}],
   HoldForm]->
  RowBox[{
   FractionBox["1", "16"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"4", " ", 
      RowBox[{"ArcTan", "[", "x", "]"}]}], "-", 
     RowBox[{"2", " ", 
      SqrtBox["2"], " ", 
      RowBox[{"ArcTan", "[", 
       RowBox[{"1", "-", 
        RowBox[{
         SqrtBox["2"], " ", "x"}]}], "]"}]}], "+", 
     RowBox[{"2", " ", 
      SqrtBox["2"], " ", 
      RowBox[{"ArcTan", "[", 
       RowBox[{"1", "+", 
        RowBox[{
         SqrtBox["2"], " ", "x"}]}], "]"}]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"Log", "[", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "x"}], "]"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"Log", "[", 
       RowBox[{"1", "+", "x"}], "]"}]}], "-", 
     RowBox[{
      SqrtBox["2"], " ", 
      RowBox[{"Log", "[", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{
         SqrtBox["2"], " ", "x"}], "-", 
        SuperscriptBox["x", "2"]}], "]"}]}], "+", 
     RowBox[{
      SqrtBox["2"], " ", 
      RowBox[{"Log", "[", 
       RowBox[{"1", "+", 
        RowBox[{
         SqrtBox["2"], " ", "x"}], "+", 
        SuperscriptBox["x", "2"]}], "]"}]}]}], ")"}]}]}}, 5]], "Output",
 ImageSize->{634, 261},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->44224095]
}, Open  ]],

Cell["\<\
This example uses the shapes of countries as tab labels, with a plot of each \
country's GDP in its pane.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TabView", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Rasterize", "[", 
      RowBox[{
       RowBox[{"Show", "[", 
        RowBox[{
         RowBox[{"CountryData", "[", 
          RowBox[{"#", ",", "\"\<Shape\>\""}], "]"}], ",", 
         RowBox[{"ImageSize", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"40", ",", "40"}], "}"}]}]}], "]"}], ",", 
       RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], "\[Rule]", 
     RowBox[{"DateListPlot", "[", 
      RowBox[{"CountryData", "[", 
       RowBox[{"#", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "\"\<GDP\>\"", "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1970", ",", "2005"}], "}"}]}], "}"}]}], "]"}], "]"}]}], 
    "&"}], "/@", 
   RowBox[{"CountryData", "[", "\"\<GroupOf8\>\"", "]"}]}], "]"}]], "Input",
 CellLabel->"In[13]:="],

Cell[BoxData[
 TabViewBox[{{1,
  GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJmYGDQgGIWhlEwCoY94ADiaCAWHmiHYAGg7HgPiP+zsbHtAtKM
A+wedAByj5W9ve07IP0fiE8BMdPAOgkF8HNycNybO3va/wvnjv8XEhT8JSYm
lsJA/3AE2acDxIFAPB2IlZiYmPYD6f+OjvZ/nzy69R+E9+7eCgrD/8zMzM1A
mpsK9goAsRY7O7ubno5OkZ6O9nx3d5eFXp5uG7093ff5eHns9/Jy38PKyvqN
ARJ/cFxSnP/z0oUT/2Fug+Erl07/9/f3+QlVpwvE7FC2OwPhcJ0BxK6KinLJ
Tg62C8NCg07X1VY8WDh/1u9dOzf9P7h/x//Ll079v33rEty+h/ev/79x7RyY
fefWZTD9+OFNDHch43t3roD9wMjIuBTNXxw43MWErG7likX/z54+gtcOYvH1
q+dQ+I8e3Pjv5ur8H81dyBgbCIXJe3q6EfQ/sXj92uVwew8d2AkXT0qMI9V9
l2Dy6P4lF4PSAbK9yGkChNHc5EvAfc4weVB6osRd166c/Z+dlfZfSUkRbn9i
QiyKGlD8gNIQkps4sYSjAJL7HGDi5Ljp9KlDYL0a6mr/kO1gZmacB6IT4mOw
6gOFBZ54Rg7L3SD+4kVzyHJfaGgQzLy/QKyJFjdTQHJnTh3GqR+H20KRzACV
O/9VVJT/3797lSS3nT97DFbmdmFJN6Ay+L+hgf4/bHpBeQYkv2jhbGR3uTFg
1oHyhPyIC4PKW6i5QmhmwspdsDpY2QjDu3dtxhZmKVj8CANk5wkk89mQzBMF
ibm6OmHE4YL5M7G5zQmP2/pBasgp90B6kOxIB7ajfKFmmoPEdmzb8N/MzARX
GsNVXyCDBJDayMjQH6B6h1T33bpxAZfdh9H4oDo3E8reygBpGxIDfjGQWO4h
qz1+dB+47MXhRmLrB3zAQlxc7P3Vy2cIumvJ4rlwe2RkpFHKOl9fL2Q3FFHR
fQx8fHwZbS0NL0B1NzZ3gcRJCB8QnoVDPJgc9wEBq5yczIr5c2f8wVZ+NDZU
k+q+dzjEJ5DpPhAQdna033fuzFGUeMSGMzNSSHUvDMtQ4D4QcJUQE/tCpt34
MBsDlQAXF8dkbm7O7Whmgus+NDvXEOEub2q5iwDIIcItMJxKJzehgyNEum+g
AEofBQ8eDADsFmCbarC6DwYGu/vUGQa3+0AA1N4dzO4DAVD/oA6ItQbaIaNg
aAEAlA+BgQ==
    "], {{0, 0}, {40, 40}}, {0, 255},
    ColorFunction->RGBColor],
   Background->None,
   ImageSize->{40, 40},
   PlotRange->{{0, 40}, {0, 40}}]->
  GraphicsBox[{{}, 
    {Hue[0.67, 0.6, 0.6], 
     PointBox[{{2.2089888*^9, 8.51102721952742*^10}, {2.2405248*^9, 
      9.611388494862978*^10}, {2.2720608*^9, 1.094720184098862*^11}, {
      2.3036832*^9, 1.2719440059381201`*^11}, {2.3352192*^9, 
      1.5529838808012518`*^11}, {2.3667552*^9, 1.6827567004560587`*^11}, {
      2.3982912*^9, 2.00061864743176*^11}, {2.4299136*^9, 
      2.0490855246558777`*^11}, {2.4614496*^9, 2.1158699904973694`*^11}, {
      2.4929856*^9, 2.354038885269667*^11}, {2.5245216*^9, 
      2.6527162075194025`*^11}, {2.556144*^9, 2.9670158287541626`*^11}, {
      2.58768*^9, 3.0382902858739197`*^11}, {2.619216*^9, 
      3.2898857285467914`*^11}, {2.650752*^9, 3.42332183759481*^11}, {
      2.6823744*^9, 3.50666308740087*^11}, {2.7139104*^9, 
      3.6336595904342676`*^11}, {2.7454464*^9, 4.1532010633550885`*^11}, {
      2.7769824*^9, 4.9056464772996716`*^11}, {2.8086048*^9, 
      5.4728594655086096`*^11}, {2.8401408*^9, 5.742041096183926*^11}, {
      2.8716768*^9, 5.888384271853116*^11}, {2.9032128*^9, 
      5.70279426668597*^11}, {2.9348352*^9, 5.546898143452979*^11}, {
      2.9663712*^9, 5.558404311536865*^11}, {2.9979072*^9, 
      5.816644190490315*^11}, {3.0294432*^9, 6.043712052962986*^11}, {
      3.0610656*^9, 6.27595363337625*^11}, {3.0926016*^9, 
      6.069244392498939*^11}, {3.1241376*^9, 6.512017086979576*^11}, {
      3.1556736*^9, 7.144534748267805*^11}, {3.187296*^9, 
      7.050688372908894*^11}, {3.218832*^9, 7.243042892296139*^11}, {
      3.250368*^9, 8.547108065250964*^11}, {3.281904*^9, 
      9.767419516622521*^11}, {3.3135264*^9, 1.1317597770741843`*^12}}]}, {}},
   
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   AxesOrigin->NCache[{2208988800, 0}, {2.2089888*^9, 0}],
   Frame->True,
   FrameTicks->{{Automatic, Automatic}, {{{
        NCache[2208988800, 2.2089888*^9], 
        FormBox["\"1970\"", TraditionalForm]}, {
        NCache[2524521600, 2.5245216*^9], 
        FormBox["\"1980\"", TraditionalForm]}, {
        NCache[2840140800, 2.8401408*^9], 
        FormBox["\"1990\"", TraditionalForm]}, {
        NCache[3155673600, 3.1556736*^9], 
        FormBox["\"2000\"", TraditionalForm]}, {
        NCache[2272060800, 2.2720608*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2335219200, 2.3352192*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2398291200, 2.3982912*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2461449600, 2.4614496*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2587680000, 2.58768*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2650752000, 2.650752*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2713910400, 2.7139104*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2776982400, 2.7769824*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2903212800, 2.9032128*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2966371200, 2.9663712*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3029443200, 3.0294432*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3092601600, 3.0926016*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3218832000, 3.218832*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3281904000, 3.281904*^9], 
        FormBox["\" \"", TraditionalForm]}}, {{
        NCache[2208988800, 2.2089888*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2524521600, 2.5245216*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2840140800, 2.8401408*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3155673600, 3.1556736*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2272060800, 2.2720608*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2335219200, 2.3352192*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2398291200, 2.3982912*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2461449600, 2.4614496*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2587680000, 2.58768*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2650752000, 2.650752*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2713910400, 2.7139104*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2776982400, 2.7769824*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2903212800, 2.9032128*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2966371200, 2.9663712*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3029443200, 3.0294432*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3092601600, 3.0926016*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3218832000, 3.218832*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3281904000, 3.281904*^9], 
        FormBox["\" \"", TraditionalForm]}}}},
   GridLines->NCache[{{{2208988800, 
        GrayLevel[0.8]}, {2524521600, 
        GrayLevel[0.8]}, {2840140800, 
        GrayLevel[0.8]}, {3155673600, 
        GrayLevel[0.8]}}, None}, {{{2.2089888*^9, 
        GrayLevel[0.8]}, {2.5245216*^9, 
        GrayLevel[0.8]}, {2.8401408*^9, 
        GrayLevel[0.8]}, {3.1556736*^9, 
        GrayLevel[0.8]}}, None}],
   PlotRange->{{2.2089888*^9, 3.3135264*^9}, {0., 1.1317597770741843`*^12}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]},
   Ticks->None]}, {2,
  GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJmYGDQgGIWhlEwDMEsZmbma0CadaAdgg6A7moAUv+hOHJgXYMV
/Ofm5vqfnBT3Hsg2pYJ5jJycnNK6ujrLdXW114mJiBzh5GTLp8R9CxfMAuGf
kpISXSTqFWdnZ3cUFhaOkpKSagPy7RigcbF08bz/+/Zs+5+bm/mfkZHxF1CM
iVz3LV405/+yJfP/KygopBOhHmSPPgcH+1VZWZk3TY21r0D6a2rKvwYE+D6f
NWPy/7u3r/x/8ugWGO/etfm/oaH+ajzmsQGxEC5JHh6eNJAbgXZ9BdJ6BNwG
MuswSP3KFYv+3751Ce4OXPjh/ev/U1MT7wHT0FqgPk4gBhW3ukAcw4BI9zAs
isNeG6i8HAH3FYHUHdi3/R8hdyHj+3ev/vf0cP2N7h5NDfUfJ47tB8urqqr8
Z2FheQYUF8BhNz8Bt4GBqKhQwpLFc76T4j5YOE6c0P27p7vt/51bl/8/uHft
/6MHN1DUlJcVfWZjY3sDtIadGLfgAFJFRbmXSXUfMfjenSv/geXdX6Ad7hS4
j8nf3+fg44c3qe6+1SsWfVNUlAOVc/8pcB8DHx/vi9OnDlHVbYcO7gKVw6C4
lQFZQYHzeED+09PT+R0U6Pfr1o0LVHEfqKyEhps6JWEHAqqqynHdXa1g8y5d
OEGx20BpBWQWJyfHBSDNQan7gMCcAVpGgPIlpe67evnM/+Ag/y9ycrIXgWYK
UsF980FuW792+S9qpb9rV87+V1JSeAE014pCt4HqgP96ujp/QGUYpe6ClYF+
vt5/gHV5GuVBBwZuIDfevH6eIrddv3oOnEb27t7639vL47eoqGgLA2VlMwM/
P+80NjbWH12dLT/Ry39ysIK8HKje/29ibPSKgfK8C6qfqZJnYbihrvIzsL04
i4mJKRVoNiMFbhMAmnN12dL5VHMbCIPKT2tri3NA86UpDDt5BmiZQo14RcbA
NuM/YDvvEQMk75EKQO3RGgZIe+h7b0/7X2q6DVa2sLKy/gW2r7YyEF8+g+pB
SQak9trWzWup6i5kfPf25X+ZGal/BQQE1jEQzsMWMDcpKSn+zs/L+kdpWUIM
XrN6CbCPIddCKOCAbbAekNt27thIczch46bGmv9iYmJTCLmPlZkZ3McA9jnh
eQHUDl+2ZN7fLZvX/O/saAa3h6idT0Dllo6O1j4GAuMEwLy0DDndJSXGofdj
QH0+qucTUH1pZmYMysdmhMKQAZIG/YA4DeomUB8bVH4y2lhZLjh14iDc3Ivn
yS+vQe0fUH8E1EcCtWNioiP+MpDefkbuW3PDwlBQQOCbnIz0UxC7rLToDynu
ArkHRIPafgIC/PC+HQcHRwUDpH4nB4DcCSqr/kHNcwBiASB/l5aWxh9i+ySg
/rukpMR3mJuEhAS6GSBlCq6+JbFAEFhP3gDSWUCcjCQuwsHB/tjY2PDVrJlT
fuNy16KFs/9Pm9IPdpOamgoonED9DGYK3UQKkOXi4toHDMsf6O3qI4f2gN0F
LLs+S0iIL6Ojm9CBHS8vzw9QmoflSVD7jgGR90FjLWwD6D4FIyP9pyC3gcZn
pKUk/0DdBWqfUNJ+ohbgkpCQOFlTU/EyJzv9AyMj41SgmPFAOwoNgOLPHFiX
ljOMwCkBAKMoRAQ=
    "], {{0, 0}, {40, 40}}, {0, 255},
    ColorFunction->RGBColor],
   Background->None,
   ImageSize->{40, 40},
   PlotRange->{{0, 40}, {0, 40}}]->
  GraphicsBox[{{}, 
    {Hue[0.67, 0.6, 0.6], 
     PointBox[{{2.2089888*^9, 1.4860490316148856`*^11}, {2.2405248*^9, 
      1.6599051480654675`*^11}, {2.2720608*^9, 2.0370806787064062`*^11}, {
      2.3036832*^9, 2.6392489611186478`*^11}, {2.3352192*^9, 
      2.8178832637142487`*^11}, {2.3667552*^9, 3.5608510491218945`*^11}, {
      2.3982912*^9, 3.682859284585891*^11}, {2.4299136*^9, 
      4.0667378485213184`*^11}, {2.4614496*^9, 5.030293764523027*^11}, {
      2.4929856*^9, 6.065025382702382*^11}, {2.5245216*^9, 
      6.890241190158655*^11}, {2.556144*^9, 6.034738136776915*^11}, {
      2.58768*^9, 5.73916593597205*^11}, {2.619216*^9, 
      5.526822076601039*^11}, {2.650752*^9, 5.2512930500900977`*^11}, {
      2.6823744*^9, 5.489972719697796*^11}, {2.7139104*^9, 
      7.642085878650359*^11}, {2.7454464*^9, 9.25744668315392*^11}, {
      2.7769824*^9, 1.0065906584591847`*^12}, {2.8086048*^9, 
      1.0080845330770159`*^12}, {2.8401408*^9, 1.239216273221249*^12}, {
      2.8716768*^9, 1.2382601056413403`*^12}, {2.9032128*^9, 
      1.3716431138354666`*^12}, {2.9348352*^9, 1.291925428637067*^12}, {
      2.9663712*^9, 1.3651592829157007`*^12}, {2.9979072*^9, 
      1.5701600445521953`*^12}, {3.0294432*^9, 1.574359362801807*^12}, {
      3.0610656*^9, 1.4255858862792654`*^12}, {3.0926016*^9, 
      1.4727634653137236`*^12}, {3.1241376*^9, 1.455813223397778*^12}, {
      3.1556736*^9, 1.3279619433987944`*^12}, {3.187296*^9, 
      1.3397410314001665`*^12}, {3.218832*^9, 1.457392660121621*^12}, {
      3.250368*^9, 1.799946390329191*^12}, {3.281904*^9, 
      2.0599603906303352`*^12}, {3.3135264*^9, 
      2.1265776254725664`*^12}}]}, {}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   AxesOrigin->NCache[{2208988800, 0}, {2.2089888*^9, 0}],
   Frame->True,
   FrameTicks->{{Automatic, Automatic}, {{{
        NCache[2208988800, 2.2089888*^9], 
        FormBox["\"1970\"", TraditionalForm]}, {
        NCache[2524521600, 2.5245216*^9], 
        FormBox["\"1980\"", TraditionalForm]}, {
        NCache[2840140800, 2.8401408*^9], 
        FormBox["\"1990\"", TraditionalForm]}, {
        NCache[3155673600, 3.1556736*^9], 
        FormBox["\"2000\"", TraditionalForm]}, {
        NCache[2272060800, 2.2720608*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2335219200, 2.3352192*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2398291200, 2.3982912*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2461449600, 2.4614496*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2587680000, 2.58768*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2650752000, 2.650752*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2713910400, 2.7139104*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2776982400, 2.7769824*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2903212800, 2.9032128*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2966371200, 2.9663712*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3029443200, 3.0294432*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3092601600, 3.0926016*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3218832000, 3.218832*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3281904000, 3.281904*^9], 
        FormBox["\" \"", TraditionalForm]}}, {{
        NCache[2208988800, 2.2089888*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2524521600, 2.5245216*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2840140800, 2.8401408*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3155673600, 3.1556736*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2272060800, 2.2720608*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2335219200, 2.3352192*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2398291200, 2.3982912*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2461449600, 2.4614496*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2587680000, 2.58768*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2650752000, 2.650752*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2713910400, 2.7139104*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2776982400, 2.7769824*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2903212800, 2.9032128*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2966371200, 2.9663712*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3029443200, 3.0294432*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3092601600, 3.0926016*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3218832000, 3.218832*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3281904000, 3.281904*^9], 
        FormBox["\" \"", TraditionalForm]}}}},
   GridLines->NCache[{{{2208988800, 
        GrayLevel[0.8]}, {2524521600, 
        GrayLevel[0.8]}, {2840140800, 
        GrayLevel[0.8]}, {3155673600, 
        GrayLevel[0.8]}}, None}, {{{2.2089888*^9, 
        GrayLevel[0.8]}, {2.5245216*^9, 
        GrayLevel[0.8]}, {2.8401408*^9, 
        GrayLevel[0.8]}, {3.1556736*^9, 
        GrayLevel[0.8]}}, None}],
   PlotRange->{{2.2089888*^9, 3.3135264*^9}, {0., 2.1265776254725664`*^12}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]},
   Ticks->None]}, {3,
  GraphicsBox[RasterBox[CompressedData["
1:eJzlmGlMVFcUx98wDMwGQy3MBjPMlGIQSgltQEZmQGhtSGmM1TapjUpKi2nU
RhDEBSSKJNYKxS5glNpiAjXRUluJsVCxslkE2VcBZbPFtB9YnSqLt+cM8wix
tc3Me69fepJ/bt7kzbm/d7dzztXH71wfz6coys8qR+r/Y87Ozp8olYrj1sfl
IKf/sHseaC3oJdAKUIC1f76Tk9MGaHNARK1WTUL7uVAoNOt03v1isTAOniWP
+RKzDQcM6wyGlWM5x478nrxr5yiySCSS3wQCgTk1JWnio6NZ5vbWG+RwZsb4
qZOfTVVX/Ui6O5tIxoF95pCQF7uUSuX7AgE/WyIRNbm5uTZZv5c1A4638vNy
5+8O95KRoVvk2tXLBHmabtYS/O2f1NZSR5b7PjsVHRVp5vF4xNXVtQJcOrDJ
BxZ26GD6+L+xPEnDgz2W1hgehvP/AstsaCaYp3u9PS128aE6228S2EOzMH4Z
4E/BMh/faDQU45zayzc00E3u9HeQnOwjc+CPgLQs8uF63pSUuGMS15+9jKi+
3jYStTpiWKFQ9IBPdxYZHaRSSfP2bVunmfChWpvriMkU/gv49GLI9DQoApQg
l3u0rzKE3s08lD6N82QvW2NDDXknbnO9p1wexpBNpdNpu6AlaftT73d1NM4x
HbfSi+eJ3ls7CD5DGbLJwX46XZA/19/bzoiJ1pnCgofeGk0N+NYxZLOYSqW6
lPvxUVbYfq69SlZHmC6AWzc22MC0Xp7q0drqK6zwfVGQh3GjlGIpbmi12uxL
pSWssOE3UgvnHWtxw8HBYYdM5jqDe40J2+2+DvJcgP+MlW8DW3xgSvR5oeQs
4/FDRow7cVve/jU4OKgA/EqZwsH4TSNfR1sDK3NM60Te8Xn0C/laOcUgdqjV
yoJdSR+wykYLc4yNG9+cfeXl6HYfH30y5Awx0GWsjYik7IfvOeGj1dx4nd43
BPLLcVvgYH6bszIP/MElH8bIM4WnLPs7MDBgwMbx83w3fssA5kRcMqKqKsuJ
j88z9bbAQb0Qk5+fO0XnvVwJYrplfvl8fowtfG5usg6TMbzfaFzVff5c0QRX
fFFREY+ohTVoa02HeZUeVKLVah4M3unihO9s8VePli17CuslgY18tPHgrPp0
394UMxdrsepaGfFwd6+wkw3Nz1OtuvftN1/PcLH2IPZNQB/BDPhkYrF4qLjo
y2mmdcfjwnOaWlh77zHgQ1NsTYhvYZOtvq6S3rfVDNnQBGvWRNczqX2XCuch
N+dDrIXHwLeIBb4UEBm43WnxD2Np+faerqbFPu3ZOwcz9o+AnxCK4V0MxLrN
cL4/wLsWqN0WYyadGwYFBc7ic/2NKpv4sg5n9ML/fJkOHpper0+KjDSdlsvd
RwUCxyv+/itGyi5/R2JfjbHcBVyvqbBpHPFceS02ppJi/45QCOK7uLgUUdZx
xFqb7hfrDPp3yEX/9kzavi1hXiqVPtTpNHEssy01vDshe/ckL45Z361W8vq6
tZb8k8fjYR1JwlaGzi2NPelpe+ZEIqHlHVg3uzlik0H/9ylrfo1zGx5uICKR
iI6lKLyj8gFN+/n5TpaXXSQajRddh+C5cowjNtrwfoxgfUz3CeNRB60BFLnk
PR6cIw30O46OjpiLVnLMRnl4eKzfnZI4lp6WushHPTlHl+Ff6Pdg7W7imk+j
0SQGBz9/TqFQFFr7fYP66z04K/YnpeuAPA==
    "], {{0, 0}, {40, 40}}, {0, 255},
    ColorFunction->RGBColor],
   Background->None,
   ImageSize->{40, 40},
   PlotRange->{{0, 40}, {0, 40}}]->
  GraphicsBox[{{}, 
    {Hue[0.67, 0.6, 0.6], 
     PointBox[{{2.2089888*^9, 2.0810384443389188`*^11}, {2.2405248*^9, 
      2.406633633299223*^11}, {2.2720608*^9, 2.901008009718065*^11}, {
      2.3036832*^9, 3.859488165006181*^11}, {2.3352192*^9, 
      4.294585203779621*^11}, {2.3667552*^9, 4.7140775174106274`*^11}, {
      2.3982912*^9, 5.0176605229263135`*^11}, {2.4299136*^9, 
      5.811627444679083*^11}, {2.4614496*^9, 7.210086697895739*^11}, {
      2.4929856*^9, 8.529460356368018*^11}, {2.5245216*^9, 
      9.12584520044493*^11}, {2.556144*^9, 7.661408754107075*^11}, {
      2.58768*^9, 7.417212813241608*^11}, {2.619216*^9, 
      7.391623711685114*^11}, {2.650752*^9, 6.956865796672733*^11}, {
      2.6823744*^9, 7.021427484597816*^11}, {2.7139104*^9, 
      1.0066288875939098`*^12}, {2.7454464*^9, 1.2559866089578115`*^12}, {
      2.7769824*^9, 1.3534382051911914`*^12}, {2.8086048*^9, 
      1.344638146460924*^12}, {2.8401408*^9, 1.7073594468832742`*^12}, {
      2.8716768*^9, 1.8085817176429229`*^12}, {2.9032128*^9, 
      2.0622474911792007`*^12}, {2.9348352*^9, 2.004389958855537*^12}, {
      2.9663712*^9, 2.1462382715819878`*^12}, {2.9979072*^9, 
      2.5226236677348384`*^12}, {3.0294432*^9, 2.438564676803662*^12}, {
      3.0610656*^9, 2.1605698959520244`*^12}, {3.0926016*^9, 
      2.1844745936107478`*^12}, {3.1241376*^9, 2.1435558626971543`*^12}, {
      3.1556736*^9, 1.9002196577147825`*^12}, {3.187296*^9, 
      1.8909539959373965`*^12}, {3.218832*^9, 2.0187441865571965`*^12}, {
      3.250368*^9, 2.4416665647769404`*^12}, {3.281904*^9, 
      2.7511128494533535`*^12}, {3.3135264*^9, 2.794856489081232*^12}}]}, {}},
   
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   AxesOrigin->NCache[{2208988800, 0}, {2.2089888*^9, 0}],
   Frame->True,
   FrameTicks->{{Automatic, Automatic}, {{{
        NCache[2208988800, 2.2089888*^9], 
        FormBox["\"1970\"", TraditionalForm]}, {
        NCache[2524521600, 2.5245216*^9], 
        FormBox["\"1980\"", TraditionalForm]}, {
        NCache[2840140800, 2.8401408*^9], 
        FormBox["\"1990\"", TraditionalForm]}, {
        NCache[3155673600, 3.1556736*^9], 
        FormBox["\"2000\"", TraditionalForm]}, {
        NCache[2272060800, 2.2720608*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2335219200, 2.3352192*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2398291200, 2.3982912*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2461449600, 2.4614496*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2587680000, 2.58768*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2650752000, 2.650752*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2713910400, 2.7139104*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2776982400, 2.7769824*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2903212800, 2.9032128*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2966371200, 2.9663712*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3029443200, 3.0294432*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3092601600, 3.0926016*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3218832000, 3.218832*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3281904000, 3.281904*^9], 
        FormBox["\" \"", TraditionalForm]}}, {{
        NCache[2208988800, 2.2089888*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2524521600, 2.5245216*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2840140800, 2.8401408*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3155673600, 3.1556736*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2272060800, 2.2720608*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2335219200, 2.3352192*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2398291200, 2.3982912*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2461449600, 2.4614496*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2587680000, 2.58768*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2650752000, 2.650752*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2713910400, 2.7139104*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2776982400, 2.7769824*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2903212800, 2.9032128*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2966371200, 2.9663712*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3029443200, 3.0294432*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3092601600, 3.0926016*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3218832000, 3.218832*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3281904000, 3.281904*^9], 
        FormBox["\" \"", TraditionalForm]}}}},
   GridLines->NCache[{{{2208988800, 
        GrayLevel[0.8]}, {2524521600, 
        GrayLevel[0.8]}, {2840140800, 
        GrayLevel[0.8]}, {3155673600, 
        GrayLevel[0.8]}}, None}, {{{2.2089888*^9, 
        GrayLevel[0.8]}, {2.5245216*^9, 
        GrayLevel[0.8]}, {2.8401408*^9, 
        GrayLevel[0.8]}, {3.1556736*^9, 
        GrayLevel[0.8]}}, None}],
   PlotRange->{{2.2089888*^9, 3.3135264*^9}, {0., 2.794856489081232*^12}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]},
   Ticks->None]}, {4,
  GraphicsBox[RasterBox[CompressedData["
1:eJztmH9Uk1UYx98x2BgD3gmMsbFB/BAyQAlpCO2IUiSnQlOyREWBAk04olCy
VE6hoksFRERRUPLISUtUkgrtl2igaEYQIfJD0UrNJLQUVKbdnmfurR0aCtOx
f3rO+Z67e3ff+37e+977PM993eJTpsSzKYp6XCtz6n9js9mRcnnA8mHDBF9i
1dQ8OiYDhXG5nNsV+3cT4LsF9WdNDQUmpWm6Zu6chIbNhfk36k7WkPbWRgLt
qDdNyGUjEjkWIMeitxbe/eWnVsJob9kHxHu451cmZEMj2WtX9TY1ntQw4bxh
eb6jmbS1NJC42Jhm6CMFRYLEQw3n5ua6PCwstDc4OOhq0rzEq6MD/MtemvRi
dVJSYn1xUcGd9EWpJCjoqSq5PPCyVOq8f6j5wDiwV3OgjLawsHgFShaIB3IQ
ix0XQ9tlc3Nz9RtzX++ZMX1aJ4/HKzIB44OMzeVyr+3auZ14erpfgLrLQ4wl
BBEzM7NeKL1AHo8CUCwSvTbc06MrdvaMdqjGUIaHienIl78+W+MbbG1trkDp
/AgQg3JzVJdaT9eTUSP91Hw+f4GB4wRmLE1vxz14+NABkpw0p416+Dlk+fv5
pJTu2Hqn40wTCR2ruMXhcKKg3cKAsR4DkW+OfKHxE9vfL+qG+viH5BuVkaE8
3dhwnEjE4huwXy5Bm6XO/7xBjDUB+Zqb6jR8xVsK1PCskw3k4goEtklWVlYF
GUuUPZ9UlBEPD7c9uh1cXWW4xy8MYkypi4vsN1wnyJeWOv8a+IQpBrCZCwR0
zYQJ4ddjZkarce6OH6tCX1gN/9Ggl0HJUVGTOhWK4M8HOqilpWUe8HX/fL5F
w/fdt9VEKBTWDoJLwGKxVsA4s2Qy58bao4eIbsxbn7e2i8+3agoJGdMJvvvi
poJ1NyNfiBjwXhE6OGA+RLJWvKMZD3+D/10zCL6FeI2jo1BdkJ/brcuGwucG
JnLgs3ISFjauMzIyIp0axPqDtauEIoHH456j7uUeKN8BXOoOmgd5Ved7quV3
mfnvqyNVB8mG/JwrwcHyjQMct6+xtKUZKJZ6cEx3gGc6yzwLvL//zBmqZGth
T3xczInQUIUK+j+tcx9jmquzs6R6zeosgvtJ35xh2749O8HPW7dAf7shYNIY
TfOfsbGx7oEc+S9984VcJdsK1UsWL2pVrVzWQdva3obL4ocADedgDfiOrh/q
a/WusZbm70lgYMCfQqH9VujrChoBmgjiGpkN1yT6avJx+Ud62U6fqiNeXp6/
cjiafTbUloJsfX0aI4ytiQlxFyCXes4EbJYQR/6AnEHvemMUFzsT44O9Cfjo
qVMnH8UzWX9sVV9XEkXImGUmYMO4F120ZUNvf2wnag+TiIjwLuiqMBaDj8+I
V319fXaD/wzRacY94QS+5MC24k16/UjpjuKbEOMPQr9plPH8Lg05fVvs7JmY
1xNtnLOGWF+C9cx3F+uNC8r0tN8lEkkW9LExEheai4/PE42pC5J7YG/eRn+P
TPBOMTfV5NH62DC3Gf2kf4URuRibMjHy+YvoH5h7Y35aX3es372AKt+7i0gk
TqWU8WMp+niib33dT6uyMpn8xtCzzkCNeLi73Tl39tSA2bCvtTWf4dNde8aY
Sz9Ya29DPntL9x0/SLnZKg0fTdN5UDrB/poFZ5VdRuATjB83thLPCMjH5El7
ykp7wB/fN15gHhwTE62m/s1lUYacG+9nFiEhclVQUGC9SOR4daSfbzfuTbyX
UpmmOYsw56X+hN/StGyhj5iNMfwGi2dSmbWVFb4vAnE+wdvbq0p7X7Isc2m/
fJWf7mP4/I3Ep2s0sDVByafu5Wz2sMYwPpDCjXnkTNuP/3BhLrMyK/NK0rzE
Bvwf8qoPh4APre/3G5adnV0lnLU7ZTLp9XW5q+9u3rSemTP8vuAE4mifyVTG
1jKECwQ28+Hc3wq/E4xxo78BEvI7/Q==
    "], {{0, 0}, {40, 40}}, {0, 255},
    ColorFunction->RGBColor],
   Background->None,
   ImageSize->{40, 40},
   PlotRange->{{0, 40}, {0, 40}}]->
  GraphicsBox[{{}, 
    {Hue[0.67, 0.6, 0.6], 
     PointBox[{{2.2089888*^9, 1.1001857267906438`*^11}, {2.2405248*^9, 
      1.208138060400842*^11}, {2.2720608*^9, 1.4051891364948038`*^11}, {
      2.3036832*^9, 1.6924997901562256`*^11}, {2.3352192*^9, 
      1.9190272481504858`*^11}, {2.3667552*^9, 2.180850414845017*^11}, {
      2.3982912*^9, 2.147967296050531*^11}, {2.4299136*^9, 
      2.4615984711328445`*^11}, {2.4614496*^9, 3.0110685730610004`*^11}, {
      2.4929856*^9, 3.7633987340165295`*^11}, {2.5245216*^9, 
      4.5847054570827466`*^11}, {2.556144*^9, 4.143881892309424*^11}, {
      2.58768*^9, 4.1068947165956665`*^11}, {2.619216*^9, 
      4.259969852143084*^11}, {2.650752*^9, 4.2190574220929376`*^11}, {
      2.6823744*^9, 4.353899537941441*^11}, {2.7139104*^9, 
      6.169717535000852*^11}, {2.7454464*^9, 7.76334491116145*^11}, {
      2.7769824*^9, 8.590083924665312*^11}, {2.8086048*^9, 
      8.947177390136152*^11}, {2.8401408*^9, 1.13346545429888*^12}, {
      2.8716768*^9, 1.1952212090324875`*^12}, {2.9032128*^9, 
      1.265830956132651*^12}, {2.9348352*^9, 1.0209509577101204`*^12}, {
      2.9663712*^9, 1.0539769534685912`*^12}, {2.9979072*^9, 
      1.126076542839802*^12}, {3.0294432*^9, 1.2596573470019568`*^12}, {
      3.0610656*^9, 1.19235440187141*^12}, {3.0926016*^9, 
      1.2171187235257039`*^12}, {3.1241376*^9, 1.2007866317323293`*^12}, {
      3.1556736*^9, 1.0973432886781492`*^12}, {3.187296*^9, 
      1.1173484826847188`*^12}, {3.218832*^9, 1.2189766944107778`*^12}, {
      3.250368*^9, 1.507113125025088*^12}, {3.281904*^9, 
      1.724522852463169*^12}, {3.3135264*^9, 1.7624749651606726`*^12}}]}, {}},
   
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   AxesOrigin->NCache[{2208988800, 0}, {2.2089888*^9, 0}],
   Frame->True,
   FrameTicks->{{Automatic, Automatic}, {{{
        NCache[2208988800, 2.2089888*^9], 
        FormBox["\"1970\"", TraditionalForm]}, {
        NCache[2524521600, 2.5245216*^9], 
        FormBox["\"1980\"", TraditionalForm]}, {
        NCache[2840140800, 2.8401408*^9], 
        FormBox["\"1990\"", TraditionalForm]}, {
        NCache[3155673600, 3.1556736*^9], 
        FormBox["\"2000\"", TraditionalForm]}, {
        NCache[2272060800, 2.2720608*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2335219200, 2.3352192*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2398291200, 2.3982912*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2461449600, 2.4614496*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2587680000, 2.58768*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2650752000, 2.650752*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2713910400, 2.7139104*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2776982400, 2.7769824*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2903212800, 2.9032128*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2966371200, 2.9663712*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3029443200, 3.0294432*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3092601600, 3.0926016*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3218832000, 3.218832*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3281904000, 3.281904*^9], 
        FormBox["\" \"", TraditionalForm]}}, {{
        NCache[2208988800, 2.2089888*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2524521600, 2.5245216*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2840140800, 2.8401408*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3155673600, 3.1556736*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2272060800, 2.2720608*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2335219200, 2.3352192*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2398291200, 2.3982912*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2461449600, 2.4614496*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2587680000, 2.58768*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2650752000, 2.650752*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2713910400, 2.7139104*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2776982400, 2.7769824*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2903212800, 2.9032128*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2966371200, 2.9663712*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3029443200, 3.0294432*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3092601600, 3.0926016*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3218832000, 3.218832*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3281904000, 3.281904*^9], 
        FormBox["\" \"", TraditionalForm]}}}},
   GridLines->NCache[{{{2208988800, 
        GrayLevel[0.8]}, {2524521600, 
        GrayLevel[0.8]}, {2840140800, 
        GrayLevel[0.8]}, {3155673600, 
        GrayLevel[0.8]}}, None}, {{{2.2089888*^9, 
        GrayLevel[0.8]}, {2.5245216*^9, 
        GrayLevel[0.8]}, {2.8401408*^9, 
        GrayLevel[0.8]}, {3.1556736*^9, 
        GrayLevel[0.8]}}, None}],
   PlotRange->{{2.2089888*^9, 3.3135264*^9}, {0., 1.7624749651606726`*^12}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]},
   Ticks->None]}, {5,
  GraphicsBox[RasterBox[CompressedData["
1:eJzVmGtsDFEUx+/O7PspW9XqKm0QlXrUJ0HrGYKE2CJEbFO7Sry1ql6JR8W7
XtUi2giaiPhEJB7RtKWpiqxGqdIqpQgfRDw+aHV3r3NmZ9bsqMSX7q1/cnLu
zszm/ubcO+eeexPd69LdPCEkSTQ1+e9kA7vEcdx78FGsYRTSgHWCUZnFMyUK
lw7idg08HTxoYMdST+YPaBeyhlJo7qiUkV9aXz6lZ0tP/jSZTAdZA8k0QKvV
loCnOdlr/NV3b0tjPFmr1dwR23Gs4GBsK0UGuiFnLX3V0iCfh5IhXzRYbwaI
AkNiwgDfm9ZndPWq5WFs58+d8ev1+m/YttksXvBRZrOxQrzvjgDfMKKIl9ls
fgi+DdvA2zFr1sxAVcUNmpo6NvSdl50vCYjtmAgwoqww1gGe55Vj61P8foT+
UV2t/NpHMBUJ5k49mKE7AIGvFvuLirJ3Xr1ymeZuWBtwLV7oJ3/OR3qq+Bg9
ffJ4V3NVnkO7I4/iUujBPg7s3+1/19ZM0V40P6b79uyiK1dk0dqaCvr2TRN9
3lgnsNhsNnq36hb1Pqj+g9NkMlzoBkZUktRHhmtRZ97G7O9FJ474du3cRhMS
+gtjjnz4TUnvILxHUz0tOVOkjPnobmJM5jmuHvwtsEnR0dH5RqOhSeyzxWq1
+pFHzidZnbeGxsb08Z0oLGgXn49kbuLABmG/f+OTbFNezldYj6ZEkE2uTI8n
4/3Rw/vpyxcNXfIVHi/4Ds9NYMRH7HZ7MxHn2fp1q3zK+Qj5XZqDfVjwxcbG
lIv9r1CpVEJOb2l+EsaYkjLiA1wfzoIPpNZoNC4SzEsqg053MWvpkva2189D
fPPmzsGczmLt7lJ2e6/DO7Zv/YaMFeXXKcQV800Say6Zkp3O2Q3Ih2NNfufB
qYy5QoqPd2wpLSkWxhfXFhLky2fNJdOE7PVr2nAdxDimpY2TGHuKTEOHJrU0
NjxUxrAnCGssgefpE6/AhzVFv7i4etZgMg00Go0d0vq3LMvdDuv1UdZQojAX
ZoLRLZtzOzzuDAqsrSR4DtBThPV0KLfwPOdlzKPUSCJw8UI9ZrFY9rEGUgj3
IvLc3Fe8jnFdyApKksPRF88gBDbY/98Gz4N3Qr0j1bdDWPJBzRDa90s2Y/q0
z3cqb+I5wCfgdLLkA2lh7lVB7RwoOLSX3r9XGapncN8yYnjyZxl7LwZ8KrVa
/Rj7h1h+LbtQGlYTYr0NcZT2+GjpEebDHKgl4ndSXHQkjA/rGlzz+jnihL2e
Xq93RZhPromp48Z8kurqmupyarVa5HvQNIZsKMf41LGvsJZZkun6iUw6nW43
eAPE7SrHcTdIMO+wUu/585yNebnZ0lmOXnGfJRv2nS87d4plyNKV8Px9AQmy
Jf7rn34BC2Nb9A==
    "], {{0, 0}, {40, 40}}, {0, 255},
    ColorFunction->RGBColor],
   Background->None,
   ImageSize->{40, 40},
   PlotRange->{{0, 40}, {0, 40}}]->
  GraphicsBox[{{}, 
    {Hue[0.67, 0.6, 0.6], 
     PointBox[{{2.2089888*^9, 2.014529580514261*^11}, {2.2405248*^9, 
      2.2755033969951434`*^11}, {2.2720608*^9, 3.01343259543402*^11}, {
      2.3036832*^9, 4.094100716072971*^11}, {2.3352192*^9, 
      4.544586112238592*^11}, {2.3667552*^9, 4.941750673051077*^11}, {
      2.3982912*^9, 5.554042215464973*^11}, {2.4299136*^9, 
      6.835571874274996*^11}, {2.4614496*^9, 9.604251124685349*^11}, {
      2.4929856*^9, 9.996525293671614*^11}, {2.5245216*^9, 
      1.0473829652743596`*^12}, {2.556144*^9, 1.1575808025550977`*^12}, {
      2.58768*^9, 1.0757971376079556`*^12}, {2.619216*^9, 
      1.173473359359394*^12}, {2.650752*^9, 1.2486767468971565`*^12}, {
      2.6823744*^9, 1.3367483967990293`*^12}, {2.7139104*^9, 
      1.980635436908171*^12}, {2.7454464*^9, 2.4020878317749478`*^12}, {
      2.7769824*^9, 2.91659077365674*^12}, {2.8086048*^9, 
      2.9183378659623613`*^12}, {2.8401408*^9, 2.9957356166212617`*^12}, {
      2.8716768*^9, 3.4256890248509097`*^12}, {2.9032128*^9, 
      3.738954620999907*^12}, {2.9348352*^9, 4.291732742888624*^12}, {
      2.9663712*^9, 4.724875099850551*^12}, {2.9979072*^9, 
      5.206658298158463*^12}, {3.0294432*^9, 4.620456505153843*^12}, {
      3.0610656*^9, 4.233781703969587*^12}, {3.0926016*^9, 
      3.842264579344679*^12}, {3.1241376*^9, 4.3476498177611074`*^12}, {
      3.1556736*^9, 4.649615208479153*^12}, {3.187296*^9, 
      4.0877240379293174`*^12}, {3.218832*^9, 3.904826021289916*^12}, {
      3.250368*^9, 4.231250256567769*^12}, {3.281904*^9, 
      4.584885115685265*^12}, {3.3135264*^9, 4.558949854127995*^12}}]}, {}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   AxesOrigin->NCache[{2208988800, 0}, {2.2089888*^9, 0}],
   Frame->True,
   FrameTicks->{{Automatic, Automatic}, {{{
        NCache[2208988800, 2.2089888*^9], 
        FormBox["\"1970\"", TraditionalForm]}, {
        NCache[2524521600, 2.5245216*^9], 
        FormBox["\"1980\"", TraditionalForm]}, {
        NCache[2840140800, 2.8401408*^9], 
        FormBox["\"1990\"", TraditionalForm]}, {
        NCache[3155673600, 3.1556736*^9], 
        FormBox["\"2000\"", TraditionalForm]}, {
        NCache[2272060800, 2.2720608*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2335219200, 2.3352192*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2398291200, 2.3982912*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2461449600, 2.4614496*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2587680000, 2.58768*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2650752000, 2.650752*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2713910400, 2.7139104*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2776982400, 2.7769824*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2903212800, 2.9032128*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2966371200, 2.9663712*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3029443200, 3.0294432*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3092601600, 3.0926016*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3218832000, 3.218832*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3281904000, 3.281904*^9], 
        FormBox["\" \"", TraditionalForm]}}, {{
        NCache[2208988800, 2.2089888*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2524521600, 2.5245216*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2840140800, 2.8401408*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3155673600, 3.1556736*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2272060800, 2.2720608*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2335219200, 2.3352192*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2398291200, 2.3982912*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2461449600, 2.4614496*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2587680000, 2.58768*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2650752000, 2.650752*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2713910400, 2.7139104*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2776982400, 2.7769824*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2903212800, 2.9032128*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2966371200, 2.9663712*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3029443200, 3.0294432*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3092601600, 3.0926016*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3218832000, 3.218832*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3281904000, 3.281904*^9], 
        FormBox["\" \"", TraditionalForm]}}}},
   GridLines->NCache[{{{2208988800, 
        GrayLevel[0.8]}, {2524521600, 
        GrayLevel[0.8]}, {2840140800, 
        GrayLevel[0.8]}, {3155673600, 
        GrayLevel[0.8]}}, None}, {{{2.2089888*^9, 
        GrayLevel[0.8]}, {2.5245216*^9, 
        GrayLevel[0.8]}, {2.8401408*^9, 
        GrayLevel[0.8]}, {3.1556736*^9, 
        GrayLevel[0.8]}}, None}],
   PlotRange->{{2.2089888*^9, 3.3135264*^9}, {0., 5.206658298158463*^12}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]},
   Ticks->None]}, {6,
  GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJmYGDQgGIWhlEwCkbBKBgFo2BIAkYgNgNiNSibFoAJiDmgbBAt
A2WzQmkjBtxVKchN/6F4Mw3cZo5kPjLuwCI2C4g9gZgZST87mho2ajmMkZFx
D8hMTU31v/fuXPmfEB/zf+OGVf/Z2Fj/gcQ3rFvxf8b0Sf9v37r0//rVc//D
w4J/Q92QBDUiHosfhHFYJ8rMzHSWAREnBJ0nLCj4eMe2Df+fPLqFgh89uPH/
8cObGOIgN0LdMBPot1MwvwkI8P/z9HCDuZ0Pi12g8L4Glc/EIg9KU7C0C6Kd
Yf4FhRu6O/Dh9LSkXzC9p04chIufPX0E5nYnLPbzMGCGMyy9RyGJCQKxA4yP
LeyIwaD4Rg7fC+eOA92dDLMDW/zNA8nduXX5f39fJ0wdPxDfBbG9vTww0v/5
s8fIchsyvnLpNLq5T7G4DQT++/h4gvVcvXwGRU9Odjo4PR3cvwMsR6mbkDEo
bUDtuQfEU3G4jQHZPcuXzgeH/+FDu8FpgpruQcegOEayGz1e1YHYAIkvDFN7
49o5mroL2X1I6Q5efgPz9mIkd8OAJIhfVlqItWzAhU8c20/NMNQCum0WEv8i
kvtA5fZ/KSnJf8SUGQ/uXftvZWUBN9vIyIAkfyFjUPpGTmMtzXUwdiiS++D1
ICgvEGNuR3sTRr5+eP86WWFYW1OOrY5kx5ZXlJWV/uKyB1RWRYSHYDMLjGfP
mgJWd/H8CTBfU0P9v5+v9/8Z0yaC+f29HVjNDQ7yRzcLV1tmIkgeVG+Cwh2k
V0xM9B8O94Dqmkvo4lqaGmB34vJDe2sjhvv27t5KrPtA+WcqLrOh2ANNizSU
BrWzbmBRDyo7QOWFCLL4uTNH/y+YPxPuxu1b1//fv3cbTF4cl/uQgBELC8sy
LPYR0wYqZYDU0+jhAPLDdGTzrl05C3djbGwkTJyXCDtgQB/NfdQCEjAzz5w6
TEzewAdA4YCtbUEJgJcZ/X0db6FsEE1M3NINANM7qN1pB8RcA+2WUTAKRsEo
GAXEAwCwGZ4C
    "], {{0, 0}, {40, 40}}, {0, 255},
    ColorFunction->RGBColor],
   Background->None,
   ImageSize->{40, 40},
   PlotRange->{{0, 40}, {0, 40}}]->
  GraphicsBox[{{}, 
    {Hue[0.67, 0.6, 0.6], 
     PointBox[{{2.8401408*^9, 5.697118807301721*^11}, {2.8716768*^9, 
      5.60148358206564*^11}, {2.9032128*^9, 4.899543440560434*^11}, {
      2.9348352*^9, 4.576050839536752*^11}, {2.9663712*^9, 
      4.0791335145689514`*^11}, {2.9979072*^9, 3.991662245416091*^11}, {
      3.0294432*^9, 3.9208952318958527`*^11}, {3.0610656*^9, 
      4.049406205883203*^11}, {3.0926016*^9, 2.709531602854175*^11}, {
      3.1241376*^9, 1.95907924077677*^11}, {3.1556736*^9, 
      2.597178361724186*^11}, {3.187296*^9, 3.066175749373683*^11}, {
      3.218832*^9, 3.4548832824979877`*^11}, {3.250368*^9, 
      4.3148797448197046`*^11}, {3.281904*^9, 5.902873738774519*^11}, {
      3.3135264*^9, 7.659680383768098*^11}}]}, {}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   AxesOrigin->NCache[{2208988800, 2.*^11}, {2.2089888*^9, 2.*^11}],
   Frame->True,
   FrameTicks->{{Automatic, Automatic}, {{{
        NCache[2208988800, 2.2089888*^9], 
        FormBox["\"1970\"", TraditionalForm]}, {
        NCache[2524521600, 2.5245216*^9], 
        FormBox["\"1980\"", TraditionalForm]}, {
        NCache[2840140800, 2.8401408*^9], 
        FormBox["\"1990\"", TraditionalForm]}, {
        NCache[3155673600, 3.1556736*^9], 
        FormBox["\"2000\"", TraditionalForm]}, {
        NCache[2272060800, 2.2720608*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2335219200, 2.3352192*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2398291200, 2.3982912*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2461449600, 2.4614496*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2587680000, 2.58768*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2650752000, 2.650752*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2713910400, 2.7139104*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2776982400, 2.7769824*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2903212800, 2.9032128*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2966371200, 2.9663712*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3029443200, 3.0294432*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3092601600, 3.0926016*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3218832000, 3.218832*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3281904000, 3.281904*^9], 
        FormBox["\" \"", TraditionalForm]}}, {{
        NCache[2208988800, 2.2089888*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2524521600, 2.5245216*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2840140800, 2.8401408*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3155673600, 3.1556736*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2272060800, 2.2720608*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2335219200, 2.3352192*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2398291200, 2.3982912*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2461449600, 2.4614496*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2587680000, 2.58768*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2650752000, 2.650752*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2713910400, 2.7139104*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2776982400, 2.7769824*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2903212800, 2.9032128*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2966371200, 2.9663712*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3029443200, 3.0294432*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3092601600, 3.0926016*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3218832000, 3.218832*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3281904000, 3.281904*^9], 
        FormBox["\" \"", TraditionalForm]}}}},
   GridLines->NCache[{{{2208988800, 
        GrayLevel[0.8]}, {2524521600, 
        GrayLevel[0.8]}, {2840140800, 
        GrayLevel[0.8]}, {3155673600, 
        GrayLevel[0.8]}}, None}, {{{2.2089888*^9, 
        GrayLevel[0.8]}, {2.5245216*^9, 
        GrayLevel[0.8]}, {2.8401408*^9, 
        GrayLevel[0.8]}, {3.1556736*^9, 
        GrayLevel[0.8]}}, None}],
   PlotRange->
    NCache[{{2208988800, 3.3135264*^9}, {1.95907924077677*^11, 
      7.659680383768098*^11}}, {{2.2089888*^9, 3.3135264*^9}, {
     1.95907924077677*^11, 7.659680383768098*^11}}],
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]},
   Ticks->None]}, {7,
  GraphicsBox[RasterBox[CompressedData["
1:eJzdmHtQVFUYwA/7ELblIRCguwspqQmLoag5PRzGrEinx+Q/9UdOiKnVNFA8
MtDEaggTRHuYGIFOQUKshmCm02QBRoQpSog8fFt/2Eh/OBqQu/v1fXc529ld
RJvx3tv0zXxzz+Fc7vnt9zjnO2diWsaiNC1jbOqw6tj/Q4KCglJ1Ol0DNgE1
WBj6r/xE8NIcof248J6f8miS3IY6n/lyco1E+1Zotdrjer1+KfYfMxqNa/E5
R2HOR4mnqrICfj3fC309x2DF8qWXUlIe7snOSu+/7945ThrHeLjG2U2m8baw
sLC0qKiojdjXKMBYSvNWflYuMZ4+2QlnT3dJbdKuzsMwPXGaMzn5AXt52UcO
W20lvLepCF595eWhyIiIiwaDoYe5/CGXGFF3EmNOdsZFqzXucsvBA4Ocj9uV
nufPdoP491N9nTB7VtIAc9lWKxMf5UAIaoGfn9/J4bnInh6M3mqrrXIyz5i1
3mowzIFMcY78NXl/XjjXA/PmJf9F/cbv9l2X76uGnQ56B3PoBD4n3Wo2lCT6
/pTJkyApafqVrMx0Z8fRVrcP9+7ZBT/+cMDHp6JGWywSI9q9UQY+TUBAQDt9
v6S48LoMN9Lqz7dz+98hAyPF3p30/fz8vN9Hs9VouiR1cT9+4yEZ+LgYMRYv
f1K2Gc6dOfGv+XZUbXOEh4cvloHLH7leQrVhG+p3f3FTPLgOwqq816729XZI
/ZIN64bGjg1eLQMf02g0tH9JMbRvb90N2dpaGz32wpkzZ1yIjZ1Yg22DHHwo
U/hcmCf2ovUFzkVPPTFwqK0JaK0ZiZHGYmIszfg/d6OamLx1xO2M+dYI2yu2
jshGPk1MnDYUHW3OYPLtGaMJ2QPeXfe2j/0wf8Q9Y74KbCRUo8IGXBPF9YZY
f25rhoULHnFMmBBTrCYb6cIFKSPuHWaziWotir0AFfimYj471+avcnpzkf0K
C97kvr1LQaZI1Bmoz6CuRv9dPXPquAcb7cXsn7gzK8gWx24id03jx9l1Wm05
jukVZCNZSTy5r2fD/q/rYM0buVJ+Yg3v4DX0sfZWCAkJvjL8W5SUcaizIiLC
VyLfoLiWiO3dX9bQ+eM3pmw+kJ+otnT7tLf7qE+uEmfqc886AgMD1zNlzkJu
8ff3X4FnR4kxISF+QLQZr2Fqqj/l/LFKsqFkMK+cKC56B/bU2xy8n5ebY8ez
2WBoaOjTCrORSP7FutzN1/ZTE1jj49x8TB27cZHm1+lc8dfZccgdb03f7xf5
otWAQ7v9QfPjXiFxUJyJeVG65X2wmE10rl2iBh/KW0zwI9XN3rUK+Xt43KIC
XwjabpDmb6iv9bjPEHMYa4RL+M6DCrPRfZ/bdltLP5Bs573nktI9C+4lJUrC
Yex1iHwvvvA8tB9ukdq4Jjqam76BLZs3QdnHH0LLwW9h7tz7f8GxyQoiBjHX
3iHdYdTtqpbsR7ai/pgx+n6RH8/wR5g695SpnCErMx26u45wpmXMVacaVOIS
RbqfLC4qvEa1MtUCzMU4W2UuLoGokGCNdy5flmanNWVH1TbOeI/KbFyeZCPf
QafIMdnf1M1Cqg==
    "], {{0, 0}, {40, 40}}, {0, 255},
    ColorFunction->RGBColor],
   Background->None,
   ImageSize->{40, 40},
   PlotRange->{{0, 40}, {0, 40}}]->
  GraphicsBox[{{}, 
    {Hue[0.67, 0.6, 0.6], 
     PointBox[{{2.2089888*^9, 1.2363590126436914`*^11}, {2.2405248*^9, 
      1.3980572083619217`*^11}, {2.2720608*^9, 1.6063569485203543`*^11}, {
      2.3036832*^9, 1.8124513969447748`*^11}, {2.3352192*^9, 
      1.957702847195009*^11}, {2.3667552*^9, 2.3398975145108023`*^11}, {
      2.3982912*^9, 2.2479207505729996`*^11}, {2.4299136*^9, 
      2.5385680838041418`*^11}, {2.4614496*^9, 3.21772819807636*^11}, {
      2.4929856*^9, 4.179666923422399*^11}, {2.5245216*^9, 
      5.361321896283531*^11}, {2.556144*^9, 5.083982851941528*^11}, {
      2.58768*^9, 4.840449529095338*^11}, {2.619216*^9, 
      4.5894000027881354`*^11}, {2.650752*^9, 4.3150455371477625`*^11}, {
      2.6823744*^9, 4.5550699023655786`*^11}, {2.7139104*^9, 
      5.58954105166052*^11}, {2.7454464*^9, 6.857539263293876*^11}, {
      2.7769824*^9, 8.331747712214061*^11}, {2.8086048*^9, 
      8.412809635246335*^11}, {2.8401408*^9, 9.89564266780465*^11}, {
      2.8716768*^9, 1.0334817518162361`*^12}, {2.9032128*^9, 
      1.0715859646146346`*^12}, {2.9348352*^9, 9.624067386994218*^11}, {
      2.9663712*^9, 1.0413426629112925`*^12}, {2.9979072*^9, 
      1.1336896670768289`*^12}, {3.0294432*^9, 1.1912803900154153`*^12}, {
      3.0610656*^9, 1.3270351591864573`*^12}, {3.0926016*^9, 
      1.4251182105389539`*^12}, {3.1241376*^9, 1.4649752807122458`*^12}, {
      3.1556736*^9, 1.4427772951531748`*^12}, {3.187296*^9, 
      1.4348964593935117`*^12}, {3.218832*^9, 1.571371904459777*^12}, {
      3.250368*^9, 1.805663111405002*^12}, {3.281904*^9, 
      2.1321560657658647`*^12}, {3.3135264*^9, 
      2.1987957539265283`*^12}}]}, {}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   AxesOrigin->NCache[{2208988800, 0}, {2.2089888*^9, 0}],
   Frame->True,
   FrameTicks->{{Automatic, Automatic}, {{{
        NCache[2208988800, 2.2089888*^9], 
        FormBox["\"1970\"", TraditionalForm]}, {
        NCache[2524521600, 2.5245216*^9], 
        FormBox["\"1980\"", TraditionalForm]}, {
        NCache[2840140800, 2.8401408*^9], 
        FormBox["\"1990\"", TraditionalForm]}, {
        NCache[3155673600, 3.1556736*^9], 
        FormBox["\"2000\"", TraditionalForm]}, {
        NCache[2272060800, 2.2720608*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2335219200, 2.3352192*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2398291200, 2.3982912*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2461449600, 2.4614496*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2587680000, 2.58768*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2650752000, 2.650752*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2713910400, 2.7139104*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2776982400, 2.7769824*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2903212800, 2.9032128*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2966371200, 2.9663712*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3029443200, 3.0294432*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3092601600, 3.0926016*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3218832000, 3.218832*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3281904000, 3.281904*^9], 
        FormBox["\" \"", TraditionalForm]}}, {{
        NCache[2208988800, 2.2089888*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2524521600, 2.5245216*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2840140800, 2.8401408*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3155673600, 3.1556736*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2272060800, 2.2720608*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2335219200, 2.3352192*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2398291200, 2.3982912*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2461449600, 2.4614496*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2587680000, 2.58768*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2650752000, 2.650752*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2713910400, 2.7139104*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2776982400, 2.7769824*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2903212800, 2.9032128*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2966371200, 2.9663712*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3029443200, 3.0294432*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3092601600, 3.0926016*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3218832000, 3.218832*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3281904000, 3.281904*^9], 
        FormBox["\" \"", TraditionalForm]}}}},
   GridLines->NCache[{{{2208988800, 
        GrayLevel[0.8]}, {2524521600, 
        GrayLevel[0.8]}, {2840140800, 
        GrayLevel[0.8]}, {3155673600, 
        GrayLevel[0.8]}}, None}, {{{2.2089888*^9, 
        GrayLevel[0.8]}, {2.5245216*^9, 
        GrayLevel[0.8]}, {2.8401408*^9, 
        GrayLevel[0.8]}, {3.1556736*^9, 
        GrayLevel[0.8]}}, None}],
   PlotRange->{{2.2089888*^9, 3.3135264*^9}, {0., 2.1987957539265283`*^12}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]},
   Ticks->None]}, {8,
  GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJmYGDQgGIWhlEwCkbBKBgFVADRQPwfiKUG2iFYwAQGiNtAeC0Z
+iOo6xwUoADE/62tLWHuA2E2IvUyIukBYWYquYkfZB4jI+M3EB0eHvz78cOb
/+tqK5HtAoWJERAnAHEFENtB3QMDzDC1vj6eIHMc0eTJBYIgM6sqS/9bWVn8
dHdz+fPk0a3/MHzrxgVkN6JjTagZVkBsjybnTaZ79IDYEoh9gVgLZh6ym7Dh
B/eu/b9+9dz/06cO/Qf64R8eN8MwqUBYQU6m1MTY4EFRYc6r6qqyPxYWZp9a
Wxq+EXIbNvzw/vX/9+5c+T95Ui/Y7YcO7kJ2GzcJ7rIBpqsuYWGh17NnTvnx
6MENkt1CDL5/9+p/dTVVUvNFIUh9YkLsvwvnjtPEXcg4OSkO5r67DISbo/Eg
tTNnTKa5u5AxMCxgblTG4S5Qnp4HUrN29VK6ug2EQeUSA/7yjw0mD0oT9HYf
CJ86eQhfPlYCic+aSd94RcZ3b19Bdp8FmvsiQeLZWWngMmAg3GdmZoLsPpR8
AixL9oDEQX4YCLft3LERvZxmQnYfMzPz0ZDgALqFHSg/HNy/A0UMzX3o5cz/
zIyUP/Rw2+2bF/8rKyv9BdlpZ2v9B+RWUJ48e/rI/5iYCJj7BNDcFwYSv33r
El3Cb+nief95eXkvs7GxHUtKjHsNijeQO+fMnoochuxI7ksHiZ0/e4wu7ps7
Z9ovaWnpOKCdpgzgdlDJO1C9DJLbvnU9shtZkeMY6Jd/tI5bCQnxf8D8CIpf
WF3BCcT/+no7wGounj+Bq6wOgolfvniSZLtBaQjUJgGxQWGxZvWS/zHREf8D
Anz/Hjm0B1Rn/oSa/wstXEDAAySXl5PxA6QWqm41A2pb1QDmPlBaQLYb1IY7
fnTf/w3rVgDtmfQxIz3lUV5e5vnExNiToSGBR3y8PPZ7errt8PLy2OHi4ngK
OS8Cw+oaiAamtxkMkHoAF5Di4OCoYkDNxyFoauByoDJpzuxpnzPSki+4ujqv
t7GxapOQEAWFMaidqgPEogyQNj47mhmgODFBixuih8lYWVmvdbQ3YavruJHd
Z2Cg1wykHYBYglizqQCYubm518nLyf7j4eHZh0UelC5YGDDTBz0BLysz8xEG
SL4ZBaNgFIwCmgIAaC0IUA==
    "], {{0, 0}, {40, 40}}, {0, 255},
    ColorFunction->RGBColor],
   Background->None,
   ImageSize->{40, 40},
   PlotRange->{{0, 40}, {0, 40}}]->
  GraphicsBox[{{}, 
    {Hue[0.67, 0.6, 0.6], 
     PointBox[{{2.2089888*^9, 1.025*^12}, {2.2405248*^9, 1.1134*^12}, {
      2.2720608*^9, 1.2254*^12}, {2.3036832*^9, 1.3698*^12}, {2.3352192*^9, 
      1.4864000007432*^12}, {2.3667552*^9, 1.624000001624*^12}, {2.3982912*^9,
       1.8098000018098*^12}, {2.4299136*^9, 2.0143000020143*^12}, {
      2.4614496*^9, 2.2769000022769*^12}, {2.4929856*^9, 
      2.5445000025445*^12}, {2.5245216*^9, 2.7689000027689*^12}, {2.556144*^9,
       3.1054000031054*^12}, {2.58768*^9, 3.2295000032295*^12}, {2.619216*^9, 
      3.5088000035088*^12}, {2.650752*^9, 3.902600001626085*^12}, {
      2.6823744*^9, 4.1875*^12}, {2.7139104*^9, 4.4277*^12}, {2.7454464*^9, 
      4.7021*^12}, {2.7769824*^9, 5.0639*^12}, {2.8086048*^9, 5.4417*^12}, {
      2.8401408*^9, 5.7572*^12}, {2.8716768*^9, 5.9469*^12}, {2.9032128*^9, 
      6.2868*^12}, {2.9348352*^9, 6.6043*^12}, {2.9663712*^9, 7.0175*^12}, {
      2.9979072*^9, 7.3423*^12}, {3.0294432*^9, 7.7623*^12}, {3.0610656*^9, 
      8.2509*^12}, {3.0926016*^9, 8.6946*^12}, {3.1241376*^9, 9.2162*^12}, {
      3.1556736*^9, 9.7648*^12}, {3.187296*^9, 1.00759*^13}, {3.218832*^9, 
      1.04176*^13}, {3.250368*^9, 1.09185*^13}, {3.281904*^9, 1.16792*^13}, {
      3.3135264*^9, 1.24558*^13}}]}, {}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   AxesOrigin->NCache[{2208988800, 0}, {2.2089888*^9, 0}],
   Frame->True,
   FrameTicks->{{Automatic, Automatic}, {{{
        NCache[2208988800, 2.2089888*^9], 
        FormBox["\"1970\"", TraditionalForm]}, {
        NCache[2524521600, 2.5245216*^9], 
        FormBox["\"1980\"", TraditionalForm]}, {
        NCache[2840140800, 2.8401408*^9], 
        FormBox["\"1990\"", TraditionalForm]}, {
        NCache[3155673600, 3.1556736*^9], 
        FormBox["\"2000\"", TraditionalForm]}, {
        NCache[2272060800, 2.2720608*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2335219200, 2.3352192*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2398291200, 2.3982912*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2461449600, 2.4614496*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2587680000, 2.58768*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2650752000, 2.650752*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2713910400, 2.7139104*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2776982400, 2.7769824*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2903212800, 2.9032128*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2966371200, 2.9663712*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3029443200, 3.0294432*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3092601600, 3.0926016*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3218832000, 3.218832*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3281904000, 3.281904*^9], 
        FormBox["\" \"", TraditionalForm]}}, {{
        NCache[2208988800, 2.2089888*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2524521600, 2.5245216*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2840140800, 2.8401408*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3155673600, 3.1556736*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2272060800, 2.2720608*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2335219200, 2.3352192*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2398291200, 2.3982912*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2461449600, 2.4614496*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2587680000, 2.58768*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2650752000, 2.650752*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2713910400, 2.7139104*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2776982400, 2.7769824*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2903212800, 2.9032128*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2966371200, 2.9663712*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3029443200, 3.0294432*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3092601600, 3.0926016*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3218832000, 3.218832*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3281904000, 3.281904*^9], 
        FormBox["\" \"", TraditionalForm]}}}},
   GridLines->NCache[{{{2208988800, 
        GrayLevel[0.8]}, {2524521600, 
        GrayLevel[0.8]}, {2840140800, 
        GrayLevel[0.8]}, {3155673600, 
        GrayLevel[0.8]}}, None}, {{{2.2089888*^9, 
        GrayLevel[0.8]}, {2.5245216*^9, 
        GrayLevel[0.8]}, {2.8401408*^9, 
        GrayLevel[0.8]}, {3.1556736*^9, 
        GrayLevel[0.8]}}, None}],
   PlotRange->{{2.2089888*^9, 3.3135264*^9}, {0., 1.24558*^13}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]},
   Ticks->None]}}, 5]], "Output",
 ImageSize->{442, 181},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->245022803]
}, Open  ]],

Cell[TextData[{
 "When arranged across the top, tab labels need to be kept reasonably short. \
The ",
 Cell[BoxData[
  ButtonBox["ControlPlacement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControlPlacement"]], "InlineFormula"],
 " option can be used to move the tabs to any side of the panel",
 "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TabView", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Row", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Rasterize", "[", 
          RowBox[{
           RowBox[{"Show", "[", 
            RowBox[{
             RowBox[{"CountryData", "[", 
              RowBox[{"#", ",", "\"\<Shape\>\""}], "]"}], ",", 
             RowBox[{"ImageSize", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"40", ",", "40"}], "}"}]}]}], "]"}], ",", 
           RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", "#"}], 
        "}"}], "]"}], "\[Rule]", 
      RowBox[{"DateListPlot", "[", 
       RowBox[{"CountryData", "[", 
        RowBox[{"#", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", "\"\<GDP\>\"", "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1970", ",", "2005"}], "}"}]}], "}"}]}], "]"}], "]"}]}], 
     "&"}], "/@", 
    RowBox[{"CountryData", "[", "\"\<GroupOf8\>\"", "]"}]}], ",", " ", 
   RowBox[{"ControlPlacement", "\[Rule]", "Left"}]}], "]"}]], "Input",
 CellLabel->"In[14]:="],

Cell[BoxData[
 TabViewBox[{{1,
  InterpretationBox[
   RowBox[{
    GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJmYGDQgGIWhlEwCoY94ADiaCAWHmiHYAGg7HgPiP+zsbHtAtKM
A+wedAByj5W9ve07IP0fiE8BMdPAOgkF8HNycNybO3va/wvnjv8XEhT8JSYm
lsJA/3AE2acDxIFAPB2IlZiYmPYD6f+OjvZ/nzy69R+E9+7eCgrD/8zMzM1A
mpsK9goAsRY7O7ubno5OkZ6O9nx3d5eFXp5uG7093ff5eHns9/Jy38PKyvqN
ARJ/cFxSnP/z0oUT/2Fug+Erl07/9/f3+QlVpwvE7FC2OwPhcJ0BxK6KinLJ
Tg62C8NCg07X1VY8WDh/1u9dOzf9P7h/x//Ll079v33rEty+h/ev/79x7RyY
fefWZTD9+OFNDHch43t3roD9wMjIuBTNXxw43MWErG7likX/z54+gtcOYvH1
q+dQ+I8e3Pjv5ur8H81dyBgbCIXJe3q6EfQ/sXj92uVwew8d2AkXT0qMI9V9
l2Dy6P4lF4PSAbK9yGkChNHc5EvAfc4weVB6osRd166c/Z+dlfZfSUkRbn9i
QiyKGlD8gNIQkps4sYSjAJL7HGDi5Ljp9KlDYL0a6mr/kO1gZmacB6IT4mOw
6gOFBZ54Rg7L3SD+4kVzyHJfaGgQzLy/QKyJFjdTQHJnTh3GqR+H20KRzACV
O/9VVJT/3797lSS3nT97DFbmdmFJN6Ay+L+hgf4/bHpBeQYkv2jhbGR3uTFg
1oHyhPyIC4PKW6i5QmhmwspdsDpY2QjDu3dtxhZmKVj8CANk5wkk89mQzBMF
ibm6OmHE4YL5M7G5zQmP2/pBasgp90B6kOxIB7ajfKFmmoPEdmzb8N/MzARX
GsNVXyCDBJDayMjQH6B6h1T33bpxAZfdh9H4oDo3E8reygBpGxIDfjGQWO4h
qz1+dB+47MXhRmLrB3zAQlxc7P3Vy2cIumvJ4rlwe2RkpFHKOl9fL2Q3FFHR
fQx8fHwZbS0NL0B1NzZ3gcRJCB8QnoVDPJgc9wEBq5yczIr5c2f8wVZ+NDZU
k+q+dzjEJ5DpPhAQdna033fuzFGUeMSGMzNSSHUvDMtQ4D4QcJUQE/tCpt34
MBsDlQAXF8dkbm7O7Whmgus+NDvXEOEub2q5iwDIIcItMJxKJzehgyNEum+g
AEofBQ8eDADsFmCbarC6DwYGu/vUGQa3+0AA1N4dzO4DAVD/oA6ItQbaIaNg
aAEAlA+BgQ==
      "], {{0, 0}, {40, 40}}, {0, 255},
      ColorFunction->RGBColor],
     Background->None,
     ImageSize->{40, 40},
     PlotRange->{{0, 40}, {0, 40}}], "\[InvisibleSpace]", "\<\"Canada\"\>"}],
   Row[{
     Graphics[
      Raster[CompressedData["
1:eJxTTMoPSmJmYGDQgGIWhlEwCoY94ADiaCAWHmiHYAGg7HgPiP+zsbHtAtKM
A+wedAByj5W9ve07IP0fiE8BMdPAOgkF8HNycNybO3va/wvnjv8XEhT8JSYm
lsJA/3AE2acDxIFAPB2IlZiYmPYD6f+OjvZ/nzy69R+E9+7eCgrD/8zMzM1A
mpsK9goAsRY7O7ubno5OkZ6O9nx3d5eFXp5uG7093ff5eHns9/Jy38PKyvqN
ARJ/cFxSnP/z0oUT/2Fug+Erl07/9/f3+QlVpwvE7FC2OwPhcJ0BxK6KinLJ
Tg62C8NCg07X1VY8WDh/1u9dOzf9P7h/x//Ll079v33rEty+h/ev/79x7RyY
fefWZTD9+OFNDHch43t3roD9wMjIuBTNXxw43MWErG7likX/z54+gtcOYvH1
q+dQ+I8e3Pjv5ur8H81dyBgbCIXJe3q6EfQ/sXj92uVwew8d2AkXT0qMI9V9
l2Dy6P4lF4PSAbK9yGkChNHc5EvAfc4weVB6osRd166c/Z+dlfZfSUkRbn9i
QiyKGlD8gNIQkps4sYSjAJL7HGDi5Ljp9KlDYL0a6mr/kO1gZmacB6IT4mOw
6gOFBZ54Rg7L3SD+4kVzyHJfaGgQzLy/QKyJFjdTQHJnTh3GqR+H20KRzACV
O/9VVJT/3797lSS3nT97DFbmdmFJN6Ay+L+hgf4/bHpBeQYkv2jhbGR3uTFg
1oHyhPyIC4PKW6i5QmhmwspdsDpY2QjDu3dtxhZmKVj8CANk5wkk89mQzBMF
ibm6OmHE4YL5M7G5zQmP2/pBasgp90B6kOxIB7ajfKFmmoPEdmzb8N/MzARX
GsNVXyCDBJDayMjQH6B6h1T33bpxAZfdh9H4oDo3E8reygBpGxIDfjGQWO4h
qz1+dB+47MXhRmLrB3zAQlxc7P3Vy2cIumvJ4rlwe2RkpFHKOl9fL2Q3FFHR
fQx8fHwZbS0NL0B1NzZ3gcRJCB8QnoVDPJgc9wEBq5yczIr5c2f8wVZ+NDZU
k+q+dzjEJ5DpPhAQdna033fuzFGUeMSGMzNSSHUvDMtQ4D4QcJUQE/tCpt34
MBsDlQAXF8dkbm7O7Whmgus+NDvXEOEub2q5iwDIIcItMJxKJzehgyNEum+g
AEofBQ8eDADsFmCbarC6DwYGu/vUGQa3+0AA1N4dzO4DAVD/oA6ItQbaIaNg
aAEAlA+BgQ==
       "], {{0, 0}, {40, 40}}, {0, 255}, ColorFunction -> RGBColor], 
      Background -> None, ImageSize -> {40, 40}, 
      PlotRange -> {{0, 40}, {0, 40}}], "Canada"}]]->
  GraphicsBox[{{}, 
    {Hue[0.67, 0.6, 0.6], 
     PointBox[{{2.2089888*^9, 8.51102721952742*^10}, {2.2405248*^9, 
      9.611388494862978*^10}, {2.2720608*^9, 1.094720184098862*^11}, {
      2.3036832*^9, 1.2719440059381201`*^11}, {2.3352192*^9, 
      1.5529838808012518`*^11}, {2.3667552*^9, 1.6827567004560587`*^11}, {
      2.3982912*^9, 2.00061864743176*^11}, {2.4299136*^9, 
      2.0490855246558777`*^11}, {2.4614496*^9, 2.1158699904973694`*^11}, {
      2.4929856*^9, 2.354038885269667*^11}, {2.5245216*^9, 
      2.6527162075194025`*^11}, {2.556144*^9, 2.9670158287541626`*^11}, {
      2.58768*^9, 3.0382902858739197`*^11}, {2.619216*^9, 
      3.2898857285467914`*^11}, {2.650752*^9, 3.42332183759481*^11}, {
      2.6823744*^9, 3.50666308740087*^11}, {2.7139104*^9, 
      3.6336595904342676`*^11}, {2.7454464*^9, 4.1532010633550885`*^11}, {
      2.7769824*^9, 4.9056464772996716`*^11}, {2.8086048*^9, 
      5.4728594655086096`*^11}, {2.8401408*^9, 5.742041096183926*^11}, {
      2.8716768*^9, 5.888384271853116*^11}, {2.9032128*^9, 
      5.70279426668597*^11}, {2.9348352*^9, 5.546898143452979*^11}, {
      2.9663712*^9, 5.558404311536865*^11}, {2.9979072*^9, 
      5.816644190490315*^11}, {3.0294432*^9, 6.043712052962986*^11}, {
      3.0610656*^9, 6.27595363337625*^11}, {3.0926016*^9, 
      6.069244392498939*^11}, {3.1241376*^9, 6.512017086979576*^11}, {
      3.1556736*^9, 7.144534748267805*^11}, {3.187296*^9, 
      7.050688372908894*^11}, {3.218832*^9, 7.243042892296139*^11}, {
      3.250368*^9, 8.547108065250964*^11}, {3.281904*^9, 
      9.767419516622521*^11}, {3.3135264*^9, 1.1317597770741843`*^12}}]}, {}},
   
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   AxesOrigin->NCache[{2208988800, 0}, {2.2089888*^9, 0}],
   Frame->True,
   FrameTicks->{{Automatic, Automatic}, {{{
        NCache[2208988800, 2.2089888*^9], 
        FormBox["\"1970\"", TraditionalForm]}, {
        NCache[2524521600, 2.5245216*^9], 
        FormBox["\"1980\"", TraditionalForm]}, {
        NCache[2840140800, 2.8401408*^9], 
        FormBox["\"1990\"", TraditionalForm]}, {
        NCache[3155673600, 3.1556736*^9], 
        FormBox["\"2000\"", TraditionalForm]}, {
        NCache[2272060800, 2.2720608*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2335219200, 2.3352192*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2398291200, 2.3982912*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2461449600, 2.4614496*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2587680000, 2.58768*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2650752000, 2.650752*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2713910400, 2.7139104*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2776982400, 2.7769824*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2903212800, 2.9032128*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2966371200, 2.9663712*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3029443200, 3.0294432*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3092601600, 3.0926016*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3218832000, 3.218832*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3281904000, 3.281904*^9], 
        FormBox["\" \"", TraditionalForm]}}, {{
        NCache[2208988800, 2.2089888*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2524521600, 2.5245216*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2840140800, 2.8401408*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3155673600, 3.1556736*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2272060800, 2.2720608*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2335219200, 2.3352192*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2398291200, 2.3982912*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2461449600, 2.4614496*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2587680000, 2.58768*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2650752000, 2.650752*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2713910400, 2.7139104*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2776982400, 2.7769824*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2903212800, 2.9032128*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2966371200, 2.9663712*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3029443200, 3.0294432*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3092601600, 3.0926016*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3218832000, 3.218832*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3281904000, 3.281904*^9], 
        FormBox["\" \"", TraditionalForm]}}}},
   GridLines->NCache[{{{2208988800, 
        GrayLevel[0.8]}, {2524521600, 
        GrayLevel[0.8]}, {2840140800, 
        GrayLevel[0.8]}, {3155673600, 
        GrayLevel[0.8]}}, None}, {{{2.2089888*^9, 
        GrayLevel[0.8]}, {2.5245216*^9, 
        GrayLevel[0.8]}, {2.8401408*^9, 
        GrayLevel[0.8]}, {3.1556736*^9, 
        GrayLevel[0.8]}}, None}],
   PlotRange->{{2.2089888*^9, 3.3135264*^9}, {0., 1.1317597770741843`*^12}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]},
   Ticks->None]}, {2,
  InterpretationBox[
   RowBox[{
    GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJmYGDQgGIWhlEwDMEsZmbma0CadaAdgg6A7moAUv+hOHJgXYMV
/Ofm5vqfnBT3Hsg2pYJ5jJycnNK6ujrLdXW114mJiBzh5GTLp8R9CxfMAuGf
kpISXSTqFWdnZ3cUFhaOkpKSagPy7RigcbF08bz/+/Zs+5+bm/mfkZHxF1CM
iVz3LV405/+yJfP/KygopBOhHmSPPgcH+1VZWZk3TY21r0D6a2rKvwYE+D6f
NWPy/7u3r/x/8ugWGO/etfm/oaH+ajzmsQGxEC5JHh6eNJAbgXZ9BdJ6BNwG
MuswSP3KFYv+3751Ce4OXPjh/ev/U1MT7wHT0FqgPk4gBhW3ukAcw4BI9zAs
isNeG6i8HAH3FYHUHdi3/R8hdyHj+3ev/vf0cP2N7h5NDfUfJ47tB8urqqr8
Z2FheQYUF8BhNz8Bt4GBqKhQwpLFc76T4j5YOE6c0P27p7vt/51bl/8/uHft
/6MHN1DUlJcVfWZjY3sDtIadGLfgAFJFRbmXSXUfMfjenSv/geXdX6Ad7hS4
j8nf3+fg44c3qe6+1SsWfVNUlAOVc/8pcB8DHx/vi9OnDlHVbYcO7gKVw6C4
lQFZQYHzeED+09PT+R0U6Pfr1o0LVHEfqKyEhps6JWEHAqqqynHdXa1g8y5d
OEGx20BpBWQWJyfHBSDNQan7gMCcAVpGgPIlpe67evnM/+Ag/y9ycrIXgWYK
UsF980FuW792+S9qpb9rV87+V1JSeAE014pCt4HqgP96ujp/QGUYpe6ClYF+
vt5/gHV5GuVBBwZuIDfevH6eIrddv3oOnEb27t7639vL47eoqGgLA2VlMwM/
P+80NjbWH12dLT/Ry39ysIK8HKje/29ibPSKgfK8C6qfqZJnYbihrvIzsL04
i4mJKRVoNiMFbhMAmnN12dL5VHMbCIPKT2tri3NA86UpDDt5BmiZQo14RcbA
NuM/YDvvEQMk75EKQO3RGgZIe+h7b0/7X2q6DVa2sLKy/gW2r7YyEF8+g+pB
SQak9trWzWup6i5kfPf25X+ZGal/BQQE1jEQzsMWMDcpKSn+zs/L+kdpWUIM
XrN6CbCPIddCKOCAbbAekNt27thIczch46bGmv9iYmJTCLmPlZkZ3McA9jnh
eQHUDl+2ZN7fLZvX/O/saAa3h6idT0Dllo6O1j4GAuMEwLy0DDndJSXGofdj
QH0+qucTUH1pZmYMysdmhMKQAZIG/YA4DeomUB8bVH4y2lhZLjh14iDc3Ivn
yS+vQe0fUH8E1EcCtWNioiP+MpDefkbuW3PDwlBQQOCbnIz0UxC7rLToDynu
ArkHRIPafgIC/PC+HQcHRwUDpH4nB4DcCSqr/kHNcwBiASB/l5aWxh9i+ySg
/rukpMR3mJuEhAS6GSBlCq6+JbFAEFhP3gDSWUCcjCQuwsHB/tjY2PDVrJlT
fuNy16KFs/9Pm9IPdpOamgoonED9DGYK3UQKkOXi4toHDMsf6O3qI4f2gN0F
LLs+S0iIL6Ojm9CBHS8vzw9QmoflSVD7jgGR90FjLWwD6D4FIyP9pyC3gcZn
pKUk/0DdBWqfUNJ+ohbgkpCQOFlTU/EyJzv9AyMj41SgmPFAOwoNgOLPHFiX
ljOMwCkBAKMoRAQ=
      "], {{0, 0}, {40, 40}}, {0, 255},
      ColorFunction->RGBColor],
     Background->None,
     ImageSize->{40, 40},
     PlotRange->{{0, 40}, {0, 40}}], "\[InvisibleSpace]", "\<\"France\"\>"}],
   Row[{
     Graphics[
      Raster[CompressedData["
1:eJxTTMoPSmJmYGDQgGIWhlEwDMEsZmbma0CadaAdgg6A7moAUv+hOHJgXYMV
/Ofm5vqfnBT3Hsg2pYJ5jJycnNK6ujrLdXW114mJiBzh5GTLp8R9CxfMAuGf
kpISXSTqFWdnZ3cUFhaOkpKSagPy7RigcbF08bz/+/Zs+5+bm/mfkZHxF1CM
iVz3LV405/+yJfP/KygopBOhHmSPPgcH+1VZWZk3TY21r0D6a2rKvwYE+D6f
NWPy/7u3r/x/8ugWGO/etfm/oaH+ajzmsQGxEC5JHh6eNJAbgXZ9BdJ6BNwG
MuswSP3KFYv+3751Ce4OXPjh/ev/U1MT7wHT0FqgPk4gBhW3ukAcw4BI9zAs
isNeG6i8HAH3FYHUHdi3/R8hdyHj+3ev/vf0cP2N7h5NDfUfJ47tB8urqqr8
Z2FheQYUF8BhNz8Bt4GBqKhQwpLFc76T4j5YOE6c0P27p7vt/51bl/8/uHft
/6MHN1DUlJcVfWZjY3sDtIadGLfgAFJFRbmXSXUfMfjenSv/geXdX6Ad7hS4
j8nf3+fg44c3qe6+1SsWfVNUlAOVc/8pcB8DHx/vi9OnDlHVbYcO7gKVw6C4
lQFZQYHzeED+09PT+R0U6Pfr1o0LVHEfqKyEhps6JWEHAqqqynHdXa1g8y5d
OEGx20BpBWQWJyfHBSDNQan7gMCcAVpGgPIlpe67evnM/+Ag/y9ycrIXgWYK
UsF980FuW792+S9qpb9rV87+V1JSeAE014pCt4HqgP96ujp/QGUYpe6ClYF+
vt5/gHV5GuVBBwZuIDfevH6eIrddv3oOnEb27t7639vL47eoqGgLA2VlMwM/
P+80NjbWH12dLT/Ry39ysIK8HKje/29ibPSKgfK8C6qfqZJnYbihrvIzsL04
i4mJKRVoNiMFbhMAmnN12dL5VHMbCIPKT2tri3NA86UpDDt5BmiZQo14RcbA
NuM/YDvvEQMk75EKQO3RGgZIe+h7b0/7X2q6DVa2sLKy/gW2r7YyEF8+g+pB
SQak9trWzWup6i5kfPf25X+ZGal/BQQE1jEQzsMWMDcpKSn+zs/L+kdpWUIM
XrN6CbCPIddCKOCAbbAekNt27thIczch46bGmv9iYmJTCLmPlZkZ3McA9jnh
eQHUDl+2ZN7fLZvX/O/saAa3h6idT0Dllo6O1j4GAuMEwLy0DDndJSXGofdj
QH0+qucTUH1pZmYMysdmhMKQAZIG/YA4DeomUB8bVH4y2lhZLjh14iDc3Ivn
yS+vQe0fUH8E1EcCtWNioiP+MpDefkbuW3PDwlBQQOCbnIz0UxC7rLToDynu
ArkHRIPafgIC/PC+HQcHRwUDpH4nB4DcCSqr/kHNcwBiASB/l5aWxh9i+ySg
/rukpMR3mJuEhAS6GSBlCq6+JbFAEFhP3gDSWUCcjCQuwsHB/tjY2PDVrJlT
fuNy16KFs/9Pm9IPdpOamgoonED9DGYK3UQKkOXi4toHDMsf6O3qI4f2gN0F
LLs+S0iIL6Ojm9CBHS8vzw9QmoflSVD7jgGR90FjLWwD6D4FIyP9pyC3gcZn
pKUk/0DdBWqfUNJ+ohbgkpCQOFlTU/EyJzv9AyMj41SgmPFAOwoNgOLPHFiX
ljOMwCkBAKMoRAQ=
       "], {{0, 0}, {40, 40}}, {0, 255}, ColorFunction -> RGBColor], 
      Background -> None, ImageSize -> {40, 40}, 
      PlotRange -> {{0, 40}, {0, 40}}], "France"}]]->
  GraphicsBox[{{}, 
    {Hue[0.67, 0.6, 0.6], 
     PointBox[{{2.2089888*^9, 1.4860490316148856`*^11}, {2.2405248*^9, 
      1.6599051480654675`*^11}, {2.2720608*^9, 2.0370806787064062`*^11}, {
      2.3036832*^9, 2.6392489611186478`*^11}, {2.3352192*^9, 
      2.8178832637142487`*^11}, {2.3667552*^9, 3.5608510491218945`*^11}, {
      2.3982912*^9, 3.682859284585891*^11}, {2.4299136*^9, 
      4.0667378485213184`*^11}, {2.4614496*^9, 5.030293764523027*^11}, {
      2.4929856*^9, 6.065025382702382*^11}, {2.5245216*^9, 
      6.890241190158655*^11}, {2.556144*^9, 6.034738136776915*^11}, {
      2.58768*^9, 5.73916593597205*^11}, {2.619216*^9, 
      5.526822076601039*^11}, {2.650752*^9, 5.2512930500900977`*^11}, {
      2.6823744*^9, 5.489972719697796*^11}, {2.7139104*^9, 
      7.642085878650359*^11}, {2.7454464*^9, 9.25744668315392*^11}, {
      2.7769824*^9, 1.0065906584591847`*^12}, {2.8086048*^9, 
      1.0080845330770159`*^12}, {2.8401408*^9, 1.239216273221249*^12}, {
      2.8716768*^9, 1.2382601056413403`*^12}, {2.9032128*^9, 
      1.3716431138354666`*^12}, {2.9348352*^9, 1.291925428637067*^12}, {
      2.9663712*^9, 1.3651592829157007`*^12}, {2.9979072*^9, 
      1.5701600445521953`*^12}, {3.0294432*^9, 1.574359362801807*^12}, {
      3.0610656*^9, 1.4255858862792654`*^12}, {3.0926016*^9, 
      1.4727634653137236`*^12}, {3.1241376*^9, 1.455813223397778*^12}, {
      3.1556736*^9, 1.3279619433987944`*^12}, {3.187296*^9, 
      1.3397410314001665`*^12}, {3.218832*^9, 1.457392660121621*^12}, {
      3.250368*^9, 1.799946390329191*^12}, {3.281904*^9, 
      2.0599603906303352`*^12}, {3.3135264*^9, 
      2.1265776254725664`*^12}}]}, {}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   AxesOrigin->NCache[{2208988800, 0}, {2.2089888*^9, 0}],
   Frame->True,
   FrameTicks->{{Automatic, Automatic}, {{{
        NCache[2208988800, 2.2089888*^9], 
        FormBox["\"1970\"", TraditionalForm]}, {
        NCache[2524521600, 2.5245216*^9], 
        FormBox["\"1980\"", TraditionalForm]}, {
        NCache[2840140800, 2.8401408*^9], 
        FormBox["\"1990\"", TraditionalForm]}, {
        NCache[3155673600, 3.1556736*^9], 
        FormBox["\"2000\"", TraditionalForm]}, {
        NCache[2272060800, 2.2720608*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2335219200, 2.3352192*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2398291200, 2.3982912*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2461449600, 2.4614496*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2587680000, 2.58768*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2650752000, 2.650752*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2713910400, 2.7139104*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2776982400, 2.7769824*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2903212800, 2.9032128*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2966371200, 2.9663712*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3029443200, 3.0294432*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3092601600, 3.0926016*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3218832000, 3.218832*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3281904000, 3.281904*^9], 
        FormBox["\" \"", TraditionalForm]}}, {{
        NCache[2208988800, 2.2089888*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2524521600, 2.5245216*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2840140800, 2.8401408*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3155673600, 3.1556736*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2272060800, 2.2720608*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2335219200, 2.3352192*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2398291200, 2.3982912*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2461449600, 2.4614496*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2587680000, 2.58768*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2650752000, 2.650752*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2713910400, 2.7139104*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2776982400, 2.7769824*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2903212800, 2.9032128*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2966371200, 2.9663712*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3029443200, 3.0294432*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3092601600, 3.0926016*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3218832000, 3.218832*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3281904000, 3.281904*^9], 
        FormBox["\" \"", TraditionalForm]}}}},
   GridLines->NCache[{{{2208988800, 
        GrayLevel[0.8]}, {2524521600, 
        GrayLevel[0.8]}, {2840140800, 
        GrayLevel[0.8]}, {3155673600, 
        GrayLevel[0.8]}}, None}, {{{2.2089888*^9, 
        GrayLevel[0.8]}, {2.5245216*^9, 
        GrayLevel[0.8]}, {2.8401408*^9, 
        GrayLevel[0.8]}, {3.1556736*^9, 
        GrayLevel[0.8]}}, None}],
   PlotRange->{{2.2089888*^9, 3.3135264*^9}, {0., 2.1265776254725664`*^12}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]},
   Ticks->None]}, {3,
  InterpretationBox[
   RowBox[{
    GraphicsBox[RasterBox[CompressedData["
1:eJzlmGlMVFcUx98wDMwGQy3MBjPMlGIQSgltQEZmQGhtSGmM1TapjUpKi2nU
RhDEBSSKJNYKxS5glNpiAjXRUluJsVCxslkE2VcBZbPFtB9YnSqLt+cM8wix
tc3Me69fepJ/bt7kzbm/d7dzztXH71wfz6coys8qR+r/Y87Ozp8olYrj1sfl
IKf/sHseaC3oJdAKUIC1f76Tk9MGaHNARK1WTUL7uVAoNOt03v1isTAOniWP
+RKzDQcM6wyGlWM5x478nrxr5yiySCSS3wQCgTk1JWnio6NZ5vbWG+RwZsb4
qZOfTVVX/Ui6O5tIxoF95pCQF7uUSuX7AgE/WyIRNbm5uTZZv5c1A4638vNy
5+8O95KRoVvk2tXLBHmabtYS/O2f1NZSR5b7PjsVHRVp5vF4xNXVtQJcOrDJ
BxZ26GD6+L+xPEnDgz2W1hgehvP/AstsaCaYp3u9PS128aE6228S2EOzMH4Z
4E/BMh/faDQU45zayzc00E3u9HeQnOwjc+CPgLQs8uF63pSUuGMS15+9jKi+
3jYStTpiWKFQ9IBPdxYZHaRSSfP2bVunmfChWpvriMkU/gv49GLI9DQoApQg
l3u0rzKE3s08lD6N82QvW2NDDXknbnO9p1wexpBNpdNpu6AlaftT73d1NM4x
HbfSi+eJ3ls7CD5DGbLJwX46XZA/19/bzoiJ1pnCgofeGk0N+NYxZLOYSqW6
lPvxUVbYfq69SlZHmC6AWzc22MC0Xp7q0drqK6zwfVGQh3GjlGIpbmi12uxL
pSWssOE3UgvnHWtxw8HBYYdM5jqDe40J2+2+DvJcgP+MlW8DW3xgSvR5oeQs
4/FDRow7cVve/jU4OKgA/EqZwsH4TSNfR1sDK3NM60Te8Xn0C/laOcUgdqjV
yoJdSR+wykYLc4yNG9+cfeXl6HYfH30y5Awx0GWsjYik7IfvOeGj1dx4nd43
BPLLcVvgYH6bszIP/MElH8bIM4WnLPs7MDBgwMbx83w3fssA5kRcMqKqKsuJ
j88z9bbAQb0Qk5+fO0XnvVwJYrplfvl8fowtfG5usg6TMbzfaFzVff5c0QRX
fFFREY+ohTVoa02HeZUeVKLVah4M3unihO9s8VePli17CuslgY18tPHgrPp0
394UMxdrsepaGfFwd6+wkw3Nz1OtuvftN1/PcLH2IPZNQB/BDPhkYrF4qLjo
y2mmdcfjwnOaWlh77zHgQ1NsTYhvYZOtvq6S3rfVDNnQBGvWRNczqX2XCuch
N+dDrIXHwLeIBb4UEBm43WnxD2Np+faerqbFPu3ZOwcz9o+AnxCK4V0MxLrN
cL4/wLsWqN0WYyadGwYFBc7ic/2NKpv4sg5n9ML/fJkOHpper0+KjDSdlsvd
RwUCxyv+/itGyi5/R2JfjbHcBVyvqbBpHPFceS02ppJi/45QCOK7uLgUUdZx
xFqb7hfrDPp3yEX/9kzavi1hXiqVPtTpNHEssy01vDshe/ckL45Z361W8vq6
tZb8k8fjYR1JwlaGzi2NPelpe+ZEIqHlHVg3uzlik0H/9ylrfo1zGx5uICKR
iI6lKLyj8gFN+/n5TpaXXSQajRddh+C5cowjNtrwfoxgfUz3CeNRB60BFLnk
PR6cIw30O46OjpiLVnLMRnl4eKzfnZI4lp6WushHPTlHl+Ff6Pdg7W7imk+j
0SQGBz9/TqFQFFr7fYP66z04K/YnpeuAPA==
      "], {{0, 0}, {40, 40}}, {0, 255},
      ColorFunction->RGBColor],
     Background->None,
     ImageSize->{40, 40},
     PlotRange->{{0, 40}, {0, 40}}], "\[InvisibleSpace]", "\<\"Germany\"\>"}],
   
   Row[{
     Graphics[
      Raster[CompressedData["
1:eJzlmGlMVFcUx98wDMwGQy3MBjPMlGIQSgltQEZmQGhtSGmM1TapjUpKi2nU
RhDEBSSKJNYKxS5glNpiAjXRUluJsVCxslkE2VcBZbPFtB9YnSqLt+cM8wix
tc3Me69fepJ/bt7kzbm/d7dzztXH71wfz6coys8qR+r/Y87Ozp8olYrj1sfl
IKf/sHseaC3oJdAKUIC1f76Tk9MGaHNARK1WTUL7uVAoNOt03v1isTAOniWP
+RKzDQcM6wyGlWM5x478nrxr5yiySCSS3wQCgTk1JWnio6NZ5vbWG+RwZsb4
qZOfTVVX/Ui6O5tIxoF95pCQF7uUSuX7AgE/WyIRNbm5uTZZv5c1A4638vNy
5+8O95KRoVvk2tXLBHmabtYS/O2f1NZSR5b7PjsVHRVp5vF4xNXVtQJcOrDJ
BxZ26GD6+L+xPEnDgz2W1hgehvP/AstsaCaYp3u9PS128aE6228S2EOzMH4Z
4E/BMh/faDQU45zayzc00E3u9HeQnOwjc+CPgLQs8uF63pSUuGMS15+9jKi+
3jYStTpiWKFQ9IBPdxYZHaRSSfP2bVunmfChWpvriMkU/gv49GLI9DQoApQg
l3u0rzKE3s08lD6N82QvW2NDDXknbnO9p1wexpBNpdNpu6AlaftT73d1NM4x
HbfSi+eJ3ls7CD5DGbLJwX46XZA/19/bzoiJ1pnCgofeGk0N+NYxZLOYSqW6
lPvxUVbYfq69SlZHmC6AWzc22MC0Xp7q0drqK6zwfVGQh3GjlGIpbmi12uxL
pSWssOE3UgvnHWtxw8HBYYdM5jqDe40J2+2+DvJcgP+MlW8DW3xgSvR5oeQs
4/FDRow7cVve/jU4OKgA/EqZwsH4TSNfR1sDK3NM60Te8Xn0C/laOcUgdqjV
yoJdSR+wykYLc4yNG9+cfeXl6HYfH30y5Awx0GWsjYik7IfvOeGj1dx4nd43
BPLLcVvgYH6bszIP/MElH8bIM4WnLPs7MDBgwMbx83w3fssA5kRcMqKqKsuJ
j88z9bbAQb0Qk5+fO0XnvVwJYrplfvl8fowtfG5usg6TMbzfaFzVff5c0QRX
fFFREY+ohTVoa02HeZUeVKLVah4M3unihO9s8VePli17CuslgY18tPHgrPp0
394UMxdrsepaGfFwd6+wkw3Nz1OtuvftN1/PcLH2IPZNQB/BDPhkYrF4qLjo
y2mmdcfjwnOaWlh77zHgQ1NsTYhvYZOtvq6S3rfVDNnQBGvWRNczqX2XCuch
N+dDrIXHwLeIBb4UEBm43WnxD2Np+faerqbFPu3ZOwcz9o+AnxCK4V0MxLrN
cL4/wLsWqN0WYyadGwYFBc7ic/2NKpv4sg5n9ML/fJkOHpper0+KjDSdlsvd
RwUCxyv+/itGyi5/R2JfjbHcBVyvqbBpHPFceS02ppJi/45QCOK7uLgUUdZx
xFqb7hfrDPp3yEX/9kzavi1hXiqVPtTpNHEssy01vDshe/ckL45Z361W8vq6
tZb8k8fjYR1JwlaGzi2NPelpe+ZEIqHlHVg3uzlik0H/9ylrfo1zGx5uICKR
iI6lKLyj8gFN+/n5TpaXXSQajRddh+C5cowjNtrwfoxgfUz3CeNRB60BFLnk
PR6cIw30O46OjpiLVnLMRnl4eKzfnZI4lp6WushHPTlHl+Ff6Pdg7W7imk+j
0SQGBz9/TqFQFFr7fYP66z04K/YnpeuAPA==
       "], {{0, 0}, {40, 40}}, {0, 255}, ColorFunction -> RGBColor], 
      Background -> None, ImageSize -> {40, 40}, 
      PlotRange -> {{0, 40}, {0, 40}}], "Germany"}]]->
  GraphicsBox[{{}, 
    {Hue[0.67, 0.6, 0.6], 
     PointBox[{{2.2089888*^9, 2.0810384443389188`*^11}, {2.2405248*^9, 
      2.406633633299223*^11}, {2.2720608*^9, 2.901008009718065*^11}, {
      2.3036832*^9, 3.859488165006181*^11}, {2.3352192*^9, 
      4.294585203779621*^11}, {2.3667552*^9, 4.7140775174106274`*^11}, {
      2.3982912*^9, 5.0176605229263135`*^11}, {2.4299136*^9, 
      5.811627444679083*^11}, {2.4614496*^9, 7.210086697895739*^11}, {
      2.4929856*^9, 8.529460356368018*^11}, {2.5245216*^9, 
      9.12584520044493*^11}, {2.556144*^9, 7.661408754107075*^11}, {
      2.58768*^9, 7.417212813241608*^11}, {2.619216*^9, 
      7.391623711685114*^11}, {2.650752*^9, 6.956865796672733*^11}, {
      2.6823744*^9, 7.021427484597816*^11}, {2.7139104*^9, 
      1.0066288875939098`*^12}, {2.7454464*^9, 1.2559866089578115`*^12}, {
      2.7769824*^9, 1.3534382051911914`*^12}, {2.8086048*^9, 
      1.344638146460924*^12}, {2.8401408*^9, 1.7073594468832742`*^12}, {
      2.8716768*^9, 1.8085817176429229`*^12}, {2.9032128*^9, 
      2.0622474911792007`*^12}, {2.9348352*^9, 2.004389958855537*^12}, {
      2.9663712*^9, 2.1462382715819878`*^12}, {2.9979072*^9, 
      2.5226236677348384`*^12}, {3.0294432*^9, 2.438564676803662*^12}, {
      3.0610656*^9, 2.1605698959520244`*^12}, {3.0926016*^9, 
      2.1844745936107478`*^12}, {3.1241376*^9, 2.1435558626971543`*^12}, {
      3.1556736*^9, 1.9002196577147825`*^12}, {3.187296*^9, 
      1.8909539959373965`*^12}, {3.218832*^9, 2.0187441865571965`*^12}, {
      3.250368*^9, 2.4416665647769404`*^12}, {3.281904*^9, 
      2.7511128494533535`*^12}, {3.3135264*^9, 2.794856489081232*^12}}]}, {}},
   
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   AxesOrigin->NCache[{2208988800, 0}, {2.2089888*^9, 0}],
   Frame->True,
   FrameTicks->{{Automatic, Automatic}, {{{
        NCache[2208988800, 2.2089888*^9], 
        FormBox["\"1970\"", TraditionalForm]}, {
        NCache[2524521600, 2.5245216*^9], 
        FormBox["\"1980\"", TraditionalForm]}, {
        NCache[2840140800, 2.8401408*^9], 
        FormBox["\"1990\"", TraditionalForm]}, {
        NCache[3155673600, 3.1556736*^9], 
        FormBox["\"2000\"", TraditionalForm]}, {
        NCache[2272060800, 2.2720608*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2335219200, 2.3352192*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2398291200, 2.3982912*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2461449600, 2.4614496*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2587680000, 2.58768*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2650752000, 2.650752*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2713910400, 2.7139104*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2776982400, 2.7769824*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2903212800, 2.9032128*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2966371200, 2.9663712*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3029443200, 3.0294432*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3092601600, 3.0926016*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3218832000, 3.218832*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3281904000, 3.281904*^9], 
        FormBox["\" \"", TraditionalForm]}}, {{
        NCache[2208988800, 2.2089888*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2524521600, 2.5245216*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2840140800, 2.8401408*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3155673600, 3.1556736*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2272060800, 2.2720608*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2335219200, 2.3352192*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2398291200, 2.3982912*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2461449600, 2.4614496*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2587680000, 2.58768*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2650752000, 2.650752*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2713910400, 2.7139104*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2776982400, 2.7769824*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2903212800, 2.9032128*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2966371200, 2.9663712*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3029443200, 3.0294432*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3092601600, 3.0926016*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3218832000, 3.218832*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3281904000, 3.281904*^9], 
        FormBox["\" \"", TraditionalForm]}}}},
   GridLines->NCache[{{{2208988800, 
        GrayLevel[0.8]}, {2524521600, 
        GrayLevel[0.8]}, {2840140800, 
        GrayLevel[0.8]}, {3155673600, 
        GrayLevel[0.8]}}, None}, {{{2.2089888*^9, 
        GrayLevel[0.8]}, {2.5245216*^9, 
        GrayLevel[0.8]}, {2.8401408*^9, 
        GrayLevel[0.8]}, {3.1556736*^9, 
        GrayLevel[0.8]}}, None}],
   PlotRange->{{2.2089888*^9, 3.3135264*^9}, {0., 2.794856489081232*^12}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]},
   Ticks->None]}, {4,
  InterpretationBox[
   RowBox[{
    GraphicsBox[RasterBox[CompressedData["
1:eJztmH9Uk1UYx98x2BgD3gmMsbFB/BAyQAlpCO2IUiSnQlOyREWBAk04olCy
VE6hoksFRERRUPLISUtUkgrtl2igaEYQIfJD0UrNJLQUVKbdnmfurR0aCtOx
f3rO+Z67e3ff+37e+977PM993eJTpsSzKYp6XCtz6n9js9mRcnnA8mHDBF9i
1dQ8OiYDhXG5nNsV+3cT4LsF9WdNDQUmpWm6Zu6chIbNhfk36k7WkPbWRgLt
qDdNyGUjEjkWIMeitxbe/eWnVsJob9kHxHu451cmZEMj2WtX9TY1ntQw4bxh
eb6jmbS1NJC42Jhm6CMFRYLEQw3n5ua6PCwstDc4OOhq0rzEq6MD/MtemvRi
dVJSYn1xUcGd9EWpJCjoqSq5PPCyVOq8f6j5wDiwV3OgjLawsHgFShaIB3IQ
ix0XQ9tlc3Nz9RtzX++ZMX1aJ4/HKzIB44OMzeVyr+3auZ14erpfgLrLQ4wl
BBEzM7NeKL1AHo8CUCwSvTbc06MrdvaMdqjGUIaHienIl78+W+MbbG1trkDp
/AgQg3JzVJdaT9eTUSP91Hw+f4GB4wRmLE1vxz14+NABkpw0p416+Dlk+fv5
pJTu2Hqn40wTCR2ruMXhcKKg3cKAsR4DkW+OfKHxE9vfL+qG+viH5BuVkaE8
3dhwnEjE4huwXy5Bm6XO/7xBjDUB+Zqb6jR8xVsK1PCskw3k4goEtklWVlYF
GUuUPZ9UlBEPD7c9uh1cXWW4xy8MYkypi4vsN1wnyJeWOv8a+IQpBrCZCwR0
zYQJ4ddjZkarce6OH6tCX1gN/9Ggl0HJUVGTOhWK4M8HOqilpWUe8HX/fL5F
w/fdt9VEKBTWDoJLwGKxVsA4s2Qy58bao4eIbsxbn7e2i8+3agoJGdMJvvvi
poJ1NyNfiBjwXhE6OGA+RLJWvKMZD3+D/10zCL6FeI2jo1BdkJ/brcuGwucG
JnLgs3ISFjauMzIyIp0axPqDtauEIoHH456j7uUeKN8BXOoOmgd5Ved7quV3
mfnvqyNVB8mG/JwrwcHyjQMct6+xtKUZKJZ6cEx3gGc6yzwLvL//zBmqZGth
T3xczInQUIUK+j+tcx9jmquzs6R6zeosgvtJ35xh2749O8HPW7dAf7shYNIY
TfOfsbGx7oEc+S9984VcJdsK1UsWL2pVrVzWQdva3obL4ocADedgDfiOrh/q
a/WusZbm70lgYMCfQqH9VujrChoBmgjiGpkN1yT6avJx+Ud62U6fqiNeXp6/
cjiafTbUloJsfX0aI4ytiQlxFyCXes4EbJYQR/6AnEHvemMUFzsT44O9Cfjo
qVMnH8UzWX9sVV9XEkXImGUmYMO4F120ZUNvf2wnag+TiIjwLuiqMBaDj8+I
V319fXaD/wzRacY94QS+5MC24k16/UjpjuKbEOMPQr9plPH8Lg05fVvs7JmY
1xNtnLOGWF+C9cx3F+uNC8r0tN8lEkkW9LExEheai4/PE42pC5J7YG/eRn+P
TPBOMTfV5NH62DC3Gf2kf4URuRibMjHy+YvoH5h7Y35aX3es372AKt+7i0gk
TqWU8WMp+niib33dT6uyMpn8xtCzzkCNeLi73Tl39tSA2bCvtTWf4dNde8aY
Sz9Ya29DPntL9x0/SLnZKg0fTdN5UDrB/poFZ5VdRuATjB83thLPCMjH5El7
ykp7wB/fN15gHhwTE62m/s1lUYacG+9nFiEhclVQUGC9SOR4daSfbzfuTbyX
UpmmOYsw56X+hN/StGyhj5iNMfwGi2dSmbWVFb4vAnE+wdvbq0p7X7Isc2m/
fJWf7mP4/I3Ep2s0sDVByafu5Wz2sMYwPpDCjXnkTNuP/3BhLrMyK/NK0rzE
Bvwf8qoPh4APre/3G5adnV0lnLU7ZTLp9XW5q+9u3rSemTP8vuAE4mifyVTG
1jKECwQ28+Hc3wq/E4xxo78BEvI7/Q==
      "], {{0, 0}, {40, 40}}, {0, 255},
      ColorFunction->RGBColor],
     Background->None,
     ImageSize->{40, 40},
     PlotRange->{{0, 40}, {0, 40}}], "\[InvisibleSpace]", "\<\"Italy\"\>"}],
   Row[{
     Graphics[
      Raster[CompressedData["
1:eJztmH9Uk1UYx98x2BgD3gmMsbFB/BAyQAlpCO2IUiSnQlOyREWBAk04olCy
VE6hoksFRERRUPLISUtUkgrtl2igaEYQIfJD0UrNJLQUVKbdnmfurR0aCtOx
f3rO+Z67e3ff+37e+977PM993eJTpsSzKYp6XCtz6n9js9mRcnnA8mHDBF9i
1dQ8OiYDhXG5nNsV+3cT4LsF9WdNDQUmpWm6Zu6chIbNhfk36k7WkPbWRgLt
qDdNyGUjEjkWIMeitxbe/eWnVsJob9kHxHu451cmZEMj2WtX9TY1ntQw4bxh
eb6jmbS1NJC42Jhm6CMFRYLEQw3n5ua6PCwstDc4OOhq0rzEq6MD/MtemvRi
dVJSYn1xUcGd9EWpJCjoqSq5PPCyVOq8f6j5wDiwV3OgjLawsHgFShaIB3IQ
ix0XQ9tlc3Nz9RtzX++ZMX1aJ4/HKzIB44OMzeVyr+3auZ14erpfgLrLQ4wl
BBEzM7NeKL1AHo8CUCwSvTbc06MrdvaMdqjGUIaHienIl78+W+MbbG1trkDp
/AgQg3JzVJdaT9eTUSP91Hw+f4GB4wRmLE1vxz14+NABkpw0p416+Dlk+fv5
pJTu2Hqn40wTCR2ruMXhcKKg3cKAsR4DkW+OfKHxE9vfL+qG+viH5BuVkaE8
3dhwnEjE4huwXy5Bm6XO/7xBjDUB+Zqb6jR8xVsK1PCskw3k4goEtklWVlYF
GUuUPZ9UlBEPD7c9uh1cXWW4xy8MYkypi4vsN1wnyJeWOv8a+IQpBrCZCwR0
zYQJ4ddjZkarce6OH6tCX1gN/9Ggl0HJUVGTOhWK4M8HOqilpWUe8HX/fL5F
w/fdt9VEKBTWDoJLwGKxVsA4s2Qy58bao4eIbsxbn7e2i8+3agoJGdMJvvvi
poJ1NyNfiBjwXhE6OGA+RLJWvKMZD3+D/10zCL6FeI2jo1BdkJ/brcuGwucG
JnLgs3ISFjauMzIyIp0axPqDtauEIoHH456j7uUeKN8BXOoOmgd5Ved7quV3
mfnvqyNVB8mG/JwrwcHyjQMct6+xtKUZKJZ6cEx3gGc6yzwLvL//zBmqZGth
T3xczInQUIUK+j+tcx9jmquzs6R6zeosgvtJ35xh2749O8HPW7dAf7shYNIY
TfOfsbGx7oEc+S9984VcJdsK1UsWL2pVrVzWQdva3obL4ocADedgDfiOrh/q
a/WusZbm70lgYMCfQqH9VujrChoBmgjiGpkN1yT6avJx+Ud62U6fqiNeXp6/
cjiafTbUloJsfX0aI4ytiQlxFyCXes4EbJYQR/6AnEHvemMUFzsT44O9Cfjo
qVMnH8UzWX9sVV9XEkXImGUmYMO4F120ZUNvf2wnag+TiIjwLuiqMBaDj8+I
V319fXaD/wzRacY94QS+5MC24k16/UjpjuKbEOMPQr9plPH8Lg05fVvs7JmY
1xNtnLOGWF+C9cx3F+uNC8r0tN8lEkkW9LExEheai4/PE42pC5J7YG/eRn+P
TPBOMTfV5NH62DC3Gf2kf4URuRibMjHy+YvoH5h7Y35aX3es372AKt+7i0gk
TqWU8WMp+niib33dT6uyMpn8xtCzzkCNeLi73Tl39tSA2bCvtTWf4dNde8aY
Sz9Ya29DPntL9x0/SLnZKg0fTdN5UDrB/poFZ5VdRuATjB83thLPCMjH5El7
ykp7wB/fN15gHhwTE62m/s1lUYacG+9nFiEhclVQUGC9SOR4daSfbzfuTbyX
UpmmOYsw56X+hN/StGyhj5iNMfwGi2dSmbWVFb4vAnE+wdvbq0p7X7Isc2m/
fJWf7mP4/I3Ep2s0sDVByafu5Wz2sMYwPpDCjXnkTNuP/3BhLrMyK/NK0rzE
Bvwf8qoPh4APre/3G5adnV0lnLU7ZTLp9XW5q+9u3rSemTP8vuAE4mifyVTG
1jKECwQ28+Hc3wq/E4xxo78BEvI7/Q==
       "], {{0, 0}, {40, 40}}, {0, 255}, ColorFunction -> RGBColor], 
      Background -> None, ImageSize -> {40, 40}, 
      PlotRange -> {{0, 40}, {0, 40}}], "Italy"}]]->
  GraphicsBox[{{}, 
    {Hue[0.67, 0.6, 0.6], 
     PointBox[{{2.2089888*^9, 1.1001857267906438`*^11}, {2.2405248*^9, 
      1.208138060400842*^11}, {2.2720608*^9, 1.4051891364948038`*^11}, {
      2.3036832*^9, 1.6924997901562256`*^11}, {2.3352192*^9, 
      1.9190272481504858`*^11}, {2.3667552*^9, 2.180850414845017*^11}, {
      2.3982912*^9, 2.147967296050531*^11}, {2.4299136*^9, 
      2.4615984711328445`*^11}, {2.4614496*^9, 3.0110685730610004`*^11}, {
      2.4929856*^9, 3.7633987340165295`*^11}, {2.5245216*^9, 
      4.5847054570827466`*^11}, {2.556144*^9, 4.143881892309424*^11}, {
      2.58768*^9, 4.1068947165956665`*^11}, {2.619216*^9, 
      4.259969852143084*^11}, {2.650752*^9, 4.2190574220929376`*^11}, {
      2.6823744*^9, 4.353899537941441*^11}, {2.7139104*^9, 
      6.169717535000852*^11}, {2.7454464*^9, 7.76334491116145*^11}, {
      2.7769824*^9, 8.590083924665312*^11}, {2.8086048*^9, 
      8.947177390136152*^11}, {2.8401408*^9, 1.13346545429888*^12}, {
      2.8716768*^9, 1.1952212090324875`*^12}, {2.9032128*^9, 
      1.265830956132651*^12}, {2.9348352*^9, 1.0209509577101204`*^12}, {
      2.9663712*^9, 1.0539769534685912`*^12}, {2.9979072*^9, 
      1.126076542839802*^12}, {3.0294432*^9, 1.2596573470019568`*^12}, {
      3.0610656*^9, 1.19235440187141*^12}, {3.0926016*^9, 
      1.2171187235257039`*^12}, {3.1241376*^9, 1.2007866317323293`*^12}, {
      3.1556736*^9, 1.0973432886781492`*^12}, {3.187296*^9, 
      1.1173484826847188`*^12}, {3.218832*^9, 1.2189766944107778`*^12}, {
      3.250368*^9, 1.507113125025088*^12}, {3.281904*^9, 
      1.724522852463169*^12}, {3.3135264*^9, 1.7624749651606726`*^12}}]}, {}},
   
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   AxesOrigin->NCache[{2208988800, 0}, {2.2089888*^9, 0}],
   Frame->True,
   FrameTicks->{{Automatic, Automatic}, {{{
        NCache[2208988800, 2.2089888*^9], 
        FormBox["\"1970\"", TraditionalForm]}, {
        NCache[2524521600, 2.5245216*^9], 
        FormBox["\"1980\"", TraditionalForm]}, {
        NCache[2840140800, 2.8401408*^9], 
        FormBox["\"1990\"", TraditionalForm]}, {
        NCache[3155673600, 3.1556736*^9], 
        FormBox["\"2000\"", TraditionalForm]}, {
        NCache[2272060800, 2.2720608*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2335219200, 2.3352192*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2398291200, 2.3982912*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2461449600, 2.4614496*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2587680000, 2.58768*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2650752000, 2.650752*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2713910400, 2.7139104*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2776982400, 2.7769824*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2903212800, 2.9032128*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2966371200, 2.9663712*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3029443200, 3.0294432*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3092601600, 3.0926016*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3218832000, 3.218832*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3281904000, 3.281904*^9], 
        FormBox["\" \"", TraditionalForm]}}, {{
        NCache[2208988800, 2.2089888*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2524521600, 2.5245216*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2840140800, 2.8401408*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3155673600, 3.1556736*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2272060800, 2.2720608*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2335219200, 2.3352192*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2398291200, 2.3982912*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2461449600, 2.4614496*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2587680000, 2.58768*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2650752000, 2.650752*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2713910400, 2.7139104*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2776982400, 2.7769824*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2903212800, 2.9032128*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2966371200, 2.9663712*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3029443200, 3.0294432*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3092601600, 3.0926016*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3218832000, 3.218832*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3281904000, 3.281904*^9], 
        FormBox["\" \"", TraditionalForm]}}}},
   GridLines->NCache[{{{2208988800, 
        GrayLevel[0.8]}, {2524521600, 
        GrayLevel[0.8]}, {2840140800, 
        GrayLevel[0.8]}, {3155673600, 
        GrayLevel[0.8]}}, None}, {{{2.2089888*^9, 
        GrayLevel[0.8]}, {2.5245216*^9, 
        GrayLevel[0.8]}, {2.8401408*^9, 
        GrayLevel[0.8]}, {3.1556736*^9, 
        GrayLevel[0.8]}}, None}],
   PlotRange->{{2.2089888*^9, 3.3135264*^9}, {0., 1.7624749651606726`*^12}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]},
   Ticks->None]}, {5,
  InterpretationBox[
   RowBox[{
    GraphicsBox[RasterBox[CompressedData["
1:eJzVmGtsDFEUx+/O7PspW9XqKm0QlXrUJ0HrGYKE2CJEbFO7Sry1ql6JR8W7
XtUi2giaiPhEJB7RtKWpiqxGqdIqpQgfRDw+aHV3r3NmZ9bsqMSX7q1/cnLu
zszm/ubcO+eeexPd69LdPCEkSTQ1+e9kA7vEcdx78FGsYRTSgHWCUZnFMyUK
lw7idg08HTxoYMdST+YPaBeyhlJo7qiUkV9aXz6lZ0tP/jSZTAdZA8k0QKvV
loCnOdlr/NV3b0tjPFmr1dwR23Gs4GBsK0UGuiFnLX3V0iCfh5IhXzRYbwaI
AkNiwgDfm9ZndPWq5WFs58+d8ev1+m/YttksXvBRZrOxQrzvjgDfMKKIl9ls
fgi+DdvA2zFr1sxAVcUNmpo6NvSdl50vCYjtmAgwoqww1gGe55Vj61P8foT+
UV2t/NpHMBUJ5k49mKE7AIGvFvuLirJ3Xr1ymeZuWBtwLV7oJ3/OR3qq+Bg9
ffJ4V3NVnkO7I4/iUujBPg7s3+1/19ZM0V40P6b79uyiK1dk0dqaCvr2TRN9
3lgnsNhsNnq36hb1Pqj+g9NkMlzoBkZUktRHhmtRZ97G7O9FJ474du3cRhMS
+gtjjnz4TUnvILxHUz0tOVOkjPnobmJM5jmuHvwtsEnR0dH5RqOhSeyzxWq1
+pFHzidZnbeGxsb08Z0oLGgXn49kbuLABmG/f+OTbFNezldYj6ZEkE2uTI8n
4/3Rw/vpyxcNXfIVHi/4Ds9NYMRH7HZ7MxHn2fp1q3zK+Qj5XZqDfVjwxcbG
lIv9r1CpVEJOb2l+EsaYkjLiA1wfzoIPpNZoNC4SzEsqg053MWvpkva2189D
fPPmzsGczmLt7lJ2e6/DO7Zv/YaMFeXXKcQV800Say6Zkp3O2Q3Ih2NNfufB
qYy5QoqPd2wpLSkWxhfXFhLky2fNJdOE7PVr2nAdxDimpY2TGHuKTEOHJrU0
NjxUxrAnCGssgefpE6/AhzVFv7i4etZgMg00Go0d0vq3LMvdDuv1UdZQojAX
ZoLRLZtzOzzuDAqsrSR4DtBThPV0KLfwPOdlzKPUSCJw8UI9ZrFY9rEGUgj3
IvLc3Fe8jnFdyApKksPRF88gBDbY/98Gz4N3Qr0j1bdDWPJBzRDa90s2Y/q0
z3cqb+I5wCfgdLLkA2lh7lVB7RwoOLSX3r9XGapncN8yYnjyZxl7LwZ8KrVa
/Rj7h1h+LbtQGlYTYr0NcZT2+GjpEebDHKgl4ndSXHQkjA/rGlzz+jnihL2e
Xq93RZhPromp48Z8kurqmupyarVa5HvQNIZsKMf41LGvsJZZkun6iUw6nW43
eAPE7SrHcTdIMO+wUu/585yNebnZ0lmOXnGfJRv2nS87d4plyNKV8Px9AQmy
Jf7rn34BC2Nb9A==
      "], {{0, 0}, {40, 40}}, {0, 255},
      ColorFunction->RGBColor],
     Background->None,
     ImageSize->{40, 40},
     PlotRange->{{0, 40}, {0, 40}}], "\[InvisibleSpace]", "\<\"Japan\"\>"}],
   Row[{
     Graphics[
      Raster[CompressedData["
1:eJzVmGtsDFEUx+/O7PspW9XqKm0QlXrUJ0HrGYKE2CJEbFO7Sry1ql6JR8W7
XtUi2giaiPhEJB7RtKWpiqxGqdIqpQgfRDw+aHV3r3NmZ9bsqMSX7q1/cnLu
zszm/ubcO+eeexPd69LdPCEkSTQ1+e9kA7vEcdx78FGsYRTSgHWCUZnFMyUK
lw7idg08HTxoYMdST+YPaBeyhlJo7qiUkV9aXz6lZ0tP/jSZTAdZA8k0QKvV
loCnOdlr/NV3b0tjPFmr1dwR23Gs4GBsK0UGuiFnLX3V0iCfh5IhXzRYbwaI
AkNiwgDfm9ZndPWq5WFs58+d8ev1+m/YttksXvBRZrOxQrzvjgDfMKKIl9ls
fgi+DdvA2zFr1sxAVcUNmpo6NvSdl50vCYjtmAgwoqww1gGe55Vj61P8foT+
UV2t/NpHMBUJ5k49mKE7AIGvFvuLirJ3Xr1ymeZuWBtwLV7oJ3/OR3qq+Bg9
ffJ4V3NVnkO7I4/iUujBPg7s3+1/19ZM0V40P6b79uyiK1dk0dqaCvr2TRN9
3lgnsNhsNnq36hb1Pqj+g9NkMlzoBkZUktRHhmtRZ97G7O9FJ474du3cRhMS
+gtjjnz4TUnvILxHUz0tOVOkjPnobmJM5jmuHvwtsEnR0dH5RqOhSeyzxWq1
+pFHzidZnbeGxsb08Z0oLGgXn49kbuLABmG/f+OTbFNezldYj6ZEkE2uTI8n
4/3Rw/vpyxcNXfIVHi/4Ds9NYMRH7HZ7MxHn2fp1q3zK+Qj5XZqDfVjwxcbG
lIv9r1CpVEJOb2l+EsaYkjLiA1wfzoIPpNZoNC4SzEsqg053MWvpkva2189D
fPPmzsGczmLt7lJ2e6/DO7Zv/YaMFeXXKcQV800Say6Zkp3O2Q3Ih2NNfufB
qYy5QoqPd2wpLSkWxhfXFhLky2fNJdOE7PVr2nAdxDimpY2TGHuKTEOHJrU0
NjxUxrAnCGssgefpE6/AhzVFv7i4etZgMg00Go0d0vq3LMvdDuv1UdZQojAX
ZoLRLZtzOzzuDAqsrSR4DtBThPV0KLfwPOdlzKPUSCJw8UI9ZrFY9rEGUgj3
IvLc3Fe8jnFdyApKksPRF88gBDbY/98Gz4N3Qr0j1bdDWPJBzRDa90s2Y/q0
z3cqb+I5wCfgdLLkA2lh7lVB7RwoOLSX3r9XGapncN8yYnjyZxl7LwZ8KrVa
/Rj7h1h+LbtQGlYTYr0NcZT2+GjpEebDHKgl4ndSXHQkjA/rGlzz+jnihL2e
Xq93RZhPromp48Z8kurqmupyarVa5HvQNIZsKMf41LGvsJZZkun6iUw6nW43
eAPE7SrHcTdIMO+wUu/585yNebnZ0lmOXnGfJRv2nS87d4plyNKV8Px9AQmy
Jf7rn34BC2Nb9A==
       "], {{0, 0}, {40, 40}}, {0, 255}, ColorFunction -> RGBColor], 
      Background -> None, ImageSize -> {40, 40}, 
      PlotRange -> {{0, 40}, {0, 40}}], "Japan"}]]->
  GraphicsBox[{{}, 
    {Hue[0.67, 0.6, 0.6], 
     PointBox[{{2.2089888*^9, 2.014529580514261*^11}, {2.2405248*^9, 
      2.2755033969951434`*^11}, {2.2720608*^9, 3.01343259543402*^11}, {
      2.3036832*^9, 4.094100716072971*^11}, {2.3352192*^9, 
      4.544586112238592*^11}, {2.3667552*^9, 4.941750673051077*^11}, {
      2.3982912*^9, 5.554042215464973*^11}, {2.4299136*^9, 
      6.835571874274996*^11}, {2.4614496*^9, 9.604251124685349*^11}, {
      2.4929856*^9, 9.996525293671614*^11}, {2.5245216*^9, 
      1.0473829652743596`*^12}, {2.556144*^9, 1.1575808025550977`*^12}, {
      2.58768*^9, 1.0757971376079556`*^12}, {2.619216*^9, 
      1.173473359359394*^12}, {2.650752*^9, 1.2486767468971565`*^12}, {
      2.6823744*^9, 1.3367483967990293`*^12}, {2.7139104*^9, 
      1.980635436908171*^12}, {2.7454464*^9, 2.4020878317749478`*^12}, {
      2.7769824*^9, 2.91659077365674*^12}, {2.8086048*^9, 
      2.9183378659623613`*^12}, {2.8401408*^9, 2.9957356166212617`*^12}, {
      2.8716768*^9, 3.4256890248509097`*^12}, {2.9032128*^9, 
      3.738954620999907*^12}, {2.9348352*^9, 4.291732742888624*^12}, {
      2.9663712*^9, 4.724875099850551*^12}, {2.9979072*^9, 
      5.206658298158463*^12}, {3.0294432*^9, 4.620456505153843*^12}, {
      3.0610656*^9, 4.233781703969587*^12}, {3.0926016*^9, 
      3.842264579344679*^12}, {3.1241376*^9, 4.3476498177611074`*^12}, {
      3.1556736*^9, 4.649615208479153*^12}, {3.187296*^9, 
      4.0877240379293174`*^12}, {3.218832*^9, 3.904826021289916*^12}, {
      3.250368*^9, 4.231250256567769*^12}, {3.281904*^9, 
      4.584885115685265*^12}, {3.3135264*^9, 4.558949854127995*^12}}]}, {}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   AxesOrigin->NCache[{2208988800, 0}, {2.2089888*^9, 0}],
   Frame->True,
   FrameTicks->{{Automatic, Automatic}, {{{
        NCache[2208988800, 2.2089888*^9], 
        FormBox["\"1970\"", TraditionalForm]}, {
        NCache[2524521600, 2.5245216*^9], 
        FormBox["\"1980\"", TraditionalForm]}, {
        NCache[2840140800, 2.8401408*^9], 
        FormBox["\"1990\"", TraditionalForm]}, {
        NCache[3155673600, 3.1556736*^9], 
        FormBox["\"2000\"", TraditionalForm]}, {
        NCache[2272060800, 2.2720608*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2335219200, 2.3352192*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2398291200, 2.3982912*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2461449600, 2.4614496*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2587680000, 2.58768*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2650752000, 2.650752*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2713910400, 2.7139104*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2776982400, 2.7769824*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2903212800, 2.9032128*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2966371200, 2.9663712*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3029443200, 3.0294432*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3092601600, 3.0926016*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3218832000, 3.218832*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3281904000, 3.281904*^9], 
        FormBox["\" \"", TraditionalForm]}}, {{
        NCache[2208988800, 2.2089888*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2524521600, 2.5245216*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2840140800, 2.8401408*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3155673600, 3.1556736*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2272060800, 2.2720608*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2335219200, 2.3352192*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2398291200, 2.3982912*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2461449600, 2.4614496*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2587680000, 2.58768*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2650752000, 2.650752*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2713910400, 2.7139104*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2776982400, 2.7769824*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2903212800, 2.9032128*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2966371200, 2.9663712*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3029443200, 3.0294432*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3092601600, 3.0926016*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3218832000, 3.218832*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3281904000, 3.281904*^9], 
        FormBox["\" \"", TraditionalForm]}}}},
   GridLines->NCache[{{{2208988800, 
        GrayLevel[0.8]}, {2524521600, 
        GrayLevel[0.8]}, {2840140800, 
        GrayLevel[0.8]}, {3155673600, 
        GrayLevel[0.8]}}, None}, {{{2.2089888*^9, 
        GrayLevel[0.8]}, {2.5245216*^9, 
        GrayLevel[0.8]}, {2.8401408*^9, 
        GrayLevel[0.8]}, {3.1556736*^9, 
        GrayLevel[0.8]}}, None}],
   PlotRange->{{2.2089888*^9, 3.3135264*^9}, {0., 5.206658298158463*^12}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]},
   Ticks->None]}, {6,
  InterpretationBox[
   RowBox[{
    GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJmYGDQgGIWhlEwCkbBKBgFo2BIAkYgNgNiNSibFoAJiDmgbBAt
A2WzQmkjBtxVKchN/6F4Mw3cZo5kPjLuwCI2C4g9gZgZST87mho2ajmMkZFx
D8hMTU31v/fuXPmfEB/zf+OGVf/Z2Fj/gcQ3rFvxf8b0Sf9v37r0//rVc//D
w4J/Q92QBDUiHosfhHFYJ8rMzHSWAREnBJ0nLCj4eMe2Df+fPLqFgh89uPH/
8cObGOIgN0LdMBPot1MwvwkI8P/z9HCDuZ0Pi12g8L4Glc/EIg9KU7C0C6Kd
Yf4FhRu6O/Dh9LSkXzC9p04chIufPX0E5nYnLPbzMGCGMyy9RyGJCQKxA4yP
LeyIwaD4Rg7fC+eOA92dDLMDW/zNA8nduXX5f39fJ0wdPxDfBbG9vTww0v/5
s8fIchsyvnLpNLq5T7G4DQT++/h4gvVcvXwGRU9Odjo4PR3cvwMsR6mbkDEo
bUDtuQfEU3G4jQHZPcuXzgeH/+FDu8FpgpruQcegOEayGz1e1YHYAIkvDFN7
49o5mroL2X1I6Q5efgPz9mIkd8OAJIhfVlqItWzAhU8c20/NMNQCum0WEv8i
kvtA5fZ/KSnJf8SUGQ/uXftvZWUBN9vIyIAkfyFjUPpGTmMtzXUwdiiS++D1
ICgvEGNuR3sTRr5+eP86WWFYW1OOrY5kx5ZXlJWV/uKyB1RWRYSHYDMLjGfP
mgJWd/H8CTBfU0P9v5+v9/8Z0yaC+f29HVjNDQ7yRzcLV1tmIkgeVG+Cwh2k
V0xM9B8O94Dqmkvo4lqaGmB34vJDe2sjhvv27t5KrPtA+WcqLrOh2ANNizSU
BrWzbmBRDyo7QOWFCLL4uTNH/y+YPxPuxu1b1//fv3cbTF4cl/uQgBELC8sy
LPYR0wYqZYDU0+jhAPLDdGTzrl05C3djbGwkTJyXCDtgQB/NfdQCEjAzz5w6
TEzewAdA4YCtbUEJgJcZ/X0db6FsEE1M3NINANM7qN1pB8RcA+2WUTAKRsEo
GAXEAwCwGZ4C
      "], {{0, 0}, {40, 40}}, {0, 255},
      ColorFunction->RGBColor],
     Background->None,
     ImageSize->{40, 40},
     PlotRange->{{0, 40}, {0, 40}}], "\[InvisibleSpace]", "\<\"Russia\"\>"}],
   Row[{
     Graphics[
      Raster[CompressedData["
1:eJxTTMoPSmJmYGDQgGIWhlEwCkbBKBgFo2BIAkYgNgNiNSibFoAJiDmgbBAt
A2WzQmkjBtxVKchN/6F4Mw3cZo5kPjLuwCI2C4g9gZgZST87mho2ajmMkZFx
D8hMTU31v/fuXPmfEB/zf+OGVf/Z2Fj/gcQ3rFvxf8b0Sf9v37r0//rVc//D
w4J/Q92QBDUiHosfhHFYJ8rMzHSWAREnBJ0nLCj4eMe2Df+fPLqFgh89uPH/
8cObGOIgN0LdMBPot1MwvwkI8P/z9HCDuZ0Pi12g8L4Glc/EIg9KU7C0C6Kd
Yf4FhRu6O/Dh9LSkXzC9p04chIufPX0E5nYnLPbzMGCGMyy9RyGJCQKxA4yP
LeyIwaD4Rg7fC+eOA92dDLMDW/zNA8nduXX5f39fJ0wdPxDfBbG9vTww0v/5
s8fIchsyvnLpNLq5T7G4DQT++/h4gvVcvXwGRU9Odjo4PR3cvwMsR6mbkDEo
bUDtuQfEU3G4jQHZPcuXzgeH/+FDu8FpgpruQcegOEayGz1e1YHYAIkvDFN7
49o5mroL2X1I6Q5efgPz9mIkd8OAJIhfVlqItWzAhU8c20/NMNQCum0WEv8i
kvtA5fZ/KSnJf8SUGQ/uXftvZWUBN9vIyIAkfyFjUPpGTmMtzXUwdiiS++D1
ICgvEGNuR3sTRr5+eP86WWFYW1OOrY5kx5ZXlJWV/uKyB1RWRYSHYDMLjGfP
mgJWd/H8CTBfU0P9v5+v9/8Z0yaC+f29HVjNDQ7yRzcLV1tmIkgeVG+Cwh2k
V0xM9B8O94Dqmkvo4lqaGmB34vJDe2sjhvv27t5KrPtA+WcqLrOh2ANNizSU
BrWzbmBRDyo7QOWFCLL4uTNH/y+YPxPuxu1b1//fv3cbTF4cl/uQgBELC8sy
LPYR0wYqZYDU0+jhAPLDdGTzrl05C3djbGwkTJyXCDtgQB/NfdQCEjAzz5w6
TEzewAdA4YCtbUEJgJcZ/X0db6FsEE1M3NINANM7qN1pB8RcA+2WUTAKRsEo
GAXEAwCwGZ4C
       "], {{0, 0}, {40, 40}}, {0, 255}, ColorFunction -> RGBColor], 
      Background -> None, ImageSize -> {40, 40}, 
      PlotRange -> {{0, 40}, {0, 40}}], "Russia"}]]->
  GraphicsBox[{{}, 
    {Hue[0.67, 0.6, 0.6], 
     PointBox[{{2.8401408*^9, 5.697118807301721*^11}, {2.8716768*^9, 
      5.60148358206564*^11}, {2.9032128*^9, 4.899543440560434*^11}, {
      2.9348352*^9, 4.576050839536752*^11}, {2.9663712*^9, 
      4.0791335145689514`*^11}, {2.9979072*^9, 3.991662245416091*^11}, {
      3.0294432*^9, 3.9208952318958527`*^11}, {3.0610656*^9, 
      4.049406205883203*^11}, {3.0926016*^9, 2.709531602854175*^11}, {
      3.1241376*^9, 1.95907924077677*^11}, {3.1556736*^9, 
      2.597178361724186*^11}, {3.187296*^9, 3.066175749373683*^11}, {
      3.218832*^9, 3.4548832824979877`*^11}, {3.250368*^9, 
      4.3148797448197046`*^11}, {3.281904*^9, 5.902873738774519*^11}, {
      3.3135264*^9, 7.659680383768098*^11}}]}, {}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   AxesOrigin->NCache[{2208988800, 2.*^11}, {2.2089888*^9, 2.*^11}],
   Frame->True,
   FrameTicks->{{Automatic, Automatic}, {{{
        NCache[2208988800, 2.2089888*^9], 
        FormBox["\"1970\"", TraditionalForm]}, {
        NCache[2524521600, 2.5245216*^9], 
        FormBox["\"1980\"", TraditionalForm]}, {
        NCache[2840140800, 2.8401408*^9], 
        FormBox["\"1990\"", TraditionalForm]}, {
        NCache[3155673600, 3.1556736*^9], 
        FormBox["\"2000\"", TraditionalForm]}, {
        NCache[2272060800, 2.2720608*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2335219200, 2.3352192*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2398291200, 2.3982912*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2461449600, 2.4614496*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2587680000, 2.58768*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2650752000, 2.650752*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2713910400, 2.7139104*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2776982400, 2.7769824*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2903212800, 2.9032128*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2966371200, 2.9663712*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3029443200, 3.0294432*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3092601600, 3.0926016*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3218832000, 3.218832*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3281904000, 3.281904*^9], 
        FormBox["\" \"", TraditionalForm]}}, {{
        NCache[2208988800, 2.2089888*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2524521600, 2.5245216*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2840140800, 2.8401408*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3155673600, 3.1556736*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2272060800, 2.2720608*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2335219200, 2.3352192*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2398291200, 2.3982912*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2461449600, 2.4614496*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2587680000, 2.58768*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2650752000, 2.650752*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2713910400, 2.7139104*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2776982400, 2.7769824*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2903212800, 2.9032128*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2966371200, 2.9663712*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3029443200, 3.0294432*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3092601600, 3.0926016*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3218832000, 3.218832*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3281904000, 3.281904*^9], 
        FormBox["\" \"", TraditionalForm]}}}},
   GridLines->NCache[{{{2208988800, 
        GrayLevel[0.8]}, {2524521600, 
        GrayLevel[0.8]}, {2840140800, 
        GrayLevel[0.8]}, {3155673600, 
        GrayLevel[0.8]}}, None}, {{{2.2089888*^9, 
        GrayLevel[0.8]}, {2.5245216*^9, 
        GrayLevel[0.8]}, {2.8401408*^9, 
        GrayLevel[0.8]}, {3.1556736*^9, 
        GrayLevel[0.8]}}, None}],
   PlotRange->
    NCache[{{2208988800, 3.3135264*^9}, {1.95907924077677*^11, 
      7.659680383768098*^11}}, {{2.2089888*^9, 3.3135264*^9}, {
     1.95907924077677*^11, 7.659680383768098*^11}}],
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]},
   Ticks->None]}, {7,
  InterpretationBox[
   RowBox[{
    GraphicsBox[RasterBox[CompressedData["
1:eJzdmHtQVFUYwA/7ELblIRCguwspqQmLoag5PRzGrEinx+Q/9UdOiKnVNFA8
MtDEaggTRHuYGIFOQUKshmCm02QBRoQpSog8fFt/2Eh/OBqQu/v1fXc529ld
RJvx3tv0zXxzz+Fc7vnt9zjnO2diWsaiNC1jbOqw6tj/Q4KCglJ1Ol0DNgE1
WBj6r/xE8NIcof248J6f8miS3IY6n/lyco1E+1Zotdrjer1+KfYfMxqNa/E5
R2HOR4mnqrICfj3fC309x2DF8qWXUlIe7snOSu+/7945ThrHeLjG2U2m8baw
sLC0qKiojdjXKMBYSvNWflYuMZ4+2QlnT3dJbdKuzsMwPXGaMzn5AXt52UcO
W20lvLepCF595eWhyIiIiwaDoYe5/CGXGFF3EmNOdsZFqzXucsvBA4Ocj9uV
nufPdoP491N9nTB7VtIAc9lWKxMf5UAIaoGfn9/J4bnInh6M3mqrrXIyz5i1
3mowzIFMcY78NXl/XjjXA/PmJf9F/cbv9l2X76uGnQ56B3PoBD4n3Wo2lCT6
/pTJkyApafqVrMx0Z8fRVrcP9+7ZBT/+cMDHp6JGWywSI9q9UQY+TUBAQDt9
v6S48LoMN9Lqz7dz+98hAyPF3p30/fz8vN9Hs9VouiR1cT9+4yEZ+LgYMRYv
f1K2Gc6dOfGv+XZUbXOEh4cvloHLH7leQrVhG+p3f3FTPLgOwqq816729XZI
/ZIN64bGjg1eLQMf02g0tH9JMbRvb90N2dpaGz32wpkzZ1yIjZ1Yg22DHHwo
U/hcmCf2ovUFzkVPPTFwqK0JaK0ZiZHGYmIszfg/d6OamLx1xO2M+dYI2yu2
jshGPk1MnDYUHW3OYPLtGaMJ2QPeXfe2j/0wf8Q9Y74KbCRUo8IGXBPF9YZY
f25rhoULHnFMmBBTrCYb6cIFKSPuHWaziWotir0AFfimYj471+avcnpzkf0K
C97kvr1LQaZI1Bmoz6CuRv9dPXPquAcb7cXsn7gzK8gWx24id03jx9l1Wm05
jukVZCNZSTy5r2fD/q/rYM0buVJ+Yg3v4DX0sfZWCAkJvjL8W5SUcaizIiLC
VyLfoLiWiO3dX9bQ+eM3pmw+kJ+otnT7tLf7qE+uEmfqc886AgMD1zNlzkJu
8ff3X4FnR4kxISF+QLQZr2Fqqj/l/LFKsqFkMK+cKC56B/bU2xy8n5ebY8ez
2WBoaOjTCrORSP7FutzN1/ZTE1jj49x8TB27cZHm1+lc8dfZccgdb03f7xf5
otWAQ7v9QfPjXiFxUJyJeVG65X2wmE10rl2iBh/KW0zwI9XN3rUK+Xt43KIC
XwjabpDmb6iv9bjPEHMYa4RL+M6DCrPRfZ/bdltLP5Bs573nktI9C+4lJUrC
Yex1iHwvvvA8tB9ukdq4Jjqam76BLZs3QdnHH0LLwW9h7tz7f8GxyQoiBjHX
3iHdYdTtqpbsR7ai/pgx+n6RH8/wR5g695SpnCErMx26u45wpmXMVacaVOIS
RbqfLC4qvEa1MtUCzMU4W2UuLoGokGCNdy5flmanNWVH1TbOeI/KbFyeZCPf
QafIMdnf1M1Cqg==
      "], {{0, 0}, {40, 40}}, {0, 255},
      ColorFunction->RGBColor],
     Background->None,
     ImageSize->{40, 40},
     PlotRange->{{0, 40}, {0, 40}}], 
    "\[InvisibleSpace]", "\<\"UnitedKingdom\"\>"}],
   Row[{
     Graphics[
      Raster[CompressedData["
1:eJzdmHtQVFUYwA/7ELblIRCguwspqQmLoag5PRzGrEinx+Q/9UdOiKnVNFA8
MtDEaggTRHuYGIFOQUKshmCm02QBRoQpSog8fFt/2Eh/OBqQu/v1fXc529ld
RJvx3tv0zXxzz+Fc7vnt9zjnO2diWsaiNC1jbOqw6tj/Q4KCglJ1Ol0DNgE1
WBj6r/xE8NIcof248J6f8miS3IY6n/lyco1E+1Zotdrjer1+KfYfMxqNa/E5
R2HOR4mnqrICfj3fC309x2DF8qWXUlIe7snOSu+/7945ThrHeLjG2U2m8baw
sLC0qKiojdjXKMBYSvNWflYuMZ4+2QlnT3dJbdKuzsMwPXGaMzn5AXt52UcO
W20lvLepCF595eWhyIiIiwaDoYe5/CGXGFF3EmNOdsZFqzXucsvBA4Ocj9uV
nufPdoP491N9nTB7VtIAc9lWKxMf5UAIaoGfn9/J4bnInh6M3mqrrXIyz5i1
3mowzIFMcY78NXl/XjjXA/PmJf9F/cbv9l2X76uGnQ56B3PoBD4n3Wo2lCT6
/pTJkyApafqVrMx0Z8fRVrcP9+7ZBT/+cMDHp6JGWywSI9q9UQY+TUBAQDt9
v6S48LoMN9Lqz7dz+98hAyPF3p30/fz8vN9Hs9VouiR1cT9+4yEZ+LgYMRYv
f1K2Gc6dOfGv+XZUbXOEh4cvloHLH7leQrVhG+p3f3FTPLgOwqq816729XZI
/ZIN64bGjg1eLQMf02g0tH9JMbRvb90N2dpaGz32wpkzZ1yIjZ1Yg22DHHwo
U/hcmCf2ovUFzkVPPTFwqK0JaK0ZiZHGYmIszfg/d6OamLx1xO2M+dYI2yu2
jshGPk1MnDYUHW3OYPLtGaMJ2QPeXfe2j/0wf8Q9Y74KbCRUo8IGXBPF9YZY
f25rhoULHnFMmBBTrCYb6cIFKSPuHWaziWotir0AFfimYj471+avcnpzkf0K
C97kvr1LQaZI1Bmoz6CuRv9dPXPquAcb7cXsn7gzK8gWx24id03jx9l1Wm05
jukVZCNZSTy5r2fD/q/rYM0buVJ+Yg3v4DX0sfZWCAkJvjL8W5SUcaizIiLC
VyLfoLiWiO3dX9bQ+eM3pmw+kJ+otnT7tLf7qE+uEmfqc886AgMD1zNlzkJu
8ff3X4FnR4kxISF+QLQZr2Fqqj/l/LFKsqFkMK+cKC56B/bU2xy8n5ebY8ez
2WBoaOjTCrORSP7FutzN1/ZTE1jj49x8TB27cZHm1+lc8dfZccgdb03f7xf5
otWAQ7v9QfPjXiFxUJyJeVG65X2wmE10rl2iBh/KW0zwI9XN3rUK+Xt43KIC
XwjabpDmb6iv9bjPEHMYa4RL+M6DCrPRfZ/bdltLP5Bs573nktI9C+4lJUrC
Yex1iHwvvvA8tB9ukdq4Jjqam76BLZs3QdnHH0LLwW9h7tz7f8GxyQoiBjHX
3iHdYdTtqpbsR7ai/pgx+n6RH8/wR5g695SpnCErMx26u45wpmXMVacaVOIS
RbqfLC4qvEa1MtUCzMU4W2UuLoGokGCNdy5flmanNWVH1TbOeI/KbFyeZCPf
QafIMdnf1M1Cqg==
       "], {{0, 0}, {40, 40}}, {0, 255}, ColorFunction -> RGBColor], 
      Background -> None, ImageSize -> {40, 40}, 
      PlotRange -> {{0, 40}, {0, 40}}], "UnitedKingdom"}]]->
  GraphicsBox[{{}, 
    {Hue[0.67, 0.6, 0.6], 
     PointBox[{{2.2089888*^9, 1.2363590126436914`*^11}, {2.2405248*^9, 
      1.3980572083619217`*^11}, {2.2720608*^9, 1.6063569485203543`*^11}, {
      2.3036832*^9, 1.8124513969447748`*^11}, {2.3352192*^9, 
      1.957702847195009*^11}, {2.3667552*^9, 2.3398975145108023`*^11}, {
      2.3982912*^9, 2.2479207505729996`*^11}, {2.4299136*^9, 
      2.5385680838041418`*^11}, {2.4614496*^9, 3.21772819807636*^11}, {
      2.4929856*^9, 4.179666923422399*^11}, {2.5245216*^9, 
      5.361321896283531*^11}, {2.556144*^9, 5.083982851941528*^11}, {
      2.58768*^9, 4.840449529095338*^11}, {2.619216*^9, 
      4.5894000027881354`*^11}, {2.650752*^9, 4.3150455371477625`*^11}, {
      2.6823744*^9, 4.5550699023655786`*^11}, {2.7139104*^9, 
      5.58954105166052*^11}, {2.7454464*^9, 6.857539263293876*^11}, {
      2.7769824*^9, 8.331747712214061*^11}, {2.8086048*^9, 
      8.412809635246335*^11}, {2.8401408*^9, 9.89564266780465*^11}, {
      2.8716768*^9, 1.0334817518162361`*^12}, {2.9032128*^9, 
      1.0715859646146346`*^12}, {2.9348352*^9, 9.624067386994218*^11}, {
      2.9663712*^9, 1.0413426629112925`*^12}, {2.9979072*^9, 
      1.1336896670768289`*^12}, {3.0294432*^9, 1.1912803900154153`*^12}, {
      3.0610656*^9, 1.3270351591864573`*^12}, {3.0926016*^9, 
      1.4251182105389539`*^12}, {3.1241376*^9, 1.4649752807122458`*^12}, {
      3.1556736*^9, 1.4427772951531748`*^12}, {3.187296*^9, 
      1.4348964593935117`*^12}, {3.218832*^9, 1.571371904459777*^12}, {
      3.250368*^9, 1.805663111405002*^12}, {3.281904*^9, 
      2.1321560657658647`*^12}, {3.3135264*^9, 
      2.1987957539265283`*^12}}]}, {}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   AxesOrigin->NCache[{2208988800, 0}, {2.2089888*^9, 0}],
   Frame->True,
   FrameTicks->{{Automatic, Automatic}, {{{
        NCache[2208988800, 2.2089888*^9], 
        FormBox["\"1970\"", TraditionalForm]}, {
        NCache[2524521600, 2.5245216*^9], 
        FormBox["\"1980\"", TraditionalForm]}, {
        NCache[2840140800, 2.8401408*^9], 
        FormBox["\"1990\"", TraditionalForm]}, {
        NCache[3155673600, 3.1556736*^9], 
        FormBox["\"2000\"", TraditionalForm]}, {
        NCache[2272060800, 2.2720608*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2335219200, 2.3352192*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2398291200, 2.3982912*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2461449600, 2.4614496*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2587680000, 2.58768*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2650752000, 2.650752*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2713910400, 2.7139104*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2776982400, 2.7769824*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2903212800, 2.9032128*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2966371200, 2.9663712*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3029443200, 3.0294432*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3092601600, 3.0926016*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3218832000, 3.218832*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3281904000, 3.281904*^9], 
        FormBox["\" \"", TraditionalForm]}}, {{
        NCache[2208988800, 2.2089888*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2524521600, 2.5245216*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2840140800, 2.8401408*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3155673600, 3.1556736*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2272060800, 2.2720608*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2335219200, 2.3352192*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2398291200, 2.3982912*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2461449600, 2.4614496*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2587680000, 2.58768*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2650752000, 2.650752*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2713910400, 2.7139104*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2776982400, 2.7769824*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2903212800, 2.9032128*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2966371200, 2.9663712*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3029443200, 3.0294432*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3092601600, 3.0926016*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3218832000, 3.218832*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3281904000, 3.281904*^9], 
        FormBox["\" \"", TraditionalForm]}}}},
   GridLines->NCache[{{{2208988800, 
        GrayLevel[0.8]}, {2524521600, 
        GrayLevel[0.8]}, {2840140800, 
        GrayLevel[0.8]}, {3155673600, 
        GrayLevel[0.8]}}, None}, {{{2.2089888*^9, 
        GrayLevel[0.8]}, {2.5245216*^9, 
        GrayLevel[0.8]}, {2.8401408*^9, 
        GrayLevel[0.8]}, {3.1556736*^9, 
        GrayLevel[0.8]}}, None}],
   PlotRange->{{2.2089888*^9, 3.3135264*^9}, {0., 2.1987957539265283`*^12}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]},
   Ticks->None]}, {8,
  InterpretationBox[
   RowBox[{
    GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJmYGDQgGIWhlEwCkbBKBgFVADRQPwfiKUG2iFYwAQGiNtAeC0Z
+iOo6xwUoADE/62tLWHuA2E2IvUyIukBYWYquYkfZB4jI+M3EB0eHvz78cOb
/+tqK5HtAoWJERAnAHEFENtB3QMDzDC1vj6eIHMc0eTJBYIgM6sqS/9bWVn8
dHdz+fPk0a3/MHzrxgVkN6JjTagZVkBsjybnTaZ79IDYEoh9gVgLZh6ym7Dh
B/eu/b9+9dz/06cO/Qf64R8eN8MwqUBYQU6m1MTY4EFRYc6r6qqyPxYWZp9a
Wxq+EXIbNvzw/vX/9+5c+T95Ui/Y7YcO7kJ2GzcJ7rIBpqsuYWGh17NnTvnx
6MENkt1CDL5/9+p/dTVVUvNFIUh9YkLsvwvnjtPEXcg4OSkO5r67DISbo/Eg
tTNnTKa5u5AxMCxgblTG4S5Qnp4HUrN29VK6ug2EQeUSA/7yjw0mD0oT9HYf
CJ86eQhfPlYCic+aSd94RcZ3b19Bdp8FmvsiQeLZWWngMmAg3GdmZoLsPpR8
AixL9oDEQX4YCLft3LERvZxmQnYfMzPz0ZDgALqFHSg/HNy/A0UMzX3o5cz/
zIyUP/Rw2+2bF/8rKyv9BdlpZ2v9B+RWUJ48e/rI/5iYCJj7BNDcFwYSv33r
El3Cb+nief95eXkvs7GxHUtKjHsNijeQO+fMnoochuxI7ksHiZ0/e4wu7ps7
Z9ovaWnpOKCdpgzgdlDJO1C9DJLbvnU9shtZkeMY6Jd/tI5bCQnxf8D8CIpf
WF3BCcT/+no7wGounj+Bq6wOgolfvniSZLtBaQjUJgGxQWGxZvWS/zHREf8D
Anz/Hjm0B1Rn/oSa/wstXEDAAySXl5PxA6QWqm41A2pb1QDmPlBaQLYb1IY7
fnTf/w3rVgDtmfQxIz3lUV5e5vnExNiToSGBR3y8PPZ7errt8PLy2OHi4ngK
OS8Cw+oaiAamtxkMkHoAF5Di4OCoYkDNxyFoauByoDJpzuxpnzPSki+4ujqv
t7GxapOQEAWFMaidqgPEogyQNj47mhmgODFBixuih8lYWVmvdbQ3YavruJHd
Z2Cg1wykHYBYglizqQCYubm518nLyf7j4eHZh0UelC5YGDDTBz0BLysz8xEG
SL4ZBaNgFIwCmgIAaC0IUA==
      "], {{0, 0}, {40, 40}}, {0, 255},
      ColorFunction->RGBColor],
     Background->None,
     ImageSize->{40, 40},
     PlotRange->{{0, 40}, {0, 40}}], 
    "\[InvisibleSpace]", "\<\"UnitedStates\"\>"}],
   Row[{
     Graphics[
      Raster[CompressedData["
1:eJxTTMoPSmJmYGDQgGIWhlEwCkbBKBgFVADRQPwfiKUG2iFYwAQGiNtAeC0Z
+iOo6xwUoADE/62tLWHuA2E2IvUyIukBYWYquYkfZB4jI+M3EB0eHvz78cOb
/+tqK5HtAoWJERAnAHEFENtB3QMDzDC1vj6eIHMc0eTJBYIgM6sqS/9bWVn8
dHdz+fPk0a3/MHzrxgVkN6JjTagZVkBsjybnTaZ79IDYEoh9gVgLZh6ym7Dh
B/eu/b9+9dz/06cO/Qf64R8eN8MwqUBYQU6m1MTY4EFRYc6r6qqyPxYWZp9a
Wxq+EXIbNvzw/vX/9+5c+T95Ui/Y7YcO7kJ2GzcJ7rIBpqsuYWGh17NnTvnx
6MENkt1CDL5/9+p/dTVVUvNFIUh9YkLsvwvnjtPEXcg4OSkO5r67DISbo/Eg
tTNnTKa5u5AxMCxgblTG4S5Qnp4HUrN29VK6ug2EQeUSA/7yjw0mD0oT9HYf
CJ86eQhfPlYCic+aSd94RcZ3b19Bdp8FmvsiQeLZWWngMmAg3GdmZoLsPpR8
AixL9oDEQX4YCLft3LERvZxmQnYfMzPz0ZDgALqFHSg/HNy/A0UMzX3o5cz/
zIyUP/Rw2+2bF/8rKyv9BdlpZ2v9B+RWUJ48e/rI/5iYCJj7BNDcFwYSv33r
El3Cb+nief95eXkvs7GxHUtKjHsNijeQO+fMnoochuxI7ksHiZ0/e4wu7ps7
Z9ovaWnpOKCdpgzgdlDJO1C9DJLbvnU9shtZkeMY6Jd/tI5bCQnxf8D8CIpf
WF3BCcT/+no7wGounj+Bq6wOgolfvniSZLtBaQjUJgGxQWGxZvWS/zHREf8D
Anz/Hjm0B1Rn/oSa/wstXEDAAySXl5PxA6QWqm41A2pb1QDmPlBaQLYb1IY7
fnTf/w3rVgDtmfQxIz3lUV5e5vnExNiToSGBR3y8PPZ7errt8PLy2OHi4ngK
OS8Cw+oaiAamtxkMkHoAF5Di4OCoYkDNxyFoauByoDJpzuxpnzPSki+4ujqv
t7GxapOQEAWFMaidqgPEogyQNj47mhmgODFBixuih8lYWVmvdbQ3YavruJHd
Z2Cg1wykHYBYglizqQCYubm518nLyf7j4eHZh0UelC5YGDDTBz0BLysz8xEG
SL4ZBaNgFIwCmgIAaC0IUA==
       "], {{0, 0}, {40, 40}}, {0, 255}, ColorFunction -> RGBColor], 
      Background -> None, ImageSize -> {40, 40}, 
      PlotRange -> {{0, 40}, {0, 40}}], "UnitedStates"}]]->
  GraphicsBox[{{}, 
    {Hue[0.67, 0.6, 0.6], 
     PointBox[{{2.2089888*^9, 1.025*^12}, {2.2405248*^9, 1.1134*^12}, {
      2.2720608*^9, 1.2254*^12}, {2.3036832*^9, 1.3698*^12}, {2.3352192*^9, 
      1.4864000007432*^12}, {2.3667552*^9, 1.624000001624*^12}, {2.3982912*^9,
       1.8098000018098*^12}, {2.4299136*^9, 2.0143000020143*^12}, {
      2.4614496*^9, 2.2769000022769*^12}, {2.4929856*^9, 
      2.5445000025445*^12}, {2.5245216*^9, 2.7689000027689*^12}, {2.556144*^9,
       3.1054000031054*^12}, {2.58768*^9, 3.2295000032295*^12}, {2.619216*^9, 
      3.5088000035088*^12}, {2.650752*^9, 3.902600001626085*^12}, {
      2.6823744*^9, 4.1875*^12}, {2.7139104*^9, 4.4277*^12}, {2.7454464*^9, 
      4.7021*^12}, {2.7769824*^9, 5.0639*^12}, {2.8086048*^9, 5.4417*^12}, {
      2.8401408*^9, 5.7572*^12}, {2.8716768*^9, 5.9469*^12}, {2.9032128*^9, 
      6.2868*^12}, {2.9348352*^9, 6.6043*^12}, {2.9663712*^9, 7.0175*^12}, {
      2.9979072*^9, 7.3423*^12}, {3.0294432*^9, 7.7623*^12}, {3.0610656*^9, 
      8.2509*^12}, {3.0926016*^9, 8.6946*^12}, {3.1241376*^9, 9.2162*^12}, {
      3.1556736*^9, 9.7648*^12}, {3.187296*^9, 1.00759*^13}, {3.218832*^9, 
      1.04176*^13}, {3.250368*^9, 1.09185*^13}, {3.281904*^9, 1.16792*^13}, {
      3.3135264*^9, 1.24558*^13}}]}, {}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   AxesOrigin->NCache[{2208988800, 0}, {2.2089888*^9, 0}],
   Frame->True,
   FrameTicks->{{Automatic, Automatic}, {{{
        NCache[2208988800, 2.2089888*^9], 
        FormBox["\"1970\"", TraditionalForm]}, {
        NCache[2524521600, 2.5245216*^9], 
        FormBox["\"1980\"", TraditionalForm]}, {
        NCache[2840140800, 2.8401408*^9], 
        FormBox["\"1990\"", TraditionalForm]}, {
        NCache[3155673600, 3.1556736*^9], 
        FormBox["\"2000\"", TraditionalForm]}, {
        NCache[2272060800, 2.2720608*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2335219200, 2.3352192*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2398291200, 2.3982912*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2461449600, 2.4614496*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2587680000, 2.58768*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2650752000, 2.650752*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2713910400, 2.7139104*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2776982400, 2.7769824*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2903212800, 2.9032128*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2966371200, 2.9663712*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3029443200, 3.0294432*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3092601600, 3.0926016*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3218832000, 3.218832*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3281904000, 3.281904*^9], 
        FormBox["\" \"", TraditionalForm]}}, {{
        NCache[2208988800, 2.2089888*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2524521600, 2.5245216*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2840140800, 2.8401408*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3155673600, 3.1556736*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2272060800, 2.2720608*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2335219200, 2.3352192*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2398291200, 2.3982912*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2461449600, 2.4614496*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2587680000, 2.58768*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2650752000, 2.650752*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2713910400, 2.7139104*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2776982400, 2.7769824*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2903212800, 2.9032128*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[2966371200, 2.9663712*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3029443200, 3.0294432*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3092601600, 3.0926016*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3218832000, 3.218832*^9], 
        FormBox["\" \"", TraditionalForm]}, {
        NCache[3281904000, 3.281904*^9], 
        FormBox["\" \"", TraditionalForm]}}}},
   GridLines->NCache[{{{2208988800, 
        GrayLevel[0.8]}, {2524521600, 
        GrayLevel[0.8]}, {2840140800, 
        GrayLevel[0.8]}, {3155673600, 
        GrayLevel[0.8]}}, None}, {{{2.2089888*^9, 
        GrayLevel[0.8]}, {2.5245216*^9, 
        GrayLevel[0.8]}, {2.8401408*^9, 
        GrayLevel[0.8]}, {3.1556736*^9, 
        GrayLevel[0.8]}}, None}],
   PlotRange->{{2.2089888*^9, 3.3135264*^9}, {0., 1.24558*^13}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]},
   Ticks->None]}}, 5,
  ControlPlacement->Left]], "Output",
 ImageSize->{334, 409},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->1372098722]
}, Open  ]],

Cell[TextData[{
 "The fact that tab labels can be absolutely anything, including typeset \
expressions, graphics, and dynamic output, makes ",
 Cell[BoxData[
  ButtonBox["TabView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TabView"]], "InlineFormula"],
 " considerably more flexible than you might at first think. Here, for \
example, is a ",
 Cell[BoxData[
  ButtonBox["TabView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TabView"]], "InlineFormula"],
 " where each pane includes a slider that allows you to adjust the label of \
the tab for that pane. (",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " are explained in ",
 ButtonBox["Introduction to Dynamic",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/IntroductionToDynamic"],
 ".)"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"values", "=", 
     RowBox[{"RandomInteger", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "100"}], "}"}], ",", 
       RowBox[{"{", "10", "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"TabView", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"With", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i", "=", "i"}], "}"}], ",", 
        RowBox[{
         RowBox[{"Dynamic", "[", 
          RowBox[{"values", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "]"}], "\[Rule]", 
         RowBox[{"Slider", "[", 
          RowBox[{
           RowBox[{"Dynamic", "[", 
            RowBox[{"values", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "100", ",", "1"}], "}"}]}], "]"}]}]}], "]"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "10"}], "}"}]}], "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[15]:="],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`values$$ = {49, 90, 3, 79, 57, 88, 53, 64, 5, 
  18}}, 
  TabViewBox[{{1,
   DynamicBox[ToBoxes[
     Part[$CellContext`values$$, 1], StandardForm],
    ImageSizeCache->{14., {0., 9.}}]->
   SliderBox[Dynamic[
     Part[$CellContext`values$$, 1]], {1, 100, 1}]}, {2,
   DynamicBox[ToBoxes[
     Part[$CellContext`values$$, 2], StandardForm],
    ImageSizeCache->{14., {0., 9.}}]->
   SliderBox[Dynamic[
     Part[$CellContext`values$$, 2]], {1, 100, 1}]}, {3,
   DynamicBox[ToBoxes[
     Part[$CellContext`values$$, 3], StandardForm],
    ImageSizeCache->{7., {0., 9.}}]->
   SliderBox[Dynamic[
     Part[$CellContext`values$$, 3]], {1, 100, 1}]}, {4,
   DynamicBox[ToBoxes[
     Part[$CellContext`values$$, 4], StandardForm],
    ImageSizeCache->{14., {0., 9.}}]->
   SliderBox[Dynamic[
     Part[$CellContext`values$$, 4]], {1, 100, 1}]}, {5,
   DynamicBox[ToBoxes[
     Part[$CellContext`values$$, 5], StandardForm],
    ImageSizeCache->{14., {0., 9.}}]->
   SliderBox[Dynamic[
     Part[$CellContext`values$$, 5]], {1, 100, 1}]}, {6,
   DynamicBox[ToBoxes[
     Part[$CellContext`values$$, 6], StandardForm],
    ImageSizeCache->{14., {0., 9.}}]->
   SliderBox[Dynamic[
     Part[$CellContext`values$$, 6]], {1, 100, 1}]}, {7,
   DynamicBox[ToBoxes[
     Part[$CellContext`values$$, 7], StandardForm],
    ImageSizeCache->{14., {0., 9.}}]->
   SliderBox[Dynamic[
     Part[$CellContext`values$$, 7]], {1, 100, 1}]}, {8,
   DynamicBox[ToBoxes[
     Part[$CellContext`values$$, 8], StandardForm],
    ImageSizeCache->{14., {0., 9.}}]->
   SliderBox[Dynamic[
     Part[$CellContext`values$$, 8]], {1, 100, 1}]}, {9,
   DynamicBox[ToBoxes[
     Part[$CellContext`values$$, 9], StandardForm],
    ImageSizeCache->{7., {0., 9.}}]->
   SliderBox[Dynamic[
     Part[$CellContext`values$$, 9]], {1, 100, 1}]}, {10,
   DynamicBox[ToBoxes[
     Part[$CellContext`values$$, 10], StandardForm],
    ImageSizeCache->{14., {0., 9.}}]->
   SliderBox[Dynamic[
     Part[$CellContext`values$$, 10]], {1, 100, 1}]}}, 1],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{276, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->1183819168]
}, Open  ]],

Cell[TextData[{
 "The ",
 ButtonBox["Controlling the Currently Displayed Pane",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/Views#337936863"],
 " section contains further examples of dynamic tab labels."
}], "Text"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TabView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TabView"]], "InlineFormula"],
 "s can be nested to arbitrary depth, allowing very large amounts of content \
to be presented in compact form. Here, for example, is a copy of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ",
 StyleBox["Preferences", "DialogElementName"],
 " dialog box, which is implemented as a set of nested ",
 Cell[BoxData[
  ButtonBox["TabView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TabView"]], "InlineFormula"],
 "s. ",
 "The fact that a complex dialog box like this can be copied and pasted into \
a document without loss of functionality is an example of the power of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s symbolic dynamic interface technology."
}], "Text"],

Cell[CellGroupData[{

Cell["\<\
Note that this is a fully functional copy, so if you change anything here it \
will in fact immediately change your preference settings. \
\>", "TextEmphasisNote",
 CellID->244159640],

Cell[BoxData[
 TagBox[
  TabViewBox[{{"Interface",
   DynamicBox[ToBoxes[
     FEPrivate`FrontEndResource["PreferencesDialog", "InterfaceLabel"], 
     StandardForm],
    ImageSizeCache->{50., {0., 10.}}]->
   StyleBox[
    TagBox[GridBox[{
       {"\<\"\"\>", "\[SpanFromLeft]"},
       {
        StyleBox[
         DynamicBox[ToBoxes[
           FEPrivate`FrontEndResource[
           "PreferencesDialog", "UserInterfaceText"], StandardForm],
          ImageSizeCache->{142., {2., 10.}}],
         StripOnInput->False,
         FontWeight->"Bold"], "\[SpanFromLeft]"},
       {
        DynamicBox[ToBoxes[
          FEPrivate`FrontEndResource["PreferencesDialog", "LanguageText"], 
          StandardForm],
         ImageSizeCache->{211., {2., 10.}}], 
        PopupMenuBox[Dynamic[
          CurrentValue[$FrontEnd, Language]], {"English"->"\<\"English\"\>", 
         "Japanese"->"\<\"Japanese\"\>", 
         "ChineseSimplified"->"\<\"ChineseSimplified\"\>", 
         "ChineseTraditional"->"\<\"ChineseTraditional\"\>", 
         "French"->"\<\"French\"\>", "German"->"\<\"German\"\>", 
         "Italian"->"\<\"Italian\"\>", "Korean"->"\<\"Korean\"\>", 
         "Spanish"->"\<\"Spanish\"\>"},
         FieldSize->{{1, 30}, 1}]},
       {
        DynamicBox[FEPrivate`FrontEndResource[
         "PreferencesDialog", "OtherLangText"],
         ImageSizeCache->{317., {2., 10.}}], "\[SpanFromLeft]"},
       {
        DynamicBox[ToBoxes[
          FEPrivate`FrontEndResource["PreferencesDialog", "RulerText"], 
          StandardForm],
         ImageSizeCache->{61., {1., 10.}}], 
        PopupMenuBox[Dynamic[
          CurrentValue[$FrontEnd, RulerUnits]], {"Inches"->"\<\"Inches\"\>", 
         "DecimalInches"->"\<\"DecimalInches\"\>", "Points"->"\<\"Points\"\>",
          "Picas"->"\<\"Picas\"\>", "Centimeters"->"\<\"Centimeters\"\>", 
         "Millimeters"->"\<\"Millimeters\"\>"},
         FieldSize->{{1, 30}, 1}]},
       {
        DynamicBox[ToBoxes[
          FEPrivate`FrontEndResource["PreferencesDialog", "HistoryText"], 
          StandardForm],
         ImageSizeCache->{200., {2., 10.}}], 
        InputFieldBox[Dynamic[
          CurrentValue[$FrontEnd, "NotebooksMenuHistoryLength"]], Number,
         FieldSize->{5, 1}]},
       {
        InterpretationBox[
         RowBox[{
          CheckboxBox[Dynamic[
            CurrentValue[$FrontEnd, ShowGroupOpenCloseIcon]]], 
          "\[InvisibleSpace]", 
          TogglerBox[Dynamic[
            CurrentValue[$FrontEnd, ShowGroupOpenCloseIcon]], {True->
           DynamicBox[ToBoxes[
             FEPrivate`FrontEndResource["PreferencesDialog", "GroupIconText"],
              StandardForm],
            ImageSizeCache->{201., {2., 10.}}], False->
           DynamicBox[ToBoxes[
             FEPrivate`FrontEndResource["PreferencesDialog", "GroupIconText"],
              StandardForm],
            ImageSizeCache->{201., {2., 10.}}]}, 
           DynamicBox[ToBoxes[
             CurrentValue[$FrontEnd, ShowGroupOpenCloseIcon], StandardForm],
            ImageSizeCache->{26., {0., 10.}}]]}],
         Row[{
           Checkbox[
            Dynamic[
             CurrentValue[$FrontEnd, ShowGroupOpenCloseIcon]]], 
           Toggler[
            Dynamic[
             CurrentValue[$FrontEnd, ShowGroupOpenCloseIcon]], {
            True -> Dynamic[
               FEPrivate`FrontEndResource[
               "PreferencesDialog", "GroupIconText"]], False -> Dynamic[
               FEPrivate`FrontEndResource[
               "PreferencesDialog", "GroupIconText"]]}]}]], 
        "\[SpanFromLeft]"},
       {
        InterpretationBox[
         RowBox[{
          CheckboxBox[Dynamic[
            CurrentValue[$FrontEnd, ShowCursorTracker]]], "\[InvisibleSpace]",
           
          TogglerBox[Dynamic[
            CurrentValue[$FrontEnd, ShowCursorTracker]], {True->
           DynamicBox[ToBoxes[
             FEPrivate`FrontEndResource[
             "PreferencesDialog", "CursorTrackerText"], StandardForm],
            ImageSizeCache->{339., {2., 10.}}], False->
           DynamicBox[ToBoxes[
             FEPrivate`FrontEndResource[
             "PreferencesDialog", "CursorTrackerText"], StandardForm],
            ImageSizeCache->{339., {2., 10.}}]}, 
           DynamicBox[ToBoxes[
             CurrentValue[$FrontEnd, ShowCursorTracker], StandardForm],
            ImageSizeCache->{26., {0., 9.}}]]}],
         Row[{
           Checkbox[
            Dynamic[
             CurrentValue[$FrontEnd, ShowCursorTracker]]], 
           Toggler[
            Dynamic[
             CurrentValue[$FrontEnd, ShowCursorTracker]], {True -> Dynamic[
               FEPrivate`FrontEndResource[
               "PreferencesDialog", "CursorTrackerText"]], False -> Dynamic[
               FEPrivate`FrontEndResource[
               "PreferencesDialog", "CursorTrackerText"]]}]}]], 
        "\[SpanFromLeft]"},
       {
        InterpretationBox[
         RowBox[{
          CheckboxBox[Dynamic[
            CurrentValue[$FrontEnd, DragAndDrop]]], "\[InvisibleSpace]", 
          TogglerBox[Dynamic[
            CurrentValue[$FrontEnd, DragAndDrop]], {True->
           DynamicBox[ToBoxes[
             FEPrivate`FrontEndResource["PreferencesDialog", "DragDropText"], 
             StandardForm],
            ImageSizeCache->{193., {2., 10.}}], False->
           DynamicBox[ToBoxes[
             FEPrivate`FrontEndResource["PreferencesDialog", "DragDropText"], 
             StandardForm],
            ImageSizeCache->{193., {2., 10.}}]}, 
           DynamicBox[ToBoxes[
             CurrentValue[$FrontEnd, DragAndDrop], StandardForm],
            ImageSizeCache->{26., {0., 10.}}]]}],
         Row[{
           Checkbox[
            Dynamic[
             CurrentValue[$FrontEnd, DragAndDrop]]], 
           Toggler[
            Dynamic[
             CurrentValue[$FrontEnd, DragAndDrop]], {True -> Dynamic[
               FEPrivate`FrontEndResource[
               "PreferencesDialog", "DragDropText"]], False -> Dynamic[
               FEPrivate`FrontEndResource[
               "PreferencesDialog", "DragDropText"]]}]}]], 
        "\[SpanFromLeft]"},
       {
        InterpretationBox[
         RowBox[{
          CheckboxBox[Dynamic[
            
            CurrentValue[$FrontEnd, {
             Graphics3DBoxOptions, "RotationAutoRescaling"}]]], 
          "\[InvisibleSpace]", 
          TogglerBox[Dynamic[
            
            CurrentValue[$FrontEnd, {
             Graphics3DBoxOptions, "RotationAutoRescaling"}]], {True->
           DynamicBox[ToBoxes[
             FEPrivate`FrontEndResource[
             "PreferencesDialog", "AutoRescaleText"], StandardForm],
            ImageSizeCache->{250., {2., 10.}}], False->
           DynamicBox[ToBoxes[
             FEPrivate`FrontEndResource[
             "PreferencesDialog", "AutoRescaleText"], StandardForm],
            ImageSizeCache->{250., {2., 10.}}]}, 
           DynamicBox[ToBoxes[
             
             CurrentValue[$FrontEnd, {
              Graphics3DBoxOptions, "RotationAutoRescaling"}], StandardForm],
            ImageSizeCache->{37., {2., 10.}}]]}],
         Row[{
           Checkbox[
            Dynamic[
             
             CurrentValue[$FrontEnd, {
              Graphics3DBoxOptions, "RotationAutoRescaling"}]]], 
           Toggler[
            Dynamic[
             
             CurrentValue[$FrontEnd, {
              Graphics3DBoxOptions, "RotationAutoRescaling"}]], {
            True -> Dynamic[
               FEPrivate`FrontEndResource[
               "PreferencesDialog", "AutoRescaleText"]], False -> Dynamic[
               FEPrivate`FrontEndResource[
               "PreferencesDialog", "AutoRescaleText"]]}]}]], 
        "\[SpanFromLeft]"},
       {
        StyleBox[
         DynamicBox[ToBoxes[
           FEPrivate`FrontEndResource["PreferencesDialog", "ActionsText"], 
           StandardForm],
          ImageSizeCache->{186., {2., 10.}}],
         StripOnInput->False,
         FontWeight->"Bold"], "\[SpanFromLeft]"},
       {
        DynamicBox[ToBoxes[
          FEPrivate`FrontEndResource["PreferencesDialog", "WarningsText"], 
          StandardForm],
         ImageSizeCache->{164., {2., 10.}}], 
        PopupMenuBox[Dynamic[
          CurrentValue[$FrontEnd, {MessageOptions, "WarningAction"}]], {{}->
         DynamicBox[ToBoxes[
           FEPrivate`FrontEndResource["PreferencesDialog", "IgnoreText"], 
           StandardForm],
          ImageSizeCache->{32., {2., 8.}}], "Beep"->
         DynamicBox[ToBoxes[
           FEPrivate`FrontEndResource["PreferencesDialog", "BeepText"], 
           StandardForm],
          ImageSizeCache->{24., {2., 8.}}], "PrintToNotebook"->
         DynamicBox[ToBoxes[
           FEPrivate`FrontEndResource["PreferencesDialog", "PrintInputText"], 
           StandardForm],
          ImageSizeCache->{113., {2., 9.}}], "PrintToConsole"->
         DynamicBox[ToBoxes[
           FEPrivate`FrontEndResource[
           "PreferencesDialog", "PrintConsoleText"], StandardForm],
          ImageSizeCache->{76., {1., 9.}}], "DialogBox"->
         DynamicBox[ToBoxes[
           FEPrivate`FrontEndResource["PreferencesDialog", "PutUpDialogText"],
            StandardForm],
          ImageSizeCache->{93., {2., 9.}}], {"Beep", "PrintToNotebook"}->
         DynamicBox[ToBoxes[
           FEPrivate`FrontEndResource["PreferencesDialog", "BeepInputText"], 
           StandardForm],
          ImageSizeCache->{161., {2., 9.}}], {"Beep", "PrintToConsole"}->
         DynamicBox[ToBoxes[
           FEPrivate`FrontEndResource["PreferencesDialog", "BeepConsoleText"],
            StandardForm],
          ImageSizeCache->{124., {2., 9.}}], {"Beep", "DialogBox"}->
         DynamicBox[ToBoxes[
           FEPrivate`FrontEndResource["PreferencesDialog", "BeepDialogText"], 
           StandardForm],
          ImageSizeCache->{132., {2., 9.}}]},
         FieldSize->{{1, 30}, 1}]},
       {
        DynamicBox[ToBoxes[
          FEPrivate`FrontEndResource["PreferencesDialog", "ErrorsText"], 
          StandardForm],
         ImageSizeCache->{157., {1., 10.}}], 
        PopupMenuBox[Dynamic[
          CurrentValue[$FrontEnd, {MessageOptions, "ErrorAction"}]], {{}->
         DynamicBox[ToBoxes[
           FEPrivate`FrontEndResource["PreferencesDialog", "IgnoreText"], 
           StandardForm],
          ImageSizeCache->{32., {2., 8.}}], "Beep"->
         DynamicBox[ToBoxes[
           FEPrivate`FrontEndResource["PreferencesDialog", "BeepText"], 
           StandardForm],
          ImageSizeCache->{24., {2., 8.}}], "PrintToNotebook"->
         DynamicBox[ToBoxes[
           FEPrivate`FrontEndResource["PreferencesDialog", "PrintInputText"], 
           StandardForm],
          ImageSizeCache->{113., {2., 9.}}], "PrintToConsole"->
         DynamicBox[ToBoxes[
           FEPrivate`FrontEndResource[
           "PreferencesDialog", "PrintConsoleText"], StandardForm],
          ImageSizeCache->{76., {1., 9.}}], "DialogBox"->
         DynamicBox[ToBoxes[
           FEPrivate`FrontEndResource["PreferencesDialog", "PutUpDialogText"],
            StandardForm],
          ImageSizeCache->{93., {2., 9.}}], {"Beep", "PrintToNotebook"}->
         DynamicBox[ToBoxes[
           FEPrivate`FrontEndResource["PreferencesDialog", "BeepInputText"], 
           StandardForm],
          ImageSizeCache->{161., {2., 9.}}], {"Beep", "PrintToConsole"}->
         DynamicBox[ToBoxes[
           FEPrivate`FrontEndResource["PreferencesDialog", "BeepConsoleText"],
            StandardForm],
          ImageSizeCache->{124., {2., 9.}}], {"Beep", "DialogBox"}->
         DynamicBox[ToBoxes[
           FEPrivate`FrontEndResource["PreferencesDialog", "BeepDialogText"], 
           StandardForm],
          ImageSizeCache->{132., {2., 9.}}]},
         FieldSize->{{1, 30}, 1}]},
       {
        DynamicBox[ToBoxes[
          FEPrivate`FrontEndResource["PreferencesDialog", "MessagesText"], 
          StandardForm],
         ImageSizeCache->{156., {2., 10.}}], 
        PopupMenuBox[Dynamic[
          
          CurrentValue[$FrontEnd, {
           MessageOptions, "ConsoleMessageAction"}]], {{}->
         DynamicBox[ToBoxes[
           FEPrivate`FrontEndResource["PreferencesDialog", "IgnoreText"], 
           StandardForm],
          ImageSizeCache->{32., {2., 8.}}], "Beep"->
         DynamicBox[ToBoxes[
           FEPrivate`FrontEndResource["PreferencesDialog", "BeepText"], 
           StandardForm],
          ImageSizeCache->{24., {2., 8.}}], "PrintToNotebook"->
         DynamicBox[ToBoxes[
           FEPrivate`FrontEndResource["PreferencesDialog", "PrintInputText"], 
           StandardForm],
          ImageSizeCache->{113., {2., 9.}}], "PrintToConsole"->
         DynamicBox[ToBoxes[
           FEPrivate`FrontEndResource[
           "PreferencesDialog", "PrintConsoleText"], StandardForm],
          ImageSizeCache->{76., {1., 9.}}], "DialogBox"->
         DynamicBox[ToBoxes[
           FEPrivate`FrontEndResource["PreferencesDialog", "PutUpDialogText"],
            StandardForm],
          ImageSizeCache->{93., {2., 9.}}], {"Beep", "PrintToNotebook"}->
         DynamicBox[ToBoxes[
           FEPrivate`FrontEndResource["PreferencesDialog", "BeepInputText"], 
           StandardForm],
          ImageSizeCache->{161., {2., 9.}}], {"Beep", "PrintToConsole"}->
         DynamicBox[ToBoxes[
           FEPrivate`FrontEndResource["PreferencesDialog", "BeepConsoleText"],
            StandardForm],
          ImageSizeCache->{124., {2., 9.}}], {"Beep", "DialogBox"}->
         DynamicBox[ToBoxes[
           FEPrivate`FrontEndResource["PreferencesDialog", "BeepDialogText"], 
           StandardForm],
          ImageSizeCache->{132., {2., 9.}}]},
         FieldSize->{{1, 30}, 1}]},
       {
        DynamicBox[ToBoxes[
          FEPrivate`FrontEndResource[
          "PreferencesDialog", "FormattingErrorsText"], StandardForm],
         ImageSizeCache->{153., {2., 10.}}], 
        PopupMenuBox[{
          Dynamic[
           
           CurrentValue[$FrontEnd, {
            AutoStyleOptions, "HighlightFormattingErrors"}]], 
          Dynamic[
           
           CurrentValue[$FrontEnd, {
            AutoStyleOptions, "FormattingErrorTooltips"}]]}, {{True, True}->
         DynamicBox[ToBoxes[
           FEPrivate`FrontEndResource[
           "PreferencesDialog", "HighlightAndTooltipText"], StandardForm],
          ImageSizeCache->{95., {2., 9.}}], {True, False}->
         DynamicBox[ToBoxes[
           FEPrivate`FrontEndResource["PreferencesDialog", "HighlightText"], 
           StandardForm],
          ImageSizeCache->{41., {2., 9.}}], {False, True}->
         DynamicBox[ToBoxes[
           FEPrivate`FrontEndResource["PreferencesDialog", "TooltipText"], 
           StandardForm],
          ImageSizeCache->{32., {2., 9.}}], {False, False}->
         DynamicBox[ToBoxes[
           FEPrivate`FrontEndResource["PreferencesDialog", "NoneText"], 
           StandardForm],
          ImageSizeCache->{25., {0., 8.}}]}]},
       {
        ButtonBox[
         DynamicBox[ToBoxes[
           FEPrivate`FrontEndResource[
           "PreferencesDialog", "ResetDefaultsText"], StandardForm],
          ImageSizeCache->{84., {1., 9.}}],
         Appearance->Automatic,
         ButtonFrame->"DialogBox",
         ButtonFunction:>
          FrontEnd`RemoveOptions[$FrontEnd, Language, RulerUnits, 
           "NotebooksMenuHistoryLength", ShowGroupOpenCloseIcon, 
           ShowCursorTracker, DragAndDrop, 
           Graphics3DBoxOptions -> {"RotationAutoRescaling"}, 
           MessageOptions -> {
            "ConsoleMessageAction", "ErrorAction", "WarningAction"}, 
           AutoStyleOptions -> {
            "HighlightFormattingErrors", "FormattingErrorTooltips"}],
         Evaluator->None,
         ImageSize->All,
         Method->"Preemptive"], "\[SpanFromLeft]"}
      },
      ColumnsEqual->False,
      GridBoxAlignment->{"Columns" -> {{Left}}},
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
      GridBoxSpacings->{
       "Columns" -> {{0.8}}, 
        "Rows" -> {0, 0, 1, 0.5, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 2}},
      RowsEqual->False],
     "Grid"],
    StripOnInput->False,
    FontFamily:>CurrentValue["PanelFontFamily"]]}, {"Evaluation",
   DynamicBox[ToBoxes[
     FEPrivate`FrontEndResource["PreferencesDialog", "EvaluationLabel"], 
     StandardForm],
    ImageSizeCache->{55., {0., 10.}}]->
   StyleBox[
    TagBox[GridBox[{
       {"\<\"\"\>", "\[SpanFromLeft]"},
       {
        StyleBox[
         DynamicBox[ToBoxes[
           FEPrivate`FrontEndResource["PreferencesDialog", "InputOutputText"],
            StandardForm],
          ImageSizeCache->{111., {2., 10.}}],
         StripOnInput->False,
         FontWeight->"Bold"], "\[SpanFromLeft]"},
       {
        DynamicBox[ToBoxes[
          FEPrivate`FrontEndResource["PreferencesDialog", "NewStylesText"], 
          StandardForm],
         ImageSizeCache->{144., {2., 10.}}], 
        InputFieldBox[Dynamic[
          CurrentValue[$FrontEnd, DefaultNewCellStyle]], String,
         FieldSize->{{10, 20}, 1}]},
       {
        DynamicBox[ToBoxes[
          FEPrivate`FrontEndResource["PreferencesDialog", "NewInputText"], 
          StandardForm],
         ImageSizeCache->{172., {2., 10.}}], 
        PopupMenuBox[Dynamic[
          CurrentValue[$FrontEnd, {CommonDefaultFormatTypes, "Input"}]], {
         StandardForm->"StandardForm", TraditionalForm->"TraditionalForm", 
         InputForm->"InputForm", "RawInputForm"->"\<\"Raw InputForm\"\>"},
         FieldSize->{{1, 30}, 1}]},
       {
        DynamicBox[ToBoxes[
          FEPrivate`FrontEndResource["PreferencesDialog", "NewOutputText"], 
          StandardForm],
         ImageSizeCache->{182., {2., 10.}}], 
        PopupMenuBox[Dynamic[
          CurrentValue[$FrontEnd, {CommonDefaultFormatTypes, "Output"}]], {
         StandardForm->"StandardForm", TraditionalForm->"TraditionalForm", 
         OutputForm->"OutputForm"},
         FieldSize->{{1, 30}, 1}]},
       {
        DynamicBox[ToBoxes[
          FEPrivate`FrontEndResource["PreferencesDialog", "MaxOutputText"], 
          StandardForm],
         ImageSizeCache->{219., {2., 10.}}], 
        InterpretationBox[
         RowBox[{
          InputFieldBox[Dynamic[
            CurrentValue[$FrontEnd, OutputSizeLimit]], Number,
           FieldSize->{12, 1}], "\[InvisibleSpace]", "\<\" Bytes\"\>"}],
         Row[{
           InputField[
            Dynamic[
             CurrentValue[$FrontEnd, OutputSizeLimit]], Number, 
            FieldSize -> {12, 1}], " Bytes"}]]},
       {
        InterpretationBox[
         RowBox[{
          CheckboxBox[Dynamic[
            
            CurrentValue[$FrontEnd, {
             "PreferencesSettings", 
              "UseTextFormattingWhenConvertingInput"}]]], "\[InvisibleSpace]",
           
          TogglerBox[Dynamic[
            
            CurrentValue[$FrontEnd, {
             "PreferencesSettings", 
              "UseTextFormattingWhenConvertingInput"}]], {True->
           DynamicBox[ToBoxes[
             FEPrivate`FrontEndResource[
             "PreferencesDialog", "OnlyTextualInputText"], StandardForm],
            ImageSizeCache->{349., {2., 10.}}], False->
           DynamicBox[ToBoxes[
             FEPrivate`FrontEndResource[
             "PreferencesDialog", "OnlyTextualInputText"], StandardForm],
            ImageSizeCache->{349., {2., 10.}}]}, 
           DynamicBox[ToBoxes[
             
             CurrentValue[$FrontEnd, {
              "PreferencesSettings", "UseTextFormattingWhenConvertingInput"}],
              StandardForm],
            ImageSizeCache->{26., {0., 9.}}]]}],
         Row[{
           Checkbox[
            Dynamic[
             
             CurrentValue[$FrontEnd, {
              "PreferencesSettings", 
               "UseTextFormattingWhenConvertingInput"}]]], 
           Toggler[
            Dynamic[
             
             CurrentValue[$FrontEnd, {
              "PreferencesSettings", 
               "UseTextFormattingWhenConvertingInput"}]], {True -> Dynamic[
               FEPrivate`FrontEndResource[
               "PreferencesDialog", "OnlyTextualInputText"]], False -> 
             Dynamic[
               FEPrivate`FrontEndResource[
               "PreferencesDialog", "OnlyTextualInputText"]]}]}]], 
        "\[SpanFromLeft]"},
       {
        InterpretationBox[
         RowBox[{
          CheckboxBox[Dynamic[
            
            CurrentValue[$FrontEnd, {
             "PreferencesSettings", 
              "UseTextFormattingWhenConvertingOutput"}]]], 
          "\[InvisibleSpace]", 
          TogglerBox[Dynamic[
            
            CurrentValue[$FrontEnd, {
             "PreferencesSettings", 
              "UseTextFormattingWhenConvertingOutput"}]], {True->
           DynamicBox[ToBoxes[
             FEPrivate`FrontEndResource[
             "PreferencesDialog", "OnlyTextualOutputText"], StandardForm],
            ImageSizeCache->{359., {2., 10.}}], False->
           DynamicBox[ToBoxes[
             FEPrivate`FrontEndResource[
             "PreferencesDialog", "OnlyTextualOutputText"], StandardForm],
            ImageSizeCache->{359., {2., 10.}}]}, 
           DynamicBox[ToBoxes[
             
             CurrentValue[$FrontEnd, {
              "PreferencesSettings", 
               "UseTextFormattingWhenConvertingOutput"}], StandardForm],
            ImageSizeCache->{26., {0., 10.}}]]}],
         Row[{
           Checkbox[
            Dynamic[
             
             CurrentValue[$FrontEnd, {
              "PreferencesSettings", 
               "UseTextFormattingWhenConvertingOutput"}]]], 
           Toggler[
            Dynamic[
      