(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24737,        920]
NotebookOptionsPosition[     18608,        719]
NotebookOutlinePosition[     21424,        792]
CellTagsIndexPosition[     21333,        786]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functional Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FunctionalOperationsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Functional Operations\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Composition" :> 
          Documentation`HelpLookup["paclet:ref/Composition"], "Heads" :> 
          Documentation`HelpLookup["paclet:ref/Heads"], "Identity" :> 
          Documentation`HelpLookup["paclet:ref/Identity"], "InverseFunction" :> 
          Documentation`HelpLookup["paclet:ref/InverseFunction"], "MapAll" :> 
          Documentation`HelpLookup["paclet:ref/MapAll"], "Operate" :> 
          Documentation`HelpLookup["paclet:ref/Operate"], "Through" :> 
          Documentation`HelpLookup["paclet:ref/Through"], "True" :> 
          Documentation`HelpLookup["paclet:ref/True"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Composition\"\>", 2->"\<\"Heads\"\>", 
       3->"\<\"Identity\"\>", 4->"\<\"InverseFunction\"\>", 
       5->"\<\"MapAll\"\>", 6->"\<\"Operate\"\>", 7->"\<\"Through\"\>", 
       8->"\<\"True\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Working with Operators", "Title",
 CellTags->{"S2.2.9", "9.1"},
 CellID->27825],

Cell[TextData[{
 "You can think of an expression like ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "[", "x", "]"}], TraditionalForm]], "InlineMath"],
 " as being formed by applying an operator ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " to the expression ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ". You can think of an expression like ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "[", 
    RowBox[{"g", "[", "x", "]"}], "]"}], TraditionalForm]], "InlineMath"],
 " as the result of ",
 StyleBox["composing",
  FontSlant->"Italic"],
 " the operators ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["g", TraditionalForm]], "InlineMath"],
 ", and applying the result to ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->22729],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Composition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Composition"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["g", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[TextData[{
     "the composition of functions ",
     Cell[BoxData[
      FormBox[
       RowBox[{"f", ",", "g", ",", "\[Ellipsis]"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["InverseFunction",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseFunction"], "[", 
     StyleBox["f", "TI"], "]"}], Cell[TextData[{
     "the inverse of a function ",
     Cell[BoxData[
      FormBox["f", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    ButtonBox["Identity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Identity"], Cell[
    "the identity function", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->1494],

Cell["Some functional operations. ", "Caption",
 CellID->24037],

Cell[TextData[{
 "This represents the composition of the functions ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["g", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["h", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->24195],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Composition", "[", 
  RowBox[{"f", ",", "g", ",", "h"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->3830],

Cell[BoxData[
 RowBox[{"Composition", "[", 
  RowBox[{"f", ",", "g", ",", "h"}], "]"}]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->16549]
}, Open  ]],

Cell["You can manipulate compositions of functions symbolically. ", \
"MathCaption",
 CellID->5300],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFunction", "[", 
  RowBox[{"Composition", "[", 
   RowBox[{"%", ",", "q"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->1701],

Cell[BoxData[
 RowBox[{"Composition", "[", 
  RowBox[{
   TagBox[
    SuperscriptBox["q", 
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}]],
    InverseFunction,
    Editable->False], ",", 
   TagBox[
    SuperscriptBox["h", 
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}]],
    InverseFunction,
    Editable->False], ",", 
   TagBox[
    SuperscriptBox["g", 
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}]],
    InverseFunction,
    Editable->False], ",", 
   TagBox[
    SuperscriptBox["f", 
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}]],
    InverseFunction,
    Editable->False]}], "]"}]], "Output",
 ImageSize->{239, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->10794]
}, Open  ]],

Cell["\<\
The composition is evaluated explicitly when you supply a specific argument. \
\
\>", "MathCaption",
 CellID->18561],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "[", "x", "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->13303],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztV8tOwzAQdOKkPMqpSBA4QLhz7S/AiY+IKqT2gEClv9VvNLZrBzPddB2T
cAAipZtde2dnp3bcPjWb5fNLs1ktmvpx3bwtV4v3+uF1rUMyE0Js9T2rhH5W
+sneW6W0vdGfuXbvnK2dnTtbgpVtlpAGxV42K/RvwZ+DXzB+9oNVTNQEL5lq
0s27IuYZZabOTpJYlBC9YNhgFW7+tCcrmmWuPwsdrOyUdtQps0vyV0XoVxBx
g1l6Xb9gGjVzZ/vypfm75St83UMK2vEy5COIb5+eRfUe+tcUymfvYn89/K5+
zXjKXvnTXRZtl4reE6cMjt9LqBH6iINrcS8/gQtqhzWiOIywY7xGfk0JQq8z
ppeQ2w4BayECpc4QLEoPwdUe+b17DNFJBzduZSJ6Fw76J4n1OdzY+sOcvqii
P4051rBXFP1WikXjtO3FCnqWHW+nWF7f/x2GGqPPdYFqcPmcmmPXxzPtX6Xh
VMIqRwyrcAX3ySsS81LrVerQf0Pq5G5Hg/gsct75wHj3lqXIPgA1jh+r\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{173, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->52060000]
}, Open  ]],

Cell[TextData[{
 "You can get the sum of two expressions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " just by typing ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "+", "y"}], TraditionalForm]], "InlineMath"],
 ". Sometimes it is also worthwhile to consider performing operations like \
addition on ",
 StyleBox["operators",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->13959],

Cell[TextData[{
 "You can think of this as containing a sum of two operators ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["g", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->4948],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"f", "+", "g"}], ")"}], "[", "x", "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->19206],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"f", "+", "g"}], ")"}], "[", "x", "]"}]], "Output",
 ImageSize->{66, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->14613]
}, Open  ]],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["Through",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Through"]], "InlineFormula"],
 ", you can convert the expression to a more explicit form. "
}], "MathCaption",
 CellID->28969],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Through", "[", 
  RowBox[{"%", ",", "Plus"}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->15639],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x", "]"}], "+", 
  RowBox[{"g", "[", "x", "]"}]}]], "Output",
 ImageSize->{73, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->19455]
}, Open  ]],

Cell[TextData[{
 "This corresponds to the mathematical operator ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "+", 
    FractionBox["\[PartialD]", 
     RowBox[{"\[PartialD]", "x"}]]}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->6561],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Identity", "+", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{"#", ",", "x"}], "]"}], "&"}], ")"}]}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->2651],

Cell[BoxData[
 RowBox[{"Identity", "+", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], "#1"}], "&"}], ")"}]}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->4410]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does not automatically apply the separate pieces of the operator to an \
expression. "
}], "MathCaption",
 CellID->32677],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "[", 
  RowBox[{"x", "^", "2"}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->16576],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"Identity", "+", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[PartialD]", "x"], "#1"}], "&"}], ")"}]}], ")"}], "[", 
  SuperscriptBox["x", "2"], "]"}]], "Output",
 ImageSize->{166, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->22539]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["Through",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Through"]], "InlineFormula"],
 " to apply the operator. "
}], "MathCaption",
 CellID->17222],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Through", "[", 
  RowBox[{"%", ",", "Plus"}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->27502],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "x"}], "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{47, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->32224]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Identity",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Identity"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "the identity function", "TableText"]},
   {
    RowBox[{
     ButtonBox["Through",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Through"], "[", 
     StyleBox["p", "TI"], "[", 
     SubscriptBox[
      StyleBox["f", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["f", "TI"], "2"], "]", "[", 
     StyleBox["x", "TI"], "]", ",", 
     StyleBox["q", "TI"], "]"}], Cell[TextData[{
     "give ",
     Cell[BoxData[
      FormBox[
       RowBox[{"p", "[", 
        RowBox[{
         RowBox[{
          SubscriptBox["f", "1"], "[", "x", "]"}], ",", 
         RowBox[{
          SubscriptBox["f", "2"], "[", "x", "]"}]}], "]"}], TraditionalForm]],
       "InlineMath"],
     " if ",
     Cell[BoxData[
      FormBox["p", TraditionalForm]], "InlineMath"],
     " is the same as ",
     Cell[BoxData[
      FormBox["q", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Operate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Operate"], "[", 
     StyleBox["p", "TI"], ",", 
     StyleBox["f", "TI"], "[", 
     StyleBox["x", "TI"], "]", "]"}], Cell[TextData[{
     "give ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"p", "[", "f", "]"}], "[", "x", "]"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Operate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Operate"], "[", 
     StyleBox["p", "TI"], ",", 
     StyleBox["f", "TI"], "[", 
     StyleBox["x", "TI"], "]", ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "apply ",
     Cell[BoxData[
      FormBox["p", TraditionalForm]], "InlineMath"],
     " at level ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " in ",
     Cell[BoxData[
      FormBox["f", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MapAll",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MapAll"], "[", 
     StyleBox["p", "TI"], ",", 
     StyleBox["expr", "TI"], ",", 
     ButtonBox["Heads",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Heads"], "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"], "]"}], Cell[TextData[{
     "apply ",
     Cell[BoxData[
      FormBox["p", TraditionalForm]], "InlineMath"],
     " to all parts of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", including heads"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->3196],

Cell["Operations for working with operators. ", "Caption",
 CellID->6849],

Cell["This has a complicated expression as a head. ", "MathCaption",
 CellID->24023],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "a"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"1", "+", "b"}], ")"}]}], ")"}], "[", "x", "]"}]}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->13912],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "a"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "b"}], ")"}]}], ")"}], "[", "x", "]"}]], "Output",
 ImageSize->{124, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->17723]
}, Open  ]],

Cell[TextData[{
 "Functions like ",
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " do not automatically go inside heads of expressions. "
}], "MathCaption",
 CellID->5714],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", "%", "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->5371],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "a"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "b"}], ")"}]}], ")"}], "[", "x", "]"}]], "Output",
 ImageSize->{124, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->16808]
}, Open  ]],

Cell[TextData[{
 "With the ",
 Cell[BoxData[
  ButtonBox["Heads",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Heads"]], "InlineFormula"],
 " option set to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["MapAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MapAll"]], "InlineFormula"],
 " goes inside heads. "
}], "MathCaption",
 CellID->1620],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapAll", "[", 
  RowBox[{"Expand", ",", "t", ",", 
   RowBox[{"Heads", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->18981],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "+", "a", "+", "b", "+", 
    RowBox[{"a", " ", "b"}]}], ")"}], "[", "x", "]"}]], "Output",
 ImageSize->{115, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->13156]
}, Open  ]],

Cell[TextData[{
 "The replacement operator ",
 Cell[BoxData["/."], "InlineFormula"],
 " does go inside heads of expressions. "
}], "MathCaption",
 CellID->23298],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "/.", 
  RowBox[{"a", "->", "1"}]}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->30149],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "b"}], ")"}]}], ")"}], "[", "x", "]"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->32145]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["Operate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Operate"]], "InlineFormula"],
 " to apply a function specifically to the head of an expression. "
}], "MathCaption",
 CellID->30497],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Operate", "[", 
  RowBox[{"p", ",", "t"}], "]"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->19466],

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "a"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "b"}], ")"}]}], "]"}], "[", "x", "]"}]], "Output",
 ImageSize->{131, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->27443]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->156543225],

Cell[TextData[ButtonBox["Functional Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/FunctionalOperationsOverview"]], "RelatedTutorials",
 CellID->222363673]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Working with Operators - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Functional Operations", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/FunctionalOperationsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ExpressionsWithHeadsThatAreNotSymbols"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/StructuralOperations"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 46, 35.7848748}", "context" -> "", 
    "keywords" -> {
     "composition", "functions", "heads", "identity", "InverseFunction", 
      "MapAll", "operate", "operators", "through"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "You can think of an expression like f[x] as being formed by applying an \
operator f to the expression x. You can think of an expression like f[g[x]] \
as the result of composing the operators f and g, and applying the result to \
x. Some functional operations. This represents the composition of the \
functions f, g and h. ", "synonyms" -> {"2.2.9"}, "title" -> 
    "Working with Operators", "type" -> "Tutorial", "uri" -> 
    "tutorial/WorkingWithOperators"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.2.9"->{
  Cell[2511, 68, 85, 2, 70, "Title",
   CellTags->{"S2.2.9", "9.1"},
   CellID->27825]},
 "9.1"->{
  Cell[2511, 68, 85, 2, 70, "Title",
   CellTags->{"S2.2.9", "9.1"},
   CellID->27825]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.2.9", 21122, 775},
 {"9.1", 21221, 779}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1886, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2511, 68, 85, 2, 70, "Title",
 CellTags->{"S2.2.9", "9.1"},
 CellID->27825],
Cell[2599, 72, 873, 30, 70, "Text",
 CellID->22729],
Cell[3475, 104, 1277, 39, 70, "DefinitionBox",
 CellID->1494],
Cell[4755, 145, 63, 1, 70, "Caption",
 CellID->24037],
Cell[4821, 148, 319, 12, 70, "MathCaption",
 CellID->24195],
Cell[CellGroupData[{
Cell[5165, 164, 136, 4, 28, "Input",
 CellID->3830],
Cell[5304, 170, 226, 7, 36, "Output",
 CellID->16549]
}, Open  ]],
Cell[5545, 180, 99, 2, 70, "MathCaption",
 CellID->5300],
Cell[CellGroupData[{
Cell[5669, 186, 169, 5, 28, "Input",
 CellID->1701],
Cell[5841, 193, 748, 31, 39, "Output",
 CellID->10794]
}, Open  ]],
Cell[6604, 227, 126, 4, 70, "MathCaption",
 CellID->18561],
Cell[CellGroupData[{
Cell[6755, 235, 94, 3, 28, "Input",
 CellID->13303],
Cell[6852, 240, 756, 16, 39, "Output",
 Evaluatable->False,
 CellID->52060000]
}, Open  ]],
Cell[7623, 259, 393, 14, 70, "Text",
 CellID->13959],
Cell[8019, 275, 257, 9, 70, "MathCaption",
 CellID->4948],
Cell[CellGroupData[{
Cell[8301, 288, 141, 5, 70, "Input",
 CellID->19206],
Cell[8445, 295, 229, 8, 36, "Output",
 CellID->14613]
}, Open  ]],
Cell[8689, 306, 240, 8, 70, "MathCaption",
 CellID->28969],
Cell[CellGroupData[{
Cell[8954, 318, 126, 4, 70, "Input",
 CellID->15639],
Cell[9083, 324, 233, 8, 36, "Output",
 CellID->19455]
}, Open  ]],
Cell[9331, 335, 258, 9, 70, "MathCaption",
 CellID->6561],
Cell[CellGroupData[{
Cell[9614, 348, 193, 7, 70, "Input",
 CellID->2651],
Cell[9810, 357, 282, 10, 36, "Output",
 CellID->4410]
}, Open  ]],
Cell[10107, 370, 189, 6, 70, "MathCaption",
 CellID->32677],
Cell[CellGroupData[{
Cell[10321, 380, 117, 4, 70, "Input",
 CellID->16576],
Cell[10441, 386, 367, 13, 39, "Output",
 CellID->22539]
}, Open  ]],
Cell[10823, 402, 212, 8, 70, "MathCaption",
 CellID->17222],
Cell[CellGroupData[{
Cell[11060, 414, 126, 4, 70, "Input",
 CellID->27502],
Cell[11189, 420, 224, 8, 36, "Output",
 CellID->32224]
}, Open  ]],
Cell[11428, 431, 3034, 102, 70, "DefinitionBox",
 CellID->3196],
Cell[14465, 535, 73, 1, 70, "Caption",
 CellID->6849],
Cell[14541, 538, 84, 1, 70, "MathCaption",
 CellID->24023],
Cell[CellGroupData[{
Cell[14650, 543, 267, 10, 70, "Input",
 CellID->13912],
Cell[14920, 555, 332, 12, 36, "Output",
 CellID->17723]
}, Open  ]],
Cell[15267, 570, 242, 8, 70, "MathCaption",
 CellID->5714],
Cell[CellGroupData[{
Cell[15534, 582, 99, 3, 70, "Input",
 CellID->5371],
Cell[15636, 587, 333, 12, 36, "Output",
 CellID->16808]
}, Open  ]],
Cell[15984, 602, 453, 18, 70, "MathCaption",
 CellID->1620],
Cell[CellGroupData[{
Cell[16462, 624, 170, 5, 70, "Input",
 CellID->18981],
Cell[16635, 631, 276, 9, 36, "Output",
 CellID->13156]
}, Open  ]],
Cell[16926, 643, 161, 5, 70, "MathCaption",
 CellID->23298],
Cell[CellGroupData[{
Cell[17112, 652, 115, 4, 70, "Input",
 CellID->30149],
Cell[17230, 658, 281, 10, 36, "Output",
 CellID->32145]
}, Open  ]],
Cell[17526, 671, 252, 8, 70, "MathCaption",
 CellID->30497],
Cell[CellGroupData[{
Cell[17803, 683, 124, 4, 70, "Input",
 CellID->19466],
Cell[17930, 689, 338, 12, 36, "Output",
 CellID->27443]
}, Open  ]],
Cell[CellGroupData[{
Cell[18305, 706, 72, 1, 70, "RelatedTutorialsSection",
 CellID->156543225],
Cell[18380, 709, 174, 4, 70, "RelatedTutorials",
 CellID->222363673]
}, Open  ]]
}, Open  ]],
Cell[18581, 717, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

