(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    301731,      10945]
NotebookOptionsPosition[    202159,       7320]
NotebookOutlinePosition[    254296,       9088]
CellTagsIndexPosition[    252645,       9023]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"CharacterRange" :> 
         Documentation`HelpLookup["paclet:ref/CharacterRange"], "Characters" :> 
         Documentation`HelpLookup["paclet:ref/Characters"], "DatePattern" :> 
         Documentation`HelpLookup["paclet:ref/DatePattern"], "DigitCharacter" :> 
         Documentation`HelpLookup["paclet:ref/DigitCharacter"], "EndOfLine" :> 
         Documentation`HelpLookup["paclet:ref/EndOfLine"], "EndOfString" :> 
         Documentation`HelpLookup["paclet:ref/EndOfString"], "Except" :> 
         Documentation`HelpLookup["paclet:ref/Except"], "LetterCharacter" :> 
         Documentation`HelpLookup["paclet:ref/LetterCharacter"], "Longest" :> 
         Documentation`HelpLookup["paclet:ref/Longest"], "NumberString" :> 
         Documentation`HelpLookup["paclet:ref/NumberString"], 
         "RegularExpression" :> 
         Documentation`HelpLookup["paclet:ref/RegularExpression"], "Shortest" :> 
         Documentation`HelpLookup["paclet:ref/Shortest"], "StartOfLine" :> 
         Documentation`HelpLookup["paclet:ref/StartOfLine"], "StartOfString" :> 
         Documentation`HelpLookup["paclet:ref/StartOfString"], "StringCases" :> 
         Documentation`HelpLookup["paclet:ref/StringCases"], "StringCount" :> 
         Documentation`HelpLookup["paclet:ref/StringCount"], 
         "StringExpression" :> 
         Documentation`HelpLookup["paclet:ref/StringExpression"], 
         "StringFreeQ" :> Documentation`HelpLookup["paclet:ref/StringFreeQ"], 
         "StringMatchQ" :> 
         Documentation`HelpLookup["paclet:ref/StringMatchQ"], 
         "StringPosition" :> 
         Documentation`HelpLookup["paclet:ref/StringPosition"], 
         "StringReplace" :> 
         Documentation`HelpLookup["paclet:ref/StringReplace"], 
         "StringReplaceList" :> 
         Documentation`HelpLookup["paclet:ref/StringReplaceList"], 
         "StringSplit" :> Documentation`HelpLookup["paclet:ref/StringSplit"], 
         "True" :> Documentation`HelpLookup["paclet:ref/True"], "Whitespace" :> 
         Documentation`HelpLookup["paclet:ref/Whitespace"], 
         "WhitespaceCharacter" :> 
         Documentation`HelpLookup["paclet:ref/WhitespaceCharacter"], 
         "WordBoundary" :> 
         Documentation`HelpLookup["paclet:ref/WordBoundary"], "WordCharacter" :> 
         Documentation`HelpLookup["paclet:ref/WordCharacter"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"CharacterRange\"\>", 
      2->"\<\"Characters\"\>", 3->"\<\"DatePattern\"\>", 
      4->"\<\"DigitCharacter\"\>", 5->"\<\"EndOfLine\"\>", 
      6->"\<\"EndOfString\"\>", 7->"\<\"Except\"\>", 
      8->"\<\"LetterCharacter\"\>", 9->"\<\"Longest\"\>", 
      10->"\<\"NumberString\"\>", 11->"\<\"RegularExpression\"\>", 
      12->"\<\"Shortest\"\>", 13->"\<\"StartOfLine\"\>", 
      14->"\<\"StartOfString\"\>", 15->"\<\"StringCases\"\>", 
      16->"\<\"StringCount\"\>", 17->"\<\"StringExpression\"\>", 
      18->"\<\"StringFreeQ\"\>", 19->"\<\"StringMatchQ\"\>", 
      20->"\<\"StringPosition\"\>", 21->"\<\"StringReplace\"\>", 
      22->"\<\"StringReplaceList\"\>", 23->"\<\"StringSplit\"\>", 
      24->"\<\"True\"\>", 25->"\<\"Whitespace\"\>", 
      26->"\<\"WhitespaceCharacter\"\>", 27->"\<\"WordBoundary\"\>", 
      28->"\<\"WordCharacter\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Introduction", "Section",
 CellTags->{"c:1", "b:0.0"},
 CellID->6475218],

Cell[TextData[{
 "The general symbolic string patterns in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allow you to perform powerful string manipulation efficiently. What \
follows discusses the details of string patterns, including usage and \
implementation notes. The emphasis is on issues not mentioned elsewhere in \
the help system."
}], "Text",
 CellTags->"b:0.0",
 CellID->879271277],

Cell[TextData[{
 "At the heart of",
 StyleBox[" Mathematica",
  FontSlant->"Italic"],
 " is a powerful language for describing patterns in general expressions. \
This language is used in function definitions, substitutions, and searches, \
with constructs like ",
 Cell[BoxData["x_"], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"a", "|", "b"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"x", ".."}]], "InlineFormula"],
 ", and so on. "
}], "Text",
 CellTags->"b:0.0",
 CellID->217261366],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatchQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"___", ",", "x_", ",", "x_", ",", "___"}], "}"}]}], 
  "]"}]], "Input",
 CellTags->"b:0.0",
 CellLabel->"In[1]:=",
 CellID->6793186],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.0",
 CellLabel->"Out[1]=",
 CellID->685045409]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatchQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"___", ",", "x_", ",", "x_", ",", "___"}], "}"}]}], 
  "]"}]], "Input",
 CellTags->"b:0.0",
 CellLabel->"In[2]:=",
 CellID->397472003],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.0",
 CellLabel->"Out[2]=",
 CellID->136501627]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "3", ",", "4", ",", "b", ",", "c", ",", "8"}], "}"}], 
   ",", "_Integer"}], "]"}]], "Input",
 CellTags->"b:0.0",
 CellLabel->"In[3]:=",
 CellID->108872960],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "4", ",", "8"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.0",
 CellLabel->"Out[3]=",
 CellID->91209889]
}, Open  ]],

Cell[TextData[{
 "A ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " string pattern uses the same constructs to describe patterns in a text \
string. You can think of a string as a sequence of characters and apply the \
principles of general ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " patterns. In addition there are several useful string-specific pattern \
constructs."
}], "Text",
 CellTags->"b:0.0",
 CellID->47601161],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<abcd\>\"", ",", 
   RowBox[{"___", "~~", 
    RowBox[{"x_", "~~", 
     RowBox[{"x_", "~~", "___"}]}]}]}], "]"}]], "Input",
 CellTags->"b:0.0",
 CellLabel->"In[4]:=",
 CellID->164239912],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.0",
 CellLabel->"Out[4]=",
 CellID->965988149]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<abccd\>\"", ",", 
   RowBox[{"___", "~~", 
    RowBox[{"x_", "~~", 
     RowBox[{"x_", "~~", "___"}]}]}]}], "]"}]], "Input",
 CellTags->"b:0.0",
 CellLabel->"In[5]:=",
 CellID->340018981],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.0",
 CellLabel->"Out[5]=",
 CellID->123154041]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a34bc8\>\"", ",", "DigitCharacter"}], "]"}]], "Input",
 CellTags->"b:0.0",
 CellLabel->"In[6]:=",
 CellID->327756114],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"3\"\>", ",", "\<\"4\"\>", ",", "\<\"8\"\>"}], "}"}]], "Output",\

 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.0",
 CellLabel->"Out[6]=",
 CellID->522047130]
}, Open  ]],

Cell["\<\
Regular expressions can be used as an alternative way to specify string \
patterns. These tend to be more compact, but less readable.\
\>", "Text",
 CellTags->"b:0.0",
 CellID->7623660],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<abcd\>\"", ",", 
   RowBox[{"RegularExpression", "[", "\"\<.*(.)\\\\1.*\>\"", "]"}]}], 
  "]"}]], "Input",
 CellTags->"b:0.0",
 CellLabel->"In[7]:=",
 CellID->257665367],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.0",
 CellLabel->"Out[7]=",
 CellID->138681442]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<abccd\>\"", ",", 
   RowBox[{"RegularExpression", "[", "\"\<.*(.)\\\\1.*\>\"", "]"}]}], 
  "]"}]], "Input",
 CellTags->"b:0.0",
 CellLabel->"In[8]:=",
 CellID->15296355],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.0",
 CellLabel->"Out[8]=",
 CellID->48670236]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a34bc8\>\"", ",", 
   RowBox[{"RegularExpression", "[", "\"\<\\\\d\>\"", "]"}]}], "]"}]], "Input",\

 CellTags->"b:0.0",
 CellLabel->"In[9]:=",
 CellID->44443359],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"3\"\>", ",", "\<\"4\"\>", ",", "\<\"8\"\>"}], "}"}]], "Output",\

 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.0",
 CellLabel->"Out[9]=",
 CellID->6967547]
}, Open  ]],

Cell["\<\
Here is a list of several functions that recognize string patterns.\
\>", "Text",
 CellTags->"b:0.0",
 CellID->131976413],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["StringMatchQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringMatchQ"], "[", "\"\<\!\(\*
StyleBox[\"s\", \"TI\"]\)\>\"", ",", 
     StyleBox["patt", "TI"], "]"}], Cell[TextData[{
     "test whether ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"s\", \"TI\"]\)\>\""], "InlineFormula"],
     " matches ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StringFreeQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringFreeQ"], "[", "\"\<\!\(\*
StyleBox[\"s\", \"TI\"]\)\>\"", ",", 
     StyleBox["patt", "TI"], "]"}], Cell[TextData[{
     "test whether ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"s\", \"TI\"]\)\>\""], "InlineFormula"],
     " is free of substrings matching ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StringCases",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringCases"], "[", "\"\<\!\(\*
StyleBox[\"s\", \"TI\"]\)\>\"", ",", 
     StyleBox["patt", "TI"], "]"}], Cell[TextData[{
     "give a list of the substrings of ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"s\", \"TI\"]\)\>\""], "InlineFormula"],
     " that match ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StringCases",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringCases"], "[", "\"\<\!\(\*
StyleBox[\"s\", \"TI\"]\)\>\"", ",", 
     StyleBox["lhs", "TI"], "->", 
     StyleBox["rhs", "TI"], "]"}], Cell[TextData[{
     "replace each case of ",
     Cell[BoxData[
      StyleBox["lhs", "TI"]], "InlineFormula"],
     " by ",
     Cell[BoxData[
      StyleBox["rhs", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StringPosition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringPosition"], "[", "\"\<\!\(\*
StyleBox[\"s\", \"TI\"]\)\>\"", ",", 
     StyleBox["patt", "TI"], "]"}], Cell[TextData[{
     "give a list of the positions of substrings that match ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StringCount",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringCount"], "[", "\"\<\!\(\*
StyleBox[\"s\", \"TI\"]\)\>\"", ",", 
     StyleBox["patt", "TI"], "]"}], Cell[TextData[{
     "count how many substrings match ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StringReplace",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringReplace"], "[", "\"\<\!\(\*
StyleBox[\"s\", \"TI\"]\)\>\"", ",", 
     StyleBox["lhs", "TI"], "->", 
     StyleBox["rhs", "TI"], "]"}], Cell[TextData[{
     "replace every substring that matches ",
     Cell[BoxData[
      StyleBox["lhs", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StringReplaceList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringReplaceList"], "[", "\"\<\!\(\*
StyleBox[\"s\", \"TI\"]\)\>\"", ",", 
     StyleBox["lhs", "TI"], "->", 
     StyleBox["rhs", "TI"], "]"}], Cell[TextData[{
     "give a list of all ways of replacing ",
     Cell[BoxData[
      StyleBox["lhs", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StringSplit",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringSplit"], "[", "\"\<\!\(\*
StyleBox[\"s\", \"TI\"]\)\>\"", ",", 
     StyleBox["patt", "TI"], "]"}], Cell[TextData[{
     "split ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     " at every substring that matches ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StringSplit",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringSplit"], "[", "\"\<\!\(\*
StyleBox[\"s\", \"TI\"]\)\>\"", ",", 
     StyleBox["lhs", "TI"], "->", 
     StyleBox["rhs", "TI"], "]"}], Cell[TextData[{
     "split at ",
     Cell[BoxData[
      StyleBox["lhs", "TI"]], "InlineFormula"],
     ", inserting ",
     Cell[BoxData[
      StyleBox["rhs", "TI"]], "InlineFormula"],
     " in its place"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, True, False, False, False, True, False, True, False, False, 
     False}, "RowsIndexed" -> {}}},
 CellID->28981],

Cell["Functions that support string patterns. ", "Caption",
 CellTags->"b:0.0",
 CellID->49176434]
}, Open  ]],

Cell[CellGroupData[{

Cell["General String Patterns", "Section",
 CellTags->{"c:2", "b:0.1"},
 CellID->316252289],

Cell[TextData[{
 "A general string pattern is formed from pattern objects similar to the \
general pattern objects in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". To join several string pattern objects, use the ",
 Cell[BoxData[
  ButtonBox["StringExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringExpression"]], "InlineFormula"],
 " operator ",
 Cell[BoxData["~~"], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.1",
 CellID->775969280],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"\"\<a\>\"", "~~", "_"}], "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[10]:=",
 CellID->14216555],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"StringExpression", "[", 
    RowBox[{"\"\<a\>\"", ",", 
     RowBox[{"Blank", "[", "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{212, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[10]//FullForm=",
 CellID->6889976]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringExpression"]], "InlineFormula"],
 " is closely related to ",
 Cell[BoxData[
  ButtonBox["StringJoin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringJoin"]], "InlineFormula"],
 ", except nonstrings are allowed and lists are not flattened. For pure \
strings, they are equivalent."
}], "Text",
 CellTags->"b:0.1",
 CellID->143628873],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\"\<aa\>\"", "~~", 
  RowBox[{"\"\<bbb\>\"", "~~", "\"\<c\>\""}]}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[11]:=",
 CellID->220445018],

Cell[BoxData["\<\"aabbbc\"\>"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[11]=",
 CellID->66432613]
}, Open  ]],

Cell[TextData[{
 "The list of objects that can appear in a string pattern closely matches the \
list for ordinary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " patterns. In terms of string patterns, a string is considered a sequence \
of characters, that is, ",
 Cell[BoxData["\"\<abc\>\""], "InlineFormula"],
 " can be thought of as something like ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["String",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/String"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"], ",", 
    StyleBox["c", "TI"]}], "]"}]], "InlineFormula"],
 ", to which the ordinary pattern constructs apply."
}], "Text",
 CellTags->"b:0.1",
 CellID->100231778],

Cell["\<\
The following objects can appear in a symbolic string pattern: \
\>", "Text",
 CellFrame->{{0, 0}, {0, 0.25}},
 CellTags->"b:0.1",
 CellID->206331185],

Cell[BoxData[GridBox[{
   {"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", Cell[
    "a literal string of characters ", "TableText"]},
   {"_", Cell["any single character ", "TableText"]},
   {"__", Cell["any substring of one or more characters ", "TableText"]},
   {"___", Cell["any substring of zero or more characters ", "TableText"]},
   {
    RowBox[{
     StyleBox[
      RowBox[{
       StyleBox["x", "TI"], "_"}]], Cell[",", "TableText"], 
     StyleBox[
      RowBox[{
       StyleBox["x", "TI"], "__"}]], Cell[",", "TableText"], 
     StyleBox[
      RowBox[{
       StyleBox["x", "TI"], "___"}]]}], Cell[TextData[{
     "substrings given the name ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], ":", 
     StyleBox["pattern", "TI"]}], Cell[TextData[{
     "pattern given the name ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["pattern", "TI"], ".."}], Cell[
    "pattern repeated one or more times ", "TableText"]},
   {
    RowBox[{
     StyleBox["pattern", "TI"], "..."}], Cell[
    "pattern repeated zero or more times ", "TableText"]},
   {
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["patt", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["patt", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell["or", "TableText"], 
      SubscriptBox[
       StyleBox["patt", "TI"], 
       StyleBox["1", "TR"]]}], "|", 
     SubscriptBox[
      StyleBox["patt", "TI"], 
      StyleBox["2", "TR"]], "|", 
     StyleBox["\[Ellipsis]", "TR"]}], Cell[TextData[{
     "a pattern matching at least one of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["patt", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["patt", "TI"], "/;", 
     StyleBox["cond", "TI"]}], Cell[TextData[{
     "a pattern for which ",
     Cell[BoxData[
      StyleBox["cond", "TI"]], "InlineFormula"],
     " evaluates to ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["pattern", "TI"], "?", 
     StyleBox["test", "TI"]}], Cell[TextData[{
     "a pattern for which ",
     Cell[BoxData[
      StyleBox["test", "TI"]], "InlineFormula"],
     " yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " for each character "
    }], "TableText"]},
   {
    ButtonBox["Whitespace",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Whitespace"], Cell[
    "a sequence of whitespace characters ", "TableText"]},
   {
    ButtonBox["NumberString",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NumberString"], Cell[
    "the characters of a number ", "TableText"]},
   {
    RowBox[{
     ButtonBox["DatePattern",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DatePattern"], "[", 
     StyleBox["spec", "TI"], "]"}], Cell[
    "the characters of a date", "TableText"]},
   {
    StyleBox["charobj", "TI"], Cell[
    "an object representing a character class (see below) ", "TableText"]},
   {
    RowBox[{
     ButtonBox["RegularExpression",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RegularExpression"], "[", "\"\<\!\(\*
StyleBox[\"regexp\", \"TI\"]\)\>\"", "]"}], Cell[
    "substring matching a regular expression ", "TableText"]},
   {
    RowBox[{
     ButtonBox["StringExpression",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringExpression"], "[", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[
    "an arbitrary string expression ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}}},
 CellID->31675],

Cell["The following represent classes of characters: ", "Text",
 CellTags->"b:0.1",
 CellID->104465889],

Cell[BoxData[GridBox[{
   {
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[TextData[{
     "any of the ",
     Cell[BoxData["\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], 
StyleBox[\"i\", \"TI\"]]\)\>\""], "InlineFormula"],
     StyleBox[" ", "TR"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Characters",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Characters"], "[", "\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], \"1\"]\)\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], \"2\"]\)\!\(\*
StyleBox[\"\[Ellipsis]\", \"TR\"]\)\>\"", "]"}], Cell[TextData[{
     "any of the ",
     Cell[BoxData["\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], 
StyleBox[\"i\", \"TI\"]]\)\>\""], "InlineFormula"],
     StyleBox[" ", "TR"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["CharacterRange",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CharacterRange"], "[", 
     RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\""}], "]"}], Cell[TextData[{
     "any character in the range ",
     Cell[BoxData["\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\""], "InlineFormula"],
     StyleBox[" to ", "TR"],
     Cell[BoxData["\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\""], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    ButtonBox["DigitCharacter",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DigitCharacter"], Cell[
    "digit 0\[Dash]9 ", "TableText"]},
   {
    ButtonBox["LetterCharacter",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/LetterCharacter"], Cell[
    "letter ", "TableText"]},
   {
    ButtonBox["WhitespaceCharacter",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WhitespaceCharacter"], Cell[
    "space, newline, tab or other whitespace character ", "TableText"]},
   {
    ButtonBox["WordCharacter",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WordCharacter"], Cell[
    "letter or digit ", "TableText"]},
   {
    RowBox[{
     ButtonBox["Except",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Except"], "[", 
     StyleBox["p", "TI"], "]"}], Cell[TextData[{
     "any character except ones matching ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"]
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "DefinitionBox",
 CellID->9253],

Cell["The following represent positions in strings: ", "Text",
 CellTags->"b:0.1",
 CellID->97881266],

Cell[BoxData[GridBox[{
   {
    ButtonBox["StartOfString",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/StartOfString"], Cell[
    "start of the whole string ", "TableText"]},
   {
    ButtonBox["EndOfString",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/EndOfString"], Cell[
    "end of the whole string ", "TableText"]},
   {
    ButtonBox["StartOfLine",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/StartOfLine"], Cell[
    "start of a line ", "TableText"]},
   {
    ButtonBox["EndOfLine",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/EndOfLine"], Cell[
    "end of a line ", "TableText"]},
   {
    ButtonBox["WordBoundary",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WordBoundary"], Cell[
    "boundary between word characters and others ", "TableText"]},
   {
    RowBox[{
     ButtonBox["Except",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Except"], "[", 
     ButtonBox["WordBoundary",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/WordBoundary"], "]"}], Cell[
    "anywhere except a word boundary ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "DefinitionBox",
 CellID->25418],

Cell["\<\
The following determine which match will be used if there are several \
possibilities: \
\>", "Text",
 CellTags->"b:0.1",
 CellID->138112839],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Shortest",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Shortest"], "[", 
     StyleBox["p", "TI"], "]"}], Cell[TextData[{
     "the shortest consistent match for ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Longest",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Longest"], "[", 
     StyleBox["p", "TI"], "]"}], Cell[TextData[{
     "the longest consistent match for ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     " (default) "
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "DefinitionBox",
 CellID->20324],

Cell["Some nontrivial issues regarding these objects follow.", "Text",
 CellFrame->{{0, 0}, {0, 0.25}},
 CellTags->"b:0.1",
 CellID->833514613],

Cell[TextData[{
 "The ",
 Cell[BoxData["_"], "InlineFormula"],
 ", ",
 Cell[BoxData["__"], "InlineFormula"],
 ", and ",
 Cell[BoxData["___"], "InlineFormula"],
 " wildcards match any characters including newlines. To match any character \
except newline (analogous to the \".\" in regular expressions), use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Except",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Except"], "[", "\"\<\\n\>\"", "]"}]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Except",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Except"], "[", "\"\<\\n\>\"", "]"}], ".."}]], 
  "InlineFormula"],
 ", and ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Except",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Except"], "[", "\"\<\\n\>\"", "]"}], "..."}]], 
  "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.1",
 CellID->110717692],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<line1\\nline2\\n\>\"", ",", "__"}], "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[12]:=",
 CellID->32115820],

Cell[BoxData[
 RowBox[{"{", "\<\"line1\\nline2\\n\"\>", "}"}]], "Output",
 ImageSize->{46, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[12]=",
 CellID->191828861]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<line1\\nline2\\n\>\"", ",", 
   RowBox[{
    RowBox[{"Except", "[", "\"\<\\n\>\"", "]"}], ".."}]}], "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[13]:=",
 CellID->280132484],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"line1\"\>", ",", "\<\"line2\"\>"}], "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[13]=",
 CellID->212135941]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<line1\\nline2\\n\>\"", ",", 
   RowBox[{"RegularExpression", "[", "\"\<.+\>\"", "]"}]}], "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[14]:=",
 CellID->406476748],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"line1\"\>", ",", "\<\"line2\"\>"}], "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[14]=",
 CellID->20298962]
}, Open  ]],

Cell[TextData[{
 "A list of patterns, such as ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"\"\<a\>\"", ",", "\"\<b\>\"", ",", "\"\<c\>\""}], "}"}]], 
  "InlineFormula"],
 ", is equivalent to a list of alternatives, such as ",
 Cell[BoxData[
  RowBox[{"\"\<a\>\"", "|", "\"\<b\>\"", "|", "\"\<c\>\""}]], 
  "InlineFormula"],
 ". This is convenient in that functions like ",
 Cell[BoxData[
  ButtonBox["Characters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Characters"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["CharacterRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CharacterRange"]], "InlineFormula"],
 " can be used to specify classes of characters."
}], "Text",
 CellTags->"b:0.1",
 CellID->694363556],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<the cat in the hat\>\"", ",", 
   RowBox[{
    RowBox[{"x", ":", 
     RowBox[{"Characters", "[", "\"\<aeiou\>\"", "]"}]}], "\[RuleDelayed]", 
    RowBox[{"x", "<>", "x"}]}]}], "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[15]:=",
 CellID->140507535],

Cell[BoxData["\<\"thee caat iin thee haat\"\>"], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[15]=",
 CellID->13100792]
}, Open  ]],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  ButtonBox["Condition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Condition"]], "InlineFormula"],
 " (",
 Cell[BoxData["/;"], "InlineFormula"],
 ") is used, the patterns involved are treated as strings as far as the rest \
of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is concerned, so you need to use ",
 Cell[BoxData[
  ButtonBox["ToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToExpression"]], "InlineFormula"],
 " in some cases."
}], "Text",
 CellTags->"b:0.1",
 CellID->48865639],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a13 a18 a41 a42\>\"", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"\"\<a\>\"", "~~", 
      RowBox[{
       RowBox[{"x", ":", 
        RowBox[{"DigitCharacter", ".."}]}], "~~", "WordBoundary"}]}], "/;", 
     RowBox[{"PrimeQ", "[", 
      RowBox[{"ToExpression", "[", "x", "]"}], "]"}]}], "\[Rule]", "x"}]}], 
  "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[16]:=",
 CellID->134667756],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"13\"\>", ",", "\<\"41\"\>"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[16]=",
 CellID->27162036]
}, Open  ]],

Cell[TextData[{
 "Similar to ordinary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " patterns, the function in ",
 Cell[BoxData[
  ButtonBox["PatternTest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PatternTest"]], "InlineFormula"],
 " (",
 Cell[BoxData["?"], "InlineFormula"],
 ") is applied to each individual character."
}], "Text",
 CellTags->"b:0.1",
 CellID->408165015],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<125378132\>\"", ",", 
   RowBox[{"__", "?", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"ToExpression", "[", "#", "]"}], "<", "5"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[17]:=",
 CellID->149685880],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"12\"\>", ",", "\<\"3\"\>", ",", "\<\"132\"\>"}], 
  "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[17]=",
 CellID->707533094]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Whitespace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Whitespace"]], "InlineFormula"],
 " construct is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WhitespaceCharacter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WhitespaceCharacter"], ".."}]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.1",
 CellID->212294979],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<13   \\t 17 \\n22   19\>\"", ",", 
   RowBox[{"Whitespace", "\[Rule]", "\"\<,\>\""}]}], "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[18]:=",
 CellID->318389946],

Cell[BoxData["\<\"13,17,22,19\"\>"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[18]=",
 CellID->168972183]
}, Open  ]],

Cell[TextData[{
 "You can insert a ",
 Cell[BoxData[
  ButtonBox["RegularExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegularExpression"]], "InlineFormula"],
 " object into a general string pattern."
}], "Text",
 CellTags->"b:0.1",
 CellID->384134564],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a13b12c17a32\>\"", ",", 
   RowBox[{
    RowBox[{"\"\<a\>\"", "~~", 
     RowBox[{"x", ":", 
      RowBox[{"RegularExpression", "[", "\"\<\\\\d+\>\"", "]"}]}]}], 
    "\[Rule]", "x"}]}], "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[19]:=",
 CellID->23848909],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"13\"\>", ",", "\<\"32\"\>"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[19]=",
 CellID->148025619]
}, Open  ]],

Cell[TextData[{
 "This inserts a lookbehind constraint (see ",
 ButtonBox["Regular Expressions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/WorkingWithStringPatterns#274403895"],
 ") to ensure that you only pick words preceded by ",
 Cell[BoxData["\"\<the \>\""], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.1",
 CellID->603056891],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<the cat in the hat\>\"", ",", 
   RowBox[{
    RowBox[{"RegularExpression", "[", "\"\<(?<=the )\>\"", "]"}], "~~", 
    RowBox[{"WordCharacter", ".."}]}]}], "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[20]:=",
 CellID->291672169],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"cat\"\>", ",", "\<\"hat\"\>"}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[20]=",
 CellID->111286320]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringExpression"]], "InlineFormula"],
 " objects can be nested."
}], "Text",
 CellTags->"b:0.1",
 CellID->344292962],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<ba3a1a78a2b7ba9\>\"", ",", 
   RowBox[{"\"\<b\>\"", "~~", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\"\<a\>\"", "~~", "DigitCharacter"}], ")"}], ".."}]}]}], 
  "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[21]:=",
 CellID->57194593],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"ba3a1a7\"\>", ",", "\<\"ba9\"\>"}], "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[21]=",
 CellID->384825101]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Except",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Except"]], "InlineFormula"],
 " construct for string patterns takes a single argument that should \
represent a single character or a class of single characters."
}], "Text",
 CellTags->"b:0.1",
 CellID->2661260],

Cell["This deletes all nonvowel characters from the string.", "Text",
 CellTags->"b:0.1",
 CellID->704437595],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<the cat in the hat\>\"", ",", 
   RowBox[{
    RowBox[{"Except", "[", 
     RowBox[{"Characters", "[", "\"\<aeiou\>\"", "]"}], "]"}], "\[Rule]", 
    "\"\<\>\""}]}], "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[22]:=",
 CellID->190390204],

Cell[BoxData["\<\"eaiea\"\>"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[22]=",
 CellID->51576904]
}, Open  ]],

Cell[TextData[{
 "When trying to match patterns of variable length (such as ",
 Cell[BoxData["__"], "InlineFormula"],
 StyleBox[" ", "MR"],
 "and ",
 Cell[BoxData[
  RowBox[{"patt", ".."}]], "InlineFormula"],
 "), the longest possible match is tried first by default. To force the \
matcher to try the shortest match first, you can wrap the relevant part of \
the pattern in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Shortest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Shortest"], "[", " ", "]"}]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.1",
 CellID->422987297],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<(ab) (cde)\>\"", ",", 
   RowBox[{"\"\<(\>\"", "~~", 
    RowBox[{"__", "~~", "\"\<)\>\""}]}]}], "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[23]:=",
 CellID->262589375],

Cell[BoxData[
 RowBox[{"{", "\<\"(ab) (cde)\"\>", "}"}]], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[23]=",
 CellID->43459422]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<(ab) (cde)\>\"", ",", 
   RowBox[{"Shortest", "[", 
    RowBox[{"\"\<(\>\"", "~~", "__", "~~", "\"\<)\>\""}], "]"}]}], 
  "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[24]:=",
 CellID->87767072],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"(ab)\"\>", ",", "\<\"(cde)\"\>"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[24]=",
 CellID->431541845]
}, Open  ]],

Cell[TextData[{
 "If for some reason you need a longest match within the short match, you can \
use ",
 Cell[BoxData[
  ButtonBox["Longest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Longest"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.1",
 CellID->30079273],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<(ab132cd)137(ef576gh)\>\"", ",", 
   RowBox[{
    RowBox[{"Shortest", "[", 
     RowBox[{"\"\<(\>\"", "~~", "___", "~~", 
      RowBox[{"x", ":", 
       RowBox[{"DigitCharacter", ".."}]}], "~~", "___", "~~", "\"\<)\>\""}], 
     "]"}], "\[RuleDelayed]", "x"}]}], "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[25]:=",
 CellID->336262030],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"1\"\>", ",", "\<\"5\"\>"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[25]=",
 CellID->238292539]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<(ab132cd)(ef576gh)\>\"", ",", 
   RowBox[{
    RowBox[{"Shortest", "[", 
     RowBox[{"\"\<(\>\"", "~~", "___", "~~", 
      RowBox[{"Longest", "[", 
       RowBox[{"x", ":", 
        RowBox[{"DigitCharacter", ".."}]}], "]"}], "~~", "___", "~~", 
      "\"\<)\>\""}], "]"}], "\[RuleDelayed]", "x"}]}], "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[26]:=",
 CellID->46781425],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"132\"\>", ",", "\<\"576\"\>"}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[26]=",
 CellID->46684404]
}, Open  ]],

Cell[TextData[{
 "You could alternatively rewrite this pattern without use of ",
 Cell[BoxData[
  ButtonBox["Longest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Longest"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.1",
 CellID->165376289],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<(ab132cd)(ef576gh)\>\"", ",", 
   RowBox[{
    RowBox[{"\"\<(\>\"", "~~", 
     RowBox[{"Shortest", "[", "___", "]"}], "~~", 
     RowBox[{"x", ":", 
      RowBox[{"DigitCharacter", ".."}]}], "~~", 
     RowBox[{"Shortest", "[", "___", "]"}], "~~", "\"\<)\>\""}], 
    "\[RuleDelayed]", "x"}]}], "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[27]:=",
 CellID->33998707],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"132\"\>", ",", "\<\"576\"\>"}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[27]=",
 CellID->428424676]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Regular Expressions", "Section",
 CellTags->{"Regular Expressions", "c:3", "b:0.2"},
 CellID->274403895],

Cell[TextData[{
 "The regular expression syntax follows the underlying Perl Compatible \
Regular Expressions (PCRE) library, which is close to the syntax of Perl.",
 " ",
 "(See ",
 ButtonBox["[1]",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/WorkingWithStringPatterns#872737084"],
 " for further information and documentation.) A regular expression in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is denoted by the head ",
 Cell[BoxData[
  ButtonBox["RegularExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegularExpression"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.2",
 CellID->179324024],

Cell["\<\
The following basic elements can be used in regular expression strings: \
\>", "Text",
 CellFrame->{{0, 0}, {0, 0.25}},
 CellTags->"b:0.2",
 CellID->311647046],

Cell[BoxData[GridBox[{
   {"\<\"\\!\\(\\* StyleBox[\"c\", \"TI\"]\\)\"\>", Cell[TextData[{
     "the literal character ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {"\<\".\"\>", Cell["any character except newline ", "TableText"]},
   {"\<\"[\\!\\(\\* SubscriptBox[ StyleBox[\"c\", \"TI\"], \"1\"]\\)\\!\\(\\* \
SubscriptBox[ StyleBox[\"c\", \"TI\"], \"2\"]\\)\\!\\(\\* StyleBox[\"\
\[Ellipsis]\", \"TR\"]\\)]\"\>", Cell[TextData[{
     "any of the characters ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {"\<\"[\\!\\(\\* SubscriptBox[ StyleBox[\"c\", \"TI\"], \
\"1\"]\\)-\\!\\(\\* SubscriptBox[ StyleBox[\"c\", \"TI\"], \"2\"]\\)]\"\>", 
    Cell[TextData[{
     "any character in the range ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     "\[Dash]",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     " "
    }], "TableText"]},
   {"\<\"[^\\!\\(\\* SubscriptBox[ StyleBox[\"c\", \"TI\"], \
\"1\"]\\)\\!\\(\\* SubscriptBox[ StyleBox[\"c\", \"TI\"], \"2\"]\\)\\!\\(\\* \
StyleBox[\"\[Ellipsis]\", \"TR\"]\\)]\"\>", Cell[TextData[{
     "any character except the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {"\<\"\\!\\(\\* StyleBox[\\\"p\\\", \\\"TI\\\"]\\)*\"\>", Cell[TextData[{
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     " repeated zero or more times "
    }], "TableText"]},
   {"\<\"\\!\\(\\* StyleBox[\\\"p\\\", \\\"TI\\\"]\\)+\"\>", Cell[TextData[{
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     " repeated one or more times "
    }], "TableText"]},
   {"\<\"\\!\\(\\* StyleBox[\\\"p\\\", \\\"TI\\\"]\\)?\"\>", Cell[TextData[{
     "zero or one occurrence of ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {"\<\"\\!\\(\\* StyleBox[\\\"p\\\", \\\"TI\\\"]\\){\\!\\(\\* \
StyleBox[\\\"m\\\", \\\"TI\\\"]\\),\\!\\(\\* StyleBox[\\\"n\\\", \
\\\"TI\\\"]\\)}\"\>", Cell[TextData[{
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     " repeated between ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " times "
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["p", "TI"], "*", 
     RowBox[{"?", 
      RowBox[{
       RowBox[{Cell[",", "TableText"], 
        StyleBox["p", "TI"]}], "+", 
       RowBox[{"?", 
        RowBox[{Cell[",", "TableText"], 
         StyleBox["p", "TI"], "??"}]}]}]}]}], Cell[
    "the shortest consistent strings that match ", "TableText"]},
   {
    RowBox[{
     StyleBox["p", "TI"], "*", 
     RowBox[{"+", Cell[",", "TableText"]}], 
     RowBox[{
      StyleBox["p", "TI"], "++"}], Cell[",", "TableText"], 
     RowBox[{
      StyleBox["p", "TI"], "?", "+"}]}], Cell[
    "possessive match", "TableText"]},
   {"\<\"(\\!\\(\\* SubscriptBox[ StyleBox[\"p\", \"TI\"], \"1\"]\\)\\!\\(\\* \
SubscriptBox[ StyleBox[\"p\", \"TI\"], \"2\"]\\)\\!\\(\\* StyleBox[\"\
\[Ellipsis]\", \"TR\"]\\))\"\>", Cell[TextData[{
     "strings matching the sequence ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"]
    }], "TableText"]},
   {"\<\"\!\(\*
SubscriptBox[
StyleBox[\\\"p\\\",
\\\"TI\\\"], \\\"1\\\"]\)|\!\(\*
SubscriptBox[
StyleBox[\\\"p\\\",
\\\"TI\\\"], \\\"2\\\"]\)\"\>", Cell[TextData[{
     "strings matching ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     " "
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "DefinitionBox",
 ShowStringCharacters->False,
 CellID->30983],

Cell["The following represent classes of characters: ", "Text",
 CellTags->"b:0.2",
 CellID->326926809],

Cell[BoxData[GridBox[{
   {"\<\"\\\\\\\\d\"\>", Cell["digit 0\[Dash]9 ", "TableText"]},
   {"\<\"\\\\\\\\D\"\>", Cell["non\[Hyphen]digit ", "TableText"]},
   {"\<\"\\\\\\\\s\"\>", Cell[
    "space, newline, tab or other whitespace character ", "TableText"]},
   {"\<\"\\\\\\\\S\"\>", Cell[
    "non\[Hyphen]whitespace character ", "TableText"]},
   {"\<\"\\\\\\\\w\"\>", Cell[TextData[{
     "word character (letter, digit or ",
     Cell[BoxData["_"], "InlineFormula"],
     ") "
    }], "TableText"]},
   {"\<\"\\\\\\\\W\"\>", Cell["non\[Hyphen]word character ", "TableText"]},
   {"\<\"[[:\\!\\(\\* StyleBox[\\\"class\\\", \\\"TI\\\"]\\):]]\"\>", Cell[
    "characters in a named class ", "TableText"]},
   {"\<\"[^[:\!\(\*
StyleBox[\\\"class\\\",
\\\"TI\\\"]\):]]\"\>", Cell["characters not in a named class ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "DefinitionBox",
 ShowStringCharacters->False,
 CellID->3341],

Cell[TextData[{
 "The following named classes can be used: ",
 StyleBox["alnum", "MR"],
 ", ",
 StyleBox["alpha", "MR"],
 ", ",
 StyleBox["ascii", "MR"],
 ", ",
 StyleBox["blank", "MR"],
 ", ",
 StyleBox["cntrl", "MR"],
 ", ",
 StyleBox["digit", "MR"],
 ", ",
 StyleBox["graph", "MR"],
 ", ",
 StyleBox["lower", "MR"],
 ", ",
 StyleBox["print", "MR"],
 ", ",
 StyleBox["punct", "MR"],
 ", ",
 StyleBox["space", "MR"],
 ", ",
 StyleBox["upper", "MR"],
 ", ",
 StyleBox["word", "MR"],
 ", and ",
 StyleBox["xdigit", "MR"],
 ". "
}], "Text",
 CellTags->"b:0.2",
 CellID->423328124],

Cell["The following represent positions in strings: ", "Text",
 CellTags->"b:0.2",
 CellID->53679581],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["^", "MR"],
     " "
    }]], Cell["the beginning of the string (or line) ", "TableText"]},
   {Cell[TextData[{
     StyleBox["$", "MR"],
     " "
    }]], Cell["the end of the string (or line) ", "TableText"]},
   {
    RowBox[{Cell[TextData[{
      "\[Backslash]\[Backslash]",
      StyleBox["A", "MR"],
      " "
     }]], Cell[TextData[StyleBox["", "MR"]]]}], Cell[
    "the beginning of the string ", "TableText"]},
   {Cell["\[Backslash]\[Backslash]z"], Cell[
    "the end of the string ", "TableText"]},
   {Cell[TextData[{
     "\[Backslash]\[Backslash]",
     StyleBox["Z", "MR"],
     " "
    }]], Cell["\<\
the end of the string (allowing for a single newline character first) \
\>", "TableText"]},
   {Cell[TextData[{
     "\[Backslash]\[Backslash]",
     StyleBox["b", "MR"],
     " "
    }]], Cell["word boundary ", "TableText"]},
   {Cell[TextData[{
     "\[Backslash]\[Backslash]",
     StyleBox["B", "MR"],
     " "
    }]], Cell["anywhere except a word boundary ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "DefinitionBox",
 CellTags->"b:0.2",
 CellID->438051314],

Cell["\<\
The following set options for all regular expression elements that follow \
them: \
\>", "Text",
 CellTags->"b:0.2",
 CellID->446511798],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["(?i)", "MR"],
      " "
     }]], Cell[
     "treat upper and lower case as equivalent (ignore case) ", 
      "TableText"]},
    {Cell[TextData[{
      StyleBox["(?m)", "MR"],
      " "
     }]], Cell[TextData[{
      "make ",
      Cell[BoxData["^"], "InlineFormula"],
      " and ",
      Cell[BoxData["$"], "InlineFormula"],
      " match start and end of lines (multiline mode) "
     }], "TableText"]},
    {Cell[TextData[{
      StyleBox["(?s)", "MR"],
      " "
     }]], Cell[TextData[{
      "allow ",
      Cell[BoxData["."], "InlineFormula"],
      " to match newline "
     }], "TableText"]},
    {Cell[TextData[{
      StyleBox["(?x)", "MR"],
      " "
     }]], Cell[TextData[{
      "disregard all whitespace and treat everything between ",
      Cell[BoxData["\"\<#\>\""], "InlineFormula"],
      " and ",
      Cell[BoxData["\"\<\\n\>\""], "InlineFormula"],
      " as comments "
     }], "TableText"]},
    {Cell[TextData[{
      StyleBox["(?-\[Backslash]#c)", "MR"],
      " "
     }]], Cell["unset options ", "TableText"]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}], TraditionalForm]], "DefinitionBox",
 CellTags->"b:0.2",
 CellID->103937476],

Cell["The following are lookahead/lookbehind constructs:", "Text",
 CellTags->"b:0.2",
 CellID->725709264],

Cell[BoxData[GridBox[{
   {
    RowBox[{"(", 
     RowBox[{"?", 
      RowBox[{
       RowBox[{"=", 
        StyleBox["p", "TI",
         FontSlant->"Italic"]}], ")"}]}]}], Cell[TextData[{
     "the following text must match ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"(", 
     RowBox[{"?", 
      RowBox[{
       RowBox[{"!", 
        StyleBox["p", "TI",
         FontSlant->"Italic"]}], ")"}]}]}], Cell[TextData[{
     "the following text cannot match ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"(", 
     RowBox[{"?", 
      RowBox[{
       RowBox[{"\[LessEqual]", 
        StyleBox["p", "TI",
         FontSlant->"Italic"]}], ")"}]}]}], Cell[TextData[{
     "the preceding text must match ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"(", 
     RowBox[{"?", 
      RowBox[{
       RowBox[{"<", 
        RowBox[{"!", 
         StyleBox["p", "TI",
          FontSlant->"Italic"]}]}], ")"}]}]}], Cell[TextData[{
     "the preceding text cannot match ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"]
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
    "RowsIndexed" -> {}}]], "DefinitionBox",
 CellTags->"b:0.2",
 CellID->324529988],

Cell["\<\
Discussion of a few issues regarding regular expressions follows.\
\>", "Text",
 CellFrame->{{0, 0}, {0, 0.25}},
 CellTags->"b:0.2",
 CellID->36188322],

Cell["\<\
This looks for runs of word characters of length between 2 and 4.\
\>", "Text",
 CellTags->"b:0.2",
 CellID->17419283],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a bb ccc dddd eeeee\>\"", ",", 
   RowBox[{"RegularExpression", "[", "\"\<\\\\b\\\\w{2,4}\\\\b\>\"", "]"}]}], 
  "]"}]], "Input",
 CellTags->"b:0.2",
 CellLabel->"In[28]:=",
 CellID->636896070],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"bb\"\>", ",", "\<\"ccc\"\>", ",", "\<\"dddd\"\>"}], 
  "}"}]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.2",
 CellLabel->"Out[28]=",
 CellID->756235924]
}, Open  ]],

Cell[TextData[{
 "With the possessive ",
 Cell[BoxData["\"\<+\>\""], "InlineFormula"],
 " quantifier, as many characters as possible are grabbed by the matcher, and \
no characters are given up, even if the rest of the patterns requires it."
}], "Text",
 CellTags->"b:0.2",
 CellID->228635176],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a2 b6\>\"", ",", 
   RowBox[{"RegularExpression", "[", "\"\<\\\\w+\\\\d\>\"", "]"}]}], 
  "]"}]], "Input",
 CellTags->"b:0.2",
 CellLabel->"In[29]:=",
 CellID->149453386],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a2\"\>", ",", "\<\"b6\"\>"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.2",
 CellLabel->"Out[29]=",
 CellID->155639932]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a2 b6\>\"", ",", 
   RowBox[{"RegularExpression", "[", "\"\<\\\\w++\\\\d\>\"", "]"}]}], 
  "]"}]], "Input",
 CellTags->"b:0.2",
 CellLabel->"In[30]:=",
 CellID->27057531],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.2",
 CellLabel->"Out[30]=",
 CellID->188119997]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a2 b6\>\"", ",", 
   RowBox[{"RegularExpression", "[", "\"\<\\\\D++\\\\d\>\"", "]"}]}], 
  "]"}]], "Input",
 CellTags->"b:0.2",
 CellLabel->"In[31]:=",
 CellID->72747825],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a2\"\>", ",", "\<\" b6\"\>"}], "}"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.2",
 CellLabel->"Out[31]=",
 CellID->72194511]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"[", 
   RowBox[{"[", 
    RowBox[{":", 
     RowBox[{"xdigit", ":"}]}], "]"}], "]"}]], "InlineFormula"],
 " corresponds to characters in a hexadecimal number."
}], "Text",
 CellTags->"b:0.2",
 CellID->574029527],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<ff, 13, 1a3, xyz, 3b\>\"", ",", 
   RowBox[{"RegularExpression", "[", "\"\<[[:xdigit:]]+\>\"", "]"}]}], 
  "]"}]], "Input",
 CellTags->"b:0.2",
 CellLabel->"In[32]:=",
 CellID->972490785],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"ff\"\>", ",", "\<\"13\"\>", ",", "\<\"1a3\"\>", 
   ",", "\<\"3b\"\>"}], "}"}]], "Output",
 ImageSize->{115, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.2",
 CellLabel->"Out[32]=",
 CellID->459953736]
}, Open  ]],

Cell[TextData[{
 "The complete list of characters that need to be escaped in a regular \
expression consists of ",
 Cell[BoxData["."], "InlineFormula"],
 ", ",
 Cell[BoxData["\\"], "InlineFormula"],
 ", ",
 Cell[BoxData["?"], "InlineFormula"],
 ", ",
 Cell[BoxData["("], "InlineFormula"],
 ", ",
 Cell[BoxData[")"], "InlineFormula"],
 ", ",
 Cell[BoxData["{"], "InlineFormula"],
 ", ",
 Cell[BoxData["}"], "InlineFormula"],
 ", ",
 Cell[BoxData["["], "InlineFormula"],
 ", ",
 Cell[BoxData["]"], "InlineFormula"],
 ", ",
 Cell[BoxData["^"], "InlineFormula"],
 ", ",
 Cell[BoxData["$"], "InlineFormula"],
 ", ",
 Cell[BoxData["*"], "InlineFormula"],
 ", ",
 Cell[BoxData["+"], "InlineFormula"],
 ", and ",
 Cell[BoxData["|"], "InlineFormula"],
 ". For instance, to write a literal period, use ",
 Cell[BoxData["\"\<\\\\.\>\""], "InlineFormula"],
 " and to write a literal backslash, use ",
 Cell[BoxData["\"\<\\\\\\\\\>\""], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.2",
 CellID->645192577],

Cell[TextData[{
 "Inside a character class ",
 Cell[BoxData["\"\<[...]\>\""], "InlineFormula"],
 ", the complete list of escaped characters is ",
 Cell[BoxData["^"], "InlineFormula"],
 ", ",
 Cell[BoxData["-"], "InlineFormula"],
 ", ",
 Cell[BoxData["\\"], "InlineFormula"],
 ", ",
 Cell[BoxData["["], "InlineFormula"],
 ", and ",
 Cell[BoxData["]"], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.2",
 CellID->38350545],

Cell[TextData[{
 "By default, ",
 Cell[BoxData["^"], "InlineFormula"],
 " and ",
 Cell[BoxData["$"], "InlineFormula"],
 " match the beginning and end of the string, respectively. In multiline \
mode, these match the beginning/end of lines instead."
}], "Text",
 CellTags->"b:0.2",
 CellID->87518571],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<line1\\nline2\>\"", ",", 
   RowBox[{"RegularExpression", "[", "\"\<^.*\>\"", "]"}]}], "]"}]], "Input",
 CellTags->"b:0.2",
 CellLabel->"In[33]:=",
 CellID->310325877],

Cell[BoxData[
 RowBox[{"{", "\<\"line1\"\>", "}"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.2",
 CellLabel->"Out[33]=",
 CellID->510580570]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<line1\\nline2\>\"", ",", 
   RowBox[{"RegularExpression", "[", "\"\<(?m)^.*\>\"", "]"}]}], 
  "]"}]], "Input",
 CellTags->"b:0.2",
 CellLabel->"In[34]:=",
 CellID->47695904],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"line1\"\>", ",", "\<\"line2\"\>"}], "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.2",
 CellLabel->"Out[34]=",
 CellID->82458948]
}, Open  ]],

Cell[TextData[{
 "In multiline mode, ",
 Cell[BoxData[
  RowBox[{"\\\\", "A"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"\\\\", "Z"}]], "InlineFormula"],
 " can be used to denote the beginning and end of the string."
}], "Text",
 CellTags->"b:0.2",
 CellID->428461048],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<line1\\nline2\>\"", ",", 
   RowBox[{"RegularExpression", "[", "\"\<(?m)\\\\A.*\>\"", "]"}]}], 
  "]"}]], "Input",
 CellTags->"b:0.2",
 CellLabel->"In[35]:=",
 CellID->1001621228],

Cell[BoxData[
 RowBox[{"{", "\<\"line1\"\>", "}"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.2",
 CellLabel->"Out[35]=",
 CellID->521403356]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  RowBox[{"(", 
   RowBox[{"?", "x)"}]}]], "InlineFormula"],
 " modifier allows you to add whitespace and comments to a regular expression \
for readability."
}], "Text",
 CellTags->"b:0.2",
 CellID->667194970],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StringCases", "[", 
   RowBox[{"\"\<12.45  bc58.11\>\"", ",", "\[IndentingNewLine]", 
    RowBox[{
    "RegularExpression", "[", 
     "\"\<\\<(?x)\n\\\\d+  \\\\.  #remember to escape the period\n\\\\d+\\>\>\
\"", "]"}]}], "]"}], "  "}]], "Input",
 CellTags->"b:0.2",
 CellLabel->"In[36]:=",
 CellID->562254777],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"12.45\"\>", ",", "\<\"58.11\"\>"}], "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.2",
 CellLabel->"Out[36]=",
 CellID->988258]
}, Open  ]],

Cell[TextData[{
 "Named subpatterns are achieved by surrounding them with parentheses ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", "subpatt", ")"}], ";"}]], "InlineFormula"],
 " they then become numbered subpatterns. The number of a given subpattern \
counts the opening parenthesis, starting from the start of the pattern. You \
can refer to these subpatterns using ",
 Cell[BoxData[
  RowBox[{"\\\\", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " for the ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " pattern later in the pattern, or by ",
 Cell[BoxData["\"\<$n\>\""], "InlineFormula"],
 " in the right-hand side of a rule. ",
 Cell[BoxData["\"\<$0\>\""], "InlineFormula"],
 " refers to all of the matched pattern."
}], "Text",
 CellTags->"b:0.2",
 CellID->1379250],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a1b6a3b3a3c3a8b8\>\"", ",", 
   RowBox[{"RegularExpression", "[", "\"\<(a(\\\\d))b\\\\2\>\"", "]"}]}], 
  "]"}]], "Input",
 CellTags->"b:0.2",
 CellLabel->"In[37]:=",
 CellID->425844705],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a3b3\"\>", ",", "\<\"a8b8\"\>"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.2",
 CellLabel->"Out[37]=",
 CellID->463827189]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a1b6a3b3a3c3a8b8\>\"", ",", 
   RowBox[{
    RowBox[{"RegularExpression", "[", "\"\<(a(\\\\d))b\\\\2\>\"", "]"}], 
    "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<$0\>\"", ",", "\"\<$1\>\"", ",", "\"\<Number:$2\>\""}], 
     "}"}]}]}], "]"}]], "Input",
 CellTags->"b:0.2",
 CellLabel->"In[38]:=",
 CellID->25483089],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"a3b3\"\>", ",", "\<\"a3\"\>", ",", "\<\"Number:3\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"a8b8\"\>", ",", "\<\"a8\"\>", ",", "\<\"Number:8\"\>"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{298, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.2",
 CellLabel->"Out[38]=",
 CellID->120083365]
}, Open  ]],

Cell[TextData[{
 "If you need a literal ",
 Cell[BoxData["$"], "InlineFormula"],
 " in this context (when the head of the left-hand side is ",
 Cell[BoxData[
  ButtonBox["RegularExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegularExpression"]], "InlineFormula"],
 "), you can escape it by using backslashes (for example, ",
 Cell[BoxData["\"\<\\\\$2\>\""], "InlineFormula"],
 ")."
}], "Text",
 CellTags->"b:0.2",
 CellID->251858179],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a1b6a3b3a3c3a8b8\>\"", ",", 
   RowBox[{
    RowBox[{"RegularExpression", "[", "\"\<(a(\\\\d))b\\\\2\>\"", "]"}], 
    "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<$0\>\"", ",", "\"\<$1\>\"", ",", "\"\<Number:$2\>\"", ",", 
      "\"\<Literal:\\\\$2\>\""}], "}"}]}]}], "]"}]], "Input",
 CellTags->"b:0.2",
 CellLabel->"In[39]:=",
 CellID->84036725],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"a3b3\"\>", ",", "\<\"a3\"\>", ",", "\<\"Number:3\"\>", 
     ",", "\<\"Literal:$2\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"a8b8\"\>", ",", "\<\"a8\"\>", ",", "\<\"Number:8\"\>", 
     ",", "\<\"Literal:$2\"\>"}], "}"}]}], "}"}]], "Output",
 ImageSize->{461, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.2",
 CellLabel->"Out[39]=",
 CellID->56276189]
}, Open  ]],

Cell[TextData[{
 "If you happen to need a single literal backslash followed by a literal ",
 Cell[BoxData["$"], "InlineFormula"],
 " under these circumstances, you need to be a bit tricky and split into two \
strings temporarily."
}], "Text",
 CellTags->"b:0.2",
 CellID->695998127],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a1b6a3b3a3c3a8b8\>\"", ",", 
   RowBox[{
    RowBox[{"RegularExpression", "[", "\"\<(a(\\\\d))b\\\\2\>\"", "]"}], ":>",
     
    RowBox[{"{", 
     RowBox[{"\"\<$0\>\"", ",", "\"\<$1\>\"", ",", "\"\<Number:$2\>\"", ",", 
      RowBox[{"\"\<Literal:\\\\\>\"", "<>", "\"\<\\\\$2\>\""}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellTags->"b:0.2",
 CellLabel->"In[40]:=",
 CellID->28505115],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"a3b3\"\>", ",", "\<\"a3\"\>", ",", "\<\"Number:3\"\>", 
     ",", "\<\"Literal:\\\\$2\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"a8b8\"\>", ",", "\<\"a8\"\>", ",", "\<\"Number:8\"\>", 
     ",", "\<\"Literal:\\\\$2\"\>"}], "}"}]}], "}"}]], "Output",
 ImageSize->{475, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.2",
 CellLabel->"Out[40]=",
 CellID->193124569]
}, Open  ]],

Cell[TextData[{
 "If you need to group a part of the pattern, but you do not want to count \
the group as a numbered subpattern, you can use the ",
 Cell[BoxData[
  RowBox[{"(", 
   RowBox[{"?", ":patt)"}]}]], "InlineFormula"],
 " construct."
}], "Text",
 CellTags->"b:0.2",
 CellID->465786935],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a11b16c22b77\>\"", ",", 
   RowBox[{"RegularExpression", "[", "\"\<(?:a|b)(\\\\d)\\\\1\>\"", "]"}]}], 
  "]"}]], "Input",
 CellTags->"b:0.2",
 CellLabel->"In[41]:=",
 CellID->38936688],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a11\"\>", ",", "\<\"b77\"\>"}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.2",
 CellLabel->"Out[41]=",
 CellID->738895931]
}, Open  ]],

Cell["\<\
Lookahead and lookbehind patterns are used to ensure a pattern is matched \
without actually including that text as part of the match.\
\>", "Text",
 CellTags->"b:0.2",
 CellID->377461404],

Cell[TextData[{
 "This picks out words following the string ",
 Cell[BoxData["\"\<the \>\""], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.2",
 CellID->114009367],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<the cat in the hat\>\"", ",", 
   RowBox[{"RegularExpression", "[", "\"\<(?<=the )\\\\w+\>\"", "]"}]}], 
  "]"}]], "Input",
 CellTags->"b:0.2",
 CellLabel->"In[42]:=",
 CellID->635063856],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"cat\"\>", ",", "\<\"hat\"\>"}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.2",
 CellLabel->"Out[42]=",
 CellID->355466528]
}, Open  ]],

Cell["\<\
This tries to pick out all even numbers in the string, but it will find \
matches that include partial numbers.\
\>", "Text",
 CellTags->"b:0.2",
 CellID->142585462],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a23b42c63d80, 123\>\"", ",", 
   RowBox[{
    RowBox[{"x", ":", 
     RowBox[{"RegularExpression", "[", "\"\<\\\\d+\>\"", "]"}]}], "/;", 
    RowBox[{
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{"ToExpression", "[", "x", "]"}], ",", "2"}], "]"}], "\[Equal]",
      "0"}]}]}], "]"}]], "Input",
 CellTags->"b:0.2",
 CellLabel->"In[43]:=",
 CellID->4084787],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"2\"\>", ",", "\<\"42\"\>", ",", "\<\"6\"\>", ",", "\<\"80\"\>",
    ",", "\<\"12\"\>"}], "}"}]], "Output",
 ImageSize->{119, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.2",
 CellLabel->"Out[43]=",
 CellID->420878177]
}, Open  ]],

Cell["\<\
Using lookbehind/lookahead, you can ensure that the characters before/after \
the match are not digits (note that the lookbehind test is superfluous in \
this particular case).\
\>", "Text",
 CellTags->"b:0.2",
 CellID->68612708],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a23b42c63d80, 123\>\"", ",", 
   RowBox[{
    RowBox[{"x", ":", 
     RowBox[{
     "RegularExpression", "[", "\"\<(?<!\\\\d)\\\\d+(?!\\\\d)\>\"", "]"}]}], "/;",
     
    RowBox[{
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{"ToExpression", "[", "x", "]"}], ",", "2"}], "]"}], "\[Equal]",
      "0"}]}]}], "]"}]], "Input",
 CellTags->"b:0.2",
 CellLabel->"In[44]:=",
 CellID->373128525],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"42\"\>", ",", "\<\"80\"\>"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.2",
 CellLabel->"Out[44]=",
 CellID->127706517]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["RegularExpression versus StringExpression", "Section",
 CellTags->{"c:4", "b:0.3"},
 CellID->182364929],

Cell["\<\
There is a close correspondence between the various pattern objects that can \
be used in general symbolic string patterns and in regular expressions. Here \
is a list of examples of patterns written as regular expressions and as \
symbolic string patterns.\
\>", "Text",
 CellTags->"b:0.3",
 CellID->100369965],

Cell[BoxData[GridBox[{
   {Cell["Regular Expression", "TableHeader"], Cell[
    "General String Pattern", "TableHeader"], Cell[
    "Explanation", "TableHeader"]},
   {"\"\<abc\>\"", "\"\<abc\>\"", Cell[TextData[{
     "the literal string ",
     Cell[BoxData["\"\<abc\>\""], "InlineFormula"],
     StyleBox[" ", "TR"]
    }], "TableText"]},
   {"\"\<.\>\"", 
    RowBox[{
     ButtonBox["Except",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Except"], "[", "\"\<\\n\>\"", "]"}], Cell[
    TextData[{
     "any character except newline",
     StyleBox[" ", "TR"]
    }], "TableText"]},
   {"\"\<(?s).\>\"", "_", Cell["any character ", "TableText"]},
   {"\"\<(?s).+\>\"", "__", Cell[
    "one or more characters (greedy) ", "TableText"]},
   {"\"\<(?s).+?\>\"", 
    RowBox[{
     ButtonBox["Shortest",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Shortest"], "[", "__", "]"}], Cell[
    "one or more characters (non-greedy) ", "TableText"]},
   {"\"\<(?s).*\>\"", "___", Cell["zero or more characters ", "TableText"]},
   {"\"\<.*\>\"", 
    RowBox[{
     RowBox[{
      ButtonBox["Except",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Except"], "[", "\"\<\\n\>\"", "]"}], "..."}], 
    Cell["zero or more characters (except newlines)", "TableText"]},
   {"\"\<a?b\>\"", 
    RowBox[{
     RowBox[{"\"\<a\>\"", "|", "\"\<\>\""}], "~~", "\"\<b\>\""}], Cell[
    TextData[{
     "zero or one ",
     Cell[BoxData["\"\<a\>\""], "InlineFormula"],
     " followed by a ",
     Cell[BoxData["\"\<b\>\""], "InlineFormula"],
     " (that is, ",
     Cell[BoxData["\"\<b\>\""], "InlineFormula"],
     " or ",
     Cell[BoxData["\"\<ab\>\""], "InlineFormula"],
     ")"
    }], "TableText"]},
   {"\"\<[abef]\>\"", 
    RowBox[{
     ButtonBox["Characters",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Characters"], "[", "\"\<abef\>\"", "]"}], Cell[
    TextData[{
     "any of the characters ",
     Cell[BoxData["\"\<a\>\""], "InlineFormula"],
     ", ",
     Cell[BoxData["\"\<b\>\""], "InlineFormula"],
     ", ",
     Cell[BoxData["\"\<e\>\""], "InlineFormula"],
     ", or ",
     Cell[BoxData["\"\<f\>\""], "InlineFormula"],
     " "
    }], "TableText"]},
   {"\"\<[abef]+\>\"", 
    RowBox[{
     RowBox[{
      ButtonBox["Characters",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Characters"], "[", "\"\<abef\>\"", "]"}], 
     ".."}], Cell[TextData[{
     "one or more of the characters ",
     Cell[BoxData["\"\<a\>\""], "InlineFormula"],
     ", ",
     Cell[BoxData["\"\<b\>\""], "InlineFormula"],
     ", ",
     Cell[BoxData["\"\<e\>\""], "InlineFormula"],
     ", or ",
     Cell[BoxData["\"\<f\>\""], "InlineFormula"],
     " "
    }], "TableText"]},
   {"\"\<[a-f]\>\"", 
    RowBox[{
     ButtonBox["CharacterRange",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CharacterRange"], "[", 
     RowBox[{"\"\<a\>\"", ",", "\"\<f\>\""}], "]"}], Cell[TextData[{
     "any character in the range between ",
     Cell[BoxData["\"\<a\>\""], "InlineFormula"],
     " and ",
     Cell[BoxData["\"\<f\>\""], "InlineFormula"]
    }], "TableText"]},
   {"\"\<[^abef]\>\"", 
    RowBox[{
     ButtonBox["Except",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Except"], "[", 
     RowBox[{
      ButtonBox["Characters",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Characters"], "[", "\"\<abef\>\"", "]"}], 
     "]"}], Cell[TextData[{
     "any character except the characters ",
     Cell[BoxData["\"\<a\>\""], "InlineFormula"],
     ", ",
     Cell[BoxData["\"\<b\>\""], "InlineFormula"],
     ", ",
     Cell[BoxData["\"\<e\>\""], "InlineFormula"],
     ", or ",
     Cell[BoxData["\"\<f\>\""], "InlineFormula"],
     " "
    }], "TableText"]},
   {"\"\<ab|efg\>\"", 
    RowBox[{"\"\<ab\>\"", "|", "\"\<efg\>\""}], Cell[TextData[{
     "match the strings ",
     Cell[BoxData["\"\<ab\>\""], "InlineFormula"],
     " or ",
     Cell[BoxData["\"\<efg\>\""], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
    "\"\<(ab|ef)gh\>\"", Cell["or", "TableText"], "\"\<(?:ab|ef)gh\>\""}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\"\<ab\>\"", "|", "\"\<ef\>\""}], ")"}], "~~", "\"\<gh\>\""}], 
    Cell[TextData[{
     Cell[BoxData["\"\<ab\>\""], "InlineFormula"],
     " or ",
     Cell[BoxData["\"\<ef\>\""], "InlineFormula"],
     " followed by ",
     Cell[BoxData["\"\<gh\>\""], "InlineFormula"],
     " (that is, ",
     Cell[BoxData["\"\<abgh\>\""], "InlineFormula"],
     " or ",
     Cell[BoxData["\"\<efgh\>\""], "InlineFormula"],
     ")"
    }], "TableText"]},
   {"\"\<\\\\s\>\"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["WhitespaceCharacter",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/WhitespaceCharacter"]]],
     " "
    }]], Cell["any whitespace character", "TableText"]},
   {"\"\<\\\\s+\>\"", 
    ButtonBox["Whitespace",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Whitespace"], Cell[
    "one or more characters of whitespace ", "TableText"]},
   {"\"\<(a|b)\\\\1\>\"", 
    RowBox[{
     RowBox[{"x", ":", 
      RowBox[{"\"\<a\>\"", "|", "\"\<b\>\""}]}], "~~", "x_"}], Cell[
    TextData[{
     "this will match either ",
     Cell[BoxData["\"\<aa\>\""], "InlineFormula"],
     " or ",
     Cell[BoxData["\"\<bb\>\""], "InlineFormula"],
     " "
    }], "TableText"]},
   {"\"\<\\\\d\>\"", 
    ButtonBox["DigitCharacter",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DigitCharacter"], Cell[
    "any digit character", "TableText"]},
   {"\"\<\\\\D\>\"", 
    RowBox[{
     ButtonBox["Except",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Except"], "[", 
     ButtonBox["DigitCharacter",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DigitCharacter"], "]"}], Cell[
    "any nondigit character", "TableText"]},
   {"\"\<\\\\d+\>\"", 
    RowBox[{
     ButtonBox["DigitCharacter",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DigitCharacter"], ".."}], Cell[
    "one or more digit characters ", "TableText"]},
   {"\"\<\\\\w\>\"", 
    RowBox[{
     ButtonBox["WordCharacter",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/WordCharacter"], "|", "\"\<_\>\""}], Cell[
    TextData[{
     "any digit, letter, or ",
     Cell[BoxData["\"\<_\>\""], "InlineFormula"],
     " character. "
    }], "TableText"]},
   {"\"\<[[:alpha:]]\>\"", 
    ButtonBox["LetterCharacter",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/LetterCharacter"], Cell[
    "any letter character", "TableText"]},
   {"\"\<[^[:alpha:]]\>\"", 
    RowBox[{
     ButtonBox["Except",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Except"], "[", 
     ButtonBox["LetterCharacter",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LetterCharacter"], "]"}], Cell[
    "any nonletter character", "TableText"]},
   {
    RowBox[{"\"\<^abf\>\"", Cell["or", "TableText"], "\"\<\\\\Aabc\>\""}], 
    RowBox[{
     ButtonBox["StartOfString",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StartOfString"], "~~", "\"\<abf\>\""}], Cell[
    TextData[{
     "the string ",
     Cell[BoxData["\"\<abf\>\""], "InlineFormula"],
     " at the start of the string "
    }], "TableText"]},
   {"\"\<(?m)^abf\>\"", 
    RowBox[{
     ButtonBox["StartOfLine",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StartOfLine"], "~~", "\"\<abf\>\""}], Cell[
    TextData[{
     "the string ",
     Cell[BoxData["\"\<abf\>\""], "InlineFormula"],
     " at the start of a line"
    }], "TableText"]},
   {
    RowBox[{"\"\<wxz$\>\"", Cell["or", "TableText"], "\"\<wxz\\\\z\>\""}], 
    RowBox[{"\"\<wxz\>\"", "~~", 
     ButtonBox["EndOfString",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EndOfString"]}], Cell[TextData[{
     "the string ",
     Cell[BoxData["\"\<wxz\>\""], "InlineFormula"],
     " at the end of the string"
    }], "TableText"]},
   {"\"\<wxz\\\\Z\>\"", 
    RowBox[{"\"\<wxz\>\"", "~~", 
     RowBox[{"\"\<\\n\>\"", "|", "\"\<\>\""}], "~~", 
     ButtonBox["EndOfString",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EndOfString"]}], Cell[TextData[{
     "the string ",
     Cell[BoxData["\"\<wxz\>\""], "InlineFormula"],
     " at the end of the string or before newline at the end of the string "
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
    "RowsIndexed" -> {}}]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellTags->"b:0.3",
 CellID->195821352],

Cell[TextData[{
 "Pattern objects that can be used in general string patterns, but not in \
regular expressions, include conditions (",
 Cell[BoxData["/;"], "InlineFormula"],
 ") and pattern tests (",
 Cell[BoxData["?"], "InlineFormula"],
 ") that can access general ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code during the match."
}], "Text",
 CellTags->"b:0.3",
 CellID->143238647],

Cell[TextData[{
 "Some special constructs in regular expressions are not directly available \
in general string patterns. These include lookahead/lookbehinds and repeats \
of a given length. They can",
 " ",
 "be embedded into a larger general string pattern by inserting a ",
 Cell[BoxData[
  ButtonBox["RegularExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegularExpression"]], "InlineFormula"],
 " object."
}], "Text",
 CellTags->"b:0.3",
 CellID->121646424]
}, Open  ]],

Cell[CellGroupData[{

Cell["String Manipulation Functions", "Section",
 CellTags->"c:5",
 CellID->393353162],

Cell["\<\
The following discusses some particulars and subtleties in the various string \
manipulation functions (see the reference pages for more information on these \
functions).\
\>", "Text",
 CellID->447203085],

Cell[CellGroupData[{

Cell["StringMatchQ", "Subsection",
 CellTags->{"c:6", "b:0.4.0"},
 CellID->115748480],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringMatchQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringMatchQ"]], "InlineFormula"],
 " is used to check whether a whole string matches a certain pattern."
}], "Text",
 CellTags->"b:0.4.0",
 CellID->88806953],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<test\>\"", ",", 
   RowBox[{"\"\<t\>\"", "~~", 
    RowBox[{"__", "~~", "\"\<t\>\""}]}]}], "]"}]], "Input",
 CellTags->"b:0.4.0",
 CellLabel->"In[45]:=",
 CellID->631912780],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.0",
 CellLabel->"Out[45]=",
 CellID->768829449]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<tester\>\"", ",", 
   RowBox[{"\"\<t\>\"", "~~", 
    RowBox[{"__", "~~", "\"\<t\>\""}]}]}], "]"}]], "Input",
 CellTags->"b:0.4.0",
 CellLabel->"In[46]:=",
 CellID->116558020],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.0",
 CellLabel->"Out[46]=",
 CellID->42906176]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringMatchQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringMatchQ"]], "InlineFormula"],
 " is special in that it also allows the metacharacters ",
 Cell[BoxData["*"], "InlineFormula"],
 " and ",
 Cell[BoxData["@"], "InlineFormula"],
 " to be entered as wildcards (for backwards compatibility reasons). ",
 Cell[BoxData["*"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Shortest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Shortest"], "[", "___", "]"}]], "InlineFormula"],
 " (",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RegularExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RegularExpression"], "[", "\"\<(?s).*?\>\"", 
   "]"}]], "InlineFormula"],
 ") and ",
 Cell[BoxData["@"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Except",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Except"], "[", 
   RowBox[{
    ButtonBox["CharacterRange",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CharacterRange"], "[", 
    RowBox[{"\"\<A\>\"", ",", "\"\<Z\>\""}], "]"}], "]"}]], "InlineFormula"],
 " (",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RegularExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RegularExpression"], "[", "\"\<[^A-Z]\>\"", 
   "]"}]], "InlineFormula"],
 ")."
}], "Text",
 CellTags->"b:0.4.0",
 CellID->406868558],

Cell["The following three patterns are therefore equivalent.", "Text",
 CellTags->"b:0.4.0",
 CellID->90376082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<test\>\"", ",", 
   RowBox[{"_", "~~", "\"\<e*\>\""}]}], "]"}]], "Input",
 CellTags->"b:0.4.0",
 CellLabel->"In[47]:=",
 CellID->996820522],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.0",
 CellLabel->"Out[47]=",
 CellID->504872867]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<test\>\"", ",", 
   RowBox[{"_", "~~", "\"\<e\>\"", "~~", 
    RowBox[{"Shortest", "[", "___", "]"}]}]}], "]"}]], "Input",
 CellTags->"b:0.4.0",
 CellLabel->"In[48]:=",
 CellID->44778046],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.0",
 CellLabel->"Out[48]=",
 CellID->11784903]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<test\>\"", ",", 
   RowBox[{"RegularExpression", "[", "\"\<(?s).e.*?\>\"", "]"}]}], 
  "]"}]], "Input",
 CellTags->"b:0.4.0",
 CellLabel->"In[49]:=",
 CellID->22423222],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.0",
 CellLabel->"Out[49]=",
 CellID->3205742]
}, Open  ]],

Cell[TextData[{
 "Note that technically the appearance of ",
 Cell[BoxData[
  ButtonBox["Shortest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Shortest"]], "InlineFormula"],
 " does not make a difference here, since we are only looking for ",
 StyleBox["a",
  FontSlant->"Italic"],
 " possible match."
}], "Text",
 CellTags->"b:0.4.0",
 CellID->60232086],

Cell[TextData[{
 "If you need to access parts of the string matched by subpatterns in the \
pattern, use ",
 Cell[BoxData[
  ButtonBox["StringCases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringCases"]], "InlineFormula"],
 " instead."
}], "Text",
 CellTags->"b:0.4.0",
 CellID->716869318],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringMatchQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringMatchQ"]], "InlineFormula"],
 " has a ",
 Cell[BoxData[
  ButtonBox["SpellingCorrection",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SpellingCorrection"]], "InlineFormula"],
 " option for finding matches allowing for a small number of discrepancies. \
This only works for patterns consisting of a single literal string."
}], "Text",
 CellTags->"b:0.4.0",
 CellID->554439476],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<alpha\>\"", ",", "\"\<alpa\>\"", ",", 
   RowBox[{"SpellingCorrection", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellTags->"b:0.4.0",
 CellLabel->"In[50]:=",
 CellID->70925498],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.0",
 CellLabel->"Out[50]=",
 CellID->121299948]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["StringFreeQ", "Subsection",
 CellTags->{"c:7", "b:0.4.1"},
 CellID->221687989],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringFreeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringFreeQ"]], "InlineFormula"],
 " is used to check whether a string contains a substring matching the \
pattern. You cannot extract the matching substring; to do this you would use \
",
 Cell[BoxData[
  ButtonBox["StringCases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringCases"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.4.1",
 CellID->58760444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringFreeQ", "[", 
  RowBox[{"\"\<abcde\>\"", ",", 
   RowBox[{"\"\<b\>\"", "~~", 
    RowBox[{"__", "~~", "\"\<d\>\""}]}]}], "]"}]], "Input",
 CellTags->"b:0.4.1",
 CellLabel->"In[51]:=",
 CellID->208914080],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.1",
 CellLabel->"Out[51]=",
 CellID->209738466]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringFreeQ", "[", 
  RowBox[{"\"\<abcde\>\"", ",", 
   RowBox[{"RegularExpression", "[", "\"\<b.*d\>\"", "]"}]}], "]"}]], "Input",\

 CellTags->"b:0.4.1",
 CellLabel->"In[52]:=",
 CellID->113974042],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.1",
 CellLabel->"Out[52]=",
 CellID->232877383]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["StringCases", "Subsection",
 CellTags->{"c:8", "b:0.4.2"},
 CellID->3968257],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringCases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringCases"]], "InlineFormula"],
 " is a general purpose function for finding occurrences of patterns in a \
string, picking out subpatterns, and processing the results."
}], "Text",
 CellTags->"b:0.4.2",
 CellID->46676764],

Cell["Find substrings matching a pattern.", "Text",
 CellTags->"b:0.4.2",
 CellID->143958968],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a1b2a26d15a42\>\"", ",", 
   RowBox[{"\"\<a\>\"", "~~", "_"}]}], "]"}]], "Input",
 CellTags->"b:0.4.2",
 CellLabel->"In[53]:=",
 CellID->459256047],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a1\"\>", ",", "\<\"a2\"\>", ",", "\<\"a4\"\>"}], 
  "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.2",
 CellLabel->"Out[53]=",
 CellID->35656270]
}, Open  ]],

Cell["Pick apart the matching substring.", "Text",
 CellTags->"b:0.4.2",
 CellID->697884743],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a1b2a26d15a42\>\"", ",", 
   RowBox[{
    RowBox[{"\"\<a\>\"", "~~", 
     RowBox[{"x", ":", 
      RowBox[{"DigitCharacter", ".."}]}]}], "\[Rule]", "x"}]}], 
  "]"}]], "Input",
 CellTags->"b:0.4.2",
 CellLabel->"In[54]:=",
 CellID->85500109],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"1\"\>", ",", "\<\"26\"\>", ",", "\<\"42\"\>"}], 
  "}"}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.2",
 CellLabel->"Out[54]=",
 CellID->166781061]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a1b2a26d15a42\>\"", ",", 
   RowBox[{
    RowBox[{"RegularExpression", "[", "\"\<a(\\\\d+)\>\"", "]"}], "\[Rule]", 
    "\"\<$1\>\""}]}], "]"}]], "Input",
 CellTags->"b:0.4.2",
 CellLabel->"In[55]:=",
 CellID->493985103],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"1\"\>", ",", "\<\"26\"\>", ",", "\<\"42\"\>"}], 
  "}"}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.2",
 CellLabel->"Out[55]=",
 CellID->358774032]
}, Open  ]],

Cell["Restrict the number of matches.", "Text",
 CellTags->"b:0.4.2",
 CellID->121882887],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a b c d e\>\"", ",", "LetterCharacter", ",", "3"}], 
  "]"}]], "Input",
 CellTags->"b:0.4.2",
 CellLabel->"In[56]:=",
 CellID->240722779],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>"}], "}"}]], "Output",\

 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.2",
 CellLabel->"Out[56]=",
 CellID->26993590]
}, Open  ]],

Cell["You can use a list of rules.", "Text",
 CellTags->"b:0.4.2",
 CellID->608581590],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a13bF5b1Aa33\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"\"\<a\>\"", "~~", 
       RowBox[{"x", ":", 
        RowBox[{"DigitCharacter", ".."}]}]}], "\[Rule]", 
      RowBox[{"f1", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{"\"\<b\>\"", "~~", 
       RowBox[{"x", ":", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"DigitCharacter", "|", 
           RowBox[{"CharacterRange", "[", 
            RowBox[{"\"\<A\>\"", ",", "\"\<F\>\""}], "]"}]}], ")"}], 
         ".."}]}]}], "\[Rule]", 
      RowBox[{"hex", "[", "x", "]"}]}]}], "}"}]}], "]"}]], "Input",
 CellTags->"b:0.4.2",
 CellLabel->"In[57]:=",
 CellID->94888225],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f1", "[", "\<\"13\"\>", "]"}], ",", 
   RowBox[{"hex", "[", "\<\"F5\"\>", "]"}], ",", 
   RowBox[{"hex", "[", "\<\"1A\"\>", "]"}], ",", 
   RowBox[{"f1", "[", "\<\"33\"\>", "]"}]}], "}"}]], "Output",
 ImageSize->{234, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.2",
 CellLabel->"Out[57]=",
 CellID->180027018]
}, Open  ]],

Cell[TextData[{
 "You can also give a list of strings as the first argument for efficient \
processing of many strings (see ",
 ButtonBox["Tips and Tricks for Efficient Matching",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/WorkingWithStringPatterns#319138910"],
 " for a discussion)."
}], "Text",
 CellTags->"b:0.4.2",
 CellID->255423450],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "\"\<cat\>\"", ",", "\"\<in\>\"", ",", "\"\<the\>\"", ",", 
     "\"\<hat\>\""}], "}"}], ",", 
   RowBox[{"__", "~~", 
    RowBox[{"\"\<t\>\"", "~~", "EndOfString"}]}]}], "]"}]], "Input",
 CellTags->"b:0.4.2",
 CellLabel->"In[58]:=",
 CellID->1009786679],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "\<\"cat\"\>", "}"}], ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "\<\"hat\"\>", "}"}]}], "}"}]], "Output",
 ImageSize->{150, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.2",
 CellLabel->"Out[58]=",
 CellID->248658486]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", "%", "]"}]], "Input",
 CellTags->"b:0.4.2",
 CellLabel->"In[59]:=",
 CellID->51924450],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"cat\"\>", ",", "\<\"hat\"\>"}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.2",
 CellLabel->"Out[59]=",
 CellID->391207758]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Overlaps Option", "Subsection",
 CellTags->{"c:9", "b:0.4.3"},
 CellID->351610464],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Overlaps",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Overlaps"]], "InlineFormula"],
 " option for ",
 Cell[BoxData[
  ButtonBox["StringCases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringCases"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["StringPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringPosition"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["StringCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringCount"]], "InlineFormula"],
 " deals with how the matcher proceeds after finding a match. It has three \
possible settings: ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", or ",
 Cell[BoxData[
  ButtonBox["All",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/All"]], "InlineFormula"],
 ". The default is ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  ButtonBox["StringCases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringCases"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["StringCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringCount"]], "InlineFormula"],
 ", while it is ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  ButtonBox["StringPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringPosition"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.4.3",
 CellID->542672475],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Overlaps",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Overlaps"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the matcher continues the match testing at the character following the \
last matched substring."
}], "Text",
 CellTags->"b:0.4.3",
 CellID->271649068],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<(a(b)c(d)\>\"", ",", 
   RowBox[{"Shortest", "[", 
    RowBox[{"\"\<(\>\"", "~~", "__", "~~", "\"\<)\>\""}], "]"}]}], 
  "]"}]], "Input",
 CellTags->"b:0.4.3",
 CellLabel->"In[60]:=",
 CellID->323915583],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"(a(b)\"\>", ",", "\<\"(d)\"\>"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.3",
 CellLabel->"Out[60]=",
 CellID->314158530]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Overlaps",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Overlaps"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", the matcher continues at the character following the first character of \
the last matched substring (when a single pattern is involved)."
}], "Text",
 CellTags->"b:0.4.3",
 CellID->18408293],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<(a(b)c(d)\>\"", ",", 
   RowBox[{"Shortest", "[", 
    RowBox[{"\"\<(\>\"", "~~", "__", "~~", "\"\<)\>\""}], "]"}], ",", 
   RowBox[{"Overlaps", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellTags->"b:0.4.3",
 CellLabel->"In[61]:=",
 CellID->123426060],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"(a(b)\"\>", ",", "\<\"(b)\"\>", ",", "\<\"(d)\"\>"}], 
  "}"}]], "Output",
 ImageSize->{118, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.3",
 CellLabel->"Out[61]=",
 CellID->38256750]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Overlaps",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Overlaps"], "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 ", the matcher keeps starting at the same position until no more new matches \
are found."
}], "Text",
 CellTags->"b:0.4.3",
 CellID->326611308],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<(a(b)c(d)\>\"", ",", 
   RowBox[{"Shortest", "[", 
    RowBox[{"\"\<(\>\"", "~~", "__", "~~", "\"\<)\>\""}], "]"}], ",", 
   RowBox[{"Overlaps", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellTags->"b:0.4.3",
 CellLabel->"In[62]:=",
 CellID->237410754],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"(a(b)\"\>", ",", "\<\"(a(b)c(d)\"\>", ",", "\<\"(b)\"\>", 
   ",", "\<\"(b)c(d)\"\>", ",", "\<\"(d)\"\>"}], "}"}]], "Output",
 ImageSize->{252, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.3",
 CellLabel->"Out[62]=",
 CellID->468451421]
}, Open  ]],

Cell[TextData[{
 "If multiple patterns are given in a list, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Overlaps",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Overlaps"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " will cause the matcher to start at the same position once for each of the \
patterns before proceeding to the next character."
}], "Text",
 CellTags->"b:0.4.3",
 CellID->627314046],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<(a(b)c(d)\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Shortest", "[", 
      RowBox[{"\"\<(\>\"", "~~", "__", "~~", "\"\<)\>\""}], "]"}], ",", 
     RowBox[{"Shortest", "[", 
      RowBox[{"\"\<(\>\"", "~~", "__", "~~", "\"\<(\>\""}], "]"}]}], "}"}], 
   ",", 
   RowBox[{"Overlaps", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellTags->"b:0.4.3",
 CellLabel->"In[63]:=",
 CellID->87536172],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"(a(b)\"\>", ",", "\<\"(a(\"\>", ",", "\<\"(b)\"\>", 
   ",", "\<\"(b)c(\"\>", ",", "\<\"(d)\"\>"}], "}"}]], "Output",
 ImageSize->{196, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.3",
 CellLabel->"Out[63]=",
 CellID->561505271]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<(a(b)c(d)\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Shortest", "[", 
      RowBox[{"\"\<(\>\"", "~~", "__", "~~", "\"\<)\>\""}], "]"}], ",", 
     RowBox[{"Shortest", "[", 
      RowBox[{"\"\<(\>\"", "~~", "__", "~~", "\"\<(\>\""}], "]"}]}], "}"}], 
   ",", 
   RowBox[{"Overlaps", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellTags->"b:0.4.3",
 CellLabel->"In[64]:=",
 CellID->31744191],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"(a(b)\"\>", ",", "\<\"(d)\"\>"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.3",
 CellLabel->"Out[64]=",
 CellID->271831375]
}, Open  ]],

Cell[TextData[{
 "Note that with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Overlaps",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Overlaps"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", there can thus be a difference between specifying a list of patterns and \
using the alternatives operator (",
 Cell[BoxData["|"], "InlineFormula"],
 ")."
}], "Text",
 CellTags->"b:0.4.3",
 CellID->1005472710],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<ab\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"_", ",", "__"}], "}"}], ",", 
   RowBox[{"Overlaps", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellTags->"b:0.4.3",
 CellLabel->"In[65]:=",
 CellID->168142260],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"ab\"\>", ",", "\<\"b\"\>", 
   ",", "\<\"b\"\>"}], "}"}]], "Output",
 ImageSize->{87, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.3",
 CellLabel->"Out[65]=",
 CellID->7842756]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<ab\>\"", ",", 
   RowBox[{"_", "|", "__"}], ",", 
   RowBox[{"Overlaps", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellTags->"b:0.4.3",
 CellLabel->"In[66]:=",
 CellID->42485134],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.3",
 CellLabel->"Out[66]=",
 CellID->337333049]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["StringPosition", "Subsection",
 CellTags->{"c:10", "b:0.4.4"},
 CellID->363493082],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringPosition"]], "InlineFormula"],
 " works much like ",
 Cell[BoxData[
  ButtonBox["StringCases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringCases"]], "InlineFormula"],
 ", except the positions of the matching substrings are returned."
}], "Text",
 CellTags->"b:0.4.4",
 CellID->3234460],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringPosition", "[", 
  RowBox[{"\"\<a1b2a26d15a42\>\"", ",", 
   RowBox[{"\"\<a\>\"", "~~", "_"}]}], "]"}]], "Input",
 CellTags->"b:0.4.4",
 CellLabel->"In[67]:=",
 CellID->175418910],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "12"}], "}"}]}], "}"}]], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.4",
 CellLabel->"Out[67]=",
 CellID->450807373]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"StringTake", "[", 
    RowBox[{"\"\<a1b2a26d15a42\>\"", ",", "#"}], "]"}], "&"}], "/@", 
  "%"}]], "Input",
 CellTags->"b:0.4.4",
 CellLabel->"In[68]:=",
 CellID->352798794],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a1\"\>", ",", "\<\"a2\"\>", ",", "\<\"a4\"\>"}], 
  "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.4",
 CellLabel->"Out[68]=",
 CellID->839342939]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Overlaps",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Overlaps"]], "InlineFormula"],
 " option is ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " by default (see the previous section for more details on this option)."
}], "Text",
 CellTags->"b:0.4.4",
 CellID->771123683],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringPosition", "[", 
  RowBox[{"\"\<(a(b)c(d)\>\"", ",", 
   RowBox[{"Shortest", "[", 
    RowBox[{"\"\<(\>\"", "~~", "__", "~~", "\"\<)\>\""}], "]"}]}], 
  "]"}]], "Input",
 CellTags->"b:0.4.4",
 CellLabel->"In[69]:=",
 CellID->227693171],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "9"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.4",
 CellLabel->"Out[69]=",
 CellID->431531950]
}, Open  ]],

Cell["Note that even empty strings can be matches.", "Text",
 CellTags->"b:0.4.4",
 CellID->141395505],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringPosition", "[", 
  RowBox[{"\"\<abc\>\"", ",", "___"}], "]"}]], "Input",
 CellTags->"b:0.4.4",
 CellLabel->"In[70]:=",
 CellID->695066864],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3"}], "}"}]}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.4",
 CellLabel->"Out[70]=",
 CellID->242903424]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["StringCount", "Subsection",
 CellTags->{"c:11", "b:0.4.5"},
 CellID->401719377],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringCount"]], "InlineFormula"],
 " returns the number of matching substrings (which are found by ",
 Cell[BoxData[
  ButtonBox["StringPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringPosition"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["StringCases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringCases"]], "InlineFormula"],
 "). It is useful for cases with many matches where memory for storing all \
the substrings might be an issue."
}], "Text",
 CellTags->"b:0.4.5",
 CellID->771573730],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCount", "[", 
  RowBox[{"\"\<abaababba\>\"", ",", 
   RowBox[{"\"\<a\>\"", "~~", 
    RowBox[{"___", "~~", "\"\<b\>\""}]}], ",", 
   RowBox[{"Overlaps", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellTags->"b:0.4.5",
 CellLabel->"In[71]:=",
 CellID->175837266],

Cell[BoxData["12"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.5",
 CellLabel->"Out[71]=",
 CellID->699615004]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StringCases", "[", 
   RowBox[{"\"\<abaababba\>\"", ",", 
    RowBox[{"\"\<a\>\"", "~~", 
     RowBox[{"___", "~~", "\"\<b\>\""}]}], ",", 
    RowBox[{"Overlaps", "\[Rule]", "All"}]}], "]"}], "//", 
  "Length"}]], "Input",
 CellTags->"b:0.4.5",
 CellLabel->"In[72]:=",
 CellID->16340890],

Cell[BoxData["12"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.5",
 CellLabel->"Out[72]=",
 CellID->327764894]
}, Open  ]],

Cell[TextData[{
 "Note that ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Overlaps",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Overlaps"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " is the default for ",
 Cell[BoxData[
  ButtonBox["StringCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringCount"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.4.5",
 CellID->12491824]
}, Open  ]],

Cell[CellGroupData[{

Cell["StringReplace", "Subsection",
 CellTags->{"c:12", "b:0.4.6"},
 CellID->1274428],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringReplace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReplace"]], "InlineFormula"],
 " is used for substituting substrings matching the given patterns."
}], "Text",
 CellTags->"b:0.4.6",
 CellID->45121066],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<abcde\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<a\>\"", "\[Rule]", "\"\<A\>\""}], ",", 
     RowBox[{"\"\<cd\>\"", "\[Rule]", "\"\<XX\>\""}]}], "}"}]}], 
  "]"}]], "Input",
 CellTags->"b:0.4.6",
 CellLabel->"In[73]:=",
 CellID->67067787],

Cell[BoxData["\<\"AbXXe\"\>"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.6",
 CellLabel->"Out[73]=",
 CellID->72896606]
}, Open  ]],

Cell[TextData[{
 "Named patterns can be used as strings on the right-hand side of the \
replacement rules. Note the use of ",
 Cell[BoxData[
  ButtonBox["RuleDelayed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RuleDelayed"]], "InlineFormula"],
 " (",
 Cell[BoxData["\[RuleDelayed]"], "InlineFormula"],
 ") to avoid premature evaluation."
}], "Text",
 CellTags->"b:0.4.6",
 CellID->21617589],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<this is a test\>\"", ",", 
   RowBox[{
    RowBox[{"x", ":", 
     RowBox[{"WordCharacter", ".."}]}], "\[RuleDelayed]", 
    RowBox[{"StringReverse", "[", "x", "]"}]}]}], "]"}]], "Input",
 CellTags->"b:0.4.6",
 CellLabel->"In[74]:=",
 CellID->801931404],

Cell[BoxData["\<\"siht si a tset\"\>"], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.6",
 CellLabel->"Out[74]=",
 CellID->187183009]
}, Open  ]],

Cell[TextData[{
 "When using regular expressions, it is convenient to remember that ",
 Cell[BoxData["\"\<$0\>\""], "InlineFormula"],
 " on the right-hand side refers to the whole matched substring."
}], "Text",
 CellTags->"b:0.4.6",
 CellID->150245402],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<this is a test\>\"", ",", 
   RowBox[{
    RowBox[{"RegularExpression", "[", "\"\<\\\\w+\>\"", "]"}], 
    "\[RuleDelayed]", 
    RowBox[{"StringReverse", "[", "\"\<$0\>\"", "]"}]}]}], "]"}]], "Input",
 CellTags->"b:0.4.6",
 CellLabel->"In[75]:=",
 CellID->85246728],

Cell[BoxData["\<\"siht si a tset\"\>"], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.6",
 CellLabel->"Out[75]=",
 CellID->483186576]
}, Open  ]],

Cell["\<\
You can limit the number of replacements made by specifying a third argument.\
\
\>", "Text",
 CellTags->"b:0.4.6",
 CellID->203144771],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<this is a test\>\"", ",", 
   RowBox[{
    RowBox[{"x", ":", 
     RowBox[{"WordCharacter", ".."}]}], "\[RuleDelayed]", 
    RowBox[{"StringReverse", "[", "x", "]"}]}], ",", "1"}], "]"}]], "Input",
 CellTags->"b:0.4.6",
 CellLabel->"In[76]:=",
 CellID->17461363],

Cell[BoxData["\<\"siht is a test\"\>"], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.6",
 CellLabel->"Out[76]=",
 CellID->461731323]
}, Open  ]],

Cell[TextData[{
 "Note that the replacement does not have to be a string. If the result is \
not a string, a ",
 Cell[BoxData[
  ButtonBox["StringExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringExpression"]], "InlineFormula"],
 " is returned."
}], "Text",
 CellTags->"b:0.4.6",
 CellID->131051894],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<some <b>bold</b> and <i>italics</i>.\>\"", ",", 
   RowBox[{
    RowBox[{"Shortest", "[", 
     RowBox[{"\"\<<\>\"", "~~", "x___", "~~", "\"\<>\>\""}], "]"}], 
    "\[RuleDelayed]", 
    RowBox[{"Tag", "[", "x", "]"}]}]}], "]"}]], "Input",
 CellTags->"b:0.4.6",
 CellLabel->"In[77]:=",
 CellID->459415768],

Cell[BoxData[
 RowBox[{"\<\"some \"\>", "~~", 
  RowBox[{
   RowBox[{"Tag", "[", "\<\"b\"\>", "]"}], "~~", 
   RowBox[{"\<\"bold\"\>", "~~", 
    RowBox[{
     RowBox[{"Tag", "[", "\<\"/b\"\>", "]"}], "~~", 
     RowBox[{"\<\" and \"\>", "~~", 
      RowBox[{
       RowBox[{"Tag", "[", "\<\"i\"\>", "]"}], "~~", 
       RowBox[{"\<\"italics\"\>", "~~", 
        RowBox[{
         RowBox[{"Tag", "[", "\<\"/i\"\>", "]"}], 
         "~~", "\<\".\"\>"}]}]}]}]}]}]}]}]], "Output",
 ImageSize->{508, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.6",
 CellLabel->"Out[77]=",
 CellID->478032402]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellTags->"b:0.4.6",
 CellLabel->"In[78]:=",
 CellID->28871706],

Cell["\<\
StringExpression[\"some \", Tag[\"b\"], \"bold\", Tag[\"/b\"], \" and \", \
Tag[\"i\"], \"italics\", Tag[\"/i\"], \".\"]\
\>", "Output",
 ImageSize->{700, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.6",
 CellLabel->"Out[78]//InputForm=",
 CellID->728560033]
}, Open  ]],

Cell[TextData[{
 "There is limited support for using the old ",
 Cell[BoxData["MetaCharacters"], "InlineFormula"],
 " option in conjunction with general string patterns, but this option is \
deprecated and its use should be avoided."
}], "Text",
 CellTags->"b:0.4.6",
 CellID->623263418]
}, Open  ]],

Cell[CellGroupData[{

Cell["StringReplaceList", "Subsection",
 CellTags->{"c:13", "b:0.4.7"},
 CellID->239124212],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringReplaceList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReplaceList"]], "InlineFormula"],
 " returns a list of strings where a ",
 StyleBox["single",
  FontSlant->"Italic"],
 " string replacement has been made in all possible ways."
}], "Text",
 CellTags->"b:0.4.7",
 CellID->758815075],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplaceList", "[", 
  RowBox[{"\"\<abaac\>\"", ",", 
   RowBox[{
    RowBox[{"\"\<a\>\"", "~~", "x_"}], "\[RuleDelayed]", 
    RowBox[{"ToUpperCase", "[", "x", "]"}]}]}], "]"}]], "Input",
 CellTags->"b:0.4.7",
 CellLabel->"In[79]:=",
 CellID->34244212],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Baac\"\>", ",", "\<\"abAc\"\>", ",", "\<\"abaC\"\>"}], 
  "}"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.7",
 CellLabel->"Out[79]=",
 CellID->977687334]
}, Open  ]],

Cell["\<\
If a list of strings is given as input, the output is a nested list of \
results.\
\>", "Text",
 CellTags->"b:0.4.7",
 CellID->578481874],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplaceList", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<abaac\>\"", ",", "\"\<baaba\>\""}], "}"}], ",", 
   RowBox[{
    RowBox[{"\"\<a\>\"", "~~", "x_"}], "\[RuleDelayed]", 
    RowBox[{"ToUpperCase", "[", "x", "]"}]}]}], "]"}]], "Input",
 CellTags->"b:0.4.7",
 CellLabel->"In[80]:=",
 CellID->80963487],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"Baac\"\>", ",", "\<\"abAc\"\>", ",", "\<\"abaC\"\>"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"bAba\"\>", ",", "\<\"baBa\"\>"}], "}"}]}], "}"}]], "Output",
 ImageSize->{231, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.7",
 CellLabel->"Out[80]=",
 CellID->588842050]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["StringSplit", "Subsection",
 CellTags->{"c:14", "b:0.4.8"},
 CellID->343107939],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringSplit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringSplit"]], "InlineFormula"],
 " is useful for splitting a string into many strings at delimiters matching \
a pattern. By default, the splits happen at runs of whitespace."
}], "Text",
 CellTags->"b:0.4.8",
 CellID->19737335],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringSplit", "[", "\"\<this is a test\>\"", "]"}]], "Input",
 CellTags->"b:0.4.8",
 CellLabel->"In[81]:=",
 CellID->20551734],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"this\"\>", ",", "\<\"is\"\>", ",", "\<\"a\"\>", 
   ",", "\<\"test\"\>"}], "}"}]], "Output",
 ImageSize->{129, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.8",
 CellLabel->"Out[81]=",
 CellID->34809990]
}, Open  ]],

Cell["\<\
For instance, to split a normal sentence into words, we need to also include \
punctuation in the delimiter.\
\>", "Text",
 CellTags->"b:0.4.8",
 CellID->27447488],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringSplit", "[", 
  RowBox[{"\"\<A sentence: with commas, semicolons; etc...!?\>\"", ",", 
   RowBox[{
    RowBox[{"Characters", "[", "\"\<:,;.!? \>\"", "]"}], ".."}]}], 
  "]"}]], "Input",
 CellTags->"b:0.4.8",
 CellLabel->"In[82]:=",
 CellID->107169258],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"A\"\>", ",", "\<\"sentence\"\>", ",", "\<\"with\"\>", 
   ",", "\<\"commas\"\>", ",", "\<\"semicolons\"\>", ",", "\<\"etc\"\>"}], 
  "}"}]], "Output",
 ImageSize->{298, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.8",
 CellLabel->"Out[82]=",
 CellID->20960328]
}, Open  ]],

Cell["\<\
By default, empty strings at the beginning and the end of the result are \
removed.\
\>", "Text",
 CellTags->"b:0.4.8",
 CellID->60098082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringSplit", "[", 
  RowBox[{"\"\<:a:b:c:\>\"", ",", "\"\<:\>\""}], "]"}]], "Input",
 CellTags->"b:0.4.8",
 CellLabel->"In[83]:=",
 CellID->72110840],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>"}], "}"}]], "Output",\

 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.8",
 CellLabel->"Out[83]=",
 CellID->515316641]
}, Open  ]],

Cell[TextData[{
 "These can be included by specifying ",
 Cell[BoxData[
  ButtonBox["All",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/All"]], "InlineFormula"],
 " as a third argument."
}], "Text",
 CellTags->"b:0.4.8",
 CellID->103751328],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringSplit", "[", 
  RowBox[{"\"\<:a:b:c:\>\"", ",", "\"\<:\>\"", ",", "All"}], "]"}]], "Input",
 CellTags->"b:0.4.8",
 CellLabel->"In[84]:=",
 CellID->460561670],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"\"\>", ",", "\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>", 
   ",", "\<\"\"\>"}], "}"}]], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.8",
 CellLabel->"Out[84]=",
 CellID->1004147207]
}, Open  ]],

Cell["\<\
The third argument can also be a number giving the maximum number of strings \
to split into.\
\>", "Text",
 CellTags->"b:0.4.8",
 CellID->656954062],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringSplit", "[", 
  RowBox[{"\"\<this is a test\>\"", ",", "Whitespace", ",", "2"}], 
  "]"}]], "Input",
 CellTags->"b:0.4.8",
 CellLabel->"In[85]:=",
 CellID->1019234],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"this\"\>", ",", "\<\"is a test\"\>"}], "}"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.8",
 CellLabel->"Out[85]=",
 CellID->135279393]
}, Open  ]],

Cell["This splits a string into individual lines.", "Text",
 CellTags->"b:0.4.8",
 CellID->241434771],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringSplit", "[", 
  RowBox[{"\"\<line1\\nthis is line 2\\nline3\>\"", ",", "\"\<\\n\>\""}], 
  "]"}]], "Input",
 CellTags->"b:0.4.8",
 CellLabel->"In[86]:=",
 CellID->171055668],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"line1\"\>", ",", "\<\"this is line 2\"\>", 
   ",", "\<\"line3\"\>"}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.8",
 CellLabel->"Out[86]=",
 CellID->802280320]
}, Open  ]],

Cell[TextData[{
 "You can also split at patterns that match positions, such as ",
 Cell[BoxData[
  ButtonBox["StartOfLine",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StartOfLine"]], "InlineFormula"],
 ". This keeps the newline characters in the result."
}], "Text",
 CellTags->"b:0.4.8",
 CellID->590437369],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringSplit", "[", 
  RowBox[{"\"\<line1\\nthis is line 2\\nline3\>\"", ",", "StartOfLine"}], 
  "]"}]], "Input",
 CellTags->"b:0.4.8",
 CellLabel->"In[87]:=",
 CellID->4669335],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"line1\\n\"\>", ",", "\<\"this is line 2\\n\"\>", 
   ",", "\<\"line3\"\>"}], "}"}]], "Output",
 ImageSize->{114, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.8",
 CellLabel->"Out[87]=",
 CellID->44401504]
}, Open  ]],

Cell["\<\
You can keep the delimiters, or parts of the delimiters, in the output by \
using a rule as the second argument.\
\>", "Text",
 CellTags->"b:0.4.8",
 CellID->11065132],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringSplit", "[", 
  RowBox[{"\"\<this is a test\>\"", ",", 
   RowBox[{"\"\< \>\"", "\[Rule]", "\"\< \>\""}]}], "]"}]], "Input",
 CellTags->"b:0.4.8",
 CellLabel->"In[88]:=",
 CellID->386084822],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"this\"\>", ",", "\<\" \"\>", ",", "\<\"is\"\>", 
   ",", "\<\" \"\>", ",", "\<\"a\"\>", ",", "\<\" \"\>", 
   ",", "\<\"test\"\>"}], "}"}]], "Output",
 ImageSize->{184, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.8",
 CellLabel->"Out[88]=",
 CellID->364330143]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringSplit", "[", 
  RowBox[{"\"\<this is a test\>\"", ",", 
   RowBox[{"\"\< \>\"", "\[Rule]", "\"\<:\>\""}]}], "]"}]], "Input",
 CellTags->"b:0.4.8",
 CellLabel->"In[89]:=",
 CellID->60902233],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"this\"\>", ",", "\<\":\"\>", ",", "\<\"is\"\>", 
   ",", "\<\":\"\>", ",", "\<\"a\"\>", ",", "\<\":\"\>", 
   ",", "\<\"test\"\>"}], "}"}]], "Output",
 ImageSize->{184, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.8",
 CellLabel->"Out[89]=",
 CellID->106027777]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringSplit", "[", 
  RowBox[{"\"\<the <tag1>first</tag1> and the <tag2>second</tag2>\>\"", ",", 
   RowBox[{"Shortest", "[", 
    RowBox[{"\"\<<\>\"", "~~", "__", "~~", "\"\<>\>\""}], "]"}]}], 
  "]"}]], "Input",
 CellTags->"b:0.4.8",
 CellLabel->"In[90]:=",
 CellID->73670271],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"the \"\>", ",", "\<\"first\"\>", ",", "\<\" and the \"\>", 
   ",", "\<\"second\"\>"}], "}"}]], "Output",
 ImageSize->{220, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.8",
 CellLabel->"Out[90]=",
 CellID->293993995]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringSplit", "[", 
  RowBox[{"\"\<the <tag1>first</tag1> and the <tag2>second</tag2>\>\"", ",", 
   RowBox[{
    RowBox[{"Shortest", "[", 
     RowBox[{"\"\<<\>\"", "~~", "x__", "~~", "\"\<>\>\""}], "]"}], 
    "\[RuleDelayed]", 
    RowBox[{"Tag", "[", "x", "]"}]}]}], "]"}]], "Input",
 CellTags->"b:0.4.8",
 CellLabel->"In[91]:=",
 CellID->153068299],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"the \"\>", ",", 
   RowBox[{"Tag", "[", "\<\"tag1\"\>", "]"}], ",", "\<\"first\"\>", ",", 
   RowBox[{"Tag", "[", "\<\"/tag1\"\>", "]"}], ",", "\<\" and the \"\>", ",", 
   
   RowBox[{"Tag", "[", "\<\"tag2\"\>", "]"}], ",", "\<\"second\"\>", ",", 
   RowBox[{"Tag", "[", "\<\"/tag2\"\>", "]"}]}], "}"}]], "Output",
 ImageSize->{531, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.8",
 CellLabel->"Out[91]=",
 CellID->129996884]
}, Open  ]],

Cell["\<\
You can give a list of patterns and rules as well; the delimiters matching \
the patterns will be left out of the result.\
\>", "Text",
 CellTags->"b:0.4.8",
 CellID->307113028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StringSplit", "[", 
   RowBox[{
   "\"\<the <tag1>first</tag1> and the <tag2>second</tag2>\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"Whitespace", ",", 
      RowBox[{
       RowBox[{"Shortest", "[", 
        RowBox[{"\"\<<\>\"", "~~", "x__", "~~", "\"\<>\>\""}], "]"}], 
       "\[RuleDelayed]", 
       RowBox[{"Tag", "[", "x", "]"}]}]}], "}"}]}], "]"}], "//", 
  "InputForm"}]], "Input",
 CellTags->"b:0.4.8",
 CellLabel->"In[92]:=",
 CellID->36223674],

Cell["\<\
{\"the\", \"\", Tag[\"tag1\"], \"first\", Tag[\"/tag1\"], \"\", \"and\", \
\"the\", \"\", Tag[\"tag2\"], \"second\", Tag[\"/tag2\"]}\
\>", "Output",
 ImageSize->{742, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.4.8",
 CellLabel->"Out[92]//InputForm=",
 CellID->409814246]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["For Perl Users", "Section",
 CellTags->"c:15",
 CellID->759470019],

Cell[CellGroupData[{

Cell["Overview", "Subsection",
 CellTags->{"c:15.5", "b:0.5.0"},
 CellID->20697950],

Cell[TextData[{
 "With the addition of general string patterns, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can be a powerful alternative to languages like Perl and Python for many \
general, everyday programming tasks. For people familiar with Perl syntax, \
and the way Perl does string manipulation, the following rough guide shows \
how to get similar functionality in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"b:0.5.0",
 CellID->86791152],

Cell[TextData[{
 "Here is an overview of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions involved in constructing Perl-like functions."
}], "Text",
 CellTags->"b:0.5.0",
 CellID->323888524],

Cell[BoxData[GridBox[{
   {Cell["Perl Construct", "TableHeader"], Cell[
    "Mathematica Function", "TableHeader"], Cell[
    "Explanation", "TableHeader"]},
   {
    RowBox[{
     RowBox[{
      RowBox[{"m", "/"}], "\[NegativeThinSpace]", "..."}], "/"}], 
    RowBox[{
     ButtonBox["StringFreeQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringFreeQ"], Cell["or", "TableText"], 
     ButtonBox["StringCases",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringCases"]}], Cell["\<\
match a string with a regular expression, possibly extracting subpatterns\
\>", "TableText"]},
   {
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"s", "/"}], "\[NegativeThinSpace]", "..."}], "/"}], 
      "\[NegativeThinSpace]", "..."}], "/"}], 
    ButtonBox["StringReplace",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/StringReplace"], Cell[
    "replace substrings matching a regular expression", "TableText"]},
   {
    RowBox[{"split", 
     RowBox[{"(", "...", ")"}]}], 
    ButtonBox["StringSplit",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/StringSplit"], Cell[
    "split a string at delimiters matching a regular expression ", 
     "TableText"]},
   {
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"tr", "/"}], "\[NegativeThinSpace]", "..."}], "/"}], 
      "\[NegativeThinSpace]", "..."}], "/"}], 
    ButtonBox["StringReplace",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/StringReplace"], Cell[
    "replace characters by other characters ", "TableText"]},
   {
    RowBox[{"/", "i"}], 
    RowBox[{
     ButtonBox["IgnoreCase",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/IgnoreCase"], "->", 
     RowBox[{
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"], Cell["or", "TableText"], 
      "\"\<(?i)\>\""}]}], Cell["case-insensitive modifier ", "TableText"]},
   {
    RowBox[{"/", "s"}], "\"\<(?s)\>\"", Cell[TextData[{
     "force ",
     Cell[BoxData["\"\<.\>\""], "InlineFormula"],
     " to match all characters (including newlines) "
    }], "TableText"]},
   {
    RowBox[{"/", "x"}], "\"\<(?x)\>\"", Cell["\<\
ignore whitespace and allow extended comments in regular expression\
\>", "TableText"]},
   {
    RowBox[{"/", "m"}], "\"\<(?m)\>\"", Cell[TextData[{
     "multiline mode (",
     Cell[BoxData["\"\<^\>\""], "InlineFormula"],
     " and ",
     Cell[BoxData["\"\<$\>\""], "InlineFormula"],
     " match start/end of lines)"
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
    "RowsIndexed" -> {}}]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellTags->"b:0.5.0",
 CellID->43654671],

Cell["Following are some common Perl constructs in more detail.", "Text",
 CellTags->"b:0.5.0",
 CellID->575279163]
}, Open  ]],

Cell[CellGroupData[{

Cell["m/.../", "Subsection",
 CellTags->{"c:16", "b:0.5.1"},
 CellID->120637313],

Cell[TextData[{
 "The match operator ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "/", "regex"}], "/"}]], "InlineFormula"],
 " tests whether a string contains a substring matching the ",
 Cell[BoxData["regex"], "InlineFormula"],
 ". For simple matches of this sort in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", use ",
 Cell[BoxData[
  ButtonBox["StringFreeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringFreeQ"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.5.1",
 CellID->332493086],

Cell[TextData[{
 "Here is a Perl snippet for testing whether a string contains a ",
 Cell[BoxData["\"\<b\>\""], "InlineFormula"],
 " somewhere after an ",
 Cell[BoxData["\"\<a\>\""], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.5.1",
 CellID->163086882],

Cell["\<\
$string = \"sdakdb\";
if ($string =~ m/a.*b/){
  print \"Match!\";
}\
\>", "Program",
 CellTags->"b:0.5.1",
 CellID->203403607],

Cell[TextData[{
 "Here is a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " version of the same test."
}], "Text",
 CellTags->"b:0.5.1",
 CellID->258819916],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"string", "=", "\"\<sdakdb\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"!", 
    RowBox[{"StringFreeQ", "[", 
     RowBox[{"string", ",", 
      RowBox[{"RegularExpression", "[", "\"\<a.*b\>\"", "]"}]}], "]"}]}], ",",
    
   RowBox[{"Print", "[", "\"\<Match!\>\"", "]"}]}], "]"}]}], "Input",
 CellTags->"b:0.5.1",
 CellLabel->"In[93]:=",
 CellID->403377399],

Cell[BoxData["\<\"Match!\"\>"], "Print",
 CellTags->"b:0.5.1",
 CellID->13390572]
}, Open  ]],

Cell[TextData[{
 "If parts of the matched string need to be accessed later, using ",
 Cell[BoxData["$1"], "InlineFormula"],
 ", ",
 Cell[BoxData["$2"], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"],
 " in Perl, the best ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function to use is normally ",
 Cell[BoxData[
  ButtonBox["StringCases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringCases"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.5.1",
 CellID->130918903],

Cell["Here is Perl code for extracting an error message.", "Text",
 CellTags->"b:0.5.1",
 CellID->272631892],

Cell["\<\
$res = \"ERROR = paper jam\";
if ($res =~ m/ERROR = (.*)/){
  print \"Hey, you should check the $1!\";
}\
\>", "Program",
 CellTags->"b:0.5.1",
 CellID->67879431],

Cell[TextData[{
 "Here is a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " version."
}], "Text",
 CellTags->"b:0.5.1",
 CellID->175118403],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"res", "=", "\"\<ERROR = paper jam\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"test", "=", 
     RowBox[{"StringCases", "[", 
      RowBox[{"res", ",", 
       RowBox[{
        RowBox[{"RegularExpression", "[", "\"\<ERROR = (.*)\>\"", "]"}], 
        "\[Rule]", "\"\<$1\>\""}]}], "]"}]}], "}"}], ",", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"test", "=!=", 
      RowBox[{"{", "}"}]}], ",", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Hey, you should check the \>\"", ",", 
       RowBox[{"test", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", "\"\<!\>\""}], "]"}]}], "]"}]}], 
  "]"}]}], "Input",
 CellTags->"b:0.5.1",
 CellLabel->"In[95]:=",
 CellID->399472551],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Hey, you should check the \"\>", 
   "\[InvisibleSpace]", "\<\"paper jam\"\>", 
   "\[InvisibleSpace]", "\<\"!\"\>"}],
  SequenceForm["Hey, you should check the ", "paper jam", "!"],
  Editable->False]], "Print",
 CellTags->"b:0.5.1",
 CellID->354731971]
}, Open  ]],

Cell["\<\
Here is Perl code for extracting several subpatterns at once.\
\>", "Text",
 CellTags->"b:0.5.1",
 CellID->161491337],

Cell["\<\
$date = \"88/6/13\";
($year, $month, $day) = $date =~ m/^(\\d+)/(\\d+)/(\\d+)$/;\
\>", "Program",
 CellTags->"b:0.5.1",
 CellID->785509705],

Cell[TextData[{
 "In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", this is done with ",
 Cell[BoxData[
  ButtonBox["StringCases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringCases"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.5.1",
 CellID->445860386],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"date", "=", "\"\<88/6/13\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"year", ",", "month", ",", "day"}], "}"}], "=", 
  RowBox[{
   RowBox[{"StringCases", "[", 
    RowBox[{"date", ",", 
     RowBox[{
      RowBox[{
      "RegularExpression", "[", "\"\<^(\\\\d+)/(\\\\d+)/(\\\\d+)$\>\"", "]"}],
       "->", 
      RowBox[{"{", 
       RowBox[{"\"\<$1\>\"", ",", "\"\<$2\>\"", ",", "\"\<$3\>\""}], 
       "}"}]}]}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]}], "Input",
 CellTags->"b:0.5.1",
 CellLabel->"In[97]:=",
 CellID->682251121],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"88\"\>", ",", "\<\"6\"\>", ",", "\<\"13\"\>"}], 
  "}"}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.5.1",
 CellLabel->"Out[98]=",
 CellID->66729238]
}, Open  ]],

Cell[TextData[{
 "This is similar to assigning all the matches to an array using the ",
 Cell[BoxData[
  RowBox[{"/", "g"}]], "InlineFormula"],
 " modifier."
}], "Text",
 CellTags->"b:0.5.1",
 CellID->20175135],

Cell["\<\
$text = \"128.32.13.117\";
@nums = $text =~ m/\\d+/g;\
\>", "Program",
 CellTags->"b:0.5.1",
 CellID->19723038],

Cell[TextData[{
 "The same thing is easily done with ",
 Cell[BoxData[
  ButtonBox["StringCases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringCases"]], "InlineFormula"],
 " in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"b:0.5.1",
 CellID->781694409],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"text", "=", "\"\<128.32.13.117\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"nums", "=", 
  RowBox[{"StringCases", "[", 
   RowBox[{"text", ",", 
    RowBox[{"RegularExpression", "[", "\"\<\\\\d+\>\"", "]"}]}], 
   "]"}]}]}], "Input",
 CellTags->"b:0.5.1",
 CellLabel->"In[99]:=",
 CellID->43441911],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"128\"\>", ",", "\<\"32\"\>", ",", "\<\"13\"\>", 
   ",", "\<\"117\"\>"}], "}"}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.5.1",
 CellLabel->"Out[100]=",
 CellID->402829830]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["s/.../.../", "Subsection",
 CellTags->{"c:17", "b:0.5.2"},
 CellID->163295011],

Cell[TextData[{
 "The obvious ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " version of the Perl ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"s", "/"}], "\[NegativeThinSpace]", "..."}], "/"}], 
    "\[NegativeThinSpace]", "..."}], "/"}]], "InlineFormula"],
 " substitution operator is ",
 Cell[BoxData[
  ButtonBox["StringReplace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReplace"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.5.2",
 CellID->51683055],

Cell["\<\
$text = \"abcagh\";
$text =~ s/a./XX/;\
\>", "Program",
 CellTags->"b:0.5.2",
 CellID->384257252],

Cell["The default Perl behavior is to do a single replacement.", "Text",
 CellTags->"b:0.5.2",
 CellID->179104029],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"text", "=", "\"\<abcagh\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"StringReplace", "[", 
  RowBox[{"text", ",", 
   RowBox[{
    RowBox[{"RegularExpression", "[", "\"\<a.\>\"", "]"}], "->", 
    "\"\<XX\>\""}], ",", "1"}], "]"}]}], "Input",
 CellTags->"b:0.5.2",
 CellLabel->"In[101]:=",
 CellID->252897767],

Cell[BoxData["\<\"XXcagh\"\>"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.5.2",
 CellLabel->"Out[102]=",
 CellID->152663893]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  RowBox[{"/", "g"}]], "InlineFormula"],
 " modifier in Perl does global replacement of all matches."
}], "Text",
 CellTags->"b:0.5.2",
 CellID->317632773],

Cell["$text =~ s/a./XX/g", "Program",
 CellTags->"b:0.5.2",
 CellID->152813715],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"text", ",", 
   RowBox[{
    RowBox[{"RegularExpression", "[", "\"\<a.\>\"", "]"}], "->", 
    "\"\<XX\>\""}]}], "]"}]], "Input",
 CellTags->"b:0.5.2",
 CellLabel->"In[103]:=",
 CellID->341597359],

Cell[BoxData["\<\"XXcXXh\"\>"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.5.2",
 CellLabel->"Out[103]=",
 CellID->294762643]
}, Open  ]],

Cell[TextData[{
 "Using the evaluation ",
 Cell[BoxData[
  RowBox[{"/", "e"}]], "InlineFormula"],
 " modifier, Perl can use subpatterns as part of the replacement. This is \
easily done in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"b:0.5.2",
 CellID->183807183],

Cell["\<\
$text = \"13 27 3\";
$text =~ s/(\\d+)/$1$1/eg\
\>", "Program",
 CellTags->"b:0.5.2",
 CellID->409627135],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"text", "=", "\"\<13 27 3\>\""}], ";"}], "\n", 
 RowBox[{"StringReplace", "[", 
  RowBox[{"text", ",", 
   RowBox[{
    RowBox[{"RegularExpression", "[", "\"\<(\\\\d+)\>\"", "]"}], 
    "\[RuleDelayed]", "\"\<$1$1\>\""}]}], "]"}]}], "Input",
 CellTags->"b:0.5.2",
 CellLabel->"In[104]:=",
 CellID->69447560],

Cell[BoxData["\<\"1313 2727 33\"\>"], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.5.2",
 CellLabel->"Out[105]=",
 CellID->406228538]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["split(...)", "Subsection",
 CellTags->{"c:18", "b:0.5.3"},
 CellID->45791734],

Cell[TextData[{
 "The Perl ",
 Cell[BoxData["split"], "InlineFormula"],
 " command is similar to ",
 Cell[BoxData[
  ButtonBox["StringSplit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringSplit"]], "InlineFormula"],
 " in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"b:0.5.3",
 CellID->12267911],

Cell["\<\
$text = \"ab:cd:efg\";
split(/:/, $text)\
\>", "Program",
 CellTags->"b:0.5.3",
 CellID->189290885],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"text", "=", "\"\<ab:cd:efg\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"StringSplit", "[", 
  RowBox[{"text", ",", "\"\<:\>\""}], "]"}]}], "Input",
 CellTags->"b:0.5.3",
 CellLabel->"In[106]:=",
 CellID->229530619],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"ab\"\>", ",", "\<\"cd\"\>", ",", "\<\"efg\"\>"}], 
  "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.5.3",
 CellLabel->"Out[107]=",
 CellID->504939231]
}, Open  ]],

Cell[TextData[{
 "You can specify the number of blocks to split into in both Perl and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"b:0.5.3",
 CellID->240418930],

Cell["split(/:/, $text,2)", "Program",
 CellTags->"b:0.5.3",
 CellID->719922593],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringSplit", "[", 
  RowBox[{"text", ",", "\"\<:\>\"", ",", "2"}], "]"}]], "Input",
 CellTags->"b:0.5.3",
 CellLabel->"In[108]:=",
 CellID->502233132],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"ab\"\>", ",", "\<\"cd:efg\"\>"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.5.3",
 CellLabel->"Out[108]=",
 CellID->355681688]
}, Open  ]],

Cell[TextData[{
 "A ",
 Cell[BoxData["split"], "InlineFormula"],
 " with capturing parentheses in the pattern, for which the captured \
substrings are included in the result, can be done in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " using rules in the second argument of ",
 Cell[BoxData[
  ButtonBox["StringSplit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringSplit"]], "InlineFormula"],
 ". Compared to Perl, in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " it is easy to then apply a function to these substrings."
}], "Text",
 CellTags->"b:0.5.3",
 CellID->78986018],

Cell["\<\
$text = \"test with <tag1>tags</tag1> and <b>more</b>\";
split(/<([^>]*)>/, $text)\
\>", "Program",
 CellTags->"b:0.5.3",
 CellID->348675863],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "text", "=", "\"\<test with <tag1>tags</tag1> and <b>more</b>\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"StringSplit", "[", 
   RowBox[{"text", ",", 
    RowBox[{
     RowBox[{"RegularExpression", "[", "\"\<<([^>]*)>\>\"", "]"}], "\[Rule]", 
     "\"\<$1\>\""}]}], "]"}], "//", "InputForm"}]}], "Input",
 CellTags->"b:0.5.3",
 CellLabel->"In[109]:=",
 CellID->639488513],

Cell["\<\
{\"test with \", \"tag1\", \"tags\", \"/tag1\", \" and \", \"b\", \"more\", \
\"/b\"}\
\>", "Output",
 ImageSize->{469, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.5.3",
 CellLabel->"Out[110]//InputForm=",
 CellID->614879701]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "text", "=", "\"\<test with <tag1>tags</tag1> and <b>more</b>\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"StringSplit", "[", 
   RowBox[{"text", ",", 
    RowBox[{
     RowBox[{"RegularExpression", "[", "\"\<<([^>]*)>\>\"", "]"}], 
     "\[RuleDelayed]", 
     RowBox[{"Tag", "[", "\"\<$1\>\"", "]"}]}]}], "]"}], "//", 
  "InputForm"}]}], "Input",
 CellTags->"b:0.5.3",
 CellLabel->"In[111]:=",
 CellID->34696905],

Cell["\<\
{\"test with \", Tag[\"tag1\"], \"tags\", Tag[\"/tag1\"], \" and \", \
Tag[\"b\"], \"more\", Tag[\"/b\"]}\
\>", "Output",
 ImageSize->{609, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.5.3",
 CellLabel->"Out[112]//InputForm=",
 CellID->77828007]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["tr/.../.../", "Subsection",
 CellTags->{"c:19", "b:0.5.4"},
 CellID->627179989],

Cell[TextData[{
 "The Perl ",
 Cell[BoxData["tr"], "InlineFormula"],
 " command can be simulated using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  ButtonBox["StringReplace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReplace"]], "InlineFormula"],
 " together with the appropriate list of rules."
}], "Text",
 CellTags->"b:0.5.4",
 CellID->512373978],

Cell[TextData[{
 "Here is the simplest form where the characters ",
 Cell[BoxData["\"\<a\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<b\>\""], "InlineFormula"],
 ", and ",
 Cell[BoxData["\"\<c\>\""], "InlineFormula"],
 " are replaced by ",
 Cell[BoxData["\"\<X\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Y\>\""], "InlineFormula"],
 ", and ",
 Cell[BoxData["\"\<Z\>\""], "InlineFormula"],
 " respectively."
}], "Text",
 CellTags->"b:0.5.4",
 CellID->75100454],

Cell["\<\
$text = \"abcdef\";
$text =~ tr/abc/XYZ/\
\>", "Program",
 CellTags->"b:0.5.4",
 CellID->2535425],

Cell[TextData[{
 "This generates the appropriate rules in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " using ",
 Cell[BoxData[
  ButtonBox["Thread",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thread"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.5.4",
 CellID->616093666],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"text", "=", "\"\<abcdef\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"StringReplace", "[", 
  RowBox[{"text", ",", 
   RowBox[{"Thread", "[", 
    RowBox[{"Rule", "[", 
     RowBox[{
      RowBox[{"Characters", "[", "\"\<abc\>\"", "]"}], ",", 
      RowBox[{"Characters", "[", "\"\<XYZ\>\"", "]"}]}], "]"}], "]"}]}], 
  "]"}]}], "Input",
 CellTags->"b:0.5.4",
 CellLabel->"In[113]:=",
 CellID->394779265],

Cell[BoxData["\<\"XYZdef\"\>"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.5.4",
 CellLabel->"Out[114]=",
 CellID->44331865]
}, Open  ]],

Cell[TextData[{
 "Here is an example where the replacement list is shorter than the character \
list, so ",
 Cell[BoxData["\"\<d\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<e\>\""], "InlineFormula"],
 ", and ",
 Cell[BoxData["\"\<f\>\""], "InlineFormula"],
 " are all replaced by ",
 Cell[BoxData["\"\<Z\>\""], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.5.4",
 CellID->44095121],

Cell["\<\
$text = \"abcdefghi\";
$text =~ tr/abcdef/WXYZ/\
\>", "Program",
 CellTags->"b:0.5.4",
 CellID->260896876],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"text", "=", "\"\<abcdefghi\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"StringReplace", "[", 
  RowBox[{"text", ",", 
   RowBox[{"Append", "[", 
    RowBox[{
     RowBox[{"Thread", "[", 
      RowBox[{"Rule", "[", 
       RowBox[{
        RowBox[{"Characters", "[", "\"\<abc\>\"", "]"}], ",", 
        RowBox[{"Characters", "[", "\"\<WXY\>\"", "]"}]}], "]"}], "]"}], ",", 
     
     RowBox[{
      RowBox[{"Characters", "[", "\"\<def\>\"", "]"}], "\[Rule]", 
      "\"\<Z\>\""}]}], "]"}]}], "]"}]}], "Input",
 CellTags->"b:0.5.4",
 CellLabel->"In[115]:=",
 CellID->37744320],

Cell[BoxData["\<\"WXYZZZghi\"\>"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.5.4",
 CellLabel->"Out[116]=",
 CellID->232622468]
}, Open  ]],

Cell[TextData[{
 "Character ranges in Perl are emulated using ",
 Cell[BoxData[
  ButtonBox["CharacterRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CharacterRange"]], "InlineFormula"],
 " in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"b:0.5.4",
 CellID->291617831],

Cell["\<\
$text = \"this and that\";
$text =~ tr/a-z/x/\
\>", "Program",
 CellTags->"b:0.5.4",
 CellID->820168201],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"text", "=", "\"\<this and that\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"StringReplace", "[", 
  RowBox[{"text", ",", 
   RowBox[{
    RowBox[{"CharacterRange", "[", 
     RowBox[{"\"\<a\>\"", ",", "\"\<z\>\""}], "]"}], "\[Rule]", 
    "\"\<x\>\""}]}], "]"}]}], "Input",
 CellTags->"b:0.5.4",
 CellLabel->"In[117]:=",
 CellID->96850109],

Cell[BoxData["\<\"xxxx xxx xxxx\"\>"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.5.4",
 CellLabel->"Out[118]=",
 CellID->17256542]
}, Open  ]],

Cell[TextData[{
 "With the ",
 Cell[BoxData[
  RowBox[{"/", "d"}]], "InlineFormula"],
 " modifier, the surplus characters are instead deleted."
}], "Text",
 CellTags->"b:0.5.4",
 CellID->206615673],

Cell["\<\
$text = \"abcdefghi\";
$text =~ tr/abcdef/WXYZ/d\
\>", "Program",
 CellTags->"b:0.5.4",
 CellID->1448094],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"text", "=", "\"\<abcdefghi\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"StringReplace", "[", 
  RowBox[{"text", ",", 
   RowBox[{"Append", "[", 
    RowBox[{
     RowBox[{"Thread", "[", 
      RowBox[{"Rule", "[", 
       RowBox[{
        RowBox[{"Characters", "[", "\"\<abcd\>\"", "]"}], ",", 
        RowBox[{"Characters", "[", "\"\<WXYZ\>\"", "]"}]}], "]"}], "]"}], ",",
      
     RowBox[{
      RowBox[{"Characters", "[", "\"\<ef\>\"", "]"}], "\[Rule]", 
      "\"\<\>\""}]}], "]"}]}], "]"}]}], "Input",
 CellTags->"b:0.5.4",
 CellLabel->"In[119]:=",
 CellID->297013012],

Cell[BoxData["\<\"WXYZghi\"\>"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.5.4",
 CellLabel->"Out[120]=",
 CellID->16752287]
}, Open  ]],

Cell[TextData[{
 "With the ",
 Cell[BoxData[
  RowBox[{"/", "c"}]], "InlineFormula"],
 " modifier, the complement of the character list is used."
}], "Text",
 CellTags->"b:0.5.4",
 CellID->809943646],

Cell["$text =~ tr/aeh/ /c", "Program",
 CellTags->"b:0.5.4",
 CellID->727836643],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"text", ",", 
   RowBox[{
    RowBox[{"Except", "[", 
     RowBox[{"Characters", "[", "\"\<aeh\>\"", "]"}], "]"}], "\[Rule]", 
    "\"\< \>\""}]}], "]"}]], "Input",
 CellTags->"b:0.5.4",
 CellLabel->"In[121]:=",
 CellID->32783502],

Cell[BoxData["\<\"a   e  h \"\>"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.5.4",
 CellLabel->"Out[121]=",
 CellID->494744495]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"text", ",", 
   RowBox[{
    RowBox[{"RegularExpression", "[", "\"\<[^aeh]\>\"", "]"}], "\[Rule]", 
    "\"\< \>\""}]}], "]"}]], "Input",
 CellTags->"b:0.5.4",
 CellLabel->"In[122]:=",
 CellID->190461549],

Cell[BoxData["\<\"a   e  h \"\>"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.5.4",
 CellLabel->"Out[122]=",
 CellID->226552420]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  RowBox[{"/", "s"}]], "InlineFormula"],
 " modifier squeezes down to one any run of characters translating into the \
same character."
}], "Text",
 CellTags->"b:0.5.4",
 CellID->117673595],

Cell["\<\
$text = \"abbcccddddeeeeeeffeeded\";
$text =~ tr/abcde/ABCD/s\
\>", "Program",
 CellTags->"b:0.5.4",
 CellID->144624070],

Cell[TextData[{
 "You get the same effect in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " using ",
 Cell[BoxData[
  ButtonBox["Repeated",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Repeated"]], "InlineFormula"],
 " (",
 Cell[BoxData[".."], "InlineFormula"],
 ")."
}], "Text",
 CellTags->"b:0.5.4",
 CellID->688187582],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"text", "=", "\"\<abbcccddddeeeeeeffeeded\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"StringReplace", "[", 
  RowBox[{"text", ",", 
   RowBox[{"Append", "[", 
    RowBox[{
     RowBox[{"Thread", "[", 
      RowBox[{"Rule", "[", 
       RowBox[{
        RowBox[{"Repeated", "/@", 
         RowBox[{"Characters", "[", "\"\<abc\>\"", "]"}]}], ",", 
        RowBox[{"Characters", "[", "\"\<ABC\>\"", "]"}]}], "]"}], "]"}], ",", 
     
     RowBox[{
      RowBox[{
       RowBox[{"Characters", "[", "\"\<de\>\"", "]"}], ".."}], "\[Rule]", 
      "\"\<D\>\""}]}], "]"}]}], "]"}]}], "Input",
 CellTags->"b:0.5.4",
 CellLabel->"In[123]:=",
 CellID->141316627],

Cell[BoxData["\<\"ABCDffD\"\>"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.5.4",
 CellLabel->"Out[124]=",
 CellID->19380011]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Some Examples", "Section",
 CellTags->"c:20",
 CellID->2083974],

Cell["\<\
Some brief examples of practical uses of string patterns are presented in \
this section.\
\>", "Text",
 CellID->118415745],

Cell[CellGroupData[{

Cell["Highlight Patterns", "Subsection",
 CellTags->{"c:22", "b:0.6.1"},
 CellID->738873845],

Cell["This defines a 1000-base random DNA string.", "Text",
 CellTags->"b:0.6.1",
 CellID->24257838],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeedRandom", "[", "1234", "]"}], ";", 
  RowBox[{"dna", "=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "\"\<a\>\"", ",", "\"\<c\>\"", ",", "\"\<g\>\"", ",", "\"\<t\>\""}], 
        "}"}], "[", 
       RowBox[{"[", 
        RowBox[{"RandomInteger", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "4"}], "}"}], "]"}], "]"}], "]"}], ",", 
      RowBox[{"{", "1000", "}"}]}], "]"}], "]"}]}]}]], "Input",
 CellTags->"b:0.6.1",
 CellLabel->"In[131]:=",
 CellID->140406151],

Cell[BoxData["\<\"\
acaaccgccgcgaattctcacaaacgtcgagtgtgatatagaaaatcccagatcacactatagggtggaaaccaggtg\
atagttgcctctgccatgcatatgcgattaaatgttcgttgaatatgagtaaagaatctaagcgtagtttttatagta\
aagaccccgcgcctctgcgcgtgatagtgttaccgacgcatctcgatgttgtacatgtagcactgtacgtaatcatta\
tacgatttccataacgtaagctgggtaacagacctaacgtagggttcatctacgcgcttatcctccgacctaggattg\
cgtctagaaaactgaacaagtaaaccgtactcctttatccgccgacagtccagaacagtctgacttccagctacttaa\
tggtttcccagatttcctgcggaatacctcgaccgtgtggccattgctccaccaccgcaattcgcctcttctgcacag\
gtccacgcacgttttccctgagcataaaaacccagcaatacgaaaggttctctacacatcagcagcttcccgagtgac\
ctgattggggctgcgctataacgtcggtcgcgtttccatcaggacgcatgcagcgacgcctgcagcagcagtcccctt\
cacagcgtacagggctctggtaagggcagccagtttcgctaacggtcctgttgcttacatgcgcatacaattatgcca\
aacggacacgtgctatccagacgaggtgtcgtaaaggggatttctaagtgaccagaattactgtcagacgaccttaag\
atagtcaggctttcagcggtagataggcgggatgaatcgaaagcaatgacaaggcccggtcgccagagagacaggctt\
agtattcagtaagcagtagcgcgacatacccgaaactccgcgcgggtatagagtacatctactaggtgtgtatctgca\
gcacattagggctattcagaccgttaattccggcctgaggccatgccgacagaacaaattgcct\"\>"], \
"Output",
 ImageSize->{585, 220},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.6.1",
 CellLabel->"Out[131]=",
 CellID->138371101]
}, Open  ]],

Cell["\<\
This highlights parts of the DNA that match a certain pattern.\
\>", "Text",
 CellTags->"b:0.6.1",
 CellID->301369684],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"dna", ",", 
   RowBox[{
    RowBox[{"x", ":", 
     RowBox[{"(", 
      RowBox[{"\"\<ag\>\"", "~~", 
       RowBox[{"_", "~~", 
        RowBox[{"_", "~~", 
         RowBox[{"\"\<t\>\"", "~~", 
          RowBox[{"_", "~~", "\"\<ca\>\""}]}]}]}]}], ")"}]}], 
    "\[RuleDelayed]", 
    RowBox[{
    "\"\<\\!\\(\\*StyleBox[\\\"\>\"", "<>", "x", "<>", 
     "\"\<\\\",FontColor->RGBColor[1,0,0],FontSize->18,FontWeight->\\\"Bold\\\
\"]\\)\>\""}]}]}], "]"}]], "Input",
 CellTags->"b:0.6.1",
 CellLabel->"In[132]:=",
 CellID->614903007],

Cell[BoxData["\<\"\
acaaccgccgcgaattctcacaaacgtcgagtgtgatatagaaaatcccagatcacactatagggtggaaaccaggtg\
atagttgcctctgccatgcatatgcgattaaatgttcgttgaatatgagtaaagaatctaagcgtagtttttatagta\
aagaccccgcgcctctgcgcgtgatagtgttaccgacgcatctcgatgttgtacatgtagcactgtacgtaatcatta\
tacgatttccataacgtaagctgggtaacagacctaacgt\\!\\(\\*StyleBox[\\\"agggttca\\\",\
FontColor->RGBColor[1,0,0],FontSize->18,FontWeight->\\\"Bold\\\"]\\)\
tctacgcgcttatcctccgacctaggattgcgtctagaaaactgaacaagtaaaccgtactcctttatccgccgacag\
tccagaacagtctgacttccagctacttaatggtttcccagatttcctgcggaatacctcgaccgtgtggccattgct\
ccaccaccgcaattcgcctcttctgcacaggtccacgcacgttttccctgagcataaaaacccagcaatacgaaaggt\
tctctacacatcagcagcttcccgagtgacctgattggggctgcgctataacgtcggtcgcgtttccatcaggacgca\
tgcagcgacgcctgcagcagcagtccccttcac\\!\\(\\*StyleBox[\\\"agcgtaca\\\",FontColor-\
>RGBColor[1,0,0],FontSize->18,FontWeight->\\\"Bold\\\"]\\)\
gggctctggtaagggcagccagtttcgctaacggtcctgttgcttacatgcgcatacaattatgccaaacggacacgt\
gctatccagacgaggtgtcgtaaaggggatttctaagtgaccagaattactgtcagacgaccttaagatagtcaggct\
ttcagcggtagataggcgggatgaatcgaaagcaatgacaaggcccggtcgccagagagacaggctt\\!\\(\\*\
StyleBox[\\\"agtattca\\\",FontColor->RGBColor[1,0,0],FontSize->18,FontWeight->\
\\\"Bold\\\"]\\)gtaagcagtagcgcgacatacccgaaactccgcgcgggtat\\!\\(\\*StyleBox[\\\
\"agagtaca\\\",FontColor->RGBColor[1,0,0],FontSize->18,FontWeight->\\\"Bold\\\
\"]\\)tctactaggtgtgtatctgcagcacattagggctattcagaccgttaattccggcctgaggccatgccgaca\
gaacaaattgcct\"\>"], "Output",
 ImageSize->{589, 237},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.6.1",
 CellLabel->"Out[132]=",
 CellID->66298060]
}, Open  ]],

Cell["Here is the same result using a regular expression.", "Text",
 CellTags->"b:0.6.1",
 CellID->12939824],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"dna", ",", 
   RowBox[{
    RowBox[{"RegularExpression", "[", "\"\<ag..t.ca\>\"", "]"}], 
    "\[RuleDelayed]", 
    "\"\<\\!\\(\\*StyleBox[\\\"$0\\\",FontColor->RGBColor[1,0,0],FontSize->18,\
FontWeight->\\\"Bold\\\"]\\)\>\""}]}], "]"}]], "Input",
 CellTags->"b:0.6.1",
 CellLabel->"In[133]:=",
 CellID->131627168],

Cell[BoxData["\<\"\
acaaccgccgcgaattctcacaaacgtcgagtgtgatatagaaaatcccagatcacactatagggtggaaaccaggtg\
atagttgcctctgccatgcatatgcgattaaatgttcgttgaatatgagtaaagaatctaagcgtagtttttatagta\
aagaccccgcgcctctgcgcgtgatagtgttaccgacgcatctcgatgttgtacatgtagcactgtacgtaatcatta\
tacgatttccataacgtaagctgggtaacagacctaacgt\\!\\(\\*StyleBox[\\\"agggttca\\\",\
FontColor->RGBColor[1,0,0],FontSize->18,FontWeight->\\\"Bold\\\"]\\)\
tctacgcgcttatcctccgacctaggattgcgtctagaaaactgaacaagtaaaccgtactcctttatccgccgacag\
tccagaacagtctgacttccagctacttaatggtttcccagatttcctgcggaatacctcgaccgtgtggccattgct\
ccaccaccgcaattcgcctcttctgcacaggtccacgcacgttttccctgagcataaaaacccagcaatacgaaaggt\
tctctacacatcagcagcttcccgagtgacctgattggggctgcgctataacgtcggtcgcgtttccatcaggacgca\
tgcagcgacgcctgcagcagcagtccccttcac\\!\\(\\*StyleBox[\\\"agcgtaca\\\",FontColor-\
>RGBColor[1,0,0],FontSize->18,FontWeight->\\\"Bold\\\"]\\)\
gggctctggtaagggcagccagtttcgctaacggtcctgttgcttacatgcgcatacaattatgccaaacggacacgt\
gctatccagacgaggtgtcgtaaaggggatttctaagtgaccagaattactgtcagacgaccttaagatagtcaggct\
ttcagcggtagataggcgggatgaatcgaaagcaatgacaaggcccggtcgccagagagacaggctt\\!\\(\\*\
StyleBox[\\\"agtattca\\\",FontColor->RGBColor[1,0,0],FontSize->18,FontWeight->\
\\\"Bold\\\"]\\)gtaagcagtagcgcgacatacccgaaactccgcgcgggtat\\!\\(\\*StyleBox[\\\
\"agagtaca\\\",FontColor->RGBColor[1,0,0],FontSize->18,FontWeight->\\\"Bold\\\
\"]\\)tctactaggtgtgtatctgcagcacattagggctattcagaccgttaattccggcctgaggccatgccgaca\
gaacaaattgcct\"\>"], "Output",
 ImageSize->{589, 237},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.6.1",
 CellLabel->"Out[133]=",
 CellID->174902817]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["HTML Parsing", "Subsection",
 CellTags->{"c:23", "b:0.6.2"},
 CellID->146223979],

Cell["\<\
String patterns are useful for taking raw HTML and extracting information \
from it.\
\>", "Text",
 CellTags->"b:0.6.2",
 CellID->454604247],

Cell[TextData[{
 "Here is the source from ",
 ButtonBox["www.google.com",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.google.com"], None}],
 "."
}], "Text",
 CellTags->"b:0.6.2",
 CellID->450806450],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "text", "=", 
   "\"\<\\<<html><head><meta http-equiv='content-type' \
content='text/html;charset=UTF-8'><title>Google</title><style><!--body,td,a,p,\
.h{font-family:arial,sans-serif;}\n.h{font-size:20px;}\n.q{color:#0000cc;}\n\
//-->\[IndentingNewLine]</style>\[IndentingNewLine]<script>\[IndentingNewLine]\
<!--function sf(){document.f.q.focus();}\n//-->\[IndentingNewLine]</script>\
\[IndentingNewLine]</head><body bgcolor=#ffffff text=#000000 link=#0000cc \
vlink=#551a8b alink=#ff0000 onLoad=sf()><center><table border=0 cellspacing=0 \
cellpadding=0><tr><td><img src='/images/logo.gif' width=276 height=110 \
alt='Google'></td></tr></table><br>\[IndentingNewLine]<form action='/search' \
name=f><script><!--function qs(el) {if \
(window.RegExp&&window.encodeURIComponent) {var \
qe=encodeURIComponent(document.f.q.value);if \
(el.href.indexOf('q=')\[NotEqual]-1) {el.href=el.href.replace(new \
RegExp('q=[^&$]*'),'q='+qe);} else {el.href+='&q='+qe;}}return 1;}\n//-->\
\[IndentingNewLine]</script><table border=0 cellspacing=0 \
cellpadding=4><tr><td nowrap class=q><font size=-1><b><font \
color=#000000>Web</font></b>&nbsp;&nbsp;&nbsp;&nbsp;<a id=1a class=q \
href='/imghp?hl=en&tab=wi' onClick='return \
qs(this);'>Images</a>&nbsp;&nbsp;&nbsp;&nbsp;<a id=2a class=q \
href='/grphp?hl=en&tab=wg' onClick='return \
qs(this);'>Groups</a>&nbsp;&nbsp;&nbsp;&nbsp;<a id=4a class=q \
href='/nwshp?hl=en&tab=wn' onClick='return \
qs(this);'>News</a>&nbsp;&nbsp;&nbsp;&nbsp;<a id=5a class=q \
href='/froogle?hl=en&tab=wf' onClick='return \
qs(this);'>Froogle</a>&nbsp;&nbsp;&nbsp;&nbsp;<b><a \
href='/options/index.html' \
class=q>more&nbsp;&raquo;</a></b></font></td></tr></table>  <table \
cellspacing=0 cellpadding=0><tr><td width=25%>&nbsp;</td><td \
align=center><input type=hidden name=hl value=en><span id=hf></span><input \
type=hidden name=ie value='UTF-8'><input maxLength=256 size=55 name=q \
value=''><br><input type=submit value='Google Search' name=btnG><input \
type=submit value='I'm Feeling Lucky' name=btnI></td><td valign=top nowrap \
width=25%><font size=-2>&nbsp;&nbsp;<a \
href=/advanced_search?hl=en>Advanced&nbsp;Search</a><br>&nbsp;&nbsp;<a \
href=/preferences?hl=en>Preferences</a><br>&nbsp;&nbsp;<a \
href=/language_tools?hl=en>Language \
Tools</a></font></td></tr></table></form><br><br><font size=-1><a \
href='/ads/'>Advertising&nbsp;Programs</a>- <a \
href='/services/'>Business&nbsp;Solutions</a>- <a href=/about.html>About \
Google</a><span id=hp style='behavior:url(#default#homepage)'></span>\
\[IndentingNewLine]<script>\[IndentingNewLine]//<!--if \
(!hp.isHomePage('http://www.google.com/')) {document.write('<p><a \
href=\\'/mgyhp.html\\' \
onClick=\\'style.behavior='url(#default#homepage)';setHomePage('http://www.\
google.com/');\\'>Make Google Your Homepage!</a>');}\n\
//-->\[IndentingNewLine]</script></font><p><font size=-2>&copy;2004 \
Google-Searching 4,285,199,774 web pages</font></p></center></body></html>\\>\
\>\""}], ";"}]], "Input",
 CellTags->"b:0.6.2",
 CellLabel->"In[134]:=",
 CellID->237894310],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringLength", "[", "text", "]"}]], "Input",
 CellTags->"b:0.6.2",
 CellLabel->"In[135]:=",
 CellID->73854272],

Cell[BoxData["2639"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.6.2",
 CellLabel->"Out[135]=",
 CellID->17257751]
}, Open  ]],

Cell["This extracts all the direct hyperlinks in the source.", "Text",
 CellTags->"b:0.6.2",
 CellID->328231447],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"text", ",", 
   RowBox[{
    RowBox[{"Shortest", "[", 
     RowBox[{"\"\<<a\>\"", "~~", 
      RowBox[{"__", "~~", 
       RowBox[{"\"\<href=\>\"", "~~", 
        RowBox[{"ref__", "~~", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"WhitespaceCharacter", "|", "\"\<>\>\""}], ")"}], "~~", 
          RowBox[{"___", "~~", "\"\<>\>\""}]}]}]}]}]}], "]"}], 
    "\[RuleDelayed]", "ref"}]}], "]"}]], "Input",
 CellTags->"b:0.6.2",
 CellLabel->"In[136]:=",
 CellID->10965036],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"'/imghp?hl=en&tab=wi'\"\>", 
   ",", "\<\"'/grphp?hl=en&tab=wg'\"\>", ",", "\<\"'/nwshp?hl=en&tab=wn'\"\>",
    ",", "\<\"'/froogle?hl=en&tab=wf'\"\>", 
   ",", "\<\"'/options/index.html'\"\>", 
   ",", "\<\"/advanced_search?hl=en\"\>", ",", "\<\"/preferences?hl=en\"\>", 
   ",", "\<\"/language_tools?hl=en\"\>", ",", "\<\"'/ads/'\"\>", 
   ",", "\<\"'/services/'\"\>", ",", "\<\"/about.html\"\>", 
   ",", "\<\"\\\\'/mgyhp.html\\\\'\"\>"}], "}"}]], "Output",
 ImageSize->{496, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.6.2",
 CellLabel->"Out[136]=",
 CellID->141092163]
}, Open  ]],

Cell[TextData[{
 "This deletes everything inside tags ",
 StyleBox["<...>", "MR"],
 "."
}], "Text",
 CellTags->"b:0.6.2",
 CellID->135521350],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"text", ",", 
   RowBox[{
    RowBox[{"Shortest", "[", 
     RowBox[{"\"\<<\>\"", "~~", "___", "~~", "\"\<>\>\""}], "]"}], "\[Rule]", 
    "\"\<\>\""}]}], "]"}]], "Input",
 CellTags->"b:0.6.2",
 CellLabel->"In[137]:=",
 CellID->499683580],

Cell[BoxData["\<\"Google\[IndentingNewLine]\[IndentingNewLine]\
\[IndentingNewLine]\[IndentingNewLine]\[IndentingNewLine]\[IndentingNewLine]\
\[IndentingNewLine]Web&nbsp;&nbsp;&nbsp;&nbsp;Images&nbsp;&nbsp;&nbsp;&nbsp;\
Groups&nbsp;&nbsp;&nbsp;&nbsp;News&nbsp;&nbsp;&nbsp;&nbsp;Froogle&nbsp;&nbsp;&\
nbsp;&nbsp;more&nbsp;&raquo;  \
&nbsp;&nbsp;&nbsp;Advanced&nbsp;Search&nbsp;&nbsp;Preferences&nbsp;&nbsp;\
Language ToolsAdvertising&nbsp;Programs- Business&nbsp;Solutions- About \
Google\[IndentingNewLine]\[IndentingNewLine]//Make Google Your \
Homepage!');}\\n//-->\[IndentingNewLine]&copy;2004 Google-Searching \
4,285,199,774 web pages\"\>"], "Output",
 ImageSize->{585, 271},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.6.2",
 CellLabel->"Out[137]=",
 CellID->408181342]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Find Money", "Subsection",
 CellTags->{"c:24", "b:0.6.3"},
 CellID->263221749],

Cell["\<\
Here is some text to scan for strings that look like dollar amounts.\
\>", "Text",
 CellTags->"b:0.6.3",
 CellID->456762081],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"text", "=", 
  "\"\<This $100 sentence can be bought for $85.00, at 15% discount\>\""}]], \
"Input",
 CellTags->"b:0.6.3",
 CellLabel->"In[138]:=",
 CellID->324262933],

Cell[BoxData["\<\"This $100 sentence can be bought for $85.00, at 15% \
discount\"\>"], "Output",
 ImageSize->{424, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.6.3",
 CellLabel->"Out[138]=",
 CellID->129687686]
}, Open  ]],

Cell["\<\
This is one way to do the search using symbolic string patterns.\
\>", "Text",
 CellTags->"b:0.6.3",
 CellID->47750368],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"text", ",", 
   RowBox[{"\"\<$\>\"", "~~", 
    RowBox[{
     RowBox[{"DigitCharacter", ".."}], "~~", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"\"\<.\>\"", "~~", 
         RowBox[{"DigitCharacter", ".."}]}], ")"}], "|", "\"\<\>\""}], 
      ")"}]}]}]}], "]"}]], "Input",
 CellTags->"b:0.6.3",
 CellLabel->"In[139]:=",
 CellID->16455114],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"$100\"\>", ",", "\<\"$85.00\"\>"}], "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.6.3",
 CellLabel->"Out[139]=",
 CellID->338551607]
}, Open  ]],

Cell["\<\
Here is the same search using regular expressions (note that you must \
remember to escape the dollar sign).\
\>", "Text",
 CellTags->"b:0.6.3",
 CellID->507462346],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"text", ",", 
   RowBox[{
   "RegularExpression", "[", "\"\<\\\\$\\\\d+(\\.\\\\d+)?\>\"", "]"}]}], 
  "]"}]], "Input",
 CellTags->"b:0.6.3",
 CellLabel->"In[140]:=",
 CellID->28199983],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"$100\"\>", ",", "\<\"$85.00\"\>"}], "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.6.3",
 CellLabel->"Out[140]=",
 CellID->388857756]
}, Open  ]],

Cell[TextData[{
 "There is also a built-in pattern object, ",
 Cell[BoxData[
  ButtonBox["NumberString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberString"]], "InlineFormula"],
 ", for this particular situation."
}], "Text",
 CellTags->"b:0.6.3",
 CellID->1024052339],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"text", ",", 
   RowBox[{"\"\<$\>\"", "~~", "NumberString"}]}], "]"}]], "Input",
 CellTags->"b:0.6.3",
 CellLabel->"In[141]:=",
 CellID->5891025],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"$100\"\>", ",", "\<\"$85.00\"\>"}], "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.6.3",
 CellLabel->"Out[141]=",
 CellID->209255404]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Find Text in Files", "Subsection",
 CellTags->"b:0.6.4",
 CellID->355263806],

Cell["\<\
Here is a very simple grep-like function for finding lines in a text file \
containing text matching a given pattern.\
\>", "Text",
 CellTags->"b:0.6.4",
 CellID->115242927],

Cell[BoxData[
 RowBox[{
  RowBox[{"Grep", "[", 
   RowBox[{"file_", ",", "patt_"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"data", "=", 
      RowBox[{"Import", "[", 
       RowBox[{"file", ",", "\"\<Lines\>\""}], "]"}]}], "}"}], ",", 
    RowBox[{"Pick", "[", 
     RowBox[{
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Range", "[", 
          RowBox[{"Length", "[", "data", "]"}], "]"}], ",", "data"}], "}"}], 
       "]"}], ",", 
      RowBox[{"StringFreeQ", "[", 
       RowBox[{"data", ",", " ", "patt"}], "]"}], ",", "False"}], "]"}]}], 
   "]"}]}]], "Input",
 CellTags->"b:0.6.4",
 CellLabel->"In[142]:=",
 CellID->78571466],

Cell["This creates a sample text file.", "Text",
 CellTags->"b:0.6.4",
 CellID->97869725],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<test.txt\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
    "\"\<this is a line\>\"", ",", "\"\<a line with 2 numbers 5\>\"", ",", 
     "\"\<third line and more\>\"", ",", "\"\<line 4\>\""}], "}"}], ",", 
   "\"\<Lines\>\""}], "]"}]], "Input",
 CellTags->"b:0.6.4",
 CellLabel->"In[143]:=",
 CellID->46155371],

Cell[BoxData["\<\"test.txt\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.6.4",
 CellLabel->"Out[143]=",
 CellID->231537702]
}, Open  ]],

Cell[TextData[{
 "This returns the line numbers and lines in ",
 StyleBox["\"text.txt\"", "MR"],
 " containing any digit characters."
}], "Text",
 CellTags->"b:0.6.4",
 CellID->252811811],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Grep", "[", 
   RowBox[{"\"\<test.txt\>\"", ",", "DigitCharacter"}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellTags->"b:0.6.4",
 CellLabel->"In[144]:=",
 CellID->580624370],

Cell[BoxData[
 TagBox[GridBox[{
    {"2", "\<\"a line with 2 numbers 5\"\>"},
    {"4", "\<\"line 4\"\>"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[0.7]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{180, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.6.4",
 CellLabel->"Out[144]//TableForm=",
 CellID->513917472]
}, Open  ]],

Cell[TextData[{
 "This finds lines containing ",
 StyleBox["\"a\"", "MR"],
 " as a stand-alone word."
}], "Text",
 CellTags->"b:0.6.4",
 CellID->612266699],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Grep", "[", 
   RowBox[{"\"\<test.txt\>\"", ",", 
    RowBox[{"RegularExpression", "[", "\"\<\\\\ba\\\\b\>\"", "]"}]}], "]"}], "//",
   "TableForm"}]], "Input",
 CellTags->"b:0.6.4",
 CellLabel->"In[145]:=",
 CellID->28035752],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "\<\"this is a line\"\>"},
    {"2", "\<\"a line with 2 numbers 5\"\>"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[0.7]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{180, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.6.4",
 CellLabel->"Out[145]//TableForm=",
 CellID->449106445]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tips and Tricks for Efficient Matching", "Section",
 CellTags->{"c:25", "Tips and Tricks", "b:0.7"},
 CellID->319138910],

Cell["\<\
This section addresses some issues involving efficiency in string pattern \
matching.\
\>", "Text",
 CellTags->"b:0.7",
 CellID->1088522],

Cell[CellGroupData[{

Cell["StringExpression versus RegularExpression", "Subsection",
 CellTags->{"c:26", "b:0.7"},
 CellID->571253149],

Cell[TextData[{
 "Since a string pattern written in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " syntax is immediately translated to a regular expression and then compiled \
and cached, there is very little overhead in using the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " syntax as opposed to the regular expression syntax directly. An exception \
to this happens when many different patterns are used a few times, in that \
case the overhead might be noticeable."
}], "Text",
 CellTags->"b:0.7",
 CellID->527245798]
}, Open  ]],

Cell[CellGroupData[{

Cell["Conditions and PatternTests", "Subsection",
 CellTags->{"c:27", "b:0.7"},
 CellID->11710184],

Cell[TextData[{
 "If a pattern contains ",
 Cell[BoxData[
  ButtonBox["Condition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Condition"]], "InlineFormula"],
 " (",
 Cell[BoxData["/;"], "InlineFormula"],
 ") or ",
 Cell[BoxData[
  ButtonBox["PatternTest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PatternTest"]], "InlineFormula"],
 " (",
 Cell[BoxData["?"], "InlineFormula"],
 ") statements, the general ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " evaluator must be invoked during the match, thus slowing it down. If a \
pattern can be written without such constructs, it will typically be faster."
}], "Text",
 CellTags->"b:0.7",
 CellID->168089851],

Cell[BoxData[
 RowBox[{
  RowBox[{"SeedRandom", "[", "1234", "]"}], ";", 
  RowBox[{"test", "=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"FromCharacterCode", "[", 
       RowBox[{"RandomInteger", "[", 
        RowBox[{"{", 
         RowBox[{"48", ",", "80"}], "}"}], "]"}], "]"}], ",", 
      RowBox[{"{", "200", "}"}]}], "]"}], "]"}]}], ";"}]], "Input",
 CellTags->"b:0.7",
 CellLabel->"In[146]:=",
 CellID->45298985],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"StringCases", "[", 
    RowBox[{"test", ",", 
     RowBox[{"DigitCharacter", ".."}]}], "]"}], "//", "Length"}], "//", 
  "Timing"}]], "Input",
 CellTags->"b:0.7",
 CellLabel->"In[147]:=",
 CellID->334473682],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.`", " ", "Second"}], ",", "45"}], "}"}]], "Output",
 ImageSize->{103, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.7",
 CellLabel->"Out[147]=",
 CellID->136821287]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"StringCases", "[", 
    RowBox[{"test", ",", 
     RowBox[{"__", "?", "DigitQ"}]}], "]"}], "//", "Length"}], "//", 
  "Timing"}]], "Input",
 CellTags->"b:0.7",
 CellLabel->"In[148]:=",
 CellID->108146462],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.030000000000000027`", " ", "Second"}], ",", "45"}], 
  "}"}]], "Output",
 ImageSize->{117, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.7",
 CellLabel->"Out[148]=",
 CellID->152242574]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Avoid Nested Quantifiers", "Subsection",
 CellTags->{"c:28", "b:0.7"},
 CellID->39608680],

Cell[TextData[{
 "Because of the nondeterministic finite automaton (NFA) algorithm used in \
the match, patterns involving nested quantifiers (such as ",
 Cell[BoxData["__"], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"patt", ".."}]], "InlineFormula"],
 " or the regular expression equivalents) can become arbitrarily slow. Such \
patterns can usually be \[OpenCurlyDoubleQuote]unrolled\
\[CloseCurlyDoubleQuote] into more efficient versions (see Friedl ",
 ButtonBox["[2]",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/WorkingWithStringPatterns#201956504"],
 " for additional information)."
}], "Text",
 CellTags->"b:0.7",
 CellID->350158018]
}, Open  ]],

Cell[CellGroupData[{

Cell["Avoid Many Calls to a Function", "Subsection",
 CellTags->{"c:29", "b:0.7"},
 CellID->73358011],

Cell[TextData[{
 "If you are searching through a long list of strings for certain matches, it \
is more efficient to feed the whole list to a string function at once, rather \
than using something like ",
 Cell[BoxData[
  ButtonBox["Select",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Select"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["StringMatchQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringMatchQ"]], "InlineFormula"],
 " (see the earlier dictionary example for an illustration). Here is another \
example that generates a list of 2000 strings with 10 characters each and \
searches for the strings that start with an ",
 Cell[BoxData["\"\<a\>\""], "InlineFormula"],
 " and contain ",
 Cell[BoxData["\"\<ggg\>\""], "InlineFormula"],
 " as a substring."
}], "Text",
 CellTags->"b:0.7",
 CellID->274569970],

Cell[BoxData[
 RowBox[{
  RowBox[{"SeedRandom", "[", "1234", "]"}], ";", 
  RowBox[{"test", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "\"\<a\>\"", ",", "\"\<c\>\"", ",", "\"\<g\>\"", ",", "\"\<t\>\""}],
           "}"}], "[", 
         RowBox[{"[", "#", "]"}], "]"}], "&"}], "/@", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"RandomInteger", "[", 
          RowBox[{"{", 
           RowBox[{"1", ",", "4"}], "}"}], "]"}], ",", 
         RowBox[{"{", "10", "}"}]}], "]"}]}], "]"}], ",", 
     RowBox[{"{", "2000", "}"}]}], "]"}]}], ";"}]], "Input",
 CellTags->"b:0.7",
 CellLabel->"In[149]:=",
 CellID->88405937],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{"test", ",", "3"}], "]"}]], "Input",
 CellTags->"b:0.7",
 CellLabel->"In[150]:=",
 CellID->171329605],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"acaaccgccg\"\>", ",", "\<\"cgaattctca\"\>", 
   ",", "\<\"caaacgtcga\"\>"}], "}"}]], "Output",
 ImageSize->{251, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.7",
 CellLabel->"Out[150]=",
 CellID->85423907]
}, Open  ]],

Cell[TextData[{
 "Here is the slower version, using ",
 Cell[BoxData[
  ButtonBox["Select",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Select"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["StringMatchQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringMatchQ"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.7",
 CellID->482988001],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Select", "[", 
   RowBox[{"test", ",", 
    RowBox[{
     RowBox[{"StringMatchQ", "[", 
      RowBox[{"#", ",", 
       RowBox[{"\"\<a\>\"", "~~", 
        RowBox[{"___", "~~", 
         RowBox[{"\"\<ggg\>\"", "~~", "___"}]}]}]}], "]"}], "&"}]}], "]"}], "//",
   "Timing"}]], "Input",
 CellTags->"b:0.7",
 CellLabel->"In[151]:=",
 CellID->235104226],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.010000000000000009`", " ", "Second"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"acgtagggtt\"\>", ",", "\<\"attagggcta\"\>", 
     ",", "\<\"atagggctct\"\>", ",", "\<\"aagggccgtc\"\>", 
     ",", "\<\"agtgttaggg\"\>", ",", "\<\"aggggtggca\"\>", 
     ",", "\<\"aggggcggag\"\>", ",", "\<\"agcgggactc\"\>", 
     ",", "\<\"acagagggtg\"\>", ",", "\<\"atgggacatc\"\>", 
     ",", "\<\"agggataaga\"\>", ",", "\<\"accacgggct\"\>", 
     ",", "\<\"aaaagggcat\"\>", ",", "\<\"agtaagggac\"\>", 
     ",", "\<\"agggtagtta\"\>", ",", "\<\"agctacgggc\"\>", 
     ",", "\<\"ataagccggg\"\>", ",", "\<\"atagggagaa\"\>", 
     ",", "\<\"acttgatggg\"\>", ",", "\<\"acagtgaggg\"\>", 
     ",", "\<\"agggcaggga\"\>", ",", "\<\"agggttctag\"\>", 
     ",", "\<\"agaggggaac\"\>", ",", "\<\"atgcagggat\"\>", 
     ",", "\<\"atcgtagggc\"\>", ",", "\<\"aggggaagct\"\>", 
     ",", "\<\"agtggggctg\"\>", ",", "\<\"aaacaaggga\"\>", 
     ",", "\<\"aagtgggatg\"\>", ",", "\<\"aagagggaat\"\>", 
     ",", "\<\"agggacggag\"\>", ",", "\<\"attcgggagc\"\>", 
     ",", "\<\"aataactggg\"\>", ",", "\<\"agggcgccca\"\>", 
     ",", "\<\"agaggggatt\"\>", ",", "\<\"agggacgaag\"\>", 
     ",", "\<\"aagggatatt\"\>", ",", "\<\"agggcaggtg\"\>", 
     ",", "\<\"agaacgggta\"\>", ",", "\<\"aattgggtct\"\>", 
     ",", "\<\"agcgggtagg\"\>", ",", "\<\"actcgggccc\"\>", 
     ",", "\<\"agggcctcct\"\>", ",", "\<\"aagggagggg\"\>", 
     ",", "\<\"aagggcatgt\"\>", ",", "\<\"aagttgaggg\"\>", 
     ",", "\<\"aaaacggggt\"\>", ",", "\<\"agagggcgta\"\>", 
     ",", "\<\"aagtctaggg\"\>", ",", "\<\"agggagcgtc\"\>"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{586, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.7",
 CellLabel->"Out[151]=",
 CellID->92602603]
}, Open  ]],

Cell[TextData[{
 "If you instead feed the whole list to ",
 Cell[BoxData[
  ButtonBox["StringMatchQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringMatchQ"]], "InlineFormula"],
 " at once, it will be much faster. Then ",
 Cell[BoxData[
  ButtonBox["Pick",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pick"]], "InlineFormula"],
 " can be used to extract the wanted elements."
}], "Text",
 CellTags->"b:0.7",
 CellID->940575378],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Pick", "[", 
   RowBox[{"test", ",", 
    RowBox[{"StringMatchQ", "[", 
     RowBox[{"test", ",", 
      RowBox[{"\"\<a\>\"", "~~", 
       RowBox[{"___", "~~", 
        RowBox[{"\"\<ggg\>\"", "~~", "___"}]}]}]}], "]"}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellTags->"b:0.7",
 CellLabel->"In[152]:=",
 CellID->159751616],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.`", " ", "Second"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"acgtagggtt\"\>", ",", "\<\"attagggcta\"\>", 
     ",", "\<\"atagggctct\"\>", ",", "\<\"aagggccgtc\"\>", 
     ",", "\<\"agtgttaggg\"\>", ",", "\<\"aggggtggca\"\>", 
     ",", "\<\"aggggcggag\"\>", ",", "\<\"agcgggactc\"\>", 
     ",", "\<\"acagagggtg\"\>", ",", "\<\"atgggacatc\"\>", 
     ",", "\<\"agggataaga\"\>", ",", "\<\"accacgggct\"\>", 
     ",", "\<\"aaaagggcat\"\>", ",", "\<\"agtaagggac\"\>", 
     ",", "\<\"agggtagtta\"\>", ",", "\<\"agctacgggc\"\>", 
     ",", "\<\"ataagccggg\"\>", ",", "\<\"atagggagaa\"\>", 
     ",", "\<\"acttgatggg\"\>", ",", "\<\"acagtgaggg\"\>", 
     ",", "\<\"agggcaggga\"\>", ",", "\<\"agggttctag\"\>", 
     ",", "\<\"agaggggaac\"\>", ",", "\<\"atgcagggat\"\>", 
     ",", "\<\"atcgtagggc\"\>", ",", "\<\"aggggaagct\"\>", 
     ",", "\<\"agtggggctg\"\>", ",", "\<\"aaacaaggga\"\>", 
     ",", "\<\"aagtgggatg\"\>", ",", "\<\"aagagggaat\"\>", 
     ",", "\<\"agggacggag\"\>", ",", "\<\"attcgggagc\"\>", 
     ",", "\<\"aataactggg\"\>", ",", "\<\"agggcgccca\"\>", 
     ",", "\<\"agaggggatt\"\>", ",", "\<\"agggacgaag\"\>", 
     ",", "\<\"aagggatatt\"\>", ",", "\<\"agggcaggtg\"\>", 
     ",", "\<\"agaacgggta\"\>", ",", "\<\"aattgggtct\"\>", 
     ",", "\<\"agcgggtagg\"\>", ",", "\<\"actcgggccc\"\>", 
     ",", "\<\"agggcctcct\"\>", ",", "\<\"aagggagggg\"\>", 
     ",", "\<\"aagggcatgt\"\>", ",", "\<\"aagttgaggg\"\>", 
     ",", "\<\"aaaacggggt\"\>", ",", "\<\"agagggcgta\"\>", 
     ",", "\<\"aagtctaggg\"\>", ",", "\<\"agggagcgtc\"\>"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{583, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.7",
 CellLabel->"Out[152]=",
 CellID->122373159]
}, Open  ]],

Cell[TextData[{
 "Alternatively, you could use ",
 Cell[BoxData[
  ButtonBox["StringCases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringCases"]], "InlineFormula"],
 ", which is also fast. Note that you need to anchor the pattern using ",
 Cell[BoxData[
  ButtonBox["StartOfString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StartOfString"]], "InlineFormula"],
 " to ensure that the ",
 Cell[BoxData["\"\<a\>\""], "InlineFormula"],
 " is at the start (the ",
 Cell[BoxData[
  ButtonBox["EndOfString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EndOfString"]], "InlineFormula"],
 " is superfluous in this particular case). "
}], "Text",
 CellTags->"b:0.7",
 CellID->440945305],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Flatten", "[", 
   RowBox[{"StringCases", "[", 
    RowBox[{"test", ",", 
     RowBox[{"StartOfString", "~~", 
      RowBox[{"\"\<a\>\"", "~~", 
       RowBox[{"___", "~~", 
        RowBox[{"\"\<ggg\>\"", "~~", 
         RowBox[{"___", "~~", "EndOfString"}]}]}]}]}]}], "]"}], "]"}], "//", 
  "Timing"}]], "Input",
 CellTags->"b:0.7",
 CellLabel->"In[153]:=",
 CellID->344941105],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.`", " ", "Second"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"acgtagggtt\"\>", ",", "\<\"attagggcta\"\>", 
     ",", "\<\"atagggctct\"\>", ",", "\<\"aagggccgtc\"\>", 
     ",", "\<\"agtgttaggg\"\>", ",", "\<\"aggggtggca\"\>", 
     ",", "\<\"aggggcggag\"\>", ",", "\<\"agcgggactc\"\>", 
     ",", "\<\"acagagggtg\"\>", ",", "\<\"atgggacatc\"\>", 
     ",", "\<\"agggataaga\"\>", ",", "\<\"accacgggct\"\>", 
     ",", "\<\"aaaagggcat\"\>", ",", "\<\"agtaagggac\"\>", 
     ",", "\<\"agggtagtta\"\>", ",", "\<\"agctacgggc\"\>", 
     ",", "\<\"ataagccggg\"\>", ",", "\<\"atagggagaa\"\>", 
     ",", "\<\"acttgatggg\"\>", ",", "\<\"acagtgaggg\"\>", 
     ",", "\<\"agggcaggga\"\>", ",", "\<\"agggttctag\"\>", 
     ",", "\<\"agaggggaac\"\>", ",", "\<\"atgcagggat\"\>", 
     ",", "\<\"atcgtagggc\"\>", ",", "\<\"aggggaagct\"\>", 
     ",", "\<\"agtggggctg\"\>", ",", "\<\"aaacaaggga\"\>", 
     ",", "\<\"aagtgggatg\"\>", ",", "\<\"aagagggaat\"\>", 
     ",", "\<\"agggacggag\"\>", ",", "\<\"attcgggagc\"\>", 
     ",", "\<\"aataactggg\"\>", ",", "\<\"agggcgccca\"\>", 
     ",", "\<\"agaggggatt\"\>", ",", "\<\"agggacgaag\"\>", 
     ",", "\<\"aagggatatt\"\>", ",", "\<\"agggcaggtg\"\>", 
     ",", "\<\"agaacgggta\"\>", ",", "\<\"aattgggtct\"\>", 
     ",", "\<\"agcgggtagg\"\>", ",", "\<\"actcgggccc\"\>", 
     ",", "\<\"agggcctcct\"\>", ",", "\<\"aagggagggg\"\>", 
     ",", "\<\"aagggcatgt\"\>", ",", "\<\"aagttgaggg\"\>", 
     ",", "\<\"aaaacggggt\"\>", ",", "\<\"agagggcgta\"\>", 
     ",", "\<\"aagtctaggg\"\>", ",", "\<\"agggagcgtc\"\>"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{583, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.7",
 CellLabel->"Out[153]=",
 CellID->52135009]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Rewrite General Expression Searches as String Searches", "Subsection",
 CellTags->{"c:30", "b:0.7"},
 CellID->148652143],

Cell[TextData[{
 "Because the string matching algorithm is different than the algorithm ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses for general expression matching (string matching can assume a finite \
alphabet and a flat structure, for instance), there are cases where it is \
advantageous to translate a normal expression-matching problem to a \
string-matching problem. A typical case is matching a long list of symbols \
against a pattern involving several occurrences of ",
 Cell[BoxData["__"], "InlineFormula"],
 " and ",
 Cell[BoxData["___"], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.7",
 CellID->13332812],

Cell["\<\
As an example, assume you want to find primes (after prime number 1000000, \
say) that have at least four identical digits. Using ordinary pattern \
matching, it could be accomplished like this.\
\>", "Text",
 CellTags->"b:0.7",
 CellID->349310128],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Select", "[", 
   RowBox[{
    RowBox[{"Array", "[", 
     RowBox[{"Prime", ",", "1000", ",", "1000000"}], "]"}], ",", 
    RowBox[{
     RowBox[{"MatchQ", "[", 
      RowBox[{
       RowBox[{"IntegerDigits", "[", "#", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "___", ",", "x_", ",", "___", ",", "x_", ",", "___", ",", "x_", ",", 
         "___", ",", "x_", ",", "___"}], "}"}]}], "]"}], "&"}]}], "]"}], "//",
   "Timing"}]], "Input",
 CellTags->"b:0.7",
 CellLabel->"In[154]:=",
 CellID->34682433],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.16000000000000003`", " ", "Second"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "15488881", ",", "15491117", ",", "15491171", ",", "15491711", ",", 
     "15493333", ",", "15493999", ",", "15496111", ",", "15499111", ",", 
     "15499199", ",", "15499399", ",", "15499499", ",", "15499919", ",", 
     "15499997", ",", "15500557", ",", "15501119", ",", "15501121", ",", 
     "15501151", ",", "15501553", ",", "15501559", ",", "15501911", ",", 
     "15502111"}], "}"}]}], "}"}]], "Output",
 ImageSize->{586, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.7",
 CellLabel->"Out[154]=",
 CellID->228226476]
}, Open  ]],

Cell["\<\
By converting the list of integers to a string, you can use string matching \
instead.\
\>", "Text",
 CellTags->"b:0.7",
 CellID->19330986],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Select", "[", 
   RowBox[{
    RowBox[{"Array", "[", 
     RowBox[{"Prime", ",", "1000", ",", "1000000"}], "]"}], ",", 
    RowBox[{
     RowBox[{"StringMatchQ", "[", 
      RowBox[{
       RowBox[{"FromCharacterCode", "[", 
        RowBox[{"48", "+", 
         RowBox[{"IntegerDigits", "[", "#", "]"}]}], "]"}], ",", 
       RowBox[{"StringExpression", "[", 
        RowBox[{
        "___", ",", "x_", ",", "___", ",", "x_", ",", "___", ",", "x_", ",", 
         "___", ",", "x_", ",", "___"}], "]"}]}], "]"}], "&"}]}], "]"}], "//",
   "Timing"}]], "Input",
 CellTags->"b:0.7",
 CellLabel->"In[155]:=",
 CellID->115301483],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.04999999999999993`", " ", "Second"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "15488881", ",", "15491117", ",", "15491171", ",", "15491711", ",", 
     "15493333", ",", "15493999", ",", "15496111", ",", "15499111", ",", 
     "15499199", ",", "15499399", ",", "15499499", ",", "15499919", ",", 
     "15499997", ",", "15500557", ",", "15501119", ",", "15501121", ",", 
     "15501151", ",", "15501553", ",", "15501559", ",", "15501911", ",", 
     "15502111"}], "}"}]}], "}"}]], "Output",
 ImageSize->{586, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.7",
 CellLabel->"Out[155]=",
 CellID->626257199]
}, Open  ]],

Cell[TextData[{
 "By using the previous tips of using ",
 Cell[BoxData[
  ButtonBox["Pick",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pick"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["StringCases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringCases"]], "InlineFormula"],
 ", you can speed it up even more."
}], "Text",
 CellTags->"b:0.7",
 CellID->309333144],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"list", "=", 
      RowBox[{"Array", "[", 
       RowBox[{"Prime", ",", "1000", ",", "1000000"}], "]"}]}], "}"}], ",", 
    RowBox[{"Pick", "[", 
     RowBox[{"list", ",", 
      RowBox[{"StringMatchQ", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"FromCharacterCode", "[", 
           RowBox[{"48", "+", 
            RowBox[{"IntegerDigits", "[", "#", "]"}]}], "]"}], "&"}], "/@", 
         "list"}], ",", 
        RowBox[{"StringExpression", "[", 
         RowBox[{
         "___", ",", "x_", ",", "___", ",", "x_", ",", "___", ",", "x_", ",", 
          "___", ",", "x_", ",", "___"}], "]"}]}], "]"}]}], "]"}]}], "]"}], "//",
   "Timing"}]], "Input",
 CellTags->"b:0.7",
 CellLabel->"In[156]:=",
 CellID->238693932],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.040000000000000036`", " ", "Second"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "15488881", ",", "15491117", ",", "15491171", ",", "15491711", ",", 
     "15493333", ",", "15493999", ",", "15496111", ",", "15499111", ",", 
     "15499199", ",", "15499399", ",", "15499499", ",", "15499919", ",", 
     "15499997", ",", "15500557", ",", "15501119", ",", "15501121", ",", 
     "15501151", ",", "15501553", ",", "15501559", ",", "15501911", ",", 
     "15502111"}], "}"}]}], "}"}]], "Output",
 ImageSize->{586, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.7",
 CellLabel->"Out[156]=",
 CellID->424288253]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Flatten", "[", 
   RowBox[{"StringCases", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"FromCharacterCode", "[", 
        RowBox[{"48", "+", 
         RowBox[{"IntegerDigits", "[", "#", "]"}]}], "]"}], "&"}], "/@", 
      RowBox[{"Array", "[", 
       RowBox[{"Prime", ",", "1000", ",", "1000000"}], "]"}]}], ",", 
     RowBox[{"StringExpression", "[", 
      RowBox[{
      "StartOfString", ",", "___", ",", "x_", ",", "___", ",", "x_", ",", 
       "___", ",", "x_", ",", "___", ",", "x_", ",", "___", ",", 
       "EndOfString"}], "]"}]}], "]"}], "]"}], "//", "Timing"}]], "Input",
 CellTags->"b:0.7",
 CellLabel->"In[157]:=",
 CellID->74230660],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.040000000000000036`", " ", "Second"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"15488881\"\>", ",", "\<\"15491117\"\>", 
     ",", "\<\"15491171\"\>", ",", "\<\"15491711\"\>", 
     ",", "\<\"15493333\"\>", ",", "\<\"15493999\"\>", 
     ",", "\<\"15496111\"\>", ",", "\<\"15499111\"\>", 
     ",", "\<\"15499199\"\>", ",", "\<\"15499399\"\>", 
     ",", "\<\"15499499\"\>", ",", "\<\"15499919\"\>", 
     ",", "\<\"15499997\"\>", ",", "\<\"15500557\"\>", 
     ",", "\<\"15501119\"\>", ",", "\<\"15501121\"\>", 
     ",", "\<\"15501151\"\>", ",", "\<\"15501553\"\>", 
     ",", "\<\"15501559\"\>", ",", "\<\"15501911\"\>", 
     ",", "\<\"15502111\"\>"}], "}"}]}], "}"}]], "Output",
 ImageSize->{569, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.7",
 CellLabel->"Out[157]=",
 CellID->33082105]
}, Open  ]],

Cell["For long sequences, the difference can be significant.", "Text",
 CellTags->"b:0.7",
 CellID->778852497],

Cell[BoxData[
 RowBox[{
  RowBox[{"test", "=", 
   RowBox[{"Range", "[", "100", "]"}]}], ";", 
  RowBox[{
   RowBox[{"test", "[", 
    RowBox[{"[", 
     RowBox[{"{", 
      RowBox[{"50", ",", "75"}], "}"}], "]"}], "]"}], "=", "5"}], 
  ";"}]], "Input",
 CellTags->"b:0.7",
 CellLabel->"In[158]:=",
 CellID->166716726],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Position", "[", 
  RowBox[{"test", ",", "5"}], "]"}]], "Input",
 CellTags->"b:0.7",
 CellLabel->"In[159]:=",
 CellID->143881214],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "5", "}"}], ",", 
   RowBox[{"{", "50", "}"}], ",", 
   RowBox[{"{", "75", "}"}]}], "}"}]], "Output",
 ImageSize->{118, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.7",
 CellLabel->"Out[159]=",
 CellID->142292458]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MatchQ", "[", 
   RowBox[{"test", ",", 
    RowBox[{"{", 
     RowBox[{
     "___", ",", "x_", ",", "___", ",", "x_", ",", "___", ",", "x_", ",", 
      "___"}], "}"}]}], "]"}], "//", "Timing"}]], "Input",
 CellTags->"b:0.7",
 CellLabel->"In[160]:=",
 CellID->9520874],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.12100000000000022`", " ", "Second"}], ",", "True"}], 
  "}"}]], "Output",
 ImageSize->{138, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.7",
 CellLabel->"Out[160]=",
 CellID->209053402]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"teststr", "=", 
   RowBox[{"FromCharacterCode", "[", "test", "]"}]}], ";"}]], "Input",
 CellTags->"b:0.7",
 CellLabel->"In[161]:=",
 CellID->55052828],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringPosition", "[", 
  RowBox[{"teststr", ",", 
   RowBox[{"FromCharacterCode", "[", "5", "]"}]}], "]"}]], "Input",
 CellTags->"b:0.7",
 CellLabel->"In[162]:=",
 CellID->106844855],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"50", ",", "50"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"75", ",", "75"}], "}"}]}], "}"}]], "Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.7",
 CellLabel->"Out[162]=",
 CellID->83809943]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StringMatchQ", "[", 
   RowBox[{"teststr", ",", 
    RowBox[{"StringExpression", "[", 
     RowBox[{
     "___", ",", "x_", ",", "___", ",", "x_", ",", "___", ",", "x_", ",", 
      "___"}], "]"}]}], "]"}], "//", "Timing"}]], "Input",
 CellTags->"b:0.7",
 CellLabel->"In[163]:=",
 CellID->483013677],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.`", " ", "Second"}], ",", "True"}], "}"}]], "Output",
 ImageSize->{117, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.7",
 CellLabel->"Out[163]=",
 CellID->544100]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Implementation Details", "Section",
 CellTags->{"c:31", "b:0.8"},
 CellID->337819047],

Cell[TextData[{
 "String pattern matching in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is built on top of the PCRE (Perl Compatible Regular Expressions) library \
by Philip Hazel ",
 ButtonBox["[1]",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/WorkingWithStringPatterns#872737084"],
 ". "
}], "Text",
 CellTags->"b:0.8",
 CellID->68963779],

Cell[TextData[{
 "In some cases the pre-5.1 ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " algorithms are used (",
 "for example",
 ", when the pattern is just a single, literal string)."
}], "Text",
 CellTags->"b:0.8",
 CellID->57047539],

Cell[TextData[{
 "Any symbolic string pattern is first translated to a regular expression. \
You can see this translation by using the internal ",
 Cell[BoxData["StringPattern`PatternConvert"], "InlineFormula"],
 " function."
}], "Text",
 CellTags->"b:0.8",
 CellID->169990753],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StringPattern`PatternConvert", "[", 
   RowBox[{
    RowBox[{"\"\<a\>\"", "|", "\"\<\>\""}], "~~", 
    RowBox[{"DigitCharacter", ".."}]}], "]"}], "//", "InputForm"}]], "Input",
 CellTags->"b:0.8",
 CellLabel->"In[164]:=",
 CellID->201123037],

Cell["{\"(?ms)a?\\\\d+\", {}, {}, {}, Hold[None]}", "Output",
 ImageSize->{273, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.8",
 CellLabel->"Out[164]//InputForm=",
 CellID->85850298]
}, Open  ]],

Cell["\<\
The first element returned is the regular expression, while the rest of the \
elements have to do with conditions, replacement rules, and named patterns.\
\>", "Text",
 CellTags->"b:0.8",
 CellID->190255727],

Cell["\<\
The regular expression is then compiled by PCRE, and the compiled version is \
cached for future use when the same pattern appears again. The translation \
from symbolic string pattern to regular expression only happens once.\
\>", "Text",
 CellTags->"b:0.8",
 CellID->210149359],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " conditions in the pattern are handled by external call-outs from the PCRE \
library to the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " evaluator, so this will slow down the matching."
}], "Text",
 CellTags->"b:0.8",
 CellID->953153723],

Cell[TextData[{
 "Explicit ",
 Cell[BoxData[
  ButtonBox["RegularExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegularExpression"]], "InlineFormula"],
 " objects embedded into a general string pattern will be spliced into the \
final regular expression (surrounded by noncapturing parentheses ",
 Cell[BoxData["\"\<(?:...)\>\""], "InlineFormula"],
 "), so the counting of named patterns can become skewed compared to what you \
might expect."
}], "Text",
 CellTags->"b:0.8",
 CellID->198359003],

Cell[TextData[{
 "Because PCRE currently does not support preset character classes with \
characters beyond character code 255, the word and letter character classes \
(such as ",
 Cell[BoxData[
  ButtonBox["WordCharacter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WordCharacter"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["LetterCharacter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LetterCharacter"]], "InlineFormula"],
 ") only include character codes in the Unicode range 0\[Dash]255. Thus ",
 Cell[BoxData[
  ButtonBox["LetterCharacter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LetterCharacter"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"_", "?", 
   ButtonBox["LetterQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LetterQ"]}]], "InlineFormula"],
 " do not give equivalent results beyond character code 255."
}], "Text",
 CellTags->"b:0.8",
 CellID->908430859],

Cell[TextData[{
 "Because of a similar PCRE restriction, case-insensitive matching (for \
example, with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["IgnoreCase",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IgnoreCase"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ") will only apply to letters in the Unicode range 0\[Dash]127 (that is, the \
normal English letters ",
 Cell[BoxData["\"\<a\>\""], "InlineFormula"],
 "\[Dash]",
 Cell[BoxData["\"\<z\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<A\>\""], "InlineFormula"],
 "\[Dash]",
 Cell[BoxData["\"\<Z\>\""], "InlineFormula"],
 ")."
}], "Text",
 CellTags->"b:0.8",
 CellID->1015887440]
}, Open  ]],

Cell[CellGroupData[{

Cell["References", "Section",
 CellTags->{"c:32", "b:0.9"},
 CellID->503575505],

Cell[TextData[{
 "[1] P. Hazel, \[OpenCurlyDoubleQuote]PCRE \[LongDash] Perl Compatible \
Regular Expressions.\[CloseCurlyDoubleQuote] (Feb 10, 2004) ",
 ButtonBox["www.pcre.org",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.pcre.org"], None}],
 "."
}], "Text",
 CellTags->{"Ref-1", "b:0.9"},
 CellID->872737084],

Cell[TextData[{
 "[2] J. E. F. Friedl, ",
 StyleBox["Mastering Regular Expressions",
  FontSlant->"Italic"],
 ", 2nd ed., Sebastopol, CA: O'Reilly & Associates, 2002."
}], "Text",
 CellTags->{"Ref-2", "b:0.9"},
 CellID->201956504]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Working with String Patterns - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 46, 38.6755738}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "The general symbolic string patterns in Mathematica allow you to perform \
powerful string manipulation efficiently. What follows discusses the details \
of string patterns, including usage and implementation notes. The emphasis is \
on issues not mentioned elsewhere in the help system. At the heart of \
Mathematica is a powerful language for describing patterns in general \
expressions. This language is used in function definitions, substitutions, \
and searches, with constructs like x_, a|b, x.., and so on. A Mathematica \
string pattern uses the same constructs to describe patterns in a text \
string. You can think of a string as a sequence of characters and apply the \
principles of general Mathematica patterns. In addition there are several \
useful string-specific pattern constructs.", "synonyms" -> {}, "title" -> 
    "Working with String Patterns", "type" -> "Tutorial", "uri" -> 
    "tutorial/WorkingWithStringPatterns"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "c:1"->{
  Cell[4291, 90, 78, 2, 70, "Section",
   CellTags->{"c:1", "b:0.0"},
   CellID->6475218]},
 "b:0.0"->{
  Cell[4291, 90, 78, 2, 70, "Section",
   CellTags->{"c:1", "b:0.0"},
   CellID->6475218],
  Cell[4372, 94, 401, 10, 70, "Text",
   CellTags->"b:0.0",
   CellID->879271277],
  Cell[4776, 106, 503, 17, 70, "Text",
   CellTags->"b:0.0",
   CellID->217261366],
  Cell[5304, 127, 290, 10, 28, "Input",
   CellTags->"b:0.0",
   CellID->6793186],
  Cell[5597, 139, 182, 6, 36, "Output",
   CellTags->"b:0.0",
   CellID->685045409],
  Cell[5816, 150, 302, 10, 28, "Input",
   CellTags->"b:0.0",
   CellID->397472003],
  Cell[6121, 162, 181, 6, 36, "Output",
   CellTags->"b:0.0",
   CellID->136501627],
  Cell[6339, 173, 244, 8, 28, "Input",
   CellTags->"b:0.0",
   CellID->108872960],
  Cell[6586, 183, 232, 8, 36, "Output",
   CellTags->"b:0.0",
   CellID->91209889],
  Cell[6833, 194, 439, 13, 70, "Text",
   CellTags->"b:0.0",
   CellID->47601161],
  Cell[7297, 211, 246, 8, 28, "Input",
   CellTags->"b:0.0",
   CellID->164239912],
  Cell[7546, 221, 182, 6, 36, "Output",
   CellTags->"b:0.0",
   CellID->965988149],
  Cell[7765, 232, 247, 8, 28, "Input",
   CellTags->"b:0.0",
   CellID->340018981],
  Cell[8015, 242, 181, 6, 36, "Output",
   CellTags->"b:0.0",
   CellID->123154041],
  Cell[8233, 253, 176, 5, 70, "Input",
   CellTags->"b:0.0",
   CellID->327756114],
  Cell[8412, 260, 259, 9, 36, "Output",
   CellTags->"b:0.0",
   CellID->522047130],
  Cell[8686, 272, 195, 5, 70, "Text",
   CellTags->"b:0.0",
   CellID->7623660],
  Cell[8906, 281, 229, 7, 70, "Input",
   CellTags->"b:0.0",
   CellID->257665367],
  Cell[9138, 290, 182, 6, 36, "Output",
   CellTags->"b:0.0",
   CellID->138681442],
  Cell[9357, 301, 229, 7, 70, "Input",
   CellTags->"b:0.0",
   CellID->15296355],
  Cell[9589, 310, 180, 6, 36, "Output",
   CellTags->"b:0.0",
   CellID->48670236],
  Cell[9806, 321, 221, 7, 70, "Input",
   CellTags->"b:0.0",
   CellID->44443359],
  Cell[10030, 330, 257, 9, 36, "Output",
   CellTags->"b:0.0",
   CellID->6967547],
  Cell[10302, 342, 131, 4, 70, "Text",
   CellTags->"b:0.0",
   CellID->131976413],
  Cell[14991, 491, 98, 2, 70, "Caption",
   CellTags->"b:0.0",
   CellID->49176434]},
 "c:2"->{
  Cell[15126, 498, 91, 2, 70, "Section",
   CellTags->{"c:2", "b:0.1"},
   CellID->316252289]},
 "b:0.1"->{
  Cell[15126, 498, 91, 2, 70, "Section",
   CellTags->{"c:2", "b:0.1"},
   CellID->316252289],
  Cell[15220, 502, 470, 15, 70, "Text",
   CellTags->"b:0.1",
   CellID->775969280],
  Cell[15715, 521, 156, 5, 70, "Input",
   CellTags->"b:0.1",
   CellID->14216555],
  Cell[15874, 528, 416, 15, 50, "Output",
   CellTags->"b:0.1",
   CellID->6889976],
  Cell[16305, 546, 458, 14, 70, "Text",
   CellTags->"b:0.1",
   CellID->143628873],
  Cell[16788, 564, 165, 5, 70, "Input",
   CellTags->"b:0.1",
   CellID->220445018],
  Cell[16956, 571, 191, 6, 36, "Output",
   CellTags->"b:0.1",
   CellID->66432613],
  Cell[17162, 580, 708, 21, 70, "Text",
   CellTags->"b:0.1",
   CellID->100231778],
  Cell[17873, 603, 160, 5, 70, "Text",
   CellTags->"b:0.1",
   CellID->206331185],
  Cell[22219, 744, 103, 2, 70, "Text",
   CellTags->"b:0.1",
   CellID->104465889],
  Cell[25087, 835, 101, 2, 70, "Text",
   CellTags->"b:0.1",
   CellID->97881266],
  Cell[26449, 880, 151, 5, 70, "Text",
   CellTags->"b:0.1",
   CellID->138112839],
  Cell[27407, 915, 143, 3, 70, "Text",
   CellTags->"b:0.1",
   CellID->833514613],
  Cell[27553, 920, 908, 34, 70, "Text",
   CellTags->"b:0.1",
   CellID->110717692],
  Cell[28486, 958, 174, 5, 70, "Input",
   CellTags->"b:0.1",
   CellID->32115820],
  Cell[28663, 965, 224, 7, 71, "Output",
   CellTags->"b:0.1",
   CellID->191828861],
  Cell[28924, 977, 239, 7, 70, "Input",
   CellTags->"b:0.1",
   CellID->280132484],
  Cell[29166, 986, 249, 8, 36, "Output",
   CellTags->"b:0.1",
   CellID->212135941],
  Cell[29452, 999, 228, 6, 70, "Input",
   CellTags->"b:0.1",
   CellID->406476748],
  Cell[29683, 1007, 248, 8, 36, "Output",
   CellTags->"b:0.1",
   CellID->20298962],
  Cell[29946, 1018, 739, 23, 70, "Text",
   CellTags->"b:0.1",
   CellID->694363556],
  Cell[30710, 1045, 318, 9, 70, "Input",
   CellTags->"b:0.1",
   CellID->140507535],
  Cell[31031, 1056, 209, 6, 36, "Output",
   CellTags->"b:0.1",
   CellID->13100792],
  Cell[31255, 1065, 562, 20, 70, "Text",
   CellTags->"b:0.1",
   CellID->48865639],
  Cell[31842, 1089, 451, 14, 70, "Input",
   CellTags->"b:0.1",
   CellID->134667756],
  Cell[32296, 1105, 241, 8, 36, "Output",
   CellTags->"b:0.1",
   CellID->27162036],
  Cell[32552, 1116, 389, 14, 70, "Text",
   CellTags->"b:0.1",
   CellID->408165015],
  Cell[32966, 1134, 312, 11, 70, "Input",
   CellTags->"b:0.1",
   CellID->149685880],
  Cell[33281, 1147, 264, 9, 36, "Output",
   CellTags->"b:0.1",
   CellID->707533094],
  Cell[33560, 1159, 400, 15, 70, "Text",
   CellTags->"b:0.1",
   CellID->212294979],
  Cell[33985, 1178, 229, 6, 70, "Input",
   CellTags->"b:0.1",
   CellID->318389946],
  Cell[34217, 1186, 197, 6, 36, "Output",
   CellTags->"b:0.1",
   CellID->168972183],
  Cell[34429, 1195, 268, 9, 70, "Text",
   CellTags->"b:0.1",
   CellID->384134564],
  Cell[34722, 1208, 325, 10, 70, "Input",
   CellTags->"b:0.1",
   CellID->23848909],
  Cell[35050, 1220, 242, 8, 36, "Output",
   CellTags->"b:0.1",
   CellID->148025619],
  Cell[35307, 1231, 347, 10, 70, "Text",
   CellTags->"b:0.1",
   CellID->603056891],
  Cell[35679, 1245, 296, 8, 70, "Input",
   CellTags->"b:0.1",
   CellID->291672169],
  Cell[35978, 1255, 244, 8, 36, "Output",
   CellTags->"b:0.1",
   CellID->111286320],
  Cell[36237, 1266, 229, 8, 70, "Text",
   CellTags->"b:0.1",
   CellID->344292962],
  Cell[36491, 1278, 304, 10, 70, "Input",
   CellTags->"b:0.1",
   CellID->57194593],
  Cell[36798, 1290, 249, 8, 36, "Output",
   CellTags->"b:0.1",
   CellID->384825101],
  Cell[37062, 1301, 323, 10, 70, "Text",
   CellTags->"b:0.1",
   CellID->2661260],
  Cell[37388, 1313, 109, 2, 70, "Text",
   CellTags->"b:0.1",
   CellID->704437595],
  Cell[37522, 1319, 307, 9, 70, "Input",
   CellTags->"b:0.1",
   CellID->190390204],
  Cell[37832, 1330, 190, 6, 36, "Output",
   CellTags->"b:0.1",
   CellID->51576904],
  Cell[38037, 1339, 584, 18, 70, "Text",
   CellTags->"b:0.1",
   CellID->422987297],
  Cell[38646, 1361, 236, 7, 70, "Input",
   CellTags->"b:0.1",
   CellID->262589375],
  Cell[38885, 1370, 217, 7, 36, "Output",
   CellTags->"b:0.1",
   CellID->43459422],
  Cell[39139, 1382, 260, 8, 70, "Input",
   CellTags->"b:0.1",
   CellID->87767072],
  Cell[39402, 1392, 247, 8, 36, "Output",
   CellTags->"b:0.1",
   CellID->431541845],
  Cell[39664, 1403, 275, 10, 70, "Text",
   CellTags->"b:0.1",
   CellID->30079273],
  Cell[39964, 1417, 403, 11, 70, "Input",
   CellTags->"b:0.1",
   CellID->336262030],
  Cell[40370, 1430, 240, 8, 36, "Output",
   CellTags->"b:0.1",
   CellID->238292539],
  Cell[40647, 1443, 440, 12, 70, "Input",
   CellTags->"b:0.1",
   CellID->46781425],
  Cell[41090, 1457, 243, 8, 36, "Output",
   CellTags->"b:0.1",
   CellID->46684404],
  Cell[41348, 1468, 254, 9, 70, "Text",
   CellTags->"b:0.1",
   CellID->165376289],
  Cell[41627, 1481, 434, 12, 70, "Input",
   CellTags->"b:0.1",
   CellID->33998707],
  Cell[42064, 1495, 244, 8, 36, "Output",
   CellTags->"b:0.1",
   CellID->428424676]},
 "Regular Expressions"->{
  Cell[42357, 1509, 110, 2, 70, "Section",
   CellTags->{"Regular Expressions", "c:3", "b:0.2"},
   CellID->274403895]},
 "c:3"->{
  Cell[42357, 1509, 110, 2, 70, "Section",
   CellTags->{"Regular Expressions", "c:3", "b:0.2"},
   CellID->274403895]},
 "b:0.2"->{
  Cell[42357, 1509, 110, 2, 70, "Section",
   CellTags->{"Regular Expressions", "c:3", "b:0.2"},
   CellID->274403895],
  Cell[42470, 1513, 635, 19, 70, "Text",
   CellTags->"b:0.2",
   CellID->179324024],
  Cell[43108, 1534, 169, 5, 70, "Text",
   CellTags->"b:0.2",
   CellID->311647046],
  Cell[47690, 1672, 103, 2, 70, "Text",
   CellTags->"b:0.2",
   CellID->326926809],
  Cell[48825, 1701, 578, 32, 70, "Text",
   CellTags->"b:0.2",
   CellID->423328124],
  Cell[49406, 1735, 101, 2, 70, "Text",
   CellTags->"b:0.2",
   CellID->53679581],
  Cell[49510, 1739, 1246, 40, 70, "DefinitionBox",
   CellTags->"b:0.2",
   CellID->438051314],
  Cell[50759, 1781, 146, 5, 70, "Text",
   CellTags->"b:0.2",
   CellID->446511798],
  Cell[50908, 1788, 1322, 45, 70, "DefinitionBox",
   CellTags->"b:0.2",
   CellID->103937476],
  Cell[52233, 1835, 106, 2, 70, "Text",
   CellTags->"b:0.2",
   CellID->725709264],
  Cell[52342, 1839, 1417, 51, 70, "DefinitionBox",
   CellTags->"b:0.2",
   CellID->324529988],
  Cell[53762, 1892, 161, 5, 70, "Text",
   CellTags->"b:0.2",
   CellID->36188322],
  Cell[53926, 1899, 128, 4, 70, "Text",
   CellTags->"b:0.2",
   CellID->17419283],
  Cell[54079, 1907, 252, 7, 70, "Input",
   CellTags->"b:0.2",
   CellID->636896070],
  Cell[54334, 1916, 268, 9, 36, "Output",
   CellTags->"b:0.2",
   CellID->756235924],
  Cell[54617, 1928, 293, 7, 70, "Text",
   CellTags->"b:0.2",
   CellID->228635176],
  Cell[54935, 1939, 229, 7, 70, "Input",
   CellTags->"b:0.2",
   CellID->149453386],
  Cell[55167, 1948, 242, 8, 36, "Output",
   CellTags->"b:0.2",
   CellID->155639932],
  Cell[55446, 1961, 229, 7, 70, "Input",
   CellTags->"b:0.2",
   CellID->27057531],
  Cell[55678, 1970, 196, 7, 36, "Output",
   CellTags->"b:0.2",
   CellID->188119997],
  Cell[55911, 1982, 229, 7, 70, "Input",
   CellTags->"b:0.2",
   CellID->72747825],
  Cell[56143, 1991, 242, 8, 36, "Output",
   CellTags->"b:0.2",
   CellID->72194511],
  Cell[56400, 2002, 253, 9, 70, "Text",
   CellTags->"b:0.2",
   CellID->574029527],
  Cell[56678, 2015, 246, 7, 70, "Input",
   CellTags->"b:0.2",
   CellID->972490785],
  Cell[56927, 2024, 286, 9, 36, "Output",
   CellTags->"b:0.2",
   CellID->459953736],
  Cell[57228, 2036, 998, 37, 70, "Text",
   CellTags->"b:0.2",
   CellID->645192577],
  Cell[58229, 2075, 424, 16, 70, "Text",
   CellTags->"b:0.2",
   CellID->38350545],
  Cell[58656, 2093, 299, 9, 70, "Text",
   CellTags->"b:0.2",
   CellID->87518571],
  Cell[58980, 2106, 226, 6, 70, "Input",
   CellTags->"b:0.2",
   CellID->310325877],
  Cell[59209, 2114, 213, 7, 36, "Output",
   CellTags->"b:0.2",
   CellID->510580570],
  Cell[59459, 2126, 232, 7, 70, "Input",
   CellTags->"b:0.2",
   CellID->47695904],
  Cell[59694, 2135, 248, 8, 36, "Output",
   CellTags->"b:0.2",
   CellID->82458948],
  Cell[59957, 2146, 282, 10, 70, "Text",
   CellTags->"b:0.2",
   CellID->428461048],
  Cell[60264, 2160, 238, 7, 70, "Input",
   CellTags->"b:0.2",
   CellID->1001621228],
  Cell[60505, 2169, 213, 7, 36, "Output",
   CellTags->"b:0.2",
   CellID->521403356],
  Cell[60733, 2179, 250, 9, 70, "Text",
   CellTags->"b:0.2",
   CellID->667194970],
  Cell[61008, 2192, 346, 10, 70, "Input",
   CellTags->"b:0.2",
   CellID->562254777],
  Cell[61357, 2204, 246, 8, 36, "Output",
   CellTags->"b:0.2",
   CellID->988258],
  Cell[61618, 2215, 869, 24, 70, "Text",
   CellTags->"b:0.2",
   CellID->1379250],
  Cell[62512, 2243, 245, 7, 70, "Input",
   CellTags->"b:0.2",
   CellID->425844705],
  Cell[62760, 2252, 246, 8, 36, "Output",
   CellTags->"b:0.2",
   CellID->463827189],
  Cell[63043, 2265, 378, 11, 70, "Input",
   CellTags->"b:0.2",
   CellID->25483089],
  Cell[63424, 2278, 423, 14, 36, "Output",
   CellTags->"b:0.2",
   CellID->120083365],
  Cell[63862, 2295, 449, 13, 70, "Text",
   CellTags->"b:0.2",
   CellID->251858179],
  Cell[64336, 2312, 416, 12, 70, "Input",
   CellTags->"b:0.2",
   CellID->84036725],
  Cell[64755, 2326, 478, 14, 36, "Output",
   CellTags->"b:0.2",
   CellID->56276189],
  Cell[65248, 2343, 282, 7, 70, "Text",
   CellTags->"b:0.2",
   CellID->695998127],
  Cell[65555, 2354, 440, 12, 70, "Input",
   CellTags->"b:0.2",
   CellID->28505115],
  Cell[65998, 2368, 487, 14, 36, "Output",
   CellTags->"b:0.2",
   CellID->193124569],
  Cell[66500, 2385, 294, 9, 70, "Text",
   CellTags->"b:0.2",
   CellID->465786935],
  Cell[66819, 2398, 243, 7, 70, "Input",
   CellTags->"b:0.2",
   CellID->38936688],
  Cell[67065, 2407, 244, 8, 36, "Output",
   CellTags->"b:0.2",
   CellID->738895931],
  Cell[67324, 2418, 198, 5, 70, "Text",
   CellTags->"b:0.2",
   CellID->377461404],
  Cell[67525, 2425, 168, 6, 70, "Text",
   CellTags->"b:0.2",
   CellID->114009367],
  Cell[67718, 2435, 246, 7, 70, "Input",
   CellTags->"b:0.2",
   CellID->635063856],
  Cell[67967, 2444, 244, 8, 36, "Output",
   CellTags->"b:0.2",
   CellID->355466528],
  Cell[68226, 2455, 175, 5, 70, "Text",
   CellTags->"b:0.2",
   CellID->142585462],
  Cell[68426, 2464, 425, 13, 70, "Input",
   CellTags->"b:0.2",
   CellID->4084787],
  Cell[68854, 2479, 302, 9, 36, "Output",
   CellTags->"b:0.2",
   CellID->420878177],
  Cell[69171, 2491, 239, 6, 70, "Text",
   CellTags->"b:0.2",
   CellID->68612708],
  Cell[69435, 2501, 457, 15, 70, "Input",
   CellTags->"b:0.2",
   CellID->373128525],
  Cell[69895, 2518, 242, 8, 36, "Output",
   CellTags->"b:0.2",
   CellID->127706517]},
 "c:4"->{
  Cell[70186, 2532, 109, 2, 70, "Section",
   CellTags->{"c:4", "b:0.3"},
   CellID->182364929]},
 "b:0.3"->{
  Cell[70186, 2532, 109, 2, 70, "Section",
   CellTags->{"c:4", "b:0.3"},
   CellID->182364929],
  Cell[70298, 2536, 321, 7, 70, "Text",
   CellTags->"b:0.3",
   CellID->100369965],
  Cell[70622, 2545, 8577, 255, 70, "DefinitionBox3Col",
   CellTags->"b:0.3",
   CellID->195821352],
  Cell[79202, 2802, 397, 12, 70, "Text",
   CellTags->"b:0.3",
   CellID->143238647],
  Cell[79602, 2816, 477, 13, 70, "Text",
   CellTags->"b:0.3",
   CellID->121646424]},
 "c:5"->{
  Cell[80116, 2834, 86, 2, 70, "Section",
   CellTags->"c:5",
   CellID->393353162]},
 "c:6"->{
  Cell[80445, 2847, 85, 2, 70, "Subsection",
   CellTags->{"c:6", "b:0.4.0"},
   CellID->115748480]},
 "b:0.4.0"->{
  Cell[80445, 2847, 85, 2, 70, "Subsection",
   CellTags->{"c:6", "b:0.4.0"},
   CellID->115748480],
  Cell[80533, 2851, 266, 8, 70, "Text",
   CellTags->"b:0.4.0",
   CellID->88806953],
  Cell[80824, 2863, 233, 7, 70, "Input",
   CellTags->"b:0.4.0",
   CellID->631912780],
  Cell[81060, 2872, 184, 6, 36, "Output",
   CellTags->"b:0.4.0",
   CellID->768829449],
  Cell[81281, 2883, 235, 7, 70, "Input",
   CellTags->"b:0.4.0",
   CellID->116558020],
  Cell[81519, 2892, 184, 6, 36, "Output",
   CellTags->"b:0.4.0",
   CellID->42906176],
  Cell[81718, 2901, 1404, 47, 70, "Text",
   CellTags->"b:0.4.0",
   CellID->406868558],
  Cell[83125, 2950, 111, 2, 70, "Text",
   CellTags->"b:0.4.0",
   CellID->90376082],
  Cell[83261, 2956, 199, 6, 70, "Input",
   CellTags->"b:0.4.0",
   CellID->996820522],
  Cell[83463, 2964, 184, 6, 36, "Output",
   CellTags->"b:0.4.0",
   CellID->504872867],
  Cell[83684, 2975, 247, 7, 70, "Input",
   CellTags->"b:0.4.0",
   CellID->44778046],
  Cell[83934, 2984, 183, 6, 36, "Output",
   CellTags->"b:0.4.0",
   CellID->11784903],
  Cell[84154, 2995, 228, 7, 70, "Input",
   CellTags->"b:0.4.0",
   CellID->22423222],
  Cell[84385, 3004, 182, 6, 36, "Output",
   CellTags->"b:0.4.0",
   CellID->3205742],
  Cell[84582, 3013, 360, 12, 70, "Text",
   CellTags->"b:0.4.0",
   CellID->60232086],
  Cell[84945, 3027, 299, 10, 70, "Text",
   CellTags->"b:0.4.0",
   CellID->716869318],
  Cell[85247, 3039, 494, 14, 70, "Text",
   CellTags->"b:0.4.0",
   CellID->554439476],
  Cell[85766, 3057, 236, 6, 70, "Input",
   CellTags->"b:0.4.0",
   CellID->70925498],
  Cell[86005, 3065, 184, 6, 36, "Output",
   CellTags->"b:0.4.0",
   CellID->121299948]},
 "c:7"->{
  Cell[86238, 3077, 84, 2, 70, "Subsection",
   CellTags->{"c:7", "b:0.4.1"},
   CellID->221687989]},
 "b:0.4.1"->{
  Cell[86238, 3077, 84, 2, 70, "Subsection",
   CellTags->{"c:7", "b:0.4.1"},
   CellID->221687989],
  Cell[86325, 3081, 478, 15, 70, "Text",
   CellTags->"b:0.4.1",
   CellID->58760444],
  Cell[86828, 3100, 233, 7, 70, "Input",
   CellTags->"b:0.4.1",
   CellID->208914080],
  Cell[87064, 3109, 185, 6, 36, "Output",
   CellTags->"b:0.4.1",
   CellID->209738466],
  Cell[87286, 3120, 223, 7, 70, "Input",
   CellTags->"b:0.4.1",
   CellID->113974042],
  Cell[87512, 3129, 185, 6, 36, "Output",
   CellTags->"b:0.4.1",
   CellID->232877383]},
 "c:8"->{
  Cell[87746, 3141, 82, 2, 70, "Subsection",
   CellTags->{"c:8", "b:0.4.2"},
   CellID->3968257]},
 "b:0.4.2"->{
  Cell[87746, 3141, 82, 2, 70, "Subsection",
   CellTags->{"c:8", "b:0.4.2"},
   CellID->3968257],
  Cell[87831, 3145, 331, 9, 70, "Text",
   CellTags->"b:0.4.2",
   CellID->46676764],
  Cell[88165, 3156, 93, 2, 70, "Text",
   CellTags->"b:0.4.2",
   CellID->143958968],
  Cell[88283, 3162, 206, 6, 70, "Input",
   CellTags->"b:0.4.2",
   CellID->459256047],
  Cell[88492, 3170, 265, 9, 36, "Output",
   CellTags->"b:0.4.2",
   CellID->35656270],
  Cell[88772, 3182, 92, 2, 70, "Text",
   CellTags->"b:0.4.2",
   CellID->697884743],
  Cell[88889, 3188, 301, 10, 70, "Input",
   CellTags->"b:0.4.2",
   CellID->85500109],
  Cell[89193, 3200, 265, 9, 36, "Output",
   CellTags->"b:0.4.2",
   CellID->166781061],
  Cell[89495, 3214, 279, 8, 70, "Input",
   CellTags->"b:0.4.2",
   CellID->493985103],
  Cell[89777, 3224, 265, 9, 36, "Output",
   CellTags->"b:0.4.2",
   CellID->358774032],
  Cell[90057, 3236, 89, 2, 70, "Text",
   CellTags->"b:0.4.2",
   CellID->121882887],
  Cell[90171, 3242, 196, 6, 70, "Input",
   CellTags->"b:0.4.2",
   CellID->240722779],
  Cell[90370, 3250, 261, 9, 36, "Output",
   CellTags->"b:0.4.2",
   CellID->26993590],
  Cell[90646, 3262, 86, 2, 70, "Text",
   CellTags->"b:0.4.2",
   CellID->608581590],
  Cell[90757, 3268, 725, 22, 70, "Input",
   CellTags->"b:0.4.2",
   CellID->94888225],
  Cell[91485, 3292, 405, 12, 36, "Output",
   CellTags->"b:0.4.2",
   CellID->180027018],
  Cell[91905, 3307, 347, 9, 70, "Text",
   CellTags->"b:0.4.2",
   CellID->255423450],
  Cell[92277, 3320, 343, 11, 70, "Input",
   CellTags->"b:0.4.2",
   CellID->1009786679],
  Cell[92623, 3333, 353, 12, 36, "Output",
   CellTags->"b:0.4.2",
   CellID->248658486],
  Cell[93013, 3350, 125, 4, 70, "Input",
   CellTags->"b:0.4.2",
   CellID->51924450],
  Cell[93141, 3356, 246, 8, 36, "Output",
   CellTags->"b:0.4.2",
   CellID->391207758]},
 "c:9"->{
  Cell[93436, 3370, 92, 2, 70, "Subsection",
   CellTags->{"c:9", "b:0.4.3"},
   CellID->351610464]},
 "b:0.4.3"->{
  Cell[93436, 3370, 92, 2, 70, "Subsection",
   CellTags->{"c:9", "b:0.4.3"},
   CellID->351610464],
  Cell[93531, 3374, 1743, 65, 70, "Text",
   CellTags->"b:0.4.3",
   CellID->542672475],
  Cell[95277, 3441, 405, 14, 70, "Text",
   CellTags->"b:0.4.3",
   CellID->271649068],
  Cell[95707, 3459, 262, 8, 70, "Input",
   CellTags->"b:0.4.3",
   CellID->323915583],
  Cell[95972, 3469, 248, 8, 36, "Output",
   CellTags->"b:0.4.3",
   CellID->314158530],
  Cell[96235, 3480, 443, 14, 70, "Text",
   CellTags->"b:0.4.3",
   CellID->18408293],
  Cell[96703, 3498, 309, 8, 70, "Input",
   CellTags->"b:0.4.3",
   CellID->123426060],
  Cell[97015, 3508, 271, 9, 36, "Output",
   CellTags->"b:0.4.3",
   CellID->38256750],
  Cell[97301, 3520, 391, 14, 70, "Text",
   CellTags->"b:0.4.3",
   CellID->326611308],
  Cell[97717, 3538, 308, 8, 70, "Input",
   CellTags->"b:0.4.3",
   CellID->237410754],
  Cell[98028, 3548, 323, 9, 36, "Output",
   CellTags->"b:0.4.3",
   CellID->468451421],
  Cell[98366, 3560, 468, 14, 70, "Text",
   CellTags->"b:0.4.3",
   CellID->627314046],
  Cell[98859, 3578, 459, 13, 70, "Input",
   CellTags->"b:0.4.3",
   CellID->87536172],
  Cell[99321, 3593, 315, 9, 36, "Output",
   CellTags->"b:0.4.3",
   CellID->561505271],
  Cell[99673, 3607, 460, 13, 70, "Input",
   CellTags->"b:0.4.3",
   CellID->31744191],
  Cell[100136, 3622, 248, 8, 36, "Output",
   CellTags->"b:0.4.3",
   CellID->271831375],
  Cell[100399, 3633, 471, 16, 70, "Text",
   CellTags->"b:0.4.3",
   CellID->1005472710],
  Cell[100895, 3653, 262, 8, 70, "Input",
   CellTags->"b:0.4.3",
   CellID->168142260],
  Cell[101160, 3663, 281, 9, 36, "Output",
   CellTags->"b:0.4.3",
   CellID->7842756],
  Cell[101478, 3677, 236, 7, 70, "Input",
   CellTags->"b:0.4.3",
   CellID->42485134],
  Cell[101717, 3686, 242, 8, 36, "Output",
   CellTags->"b:0.4.3",
   CellID->337333049]},
 "c:10"->{
  Cell[102008, 3700, 88, 2, 70, "Subsection",
   CellTags->{"c:10", "b:0.4.4"},
   CellID->363493082]},
 "b:0.4.4"->{
  Cell[102008, 3700, 88, 2, 70, "Subsection",
   CellTags->{"c:10", "b:0.4.4"},
   CellID->363493082],
  Cell[102099, 3704, 412, 13, 70, "Text",
   CellTags->"b:0.4.4",
   CellID->3234460],
  Cell[102536, 3721, 209, 6, 70, "Input",
   CellTags->"b:0.4.4",
   CellID->175418910],
  Cell[102748, 3729, 386, 14, 36, "Output",
   CellTags->"b:0.4.4",
   CellID->450807373],
  Cell[103171, 3748, 220, 8, 70, "Input",
   CellTags->"b:0.4.4",
   CellID->352798794],
  Cell[103394, 3758, 266, 9, 36, "Output",
   CellTags->"b:0.4.4",
   CellID->839342939],
  Cell[103675, 3770, 399, 14, 70, "Text",
   CellTags->"b:0.4.4",
   CellID->771123683],
  Cell[104099, 3788, 265, 8, 70, "Input",
   CellTags->"b:0.4.4",
   CellID->227693171],
  Cell[104367, 3798, 384, 14, 36, "Output",
   CellTags->"b:0.4.4",
   CellID->431531950],
  Cell[104766, 3815, 102, 2, 70, "Text",
   CellTags->"b:0.4.4",
   CellID->141395505],
  Cell[104893, 3821, 168, 5, 70, "Input",
   CellTags->"b:0.4.4",
   CellID->695066864],
  Cell[105064, 3828, 443, 16, 36, "Output",
   CellTags->"b:0.4.4",
   CellID->242903424]},
 "c:11"->{
  Cell[105556, 3850, 85, 2, 70, "Subsection",
   CellTags->{"c:11", "b:0.4.5"},
   CellID->401719377]},
 "b:0.4.5"->{
  Cell[105556, 3850, 85, 2, 70, "Subsection",
   CellTags->{"c:11", "b:0.4.5"},
   CellID->401719377],
  Cell[105644, 3854, 639, 19, 70, "Text",
   CellTags->"b:0.4.5",
   CellID->771573730],
  Cell[106308, 3877, 287, 8, 70, "Input",
   CellTags->"b:0.4.5",
   CellID->175837266],
  Cell[106598, 3887, 182, 6, 36, "Output",
   CellTags->"b:0.4.5",
   CellID->699615004],
  Cell[106817, 3898, 322, 10, 70, "Input",
   CellTags->"b:0.4.5",
   CellID->16340890],
  Cell[107142, 3910, 182, 6, 36, "Output",
   CellTags->"b:0.4.5",
   CellID->327764894],
  Cell[107339, 3919, 462, 18, 70, "Text",
   CellTags->"b:0.4.5",
   CellID->12491824]},
 "c:12"->{
  Cell[107838, 3942, 85, 2, 70, "Subsection",
   CellTags->{"c:12", "b:0.4.6"},
   CellID->1274428]},
 "b:0.4.6"->{
  Cell[107838, 3942, 85, 2, 70, "Subsection",
   CellTags->{"c:12", "b:0.4.6"},
   CellID->1274428],
  Cell[107926, 3946, 266, 8, 70, "Text",
   CellTags->"b:0.4.6",
   CellID->45121066],
  Cell[108217, 3958, 316, 10, 70, "Input",
   CellTags->"b:0.4.6",
   CellID->67067787],
  Cell[108536, 3970, 192, 6, 36, "Output",
   CellTags->"b:0.4.6",
   CellID->72896606],
  Cell[108743, 3979, 397, 12, 70, "Text",
   CellTags->"b:0.4.6",
   CellID->21617589],
  Cell[109165, 3995, 314, 9, 70, "Input",
   CellTags->"b:0.4.6",
   CellID->801931404],
  Cell[109482, 4006, 203, 6, 36, "Output",
   CellTags->"b:0.4.6",
   CellID->187183009],
  Cell[109700, 4015, 253, 6, 70, "Text",
   CellTags->"b:0.4.6",
   CellID->150245402],
  Cell[109978, 4025, 327, 9, 70, "Input",
   CellTags->"b:0.4.6",
   CellID->85246728],
  Cell[110308, 4036, 203, 6, 36, "Output",
   CellTags->"b:0.4.6",
   CellID->483186576],
  Cell[110526, 4045, 145, 5, 70, "Text",
   CellTags->"b:0.4.6",
   CellID->203144771],
  Cell[110696, 4054, 323, 9, 70, "Input",
   CellTags->"b:0.4.6",
   CellID->17461363],
  Cell[111022, 4065, 203, 6, 36, "Output",
   CellTags->"b:0.4.6",
   CellID->461731323],
  Cell[111240, 4074, 317, 10, 70, "Text",
   CellTags->"b:0.4.6",
   CellID->131051894],
  Cell[111582, 4088, 366, 10, 70, "Input",
   CellTags->"b:0.4.6",
   CellID->459415768],
  Cell[111951, 4100, 631, 19, 36, "Output",
   CellTags->"b:0.4.6",
   CellID->478032402],
  Cell[112619, 4124, 127, 4, 70, "Input",
   CellTags->"b:0.4.6",
   CellID->28871706],
  Cell[112749, 4130, 311, 9, 50, "Output",
   CellTags->"b:0.4.6",
   CellID->728560033],
  Cell[113075, 4142, 287, 7, 70, "Text",
   CellTags->"b:0.4.6",
   CellID->623263418]},
 "c:13"->{
  Cell[113399, 4154, 91, 2, 70, "Subsection",
   CellTags->{"c:13", "b:0.4.7"},
   CellID->239124212]},
 "b:0.4.7"->{
  Cell[113399, 4154, 91, 2, 70, "Subsection",
   CellTags->{"c:13", "b:0.4.7"},
   CellID->239124212],
  Cell[113493, 4158, 349, 11, 70, "Text",
   CellTags->"b:0.4.7",
   CellID->758815075],
  Cell[113867, 4173, 282, 8, 70, "Input",
   CellTags->"b:0.4.7",
   CellID->34244212],
  Cell[114152, 4183, 273, 9, 36, "Output",
   CellTags->"b:0.4.7",
   CellID->977687334],
  Cell[114440, 4195, 147, 5, 70, "Text",
   CellTags->"b:0.4.7",
   CellID->578481874],
  Cell[114612, 4204, 343, 10, 70, "Input",
   CellTags->"b:0.4.7",
   CellID->80963487],
  Cell[114958, 4216, 394, 13, 36, "Output",
   CellTags->"b:0.4.7",
   CellID->588842050]},
 "c:14"->{
  Cell[115401, 4235, 85, 2, 70, "Subsection",
   CellTags->{"c:14", "b:0.4.8"},
   CellID->343107939]},
 "b:0.4.8"->{
  Cell[115401, 4235, 85, 2, 70, "Subsection",
   CellTags->{"c:14", "b:0.4.8"},
   CellID->343107939],
  Cell[115489, 4239, 337, 9, 70, "Text",
   CellTags->"b:0.4.8",
   CellID->19737335],
  Cell[115851, 4252, 150, 4, 70, "Input",
   CellTags->"b:0.4.8",
   CellID->20551734],
  Cell[116004, 4258, 289, 9, 36, "Output",
   CellTags->"b:0.4.8",
   CellID->34809990],
  Cell[116308, 4270, 173, 5, 70, "Text",
   CellTags->"b:0.4.8",
   CellID->27447488],
  Cell[116506, 4279, 281, 8, 70, "Input",
   CellTags->"b:0.4.8",
   CellID->107169258],
  Cell[116790, 4289, 347, 10, 36, "Output",
   CellTags->"b:0.4.8",
   CellID->20960328],
  Cell[117152, 4302, 148, 5, 70, "Text",
   CellTags->"b:0.4.8",
   CellID->60098082],
  Cell[117325, 4311, 174, 5, 70, "Input",
   CellTags->"b:0.4.8",
   CellID->72110840],
  Cell[117502, 4318, 262, 9, 36, "Output",
   CellTags->"b:0.4.8",
   CellID->515316641],
  Cell[117779, 4330, 244, 9, 70, "Text",
   CellTags->"b:0.4.8",
   CellID->103751328],
  Cell[118048, 4343, 187, 5, 70, "Input",
   CellTags->"b:0.4.8",
   CellID->460561670],
  Cell[118238, 4350, 299, 9, 36, "Output",
   CellTags->"b:0.4.8",
   CellID->1004147207],
  Cell[118552, 4362, 159, 5, 70, "Text",
   CellTags->"b:0.4.8",
   CellID->656954062],
  Cell[118736, 4371, 194, 6, 70, "Input",
   CellTags->"b:0.4.8",
   CellID->1019234],
  Cell[118933, 4379, 254, 8, 36, "Output",
   CellTags->"b:0.4.8",
   CellID->135279393],
  Cell[119202, 4390, 101, 2, 70, "Text",
   CellTags->"b:0.4.8",
   CellID->241434771],
  Cell[119328, 4396, 203, 6, 70, "Input",
   CellTags->"b:0.4.8",
   CellID->171055668],
  Cell[119534, 4404, 286, 9, 36, "Output",
   CellTags->"b:0.4.8",
   CellID->802280320],
  Cell[119835, 4416, 314, 9, 70, "Text",
   CellTags->"b:0.4.8",
   CellID->590437369],
  Cell[120174, 4429, 201, 6, 70, "Input",
   CellTags->"b:0.4.8",
   CellID->4669335],
  Cell[120378, 4437, 291, 9, 71, "Output",
   CellTags->"b:0.4.8",
   CellID->44401504],
  Cell[120684, 4449, 177, 5, 70, "Text",
   CellTags->"b:0.4.8",
   CellID->11065132],
  Cell[120886, 4458, 220, 6, 70, "Input",
   CellTags->"b:0.4.8",
   CellID->386084822],
  Cell[121109, 4466, 348, 10, 36, "Output",
   CellTags->"b:0.4.8",
   CellID->364330143],
  Cell[121494, 4481, 219, 6, 70, "Input",
   CellTags->"b:0.4.8",
   CellID->60902233],
  Cell[121716, 4489, 348, 10, 36, "Output",
   CellTags->"b:0.4.8",
   CellID->106027777],
  Cell[122101, 4504, 302, 8, 70, "Input",
   CellTags->"b:0.4.8",
   CellID->73670271],
  Cell[122406, 4514, 303, 9, 36, "Output",
   CellTags->"b:0.4.8",
   CellID->293993995],
  Cell[122746, 4528, 377, 10, 70, "Input",
   CellTags->"b:0.4.8",
   CellID->153068299],
  Cell[123126, 4540, 513, 13, 36, "Output",
   CellTags->"b:0.4.8",
   CellID->129996884],
  Cell[123654, 4556, 187, 5, 70, "Text",
   CellTags->"b:0.4.8",
   CellID->307113028],
  Cell[123866, 4565, 491, 15, 70, "Input",
   CellTags->"b:0.4.8",
   CellID->36223674],
  Cell[124360, 4582, 323, 9, 50, "Output",
   CellTags->"b:0.4.8",
   CellID->409814246]},
 "c:15"->{
  Cell[124744, 4598, 72, 2, 70, "Section",
   CellTags->"c:15",
   CellID->759470019]},
 "c:15.5"->{
  Cell[124841, 4604, 83, 2, 70, "Subsection",
   CellTags->{"c:15.5", "b:0.5.0"},
   CellID->20697950]},
 "b:0.5.0"->{
  Cell[124841, 4604, 83, 2, 70, "Subsection",
   CellTags->{"c:15.5", "b:0.5.0"},
   CellID->20697950],
  Cell[124927, 4608, 493, 13, 70, "Text",
   CellTags->"b:0.5.0",
   CellID->86791152],
  Cell[125423, 4623, 210, 7, 70, "Text",
   CellTags->"b:0.5.0",
   CellID->323888524],
  Cell[125636, 4632, 2866, 85, 70, "DefinitionBox3Col",
   CellTags->"b:0.5.0",
   CellID->43654671],
  Cell[128505, 4719, 115, 2, 70, "Text",
   CellTags->"b:0.5.0",
   CellID->575279163]},
 "c:16"->{
  Cell[128657, 4726, 80, 2, 70, "Subsection",
   CellTags->{"c:16", "b:0.5.1"},
   CellID->120637313]},
 "b:0.5.1"->{
  Cell[128657, 4726, 80, 2, 70, "Subsection",
   CellTags->{"c:16", "b:0.5.1"},
   CellID->120637313],
  Cell[128740, 4730, 514, 18, 70, "Text",
   CellTags->"b:0.5.1",
   CellID->332493086],
  Cell[129257, 4750, 259, 8, 70, "Text",
   CellTags->"b:0.5.1",
   CellID->163086882],
  Cell[129519, 4760, 137, 7, 70, "Program",
   CellTags->"b:0.5.1",
   CellID->203403607],
  Cell[129659, 4769, 163, 7, 70, "Text",
   CellTags->"b:0.5.1",
   CellID->258819916],
  Cell[129847, 4780, 431, 13, 70, "Input",
   CellTags->"b:0.5.1",
   CellID->403377399],
  Cell[130281, 4795, 81, 2, 70, "Print",
   CellTags->"b:0.5.1",
   CellID->13390572],
  Cell[130377, 4800, 534, 19, 70, "Text",
   CellTags->"b:0.5.1",
   CellID->130918903],
  Cell[130914, 4821, 108, 2, 70, "Text",
   CellTags->"b:0.5.1",
   CellID->272631892],
  Cell[131025, 4825, 172, 7, 70, "Program",
   CellTags->"b:0.5.1",
   CellID->67879431],
  Cell[131200, 4834, 146, 7, 70, "Text",
   CellTags->"b:0.5.1",
   CellID->175118403],
  Cell[131371, 4845, 777, 24, 70, "Input",
   CellTags->"b:0.5.1",
   CellID->399472551],
  Cell[132151, 4871, 303, 8, 70, "Print",
   CellTags->"b:0.5.1",
   CellID->354731971],
  Cell[132469, 4882, 127, 4, 70, "Text",
   CellTags->"b:0.5.1",
   CellID->161491337],
  Cell[132599, 4888, 149, 5, 70, "Program",
   CellTags->"b:0.5.1",
   CellID->785509705],
  Cell[132751, 4895, 281, 12, 70, "Text",
   CellTags->"b:0.5.1",
   CellID->445860386],
  Cell[133057, 4911, 611, 19, 70, "Input",
   CellTags->"b:0.5.1",
   CellID->682251121],
  Cell[133671, 4932, 264, 9, 36, "Output",
   CellTags->"b:0.5.1",
   CellID->66729238],
  Cell[133950, 4944, 210, 7, 70, "Text",
   CellTags->"b:0.5.1",
   CellID->20175135],
  Cell[134163, 4953, 121, 5, 70, "Program",
   CellTags->"b:0.5.1",
   CellID->19723038],
  Cell[134287, 4960, 297, 12, 70, "Text",
   CellTags->"b:0.5.1",
   CellID->781694409],
  Cell[134609, 4976, 341, 11, 70, "Input",
   CellTags->"b:0.5.1",
   CellID->43441911],
  Cell[134953, 4989, 290, 9, 36, "Output",
   CellTags->"b:0.5.1",
   CellID->402829830]},
 "c:17"->{
  Cell[135292, 5004, 84, 2, 70, "Subsection",
   CellTags->{"c:17", "b:0.5.2"},
   CellID->163295011]},
 "b:0.5.2"->{
  Cell[135292, 5004, 84, 2, 70, "Subsection",
   CellTags->{"c:17", "b:0.5.2"},
   CellID->163295011],
  Cell[135379, 5008, 520, 20, 70, "Text",
   CellTags->"b:0.5.2",
   CellID->51683055],
  Cell[135902, 5030, 107, 5, 70, "Program",
   CellTags->"b:0.5.2",
   CellID->384257252],
  Cell[136012, 5037, 114, 2, 70, "Text",
   CellTags->"b:0.5.2",
   CellID->179104029],
  Cell[136151, 5043, 349, 10, 70, "Input",
   CellTags->"b:0.5.2",
   CellID->252897767],
  Cell[136503, 5055, 195, 6, 36, "Output",
   CellTags->"b:0.5.2",
   CellID->152663893],
  Cell[136713, 5064, 195, 7, 70, "Text",
   CellTags->"b:0.5.2",
   CellID->317632773],
  Cell[136911, 5073, 79, 2, 70, "Program",
   CellTags->"b:0.5.2",
   CellID->152813715],
  Cell[137015, 5079, 253, 8, 70, "Input",
   CellTags->"b:0.5.2",
   CellID->341597359],
  Cell[137271, 5089, 195, 6, 36, "Output",
   CellTags->"b:0.5.2",
   CellID->294762643],
  Cell[137481, 5098, 299, 11, 70, "Text",
   CellTags->"b:0.5.2",
   CellID->183807183],
  Cell[137783, 5111, 115, 5, 70, "Program",
   CellTags->"b:0.5.2",
   CellID->409627135],
  Cell[137923, 5120, 342, 10, 70, "Input",
   CellTags->"b:0.5.2",
   CellID->69447560],
  Cell[138268, 5132, 201, 6, 36, "Output",
   CellTags->"b:0.5.2",
   CellID->406228538]},
 "c:18"->{
  Cell[138518, 5144, 83, 2, 70, "Subsection",
   CellTags->{"c:18", "b:0.5.3"},
   CellID->45791734]},
 "b:0.5.3"->{
  Cell[138518, 5144, 83, 2, 70, "Subsection",
   CellTags->{"c:18", "b:0.5.3"},
   CellID->45791734],
  Cell[138604, 5148, 340, 14, 70, "Text",
   CellTags->"b:0.5.3",
   CellID->12267911],
  Cell[138947, 5164, 109, 5, 70, "Program",
   CellTags->"b:0.5.3",
   CellID->189290885],
  Cell[139081, 5173, 254, 7, 70, "Input",
   CellTags->"b:0.5.3",
   CellID->229530619],
  Cell[139338, 5182, 268, 9, 36, "Output",
   CellTags->"b:0.5.3",
   CellID->504939231],
  Cell[139621, 5194, 196, 7, 70, "Text",
   CellTags->"b:0.5.3",
   CellID->240418930],
  Cell[139820, 5203, 80, 2, 70, "Program",
   CellTags->"b:0.5.3",
   CellID->719922593],
  Cell[139925, 5209, 175, 5, 70, "Input",
   CellTags->"b:0.5.3",
   CellID->502233132],
  Cell[140103, 5216, 249, 8, 36, "Output",
   CellTags->"b:0.5.3",
   CellID->355681688],
  Cell[140367, 5227, 601, 18, 70, "Text",
   CellTags->"b:0.5.3",
   CellID->78986018],
  Cell[140971, 5247, 151, 5, 70, "Program",
   CellTags->"b:0.5.3",
   CellID->348675863],
  Cell[141147, 5256, 428, 13, 70, "Input",
   CellTags->"b:0.5.3",
   CellID->639488513],
  Cell[141578, 5271, 277, 9, 50, "Output",
   CellTags->"b:0.5.3",
   CellID->614879701],
  Cell[141892, 5285, 470, 15, 70, "Input",
   CellTags->"b:0.5.3",
   CellID->34696905],
  Cell[142365, 5302, 296, 9, 50, "Output",
   CellTags->"b:0.5.3",
   CellID->77828007]},
 "c:19"->{
  Cell[142710, 5317, 85, 2, 70, "Subsection",
   CellTags->{"c:19", "b:0.5.4"},
   CellID->627179989]},
 "b:0.5.4"->{
  Cell[142710, 5317, 85, 2, 70, "Subsection",
   CellTags->{"c:19", "b:0.5.4"},
   CellID->627179989],
  Cell[142798, 5321, 392, 14, 70, "Text",
   CellTags->"b:0.5.4",
   CellID->512373978],
  Cell[143193, 5337, 472, 16, 70, "Text",
   CellTags->"b:0.5.4",
   CellID->75100454],
  Cell[143668, 5355, 107, 5, 70, "Program",
   CellTags->"b:0.5.4",
   CellID->2535425],
  Cell[143778, 5362, 295, 12, 70, "Text",
   CellTags->"b:0.5.4",
   CellID->616093666],
  Cell[144098, 5378, 443, 13, 70, "Input",
   CellTags->"b:0.5.4",
   CellID->394779265],
  Cell[144544, 5393, 194, 6, 36, "Output",
   CellTags->"b:0.5.4",
   CellID->44331865],
  Cell[144753, 5402, 393, 13, 70, "Text",
   CellTags->"b:0.5.4",
   CellID->44095121],
  Cell[145149, 5417, 116, 5, 70, "Program",
   CellTags->"b:0.5.4",
   CellID->260896876],
  Cell[145290, 5426, 615, 18, 70, "Input",
   CellTags->"b:0.5.4",
   CellID->37744320],
  Cell[145908, 5446, 198, 6, 36, "Output",
   CellTags->"b:0.5.4",
   CellID->232622468],
  Cell[146121, 5455, 312, 12, 70, "Text",
   CellTags->"b:0.5.4",
   CellID->291617831],
  Cell[146436, 5469, 114, 5, 70, "Program",
   CellTags->"b:0.5.4",
   CellID->820168201],
  Cell[146575, 5478, 382, 12, 70, "Input",
   CellTags->"b:0.5.4",
   CellID->96850109],
  Cell[146960, 5492, 201, 6, 36, "Output",
   CellTags->"b:0.5.4",
   CellID->17256542],
  Cell[147176, 5501, 197, 7, 70, "Text",
   CellTags->"b:0.5.4",
   CellID->206615673],
  Cell[147376, 5510, 115, 5, 70, "Program",
   CellTags->"b:0.5.4",
   CellID->1448094],
  Cell[147516, 5519, 616, 18, 70, "Input",
   CellTags->"b:0.5.4",
   CellID->297013012],
  Cell[148135, 5539, 195, 6, 36, "Output",
   CellTags->"b:0.5.4",
   CellID->16752287],
  Cell[148345, 5548, 199, 7, 70, "Text",
   CellTags->"b:0.5.4",
   CellID->809943646],
  Cell[148547, 5557, 80, 2, 70, "Program",
   CellTags->"b:0.5.4",
   CellID->727836643],
  Cell[148652, 5563, 286, 9, 70, "Input",
   CellTags->"b:0.5.4",
   CellID->32783502],
  Cell[148941, 5574, 198, 6, 36, "Output",
   CellTags->"b:0.5.4",
   CellID->494744495],
  Cell[149176, 5585, 261, 8, 70, "Input",
   CellTags->"b:0.5.4",
   CellID->190461549],
  Cell[149440, 5595, 198, 6, 36, "Output",
   CellTags->"b:0.5.4",
   CellID->226552420],
  Cell[149653, 5604, 229, 8, 70, "Text",
   CellTags->"b:0.5.4",
   CellID->117673595],
  Cell[149885, 5614, 130, 5, 70, "Program",
   CellTags->"b:0.5.4",
   CellID->144624070],
  Cell[150018, 5621, 333, 14, 70, "Text",
   CellTags->"b:0.5.4",
   CellID->688187582],
  Cell[150376, 5639, 694, 21, 70, "Input",
   CellTags->"b:0.5.4",
   CellID->141316627],
  Cell[151073, 5662, 195, 6, 36, "Output",
   CellTags->"b:0.5.4",
   CellID->19380011]},
 "c:20"->{
  Cell[151329, 5675, 69, 2, 70, "Section",
   CellTags->"c:20",
   CellID->2083974]},
 "c:22"->{
  Cell[151559, 5687, 92, 2, 70, "Subsection",
   CellTags->{"c:22", "b:0.6.1"},
   CellID->738873845]},
 "b:0.6.1"->{
  Cell[151559, 5687, 92, 2, 70, "Subsection",
   CellTags->{"c:22", "b:0.6.1"},
   CellID->738873845],
  Cell[151654, 5691, 100, 2, 70, "Text",
   CellTags->"b:0.6.1",
   CellID->24257838],
  Cell[151779, 5697, 603, 19, 70, "Input",
   CellTags->"b:0.6.1",
   CellID->140406151],
  Cell[152385, 5718, 1219, 20, 241, "Output",
   CellTags->"b:0.6.1",
   CellID->138371101],
  Cell[153619, 5741, 128, 4, 70, "Text",
   CellTags->"b:0.6.1",
   CellID->301369684],
  Cell[153772, 5749, 586, 18, 70, "Input",
   CellTags->"b:0.6.1",
   CellID->614903007],
  Cell[154361, 5769, 1608, 25, 258, "Output",
   CellTags->"b:0.6.1",
   CellID->66298060],
  Cell[155984, 5797, 108, 2, 70, "Text",
   CellTags->"b:0.6.1",
   CellID->12939824],
  Cell[156117, 5803, 372, 10, 70, "Input",
   CellTags->"b:0.6.1",
   CellID->131627168],
  Cell[156492, 5815, 1609, 25, 258, "Output",
   CellTags->"b:0.6.1",
   CellID->174902817]},
 "c:23"->{
  Cell[158150, 5846, 86, 2, 70, "Subsection",
   CellTags->{"c:23", "b:0.6.2"},
   CellID->146223979]},
 "b:0.6.2"->{
  Cell[158150, 5846, 86, 2, 70, "Subsection",
   CellTags->{"c:23", "b:0.6.2"},
   CellID->146223979],
  Cell[158239, 5850, 150, 5, 70, "Text",
   CellTags->"b:0.6.2",
   CellID->454604247],
  Cell[158392, 5857, 216, 9, 70, "Text",
   CellTags->"b:0.6.2",
   CellID->450806450],
  Cell[158611, 5868, 3090, 54, 70, "Input",
   CellTags->"b:0.6.2",
   CellID->237894310],
  Cell[161726, 5926, 134, 4, 70, "Input",
   CellTags->"b:0.6.2",
   CellID->73854272],
  Cell[161863, 5932, 184, 6, 36, "Output",
   CellTags->"b:0.6.2",
   CellID->17257751],
  Cell[162062, 5941, 112, 2, 70, "Text",
   CellTags->"b:0.6.2",
   CellID->328231447],
  Cell[162199, 5947, 539, 16, 70, "Input",
   CellTags->"b:0.6.2",
   CellID->10965036],
  Cell[162741, 5965, 659, 15, 88, "Output",
   CellTags->"b:0.6.2",
   CellID->141092163],
  Cell[163415, 5983, 141, 6, 70, "Text",
   CellTags->"b:0.6.2",
   CellID->135521350],
  Cell[163581, 5993, 294, 9, 70, "Input",
   CellTags->"b:0.6.2",
   CellID->499683580],
  Cell[163878, 6004, 812, 15, 292, "Output",
   CellTags->"b:0.6.2",
   CellID->408181342]},
 "c:24"->{
  Cell[164739, 6025, 84, 2, 70, "Subsection",
   CellTags->{"c:24", "b:0.6.3"},
   CellID->263221749]},
 "b:0.6.3"->{
  Cell[164739, 6025, 84, 2, 70, "Subsection",
   CellTags->{"c:24", "b:0.6.3"},
   CellID->263221749],
  Cell[164826, 6029, 134, 4, 70, "Text",
   CellTags->"b:0.6.3",
   CellID->456762081],
  Cell[164985, 6037, 191, 6, 70, "Input",
   CellTags->"b:0.6.3",
   CellID->324262933],
  Cell[165179, 6045, 252, 7, 36, "Output",
   CellTags->"b:0.6.3",
   CellID->129687686],
  Cell[165446, 6055, 129, 4, 70, "Text",
   CellTags->"b:0.6.3",
   CellID->47750368],
  Cell[165600, 6063, 422, 14, 70, "Input",
   CellTags->"b:0.6.3",
   CellID->16455114],
  Cell[166025, 6079, 252, 8, 36, "Output",
   CellTags->"b:0.6.3",
   CellID->338551607],
  Cell[166292, 6090, 174, 5, 70, "Text",
   CellTags->"b:0.6.3",
   CellID->507462346],
  Cell[166491, 6099, 238, 8, 70, "Input",
   CellTags->"b:0.6.3",
   CellID->28199983],
  Cell[166732, 6109, 252, 8, 36, "Output",
   CellTags->"b:0.6.3",
   CellID->388857756],
  Cell[166999, 6120, 279, 9, 70, "Text",
   CellTags->"b:0.6.3",
   CellID->1024052339],
  Cell[167303, 6133, 199, 6, 70, "Input",
   CellTags->"b:0.6.3",
   CellID->5891025],
  Cell[167505, 6141, 252, 8, 36, "Output",
   CellTags->"b:0.6.3",
   CellID->209255404]},
 "b:0.6.4"->{
  Cell[167806, 6155, 82, 2, 70, "Subsection",
   CellTags->"b:0.6.4",
   CellID->355263806],
  Cell[167891, 6159, 183, 5, 70, "Text",
   CellTags->"b:0.6.4",
   CellID->115242927],
  Cell[168077, 6166, 717, 23, 70, "Input",
   CellTags->"b:0.6.4",
   CellID->78571466],
  Cell[168797, 6191, 89, 2, 70, "Text",
   CellTags->"b:0.6.4",
   CellID->97869725],
  Cell[168911, 6197, 359, 10, 70, "Input",
   CellTags->"b:0.6.4",
   CellID->46155371],
  Cell[169273, 6209, 197, 6, 36, "Output",
   CellTags->"b:0.6.4",
   CellID->231537702],
  Cell[169485, 6218, 187, 6, 70, "Text",
   CellTags->"b:0.6.4",
   CellID->252811811],
  Cell[169697, 6228, 211, 7, 70, "Input",
   CellTags->"b:0.6.4",
   CellID->580624370],
  Cell[169911, 6237, 696, 22, 62, "Output",
   CellTags->"b:0.6.4",
   CellID->513917472],
  Cell[170622, 6262, 155, 6, 70, "Text",
   CellTags->"b:0.6.4",
   CellID->612266699],
  Cell[170802, 6272, 261, 8, 70, "Input",
   CellTags->"b:0.6.4",
   CellID->28035752],
  Cell[171066, 6282, 704, 22, 62, "Output",
   CellTags->"b:0.6.4",
   CellID->449106445]},
 "c:25"->{
  Cell[171831, 6311, 126, 2, 70, "Section",
   CellTags->{"c:25", "Tips and Tricks", "b:0.7"},
   CellID->319138910]},
 "Tips and Tricks"->{
  Cell[171831, 6311, 126, 2, 70, "Section",
   CellTags->{"c:25", "Tips and Tricks", "b:0.7"},
   CellID->319138910]},
 "b:0.7"->{
  Cell[171831, 6311, 126, 2, 70, "Section",
   CellTags->{"c:25", "Tips and Tricks", "b:0.7"},
   CellID->319138910],
  Cell[171960, 6315, 147, 5, 70, "Text",
   CellTags->"b:0.7",
   CellID->1088522],
  Cell[172132, 6324, 113, 2, 70, "Subsection",
   CellTags->{"c:26", "b:0.7"},
   CellID->571253149],
  Cell[172248, 6328, 538, 13, 70, "Text",
   CellTags->"b:0.7",
   CellID->527245798],
  Cell[172823, 6346, 98, 2, 70, "Subsection",
   CellTags->{"c:27", "b:0.7"},
   CellID->11710184],
  Cell[172924, 6350, 675, 22, 70, "Text",
   CellTags->"b:0.7",
   CellID->168089851],
  Cell[173602, 6374, 465, 14, 70, "Input",
   CellTags->"b:0.7",
   CellID->45298985],
  Cell[174092, 6392, 254, 9, 70, "Input",
   CellTags->"b:0.7",
   CellID->334473682],
  Cell[174349, 6403, 258, 9, 36, "Output",
   CellTags->"b:0.7",
   CellID->136821287],
  Cell[174644, 6417, 251, 9, 70, "Input",
   CellTags->"b:0.7",
   CellID->108146462],
  Cell[174898, 6428, 279, 10, 36, "Output",
   CellTags->"b:0.7",
   CellID->152242574],
  Cell[175226, 6444, 95, 2, 70, "Subsection",
   CellTags->{"c:28", "b:0.7"},
   CellID->39608680],
  Cell[175324, 6448, 660, 16, 70, "Text",
   CellTags->"b:0.7",
   CellID->350158018],
  Cell[176021, 6469, 101, 2, 70, "Subsection",
   CellTags->{"c:29", "b:0.7"},
   CellID->73358011],
  Cell[176125, 6473, 842, 22, 70, "Text",
   CellTags->"b:0.7",
   CellID->274569970],
  Cell[176970, 6497, 768, 24, 70, "Input",
   CellTags->"b:0.7",
   CellID->88405937],
  Cell[177763, 6525, 148, 5, 70, "Input",
   CellTags->"b:0.7",
   CellID->171329605],
  Cell[177914, 6532, 290, 9, 36, "Output",
   CellTags->"b:0.7",
   CellID->85423907],
  Cell[178219, 6544, 363, 14, 70, "Text",
   CellTags->"b:0.7",
   CellID->482988001],
  Cell[178607, 6562, 384, 13, 70, "Input",
   CellTags->"b:0.7",
   CellID->235104226],
  Cell[178994, 6577, 1801, 36, 156, "Output",
   CellTags->"b:0.7",
   CellID->92602603],
  Cell[180810, 6616, 440, 14, 70, "Text",
   CellTags->"b:0.7",
   CellID->940575378],
  Cell[181275, 6634, 360, 12, 70, "Input",
   CellTags->"b:0.7",
   CellID->159751616],
  Cell[181638, 6648, 1784, 36, 156, "Output",
   CellTags->"b:0.7",
   CellID->122373159],
  Cell[183437, 6687, 698, 21, 70, "Text",
   CellTags->"b:0.7",
   CellID->440945305],
  Cell[184160, 6712, 413, 13, 70, "Input",
   CellTags->"b:0.7",
   CellID->344941105],
  Cell[184576, 6727, 1783, 36, 156, "Output",
   CellTags->"b:0.7",
   CellID->52135009],
  Cell[186408, 6769, 126, 2, 70, "Subsection",
   CellTags->{"c:30", "b:0.7"},
   CellID->148652143],
  Cell[186537, 6773, 640, 15, 70, "Text",
   CellTags->"b:0.7",
   CellID->13332812],
  Cell[187180, 6790, 258, 6, 70, "Text",
   CellTags->"b:0.7",
   CellID->349310128],
  Cell[187463, 6800, 550, 17, 70, "Input",
   CellTags->"b:0.7",
   CellID->34682433],
  Cell[188016, 6819, 695, 17, 71, "Output",
   CellTags->"b:0.7",
   CellID->228226476],
  Cell[188726, 6839, 149, 5, 70, "Text",
   CellTags->"b:0.7",
   CellID->19330986],
  Cell[188900, 6848, 658, 19, 70, "Input",
   CellTags->"b:0.7",
   CellID->115301483],
  Cell[189561, 6869, 695, 17, 71, "Output",
   CellTags->"b:0.7",
   CellID->626257199],
  Cell[190271, 6889, 389, 14, 70, "Text",
   CellTags->"b:0.7",
   CellID->309333144],
  Cell[190685, 6907, 839, 25, 70, "Input",
   CellTags->"b:0.7",
   CellID->238693932],
  Cell[191527, 6934, 696, 17, 71, "Output",
   CellTags->"b:0.7",
   CellID->424288253],
  Cell[192260, 6956, 701, 19, 70, "Input",
   CellTags->"b:0.7",
   CellID->74230660],
  Cell[192964, 6977, 888, 21, 71, "Output",
   CellTags->"b:0.7",
   CellID->33082105],
  Cell[193867, 7001, 110, 2, 70, "Text",
   CellTags->"b:0.7",
   CellID->778852497],
  Cell[193980, 7005, 318, 12, 70, "Input",
   CellTags->"b:0.7",
   CellID->166716726],
  Cell[194323, 7021, 152, 5, 70, "Input",
   CellTags->"b:0.7",
   CellID->143881214],
  Cell[194478, 7028, 310, 11, 36, "Output",
   CellTags->"b:0.7",
   CellID->142292458],
  Cell[194825, 7044, 303, 10, 70, "Input",
   CellTags->"b:0.7",
   CellID->9520874],
  Cell[195131, 7056, 280, 10, 36, "Output",
   CellTags->"b:0.7",
   CellID->209053402],
  Cell[195426, 7069, 185, 6, 70, "Input",
   CellTags->"b:0.7",
   CellID->55052828],
  Cell[195636, 7079, 206, 6, 70, "Input",
   CellTags->"b:0.7",
   CellID->106844855],
  Cell[195845, 7087, 386, 14, 36, "Output",
   CellTags->"b:0.7",
   CellID->83809943],
  Cell[196268, 7106, 334, 10, 70, "Input",
   CellTags->"b:0.7",
   CellID->483013677],
  Cell[196605, 7118, 257, 9, 36, "Output",
   CellTags->"b:0.7",
   CellID->544100]},
 "c:26"->{
  Cell[172132, 6324, 113, 2, 70, "Subsection",
   CellTags->{"c:26", "b:0.7"},
   CellID->571253149]},
 "c:27"->{
  Cell[172823, 6346, 98, 2, 70, "Subsection",
   CellTags->{"c:27", "b:0.7"},
   CellID->11710184]},
 "c:28"->{
  Cell[175226, 6444, 95, 2, 70, "Subsection",
   CellTags->{"c:28", "b:0.7"},
   CellID->39608680]},
 "c:29"->{
  Cell[176021, 6469, 101, 2, 70, "Subsection",
   CellTags->{"c:29", "b:0.7"},
   CellID->73358011]},
 "c:30"->{
  Cell[186408, 6769, 126, 2, 70, "Subsection",
   CellTags->{"c:30", "b:0.7"},
   CellID->148652143]},
 "c:31"->{
  Cell[196923, 7134, 91, 2, 70, "Section",
   CellTags->{"c:31", "b:0.8"},
   CellID->337819047]},
 "b:0.8"->{
  Cell[196923, 7134, 91, 2, 70, "Section",
   CellTags->{"c:31", "b:0.8"},
   CellID->337819047],
  Cell[197017, 7138, 360, 12, 70, "Text",
   CellTags->"b:0.8",
   CellID->68963779],
  Cell[197380, 7152, 246, 9, 70, "Text",
   CellTags->"b:0.8",
   CellID->57047539],
  Cell[197629, 7163, 277, 7, 70, "Text",
   CellTags->"b:0.8",
   CellID->169990753],
  Cell[197931, 7174, 277, 8, 70, "Input",
   CellTags->"b:0.8",
   CellID->201123037],
  Cell[198211, 7184, 224, 6, 50, "Output",
   CellTags->"b:0.8",
   CellID->85850298],
  Cell[198450, 7193, 217, 5, 70, "Text",
   CellTags->"b:0.8",
   CellID->190255727],
  Cell[198670, 7200, 289, 6, 70, "Text",
   CellTags->"b:0.8",
   CellID->210149359],
  Cell[198962, 7208, 314, 10, 70, "Text",
   CellTags->"b:0.8",
   CellID->953153723],
  Cell[199279, 7220, 510, 13, 70, "Text",
   CellTags->"b:0.8",
   CellID->198359003],
  Cell[199792, 7235, 926, 27, 70, "Text",
   CellTags->"b:0.8",
   CellID->908430859],
  Cell[200721, 7264, 715, 23, 70, "Text",
   CellTags->"b:0.8",
   CellID->1015887440]},
 "c:32"->{
  Cell[201473, 7292, 79, 2, 70, "Section",
   CellTags->{"c:32", "b:0.9"},
   CellID->503575505]},
 "b:0.9"->{
  Cell[201473, 7292, 79, 2, 70, "Section",
   CellTags->{"c:32", "b:0.9"},
   CellID->503575505],
  Cell[201555, 7296, 329, 10, 70, "Text",
   CellTags->{"Ref-1", "b:0.9"},
   CellID->872737084],
  Cell[201887, 7308, 230, 7, 70, "Text",
   CellTags->{"Ref-2", "b:0.9"},
   CellID->201956504]},
 "Ref-1"->{
  Cell[201555, 7296, 329, 10, 70, "Text",
   CellTags->{"Ref-1", "b:0.9"},
   CellID->872737084]},
 "Ref-2"->{
  Cell[201887, 7308, 230, 7, 70, "Text",
   CellTags->{"Ref-2", "b:0.9"},
   CellID->201956504]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"c:1", 204222, 7363},
 {"b:0.0", 204326, 7367},
 {"c:2", 206444, 7443},
 {"b:0.1", 206552, 7447},
 {"Regular Expressions", 211554, 7622},
 {"c:3", 211685, 7626},
 {"b:0.2", 211818, 7630},
 {"c:4", 217212, 7817},
 {"b:0.3", 217322, 7821},
 {"c:5", 217788, 7837},
 {"c:6", 217884, 7841},
 {"b:0.4.0", 218000, 7845},
 {"c:7", 219691, 7903},
 {"b:0.4.1", 219807, 7907},
 {"c:8", 220360, 7926},
 {"b:0.4.2", 220474, 7930},
 {"c:9", 222341, 7994},
 {"b:0.4.3", 222457, 7998},
 {"c:10", 224340, 8062},
 {"b:0.4.4", 224458, 8066},
 {"c:11", 225556, 8103},
 {"b:0.4.5", 225674, 8107},
 {"c:12", 226324, 8129},
 {"b:0.4.6", 226440, 8133},
 {"c:13", 228153, 8191},
 {"b:0.4.7", 228271, 8195},
 {"c:14", 228921, 8217},
 {"b:0.4.8", 229039, 8221},
 {"c:15", 232085, 8324},
 {"c:15.5", 232186, 8328},
 {"b:0.5.0", 232305, 8332},
 {"c:16", 232787, 8348},
 {"b:0.5.1", 232905, 8352},
 {"c:17", 234979, 8422},
 {"b:0.5.2", 235097, 8426},
 {"c:18", 236375, 8469},
 {"b:0.5.3", 236492, 8473},
 {"c:19", 237858, 8519},
 {"b:0.5.4", 237976, 8523},
 {"c:20", 240679, 8614},
 {"c:22", 240776, 8618},
 {"b:0.6.1", 240894, 8622},
 {"c:23", 241819, 8653},
 {"b:0.6.2", 241937, 8657},
 {"c:24", 243033, 8694},
 {"b:0.6.3", 243151, 8698},
 {"b:0.6.4", 244334, 8738},
 {"c:25", 245416, 8775},
 {"Tips and Tricks", 245557, 8779},
 {"b:0.7", 245688, 8783},
 {"c:26", 250258, 8937},
 {"c:27", 250372, 8941},
 {"c:28", 250484, 8945},
 {"c:29", 250596, 8949},
 {"c:30", 250709, 8953},
 {"c:31", 250823, 8957},
 {"b:0.8", 250934, 8961},
 {"c:32", 251996, 8998},
 {"b:0.9", 252107, 9002},
 {"Ref-1", 252413, 9012},
 {"Ref-2", 252524, 9016}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 3666, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4291, 90, 78, 2, 70, "Section",
 CellTags->{"c:1", "b:0.0"},
 CellID->6475218],
Cell[4372, 94, 401, 10, 70, "Text",
 CellTags->"b:0.0",
 CellID->879271277],
Cell[4776, 106, 503, 17, 70, "Text",
 CellTags->"b:0.0",
 CellID->217261366],
Cell[CellGroupData[{
Cell[5304, 127, 290, 10, 28, "Input",
 CellTags->"b:0.0",
 CellID->6793186],
Cell[5597, 139, 182, 6, 36, "Output",
 CellTags->"b:0.0",
 CellID->685045409]
}, Open  ]],
Cell[CellGroupData[{
Cell[5816, 150, 302, 10, 28, "Input",
 CellTags->"b:0.0",
 CellID->397472003],
Cell[6121, 162, 181, 6, 36, "Output",
 CellTags->"b:0.0",
 CellID->136501627]
}, Open  ]],
Cell[CellGroupData[{
Cell[6339, 173, 244, 8, 28, "Input",
 CellTags->"b:0.0",
 CellID->108872960],
Cell[6586, 183, 232, 8, 36, "Output",
 CellTags->"b:0.0",
 CellID->91209889]
}, Open  ]],
Cell[6833, 194, 439, 13, 70, "Text",
 CellTags->"b:0.0",
 CellID->47601161],
Cell[CellGroupData[{
Cell[7297, 211, 246, 8, 28, "Input",
 CellTags->"b:0.0",
 CellID->164239912],
Cell[7546, 221, 182, 6, 36, "Output",
 CellTags->"b:0.0",
 CellID->965988149]
}, Open  ]],
Cell[CellGroupData[{
Cell[7765, 232, 247, 8, 28, "Input",
 CellTags->"b:0.0",
 CellID->340018981],
Cell[8015, 242, 181, 6, 36, "Output",
 CellTags->"b:0.0",
 CellID->123154041]
}, Open  ]],
Cell[CellGroupData[{
Cell[8233, 253, 176, 5, 70, "Input",
 CellTags->"b:0.0",
 CellID->327756114],
Cell[8412, 260, 259, 9, 36, "Output",
 CellTags->"b:0.0",
 CellID->522047130]
}, Open  ]],
Cell[8686, 272, 195, 5, 70, "Text",
 CellTags->"b:0.0",
 CellID->7623660],
Cell[CellGroupData[{
Cell[8906, 281, 229, 7, 70, "Input",
 CellTags->"b:0.0",
 CellID->257665367],
Cell[9138, 290, 182, 6, 36, "Output",
 CellTags->"b:0.0",
 CellID->138681442]
}, Open  ]],
Cell[CellGroupData[{
Cell[9357, 301, 229, 7, 70, "Input",
 CellTags->"b:0.0",
 CellID->15296355],
Cell[9589, 310, 180, 6, 36, "Output",
 CellTags->"b:0.0",
 CellID->48670236]
}, Open  ]],
Cell[CellGroupData[{
Cell[9806, 321, 221, 7, 70, "Input",
 CellTags->"b:0.0",
 CellID->44443359],
Cell[10030, 330, 257, 9, 36, "Output",
 CellTags->"b:0.0",
 CellID->6967547]
}, Open  ]],
Cell[10302, 342, 131, 4, 70, "Text",
 CellTags->"b:0.0",
 CellID->131976413],
Cell[10436, 348, 4552, 141, 70, "DefinitionBox",
 CellID->28981],
Cell[14991, 491, 98, 2, 70, "Caption",
 CellTags->"b:0.0",
 CellID->49176434]
}, Open  ]],
Cell[CellGroupData[{
Cell[15126, 498, 91, 2, 70, "Section",
 CellTags->{"c:2", "b:0.1"},
 CellID->316252289],
Cell[15220, 502, 470, 15, 70, "Text",
 CellTags->"b:0.1",
 CellID->775969280],
Cell[CellGroupData[{
Cell[15715, 521, 156, 5, 70, "Input",
 CellTags->"b:0.1",
 CellID->14216555],
Cell[15874, 528, 416, 15, 50, "Output",
 CellTags->"b:0.1",
 CellID->6889976]
}, Open  ]],
Cell[16305, 546, 458, 14, 70, "Text",
 CellTags->"b:0.1",
 CellID->143628873],
Cell[CellGroupData[{
Cell[16788, 564, 165, 5, 70, "Input",
 CellTags->"b:0.1",
 CellID->220445018],
Cell[16956, 571, 191, 6, 36, "Output",
 CellTags->"b:0.1",
 CellID->66432613]
}, Open  ]],
Cell[17162, 580, 708, 21, 70, "Text",
 CellTags->"b:0.1",
 CellID->100231778],
Cell[17873, 603, 160, 5, 70, "Text",
 CellTags->"b:0.1",
 CellID->206331185],
Cell[18036, 610, 4180, 132, 70, "DefinitionBox",
 CellID->31675],
Cell[22219, 744, 103, 2, 70, "Text",
 CellTags->"b:0.1",
 CellID->104465889],
Cell[22325, 748, 2759, 85, 70, "DefinitionBox",
 CellID->9253],
Cell[25087, 835, 101, 2, 70, "Text",
 CellTags->"b:0.1",
 CellID->97881266],
Cell[25191, 839, 1255, 39, 70, "DefinitionBox",
 CellID->25418],
Cell[26449, 880, 151, 5, 70, "Text",
 CellTags->"b:0.1",
 CellID->138112839],
Cell[26603, 887, 801, 26, 70, "DefinitionBox",
 CellID->20324],
Cell[27407, 915, 143, 3, 70, "Text",
 CellTags->"b:0.1",
 CellID->833514613],
Cell[27553, 920, 908, 34, 70, "Text",
 CellTags->"b:0.1",
 CellID->110717692],
Cell[CellGroupData[{
Cell[28486, 958, 174, 5, 70, "Input",
 CellTags->"b:0.1",
 CellID->32115820],
Cell[28663, 965, 224, 7, 71, "Output",
 CellTags->"b:0.1",
 CellID->191828861]
}, Open  ]],
Cell[CellGroupData[{
Cell[28924, 977, 239, 7, 70, "Input",
 CellTags->"b:0.1",
 CellID->280132484],
Cell[29166, 986, 249, 8, 36, "Output",
 CellTags->"b:0.1",
 CellID->212135941]
}, Open  ]],
Cell[CellGroupData[{
Cell[29452, 999, 228, 6, 70, "Input",
 CellTags->"b:0.1",
 CellID->406476748],
Cell[29683, 1007, 248, 8, 36, "Output",
 CellTags->"b:0.1",
 CellID->20298962]
}, Open  ]],
Cell[29946, 1018, 739, 23, 70, "Text",
 CellTags->"b:0.1",
 CellID->694363556],
Cell[CellGroupData[{
Cell[30710, 1045, 318, 9, 70, "Input",
 CellTags->"b:0.1",
 CellID->140507535],
Cell[31031, 1056, 209, 6, 36, "Output",
 CellTags->"b:0.1",
 CellID->13100792]
}, Open  ]],
Cell[31255, 1065, 562, 20, 70, "Text",
 CellTags->"b:0.1",
 CellID->48865639],
Cell[CellGroupData[{
Cell[31842, 1089, 451, 14, 70, "Input",
 CellTags->"b:0.1",
 CellID->134667756],
Cell[32296, 1105, 241, 8, 36, "Output",
 CellTags->"b:0.1",
 CellID->27162036]
}, Open  ]],
Cell[32552, 1116, 389, 14, 70, "Text",
 CellTags->"b:0.1",
 CellID->408165015],
Cell[CellGroupData[{
Cell[32966, 1134, 312, 11, 70, "Input",
 CellTags->"b:0.1",
 CellID->149685880],
Cell[33281, 1147, 264, 9, 36, "Output",
 CellTags->"b:0.1",
 CellID->707533094]
}, Open  ]],
Cell[33560, 1159, 400, 15, 70, "Text",
 CellTags->"b:0.1",
 CellID->212294979],
Cell[CellGroupData[{
Cell[33985, 1178, 229, 6, 70, "Input",
 CellTags->"b:0.1",
 CellID->318389946],
Cell[34217, 1186, 197, 6, 36, "Output",
 CellTags->"b:0.1",
 CellID->168972183]
}, Open  ]],
Cell[34429, 1195, 268, 9, 70, "Text",
 CellTags->"b:0.1",
 CellID->384134564],
Cell[CellGroupData[{
Cell[34722, 1208, 325, 10, 70, "Input",
 CellTags->"b:0.1",
 CellID->23848909],
Cell[35050, 1220, 242, 8, 36, "Output",
 CellTags->"b:0.1",
 CellID->148025619]
}, Open  ]],
Cell[35307, 1231, 347, 10, 70, "Text",
 CellTags->"b:0.1",
 CellID->603056891],
Cell[CellGroupData[{
Cell[35679, 1245, 296, 8, 70, "Input",
 CellTags->"b:0.1",
 CellID->291672169],
Cell[35978, 1255, 244, 8, 36, "Output",
 CellTags->"b:0.1",
 CellID->111286320]
}, Open  ]],
Cell[36237, 1266, 229, 8, 70, "Text",
 CellTags->"b:0.1",
 CellID->344292962],
Cell[CellGroupData[{
Cell[36491, 1278, 304, 10, 70, "Input",
 CellTags->"b:0.1",
 CellID->57194593],
Cell[36798, 1290, 249, 8, 36, "Output",
 CellTags->"b:0.1",
 CellID->384825101]
}, Open  ]],
Cell[37062, 1301, 323, 10, 70, "Text",
 CellTags->"b:0.1",
 CellID->2661260],
Cell[37388, 1313, 109, 2, 70, "Text",
 CellTags->"b:0.1",
 CellID->704437595],
Cell[CellGroupData[{
Cell[37522, 1319, 307, 9, 70, "Input",
 CellTags->"b:0.1",
 CellID->190390204],
Cell[37832, 1330, 190, 6, 36, "Output",
 CellTags->"b:0.1",
 CellID->51576904]
}, Open  ]],
Cell[38037, 1339, 584, 18, 70, "Text",
 CellTags->"b:0.1",
 CellID->422987297],
Cell[CellGroupData[{
Cell[38646, 1361, 236, 7, 70, "Input",
 CellTags->"b:0.1",
 CellID->262589375],
Cell[38885, 1370, 217, 7, 36, "Output",
 CellTags->"b:0.1",
 CellID->43459422]
}, Open  ]],
Cell[CellGroupData[{
Cell[39139, 1382, 260, 8, 70, "Input",
 CellTags->"b:0.1",
 CellID->87767072],
Cell[39402, 1392, 247, 8, 36, "Output",
 CellTags->"b:0.1",
 CellID->431541845]
}, Open  ]],
Cell[39664, 1403, 275, 10, 70, "Text",
 CellTags->"b:0.1",
 CellID->30079273],
Cell[CellGroupData[{
Cell[39964, 1417, 403, 11, 70, "Input",
 CellTags->"b:0.1",
 CellID->336262030],
Cell[40370, 1430, 240, 8, 36, "Output",
 CellTags->"b:0.1",
 CellID->238292539]
}, Open  ]],
Cell[CellGroupData[{
Cell[40647, 1443, 440, 12, 70, "Input",
 CellTags->"b:0.1",
 CellID->46781425],
Cell[41090, 1457, 243, 8, 36, "Output",
 CellTags->"b:0.1",
 CellID->46684404]
}, Open  ]],
Cell[41348, 1468, 254, 9, 70, "Text",
 CellTags->"b:0.1",
 CellID->165376289],
Cell[CellGroupData[{
Cell[41627, 1481, 434, 12, 70, "Input",
 CellTags->"b:0.1",
 CellID->33998707],
Cell[42064, 1495, 244, 8, 36, "Output",
 CellTags->"b:0.1",
 CellID->428424676]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[42357, 1509, 110, 2, 70, "Section",
 CellTags->{"Regular Expressions", "c:3", "b:0.2"},
 CellID->274403895],
Cell[42470, 1513, 635, 19, 70, "Text",
 CellTags->"b:0.2",
 CellID->179324024],
Cell[43108, 1534, 169, 5, 70, "Text",
 CellTags->"b:0.2",
 CellID->311647046],
Cell[43280, 1541, 4407, 129, 70, "DefinitionBox",
 CellID->30983],
Cell[47690, 1672, 103, 2, 70, "Text",
 CellTags->"b:0.2",
 CellID->326926809],
Cell[47796, 1676, 1026, 23, 70, "DefinitionBox",
 CellID->3341],
Cell[48825, 1701, 578, 32, 70, "Text",
 CellTags->"b:0.2",
 CellID->423328124],
Cell[49406, 1735, 101, 2, 70, "Text",
 CellTags->"b:0.2",
 CellID->53679581],
Cell[49510, 1739, 1246, 40, 70, "DefinitionBox",
 CellTags->"b:0.2",
 CellID->438051314],
Cell[50759, 1781, 146, 5, 70, "Text",
 CellTags->"b:0.2",
 CellID->446511798],
Cell[50908, 1788, 1322, 45, 70, "DefinitionBox",
 CellTags->"b:0.2",
 CellID->103937476],
Cell[52233, 1835, 106, 2, 70, "Text",
 CellTags->"b:0.2",
 CellID->725709264],
Cell[52342, 1839, 1417, 51, 70, "DefinitionBox",
 CellTags->"b:0.2",
 CellID->324529988],
Cell[53762, 1892, 161, 5, 70, "Text",
 CellTags->"b:0.2",
 CellID->36188322],
Cell[53926, 1899, 128, 4, 70, "Text",
 CellTags->"b:0.2",
 CellID->17419283],
Cell[CellGroupData[{
Cell[54079, 1907, 252, 7, 70, "Input",
 CellTags->"b:0.2",
 CellID->636896070],
Cell[54334, 1916, 268, 9, 36, "Output",
 CellTags->"b:0.2",
 CellID->756235924]
}, Open  ]],
Cell[54617, 1928, 293, 7, 70, "Text",
 CellTags->"b:0.2",
 CellID->228635176],
Cell[CellGroupData[{
Cell[54935, 1939, 229, 7, 70, "Input",
 CellTags->"b:0.2",
 CellID->149453386],
Cell[55167, 1948, 242, 8, 36, "Output",
 CellTags->"b:0.2",
 CellID->155639932]
}, Open  ]],
Cell[CellGroupData[{
Cell[55446, 1961, 229, 7, 70, "Input",
 CellTags->"b:0.2",
 CellID->27057531],
Cell[55678, 1970, 196, 7, 36, "Output",
 CellTags->"b:0.2",
 CellID->188119997]
}, Open  ]],
Cell[CellGroupData[{
Cell[55911, 1982, 229, 7, 70, "Input",
 CellTags->"b:0.2",
 CellID->72747825],
Cell[56143, 1991, 242, 8, 36, "Output",
 CellTags->"b:0.2",
 CellID->72194511]
}, Open  ]],
Cell[56400, 2002, 253, 9, 70, "Text",
 CellTags->"b:0.2",
 CellID->574029527],
Cell[CellGroupData[{
Cell[56678, 2015, 246, 7, 70, "Input",
 CellTags->"b:0.2",
 CellID->972490785],
Cell[56927, 2024, 286, 9, 36, "Output",
 CellTags->"b:0.2",
 CellID->459953736]
}, Open  ]],
Cell[57228, 2036, 998, 37, 70, "Text",
 CellTags->"b:0.2",
 CellID->645192577],
Cell[58229, 2075, 424, 16, 70, "Text",
 CellTags->"b:0.2",
 CellID->38350545],
Cell[58656, 2093, 299, 9, 70, "Text",
 CellTags->"b:0.2",
 CellID->87518571],
Cell[CellGroupData[{
Cell[58980, 2106, 226, 6, 70, "Input",
 CellTags->"b:0.2",
 CellID->310325877],
Cell[59209, 2114, 213, 7, 36, "Output",
 CellTags->"b:0.2",
 CellID->510580570]
}, Open  ]],
Cell[CellGroupData[{
Cell[59459, 2126, 232, 7, 70, "Input",
 CellTags->"b:0.2",
 CellID->47695904],
Cell[59694, 2135, 248, 8, 36, "Output",
 CellTags->"b:0.2",
 CellID->82458948]
}, Open  ]],
Cell[59957, 2146, 282, 10, 70, "Text",
 CellTags->"b:0.2",
 CellID->428461048],
Cell[CellGroupData[{
Cell[60264, 2160, 238, 7, 70, "Input",
 CellTags->"b:0.2",
 CellID->1001621228],
Cell[60505, 2169, 213, 7, 36, "Output",
 CellTags->"b:0.2",
 CellID->521403356]
}, Open  ]],
Cell[60733, 2179, 250, 9, 70, "Text",
 CellTags->"b:0.2",
 CellID->667194970],
Cell[CellGroupData[{
Cell[61008, 2192, 346, 10, 70, "Input",
 CellTags->"b:0.2",
 CellID->562254777],
Cell[61357, 2204, 246, 8, 36, "Output",
 CellTags->"b:0.2",
 CellID->988258]
}, Open  ]],
Cell[61618, 2215, 869, 24, 70, "Text",
 CellTags->"b:0.2",
 CellID->1379250],
Cell[CellGroupData[{
Cell[62512, 2243, 245, 7, 70, "Input",
 CellTags->"b:0.2",
 CellID->425844705],
Cell[62760, 2252, 246, 8, 36, "Output",
 CellTags->"b:0.2",
 CellID->463827189]
}, Open  ]],
Cell[CellGroupData[{
Cell[63043, 2265, 378, 11, 70, "Input",
 CellTags->"b:0.2",
 CellID->25483089],
Cell[63424, 2278, 423, 14, 36, "Output",
 CellTags->"b:0.2",
 CellID->120083365]
}, Open  ]],
Cell[63862, 2295, 449, 13, 70, "Text",
 CellTags->"b:0.2",
 CellID->251858179],
Cell[CellGroupData[{
Cell[64336, 2312, 416, 12, 70, "Input",
 CellTags->"b:0.2",
 CellID->84036725],
Cell[64755, 2326, 478, 14, 36, "Output",
 CellTags->"b:0.2",
 CellID->56276189]
}, Open  ]],
Cell[65248, 2343, 282, 7, 70, "Text",
 CellTags->"b:0.2",
 CellID->695998127],
Cell[CellGroupData[{
Cell[65555, 2354, 440, 12, 70, "Input",
 CellTags->"b:0.2",
 CellID->28505115],
Cell[65998, 2368, 487, 14, 36, "Output",
 CellTags->"b:0.2",
 CellID->193124569]
}, Open  ]],
Cell[66500, 2385, 294, 9, 70, "Text",
 CellTags->"b:0.2",
 CellID->465786935],
Cell[CellGroupData[{
Cell[66819, 2398, 243, 7, 70, "Input",
 CellTags->"b:0.2",
 CellID->38936688],
Cell[67065, 2407, 244, 8, 36, "Output",
 CellTags->"b:0.2",
 CellID->738895931]
}, Open  ]],
Cell[67324, 2418, 198, 5, 70, "Text",
 CellTags->"b:0.2",
 CellID->377461404],
Cell[67525, 2425, 168, 6, 70, "Text",
 CellTags->"b:0.2",
 CellID->114009367],
Cell[CellGroupData[{
Cell[67718, 2435, 246, 7, 70, "Input",
 CellTags->"b:0.2",
 CellID->635063856],
Cell[67967, 2444, 244, 8, 36, "Output",
 CellTags->"b:0.2",
 CellID->355466528]
}, Open  ]],
Cell[68226, 2455, 175, 5, 70, "Text",
 CellTags->"b:0.2",
 CellID->142585462],
Cell[CellGroupData[{
Cell[68426, 2464, 425, 13, 70, "Input",
 CellTags->"b:0.2",
 CellID->4084787],
Cell[68854, 2479, 302, 9, 36, "Output",
 CellTags->"b:0.2",
 CellID->420878177]
}, Open  ]],
Cell[69171, 2491, 239, 6, 70, "Text",
 CellTags->"b:0.2",
 CellID->68612708],
Cell[CellGroupData[{
Cell[69435, 2501, 457, 15, 70, "Input",
 CellTags->"b:0.2",
 CellID->373128525],
Cell[69895, 2518, 242, 8, 36, "Output",
 CellTags->"b:0.2",
 CellID->127706517]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[70186, 2532, 109, 2, 70, "Section",
 CellTags->{"c:4", "b:0.3"},
 CellID->182364929],
Cell[70298, 2536, 321, 7, 70, "Text",
 CellTags->"b:0.3",
 CellID->100369965],
Cell[70622, 2545, 8577, 255, 70, "DefinitionBox3Col",
 CellTags->"b:0.3",
 CellID->195821352],
Cell[79202, 2802, 397, 12, 70, "Text",
 CellTags->"b:0.3",
 CellID->143238647],
Cell[79602, 2816, 477, 13, 70, "Text",
 CellTags->"b:0.3",
 CellID->121646424]
}, Open  ]],
Cell[CellGroupData[{
Cell[80116, 2834, 86, 2, 70, "Section",
 CellTags->"c:5",
 CellID->393353162],
Cell[80205, 2838, 215, 5, 70, "Text",
 CellID->447203085],
Cell[CellGroupData[{
Cell[80445, 2847, 85, 2, 70, "Subsection",
 CellTags->{"c:6", "b:0.4.0"},
 CellID->115748480],
Cell[80533, 2851, 266, 8, 70, "Text",
 CellTags->"b:0.4.0",
 CellID->88806953],
Cell[CellGroupData[{
Cell[80824, 2863, 233, 7, 70, "Input",
 CellTags->"b:0.4.0",
 CellID->631912780],
Cell[81060, 2872, 184, 6, 36, "Output",
 CellTags->"b:0.4.0",
 CellID->768829449]
}, Open  ]],
Cell[CellGroupData[{
Cell[81281, 2883, 235, 7, 70, "Input",
 CellTags->"b:0.4.0",
 CellID->116558020],
Cell[81519, 2892, 184, 6, 36, "Output",
 CellTags->"b:0.4.0",
 CellID->42906176]
}, Open  ]],
Cell[81718, 2901, 1404, 47, 70, "Text",
 CellTags->"b:0.4.0",
 CellID->406868558],
Cell[83125, 2950, 111, 2, 70, "Text",
 CellTags->"b:0.4.0",
 CellID->90376082],
Cell[CellGroupData[{
Cell[83261, 2956, 199, 6, 70, "Input",
 CellTags->"b:0.4.0",
 CellID->996820522],
Cell[83463, 2964, 184, 6, 36, "Output",
 CellTags->"b:0.4.0",
 CellID->504872867]
}, Open  ]],
Cell[CellGroupData[{
Cell[83684, 2975, 247, 7, 70, "Input",
 CellTags->"b:0.4.0",
 CellID->44778046],
Cell[83934, 2984, 183, 6, 36, "Output",
 CellTags->"b:0.4.0",
 CellID->11784903]
}, Open  ]],
Cell[CellGroupData[{
Cell[84154, 2995, 228, 7, 70, "Input",
 CellTags->"b:0.4.0",
 CellID->22423222],
Cell[84385, 3004, 182, 6, 36, "Output",
 CellTags->"b:0.4.0",
 CellID->3205742]
}, Open  ]],
Cell[84582, 3013, 360, 12, 70, "Text",
 CellTags->"b:0.4.0",
 CellID->60232086],
Cell[84945, 3027, 299, 10, 70, "Text",
 CellTags->"b:0.4.0",
 CellID->716869318],
Cell[85247, 3039, 494, 14, 70, "Text",
 CellTags->"b:0.4.0",
 CellID->554439476],
Cell[CellGroupData[{
Cell[85766, 3057, 236, 6, 70, "Input",
 CellTags->"b:0.4.0",
 CellID->70925498],
Cell[86005, 3065, 184, 6, 36, "Output",
 CellTags->"b:0.4.0",
 CellID->121299948]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[86238, 3077, 84, 2, 70, "Subsection",
 CellTags->{"c:7", "b:0.4.1"},
 CellID->221687989],
Cell[86325, 3081, 478, 15, 70, "Text",
 CellTags->"b:0.4.1",
 CellID->58760444],
Cell[CellGroupData[{
Cell[86828, 3100, 233, 7, 70, "Input",
 CellTags->"b:0.4.1",
 CellID->208914080],
Cell[87064, 3109, 185, 6, 36, "Output",
 CellTags->"b:0.4.1",
 CellID->209738466]
}, Open  ]],
Cell[CellGroupData[{
Cell[87286, 3120, 223, 7, 70, "Input",
 CellTags->"b:0.4.1",
 CellID->113974042],
Cell[87512, 3129, 185, 6, 36, "Output",
 CellTags->"b:0.4.1",
 CellID->232877383]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[87746, 3141, 82, 2, 70, "Subsection",
 CellTags->{"c:8", "b:0.4.2"},
 CellID->3968257],
Cell[87831, 3145, 331, 9, 70, "Text",
 CellTags->"b:0.4.2",
 CellID->46676764],
Cell[88165, 3156, 93, 2, 70, "Text",
 CellTags->"b:0.4.2",
 CellID->143958968],
Cell[CellGroupData[{
Cell[88283, 3162, 206, 6, 70, "Input",
 CellTags->"b:0.4.2",
 CellID->459256047],
Cell[88492, 3170, 265, 9, 36, "Output",
 CellTags->"b:0.4.2",
 CellID->35656270]
}, Open  ]],
Cell[88772, 3182, 92, 2, 70, "Text",
 CellTags->"b:0.4.2",
 CellID->697884743],
Cell[CellGroupData[{
Cell[88889, 3188, 301, 10, 70, "Input",
 CellTags->"b:0.4.2",
 CellID->85500109],
Cell[89193, 3200, 265, 9, 36, "Output",
 CellTags->"b:0.4.2",
 CellID->166781061]
}, Open  ]],
Cell[CellGroupData[{
Cell[89495, 3214, 279, 8, 70, "Input",
 CellTags->"b:0.4.2",
 CellID->493985103],
Cell[89777, 3224, 265, 9, 36, "Output",
 CellTags->"b:0.4.2",
 CellID->358774032]
}, Open  ]],
Cell[90057, 3236, 89, 2, 70, "Text",
 CellTags->"b:0.4.2",
 CellID->121882887],
Cell[CellGroupData[{
Cell[90171, 3242, 196, 6, 70, "Input",
 CellTags->"b:0.4.2",
 CellID->240722779],
Cell[90370, 3250, 261, 9, 36, "Output",
 CellTags->"b:0.4.2",
 CellID->26993590]
}, Open  ]],
Cell[90646, 3262, 86, 2, 70, "Text",
 CellTags->"b:0.4.2",
 CellID->608581590],
Cell[CellGroupData[{
Cell[90757, 3268, 725, 22, 70, "Input",
 CellTags->"b:0.4.2",
 CellID->94888225],
Cell[91485, 3292, 405, 12, 36, "Output",
 CellTags->"b:0.4.2",
 CellID->180027018]
}, Open  ]],
Cell[91905, 3307, 347, 9, 70, "Text",
 CellTags->"b:0.4.2",
 CellID->255423450],
Cell[CellGroupData[{
Cell[92277, 3320, 343, 11, 70, "Input",
 CellTags->"b:0.4.2",
 CellID->1009786679],
Cell[92623, 3333, 353, 12, 36, "Output",
 CellTags->"b:0.4.2",
 CellID->248658486]
}, Open  ]],
Cell[CellGroupData[{
Cell[93013, 3350, 125, 4, 70, "Input",
 CellTags->"b:0.4.2",
 CellID->51924450],
Cell[93141, 3356, 246, 8, 36, "Output",
 CellTags->"b:0.4.2",
 CellID->391207758]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[93436, 3370, 92, 2, 70, "Subsection",
 CellTags->{"c:9", "b:0.4.3"},
 CellID->351610464],
Cell[93531, 3374, 1743, 65, 70, "Text",
 CellTags->"b:0.4.3",
 CellID->542672475],
Cell[95277, 3441, 405, 14, 70, "Text",
 CellTags->"b:0.4.3",
 CellID->271649068],
Cell[CellGroupData[{
Cell[95707, 3459, 262, 8, 70, "Input",
 CellTags->"b:0.4.3",
 CellID->323915583],
Cell[95972, 3469, 248, 8, 36, "Output",
 CellTags->"b:0.4.3",
 CellID->314158530]
}, Open  ]],
Cell[96235, 3480, 443, 14, 70, "Text",
 CellTags->"b:0.4.3",
 CellID->18408293],
Cell[CellGroupData[{
Cell[96703, 3498, 309, 8, 70, "Input",
 CellTags->"b:0.4.3",
 CellID->123426060],
Cell[97015, 3508, 271, 9, 36, "Output",
 CellTags->"b:0.4.3",
 CellID->38256750]
}, Open  ]],
Cell[97301, 3520, 391, 14, 70, "Text",
 CellTags->"b:0.4.3",
 CellID->326611308],
Cell[CellGroupData[{
Cell[97717, 3538, 308, 8, 70, "Input",
 CellTags->"b:0.4.3",
 CellID->237410754],
Cell[98028, 3548, 323, 9, 36, "Output",
 CellTags->"b:0.4.3",
 CellID->468451421]
}, Open  ]],
Cell[98366, 3560, 468, 14, 70, "Text",
 CellTags->"b:0.4.3",
 CellID->627314046],
Cell[CellGroupData[{
Cell[98859, 3578, 459, 13, 70, "Input",
 CellTags->"b:0.4.3",
 CellID->87536172],
Cell[99321, 3593, 315, 9, 36, "Output",
 CellTags->"b:0.4.3",
 CellID->561505271]
}, Open  ]],
Cell[CellGroupData[{
Cell[99673, 3607, 460, 13, 70, "Input",
 CellTags->"b:0.4.3",
 CellID->31744191],
Cell[100136, 3622, 248, 8, 36, "Output",
 CellTags->"b:0.4.3",
 CellID->271831375]
}, Open  ]],
Cell[100399, 3633, 471, 16, 70, "Text",
 CellTags->"b:0.4.3",
 CellID->1005472710],
Cell[CellGroupData[{
Cell[100895, 3653, 262, 8, 70, "Input",
 CellTags->"b:0.4.3",
 CellID->168142260],
Cell[101160, 3663, 281, 9, 36, "Output",
 CellTags->"b:0.4.3",
 CellID->7842756]
}, Open  ]],
Cell[CellGroupData[{
Cell[101478, 3677, 236, 7, 70, "Input",
 CellTags->"b:0.4.3",
 CellID->42485134],
Cell[101717, 3686, 242, 8, 36, "Output",
 CellTags->"b:0.4.3",
 CellID->337333049]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[102008, 3700, 88, 2, 70, "Subsection",
 CellTags->{"c:10", "b:0.4.4"},
 CellID->363493082],
Cell[102099, 3704, 412, 13, 70, "Text",
 CellTags->"b:0.4.4",
 CellID->3234460],
Cell[CellGroupData[{
Cell[102536, 3721, 209, 6, 70, "Input",
 CellTags->"b:0.4.4",
 CellID->175418910],
Cell[102748, 3729, 386, 14, 36, "Output",
 CellTags->"b:0.4.4",
 CellID->450807373]
}, Open  ]],
Cell[CellGroupData[{
Cell[103171, 3748, 220, 8, 70, "Input",
 CellTags->"b:0.4.4",
 CellID->352798794],
Cell[103394, 3758, 266, 9, 36, "Output",
 CellTags->"b:0.4.4",
 CellID->839342939]
}, Open  ]],
Cell[103675, 3770, 399, 14, 70, "Text",
 CellTags->"b:0.4.4",
 CellID->771123683],
Cell[CellGroupData[{
Cell[104099, 3788, 265, 8, 70, "Input",
 CellTags->"b:0.4.4",
 CellID->227693171],
Cell[104367, 3798, 384, 14, 36, "Output",
 CellTags->"b:0.4.4",
 CellID->431531950]
}, Open  ]],
Cell[104766, 3815, 102, 2, 70, "Text",
 CellTags->"b:0.4.4",
 CellID->141395505],
Cell[CellGroupData[{
Cell[104893, 3821, 168, 5, 70, "Input",
 CellTags->"b:0.4.4",
 CellID->695066864],
Cell[105064, 3828, 443, 16, 36, "Output",
 CellTags->"b:0.4.4",
 CellID->242903424]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[105556, 3850, 85, 2, 70, "Subsection",
 CellTags->{"c:11", "b:0.4.5"},
 CellID->401719377],
Cell[105644, 3854, 639, 19, 70, "Text",
 CellTags->"b:0.4.5",
 CellID->771573730],
Cell[CellGroupData[{
Cell[106308, 3877, 287, 8, 70, "Input",
 CellTags->"b:0.4.5",
 CellID->175837266],
Cell[106598, 3887, 182, 6, 36, "Output",
 CellTags->"b:0.4.5",
 CellID->699615004]
}, Open  ]],
Cell[CellGroupData[{
Cell[106817, 3898, 322, 10, 70, "Input",
 CellTags->"b:0.4.5",
 CellID->16340890],
Cell[107142, 3910, 182, 6, 36, "Output",
 CellTags->"b:0.4.5",
 CellID->327764894]
}, Open  ]],
Cell[107339, 3919, 462, 18, 70, "Text",
 CellTags->"b:0.4.5",
 CellID->12491824]
}, Open  ]],
Cell[CellGroupData[{
Cell[107838, 3942, 85, 2, 70, "Subsection",
 CellTags->{"c:12", "b:0.4.6"},
 CellID->1274428],
Cell[107926, 3946, 266, 8, 70, "Text",
 CellTags->"b:0.4.6",
 CellID->45121066],
Cell[CellGroupData[{
Cell[108217, 3958, 316, 10, 70, "Input",
 CellTags->"b:0.4.6",
 CellID->67067787],
Cell[108536, 3970, 192, 6, 36, "Output",
 CellTags->"b:0.4.6",
 CellID->72896606]
}, Open  ]],
Cell[108743, 3979, 397, 12, 70, "Text",
 CellTags->"b:0.4.6",
 CellID->21617589],
Cell[CellGroupData[{
Cell[109165, 3995, 314, 9, 70, "Input",
 CellTags->"b:0.4.6",
 CellID->801931404],
Cell[109482, 4006, 203, 6, 36, "Output",
 CellTags->"b:0.4.6",
 CellID->187183009]
}, Open  ]],
Cell[109700, 4015, 253, 6, 70, "Text",
 CellTags->"b:0.4.6",
 CellID->150245402],
Cell[CellGroupData[{
Cell[109978, 4025, 327, 9, 70, "Input",
 CellTags->"b:0.4.6",
 CellID->85246728],
Cell[110308, 4036, 203, 6, 36, "Output",
 CellTags->"b:0.4.6",
 CellID->483186576]
}, Open  ]],
Cell[110526, 4045, 145, 5, 70, "Text",
 CellTags->"b:0.4.6",
 CellID->203144771],
Cell[CellGroupData[{
Cell[110696, 4054, 323, 9, 70, "Input",
 CellTags->"b:0.4.6",
 CellID->17461363],
Cell[111022, 4065, 203, 6, 36, "Output",
 CellTags->"b:0.4.6",
 CellID->461731323]
}, Open  ]],
Cell[111240, 4074, 317, 10, 70, "Text",
 CellTags->"b:0.4.6",
 CellID->131051894],
Cell[CellGroupData[{
Cell[111582, 4088, 366, 10, 70, "Input",
 CellTags->"b:0.4.6",
 CellID->459415768],
Cell[111951, 4100, 631, 19, 36, "Output",
 CellTags->"b:0.4.6",
 CellID->478032402]
}, Open  ]],
Cell[CellGroupData[{
Cell[112619, 4124, 127, 4, 70, "Input",
 CellTags->"b:0.4.6",
 CellID->28871706],
Cell[112749, 4130, 311, 9, 50, "Output",
 CellTags->"b:0.4.6",
 CellID->728560033]
}, Open  ]],
Cell[113075, 4142, 287, 7, 70, "Text",
 CellTags->"b:0.4.6",
 CellID->623263418]
}, Open  ]],
Cell[CellGroupData[{
Cell[113399, 4154, 91, 2, 70, "Subsection",
 CellTags->{"c:13", "b:0.4.7"},
 CellID->239124212],
Cell[113493, 4158, 349, 11, 70, "Text",
 CellTags->"b:0.4.7",
 CellID->758815075],
Cell[CellGroupData[{
Cell[113867, 4173, 282, 8, 70, "Input",
 CellTags->"b:0.4.7",
 CellID->34244212],
Cell[114152, 4183, 273, 9, 36, "Output",
 CellTags->"b:0.4.7",
 CellID->977687334]
}, Open  ]],
Cell[114440, 4195, 147, 5, 70, "Text",
 CellTags->"b:0.4.7",
 CellID->578481874],
Cell[CellGroupData[{
Cell[114612, 4204, 343, 10, 70, "Input",
 CellTags->"b:0.4.7",
 CellID->80963487],
Cell[114958, 4216, 394, 13, 36, "Output",
 CellTags->"b:0.4.7",
 CellID->588842050]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[115401, 4235, 85, 2, 70, "Subsection",
 CellTags->{"c:14", "b:0.4.8"},
 CellID->343107939],
Cell[115489, 4239, 337, 9, 70, "Text",
 CellTags->"b:0.4.8",
 CellID->19737335],
Cell[CellGroupData[{
Cell[115851, 4252, 150, 4, 70, "Input",
 CellTags->"b:0.4.8",
 CellID->20551734],
Cell[116004, 4258, 289, 9, 36, "Output",
 CellTags->"b:0.4.8",
 CellID->34809990]
}, Open  ]],
Cell[116308, 4270, 173, 5, 70, "Text",
 CellTags->"b:0.4.8",
 CellID->27447488],
Cell[CellGroupData[{
Cell[116506, 4279, 281, 8, 70, "Input",
 CellTags->"b:0.4.8",
 CellID->107169258],
Cell[116790, 4289, 347, 10, 36, "Output",
 CellTags->"b:0.4.8",
 CellID->20960328]
}, Open  ]],
Cell[117152, 4302, 148, 5, 70, "Text",
 CellTags->"b:0.4.8",
 CellID->60098082],
Cell[CellGroupData[{
Cell[117325, 4311, 174, 5, 70, "Input",
 CellTags->"b:0.4.8",
 CellID->72110840],
Cell[117502, 4318, 262, 9, 36, "Output",
 CellTags->"b:0.4.8",
 CellID->515316641]
}, Open  ]],
Cell[117779, 4330, 244, 9, 70, "Text",
 CellTags->"b:0.4.8",
 CellID->103751328],
Cell[CellGroupData[{
Cell[118048, 4343, 187, 5, 70, "Input",
 CellTags->"b:0.4.8",
 CellID->460561670],
Cell[118238, 4350, 299, 9, 36, "Output",
 CellTags->"b:0.4.8",
 CellID->1004147207]
}, Open  ]],
Cell[118552, 4362, 159, 5, 70, "Text",
 CellTags->"b:0.4.8",
 CellID->656954062],
Cell[CellGroupData[{
Cell[118736, 4371, 194, 6, 70, "Input",
 CellTags->"b:0.4.8",
 CellID->1019234],
Cell[118933, 4379, 254, 8, 36, "Output",
 CellTags->"b:0.4.8",
 CellID->135279393]
}, Open  ]],
Cell[119202, 4390, 101, 2, 70, "Text",
 CellTags->"b:0.4.8",
 CellID->241434771],
Cell[CellGroupData[{
Cell[119328, 4396, 203, 6, 70, "Input",
 CellTags->"b:0.4.8",
 CellID->171055668],
Cell[119534, 4404, 286, 9, 36, "Output",
 CellTags->"b:0.4.8",
 CellID->802280320]
}, Open  ]],
Cell[119835, 4416, 314, 9, 70, "Text",
 CellTags->"b:0.4.8",
 CellID->590437369],
Cell[CellGroupData[{
Cell[120174, 4429, 201, 6, 70, "Input",
 CellTags->"b:0.4.8",
 CellID->4669335],
Cell[120378, 4437, 291, 9, 71, "Output",
 CellTags->"b:0.4.8",
 CellID->44401504]
}, Open  ]],
Cell[120684, 4449, 177, 5, 70, "Text",
 CellTags->"b:0.4.8",
 CellID->11065132],
Cell[CellGroupData[{
Cell[120886, 4458, 220, 6, 70, "Input",
 CellTags->"b:0.4.8",
 CellID->386084822],
Cell[121109, 4466, 348, 10, 36, "Output",
 CellTags->"b:0.4.8",
 CellID->364330143]
}, Open  ]],
Cell[CellGroupData[{
Cell[121494, 4481, 219, 6, 70, "Input",
 CellTags->"b:0.4.8",
 CellID->60902233],
Cell[121716, 4489, 348, 10, 36, "Output",
 CellTags->"b:0.4.8",
 CellID->106027777]
}, Open  ]],
Cell[CellGroupData[{
Cell[122101, 4504, 302, 8, 70, "Input",
 CellTags->"b:0.4.8",
 CellID->73670271],
Cell[122406, 4514, 303, 9, 36, "Output",
 CellTags->"b:0.4.8",
 CellID->293993995]
}, Open  ]],
Cell[CellGroupData[{
Cell[122746, 4528, 377, 10, 70, "Input",
 CellTags->"b:0.4.8",
 CellID->153068299],
Cell[123126, 4540, 513, 13, 36, "Output",
 CellTags->"b:0.4.8",
 CellID->129996884]
}, Open  ]],
Cell[123654, 4556, 187, 5, 70, "Text",
 CellTags->"b:0.4.8",
 CellID->307113028],
Cell[CellGroupData[{
Cell[123866, 4565, 491, 15, 70, "Input",
 CellTags->"b:0.4.8",
 CellID->36223674],
Cell[124360, 4582, 323, 9, 50, "Output",
 CellTags->"b:0.4.8",
 CellID->409814246]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[124744, 4598, 72, 2, 70, "Section",
 CellTags->"c:15",
 CellID->759470019],
Cell[CellGroupData[{
Cell[124841, 4604, 83, 2, 70, "Subsection",
 CellTags->{"c:15.5", "b:0.5.0"},
 CellID->20697950],
Cell[124927, 4608, 493, 13, 70, "Text",
 CellTags->"b:0.5.0",
 CellID->86791152],
Cell[125423, 4623, 210, 7, 70, "Text",
 CellTags->"b:0.5.0",
 CellID->323888524],
Cell[125636, 4632, 2866, 85, 70, "DefinitionBox3Col",
 CellTags->"b:0.5.0",
 CellID->43654671],
Cell[128505, 4719, 115, 2, 70, "Text",
 CellTags->"b:0.5.0",
 CellID->575279163]
}, Open  ]],
Cell[CellGroupData[{
Cell[128657, 4726, 80, 2, 70, "Subsection",
 CellTags->{"c:16", "b:0.5.1"},
 CellID->120637313],
Cell[128740, 4730, 514, 18, 70, "Text",
 CellTags->"b:0.5.1",
 CellID->332493086],
Cell[129257, 4750, 259, 8, 70, "Text",
 CellTags->"b:0.5.1",
 CellID->163086882],
Cell[129519, 4760, 137, 7, 70, "Program",
 CellTags->"b:0.5.1",
 CellID->203403607],
Cell[129659, 4769, 163, 7, 70, "Text",
 CellTags->"b:0.5.1",
 CellID->258819916],
Cell[CellGroupData[{
Cell[129847, 4780, 431, 13, 70, "Input",
 CellTags->"b:0.5.1",
 CellID->403377399],
Cell[130281, 4795, 81, 2, 70, "Print",
 CellTags->"b:0.5.1",
 CellID->13390572]
}, Open  ]],
Cell[130377, 4800, 534, 19, 70, "Text",
 CellTags->"b:0.5.1",
 CellID->130918903],
Cell[130914, 4821, 108, 2, 70, "Text",
 CellTags->"b:0.5.1",
 CellID->272631892],
Cell[131025, 4825, 172, 7, 70, "Program",
 CellTags->"b:0.5.1",
 CellID->67879431],
Cell[131200, 4834, 146, 7, 70, "Text",
 CellTags->"b:0.5.1",
 CellID->175118403],
Cell[CellGroupData[{
Cell[131371, 4845, 777, 24, 70, "Input",
 CellTags->"b:0.5.1",
 CellID->399472551],
Cell[132151, 4871, 303, 8, 70, "Print",
 CellTags->"b:0.5.1",
 CellID->354731971]
}, Open  ]],
Cell[132469, 4882, 127, 4, 70, "Text",
 CellTags->"b:0.5.1",
 CellID->161491337],
Cell[132599, 4888, 149, 5, 70, "Program",
 CellTags->"b:0.5.1",
 CellID->785509705],
Cell[132751, 4895, 281, 12, 70, "Text",
 CellTags->"b:0.5.1",
 CellID->445860386],
Cell[CellGroupData[{
Cell[133057, 4911, 611, 19, 70, "Input",
 CellTags->"b:0.5.1",
 CellID->682251121],
Cell[133671, 4932, 264, 9, 36, "Output",
 CellTags->"b:0.5.1",
 CellID->66729238]
}, Open  ]],
Cell[133950, 4944, 210, 7, 70, "Text",
 CellTags->"b:0.5.1",
 CellID->20175135],
Cell[134163, 4953, 121, 5, 70, "Program",
 CellTags->"b:0.5.1",
 CellID->19723038],
Cell[134287, 4960, 297, 12, 70, "Text",
 CellTags->"b:0.5.1",
 CellID->781694409],
Cell[CellGroupData[{
Cell[134609, 4976, 341, 11, 70, "Input",
 CellTags->"b:0.5.1",
 CellID->43441911],
Cell[134953, 4989, 290, 9, 36, "Output",
 CellTags->"b:0.5.1",
 CellID->402829830]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[135292, 5004, 84, 2, 70, "Subsection",
 CellTags->{"c:17", "b:0.5.2"},
 CellID->163295011],
Cell[135379, 5008, 520, 20, 70, "Text",
 CellTags->"b:0.5.2",
 CellID->51683055],
Cell[135902, 5030, 107, 5, 70, "Program",
 CellTags->"b:0.5.2",
 CellID->384257252],
Cell[136012, 5037, 114, 2, 70, "Text",
 CellTags->"b:0.5.2",
 CellID->179104029],
Cell[CellGroupData[{
Cell[136151, 5043, 349, 10, 70, "Input",
 CellTags->"b:0.5.2",
 CellID->252897767],
Cell[136503, 5055, 195, 6, 36, "Output",
 CellTags->"b:0.5.2",
 CellID->152663893]
}, Open  ]],
Cell[136713, 5064, 195, 7, 70, "Text",
 CellTags->"b:0.5.2",
 CellID->317632773],
Cell[136911, 5073, 79, 2, 70, "Program",
 CellTags->"b:0.5.2",
 CellID->152813715],
Cell[CellGroupData[{
Cell[137015, 5079, 253, 8, 70, "Input",
 CellTags->"b:0.5.2",
 CellID->341597359],
Cell[137271, 5089, 195, 6, 36, "Output",
 CellTags->"b:0.5.2",
 CellID->294762643]
}, Open  ]],
Cell[137481, 5098, 299, 11, 70, "Text",
 CellTags->"b:0.5.2",
 CellID->183807183],
Cell[137783, 5111, 115, 5, 70, "Program",
 CellTags->"b:0.5.2",
 CellID->409627135],
Cell[CellGroupData[{
Cell[137923, 5120, 342, 10, 70, "Input",
 CellTags->"b:0.5.2",
 CellID->69447560],
Cell[138268, 5132, 201, 6, 36, "Output",
 CellTags->"b:0.5.2",
 CellID->406228538]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[138518, 5144, 83, 2, 70, "Subsection",
 CellTags->{"c:18", "b:0.5.3"},
 CellID->45791734],
Cell[138604, 5148, 340, 14, 70, "Text",
 CellTags->"b:0.5.3",
 CellID->12267911],
Cell[138947, 5164, 109, 5, 70, "Program",
 CellTags->"b:0.5.3",
 CellID->189290885],
Cell[CellGroupData[{
Cell[139081, 5173, 254, 7, 70, "Input",
 CellTags->"b:0.5.3",
 CellID->229530619],
Cell[139338, 5182, 268, 9, 36, "Output",
 CellTags->"b:0.5.3",
 CellID->504939231]
}, Open  ]],
Cell[139621, 5194, 196, 7, 70, "Text",
 CellTags->"b:0.5.3",
 CellID->240418930],
Cell[139820, 5203, 80, 2, 70, "Program",
 CellTags->"b:0.5.3",
 CellID->719922593],
Cell[CellGroupData[{
Cell[139925, 5209, 175, 5, 70, "Input",
 CellTags->"b:0.5.3",
 CellID->502233132],
Cell[140103, 5216, 249, 8, 36, "Output",
 CellTags->"b:0.5.3",
 CellID->355681688]
}, Open  ]],
Cell[140367, 5227, 601, 18, 70, "Text",
 CellTags->"b:0.5.3",
 CellID->78986018],
Cell[140971, 5247, 151, 5, 70, "Program",
 CellTags->"b:0.5.3",
 CellID->348675863],
Cell[CellGroupData[{
Cell[141147, 5256, 428, 13, 70, "Input",
 CellTags->"b:0.5.3",
 CellID->639488513],
Cell[141578, 5271, 277, 9, 50, "Output",
 CellTags->"b:0.5.3",
 CellID->614879701]
}, Open  ]],
Cell[CellGroupData[{
Cell[141892, 5285, 470, 15, 70, "Input",
 CellTags->"b:0.5.3",
 CellID->34696905],
Cell[142365, 5302, 296, 9, 50, "Output",
 CellTags->"b:0.5.3",
 CellID->77828007]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[142710, 5317, 85, 2, 70, "Subsection",
 CellTags->{"c:19", "b:0.5.4"},
 CellID->627179989],
Cell[142798, 5321, 392, 14, 70, "Text",
 CellTags->"b:0.5.4",
 CellID->512373978],
Cell[143193, 5337, 472, 16, 70, "Text",
 CellTags->"b:0.5.4",
 CellID->75100454],
Cell[143668, 5355, 107, 5, 70, "Program",
 CellTags->"b:0.5.4",
 CellID->2535425],
Cell[143778, 5362, 295, 12, 70, "Text",
 CellTags->"b:0.5.4",
 CellID->616093666],
Cell[CellGroupData[{
Cell[144098, 5378, 443, 13, 70, "Input",
 CellTags->"b:0.5.4",
 CellID->394779265],
Cell[144544, 5393, 194, 6, 36, "Output",
 CellTags->"b:0.5.4",
 CellID->44331865]
}, Open  ]],
Cell[144753, 5402, 393, 13, 70, "Text",
 CellTags->"b:0.5.4",
 CellID->44095121],
Cell[145149, 5417, 116, 5, 70, "Program",
 CellTags->"b:0.5.4",
 CellID->260896876],
Cell[CellGroupData[{
Cell[145290, 5426, 615, 18, 70, "Input",
 CellTags->"b:0.5.4",
 CellID->37744320],
Cell[145908, 5446, 198, 6, 36, "Output",
 CellTags->"b:0.5.4",
 CellID->232622468]
}, Open  ]],
Cell[146121, 5455, 312, 12, 70, "Text",
 CellTags->"b:0.5.4",
 CellID->291617831],
Cell[146436, 5469, 114, 5, 70, "Program",
 CellTags->"b:0.5.4",
 CellID->820168201],
Cell[CellGroupData[{
Cell[146575, 5478, 382, 12, 70, "Input",
 CellTags->"b:0.5.4",
 CellID->96850109],
Cell[146960, 5492, 201, 6, 36, "Output",
 CellTags->"b:0.5.4",
 CellID->17256542]
}, Open  ]],
Cell[147176, 5501, 197, 7, 70, "Text",
 CellTags->"b:0.5.4",
 CellID->206615673],
Cell[147376, 5510, 115, 5, 70, "Program",
 CellTags->"b:0.5.4",
 CellID->1448094],
Cell[CellGroupData[{
Cell[147516, 5519, 616, 18, 70, "Input",
 CellTags->"b:0.5.4",
 CellID->297013012],
Cell[148135, 5539, 195, 6, 36, "Output",
 CellTags->"b:0.5.4",
 CellID->16752287]
}, Open  ]],
Cell[148345, 5548, 199, 7, 70, "Text",
 CellTags->"b:0.5.4",
 CellID->809943646],
Cell[148547, 5557, 80, 2, 70, "Program",
 CellTags->"b:0.5.4",
 CellID->727836643],
Cell[CellGroupData[{
Cell[148652, 5563, 286, 9, 70, "Input",
 CellTags->"b:0.5.4",
 CellID->32783502],
Cell[148941, 5574, 198, 6, 36, "Output",
 CellTags->"b:0.5.4",
 CellID->494744495]
}, Open  ]],
Cell[CellGroupData[{
Cell[149176, 5585, 261, 8, 70, "Input",
 CellTags->"b:0.5.4",
 CellID->190461549],
Cell[149440, 5595, 198, 6, 36, "Output",
 CellTags->"b:0.5.4",
 CellID->226552420]
}, Open  ]],
Cell[149653, 5604, 229, 8, 70, "Text",
 CellTags->"b:0.5.4",
 CellID->117673595],
Cell[149885, 5614, 130, 5, 70, "Program",
 CellTags->"b:0.5.4",
 CellID->144624070],
Cell[150018, 5621, 333, 14, 70, "Text",
 CellTags->"b:0.5.4",
 CellID->688187582],
Cell[CellGroupData[{
Cell[150376, 5639, 694, 21, 70, "Input",
 CellTags->"b:0.5.4",
 CellID->141316627],
Cell[151073, 5662, 195, 6, 36, "Output",
 CellTags->"b:0.5.4",
 CellID->19380011]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[151329, 5675, 69, 2, 70, "Section",
 CellTags->"c:20",
 CellID->2083974],
Cell[151401, 5679, 133, 4, 70, "Text",
 CellID->118415745],
Cell[CellGroupData[{
Cell[151559, 5687, 92, 2, 70, "Subsection",
 CellTags->{"c:22", "b:0.6.1"},
 CellID->738873845],
Cell[151654, 5691, 100, 2, 70, "Text",
 CellTags->"b:0.6.1",
 CellID->24257838],
Cell[CellGroupData[{
Cell[151779, 5697, 603, 19, 70, "Input",
 CellTags->"b:0.6.1",
 CellID->140406151],
Cell[152385, 5718, 1219, 20, 241, "Output",
 CellTags->"b:0.6.1",
 CellID->138371101]
}, Open  ]],
Cell[153619, 5741, 128, 4, 70, "Text",
 CellTags->"b:0.6.1",
 CellID->301369684],
Cell[CellGroupData[{
Cell[153772, 5749, 586, 18, 70, "Input",
 CellTags->"b:0.6.1",
 CellID->614903007],
Cell[154361, 5769, 1608, 25, 258, "Output",
 CellTags->"b:0.6.1",
 CellID->66298060]
}, Open  ]],
Cell[155984, 5797, 108, 2, 70, "Text",
 CellTags->"b:0.6.1",
 CellID->12939824],
Cell[CellGroupData[{
Cell[156117, 5803, 372, 10, 70, "Input",
 CellTags->"b:0.6.1",
 CellID->131627168],
Cell[156492, 5815, 1609, 25, 258, "Output",
 CellTags->"b:0.6.1",
 CellID->174902817]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[158150, 5846, 86, 2, 70, "Subsection",
 CellTags->{"c:23", "b:0.6.2"},
 CellID->146223979],
Cell[158239, 5850, 150, 5, 70, "Text",
 CellTags->"b:0.6.2",
 CellID->454604247],
Cell[158392, 5857, 216, 9, 70, "Text",
 CellTags->"b:0.6.2",
 CellID->450806450],
Cell[158611, 5868, 3090, 54, 70, "Input",
 CellTags->"b:0.6.2",
 CellID->237894310],
Cell[CellGroupData[{
Cell[161726, 5926, 134, 4, 70, "Input",
 CellTags->"b:0.6.2",
 CellID->73854272],
Cell[161863, 5932, 184, 6, 36, "Output",
 CellTags->"b:0.6.2",
 CellID->17257751]
}, Open  ]],
Cell[162062, 5941, 112, 2, 70, "Text",
 CellTags->"b:0.6.2",
 CellID->328231447],
Cell[CellGroupData[{
Cell[162199, 5947, 539, 16, 70, "Input",
 CellTags->"b:0.6.2",
 CellID->10965036],
Cell[162741, 5965, 659, 15, 88, "Output",
 CellTags->"b:0.6.2",
 CellID->141092163]
}, Open  ]],
Cell[163415, 5983, 141, 6, 70, "Text",
 CellTags->"b:0.6.2",
 CellID->135521350],
Cell[CellGroupData[{
Cell[163581, 5993, 294, 9, 70, "Input",
 CellTags->"b:0.6.2",
 CellID->499683580],
Cell[163878, 6004, 812, 15, 292, "Output",
 CellTags->"b:0.6.2",
 CellID->408181342]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[164739, 6025, 84, 2, 70, "Subsection",
 CellTags->{"c:24", "b:0.6.3"},
 CellID->263221749],
Cell[164826, 6029, 134, 4, 70, "Text",
 CellTags->"b:0.6.3",
 CellID->456762081],
Cell[CellGroupData[{
Cell[164985, 6037, 191, 6, 70, "Input",
 CellTags->"b:0.6.3",
 CellID->324262933],
Cell[165179, 6045, 252, 7, 36, "Output",
 CellTags->"b:0.6.3",
 CellID->129687686]
}, Open  ]],
Cell[165446, 6055, 129, 4, 70, "Text",
 CellTags->"b:0.6.3",
 CellID->47750368],
Cell[CellGroupData[{
Cell[165600, 6063, 422, 14, 70, "Input",
 CellTags->"b:0.6.3",
 CellID->16455114],
Cell[166025, 6079, 252, 8, 36, "Output",
 CellTags->"b:0.6.3",
 CellID->338551607]
}, Open  ]],
Cell[166292, 6090, 174, 5, 70, "Text",
 CellTags->"b:0.6.3",
 CellID->507462346],
Cell[CellGroupData[{
Cell[166491, 6099, 238, 8, 70, "Input",
 CellTags->"b:0.6.3",
 CellID->28199983],
Cell[166732, 6109, 252, 8, 36, "Output",
 CellTags->"b:0.6.3",
 CellID->388857756]
}, Open  ]],
Cell[166999, 6120, 279, 9, 70, "Text",
 CellTags->"b:0.6.3",
 CellID->1024052339],
Cell[CellGroupData[{
Cell[167303, 6133, 199, 6, 70, "Input",
 CellTags->"b:0.6.3",
 CellID->5891025],
Cell[167505, 6141, 252, 8, 36, "Output",
 CellTags->"b:0.6.3",
 CellID->209255404]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[167806, 6155, 82, 2, 70, "Subsection",
 CellTags->"b:0.6.4",
 CellID->355263806],
Cell[167891, 6159, 183, 5, 70, "Text",
 CellTags->"b:0.6.4",
 CellID->115242927],
Cell[168077, 6166, 717, 23, 70, "Input",
 CellTags->"b:0.6.4",
 CellID->78571466],
Cell[168797, 6191, 89, 2, 70, "Text",
 CellTags->"b:0.6.4",
 CellID->97869725],
Cell[CellGroupData[{
Cell[168911, 6197, 359, 10, 70, "Input",
 CellTags->"b:0.6.4",
 CellID->46155371],
Cell[169273, 6209, 197, 6, 36, "Output",
 CellTags->"b:0.6.4",
 CellID->231537702]
}, Open  ]],
Cell[169485, 6218, 187, 6, 70, "Text",
 CellTags->"b:0.6.4",
 CellID->252811811],
Cell[CellGroupData[{
Cell[169697, 6228, 211, 7, 70, "Input",
 CellTags->"b:0.6.4",
 CellID->580624370],
Cell[169911, 6237, 696, 22, 62, "Output",
 CellTags->"b:0.6.4",
 CellID->513917472]
}, Open  ]],
Cell[170622, 6262, 155, 6, 70, "Text",
 CellTags->"b:0.6.4",
 CellID->612266699],
Cell[CellGroupData[{
Cell[170802, 6272, 261, 8, 70, "Input",
 CellTags->"b:0.6.4",
 CellID->28035752],
Cell[171066, 6282, 704, 22, 62, "Output",
 CellTags->"b:0.6.4",
 CellID->449106445]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[171831, 6311, 126, 2, 70, "Section",
 CellTags->{"c:25", "Tips and Tricks", "b:0.7"},
 CellID->319138910],
Cell[171960, 6315, 147, 5, 70, "Text",
 CellTags->"b:0.7",
 CellID->1088522],
Cell[CellGroupData[{
Cell[172132, 6324, 113, 2, 70, "Subsection",
 CellTags->{"c:26", "b:0.7"},
 CellID->571253149],
Cell[172248, 6328, 538, 13, 70, "Text",
 CellTags->"b:0.7",
 CellID->527245798]
}, Open  ]],
Cell[CellGroupData[{
Cell[172823, 6346, 98, 2, 70, "Subsection",
 CellTags->{"c:27", "b:0.7"},
 CellID->11710184],
Cell[172924, 6350, 675, 22, 70, "Text",
 CellTags->"b:0.7",
 CellID->168089851],
Cell[173602, 6374, 465, 14, 70, "Input",
 CellTags->"b:0.7",
 CellID->45298985],
Cell[CellGroupData[{
Cell[174092, 6392, 254, 9, 70, "Input",
 CellTags->"b:0.7",
 CellID->334473682],
Cell[174349, 6403, 258, 9, 36, "Output",
 CellTags->"b:0.7",
 CellID->136821287]
}, Open  ]],
Cell[CellGroupData[{
Cell[174644, 6417, 251, 9, 70, "Input",
 CellTags->"b:0.7",
 CellID->108146462],
Cell[174898, 6428, 279, 10, 36, "Output",
 CellTags->"b:0.7",
 CellID->152242574]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[175226, 6444, 95, 2, 70, "Subsection",
 CellTags->{"c:28", "b:0.7"},
 CellID->39608680],
Cell[175324, 6448, 660, 16, 70, "Text",
 CellTags->"b:0.7",
 CellID->350158018]
}, Open  ]],
Cell[CellGroupData[{
Cell[176021, 6469, 101, 2, 70, "Subsection",
 CellTags->{"c:29", "b:0.7"},
 CellID->73358011],
Cell[176125, 6473, 842, 22, 70, "Text",
 CellTags->"b:0.7",
 CellID->274569970],
Cell[176970, 6497, 768, 24, 70, "Input",
 CellTags->"b:0.7",
 CellID->88405937],
Cell[CellGroupData[{
Cell[177763, 6525, 148, 5, 70, "Input",
 CellTags->"b:0.7",
 CellID->171329605],
Cell[177914, 6532, 290, 9, 36, "Output",
 CellTags->"b:0.7",
 CellID->85423907]
}, Open  ]],
Cell[178219, 6544, 363, 14, 70, "Text",
 CellTags->"b:0.7",
 CellID->482988001],
Cell[CellGroupData[{
Cell[178607, 6562, 384, 13, 70, "Input",
 CellTags->"b:0.7",
 CellID->235104226],
Cell[178994, 6577, 1801, 36, 156, "Output",
 CellTags->"b:0.7",
 CellID->92602603]
}, Open  ]],
Cell[180810, 6616, 440, 14, 70, "Text",
 CellTags->"b:0.7",
 CellID->940575378],
Cell[CellGroupData[{
Cell[181275, 6634, 360, 12, 70, "Input",
 CellTags->"b:0.7",
 CellID->159751616],
Cell[181638, 6648, 1784, 36, 156, "Output",
 CellTags->"b:0.7",
 CellID->122373159]
}, Open  ]],
Cell[183437, 6687, 698, 21, 70, "Text",
 CellTags->"b:0.7",
 CellID->440945305],
Cell[CellGroupData[{
Cell[184160, 6712, 413, 13, 70, "Input",
 CellTags->"b:0.7",
 CellID->344941105],
Cell[184576, 6727, 1783, 36, 156, "Output",
 CellTags->"b:0.7",
 CellID->52135009]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[186408, 6769, 126, 2, 70, "Subsection",
 CellTags->{"c:30", "b:0.7"},
 CellID->148652143],
Cell[186537, 6773, 640, 15, 70, "Text",
 CellTags->"b:0.7",
 CellID->13332812],
Cell[187180, 6790, 258, 6, 70, "Text",
 CellTags->"b:0.7",
 CellID->349310128],
Cell[CellGroupData[{
Cell[187463, 6800, 550, 17, 70, "Input",
 CellTags->"b:0.7",
 CellID->34682433],
Cell[188016, 6819, 695, 17, 71, "Output",
 CellTags->"b:0.7",
 CellID->228226476]
}, Open  ]],
Cell[188726, 6839, 149, 5, 70, "Text",
 CellTags->"b:0.7",
 CellID->19330986],
Cell[CellGroupData[{
Cell[188900, 6848, 658, 19, 70, "Input",
 CellTags->"b:0.7",
 CellID->115301483],
Cell[189561, 6869, 695, 17, 71, "Output",
 CellTags->"b:0.7",
 CellID->626257199]
}, Open  ]],
Cell[190271, 6889, 389, 14, 70, "Text",
 CellTags->"b:0.7",
 CellID->309333144],
Cell[CellGroupData[{
Cell[190685, 6907, 839, 25, 70, "Input",
 CellTags->"b:0.7",
 CellID->238693932],
Cell[191527, 6934, 696, 17, 71, "Output",
 CellTags->"b:0.7",
 CellID->424288253]
}, Open  ]],
Cell[CellGroupData[{
Cell[192260, 6956, 701, 19, 70, "Input",
 CellTags->"b:0.7",
 CellID->74230660],
Cell[192964, 6977, 888, 21, 71, "Output",
 CellTags->"b:0.7",
 CellID->33082105]
}, Open  ]],
Cell[193867, 7001, 110, 2, 70, "Text",
 CellTags->"b:0.7",
 CellID->778852497],
Cell[193980, 7005, 318, 12, 70, "Input",
 CellTags->"b:0.7",
 CellID->166716726],
Cell[CellGroupData[{
Cell[194323, 7021, 152, 5, 70, "Input",
 CellTags->"b:0.7",
 CellID->143881214],
Cell[194478, 7028, 310, 11, 36, "Output",
 CellTags->"b:0.7",
 CellID->142292458]
}, Open  ]],
Cell[CellGroupData[{
Cell[194825, 7044, 303, 10, 70, "Input",
 CellTags->"b:0.7",
 CellID->9520874],
Cell[195131, 7056, 280, 10, 36, "Output",
 CellTags->"b:0.7",
 CellID->209053402]
}, Open  ]],
Cell[195426, 7069, 185, 6, 70, "Input",
 CellTags->"b:0.7",
 CellID->55052828],
Cell[CellGroupData[{
Cell[195636, 7079, 206, 6, 70, "Input",
 CellTags->"b:0.7",
 CellID->106844855],
Cell[195845, 7087, 386, 14, 36, "Output",
 CellTags->"b:0.7",
 CellID->83809943]
}, Open  ]],
Cell[CellGroupData[{
Cell[196268, 7106, 334, 10, 70, "Input",
 CellTags->"b:0.7",
 CellID->483013677],
Cell[196605, 7118, 257, 9, 36, "Output",
 CellTags->"b:0.7",
 CellID->544100]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[196923, 7134, 91, 2, 70, "Section",
 CellTags->{"c:31", "b:0.8"},
 CellID->337819047],
Cell[197017, 7138, 360, 12, 70, "Text",
 CellTags->"b:0.8",
 CellID->68963779],
Cell[197380, 7152, 246, 9, 70, "Text",
 CellTags->"b:0.8",
 CellID->57047539],
Cell[197629, 7163, 277, 7, 70, "Text",
 CellTags->"b:0.8",
 CellID->169990753],
Cell[CellGroupData[{
Cell[197931, 7174, 277, 8, 70, "Input",
 CellTags->"b:0.8",
 CellID->201123037],
Cell[198211, 7184, 224, 6, 50, "Output",
 CellTags->"b:0.8",
 CellID->85850298]
}, Open  ]],
Cell[198450, 7193, 217, 5, 70, "Text",
 CellTags->"b:0.8",
 CellID->190255727],
Cell[198670, 7200, 289, 6, 70, "Text",
 CellTags->"b:0.8",
 CellID->210149359],
Cell[198962, 7208, 314, 10, 70, "Text",
 CellTags->"b:0.8",
 CellID->953153723],
Cell[199279, 7220, 510, 13, 70, "Text",
 CellTags->"b:0.8",
 CellID->198359003],
Cell[199792, 7235, 926, 27, 70, "Text",
 CellTags->"b:0.8",
 CellID->908430859],
Cell[200721, 7264, 715, 23, 70, "Text",
 CellTags->"b:0.8",
 CellID->1015887440]
}, Open  ]],
Cell[CellGroupData[{
Cell[201473, 7292, 79, 2, 70, "Section",
 CellTags->{"c:32", "b:0.9"},
 CellID->503575505],
Cell[201555, 7296, 329, 10, 70, "Text",
 CellTags->{"Ref-1", "b:0.9"},
 CellID->872737084],
Cell[201887, 7308, 230, 7, 70, "Text",
 CellTags->{"Ref-2", "b:0.9"},
 CellID->201956504]
}, Open  ]],
Cell[202132, 7318, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

