(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10877,        389]
NotebookOptionsPosition[      7534,        289]
NotebookOutlinePosition[      8870,        322]
CellTagsIndexPosition[      8827,        319]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " Connections and Resources"
}], "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["DatabaseLink ",
  FontSlant->"Italic"],
 "provides a number of functions for connection to an SQL database. It also \
supports a resource mechanism that allows the details of how the connection \
is set up to be hidden. This can simplify and increase the robustness of the \
connection process."
}], "GuideAbstract",
 CellID->630713982],

Cell[CellGroupData[{

Cell["Connections", "GuideFunctionsSubsection",
 CellID->631038429],

Cell[TextData[{
 Cell[TextData[ButtonBox["OpenSQLConnection",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/ref/OpenSQLConnection"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "connect to a data resource"
}], "GuideText",
 CellID->1176903936],

Cell[TextData[{
 Cell[TextData[ButtonBox["$SQLUseConnectionPool",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/ref/$SQLUseConnectionPool"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " whether to use a connection pool when connecting"
}], "GuideText",
 CellID->1900063482],

Cell[TextData[{
 Cell[TextData[ButtonBox["CloseSQLConnection",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/ref/CloseSQLConnection"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SQLConnectionPoolClose",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/ref/SQLConnectionPoolClose"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->1090120073],

Cell["\t", "GuideDelimiter",
 CellID->1465074354],

Cell[TextData[{
 Cell[TextData[ButtonBox["SQLConnections",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/ref/SQLConnections"]], 
  "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["SQLConnectionPools",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/ref/SQLConnectionPools"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " list SQL connections and connection pools"
}], "GuideText",
 CellID->1300931446],

Cell[TextData[{
 Cell[TextData[ButtonBox["SQLConnectionInformation",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/ref/SQLConnectionInformation"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " list information about open SQL connections"
}], "GuideText",
 CellID->1223802815],

Cell["\t", "GuideDelimiter",
 CellID->1618950909],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["$SQLTimeout",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/$SQLTimeout"], " "}]], 
  "InlineGuideFunction"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " how long ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " waits while opening connections "
}], "GuideText",
 CellID->2126949713]
}, Open  ]],

Cell[CellGroupData[{

Cell["Data Resources", "GuideFunctionsSubsection",
 CellID->1455666402],

Cell[TextData[{
 Cell[TextData[ButtonBox["DataSourceNames",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/ref/DataSourceNames"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " list data sources configured on your system"
}], "GuideText",
 CellID->1588627317],

Cell[TextData[{
 Cell[TextData[ButtonBox["DataSources",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/ref/DataSources"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " list information about configured data sources"
}], "GuideText",
 CellID->395133668],

Cell[TextData[{
 Cell[TextData[ButtonBox["DatabaseResourcesPath",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/ref/DatabaseResourcesPath"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " list of directories to search for database resources"
}], "GuideText",
 CellID->1115070770],

Cell[TextData[{
 Cell[TextData[ButtonBox["WriteDataSource",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/ref/WriteDataSource"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " write a new data source configuration"
}], "GuideText",
 CellID->244768609],

Cell["\t", "GuideDelimiter",
 CellID->2052127668],

Cell[TextData[{
 Cell[TextData[ButtonBox["JDBCDriverNames",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/ref/JDBCDriverNames"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " list available JDBC drivers"
}], "GuideText",
 CellID->1522345256],

Cell[TextData[{
 Cell[TextData[ButtonBox["JDBCDrivers",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/ref/JDBCDrivers"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " list information about available JDBC drivers"
}], "GuideText",
 CellID->936547234]
}, Open  ]],

Cell[CellGroupData[{

Cell["Database Servers", "GuideFunctionsSubsection",
 CellID->1760390704],

Cell[TextData[{
 Cell[TextData[ButtonBox["SQLServerLaunch",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/ref/SQLServerLaunch"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " launch a database server that can be accessed over a network"
}], "GuideText",
 CellID->1004357409],

Cell[TextData[{
 Cell[TextData[ButtonBox["SQLServers",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/ref/SQLServers"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " list the open database servers"
}], "GuideText",
 CellID->1013507643],

Cell[TextData[{
 Cell[TextData[ButtonBox["SQLServerInformation",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/ref/SQLServerInformation"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " list information about open database servers"
}], "GuideText",
 CellID->182667897],

Cell[TextData[{
 Cell[TextData[ButtonBox["SQLServerShutdown",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/ref/SQLServerShutdown"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " shut down a database server"
}], "GuideText",
 CellID->1345213316]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "GuideTutorial",
 CellID->691132687]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["SQL Database Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:DatabaseLink/guide/SQLDatabaseOperations"]], "GuideMoreAbout",
 CellID->137578470]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DatabaseLink Connections and Resources - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 14, 12.8127382}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "DatabaseLink Guide", 
    "language" -> "en", "paclet" -> "DatabaseLink", "status" -> "None", 
    "summary" -> 
    "DatabaseLink provides a number of functions for connection to an SQL \
database. It also supports a resource mechanism that allows the details of \
how the connection is set up to be hidden. This can simplify and increase the \
robustness of the connection process.", "synonyms" -> {}, "title" -> 
    "DatabaseLink Connections and Resources", "type" -> "Guide", "uri" -> 
    "DatabaseLink/guide/DatabaseConnectionsAndResources"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 133, 5, 70, "GuideTitle",
 CellID->942062912],
Cell[755, 32, 363, 8, 70, "GuideAbstract",
 CellID->630713982],
Cell[CellGroupData[{
Cell[1143, 44, 67, 1, 70, "GuideFunctionsSubsection",
 CellID->631038429],
Cell[1213, 47, 290, 10, 70, "GuideText",
 CellID->1176903936],
Cell[1506, 59, 315, 9, 70, "GuideText",
 CellID->1900063482],
Cell[1824, 70, 477, 13, 70, "InlineGuideFunctionListing",
 CellID->1090120073],
Cell[2304, 85, 49, 1, 70, "GuideDelimiter",
 CellID->1465074354],
Cell[2356, 88, 457, 14, 70, "GuideText",
 CellID->1300931446],
Cell[2816, 104, 316, 9, 70, "GuideText",
 CellID->1223802815],
Cell[3135, 115, 49, 1, 70, "GuideDelimiter",
 CellID->1618950909],
Cell[3187, 118, 369, 14, 70, "GuideText",
 CellID->2126949713]
}, Open  ]],
Cell[CellGroupData[{
Cell[3593, 137, 71, 1, 70, "GuideFunctionsSubsection",
 CellID->1455666402],
Cell[3667, 140, 298, 9, 70, "GuideText",
 CellID->1588627317],
Cell[3968, 151, 289, 8, 70, "GuideText",
 CellID->395133668],
Cell[4260, 161, 319, 9, 70, "GuideText",
 CellID->1115070770],
Cell[4582, 172, 291, 9, 70, "GuideText",
 CellID->244768609],
Cell[4876, 183, 49, 1, 70, "GuideDelimiter",
 CellID->2052127668],
Cell[4928, 186, 282, 9, 70, "GuideText",
 CellID->1522345256],
Cell[5213, 197, 288, 8, 70, "GuideText",
 CellID->936547234]
}, Open  ]],
Cell[CellGroupData[{
Cell[5538, 210, 73, 1, 70, "GuideFunctionsSubsection",
 CellID->1760390704],
Cell[5614, 213, 315, 9, 70, "GuideText",
 CellID->1004357409],
Cell[5932, 224, 272, 8, 70, "GuideText",
 CellID->1013507643],
Cell[6207, 234, 308, 9, 70, "GuideText",
 CellID->182667897],
Cell[6518, 245, 286, 9, 70, "GuideText",
 CellID->1345213316]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6853, 260, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[6918, 263, 295, 9, 70, "GuideTutorial",
 CellID->691132687]
}, Open  ]],
Cell[CellGroupData[{
Cell[7250, 277, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[7315, 280, 177, 4, 70, "GuideMoreAbout",
 CellID->137578470]
}, Open  ]],
Cell[7507, 287, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

