(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6433,        227]
NotebookOptionsPosition[      4274,        157]
NotebookOutlinePosition[      5571,        194]
CellTagsIndexPosition[      5487,        189]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[Cell[BoxData[
    
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"DatabaseLink User Guide" :> 
         Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
         "Setting Up the Connection in DatabaseLink User Guide" :> 
         Documentation`HelpLookup[
          "paclet:DatabaseLink/tutorial/DatabaseConnections#2168"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
      2->"\<\"Setting Up the Connection in DatabaseLink User Guide\"\>"}, "\<\
\"tutorials\"\>", 
      StyleBox["\<\"tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$DatabaseLinkDirectory", "ObjectName",
 CellID->30519],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["$DatabaseLinkDirectory"], "InlineFormula"],
     "\[LineSeparator]gives the directory where ",
     StyleBox["DatabaseLink",
      FontSlant->"Italic"],
     " is installed."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6126]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->35636707],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->64269182],

Cell[TextData[{
 "The location where ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " in installed:"
}], "ExampleText",
 CellID->13465],

Cell[CellGroupData[{

Cell[BoxData["$DatabaseLinkDirectory"], "Input",
 CellLabel->"In[2]:=",
 CellID->21465],

Cell[BoxData["\<\"C:\\\\Program Files\\\\Wolfram \
Research\\\\Mathematica\\\\6.0_Thin\\\\SystemFiles\\\\Links\\\\DatabaseLink\\\
\\\"\>"], "Output",
 CellLabel->"Out[2]=",
 CellID->27178602]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Setting Up the Connection in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#2168"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#2168"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#2168"]
}], "Tutorials",
 CellID->133710995]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$DatabaseLinkDirectory - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 26.7653899}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "$DatabaseLinkDirectory gives the directory where DatabaseLink is \
installed.", "synonyms" -> {}, "title" -> "$DatabaseLinkDirectory", "type" -> 
    "Symbol", "uri" -> "DatabaseLink/ref/$DatabaseLinkDirectory"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1988, 67, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5353, 182}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 848, 19, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1471, 46, 60, 1, 70, "ObjectName",
 CellID->30519],
Cell[1534, 49, 417, 13, 70, "Usage",
 CellID->6126]
}, Open  ]],
Cell[CellGroupData[{
Cell[1988, 67, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[2365, 81, 147, 5, 70, "ExampleSection",
 CellID->35636707],
Cell[2515, 88, 134, 3, 70, "Input",
 CellID->64269182],
Cell[2652, 93, 142, 6, 70, "ExampleText",
 CellID->13465],
Cell[CellGroupData[{
Cell[2819, 103, 87, 2, 70, "Input",
 CellID->21465],
Cell[2909, 107, 191, 4, 70, "Output",
 CellID->27178602]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[3161, 118, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[3482, 129, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[3772, 140, 460, 12, 70, "Tutorials",
 CellID->133710995]
}, Open  ]],
Cell[4247, 155, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

