(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10375,        351]
NotebookOptionsPosition[      7618,        258]
NotebookOutlinePosition[      9147,        304]
CellTagsIndexPosition[      9038,        298]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Database Resources in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/DatabaseResources"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
       2->"\<\"Database Resources in DatabaseLink User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DataSources" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/DataSources"], 
          "DataSourceNames" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/DataSourceNames"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"DataSources\"\>", 
       2->"\<\"DataSourceNames\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Database Connections and Resources" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/DatabaseConnectionsAndResources"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Database Connections and Resources\"\>"}, "\<\"more about\"\>",
        
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DatabaseResourcesPath", "ObjectName",
 CellID->22929],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DatabaseResourcesPath", "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the list of directories that are searched to find \
database resources."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16541]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->543146992],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->42858418],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DatabaseResourcesPath", "[", "]"}]], "Input",
 CellTags->"b:2.3.0",
 CellLabel->"In[2]:=",
 CellID->9930],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"C:\\\\Documents and Settings\\\\username\\\\Application Data\\\
\\Mathematica\\\\DatabaseResources\\\\\"\>", 
   ",", "\<\"C:\\\\Documents and Settings\\\\All Users\\\\Application \
Data\\\\Mathematica\\\\DatabaseResources\\\\\"\>", 
   ",", "\<\"C:\\\\Program Files\\\\Wolfram \
Research\\\\Mathematica\\\\6.0\\\\AddOns\\\\Applications\\\\DatabaseLink\\\\\
DatabaseResources\\\\\"\>"}], "}"}]], "Output",
 CellTags->"b:2.3.0",
 CellLabel->"Out[2]=",
 CellID->13977]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DataSources",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/DataSources"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DataSourceNames",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/DataSourceNames"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31107]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4833],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Database Resources in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseResources"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseResources"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseResources"]
}], "Tutorials",
 CellID->133710995]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->603802269],

Cell[TextData[ButtonBox["Database Connections and Resources",
 BaseStyle->"Link",
 ButtonData->
  "paclet:DatabaseLink/guide/DatabaseConnectionsAndResources"]], "MoreAbout",
 CellID->67899733]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DatabaseResourcesPath - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 14, 20.2345657}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "DatabaseResourcesPath[] gives the list of directories that are searched \
to find database resources.", "synonyms" -> {}, "title" -> 
    "DatabaseResourcesPath", "type" -> "Symbol", "uri" -> 
    "DatabaseLink/ref/DatabaseResourcesPath"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3343, 102, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]},
 "b:2.3.0"->{
  Cell[4431, 142, 129, 4, 70, "Input",
   CellTags->"b:2.3.0",
   CellID->9930],
  Cell[4563, 148, 510, 11, 70, "Output",
   CellTags->"b:2.3.0",
   CellID->13977]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8723, 284},
 {"b:2.3.0", 8849, 288}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2207, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2830, 82, 59, 1, 70, "ObjectName",
 CellID->22929],
Cell[2892, 85, 414, 12, 70, "Usage",
 CellID->16541]
}, Open  ]],
Cell[CellGroupData[{
Cell[3343, 102, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3720, 116, 148, 5, 70, "ExampleSection",
 CellID->543146992],
Cell[3871, 123, 134, 3, 70, "Input",
 CellID->42858418],
Cell[4008, 128, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[CellGroupData[{
Cell[4431, 142, 129, 4, 70, "Input",
 CellTags->"b:2.3.0",
 CellID->9930],
Cell[4563, 148, 510, 11, 70, "Output",
 CellTags->"b:2.3.0",
 CellID->13977]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5134, 166, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[5453, 177, 497, 17, 70, "SeeAlso",
 CellID->31107]
}, Open  ]],
Cell[CellGroupData[{
Cell[5987, 199, 313, 9, 70, "TutorialsSection",
 CellID->4833],
Cell[6303, 210, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[6593, 221, 432, 12, 70, "Tutorials",
 CellID->133710995]
}, Open  ]],
Cell[CellGroupData[{
Cell[7062, 238, 319, 9, 70, "MoreAboutSection",
 CellID->603802269],
Cell[7384, 249, 192, 4, 70, "MoreAbout",
 CellID->67899733]
}, Open  ]],
Cell[7591, 256, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

