(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26129,        866]
NotebookOptionsPosition[     17921,        608]
NotebookOutlinePosition[     22101,        724]
CellTagsIndexPosition[     21464,        707]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Database Connections in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/DatabaseConnections"], 
          "Establishing a Connection in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/DatabaseConnections#16139"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>",
        2->"\<\"Database Connections in DatabaseLink User Guide\"\>", 
       3->"\<\"Establishing a Connection in DatabaseLink User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CloseSQLConnection" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/CloseSQLConnection"], "SQLConnections" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLConnections"], 
          "SQLConnection" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLConnection"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"CloseSQLConnection\"\>", 
       2->"\<\"SQLConnections\"\>", 
       3->"\<\"SQLConnection\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{
         "Database Connections and Resources" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/DatabaseConnectionsAndResources"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Database Connections and Resources\"\>"}, "\<\"more about\"\>",
        
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["OpenSQLConnection", "ObjectName",
 CellID->31339],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"OpenSQLConnection", "[", 
       StyleBox["src", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]makes a connection to a data source."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"OpenSQLConnection", "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]opens a GUI that helps to make a connection to a data \
source."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->23154]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following options can be given: ", "Notes",
 CellID->24604],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Description\>\"", "\"\<\>\"", Cell[
    "textual description of the connection", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Location\>\"", "\"\<\>\"", Cell[
    "location of the file that defines the connection", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Name\>\"", "\"\<\>\"", Cell[
    "name of the connection", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Password\>\"", "\"\<\>\"", Cell[
    "password to use for connecting", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<RelativePath\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether the connection data contains a relative path", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Timeout\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "the timeout for the query", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Username\>\"", "\"\<\>\"", Cell[
    "username to use for connecting", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Version\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "version of the configuration file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Catalog\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[StyleBox[
    "location of the database catalog", "TableText"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ReadOnly\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[StyleBox[
    "set the connection to be read-only", "TableText"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<TransactionIsolationLevel\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[StyleBox[
    "set transaction isolation for the connection", "TableText"]], 
     "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, 
      True}}}},
 CellID->4623]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->340502098],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->209630177],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->197498609],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"conn", "=", 
  RowBox[{"OpenSQLConnection", "[", "\"\<demo\>\"", "]"}]}]], "Input",
 CellTags->"Ex--21943492438155078303,34",
 CellLabel->"In[2]:=",
 CellID->20594],

Cell[BoxData[
 RowBox[{"SQLConnection", "[", 
  RowBox[{"\<\"demo\"\>", ",", "1", ",", "\<\"Open\"\>", ",", "\<\"<>\"\>"}], 
  "]"}]], "Output",
 CellTags->"Ex--21943492438155078303,34",
 CellLabel->"Out[2]=",
 CellID->29130]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"CloseSQLConnection", "[", "conn", "]"}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellTags->"Ex--21943492438155078303,35",
 CellLabel->"In[3]:=",
 CellID->18846],

Cell[TextData[{
 "This uses ",
 StyleBox["JDBC", "MR"],
 ":"
}], "ExampleText",
 CellID->4987],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"conn", "=", 
  RowBox[{"OpenSQLConnection", "[", " ", 
   RowBox[{
    RowBox[{"JDBC", "[", 
     RowBox[{"\"\<hsqldb\>\"", ",", 
      RowBox[{"ToFileName", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "$UserBaseDirectory", ",", "\"\<DatabaseResources\>\"", ",", 
          "\"\<Examples\>\""}], "}"}], ",", "\"\<demo\>\""}], "]"}]}], " ", 
     "]"}], ",", " ", "\[IndentingNewLine]", "\t", 
    RowBox[{"\"\<Name\>\"", "->", "\"\<manualA\>\""}], ",", 
    RowBox[{"\"\<Username\>\"", "->", "\"\<sa\>\""}]}], "]"}]}]], "Input",
 CellTags->"Ex--21943492438155078303,36",
 CellLabel->"In[4]:=",
 CellID->29445],

Cell[BoxData[
 RowBox[{"SQLConnection", "[", 
  RowBox[{"\<\"manualA\"\>", ",", "2", ",", "\<\"Open\"\>", 
   ",", "\<\"<>\"\>"}], "]"}]], "Output",
 CellTags->"Ex--21943492438155078303,36",
 CellLabel->"Out[4]=",
 CellID->18805]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"CloseSQLConnection", "[", "conn", "]"}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellTags->"Ex--21943492438155078303,37",
 CellLabel->"In[5]:=",
 CellID->8616],

Cell["This opens a GUI:", "ExampleText",
 CellID->5750],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"conn", "=", 
  RowBox[{"OpenSQLConnection", "[", "]"}]}]], "Input",
 CellTags->"Ex--21943492438155078303,38",
 CellLabel->"In[6]:=",
 CellID->20489],

Cell[BoxData[
 RowBox[{"SQLConnection", "[", 
  RowBox[{"\<\"publisher\"\>", ",", "3", ",", "\<\"Open\"\>", 
   ",", "\<\"<>\"\>"}], "]"}]], "Output",
 CellTags->"Ex--21943492438155078303,38",
 CellLabel->"Out[6]=",
 CellID->27338]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellTags->"Ex--21943492438155078303,39",
 CellLabel->"In[7]:=",
 CellID->21963],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->489567198]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32209],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "\"Username\"",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->21630],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->98042017],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"conn", "=", 
  RowBox[{"OpenSQLConnection", "[", " ", 
   RowBox[{"\"\<demo\>\"", ",", " ", 
    RowBox[{"\"\<Username\>\"", "->", "\"\<sa\>\""}]}], "]"}]}]], "Input",
 CellTags->"Ex--21943492438155078303,41",
 CellLabel->"In[2]:=",
 CellID->1908],

Cell[BoxData[
 RowBox[{"SQLConnection", "[", 
  RowBox[{"\<\"demo\"\>", ",", "4", ",", "\<\"Open\"\>", ",", "\<\"<>\"\>"}], 
  "]"}]], "Output",
 CellTags->"Ex--21943492438155078303,41",
 CellLabel->"Out[2]=",
 CellID->26737]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellTags->"Ex--21943492438155078303,42",
 CellLabel->"In[3]:=",
 CellID->24474]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "\"Password\"",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->31920],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->165769942],

Cell["Specify username and password:", "ExampleText",
 CellID->10293],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"conn", "=", 
  RowBox[{"OpenSQLConnection", "[", " ", 
   RowBox[{"\"\<demo\>\"", ",", " ", 
    RowBox[{"\"\<Username\>\"", "->", "\"\<sa\>\""}], ",", " ", 
    RowBox[{"\"\<Password\>\"", "->", "\"\<\>\""}]}], "]"}]}]], "Input",
 CellTags->"Ex--21943492438155078303,44",
 CellLabel->"In[2]:=",
 CellID->3855],

Cell[BoxData[
 RowBox[{"SQLConnection", "[", 
  RowBox[{"\<\"demo\"\>", ",", "5", ",", "\<\"Open\"\>", ",", "\<\"<>\"\>"}], 
  "]"}]], "Output",
 CellTags->"Ex--21943492438155078303,44",
 CellLabel->"Out[2]=",
 CellID->6734]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellTags->"Ex--21943492438155078303,45",
 CellLabel->"In[3]:=",
 CellID->9561],

Cell[TextData[{
 "Use ",
 StyleBox["$Prompt", "MR"],
 " to be prompted for the password:"
}], "ExampleText",
 CellID->31056],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"conn", "=", 
  RowBox[{"OpenSQLConnection", "[", " ", 
   RowBox[{"\"\<demo\>\"", ",", " ", 
    RowBox[{"\"\<Username\>\"", "->", "\"\<sa\>\""}], ",", " ", 
    RowBox[{"\"\<Password\>\"", "->", "\"\<$Prompt\>\""}]}], "]"}]}]], "Input",\

 CellTags->"Ex--21943492438155078303,46",
 CellLabel->"In[4]:=",
 CellID->27606],

Cell[BoxData[
 RowBox[{"SQLConnection", "[", 
  RowBox[{"\<\"demo\"\>", ",", "6", ",", "\<\"Open\"\>", ",", "\<\"<>\"\>"}], 
  "]"}]], "Output",
 CellTags->"Ex--21943492438155078303,46",
 CellLabel->"Out[4]=",
 CellID->8184]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellTags->"Ex--21943492438155078303,47",
 CellLabel->"In[5]:=",
 CellID->7075]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22225],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CloseSQLConnection",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/CloseSQLConnection"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLConnections",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLConnections"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLConnection",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLConnection"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20078]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21724],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Database Connections in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections"]
}], "Tutorials",
 CellID->33758115],

Cell[TextData[{
 ButtonBox["Establishing a Connection in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#16139"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#16139"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#16139"]
}], "Tutorials",
 CellID->133710995]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->618053859],

Cell[TextData[ButtonBox["Database Connections and Resources",
 BaseStyle->"Link",
 ButtonData->
  "paclet:DatabaseLink/guide/DatabaseConnectionsAndResources"]], "MoreAbout",
 CellID->150037521]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"OpenSQLConnection - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 14, 26.5939000}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "OpenSQLConnection[src] makes a connection to a data source. \
OpenSQLConnection[] opens a GUI that helps to make a connection to a data \
source.", "synonyms" -> {}, "title" -> "OpenSQLConnection", "type" -> 
    "Symbol", "uri" -> "DatabaseLink/ref/OpenSQLConnection"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6985, 194, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->340502098]},
 "Ex--21943492438155078303,34"->{
  Cell[8082, 234, 188, 5, 70, "Input",
   CellTags->"Ex--21943492438155078303,34",
   CellID->20594],
  Cell[8273, 241, 225, 6, 70, "Output",
   CellTags->"Ex--21943492438155078303,34",
   CellID->29130]},
 "Ex--21943492438155078303,35"->{
  Cell[8513, 250, 209, 7, 70, "Input",
   CellTags->"Ex--21943492438155078303,35",
   CellID->18846]},
 "Ex--21943492438155078303,36"->{
  Cell[8844, 268, 660, 17, 70, "Input",
   CellTags->"Ex--21943492438155078303,36",
   CellID->29445],
  Cell[9507, 287, 229, 6, 70, "Output",
   CellTags->"Ex--21943492438155078303,36",
   CellID->18805]},
 "Ex--21943492438155078303,37"->{
  Cell[9751, 296, 208, 7, 70, "Input",
   CellTags->"Ex--21943492438155078303,37",
   CellID->8616]},
 "Ex--21943492438155078303,38"->{
  Cell[10042, 310, 172, 5, 70, "Input",
   CellTags->"Ex--21943492438155078303,38",
   CellID->20489],
  Cell[10217, 317, 231, 6, 70, "Output",
   CellTags->"Ex--21943492438155078303,38",
   CellID->27338]},
 "Ex--21943492438155078303,39"->{
  Cell[10463, 326, 190, 6, 70, "Input",
   CellTags->"Ex--21943492438155078303,39",
   CellID->21963]},
 "Ex--21943492438155078303,41"->{
  Cell[11729, 376, 271, 7, 70, "Input",
   CellTags->"Ex--21943492438155078303,41",
   CellID->1908],
  Cell[12003, 385, 225, 6, 70, "Output",
   CellTags->"Ex--21943492438155078303,41",
   CellID->26737]},
 "Ex--21943492438155078303,42"->{
  Cell[12243, 394, 190, 6, 70, "Input",
   CellTags->"Ex--21943492438155078303,42",
   CellID->24474]},
 "Ex--21943492438155078303,44"->{
  Cell[12934, 424, 334, 8, 70, "Input",
   CellTags->"Ex--21943492438155078303,44",
   CellID->3855],
  Cell[13271, 434, 224, 6, 70, "Output",
   CellTags->"Ex--21943492438155078303,44",
   CellID->6734]},
 "Ex--21943492438155078303,45"->{
  Cell[13510, 443, 189, 6, 70, "Input",
   CellTags->"Ex--21943492438155078303,45",
   CellID->9561]},
 "Ex--21943492438155078303,46"->{
  Cell[13851, 460, 344, 9, 70, "Input",
   CellTags->"Ex--21943492438155078303,46",
   CellID->27606],
  Cell[14198, 471, 224, 6, 70, "Output",
   CellTags->"Ex--21943492438155078303,46",
   CellID->8184]},
 "Ex--21943492438155078303,47"->{
  Cell[14437, 480, 189, 6, 70, "Input",
   CellTags->"Ex--21943492438155078303,47",
   CellID->7075]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19053, 634},
 {"Ex--21943492438155078303,34", 19207, 638},
 {"Ex--21943492438155078303,35", 19447, 645},
 {"Ex--21943492438155078303,36", 19584, 649},
 {"Ex--21943492438155078303,37", 19825, 656},
 {"Ex--21943492438155078303,38", 19961, 660},
 {"Ex--21943492438155078303,39", 20203, 667},
 {"Ex--21943492438155078303,41", 20341, 671},
 {"Ex--21943492438155078303,42", 20582, 678},
 {"Ex--21943492438155078303,44", 20720, 682},
 {"Ex--21943492438155078303,45", 20960, 689},
 {"Ex--21943492438155078303,46", 21097, 693},
 {"Ex--21943492438155078303,47", 21338, 700}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2638, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3261, 90, 55, 1, 70, "ObjectName",
 CellID->31339],
Cell[3319, 93, 612, 18, 70, "Usage",
 CellID->23154]
}, Open  ]],
Cell[CellGroupData[{
Cell[3968, 116, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4446, 133, 69, 1, 70, "Notes",
 CellID->24604],
Cell[4518, 136, 2430, 53, 70, "3ColumnTableMod",
 CellID->4623]
}, Closed]],
Cell[CellGroupData[{
Cell[6985, 194, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->340502098],
Cell[CellGroupData[{
Cell[7370, 208, 148, 5, 70, "ExampleSection",
 CellID->209630177],
Cell[7521, 215, 135, 3, 70, "Input",
 CellID->197498609],
Cell[7659, 220, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[CellGroupData[{
Cell[8082, 234, 188, 5, 70, "Input",
 CellTags->"Ex--21943492438155078303,34",
 CellID->20594],
Cell[8273, 241, 225, 6, 70, "Output",
 CellTags->"Ex--21943492438155078303,34",
 CellID->29130]
}, Open  ]],
Cell[8513, 250, 209, 7, 70, "Input",
 CellTags->"Ex--21943492438155078303,35",
 CellID->18846],
Cell[8725, 259, 94, 5, 70, "ExampleText",
 CellID->4987],
Cell[CellGroupData[{
Cell[8844, 268, 660, 17, 70, "Input",
 CellTags->"Ex--21943492438155078303,36",
 CellID->29445],
Cell[9507, 287, 229, 6, 70, "Output",
 CellTags->"Ex--21943492438155078303,36",
 CellID->18805]
}, Open  ]],
Cell[9751, 296, 208, 7, 70, "Input",
 CellTags->"Ex--21943492438155078303,37",
 CellID->8616],
Cell[9962, 305, 55, 1, 70, "ExampleText",
 CellID->5750],
Cell[CellGroupData[{
Cell[10042, 310, 172, 5, 70, "Input",
 CellTags->"Ex--21943492438155078303,38",
 CellID->20489],
Cell[10217, 317, 231, 6, 70, "Output",
 CellTags->"Ex--21943492438155078303,38",
 CellID->27338]
}, Open  ]],
Cell[10463, 326, 190, 6, 70, "Input",
 CellTags->"Ex--21943492438155078303,39",
 CellID->21963],
Cell[10656, 334, 402, 10, 70, "ExampleText",
 CellID->489567198]
}, Open  ]],
Cell[CellGroupData[{
Cell[11095, 349, 218, 7, 70, "ExampleSection",
 CellID->32209],
Cell[CellGroupData[{
Cell[11338, 360, 229, 7, 70, "ExampleSubsection",
 CellID->21630],
Cell[11570, 369, 134, 3, 70, "Input",
 CellID->98042017],
Cell[CellGroupData[{
Cell[11729, 376, 271, 7, 70, "Input",
 CellTags->"Ex--21943492438155078303,41",
 CellID->1908],
Cell[12003, 385, 225, 6, 70, "Output",
 CellTags->"Ex--21943492438155078303,41",
 CellID->26737]
}, Open  ]],
Cell[12243, 394, 190, 6, 70, "Input",
 CellTags->"Ex--21943492438155078303,42",
 CellID->24474]
}, Closed]],
Cell[CellGroupData[{
Cell[12470, 405, 229, 7, 70, "ExampleSubsection",
 CellID->31920],
Cell[12702, 414, 135, 3, 70, "Input",
 CellID->165769942],
Cell[12840, 419, 69, 1, 70, "ExampleText",
 CellID->10293],
Cell[CellGroupData[{
Cell[12934, 424, 334, 8, 70, "Input",
 CellTags->"Ex--21943492438155078303,44",
 CellID->3855],
Cell[13271, 434, 224, 6, 70, "Output",
 CellTags->"Ex--21943492438155078303,44",
 CellID->6734]
}, Open  ]],
Cell[13510, 443, 189, 6, 70, "Input",
 CellTags->"Ex--21943492438155078303,45",
 CellID->9561],
Cell[13702, 451, 124, 5, 70, "ExampleText",
 CellID->31056],
Cell[CellGroupData[{
Cell[13851, 460, 344, 9, 70, "Input",
 CellTags->"Ex--21943492438155078303,46",
 CellID->27606],
Cell[14198, 471, 224, 6, 70, "Output",
 CellTags->"Ex--21943492438155078303,46",
 CellID->8184]
}, Open  ]],
Cell[14437, 480, 189, 6, 70, "Input",
 CellTags->"Ex--21943492438155078303,47",
 CellID->7075]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14687, 493, 311, 9, 70, "SeeAlsoSection",
 CellID->22225],
Cell[15001, 504, 777, 26, 70, "SeeAlso",
 CellID->20078]
}, Open  ]],
Cell[CellGroupData[{
Cell[15815, 535, 314, 9, 70, "TutorialsSection",
 CellID->21724],
Cell[16132, 546, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[16422, 557, 439, 12, 70, "Tutorials",
 CellID->33758115],
Cell[16864, 571, 463, 12, 70, "Tutorials",
 CellID->133710995]
}, Open  ]],
Cell[CellGroupData[{
Cell[17364, 588, 319, 9, 70, "MoreAboutSection",
 CellID->618053859],
Cell[17686, 599, 193, 4, 70, "MoreAbout",
 CellID->150037521]
}, Open  ]],
Cell[17894, 606, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

